"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dynamicAnchor = void 0;
const codegen_1 = require("../../compile/codegen");
const names_1 = require("../../compile/names");
const def = {
    keyword: "$dynamicAnchor",
    schemaType: "string",
    code: (cxt) => dynamicAnchor(cxt, cxt.schema),
};
function dynamicAnchor(cxt, anchor) {
    const { gen, keyword, it } = cxt;
    it.dynamicAnchors[anchor] = true;
    const v = codegen_1._ `${names_1.default.dynamicAnchors}${codegen_1.getProperty(anchor)}`;
    if (it.errSchemaPath === "#") {
        gen.if(codegen_1._ `!${v}`, () => gen.assign(v, it.validateName));
    }
    else {
        // TODO add support for dynamicRef/recursiveRef not in schema root
        // const validate = it.self.getSchema()
        throw new Error(`"${keyword}" is only supported in schema root`);
    }
}
exports.dynamicAnchor = dynamicAnchor;
exports.default = def;
//# sourceMappingURL=dynamicAnchor.js.map