"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dynamicRef = void 0;
const codegen_1 = require("../../compile/codegen");
const names_1 = require("../../compile/names");
const ref_1 = require("../core/ref");
const def = {
    keyword: "$dynamicRef",
    schemaType: "string",
    code: (cxt) => dynamicRef(cxt, cxt.schema),
};
function dynamicRef(cxt, ref) {
    const { gen, keyword, it } = cxt;
    if (ref[0] !== "#")
        throw new Error(`"${keyword}" only supports hash fragment reference`);
    const anchor = ref.slice(1);
    const v = gen.let("_v", codegen_1._ `${names_1.default.dynamicAnchors}${codegen_1.getProperty(anchor)}`);
    if (it.allErrors) {
        gen.if(v, _callRef(v), _callRef(it.validateName));
    }
    else {
        const valid = gen.let("valid", false);
        gen.if(v, _callRef(v, valid), _callRef(it.validateName, valid));
        cxt.ok(valid);
    }
    function _callRef(validate, valid) {
        return valid
            ? () => gen.block(() => {
                ref_1.callRef(cxt, validate);
                gen.let(valid, true);
            })
            : () => ref_1.callRef(cxt, validate);
    }
}
exports.dynamicRef = dynamicRef;
exports.default = def;
//# sourceMappingURL=dynamicRef.js.map