import { ChangeDetectorRef } from './change_detector_ref';
import { DirectiveIndex } from './directive_record';
import { ChangeDetector, ChangeDispatcher } from './interfaces';
import { Pipes } from './pipes';
import { BindingTarget } from './binding_record';
import { Locals } from './parser/locals';
import { ChangeDetectionStrategy } from './constants';
export declare class AbstractChangeDetector<T> implements ChangeDetector {
    id: string;
    dispatcher: ChangeDispatcher;
    numberOfPropertyProtoRecords: number;
    bindingTargets: BindingTarget[];
    directiveIndices: DirectiveIndex[];
    strategy: ChangeDetectionStrategy;
    lightDomChildren: any[];
    shadowDomChildren: any[];
    parent: ChangeDetector;
    ref: ChangeDetectorRef;
    alreadyChecked: any;
    context: T;
    locals: Locals;
    mode: ChangeDetectionStrategy;
    pipes: Pipes;
    propertyBindingIndex: number;
    subscriptions: any[];
    streams: any[];
    constructor(id: string, dispatcher: ChangeDispatcher, numberOfPropertyProtoRecords: number, bindingTargets: BindingTarget[], directiveIndices: DirectiveIndex[], strategy: ChangeDetectionStrategy);
    addChild(cd: ChangeDetector): void;
    removeChild(cd: ChangeDetector): void;
    addShadowDomChild(cd: ChangeDetector): void;
    removeShadowDomChild(cd: ChangeDetector): void;
    remove(): void;
    handleEvent(eventName: string, elIndex: number, locals: Locals): boolean;
    handleEventInternal(eventName: string, elIndex: number, locals: Locals): boolean;
    detectChanges(): void;
    checkNoChanges(): void;
    runDetectChanges(throwOnChange: boolean): void;
    detectChangesInRecords(throwOnChange: boolean): void;
    detectChangesInRecordsInternal(throwOnChange: boolean): void;
    hydrate(context: T, locals: Locals, directives: any, pipes: any): void;
    hydrateDirectives(directives: any): void;
    dehydrate(): void;
    dehydrateDirectives(destroyPipes: boolean): void;
    hydrated(): boolean;
    afterContentLifecycleCallbacks(): void;
    afterContentLifecycleCallbacksInternal(): void;
    afterViewLifecycleCallbacks(): void;
    afterViewLifecycleCallbacksInternal(): void;
    markAsCheckOnce(): void;
    markPathToRootAsCheckOnce(): void;
    private _unsubsribeFromObservables();
    observeValue(value: any, index: number): any;
    observeDirective(value: any, index: number): any;
    observeComponent(value: any): any;
    private _createArrayToStoreObservables();
    getDirectiveFor(directives: any, index: number): any;
    getDetectorFor(directives: any, index: number): ChangeDetector;
    notifyDispatcher(value: any): void;
    logBindingUpdate(value: any): void;
    addChange(changes: {
        [key: string]: any;
    }, oldValue: any, newValue: any): {
        [key: string]: any;
    };
    private _throwError(exception, stack);
    throwOnChangeError(oldValue: any, newValue: any): void;
    throwDehydratedError(): void;
    private _currentBinding();
}
