library angular2.src.change_detection.pregen_proto_change_detector;

import 'package:angular2/src/core/change_detection/interfaces.dart';
import 'package:angular2/src/facade/lang.dart' show looseIdentical;

export 'dart:core' show List;
export 'package:angular2/src/core/change_detection/abstract_change_detector.dart'
    show AbstractChangeDetector;
export 'package:angular2/src/core/change_detection/change_detection.dart'
    show ChangeDetectionStrategy;
export 'package:angular2/src/core/change_detection/constants.dart'
    show ChangeDetectorState;
export 'package:angular2/src/core/change_detection/directive_record.dart'
    show DirectiveIndex, DirectiveRecord;
export 'package:angular2/src/core/change_detection/interfaces.dart'
    show ChangeDetector, ChangeDetectorDefinition, ProtoChangeDetector;
export 'package:angular2/src/core/change_detection/pipes.dart' show Pipes;
export 'package:angular2/src/core/change_detection/proto_record.dart'
    show ProtoRecord;
export 'package:angular2/src/core/change_detection/change_detection_util.dart'
    show ChangeDetectionUtil;
export 'package:angular2/src/facade/lang.dart' show assertionsEnabled, looseIdentical;

typedef ProtoChangeDetector PregenProtoChangeDetectorFactory(
    ChangeDetectorDefinition definition);

typedef ChangeDetector InstantiateMethod(dynamic dispatcher);

/// Implementation of [ProtoChangeDetector] for use by pre-generated change
/// detectors in Angular 2 Dart.
/// Classes generated by the `TemplateCompiler` use this. The `export`s above
/// allow the generated code to `import` a single library and get all
/// dependencies.
class PregenProtoChangeDetector extends ProtoChangeDetector {
  /// The [ChangeDetectorDefinition#id]. Strictly informational.
  final String id;

  /// Closure used to generate an actual [ChangeDetector].
  final InstantiateMethod _instantiateMethod;

  /// Internal ctor.
  PregenProtoChangeDetector._(this.id, this._instantiateMethod);

  static bool isSupported() => true;

  factory PregenProtoChangeDetector(
      InstantiateMethod instantiateMethod, ChangeDetectorDefinition def) {
    return new PregenProtoChangeDetector._(def.id, instantiateMethod);
  }

  @override
  instantiate(dynamic dispatcher) => _instantiateMethod(dispatcher);
}
