var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { isPresent, isBlank, isString, StringWrapper, IS_DART } from 'angular2/src/facade/lang';
import { SetWrapper, StringMapWrapper, ListWrapper } from 'angular2/src/facade/collection';
import { TextCmd, NgContentCmd, BeginElementCmd, EndElementCmd, BeginComponentCmd, EndComponentCmd, EmbeddedTemplateCmd } from 'angular2/src/core/linker/template_commands';
import { templateVisitAll } from './template_ast';
import { SourceExpression, moduleRef } from './source_module';
import { escapeSingleQuoteString, codeGenConstConstructorCall, MODULE_SUFFIX } from './util';
import { Injectable } from 'angular2/src/core/di';
export var TEMPLATE_COMMANDS_MODULE_REF = moduleRef(`package:angular2/src/core/linker/template_commands${MODULE_SUFFIX}`);
const IMPLICIT_TEMPLATE_VAR = '\$implicit';
const CLASS_ATTR = 'class';
const STYLE_ATTR = 'style';
export let CommandCompiler = class {
    compileComponentRuntime(component, template, changeDetectorFactories, componentTemplateFactory) {
        var visitor = new CommandBuilderVisitor(new RuntimeCommandFactory(component, componentTemplateFactory, changeDetectorFactories), 0);
        templateVisitAll(visitor, template);
        return visitor.result;
    }
    compileComponentCodeGen(component, template, changeDetectorFactoryExpressions, componentTemplateFactory) {
        var visitor = new CommandBuilderVisitor(new CodegenCommandFactory(component, componentTemplateFactory, changeDetectorFactoryExpressions), 0);
        templateVisitAll(visitor, template);
        return new SourceExpression([], codeGenArray(visitor.result));
    }
};
CommandCompiler = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [])
], CommandCompiler);
class RuntimeCommandFactory {
    constructor(component, componentTemplateFactory, changeDetectorFactories) {
        this.component = component;
        this.componentTemplateFactory = componentTemplateFactory;
        this.changeDetectorFactories = changeDetectorFactories;
    }
    _mapDirectives(directives) {
        return directives.map(directive => directive.type.runtime);
    }
    createText(value, isBound, ngContentIndex) {
        return new TextCmd(value, isBound, ngContentIndex);
    }
    createNgContent(index, ngContentIndex) {
        return new NgContentCmd(index, ngContentIndex);
    }
    createBeginElement(name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, isBound, ngContentIndex) {
        return new BeginElementCmd(name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, this._mapDirectives(directives), isBound, ngContentIndex);
    }
    createEndElement() { return new EndElementCmd(); }
    createBeginComponent(name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, encapsulation, ngContentIndex) {
        var nestedTemplateAccessor = this.componentTemplateFactory(directives[0]);
        return new BeginComponentCmd(name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, this._mapDirectives(directives), encapsulation, ngContentIndex, nestedTemplateAccessor);
    }
    createEndComponent() { return new EndComponentCmd(); }
    createEmbeddedTemplate(embeddedTemplateIndex, attrNameAndValues, variableNameAndValues, directives, isMerged, ngContentIndex, children) {
        return new EmbeddedTemplateCmd(attrNameAndValues, variableNameAndValues, this._mapDirectives(directives), isMerged, ngContentIndex, this.changeDetectorFactories[embeddedTemplateIndex], children);
    }
}
class CodegenCommandFactory {
    constructor(component, componentTemplateFactory, changeDetectorFactoryExpressions) {
        this.component = component;
        this.componentTemplateFactory = componentTemplateFactory;
        this.changeDetectorFactoryExpressions = changeDetectorFactoryExpressions;
    }
    createText(value, isBound, ngContentIndex) {
        return new Expression(`${codeGenConstConstructorCall(TEMPLATE_COMMANDS_MODULE_REF + 'TextCmd')}(${escapeSingleQuoteString(value)}, ${isBound}, ${ngContentIndex})`);
    }
    createNgContent(index, ngContentIndex) {
        return new Expression(`${codeGenConstConstructorCall(TEMPLATE_COMMANDS_MODULE_REF + 'NgContentCmd')}(${index}, ${ngContentIndex})`);
    }
    createBeginElement(name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, isBound, ngContentIndex) {
        var attrsExpression = codeGenArray(attrNameAndValues);
        return new Expression(`${codeGenConstConstructorCall(TEMPLATE_COMMANDS_MODULE_REF + 'BeginElementCmd')}(${escapeSingleQuoteString(name)}, ${attrsExpression}, ` +
            `${codeGenArray(eventTargetAndNames)}, ${codeGenArray(variableNameAndValues)}, ${codeGenDirectivesArray(directives)}, ${isBound}, ${ngContentIndex})`);
    }
    createEndElement() {
        return new Expression(`${codeGenConstConstructorCall(TEMPLATE_COMMANDS_MODULE_REF + 'EndElementCmd')}()`);
    }
    createBeginComponent(name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, encapsulation, ngContentIndex) {
        var attrsExpression = codeGenArray(attrNameAndValues);
        return new Expression(`${codeGenConstConstructorCall(TEMPLATE_COMMANDS_MODULE_REF + 'BeginComponentCmd')}(${escapeSingleQuoteString(name)}, ${attrsExpression}, ` +
            `${codeGenArray(eventTargetAndNames)}, ${codeGenArray(variableNameAndValues)}, ${codeGenDirectivesArray(directives)}, ${codeGenViewEncapsulation(encapsulation)}, ${ngContentIndex}, ${this.componentTemplateFactory(directives[0])})`);
    }
    createEndComponent() {
        return new Expression(`${codeGenConstConstructorCall(TEMPLATE_COMMANDS_MODULE_REF + 'EndComponentCmd')}()`);
    }
    createEmbeddedTemplate(embeddedTemplateIndex, attrNameAndValues, variableNameAndValues, directives, isMerged, ngContentIndex, children) {
        return new Expression(`${codeGenConstConstructorCall(TEMPLATE_COMMANDS_MODULE_REF + 'EmbeddedTemplateCmd')}(${codeGenArray(attrNameAndValues)}, ${codeGenArray(variableNameAndValues)}, ` +
            `${codeGenDirectivesArray(directives)}, ${isMerged}, ${ngContentIndex}, ${this.changeDetectorFactoryExpressions[embeddedTemplateIndex]}, ${codeGenArray(children)})`);
    }
}
function visitAndReturnContext(visitor, asts, context) {
    templateVisitAll(visitor, asts, context);
    return context;
}
class CommandBuilderVisitor {
    constructor(commandFactory, embeddedTemplateIndex) {
        this.commandFactory = commandFactory;
        this.embeddedTemplateIndex = embeddedTemplateIndex;
        this.result = [];
        this.transitiveNgContentCount = 0;
    }
    _readAttrNameAndValues(directives, attrAsts) {
        var attrs = keyValueArrayToMap(visitAndReturnContext(this, attrAsts, []));
        directives.forEach(directiveMeta => {
            StringMapWrapper.forEach(directiveMeta.hostAttributes, (value, name) => {
                var prevValue = attrs[name];
                attrs[name] = isPresent(prevValue) ? mergeAttributeValue(name, prevValue, value) : value;
            });
        });
        return mapToKeyValueArray(attrs);
    }
    visitNgContent(ast, context) {
        this.transitiveNgContentCount++;
        this.result.push(this.commandFactory.createNgContent(ast.index, ast.ngContentIndex));
        return null;
    }
    visitEmbeddedTemplate(ast, context) {
        this.embeddedTemplateIndex++;
        var childVisitor = new CommandBuilderVisitor(this.commandFactory, this.embeddedTemplateIndex);
        templateVisitAll(childVisitor, ast.children);
        var isMerged = childVisitor.transitiveNgContentCount > 0;
        var variableNameAndValues = [];
        ast.vars.forEach((varAst) => {
            variableNameAndValues.push(varAst.name);
            variableNameAndValues.push(varAst.value.length > 0 ? varAst.value : IMPLICIT_TEMPLATE_VAR);
        });
        var directives = [];
        ListWrapper.forEachWithIndex(ast.directives, (directiveAst, index) => {
            directiveAst.visit(this, new DirectiveContext(index, [], [], directives));
        });
        this.result.push(this.commandFactory.createEmbeddedTemplate(this.embeddedTemplateIndex, this._readAttrNameAndValues(directives, ast.attrs), variableNameAndValues, directives, isMerged, ast.ngContentIndex, childVisitor.result));
        this.transitiveNgContentCount += childVisitor.transitiveNgContentCount;
        this.embeddedTemplateIndex = childVisitor.embeddedTemplateIndex;
        return null;
    }
    visitElement(ast, context) {
        var component = ast.getComponent();
        var eventTargetAndNames = visitAndReturnContext(this, ast.outputs, []);
        var variableNameAndValues = [];
        if (isBlank(component)) {
            ast.exportAsVars.forEach((varAst) => {
                variableNameAndValues.push(varAst.name);
                variableNameAndValues.push(null);
            });
        }
        var directives = [];
        ListWrapper.forEachWithIndex(ast.directives, (directiveAst, index) => {
            directiveAst.visit(this, new DirectiveContext(index, eventTargetAndNames, variableNameAndValues, directives));
        });
        eventTargetAndNames = removeKeyValueArrayDuplicates(eventTargetAndNames);
        var attrNameAndValues = this._readAttrNameAndValues(directives, ast.attrs);
        if (isPresent(component)) {
            this.result.push(this.commandFactory.createBeginComponent(ast.name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, component.template.encapsulation, ast.ngContentIndex));
            templateVisitAll(this, ast.children);
            this.result.push(this.commandFactory.createEndComponent());
        }
        else {
            this.result.push(this.commandFactory.createBeginElement(ast.name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, ast.isBound(), ast.ngContentIndex));
            templateVisitAll(this, ast.children);
            this.result.push(this.commandFactory.createEndElement());
        }
        return null;
    }
    visitVariable(ast, ctx) { return null; }
    visitAttr(ast, attrNameAndValues) {
        attrNameAndValues.push(ast.name);
        attrNameAndValues.push(ast.value);
        return null;
    }
    visitBoundText(ast, context) {
        this.result.push(this.commandFactory.createText(null, true, ast.ngContentIndex));
        return null;
    }
    visitText(ast, context) {
        this.result.push(this.commandFactory.createText(ast.value, false, ast.ngContentIndex));
        return null;
    }
    visitDirective(ast, ctx) {
        ctx.targetDirectives.push(ast.directive);
        templateVisitAll(this, ast.hostEvents, ctx.eventTargetAndNames);
        ast.exportAsVars.forEach(varAst => {
            ctx.targetVariableNameAndValues.push(varAst.name);
            ctx.targetVariableNameAndValues.push(ctx.index);
        });
        return null;
    }
    visitEvent(ast, eventTargetAndNames) {
        eventTargetAndNames.push(ast.target);
        eventTargetAndNames.push(ast.name);
        return null;
    }
    visitDirectiveProperty(ast, context) { return null; }
    visitElementProperty(ast, context) { return null; }
}
function removeKeyValueArrayDuplicates(keyValueArray) {
    var knownPairs = new Set();
    var resultKeyValueArray = [];
    for (var i = 0; i < keyValueArray.length; i += 2) {
        var key = keyValueArray[i];
        var value = keyValueArray[i + 1];
        var pairId = `${key}:${value}`;
        if (!SetWrapper.has(knownPairs, pairId)) {
            resultKeyValueArray.push(key);
            resultKeyValueArray.push(value);
            knownPairs.add(pairId);
        }
    }
    return resultKeyValueArray;
}
function keyValueArrayToMap(keyValueArr) {
    var data = {};
    for (var i = 0; i < keyValueArr.length; i += 2) {
        data[keyValueArr[i]] = keyValueArr[i + 1];
    }
    return data;
}
function mapToKeyValueArray(data) {
    var entryArray = [];
    StringMapWrapper.forEach(data, (value, name) => { entryArray.push([name, value]); });
    // We need to sort to get a defined output order
    // for tests and for caching generated artifacts...
    ListWrapper.sort(entryArray, (entry1, entry2) => StringWrapper.compare(entry1[0], entry2[0]));
    var keyValueArray = [];
    entryArray.forEach((entry) => {
        keyValueArray.push(entry[0]);
        keyValueArray.push(entry[1]);
    });
    return keyValueArray;
}
function mergeAttributeValue(attrName, attrValue1, attrValue2) {
    if (attrName == CLASS_ATTR || attrName == STYLE_ATTR) {
        return `${attrValue1} ${attrValue2}`;
    }
    else {
        return attrValue2;
    }
}
class DirectiveContext {
    constructor(index, eventTargetAndNames, targetVariableNameAndValues, targetDirectives) {
        this.index = index;
        this.eventTargetAndNames = eventTargetAndNames;
        this.targetVariableNameAndValues = targetVariableNameAndValues;
        this.targetDirectives = targetDirectives;
    }
}
class Expression {
    constructor(value) {
        this.value = value;
    }
}
function escapeValue(value) {
    if (value instanceof Expression) {
        return value.value;
    }
    else if (isString(value)) {
        return escapeSingleQuoteString(value);
    }
    else if (isBlank(value)) {
        return 'null';
    }
    else {
        return `${value}`;
    }
}
function codeGenArray(data) {
    var base = `[${data.map(escapeValue).join(',')}]`;
    return IS_DART ? `const ${base}` : base;
}
function codeGenDirectivesArray(directives) {
    var expressions = directives.map(directiveType => `${moduleRef(directiveType.type.moduleUrl)}${directiveType.type.name}`);
    var base = `[${expressions.join(',')}]`;
    return IS_DART ? `const ${base}` : base;
}
function codeGenViewEncapsulation(value) {
    if (IS_DART) {
        return `${TEMPLATE_COMMANDS_MODULE_REF}${value}`;
    }
    else {
        return `${value}`;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tbWFuZF9jb21waWxlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFuZ3VsYXIyL3NyYy9jb21waWxlci9jb21tYW5kX2NvbXBpbGVyLnRzIl0sIm5hbWVzIjpbIkNvbW1hbmRDb21waWxlciIsIkNvbW1hbmRDb21waWxlci5jb21waWxlQ29tcG9uZW50UnVudGltZSIsIkNvbW1hbmRDb21waWxlci5jb21waWxlQ29tcG9uZW50Q29kZUdlbiIsIlJ1bnRpbWVDb21tYW5kRmFjdG9yeSIsIlJ1bnRpbWVDb21tYW5kRmFjdG9yeS5jb25zdHJ1Y3RvciIsIlJ1bnRpbWVDb21tYW5kRmFjdG9yeS5fbWFwRGlyZWN0aXZlcyIsIlJ1bnRpbWVDb21tYW5kRmFjdG9yeS5jcmVhdGVUZXh0IiwiUnVudGltZUNvbW1hbmRGYWN0b3J5LmNyZWF0ZU5nQ29udGVudCIsIlJ1bnRpbWVDb21tYW5kRmFjdG9yeS5jcmVhdGVCZWdpbkVsZW1lbnQiLCJSdW50aW1lQ29tbWFuZEZhY3RvcnkuY3JlYXRlRW5kRWxlbWVudCIsIlJ1bnRpbWVDb21tYW5kRmFjdG9yeS5jcmVhdGVCZWdpbkNvbXBvbmVudCIsIlJ1bnRpbWVDb21tYW5kRmFjdG9yeS5jcmVhdGVFbmRDb21wb25lbnQiLCJSdW50aW1lQ29tbWFuZEZhY3RvcnkuY3JlYXRlRW1iZWRkZWRUZW1wbGF0ZSIsIkNvZGVnZW5Db21tYW5kRmFjdG9yeSIsIkNvZGVnZW5Db21tYW5kRmFjdG9yeS5jb25zdHJ1Y3RvciIsIkNvZGVnZW5Db21tYW5kRmFjdG9yeS5jcmVhdGVUZXh0IiwiQ29kZWdlbkNvbW1hbmRGYWN0b3J5LmNyZWF0ZU5nQ29udGVudCIsIkNvZGVnZW5Db21tYW5kRmFjdG9yeS5jcmVhdGVCZWdpbkVsZW1lbnQiLCJDb2RlZ2VuQ29tbWFuZEZhY3RvcnkuY3JlYXRlRW5kRWxlbWVudCIsIkNvZGVnZW5Db21tYW5kRmFjdG9yeS5jcmVhdGVCZWdpbkNvbXBvbmVudCIsIkNvZGVnZW5Db21tYW5kRmFjdG9yeS5jcmVhdGVFbmRDb21wb25lbnQiLCJDb2RlZ2VuQ29tbWFuZEZhY3RvcnkuY3JlYXRlRW1iZWRkZWRUZW1wbGF0ZSIsInZpc2l0QW5kUmV0dXJuQ29udGV4dCIsIkNvbW1hbmRCdWlsZGVyVmlzaXRvciIsIkNvbW1hbmRCdWlsZGVyVmlzaXRvci5jb25zdHJ1Y3RvciIsIkNvbW1hbmRCdWlsZGVyVmlzaXRvci5fcmVhZEF0dHJOYW1lQW5kVmFsdWVzIiwiQ29tbWFuZEJ1aWxkZXJWaXNpdG9yLnZpc2l0TmdDb250ZW50IiwiQ29tbWFuZEJ1aWxkZXJWaXNpdG9yLnZpc2l0RW1iZWRkZWRUZW1wbGF0ZSIsIkNvbW1hbmRCdWlsZGVyVmlzaXRvci52aXNpdEVsZW1lbnQiLCJDb21tYW5kQnVpbGRlclZpc2l0b3IudmlzaXRWYXJpYWJsZSIsIkNvbW1hbmRCdWlsZGVyVmlzaXRvci52aXNpdEF0dHIiLCJDb21tYW5kQnVpbGRlclZpc2l0b3IudmlzaXRCb3VuZFRleHQiLCJDb21tYW5kQnVpbGRlclZpc2l0b3IudmlzaXRUZXh0IiwiQ29tbWFuZEJ1aWxkZXJWaXNpdG9yLnZpc2l0RGlyZWN0aXZlIiwiQ29tbWFuZEJ1aWxkZXJWaXNpdG9yLnZpc2l0RXZlbnQiLCJDb21tYW5kQnVpbGRlclZpc2l0b3IudmlzaXREaXJlY3RpdmVQcm9wZXJ0eSIsIkNvbW1hbmRCdWlsZGVyVmlzaXRvci52aXNpdEVsZW1lbnRQcm9wZXJ0eSIsInJlbW92ZUtleVZhbHVlQXJyYXlEdXBsaWNhdGVzIiwia2V5VmFsdWVBcnJheVRvTWFwIiwibWFwVG9LZXlWYWx1ZUFycmF5IiwibWVyZ2VBdHRyaWJ1dGVWYWx1ZSIsIkRpcmVjdGl2ZUNvbnRleHQiLCJEaXJlY3RpdmVDb250ZXh0LmNvbnN0cnVjdG9yIiwiRXhwcmVzc2lvbiIsIkV4cHJlc3Npb24uY29uc3RydWN0b3IiLCJlc2NhcGVWYWx1ZSIsImNvZGVHZW5BcnJheSIsImNvZGVHZW5EaXJlY3RpdmVzQXJyYXkiLCJjb2RlR2VuVmlld0VuY2Fwc3VsYXRpb24iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7O09BQU8sRUFBQyxTQUFTLEVBQUUsT0FBTyxFQUFRLFFBQVEsRUFBRSxhQUFhLEVBQUUsT0FBTyxFQUFDLE1BQU0sMEJBQTBCO09BQzVGLEVBQUMsVUFBVSxFQUFFLGdCQUFnQixFQUFFLFdBQVcsRUFBQyxNQUFNLGdDQUFnQztPQUNqRixFQUVMLE9BQU8sRUFDUCxZQUFZLEVBQ1osZUFBZSxFQUNmLGFBQWEsRUFDYixpQkFBaUIsRUFDakIsZUFBZSxFQUNmLG1CQUFtQixFQUVwQixNQUFNLDRDQUE0QztPQUM1QyxFQWNMLGdCQUFnQixFQUNqQixNQUFNLGdCQUFnQjtPQUVoQixFQUFvQixnQkFBZ0IsRUFBRSxTQUFTLEVBQUMsTUFBTSxpQkFBaUI7T0FHdkUsRUFDTCx1QkFBdUIsRUFDdkIsMkJBQTJCLEVBRTNCLGFBQWEsRUFDZCxNQUFNLFFBQVE7T0FDUixFQUFDLFVBQVUsRUFBQyxNQUFNLHNCQUFzQjtBQUUvQyxXQUFXLDRCQUE0QixHQUNuQyxTQUFTLENBQUMscURBQXFELGFBQWEsRUFBRSxDQUFDLENBQUM7QUFFcEYsTUFBTSxxQkFBcUIsR0FBRyxZQUFZLENBQUM7QUFDM0MsTUFBTSxVQUFVLEdBQUcsT0FBTyxDQUFDO0FBQzNCLE1BQU0sVUFBVSxHQUFHLE9BQU8sQ0FBQztBQUUzQjtJQUVFQSx1QkFBdUJBLENBQUNBLFNBQW1DQSxFQUFFQSxRQUF1QkEsRUFDNURBLHVCQUFtQ0EsRUFDbkNBLHdCQUFrQ0E7UUFDeERDLElBQUlBLE9BQU9BLEdBQUdBLElBQUlBLHFCQUFxQkEsQ0FDbkNBLElBQUlBLHFCQUFxQkEsQ0FBQ0EsU0FBU0EsRUFBRUEsd0JBQXdCQSxFQUFFQSx1QkFBdUJBLENBQUNBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBO1FBQ2hHQSxnQkFBZ0JBLENBQUNBLE9BQU9BLEVBQUVBLFFBQVFBLENBQUNBLENBQUNBO1FBQ3BDQSxNQUFNQSxDQUFDQSxPQUFPQSxDQUFDQSxNQUFNQSxDQUFDQTtJQUN4QkEsQ0FBQ0E7SUFFREQsdUJBQXVCQSxDQUFDQSxTQUFtQ0EsRUFBRUEsUUFBdUJBLEVBQzVEQSxnQ0FBMENBLEVBQzFDQSx3QkFBa0NBO1FBQ3hERSxJQUFJQSxPQUFPQSxHQUNQQSxJQUFJQSxxQkFBcUJBLENBQUNBLElBQUlBLHFCQUFxQkEsQ0FBQ0EsU0FBU0EsRUFBRUEsd0JBQXdCQSxFQUNuQ0EsZ0NBQWdDQSxDQUFDQSxFQUMzREEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDakNBLGdCQUFnQkEsQ0FBQ0EsT0FBT0EsRUFBRUEsUUFBUUEsQ0FBQ0EsQ0FBQ0E7UUFDcENBLE1BQU1BLENBQUNBLElBQUlBLGdCQUFnQkEsQ0FBQ0EsRUFBRUEsRUFBRUEsWUFBWUEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsTUFBTUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7SUFDaEVBLENBQUNBO0FBQ0hGLENBQUNBO0FBckJEO0lBQUMsVUFBVSxFQUFFOztvQkFxQlo7QUFrQkQ7SUFDRUcsWUFBb0JBLFNBQW1DQSxFQUNuQ0Esd0JBQWtDQSxFQUNsQ0EsdUJBQW1DQTtRQUZuQ0MsY0FBU0EsR0FBVEEsU0FBU0EsQ0FBMEJBO1FBQ25DQSw2QkFBd0JBLEdBQXhCQSx3QkFBd0JBLENBQVVBO1FBQ2xDQSw0QkFBdUJBLEdBQXZCQSx1QkFBdUJBLENBQVlBO0lBQUdBLENBQUNBO0lBQ25ERCxjQUFjQSxDQUFDQSxVQUFzQ0E7UUFDM0RFLE1BQU1BLENBQUNBLFVBQVVBLENBQUNBLEdBQUdBLENBQUNBLFNBQVNBLElBQUlBLFNBQVNBLENBQUNBLElBQUlBLENBQUNBLE9BQU9BLENBQUNBLENBQUNBO0lBQzdEQSxDQUFDQTtJQUVERixVQUFVQSxDQUFDQSxLQUFhQSxFQUFFQSxPQUFnQkEsRUFBRUEsY0FBc0JBO1FBQ2hFRyxNQUFNQSxDQUFDQSxJQUFJQSxPQUFPQSxDQUFDQSxLQUFLQSxFQUFFQSxPQUFPQSxFQUFFQSxjQUFjQSxDQUFDQSxDQUFDQTtJQUNyREEsQ0FBQ0E7SUFDREgsZUFBZUEsQ0FBQ0EsS0FBYUEsRUFBRUEsY0FBc0JBO1FBQ25ESSxNQUFNQSxDQUFDQSxJQUFJQSxZQUFZQSxDQUFDQSxLQUFLQSxFQUFFQSxjQUFjQSxDQUFDQSxDQUFDQTtJQUNqREEsQ0FBQ0E7SUFDREosa0JBQWtCQSxDQUFDQSxJQUFZQSxFQUFFQSxpQkFBMkJBLEVBQUVBLG1CQUE2QkEsRUFDeEVBLHFCQUErQkEsRUFBRUEsVUFBc0NBLEVBQ3ZFQSxPQUFnQkEsRUFBRUEsY0FBc0JBO1FBQ3pESyxNQUFNQSxDQUFDQSxJQUFJQSxlQUFlQSxDQUFDQSxJQUFJQSxFQUFFQSxpQkFBaUJBLEVBQUVBLG1CQUFtQkEsRUFBRUEscUJBQXFCQSxFQUNuRUEsSUFBSUEsQ0FBQ0EsY0FBY0EsQ0FBQ0EsVUFBVUEsQ0FBQ0EsRUFBRUEsT0FBT0EsRUFBRUEsY0FBY0EsQ0FBQ0EsQ0FBQ0E7SUFDdkZBLENBQUNBO0lBQ0RMLGdCQUFnQkEsS0FBa0JNLE1BQU1BLENBQUNBLElBQUlBLGFBQWFBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBO0lBQy9ETixvQkFBb0JBLENBQUNBLElBQVlBLEVBQUVBLGlCQUEyQkEsRUFBRUEsbUJBQTZCQSxFQUN4RUEscUJBQStCQSxFQUFFQSxVQUFzQ0EsRUFDdkVBLGFBQWdDQSxFQUFFQSxjQUFzQkE7UUFDM0VPLElBQUlBLHNCQUFzQkEsR0FBR0EsSUFBSUEsQ0FBQ0Esd0JBQXdCQSxDQUFDQSxVQUFVQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUMxRUEsTUFBTUEsQ0FBQ0EsSUFBSUEsaUJBQWlCQSxDQUFDQSxJQUFJQSxFQUFFQSxpQkFBaUJBLEVBQUVBLG1CQUFtQkEsRUFDNUNBLHFCQUFxQkEsRUFBRUEsSUFBSUEsQ0FBQ0EsY0FBY0EsQ0FBQ0EsVUFBVUEsQ0FBQ0EsRUFDdERBLGFBQWFBLEVBQUVBLGNBQWNBLEVBQUVBLHNCQUFzQkEsQ0FBQ0EsQ0FBQ0E7SUFDdEZBLENBQUNBO0lBQ0RQLGtCQUFrQkEsS0FBa0JRLE1BQU1BLENBQUNBLElBQUlBLGVBQWVBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBO0lBQ25FUixzQkFBc0JBLENBQUNBLHFCQUE2QkEsRUFBRUEsaUJBQTJCQSxFQUMxREEscUJBQStCQSxFQUFFQSxVQUFzQ0EsRUFDdkVBLFFBQWlCQSxFQUFFQSxjQUFzQkEsRUFDekNBLFFBQXVCQTtRQUM1Q1MsTUFBTUEsQ0FBQ0EsSUFBSUEsbUJBQW1CQSxDQUFDQSxpQkFBaUJBLEVBQUVBLHFCQUFxQkEsRUFDeENBLElBQUlBLENBQUNBLGNBQWNBLENBQUNBLFVBQVVBLENBQUNBLEVBQUVBLFFBQVFBLEVBQUVBLGNBQWNBLEVBQ3pEQSxJQUFJQSxDQUFDQSx1QkFBdUJBLENBQUNBLHFCQUFxQkEsQ0FBQ0EsRUFBRUEsUUFBUUEsQ0FBQ0EsQ0FBQ0E7SUFDaEdBLENBQUNBO0FBQ0hULENBQUNBO0FBRUQ7SUFDRVUsWUFBb0JBLFNBQW1DQSxFQUNuQ0Esd0JBQWtDQSxFQUNsQ0EsZ0NBQTBDQTtRQUYxQ0MsY0FBU0EsR0FBVEEsU0FBU0EsQ0FBMEJBO1FBQ25DQSw2QkFBd0JBLEdBQXhCQSx3QkFBd0JBLENBQVVBO1FBQ2xDQSxxQ0FBZ0NBLEdBQWhDQSxnQ0FBZ0NBLENBQVVBO0lBQUdBLENBQUNBO0lBRWxFRCxVQUFVQSxDQUFDQSxLQUFhQSxFQUFFQSxPQUFnQkEsRUFBRUEsY0FBc0JBO1FBQ2hFRSxNQUFNQSxDQUFDQSxJQUFJQSxVQUFVQSxDQUNqQkEsR0FBR0EsMkJBQTJCQSxDQUFDQSw0QkFBNEJBLEdBQUNBLFNBQVNBLENBQUNBLElBQUlBLHVCQUF1QkEsQ0FBQ0EsS0FBS0EsQ0FBQ0EsS0FBS0EsT0FBT0EsS0FBS0EsY0FBY0EsR0FBR0EsQ0FBQ0EsQ0FBQ0E7SUFDbEpBLENBQUNBO0lBQ0RGLGVBQWVBLENBQUNBLEtBQWFBLEVBQUVBLGNBQXNCQTtRQUNuREcsTUFBTUEsQ0FBQ0EsSUFBSUEsVUFBVUEsQ0FDakJBLEdBQUdBLDJCQUEyQkEsQ0FBQ0EsNEJBQTRCQSxHQUFDQSxjQUFjQSxDQUFDQSxJQUFJQSxLQUFLQSxLQUFLQSxjQUFjQSxHQUFHQSxDQUFDQSxDQUFDQTtJQUNsSEEsQ0FBQ0E7SUFDREgsa0JBQWtCQSxDQUFDQSxJQUFZQSxFQUFFQSxpQkFBMkJBLEVBQUVBLG1CQUE2QkEsRUFDeEVBLHFCQUErQkEsRUFBRUEsVUFBc0NBLEVBQ3ZFQSxPQUFnQkEsRUFBRUEsY0FBc0JBO1FBQ3pESSxJQUFJQSxlQUFlQSxHQUFHQSxZQUFZQSxDQUFDQSxpQkFBaUJBLENBQUNBLENBQUNBO1FBQ3REQSxNQUFNQSxDQUFDQSxJQUFJQSxVQUFVQSxDQUNqQkEsR0FBR0EsMkJBQTJCQSxDQUFDQSw0QkFBNEJBLEdBQUNBLGlCQUFpQkEsQ0FBQ0EsSUFBSUEsdUJBQXVCQSxDQUFDQSxJQUFJQSxDQUFDQSxLQUFLQSxlQUFlQSxJQUFJQTtZQUN2SUEsR0FBR0EsWUFBWUEsQ0FBQ0EsbUJBQW1CQSxDQUFDQSxLQUFLQSxZQUFZQSxDQUFDQSxxQkFBcUJBLENBQUNBLEtBQUtBLHNCQUFzQkEsQ0FBQ0EsVUFBVUEsQ0FBQ0EsS0FBS0EsT0FBT0EsS0FBS0EsY0FBY0EsR0FBR0EsQ0FBQ0EsQ0FBQ0E7SUFDN0pBLENBQUNBO0lBQ0RKLGdCQUFnQkE7UUFDZEssTUFBTUEsQ0FBQ0EsSUFBSUEsVUFBVUEsQ0FDakJBLEdBQUdBLDJCQUEyQkEsQ0FBQ0EsNEJBQTRCQSxHQUFDQSxlQUFlQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtJQUN4RkEsQ0FBQ0E7SUFDREwsb0JBQW9CQSxDQUFDQSxJQUFZQSxFQUFFQSxpQkFBMkJBLEVBQUVBLG1CQUE2QkEsRUFDeEVBLHFCQUErQkEsRUFBRUEsVUFBc0NBLEVBQ3ZFQSxhQUFnQ0EsRUFBRUEsY0FBc0JBO1FBQzNFTSxJQUFJQSxlQUFlQSxHQUFHQSxZQUFZQSxDQUFDQSxpQkFBaUJBLENBQUNBLENBQUNBO1FBQ3REQSxNQUFNQSxDQUFDQSxJQUFJQSxVQUFVQSxDQUNqQkEsR0FBR0EsMkJBQTJCQSxDQUFDQSw0QkFBNEJBLEdBQUNBLG1CQUFtQkEsQ0FBQ0EsSUFBSUEsdUJBQXVCQSxDQUFDQSxJQUFJQSxDQUFDQSxLQUFLQSxlQUFlQSxJQUFJQTtZQUN6SUEsR0FBR0EsWUFBWUEsQ0FBQ0EsbUJBQW1CQSxDQUFDQSxLQUFLQSxZQUFZQSxDQUFDQSxxQkFBcUJBLENBQUNBLEtBQUtBLHNCQUFzQkEsQ0FBQ0EsVUFBVUEsQ0FBQ0EsS0FBS0Esd0JBQXdCQSxDQUFDQSxhQUFhQSxDQUFDQSxLQUFLQSxjQUFjQSxLQUFLQSxJQUFJQSxDQUFDQSx3QkFBd0JBLENBQUNBLFVBQVVBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBO0lBQzlPQSxDQUFDQTtJQUNETixrQkFBa0JBO1FBQ2hCTyxNQUFNQSxDQUFDQSxJQUFJQSxVQUFVQSxDQUNqQkEsR0FBR0EsMkJBQTJCQSxDQUFDQSw0QkFBNEJBLEdBQUNBLGlCQUFpQkEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7SUFDMUZBLENBQUNBO0lBQ0RQLHNCQUFzQkEsQ0FBQ0EscUJBQTZCQSxFQUFFQSxpQkFBMkJBLEVBQzFEQSxxQkFBK0JBLEVBQUVBLFVBQXNDQSxFQUN2RUEsUUFBaUJBLEVBQUVBLGNBQXNCQSxFQUN6Q0EsUUFBc0JBO1FBQzNDUSxNQUFNQSxDQUFDQSxJQUFJQSxVQUFVQSxDQUNqQkEsR0FBR0EsMkJBQTJCQSxDQUFDQSw0QkFBNEJBLEdBQUNBLHFCQUFxQkEsQ0FBQ0EsSUFBSUEsWUFBWUEsQ0FBQ0EsaUJBQWlCQSxDQUFDQSxLQUFLQSxZQUFZQSxDQUFDQSxxQkFBcUJBLENBQUNBLElBQUlBO1lBQ2pLQSxHQUFHQSxzQkFBc0JBLENBQUNBLFVBQVVBLENBQUNBLEtBQUtBLFFBQVFBLEtBQUtBLGNBQWNBLEtBQUtBLElBQUlBLENBQUNBLGdDQUFnQ0EsQ0FBQ0EscUJBQXFCQSxDQUFDQSxLQUFLQSxZQUFZQSxDQUFDQSxRQUFRQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQTtJQUM1S0EsQ0FBQ0E7QUFDSFIsQ0FBQ0E7QUFFRCwrQkFBK0IsT0FBMkIsRUFBRSxJQUFtQixFQUNoRCxPQUFZO0lBQ3pDUyxnQkFBZ0JBLENBQUNBLE9BQU9BLEVBQUVBLElBQUlBLEVBQUVBLE9BQU9BLENBQUNBLENBQUNBO0lBQ3pDQSxNQUFNQSxDQUFDQSxPQUFPQSxDQUFDQTtBQUNqQkEsQ0FBQ0E7QUFFRDtJQUdFQyxZQUFtQkEsY0FBaUNBLEVBQVNBLHFCQUE2QkE7UUFBdkVDLG1CQUFjQSxHQUFkQSxjQUFjQSxDQUFtQkE7UUFBU0EsMEJBQXFCQSxHQUFyQkEscUJBQXFCQSxDQUFRQTtRQUYxRkEsV0FBTUEsR0FBUUEsRUFBRUEsQ0FBQ0E7UUFDakJBLDZCQUF3QkEsR0FBV0EsQ0FBQ0EsQ0FBQ0E7SUFDd0RBLENBQUNBO0lBRXRGRCxzQkFBc0JBLENBQUNBLFVBQXNDQSxFQUN0Q0EsUUFBdUJBO1FBQ3BERSxJQUFJQSxLQUFLQSxHQUFHQSxrQkFBa0JBLENBQUNBLHFCQUFxQkEsQ0FBQ0EsSUFBSUEsRUFBRUEsUUFBUUEsRUFBRUEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDMUVBLFVBQVVBLENBQUNBLE9BQU9BLENBQUNBLGFBQWFBO1lBQzlCQSxnQkFBZ0JBLENBQUNBLE9BQU9BLENBQUNBLGFBQWFBLENBQUNBLGNBQWNBLEVBQUVBLENBQUNBLEtBQUtBLEVBQUVBLElBQUlBO2dCQUNqRUEsSUFBSUEsU0FBU0EsR0FBR0EsS0FBS0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7Z0JBQzVCQSxLQUFLQSxDQUFDQSxJQUFJQSxDQUFDQSxHQUFHQSxTQUFTQSxDQUFDQSxTQUFTQSxDQUFDQSxHQUFHQSxtQkFBbUJBLENBQUNBLElBQUlBLEVBQUVBLFNBQVNBLEVBQUVBLEtBQUtBLENBQUNBLEdBQUdBLEtBQUtBLENBQUNBO1lBQzNGQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUNMQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUNIQSxNQUFNQSxDQUFDQSxrQkFBa0JBLENBQUNBLEtBQUtBLENBQUNBLENBQUNBO0lBQ25DQSxDQUFDQTtJQUVERixjQUFjQSxDQUFDQSxHQUFpQkEsRUFBRUEsT0FBWUE7UUFDNUNHLElBQUlBLENBQUNBLHdCQUF3QkEsRUFBRUEsQ0FBQ0E7UUFDaENBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLElBQUlBLENBQUNBLGNBQWNBLENBQUNBLGVBQWVBLENBQUNBLEdBQUdBLENBQUNBLEtBQUtBLEVBQUVBLEdBQUdBLENBQUNBLGNBQWNBLENBQUNBLENBQUNBLENBQUNBO1FBQ3JGQSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQTtJQUNkQSxDQUFDQTtJQUNESCxxQkFBcUJBLENBQUNBLEdBQXdCQSxFQUFFQSxPQUFZQTtRQUMxREksSUFBSUEsQ0FBQ0EscUJBQXFCQSxFQUFFQSxDQUFDQTtRQUM3QkEsSUFBSUEsWUFBWUEsR0FBR0EsSUFBSUEscUJBQXFCQSxDQUFDQSxJQUFJQSxDQUFDQSxjQUFjQSxFQUFFQSxJQUFJQSxDQUFDQSxxQkFBcUJBLENBQUNBLENBQUNBO1FBQzlGQSxnQkFBZ0JBLENBQUNBLFlBQVlBLEVBQUVBLEdBQUdBLENBQUNBLFFBQVFBLENBQUNBLENBQUNBO1FBQzdDQSxJQUFJQSxRQUFRQSxHQUFHQSxZQUFZQSxDQUFDQSx3QkFBd0JBLEdBQUdBLENBQUNBLENBQUNBO1FBQ3pEQSxJQUFJQSxxQkFBcUJBLEdBQUdBLEVBQUVBLENBQUNBO1FBQy9CQSxHQUFHQSxDQUFDQSxJQUFJQSxDQUFDQSxPQUFPQSxDQUFDQSxDQUFDQSxNQUFNQTtZQUN0QkEscUJBQXFCQSxDQUFDQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtZQUN4Q0EscUJBQXFCQSxDQUFDQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxLQUFLQSxDQUFDQSxNQUFNQSxHQUFHQSxDQUFDQSxHQUFHQSxNQUFNQSxDQUFDQSxLQUFLQSxHQUFHQSxxQkFBcUJBLENBQUNBLENBQUNBO1FBQzdGQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUNIQSxJQUFJQSxVQUFVQSxHQUFHQSxFQUFFQSxDQUFDQTtRQUNwQkEsV0FBV0EsQ0FBQ0EsZ0JBQWdCQSxDQUFDQSxHQUFHQSxDQUFDQSxVQUFVQSxFQUFFQSxDQUFDQSxZQUEwQkEsRUFBRUEsS0FBYUE7WUFDckZBLFlBQVlBLENBQUNBLEtBQUtBLENBQUNBLElBQUlBLEVBQUVBLElBQUlBLGdCQUFnQkEsQ0FBQ0EsS0FBS0EsRUFBRUEsRUFBRUEsRUFBRUEsRUFBRUEsRUFBRUEsVUFBVUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDNUVBLENBQUNBLENBQUNBLENBQUNBO1FBQ0hBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLElBQUlBLENBQUNBLGNBQWNBLENBQUNBLHNCQUFzQkEsQ0FDdkRBLElBQUlBLENBQUNBLHFCQUFxQkEsRUFBRUEsSUFBSUEsQ0FBQ0Esc0JBQXNCQSxDQUFDQSxVQUFVQSxFQUFFQSxHQUFHQSxDQUFDQSxLQUFLQSxDQUFDQSxFQUM5RUEscUJBQXFCQSxFQUFFQSxVQUFVQSxFQUFFQSxRQUFRQSxFQUFFQSxHQUFHQSxDQUFDQSxjQUFjQSxFQUFFQSxZQUFZQSxDQUFDQSxNQUFNQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUMzRkEsSUFBSUEsQ0FBQ0Esd0JBQXdCQSxJQUFJQSxZQUFZQSxDQUFDQSx3QkFBd0JBLENBQUNBO1FBQ3ZFQSxJQUFJQSxDQUFDQSxxQkFBcUJBLEdBQUdBLFlBQVlBLENBQUNBLHFCQUFxQkEsQ0FBQ0E7UUFDaEVBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBO0lBQ2RBLENBQUNBO0lBQ0RKLFlBQVlBLENBQUNBLEdBQWVBLEVBQUVBLE9BQVlBO1FBQ3hDSyxJQUFJQSxTQUFTQSxHQUFHQSxHQUFHQSxDQUFDQSxZQUFZQSxFQUFFQSxDQUFDQTtRQUNuQ0EsSUFBSUEsbUJBQW1CQSxHQUFHQSxxQkFBcUJBLENBQUNBLElBQUlBLEVBQUVBLEdBQUdBLENBQUNBLE9BQU9BLEVBQUVBLEVBQUVBLENBQUNBLENBQUNBO1FBQ3ZFQSxJQUFJQSxxQkFBcUJBLEdBQUdBLEVBQUVBLENBQUNBO1FBQy9CQSxFQUFFQSxDQUFDQSxDQUFDQSxPQUFPQSxDQUFDQSxTQUFTQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUN2QkEsR0FBR0EsQ0FBQ0EsWUFBWUEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsQ0FBQ0EsTUFBTUE7Z0JBQzlCQSxxQkFBcUJBLENBQUNBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLENBQUNBO2dCQUN4Q0EscUJBQXFCQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtZQUNuQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDTEEsQ0FBQ0E7UUFDREEsSUFBSUEsVUFBVUEsR0FBR0EsRUFBRUEsQ0FBQ0E7UUFDcEJBLFdBQVdBLENBQUNBLGdCQUFnQkEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsVUFBVUEsRUFBRUEsQ0FBQ0EsWUFBMEJBLEVBQUVBLEtBQWFBO1lBQ3JGQSxZQUFZQSxDQUFDQSxLQUFLQSxDQUFDQSxJQUFJQSxFQUFFQSxJQUFJQSxnQkFBZ0JBLENBQUNBLEtBQUtBLEVBQUVBLG1CQUFtQkEsRUFDMUJBLHFCQUFxQkEsRUFBRUEsVUFBVUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDcEZBLENBQUNBLENBQUNBLENBQUNBO1FBQ0hBLG1CQUFtQkEsR0FBR0EsNkJBQTZCQSxDQUFDQSxtQkFBbUJBLENBQUNBLENBQUNBO1FBRXpFQSxJQUFJQSxpQkFBaUJBLEdBQUdBLElBQUlBLENBQUNBLHNCQUFzQkEsQ0FBQ0EsVUFBVUEsRUFBRUEsR0FBR0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EsQ0FBQ0E7UUFDM0VBLEVBQUVBLENBQUNBLENBQUNBLFNBQVNBLENBQUNBLFNBQVNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQ3pCQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxjQUFjQSxDQUFDQSxvQkFBb0JBLENBQ3JEQSxHQUFHQSxDQUFDQSxJQUFJQSxFQUFFQSxpQkFBaUJBLEVBQUVBLG1CQUFtQkEsRUFBRUEscUJBQXFCQSxFQUFFQSxVQUFVQSxFQUNuRkEsU0FBU0EsQ0FBQ0EsUUFBUUEsQ0FBQ0EsYUFBYUEsRUFBRUEsR0FBR0EsQ0FBQ0EsY0FBY0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDM0RBLGdCQUFnQkEsQ0FBQ0EsSUFBSUEsRUFBRUEsR0FBR0EsQ0FBQ0EsUUFBUUEsQ0FBQ0EsQ0FBQ0E7WUFDckNBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLElBQUlBLENBQUNBLGNBQWNBLENBQUNBLGtCQUFrQkEsRUFBRUEsQ0FBQ0EsQ0FBQ0E7UUFDN0RBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLENBQUNBO1lBQ05BLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLElBQUlBLENBQUNBLGNBQWNBLENBQUNBLGtCQUFrQkEsQ0FDbkRBLEdBQUdBLENBQUNBLElBQUlBLEVBQUVBLGlCQUFpQkEsRUFBRUEsbUJBQW1CQSxFQUFFQSxxQkFBcUJBLEVBQUVBLFVBQVVBLEVBQ25GQSxHQUFHQSxDQUFDQSxPQUFPQSxFQUFFQSxFQUFFQSxHQUFHQSxDQUFDQSxjQUFjQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUN4Q0EsZ0JBQWdCQSxDQUFDQSxJQUFJQSxFQUFFQSxHQUFHQSxDQUFDQSxRQUFRQSxDQUFDQSxDQUFDQTtZQUNyQ0EsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsY0FBY0EsQ0FBQ0EsZ0JBQWdCQSxFQUFFQSxDQUFDQSxDQUFDQTtRQUMzREEsQ0FBQ0E7UUFDREEsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0E7SUFDZEEsQ0FBQ0E7SUFDREwsYUFBYUEsQ0FBQ0EsR0FBZ0JBLEVBQUVBLEdBQVFBLElBQVNNLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLENBQUNBLENBQUNBO0lBQy9ETixTQUFTQSxDQUFDQSxHQUFZQSxFQUFFQSxpQkFBMkJBO1FBQ2pETyxpQkFBaUJBLENBQUNBLElBQUlBLENBQUNBLEdBQUdBLENBQUNBLElBQUlBLENBQUNBLENBQUNBO1FBQ2pDQSxpQkFBaUJBLENBQUNBLElBQUlBLENBQUNBLEdBQUdBLENBQUNBLEtBQUtBLENBQUNBLENBQUNBO1FBQ2xDQSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQTtJQUNkQSxDQUFDQTtJQUNEUCxjQUFjQSxDQUFDQSxHQUFpQkEsRUFBRUEsT0FBWUE7UUFDNUNRLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLElBQUlBLENBQUNBLGNBQWNBLENBQUNBLFVBQVVBLENBQUNBLElBQUlBLEVBQUVBLElBQUlBLEVBQUVBLEdBQUdBLENBQUNBLGNBQWNBLENBQUNBLENBQUNBLENBQUNBO1FBQ2pGQSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQTtJQUNkQSxDQUFDQTtJQUNEUixTQUFTQSxDQUFDQSxHQUFZQSxFQUFFQSxPQUFZQTtRQUNsQ1MsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsY0FBY0EsQ0FBQ0EsVUFBVUEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsS0FBS0EsRUFBRUEsS0FBS0EsRUFBRUEsR0FBR0EsQ0FBQ0EsY0FBY0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDdkZBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBO0lBQ2RBLENBQUNBO0lBQ0RULGNBQWNBLENBQUNBLEdBQWlCQSxFQUFFQSxHQUFxQkE7UUFDckRVLEdBQUdBLENBQUNBLGdCQUFnQkEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsU0FBU0EsQ0FBQ0EsQ0FBQ0E7UUFDekNBLGdCQUFnQkEsQ0FBQ0EsSUFBSUEsRUFBRUEsR0FBR0EsQ0FBQ0EsVUFBVUEsRUFBRUEsR0FBR0EsQ0FBQ0EsbUJBQW1CQSxDQUFDQSxDQUFDQTtRQUNoRUEsR0FBR0EsQ0FBQ0EsWUFBWUEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsTUFBTUE7WUFDN0JBLEdBQUdBLENBQUNBLDJCQUEyQkEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7WUFDbERBLEdBQUdBLENBQUNBLDJCQUEyQkEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EsQ0FBQ0E7UUFDbERBLENBQUNBLENBQUNBLENBQUNBO1FBQ0hBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBO0lBQ2RBLENBQUNBO0lBQ0RWLFVBQVVBLENBQUNBLEdBQWtCQSxFQUFFQSxtQkFBNkJBO1FBQzFEVyxtQkFBbUJBLENBQUNBLElBQUlBLENBQUNBLEdBQUdBLENBQUNBLE1BQU1BLENBQUNBLENBQUNBO1FBQ3JDQSxtQkFBbUJBLENBQUNBLElBQUlBLENBQUNBLEdBQUdBLENBQUNBLElBQUlBLENBQUNBLENBQUNBO1FBQ25DQSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQTtJQUNkQSxDQUFDQTtJQUNEWCxzQkFBc0JBLENBQUNBLEdBQThCQSxFQUFFQSxPQUFZQSxJQUFTWSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQSxDQUFDQTtJQUMxRlosb0JBQW9CQSxDQUFDQSxHQUE0QkEsRUFBRUEsT0FBWUEsSUFBU2EsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7QUFDeEZiLENBQUNBO0FBRUQsdUNBQXVDLGFBQXVCO0lBQzVEYyxJQUFJQSxVQUFVQSxHQUFHQSxJQUFJQSxHQUFHQSxFQUFFQSxDQUFDQTtJQUMzQkEsSUFBSUEsbUJBQW1CQSxHQUFHQSxFQUFFQSxDQUFDQTtJQUM3QkEsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsRUFBRUEsQ0FBQ0EsR0FBR0EsYUFBYUEsQ0FBQ0EsTUFBTUEsRUFBRUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsRUFBRUEsQ0FBQ0E7UUFDakRBLElBQUlBLEdBQUdBLEdBQUdBLGFBQWFBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1FBQzNCQSxJQUFJQSxLQUFLQSxHQUFHQSxhQUFhQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUNqQ0EsSUFBSUEsTUFBTUEsR0FBR0EsR0FBR0EsR0FBR0EsSUFBSUEsS0FBS0EsRUFBRUEsQ0FBQ0E7UUFDL0JBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBLFVBQVVBLENBQUNBLEdBQUdBLENBQUNBLFVBQVVBLEVBQUVBLE1BQU1BLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQ3hDQSxtQkFBbUJBLENBQUNBLElBQUlBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBO1lBQzlCQSxtQkFBbUJBLENBQUNBLElBQUlBLENBQUNBLEtBQUtBLENBQUNBLENBQUNBO1lBQ2hDQSxVQUFVQSxDQUFDQSxHQUFHQSxDQUFDQSxNQUFNQSxDQUFDQSxDQUFDQTtRQUN6QkEsQ0FBQ0E7SUFDSEEsQ0FBQ0E7SUFDREEsTUFBTUEsQ0FBQ0EsbUJBQW1CQSxDQUFDQTtBQUM3QkEsQ0FBQ0E7QUFFRCw0QkFBNEIsV0FBcUI7SUFDL0NDLElBQUlBLElBQUlBLEdBQTRCQSxFQUFFQSxDQUFDQTtJQUN2Q0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsRUFBRUEsQ0FBQ0EsR0FBR0EsV0FBV0EsQ0FBQ0EsTUFBTUEsRUFBRUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsRUFBRUEsQ0FBQ0E7UUFDL0NBLElBQUlBLENBQUNBLFdBQVdBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLEdBQUdBLFdBQVdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBLENBQUNBO0lBQzVDQSxDQUFDQTtJQUNEQSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQTtBQUNkQSxDQUFDQTtBQUVELDRCQUE0QixJQUE2QjtJQUN2REMsSUFBSUEsVUFBVUEsR0FBR0EsRUFBRUEsQ0FBQ0E7SUFDcEJBLGdCQUFnQkEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsSUFBSUEsRUFBRUEsQ0FBQ0EsS0FBS0EsRUFBRUEsSUFBSUEsT0FBT0EsVUFBVUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0EsSUFBSUEsRUFBRUEsS0FBS0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7SUFDckZBLGdEQUFnREE7SUFDaERBLG1EQUFtREE7SUFDbkRBLFdBQVdBLENBQUNBLElBQUlBLENBQUNBLFVBQVVBLEVBQUVBLENBQUNBLE1BQU1BLEVBQUVBLE1BQU1BLEtBQUtBLGFBQWFBLENBQUNBLE9BQU9BLENBQUNBLE1BQU1BLENBQUNBLENBQUNBLENBQUNBLEVBQUVBLE1BQU1BLENBQUNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO0lBQzlGQSxJQUFJQSxhQUFhQSxHQUFHQSxFQUFFQSxDQUFDQTtJQUN2QkEsVUFBVUEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsQ0FBQ0EsS0FBS0E7UUFDdkJBLGFBQWFBLENBQUNBLElBQUlBLENBQUNBLEtBQUtBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1FBQzdCQSxhQUFhQSxDQUFDQSxJQUFJQSxDQUFDQSxLQUFLQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtJQUMvQkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7SUFDSEEsTUFBTUEsQ0FBQ0EsYUFBYUEsQ0FBQ0E7QUFDdkJBLENBQUNBO0FBRUQsNkJBQTZCLFFBQWdCLEVBQUUsVUFBa0IsRUFBRSxVQUFrQjtJQUNuRkMsRUFBRUEsQ0FBQ0EsQ0FBQ0EsUUFBUUEsSUFBSUEsVUFBVUEsSUFBSUEsUUFBUUEsSUFBSUEsVUFBVUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDckRBLE1BQU1BLENBQUNBLEdBQUdBLFVBQVVBLElBQUlBLFVBQVVBLEVBQUVBLENBQUNBO0lBQ3ZDQSxDQUFDQTtJQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtRQUNOQSxNQUFNQSxDQUFDQSxVQUFVQSxDQUFDQTtJQUNwQkEsQ0FBQ0E7QUFDSEEsQ0FBQ0E7QUFFRDtJQUNFQyxZQUFtQkEsS0FBYUEsRUFBU0EsbUJBQTZCQSxFQUNuREEsMkJBQWtDQSxFQUNsQ0EsZ0JBQTRDQTtRQUY1Q0MsVUFBS0EsR0FBTEEsS0FBS0EsQ0FBUUE7UUFBU0Esd0JBQW1CQSxHQUFuQkEsbUJBQW1CQSxDQUFVQTtRQUNuREEsZ0NBQTJCQSxHQUEzQkEsMkJBQTJCQSxDQUFPQTtRQUNsQ0EscUJBQWdCQSxHQUFoQkEsZ0JBQWdCQSxDQUE0QkE7SUFBR0EsQ0FBQ0E7QUFDckVELENBQUNBO0FBRUQ7SUFDRUUsWUFBbUJBLEtBQWFBO1FBQWJDLFVBQUtBLEdBQUxBLEtBQUtBLENBQVFBO0lBQUdBLENBQUNBO0FBQ3RDRCxDQUFDQTtBQUVELHFCQUFxQixLQUFVO0lBQzdCRSxFQUFFQSxDQUFDQSxDQUFDQSxLQUFLQSxZQUFZQSxVQUFVQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUNoQ0EsTUFBTUEsQ0FBQ0EsS0FBS0EsQ0FBQ0EsS0FBS0EsQ0FBQ0E7SUFDckJBLENBQUNBO0lBQUNBLElBQUlBLENBQUNBLEVBQUVBLENBQUNBLENBQUNBLFFBQVFBLENBQUNBLEtBQUtBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1FBQzNCQSxNQUFNQSxDQUFDQSx1QkFBdUJBLENBQUNBLEtBQUtBLENBQUNBLENBQUNBO0lBQ3hDQSxDQUFDQTtJQUFDQSxJQUFJQSxDQUFDQSxFQUFFQSxDQUFDQSxDQUFDQSxPQUFPQSxDQUFDQSxLQUFLQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUMxQkEsTUFBTUEsQ0FBQ0EsTUFBTUEsQ0FBQ0E7SUFDaEJBLENBQUNBO0lBQUNBLElBQUlBLENBQUNBLENBQUNBO1FBQ05BLE1BQU1BLENBQUNBLEdBQUdBLEtBQUtBLEVBQUVBLENBQUNBO0lBQ3BCQSxDQUFDQTtBQUNIQSxDQUFDQTtBQUVELHNCQUFzQixJQUFXO0lBQy9CQyxJQUFJQSxJQUFJQSxHQUFHQSxJQUFJQSxJQUFJQSxDQUFDQSxHQUFHQSxDQUFDQSxXQUFXQSxDQUFDQSxDQUFDQSxJQUFJQSxDQUFDQSxHQUFHQSxDQUFDQSxHQUFHQSxDQUFDQTtJQUNsREEsTUFBTUEsQ0FBQ0EsT0FBT0EsR0FBR0EsU0FBU0EsSUFBSUEsRUFBRUEsR0FBR0EsSUFBSUEsQ0FBQ0E7QUFDMUNBLENBQUNBO0FBRUQsZ0NBQWdDLFVBQXNDO0lBQ3BFQyxJQUFJQSxXQUFXQSxHQUFHQSxVQUFVQSxDQUFDQSxHQUFHQSxDQUM1QkEsYUFBYUEsSUFBSUEsR0FBR0EsU0FBU0EsQ0FBQ0EsYUFBYUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsU0FBU0EsQ0FBQ0EsR0FBR0EsYUFBYUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsSUFBSUEsRUFBRUEsQ0FBQ0EsQ0FBQ0E7SUFDN0ZBLElBQUlBLElBQUlBLEdBQUdBLElBQUlBLFdBQVdBLENBQUNBLElBQUlBLENBQUNBLEdBQUdBLENBQUNBLEdBQUdBLENBQUNBO0lBQ3hDQSxNQUFNQSxDQUFDQSxPQUFPQSxHQUFHQSxTQUFTQSxJQUFJQSxFQUFFQSxHQUFHQSxJQUFJQSxDQUFDQTtBQUMxQ0EsQ0FBQ0E7QUFFRCxrQ0FBa0MsS0FBd0I7SUFDeERDLEVBQUVBLENBQUNBLENBQUNBLE9BQU9BLENBQUNBLENBQUNBLENBQUNBO1FBQ1pBLE1BQU1BLENBQUNBLEdBQUdBLDRCQUE0QkEsR0FBR0EsS0FBS0EsRUFBRUEsQ0FBQ0E7SUFDbkRBLENBQUNBO0lBQUNBLElBQUlBLENBQUNBLENBQUNBO1FBQ05BLE1BQU1BLENBQUNBLEdBQUdBLEtBQUtBLEVBQUVBLENBQUNBO0lBQ3BCQSxDQUFDQTtBQUNIQSxDQUFDQSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7aXNQcmVzZW50LCBpc0JsYW5rLCBUeXBlLCBpc1N0cmluZywgU3RyaW5nV3JhcHBlciwgSVNfREFSVH0gZnJvbSAnYW5ndWxhcjIvc3JjL2ZhY2FkZS9sYW5nJztcbmltcG9ydCB7U2V0V3JhcHBlciwgU3RyaW5nTWFwV3JhcHBlciwgTGlzdFdyYXBwZXJ9IGZyb20gJ2FuZ3VsYXIyL3NyYy9mYWNhZGUvY29sbGVjdGlvbic7XG5pbXBvcnQge1xuICBUZW1wbGF0ZUNtZCxcbiAgVGV4dENtZCxcbiAgTmdDb250ZW50Q21kLFxuICBCZWdpbkVsZW1lbnRDbWQsXG4gIEVuZEVsZW1lbnRDbWQsXG4gIEJlZ2luQ29tcG9uZW50Q21kLFxuICBFbmRDb21wb25lbnRDbWQsXG4gIEVtYmVkZGVkVGVtcGxhdGVDbWQsXG4gIENvbXBpbGVkQ29tcG9uZW50VGVtcGxhdGVcbn0gZnJvbSAnYW5ndWxhcjIvc3JjL2NvcmUvbGlua2VyL3RlbXBsYXRlX2NvbW1hbmRzJztcbmltcG9ydCB7XG4gIFRlbXBsYXRlQXN0LFxuICBUZW1wbGF0ZUFzdFZpc2l0b3IsXG4gIE5nQ29udGVudEFzdCxcbiAgRW1iZWRkZWRUZW1wbGF0ZUFzdCxcbiAgRWxlbWVudEFzdCxcbiAgVmFyaWFibGVBc3QsXG4gIEJvdW5kRXZlbnRBc3QsXG4gIEJvdW5kRWxlbWVudFByb3BlcnR5QXN0LFxuICBBdHRyQXN0LFxuICBCb3VuZFRleHRBc3QsXG4gIFRleHRBc3QsXG4gIERpcmVjdGl2ZUFzdCxcbiAgQm91bmREaXJlY3RpdmVQcm9wZXJ0eUFzdCxcbiAgdGVtcGxhdGVWaXNpdEFsbFxufSBmcm9tICcuL3RlbXBsYXRlX2FzdCc7XG5pbXBvcnQge0NvbXBpbGVUeXBlTWV0YWRhdGEsIENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YX0gZnJvbSAnLi9kaXJlY3RpdmVfbWV0YWRhdGEnO1xuaW1wb3J0IHtTb3VyY2VFeHByZXNzaW9ucywgU291cmNlRXhwcmVzc2lvbiwgbW9kdWxlUmVmfSBmcm9tICcuL3NvdXJjZV9tb2R1bGUnO1xuXG5pbXBvcnQge1ZpZXdFbmNhcHN1bGF0aW9ufSBmcm9tICdhbmd1bGFyMi9zcmMvY29yZS9tZXRhZGF0YS92aWV3JztcbmltcG9ydCB7XG4gIGVzY2FwZVNpbmdsZVF1b3RlU3RyaW5nLFxuICBjb2RlR2VuQ29uc3RDb25zdHJ1Y3RvckNhbGwsXG4gIGNvZGVHZW5WYWx1ZUZuLFxuICBNT0RVTEVfU1VGRklYXG59IGZyb20gJy4vdXRpbCc7XG5pbXBvcnQge0luamVjdGFibGV9IGZyb20gJ2FuZ3VsYXIyL3NyYy9jb3JlL2RpJztcblxuZXhwb3J0IHZhciBURU1QTEFURV9DT01NQU5EU19NT0RVTEVfUkVGID1cbiAgICBtb2R1bGVSZWYoYHBhY2thZ2U6YW5ndWxhcjIvc3JjL2NvcmUvbGlua2VyL3RlbXBsYXRlX2NvbW1hbmRzJHtNT0RVTEVfU1VGRklYfWApO1xuXG5jb25zdCBJTVBMSUNJVF9URU1QTEFURV9WQVIgPSAnXFwkaW1wbGljaXQnO1xuY29uc3QgQ0xBU1NfQVRUUiA9ICdjbGFzcyc7XG5jb25zdCBTVFlMRV9BVFRSID0gJ3N0eWxlJztcblxuQEluamVjdGFibGUoKVxuZXhwb3J0IGNsYXNzIENvbW1hbmRDb21waWxlciB7XG4gIGNvbXBpbGVDb21wb25lbnRSdW50aW1lKGNvbXBvbmVudDogQ29tcGlsZURpcmVjdGl2ZU1ldGFkYXRhLCB0ZW1wbGF0ZTogVGVtcGxhdGVBc3RbXSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgY2hhbmdlRGV0ZWN0b3JGYWN0b3JpZXM6IEZ1bmN0aW9uW10sXG4gICAgICAgICAgICAgICAgICAgICAgICAgIGNvbXBvbmVudFRlbXBsYXRlRmFjdG9yeTogRnVuY3Rpb24pOiBUZW1wbGF0ZUNtZFtdIHtcbiAgICB2YXIgdmlzaXRvciA9IG5ldyBDb21tYW5kQnVpbGRlclZpc2l0b3IoXG4gICAgICAgIG5ldyBSdW50aW1lQ29tbWFuZEZhY3RvcnkoY29tcG9uZW50LCBjb21wb25lbnRUZW1wbGF0ZUZhY3RvcnksIGNoYW5nZURldGVjdG9yRmFjdG9yaWVzKSwgMCk7XG4gICAgdGVtcGxhdGVWaXNpdEFsbCh2aXNpdG9yLCB0ZW1wbGF0ZSk7XG4gICAgcmV0dXJuIHZpc2l0b3IucmVzdWx0O1xuICB9XG5cbiAgY29tcGlsZUNvbXBvbmVudENvZGVHZW4oY29tcG9uZW50OiBDb21waWxlRGlyZWN0aXZlTWV0YWRhdGEsIHRlbXBsYXRlOiBUZW1wbGF0ZUFzdFtdLFxuICAgICAgICAgICAgICAgICAgICAgICAgICBjaGFuZ2VEZXRlY3RvckZhY3RvcnlFeHByZXNzaW9uczogc3RyaW5nW10sXG4gICAgICAgICAgICAgICAgICAgICAgICAgIGNvbXBvbmVudFRlbXBsYXRlRmFjdG9yeTogRnVuY3Rpb24pOiBTb3VyY2VFeHByZXNzaW9uIHtcbiAgICB2YXIgdmlzaXRvciA9XG4gICAgICAgIG5ldyBDb21tYW5kQnVpbGRlclZpc2l0b3IobmV3IENvZGVnZW5Db21tYW5kRmFjdG9yeShjb21wb25lbnQsIGNvbXBvbmVudFRlbXBsYXRlRmFjdG9yeSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNoYW5nZURldGVjdG9yRmFjdG9yeUV4cHJlc3Npb25zKSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAwKTtcbiAgICB0ZW1wbGF0ZVZpc2l0QWxsKHZpc2l0b3IsIHRlbXBsYXRlKTtcbiAgICByZXR1cm4gbmV3IFNvdXJjZUV4cHJlc3Npb24oW10sIGNvZGVHZW5BcnJheSh2aXNpdG9yLnJlc3VsdCkpO1xuICB9XG59XG5cbmludGVyZmFjZSBDb21tYW5kRmFjdG9yeTxSPiB7XG4gIGNyZWF0ZVRleHQodmFsdWU6IHN0cmluZywgaXNCb3VuZDogYm9vbGVhbiwgbmdDb250ZW50SW5kZXg6IG51bWJlcik6IFI7XG4gIGNyZWF0ZU5nQ29udGVudChpbmRleDogbnVtYmVyLCBuZ0NvbnRlbnRJbmRleDogbnVtYmVyKTogUjtcbiAgY3JlYXRlQmVnaW5FbGVtZW50KG5hbWU6IHN0cmluZywgYXR0ck5hbWVBbmRWYWx1ZXM6IHN0cmluZ1tdLCBldmVudFRhcmdldEFuZE5hbWVzOiBzdHJpbmdbXSxcbiAgICAgICAgICAgICAgICAgICAgIHZhcmlhYmxlTmFtZUFuZFZhbHVlczogc3RyaW5nW10sIGRpcmVjdGl2ZXM6IENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YVtdLFxuICAgICAgICAgICAgICAgICAgICAgaXNCb3VuZDogYm9vbGVhbiwgbmdDb250ZW50SW5kZXg6IG51bWJlcik6IFI7XG4gIGNyZWF0ZUVuZEVsZW1lbnQoKTogUjtcbiAgY3JlYXRlQmVnaW5Db21wb25lbnQobmFtZTogc3RyaW5nLCBhdHRyTmFtZUFuZFZhbHVlczogc3RyaW5nW10sIGV2ZW50VGFyZ2V0QW5kTmFtZXM6IHN0cmluZ1tdLFxuICAgICAgICAgICAgICAgICAgICAgICB2YXJpYWJsZU5hbWVBbmRWYWx1ZXM6IHN0cmluZ1tdLCBkaXJlY3RpdmVzOiBDb21waWxlRGlyZWN0aXZlTWV0YWRhdGFbXSxcbiAgICAgICAgICAgICAgICAgICAgICAgZW5jYXBzdWxhdGlvbjogVmlld0VuY2Fwc3VsYXRpb24sIG5nQ29udGVudEluZGV4OiBudW1iZXIpOiBSO1xuICBjcmVhdGVFbmRDb21wb25lbnQoKTogUjtcbiAgY3JlYXRlRW1iZWRkZWRUZW1wbGF0ZShlbWJlZGRlZFRlbXBsYXRlSW5kZXg6IG51bWJlciwgYXR0ck5hbWVBbmRWYWx1ZXM6IHN0cmluZ1tdLFxuICAgICAgICAgICAgICAgICAgICAgICAgIHZhcmlhYmxlTmFtZUFuZFZhbHVlczogc3RyaW5nW10sIGRpcmVjdGl2ZXM6IENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YVtdLFxuICAgICAgICAgICAgICAgICAgICAgICAgIGlzTWVyZ2VkOiBib29sZWFuLCBuZ0NvbnRlbnRJbmRleDogbnVtYmVyLCBjaGlsZHJlbjogUltdKTogUjtcbn1cblxuY2xhc3MgUnVudGltZUNvbW1hbmRGYWN0b3J5IGltcGxlbWVudHMgQ29tbWFuZEZhY3Rvcnk8VGVtcGxhdGVDbWQ+IHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSBjb21wb25lbnQ6IENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YSxcbiAgICAgICAgICAgICAgcHJpdmF0ZSBjb21wb25lbnRUZW1wbGF0ZUZhY3Rvcnk6IEZ1bmN0aW9uLFxuICAgICAgICAgICAgICBwcml2YXRlIGNoYW5nZURldGVjdG9yRmFjdG9yaWVzOiBGdW5jdGlvbltdKSB7fVxuICBwcml2YXRlIF9tYXBEaXJlY3RpdmVzKGRpcmVjdGl2ZXM6IENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YVtdKTogVHlwZVtdIHtcbiAgICByZXR1cm4gZGlyZWN0aXZlcy5tYXAoZGlyZWN0aXZlID0+IGRpcmVjdGl2ZS50eXBlLnJ1bnRpbWUpO1xuICB9XG5cbiAgY3JlYXRlVGV4dCh2YWx1ZTogc3RyaW5nLCBpc0JvdW5kOiBib29sZWFuLCBuZ0NvbnRlbnRJbmRleDogbnVtYmVyKTogVGVtcGxhdGVDbWQge1xuICAgIHJldHVybiBuZXcgVGV4dENtZCh2YWx1ZSwgaXNCb3VuZCwgbmdDb250ZW50SW5kZXgpO1xuICB9XG4gIGNyZWF0ZU5nQ29udGVudChpbmRleDogbnVtYmVyLCBuZ0NvbnRlbnRJbmRleDogbnVtYmVyKTogVGVtcGxhdGVDbWQge1xuICAgIHJldHVybiBuZXcgTmdDb250ZW50Q21kKGluZGV4LCBuZ0NvbnRlbnRJbmRleCk7XG4gIH1cbiAgY3JlYXRlQmVnaW5FbGVtZW50KG5hbWU6IHN0cmluZywgYXR0ck5hbWVBbmRWYWx1ZXM6IHN0cmluZ1tdLCBldmVudFRhcmdldEFuZE5hbWVzOiBzdHJpbmdbXSxcbiAgICAgICAgICAgICAgICAgICAgIHZhcmlhYmxlTmFtZUFuZFZhbHVlczogc3RyaW5nW10sIGRpcmVjdGl2ZXM6IENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YVtdLFxuICAgICAgICAgICAgICAgICAgICAgaXNCb3VuZDogYm9vbGVhbiwgbmdDb250ZW50SW5kZXg6IG51bWJlcik6IFRlbXBsYXRlQ21kIHtcbiAgICByZXR1cm4gbmV3IEJlZ2luRWxlbWVudENtZChuYW1lLCBhdHRyTmFtZUFuZFZhbHVlcywgZXZlbnRUYXJnZXRBbmROYW1lcywgdmFyaWFibGVOYW1lQW5kVmFsdWVzLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMuX21hcERpcmVjdGl2ZXMoZGlyZWN0aXZlcyksIGlzQm91bmQsIG5nQ29udGVudEluZGV4KTtcbiAgfVxuICBjcmVhdGVFbmRFbGVtZW50KCk6IFRlbXBsYXRlQ21kIHsgcmV0dXJuIG5ldyBFbmRFbGVtZW50Q21kKCk7IH1cbiAgY3JlYXRlQmVnaW5Db21wb25lbnQobmFtZTogc3RyaW5nLCBhdHRyTmFtZUFuZFZhbHVlczogc3RyaW5nW10sIGV2ZW50VGFyZ2V0QW5kTmFtZXM6IHN0cmluZ1tdLFxuICAgICAgICAgICAgICAgICAgICAgICB2YXJpYWJsZU5hbWVBbmRWYWx1ZXM6IHN0cmluZ1tdLCBkaXJlY3RpdmVzOiBDb21waWxlRGlyZWN0aXZlTWV0YWRhdGFbXSxcbiAgICAgICAgICAgICAgICAgICAgICAgZW5jYXBzdWxhdGlvbjogVmlld0VuY2Fwc3VsYXRpb24sIG5nQ29udGVudEluZGV4OiBudW1iZXIpOiBUZW1wbGF0ZUNtZCB7XG4gICAgdmFyIG5lc3RlZFRlbXBsYXRlQWNjZXNzb3IgPSB0aGlzLmNvbXBvbmVudFRlbXBsYXRlRmFjdG9yeShkaXJlY3RpdmVzWzBdKTtcbiAgICByZXR1cm4gbmV3IEJlZ2luQ29tcG9uZW50Q21kKG5hbWUsIGF0dHJOYW1lQW5kVmFsdWVzLCBldmVudFRhcmdldEFuZE5hbWVzLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdmFyaWFibGVOYW1lQW5kVmFsdWVzLCB0aGlzLl9tYXBEaXJlY3RpdmVzKGRpcmVjdGl2ZXMpLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgZW5jYXBzdWxhdGlvbiwgbmdDb250ZW50SW5kZXgsIG5lc3RlZFRlbXBsYXRlQWNjZXNzb3IpO1xuICB9XG4gIGNyZWF0ZUVuZENvbXBvbmVudCgpOiBUZW1wbGF0ZUNtZCB7IHJldHVybiBuZXcgRW5kQ29tcG9uZW50Q21kKCk7IH1cbiAgY3JlYXRlRW1iZWRkZWRUZW1wbGF0ZShlbWJlZGRlZFRlbXBsYXRlSW5kZXg6IG51bWJlciwgYXR0ck5hbWVBbmRWYWx1ZXM6IHN0cmluZ1tdLFxuICAgICAgICAgICAgICAgICAgICAgICAgIHZhcmlhYmxlTmFtZUFuZFZhbHVlczogc3RyaW5nW10sIGRpcmVjdGl2ZXM6IENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YVtdLFxuICAgICAgICAgICAgICAgICAgICAgICAgIGlzTWVyZ2VkOiBib29sZWFuLCBuZ0NvbnRlbnRJbmRleDogbnVtYmVyLFxuICAgICAgICAgICAgICAgICAgICAgICAgIGNoaWxkcmVuOiBUZW1wbGF0ZUNtZFtdKTogVGVtcGxhdGVDbWQge1xuICAgIHJldHVybiBuZXcgRW1iZWRkZWRUZW1wbGF0ZUNtZChhdHRyTmFtZUFuZFZhbHVlcywgdmFyaWFibGVOYW1lQW5kVmFsdWVzLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aGlzLl9tYXBEaXJlY3RpdmVzKGRpcmVjdGl2ZXMpLCBpc01lcmdlZCwgbmdDb250ZW50SW5kZXgsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMuY2hhbmdlRGV0ZWN0b3JGYWN0b3JpZXNbZW1iZWRkZWRUZW1wbGF0ZUluZGV4XSwgY2hpbGRyZW4pO1xuICB9XG59XG5cbmNsYXNzIENvZGVnZW5Db21tYW5kRmFjdG9yeSBpbXBsZW1lbnRzIENvbW1hbmRGYWN0b3J5PEV4cHJlc3Npb24+IHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSBjb21wb25lbnQ6IENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YSxcbiAgICAgICAgICAgICAgcHJpdmF0ZSBjb21wb25lbnRUZW1wbGF0ZUZhY3Rvcnk6IEZ1bmN0aW9uLFxuICAgICAgICAgICAgICBwcml2YXRlIGNoYW5nZURldGVjdG9yRmFjdG9yeUV4cHJlc3Npb25zOiBzdHJpbmdbXSkge31cblxuICBjcmVhdGVUZXh0KHZhbHVlOiBzdHJpbmcsIGlzQm91bmQ6IGJvb2xlYW4sIG5nQ29udGVudEluZGV4OiBudW1iZXIpOiBFeHByZXNzaW9uIHtcbiAgICByZXR1cm4gbmV3IEV4cHJlc3Npb24oXG4gICAgICAgIGAke2NvZGVHZW5Db25zdENvbnN0cnVjdG9yQ2FsbChURU1QTEFURV9DT01NQU5EU19NT0RVTEVfUkVGKydUZXh0Q21kJyl9KCR7ZXNjYXBlU2luZ2xlUXVvdGVTdHJpbmcodmFsdWUpfSwgJHtpc0JvdW5kfSwgJHtuZ0NvbnRlbnRJbmRleH0pYCk7XG4gIH1cbiAgY3JlYXRlTmdDb250ZW50KGluZGV4OiBudW1iZXIsIG5nQ29udGVudEluZGV4OiBudW1iZXIpOiBFeHByZXNzaW9uIHtcbiAgICByZXR1cm4gbmV3IEV4cHJlc3Npb24oXG4gICAgICAgIGAke2NvZGVHZW5Db25zdENvbnN0cnVjdG9yQ2FsbChURU1QTEFURV9DT01NQU5EU19NT0RVTEVfUkVGKydOZ0NvbnRlbnRDbWQnKX0oJHtpbmRleH0sICR7bmdDb250ZW50SW5kZXh9KWApO1xuICB9XG4gIGNyZWF0ZUJlZ2luRWxlbWVudChuYW1lOiBzdHJpbmcsIGF0dHJOYW1lQW5kVmFsdWVzOiBzdHJpbmdbXSwgZXZlbnRUYXJnZXRBbmROYW1lczogc3RyaW5nW10sXG4gICAgICAgICAgICAgICAgICAgICB2YXJpYWJsZU5hbWVBbmRWYWx1ZXM6IHN0cmluZ1tdLCBkaXJlY3RpdmVzOiBDb21waWxlRGlyZWN0aXZlTWV0YWRhdGFbXSxcbiAgICAgICAgICAgICAgICAgICAgIGlzQm91bmQ6IGJvb2xlYW4sIG5nQ29udGVudEluZGV4OiBudW1iZXIpOiBFeHByZXNzaW9uIHtcbiAgICB2YXIgYXR0cnNFeHByZXNzaW9uID0gY29kZUdlbkFycmF5KGF0dHJOYW1lQW5kVmFsdWVzKTtcbiAgICByZXR1cm4gbmV3IEV4cHJlc3Npb24oXG4gICAgICAgIGAke2NvZGVHZW5Db25zdENvbnN0cnVjdG9yQ2FsbChURU1QTEFURV9DT01NQU5EU19NT0RVTEVfUkVGKydCZWdpbkVsZW1lbnRDbWQnKX0oJHtlc2NhcGVTaW5nbGVRdW90ZVN0cmluZyhuYW1lKX0sICR7YXR0cnNFeHByZXNzaW9ufSwgYCArXG4gICAgICAgIGAke2NvZGVHZW5BcnJheShldmVudFRhcmdldEFuZE5hbWVzKX0sICR7Y29kZUdlbkFycmF5KHZhcmlhYmxlTmFtZUFuZFZhbHVlcyl9LCAke2NvZGVHZW5EaXJlY3RpdmVzQXJyYXkoZGlyZWN0aXZlcyl9LCAke2lzQm91bmR9LCAke25nQ29udGVudEluZGV4fSlgKTtcbiAgfVxuICBjcmVhdGVFbmRFbGVtZW50KCk6IEV4cHJlc3Npb24ge1xuICAgIHJldHVybiBuZXcgRXhwcmVzc2lvbihcbiAgICAgICAgYCR7Y29kZUdlbkNvbnN0Q29uc3RydWN0b3JDYWxsKFRFTVBMQVRFX0NPTU1BTkRTX01PRFVMRV9SRUYrJ0VuZEVsZW1lbnRDbWQnKX0oKWApO1xuICB9XG4gIGNyZWF0ZUJlZ2luQ29tcG9uZW50KG5hbWU6IHN0cmluZywgYXR0ck5hbWVBbmRWYWx1ZXM6IHN0cmluZ1tdLCBldmVudFRhcmdldEFuZE5hbWVzOiBzdHJpbmdbXSxcbiAgICAgICAgICAgICAgICAgICAgICAgdmFyaWFibGVOYW1lQW5kVmFsdWVzOiBzdHJpbmdbXSwgZGlyZWN0aXZlczogQ29tcGlsZURpcmVjdGl2ZU1ldGFkYXRhW10sXG4gICAgICAgICAgICAgICAgICAgICAgIGVuY2Fwc3VsYXRpb246IFZpZXdFbmNhcHN1bGF0aW9uLCBuZ0NvbnRlbnRJbmRleDogbnVtYmVyKTogRXhwcmVzc2lvbiB7XG4gICAgdmFyIGF0dHJzRXhwcmVzc2lvbiA9IGNvZGVHZW5BcnJheShhdHRyTmFtZUFuZFZhbHVlcyk7XG4gICAgcmV0dXJuIG5ldyBFeHByZXNzaW9uKFxuICAgICAgICBgJHtjb2RlR2VuQ29uc3RDb25zdHJ1Y3RvckNhbGwoVEVNUExBVEVfQ09NTUFORFNfTU9EVUxFX1JFRisnQmVnaW5Db21wb25lbnRDbWQnKX0oJHtlc2NhcGVTaW5nbGVRdW90ZVN0cmluZyhuYW1lKX0sICR7YXR0cnNFeHByZXNzaW9ufSwgYCArXG4gICAgICAgIGAke2NvZGVHZW5BcnJheShldmVudFRhcmdldEFuZE5hbWVzKX0sICR7Y29kZUdlbkFycmF5KHZhcmlhYmxlTmFtZUFuZFZhbHVlcyl9LCAke2NvZGVHZW5EaXJlY3RpdmVzQXJyYXkoZGlyZWN0aXZlcyl9LCAke2NvZGVHZW5WaWV3RW5jYXBzdWxhdGlvbihlbmNhcHN1bGF0aW9uKX0sICR7bmdDb250ZW50SW5kZXh9LCAke3RoaXMuY29tcG9uZW50VGVtcGxhdGVGYWN0b3J5KGRpcmVjdGl2ZXNbMF0pfSlgKTtcbiAgfVxuICBjcmVhdGVFbmRDb21wb25lbnQoKTogRXhwcmVzc2lvbiB7XG4gICAgcmV0dXJuIG5ldyBFeHByZXNzaW9uKFxuICAgICAgICBgJHtjb2RlR2VuQ29uc3RDb25zdHJ1Y3RvckNhbGwoVEVNUExBVEVfQ09NTUFORFNfTU9EVUxFX1JFRisnRW5kQ29tcG9uZW50Q21kJyl9KClgKTtcbiAgfVxuICBjcmVhdGVFbWJlZGRlZFRlbXBsYXRlKGVtYmVkZGVkVGVtcGxhdGVJbmRleDogbnVtYmVyLCBhdHRyTmFtZUFuZFZhbHVlczogc3RyaW5nW10sXG4gICAgICAgICAgICAgICAgICAgICAgICAgdmFyaWFibGVOYW1lQW5kVmFsdWVzOiBzdHJpbmdbXSwgZGlyZWN0aXZlczogQ29tcGlsZURpcmVjdGl2ZU1ldGFkYXRhW10sXG4gICAgICAgICAgICAgICAgICAgICAgICAgaXNNZXJnZWQ6IGJvb2xlYW4sIG5nQ29udGVudEluZGV4OiBudW1iZXIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgY2hpbGRyZW46IEV4cHJlc3Npb25bXSk6IEV4cHJlc3Npb24ge1xuICAgIHJldHVybiBuZXcgRXhwcmVzc2lvbihcbiAgICAgICAgYCR7Y29kZUdlbkNvbnN0Q29uc3RydWN0b3JDYWxsKFRFTVBMQVRFX0NPTU1BTkRTX01PRFVMRV9SRUYrJ0VtYmVkZGVkVGVtcGxhdGVDbWQnKX0oJHtjb2RlR2VuQXJyYXkoYXR0ck5hbWVBbmRWYWx1ZXMpfSwgJHtjb2RlR2VuQXJyYXkodmFyaWFibGVOYW1lQW5kVmFsdWVzKX0sIGAgK1xuICAgICAgICBgJHtjb2RlR2VuRGlyZWN0aXZlc0FycmF5KGRpcmVjdGl2ZXMpfSwgJHtpc01lcmdlZH0sICR7bmdDb250ZW50SW5kZXh9LCAke3RoaXMuY2hhbmdlRGV0ZWN0b3JGYWN0b3J5RXhwcmVzc2lvbnNbZW1iZWRkZWRUZW1wbGF0ZUluZGV4XX0sICR7Y29kZUdlbkFycmF5KGNoaWxkcmVuKX0pYCk7XG4gIH1cbn1cblxuZnVuY3Rpb24gdmlzaXRBbmRSZXR1cm5Db250ZXh0KHZpc2l0b3I6IFRlbXBsYXRlQXN0VmlzaXRvciwgYXN0czogVGVtcGxhdGVBc3RbXSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb250ZXh0OiBhbnkpOiBhbnkge1xuICB0ZW1wbGF0ZVZpc2l0QWxsKHZpc2l0b3IsIGFzdHMsIGNvbnRleHQpO1xuICByZXR1cm4gY29udGV4dDtcbn1cblxuY2xhc3MgQ29tbWFuZEJ1aWxkZXJWaXNpdG9yPFI+IGltcGxlbWVudHMgVGVtcGxhdGVBc3RWaXNpdG9yIHtcbiAgcmVzdWx0OiBSW10gPSBbXTtcbiAgdHJhbnNpdGl2ZU5nQ29udGVudENvdW50OiBudW1iZXIgPSAwO1xuICBjb25zdHJ1Y3RvcihwdWJsaWMgY29tbWFuZEZhY3Rvcnk6IENvbW1hbmRGYWN0b3J5PFI+LCBwdWJsaWMgZW1iZWRkZWRUZW1wbGF0ZUluZGV4OiBudW1iZXIpIHt9XG5cbiAgcHJpdmF0ZSBfcmVhZEF0dHJOYW1lQW5kVmFsdWVzKGRpcmVjdGl2ZXM6IENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YVtdLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYXR0ckFzdHM6IFRlbXBsYXRlQXN0W10pOiBzdHJpbmdbXSB7XG4gICAgdmFyIGF0dHJzID0ga2V5VmFsdWVBcnJheVRvTWFwKHZpc2l0QW5kUmV0dXJuQ29udGV4dCh0aGlzLCBhdHRyQXN0cywgW10pKTtcbiAgICBkaXJlY3RpdmVzLmZvckVhY2goZGlyZWN0aXZlTWV0YSA9PiB7XG4gICAgICBTdHJpbmdNYXBXcmFwcGVyLmZvckVhY2goZGlyZWN0aXZlTWV0YS5ob3N0QXR0cmlidXRlcywgKHZhbHVlLCBuYW1lKSA9PiB7XG4gICAgICAgIHZhciBwcmV2VmFsdWUgPSBhdHRyc1tuYW1lXTtcbiAgICAgICAgYXR0cnNbbmFtZV0gPSBpc1ByZXNlbnQocHJldlZhbHVlKSA/IG1lcmdlQXR0cmlidXRlVmFsdWUobmFtZSwgcHJldlZhbHVlLCB2YWx1ZSkgOiB2YWx1ZTtcbiAgICAgIH0pO1xuICAgIH0pO1xuICAgIHJldHVybiBtYXBUb0tleVZhbHVlQXJyYXkoYXR0cnMpO1xuICB9XG5cbiAgdmlzaXROZ0NvbnRlbnQoYXN0OiBOZ0NvbnRlbnRBc3QsIGNvbnRleHQ6IGFueSk6IGFueSB7XG4gICAgdGhpcy50cmFuc2l0aXZlTmdDb250ZW50Q291bnQrKztcbiAgICB0aGlzLnJlc3VsdC5wdXNoKHRoaXMuY29tbWFuZEZhY3RvcnkuY3JlYXRlTmdDb250ZW50KGFzdC5pbmRleCwgYXN0Lm5nQ29udGVudEluZGV4KSk7XG4gICAgcmV0dXJuIG51bGw7XG4gIH1cbiAgdmlzaXRFbWJlZGRlZFRlbXBsYXRlKGFzdDogRW1iZWRkZWRUZW1wbGF0ZUFzdCwgY29udGV4dDogYW55KTogYW55IHtcbiAgICB0aGlzLmVtYmVkZGVkVGVtcGxhdGVJbmRleCsrO1xuICAgIHZhciBjaGlsZFZpc2l0b3IgPSBuZXcgQ29tbWFuZEJ1aWxkZXJWaXNpdG9yKHRoaXMuY29tbWFuZEZhY3RvcnksIHRoaXMuZW1iZWRkZWRUZW1wbGF0ZUluZGV4KTtcbiAgICB0ZW1wbGF0ZVZpc2l0QWxsKGNoaWxkVmlzaXRvciwgYXN0LmNoaWxkcmVuKTtcbiAgICB2YXIgaXNNZXJnZWQgPSBjaGlsZFZpc2l0b3IudHJhbnNpdGl2ZU5nQ29udGVudENvdW50ID4gMDtcbiAgICB2YXIgdmFyaWFibGVOYW1lQW5kVmFsdWVzID0gW107XG4gICAgYXN0LnZhcnMuZm9yRWFjaCgodmFyQXN0KSA9PiB7XG4gICAgICB2YXJpYWJsZU5hbWVBbmRWYWx1ZXMucHVzaCh2YXJBc3QubmFtZSk7XG4gICAgICB2YXJpYWJsZU5hbWVBbmRWYWx1ZXMucHVzaCh2YXJBc3QudmFsdWUubGVuZ3RoID4gMCA/IHZhckFzdC52YWx1ZSA6IElNUExJQ0lUX1RFTVBMQVRFX1ZBUik7XG4gICAgfSk7XG4gICAgdmFyIGRpcmVjdGl2ZXMgPSBbXTtcbiAgICBMaXN0V3JhcHBlci5mb3JFYWNoV2l0aEluZGV4KGFzdC5kaXJlY3RpdmVzLCAoZGlyZWN0aXZlQXN0OiBEaXJlY3RpdmVBc3QsIGluZGV4OiBudW1iZXIpID0+IHtcbiAgICAgIGRpcmVjdGl2ZUFzdC52aXNpdCh0aGlzLCBuZXcgRGlyZWN0aXZlQ29udGV4dChpbmRleCwgW10sIFtdLCBkaXJlY3RpdmVzKSk7XG4gICAgfSk7XG4gICAgdGhpcy5yZXN1bHQucHVzaCh0aGlzLmNvbW1hbmRGYWN0b3J5LmNyZWF0ZUVtYmVkZGVkVGVtcGxhdGUoXG4gICAgICAgIHRoaXMuZW1iZWRkZWRUZW1wbGF0ZUluZGV4LCB0aGlzLl9yZWFkQXR0ck5hbWVBbmRWYWx1ZXMoZGlyZWN0aXZlcywgYXN0LmF0dHJzKSxcbiAgICAgICAgdmFyaWFibGVOYW1lQW5kVmFsdWVzLCBkaXJlY3RpdmVzLCBpc01lcmdlZCwgYXN0Lm5nQ29udGVudEluZGV4LCBjaGlsZFZpc2l0b3IucmVzdWx0KSk7XG4gICAgdGhpcy50cmFuc2l0aXZlTmdDb250ZW50Q291bnQgKz0gY2hpbGRWaXNpdG9yLnRyYW5zaXRpdmVOZ0NvbnRlbnRDb3VudDtcbiAgICB0aGlzLmVtYmVkZGVkVGVtcGxhdGVJbmRleCA9IGNoaWxkVmlzaXRvci5lbWJlZGRlZFRlbXBsYXRlSW5kZXg7XG4gICAgcmV0dXJuIG51bGw7XG4gIH1cbiAgdmlzaXRFbGVtZW50KGFzdDogRWxlbWVudEFzdCwgY29udGV4dDogYW55KTogYW55IHtcbiAgICB2YXIgY29tcG9uZW50ID0gYXN0LmdldENvbXBvbmVudCgpO1xuICAgIHZhciBldmVudFRhcmdldEFuZE5hbWVzID0gdmlzaXRBbmRSZXR1cm5Db250ZXh0KHRoaXMsIGFzdC5vdXRwdXRzLCBbXSk7XG4gICAgdmFyIHZhcmlhYmxlTmFtZUFuZFZhbHVlcyA9IFtdO1xuICAgIGlmIChpc0JsYW5rKGNvbXBvbmVudCkpIHtcbiAgICAgIGFzdC5leHBvcnRBc1ZhcnMuZm9yRWFjaCgodmFyQXN0KSA9PiB7XG4gICAgICAgIHZhcmlhYmxlTmFtZUFuZFZhbHVlcy5wdXNoKHZhckFzdC5uYW1lKTtcbiAgICAgICAgdmFyaWFibGVOYW1lQW5kVmFsdWVzLnB1c2gobnVsbCk7XG4gICAgICB9KTtcbiAgICB9XG4gICAgdmFyIGRpcmVjdGl2ZXMgPSBbXTtcbiAgICBMaXN0V3JhcHBlci5mb3JFYWNoV2l0aEluZGV4KGFzdC5kaXJlY3RpdmVzLCAoZGlyZWN0aXZlQXN0OiBEaXJlY3RpdmVBc3QsIGluZGV4OiBudW1iZXIpID0+IHtcbiAgICAgIGRpcmVjdGl2ZUFzdC52aXNpdCh0aGlzLCBuZXcgRGlyZWN0aXZlQ29udGV4dChpbmRleCwgZXZlbnRUYXJnZXRBbmROYW1lcyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB2YXJpYWJsZU5hbWVBbmRWYWx1ZXMsIGRpcmVjdGl2ZXMpKTtcbiAgICB9KTtcbiAgICBldmVudFRhcmdldEFuZE5hbWVzID0gcmVtb3ZlS2V5VmFsdWVBcnJheUR1cGxpY2F0ZXMoZXZlbnRUYXJnZXRBbmROYW1lcyk7XG5cbiAgICB2YXIgYXR0ck5hbWVBbmRWYWx1ZXMgPSB0aGlzLl9yZWFkQXR0ck5hbWVBbmRWYWx1ZXMoZGlyZWN0aXZlcywgYXN0LmF0dHJzKTtcbiAgICBpZiAoaXNQcmVzZW50KGNvbXBvbmVudCkpIHtcbiAgICAgIHRoaXMucmVzdWx0LnB1c2godGhpcy5jb21tYW5kRmFjdG9yeS5jcmVhdGVCZWdpbkNvbXBvbmVudChcbiAgICAgICAgICBhc3QubmFtZSwgYXR0ck5hbWVBbmRWYWx1ZXMsIGV2ZW50VGFyZ2V0QW5kTmFtZXMsIHZhcmlhYmxlTmFtZUFuZFZhbHVlcywgZGlyZWN0aXZlcyxcbiAgICAgICAgICBjb21wb25lbnQudGVtcGxhdGUuZW5jYXBzdWxhdGlvbiwgYXN0Lm5nQ29udGVudEluZGV4KSk7XG4gICAgICB0ZW1wbGF0ZVZpc2l0QWxsKHRoaXMsIGFzdC5jaGlsZHJlbik7XG4gICAgICB0aGlzLnJlc3VsdC5wdXNoKHRoaXMuY29tbWFuZEZhY3RvcnkuY3JlYXRlRW5kQ29tcG9uZW50KCkpO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLnJlc3VsdC5wdXNoKHRoaXMuY29tbWFuZEZhY3RvcnkuY3JlYXRlQmVnaW5FbGVtZW50KFxuICAgICAgICAgIGFzdC5uYW1lLCBhdHRyTmFtZUFuZFZhbHVlcywgZXZlbnRUYXJnZXRBbmROYW1lcywgdmFyaWFibGVOYW1lQW5kVmFsdWVzLCBkaXJlY3RpdmVzLFxuICAgICAgICAgIGFzdC5pc0JvdW5kKCksIGFzdC5uZ0NvbnRlbnRJbmRleCkpO1xuICAgICAgdGVtcGxhdGVWaXNpdEFsbCh0aGlzLCBhc3QuY2hpbGRyZW4pO1xuICAgICAgdGhpcy5yZXN1bHQucHVzaCh0aGlzLmNvbW1hbmRGYWN0b3J5LmNyZWF0ZUVuZEVsZW1lbnQoKSk7XG4gICAgfVxuICAgIHJldHVybiBudWxsO1xuICB9XG4gIHZpc2l0VmFyaWFibGUoYXN0OiBWYXJpYWJsZUFzdCwgY3R4OiBhbnkpOiBhbnkgeyByZXR1cm4gbnVsbDsgfVxuICB2aXNpdEF0dHIoYXN0OiBBdHRyQXN0LCBhdHRyTmFtZUFuZFZhbHVlczogc3RyaW5nW10pOiBhbnkge1xuICAgIGF0dHJOYW1lQW5kVmFsdWVzLnB1c2goYXN0Lm5hbWUpO1xuICAgIGF0dHJOYW1lQW5kVmFsdWVzLnB1c2goYXN0LnZhbHVlKTtcbiAgICByZXR1cm4gbnVsbDtcbiAgfVxuICB2aXNpdEJvdW5kVGV4dChhc3Q6IEJvdW5kVGV4dEFzdCwgY29udGV4dDogYW55KTogYW55IHtcbiAgICB0aGlzLnJlc3VsdC5wdXNoKHRoaXMuY29tbWFuZEZhY3RvcnkuY3JlYXRlVGV4dChudWxsLCB0cnVlLCBhc3QubmdDb250ZW50SW5kZXgpKTtcbiAgICByZXR1cm4gbnVsbDtcbiAgfVxuICB2aXNpdFRleHQoYXN0OiBUZXh0QXN0LCBjb250ZXh0OiBhbnkpOiBhbnkge1xuICAgIHRoaXMucmVzdWx0LnB1c2godGhpcy5jb21tYW5kRmFjdG9yeS5jcmVhdGVUZXh0KGFzdC52YWx1ZSwgZmFsc2UsIGFzdC5uZ0NvbnRlbnRJbmRleCkpO1xuICAgIHJldHVybiBudWxsO1xuICB9XG4gIHZpc2l0RGlyZWN0aXZlKGFzdDogRGlyZWN0aXZlQXN0LCBjdHg6IERpcmVjdGl2ZUNvbnRleHQpOiBhbnkge1xuICAgIGN0eC50YXJnZXREaXJlY3RpdmVzLnB1c2goYXN0LmRpcmVjdGl2ZSk7XG4gICAgdGVtcGxhdGVWaXNpdEFsbCh0aGlzLCBhc3QuaG9zdEV2ZW50cywgY3R4LmV2ZW50VGFyZ2V0QW5kTmFtZXMpO1xuICAgIGFzdC5leHBvcnRBc1ZhcnMuZm9yRWFjaCh2YXJBc3QgPT4ge1xuICAgICAgY3R4LnRhcmdldFZhcmlhYmxlTmFtZUFuZFZhbHVlcy5wdXNoKHZhckFzdC5uYW1lKTtcbiAgICAgIGN0eC50YXJnZXRWYXJpYWJsZU5hbWVBbmRWYWx1ZXMucHVzaChjdHguaW5kZXgpO1xuICAgIH0pO1xuICAgIHJldHVybiBudWxsO1xuICB9XG4gIHZpc2l0RXZlbnQoYXN0OiBCb3VuZEV2ZW50QXN0LCBldmVudFRhcmdldEFuZE5hbWVzOiBzdHJpbmdbXSk6IGFueSB7XG4gICAgZXZlbnRUYXJnZXRBbmROYW1lcy5wdXNoKGFzdC50YXJnZXQpO1xuICAgIGV2ZW50VGFyZ2V0QW5kTmFtZXMucHVzaChhc3QubmFtZSk7XG4gICAgcmV0dXJuIG51bGw7XG4gIH1cbiAgdmlzaXREaXJlY3RpdmVQcm9wZXJ0eShhc3Q6IEJvdW5kRGlyZWN0aXZlUHJvcGVydHlBc3QsIGNvbnRleHQ6IGFueSk6IGFueSB7IHJldHVybiBudWxsOyB9XG4gIHZpc2l0RWxlbWVudFByb3BlcnR5KGFzdDogQm91bmRFbGVtZW50UHJvcGVydHlBc3QsIGNvbnRleHQ6IGFueSk6IGFueSB7IHJldHVybiBudWxsOyB9XG59XG5cbmZ1bmN0aW9uIHJlbW92ZUtleVZhbHVlQXJyYXlEdXBsaWNhdGVzKGtleVZhbHVlQXJyYXk6IHN0cmluZ1tdKTogc3RyaW5nW10ge1xuICB2YXIga25vd25QYWlycyA9IG5ldyBTZXQoKTtcbiAgdmFyIHJlc3VsdEtleVZhbHVlQXJyYXkgPSBbXTtcbiAgZm9yICh2YXIgaSA9IDA7IGkgPCBrZXlWYWx1ZUFycmF5Lmxlbmd0aDsgaSArPSAyKSB7XG4gICAgdmFyIGtleSA9IGtleVZhbHVlQXJyYXlbaV07XG4gICAgdmFyIHZhbHVlID0ga2V5VmFsdWVBcnJheVtpICsgMV07XG4gICAgdmFyIHBhaXJJZCA9IGAke2tleX06JHt2YWx1ZX1gO1xuICAgIGlmICghU2V0V3JhcHBlci5oYXMoa25vd25QYWlycywgcGFpcklkKSkge1xuICAgICAgcmVzdWx0S2V5VmFsdWVBcnJheS5wdXNoKGtleSk7XG4gICAgICByZXN1bHRLZXlWYWx1ZUFycmF5LnB1c2godmFsdWUpO1xuICAgICAga25vd25QYWlycy5hZGQocGFpcklkKTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHJlc3VsdEtleVZhbHVlQXJyYXk7XG59XG5cbmZ1bmN0aW9uIGtleVZhbHVlQXJyYXlUb01hcChrZXlWYWx1ZUFycjogc3RyaW5nW10pOiB7W2tleTogc3RyaW5nXTogc3RyaW5nfSB7XG4gIHZhciBkYXRhOiB7W2tleTogc3RyaW5nXTogc3RyaW5nfSA9IHt9O1xuICBmb3IgKHZhciBpID0gMDsgaSA8IGtleVZhbHVlQXJyLmxlbmd0aDsgaSArPSAyKSB7XG4gICAgZGF0YVtrZXlWYWx1ZUFycltpXV0gPSBrZXlWYWx1ZUFycltpICsgMV07XG4gIH1cbiAgcmV0dXJuIGRhdGE7XG59XG5cbmZ1bmN0aW9uIG1hcFRvS2V5VmFsdWVBcnJheShkYXRhOiB7W2tleTogc3RyaW5nXTogc3RyaW5nfSk6IHN0cmluZ1tdIHtcbiAgdmFyIGVudHJ5QXJyYXkgPSBbXTtcbiAgU3RyaW5nTWFwV3JhcHBlci5mb3JFYWNoKGRhdGEsICh2YWx1ZSwgbmFtZSkgPT4geyBlbnRyeUFycmF5LnB1c2goW25hbWUsIHZhbHVlXSk7IH0pO1xuICAvLyBXZSBuZWVkIHRvIHNvcnQgdG8gZ2V0IGEgZGVmaW5lZCBvdXRwdXQgb3JkZXJcbiAgLy8gZm9yIHRlc3RzIGFuZCBmb3IgY2FjaGluZyBnZW5lcmF0ZWQgYXJ0aWZhY3RzLi4uXG4gIExpc3RXcmFwcGVyLnNvcnQoZW50cnlBcnJheSwgKGVudHJ5MSwgZW50cnkyKSA9PiBTdHJpbmdXcmFwcGVyLmNvbXBhcmUoZW50cnkxWzBdLCBlbnRyeTJbMF0pKTtcbiAgdmFyIGtleVZhbHVlQXJyYXkgPSBbXTtcbiAgZW50cnlBcnJheS5mb3JFYWNoKChlbnRyeSkgPT4ge1xuICAgIGtleVZhbHVlQXJyYXkucHVzaChlbnRyeVswXSk7XG4gICAga2V5VmFsdWVBcnJheS5wdXNoKGVudHJ5WzFdKTtcbiAgfSk7XG4gIHJldHVybiBrZXlWYWx1ZUFycmF5O1xufVxuXG5mdW5jdGlvbiBtZXJnZUF0dHJpYnV0ZVZhbHVlKGF0dHJOYW1lOiBzdHJpbmcsIGF0dHJWYWx1ZTE6IHN0cmluZywgYXR0clZhbHVlMjogc3RyaW5nKTogc3RyaW5nIHtcbiAgaWYgKGF0dHJOYW1lID09IENMQVNTX0FUVFIgfHwgYXR0ck5hbWUgPT0gU1RZTEVfQVRUUikge1xuICAgIHJldHVybiBgJHthdHRyVmFsdWUxfSAke2F0dHJWYWx1ZTJ9YDtcbiAgfSBlbHNlIHtcbiAgICByZXR1cm4gYXR0clZhbHVlMjtcbiAgfVxufVxuXG5jbGFzcyBEaXJlY3RpdmVDb250ZXh0IHtcbiAgY29uc3RydWN0b3IocHVibGljIGluZGV4OiBudW1iZXIsIHB1YmxpYyBldmVudFRhcmdldEFuZE5hbWVzOiBzdHJpbmdbXSxcbiAgICAgICAgICAgICAgcHVibGljIHRhcmdldFZhcmlhYmxlTmFtZUFuZFZhbHVlczogYW55W10sXG4gICAgICAgICAgICAgIHB1YmxpYyB0YXJnZXREaXJlY3RpdmVzOiBDb21waWxlRGlyZWN0aXZlTWV0YWRhdGFbXSkge31cbn1cblxuY2xhc3MgRXhwcmVzc2lvbiB7XG4gIGNvbnN0cnVjdG9yKHB1YmxpYyB2YWx1ZTogc3RyaW5nKSB7fVxufVxuXG5mdW5jdGlvbiBlc2NhcGVWYWx1ZSh2YWx1ZTogYW55KTogc3RyaW5nIHtcbiAgaWYgKHZhbHVlIGluc3RhbmNlb2YgRXhwcmVzc2lvbikge1xuICAgIHJldHVybiB2YWx1ZS52YWx1ZTtcbiAgfSBlbHNlIGlmIChpc1N0cmluZyh2YWx1ZSkpIHtcbiAgICByZXR1cm4gZXNjYXBlU2luZ2xlUXVvdGVTdHJpbmcodmFsdWUpO1xuICB9IGVsc2UgaWYgKGlzQmxhbmsodmFsdWUpKSB7XG4gICAgcmV0dXJuICdudWxsJztcbiAgfSBlbHNlIHtcbiAgICByZXR1cm4gYCR7dmFsdWV9YDtcbiAgfVxufVxuXG5mdW5jdGlvbiBjb2RlR2VuQXJyYXkoZGF0YTogYW55W10pOiBzdHJpbmcge1xuICB2YXIgYmFzZSA9IGBbJHtkYXRhLm1hcChlc2NhcGVWYWx1ZSkuam9pbignLCcpfV1gO1xuICByZXR1cm4gSVNfREFSVCA/IGBjb25zdCAke2Jhc2V9YCA6IGJhc2U7XG59XG5cbmZ1bmN0aW9uIGNvZGVHZW5EaXJlY3RpdmVzQXJyYXkoZGlyZWN0aXZlczogQ29tcGlsZURpcmVjdGl2ZU1ldGFkYXRhW10pOiBzdHJpbmcge1xuICB2YXIgZXhwcmVzc2lvbnMgPSBkaXJlY3RpdmVzLm1hcChcbiAgICAgIGRpcmVjdGl2ZVR5cGUgPT4gYCR7bW9kdWxlUmVmKGRpcmVjdGl2ZVR5cGUudHlwZS5tb2R1bGVVcmwpfSR7ZGlyZWN0aXZlVHlwZS50eXBlLm5hbWV9YCk7XG4gIHZhciBiYXNlID0gYFske2V4cHJlc3Npb25zLmpvaW4oJywnKX1dYDtcbiAgcmV0dXJuIElTX0RBUlQgPyBgY29uc3QgJHtiYXNlfWAgOiBiYXNlO1xufVxuXG5mdW5jdGlvbiBjb2RlR2VuVmlld0VuY2Fwc3VsYXRpb24odmFsdWU6IFZpZXdFbmNhcHN1bGF0aW9uKTogc3RyaW5nIHtcbiAgaWYgKElTX0RBUlQpIHtcbiAgICByZXR1cm4gYCR7VEVNUExBVEVfQ09NTUFORFNfTU9EVUxFX1JFRn0ke3ZhbHVlfWA7XG4gIH0gZWxzZSB7XG4gICAgcmV0dXJuIGAke3ZhbHVlfWA7XG4gIH1cbn1cbiJdfQ==