import { RuntimeCompiler_ } from "./runtime_compiler";
export { TemplateCompiler } from './template_compiler';
export { CompileDirectiveMetadata, CompileTypeMetadata, CompileTemplateMetadata } from './directive_metadata';
export { SourceModule, SourceWithImports } from './source_module';
export { PLATFORM_DIRECTIVES, PLATFORM_PIPES } from 'angular2/src/core/platform_directives_and_pipes';
export * from 'angular2/src/compiler/template_ast';
export { TEMPLATE_TRANSFORMS } from 'angular2/src/compiler/template_parser';
import { assertionsEnabled, CONST_EXPR } from 'angular2/src/facade/lang';
import { Provider } from 'angular2/src/core/di';
import { TemplateParser } from 'angular2/src/compiler/template_parser';
import { HtmlParser } from 'angular2/src/compiler/html_parser';
import { TemplateNormalizer } from 'angular2/src/compiler/template_normalizer';
import { RuntimeMetadataResolver } from 'angular2/src/compiler/runtime_metadata';
import { ChangeDetectionCompiler } from 'angular2/src/compiler/change_detector_compiler';
import { StyleCompiler } from 'angular2/src/compiler/style_compiler';
import { CommandCompiler } from 'angular2/src/compiler/command_compiler';
import { TemplateCompiler } from 'angular2/src/compiler/template_compiler';
import { ChangeDetectorGenConfig } from 'angular2/src/core/change_detection/change_detection';
import { Compiler } from 'angular2/src/core/linker/compiler';
import { RuntimeCompiler } from 'angular2/src/compiler/runtime_compiler';
import { ElementSchemaRegistry } from 'angular2/src/compiler/schema/element_schema_registry';
import { DomElementSchemaRegistry } from 'angular2/src/compiler/schema/dom_element_schema_registry';
import { UrlResolver } from 'angular2/src/compiler/url_resolver';
import { AppRootUrl } from 'angular2/src/compiler/app_root_url';
import { AnchorBasedAppRootUrl } from 'angular2/src/compiler/anchor_based_app_root_url';
import { Parser, Lexer } from 'angular2/src/core/change_detection/change_detection';
function _createChangeDetectorGenConfig() {
    return new ChangeDetectorGenConfig(assertionsEnabled(), false, true);
}
export const COMPILER_PROVIDERS = CONST_EXPR([
    Lexer,
    Parser,
    HtmlParser,
    TemplateParser,
    TemplateNormalizer,
    RuntimeMetadataResolver,
    StyleCompiler,
    CommandCompiler,
    ChangeDetectionCompiler,
    new Provider(ChangeDetectorGenConfig, { useFactory: _createChangeDetectorGenConfig, deps: [] }),
    TemplateCompiler,
    new Provider(RuntimeCompiler, { useClass: RuntimeCompiler_ }),
    new Provider(Compiler, { useExisting: RuntimeCompiler }),
    DomElementSchemaRegistry,
    new Provider(ElementSchemaRegistry, { useExisting: DomElementSchemaRegistry }),
    AnchorBasedAppRootUrl,
    new Provider(AppRootUrl, { useExisting: AnchorBasedAppRootUrl }),
    UrlResolver
]);
//# sourceMappingURL=data:application/json;base64,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