var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { IS_DART, isBlank, stringify } from 'angular2/src/facade/lang';
import { BaseException } from 'angular2/src/facade/exceptions';
import { ListWrapper, SetWrapper } from 'angular2/src/facade/collection';
import { PromiseWrapper } from 'angular2/src/facade/async';
import { CompiledComponentTemplate, CompiledHostTemplate, BeginComponentCmd } from 'angular2/src/core/linker/template_commands';
import { createHostComponentMeta, CompileDirectiveMetadata } from './directive_metadata';
import { Injectable } from 'angular2/src/core/di';
import { SourceModule, moduleRef } from './source_module';
import { ChangeDetectionCompiler } from './change_detector_compiler';
import { StyleCompiler } from './style_compiler';
import { CommandCompiler } from './command_compiler';
import { TemplateParser } from './template_parser';
import { TemplateNormalizer } from './template_normalizer';
import { RuntimeMetadataResolver } from './runtime_metadata';
import { TEMPLATE_COMMANDS_MODULE_REF } from './command_compiler';
import { codeGenExportVariable, codeGenValueFn, MODULE_SUFFIX } from './util';
export let TemplateCompiler = class {
    constructor(_runtimeMetadataResolver, _templateNormalizer, _templateParser, _styleCompiler, _commandCompiler, _cdCompiler) {
        this._runtimeMetadataResolver = _runtimeMetadataResolver;
        this._templateNormalizer = _templateNormalizer;
        this._templateParser = _templateParser;
        this._styleCompiler = _styleCompiler;
        this._commandCompiler = _commandCompiler;
        this._cdCompiler = _cdCompiler;
        this._hostCacheKeys = new Map();
        this._compiledTemplateCache = new Map();
        this._compiledTemplateDone = new Map();
        this._nextTemplateId = 0;
    }
    normalizeDirectiveMetadata(directive) {
        if (!directive.isComponent) {
            // For non components there is nothing to be normalized yet.
            return PromiseWrapper.resolve(directive);
        }
        return this._templateNormalizer.normalizeTemplate(directive.type, directive.template)
            .then((normalizedTemplate) => new CompileDirectiveMetadata({
            type: directive.type,
            isComponent: directive.isComponent,
            dynamicLoadable: directive.dynamicLoadable,
            selector: directive.selector,
            exportAs: directive.exportAs,
            changeDetection: directive.changeDetection,
            inputs: directive.inputs,
            outputs: directive.outputs,
            hostListeners: directive.hostListeners,
            hostProperties: directive.hostProperties,
            hostAttributes: directive.hostAttributes,
            lifecycleHooks: directive.lifecycleHooks,
            template: normalizedTemplate
        }));
    }
    compileHostComponentRuntime(type) {
        var hostCacheKey = this._hostCacheKeys.get(type);
        if (isBlank(hostCacheKey)) {
            hostCacheKey = new Object();
            this._hostCacheKeys.set(type, hostCacheKey);
            var compMeta = this._runtimeMetadataResolver.getMetadata(type);
            assertComponent(compMeta);
            var hostMeta = createHostComponentMeta(compMeta.type, compMeta.selector);
            this._compileComponentRuntime(hostCacheKey, hostMeta, [compMeta], new Set());
        }
        return this._compiledTemplateDone.get(hostCacheKey)
            .then(compiledTemplate => new CompiledHostTemplate(compiledTemplate));
    }
    clearCache() {
        this._hostCacheKeys.clear();
        this._styleCompiler.clearCache();
        this._compiledTemplateCache.clear();
        this._compiledTemplateDone.clear();
    }
    _compileComponentRuntime(cacheKey, compMeta, viewDirectives, compilingComponentCacheKeys) {
        let uniqViewDirectives = removeDuplicates(viewDirectives);
        var compiledTemplate = this._compiledTemplateCache.get(cacheKey);
        var done = this._compiledTemplateDone.get(cacheKey);
        if (isBlank(compiledTemplate)) {
            var styles = [];
            var changeDetectorFactory;
            var commands = [];
            var templateId = `${stringify(compMeta.type.runtime)}Template${this._nextTemplateId++}`;
            compiledTemplate = new CompiledComponentTemplate(templateId, (dispatcher) => changeDetectorFactory(dispatcher), commands, styles);
            this._compiledTemplateCache.set(cacheKey, compiledTemplate);
            compilingComponentCacheKeys.add(cacheKey);
            done = PromiseWrapper
                .all([this._styleCompiler.compileComponentRuntime(compMeta.template)].concat(uniqViewDirectives.map(dirMeta => this.normalizeDirectiveMetadata(dirMeta))))
                .then((stylesAndNormalizedViewDirMetas) => {
                var childPromises = [];
                var normalizedViewDirMetas = stylesAndNormalizedViewDirMetas.slice(1);
                var parsedTemplate = this._templateParser.parse(compMeta.template.template, normalizedViewDirMetas, compMeta.type.name);
                var changeDetectorFactories = this._cdCompiler.compileComponentRuntime(compMeta.type, compMeta.changeDetection, parsedTemplate);
                changeDetectorFactory = changeDetectorFactories[0];
                var tmpStyles = stylesAndNormalizedViewDirMetas[0];
                tmpStyles.forEach(style => styles.push(style));
                var tmpCommands = this._compileCommandsRuntime(compMeta, parsedTemplate, changeDetectorFactories, compilingComponentCacheKeys, childPromises);
                tmpCommands.forEach(cmd => commands.push(cmd));
                return PromiseWrapper.all(childPromises);
            })
                .then((_) => {
                SetWrapper.delete(compilingComponentCacheKeys, cacheKey);
                return compiledTemplate;
            });
            this._compiledTemplateDone.set(cacheKey, done);
        }
        return compiledTemplate;
    }
    _compileCommandsRuntime(compMeta, parsedTemplate, changeDetectorFactories, compilingComponentCacheKeys, childPromises) {
        var cmds = this._commandCompiler.compileComponentRuntime(compMeta, parsedTemplate, changeDetectorFactories, (childComponentDir) => {
            var childCacheKey = childComponentDir.type.runtime;
            var childViewDirectives = this._runtimeMetadataResolver.getViewDirectivesMetadata(childComponentDir.type.runtime);
            var childIsRecursive = SetWrapper.has(compilingComponentCacheKeys, childCacheKey);
            var childTemplate = this._compileComponentRuntime(childCacheKey, childComponentDir, childViewDirectives, compilingComponentCacheKeys);
            if (!childIsRecursive) {
                // Only wait for a child if it is not a cycle
                childPromises.push(this._compiledTemplateDone.get(childCacheKey));
            }
            return () => childTemplate;
        });
        cmds.forEach(cmd => {
            if (cmd instanceof BeginComponentCmd) {
                cmd.templateGetter();
            }
        });
        return cmds;
    }
    compileTemplatesCodeGen(components) {
        if (components.length === 0) {
            throw new BaseException('No components given');
        }
        var declarations = [];
        var templateArguments = [];
        var componentMetas = [];
        components.forEach(componentWithDirs => {
            var compMeta = componentWithDirs.component;
            assertComponent(compMeta);
            componentMetas.push(compMeta);
            this._processTemplateCodeGen(compMeta, componentWithDirs.directives, declarations, templateArguments);
            if (compMeta.dynamicLoadable) {
                var hostMeta = createHostComponentMeta(compMeta.type, compMeta.selector);
                componentMetas.push(hostMeta);
                this._processTemplateCodeGen(hostMeta, [compMeta], declarations, templateArguments);
            }
        });
        ListWrapper.forEachWithIndex(componentMetas, (compMeta, index) => {
            var templateId = `${compMeta.type.moduleUrl}|${compMeta.type.name}`;
            var constructionKeyword = IS_DART ? 'const' : 'new';
            var compiledTemplateExpr = `${constructionKeyword} ${TEMPLATE_COMMANDS_MODULE_REF}CompiledComponentTemplate('${templateId}',${templateArguments[index].join(',')})`;
            var variableValueExpr;
            if (compMeta.type.isHost) {
                variableValueExpr =
                    `${constructionKeyword} ${TEMPLATE_COMMANDS_MODULE_REF}CompiledHostTemplate(${compiledTemplateExpr})`;
            }
            else {
                variableValueExpr = compiledTemplateExpr;
            }
            var varName = templateVariableName(compMeta.type);
            declarations.push(`${codeGenExportVariable(varName)}${variableValueExpr};`);
            declarations.push(`${codeGenValueFn([], varName, templateGetterName(compMeta.type))};`);
        });
        var moduleUrl = components[0].component.type.moduleUrl;
        return new SourceModule(`${templateModuleUrl(moduleUrl)}`, declarations.join('\n'));
    }
    compileStylesheetCodeGen(stylesheetUrl, cssText) {
        return this._styleCompiler.compileStylesheetCodeGen(stylesheetUrl, cssText);
    }
    _processTemplateCodeGen(compMeta, directives, targetDeclarations, targetTemplateArguments) {
        let uniqueDirectives = removeDuplicates(directives);
        var styleExpr = this._styleCompiler.compileComponentCodeGen(compMeta.template);
        var parsedTemplate = this._templateParser.parse(compMeta.template.template, uniqueDirectives, compMeta.type.name);
        var changeDetectorsExprs = this._cdCompiler.compileComponentCodeGen(compMeta.type, compMeta.changeDetection, parsedTemplate);
        var commandsExpr = this._commandCompiler.compileComponentCodeGen(compMeta, parsedTemplate, changeDetectorsExprs.expressions, codeGenComponentTemplateFactory);
        addAll(styleExpr.declarations, targetDeclarations);
        addAll(changeDetectorsExprs.declarations, targetDeclarations);
        addAll(commandsExpr.declarations, targetDeclarations);
        targetTemplateArguments.push([changeDetectorsExprs.expressions[0], commandsExpr.expression, styleExpr.expression]);
    }
};
TemplateCompiler = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [RuntimeMetadataResolver, TemplateNormalizer, TemplateParser, StyleCompiler, CommandCompiler, ChangeDetectionCompiler])
], TemplateCompiler);
export class NormalizedComponentWithViewDirectives {
    constructor(component, directives) {
        this.component = component;
        this.directives = directives;
    }
}
function assertComponent(meta) {
    if (!meta.isComponent) {
        throw new BaseException(`Could not compile '${meta.type.name}' because it is not a component.`);
    }
}
function templateVariableName(type) {
    return `${type.name}Template`;
}
function templateGetterName(type) {
    return `${templateVariableName(type)}Getter`;
}
function templateModuleUrl(moduleUrl) {
    var urlWithoutSuffix = moduleUrl.substring(0, moduleUrl.length - MODULE_SUFFIX.length);
    return `${urlWithoutSuffix}.template${MODULE_SUFFIX}`;
}
function addAll(source, target) {
    for (var i = 0; i < source.length; i++) {
        target.push(source[i]);
    }
}
function codeGenComponentTemplateFactory(nestedCompType) {
    return `${moduleRef(templateModuleUrl(nestedCompType.type.moduleUrl))}${templateGetterName(nestedCompType.type)}`;
}
function removeDuplicates(items) {
    let res = [];
    items.forEach(item => {
        let hasMatch = res.filter(r => r.type.name == item.type.name && r.type.moduleUrl == item.type.moduleUrl &&
            r.type.runtime == item.type.runtime)
            .length > 0;
        if (!hasMatch) {
            res.push(item);
        }
    });
    return res;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVtcGxhdGVfY29tcGlsZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJhbmd1bGFyMi9zcmMvY29tcGlsZXIvdGVtcGxhdGVfY29tcGlsZXIudHMiXSwibmFtZXMiOlsiVGVtcGxhdGVDb21waWxlciIsIlRlbXBsYXRlQ29tcGlsZXIuY29uc3RydWN0b3IiLCJUZW1wbGF0ZUNvbXBpbGVyLm5vcm1hbGl6ZURpcmVjdGl2ZU1ldGFkYXRhIiwiVGVtcGxhdGVDb21waWxlci5jb21waWxlSG9zdENvbXBvbmVudFJ1bnRpbWUiLCJUZW1wbGF0ZUNvbXBpbGVyLmNsZWFyQ2FjaGUiLCJUZW1wbGF0ZUNvbXBpbGVyLl9jb21waWxlQ29tcG9uZW50UnVudGltZSIsIlRlbXBsYXRlQ29tcGlsZXIuX2NvbXBpbGVDb21tYW5kc1J1bnRpbWUiLCJUZW1wbGF0ZUNvbXBpbGVyLmNvbXBpbGVUZW1wbGF0ZXNDb2RlR2VuIiwiVGVtcGxhdGVDb21waWxlci5jb21waWxlU3R5bGVzaGVldENvZGVHZW4iLCJUZW1wbGF0ZUNvbXBpbGVyLl9wcm9jZXNzVGVtcGxhdGVDb2RlR2VuIiwiTm9ybWFsaXplZENvbXBvbmVudFdpdGhWaWV3RGlyZWN0aXZlcyIsIk5vcm1hbGl6ZWRDb21wb25lbnRXaXRoVmlld0RpcmVjdGl2ZXMuY29uc3RydWN0b3IiLCJhc3NlcnRDb21wb25lbnQiLCJ0ZW1wbGF0ZVZhcmlhYmxlTmFtZSIsInRlbXBsYXRlR2V0dGVyTmFtZSIsInRlbXBsYXRlTW9kdWxlVXJsIiwiYWRkQWxsIiwiY29kZUdlbkNvbXBvbmVudFRlbXBsYXRlRmFjdG9yeSIsInJlbW92ZUR1cGxpY2F0ZXMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7O09BQU8sRUFBQyxPQUFPLEVBQWMsT0FBTyxFQUFFLFNBQVMsRUFBQyxNQUFNLDBCQUEwQjtPQUN6RSxFQUFDLGFBQWEsRUFBQyxNQUFNLGdDQUFnQztPQUNyRCxFQUFDLFdBQVcsRUFBRSxVQUFVLEVBQWEsTUFBTSxnQ0FBZ0M7T0FDM0UsRUFBQyxjQUFjLEVBQVUsTUFBTSwyQkFBMkI7T0FDMUQsRUFDTCx5QkFBeUIsRUFFekIsb0JBQW9CLEVBQ3BCLGlCQUFpQixFQUNsQixNQUFNLDRDQUE0QztPQUM1QyxFQUNMLHVCQUF1QixFQUN2Qix3QkFBd0IsRUFHekIsTUFBTSxzQkFBc0I7T0FFdEIsRUFBQyxVQUFVLEVBQUMsTUFBTSxzQkFBc0I7T0FDeEMsRUFBQyxZQUFZLEVBQUUsU0FBUyxFQUFDLE1BQU0saUJBQWlCO09BQ2hELEVBQUMsdUJBQXVCLEVBQUMsTUFBTSw0QkFBNEI7T0FDM0QsRUFBQyxhQUFhLEVBQUMsTUFBTSxrQkFBa0I7T0FDdkMsRUFBQyxlQUFlLEVBQUMsTUFBTSxvQkFBb0I7T0FDM0MsRUFBQyxjQUFjLEVBQUMsTUFBTSxtQkFBbUI7T0FDekMsRUFBQyxrQkFBa0IsRUFBQyxNQUFNLHVCQUF1QjtPQUNqRCxFQUFDLHVCQUF1QixFQUFDLE1BQU0sb0JBQW9CO09BRW5ELEVBQUMsNEJBQTRCLEVBQUMsTUFBTSxvQkFBb0I7T0FDeEQsRUFDTCxxQkFBcUIsRUFFckIsY0FBYyxFQUNkLGFBQWEsRUFDZCxNQUFNLFFBQVE7QUFFZjtJQU9FQSxZQUFvQkEsd0JBQWlEQSxFQUNqREEsbUJBQXVDQSxFQUN2Q0EsZUFBK0JBLEVBQVVBLGNBQTZCQSxFQUN0RUEsZ0JBQWlDQSxFQUNqQ0EsV0FBb0NBO1FBSnBDQyw2QkFBd0JBLEdBQXhCQSx3QkFBd0JBLENBQXlCQTtRQUNqREEsd0JBQW1CQSxHQUFuQkEsbUJBQW1CQSxDQUFvQkE7UUFDdkNBLG9CQUFlQSxHQUFmQSxlQUFlQSxDQUFnQkE7UUFBVUEsbUJBQWNBLEdBQWRBLGNBQWNBLENBQWVBO1FBQ3RFQSxxQkFBZ0JBLEdBQWhCQSxnQkFBZ0JBLENBQWlCQTtRQUNqQ0EsZ0JBQVdBLEdBQVhBLFdBQVdBLENBQXlCQTtRQVRoREEsbUJBQWNBLEdBQUdBLElBQUlBLEdBQUdBLEVBQWFBLENBQUNBO1FBQ3RDQSwyQkFBc0JBLEdBQUdBLElBQUlBLEdBQUdBLEVBQWtDQSxDQUFDQTtRQUNuRUEsMEJBQXFCQSxHQUFHQSxJQUFJQSxHQUFHQSxFQUEyQ0EsQ0FBQ0E7UUFDM0VBLG9CQUFlQSxHQUFXQSxDQUFDQSxDQUFDQTtJQU11QkEsQ0FBQ0E7SUFFNURELDBCQUEwQkEsQ0FBQ0EsU0FBbUNBO1FBRTVERSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxTQUFTQSxDQUFDQSxXQUFXQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUMzQkEsNERBQTREQTtZQUM1REEsTUFBTUEsQ0FBQ0EsY0FBY0EsQ0FBQ0EsT0FBT0EsQ0FBQ0EsU0FBU0EsQ0FBQ0EsQ0FBQ0E7UUFDM0NBLENBQUNBO1FBRURBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLG1CQUFtQkEsQ0FBQ0EsaUJBQWlCQSxDQUFDQSxTQUFTQSxDQUFDQSxJQUFJQSxFQUFFQSxTQUFTQSxDQUFDQSxRQUFRQSxDQUFDQTthQUNoRkEsSUFBSUEsQ0FBQ0EsQ0FBQ0Esa0JBQTJDQSxLQUFLQSxJQUFJQSx3QkFBd0JBLENBQUNBO1lBQzVFQSxJQUFJQSxFQUFFQSxTQUFTQSxDQUFDQSxJQUFJQTtZQUNwQkEsV0FBV0EsRUFBRUEsU0FBU0EsQ0FBQ0EsV0FBV0E7WUFDbENBLGVBQWVBLEVBQUVBLFNBQVNBLENBQUNBLGVBQWVBO1lBQzFDQSxRQUFRQSxFQUFFQSxTQUFTQSxDQUFDQSxRQUFRQTtZQUM1QkEsUUFBUUEsRUFBRUEsU0FBU0EsQ0FBQ0EsUUFBUUE7WUFDNUJBLGVBQWVBLEVBQUVBLFNBQVNBLENBQUNBLGVBQWVBO1lBQzFDQSxNQUFNQSxFQUFFQSxTQUFTQSxDQUFDQSxNQUFNQTtZQUN4QkEsT0FBT0EsRUFBRUEsU0FBU0EsQ0FBQ0EsT0FBT0E7WUFDMUJBLGFBQWFBLEVBQUVBLFNBQVNBLENBQUNBLGFBQWFBO1lBQ3RDQSxjQUFjQSxFQUFFQSxTQUFTQSxDQUFDQSxjQUFjQTtZQUN4Q0EsY0FBY0EsRUFBRUEsU0FBU0EsQ0FBQ0EsY0FBY0E7WUFDeENBLGNBQWNBLEVBQUVBLFNBQVNBLENBQUNBLGNBQWNBO1lBQ3hDQSxRQUFRQSxFQUFFQSxrQkFBa0JBO1NBQzdCQSxDQUFDQSxDQUFDQSxDQUFDQTtJQUNoQkEsQ0FBQ0E7SUFFREYsMkJBQTJCQSxDQUFDQSxJQUFVQTtRQUNwQ0csSUFBSUEsWUFBWUEsR0FBR0EsSUFBSUEsQ0FBQ0EsY0FBY0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7UUFDakRBLEVBQUVBLENBQUNBLENBQUNBLE9BQU9BLENBQUNBLFlBQVlBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQzFCQSxZQUFZQSxHQUFHQSxJQUFJQSxNQUFNQSxFQUFFQSxDQUFDQTtZQUM1QkEsSUFBSUEsQ0FBQ0EsY0FBY0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsSUFBSUEsRUFBRUEsWUFBWUEsQ0FBQ0EsQ0FBQ0E7WUFDNUNBLElBQUlBLFFBQVFBLEdBQTZCQSxJQUFJQSxDQUFDQSx3QkFBd0JBLENBQUNBLFdBQVdBLENBQUNBLElBQUlBLENBQUNBLENBQUNBO1lBQ3pGQSxlQUFlQSxDQUFDQSxRQUFRQSxDQUFDQSxDQUFDQTtZQUMxQkEsSUFBSUEsUUFBUUEsR0FDUkEsdUJBQXVCQSxDQUFDQSxRQUFRQSxDQUFDQSxJQUFJQSxFQUFFQSxRQUFRQSxDQUFDQSxRQUFRQSxDQUFDQSxDQUFDQTtZQUU5REEsSUFBSUEsQ0FBQ0Esd0JBQXdCQSxDQUFDQSxZQUFZQSxFQUFFQSxRQUFRQSxFQUFFQSxDQUFDQSxRQUFRQSxDQUFDQSxFQUFFQSxJQUFJQSxHQUFHQSxFQUFFQSxDQUFDQSxDQUFDQTtRQUMvRUEsQ0FBQ0E7UUFDREEsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EscUJBQXFCQSxDQUFDQSxHQUFHQSxDQUFDQSxZQUFZQSxDQUFDQTthQUM5Q0EsSUFBSUEsQ0FBQ0EsZ0JBQWdCQSxJQUFJQSxJQUFJQSxvQkFBb0JBLENBQUNBLGdCQUFnQkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7SUFDNUVBLENBQUNBO0lBRURILFVBQVVBO1FBQ1JJLElBQUlBLENBQUNBLGNBQWNBLENBQUNBLEtBQUtBLEVBQUVBLENBQUNBO1FBQzVCQSxJQUFJQSxDQUFDQSxjQUFjQSxDQUFDQSxVQUFVQSxFQUFFQSxDQUFDQTtRQUNqQ0EsSUFBSUEsQ0FBQ0Esc0JBQXNCQSxDQUFDQSxLQUFLQSxFQUFFQSxDQUFDQTtRQUNwQ0EsSUFBSUEsQ0FBQ0EscUJBQXFCQSxDQUFDQSxLQUFLQSxFQUFFQSxDQUFDQTtJQUNyQ0EsQ0FBQ0E7SUFFT0osd0JBQXdCQSxDQUM1QkEsUUFBYUEsRUFBRUEsUUFBa0NBLEVBQUVBLGNBQTBDQSxFQUM3RkEsMkJBQXFDQTtRQUN2Q0ssSUFBSUEsa0JBQWtCQSxHQUFHQSxnQkFBZ0JBLENBQUNBLGNBQWNBLENBQUNBLENBQUNBO1FBQzFEQSxJQUFJQSxnQkFBZ0JBLEdBQUdBLElBQUlBLENBQUNBLHNCQUFzQkEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsUUFBUUEsQ0FBQ0EsQ0FBQ0E7UUFDakVBLElBQUlBLElBQUlBLEdBQUdBLElBQUlBLENBQUNBLHFCQUFxQkEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsUUFBUUEsQ0FBQ0EsQ0FBQ0E7UUFDcERBLEVBQUVBLENBQUNBLENBQUNBLE9BQU9BLENBQUNBLGdCQUFnQkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDOUJBLElBQUlBLE1BQU1BLEdBQUdBLEVBQUVBLENBQUNBO1lBQ2hCQSxJQUFJQSxxQkFBcUJBLENBQUNBO1lBQzFCQSxJQUFJQSxRQUFRQSxHQUFHQSxFQUFFQSxDQUFDQTtZQUNsQkEsSUFBSUEsVUFBVUEsR0FBR0EsR0FBR0EsU0FBU0EsQ0FBQ0EsUUFBUUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsV0FBV0EsSUFBSUEsQ0FBQ0EsZUFBZUEsRUFBRUEsRUFBRUEsQ0FBQ0E7WUFDeEZBLGdCQUFnQkEsR0FBR0EsSUFBSUEseUJBQXlCQSxDQUM1Q0EsVUFBVUEsRUFBRUEsQ0FBQ0EsVUFBVUEsS0FBS0EscUJBQXFCQSxDQUFDQSxVQUFVQSxDQUFDQSxFQUFFQSxRQUFRQSxFQUFFQSxNQUFNQSxDQUFDQSxDQUFDQTtZQUNyRkEsSUFBSUEsQ0FBQ0Esc0JBQXNCQSxDQUFDQSxHQUFHQSxDQUFDQSxRQUFRQSxFQUFFQSxnQkFBZ0JBLENBQUNBLENBQUNBO1lBQzVEQSwyQkFBMkJBLENBQUNBLEdBQUdBLENBQUNBLFFBQVFBLENBQUNBLENBQUNBO1lBQzFDQSxJQUFJQSxHQUFHQSxjQUFjQTtpQkFDVEEsR0FBR0EsQ0FBQ0EsQ0FBTUEsSUFBSUEsQ0FBQ0EsY0FBY0EsQ0FBQ0EsdUJBQXVCQSxDQUFDQSxRQUFRQSxDQUFDQSxRQUFRQSxDQUFDQSxDQUFDQSxDQUFDQSxNQUFNQSxDQUM3RUEsa0JBQWtCQSxDQUFDQSxHQUFHQSxDQUFDQSxPQUFPQSxJQUFJQSxJQUFJQSxDQUFDQSwwQkFBMEJBLENBQUNBLE9BQU9BLENBQUNBLENBQUNBLENBQUNBLENBQUNBO2lCQUNoRkEsSUFBSUEsQ0FBQ0EsQ0FBQ0EsK0JBQXNDQTtnQkFDM0NBLElBQUlBLGFBQWFBLEdBQUdBLEVBQUVBLENBQUNBO2dCQUN2QkEsSUFBSUEsc0JBQXNCQSxHQUFHQSwrQkFBK0JBLENBQUNBLEtBQUtBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO2dCQUN0RUEsSUFBSUEsY0FBY0EsR0FBR0EsSUFBSUEsQ0FBQ0EsZUFBZUEsQ0FBQ0EsS0FBS0EsQ0FDM0NBLFFBQVFBLENBQUNBLFFBQVFBLENBQUNBLFFBQVFBLEVBQUVBLHNCQUFzQkEsRUFBRUEsUUFBUUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7Z0JBRTVFQSxJQUFJQSx1QkFBdUJBLEdBQUdBLElBQUlBLENBQUNBLFdBQVdBLENBQUNBLHVCQUF1QkEsQ0FDbEVBLFFBQVFBLENBQUNBLElBQUlBLEVBQUVBLFFBQVFBLENBQUNBLGVBQWVBLEVBQUVBLGNBQWNBLENBQUNBLENBQUNBO2dCQUM3REEscUJBQXFCQSxHQUFHQSx1QkFBdUJBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO2dCQUNuREEsSUFBSUEsU0FBU0EsR0FBYUEsK0JBQStCQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtnQkFDN0RBLFNBQVNBLENBQUNBLE9BQU9BLENBQUNBLEtBQUtBLElBQUlBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLEtBQUtBLENBQUNBLENBQUNBLENBQUNBO2dCQUMvQ0EsSUFBSUEsV0FBV0EsR0FBa0JBLElBQUlBLENBQUNBLHVCQUF1QkEsQ0FDekRBLFFBQVFBLEVBQUVBLGNBQWNBLEVBQUVBLHVCQUF1QkEsRUFDakRBLDJCQUEyQkEsRUFBRUEsYUFBYUEsQ0FBQ0EsQ0FBQ0E7Z0JBQ2hEQSxXQUFXQSxDQUFDQSxPQUFPQSxDQUFDQSxHQUFHQSxJQUFJQSxRQUFRQSxDQUFDQSxJQUFJQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQSxDQUFDQTtnQkFDL0NBLE1BQU1BLENBQUNBLGNBQWNBLENBQUNBLEdBQUdBLENBQUNBLGFBQWFBLENBQUNBLENBQUNBO1lBQzNDQSxDQUFDQSxDQUFDQTtpQkFDREEsSUFBSUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7Z0JBQ05BLFVBQVVBLENBQUNBLE1BQU1BLENBQUNBLDJCQUEyQkEsRUFBRUEsUUFBUUEsQ0FBQ0EsQ0FBQ0E7Z0JBQ3pEQSxNQUFNQSxDQUFDQSxnQkFBZ0JBLENBQUNBO1lBQzFCQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNkQSxJQUFJQSxDQUFDQSxxQkFBcUJBLENBQUNBLEdBQUdBLENBQUNBLFFBQVFBLEVBQUVBLElBQUlBLENBQUNBLENBQUNBO1FBQ2pEQSxDQUFDQTtRQUNEQSxNQUFNQSxDQUFDQSxnQkFBZ0JBLENBQUNBO0lBQzFCQSxDQUFDQTtJQUVPTCx1QkFBdUJBLENBQUNBLFFBQWtDQSxFQUFFQSxjQUE2QkEsRUFDakVBLHVCQUFtQ0EsRUFDbkNBLDJCQUFzQ0EsRUFDdENBLGFBQTZCQTtRQUMzRE0sSUFBSUEsSUFBSUEsR0FBa0JBLElBQUlBLENBQUNBLGdCQUFnQkEsQ0FBQ0EsdUJBQXVCQSxDQUNuRUEsUUFBUUEsRUFBRUEsY0FBY0EsRUFBRUEsdUJBQXVCQSxFQUNqREEsQ0FBQ0EsaUJBQTJDQTtZQUMxQ0EsSUFBSUEsYUFBYUEsR0FBR0EsaUJBQWlCQSxDQUFDQSxJQUFJQSxDQUFDQSxPQUFPQSxDQUFDQTtZQUNuREEsSUFBSUEsbUJBQW1CQSxHQUNuQkEsSUFBSUEsQ0FBQ0Esd0JBQXdCQSxDQUFDQSx5QkFBeUJBLENBQ25EQSxpQkFBaUJBLENBQUNBLElBQUlBLENBQUNBLE9BQU9BLENBQUNBLENBQUNBO1lBQ3hDQSxJQUFJQSxnQkFBZ0JBLEdBQUdBLFVBQVVBLENBQUNBLEdBQUdBLENBQUNBLDJCQUEyQkEsRUFBRUEsYUFBYUEsQ0FBQ0EsQ0FBQ0E7WUFDbEZBLElBQUlBLGFBQWFBLEdBQUdBLElBQUlBLENBQUNBLHdCQUF3QkEsQ0FDN0NBLGFBQWFBLEVBQUVBLGlCQUFpQkEsRUFBRUEsbUJBQW1CQSxFQUFFQSwyQkFBMkJBLENBQUNBLENBQUNBO1lBQ3hGQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxnQkFBZ0JBLENBQUNBLENBQUNBLENBQUNBO2dCQUN0QkEsNkNBQTZDQTtnQkFDN0NBLGFBQWFBLENBQUNBLElBQUlBLENBQUNBLElBQUlBLENBQUNBLHFCQUFxQkEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsYUFBYUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDcEVBLENBQUNBO1lBQ0RBLE1BQU1BLENBQUNBLE1BQU1BLGFBQWFBLENBQUNBO1FBQzdCQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUNQQSxJQUFJQSxDQUFDQSxPQUFPQSxDQUFDQSxHQUFHQTtZQUNkQSxFQUFFQSxDQUFDQSxDQUFDQSxHQUFHQSxZQUFZQSxpQkFBaUJBLENBQUNBLENBQUNBLENBQUNBO2dCQUNyQ0EsR0FBR0EsQ0FBQ0EsY0FBY0EsRUFBRUEsQ0FBQ0E7WUFDdkJBLENBQUNBO1FBQ0hBLENBQUNBLENBQUNBLENBQUNBO1FBQ0hBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBO0lBQ2RBLENBQUNBO0lBRUROLHVCQUF1QkEsQ0FBQ0EsVUFBbURBO1FBQ3pFTyxFQUFFQSxDQUFDQSxDQUFDQSxVQUFVQSxDQUFDQSxNQUFNQSxLQUFLQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUM1QkEsTUFBTUEsSUFBSUEsYUFBYUEsQ0FBQ0EscUJBQXFCQSxDQUFDQSxDQUFDQTtRQUNqREEsQ0FBQ0E7UUFDREEsSUFBSUEsWUFBWUEsR0FBR0EsRUFBRUEsQ0FBQ0E7UUFDdEJBLElBQUlBLGlCQUFpQkEsR0FBR0EsRUFBRUEsQ0FBQ0E7UUFDM0JBLElBQUlBLGNBQWNBLEdBQStCQSxFQUFFQSxDQUFDQTtRQUNwREEsVUFBVUEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsaUJBQWlCQTtZQUNsQ0EsSUFBSUEsUUFBUUEsR0FBNkJBLGlCQUFpQkEsQ0FBQ0EsU0FBU0EsQ0FBQ0E7WUFDckVBLGVBQWVBLENBQUNBLFFBQVFBLENBQUNBLENBQUNBO1lBQzFCQSxjQUFjQSxDQUFDQSxJQUFJQSxDQUFDQSxRQUFRQSxDQUFDQSxDQUFDQTtZQUU5QkEsSUFBSUEsQ0FBQ0EsdUJBQXVCQSxDQUFDQSxRQUFRQSxFQUFFQSxpQkFBaUJBLENBQUNBLFVBQVVBLEVBQUVBLFlBQVlBLEVBQ3BEQSxpQkFBaUJBLENBQUNBLENBQUNBO1lBQ2hEQSxFQUFFQSxDQUFDQSxDQUFDQSxRQUFRQSxDQUFDQSxlQUFlQSxDQUFDQSxDQUFDQSxDQUFDQTtnQkFDN0JBLElBQUlBLFFBQVFBLEdBQUdBLHVCQUF1QkEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsSUFBSUEsRUFBRUEsUUFBUUEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsQ0FBQ0E7Z0JBQ3pFQSxjQUFjQSxDQUFDQSxJQUFJQSxDQUFDQSxRQUFRQSxDQUFDQSxDQUFDQTtnQkFDOUJBLElBQUlBLENBQUNBLHVCQUF1QkEsQ0FBQ0EsUUFBUUEsRUFBRUEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsRUFBRUEsWUFBWUEsRUFBRUEsaUJBQWlCQSxDQUFDQSxDQUFDQTtZQUN0RkEsQ0FBQ0E7UUFDSEEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDSEEsV0FBV0EsQ0FBQ0EsZ0JBQWdCQSxDQUFDQSxjQUFjQSxFQUFFQSxDQUFDQSxRQUFrQ0EsRUFDbENBLEtBQWFBO1lBQ3pEQSxJQUFJQSxVQUFVQSxHQUFHQSxHQUFHQSxRQUFRQSxDQUFDQSxJQUFJQSxDQUFDQSxTQUFTQSxJQUFJQSxRQUFRQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxFQUFFQSxDQUFDQTtZQUNwRUEsSUFBSUEsbUJBQW1CQSxHQUFHQSxPQUFPQSxHQUFHQSxPQUFPQSxHQUFHQSxLQUFLQSxDQUFDQTtZQUNwREEsSUFBSUEsb0JBQW9CQSxHQUNwQkEsR0FBR0EsbUJBQW1CQSxJQUFJQSw0QkFBNEJBLDhCQUE4QkEsVUFBVUEsS0FBYUEsaUJBQWlCQSxDQUFDQSxLQUFLQSxDQUFFQSxDQUFDQSxJQUFJQSxDQUFDQSxHQUFHQSxDQUFDQSxHQUFHQSxDQUFDQTtZQUN0SkEsSUFBSUEsaUJBQWlCQSxDQUFDQTtZQUN0QkEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsUUFBUUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7Z0JBQ3pCQSxpQkFBaUJBO29CQUNiQSxHQUFHQSxtQkFBbUJBLElBQUlBLDRCQUE0QkEsd0JBQXdCQSxvQkFBb0JBLEdBQUdBLENBQUNBO1lBQzVHQSxDQUFDQTtZQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtnQkFDTkEsaUJBQWlCQSxHQUFHQSxvQkFBb0JBLENBQUNBO1lBQzNDQSxDQUFDQTtZQUNEQSxJQUFJQSxPQUFPQSxHQUFHQSxvQkFBb0JBLENBQUNBLFFBQVFBLENBQUNBLElBQUlBLENBQUNBLENBQUNBO1lBQ2xEQSxZQUFZQSxDQUFDQSxJQUFJQSxDQUFDQSxHQUFHQSxxQkFBcUJBLENBQUNBLE9BQU9BLENBQUNBLEdBQUdBLGlCQUFpQkEsR0FBR0EsQ0FBQ0EsQ0FBQ0E7WUFDNUVBLFlBQVlBLENBQUNBLElBQUlBLENBQUNBLEdBQUdBLGNBQWNBLENBQUNBLEVBQUVBLEVBQUVBLE9BQU9BLEVBQUVBLGtCQUFrQkEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0E7UUFDMUZBLENBQUNBLENBQUNBLENBQUNBO1FBQ0hBLElBQUlBLFNBQVNBLEdBQUdBLFVBQVVBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLFNBQVNBLENBQUNBLElBQUlBLENBQUNBLFNBQVNBLENBQUNBO1FBQ3ZEQSxNQUFNQSxDQUFDQSxJQUFJQSxZQUFZQSxDQUFDQSxHQUFHQSxpQkFBaUJBLENBQUNBLFNBQVNBLENBQUNBLEVBQUVBLEVBQUVBLFlBQVlBLENBQUNBLElBQUlBLENBQUNBLElBQUlBLENBQUNBLENBQUNBLENBQUNBO0lBQ3RGQSxDQUFDQTtJQUVEUCx3QkFBd0JBLENBQUNBLGFBQXFCQSxFQUFFQSxPQUFlQTtRQUM3RFEsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsY0FBY0EsQ0FBQ0Esd0JBQXdCQSxDQUFDQSxhQUFhQSxFQUFFQSxPQUFPQSxDQUFDQSxDQUFDQTtJQUM5RUEsQ0FBQ0E7SUFFT1IsdUJBQXVCQSxDQUFDQSxRQUFrQ0EsRUFDbENBLFVBQXNDQSxFQUN0Q0Esa0JBQTRCQSxFQUFFQSx1QkFBZ0NBO1FBQzVGUyxJQUFJQSxnQkFBZ0JBLEdBQUdBLGdCQUFnQkEsQ0FBQ0EsVUFBVUEsQ0FBQ0EsQ0FBQ0E7UUFDcERBLElBQUlBLFNBQVNBLEdBQUdBLElBQUlBLENBQUNBLGNBQWNBLENBQUNBLHVCQUF1QkEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsQ0FBQ0E7UUFDL0VBLElBQUlBLGNBQWNBLEdBQUdBLElBQUlBLENBQUNBLGVBQWVBLENBQUNBLEtBQUtBLENBQUNBLFFBQVFBLENBQUNBLFFBQVFBLENBQUNBLFFBQVFBLEVBQUVBLGdCQUFnQkEsRUFDNUNBLFFBQVFBLENBQUNBLElBQUlBLENBQUNBLElBQUlBLENBQUNBLENBQUNBO1FBQ3BFQSxJQUFJQSxvQkFBb0JBLEdBQUdBLElBQUlBLENBQUNBLFdBQVdBLENBQUNBLHVCQUF1QkEsQ0FDL0RBLFFBQVFBLENBQUNBLElBQUlBLEVBQUVBLFFBQVFBLENBQUNBLGVBQWVBLEVBQUVBLGNBQWNBLENBQUNBLENBQUNBO1FBQzdEQSxJQUFJQSxZQUFZQSxHQUFHQSxJQUFJQSxDQUFDQSxnQkFBZ0JBLENBQUNBLHVCQUF1QkEsQ0FDNURBLFFBQVFBLEVBQUVBLGNBQWNBLEVBQUVBLG9CQUFvQkEsQ0FBQ0EsV0FBV0EsRUFDMURBLCtCQUErQkEsQ0FBQ0EsQ0FBQ0E7UUFFckNBLE1BQU1BLENBQUNBLFNBQVNBLENBQUNBLFlBQVlBLEVBQUVBLGtCQUFrQkEsQ0FBQ0EsQ0FBQ0E7UUFDbkRBLE1BQU1BLENBQUNBLG9CQUFvQkEsQ0FBQ0EsWUFBWUEsRUFBRUEsa0JBQWtCQSxDQUFDQSxDQUFDQTtRQUM5REEsTUFBTUEsQ0FBQ0EsWUFBWUEsQ0FBQ0EsWUFBWUEsRUFBRUEsa0JBQWtCQSxDQUFDQSxDQUFDQTtRQUV0REEsdUJBQXVCQSxDQUFDQSxJQUFJQSxDQUN4QkEsQ0FBQ0Esb0JBQW9CQSxDQUFDQSxXQUFXQSxDQUFDQSxDQUFDQSxDQUFDQSxFQUFFQSxZQUFZQSxDQUFDQSxVQUFVQSxFQUFFQSxTQUFTQSxDQUFDQSxVQUFVQSxDQUFDQSxDQUFDQSxDQUFDQTtJQUM1RkEsQ0FBQ0E7QUFDSFQsQ0FBQ0E7QUF0TUQ7SUFBQyxVQUFVLEVBQUU7O3FCQXNNWjtBQUVEO0lBQ0VVLFlBQW1CQSxTQUFtQ0EsRUFDbkNBLFVBQXNDQTtRQUR0Q0MsY0FBU0EsR0FBVEEsU0FBU0EsQ0FBMEJBO1FBQ25DQSxlQUFVQSxHQUFWQSxVQUFVQSxDQUE0QkE7SUFBR0EsQ0FBQ0E7QUFDL0RELENBQUNBO0FBRUQseUJBQXlCLElBQThCO0lBQ3JERSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxJQUFJQSxDQUFDQSxXQUFXQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUN0QkEsTUFBTUEsSUFBSUEsYUFBYUEsQ0FBQ0Esc0JBQXNCQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxrQ0FBa0NBLENBQUNBLENBQUNBO0lBQ2xHQSxDQUFDQTtBQUNIQSxDQUFDQTtBQUVELDhCQUE4QixJQUF5QjtJQUNyREMsTUFBTUEsQ0FBQ0EsR0FBR0EsSUFBSUEsQ0FBQ0EsSUFBSUEsVUFBVUEsQ0FBQ0E7QUFDaENBLENBQUNBO0FBRUQsNEJBQTRCLElBQXlCO0lBQ25EQyxNQUFNQSxDQUFDQSxHQUFHQSxvQkFBb0JBLENBQUNBLElBQUlBLENBQUNBLFFBQVFBLENBQUNBO0FBQy9DQSxDQUFDQTtBQUVELDJCQUEyQixTQUFpQjtJQUMxQ0MsSUFBSUEsZ0JBQWdCQSxHQUFHQSxTQUFTQSxDQUFDQSxTQUFTQSxDQUFDQSxDQUFDQSxFQUFFQSxTQUFTQSxDQUFDQSxNQUFNQSxHQUFHQSxhQUFhQSxDQUFDQSxNQUFNQSxDQUFDQSxDQUFDQTtJQUN2RkEsTUFBTUEsQ0FBQ0EsR0FBR0EsZ0JBQWdCQSxZQUFZQSxhQUFhQSxFQUFFQSxDQUFDQTtBQUN4REEsQ0FBQ0E7QUFFRCxnQkFBZ0IsTUFBYSxFQUFFLE1BQWE7SUFDMUNDLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLEVBQUVBLENBQUNBLEdBQUdBLE1BQU1BLENBQUNBLE1BQU1BLEVBQUVBLENBQUNBLEVBQUVBLEVBQUVBLENBQUNBO1FBQ3ZDQSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtJQUN6QkEsQ0FBQ0E7QUFDSEEsQ0FBQ0E7QUFFRCx5Q0FBeUMsY0FBd0M7SUFDL0VDLE1BQU1BLENBQUNBLEdBQUdBLFNBQVNBLENBQUNBLGlCQUFpQkEsQ0FBQ0EsY0FBY0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsU0FBU0EsQ0FBQ0EsQ0FBQ0EsR0FBR0Esa0JBQWtCQSxDQUFDQSxjQUFjQSxDQUFDQSxJQUFJQSxDQUFDQSxFQUFFQSxDQUFDQTtBQUNwSEEsQ0FBQ0E7QUFFRCwwQkFBMEIsS0FBaUM7SUFDekRDLElBQUlBLEdBQUdBLEdBQUdBLEVBQUVBLENBQUNBO0lBQ2JBLEtBQUtBLENBQUNBLE9BQU9BLENBQUNBLElBQUlBO1FBQ2hCQSxJQUFJQSxRQUFRQSxHQUNSQSxHQUFHQSxDQUFDQSxNQUFNQSxDQUFDQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxJQUFJQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxJQUFJQSxDQUFDQSxDQUFDQSxJQUFJQSxDQUFDQSxTQUFTQSxJQUFJQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxTQUFTQTtZQUN4RUEsQ0FBQ0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsT0FBT0EsSUFBSUEsSUFBSUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsT0FBT0EsQ0FBQ0E7YUFDL0NBLE1BQU1BLEdBQUdBLENBQUNBLENBQUNBO1FBQ3BCQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxRQUFRQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNkQSxHQUFHQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtRQUNqQkEsQ0FBQ0E7SUFDSEEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7SUFDSEEsTUFBTUEsQ0FBQ0EsR0FBR0EsQ0FBQ0E7QUFDYkEsQ0FBQ0EiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge0lTX0RBUlQsIFR5cGUsIEpzb24sIGlzQmxhbmssIHN0cmluZ2lmeX0gZnJvbSAnYW5ndWxhcjIvc3JjL2ZhY2FkZS9sYW5nJztcbmltcG9ydCB7QmFzZUV4Y2VwdGlvbn0gZnJvbSAnYW5ndWxhcjIvc3JjL2ZhY2FkZS9leGNlcHRpb25zJztcbmltcG9ydCB7TGlzdFdyYXBwZXIsIFNldFdyYXBwZXIsIE1hcFdyYXBwZXJ9IGZyb20gJ2FuZ3VsYXIyL3NyYy9mYWNhZGUvY29sbGVjdGlvbic7XG5pbXBvcnQge1Byb21pc2VXcmFwcGVyLCBQcm9taXNlfSBmcm9tICdhbmd1bGFyMi9zcmMvZmFjYWRlL2FzeW5jJztcbmltcG9ydCB7XG4gIENvbXBpbGVkQ29tcG9uZW50VGVtcGxhdGUsXG4gIFRlbXBsYXRlQ21kLFxuICBDb21waWxlZEhvc3RUZW1wbGF0ZSxcbiAgQmVnaW5Db21wb25lbnRDbWRcbn0gZnJvbSAnYW5ndWxhcjIvc3JjL2NvcmUvbGlua2VyL3RlbXBsYXRlX2NvbW1hbmRzJztcbmltcG9ydCB7XG4gIGNyZWF0ZUhvc3RDb21wb25lbnRNZXRhLFxuICBDb21waWxlRGlyZWN0aXZlTWV0YWRhdGEsXG4gIENvbXBpbGVUeXBlTWV0YWRhdGEsXG4gIENvbXBpbGVUZW1wbGF0ZU1ldGFkYXRhXG59IGZyb20gJy4vZGlyZWN0aXZlX21ldGFkYXRhJztcbmltcG9ydCB7VGVtcGxhdGVBc3R9IGZyb20gJy4vdGVtcGxhdGVfYXN0JztcbmltcG9ydCB7SW5qZWN0YWJsZX0gZnJvbSAnYW5ndWxhcjIvc3JjL2NvcmUvZGknO1xuaW1wb3J0IHtTb3VyY2VNb2R1bGUsIG1vZHVsZVJlZn0gZnJvbSAnLi9zb3VyY2VfbW9kdWxlJztcbmltcG9ydCB7Q2hhbmdlRGV0ZWN0aW9uQ29tcGlsZXJ9IGZyb20gJy4vY2hhbmdlX2RldGVjdG9yX2NvbXBpbGVyJztcbmltcG9ydCB7U3R5bGVDb21waWxlcn0gZnJvbSAnLi9zdHlsZV9jb21waWxlcic7XG5pbXBvcnQge0NvbW1hbmRDb21waWxlcn0gZnJvbSAnLi9jb21tYW5kX2NvbXBpbGVyJztcbmltcG9ydCB7VGVtcGxhdGVQYXJzZXJ9IGZyb20gJy4vdGVtcGxhdGVfcGFyc2VyJztcbmltcG9ydCB7VGVtcGxhdGVOb3JtYWxpemVyfSBmcm9tICcuL3RlbXBsYXRlX25vcm1hbGl6ZXInO1xuaW1wb3J0IHtSdW50aW1lTWV0YWRhdGFSZXNvbHZlcn0gZnJvbSAnLi9ydW50aW1lX21ldGFkYXRhJztcblxuaW1wb3J0IHtURU1QTEFURV9DT01NQU5EU19NT0RVTEVfUkVGfSBmcm9tICcuL2NvbW1hbmRfY29tcGlsZXInO1xuaW1wb3J0IHtcbiAgY29kZUdlbkV4cG9ydFZhcmlhYmxlLFxuICBlc2NhcGVTaW5nbGVRdW90ZVN0cmluZyxcbiAgY29kZUdlblZhbHVlRm4sXG4gIE1PRFVMRV9TVUZGSVhcbn0gZnJvbSAnLi91dGlsJztcblxuQEluamVjdGFibGUoKVxuZXhwb3J0IGNsYXNzIFRlbXBsYXRlQ29tcGlsZXIge1xuICBwcml2YXRlIF9ob3N0Q2FjaGVLZXlzID0gbmV3IE1hcDxUeXBlLCBhbnk+KCk7XG4gIHByaXZhdGUgX2NvbXBpbGVkVGVtcGxhdGVDYWNoZSA9IG5ldyBNYXA8YW55LCBDb21waWxlZENvbXBvbmVudFRlbXBsYXRlPigpO1xuICBwcml2YXRlIF9jb21waWxlZFRlbXBsYXRlRG9uZSA9IG5ldyBNYXA8YW55LCBQcm9taXNlPENvbXBpbGVkQ29tcG9uZW50VGVtcGxhdGU+PigpO1xuICBwcml2YXRlIF9uZXh0VGVtcGxhdGVJZDogbnVtYmVyID0gMDtcblxuICBjb25zdHJ1Y3Rvcihwcml2YXRlIF9ydW50aW1lTWV0YWRhdGFSZXNvbHZlcjogUnVudGltZU1ldGFkYXRhUmVzb2x2ZXIsXG4gICAgICAgICAgICAgIHByaXZhdGUgX3RlbXBsYXRlTm9ybWFsaXplcjogVGVtcGxhdGVOb3JtYWxpemVyLFxuICAgICAgICAgICAgICBwcml2YXRlIF90ZW1wbGF0ZVBhcnNlcjogVGVtcGxhdGVQYXJzZXIsIHByaXZhdGUgX3N0eWxlQ29tcGlsZXI6IFN0eWxlQ29tcGlsZXIsXG4gICAgICAgICAgICAgIHByaXZhdGUgX2NvbW1hbmRDb21waWxlcjogQ29tbWFuZENvbXBpbGVyLFxuICAgICAgICAgICAgICBwcml2YXRlIF9jZENvbXBpbGVyOiBDaGFuZ2VEZXRlY3Rpb25Db21waWxlcikge31cblxuICBub3JtYWxpemVEaXJlY3RpdmVNZXRhZGF0YShkaXJlY3RpdmU6IENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YSk6XG4gICAgICBQcm9taXNlPENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YT4ge1xuICAgIGlmICghZGlyZWN0aXZlLmlzQ29tcG9uZW50KSB7XG4gICAgICAvLyBGb3Igbm9uIGNvbXBvbmVudHMgdGhlcmUgaXMgbm90aGluZyB0byBiZSBub3JtYWxpemVkIHlldC5cbiAgICAgIHJldHVybiBQcm9taXNlV3JhcHBlci5yZXNvbHZlKGRpcmVjdGl2ZSk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMuX3RlbXBsYXRlTm9ybWFsaXplci5ub3JtYWxpemVUZW1wbGF0ZShkaXJlY3RpdmUudHlwZSwgZGlyZWN0aXZlLnRlbXBsYXRlKVxuICAgICAgICAudGhlbigobm9ybWFsaXplZFRlbXBsYXRlOiBDb21waWxlVGVtcGxhdGVNZXRhZGF0YSkgPT4gbmV3IENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YSh7XG4gICAgICAgICAgICAgICAgdHlwZTogZGlyZWN0aXZlLnR5cGUsXG4gICAgICAgICAgICAgICAgaXNDb21wb25lbnQ6IGRpcmVjdGl2ZS5pc0NvbXBvbmVudCxcbiAgICAgICAgICAgICAgICBkeW5hbWljTG9hZGFibGU6IGRpcmVjdGl2ZS5keW5hbWljTG9hZGFibGUsXG4gICAgICAgICAgICAgICAgc2VsZWN0b3I6IGRpcmVjdGl2ZS5zZWxlY3RvcixcbiAgICAgICAgICAgICAgICBleHBvcnRBczogZGlyZWN0aXZlLmV4cG9ydEFzLFxuICAgICAgICAgICAgICAgIGNoYW5nZURldGVjdGlvbjogZGlyZWN0aXZlLmNoYW5nZURldGVjdGlvbixcbiAgICAgICAgICAgICAgICBpbnB1dHM6IGRpcmVjdGl2ZS5pbnB1dHMsXG4gICAgICAgICAgICAgICAgb3V0cHV0czogZGlyZWN0aXZlLm91dHB1dHMsXG4gICAgICAgICAgICAgICAgaG9zdExpc3RlbmVyczogZGlyZWN0aXZlLmhvc3RMaXN0ZW5lcnMsXG4gICAgICAgICAgICAgICAgaG9zdFByb3BlcnRpZXM6IGRpcmVjdGl2ZS5ob3N0UHJvcGVydGllcyxcbiAgICAgICAgICAgICAgICBob3N0QXR0cmlidXRlczogZGlyZWN0aXZlLmhvc3RBdHRyaWJ1dGVzLFxuICAgICAgICAgICAgICAgIGxpZmVjeWNsZUhvb2tzOiBkaXJlY3RpdmUubGlmZWN5Y2xlSG9va3MsXG4gICAgICAgICAgICAgICAgdGVtcGxhdGU6IG5vcm1hbGl6ZWRUZW1wbGF0ZVxuICAgICAgICAgICAgICB9KSk7XG4gIH1cblxuICBjb21waWxlSG9zdENvbXBvbmVudFJ1bnRpbWUodHlwZTogVHlwZSk6IFByb21pc2U8Q29tcGlsZWRIb3N0VGVtcGxhdGU+IHtcbiAgICB2YXIgaG9zdENhY2hlS2V5ID0gdGhpcy5faG9zdENhY2hlS2V5cy5nZXQodHlwZSk7XG4gICAgaWYgKGlzQmxhbmsoaG9zdENhY2hlS2V5KSkge1xuICAgICAgaG9zdENhY2hlS2V5ID0gbmV3IE9iamVjdCgpO1xuICAgICAgdGhpcy5faG9zdENhY2hlS2V5cy5zZXQodHlwZSwgaG9zdENhY2hlS2V5KTtcbiAgICAgIHZhciBjb21wTWV0YTogQ29tcGlsZURpcmVjdGl2ZU1ldGFkYXRhID0gdGhpcy5fcnVudGltZU1ldGFkYXRhUmVzb2x2ZXIuZ2V0TWV0YWRhdGEodHlwZSk7XG4gICAgICBhc3NlcnRDb21wb25lbnQoY29tcE1ldGEpO1xuICAgICAgdmFyIGhvc3RNZXRhOiBDb21waWxlRGlyZWN0aXZlTWV0YWRhdGEgPVxuICAgICAgICAgIGNyZWF0ZUhvc3RDb21wb25lbnRNZXRhKGNvbXBNZXRhLnR5cGUsIGNvbXBNZXRhLnNlbGVjdG9yKTtcblxuICAgICAgdGhpcy5fY29tcGlsZUNvbXBvbmVudFJ1bnRpbWUoaG9zdENhY2hlS2V5LCBob3N0TWV0YSwgW2NvbXBNZXRhXSwgbmV3IFNldCgpKTtcbiAgICB9XG4gICAgcmV0dXJuIHRoaXMuX2NvbXBpbGVkVGVtcGxhdGVEb25lLmdldChob3N0Q2FjaGVLZXkpXG4gICAgICAgIC50aGVuKGNvbXBpbGVkVGVtcGxhdGUgPT4gbmV3IENvbXBpbGVkSG9zdFRlbXBsYXRlKGNvbXBpbGVkVGVtcGxhdGUpKTtcbiAgfVxuXG4gIGNsZWFyQ2FjaGUoKSB7XG4gICAgdGhpcy5faG9zdENhY2hlS2V5cy5jbGVhcigpO1xuICAgIHRoaXMuX3N0eWxlQ29tcGlsZXIuY2xlYXJDYWNoZSgpO1xuICAgIHRoaXMuX2NvbXBpbGVkVGVtcGxhdGVDYWNoZS5jbGVhcigpO1xuICAgIHRoaXMuX2NvbXBpbGVkVGVtcGxhdGVEb25lLmNsZWFyKCk7XG4gIH1cblxuICBwcml2YXRlIF9jb21waWxlQ29tcG9uZW50UnVudGltZShcbiAgICAgIGNhY2hlS2V5OiBhbnksIGNvbXBNZXRhOiBDb21waWxlRGlyZWN0aXZlTWV0YWRhdGEsIHZpZXdEaXJlY3RpdmVzOiBDb21waWxlRGlyZWN0aXZlTWV0YWRhdGFbXSxcbiAgICAgIGNvbXBpbGluZ0NvbXBvbmVudENhY2hlS2V5czogU2V0PGFueT4pOiBDb21waWxlZENvbXBvbmVudFRlbXBsYXRlIHtcbiAgICBsZXQgdW5pcVZpZXdEaXJlY3RpdmVzID0gcmVtb3ZlRHVwbGljYXRlcyh2aWV3RGlyZWN0aXZlcyk7XG4gICAgdmFyIGNvbXBpbGVkVGVtcGxhdGUgPSB0aGlzLl9jb21waWxlZFRlbXBsYXRlQ2FjaGUuZ2V0KGNhY2hlS2V5KTtcbiAgICB2YXIgZG9uZSA9IHRoaXMuX2NvbXBpbGVkVGVtcGxhdGVEb25lLmdldChjYWNoZUtleSk7XG4gICAgaWYgKGlzQmxhbmsoY29tcGlsZWRUZW1wbGF0ZSkpIHtcbiAgICAgIHZhciBzdHlsZXMgPSBbXTtcbiAgICAgIHZhciBjaGFuZ2VEZXRlY3RvckZhY3Rvcnk7XG4gICAgICB2YXIgY29tbWFuZHMgPSBbXTtcbiAgICAgIHZhciB0ZW1wbGF0ZUlkID0gYCR7c3RyaW5naWZ5KGNvbXBNZXRhLnR5cGUucnVudGltZSl9VGVtcGxhdGUke3RoaXMuX25leHRUZW1wbGF0ZUlkKyt9YDtcbiAgICAgIGNvbXBpbGVkVGVtcGxhdGUgPSBuZXcgQ29tcGlsZWRDb21wb25lbnRUZW1wbGF0ZShcbiAgICAgICAgICB0ZW1wbGF0ZUlkLCAoZGlzcGF0Y2hlcikgPT4gY2hhbmdlRGV0ZWN0b3JGYWN0b3J5KGRpc3BhdGNoZXIpLCBjb21tYW5kcywgc3R5bGVzKTtcbiAgICAgIHRoaXMuX2NvbXBpbGVkVGVtcGxhdGVDYWNoZS5zZXQoY2FjaGVLZXksIGNvbXBpbGVkVGVtcGxhdGUpO1xuICAgICAgY29tcGlsaW5nQ29tcG9uZW50Q2FjaGVLZXlzLmFkZChjYWNoZUtleSk7XG4gICAgICBkb25lID0gUHJvbWlzZVdyYXBwZXJcbiAgICAgICAgICAgICAgICAgLmFsbChbPGFueT50aGlzLl9zdHlsZUNvbXBpbGVyLmNvbXBpbGVDb21wb25lbnRSdW50aW1lKGNvbXBNZXRhLnRlbXBsYXRlKV0uY29uY2F0KFxuICAgICAgICAgICAgICAgICAgICAgdW5pcVZpZXdEaXJlY3RpdmVzLm1hcChkaXJNZXRhID0+IHRoaXMubm9ybWFsaXplRGlyZWN0aXZlTWV0YWRhdGEoZGlyTWV0YSkpKSlcbiAgICAgICAgICAgICAgICAgLnRoZW4oKHN0eWxlc0FuZE5vcm1hbGl6ZWRWaWV3RGlyTWV0YXM6IGFueVtdKSA9PiB7XG4gICAgICAgICAgICAgICAgICAgdmFyIGNoaWxkUHJvbWlzZXMgPSBbXTtcbiAgICAgICAgICAgICAgICAgICB2YXIgbm9ybWFsaXplZFZpZXdEaXJNZXRhcyA9IHN0eWxlc0FuZE5vcm1hbGl6ZWRWaWV3RGlyTWV0YXMuc2xpY2UoMSk7XG4gICAgICAgICAgICAgICAgICAgdmFyIHBhcnNlZFRlbXBsYXRlID0gdGhpcy5fdGVtcGxhdGVQYXJzZXIucGFyc2UoXG4gICAgICAgICAgICAgICAgICAgICAgIGNvbXBNZXRhLnRlbXBsYXRlLnRlbXBsYXRlLCBub3JtYWxpemVkVmlld0Rpck1ldGFzLCBjb21wTWV0YS50eXBlLm5hbWUpO1xuXG4gICAgICAgICAgICAgICAgICAgdmFyIGNoYW5nZURldGVjdG9yRmFjdG9yaWVzID0gdGhpcy5fY2RDb21waWxlci5jb21waWxlQ29tcG9uZW50UnVudGltZShcbiAgICAgICAgICAgICAgICAgICAgICAgY29tcE1ldGEudHlwZSwgY29tcE1ldGEuY2hhbmdlRGV0ZWN0aW9uLCBwYXJzZWRUZW1wbGF0ZSk7XG4gICAgICAgICAgICAgICAgICAgY2hhbmdlRGV0ZWN0b3JGYWN0b3J5ID0gY2hhbmdlRGV0ZWN0b3JGYWN0b3JpZXNbMF07XG4gICAgICAgICAgICAgICAgICAgdmFyIHRtcFN0eWxlczogc3RyaW5nW10gPSBzdHlsZXNBbmROb3JtYWxpemVkVmlld0Rpck1ldGFzWzBdO1xuICAgICAgICAgICAgICAgICAgIHRtcFN0eWxlcy5mb3JFYWNoKHN0eWxlID0+IHN0eWxlcy5wdXNoKHN0eWxlKSk7XG4gICAgICAgICAgICAgICAgICAgdmFyIHRtcENvbW1hbmRzOiBUZW1wbGF0ZUNtZFtdID0gdGhpcy5fY29tcGlsZUNvbW1hbmRzUnVudGltZShcbiAgICAgICAgICAgICAgICAgICAgICAgY29tcE1ldGEsIHBhcnNlZFRlbXBsYXRlLCBjaGFuZ2VEZXRlY3RvckZhY3RvcmllcyxcbiAgICAgICAgICAgICAgICAgICAgICAgY29tcGlsaW5nQ29tcG9uZW50Q2FjaGVLZXlzLCBjaGlsZFByb21pc2VzKTtcbiAgICAgICAgICAgICAgICAgICB0bXBDb21tYW5kcy5mb3JFYWNoKGNtZCA9PiBjb21tYW5kcy5wdXNoKGNtZCkpO1xuICAgICAgICAgICAgICAgICAgIHJldHVybiBQcm9taXNlV3JhcHBlci5hbGwoY2hpbGRQcm9taXNlcyk7XG4gICAgICAgICAgICAgICAgIH0pXG4gICAgICAgICAgICAgICAgIC50aGVuKChfKSA9PiB7XG4gICAgICAgICAgICAgICAgICAgU2V0V3JhcHBlci5kZWxldGUoY29tcGlsaW5nQ29tcG9uZW50Q2FjaGVLZXlzLCBjYWNoZUtleSk7XG4gICAgICAgICAgICAgICAgICAgcmV0dXJuIGNvbXBpbGVkVGVtcGxhdGU7XG4gICAgICAgICAgICAgICAgIH0pO1xuICAgICAgdGhpcy5fY29tcGlsZWRUZW1wbGF0ZURvbmUuc2V0KGNhY2hlS2V5LCBkb25lKTtcbiAgICB9XG4gICAgcmV0dXJuIGNvbXBpbGVkVGVtcGxhdGU7XG4gIH1cblxuICBwcml2YXRlIF9jb21waWxlQ29tbWFuZHNSdW50aW1lKGNvbXBNZXRhOiBDb21waWxlRGlyZWN0aXZlTWV0YWRhdGEsIHBhcnNlZFRlbXBsYXRlOiBUZW1wbGF0ZUFzdFtdLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNoYW5nZURldGVjdG9yRmFjdG9yaWVzOiBGdW5jdGlvbltdLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNvbXBpbGluZ0NvbXBvbmVudENhY2hlS2V5czogU2V0PFR5cGU+LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNoaWxkUHJvbWlzZXM6IFByb21pc2U8YW55PltdKTogVGVtcGxhdGVDbWRbXSB7XG4gICAgdmFyIGNtZHM6IFRlbXBsYXRlQ21kW10gPSB0aGlzLl9jb21tYW5kQ29tcGlsZXIuY29tcGlsZUNvbXBvbmVudFJ1bnRpbWUoXG4gICAgICAgIGNvbXBNZXRhLCBwYXJzZWRUZW1wbGF0ZSwgY2hhbmdlRGV0ZWN0b3JGYWN0b3JpZXMsXG4gICAgICAgIChjaGlsZENvbXBvbmVudERpcjogQ29tcGlsZURpcmVjdGl2ZU1ldGFkYXRhKSA9PiB7XG4gICAgICAgICAgdmFyIGNoaWxkQ2FjaGVLZXkgPSBjaGlsZENvbXBvbmVudERpci50eXBlLnJ1bnRpbWU7XG4gICAgICAgICAgdmFyIGNoaWxkVmlld0RpcmVjdGl2ZXM6IENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YVtdID1cbiAgICAgICAgICAgICAgdGhpcy5fcnVudGltZU1ldGFkYXRhUmVzb2x2ZXIuZ2V0Vmlld0RpcmVjdGl2ZXNNZXRhZGF0YShcbiAgICAgICAgICAgICAgICAgIGNoaWxkQ29tcG9uZW50RGlyLnR5cGUucnVudGltZSk7XG4gICAgICAgICAgdmFyIGNoaWxkSXNSZWN1cnNpdmUgPSBTZXRXcmFwcGVyLmhhcyhjb21waWxpbmdDb21wb25lbnRDYWNoZUtleXMsIGNoaWxkQ2FjaGVLZXkpO1xuICAgICAgICAgIHZhciBjaGlsZFRlbXBsYXRlID0gdGhpcy5fY29tcGlsZUNvbXBvbmVudFJ1bnRpbWUoXG4gICAgICAgICAgICAgIGNoaWxkQ2FjaGVLZXksIGNoaWxkQ29tcG9uZW50RGlyLCBjaGlsZFZpZXdEaXJlY3RpdmVzLCBjb21waWxpbmdDb21wb25lbnRDYWNoZUtleXMpO1xuICAgICAgICAgIGlmICghY2hpbGRJc1JlY3Vyc2l2ZSkge1xuICAgICAgICAgICAgLy8gT25seSB3YWl0IGZvciBhIGNoaWxkIGlmIGl0IGlzIG5vdCBhIGN5Y2xlXG4gICAgICAgICAgICBjaGlsZFByb21pc2VzLnB1c2godGhpcy5fY29tcGlsZWRUZW1wbGF0ZURvbmUuZ2V0KGNoaWxkQ2FjaGVLZXkpKTtcbiAgICAgICAgICB9XG4gICAgICAgICAgcmV0dXJuICgpID0+IGNoaWxkVGVtcGxhdGU7XG4gICAgICAgIH0pO1xuICAgIGNtZHMuZm9yRWFjaChjbWQgPT4ge1xuICAgICAgaWYgKGNtZCBpbnN0YW5jZW9mIEJlZ2luQ29tcG9uZW50Q21kKSB7XG4gICAgICAgIGNtZC50ZW1wbGF0ZUdldHRlcigpO1xuICAgICAgfVxuICAgIH0pO1xuICAgIHJldHVybiBjbWRzO1xuICB9XG5cbiAgY29tcGlsZVRlbXBsYXRlc0NvZGVHZW4oY29tcG9uZW50czogTm9ybWFsaXplZENvbXBvbmVudFdpdGhWaWV3RGlyZWN0aXZlc1tdKTogU291cmNlTW9kdWxlIHtcbiAgICBpZiAoY29tcG9uZW50cy5sZW5ndGggPT09IDApIHtcbiAgICAgIHRocm93IG5ldyBCYXNlRXhjZXB0aW9uKCdObyBjb21wb25lbnRzIGdpdmVuJyk7XG4gICAgfVxuICAgIHZhciBkZWNsYXJhdGlvbnMgPSBbXTtcbiAgICB2YXIgdGVtcGxhdGVBcmd1bWVudHMgPSBbXTtcbiAgICB2YXIgY29tcG9uZW50TWV0YXM6IENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YVtdID0gW107XG4gICAgY29tcG9uZW50cy5mb3JFYWNoKGNvbXBvbmVudFdpdGhEaXJzID0+IHtcbiAgICAgIHZhciBjb21wTWV0YSA9IDxDb21waWxlRGlyZWN0aXZlTWV0YWRhdGE+Y29tcG9uZW50V2l0aERpcnMuY29tcG9uZW50O1xuICAgICAgYXNzZXJ0Q29tcG9uZW50KGNvbXBNZXRhKTtcbiAgICAgIGNvbXBvbmVudE1ldGFzLnB1c2goY29tcE1ldGEpO1xuXG4gICAgICB0aGlzLl9wcm9jZXNzVGVtcGxhdGVDb2RlR2VuKGNvbXBNZXRhLCBjb21wb25lbnRXaXRoRGlycy5kaXJlY3RpdmVzLCBkZWNsYXJhdGlvbnMsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRlbXBsYXRlQXJndW1lbnRzKTtcbiAgICAgIGlmIChjb21wTWV0YS5keW5hbWljTG9hZGFibGUpIHtcbiAgICAgICAgdmFyIGhvc3RNZXRhID0gY3JlYXRlSG9zdENvbXBvbmVudE1ldGEoY29tcE1ldGEudHlwZSwgY29tcE1ldGEuc2VsZWN0b3IpO1xuICAgICAgICBjb21wb25lbnRNZXRhcy5wdXNoKGhvc3RNZXRhKTtcbiAgICAgICAgdGhpcy5fcHJvY2Vzc1RlbXBsYXRlQ29kZUdlbihob3N0TWV0YSwgW2NvbXBNZXRhXSwgZGVjbGFyYXRpb25zLCB0ZW1wbGF0ZUFyZ3VtZW50cyk7XG4gICAgICB9XG4gICAgfSk7XG4gICAgTGlzdFdyYXBwZXIuZm9yRWFjaFdpdGhJbmRleChjb21wb25lbnRNZXRhcywgKGNvbXBNZXRhOiBDb21waWxlRGlyZWN0aXZlTWV0YWRhdGEsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGluZGV4OiBudW1iZXIpID0+IHtcbiAgICAgIHZhciB0ZW1wbGF0ZUlkID0gYCR7Y29tcE1ldGEudHlwZS5tb2R1bGVVcmx9fCR7Y29tcE1ldGEudHlwZS5uYW1lfWA7XG4gICAgICB2YXIgY29uc3RydWN0aW9uS2V5d29yZCA9IElTX0RBUlQgPyAnY29uc3QnIDogJ25ldyc7XG4gICAgICB2YXIgY29tcGlsZWRUZW1wbGF0ZUV4cHIgPVxuICAgICAgICAgIGAke2NvbnN0cnVjdGlvbktleXdvcmR9ICR7VEVNUExBVEVfQ09NTUFORFNfTU9EVUxFX1JFRn1Db21waWxlZENvbXBvbmVudFRlbXBsYXRlKCcke3RlbXBsYXRlSWR9Jywkeyg8YW55W10+dGVtcGxhdGVBcmd1bWVudHNbaW5kZXhdKS5qb2luKCcsJyl9KWA7XG4gICAgICB2YXIgdmFyaWFibGVWYWx1ZUV4cHI7XG4gICAgICBpZiAoY29tcE1ldGEudHlwZS5pc0hvc3QpIHtcbiAgICAgICAgdmFyaWFibGVWYWx1ZUV4cHIgPVxuICAgICAgICAgICAgYCR7Y29uc3RydWN0aW9uS2V5d29yZH0gJHtURU1QTEFURV9DT01NQU5EU19NT0RVTEVfUkVGfUNvbXBpbGVkSG9zdFRlbXBsYXRlKCR7Y29tcGlsZWRUZW1wbGF0ZUV4cHJ9KWA7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICB2YXJpYWJsZVZhbHVlRXhwciA9IGNvbXBpbGVkVGVtcGxhdGVFeHByO1xuICAgICAgfVxuICAgICAgdmFyIHZhck5hbWUgPSB0ZW1wbGF0ZVZhcmlhYmxlTmFtZShjb21wTWV0YS50eXBlKTtcbiAgICAgIGRlY2xhcmF0aW9ucy5wdXNoKGAke2NvZGVHZW5FeHBvcnRWYXJpYWJsZSh2YXJOYW1lKX0ke3ZhcmlhYmxlVmFsdWVFeHByfTtgKTtcbiAgICAgIGRlY2xhcmF0aW9ucy5wdXNoKGAke2NvZGVHZW5WYWx1ZUZuKFtdLCB2YXJOYW1lLCB0ZW1wbGF0ZUdldHRlck5hbWUoY29tcE1ldGEudHlwZSkpfTtgKTtcbiAgICB9KTtcbiAgICB2YXIgbW9kdWxlVXJsID0gY29tcG9uZW50c1swXS5jb21wb25lbnQudHlwZS5tb2R1bGVVcmw7XG4gICAgcmV0dXJuIG5ldyBTb3VyY2VNb2R1bGUoYCR7dGVtcGxhdGVNb2R1bGVVcmwobW9kdWxlVXJsKX1gLCBkZWNsYXJhdGlvbnMuam9pbignXFxuJykpO1xuICB9XG5cbiAgY29tcGlsZVN0eWxlc2hlZXRDb2RlR2VuKHN0eWxlc2hlZXRVcmw6IHN0cmluZywgY3NzVGV4dDogc3RyaW5nKTogU291cmNlTW9kdWxlW10ge1xuICAgIHJldHVybiB0aGlzLl9zdHlsZUNvbXBpbGVyLmNvbXBpbGVTdHlsZXNoZWV0Q29kZUdlbihzdHlsZXNoZWV0VXJsLCBjc3NUZXh0KTtcbiAgfVxuXG4gIHByaXZhdGUgX3Byb2Nlc3NUZW1wbGF0ZUNvZGVHZW4oY29tcE1ldGE6IENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBkaXJlY3RpdmVzOiBDb21waWxlRGlyZWN0aXZlTWV0YWRhdGFbXSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0YXJnZXREZWNsYXJhdGlvbnM6IHN0cmluZ1tdLCB0YXJnZXRUZW1wbGF0ZUFyZ3VtZW50czogYW55W11bXSkge1xuICAgIGxldCB1bmlxdWVEaXJlY3RpdmVzID0gcmVtb3ZlRHVwbGljYXRlcyhkaXJlY3RpdmVzKTtcbiAgICB2YXIgc3R5bGVFeHByID0gdGhpcy5fc3R5bGVDb21waWxlci5jb21waWxlQ29tcG9uZW50Q29kZUdlbihjb21wTWV0YS50ZW1wbGF0ZSk7XG4gICAgdmFyIHBhcnNlZFRlbXBsYXRlID0gdGhpcy5fdGVtcGxhdGVQYXJzZXIucGFyc2UoY29tcE1ldGEudGVtcGxhdGUudGVtcGxhdGUsIHVuaXF1ZURpcmVjdGl2ZXMsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY29tcE1ldGEudHlwZS5uYW1lKTtcbiAgICB2YXIgY2hhbmdlRGV0ZWN0b3JzRXhwcnMgPSB0aGlzLl9jZENvbXBpbGVyLmNvbXBpbGVDb21wb25lbnRDb2RlR2VuKFxuICAgICAgICBjb21wTWV0YS50eXBlLCBjb21wTWV0YS5jaGFuZ2VEZXRlY3Rpb24sIHBhcnNlZFRlbXBsYXRlKTtcbiAgICB2YXIgY29tbWFuZHNFeHByID0gdGhpcy5fY29tbWFuZENvbXBpbGVyLmNvbXBpbGVDb21wb25lbnRDb2RlR2VuKFxuICAgICAgICBjb21wTWV0YSwgcGFyc2VkVGVtcGxhdGUsIGNoYW5nZURldGVjdG9yc0V4cHJzLmV4cHJlc3Npb25zLFxuICAgICAgICBjb2RlR2VuQ29tcG9uZW50VGVtcGxhdGVGYWN0b3J5KTtcblxuICAgIGFkZEFsbChzdHlsZUV4cHIuZGVjbGFyYXRpb25zLCB0YXJnZXREZWNsYXJhdGlvbnMpO1xuICAgIGFkZEFsbChjaGFuZ2VEZXRlY3RvcnNFeHBycy5kZWNsYXJhdGlvbnMsIHRhcmdldERlY2xhcmF0aW9ucyk7XG4gICAgYWRkQWxsKGNvbW1hbmRzRXhwci5kZWNsYXJhdGlvbnMsIHRhcmdldERlY2xhcmF0aW9ucyk7XG5cbiAgICB0YXJnZXRUZW1wbGF0ZUFyZ3VtZW50cy5wdXNoKFxuICAgICAgICBbY2hhbmdlRGV0ZWN0b3JzRXhwcnMuZXhwcmVzc2lvbnNbMF0sIGNvbW1hbmRzRXhwci5leHByZXNzaW9uLCBzdHlsZUV4cHIuZXhwcmVzc2lvbl0pO1xuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBOb3JtYWxpemVkQ29tcG9uZW50V2l0aFZpZXdEaXJlY3RpdmVzIHtcbiAgY29uc3RydWN0b3IocHVibGljIGNvbXBvbmVudDogQ29tcGlsZURpcmVjdGl2ZU1ldGFkYXRhLFxuICAgICAgICAgICAgICBwdWJsaWMgZGlyZWN0aXZlczogQ29tcGlsZURpcmVjdGl2ZU1ldGFkYXRhW10pIHt9XG59XG5cbmZ1bmN0aW9uIGFzc2VydENvbXBvbmVudChtZXRhOiBDb21waWxlRGlyZWN0aXZlTWV0YWRhdGEpIHtcbiAgaWYgKCFtZXRhLmlzQ29tcG9uZW50KSB7XG4gICAgdGhyb3cgbmV3IEJhc2VFeGNlcHRpb24oYENvdWxkIG5vdCBjb21waWxlICcke21ldGEudHlwZS5uYW1lfScgYmVjYXVzZSBpdCBpcyBub3QgYSBjb21wb25lbnQuYCk7XG4gIH1cbn1cblxuZnVuY3Rpb24gdGVtcGxhdGVWYXJpYWJsZU5hbWUodHlwZTogQ29tcGlsZVR5cGVNZXRhZGF0YSk6IHN0cmluZyB7XG4gIHJldHVybiBgJHt0eXBlLm5hbWV9VGVtcGxhdGVgO1xufVxuXG5mdW5jdGlvbiB0ZW1wbGF0ZUdldHRlck5hbWUodHlwZTogQ29tcGlsZVR5cGVNZXRhZGF0YSk6IHN0cmluZyB7XG4gIHJldHVybiBgJHt0ZW1wbGF0ZVZhcmlhYmxlTmFtZSh0eXBlKX1HZXR0ZXJgO1xufVxuXG5mdW5jdGlvbiB0ZW1wbGF0ZU1vZHVsZVVybChtb2R1bGVVcmw6IHN0cmluZyk6IHN0cmluZyB7XG4gIHZhciB1cmxXaXRob3V0U3VmZml4ID0gbW9kdWxlVXJsLnN1YnN0cmluZygwLCBtb2R1bGVVcmwubGVuZ3RoIC0gTU9EVUxFX1NVRkZJWC5sZW5ndGgpO1xuICByZXR1cm4gYCR7dXJsV2l0aG91dFN1ZmZpeH0udGVtcGxhdGUke01PRFVMRV9TVUZGSVh9YDtcbn1cblxuZnVuY3Rpb24gYWRkQWxsKHNvdXJjZTogYW55W10sIHRhcmdldDogYW55W10pIHtcbiAgZm9yICh2YXIgaSA9IDA7IGkgPCBzb3VyY2UubGVuZ3RoOyBpKyspIHtcbiAgICB0YXJnZXQucHVzaChzb3VyY2VbaV0pO1xuICB9XG59XG5cbmZ1bmN0aW9uIGNvZGVHZW5Db21wb25lbnRUZW1wbGF0ZUZhY3RvcnkobmVzdGVkQ29tcFR5cGU6IENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YSk6IHN0cmluZyB7XG4gIHJldHVybiBgJHttb2R1bGVSZWYodGVtcGxhdGVNb2R1bGVVcmwobmVzdGVkQ29tcFR5cGUudHlwZS5tb2R1bGVVcmwpKX0ke3RlbXBsYXRlR2V0dGVyTmFtZShuZXN0ZWRDb21wVHlwZS50eXBlKX1gO1xufVxuXG5mdW5jdGlvbiByZW1vdmVEdXBsaWNhdGVzKGl0ZW1zOiBDb21waWxlRGlyZWN0aXZlTWV0YWRhdGFbXSk6IENvbXBpbGVEaXJlY3RpdmVNZXRhZGF0YVtdIHtcbiAgbGV0IHJlcyA9IFtdO1xuICBpdGVtcy5mb3JFYWNoKGl0ZW0gPT4ge1xuICAgIGxldCBoYXNNYXRjaCA9XG4gICAgICAgIHJlcy5maWx0ZXIociA9PiByLnR5cGUubmFtZSA9PSBpdGVtLnR5cGUubmFtZSAmJiByLnR5cGUubW9kdWxlVXJsID09IGl0ZW0udHlwZS5tb2R1bGVVcmwgJiZcbiAgICAgICAgICAgICAgICAgICAgICAgIHIudHlwZS5ydW50aW1lID09IGl0ZW0udHlwZS5ydW50aW1lKVxuICAgICAgICAgICAgLmxlbmd0aCA+IDA7XG4gICAgaWYgKCFoYXNNYXRjaCkge1xuICAgICAgcmVzLnB1c2goaXRlbSk7XG4gICAgfVxuICB9KTtcbiAgcmV0dXJuIHJlcztcbn1cbiJdfQ==