var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { MapWrapper, StringMapWrapper } from 'angular2/src/facade/collection';
import { stringify, looseIdentical, isJsObject, CONST, isBlank } from 'angular2/src/facade/lang';
import { BaseException } from 'angular2/src/facade/exceptions';
export let DefaultKeyValueDifferFactory = class {
    supports(obj) { return obj instanceof Map || isJsObject(obj); }
    create(cdRef) { return new DefaultKeyValueDiffer(); }
};
DefaultKeyValueDifferFactory = __decorate([
    CONST(), 
    __metadata('design:paramtypes', [])
], DefaultKeyValueDifferFactory);
export class DefaultKeyValueDiffer {
    constructor() {
        this._records = new Map();
        this._mapHead = null;
        this._previousMapHead = null;
        this._changesHead = null;
        this._changesTail = null;
        this._additionsHead = null;
        this._additionsTail = null;
        this._removalsHead = null;
        this._removalsTail = null;
    }
    get isDirty() {
        return this._additionsHead !== null || this._changesHead !== null ||
            this._removalsHead !== null;
    }
    forEachItem(fn) {
        var record;
        for (record = this._mapHead; record !== null; record = record._next) {
            fn(record);
        }
    }
    forEachPreviousItem(fn) {
        var record;
        for (record = this._previousMapHead; record !== null; record = record._nextPrevious) {
            fn(record);
        }
    }
    forEachChangedItem(fn) {
        var record;
        for (record = this._changesHead; record !== null; record = record._nextChanged) {
            fn(record);
        }
    }
    forEachAddedItem(fn) {
        var record;
        for (record = this._additionsHead; record !== null; record = record._nextAdded) {
            fn(record);
        }
    }
    forEachRemovedItem(fn) {
        var record;
        for (record = this._removalsHead; record !== null; record = record._nextRemoved) {
            fn(record);
        }
    }
    diff(map) {
        if (isBlank(map))
            map = MapWrapper.createFromPairs([]);
        if (!(map instanceof Map || isJsObject(map))) {
            throw new BaseException(`Error trying to diff '${map}'`);
        }
        if (this.check(map)) {
            return this;
        }
        else {
            return null;
        }
    }
    onDestroy() { }
    check(map) {
        this._reset();
        var records = this._records;
        var oldSeqRecord = this._mapHead;
        var lastOldSeqRecord = null;
        var lastNewSeqRecord = null;
        var seqChanged = false;
        this._forEach(map, (value, key) => {
            var newSeqRecord;
            if (oldSeqRecord !== null && key === oldSeqRecord.key) {
                newSeqRecord = oldSeqRecord;
                if (!looseIdentical(value, oldSeqRecord.currentValue)) {
                    oldSeqRecord.previousValue = oldSeqRecord.currentValue;
                    oldSeqRecord.currentValue = value;
                    this._addToChanges(oldSeqRecord);
                }
            }
            else {
                seqChanged = true;
                if (oldSeqRecord !== null) {
                    oldSeqRecord._next = null;
                    this._removeFromSeq(lastOldSeqRecord, oldSeqRecord);
                    this._addToRemovals(oldSeqRecord);
                }
                if (records.has(key)) {
                    newSeqRecord = records.get(key);
                }
                else {
                    newSeqRecord = new KVChangeRecord(key);
                    records.set(key, newSeqRecord);
                    newSeqRecord.currentValue = value;
                    this._addToAdditions(newSeqRecord);
                }
            }
            if (seqChanged) {
                if (this._isInRemovals(newSeqRecord)) {
                    this._removeFromRemovals(newSeqRecord);
                }
                if (lastNewSeqRecord == null) {
                    this._mapHead = newSeqRecord;
                }
                else {
                    lastNewSeqRecord._next = newSeqRecord;
                }
            }
            lastOldSeqRecord = oldSeqRecord;
            lastNewSeqRecord = newSeqRecord;
            oldSeqRecord = oldSeqRecord === null ? null : oldSeqRecord._next;
        });
        this._truncate(lastOldSeqRecord, oldSeqRecord);
        return this.isDirty;
    }
    /** @internal */
    _reset() {
        if (this.isDirty) {
            var record;
            // Record the state of the mapping
            for (record = this._previousMapHead = this._mapHead; record !== null; record = record._next) {
                record._nextPrevious = record._next;
            }
            for (record = this._changesHead; record !== null; record = record._nextChanged) {
                record.previousValue = record.currentValue;
            }
            for (record = this._additionsHead; record != null; record = record._nextAdded) {
                record.previousValue = record.currentValue;
            }
            // todo(vicb) once assert is supported
            // assert(() {
            //  var r = _changesHead;
            //  while (r != null) {
            //    var nextRecord = r._nextChanged;
            //    r._nextChanged = null;
            //    r = nextRecord;
            //  }
            //
            //  r = _additionsHead;
            //  while (r != null) {
            //    var nextRecord = r._nextAdded;
            //    r._nextAdded = null;
            //    r = nextRecord;
            //  }
            //
            //  r = _removalsHead;
            //  while (r != null) {
            //    var nextRecord = r._nextRemoved;
            //    r._nextRemoved = null;
            //    r = nextRecord;
            //  }
            //
            //  return true;
            //});
            this._changesHead = this._changesTail = null;
            this._additionsHead = this._additionsTail = null;
            this._removalsHead = this._removalsTail = null;
        }
    }
    /** @internal */
    _truncate(lastRecord, record) {
        while (record !== null) {
            if (lastRecord === null) {
                this._mapHead = null;
            }
            else {
                lastRecord._next = null;
            }
            var nextRecord = record._next;
            // todo(vicb) assert
            // assert((() {
            //  record._next = null;
            //  return true;
            //}));
            this._addToRemovals(record);
            lastRecord = record;
            record = nextRecord;
        }
        for (var rec = this._removalsHead; rec !== null; rec = rec._nextRemoved) {
            rec.previousValue = rec.currentValue;
            rec.currentValue = null;
            this._records.delete(rec.key);
        }
    }
    /** @internal */
    _isInRemovals(record) {
        return record === this._removalsHead || record._nextRemoved !== null ||
            record._prevRemoved !== null;
    }
    /** @internal */
    _addToRemovals(record) {
        // todo(vicb) assert
        // assert(record._next == null);
        // assert(record._nextAdded == null);
        // assert(record._nextChanged == null);
        // assert(record._nextRemoved == null);
        // assert(record._prevRemoved == null);
        if (this._removalsHead === null) {
            this._removalsHead = this._removalsTail = record;
        }
        else {
            this._removalsTail._nextRemoved = record;
            record._prevRemoved = this._removalsTail;
            this._removalsTail = record;
        }
    }
    /** @internal */
    _removeFromSeq(prev, record) {
        var next = record._next;
        if (prev === null) {
            this._mapHead = next;
        }
        else {
            prev._next = next;
        }
        // todo(vicb) assert
        // assert((() {
        //  record._next = null;
        //  return true;
        //})());
    }
    /** @internal */
    _removeFromRemovals(record) {
        // todo(vicb) assert
        // assert(record._next == null);
        // assert(record._nextAdded == null);
        // assert(record._nextChanged == null);
        var prev = record._prevRemoved;
        var next = record._nextRemoved;
        if (prev === null) {
            this._removalsHead = next;
        }
        else {
            prev._nextRemoved = next;
        }
        if (next === null) {
            this._removalsTail = prev;
        }
        else {
            next._prevRemoved = prev;
        }
        record._prevRemoved = record._nextRemoved = null;
    }
    /** @internal */
    _addToAdditions(record) {
        // todo(vicb): assert
        // assert(record._next == null);
        // assert(record._nextAdded == null);
        // assert(record._nextChanged == null);
        // assert(record._nextRemoved == null);
        // assert(record._prevRemoved == null);
        if (this._additionsHead === null) {
            this._additionsHead = this._additionsTail = record;
        }
        else {
            this._additionsTail._nextAdded = record;
            this._additionsTail = record;
        }
    }
    /** @internal */
    _addToChanges(record) {
        // todo(vicb) assert
        // assert(record._nextAdded == null);
        // assert(record._nextChanged == null);
        // assert(record._nextRemoved == null);
        // assert(record._prevRemoved == null);
        if (this._changesHead === null) {
            this._changesHead = this._changesTail = record;
        }
        else {
            this._changesTail._nextChanged = record;
            this._changesTail = record;
        }
    }
    toString() {
        var items = [];
        var previous = [];
        var changes = [];
        var additions = [];
        var removals = [];
        var record;
        for (record = this._mapHead; record !== null; record = record._next) {
            items.push(stringify(record));
        }
        for (record = this._previousMapHead; record !== null; record = record._nextPrevious) {
            previous.push(stringify(record));
        }
        for (record = this._changesHead; record !== null; record = record._nextChanged) {
            changes.push(stringify(record));
        }
        for (record = this._additionsHead; record !== null; record = record._nextAdded) {
            additions.push(stringify(record));
        }
        for (record = this._removalsHead; record !== null; record = record._nextRemoved) {
            removals.push(stringify(record));
        }
        return "map: " + items.join(', ') + "\n" + "previous: " + previous.join(', ') + "\n" +
            "additions: " + additions.join(', ') + "\n" + "changes: " + changes.join(', ') + "\n" +
            "removals: " + removals.join(', ') + "\n";
    }
    /** @internal */
    _forEach(obj, fn) {
        if (obj instanceof Map) {
            obj.forEach(fn);
        }
        else {
            StringMapWrapper.forEach(obj, fn);
        }
    }
}
export class KVChangeRecord {
    constructor(key) {
        this.key = key;
        this.previousValue = null;
        this.currentValue = null;
        /** @internal */
        this._nextPrevious = null;
        /** @internal */
        this._next = null;
        /** @internal */
        this._nextAdded = null;
        /** @internal */
        this._nextRemoved = null;
        /** @internal */
        this._prevRemoved = null;
        /** @internal */
        this._nextChanged = null;
    }
    toString() {
        return looseIdentical(this.previousValue, this.currentValue) ?
            stringify(this.key) :
            (stringify(this.key) + '[' + stringify(this.previousValue) + '->' +
                stringify(this.currentValue) + ']');
    }
}
//# sourceMappingURL=data:application/json;base64,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