var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { isPresent, isBlank, isArray, isNumber } from 'angular2/src/facade/lang';
import { RenderComponentTemplate } from 'angular2/src/core/render/api';
import { Optional, Injectable, resolveForwardRef, Inject } from 'angular2/src/core/di';
import { PipeProvider } from '../pipes/pipe_provider';
import { ProtoPipes } from '../pipes/pipes';
import { AppProtoView, AppProtoViewMergeInfo, ViewType } from './view';
import { ElementBinder } from './element_binder';
import { ProtoElementInjector, DirectiveProvider } from './element_injector';
import { DirectiveResolver } from './directive_resolver';
import { ViewResolver } from './view_resolver';
import { PipeResolver } from './pipe_resolver';
import { ViewEncapsulation } from '../metadata/view';
import { PLATFORM_PIPES } from 'angular2/src/core/platform_directives_and_pipes';
import { visitAllCommands, EmbeddedTemplateCmd, BeginComponentCmd } from './template_commands';
import { Renderer } from 'angular2/src/core/render/api';
import { APP_ID } from 'angular2/src/core/application_tokens';
export let ProtoViewFactory = class {
    constructor(_renderer, _platformPipes, _directiveResolver, _viewResolver, _pipeResolver, _appId) {
        this._renderer = _renderer;
        this._platformPipes = _platformPipes;
        this._directiveResolver = _directiveResolver;
        this._viewResolver = _viewResolver;
        this._pipeResolver = _pipeResolver;
        this._appId = _appId;
        this._cache = new Map();
        this._nextTemplateId = 0;
    }
    clearCache() { this._cache.clear(); }
    createHost(compiledHostTemplate) {
        var compiledTemplate = compiledHostTemplate.template;
        var result = this._cache.get(compiledTemplate.id);
        if (isBlank(result)) {
            var emptyMap = {};
            var shortId = `${this._appId}-${this._nextTemplateId++}`;
            this._renderer.registerComponentTemplate(new RenderComponentTemplate(compiledTemplate.id, shortId, ViewEncapsulation.None, compiledTemplate.commands, []));
            result =
                new AppProtoView(compiledTemplate.id, compiledTemplate.commands, ViewType.HOST, true, compiledTemplate.changeDetectorFactory, null, new ProtoPipes(emptyMap));
            this._cache.set(compiledTemplate.id, result);
        }
        return result;
    }
    _createComponent(cmd) {
        var nestedProtoView = this._cache.get(cmd.templateId);
        if (isBlank(nestedProtoView)) {
            var component = cmd.directives[0];
            var view = this._viewResolver.resolve(component);
            var compiledTemplate = cmd.templateGetter();
            var styles = _flattenStyleArr(compiledTemplate.styles, []);
            var shortId = `${this._appId}-${this._nextTemplateId++}`;
            this._renderer.registerComponentTemplate(new RenderComponentTemplate(compiledTemplate.id, shortId, cmd.encapsulation, compiledTemplate.commands, styles));
            var boundPipes = this._flattenPipes(view).map(pipe => this._bindPipe(pipe));
            nestedProtoView = new AppProtoView(compiledTemplate.id, compiledTemplate.commands, ViewType.COMPONENT, true, compiledTemplate.changeDetectorFactory, null, ProtoPipes.fromProviders(boundPipes));
            // Note: The cache is updated before recursing
            // to be able to resolve cycles
            this._cache.set(compiledTemplate.id, nestedProtoView);
            this._initializeProtoView(nestedProtoView, null);
        }
        return nestedProtoView;
    }
    _createEmbeddedTemplate(cmd, parent) {
        var nestedProtoView = new AppProtoView(parent.templateId, cmd.children, ViewType.EMBEDDED, cmd.isMerged, cmd.changeDetectorFactory, arrayToMap(cmd.variableNameAndValues, true), new ProtoPipes(parent.pipes.config));
        if (cmd.isMerged) {
            this.initializeProtoViewIfNeeded(nestedProtoView);
        }
        return nestedProtoView;
    }
    initializeProtoViewIfNeeded(protoView) {
        if (!protoView.isInitialized()) {
            var render = this._renderer.createProtoView(protoView.templateId, protoView.templateCmds);
            this._initializeProtoView(protoView, render);
        }
    }
    _initializeProtoView(protoView, render) {
        var initializer = new _ProtoViewInitializer(protoView, this._directiveResolver, this);
        visitAllCommands(initializer, protoView.templateCmds);
        var mergeInfo = new AppProtoViewMergeInfo(initializer.mergeEmbeddedViewCount, initializer.mergeElementCount, initializer.mergeViewCount);
        protoView.init(render, initializer.elementBinders, initializer.boundTextCount, mergeInfo, initializer.variableLocations);
    }
    _bindPipe(typeOrProvider) {
        let meta = this._pipeResolver.resolve(typeOrProvider);
        return PipeProvider.createFromType(typeOrProvider, meta);
    }
    _flattenPipes(view) {
        let pipes = [];
        if (isPresent(this._platformPipes)) {
            _flattenArray(this._platformPipes, pipes);
        }
        if (isPresent(view.pipes)) {
            _flattenArray(view.pipes, pipes);
        }
        return pipes;
    }
};
ProtoViewFactory = __decorate([
    Injectable(),
    __param(1, Optional()),
    __param(1, Inject(PLATFORM_PIPES)),
    __param(5, Inject(APP_ID)), 
    __metadata('design:paramtypes', [Renderer, Array, DirectiveResolver, ViewResolver, PipeResolver, String])
], ProtoViewFactory);
function createComponent(protoViewFactory, cmd) {
    return protoViewFactory._createComponent(cmd);
}
function createEmbeddedTemplate(protoViewFactory, cmd, parent) {
    return protoViewFactory._createEmbeddedTemplate(cmd, parent);
}
class _ProtoViewInitializer {
    constructor(_protoView, _directiveResolver, _protoViewFactory) {
        this._protoView = _protoView;
        this._directiveResolver = _directiveResolver;
        this._protoViewFactory = _protoViewFactory;
        this.variableLocations = new Map();
        this.boundTextCount = 0;
        this.boundElementIndex = 0;
        this.elementBinderStack = [];
        this.distanceToParentElementBinder = 0;
        this.distanceToParentProtoElementInjector = 0;
        this.elementBinders = [];
        this.mergeEmbeddedViewCount = 0;
        this.mergeElementCount = 0;
        this.mergeViewCount = 1;
    }
    visitText(cmd, context) {
        if (cmd.isBound) {
            this.boundTextCount++;
        }
        return null;
    }
    visitNgContent(cmd, context) { return null; }
    visitBeginElement(cmd, context) {
        if (cmd.isBound) {
            this._visitBeginBoundElement(cmd, null);
        }
        else {
            this._visitBeginElement(cmd, null, null);
        }
        return null;
    }
    visitEndElement(context) { return this._visitEndElement(); }
    visitBeginComponent(cmd, context) {
        var nestedProtoView = createComponent(this._protoViewFactory, cmd);
        return this._visitBeginBoundElement(cmd, nestedProtoView);
    }
    visitEndComponent(context) { return this._visitEndElement(); }
    visitEmbeddedTemplate(cmd, context) {
        var nestedProtoView = createEmbeddedTemplate(this._protoViewFactory, cmd, this._protoView);
        if (cmd.isMerged) {
            this.mergeEmbeddedViewCount++;
        }
        this._visitBeginBoundElement(cmd, nestedProtoView);
        return this._visitEndElement();
    }
    _visitBeginBoundElement(cmd, nestedProtoView) {
        if (isPresent(nestedProtoView) && nestedProtoView.isMergable) {
            this.mergeElementCount += nestedProtoView.mergeInfo.elementCount;
            this.mergeViewCount += nestedProtoView.mergeInfo.viewCount;
            this.mergeEmbeddedViewCount += nestedProtoView.mergeInfo.embeddedViewCount;
        }
        var elementBinder = _createElementBinder(this._directiveResolver, nestedProtoView, this.elementBinderStack, this.boundElementIndex, this.distanceToParentElementBinder, this.distanceToParentProtoElementInjector, cmd);
        this.elementBinders.push(elementBinder);
        var protoElementInjector = elementBinder.protoElementInjector;
        for (var i = 0; i < cmd.variableNameAndValues.length; i += 2) {
            this.variableLocations.set(cmd.variableNameAndValues[i], this.boundElementIndex);
        }
        this.boundElementIndex++;
        this.mergeElementCount++;
        return this._visitBeginElement(cmd, elementBinder, protoElementInjector);
    }
    _visitBeginElement(cmd, elementBinder, protoElementInjector) {
        this.distanceToParentElementBinder =
            isPresent(elementBinder) ? 1 : this.distanceToParentElementBinder + 1;
        this.distanceToParentProtoElementInjector =
            isPresent(protoElementInjector) ? 1 : this.distanceToParentProtoElementInjector + 1;
        this.elementBinderStack.push(elementBinder);
        return null;
    }
    _visitEndElement() {
        var parentElementBinder = this.elementBinderStack.pop();
        var parentProtoElementInjector = isPresent(parentElementBinder) ? parentElementBinder.protoElementInjector : null;
        this.distanceToParentElementBinder = isPresent(parentElementBinder) ?
            parentElementBinder.distanceToParent :
            this.distanceToParentElementBinder - 1;
        this.distanceToParentProtoElementInjector = isPresent(parentProtoElementInjector) ?
            parentProtoElementInjector.distanceToParent :
            this.distanceToParentProtoElementInjector - 1;
        return null;
    }
}
function _createElementBinder(directiveResolver, nestedProtoView, elementBinderStack, boundElementIndex, distanceToParentBinder, distanceToParentPei, beginElementCmd) {
    var parentElementBinder = null;
    var parentProtoElementInjector = null;
    if (distanceToParentBinder > 0) {
        parentElementBinder = elementBinderStack[elementBinderStack.length - distanceToParentBinder];
    }
    if (isBlank(parentElementBinder)) {
        distanceToParentBinder = -1;
    }
    if (distanceToParentPei > 0) {
        var peiBinder = elementBinderStack[elementBinderStack.length - distanceToParentPei];
        if (isPresent(peiBinder)) {
            parentProtoElementInjector = peiBinder.protoElementInjector;
        }
    }
    if (isBlank(parentProtoElementInjector)) {
        distanceToParentPei = -1;
    }
    var componentDirectiveProvider = null;
    var isEmbeddedTemplate = false;
    var directiveProviders = beginElementCmd.directives.map(type => provideDirective(directiveResolver, type));
    if (beginElementCmd instanceof BeginComponentCmd) {
        componentDirectiveProvider = directiveProviders[0];
    }
    else if (beginElementCmd instanceof EmbeddedTemplateCmd) {
        isEmbeddedTemplate = true;
    }
    var protoElementInjector = null;
    // Create a protoElementInjector for any element that either has bindings *or* has one
    // or more var- defined *or* for <template> elements:
    // - Elements with a var- defined need a their own element injector
    //   so that, when hydrating, $implicit can be set to the element.
    // - <template> elements need their own ElementInjector so that we can query their TemplateRef
    var hasVariables = beginElementCmd.variableNameAndValues.length > 0;
    if (directiveProviders.length > 0 || hasVariables || isEmbeddedTemplate) {
        var directiveVariableBindings = new Map();
        if (!isEmbeddedTemplate) {
            directiveVariableBindings = createDirectiveVariableBindings(beginElementCmd.variableNameAndValues, directiveProviders);
        }
        protoElementInjector = ProtoElementInjector.create(parentProtoElementInjector, boundElementIndex, directiveProviders, isPresent(componentDirectiveProvider), distanceToParentPei, directiveVariableBindings);
        protoElementInjector.attributes = arrayToMap(beginElementCmd.attrNameAndValues, false);
    }
    return new ElementBinder(boundElementIndex, parentElementBinder, distanceToParentBinder, protoElementInjector, componentDirectiveProvider, nestedProtoView);
}
function provideDirective(directiveResolver, type) {
    let annotation = directiveResolver.resolve(type);
    return DirectiveProvider.createFromType(type, annotation);
}
export function createDirectiveVariableBindings(variableNameAndValues, directiveProviders) {
    var directiveVariableBindings = new Map();
    for (var i = 0; i < variableNameAndValues.length; i += 2) {
        var templateName = variableNameAndValues[i];
        var dirIndex = variableNameAndValues[i + 1];
        if (isNumber(dirIndex)) {
            directiveVariableBindings.set(templateName, dirIndex);
        }
        else {
            // a variable without a directive index -> reference the element
            directiveVariableBindings.set(templateName, null);
        }
    }
    return directiveVariableBindings;
}
function arrayToMap(arr, inverse) {
    var result = new Map();
    for (var i = 0; i < arr.length; i += 2) {
        if (inverse) {
            result.set(arr[i + 1], arr[i]);
        }
        else {
            result.set(arr[i], arr[i + 1]);
        }
    }
    return result;
}
function _flattenArray(tree, out) {
    for (var i = 0; i < tree.length; i++) {
        var item = resolveForwardRef(tree[i]);
        if (isArray(item)) {
            _flattenArray(item, out);
        }
        else {
            out.push(item);
        }
    }
}
function _flattenStyleArr(arr, out) {
    for (var i = 0; i < arr.length; i++) {
        var entry = arr[i];
        if (isArray(entry)) {
            _flattenStyleArr(entry, out);
        }
        else {
            out.push(entry);
        }
    }
    return out;
}
//# sourceMappingURL=data:application/json;base64,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