var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Injector, Injectable } from 'angular2/src/core/di';
import { ListWrapper } from 'angular2/src/facade/collection';
import * as eli from './element_injector';
import { isPresent, isBlank } from 'angular2/src/facade/lang';
import * as viewModule from './view';
import { ElementRef_ } from './element_ref';
import { TemplateRef_ } from './template_ref';
import { Pipes } from 'angular2/src/core/pipes/pipes';
export let AppViewManagerUtils = class {
    constructor() {
    }
    getComponentInstance(parentView, boundElementIndex) {
        var eli = parentView.elementInjectors[boundElementIndex];
        return eli.getComponent();
    }
    createView(mergedParentViewProto, renderViewWithFragments, viewManager, renderer) {
        var renderFragments = renderViewWithFragments.fragmentRefs;
        var renderView = renderViewWithFragments.viewRef;
        var elementCount = mergedParentViewProto.mergeInfo.elementCount;
        var viewCount = mergedParentViewProto.mergeInfo.viewCount;
        var elementRefs = ListWrapper.createFixedSize(elementCount);
        var viewContainers = ListWrapper.createFixedSize(elementCount);
        var preBuiltObjects = ListWrapper.createFixedSize(elementCount);
        var elementInjectors = ListWrapper.createFixedSize(elementCount);
        var views = ListWrapper.createFixedSize(viewCount);
        var elementOffset = 0;
        var textOffset = 0;
        var fragmentIdx = 0;
        var containerElementIndicesByViewIndex = ListWrapper.createFixedSize(viewCount);
        for (var viewOffset = 0; viewOffset < viewCount; viewOffset++) {
            var containerElementIndex = containerElementIndicesByViewIndex[viewOffset];
            var containerElementInjector = isPresent(containerElementIndex) ? elementInjectors[containerElementIndex] : null;
            var parentView = isPresent(containerElementInjector) ? preBuiltObjects[containerElementIndex].view : null;
            var protoView = isPresent(containerElementIndex) ?
                parentView.proto.elementBinders[containerElementIndex - parentView.elementOffset]
                    .nestedProtoView :
                mergedParentViewProto;
            var renderFragment = null;
            if (viewOffset === 0 || protoView.type === viewModule.ViewType.EMBEDDED) {
                renderFragment = renderFragments[fragmentIdx++];
            }
            var currentView = new viewModule.AppView(renderer, protoView, viewOffset, elementOffset, textOffset, protoView.protoLocals, renderView, renderFragment, containerElementInjector);
            views[viewOffset] = currentView;
            if (isPresent(containerElementIndex)) {
                preBuiltObjects[containerElementIndex].nestedView = currentView;
            }
            var rootElementInjectors = [];
            var nestedViewOffset = viewOffset + 1;
            for (var binderIdx = 0; binderIdx < protoView.elementBinders.length; binderIdx++) {
                var binder = protoView.elementBinders[binderIdx];
                var boundElementIndex = elementOffset + binderIdx;
                var elementInjector = null;
                if (isPresent(binder.nestedProtoView) && binder.nestedProtoView.isMergable) {
                    containerElementIndicesByViewIndex[nestedViewOffset] = boundElementIndex;
                    nestedViewOffset += binder.nestedProtoView.mergeInfo.viewCount;
                }
                // elementInjectors and rootElementInjectors
                var protoElementInjector = binder.protoElementInjector;
                if (isPresent(protoElementInjector)) {
                    if (isPresent(protoElementInjector.parent)) {
                        var parentElementInjector = elementInjectors[elementOffset + protoElementInjector.parent.index];
                        elementInjector = protoElementInjector.instantiate(parentElementInjector);
                    }
                    else {
                        elementInjector = protoElementInjector.instantiate(null);
                        rootElementInjectors.push(elementInjector);
                    }
                }
                elementInjectors[boundElementIndex] = elementInjector;
                // elementRefs
                var el = new ElementRef_(currentView.ref, boundElementIndex, renderer);
                elementRefs[el.boundElementIndex] = el;
                // preBuiltObjects
                if (isPresent(elementInjector)) {
                    var templateRef = isPresent(binder.nestedProtoView) &&
                        binder.nestedProtoView.type === viewModule.ViewType.EMBEDDED ?
                        new TemplateRef_(el) :
                        null;
                    preBuiltObjects[boundElementIndex] =
                        new eli.PreBuiltObjects(viewManager, currentView, el, templateRef);
                }
            }
            currentView.init(protoView.changeDetectorFactory(currentView), elementInjectors, rootElementInjectors, preBuiltObjects, views, elementRefs, viewContainers);
            if (isPresent(parentView) && protoView.type === viewModule.ViewType.COMPONENT) {
                parentView.changeDetector.addViewChild(currentView.changeDetector);
            }
            elementOffset += protoView.elementBinders.length;
            textOffset += protoView.textBindingCount;
        }
        return views[0];
    }
    hydrateRootHostView(hostView, injector) {
        this._hydrateView(hostView, injector, null, new Object(), null);
    }
    // Misnomer: this method is attaching next to the view container.
    attachViewInContainer(parentView, boundElementIndex, contextView, contextBoundElementIndex, index, view) {
        if (isBlank(contextView)) {
            contextView = parentView;
            contextBoundElementIndex = boundElementIndex;
        }
        parentView.changeDetector.addContentChild(view.changeDetector);
        var viewContainer = parentView.viewContainers[boundElementIndex];
        if (isBlank(viewContainer)) {
            viewContainer = new viewModule.AppViewContainer();
            parentView.viewContainers[boundElementIndex] = viewContainer;
        }
        ListWrapper.insert(viewContainer.views, index, view);
        var elementInjector = contextView.elementInjectors[contextBoundElementIndex];
        for (var i = view.rootElementInjectors.length - 1; i >= 0; i--) {
            if (isPresent(elementInjector.parent)) {
                view.rootElementInjectors[i].link(elementInjector.parent);
            }
        }
        elementInjector.traverseAndSetQueriesAsDirty();
    }
    detachViewInContainer(parentView, boundElementIndex, index) {
        var viewContainer = parentView.viewContainers[boundElementIndex];
        var view = viewContainer.views[index];
        parentView.elementInjectors[boundElementIndex].traverseAndSetQueriesAsDirty();
        view.changeDetector.remove();
        ListWrapper.removeAt(viewContainer.views, index);
        for (var i = 0; i < view.rootElementInjectors.length; ++i) {
            var inj = view.rootElementInjectors[i];
            inj.unlink();
        }
    }
    hydrateViewInContainer(parentView, boundElementIndex, contextView, contextBoundElementIndex, index, imperativelyCreatedProviders) {
        if (isBlank(contextView)) {
            contextView = parentView;
            contextBoundElementIndex = boundElementIndex;
        }
        var viewContainer = parentView.viewContainers[boundElementIndex];
        var view = viewContainer.views[index];
        var elementInjector = contextView.elementInjectors[contextBoundElementIndex];
        var injector = isPresent(imperativelyCreatedProviders) ?
            Injector.fromResolvedProviders(imperativelyCreatedProviders) :
            null;
        this._hydrateView(view, injector, elementInjector.getHost(), contextView.context, contextView.locals);
    }
    /** @internal */
    _hydrateView(initView, imperativelyCreatedInjector, hostElementInjector, context, parentLocals) {
        var viewIdx = initView.viewOffset;
        var endViewOffset = viewIdx + initView.proto.mergeInfo.viewCount - 1;
        while (viewIdx <= endViewOffset) {
            var currView = initView.views[viewIdx];
            var currProtoView = currView.proto;
            if (currView !== initView && currView.proto.type === viewModule.ViewType.EMBEDDED) {
                // Don't hydrate components of embedded fragment views.
                viewIdx += currView.proto.mergeInfo.viewCount;
            }
            else {
                if (currView !== initView) {
                    // hydrate a nested component view
                    imperativelyCreatedInjector = null;
                    parentLocals = null;
                    hostElementInjector = currView.containerElementInjector;
                    context = hostElementInjector.getComponent();
                }
                currView.context = context;
                currView.locals.parent = parentLocals;
                var binders = currProtoView.elementBinders;
                for (var binderIdx = 0; binderIdx < binders.length; binderIdx++) {
                    var boundElementIndex = binderIdx + currView.elementOffset;
                    var elementInjector = initView.elementInjectors[boundElementIndex];
                    if (isPresent(elementInjector)) {
                        elementInjector.hydrate(imperativelyCreatedInjector, hostElementInjector, currView.preBuiltObjects[boundElementIndex]);
                        this._populateViewLocals(currView, elementInjector, boundElementIndex);
                        this._setUpEventEmitters(currView, elementInjector, boundElementIndex);
                    }
                }
                var pipes = isPresent(hostElementInjector) ?
                    new Pipes(currView.proto.pipes, hostElementInjector.getInjector()) :
                    null;
                currView.changeDetector.hydrate(currView.context, currView.locals, currView, pipes);
                viewIdx++;
            }
        }
    }
    /** @internal */
    _populateViewLocals(view, elementInjector, boundElementIdx) {
        if (isPresent(elementInjector.getDirectiveVariableBindings())) {
            elementInjector.getDirectiveVariableBindings().forEach((directiveIndex, name) => {
                if (isBlank(directiveIndex)) {
                    view.locals.set(name, view.elementRefs[boundElementIdx].nativeElement);
                }
                else {
                    view.locals.set(name, elementInjector.getDirectiveAtIndex(directiveIndex));
                }
            });
        }
    }
    /** @internal */
    _setUpEventEmitters(view, elementInjector, boundElementIndex) {
        var emitters = elementInjector.getEventEmitterAccessors();
        for (var directiveIndex = 0; directiveIndex < emitters.length; ++directiveIndex) {
            var directiveEmitters = emitters[directiveIndex];
            var directive = elementInjector.getDirectiveAtIndex(directiveIndex);
            for (var eventIndex = 0; eventIndex < directiveEmitters.length; ++eventIndex) {
                var eventEmitterAccessor = directiveEmitters[eventIndex];
                eventEmitterAccessor.subscribe(view, boundElementIndex, directive);
            }
        }
    }
    dehydrateView(initView) {
        var endViewOffset = initView.viewOffset + initView.proto.mergeInfo.viewCount - 1;
        for (var viewIdx = initView.viewOffset; viewIdx <= endViewOffset; viewIdx++) {
            var currView = initView.views[viewIdx];
            if (currView.hydrated()) {
                if (isPresent(currView.locals)) {
                    currView.locals.clearValues();
                }
                currView.context = null;
                currView.changeDetector.dehydrate();
                var binders = currView.proto.elementBinders;
                for (var binderIdx = 0; binderIdx < binders.length; binderIdx++) {
                    var eli = initView.elementInjectors[currView.elementOffset + binderIdx];
                    if (isPresent(eli)) {
                        eli.dehydrate();
                    }
                }
            }
        }
    }
};
AppViewManagerUtils = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [])
], AppViewManagerUtils);
//# sourceMappingURL=data:application/json;base64,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