import { DirectiveResolver } from 'angular2/angular2';
var COMPONENT_SELECTOR = /^[\w|-]*$/;
var SKEWER_CASE = /-(\w)/g;
var directiveResolver = new DirectiveResolver();
export function getComponentInfo(type) {
    var resolvedMetadata = directiveResolver.resolve(type);
    var selector = resolvedMetadata.selector;
    if (!selector.match(COMPONENT_SELECTOR)) {
        throw new Error('Only selectors matching element names are supported, got: ' + selector);
    }
    var selector = selector.replace(SKEWER_CASE, (all, letter) => letter.toUpperCase());
    return {
        type: type,
        selector: selector,
        inputs: parseFields(resolvedMetadata.inputs),
        outputs: parseFields(resolvedMetadata.outputs)
    };
}
export function parseFields(names) {
    var attrProps = [];
    if (names) {
        for (var i = 0; i < names.length; i++) {
            var parts = names[i].split(':');
            var prop = parts[0].trim();
            var attr = (parts[1] || parts[0]).trim();
            var capitalAttr = attr.charAt(0).toUpperCase() + attr.substr(1);
            attrProps.push({
                prop: prop,
                attr: attr,
                bracketAttr: `[${attr}]`,
                parenAttr: `(${attr})`,
                bracketParenAttr: `[(${attr})]`,
                onAttr: `on${capitalAttr}`,
                bindAttr: `bind${capitalAttr}`,
                bindonAttr: `bindon${capitalAttr}`
            });
        }
    }
    return attrProps;
}
//# sourceMappingURL=data:application/json;base64,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