var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { isArray, isPresent, serializeEnum } from "angular2/src/facade/lang";
import { BaseException } from 'angular2/src/facade/exceptions';
import { Map, StringMapWrapper, MapWrapper } from "angular2/src/facade/collection";
import { RenderProtoViewRef, RenderViewRef, RenderFragmentRef, RenderComponentTemplate } from "angular2/src/core/render/api";
import { WebWorkerElementRef, WebWorkerTemplateCmd, WebWorkerTextCmd, WebWorkerNgContentCmd, WebWorkerBeginElementCmd, WebWorkerEndElementCmd, WebWorkerBeginComponentCmd, WebWorkerEndComponentCmd, WebWorkerEmbeddedTemplateCmd } from 'angular2/src/web_workers/shared/api';
import { Injectable } from "angular2/src/core/di";
import { RenderProtoViewRefStore } from 'angular2/src/web_workers/shared/render_proto_view_ref_store';
import { RenderViewWithFragmentsStore } from 'angular2/src/web_workers/shared/render_view_with_fragments_store';
import { ViewEncapsulation, VIEW_ENCAPSULATION_VALUES } from 'angular2/src/core/metadata/view';
// PRIMITIVE is any type that does not need to be serialized (string, number, boolean)
// We set it to String so that it is considered a Type.
export const PRIMITIVE = String;
export let Serializer = class {
    constructor(_protoViewStore, _renderViewStore) {
        this._protoViewStore = _protoViewStore;
        this._renderViewStore = _renderViewStore;
    }
    serialize(obj, type) {
        if (!isPresent(obj)) {
            return null;
        }
        if (isArray(obj)) {
            return obj.map(v => this.serialize(v, type));
        }
        if (type == PRIMITIVE) {
            return obj;
        }
        if (type == RenderProtoViewRef) {
            return this._protoViewStore.serialize(obj);
        }
        else if (type == RenderViewRef) {
            return this._renderViewStore.serializeRenderViewRef(obj);
        }
        else if (type == RenderFragmentRef) {
            return this._renderViewStore.serializeRenderFragmentRef(obj);
        }
        else if (type == WebWorkerElementRef) {
            return this._serializeWorkerElementRef(obj);
        }
        else if (type == WebWorkerTemplateCmd) {
            return serializeTemplateCmd(obj);
        }
        else if (type === RenderComponentTemplate) {
            return this._serializeRenderTemplate(obj);
        }
        else if (type === ViewEncapsulation) {
            return serializeEnum(obj);
        }
        else {
            throw new BaseException("No serializer for " + type.toString());
        }
    }
    deserialize(map, type, data) {
        if (!isPresent(map)) {
            return null;
        }
        if (isArray(map)) {
            var obj = [];
            map.forEach(val => obj.push(this.deserialize(val, type, data)));
            return obj;
        }
        if (type == PRIMITIVE) {
            return map;
        }
        if (type == RenderProtoViewRef) {
            return this._protoViewStore.deserialize(map);
        }
        else if (type == RenderViewRef) {
            return this._renderViewStore.deserializeRenderViewRef(map);
        }
        else if (type == RenderFragmentRef) {
            return this._renderViewStore.deserializeRenderFragmentRef(map);
        }
        else if (type == WebWorkerElementRef) {
            return this._deserializeWorkerElementRef(map);
        }
        else if (type == WebWorkerTemplateCmd) {
            return deserializeTemplateCmd(map);
        }
        else if (type === RenderComponentTemplate) {
            return this._deserializeRenderTemplate(map);
        }
        else if (type === ViewEncapsulation) {
            return VIEW_ENCAPSULATION_VALUES[map];
        }
        else {
            throw new BaseException("No deserializer for " + type.toString());
        }
    }
    mapToObject(map, type) {
        var object = {};
        var serialize = isPresent(type);
        map.forEach((value, key) => {
            if (serialize) {
                object[key] = this.serialize(value, type);
            }
            else {
                object[key] = value;
            }
        });
        return object;
    }
    /*
     * Transforms a Javascript object (StringMap) into a Map<string, V>
     * If the values need to be deserialized pass in their type
     * and they will be deserialized before being placed in the map
     */
    objectToMap(obj, type, data) {
        if (isPresent(type)) {
            var map = new Map();
            StringMapWrapper.forEach(obj, (val, key) => { map.set(key, this.deserialize(val, type, data)); });
            return map;
        }
        else {
            return MapWrapper.createFromStringMap(obj);
        }
    }
    allocateRenderViews(fragmentCount) { this._renderViewStore.allocate(fragmentCount); }
    _serializeWorkerElementRef(elementRef) {
        return {
            'renderView': this.serialize(elementRef.renderView, RenderViewRef),
            'boundElementIndex': elementRef.boundElementIndex
        };
    }
    _deserializeWorkerElementRef(map) {
        return new WebWorkerElementRef(this.deserialize(map['renderView'], RenderViewRef), map['boundElementIndex']);
    }
    _serializeRenderTemplate(obj) {
        return {
            'id': obj.id,
            'shortId': obj.shortId,
            'encapsulation': this.serialize(obj.encapsulation, ViewEncapsulation),
            'commands': this.serialize(obj.commands, WebWorkerTemplateCmd),
            'styles': this.serialize(obj.styles, PRIMITIVE)
        };
    }
    _deserializeRenderTemplate(map) {
        return new RenderComponentTemplate(map['id'], map['shortId'], this.deserialize(map['encapsulation'], ViewEncapsulation), this.deserialize(map['commands'], WebWorkerTemplateCmd), this.deserialize(map['styles'], PRIMITIVE));
    }
};
Serializer = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [RenderProtoViewRefStore, RenderViewWithFragmentsStore])
], Serializer);
function serializeTemplateCmd(cmd) {
    return cmd.visit(RENDER_TEMPLATE_CMD_SERIALIZER, null);
}
function deserializeTemplateCmd(data) {
    return RENDER_TEMPLATE_CMD_DESERIALIZERS[data['deserializerIndex']](data);
}
class RenderTemplateCmdSerializer {
    visitText(cmd, context) {
        return {
            'deserializerIndex': 0,
            'isBound': cmd.isBound,
            'ngContentIndex': cmd.ngContentIndex,
            'value': cmd.value
        };
    }
    visitNgContent(cmd, context) {
        return { 'deserializerIndex': 1, 'index': cmd.index, 'ngContentIndex': cmd.ngContentIndex };
    }
    visitBeginElement(cmd, context) {
        return {
            'deserializerIndex': 2,
            'isBound': cmd.isBound,
            'ngContentIndex': cmd.ngContentIndex,
            'name': cmd.name,
            'attrNameAndValues': cmd.attrNameAndValues,
            'eventTargetAndNames': cmd.eventTargetAndNames
        };
    }
    visitEndElement(context) { return { 'deserializerIndex': 3 }; }
    visitBeginComponent(cmd, context) {
        return {
            'deserializerIndex': 4,
            'isBound': cmd.isBound,
            'ngContentIndex': cmd.ngContentIndex,
            'name': cmd.name,
            'attrNameAndValues': cmd.attrNameAndValues,
            'eventTargetAndNames': cmd.eventTargetAndNames,
            'templateId': cmd.templateId
        };
    }
    visitEndComponent(context) { return { 'deserializerIndex': 5 }; }
    visitEmbeddedTemplate(cmd, context) {
        var children = cmd.children.map(child => child.visit(this, null));
        return {
            'deserializerIndex': 6,
            'isBound': cmd.isBound,
            'ngContentIndex': cmd.ngContentIndex,
            'name': cmd.name,
            'attrNameAndValues': cmd.attrNameAndValues,
            'eventTargetAndNames': cmd.eventTargetAndNames,
            'isMerged': cmd.isMerged,
            'children': children
        };
    }
}
var RENDER_TEMPLATE_CMD_SERIALIZER = new RenderTemplateCmdSerializer();
var RENDER_TEMPLATE_CMD_DESERIALIZERS = [
        (data) => new WebWorkerTextCmd(data['isBound'], data['ngContentIndex'], data['value']),
        (data) => new WebWorkerNgContentCmd(data['index'], data['ngContentIndex']),
        (data) => new WebWorkerBeginElementCmd(data['isBound'], data['ngContentIndex'], data['name'], data['attrNameAndValues'], data['eventTargetAndNames']),
        (data) => new WebWorkerEndElementCmd(),
        (data) => new WebWorkerBeginComponentCmd(data['isBound'], data['ngContentIndex'], data['name'], data['attrNameAndValues'], data['eventTargetAndNames'], data['templateId']),
        (data) => new WebWorkerEndComponentCmd(),
        (data) => new WebWorkerEmbeddedTemplateCmd(data['isBound'], data['ngContentIndex'], data['name'], data['attrNameAndValues'], data['eventTargetAndNames'], data['isMerged'], data['children'].map(childData => deserializeTemplateCmd(childData))),
];
//# sourceMappingURL=data:application/json;base64,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