import { Set } from 'angular2/src/facade/collection';
import { isPresent } from 'angular2/src/facade/lang';
const MOUSE_EVENT_PROPERTIES = [
    "altKey",
    "button",
    "clientX",
    "clientY",
    "metaKey",
    "movementX",
    "movementY",
    "offsetX",
    "offsetY",
    "region",
    "screenX",
    "screenY",
    "shiftKey"
];
const KEYBOARD_EVENT_PROPERTIES = [
    'altkey',
    'charCode',
    'code',
    'ctrlKey',
    'isComposing',
    'key',
    'keyCode',
    'location',
    'metaKey',
    'repeat',
    'shiftKey',
    'which'
];
const EVENT_PROPERTIES = ['type', 'bubbles', 'cancelable'];
const NODES_WITH_VALUE = new Set(["input", "select", "option", "button", "li", "meter", "progress", "param"]);
export function serializeGenericEvent(e) {
    return serializeEvent(e, EVENT_PROPERTIES);
}
// TODO(jteplitz602): Allow users to specify the properties they need rather than always
// adding value and files #3374
export function serializeEventWithTarget(e) {
    var serializedEvent = serializeEvent(e, EVENT_PROPERTIES);
    return addTarget(e, serializedEvent);
}
export function serializeMouseEvent(e) {
    return serializeEvent(e, MOUSE_EVENT_PROPERTIES);
}
export function serializeKeyboardEvent(e) {
    var serializedEvent = serializeEvent(e, KEYBOARD_EVENT_PROPERTIES);
    return addTarget(e, serializedEvent);
}
// TODO(jteplitz602): #3374. See above.
function addTarget(e, serializedEvent) {
    if (NODES_WITH_VALUE.has(e.target.tagName.toLowerCase())) {
        var target = e.target;
        serializedEvent['target'] = { 'value': target.value };
        if (isPresent(target.files)) {
            serializedEvent['target']['files'] = target.files;
        }
    }
    return serializedEvent;
}
function serializeEvent(e, properties) {
    var serialized = {};
    for (var i = 0; i < properties.length; i++) {
        var prop = properties[i];
        serialized[prop] = e[prop];
    }
    return serialized;
}
//# sourceMappingURL=data:application/json;base64,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