'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var source_module_1 = require('./source_module');
var change_detection_jit_generator_1 = require('angular2/src/core/change_detection/change_detection_jit_generator');
var change_definition_factory_1 = require('./change_definition_factory');
var lang_1 = require('angular2/src/facade/lang');
var change_detection_1 = require('angular2/src/core/change_detection/change_detection');
var change_detector_codegen_1 = require('angular2/src/transform/template_compiler/change_detector_codegen');
var util_1 = require('./util');
var di_1 = require('angular2/src/core/di');
var ABSTRACT_CHANGE_DETECTOR = "AbstractChangeDetector";
var UTIL = "ChangeDetectionUtil";
var CHANGE_DETECTOR_STATE = "ChangeDetectorState";
var ABSTRACT_CHANGE_DETECTOR_MODULE = source_module_1.moduleRef("package:angular2/src/core/change_detection/abstract_change_detector" + util_1.MODULE_SUFFIX);
var UTIL_MODULE = source_module_1.moduleRef("package:angular2/src/core/change_detection/change_detection_util" + util_1.MODULE_SUFFIX);
var PREGEN_PROTO_CHANGE_DETECTOR_MODULE = source_module_1.moduleRef("package:angular2/src/core/change_detection/pregen_proto_change_detector" + util_1.MODULE_SUFFIX);
var CONSTANTS_MODULE = source_module_1.moduleRef("package:angular2/src/core/change_detection/constants" + util_1.MODULE_SUFFIX);
var ChangeDetectionCompiler = (function () {
    function ChangeDetectionCompiler(_genConfig) {
        this._genConfig = _genConfig;
    }
    ChangeDetectionCompiler.prototype.compileComponentRuntime = function (componentType, strategy, parsedTemplate) {
        var _this = this;
        var changeDetectorDefinitions = change_definition_factory_1.createChangeDetectorDefinitions(componentType, strategy, this._genConfig, parsedTemplate);
        return changeDetectorDefinitions.map(function (definition) {
            return _this._createChangeDetectorFactory(definition);
        });
    };
    ChangeDetectionCompiler.prototype._createChangeDetectorFactory = function (definition) {
        if (lang_1.IS_DART || !this._genConfig.useJit) {
            var proto = new change_detection_1.DynamicProtoChangeDetector(definition);
            return function (dispatcher) { return proto.instantiate(dispatcher); };
        }
        else {
            return new change_detection_jit_generator_1.ChangeDetectorJITGenerator(definition, UTIL, ABSTRACT_CHANGE_DETECTOR, CHANGE_DETECTOR_STATE)
                .generate();
        }
    };
    ChangeDetectionCompiler.prototype.compileComponentCodeGen = function (componentType, strategy, parsedTemplate) {
        var changeDetectorDefinitions = change_definition_factory_1.createChangeDetectorDefinitions(componentType, strategy, this._genConfig, parsedTemplate);
        var factories = [];
        var index = 0;
        var sourceParts = changeDetectorDefinitions.map(function (definition) {
            var codegen;
            var sourcePart;
            // TODO(tbosch): move the 2 code generators to the same place, one with .dart and one with .ts
            // suffix
            // and have the same API for calling them!
            if (lang_1.IS_DART) {
                codegen = new change_detector_codegen_1.Codegen(PREGEN_PROTO_CHANGE_DETECTOR_MODULE);
                var className = "_" + definition.id;
                var typeRef = (index === 0 && componentType.isHost) ?
                    'dynamic' :
                    "" + source_module_1.moduleRef(componentType.moduleUrl) + componentType.name;
                codegen.generate(typeRef, className, definition);
                factories.push(className + ".newChangeDetector");
                sourcePart = codegen.toString();
            }
            else {
                codegen = new change_detection_jit_generator_1.ChangeDetectorJITGenerator(definition, "" + UTIL_MODULE + UTIL, "" + ABSTRACT_CHANGE_DETECTOR_MODULE + ABSTRACT_CHANGE_DETECTOR, "" + CONSTANTS_MODULE + CHANGE_DETECTOR_STATE);
                factories.push("function(dispatcher) { return new " + codegen.typeName + "(dispatcher); }");
                sourcePart = codegen.generateSource();
            }
            index++;
            return sourcePart;
        });
        return new source_module_1.SourceExpressions(sourceParts, factories);
    };
    ChangeDetectionCompiler = __decorate([
        di_1.Injectable(), 
        __metadata('design:paramtypes', [change_detection_1.ChangeDetectorGenConfig])
    ], ChangeDetectionCompiler);
    return ChangeDetectionCompiler;
})();
exports.ChangeDetectionCompiler = ChangeDetectionCompiler;
//# sourceMappingURL=data:application/json;base64,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