'use strict';var lang_1 = require('angular2/src/facade/lang');
var exceptions_1 = require('angular2/src/facade/exceptions');
var collection_1 = require('angular2/src/facade/collection');
var abstract_change_detector_1 = require('./abstract_change_detector');
var change_detection_util_1 = require('./change_detection_util');
var proto_record_1 = require('./proto_record');
var codegen_name_util_1 = require('./codegen_name_util');
var codegen_logic_util_1 = require('./codegen_logic_util');
var codegen_facade_1 = require('./codegen_facade');
var constants_1 = require('./constants');
var proto_change_detector_1 = require('./proto_change_detector');
/**
 * The code generator takes a list of proto records and creates a function/class
 * that "emulates" what the developer would write by hand to implement the same
 * kind of behaviour.
 *
 * This code should be kept in sync with the Dart transformer's
 * `angular2.transform.template_compiler.change_detector_codegen` library. If you make updates
 * here, please make equivalent changes there.
*/
var IS_CHANGED_LOCAL = "isChanged";
var CHANGES_LOCAL = "changes";
var ChangeDetectorJITGenerator = (function () {
    function ChangeDetectorJITGenerator(definition, changeDetectionUtilVarName, abstractChangeDetectorVarName, changeDetectorStateVarName) {
        this.changeDetectionUtilVarName = changeDetectionUtilVarName;
        this.abstractChangeDetectorVarName = abstractChangeDetectorVarName;
        this.changeDetectorStateVarName = changeDetectorStateVarName;
        var propertyBindingRecords = proto_change_detector_1.createPropertyRecords(definition);
        var eventBindingRecords = proto_change_detector_1.createEventRecords(definition);
        var propertyBindingTargets = definition.bindingRecords.map(function (b) { return b.target; });
        this.id = definition.id;
        this.changeDetectionStrategy = definition.strategy;
        this.genConfig = definition.genConfig;
        this.records = propertyBindingRecords;
        this.propertyBindingTargets = propertyBindingTargets;
        this.eventBindings = eventBindingRecords;
        this.directiveRecords = definition.directiveRecords;
        this._names = new codegen_name_util_1.CodegenNameUtil(this.records, this.eventBindings, this.directiveRecords, this.changeDetectionUtilVarName);
        this._logic =
            new codegen_logic_util_1.CodegenLogicUtil(this._names, this.changeDetectionUtilVarName, this.changeDetectorStateVarName, this.changeDetectionStrategy);
        this.typeName = codegen_name_util_1.sanitizeName("ChangeDetector_" + this.id);
    }
    ChangeDetectorJITGenerator.prototype.generate = function () {
        var factorySource = "\n      " + this.generateSource() + "\n      return function(dispatcher) {\n        return new " + this.typeName + "(dispatcher);\n      }\n    ";
        return new Function(this.abstractChangeDetectorVarName, this.changeDetectionUtilVarName, this.changeDetectorStateVarName, factorySource)(abstract_change_detector_1.AbstractChangeDetector, change_detection_util_1.ChangeDetectionUtil, constants_1.ChangeDetectorState);
    };
    ChangeDetectorJITGenerator.prototype.generateSource = function () {
        return "\n      var " + this.typeName + " = function " + this.typeName + "(dispatcher) {\n        " + this.abstractChangeDetectorVarName + ".call(\n            this, " + JSON.stringify(this.id) + ", dispatcher, " + this.records.length + ",\n            " + this.typeName + ".gen_propertyBindingTargets, " + this.typeName + ".gen_directiveIndices,\n            " + codegen_facade_1.codify(this.changeDetectionStrategy) + ");\n        this.dehydrateDirectives(false);\n      }\n\n      " + this.typeName + ".prototype = Object.create(" + this.abstractChangeDetectorVarName + ".prototype);\n\n      " + this.typeName + ".prototype.detectChangesInRecordsInternal = function(throwOnChange) {\n        " + this._names.genInitLocals() + "\n        var " + IS_CHANGED_LOCAL + " = false;\n        var " + CHANGES_LOCAL + " = null;\n\n        " + this._genAllRecords(this.records) + "\n      }\n\n      " + this._maybeGenHandleEventInternal() + "\n\n      " + this._maybeGenAfterContentLifecycleCallbacks() + "\n\n      " + this._maybeGenAfterViewLifecycleCallbacks() + "\n\n      " + this._maybeGenHydrateDirectives() + "\n\n      " + this._maybeGenDehydrateDirectives() + "\n\n      " + this._genPropertyBindingTargets() + "\n\n      " + this._genDirectiveIndices() + "\n    ";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genPropertyBindingTargets = function () {
        var targets = this._logic.genPropertyBindingTargets(this.propertyBindingTargets, this.genConfig.genDebugInfo);
        return this.typeName + ".gen_propertyBindingTargets = " + targets + ";";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genDirectiveIndices = function () {
        var indices = this._logic.genDirectiveIndices(this.directiveRecords);
        return this.typeName + ".gen_directiveIndices = " + indices + ";";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._maybeGenHandleEventInternal = function () {
        var _this = this;
        if (this.eventBindings.length > 0) {
            var handlers = this.eventBindings.map(function (eb) { return _this._genEventBinding(eb); }).join("\n");
            return "\n        " + this.typeName + ".prototype.handleEventInternal = function(eventName, elIndex, locals) {\n          var " + this._names.getPreventDefaultAccesor() + " = false;\n          " + this._names.genInitEventLocals() + "\n          " + handlers + "\n          return " + this._names.getPreventDefaultAccesor() + ";\n        }\n      ";
        }
        else {
            return '';
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genEventBinding = function (eb) {
        var _this = this;
        var codes = [];
        this._endOfBlockIdxs = [];
        collection_1.ListWrapper.forEachWithIndex(eb.records, function (r, i) {
            var code;
            if (r.isConditionalSkipRecord()) {
                code = _this._genConditionalSkip(r, _this._names.getEventLocalName(eb, i));
            }
            else if (r.isUnconditionalSkipRecord()) {
                code = _this._genUnconditionalSkip(r);
            }
            else {
                code = _this._genEventBindingEval(eb, r);
            }
            code += _this._genEndOfSkipBlock(i);
            codes.push(code);
        });
        return "\n    if (eventName === \"" + eb.eventName + "\" && elIndex === " + eb.elIndex + ") {\n      " + codes.join("\n") + "\n    }";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genEventBindingEval = function (eb, r) {
        if (r.lastInBinding) {
            var evalRecord = this._logic.genEventBindingEvalValue(eb, r);
            var markPath = this._genMarkPathToRootAsCheckOnce(r);
            var prevDefault = this._genUpdatePreventDefault(eb, r);
            return evalRecord + "\n" + markPath + "\n" + prevDefault;
        }
        else {
            return this._logic.genEventBindingEvalValue(eb, r);
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genMarkPathToRootAsCheckOnce = function (r) {
        var br = r.bindingRecord;
        if (br.isDefaultChangeDetection()) {
            return "";
        }
        else {
            return this._names.getDetectorName(br.directiveRecord.directiveIndex) + ".markPathToRootAsCheckOnce();";
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genUpdatePreventDefault = function (eb, r) {
        var local = this._names.getEventLocalName(eb, r.selfIndex);
        return "if (" + local + " === false) { " + this._names.getPreventDefaultAccesor() + " = true};";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._maybeGenDehydrateDirectives = function () {
        var destroyPipesCode = this._names.genPipeOnDestroy();
        if (destroyPipesCode) {
            destroyPipesCode = "if (destroyPipes) { " + destroyPipesCode + " }";
        }
        var dehydrateFieldsCode = this._names.genDehydrateFields();
        if (!destroyPipesCode && !dehydrateFieldsCode)
            return '';
        return this.typeName + ".prototype.dehydrateDirectives = function(destroyPipes) {\n        " + destroyPipesCode + "\n        " + dehydrateFieldsCode + "\n    }";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._maybeGenHydrateDirectives = function () {
        var hydrateDirectivesCode = this._logic.genHydrateDirectives(this.directiveRecords);
        var hydrateDetectorsCode = this._logic.genHydrateDetectors(this.directiveRecords);
        if (!hydrateDirectivesCode && !hydrateDetectorsCode)
            return '';
        return this.typeName + ".prototype.hydrateDirectives = function(directives) {\n      " + hydrateDirectivesCode + "\n      " + hydrateDetectorsCode + "\n    }";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._maybeGenAfterContentLifecycleCallbacks = function () {
        var notifications = this._logic.genContentLifecycleCallbacks(this.directiveRecords);
        if (notifications.length > 0) {
            var directiveNotifications = notifications.join("\n");
            return "\n        " + this.typeName + ".prototype.afterContentLifecycleCallbacksInternal = function() {\n          " + directiveNotifications + "\n        }\n      ";
        }
        else {
            return '';
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._maybeGenAfterViewLifecycleCallbacks = function () {
        var notifications = this._logic.genViewLifecycleCallbacks(this.directiveRecords);
        if (notifications.length > 0) {
            var directiveNotifications = notifications.join("\n");
            return "\n        " + this.typeName + ".prototype.afterViewLifecycleCallbacksInternal = function() {\n          " + directiveNotifications + "\n        }\n      ";
        }
        else {
            return '';
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genAllRecords = function (rs) {
        var codes = [];
        this._endOfBlockIdxs = [];
        for (var i = 0; i < rs.length; i++) {
            var code = void 0;
            var r = rs[i];
            if (r.isLifeCycleRecord()) {
                code = this._genDirectiveLifecycle(r);
            }
            else if (r.isPipeRecord()) {
                code = this._genPipeCheck(r);
            }
            else if (r.isConditionalSkipRecord()) {
                code = this._genConditionalSkip(r, this._names.getLocalName(r.contextIndex));
            }
            else if (r.isUnconditionalSkipRecord()) {
                code = this._genUnconditionalSkip(r);
            }
            else {
                code = this._genReferenceCheck(r);
            }
            code = "\n        " + this._maybeFirstInBinding(r) + "\n        " + code + "\n        " + this._maybeGenLastInDirective(r) + "\n        " + this._genEndOfSkipBlock(i) + "\n      ";
            codes.push(code);
        }
        return codes.join("\n");
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genConditionalSkip = function (r, condition) {
        var maybeNegate = r.mode === proto_record_1.RecordType.SkipRecordsIf ? '!' : '';
        this._endOfBlockIdxs.push(r.fixedArgs[0] - 1);
        return "if (" + maybeNegate + condition + ") {";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genUnconditionalSkip = function (r) {
        this._endOfBlockIdxs.pop();
        this._endOfBlockIdxs.push(r.fixedArgs[0] - 1);
        return "} else {";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genEndOfSkipBlock = function (protoIndex) {
        if (!collection_1.ListWrapper.isEmpty(this._endOfBlockIdxs)) {
            var endOfBlock = collection_1.ListWrapper.last(this._endOfBlockIdxs);
            if (protoIndex === endOfBlock) {
                this._endOfBlockIdxs.pop();
                return '}';
            }
        }
        return '';
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genDirectiveLifecycle = function (r) {
        if (r.name === "DoCheck") {
            return this._genOnCheck(r);
        }
        else if (r.name === "OnInit") {
            return this._genOnInit(r);
        }
        else if (r.name === "OnChanges") {
            return this._genOnChange(r);
        }
        else {
            throw new exceptions_1.BaseException("Unknown lifecycle event '" + r.name + "'");
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genPipeCheck = function (r) {
        var _this = this;
        var context = this._names.getLocalName(r.contextIndex);
        var argString = r.args.map(function (arg) { return _this._names.getLocalName(arg); }).join(", ");
        var oldValue = this._names.getFieldName(r.selfIndex);
        var newValue = this._names.getLocalName(r.selfIndex);
        var pipe = this._names.getPipeName(r.selfIndex);
        var pipeName = r.name;
        var init = "\n      if (" + pipe + " === " + this.changeDetectionUtilVarName + ".uninitialized) {\n        " + pipe + " = " + this._names.getPipesAccessorName() + ".get('" + pipeName + "');\n      }\n    ";
        var read = newValue + " = " + pipe + ".pipe.transform(" + context + ", [" + argString + "]);";
        var contexOrArgCheck = r.args.map(function (a) { return _this._names.getChangeName(a); });
        contexOrArgCheck.push(this._names.getChangeName(r.contextIndex));
        var condition = "!" + pipe + ".pure || (" + contexOrArgCheck.join(" || ") + ")";
        var check = "\n      if (" + this.changeDetectionUtilVarName + ".looseNotIdentical(" + oldValue + ", " + newValue + ")) {\n        " + newValue + " = " + this.changeDetectionUtilVarName + ".unwrapValue(" + newValue + ")\n        " + this._genChangeMarker(r) + "\n        " + this._genUpdateDirectiveOrElement(r) + "\n        " + this._genAddToChanges(r) + "\n        " + oldValue + " = " + newValue + ";\n      }\n    ";
        var genCode = r.shouldBeChecked() ? "" + read + check : read;
        if (r.isUsedByOtherRecord()) {
            return init + " if (" + condition + ") { " + genCode + " } else { " + newValue + " = " + oldValue + "; }";
        }
        else {
            return init + " if (" + condition + ") { " + genCode + " }";
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genReferenceCheck = function (r) {
        var _this = this;
        var oldValue = this._names.getFieldName(r.selfIndex);
        var newValue = this._names.getLocalName(r.selfIndex);
        var read = "\n      " + this._logic.genPropertyBindingEvalValue(r) + "\n    ";
        var check = "\n      if (" + this.changeDetectionUtilVarName + ".looseNotIdentical(" + oldValue + ", " + newValue + ")) {\n        " + this._genChangeMarker(r) + "\n        " + this._genUpdateDirectiveOrElement(r) + "\n        " + this._genAddToChanges(r) + "\n        " + oldValue + " = " + newValue + ";\n      }\n    ";
        var genCode = r.shouldBeChecked() ? "" + read + check : read;
        if (r.isPureFunction()) {
            var condition = r.args.map(function (a) { return _this._names.getChangeName(a); }).join(" || ");
            if (r.isUsedByOtherRecord()) {
                return "if (" + condition + ") { " + genCode + " } else { " + newValue + " = " + oldValue + "; }";
            }
            else {
                return "if (" + condition + ") { " + genCode + " }";
            }
        }
        else {
            return genCode;
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genChangeMarker = function (r) {
        return r.argumentToPureFunction ? this._names.getChangeName(r.selfIndex) + " = true" : "";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genUpdateDirectiveOrElement = function (r) {
        if (!r.lastInBinding)
            return "";
        var newValue = this._names.getLocalName(r.selfIndex);
        var oldValue = this._names.getFieldName(r.selfIndex);
        var notifyDebug = this.genConfig.logBindingUpdate ? "this.logBindingUpdate(" + newValue + ");" : "";
        var br = r.bindingRecord;
        if (br.target.isDirective()) {
            var directiveProperty = this._names.getDirectiveName(br.directiveRecord.directiveIndex) + "." + br.target.name;
            return "\n        " + this._genThrowOnChangeCheck(oldValue, newValue) + "\n        " + directiveProperty + " = " + newValue + ";\n        " + notifyDebug + "\n        " + IS_CHANGED_LOCAL + " = true;\n      ";
        }
        else {
            return "\n        " + this._genThrowOnChangeCheck(oldValue, newValue) + "\n        this.notifyDispatcher(" + newValue + ");\n        " + notifyDebug + "\n      ";
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genThrowOnChangeCheck = function (oldValue, newValue) {
        if (lang_1.assertionsEnabled()) {
            return "\n        if(throwOnChange) {\n          this.throwOnChangeError(" + oldValue + ", " + newValue + ");\n        }\n        ";
        }
        else {
            return '';
        }
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genAddToChanges = function (r) {
        var newValue = this._names.getLocalName(r.selfIndex);
        var oldValue = this._names.getFieldName(r.selfIndex);
        if (!r.bindingRecord.callOnChanges())
            return "";
        return CHANGES_LOCAL + " = this.addChange(" + CHANGES_LOCAL + ", " + oldValue + ", " + newValue + ");";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._maybeFirstInBinding = function (r) {
        var prev = change_detection_util_1.ChangeDetectionUtil.protoByIndex(this.records, r.selfIndex - 1);
        var firstInBinding = lang_1.isBlank(prev) || prev.bindingRecord !== r.bindingRecord;
        return firstInBinding && !r.bindingRecord.isDirectiveLifecycle() ?
            this._names.getPropertyBindingIndex() + " = " + r.propertyBindingIndex + ";" :
            '';
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._maybeGenLastInDirective = function (r) {
        if (!r.lastInDirective)
            return "";
        return "\n      " + CHANGES_LOCAL + " = null;\n      " + this._genNotifyOnPushDetectors(r) + "\n      " + IS_CHANGED_LOCAL + " = false;\n    ";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genOnCheck = function (r) {
        var br = r.bindingRecord;
        return "if (!throwOnChange) " + this._names.getDirectiveName(br.directiveRecord.directiveIndex) + ".ngDoCheck();";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genOnInit = function (r) {
        var br = r.bindingRecord;
        return "if (!throwOnChange && " + this._names.getStateName() + " === " + this.changeDetectorStateVarName + ".NeverChecked) " + this._names.getDirectiveName(br.directiveRecord.directiveIndex) + ".ngOnInit();";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genOnChange = function (r) {
        var br = r.bindingRecord;
        return "if (!throwOnChange && " + CHANGES_LOCAL + ") " + this._names.getDirectiveName(br.directiveRecord.directiveIndex) + ".ngOnChanges(" + CHANGES_LOCAL + ");";
    };
    /** @internal */
    ChangeDetectorJITGenerator.prototype._genNotifyOnPushDetectors = function (r) {
        var br = r.bindingRecord;
        if (!r.lastInDirective || br.isDefaultChangeDetection())
            return "";
        var retVal = "\n      if(" + IS_CHANGED_LOCAL + ") {\n        " + this._names.getDetectorName(br.directiveRecord.directiveIndex) + ".markAsCheckOnce();\n      }\n    ";
        return retVal;
    };
    return ChangeDetectorJITGenerator;
})();
exports.ChangeDetectorJITGenerator = ChangeDetectorJITGenerator;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2hhbmdlX2RldGVjdGlvbl9qaXRfZ2VuZXJhdG9yLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYW5ndWxhcjIvc3JjL2NvcmUvY2hhbmdlX2RldGVjdGlvbi9jaGFuZ2VfZGV0ZWN0aW9uX2ppdF9nZW5lcmF0b3IudHMiXSwibmFtZXMiOlsiQ2hhbmdlRGV0ZWN0b3JKSVRHZW5lcmF0b3IiLCJDaGFuZ2VEZXRlY3RvckpJVEdlbmVyYXRvci5jb25zdHJ1Y3RvciIsIkNoYW5nZURldGVjdG9ySklUR2VuZXJhdG9yLmdlbmVyYXRlIiwiQ2hhbmdlRGV0ZWN0b3JKSVRHZW5lcmF0b3IuZ2VuZXJhdGVTb3VyY2UiLCJDaGFuZ2VEZXRlY3RvckpJVEdlbmVyYXRvci5fZ2VuUHJvcGVydHlCaW5kaW5nVGFyZ2V0cyIsIkNoYW5nZURldGVjdG9ySklUR2VuZXJhdG9yLl9nZW5EaXJlY3RpdmVJbmRpY2VzIiwiQ2hhbmdlRGV0ZWN0b3JKSVRHZW5lcmF0b3IuX21heWJlR2VuSGFuZGxlRXZlbnRJbnRlcm5hbCIsIkNoYW5nZURldGVjdG9ySklUR2VuZXJhdG9yLl9nZW5FdmVudEJpbmRpbmciLCJDaGFuZ2VEZXRlY3RvckpJVEdlbmVyYXRvci5fZ2VuRXZlbnRCaW5kaW5nRXZhbCIsIkNoYW5nZURldGVjdG9ySklUR2VuZXJhdG9yLl9nZW5NYXJrUGF0aFRvUm9vdEFzQ2hlY2tPbmNlIiwiQ2hhbmdlRGV0ZWN0b3JKSVRHZW5lcmF0b3IuX2dlblVwZGF0ZVByZXZlbnREZWZhdWx0IiwiQ2hhbmdlRGV0ZWN0b3JKSVRHZW5lcmF0b3IuX21heWJlR2VuRGVoeWRyYXRlRGlyZWN0aXZlcyIsIkNoYW5nZURldGVjdG9ySklUR2VuZXJhdG9yLl9tYXliZUdlbkh5ZHJhdGVEaXJlY3RpdmVzIiwiQ2hhbmdlRGV0ZWN0b3JKSVRHZW5lcmF0b3IuX21heWJlR2VuQWZ0ZXJDb250ZW50TGlmZWN5Y2xlQ2FsbGJhY2tzIiwiQ2hhbmdlRGV0ZWN0b3JKSVRHZW5lcmF0b3IuX21heWJlR2VuQWZ0ZXJWaWV3TGlmZWN5Y2xlQ2FsbGJhY2tzIiwiQ2hhbmdlRGV0ZWN0b3JKSVRHZW5lcmF0b3IuX2dlbkFsbFJlY29yZHMiLCJDaGFuZ2VEZXRlY3RvckpJVEdlbmVyYXRvci5fZ2VuQ29uZGl0aW9uYWxTa2lwIiwiQ2hhbmdlRGV0ZWN0b3JKSVRHZW5lcmF0b3IuX2dlblVuY29uZGl0aW9uYWxTa2lwIiwiQ2hhbmdlRGV0ZWN0b3JKSVRHZW5lcmF0b3IuX2dlbkVuZE9mU2tpcEJsb2NrIiwiQ2hhbmdlRGV0ZWN0b3JKSVRHZW5lcmF0b3IuX2dlbkRpcmVjdGl2ZUxpZmVjeWNsZSIsIkNoYW5nZURldGVjdG9ySklUR2VuZXJhdG9yLl9nZW5QaXBlQ2hlY2siLCJDaGFuZ2VEZXRlY3RvckpJVEdlbmVyYXRvci5fZ2VuUmVmZXJlbmNlQ2hlY2siLCJDaGFuZ2VEZXRlY3RvckpJVEdlbmVyYXRvci5fZ2VuQ2hhbmdlTWFya2VyIiwiQ2hhbmdlRGV0ZWN0b3JKSVRHZW5lcmF0b3IuX2dlblVwZGF0ZURpcmVjdGl2ZU9yRWxlbWVudCIsIkNoYW5nZURldGVjdG9ySklUR2VuZXJhdG9yLl9nZW5UaHJvd09uQ2hhbmdlQ2hlY2siLCJDaGFuZ2VEZXRlY3RvckpJVEdlbmVyYXRvci5fZ2VuQWRkVG9DaGFuZ2VzIiwiQ2hhbmdlRGV0ZWN0b3JKSVRHZW5lcmF0b3IuX21heWJlRmlyc3RJbkJpbmRpbmciLCJDaGFuZ2VEZXRlY3RvckpJVEdlbmVyYXRvci5fbWF5YmVHZW5MYXN0SW5EaXJlY3RpdmUiLCJDaGFuZ2VEZXRlY3RvckpJVEdlbmVyYXRvci5fZ2VuT25DaGVjayIsIkNoYW5nZURldGVjdG9ySklUR2VuZXJhdG9yLl9nZW5PbkluaXQiLCJDaGFuZ2VEZXRlY3RvckpJVEdlbmVyYXRvci5fZ2VuT25DaGFuZ2UiLCJDaGFuZ2VEZXRlY3RvckpJVEdlbmVyYXRvci5fZ2VuTm90aWZ5T25QdXNoRGV0ZWN0b3JzIl0sIm1hcHBpbmdzIjoiQUFBQSxxQkFBeUUsMEJBQTBCLENBQUMsQ0FBQTtBQUNwRywyQkFBNEIsZ0NBQWdDLENBQUMsQ0FBQTtBQUM3RCwyQkFBd0QsZ0NBQWdDLENBQUMsQ0FBQTtBQUV6Rix5Q0FBcUMsNEJBQTRCLENBQUMsQ0FBQTtBQUNsRSxzQ0FBa0MseUJBQXlCLENBQUMsQ0FBQTtBQUc1RCw2QkFBc0MsZ0JBQWdCLENBQUMsQ0FBQTtBQUN2RCxrQ0FBNEMscUJBQXFCLENBQUMsQ0FBQTtBQUNsRSxtQ0FBK0Isc0JBQXNCLENBQUMsQ0FBQTtBQUN0RCwrQkFBcUIsa0JBQWtCLENBQUMsQ0FBQTtBQUl4QywwQkFBMkQsYUFBYSxDQUFDLENBQUE7QUFDekUsc0NBQXdELHlCQUF5QixDQUFDLENBQUE7QUFFbEY7Ozs7Ozs7O0VBUUU7QUFDRixJQUFNLGdCQUFnQixHQUFHLFdBQVcsQ0FBQztBQUNyQyxJQUFNLGFBQWEsR0FBRyxTQUFTLENBQUM7QUFFaEM7SUFhRUEsb0NBQVlBLFVBQW9DQSxFQUFVQSwwQkFBa0NBLEVBQ3hFQSw2QkFBcUNBLEVBQ3JDQSwwQkFBa0NBO1FBRklDLCtCQUEwQkEsR0FBMUJBLDBCQUEwQkEsQ0FBUUE7UUFDeEVBLGtDQUE2QkEsR0FBN0JBLDZCQUE2QkEsQ0FBUUE7UUFDckNBLCtCQUEwQkEsR0FBMUJBLDBCQUEwQkEsQ0FBUUE7UUFDcERBLElBQUlBLHNCQUFzQkEsR0FBR0EsNkNBQXFCQSxDQUFDQSxVQUFVQSxDQUFDQSxDQUFDQTtRQUMvREEsSUFBSUEsbUJBQW1CQSxHQUFHQSwwQ0FBa0JBLENBQUNBLFVBQVVBLENBQUNBLENBQUNBO1FBQ3pEQSxJQUFJQSxzQkFBc0JBLEdBQUdBLFVBQVVBLENBQUNBLGNBQWNBLENBQUNBLEdBQUdBLENBQUNBLFVBQUFBLENBQUNBLElBQUlBLE9BQUFBLENBQUNBLENBQUNBLE1BQU1BLEVBQVJBLENBQVFBLENBQUNBLENBQUNBO1FBQzFFQSxJQUFJQSxDQUFDQSxFQUFFQSxHQUFHQSxVQUFVQSxDQUFDQSxFQUFFQSxDQUFDQTtRQUN4QkEsSUFBSUEsQ0FBQ0EsdUJBQXVCQSxHQUFHQSxVQUFVQSxDQUFDQSxRQUFRQSxDQUFDQTtRQUNuREEsSUFBSUEsQ0FBQ0EsU0FBU0EsR0FBR0EsVUFBVUEsQ0FBQ0EsU0FBU0EsQ0FBQ0E7UUFFdENBLElBQUlBLENBQUNBLE9BQU9BLEdBQUdBLHNCQUFzQkEsQ0FBQ0E7UUFDdENBLElBQUlBLENBQUNBLHNCQUFzQkEsR0FBR0Esc0JBQXNCQSxDQUFDQTtRQUNyREEsSUFBSUEsQ0FBQ0EsYUFBYUEsR0FBR0EsbUJBQW1CQSxDQUFDQTtRQUN6Q0EsSUFBSUEsQ0FBQ0EsZ0JBQWdCQSxHQUFHQSxVQUFVQSxDQUFDQSxnQkFBZ0JBLENBQUNBO1FBQ3BEQSxJQUFJQSxDQUFDQSxNQUFNQSxHQUFHQSxJQUFJQSxtQ0FBZUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsT0FBT0EsRUFBRUEsSUFBSUEsQ0FBQ0EsYUFBYUEsRUFBRUEsSUFBSUEsQ0FBQ0EsZ0JBQWdCQSxFQUN2REEsSUFBSUEsQ0FBQ0EsMEJBQTBCQSxDQUFDQSxDQUFDQTtRQUNuRUEsSUFBSUEsQ0FBQ0EsTUFBTUE7WUFDUEEsSUFBSUEscUNBQWdCQSxDQUFDQSxJQUFJQSxDQUFDQSxNQUFNQSxFQUFFQSxJQUFJQSxDQUFDQSwwQkFBMEJBLEVBQzVDQSxJQUFJQSxDQUFDQSwwQkFBMEJBLEVBQUVBLElBQUlBLENBQUNBLHVCQUF1QkEsQ0FBQ0EsQ0FBQ0E7UUFDeEZBLElBQUlBLENBQUNBLFFBQVFBLEdBQUdBLGdDQUFZQSxDQUFDQSxvQkFBa0JBLElBQUlBLENBQUNBLEVBQUlBLENBQUNBLENBQUNBO0lBQzVEQSxDQUFDQTtJQUVERCw2Q0FBUUEsR0FBUkE7UUFDRUUsSUFBSUEsYUFBYUEsR0FBR0EsYUFDaEJBLElBQUlBLENBQUNBLGNBQWNBLEVBQUVBLGtFQUVSQSxJQUFJQSxDQUFDQSxRQUFRQSxpQ0FFN0JBLENBQUNBO1FBQ0ZBLE1BQU1BLENBQUNBLElBQUlBLFFBQVFBLENBQUNBLElBQUlBLENBQUNBLDZCQUE2QkEsRUFBRUEsSUFBSUEsQ0FBQ0EsMEJBQTBCQSxFQUNuRUEsSUFBSUEsQ0FBQ0EsMEJBQTBCQSxFQUFFQSxhQUFhQSxDQUFDQSxDQUMvREEsaURBQXNCQSxFQUFFQSwyQ0FBbUJBLEVBQUVBLCtCQUFtQkEsQ0FBQ0EsQ0FBQ0E7SUFDeEVBLENBQUNBO0lBRURGLG1EQUFjQSxHQUFkQTtRQUNFRyxNQUFNQSxDQUFDQSxpQkFDQ0EsSUFBSUEsQ0FBQ0EsUUFBUUEsb0JBQWVBLElBQUlBLENBQUNBLFFBQVFBLGdDQUMzQ0EsSUFBSUEsQ0FBQ0EsNkJBQTZCQSxrQ0FDeEJBLElBQUlBLENBQUNBLFNBQVNBLENBQUNBLElBQUlBLENBQUNBLEVBQUVBLENBQUNBLHNCQUFpQkEsSUFBSUEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsTUFBTUEsdUJBQ2pFQSxJQUFJQSxDQUFDQSxRQUFRQSxxQ0FBZ0NBLElBQUlBLENBQUNBLFFBQVFBLDRDQUMxREEsdUJBQU1BLENBQUNBLElBQUlBLENBQUNBLHVCQUF1QkEsQ0FBQ0EsdUVBSTFDQSxJQUFJQSxDQUFDQSxRQUFRQSxtQ0FBOEJBLElBQUlBLENBQUNBLDZCQUE2QkEsOEJBRTdFQSxJQUFJQSxDQUFDQSxRQUFRQSx1RkFDWEEsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsYUFBYUEsRUFBRUEsc0JBQ3ZCQSxnQkFBZ0JBLCtCQUNoQkEsYUFBYUEsNEJBRWpCQSxJQUFJQSxDQUFDQSxjQUFjQSxDQUFDQSxJQUFJQSxDQUFDQSxPQUFPQSxDQUFDQSwyQkFHbkNBLElBQUlBLENBQUNBLDRCQUE0QkEsRUFBRUEsa0JBRW5DQSxJQUFJQSxDQUFDQSx1Q0FBdUNBLEVBQUVBLGtCQUU5Q0EsSUFBSUEsQ0FBQ0Esb0NBQW9DQSxFQUFFQSxrQkFFM0NBLElBQUlBLENBQUNBLDBCQUEwQkEsRUFBRUEsa0JBRWpDQSxJQUFJQSxDQUFDQSw0QkFBNEJBLEVBQUVBLGtCQUVuQ0EsSUFBSUEsQ0FBQ0EsMEJBQTBCQSxFQUFFQSxrQkFFakNBLElBQUlBLENBQUNBLG9CQUFvQkEsRUFBRUEsV0FDOUJBLENBQUNBO0lBQ0pBLENBQUNBO0lBRURILGdCQUFnQkE7SUFDaEJBLCtEQUEwQkEsR0FBMUJBO1FBQ0VJLElBQUlBLE9BQU9BLEdBQUdBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLHlCQUF5QkEsQ0FBQ0EsSUFBSUEsQ0FBQ0Esc0JBQXNCQSxFQUMzQkEsSUFBSUEsQ0FBQ0EsU0FBU0EsQ0FBQ0EsWUFBWUEsQ0FBQ0EsQ0FBQ0E7UUFDakZBLE1BQU1BLENBQUlBLElBQUlBLENBQUNBLFFBQVFBLHNDQUFpQ0EsT0FBT0EsTUFBR0EsQ0FBQ0E7SUFDckVBLENBQUNBO0lBRURKLGdCQUFnQkE7SUFDaEJBLHlEQUFvQkEsR0FBcEJBO1FBQ0VLLElBQUlBLE9BQU9BLEdBQUdBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLG1CQUFtQkEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsZ0JBQWdCQSxDQUFDQSxDQUFDQTtRQUNyRUEsTUFBTUEsQ0FBSUEsSUFBSUEsQ0FBQ0EsUUFBUUEsZ0NBQTJCQSxPQUFPQSxNQUFHQSxDQUFDQTtJQUMvREEsQ0FBQ0E7SUFFREwsZ0JBQWdCQTtJQUNoQkEsaUVBQTRCQSxHQUE1QkE7UUFBQU0saUJBY0NBO1FBYkNBLEVBQUVBLENBQUNBLENBQUNBLElBQUlBLENBQUNBLGFBQWFBLENBQUNBLE1BQU1BLEdBQUdBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQ2xDQSxJQUFJQSxRQUFRQSxHQUFHQSxJQUFJQSxDQUFDQSxhQUFhQSxDQUFDQSxHQUFHQSxDQUFDQSxVQUFBQSxFQUFFQSxJQUFJQSxPQUFBQSxLQUFJQSxDQUFDQSxnQkFBZ0JBLENBQUNBLEVBQUVBLENBQUNBLEVBQXpCQSxDQUF5QkEsQ0FBQ0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7WUFDbEZBLE1BQU1BLENBQUNBLGVBQ0hBLElBQUlBLENBQUNBLFFBQVFBLCtGQUNQQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSx3QkFBd0JBLEVBQUVBLDZCQUMxQ0EsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0Esa0JBQWtCQSxFQUFFQSxvQkFDaENBLFFBQVFBLDJCQUNEQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSx3QkFBd0JBLEVBQUVBLHlCQUVsREEsQ0FBQ0E7UUFDSkEsQ0FBQ0E7UUFBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7WUFDTkEsTUFBTUEsQ0FBQ0EsRUFBRUEsQ0FBQ0E7UUFDWkEsQ0FBQ0E7SUFDSEEsQ0FBQ0E7SUFFRE4sZ0JBQWdCQTtJQUNoQkEscURBQWdCQSxHQUFoQkEsVUFBaUJBLEVBQWdCQTtRQUFqQ08saUJBd0JDQTtRQXZCQ0EsSUFBSUEsS0FBS0EsR0FBYUEsRUFBRUEsQ0FBQ0E7UUFDekJBLElBQUlBLENBQUNBLGVBQWVBLEdBQUdBLEVBQUVBLENBQUNBO1FBRTFCQSx3QkFBV0EsQ0FBQ0EsZ0JBQWdCQSxDQUFDQSxFQUFFQSxDQUFDQSxPQUFPQSxFQUFFQSxVQUFDQSxDQUFDQSxFQUFFQSxDQUFDQTtZQUM1Q0EsSUFBSUEsSUFBSUEsQ0FBQ0E7WUFFVEEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsdUJBQXVCQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQTtnQkFDaENBLElBQUlBLEdBQUdBLEtBQUlBLENBQUNBLG1CQUFtQkEsQ0FBQ0EsQ0FBQ0EsRUFBRUEsS0FBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsaUJBQWlCQSxDQUFDQSxFQUFFQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUMzRUEsQ0FBQ0E7WUFBQ0EsSUFBSUEsQ0FBQ0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EseUJBQXlCQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQTtnQkFDekNBLElBQUlBLEdBQUdBLEtBQUlBLENBQUNBLHFCQUFxQkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDdkNBLENBQUNBO1lBQUNBLElBQUlBLENBQUNBLENBQUNBO2dCQUNOQSxJQUFJQSxHQUFHQSxLQUFJQSxDQUFDQSxvQkFBb0JBLENBQUNBLEVBQUVBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBO1lBQzFDQSxDQUFDQTtZQUVEQSxJQUFJQSxJQUFJQSxLQUFJQSxDQUFDQSxrQkFBa0JBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBRW5DQSxLQUFLQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtRQUNuQkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFFSEEsTUFBTUEsQ0FBQ0EsK0JBQ2NBLEVBQUVBLENBQUNBLFNBQVNBLDBCQUFvQkEsRUFBRUEsQ0FBQ0EsT0FBT0EsbUJBQzNEQSxLQUFLQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxZQUNsQkEsQ0FBQ0E7SUFDTEEsQ0FBQ0E7SUFFRFAsZ0JBQWdCQTtJQUNoQkEseURBQW9CQSxHQUFwQkEsVUFBcUJBLEVBQWdCQSxFQUFFQSxDQUFjQTtRQUNuRFEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsYUFBYUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDcEJBLElBQUlBLFVBQVVBLEdBQUdBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLHdCQUF3QkEsQ0FBQ0EsRUFBRUEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDN0RBLElBQUlBLFFBQVFBLEdBQUdBLElBQUlBLENBQUNBLDZCQUE2QkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDckRBLElBQUlBLFdBQVdBLEdBQUdBLElBQUlBLENBQUNBLHdCQUF3QkEsQ0FBQ0EsRUFBRUEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDdkRBLE1BQU1BLENBQUlBLFVBQVVBLFVBQUtBLFFBQVFBLFVBQUtBLFdBQWFBLENBQUNBO1FBQ3REQSxDQUFDQTtRQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtZQUNOQSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSx3QkFBd0JBLENBQUNBLEVBQUVBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBO1FBQ3JEQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUVEUixnQkFBZ0JBO0lBQ2hCQSxrRUFBNkJBLEdBQTdCQSxVQUE4QkEsQ0FBY0E7UUFDMUNTLElBQUlBLEVBQUVBLEdBQUdBLENBQUNBLENBQUNBLGFBQWFBLENBQUNBO1FBQ3pCQSxFQUFFQSxDQUFDQSxDQUFDQSxFQUFFQSxDQUFDQSx3QkFBd0JBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBO1lBQ2xDQSxNQUFNQSxDQUFDQSxFQUFFQSxDQUFDQTtRQUNaQSxDQUFDQTtRQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtZQUNOQSxNQUFNQSxDQUFJQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxlQUFlQSxDQUFDQSxFQUFFQSxDQUFDQSxlQUFlQSxDQUFDQSxjQUFjQSxDQUFDQSxrQ0FBK0JBLENBQUNBO1FBQzFHQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUVEVCxnQkFBZ0JBO0lBQ2hCQSw2REFBd0JBLEdBQXhCQSxVQUF5QkEsRUFBZ0JBLEVBQUVBLENBQWNBO1FBQ3ZEVSxJQUFJQSxLQUFLQSxHQUFHQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxpQkFBaUJBLENBQUNBLEVBQUVBLEVBQUVBLENBQUNBLENBQUNBLFNBQVNBLENBQUNBLENBQUNBO1FBQzNEQSxNQUFNQSxDQUFDQSxTQUFPQSxLQUFLQSxzQkFBaUJBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLHdCQUF3QkEsRUFBRUEsY0FBV0EsQ0FBQ0E7SUFDeEZBLENBQUNBO0lBRURWLGdCQUFnQkE7SUFDaEJBLGlFQUE0QkEsR0FBNUJBO1FBQ0VXLElBQUlBLGdCQUFnQkEsR0FBR0EsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsZ0JBQWdCQSxFQUFFQSxDQUFDQTtRQUN0REEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsZ0JBQWdCQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNyQkEsZ0JBQWdCQSxHQUFHQSx5QkFBdUJBLGdCQUFnQkEsT0FBSUEsQ0FBQ0E7UUFDakVBLENBQUNBO1FBQ0RBLElBQUlBLG1CQUFtQkEsR0FBR0EsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0Esa0JBQWtCQSxFQUFFQSxDQUFDQTtRQUMzREEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsZ0JBQWdCQSxJQUFJQSxDQUFDQSxtQkFBbUJBLENBQUNBO1lBQUNBLE1BQU1BLENBQUNBLEVBQUVBLENBQUNBO1FBQ3pEQSxNQUFNQSxDQUFJQSxJQUFJQSxDQUFDQSxRQUFRQSwyRUFDakJBLGdCQUFnQkEsa0JBQ2hCQSxtQkFBbUJBLFlBQ3ZCQSxDQUFDQTtJQUNMQSxDQUFDQTtJQUVEWCxnQkFBZ0JBO0lBQ2hCQSwrREFBMEJBLEdBQTFCQTtRQUNFWSxJQUFJQSxxQkFBcUJBLEdBQUdBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLG9CQUFvQkEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsZ0JBQWdCQSxDQUFDQSxDQUFDQTtRQUNwRkEsSUFBSUEsb0JBQW9CQSxHQUFHQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxtQkFBbUJBLENBQUNBLElBQUlBLENBQUNBLGdCQUFnQkEsQ0FBQ0EsQ0FBQ0E7UUFDbEZBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBLHFCQUFxQkEsSUFBSUEsQ0FBQ0Esb0JBQW9CQSxDQUFDQTtZQUFDQSxNQUFNQSxDQUFDQSxFQUFFQSxDQUFDQTtRQUMvREEsTUFBTUEsQ0FBSUEsSUFBSUEsQ0FBQ0EsUUFBUUEscUVBQ25CQSxxQkFBcUJBLGdCQUNyQkEsb0JBQW9CQSxZQUN0QkEsQ0FBQ0E7SUFDTEEsQ0FBQ0E7SUFFRFosZ0JBQWdCQTtJQUNoQkEsNEVBQXVDQSxHQUF2Q0E7UUFDRWEsSUFBSUEsYUFBYUEsR0FBR0EsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsNEJBQTRCQSxDQUFDQSxJQUFJQSxDQUFDQSxnQkFBZ0JBLENBQUNBLENBQUNBO1FBQ3BGQSxFQUFFQSxDQUFDQSxDQUFDQSxhQUFhQSxDQUFDQSxNQUFNQSxHQUFHQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUM3QkEsSUFBSUEsc0JBQXNCQSxHQUFHQSxhQUFhQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtZQUN0REEsTUFBTUEsQ0FBQ0EsZUFDSEEsSUFBSUEsQ0FBQ0EsUUFBUUEsb0ZBQ1hBLHNCQUFzQkEsd0JBRTNCQSxDQUFDQTtRQUNKQSxDQUFDQTtRQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtZQUNOQSxNQUFNQSxDQUFDQSxFQUFFQSxDQUFDQTtRQUNaQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUVEYixnQkFBZ0JBO0lBQ2hCQSx5RUFBb0NBLEdBQXBDQTtRQUNFYyxJQUFJQSxhQUFhQSxHQUFHQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSx5QkFBeUJBLENBQUNBLElBQUlBLENBQUNBLGdCQUFnQkEsQ0FBQ0EsQ0FBQ0E7UUFDakZBLEVBQUVBLENBQUNBLENBQUNBLGFBQWFBLENBQUNBLE1BQU1BLEdBQUdBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQzdCQSxJQUFJQSxzQkFBc0JBLEdBQUdBLGFBQWFBLENBQUNBLElBQUlBLENBQUNBLElBQUlBLENBQUNBLENBQUNBO1lBQ3REQSxNQUFNQSxDQUFDQSxlQUNIQSxJQUFJQSxDQUFDQSxRQUFRQSxpRkFDWEEsc0JBQXNCQSx3QkFFM0JBLENBQUNBO1FBQ0pBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLENBQUNBO1lBQ05BLE1BQU1BLENBQUNBLEVBQUVBLENBQUNBO1FBQ1pBLENBQUNBO0lBQ0hBLENBQUNBO0lBRURkLGdCQUFnQkE7SUFDaEJBLG1EQUFjQSxHQUFkQSxVQUFlQSxFQUFpQkE7UUFDOUJlLElBQUlBLEtBQUtBLEdBQWFBLEVBQUVBLENBQUNBO1FBQ3pCQSxJQUFJQSxDQUFDQSxlQUFlQSxHQUFHQSxFQUFFQSxDQUFDQTtRQUUxQkEsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsRUFBRUEsQ0FBQ0EsR0FBR0EsRUFBRUEsQ0FBQ0EsTUFBTUEsRUFBRUEsQ0FBQ0EsRUFBRUEsRUFBRUEsQ0FBQ0E7WUFDbkNBLElBQUlBLElBQUlBLFNBQUFBLENBQUNBO1lBQ1RBLElBQUlBLENBQUNBLEdBQUdBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBRWRBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLGlCQUFpQkEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7Z0JBQzFCQSxJQUFJQSxHQUFHQSxJQUFJQSxDQUFDQSxzQkFBc0JBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQ3hDQSxDQUFDQTtZQUFDQSxJQUFJQSxDQUFDQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxZQUFZQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQTtnQkFDNUJBLElBQUlBLEdBQUdBLElBQUlBLENBQUNBLGFBQWFBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQy9CQSxDQUFDQTtZQUFDQSxJQUFJQSxDQUFDQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSx1QkFBdUJBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBO2dCQUN2Q0EsSUFBSUEsR0FBR0EsSUFBSUEsQ0FBQ0EsbUJBQW1CQSxDQUFDQSxDQUFDQSxFQUFFQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxZQUFZQSxDQUFDQSxDQUFDQSxDQUFDQSxZQUFZQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUMvRUEsQ0FBQ0E7WUFBQ0EsSUFBSUEsQ0FBQ0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EseUJBQXlCQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQTtnQkFDekNBLElBQUlBLEdBQUdBLElBQUlBLENBQUNBLHFCQUFxQkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDdkNBLENBQUNBO1lBQUNBLElBQUlBLENBQUNBLENBQUNBO2dCQUNOQSxJQUFJQSxHQUFHQSxJQUFJQSxDQUFDQSxrQkFBa0JBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQ3BDQSxDQUFDQTtZQUVEQSxJQUFJQSxHQUFHQSxlQUNIQSxJQUFJQSxDQUFDQSxvQkFBb0JBLENBQUNBLENBQUNBLENBQUNBLGtCQUM1QkEsSUFBSUEsa0JBQ0pBLElBQUlBLENBQUNBLHdCQUF3QkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0Esa0JBQ2hDQSxJQUFJQSxDQUFDQSxrQkFBa0JBLENBQUNBLENBQUNBLENBQUNBLGFBQzdCQSxDQUFDQTtZQUVGQSxLQUFLQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtRQUNuQkEsQ0FBQ0E7UUFFREEsTUFBTUEsQ0FBQ0EsS0FBS0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7SUFDMUJBLENBQUNBO0lBRURmLGdCQUFnQkE7SUFDaEJBLHdEQUFtQkEsR0FBbkJBLFVBQW9CQSxDQUFjQSxFQUFFQSxTQUFpQkE7UUFDbkRnQixJQUFJQSxXQUFXQSxHQUFHQSxDQUFDQSxDQUFDQSxJQUFJQSxLQUFLQSx5QkFBVUEsQ0FBQ0EsYUFBYUEsR0FBR0EsR0FBR0EsR0FBR0EsRUFBRUEsQ0FBQ0E7UUFDakVBLElBQUlBLENBQUNBLGVBQWVBLENBQUNBLElBQUlBLENBQUNBLENBQUNBLENBQUNBLFNBQVNBLENBQUNBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBLENBQUNBO1FBRTlDQSxNQUFNQSxDQUFDQSxTQUFPQSxXQUFXQSxHQUFHQSxTQUFTQSxRQUFLQSxDQUFDQTtJQUM3Q0EsQ0FBQ0E7SUFFRGhCLGdCQUFnQkE7SUFDaEJBLDBEQUFxQkEsR0FBckJBLFVBQXNCQSxDQUFjQTtRQUNsQ2lCLElBQUlBLENBQUNBLGVBQWVBLENBQUNBLEdBQUdBLEVBQUVBLENBQUNBO1FBQzNCQSxJQUFJQSxDQUFDQSxlQUFlQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQSxDQUFDQSxTQUFTQSxDQUFDQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUM5Q0EsTUFBTUEsQ0FBQ0EsVUFBVUEsQ0FBQ0E7SUFDcEJBLENBQUNBO0lBRURqQixnQkFBZ0JBO0lBQ2hCQSx1REFBa0JBLEdBQWxCQSxVQUFtQkEsVUFBa0JBO1FBQ25Da0IsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0Esd0JBQVdBLENBQUNBLE9BQU9BLENBQUNBLElBQUlBLENBQUNBLGVBQWVBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQy9DQSxJQUFJQSxVQUFVQSxHQUFHQSx3QkFBV0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsZUFBZUEsQ0FBQ0EsQ0FBQ0E7WUFDeERBLEVBQUVBLENBQUNBLENBQUNBLFVBQVVBLEtBQUtBLFVBQVVBLENBQUNBLENBQUNBLENBQUNBO2dCQUM5QkEsSUFBSUEsQ0FBQ0EsZUFBZUEsQ0FBQ0EsR0FBR0EsRUFBRUEsQ0FBQ0E7Z0JBQzNCQSxNQUFNQSxDQUFDQSxHQUFHQSxDQUFDQTtZQUNiQSxDQUFDQTtRQUNIQSxDQUFDQTtRQUVEQSxNQUFNQSxDQUFDQSxFQUFFQSxDQUFDQTtJQUNaQSxDQUFDQTtJQUVEbEIsZ0JBQWdCQTtJQUNoQkEsMkRBQXNCQSxHQUF0QkEsVUFBdUJBLENBQWNBO1FBQ25DbUIsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsSUFBSUEsS0FBS0EsU0FBU0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDekJBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLFdBQVdBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1FBQzdCQSxDQUFDQTtRQUFDQSxJQUFJQSxDQUFDQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxJQUFJQSxLQUFLQSxRQUFRQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUMvQkEsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsVUFBVUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDNUJBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLElBQUlBLEtBQUtBLFdBQVdBLENBQUNBLENBQUNBLENBQUNBO1lBQ2xDQSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQSxZQUFZQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUM5QkEsQ0FBQ0E7UUFBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7WUFDTkEsTUFBTUEsSUFBSUEsMEJBQWFBLENBQUNBLDhCQUE0QkEsQ0FBQ0EsQ0FBQ0EsSUFBSUEsTUFBR0EsQ0FBQ0EsQ0FBQ0E7UUFDakVBLENBQUNBO0lBQ0hBLENBQUNBO0lBRURuQixnQkFBZ0JBO0lBQ2hCQSxrREFBYUEsR0FBYkEsVUFBY0EsQ0FBY0E7UUFBNUJvQixpQkFzQ0NBO1FBckNDQSxJQUFJQSxPQUFPQSxHQUFHQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxZQUFZQSxDQUFDQSxDQUFDQSxDQUFDQSxZQUFZQSxDQUFDQSxDQUFDQTtRQUN2REEsSUFBSUEsU0FBU0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsVUFBQ0EsR0FBR0EsSUFBS0EsT0FBQUEsS0FBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsWUFBWUEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsRUFBN0JBLENBQTZCQSxDQUFDQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtRQUU5RUEsSUFBSUEsUUFBUUEsR0FBR0EsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsWUFBWUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsU0FBU0EsQ0FBQ0EsQ0FBQ0E7UUFDckRBLElBQUlBLFFBQVFBLEdBQUdBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLFlBQVlBLENBQUNBLENBQUNBLENBQUNBLFNBQVNBLENBQUNBLENBQUNBO1FBRXJEQSxJQUFJQSxJQUFJQSxHQUFHQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxXQUFXQSxDQUFDQSxDQUFDQSxDQUFDQSxTQUFTQSxDQUFDQSxDQUFDQTtRQUNoREEsSUFBSUEsUUFBUUEsR0FBR0EsQ0FBQ0EsQ0FBQ0EsSUFBSUEsQ0FBQ0E7UUFFdEJBLElBQUlBLElBQUlBLEdBQUdBLGlCQUNIQSxJQUFJQSxhQUFRQSxJQUFJQSxDQUFDQSwwQkFBMEJBLG1DQUM3Q0EsSUFBSUEsV0FBTUEsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0Esb0JBQW9CQSxFQUFFQSxjQUFTQSxRQUFRQSx1QkFFbEVBLENBQUNBO1FBQ0ZBLElBQUlBLElBQUlBLEdBQU1BLFFBQVFBLFdBQU1BLElBQUlBLHdCQUFtQkEsT0FBT0EsV0FBTUEsU0FBU0EsUUFBS0EsQ0FBQ0E7UUFFL0VBLElBQUlBLGdCQUFnQkEsR0FBR0EsQ0FBQ0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsVUFBQ0EsQ0FBQ0EsSUFBS0EsT0FBQUEsS0FBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsYUFBYUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsRUFBNUJBLENBQTRCQSxDQUFDQSxDQUFDQTtRQUN2RUEsZ0JBQWdCQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxhQUFhQSxDQUFDQSxDQUFDQSxDQUFDQSxZQUFZQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUNqRUEsSUFBSUEsU0FBU0EsR0FBR0EsTUFBSUEsSUFBSUEsa0JBQWFBLGdCQUFnQkEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsTUFBR0EsQ0FBQ0E7UUFFdEVBLElBQUlBLEtBQUtBLEdBQUdBLGlCQUNKQSxJQUFJQSxDQUFDQSwwQkFBMEJBLDJCQUFzQkEsUUFBUUEsVUFBS0EsUUFBUUEsc0JBQzVFQSxRQUFRQSxXQUFNQSxJQUFJQSxDQUFDQSwwQkFBMEJBLHFCQUFnQkEsUUFBUUEsbUJBQ3JFQSxJQUFJQSxDQUFDQSxnQkFBZ0JBLENBQUNBLENBQUNBLENBQUNBLGtCQUN4QkEsSUFBSUEsQ0FBQ0EsNEJBQTRCQSxDQUFDQSxDQUFDQSxDQUFDQSxrQkFDcENBLElBQUlBLENBQUNBLGdCQUFnQkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0Esa0JBQ3hCQSxRQUFRQSxXQUFNQSxRQUFRQSxxQkFFM0JBLENBQUNBO1FBRUZBLElBQUlBLE9BQU9BLEdBQUdBLENBQUNBLENBQUNBLGVBQWVBLEVBQUVBLEdBQUdBLEtBQUdBLElBQUlBLEdBQUdBLEtBQU9BLEdBQUdBLElBQUlBLENBQUNBO1FBRTdEQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxtQkFBbUJBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBO1lBQzVCQSxNQUFNQSxDQUFJQSxJQUFJQSxhQUFRQSxTQUFTQSxZQUFPQSxPQUFPQSxrQkFBYUEsUUFBUUEsV0FBTUEsUUFBUUEsUUFBS0EsQ0FBQ0E7UUFDeEZBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLENBQUNBO1lBQ05BLE1BQU1BLENBQUlBLElBQUlBLGFBQVFBLFNBQVNBLFlBQU9BLE9BQU9BLE9BQUlBLENBQUNBO1FBQ3BEQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUVEcEIsZ0JBQWdCQTtJQUNoQkEsdURBQWtCQSxHQUFsQkEsVUFBbUJBLENBQWNBO1FBQWpDcUIsaUJBNEJDQTtRQTNCQ0EsSUFBSUEsUUFBUUEsR0FBR0EsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsWUFBWUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsU0FBU0EsQ0FBQ0EsQ0FBQ0E7UUFDckRBLElBQUlBLFFBQVFBLEdBQUdBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLFlBQVlBLENBQUNBLENBQUNBLENBQUNBLFNBQVNBLENBQUNBLENBQUNBO1FBQ3JEQSxJQUFJQSxJQUFJQSxHQUFHQSxhQUNQQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSwyQkFBMkJBLENBQUNBLENBQUNBLENBQUNBLFdBQzdDQSxDQUFDQTtRQUVGQSxJQUFJQSxLQUFLQSxHQUFHQSxpQkFDSkEsSUFBSUEsQ0FBQ0EsMEJBQTBCQSwyQkFBc0JBLFFBQVFBLFVBQUtBLFFBQVFBLHNCQUM1RUEsSUFBSUEsQ0FBQ0EsZ0JBQWdCQSxDQUFDQSxDQUFDQSxDQUFDQSxrQkFDeEJBLElBQUlBLENBQUNBLDRCQUE0QkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0Esa0JBQ3BDQSxJQUFJQSxDQUFDQSxnQkFBZ0JBLENBQUNBLENBQUNBLENBQUNBLGtCQUN4QkEsUUFBUUEsV0FBTUEsUUFBUUEscUJBRTNCQSxDQUFDQTtRQUVGQSxJQUFJQSxPQUFPQSxHQUFHQSxDQUFDQSxDQUFDQSxlQUFlQSxFQUFFQSxHQUFHQSxLQUFHQSxJQUFJQSxHQUFHQSxLQUFPQSxHQUFHQSxJQUFJQSxDQUFDQTtRQUU3REEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsY0FBY0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDdkJBLElBQUlBLFNBQVNBLEdBQUdBLENBQUNBLENBQUNBLElBQUlBLENBQUNBLEdBQUdBLENBQUNBLFVBQUNBLENBQUNBLElBQUtBLE9BQUFBLEtBQUlBLENBQUNBLE1BQU1BLENBQUNBLGFBQWFBLENBQUNBLENBQUNBLENBQUNBLEVBQTVCQSxDQUE0QkEsQ0FBQ0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsQ0FBQ0E7WUFDN0VBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLG1CQUFtQkEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7Z0JBQzVCQSxNQUFNQSxDQUFDQSxTQUFPQSxTQUFTQSxZQUFPQSxPQUFPQSxrQkFBYUEsUUFBUUEsV0FBTUEsUUFBUUEsUUFBS0EsQ0FBQ0E7WUFDaEZBLENBQUNBO1lBQUNBLElBQUlBLENBQUNBLENBQUNBO2dCQUNOQSxNQUFNQSxDQUFDQSxTQUFPQSxTQUFTQSxZQUFPQSxPQUFPQSxPQUFJQSxDQUFDQTtZQUM1Q0EsQ0FBQ0E7UUFDSEEsQ0FBQ0E7UUFBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7WUFDTkEsTUFBTUEsQ0FBQ0EsT0FBT0EsQ0FBQ0E7UUFDakJBLENBQUNBO0lBQ0hBLENBQUNBO0lBRURyQixnQkFBZ0JBO0lBQ2hCQSxxREFBZ0JBLEdBQWhCQSxVQUFpQkEsQ0FBY0E7UUFDN0JzQixNQUFNQSxDQUFDQSxDQUFDQSxDQUFDQSxzQkFBc0JBLEdBQU1BLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLGFBQWFBLENBQUNBLENBQUNBLENBQUNBLFNBQVNBLENBQUNBLFlBQVNBLEdBQUdBLEVBQUVBLENBQUNBO0lBQzVGQSxDQUFDQTtJQUVEdEIsZ0JBQWdCQTtJQUNoQkEsaUVBQTRCQSxHQUE1QkEsVUFBNkJBLENBQWNBO1FBQ3pDdUIsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsYUFBYUEsQ0FBQ0E7WUFBQ0EsTUFBTUEsQ0FBQ0EsRUFBRUEsQ0FBQ0E7UUFFaENBLElBQUlBLFFBQVFBLEdBQUdBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLFlBQVlBLENBQUNBLENBQUNBLENBQUNBLFNBQVNBLENBQUNBLENBQUNBO1FBQ3JEQSxJQUFJQSxRQUFRQSxHQUFHQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxZQUFZQSxDQUFDQSxDQUFDQSxDQUFDQSxTQUFTQSxDQUFDQSxDQUFDQTtRQUNyREEsSUFBSUEsV0FBV0EsR0FBR0EsSUFBSUEsQ0FBQ0EsU0FBU0EsQ0FBQ0EsZ0JBQWdCQSxHQUFHQSwyQkFBeUJBLFFBQVFBLE9BQUlBLEdBQUdBLEVBQUVBLENBQUNBO1FBRS9GQSxJQUFJQSxFQUFFQSxHQUFHQSxDQUFDQSxDQUFDQSxhQUFhQSxDQUFDQTtRQUN6QkEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsRUFBRUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsV0FBV0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDNUJBLElBQUlBLGlCQUFpQkEsR0FDZEEsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsZ0JBQWdCQSxDQUFDQSxFQUFFQSxDQUFDQSxlQUFlQSxDQUFDQSxjQUFjQSxDQUFDQSxTQUFJQSxFQUFFQSxDQUFDQSxNQUFNQSxDQUFDQSxJQUFNQSxDQUFDQTtZQUMzRkEsTUFBTUEsQ0FBQ0EsZUFDSEEsSUFBSUEsQ0FBQ0Esc0JBQXNCQSxDQUFDQSxRQUFRQSxFQUFFQSxRQUFRQSxDQUFDQSxrQkFDL0NBLGlCQUFpQkEsV0FBTUEsUUFBUUEsbUJBQy9CQSxXQUFXQSxrQkFDWEEsZ0JBQWdCQSxxQkFDbkJBLENBQUNBO1FBQ0pBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLENBQUNBO1lBQ05BLE1BQU1BLENBQUNBLGVBQ0hBLElBQUlBLENBQUNBLHNCQUFzQkEsQ0FBQ0EsUUFBUUEsRUFBRUEsUUFBUUEsQ0FBQ0Esd0NBQ3pCQSxRQUFRQSxvQkFDOUJBLFdBQVdBLGFBQ2RBLENBQUNBO1FBQ0pBLENBQUNBO0lBQ0hBLENBQUNBO0lBRUR2QixnQkFBZ0JBO0lBQ2hCQSwyREFBc0JBLEdBQXRCQSxVQUF1QkEsUUFBZ0JBLEVBQUVBLFFBQWdCQTtRQUN2RHdCLEVBQUVBLENBQUNBLENBQUNBLHdCQUFpQkEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDeEJBLE1BQU1BLENBQUNBLHNFQUV1QkEsUUFBUUEsVUFBS0EsUUFBUUEsNEJBRWhEQSxDQUFDQTtRQUNOQSxDQUFDQTtRQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtZQUNOQSxNQUFNQSxDQUFDQSxFQUFFQSxDQUFDQTtRQUNaQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUVEeEIsZ0JBQWdCQTtJQUNoQkEscURBQWdCQSxHQUFoQkEsVUFBaUJBLENBQWNBO1FBQzdCeUIsSUFBSUEsUUFBUUEsR0FBR0EsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsWUFBWUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsU0FBU0EsQ0FBQ0EsQ0FBQ0E7UUFDckRBLElBQUlBLFFBQVFBLEdBQUdBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLFlBQVlBLENBQUNBLENBQUNBLENBQUNBLFNBQVNBLENBQUNBLENBQUNBO1FBQ3JEQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxhQUFhQSxDQUFDQSxhQUFhQSxFQUFFQSxDQUFDQTtZQUFDQSxNQUFNQSxDQUFDQSxFQUFFQSxDQUFDQTtRQUNoREEsTUFBTUEsQ0FBSUEsYUFBYUEsMEJBQXFCQSxhQUFhQSxVQUFLQSxRQUFRQSxVQUFLQSxRQUFRQSxPQUFJQSxDQUFDQTtJQUMxRkEsQ0FBQ0E7SUFFRHpCLGdCQUFnQkE7SUFDaEJBLHlEQUFvQkEsR0FBcEJBLFVBQXFCQSxDQUFjQTtRQUNqQzBCLElBQUlBLElBQUlBLEdBQUdBLDJDQUFtQkEsQ0FBQ0EsWUFBWUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsT0FBT0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsU0FBU0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDM0VBLElBQUlBLGNBQWNBLEdBQUdBLGNBQU9BLENBQUNBLElBQUlBLENBQUNBLElBQUlBLElBQUlBLENBQUNBLGFBQWFBLEtBQUtBLENBQUNBLENBQUNBLGFBQWFBLENBQUNBO1FBQzdFQSxNQUFNQSxDQUFDQSxjQUFjQSxJQUFJQSxDQUFDQSxDQUFDQSxDQUFDQSxhQUFhQSxDQUFDQSxvQkFBb0JBLEVBQUVBO1lBQ2xEQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSx1QkFBdUJBLEVBQUVBLFdBQU1BLENBQUNBLENBQUNBLG9CQUFvQkEsTUFBR0E7WUFDdkVBLEVBQUVBLENBQUNBO0lBQ2hCQSxDQUFDQTtJQUVEMUIsZ0JBQWdCQTtJQUNoQkEsNkRBQXdCQSxHQUF4QkEsVUFBeUJBLENBQWNBO1FBQ3JDMkIsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsZUFBZUEsQ0FBQ0E7WUFBQ0EsTUFBTUEsQ0FBQ0EsRUFBRUEsQ0FBQ0E7UUFDbENBLE1BQU1BLENBQUNBLGFBQ0hBLGFBQWFBLHdCQUNiQSxJQUFJQSxDQUFDQSx5QkFBeUJBLENBQUNBLENBQUNBLENBQUNBLGdCQUNqQ0EsZ0JBQWdCQSxvQkFDbkJBLENBQUNBO0lBQ0pBLENBQUNBO0lBRUQzQixnQkFBZ0JBO0lBQ2hCQSxnREFBV0EsR0FBWEEsVUFBWUEsQ0FBY0E7UUFDeEI0QixJQUFJQSxFQUFFQSxHQUFHQSxDQUFDQSxDQUFDQSxhQUFhQSxDQUFDQTtRQUN6QkEsTUFBTUEsQ0FBQ0EseUJBQXVCQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxnQkFBZ0JBLENBQUNBLEVBQUVBLENBQUNBLGVBQWVBLENBQUNBLGNBQWNBLENBQUNBLGtCQUFlQSxDQUFDQTtJQUMvR0EsQ0FBQ0E7SUFFRDVCLGdCQUFnQkE7SUFDaEJBLCtDQUFVQSxHQUFWQSxVQUFXQSxDQUFjQTtRQUN2QjZCLElBQUlBLEVBQUVBLEdBQUdBLENBQUNBLENBQUNBLGFBQWFBLENBQUNBO1FBQ3pCQSxNQUFNQSxDQUFDQSwyQkFBeUJBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLFlBQVlBLEVBQUVBLGFBQVFBLElBQUlBLENBQUNBLDBCQUEwQkEsdUJBQWtCQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxnQkFBZ0JBLENBQUNBLEVBQUVBLENBQUNBLGVBQWVBLENBQUNBLGNBQWNBLENBQUNBLGlCQUFjQSxDQUFDQTtJQUNuTUEsQ0FBQ0E7SUFFRDdCLGdCQUFnQkE7SUFDaEJBLGlEQUFZQSxHQUFaQSxVQUFhQSxDQUFjQTtRQUN6QjhCLElBQUlBLEVBQUVBLEdBQUdBLENBQUNBLENBQUNBLGFBQWFBLENBQUNBO1FBQ3pCQSxNQUFNQSxDQUFDQSwyQkFBeUJBLGFBQWFBLFVBQUtBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLGdCQUFnQkEsQ0FBQ0EsRUFBRUEsQ0FBQ0EsZUFBZUEsQ0FBQ0EsY0FBY0EsQ0FBQ0EscUJBQWdCQSxhQUFhQSxPQUFJQSxDQUFDQTtJQUNySkEsQ0FBQ0E7SUFFRDlCLGdCQUFnQkE7SUFDaEJBLDhEQUF5QkEsR0FBekJBLFVBQTBCQSxDQUFjQTtRQUN0QytCLElBQUlBLEVBQUVBLEdBQUdBLENBQUNBLENBQUNBLGFBQWFBLENBQUNBO1FBQ3pCQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxlQUFlQSxJQUFJQSxFQUFFQSxDQUFDQSx3QkFBd0JBLEVBQUVBLENBQUNBO1lBQUNBLE1BQU1BLENBQUNBLEVBQUVBLENBQUNBO1FBQ25FQSxJQUFJQSxNQUFNQSxHQUFHQSxnQkFDTkEsZ0JBQWdCQSxxQkFDakJBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLGVBQWVBLENBQUNBLEVBQUVBLENBQUNBLGVBQWVBLENBQUNBLGNBQWNBLENBQUNBLHVDQUVuRUEsQ0FBQ0E7UUFDRkEsTUFBTUEsQ0FBQ0EsTUFBTUEsQ0FBQ0E7SUFDaEJBLENBQUNBO0lBQ0gvQixpQ0FBQ0E7QUFBREEsQ0FBQ0EsQUF2ZEQsSUF1ZEM7QUF2ZFksa0NBQTBCLDZCQXVkdEMsQ0FBQSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7VHlwZSwgYXNzZXJ0aW9uc0VuYWJsZWQsIGlzQmxhbmssIGlzUHJlc2VudCwgU3RyaW5nV3JhcHBlcn0gZnJvbSAnYW5ndWxhcjIvc3JjL2ZhY2FkZS9sYW5nJztcbmltcG9ydCB7QmFzZUV4Y2VwdGlvbn0gZnJvbSAnYW5ndWxhcjIvc3JjL2ZhY2FkZS9leGNlcHRpb25zJztcbmltcG9ydCB7TGlzdFdyYXBwZXIsIE1hcFdyYXBwZXIsIFN0cmluZ01hcFdyYXBwZXJ9IGZyb20gJ2FuZ3VsYXIyL3NyYy9mYWNhZGUvY29sbGVjdGlvbic7XG5cbmltcG9ydCB7QWJzdHJhY3RDaGFuZ2VEZXRlY3Rvcn0gZnJvbSAnLi9hYnN0cmFjdF9jaGFuZ2VfZGV0ZWN0b3InO1xuaW1wb3J0IHtDaGFuZ2VEZXRlY3Rpb25VdGlsfSBmcm9tICcuL2NoYW5nZV9kZXRlY3Rpb25fdXRpbCc7XG5pbXBvcnQge0RpcmVjdGl2ZUluZGV4LCBEaXJlY3RpdmVSZWNvcmR9IGZyb20gJy4vZGlyZWN0aXZlX3JlY29yZCc7XG5cbmltcG9ydCB7UHJvdG9SZWNvcmQsIFJlY29yZFR5cGV9IGZyb20gJy4vcHJvdG9fcmVjb3JkJztcbmltcG9ydCB7Q29kZWdlbk5hbWVVdGlsLCBzYW5pdGl6ZU5hbWV9IGZyb20gJy4vY29kZWdlbl9uYW1lX3V0aWwnO1xuaW1wb3J0IHtDb2RlZ2VuTG9naWNVdGlsfSBmcm9tICcuL2NvZGVnZW5fbG9naWNfdXRpbCc7XG5pbXBvcnQge2NvZGlmeX0gZnJvbSAnLi9jb2RlZ2VuX2ZhY2FkZSc7XG5pbXBvcnQge0V2ZW50QmluZGluZ30gZnJvbSAnLi9ldmVudF9iaW5kaW5nJztcbmltcG9ydCB7QmluZGluZ1RhcmdldH0gZnJvbSAnLi9iaW5kaW5nX3JlY29yZCc7XG5pbXBvcnQge0NoYW5nZURldGVjdG9yR2VuQ29uZmlnLCBDaGFuZ2VEZXRlY3RvckRlZmluaXRpb259IGZyb20gJy4vaW50ZXJmYWNlcyc7XG5pbXBvcnQge0NoYW5nZURldGVjdGlvblN0cmF0ZWd5LCBDaGFuZ2VEZXRlY3RvclN0YXRlfSBmcm9tICcuL2NvbnN0YW50cyc7XG5pbXBvcnQge2NyZWF0ZVByb3BlcnR5UmVjb3JkcywgY3JlYXRlRXZlbnRSZWNvcmRzfSBmcm9tICcuL3Byb3RvX2NoYW5nZV9kZXRlY3Rvcic7XG5cbi8qKlxuICogVGhlIGNvZGUgZ2VuZXJhdG9yIHRha2VzIGEgbGlzdCBvZiBwcm90byByZWNvcmRzIGFuZCBjcmVhdGVzIGEgZnVuY3Rpb24vY2xhc3NcbiAqIHRoYXQgXCJlbXVsYXRlc1wiIHdoYXQgdGhlIGRldmVsb3BlciB3b3VsZCB3cml0ZSBieSBoYW5kIHRvIGltcGxlbWVudCB0aGUgc2FtZVxuICoga2luZCBvZiBiZWhhdmlvdXIuXG4gKlxuICogVGhpcyBjb2RlIHNob3VsZCBiZSBrZXB0IGluIHN5bmMgd2l0aCB0aGUgRGFydCB0cmFuc2Zvcm1lcidzXG4gKiBgYW5ndWxhcjIudHJhbnNmb3JtLnRlbXBsYXRlX2NvbXBpbGVyLmNoYW5nZV9kZXRlY3Rvcl9jb2RlZ2VuYCBsaWJyYXJ5LiBJZiB5b3UgbWFrZSB1cGRhdGVzXG4gKiBoZXJlLCBwbGVhc2UgbWFrZSBlcXVpdmFsZW50IGNoYW5nZXMgdGhlcmUuXG4qL1xuY29uc3QgSVNfQ0hBTkdFRF9MT0NBTCA9IFwiaXNDaGFuZ2VkXCI7XG5jb25zdCBDSEFOR0VTX0xPQ0FMID0gXCJjaGFuZ2VzXCI7XG5cbmV4cG9ydCBjbGFzcyBDaGFuZ2VEZXRlY3RvckpJVEdlbmVyYXRvciB7XG4gIHByaXZhdGUgX2xvZ2ljOiBDb2RlZ2VuTG9naWNVdGlsO1xuICBwcml2YXRlIF9uYW1lczogQ29kZWdlbk5hbWVVdGlsO1xuICBwcml2YXRlIF9lbmRPZkJsb2NrSWR4czogbnVtYmVyW107XG4gIHByaXZhdGUgaWQ6IHN0cmluZztcbiAgcHJpdmF0ZSBjaGFuZ2VEZXRlY3Rpb25TdHJhdGVneTogQ2hhbmdlRGV0ZWN0aW9uU3RyYXRlZ3k7XG4gIHByaXZhdGUgcmVjb3JkczogUHJvdG9SZWNvcmRbXTtcbiAgcHJpdmF0ZSBwcm9wZXJ0eUJpbmRpbmdUYXJnZXRzOiBCaW5kaW5nVGFyZ2V0W107XG4gIHByaXZhdGUgZXZlbnRCaW5kaW5nczogRXZlbnRCaW5kaW5nW107XG4gIHByaXZhdGUgZGlyZWN0aXZlUmVjb3JkczogYW55W107XG4gIHByaXZhdGUgZ2VuQ29uZmlnOiBDaGFuZ2VEZXRlY3RvckdlbkNvbmZpZztcbiAgdHlwZU5hbWU6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihkZWZpbml0aW9uOiBDaGFuZ2VEZXRlY3RvckRlZmluaXRpb24sIHByaXZhdGUgY2hhbmdlRGV0ZWN0aW9uVXRpbFZhck5hbWU6IHN0cmluZyxcbiAgICAgICAgICAgICAgcHJpdmF0ZSBhYnN0cmFjdENoYW5nZURldGVjdG9yVmFyTmFtZTogc3RyaW5nLFxuICAgICAgICAgICAgICBwcml2YXRlIGNoYW5nZURldGVjdG9yU3RhdGVWYXJOYW1lOiBzdHJpbmcpIHtcbiAgICB2YXIgcHJvcGVydHlCaW5kaW5nUmVjb3JkcyA9IGNyZWF0ZVByb3BlcnR5UmVjb3JkcyhkZWZpbml0aW9uKTtcbiAgICB2YXIgZXZlbnRCaW5kaW5nUmVjb3JkcyA9IGNyZWF0ZUV2ZW50UmVjb3JkcyhkZWZpbml0aW9uKTtcbiAgICB2YXIgcHJvcGVydHlCaW5kaW5nVGFyZ2V0cyA9IGRlZmluaXRpb24uYmluZGluZ1JlY29yZHMubWFwKGIgPT4gYi50YXJnZXQpO1xuICAgIHRoaXMuaWQgPSBkZWZpbml0aW9uLmlkO1xuICAgIHRoaXMuY2hhbmdlRGV0ZWN0aW9uU3RyYXRlZ3kgPSBkZWZpbml0aW9uLnN0cmF0ZWd5O1xuICAgIHRoaXMuZ2VuQ29uZmlnID0gZGVmaW5pdGlvbi5nZW5Db25maWc7XG5cbiAgICB0aGlzLnJlY29yZHMgPSBwcm9wZXJ0eUJpbmRpbmdSZWNvcmRzO1xuICAgIHRoaXMucHJvcGVydHlCaW5kaW5nVGFyZ2V0cyA9IHByb3BlcnR5QmluZGluZ1RhcmdldHM7XG4gICAgdGhpcy5ldmVudEJpbmRpbmdzID0gZXZlbnRCaW5kaW5nUmVjb3JkcztcbiAgICB0aGlzLmRpcmVjdGl2ZVJlY29yZHMgPSBkZWZpbml0aW9uLmRpcmVjdGl2ZVJlY29yZHM7XG4gICAgdGhpcy5fbmFtZXMgPSBuZXcgQ29kZWdlbk5hbWVVdGlsKHRoaXMucmVjb3JkcywgdGhpcy5ldmVudEJpbmRpbmdzLCB0aGlzLmRpcmVjdGl2ZVJlY29yZHMsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMuY2hhbmdlRGV0ZWN0aW9uVXRpbFZhck5hbWUpO1xuICAgIHRoaXMuX2xvZ2ljID1cbiAgICAgICAgbmV3IENvZGVnZW5Mb2dpY1V0aWwodGhpcy5fbmFtZXMsIHRoaXMuY2hhbmdlRGV0ZWN0aW9uVXRpbFZhck5hbWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMuY2hhbmdlRGV0ZWN0b3JTdGF0ZVZhck5hbWUsIHRoaXMuY2hhbmdlRGV0ZWN0aW9uU3RyYXRlZ3kpO1xuICAgIHRoaXMudHlwZU5hbWUgPSBzYW5pdGl6ZU5hbWUoYENoYW5nZURldGVjdG9yXyR7dGhpcy5pZH1gKTtcbiAgfVxuXG4gIGdlbmVyYXRlKCk6IEZ1bmN0aW9uIHtcbiAgICB2YXIgZmFjdG9yeVNvdXJjZSA9IGBcbiAgICAgICR7dGhpcy5nZW5lcmF0ZVNvdXJjZSgpfVxuICAgICAgcmV0dXJuIGZ1bmN0aW9uKGRpc3BhdGNoZXIpIHtcbiAgICAgICAgcmV0dXJuIG5ldyAke3RoaXMudHlwZU5hbWV9KGRpc3BhdGNoZXIpO1xuICAgICAgfVxuICAgIGA7XG4gICAgcmV0dXJuIG5ldyBGdW5jdGlvbih0aGlzLmFic3RyYWN0Q2hhbmdlRGV0ZWN0b3JWYXJOYW1lLCB0aGlzLmNoYW5nZURldGVjdGlvblV0aWxWYXJOYW1lLFxuICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5jaGFuZ2VEZXRlY3RvclN0YXRlVmFyTmFtZSwgZmFjdG9yeVNvdXJjZSkoXG4gICAgICAgIEFic3RyYWN0Q2hhbmdlRGV0ZWN0b3IsIENoYW5nZURldGVjdGlvblV0aWwsIENoYW5nZURldGVjdG9yU3RhdGUpO1xuICB9XG5cbiAgZ2VuZXJhdGVTb3VyY2UoKTogc3RyaW5nIHtcbiAgICByZXR1cm4gYFxuICAgICAgdmFyICR7dGhpcy50eXBlTmFtZX0gPSBmdW5jdGlvbiAke3RoaXMudHlwZU5hbWV9KGRpc3BhdGNoZXIpIHtcbiAgICAgICAgJHt0aGlzLmFic3RyYWN0Q2hhbmdlRGV0ZWN0b3JWYXJOYW1lfS5jYWxsKFxuICAgICAgICAgICAgdGhpcywgJHtKU09OLnN0cmluZ2lmeSh0aGlzLmlkKX0sIGRpc3BhdGNoZXIsICR7dGhpcy5yZWNvcmRzLmxlbmd0aH0sXG4gICAgICAgICAgICAke3RoaXMudHlwZU5hbWV9Lmdlbl9wcm9wZXJ0eUJpbmRpbmdUYXJnZXRzLCAke3RoaXMudHlwZU5hbWV9Lmdlbl9kaXJlY3RpdmVJbmRpY2VzLFxuICAgICAgICAgICAgJHtjb2RpZnkodGhpcy5jaGFuZ2VEZXRlY3Rpb25TdHJhdGVneSl9KTtcbiAgICAgICAgdGhpcy5kZWh5ZHJhdGVEaXJlY3RpdmVzKGZhbHNlKTtcbiAgICAgIH1cblxuICAgICAgJHt0aGlzLnR5cGVOYW1lfS5wcm90b3R5cGUgPSBPYmplY3QuY3JlYXRlKCR7dGhpcy5hYnN0cmFjdENoYW5nZURldGVjdG9yVmFyTmFtZX0ucHJvdG90eXBlKTtcblxuICAgICAgJHt0aGlzLnR5cGVOYW1lfS5wcm90b3R5cGUuZGV0ZWN0Q2hhbmdlc0luUmVjb3Jkc0ludGVybmFsID0gZnVuY3Rpb24odGhyb3dPbkNoYW5nZSkge1xuICAgICAgICAke3RoaXMuX25hbWVzLmdlbkluaXRMb2NhbHMoKX1cbiAgICAgICAgdmFyICR7SVNfQ0hBTkdFRF9MT0NBTH0gPSBmYWxzZTtcbiAgICAgICAgdmFyICR7Q0hBTkdFU19MT0NBTH0gPSBudWxsO1xuXG4gICAgICAgICR7dGhpcy5fZ2VuQWxsUmVjb3Jkcyh0aGlzLnJlY29yZHMpfVxuICAgICAgfVxuXG4gICAgICAke3RoaXMuX21heWJlR2VuSGFuZGxlRXZlbnRJbnRlcm5hbCgpfVxuXG4gICAgICAke3RoaXMuX21heWJlR2VuQWZ0ZXJDb250ZW50TGlmZWN5Y2xlQ2FsbGJhY2tzKCl9XG5cbiAgICAgICR7dGhpcy5fbWF5YmVHZW5BZnRlclZpZXdMaWZlY3ljbGVDYWxsYmFja3MoKX1cblxuICAgICAgJHt0aGlzLl9tYXliZUdlbkh5ZHJhdGVEaXJlY3RpdmVzKCl9XG5cbiAgICAgICR7dGhpcy5fbWF5YmVHZW5EZWh5ZHJhdGVEaXJlY3RpdmVzKCl9XG5cbiAgICAgICR7dGhpcy5fZ2VuUHJvcGVydHlCaW5kaW5nVGFyZ2V0cygpfVxuXG4gICAgICAke3RoaXMuX2dlbkRpcmVjdGl2ZUluZGljZXMoKX1cbiAgICBgO1xuICB9XG5cbiAgLyoqIEBpbnRlcm5hbCAqL1xuICBfZ2VuUHJvcGVydHlCaW5kaW5nVGFyZ2V0cygpOiBzdHJpbmcge1xuICAgIHZhciB0YXJnZXRzID0gdGhpcy5fbG9naWMuZ2VuUHJvcGVydHlCaW5kaW5nVGFyZ2V0cyh0aGlzLnByb3BlcnR5QmluZGluZ1RhcmdldHMsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMuZ2VuQ29uZmlnLmdlbkRlYnVnSW5mbyk7XG4gICAgcmV0dXJuIGAke3RoaXMudHlwZU5hbWV9Lmdlbl9wcm9wZXJ0eUJpbmRpbmdUYXJnZXRzID0gJHt0YXJnZXRzfTtgO1xuICB9XG5cbiAgLyoqIEBpbnRlcm5hbCAqL1xuICBfZ2VuRGlyZWN0aXZlSW5kaWNlcygpOiBzdHJpbmcge1xuICAgIHZhciBpbmRpY2VzID0gdGhpcy5fbG9naWMuZ2VuRGlyZWN0aXZlSW5kaWNlcyh0aGlzLmRpcmVjdGl2ZVJlY29yZHMpO1xuICAgIHJldHVybiBgJHt0aGlzLnR5cGVOYW1lfS5nZW5fZGlyZWN0aXZlSW5kaWNlcyA9ICR7aW5kaWNlc307YDtcbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgX21heWJlR2VuSGFuZGxlRXZlbnRJbnRlcm5hbCgpOiBzdHJpbmcge1xuICAgIGlmICh0aGlzLmV2ZW50QmluZGluZ3MubGVuZ3RoID4gMCkge1xuICAgICAgdmFyIGhhbmRsZXJzID0gdGhpcy5ldmVudEJpbmRpbmdzLm1hcChlYiA9PiB0aGlzLl9nZW5FdmVudEJpbmRpbmcoZWIpKS5qb2luKFwiXFxuXCIpO1xuICAgICAgcmV0dXJuIGBcbiAgICAgICAgJHt0aGlzLnR5cGVOYW1lfS5wcm90b3R5cGUuaGFuZGxlRXZlbnRJbnRlcm5hbCA9IGZ1bmN0aW9uKGV2ZW50TmFtZSwgZWxJbmRleCwgbG9jYWxzKSB7XG4gICAgICAgICAgdmFyICR7dGhpcy5fbmFtZXMuZ2V0UHJldmVudERlZmF1bHRBY2Nlc29yKCl9ID0gZmFsc2U7XG4gICAgICAgICAgJHt0aGlzLl9uYW1lcy5nZW5Jbml0RXZlbnRMb2NhbHMoKX1cbiAgICAgICAgICAke2hhbmRsZXJzfVxuICAgICAgICAgIHJldHVybiAke3RoaXMuX25hbWVzLmdldFByZXZlbnREZWZhdWx0QWNjZXNvcigpfTtcbiAgICAgICAgfVxuICAgICAgYDtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuICcnO1xuICAgIH1cbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgX2dlbkV2ZW50QmluZGluZyhlYjogRXZlbnRCaW5kaW5nKTogc3RyaW5nIHtcbiAgICBsZXQgY29kZXM6IFN0cmluZ1tdID0gW107XG4gICAgdGhpcy5fZW5kT2ZCbG9ja0lkeHMgPSBbXTtcblxuICAgIExpc3RXcmFwcGVyLmZvckVhY2hXaXRoSW5kZXgoZWIucmVjb3JkcywgKHIsIGkpID0+IHtcbiAgICAgIGxldCBjb2RlO1xuXG4gICAgICBpZiAoci5pc0NvbmRpdGlvbmFsU2tpcFJlY29yZCgpKSB7XG4gICAgICAgIGNvZGUgPSB0aGlzLl9nZW5Db25kaXRpb25hbFNraXAociwgdGhpcy5fbmFtZXMuZ2V0RXZlbnRMb2NhbE5hbWUoZWIsIGkpKTtcbiAgICAgIH0gZWxzZSBpZiAoci5pc1VuY29uZGl0aW9uYWxTa2lwUmVjb3JkKCkpIHtcbiAgICAgICAgY29kZSA9IHRoaXMuX2dlblVuY29uZGl0aW9uYWxTa2lwKHIpO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgY29kZSA9IHRoaXMuX2dlbkV2ZW50QmluZGluZ0V2YWwoZWIsIHIpO1xuICAgICAgfVxuXG4gICAgICBjb2RlICs9IHRoaXMuX2dlbkVuZE9mU2tpcEJsb2NrKGkpO1xuXG4gICAgICBjb2Rlcy5wdXNoKGNvZGUpO1xuICAgIH0pO1xuXG4gICAgcmV0dXJuIGBcbiAgICBpZiAoZXZlbnROYW1lID09PSBcIiR7ZWIuZXZlbnROYW1lfVwiICYmIGVsSW5kZXggPT09ICR7ZWIuZWxJbmRleH0pIHtcbiAgICAgICR7Y29kZXMuam9pbihcIlxcblwiKX1cbiAgICB9YDtcbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgX2dlbkV2ZW50QmluZGluZ0V2YWwoZWI6IEV2ZW50QmluZGluZywgcjogUHJvdG9SZWNvcmQpOiBzdHJpbmcge1xuICAgIGlmIChyLmxhc3RJbkJpbmRpbmcpIHtcbiAgICAgIHZhciBldmFsUmVjb3JkID0gdGhpcy5fbG9naWMuZ2VuRXZlbnRCaW5kaW5nRXZhbFZhbHVlKGViLCByKTtcbiAgICAgIHZhciBtYXJrUGF0aCA9IHRoaXMuX2dlbk1hcmtQYXRoVG9Sb290QXNDaGVja09uY2Uocik7XG4gICAgICB2YXIgcHJldkRlZmF1bHQgPSB0aGlzLl9nZW5VcGRhdGVQcmV2ZW50RGVmYXVsdChlYiwgcik7XG4gICAgICByZXR1cm4gYCR7ZXZhbFJlY29yZH1cXG4ke21hcmtQYXRofVxcbiR7cHJldkRlZmF1bHR9YDtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIHRoaXMuX2xvZ2ljLmdlbkV2ZW50QmluZGluZ0V2YWxWYWx1ZShlYiwgcik7XG4gICAgfVxuICB9XG5cbiAgLyoqIEBpbnRlcm5hbCAqL1xuICBfZ2VuTWFya1BhdGhUb1Jvb3RBc0NoZWNrT25jZShyOiBQcm90b1JlY29yZCk6IHN0cmluZyB7XG4gICAgdmFyIGJyID0gci5iaW5kaW5nUmVjb3JkO1xuICAgIGlmIChici5pc0RlZmF1bHRDaGFuZ2VEZXRlY3Rpb24oKSkge1xuICAgICAgcmV0dXJuIFwiXCI7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiBgJHt0aGlzLl9uYW1lcy5nZXREZXRlY3Rvck5hbWUoYnIuZGlyZWN0aXZlUmVjb3JkLmRpcmVjdGl2ZUluZGV4KX0ubWFya1BhdGhUb1Jvb3RBc0NoZWNrT25jZSgpO2A7XG4gICAgfVxuICB9XG5cbiAgLyoqIEBpbnRlcm5hbCAqL1xuICBfZ2VuVXBkYXRlUHJldmVudERlZmF1bHQoZWI6IEV2ZW50QmluZGluZywgcjogUHJvdG9SZWNvcmQpOiBzdHJpbmcge1xuICAgIHZhciBsb2NhbCA9IHRoaXMuX25hbWVzLmdldEV2ZW50TG9jYWxOYW1lKGViLCByLnNlbGZJbmRleCk7XG4gICAgcmV0dXJuIGBpZiAoJHtsb2NhbH0gPT09IGZhbHNlKSB7ICR7dGhpcy5fbmFtZXMuZ2V0UHJldmVudERlZmF1bHRBY2Nlc29yKCl9ID0gdHJ1ZX07YDtcbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgX21heWJlR2VuRGVoeWRyYXRlRGlyZWN0aXZlcygpOiBzdHJpbmcge1xuICAgIHZhciBkZXN0cm95UGlwZXNDb2RlID0gdGhpcy5fbmFtZXMuZ2VuUGlwZU9uRGVzdHJveSgpO1xuICAgIGlmIChkZXN0cm95UGlwZXNDb2RlKSB7XG4gICAgICBkZXN0cm95UGlwZXNDb2RlID0gYGlmIChkZXN0cm95UGlwZXMpIHsgJHtkZXN0cm95UGlwZXNDb2RlfSB9YDtcbiAgICB9XG4gICAgdmFyIGRlaHlkcmF0ZUZpZWxkc0NvZGUgPSB0aGlzLl9uYW1lcy5nZW5EZWh5ZHJhdGVGaWVsZHMoKTtcbiAgICBpZiAoIWRlc3Ryb3lQaXBlc0NvZGUgJiYgIWRlaHlkcmF0ZUZpZWxkc0NvZGUpIHJldHVybiAnJztcbiAgICByZXR1cm4gYCR7dGhpcy50eXBlTmFtZX0ucHJvdG90eXBlLmRlaHlkcmF0ZURpcmVjdGl2ZXMgPSBmdW5jdGlvbihkZXN0cm95UGlwZXMpIHtcbiAgICAgICAgJHtkZXN0cm95UGlwZXNDb2RlfVxuICAgICAgICAke2RlaHlkcmF0ZUZpZWxkc0NvZGV9XG4gICAgfWA7XG4gIH1cblxuICAvKiogQGludGVybmFsICovXG4gIF9tYXliZUdlbkh5ZHJhdGVEaXJlY3RpdmVzKCk6IHN0cmluZyB7XG4gICAgdmFyIGh5ZHJhdGVEaXJlY3RpdmVzQ29kZSA9IHRoaXMuX2xvZ2ljLmdlbkh5ZHJhdGVEaXJlY3RpdmVzKHRoaXMuZGlyZWN0aXZlUmVjb3Jkcyk7XG4gICAgdmFyIGh5ZHJhdGVEZXRlY3RvcnNDb2RlID0gdGhpcy5fbG9naWMuZ2VuSHlkcmF0ZURldGVjdG9ycyh0aGlzLmRpcmVjdGl2ZVJlY29yZHMpO1xuICAgIGlmICghaHlkcmF0ZURpcmVjdGl2ZXNDb2RlICYmICFoeWRyYXRlRGV0ZWN0b3JzQ29kZSkgcmV0dXJuICcnO1xuICAgIHJldHVybiBgJHt0aGlzLnR5cGVOYW1lfS5wcm90b3R5cGUuaHlkcmF0ZURpcmVjdGl2ZXMgPSBmdW5jdGlvbihkaXJlY3RpdmVzKSB7XG4gICAgICAke2h5ZHJhdGVEaXJlY3RpdmVzQ29kZX1cbiAgICAgICR7aHlkcmF0ZURldGVjdG9yc0NvZGV9XG4gICAgfWA7XG4gIH1cblxuICAvKiogQGludGVybmFsICovXG4gIF9tYXliZUdlbkFmdGVyQ29udGVudExpZmVjeWNsZUNhbGxiYWNrcygpOiBzdHJpbmcge1xuICAgIHZhciBub3RpZmljYXRpb25zID0gdGhpcy5fbG9naWMuZ2VuQ29udGVudExpZmVjeWNsZUNhbGxiYWNrcyh0aGlzLmRpcmVjdGl2ZVJlY29yZHMpO1xuICAgIGlmIChub3RpZmljYXRpb25zLmxlbmd0aCA+IDApIHtcbiAgICAgIHZhciBkaXJlY3RpdmVOb3RpZmljYXRpb25zID0gbm90aWZpY2F0aW9ucy5qb2luKFwiXFxuXCIpO1xuICAgICAgcmV0dXJuIGBcbiAgICAgICAgJHt0aGlzLnR5cGVOYW1lfS5wcm90b3R5cGUuYWZ0ZXJDb250ZW50TGlmZWN5Y2xlQ2FsbGJhY2tzSW50ZXJuYWwgPSBmdW5jdGlvbigpIHtcbiAgICAgICAgICAke2RpcmVjdGl2ZU5vdGlmaWNhdGlvbnN9XG4gICAgICAgIH1cbiAgICAgIGA7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiAnJztcbiAgICB9XG4gIH1cblxuICAvKiogQGludGVybmFsICovXG4gIF9tYXliZUdlbkFmdGVyVmlld0xpZmVjeWNsZUNhbGxiYWNrcygpOiBzdHJpbmcge1xuICAgIHZhciBub3RpZmljYXRpb25zID0gdGhpcy5fbG9naWMuZ2VuVmlld0xpZmVjeWNsZUNhbGxiYWNrcyh0aGlzLmRpcmVjdGl2ZVJlY29yZHMpO1xuICAgIGlmIChub3RpZmljYXRpb25zLmxlbmd0aCA+IDApIHtcbiAgICAgIHZhciBkaXJlY3RpdmVOb3RpZmljYXRpb25zID0gbm90aWZpY2F0aW9ucy5qb2luKFwiXFxuXCIpO1xuICAgICAgcmV0dXJuIGBcbiAgICAgICAgJHt0aGlzLnR5cGVOYW1lfS5wcm90b3R5cGUuYWZ0ZXJWaWV3TGlmZWN5Y2xlQ2FsbGJhY2tzSW50ZXJuYWwgPSBmdW5jdGlvbigpIHtcbiAgICAgICAgICAke2RpcmVjdGl2ZU5vdGlmaWNhdGlvbnN9XG4gICAgICAgIH1cbiAgICAgIGA7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiAnJztcbiAgICB9XG4gIH1cblxuICAvKiogQGludGVybmFsICovXG4gIF9nZW5BbGxSZWNvcmRzKHJzOiBQcm90b1JlY29yZFtdKTogc3RyaW5nIHtcbiAgICB2YXIgY29kZXM6IFN0cmluZ1tdID0gW107XG4gICAgdGhpcy5fZW5kT2ZCbG9ja0lkeHMgPSBbXTtcblxuICAgIGZvciAobGV0IGkgPSAwOyBpIDwgcnMubGVuZ3RoOyBpKyspIHtcbiAgICAgIGxldCBjb2RlO1xuICAgICAgbGV0IHIgPSByc1tpXTtcblxuICAgICAgaWYgKHIuaXNMaWZlQ3ljbGVSZWNvcmQoKSkge1xuICAgICAgICBjb2RlID0gdGhpcy5fZ2VuRGlyZWN0aXZlTGlmZWN5Y2xlKHIpO1xuICAgICAgfSBlbHNlIGlmIChyLmlzUGlwZVJlY29yZCgpKSB7XG4gICAgICAgIGNvZGUgPSB0aGlzLl9nZW5QaXBlQ2hlY2socik7XG4gICAgICB9IGVsc2UgaWYgKHIuaXNDb25kaXRpb25hbFNraXBSZWNvcmQoKSkge1xuICAgICAgICBjb2RlID0gdGhpcy5fZ2VuQ29uZGl0aW9uYWxTa2lwKHIsIHRoaXMuX25hbWVzLmdldExvY2FsTmFtZShyLmNvbnRleHRJbmRleCkpO1xuICAgICAgfSBlbHNlIGlmIChyLmlzVW5jb25kaXRpb25hbFNraXBSZWNvcmQoKSkge1xuICAgICAgICBjb2RlID0gdGhpcy5fZ2VuVW5jb25kaXRpb25hbFNraXAocik7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBjb2RlID0gdGhpcy5fZ2VuUmVmZXJlbmNlQ2hlY2socik7XG4gICAgICB9XG5cbiAgICAgIGNvZGUgPSBgXG4gICAgICAgICR7dGhpcy5fbWF5YmVGaXJzdEluQmluZGluZyhyKX1cbiAgICAgICAgJHtjb2RlfVxuICAgICAgICAke3RoaXMuX21heWJlR2VuTGFzdEluRGlyZWN0aXZlKHIpfVxuICAgICAgICAke3RoaXMuX2dlbkVuZE9mU2tpcEJsb2NrKGkpfVxuICAgICAgYDtcblxuICAgICAgY29kZXMucHVzaChjb2RlKTtcbiAgICB9XG5cbiAgICByZXR1cm4gY29kZXMuam9pbihcIlxcblwiKTtcbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgX2dlbkNvbmRpdGlvbmFsU2tpcChyOiBQcm90b1JlY29yZCwgY29uZGl0aW9uOiBzdHJpbmcpOiBzdHJpbmcge1xuICAgIGxldCBtYXliZU5lZ2F0ZSA9IHIubW9kZSA9PT0gUmVjb3JkVHlwZS5Ta2lwUmVjb3Jkc0lmID8gJyEnIDogJyc7XG4gICAgdGhpcy5fZW5kT2ZCbG9ja0lkeHMucHVzaChyLmZpeGVkQXJnc1swXSAtIDEpO1xuXG4gICAgcmV0dXJuIGBpZiAoJHttYXliZU5lZ2F0ZX0ke2NvbmRpdGlvbn0pIHtgO1xuICB9XG5cbiAgLyoqIEBpbnRlcm5hbCAqL1xuICBfZ2VuVW5jb25kaXRpb25hbFNraXAocjogUHJvdG9SZWNvcmQpOiBzdHJpbmcge1xuICAgIHRoaXMuX2VuZE9mQmxvY2tJZHhzLnBvcCgpO1xuICAgIHRoaXMuX2VuZE9mQmxvY2tJZHhzLnB1c2goci5maXhlZEFyZ3NbMF0gLSAxKTtcbiAgICByZXR1cm4gYH0gZWxzZSB7YDtcbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgX2dlbkVuZE9mU2tpcEJsb2NrKHByb3RvSW5kZXg6IG51bWJlcik6IHN0cmluZyB7XG4gICAgaWYgKCFMaXN0V3JhcHBlci5pc0VtcHR5KHRoaXMuX2VuZE9mQmxvY2tJZHhzKSkge1xuICAgICAgbGV0IGVuZE9mQmxvY2sgPSBMaXN0V3JhcHBlci5sYXN0KHRoaXMuX2VuZE9mQmxvY2tJZHhzKTtcbiAgICAgIGlmIChwcm90b0luZGV4ID09PSBlbmRPZkJsb2NrKSB7XG4gICAgICAgIHRoaXMuX2VuZE9mQmxvY2tJZHhzLnBvcCgpO1xuICAgICAgICByZXR1cm4gJ30nO1xuICAgICAgfVxuICAgIH1cblxuICAgIHJldHVybiAnJztcbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgX2dlbkRpcmVjdGl2ZUxpZmVjeWNsZShyOiBQcm90b1JlY29yZCk6IHN0cmluZyB7XG4gICAgaWYgKHIubmFtZSA9PT0gXCJEb0NoZWNrXCIpIHtcbiAgICAgIHJldHVybiB0aGlzLl9nZW5PbkNoZWNrKHIpO1xuICAgIH0gZWxzZSBpZiAoci5uYW1lID09PSBcIk9uSW5pdFwiKSB7XG4gICAgICByZXR1cm4gdGhpcy5fZ2VuT25Jbml0KHIpO1xuICAgIH0gZWxzZSBpZiAoci5uYW1lID09PSBcIk9uQ2hhbmdlc1wiKSB7XG4gICAgICByZXR1cm4gdGhpcy5fZ2VuT25DaGFuZ2Uocik7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRocm93IG5ldyBCYXNlRXhjZXB0aW9uKGBVbmtub3duIGxpZmVjeWNsZSBldmVudCAnJHtyLm5hbWV9J2ApO1xuICAgIH1cbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgX2dlblBpcGVDaGVjayhyOiBQcm90b1JlY29yZCk6IHN0cmluZyB7XG4gICAgdmFyIGNvbnRleHQgPSB0aGlzLl9uYW1lcy5nZXRMb2NhbE5hbWUoci5jb250ZXh0SW5kZXgpO1xuICAgIHZhciBhcmdTdHJpbmcgPSByLmFyZ3MubWFwKChhcmcpID0+IHRoaXMuX25hbWVzLmdldExvY2FsTmFtZShhcmcpKS5qb2luKFwiLCBcIik7XG5cbiAgICB2YXIgb2xkVmFsdWUgPSB0aGlzLl9uYW1lcy5nZXRGaWVsZE5hbWUoci5zZWxmSW5kZXgpO1xuICAgIHZhciBuZXdWYWx1ZSA9IHRoaXMuX25hbWVzLmdldExvY2FsTmFtZShyLnNlbGZJbmRleCk7XG5cbiAgICB2YXIgcGlwZSA9IHRoaXMuX25hbWVzLmdldFBpcGVOYW1lKHIuc2VsZkluZGV4KTtcbiAgICB2YXIgcGlwZU5hbWUgPSByLm5hbWU7XG5cbiAgICB2YXIgaW5pdCA9IGBcbiAgICAgIGlmICgke3BpcGV9ID09PSAke3RoaXMuY2hhbmdlRGV0ZWN0aW9uVXRpbFZhck5hbWV9LnVuaW5pdGlhbGl6ZWQpIHtcbiAgICAgICAgJHtwaXBlfSA9ICR7dGhpcy5fbmFtZXMuZ2V0UGlwZXNBY2Nlc3Nvck5hbWUoKX0uZ2V0KCcke3BpcGVOYW1lfScpO1xuICAgICAgfVxuICAgIGA7XG4gICAgdmFyIHJlYWQgPSBgJHtuZXdWYWx1ZX0gPSAke3BpcGV9LnBpcGUudHJhbnNmb3JtKCR7Y29udGV4dH0sIFske2FyZ1N0cmluZ31dKTtgO1xuXG4gICAgdmFyIGNvbnRleE9yQXJnQ2hlY2sgPSByLmFyZ3MubWFwKChhKSA9PiB0aGlzLl9uYW1lcy5nZXRDaGFuZ2VOYW1lKGEpKTtcbiAgICBjb250ZXhPckFyZ0NoZWNrLnB1c2godGhpcy5fbmFtZXMuZ2V0Q2hhbmdlTmFtZShyLmNvbnRleHRJbmRleCkpO1xuICAgIHZhciBjb25kaXRpb24gPSBgISR7cGlwZX0ucHVyZSB8fCAoJHtjb250ZXhPckFyZ0NoZWNrLmpvaW4oXCIgfHwgXCIpfSlgO1xuXG4gICAgdmFyIGNoZWNrID0gYFxuICAgICAgaWYgKCR7dGhpcy5jaGFuZ2VEZXRlY3Rpb25VdGlsVmFyTmFtZX0ubG9vc2VOb3RJZGVudGljYWwoJHtvbGRWYWx1ZX0sICR7bmV3VmFsdWV9KSkge1xuICAgICAgICAke25ld1ZhbHVlfSA9ICR7dGhpcy5jaGFuZ2VEZXRlY3Rpb25VdGlsVmFyTmFtZX0udW53cmFwVmFsdWUoJHtuZXdWYWx1ZX0pXG4gICAgICAgICR7dGhpcy5fZ2VuQ2hhbmdlTWFya2VyKHIpfVxuICAgICAgICAke3RoaXMuX2dlblVwZGF0ZURpcmVjdGl2ZU9yRWxlbWVudChyKX1cbiAgICAgICAgJHt0aGlzLl9nZW5BZGRUb0NoYW5nZXMocil9XG4gICAgICAgICR7b2xkVmFsdWV9ID0gJHtuZXdWYWx1ZX07XG4gICAgICB9XG4gICAgYDtcblxuICAgIHZhciBnZW5Db2RlID0gci5zaG91bGRCZUNoZWNrZWQoKSA/IGAke3JlYWR9JHtjaGVja31gIDogcmVhZDtcblxuICAgIGlmIChyLmlzVXNlZEJ5T3RoZXJSZWNvcmQoKSkge1xuICAgICAgcmV0dXJuIGAke2luaXR9IGlmICgke2NvbmRpdGlvbn0pIHsgJHtnZW5Db2RlfSB9IGVsc2UgeyAke25ld1ZhbHVlfSA9ICR7b2xkVmFsdWV9OyB9YDtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIGAke2luaXR9IGlmICgke2NvbmRpdGlvbn0pIHsgJHtnZW5Db2RlfSB9YDtcbiAgICB9XG4gIH1cblxuICAvKiogQGludGVybmFsICovXG4gIF9nZW5SZWZlcmVuY2VDaGVjayhyOiBQcm90b1JlY29yZCk6IHN0cmluZyB7XG4gICAgdmFyIG9sZFZhbHVlID0gdGhpcy5fbmFtZXMuZ2V0RmllbGROYW1lKHIuc2VsZkluZGV4KTtcbiAgICB2YXIgbmV3VmFsdWUgPSB0aGlzLl9uYW1lcy5nZXRMb2NhbE5hbWUoci5zZWxmSW5kZXgpO1xuICAgIHZhciByZWFkID0gYFxuICAgICAgJHt0aGlzLl9sb2dpYy5nZW5Qcm9wZXJ0eUJpbmRpbmdFdmFsVmFsdWUocil9XG4gICAgYDtcblxuICAgIHZhciBjaGVjayA9IGBcbiAgICAgIGlmICgke3RoaXMuY2hhbmdlRGV0ZWN0aW9uVXRpbFZhck5hbWV9Lmxvb3NlTm90SWRlbnRpY2FsKCR7b2xkVmFsdWV9LCAke25ld1ZhbHVlfSkpIHtcbiAgICAgICAgJHt0aGlzLl9nZW5DaGFuZ2VNYXJrZXIocil9XG4gICAgICAgICR7dGhpcy5fZ2VuVXBkYXRlRGlyZWN0aXZlT3JFbGVtZW50KHIpfVxuICAgICAgICAke3RoaXMuX2dlbkFkZFRvQ2hhbmdlcyhyKX1cbiAgICAgICAgJHtvbGRWYWx1ZX0gPSAke25ld1ZhbHVlfTtcbiAgICAgIH1cbiAgICBgO1xuXG4gICAgdmFyIGdlbkNvZGUgPSByLnNob3VsZEJlQ2hlY2tlZCgpID8gYCR7cmVhZH0ke2NoZWNrfWAgOiByZWFkO1xuXG4gICAgaWYgKHIuaXNQdXJlRnVuY3Rpb24oKSkge1xuICAgICAgdmFyIGNvbmRpdGlvbiA9IHIuYXJncy5tYXAoKGEpID0+IHRoaXMuX25hbWVzLmdldENoYW5nZU5hbWUoYSkpLmpvaW4oXCIgfHwgXCIpO1xuICAgICAgaWYgKHIuaXNVc2VkQnlPdGhlclJlY29yZCgpKSB7XG4gICAgICAgIHJldHVybiBgaWYgKCR7Y29uZGl0aW9ufSkgeyAke2dlbkNvZGV9IH0gZWxzZSB7ICR7bmV3VmFsdWV9ID0gJHtvbGRWYWx1ZX07IH1gO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgcmV0dXJuIGBpZiAoJHtjb25kaXRpb259KSB7ICR7Z2VuQ29kZX0gfWA7XG4gICAgICB9XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiBnZW5Db2RlO1xuICAgIH1cbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgX2dlbkNoYW5nZU1hcmtlcihyOiBQcm90b1JlY29yZCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIHIuYXJndW1lbnRUb1B1cmVGdW5jdGlvbiA/IGAke3RoaXMuX25hbWVzLmdldENoYW5nZU5hbWUoci5zZWxmSW5kZXgpfSA9IHRydWVgIDogYGA7XG4gIH1cblxuICAvKiogQGludGVybmFsICovXG4gIF9nZW5VcGRhdGVEaXJlY3RpdmVPckVsZW1lbnQocjogUHJvdG9SZWNvcmQpOiBzdHJpbmcge1xuICAgIGlmICghci5sYXN0SW5CaW5kaW5nKSByZXR1cm4gXCJcIjtcblxuICAgIHZhciBuZXdWYWx1ZSA9IHRoaXMuX25hbWVzLmdldExvY2FsTmFtZShyLnNlbGZJbmRleCk7XG4gICAgdmFyIG9sZFZhbHVlID0gdGhpcy5fbmFtZXMuZ2V0RmllbGROYW1lKHIuc2VsZkluZGV4KTtcbiAgICB2YXIgbm90aWZ5RGVidWcgPSB0aGlzLmdlbkNvbmZpZy5sb2dCaW5kaW5nVXBkYXRlID8gYHRoaXMubG9nQmluZGluZ1VwZGF0ZSgke25ld1ZhbHVlfSk7YCA6IFwiXCI7XG5cbiAgICB2YXIgYnIgPSByLmJpbmRpbmdSZWNvcmQ7XG4gICAgaWYgKGJyLnRhcmdldC5pc0RpcmVjdGl2ZSgpKSB7XG4gICAgICB2YXIgZGlyZWN0aXZlUHJvcGVydHkgPVxuICAgICAgICAgIGAke3RoaXMuX25hbWVzLmdldERpcmVjdGl2ZU5hbWUoYnIuZGlyZWN0aXZlUmVjb3JkLmRpcmVjdGl2ZUluZGV4KX0uJHtici50YXJnZXQubmFtZX1gO1xuICAgICAgcmV0dXJuIGBcbiAgICAgICAgJHt0aGlzLl9nZW5UaHJvd09uQ2hhbmdlQ2hlY2sob2xkVmFsdWUsIG5ld1ZhbHVlKX1cbiAgICAgICAgJHtkaXJlY3RpdmVQcm9wZXJ0eX0gPSAke25ld1ZhbHVlfTtcbiAgICAgICAgJHtub3RpZnlEZWJ1Z31cbiAgICAgICAgJHtJU19DSEFOR0VEX0xPQ0FMfSA9IHRydWU7XG4gICAgICBgO1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gYFxuICAgICAgICAke3RoaXMuX2dlblRocm93T25DaGFuZ2VDaGVjayhvbGRWYWx1ZSwgbmV3VmFsdWUpfVxuICAgICAgICB0aGlzLm5vdGlmeURpc3BhdGNoZXIoJHtuZXdWYWx1ZX0pO1xuICAgICAgICAke25vdGlmeURlYnVnfVxuICAgICAgYDtcbiAgICB9XG4gIH1cblxuICAvKiogQGludGVybmFsICovXG4gIF9nZW5UaHJvd09uQ2hhbmdlQ2hlY2sob2xkVmFsdWU6IHN0cmluZywgbmV3VmFsdWU6IHN0cmluZyk6IHN0cmluZyB7XG4gICAgaWYgKGFzc2VydGlvbnNFbmFibGVkKCkpIHtcbiAgICAgIHJldHVybiBgXG4gICAgICAgIGlmKHRocm93T25DaGFuZ2UpIHtcbiAgICAgICAgICB0aGlzLnRocm93T25DaGFuZ2VFcnJvcigke29sZFZhbHVlfSwgJHtuZXdWYWx1ZX0pO1xuICAgICAgICB9XG4gICAgICAgIGA7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiAnJztcbiAgICB9XG4gIH1cblxuICAvKiogQGludGVybmFsICovXG4gIF9nZW5BZGRUb0NoYW5nZXMocjogUHJvdG9SZWNvcmQpOiBzdHJpbmcge1xuICAgIHZhciBuZXdWYWx1ZSA9IHRoaXMuX25hbWVzLmdldExvY2FsTmFtZShyLnNlbGZJbmRleCk7XG4gICAgdmFyIG9sZFZhbHVlID0gdGhpcy5fbmFtZXMuZ2V0RmllbGROYW1lKHIuc2VsZkluZGV4KTtcbiAgICBpZiAoIXIuYmluZGluZ1JlY29yZC5jYWxsT25DaGFuZ2VzKCkpIHJldHVybiBcIlwiO1xuICAgIHJldHVybiBgJHtDSEFOR0VTX0xPQ0FMfSA9IHRoaXMuYWRkQ2hhbmdlKCR7Q0hBTkdFU19MT0NBTH0sICR7b2xkVmFsdWV9LCAke25ld1ZhbHVlfSk7YDtcbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgX21heWJlRmlyc3RJbkJpbmRpbmcocjogUHJvdG9SZWNvcmQpOiBzdHJpbmcge1xuICAgIHZhciBwcmV2ID0gQ2hhbmdlRGV0ZWN0aW9uVXRpbC5wcm90b0J5SW5kZXgodGhpcy5yZWNvcmRzLCByLnNlbGZJbmRleCAtIDEpO1xuICAgIHZhciBmaXJzdEluQmluZGluZyA9IGlzQmxhbmsocHJldikgfHwgcHJldi5iaW5kaW5nUmVjb3JkICE9PSByLmJpbmRpbmdSZWNvcmQ7XG4gICAgcmV0dXJuIGZpcnN0SW5CaW5kaW5nICYmICFyLmJpbmRpbmdSZWNvcmQuaXNEaXJlY3RpdmVMaWZlY3ljbGUoKSA/XG4gICAgICAgICAgICAgICBgJHt0aGlzLl9uYW1lcy5nZXRQcm9wZXJ0eUJpbmRpbmdJbmRleCgpfSA9ICR7ci5wcm9wZXJ0eUJpbmRpbmdJbmRleH07YCA6XG4gICAgICAgICAgICAgICAnJztcbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgX21heWJlR2VuTGFzdEluRGlyZWN0aXZlKHI6IFByb3RvUmVjb3JkKTogc3RyaW5nIHtcbiAgICBpZiAoIXIubGFzdEluRGlyZWN0aXZlKSByZXR1cm4gXCJcIjtcbiAgICByZXR1cm4gYFxuICAgICAgJHtDSEFOR0VTX0xPQ0FMfSA9IG51bGw7XG4gICAgICAke3RoaXMuX2dlbk5vdGlmeU9uUHVzaERldGVjdG9ycyhyKX1cbiAgICAgICR7SVNfQ0hBTkdFRF9MT0NBTH0gPSBmYWxzZTtcbiAgICBgO1xuICB9XG5cbiAgLyoqIEBpbnRlcm5hbCAqL1xuICBfZ2VuT25DaGVjayhyOiBQcm90b1JlY29yZCk6IHN0cmluZyB7XG4gICAgdmFyIGJyID0gci5iaW5kaW5nUmVjb3JkO1xuICAgIHJldHVybiBgaWYgKCF0aHJvd09uQ2hhbmdlKSAke3RoaXMuX25hbWVzLmdldERpcmVjdGl2ZU5hbWUoYnIuZGlyZWN0aXZlUmVjb3JkLmRpcmVjdGl2ZUluZGV4KX0ubmdEb0NoZWNrKCk7YDtcbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgX2dlbk9uSW5pdChyOiBQcm90b1JlY29yZCk6IHN0cmluZyB7XG4gICAgdmFyIGJyID0gci5iaW5kaW5nUmVjb3JkO1xuICAgIHJldHVybiBgaWYgKCF0aHJvd09uQ2hhbmdlICYmICR7dGhpcy5fbmFtZXMuZ2V0U3RhdGVOYW1lKCl9ID09PSAke3RoaXMuY2hhbmdlRGV0ZWN0b3JTdGF0ZVZhck5hbWV9Lk5ldmVyQ2hlY2tlZCkgJHt0aGlzLl9uYW1lcy5nZXREaXJlY3RpdmVOYW1lKGJyLmRpcmVjdGl2ZVJlY29yZC5kaXJlY3RpdmVJbmRleCl9Lm5nT25Jbml0KCk7YDtcbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgX2dlbk9uQ2hhbmdlKHI6IFByb3RvUmVjb3JkKTogc3RyaW5nIHtcbiAgICB2YXIgYnIgPSByLmJpbmRpbmdSZWNvcmQ7XG4gICAgcmV0dXJuIGBpZiAoIXRocm93T25DaGFuZ2UgJiYgJHtDSEFOR0VTX0xPQ0FMfSkgJHt0aGlzLl9uYW1lcy5nZXREaXJlY3RpdmVOYW1lKGJyLmRpcmVjdGl2ZVJlY29yZC5kaXJlY3RpdmVJbmRleCl9Lm5nT25DaGFuZ2VzKCR7Q0hBTkdFU19MT0NBTH0pO2A7XG4gIH1cblxuICAvKiogQGludGVybmFsICovXG4gIF9nZW5Ob3RpZnlPblB1c2hEZXRlY3RvcnMocjogUHJvdG9SZWNvcmQpOiBzdHJpbmcge1xuICAgIHZhciBiciA9IHIuYmluZGluZ1JlY29yZDtcbiAgICBpZiAoIXIubGFzdEluRGlyZWN0aXZlIHx8IGJyLmlzRGVmYXVsdENoYW5nZURldGVjdGlvbigpKSByZXR1cm4gXCJcIjtcbiAgICB2YXIgcmV0VmFsID0gYFxuICAgICAgaWYoJHtJU19DSEFOR0VEX0xPQ0FMfSkge1xuICAgICAgICAke3RoaXMuX25hbWVzLmdldERldGVjdG9yTmFtZShici5kaXJlY3RpdmVSZWNvcmQuZGlyZWN0aXZlSW5kZXgpfS5tYXJrQXNDaGVja09uY2UoKTtcbiAgICAgIH1cbiAgICBgO1xuICAgIHJldHVybiByZXRWYWw7XG4gIH1cbn1cbiJdfQ==