'use strict';var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var di_1 = require('angular2/src/core/di');
var compiler_1 = require('./compiler');
var lang_1 = require('angular2/src/facade/lang');
var view_manager_1 = require('angular2/src/core/linker/view_manager');
/**
 * Represents an instance of a Component created via {@link DynamicComponentLoader}.
 *
 * `ComponentRef` provides access to the Component Instance as well other objects related to this
 * Component Instance and allows you to destroy the Component Instance via the {@link #dispose}
 * method.
 */
var ComponentRef = (function () {
    function ComponentRef() {
    }
    Object.defineProperty(ComponentRef.prototype, "hostView", {
        /**
         * The {@link ViewRef} of the Host View of this Component instance.
         */
        get: function () { return this.location.parentView; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ComponentRef.prototype, "hostComponent", {
        /**
         * @internal
         *
         * The instance of the component.
         *
         * TODO(i): this api should be removed
         */
        get: function () { return this.instance; },
        enumerable: true,
        configurable: true
    });
    return ComponentRef;
})();
exports.ComponentRef = ComponentRef;
var ComponentRef_ = (function (_super) {
    __extends(ComponentRef_, _super);
    /**
     * TODO(i): refactor into public/private fields
     */
    function ComponentRef_(location, instance, componentType, injector, _dispose) {
        _super.call(this);
        this._dispose = _dispose;
        this.location = location;
        this.instance = instance;
        this.componentType = componentType;
        this.injector = injector;
    }
    Object.defineProperty(ComponentRef_.prototype, "hostComponentType", {
        /**
         * @internal
         *
         * Returns the type of this Component instance.
         *
         * TODO(i): this api should be removed
         */
        get: function () { return this.componentType; },
        enumerable: true,
        configurable: true
    });
    ComponentRef_.prototype.dispose = function () { this._dispose(); };
    return ComponentRef_;
})(ComponentRef);
exports.ComponentRef_ = ComponentRef_;
/**
 * Service for instantiating a Component and attaching it to a View at a specified location.
 */
var DynamicComponentLoader = (function () {
    function DynamicComponentLoader() {
    }
    return DynamicComponentLoader;
})();
exports.DynamicComponentLoader = DynamicComponentLoader;
var DynamicComponentLoader_ = (function (_super) {
    __extends(DynamicComponentLoader_, _super);
    function DynamicComponentLoader_(_compiler, _viewManager) {
        _super.call(this);
        this._compiler = _compiler;
        this._viewManager = _viewManager;
    }
    DynamicComponentLoader_.prototype.loadAsRoot = function (type, overrideSelector, injector, onDispose) {
        var _this = this;
        return this._compiler.compileInHost(type).then(function (hostProtoViewRef) {
            var hostViewRef = _this._viewManager.createRootHostView(hostProtoViewRef, overrideSelector, injector);
            var newLocation = _this._viewManager.getHostElement(hostViewRef);
            var component = _this._viewManager.getComponent(newLocation);
            var dispose = function () {
                if (lang_1.isPresent(onDispose)) {
                    onDispose();
                }
                _this._viewManager.destroyRootHostView(hostViewRef);
            };
            return new ComponentRef_(newLocation, component, type, injector, dispose);
        });
    };
    DynamicComponentLoader_.prototype.loadIntoLocation = function (type, hostLocation, anchorName, providers) {
        if (providers === void 0) { providers = null; }
        return this.loadNextToLocation(type, this._viewManager.getNamedElementInComponentView(hostLocation, anchorName), providers);
    };
    DynamicComponentLoader_.prototype.loadNextToLocation = function (type, location, providers) {
        var _this = this;
        if (providers === void 0) { providers = null; }
        return this._compiler.compileInHost(type).then(function (hostProtoViewRef) {
            var viewContainer = _this._viewManager.getViewContainer(location);
            var hostViewRef = viewContainer.createHostView(hostProtoViewRef, viewContainer.length, providers);
            var newLocation = _this._viewManager.getHostElement(hostViewRef);
            var component = _this._viewManager.getComponent(newLocation);
            var dispose = function () {
                var index = viewContainer.indexOf(hostViewRef);
                if (index !== -1) {
                    viewContainer.remove(index);
                }
            };
            return new ComponentRef_(newLocation, component, type, null, dispose);
        });
    };
    DynamicComponentLoader_ = __decorate([
        di_1.Injectable(), 
        __metadata('design:paramtypes', [compiler_1.Compiler, view_manager_1.AppViewManager])
    ], DynamicComponentLoader_);
    return DynamicComponentLoader_;
})(DynamicComponentLoader);
exports.DynamicComponentLoader_ = DynamicComponentLoader_;
//# sourceMappingURL=data:application/json;base64,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