'use strict';(function (LifecycleHooks) {
    LifecycleHooks[LifecycleHooks["OnInit"] = 0] = "OnInit";
    LifecycleHooks[LifecycleHooks["OnDestroy"] = 1] = "OnDestroy";
    LifecycleHooks[LifecycleHooks["DoCheck"] = 2] = "DoCheck";
    LifecycleHooks[LifecycleHooks["OnChanges"] = 3] = "OnChanges";
    LifecycleHooks[LifecycleHooks["AfterContentInit"] = 4] = "AfterContentInit";
    LifecycleHooks[LifecycleHooks["AfterContentChecked"] = 5] = "AfterContentChecked";
    LifecycleHooks[LifecycleHooks["AfterViewInit"] = 6] = "AfterViewInit";
    LifecycleHooks[LifecycleHooks["AfterViewChecked"] = 7] = "AfterViewChecked";
})(exports.LifecycleHooks || (exports.LifecycleHooks = {}));
var LifecycleHooks = exports.LifecycleHooks;
/**
 * @internal
 */
exports.LIFECYCLE_HOOKS_VALUES = [
    LifecycleHooks.OnInit,
    LifecycleHooks.OnDestroy,
    LifecycleHooks.DoCheck,
    LifecycleHooks.OnChanges,
    LifecycleHooks.AfterContentInit,
    LifecycleHooks.AfterContentChecked,
    LifecycleHooks.AfterViewInit,
    LifecycleHooks.AfterViewChecked
];
//# sourceMappingURL=data:application/json;base64,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