'use strict';var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var exceptions_1 = require('angular2/src/facade/exceptions');
/**
 * Represents an Angular ProtoView in the Rendering Context.
 *
 * When you implement a custom {@link Renderer}, `RenderProtoViewRef` specifies what Render View
 * your renderer should create.
 *
 * `RenderProtoViewRef` is a counterpart to {@link ProtoViewRef} available in the Application
 * Context. But unlike `ProtoViewRef`, `RenderProtoViewRef` contains all static nested Proto Views
 * that are recursively merged into a single Render Proto View.

 *
 * <!-- TODO: this is created by Renderer#createProtoView in the new compiler -->
 */
var RenderProtoViewRef = (function () {
    function RenderProtoViewRef() {
    }
    return RenderProtoViewRef;
})();
exports.RenderProtoViewRef = RenderProtoViewRef;
/**
 * Represents a list of sibling Nodes that can be moved by the {@link Renderer} independently of
 * other Render Fragments.
 *
 * Any {@link RenderView} has one Render Fragment.
 *
 * Additionally any View with an Embedded View that contains a {@link NgContent View Projection}
 * results in additional Render Fragment.
 */
/*
  <div>foo</div>
  {{bar}}


  <div>foo</div> -> view 1 / fragment 1
  <ul>
    <template ng-for>
      <li>{{fg}}</li> -> view 2 / fragment 1
    </template>
  </ul>
  {{bar}}


  <div>foo</div> -> view 1 / fragment 1
  <ul>
    <template ng-if>
      <li><ng-content></></li> -> view 1 / fragment 2
    </template>
    <template ng-for>
      <li><ng-content></></li> ->
      <li></li>                -> view 1 / fragment 2 + view 2 / fragment 1..n-1
    </template>
  </ul>
  {{bar}}
 */
// TODO(i): refactor into an interface
var RenderFragmentRef = (function () {
    function RenderFragmentRef() {
    }
    return RenderFragmentRef;
})();
exports.RenderFragmentRef = RenderFragmentRef;
/**
 * Represents an Angular View in the Rendering Context.
 *
 * `RenderViewRef` specifies to the {@link Renderer} what View to update or destroy.
 *
 * Unlike a {@link ViewRef} available in the Application Context, Render View contains all the
 * static Component Views that have been recursively merged into a single Render View.
 *
 * Each `RenderViewRef` contains one or more {@link RenderFragmentRef Render Fragments}, these
 * Fragments are created, hydrated, dehydrated and destroyed as a single unit together with the
 * View.
 */
// TODO(i): refactor into an interface
var RenderViewRef = (function () {
    function RenderViewRef() {
    }
    return RenderViewRef;
})();
exports.RenderViewRef = RenderViewRef;
var RenderTemplateCmd = (function () {
    function RenderTemplateCmd() {
    }
    return RenderTemplateCmd;
})();
exports.RenderTemplateCmd = RenderTemplateCmd;
var RenderBeginCmd = (function (_super) {
    __extends(RenderBeginCmd, _super);
    function RenderBeginCmd() {
        _super.apply(this, arguments);
    }
    Object.defineProperty(RenderBeginCmd.prototype, "ngContentIndex", {
        get: function () { return exceptions_1.unimplemented(); },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(RenderBeginCmd.prototype, "isBound", {
        get: function () { return exceptions_1.unimplemented(); },
        enumerable: true,
        configurable: true
    });
    ;
    return RenderBeginCmd;
})(RenderTemplateCmd);
exports.RenderBeginCmd = RenderBeginCmd;
var RenderTextCmd = (function (_super) {
    __extends(RenderTextCmd, _super);
    function RenderTextCmd() {
        _super.apply(this, arguments);
    }
    Object.defineProperty(RenderTextCmd.prototype, "value", {
        get: function () { return exceptions_1.unimplemented(); },
        enumerable: true,
        configurable: true
    });
    ;
    return RenderTextCmd;
})(RenderBeginCmd);
exports.RenderTextCmd = RenderTextCmd;
var RenderNgContentCmd = (function (_super) {
    __extends(RenderNgContentCmd, _super);
    function RenderNgContentCmd() {
        _super.apply(this, arguments);
    }
    Object.defineProperty(RenderNgContentCmd.prototype, "index", {
        // The index of this NgContent element
        get: function () { return exceptions_1.unimplemented(); },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(RenderNgContentCmd.prototype, "ngContentIndex", {
        // The index of the NgContent element into which this
        // NgContent element should be projected (if any)
        get: function () { return exceptions_1.unimplemented(); },
        enumerable: true,
        configurable: true
    });
    ;
    return RenderNgContentCmd;
})(RenderTemplateCmd);
exports.RenderNgContentCmd = RenderNgContentCmd;
var RenderBeginElementCmd = (function (_super) {
    __extends(RenderBeginElementCmd, _super);
    function RenderBeginElementCmd() {
        _super.apply(this, arguments);
    }
    Object.defineProperty(RenderBeginElementCmd.prototype, "name", {
        get: function () { return exceptions_1.unimplemented(); },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(RenderBeginElementCmd.prototype, "attrNameAndValues", {
        get: function () { return exceptions_1.unimplemented(); },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(RenderBeginElementCmd.prototype, "eventTargetAndNames", {
        get: function () { return exceptions_1.unimplemented(); },
        enumerable: true,
        configurable: true
    });
    ;
    return RenderBeginElementCmd;
})(RenderBeginCmd);
exports.RenderBeginElementCmd = RenderBeginElementCmd;
var RenderBeginComponentCmd = (function (_super) {
    __extends(RenderBeginComponentCmd, _super);
    function RenderBeginComponentCmd() {
        _super.apply(this, arguments);
    }
    Object.defineProperty(RenderBeginComponentCmd.prototype, "templateId", {
        get: function () { return exceptions_1.unimplemented(); },
        enumerable: true,
        configurable: true
    });
    ;
    return RenderBeginComponentCmd;
})(RenderBeginElementCmd);
exports.RenderBeginComponentCmd = RenderBeginComponentCmd;
var RenderEmbeddedTemplateCmd = (function (_super) {
    __extends(RenderEmbeddedTemplateCmd, _super);
    function RenderEmbeddedTemplateCmd() {
        _super.apply(this, arguments);
    }
    Object.defineProperty(RenderEmbeddedTemplateCmd.prototype, "isMerged", {
        get: function () { return exceptions_1.unimplemented(); },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(RenderEmbeddedTemplateCmd.prototype, "children", {
        get: function () { return exceptions_1.unimplemented(); },
        enumerable: true,
        configurable: true
    });
    ;
    return RenderEmbeddedTemplateCmd;
})(RenderBeginElementCmd);
exports.RenderEmbeddedTemplateCmd = RenderEmbeddedTemplateCmd;
/**
 * Container class produced by a {@link Renderer} when creating a Render View.
 *
 * An instance of `RenderViewWithFragments` contains a {@link RenderViewRef} and an array of
 * {@link RenderFragmentRef}s belonging to this Render View.
 */
// TODO(i): refactor this by RenderViewWithFragments and adding fragments directly to RenderViewRef
var RenderViewWithFragments = (function () {
    function RenderViewWithFragments(
        /**
         * Reference to the {@link RenderViewRef}.
         */
        viewRef, 
        /**
         * Array of {@link RenderFragmentRef}s ordered in the depth-first order.
         */
        fragmentRefs) {
        this.viewRef = viewRef;
        this.fragmentRefs = fragmentRefs;
    }
    return RenderViewWithFragments;
})();
exports.RenderViewWithFragments = RenderViewWithFragments;
var RenderComponentTemplate = (function () {
    function RenderComponentTemplate(id, shortId, encapsulation, commands, styles) {
        this.id = id;
        this.shortId = shortId;
        this.encapsulation = encapsulation;
        this.commands = commands;
        this.styles = styles;
    }
    return RenderComponentTemplate;
})();
exports.RenderComponentTemplate = RenderComponentTemplate;
/**
 * Injectable service that provides a low-level interface for modifying the UI.
 *
 * Use this service to bypass Angular's templating and make custom UI changes that can't be
 * expressed declaratively. For example if you need to set a property or an attribute whose name is
 * not statically known, use {@link #setElementProperty} or {@link #setElementAttribute}
 * respectively.
 *
 * If you are implementing a custom renderer, you must implement this interface.
 *
 * The default Renderer implementation is {@link DomRenderer}. Also see {@link WebWorkerRenderer}.
 */
var Renderer = (function () {
    function Renderer() {
    }
    return Renderer;
})();
exports.Renderer = Renderer;
//# sourceMappingURL=data:application/json;base64,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