'use strict';var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var di_1 = require('angular2/src/core/di');
var animation_builder_1 = require('angular2/src/animate/animation_builder');
var lang_1 = require('angular2/src/facade/lang');
var exceptions_1 = require('angular2/src/facade/exceptions');
var shared_styles_host_1 = require('./shared_styles_host');
var profile_1 = require('angular2/src/core/profile/profile');
var core_1 = require('angular2/core');
var event_manager_1 = require('./events/event_manager');
var dom_tokens_1 = require('./dom_tokens');
var view_factory_1 = require('angular2/src/core/render/view_factory');
var view_1 = require('angular2/src/core/render/view');
var util_1 = require('./util');
var metadata_1 = require('angular2/src/core/metadata');
// TODO move it once DomAdapter is moved
var dom_adapter_1 = require('angular2/src/platform/dom/dom_adapter');
var NAMESPACE_URIS = lang_1.CONST_EXPR({ 'xlink': 'http://www.w3.org/1999/xlink', 'svg': 'http://www.w3.org/2000/svg' });
var DomRenderer = (function (_super) {
    __extends(DomRenderer, _super);
    function DomRenderer() {
        _super.apply(this, arguments);
    }
    DomRenderer.prototype.getNativeElementSync = function (location) {
        return resolveInternalDomView(location.renderView).boundElements[location.boundElementIndex];
    };
    DomRenderer.prototype.getRootNodes = function (fragment) { return resolveInternalDomFragment(fragment); };
    DomRenderer.prototype.attachFragmentAfterFragment = function (previousFragmentRef, fragmentRef) {
        var previousFragmentNodes = resolveInternalDomFragment(previousFragmentRef);
        if (previousFragmentNodes.length > 0) {
            var sibling = previousFragmentNodes[previousFragmentNodes.length - 1];
            var nodes = resolveInternalDomFragment(fragmentRef);
            moveNodesAfterSibling(sibling, nodes);
            this.animateNodesEnter(nodes);
        }
    };
    /**
     * Iterates through all nodes being added to the DOM and animates them if necessary
     * @param nodes
     */
    DomRenderer.prototype.animateNodesEnter = function (nodes) {
        for (var i = 0; i < nodes.length; i++)
            this.animateNodeEnter(nodes[i]);
    };
    DomRenderer.prototype.attachFragmentAfterElement = function (elementRef, fragmentRef) {
        var parentView = resolveInternalDomView(elementRef.renderView);
        var element = parentView.boundElements[elementRef.boundElementIndex];
        var nodes = resolveInternalDomFragment(fragmentRef);
        moveNodesAfterSibling(element, nodes);
        this.animateNodesEnter(nodes);
    };
    DomRenderer.prototype.hydrateView = function (viewRef) { resolveInternalDomView(viewRef).hydrate(); };
    DomRenderer.prototype.dehydrateView = function (viewRef) { resolveInternalDomView(viewRef).dehydrate(); };
    DomRenderer.prototype.createTemplateAnchor = function (attrNameAndValues) {
        return this.createElement('script', attrNameAndValues);
    };
    DomRenderer.prototype.createText = function (value) { return dom_adapter_1.DOM.createTextNode(lang_1.isPresent(value) ? value : ''); };
    DomRenderer.prototype.appendChild = function (parent, child) { dom_adapter_1.DOM.appendChild(parent, child); };
    DomRenderer.prototype.setElementProperty = function (location, propertyName, propertyValue) {
        var view = resolveInternalDomView(location.renderView);
        dom_adapter_1.DOM.setProperty(view.boundElements[location.boundElementIndex], propertyName, propertyValue);
    };
    DomRenderer.prototype.setElementAttribute = function (location, attributeName, attributeValue) {
        var view = resolveInternalDomView(location.renderView);
        var element = view.boundElements[location.boundElementIndex];
        var dashCasedAttributeName = util_1.camelCaseToDashCase(attributeName);
        if (lang_1.isPresent(attributeValue)) {
            dom_adapter_1.DOM.setAttribute(element, dashCasedAttributeName, lang_1.stringify(attributeValue));
        }
        else {
            dom_adapter_1.DOM.removeAttribute(element, dashCasedAttributeName);
        }
    };
    DomRenderer.prototype.setElementClass = function (location, className, isAdd) {
        var view = resolveInternalDomView(location.renderView);
        var element = view.boundElements[location.boundElementIndex];
        if (isAdd) {
            dom_adapter_1.DOM.addClass(element, className);
        }
        else {
            dom_adapter_1.DOM.removeClass(element, className);
        }
    };
    DomRenderer.prototype.setElementStyle = function (location, styleName, styleValue) {
        var view = resolveInternalDomView(location.renderView);
        var element = view.boundElements[location.boundElementIndex];
        var dashCasedStyleName = util_1.camelCaseToDashCase(styleName);
        if (lang_1.isPresent(styleValue)) {
            dom_adapter_1.DOM.setStyle(element, dashCasedStyleName, lang_1.stringify(styleValue));
        }
        else {
            dom_adapter_1.DOM.removeStyle(element, dashCasedStyleName);
        }
    };
    DomRenderer.prototype.invokeElementMethod = function (location, methodName, args) {
        var view = resolveInternalDomView(location.renderView);
        var element = view.boundElements[location.boundElementIndex];
        dom_adapter_1.DOM.invoke(element, methodName, args);
    };
    DomRenderer.prototype.setText = function (viewRef, textNodeIndex, text) {
        var view = resolveInternalDomView(viewRef);
        dom_adapter_1.DOM.setText(view.boundTextNodes[textNodeIndex], text);
    };
    DomRenderer.prototype.setEventDispatcher = function (viewRef, dispatcher) {
        resolveInternalDomView(viewRef).setEventDispatcher(dispatcher);
    };
    return DomRenderer;
})(core_1.Renderer);
exports.DomRenderer = DomRenderer;
var DomRenderer_ = (function (_super) {
    __extends(DomRenderer_, _super);
    function DomRenderer_(_eventManager, _domSharedStylesHost, _animate, document) {
        _super.call(this);
        this._eventManager = _eventManager;
        this._domSharedStylesHost = _domSharedStylesHost;
        this._animate = _animate;
        this._componentTpls = new Map();
        /** @internal */
        this._createRootHostViewScope = profile_1.wtfCreateScope('DomRenderer#createRootHostView()');
        /** @internal */
        this._createViewScope = profile_1.wtfCreateScope('DomRenderer#createView()');
        /** @internal */
        this._detachFragmentScope = profile_1.wtfCreateScope('DomRenderer#detachFragment()');
        this._document = document;
    }
    DomRenderer_.prototype.registerComponentTemplate = function (template) {
        this._componentTpls.set(template.id, template);
        if (template.encapsulation !== metadata_1.ViewEncapsulation.Native) {
            var encapsulatedStyles = view_factory_1.encapsulateStyles(template);
            this._domSharedStylesHost.addStyles(encapsulatedStyles);
        }
    };
    DomRenderer_.prototype.createProtoView = function (componentTemplateId, cmds) {
        return new view_1.DefaultProtoViewRef(this._componentTpls.get(componentTemplateId), cmds);
    };
    DomRenderer_.prototype.resolveComponentTemplate = function (templateId) {
        return this._componentTpls.get(templateId);
    };
    DomRenderer_.prototype.createRootHostView = function (hostProtoViewRef, fragmentCount, hostElementSelector) {
        var s = this._createRootHostViewScope();
        var element = dom_adapter_1.DOM.querySelector(this._document, hostElementSelector);
        if (lang_1.isBlank(element)) {
            profile_1.wtfLeave(s);
            throw new exceptions_1.BaseException("The selector \"" + hostElementSelector + "\" did not match any elements");
        }
        return profile_1.wtfLeave(s, this._createView(hostProtoViewRef, element));
    };
    DomRenderer_.prototype.createView = function (protoViewRef, fragmentCount) {
        var s = this._createViewScope();
        return profile_1.wtfLeave(s, this._createView(protoViewRef, null));
    };
    DomRenderer_.prototype._createView = function (protoViewRef, inplaceElement) {
        var dpvr = protoViewRef;
        var view = view_factory_1.createRenderView(dpvr.template, dpvr.cmds, inplaceElement, this);
        var sdRoots = view.nativeShadowRoots;
        for (var i = 0; i < sdRoots.length; i++) {
            this._domSharedStylesHost.addHost(sdRoots[i]);
        }
        return new core_1.RenderViewWithFragments(view, view.fragments);
    };
    DomRenderer_.prototype.destroyView = function (viewRef) {
        var view = viewRef;
        var sdRoots = view.nativeShadowRoots;
        for (var i = 0; i < sdRoots.length; i++) {
            this._domSharedStylesHost.removeHost(sdRoots[i]);
        }
    };
    DomRenderer_.prototype.animateNodeEnter = function (node) {
        if (dom_adapter_1.DOM.isElementNode(node) && dom_adapter_1.DOM.hasClass(node, 'ng-animate')) {
            dom_adapter_1.DOM.addClass(node, 'ng-enter');
            this._animate.css()
                .addAnimationClass('ng-enter-active')
                .start(node)
                .onComplete(function () { dom_adapter_1.DOM.removeClass(node, 'ng-enter'); });
        }
    };
    DomRenderer_.prototype.animateNodeLeave = function (node) {
        if (dom_adapter_1.DOM.isElementNode(node) && dom_adapter_1.DOM.hasClass(node, 'ng-animate')) {
            dom_adapter_1.DOM.addClass(node, 'ng-leave');
            this._animate.css()
                .addAnimationClass('ng-leave-active')
                .start(node)
                .onComplete(function () {
                dom_adapter_1.DOM.removeClass(node, 'ng-leave');
                dom_adapter_1.DOM.remove(node);
            });
        }
        else {
            dom_adapter_1.DOM.remove(node);
        }
    };
    DomRenderer_.prototype.detachFragment = function (fragmentRef) {
        var s = this._detachFragmentScope();
        var fragmentNodes = resolveInternalDomFragment(fragmentRef);
        for (var i = 0; i < fragmentNodes.length; i++) {
            this.animateNodeLeave(fragmentNodes[i]);
        }
        profile_1.wtfLeave(s);
    };
    DomRenderer_.prototype.createElement = function (name, attrNameAndValues) {
        var nsAndName = splitNamespace(name);
        var el = lang_1.isPresent(nsAndName[0]) ?
            dom_adapter_1.DOM.createElementNS(NAMESPACE_URIS[nsAndName[0]], nsAndName[1]) :
            dom_adapter_1.DOM.createElement(nsAndName[1]);
        this._setAttributes(el, attrNameAndValues);
        return el;
    };
    DomRenderer_.prototype.mergeElement = function (existing, attrNameAndValues) {
        dom_adapter_1.DOM.clearNodes(existing);
        this._setAttributes(existing, attrNameAndValues);
    };
    DomRenderer_.prototype._setAttributes = function (node, attrNameAndValues) {
        for (var attrIdx = 0; attrIdx < attrNameAndValues.length; attrIdx += 2) {
            var attrNs;
            var attrName = attrNameAndValues[attrIdx];
            var nsAndName = splitNamespace(attrName);
            if (lang_1.isPresent(nsAndName[0])) {
                attrName = nsAndName[0] + ':' + nsAndName[1];
                attrNs = NAMESPACE_URIS[nsAndName[0]];
            }
            var attrValue = attrNameAndValues[attrIdx + 1];
            if (lang_1.isPresent(attrNs)) {
                dom_adapter_1.DOM.setAttributeNS(node, attrNs, attrName, attrValue);
            }
            else {
                dom_adapter_1.DOM.setAttribute(node, nsAndName[1], attrValue);
            }
        }
    };
    DomRenderer_.prototype.createRootContentInsertionPoint = function () {
        return dom_adapter_1.DOM.createComment('root-content-insertion-point');
    };
    DomRenderer_.prototype.createShadowRoot = function (host, templateId) {
        var sr = dom_adapter_1.DOM.createShadowRoot(host);
        var tpl = this._componentTpls.get(templateId);
        for (var i = 0; i < tpl.styles.length; i++) {
            dom_adapter_1.DOM.appendChild(sr, dom_adapter_1.DOM.createStyleElement(tpl.styles[i]));
        }
        return sr;
    };
    DomRenderer_.prototype.on = function (element, eventName, callback) {
        this._eventManager.addEventListener(element, eventName, decoratePreventDefault(callback));
    };
    DomRenderer_.prototype.globalOn = function (target, eventName, callback) {
        return this._eventManager.addGlobalEventListener(target, eventName, decoratePreventDefault(callback));
    };
    DomRenderer_ = __decorate([
        di_1.Injectable(),
        __param(3, di_1.Inject(dom_tokens_1.DOCUMENT)), 
        __metadata('design:paramtypes', [event_manager_1.EventManager, shared_styles_host_1.DomSharedStylesHost, animation_builder_1.AnimationBuilder, Object])
    ], DomRenderer_);
    return DomRenderer_;
})(DomRenderer);
exports.DomRenderer_ = DomRenderer_;
function resolveInternalDomView(viewRef) {
    return viewRef;
}
function resolveInternalDomFragment(fragmentRef) {
    return fragmentRef.nodes;
}
function moveNodesAfterSibling(sibling, nodes) {
    if (nodes.length > 0 && lang_1.isPresent(dom_adapter_1.DOM.parentElement(sibling))) {
        for (var i = 0; i < nodes.length; i++) {
            dom_adapter_1.DOM.insertBefore(sibling, nodes[i]);
        }
        dom_adapter_1.DOM.insertBefore(nodes[0], sibling);
    }
}
function decoratePreventDefault(eventHandler) {
    return function (event) {
        var allowDefaultBehavior = eventHandler(event);
        if (!allowDefaultBehavior) {
            // TODO(tbosch): move preventDefault into event plugins...
            dom_adapter_1.DOM.preventDefault(event);
        }
    };
}
var NS_PREFIX_RE = /^@([^:]+):(.+)/g;
function splitNamespace(name) {
    if (name[0] != '@') {
        return [null, name];
    }
    var match = lang_1.RegExpWrapper.firstMatch(NS_PREFIX_RE, name);
    return [match[1], match[2]];
}
//# sourceMappingURL=data:application/json;base64,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