'use strict';var xhr_1 = require('angular2/src/compiler/xhr');
var xhr_impl_1 = require('angular2/src/web_workers/worker/xhr_impl');
var collection_1 = require('angular2/src/facade/collection');
var app_root_url_1 = require('angular2/src/compiler/app_root_url');
var renderer_1 = require('angular2/src/web_workers/worker/renderer');
var lang_1 = require('angular2/src/facade/lang');
var message_bus_1 = require('angular2/src/web_workers/shared/message_bus');
var api_1 = require('angular2/src/core/render/api');
var core_1 = require('angular2/core');
var common_1 = require("angular2/common");
var client_message_broker_1 = require('angular2/src/web_workers/shared/client_message_broker');
var service_message_broker_1 = require('angular2/src/web_workers/shared/service_message_broker');
var compiler_1 = require('angular2/src/compiler/compiler');
var serializer_1 = require("angular2/src/web_workers/shared/serializer");
var api_2 = require("angular2/src/web_workers/shared/api");
var di_1 = require('angular2/src/core/di');
var render_proto_view_ref_store_1 = require('angular2/src/web_workers/shared/render_proto_view_ref_store');
var render_view_with_fragments_store_1 = require('angular2/src/web_workers/shared/render_view_with_fragments_store');
var event_dispatcher_1 = require('angular2/src/web_workers/worker/event_dispatcher');
var async_1 = require('angular2/src/facade/async');
var messaging_api_1 = require('angular2/src/web_workers/shared/messaging_api');
var async_2 = require('angular2/src/facade/async');
var PrintLogger = (function () {
    function PrintLogger() {
        this.log = lang_1.print;
        this.logError = lang_1.print;
        this.logGroup = lang_1.print;
    }
    PrintLogger.prototype.logGroupEnd = function () { };
    return PrintLogger;
})();
exports.WORKER_APP_PLATFORM = lang_1.CONST_EXPR([core_1.PLATFORM_COMMON_PROVIDERS]);
exports.WORKER_APP_COMMON_PROVIDERS = lang_1.CONST_EXPR([
    core_1.APPLICATION_COMMON_PROVIDERS,
    compiler_1.COMPILER_PROVIDERS,
    common_1.FORM_PROVIDERS,
    serializer_1.Serializer,
    new di_1.Provider(core_1.PLATFORM_PIPES, { useValue: common_1.COMMON_PIPES, multi: true }),
    new di_1.Provider(core_1.PLATFORM_DIRECTIVES, { useValue: common_1.COMMON_DIRECTIVES, multi: true }),
    new di_1.Provider(client_message_broker_1.ClientMessageBrokerFactory, { useClass: client_message_broker_1.ClientMessageBrokerFactory_ }),
    new di_1.Provider(service_message_broker_1.ServiceMessageBrokerFactory, { useClass: service_message_broker_1.ServiceMessageBrokerFactory_ }),
    renderer_1.WebWorkerRenderer,
    new di_1.Provider(api_1.Renderer, { useExisting: renderer_1.WebWorkerRenderer }),
    new di_1.Provider(api_2.ON_WEB_WORKER, { useValue: true }),
    render_view_with_fragments_store_1.RenderViewWithFragmentsStore,
    render_proto_view_ref_store_1.RenderProtoViewRefStore,
    new di_1.Provider(core_1.ExceptionHandler, { useFactory: _exceptionHandler, deps: [] }),
    xhr_impl_1.WebWorkerXHRImpl,
    new di_1.Provider(xhr_1.XHR, { useExisting: xhr_impl_1.WebWorkerXHRImpl }),
    event_dispatcher_1.WebWorkerEventDispatcher
]);
function _exceptionHandler() {
    return new core_1.ExceptionHandler(new PrintLogger());
}
/**
 * Asynchronously returns a list of providers that can be used to initialize the
 * Application injector.
 * Also takes care of attaching the {@link MessageBus} to the given {@link NgZone}.
 */
function genericWorkerAppProviders(bus, zone) {
    var bootstrapProcess = async_1.PromiseWrapper.completer();
    bus.attachToZone(zone);
    bus.initChannel(messaging_api_1.SETUP_CHANNEL, false);
    var subscription;
    var emitter = bus.from(messaging_api_1.SETUP_CHANNEL);
    subscription = async_2.ObservableWrapper.subscribe(emitter, function (initData) {
        var bindings = collection_1.ListWrapper.concat(exports.WORKER_APP_COMMON_PROVIDERS, [
            new di_1.Provider(message_bus_1.MessageBus, { useValue: bus }),
            new di_1.Provider(app_root_url_1.AppRootUrl, { useValue: new app_root_url_1.AppRootUrl(initData['rootUrl']) }),
        ]);
        bootstrapProcess.resolve(bindings);
        async_2.ObservableWrapper.dispose(subscription);
    });
    async_2.ObservableWrapper.callNext(bus.to(messaging_api_1.SETUP_CHANNEL), "ready");
    return bootstrapProcess.promise;
}
exports.genericWorkerAppProviders = genericWorkerAppProviders;
//# sourceMappingURL=data:application/json;base64,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