'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var lang_1 = require("angular2/src/facade/lang");
var exceptions_1 = require('angular2/src/facade/exceptions');
var collection_1 = require("angular2/src/facade/collection");
var api_1 = require("angular2/src/core/render/api");
var api_2 = require('angular2/src/web_workers/shared/api');
var di_1 = require("angular2/src/core/di");
var render_proto_view_ref_store_1 = require('angular2/src/web_workers/shared/render_proto_view_ref_store');
var render_view_with_fragments_store_1 = require('angular2/src/web_workers/shared/render_view_with_fragments_store');
var view_1 = require('angular2/src/core/metadata/view');
// PRIMITIVE is any type that does not need to be serialized (string, number, boolean)
// We set it to String so that it is considered a Type.
exports.PRIMITIVE = String;
var Serializer = (function () {
    function Serializer(_protoViewStore, _renderViewStore) {
        this._protoViewStore = _protoViewStore;
        this._renderViewStore = _renderViewStore;
    }
    Serializer.prototype.serialize = function (obj, type) {
        var _this = this;
        if (!lang_1.isPresent(obj)) {
            return null;
        }
        if (lang_1.isArray(obj)) {
            return obj.map(function (v) { return _this.serialize(v, type); });
        }
        if (type == exports.PRIMITIVE) {
            return obj;
        }
        if (type == api_1.RenderProtoViewRef) {
            return this._protoViewStore.serialize(obj);
        }
        else if (type == api_1.RenderViewRef) {
            return this._renderViewStore.serializeRenderViewRef(obj);
        }
        else if (type == api_1.RenderFragmentRef) {
            return this._renderViewStore.serializeRenderFragmentRef(obj);
        }
        else if (type == api_2.WebWorkerElementRef) {
            return this._serializeWorkerElementRef(obj);
        }
        else if (type == api_2.WebWorkerTemplateCmd) {
            return serializeTemplateCmd(obj);
        }
        else if (type === api_1.RenderComponentTemplate) {
            return this._serializeRenderTemplate(obj);
        }
        else if (type === view_1.ViewEncapsulation) {
            return lang_1.serializeEnum(obj);
        }
        else {
            throw new exceptions_1.BaseException("No serializer for " + type.toString());
        }
    };
    Serializer.prototype.deserialize = function (map, type, data) {
        var _this = this;
        if (!lang_1.isPresent(map)) {
            return null;
        }
        if (lang_1.isArray(map)) {
            var obj = [];
            map.forEach(function (val) { return obj.push(_this.deserialize(val, type, data)); });
            return obj;
        }
        if (type == exports.PRIMITIVE) {
            return map;
        }
        if (type == api_1.RenderProtoViewRef) {
            return this._protoViewStore.deserialize(map);
        }
        else if (type == api_1.RenderViewRef) {
            return this._renderViewStore.deserializeRenderViewRef(map);
        }
        else if (type == api_1.RenderFragmentRef) {
            return this._renderViewStore.deserializeRenderFragmentRef(map);
        }
        else if (type == api_2.WebWorkerElementRef) {
            return this._deserializeWorkerElementRef(map);
        }
        else if (type == api_2.WebWorkerTemplateCmd) {
            return deserializeTemplateCmd(map);
        }
        else if (type === api_1.RenderComponentTemplate) {
            return this._deserializeRenderTemplate(map);
        }
        else if (type === view_1.ViewEncapsulation) {
            return view_1.VIEW_ENCAPSULATION_VALUES[map];
        }
        else {
            throw new exceptions_1.BaseException("No deserializer for " + type.toString());
        }
    };
    Serializer.prototype.mapToObject = function (map, type) {
        var _this = this;
        var object = {};
        var serialize = lang_1.isPresent(type);
        map.forEach(function (value, key) {
            if (serialize) {
                object[key] = _this.serialize(value, type);
            }
            else {
                object[key] = value;
            }
        });
        return object;
    };
    /*
     * Transforms a Javascript object (StringMap) into a Map<string, V>
     * If the values need to be deserialized pass in their type
     * and they will be deserialized before being placed in the map
     */
    Serializer.prototype.objectToMap = function (obj, type, data) {
        var _this = this;
        if (lang_1.isPresent(type)) {
            var map = new collection_1.Map();
            collection_1.StringMapWrapper.forEach(obj, function (val, key) { map.set(key, _this.deserialize(val, type, data)); });
            return map;
        }
        else {
            return collection_1.MapWrapper.createFromStringMap(obj);
        }
    };
    Serializer.prototype.allocateRenderViews = function (fragmentCount) { this._renderViewStore.allocate(fragmentCount); };
    Serializer.prototype._serializeWorkerElementRef = function (elementRef) {
        return {
            'renderView': this.serialize(elementRef.renderView, api_1.RenderViewRef),
            'boundElementIndex': elementRef.boundElementIndex
        };
    };
    Serializer.prototype._deserializeWorkerElementRef = function (map) {
        return new api_2.WebWorkerElementRef(this.deserialize(map['renderView'], api_1.RenderViewRef), map['boundElementIndex']);
    };
    Serializer.prototype._serializeRenderTemplate = function (obj) {
        return {
            'id': obj.id,
            'shortId': obj.shortId,
            'encapsulation': this.serialize(obj.encapsulation, view_1.ViewEncapsulation),
            'commands': this.serialize(obj.commands, api_2.WebWorkerTemplateCmd),
            'styles': this.serialize(obj.styles, exports.PRIMITIVE)
        };
    };
    Serializer.prototype._deserializeRenderTemplate = function (map) {
        return new api_1.RenderComponentTemplate(map['id'], map['shortId'], this.deserialize(map['encapsulation'], view_1.ViewEncapsulation), this.deserialize(map['commands'], api_2.WebWorkerTemplateCmd), this.deserialize(map['styles'], exports.PRIMITIVE));
    };
    Serializer = __decorate([
        di_1.Injectable(), 
        __metadata('design:paramtypes', [render_proto_view_ref_store_1.RenderProtoViewRefStore, render_view_with_fragments_store_1.RenderViewWithFragmentsStore])
    ], Serializer);
    return Serializer;
})();
exports.Serializer = Serializer;
function serializeTemplateCmd(cmd) {
    return cmd.visit(RENDER_TEMPLATE_CMD_SERIALIZER, null);
}
function deserializeTemplateCmd(data) {
    return RENDER_TEMPLATE_CMD_DESERIALIZERS[data['deserializerIndex']](data);
}
var RenderTemplateCmdSerializer = (function () {
    function RenderTemplateCmdSerializer() {
    }
    RenderTemplateCmdSerializer.prototype.visitText = function (cmd, context) {
        return {
            'deserializerIndex': 0,
            'isBound': cmd.isBound,
            'ngContentIndex': cmd.ngContentIndex,
            'value': cmd.value
        };
    };
    RenderTemplateCmdSerializer.prototype.visitNgContent = function (cmd, context) {
        return { 'deserializerIndex': 1, 'index': cmd.index, 'ngContentIndex': cmd.ngContentIndex };
    };
    RenderTemplateCmdSerializer.prototype.visitBeginElement = function (cmd, context) {
        return {
            'deserializerIndex': 2,
            'isBound': cmd.isBound,
            'ngContentIndex': cmd.ngContentIndex,
            'name': cmd.name,
            'attrNameAndValues': cmd.attrNameAndValues,
            'eventTargetAndNames': cmd.eventTargetAndNames
        };
    };
    RenderTemplateCmdSerializer.prototype.visitEndElement = function (context) { return { 'deserializerIndex': 3 }; };
    RenderTemplateCmdSerializer.prototype.visitBeginComponent = function (cmd, context) {
        return {
            'deserializerIndex': 4,
            'isBound': cmd.isBound,
            'ngContentIndex': cmd.ngContentIndex,
            'name': cmd.name,
            'attrNameAndValues': cmd.attrNameAndValues,
            'eventTargetAndNames': cmd.eventTargetAndNames,
            'templateId': cmd.templateId
        };
    };
    RenderTemplateCmdSerializer.prototype.visitEndComponent = function (context) { return { 'deserializerIndex': 5 }; };
    RenderTemplateCmdSerializer.prototype.visitEmbeddedTemplate = function (cmd, context) {
        var _this = this;
        var children = cmd.children.map(function (child) { return child.visit(_this, null); });
        return {
            'deserializerIndex': 6,
            'isBound': cmd.isBound,
            'ngContentIndex': cmd.ngContentIndex,
            'name': cmd.name,
            'attrNameAndValues': cmd.attrNameAndValues,
            'eventTargetAndNames': cmd.eventTargetAndNames,
            'isMerged': cmd.isMerged,
            'children': children
        };
    };
    return RenderTemplateCmdSerializer;
})();
var RENDER_TEMPLATE_CMD_SERIALIZER = new RenderTemplateCmdSerializer();
var RENDER_TEMPLATE_CMD_DESERIALIZERS = [
    function (data) {
        return new api_2.WebWorkerTextCmd(data['isBound'], data['ngContentIndex'], data['value']);
    },
    function (data) { return new api_2.WebWorkerNgContentCmd(data['index'], data['ngContentIndex']); },
    function (data) {
        return new api_2.WebWorkerBeginElementCmd(data['isBound'], data['ngContentIndex'], data['name'], data['attrNameAndValues'], data['eventTargetAndNames']);
    },
    function (data) { return new api_2.WebWorkerEndElementCmd(); },
    function (data) { return new api_2.WebWorkerBeginComponentCmd(data['isBound'], data['ngContentIndex'], data['name'], data['attrNameAndValues'], data['eventTargetAndNames'], data['templateId']); },
    function (data) { return new api_2.WebWorkerEndComponentCmd(); },
    function (data) { return new api_2.WebWorkerEmbeddedTemplateCmd(data['isBound'], data['ngContentIndex'], data['name'], data['attrNameAndValues'], data['eventTargetAndNames'], data['isMerged'], data['children'].map(function (childData) { return deserializeTemplateCmd(childData); })); },
];
//# sourceMappingURL=data:application/json;base64,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