import { StringWrapper, isBlank } from 'angular2/src/facade/lang';
var MODULE_REGEXP = /#MODULE\[([^\]]*)\]/g;
export function moduleRef(moduleUrl) {
    return `#MODULE[${moduleUrl}]`;
}
export class SourceModule {
    constructor(moduleUrl, sourceWithModuleRefs) {
        this.moduleUrl = moduleUrl;
        this.sourceWithModuleRefs = sourceWithModuleRefs;
    }
    getSourceWithImports() {
        var moduleAliases = {};
        var imports = [];
        var newSource = StringWrapper.replaceAllMapped(this.sourceWithModuleRefs, MODULE_REGEXP, (match) => {
            var moduleUrl = match[1];
            var alias = moduleAliases[moduleUrl];
            if (isBlank(alias)) {
                if (moduleUrl == this.moduleUrl) {
                    alias = '';
                }
                else {
                    alias = `import${imports.length}`;
                    imports.push([moduleUrl, alias]);
                }
                moduleAliases[moduleUrl] = alias;
            }
            return alias.length > 0 ? `${alias}.` : '';
        });
        return new SourceWithImports(newSource, imports);
    }
}
export class SourceExpression {
    constructor(declarations, expression) {
        this.declarations = declarations;
        this.expression = expression;
    }
}
export class SourceExpressions {
    constructor(declarations, expressions) {
        this.declarations = declarations;
        this.expressions = expressions;
    }
}
export class SourceWithImports {
    constructor(source, imports) {
        this.source = source;
        this.imports = imports;
    }
}
//# sourceMappingURL=data:application/json;base64,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