var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { SourceModule, SourceExpression, moduleRef } from './source_module';
import { ViewEncapsulation } from 'angular2/src/core/metadata/view';
import { XHR } from 'angular2/src/compiler/xhr';
import { IS_DART, isBlank } from 'angular2/src/facade/lang';
import { PromiseWrapper } from 'angular2/src/facade/async';
import { ShadowCss } from 'angular2/src/compiler/shadow_css';
import { UrlResolver } from 'angular2/src/compiler/url_resolver';
import { extractStyleUrls } from './style_url_resolver';
import { escapeSingleQuoteString, codeGenExportVariable, MODULE_SUFFIX } from './util';
import { Injectable } from 'angular2/src/core/di';
import { HOST_ATTR, CONTENT_ATTR } from 'angular2/src/core/render/view_factory';
export let StyleCompiler = class {
    constructor(_xhr, _urlResolver) {
        this._xhr = _xhr;
        this._urlResolver = _urlResolver;
        this._styleCache = new Map();
        this._shadowCss = new ShadowCss();
    }
    compileComponentRuntime(template) {
        var styles = template.styles;
        var styleAbsUrls = template.styleUrls;
        return this._loadStyles(styles, styleAbsUrls, template.encapsulation === ViewEncapsulation.Emulated);
    }
    compileComponentCodeGen(template) {
        var shim = template.encapsulation === ViewEncapsulation.Emulated;
        return this._styleCodeGen(template.styles, template.styleUrls, shim);
    }
    compileStylesheetCodeGen(stylesheetUrl, cssText) {
        var styleWithImports = extractStyleUrls(this._urlResolver, stylesheetUrl, cssText);
        return [
            this._styleModule(stylesheetUrl, false, this._styleCodeGen([styleWithImports.style], styleWithImports.styleUrls, false)),
            this._styleModule(stylesheetUrl, true, this._styleCodeGen([styleWithImports.style], styleWithImports.styleUrls, true))
        ];
    }
    clearCache() { this._styleCache.clear(); }
    _loadStyles(plainStyles, absUrls, encapsulate) {
        var promises = absUrls.map((absUrl) => {
            var cacheKey = `${absUrl}${encapsulate ? '.shim' : ''}`;
            var result = this._styleCache.get(cacheKey);
            if (isBlank(result)) {
                result = this._xhr.get(absUrl).then((style) => {
                    var styleWithImports = extractStyleUrls(this._urlResolver, absUrl, style);
                    return this._loadStyles([styleWithImports.style], styleWithImports.styleUrls, encapsulate);
                });
                this._styleCache.set(cacheKey, result);
            }
            return result;
        });
        return PromiseWrapper.all(promises).then((nestedStyles) => {
            var result = plainStyles.map(plainStyle => this._shimIfNeeded(plainStyle, encapsulate));
            nestedStyles.forEach(styles => result.push(styles));
            return result;
        });
    }
    _styleCodeGen(plainStyles, absUrls, shim) {
        var arrayPrefix = IS_DART ? `const` : '';
        var styleExpressions = plainStyles.map(plainStyle => escapeSingleQuoteString(this._shimIfNeeded(plainStyle, shim)));
        for (var i = 0; i < absUrls.length; i++) {
            var moduleUrl = this._createModuleUrl(absUrls[i], shim);
            styleExpressions.push(`${moduleRef(moduleUrl)}STYLES`);
        }
        var expressionSource = `${arrayPrefix} [${styleExpressions.join(',')}]`;
        return new SourceExpression([], expressionSource);
    }
    _styleModule(stylesheetUrl, shim, expression) {
        var moduleSource = `
      ${expression.declarations.join('\n')}
      ${codeGenExportVariable('STYLES')}${expression.expression};
    `;
        return new SourceModule(this._createModuleUrl(stylesheetUrl, shim), moduleSource);
    }
    _shimIfNeeded(style, shim) {
        return shim ? this._shadowCss.shimCssText(style, CONTENT_ATTR, HOST_ATTR) : style;
    }
    _createModuleUrl(stylesheetUrl, shim) {
        return shim ? `${stylesheetUrl}.shim${MODULE_SUFFIX}` : `${stylesheetUrl}${MODULE_SUFFIX}`;
    }
};
StyleCompiler = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [XHR, UrlResolver])
], StyleCompiler);
//# sourceMappingURL=data:application/json;base64,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