var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { IS_DART, isBlank, stringify } from 'angular2/src/facade/lang';
import { BaseException } from 'angular2/src/facade/exceptions';
import { ListWrapper, SetWrapper } from 'angular2/src/facade/collection';
import { PromiseWrapper } from 'angular2/src/facade/async';
import { CompiledComponentTemplate, CompiledHostTemplate, BeginComponentCmd } from 'angular2/src/core/linker/template_commands';
import { createHostComponentMeta, CompileDirectiveMetadata } from './directive_metadata';
import { Injectable } from 'angular2/src/core/di';
import { SourceModule, moduleRef } from './source_module';
import { ChangeDetectionCompiler } from './change_detector_compiler';
import { StyleCompiler } from './style_compiler';
import { CommandCompiler } from './command_compiler';
import { TemplateParser } from './template_parser';
import { TemplateNormalizer } from './template_normalizer';
import { RuntimeMetadataResolver } from './runtime_metadata';
import { TEMPLATE_COMMANDS_MODULE_REF } from './command_compiler';
import { codeGenExportVariable, codeGenValueFn, MODULE_SUFFIX } from './util';
export let TemplateCompiler = class {
    constructor(_runtimeMetadataResolver, _templateNormalizer, _templateParser, _styleCompiler, _commandCompiler, _cdCompiler) {
        this._runtimeMetadataResolver = _runtimeMetadataResolver;
        this._templateNormalizer = _templateNormalizer;
        this._templateParser = _templateParser;
        this._styleCompiler = _styleCompiler;
        this._commandCompiler = _commandCompiler;
        this._cdCompiler = _cdCompiler;
        this._hostCacheKeys = new Map();
        this._compiledTemplateCache = new Map();
        this._compiledTemplateDone = new Map();
        this._nextTemplateId = 0;
    }
    normalizeDirectiveMetadata(directive) {
        if (!directive.isComponent) {
            // For non components there is nothing to be normalized yet.
            return PromiseWrapper.resolve(directive);
        }
        return this._templateNormalizer.normalizeTemplate(directive.type, directive.template)
            .then((normalizedTemplate) => new CompileDirectiveMetadata({
            type: directive.type,
            isComponent: directive.isComponent,
            dynamicLoadable: directive.dynamicLoadable,
            selector: directive.selector,
            exportAs: directive.exportAs,
            changeDetection: directive.changeDetection,
            inputs: directive.inputs,
            outputs: directive.outputs,
            hostListeners: directive.hostListeners,
            hostProperties: directive.hostProperties,
            hostAttributes: directive.hostAttributes,
            lifecycleHooks: directive.lifecycleHooks,
            template: normalizedTemplate
        }));
    }
    compileHostComponentRuntime(type) {
        var hostCacheKey = this._hostCacheKeys.get(type);
        if (isBlank(hostCacheKey)) {
            hostCacheKey = new Object();
            this._hostCacheKeys.set(type, hostCacheKey);
            var compMeta = this._runtimeMetadataResolver.getMetadata(type);
            assertComponent(compMeta);
            var hostMeta = createHostComponentMeta(compMeta.type, compMeta.selector);
            this._compileComponentRuntime(hostCacheKey, hostMeta, [compMeta], new Set());
        }
        return this._compiledTemplateDone.get(hostCacheKey)
            .then(compiledTemplate => new CompiledHostTemplate(compiledTemplate));
    }
    clearCache() {
        this._hostCacheKeys.clear();
        this._styleCompiler.clearCache();
        this._compiledTemplateCache.clear();
        this._compiledTemplateDone.clear();
    }
    _compileComponentRuntime(cacheKey, compMeta, viewDirectives, compilingComponentCacheKeys) {
        let uniqViewDirectives = removeDuplicates(viewDirectives);
        var compiledTemplate = this._compiledTemplateCache.get(cacheKey);
        var done = this._compiledTemplateDone.get(cacheKey);
        if (isBlank(compiledTemplate)) {
            var styles = [];
            var changeDetectorFactory;
            var commands = [];
            var templateId = `${stringify(compMeta.type.runtime)}Template${this._nextTemplateId++}`;
            compiledTemplate = new CompiledComponentTemplate(templateId, (dispatcher) => changeDetectorFactory(dispatcher), commands, styles);
            this._compiledTemplateCache.set(cacheKey, compiledTemplate);
            compilingComponentCacheKeys.add(cacheKey);
            done = PromiseWrapper
                .all([this._styleCompiler.compileComponentRuntime(compMeta.template)].concat(uniqViewDirectives.map(dirMeta => this.normalizeDirectiveMetadata(dirMeta))))
                .then((stylesAndNormalizedViewDirMetas) => {
                var childPromises = [];
                var normalizedViewDirMetas = stylesAndNormalizedViewDirMetas.slice(1);
                var parsedTemplate = this._templateParser.parse(compMeta.template.template, normalizedViewDirMetas, compMeta.type.name);
                var changeDetectorFactories = this._cdCompiler.compileComponentRuntime(compMeta.type, compMeta.changeDetection, parsedTemplate);
                changeDetectorFactory = changeDetectorFactories[0];
                var tmpStyles = stylesAndNormalizedViewDirMetas[0];
                tmpStyles.forEach(style => styles.push(style));
                var tmpCommands = this._compileCommandsRuntime(compMeta, parsedTemplate, changeDetectorFactories, compilingComponentCacheKeys, childPromises);
                tmpCommands.forEach(cmd => commands.push(cmd));
                return PromiseWrapper.all(childPromises);
            })
                .then((_) => {
                SetWrapper.delete(compilingComponentCacheKeys, cacheKey);
                return compiledTemplate;
            });
            this._compiledTemplateDone.set(cacheKey, done);
        }
        return compiledTemplate;
    }
    _compileCommandsRuntime(compMeta, parsedTemplate, changeDetectorFactories, compilingComponentCacheKeys, childPromises) {
        var cmds = this._commandCompiler.compileComponentRuntime(compMeta, parsedTemplate, changeDetectorFactories, (childComponentDir) => {
            var childCacheKey = childComponentDir.type.runtime;
            var childViewDirectives = this._runtimeMetadataResolver.getViewDirectivesMetadata(childComponentDir.type.runtime);
            var childIsRecursive = SetWrapper.has(compilingComponentCacheKeys, childCacheKey);
            var childTemplate = this._compileComponentRuntime(childCacheKey, childComponentDir, childViewDirectives, compilingComponentCacheKeys);
            if (!childIsRecursive) {
                // Only wait for a child if it is not a cycle
                childPromises.push(this._compiledTemplateDone.get(childCacheKey));
            }
            return () => childTemplate;
        });
        cmds.forEach(cmd => {
            if (cmd instanceof BeginComponentCmd) {
                cmd.templateGetter();
            }
        });
        return cmds;
    }
    compileTemplatesCodeGen(components) {
        if (components.length === 0) {
            throw new BaseException('No components given');
        }
        var declarations = [];
        var templateArguments = [];
        var componentMetas = [];
        components.forEach(componentWithDirs => {
            var compMeta = componentWithDirs.component;
            assertComponent(compMeta);
            componentMetas.push(compMeta);
            this._processTemplateCodeGen(compMeta, componentWithDirs.directives, declarations, templateArguments);
            if (compMeta.dynamicLoadable) {
                var hostMeta = createHostComponentMeta(compMeta.type, compMeta.selector);
                componentMetas.push(hostMeta);
                this._processTemplateCodeGen(hostMeta, [compMeta], declarations, templateArguments);
            }
        });
        ListWrapper.forEachWithIndex(componentMetas, (compMeta, index) => {
            var templateId = `${compMeta.type.moduleUrl}|${compMeta.type.name}`;
            var constructionKeyword = IS_DART ? 'const' : 'new';
            var compiledTemplateExpr = `${constructionKeyword} ${TEMPLATE_COMMANDS_MODULE_REF}CompiledComponentTemplate('${templateId}',${templateArguments[index].join(',')})`;
            var variableValueExpr;
            if (compMeta.type.isHost) {
                variableValueExpr =
                    `${constructionKeyword} ${TEMPLATE_COMMANDS_MODULE_REF}CompiledHostTemplate(${compiledTemplateExpr})`;
            }
            else {
                variableValueExpr = compiledTemplateExpr;
            }
            var varName = templateVariableName(compMeta.type);
            declarations.push(`${codeGenExportVariable(varName)}${variableValueExpr};`);
            declarations.push(`${codeGenValueFn([], varName, templateGetterName(compMeta.type))};`);
        });
        var moduleUrl = components[0].component.type.moduleUrl;
        return new SourceModule(`${templateModuleUrl(moduleUrl)}`, declarations.join('\n'));
    }
    compileStylesheetCodeGen(stylesheetUrl, cssText) {
        return this._styleCompiler.compileStylesheetCodeGen(stylesheetUrl, cssText);
    }
    _processTemplateCodeGen(compMeta, directives, targetDeclarations, targetTemplateArguments) {
        let uniqueDirectives = removeDuplicates(directives);
        var styleExpr = this._styleCompiler.compileComponentCodeGen(compMeta.template);
        var parsedTemplate = this._templateParser.parse(compMeta.template.template, uniqueDirectives, compMeta.type.name);
        var changeDetectorsExprs = this._cdCompiler.compileComponentCodeGen(compMeta.type, compMeta.changeDetection, parsedTemplate);
        var commandsExpr = this._commandCompiler.compileComponentCodeGen(compMeta, parsedTemplate, changeDetectorsExprs.expressions, codeGenComponentTemplateFactory);
        addAll(styleExpr.declarations, targetDeclarations);
        addAll(changeDetectorsExprs.declarations, targetDeclarations);
        addAll(commandsExpr.declarations, targetDeclarations);
        targetTemplateArguments.push([changeDetectorsExprs.expressions[0], commandsExpr.expression, styleExpr.expression]);
    }
};
TemplateCompiler = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [RuntimeMetadataResolver, TemplateNormalizer, TemplateParser, StyleCompiler, CommandCompiler, ChangeDetectionCompiler])
], TemplateCompiler);
export class NormalizedComponentWithViewDirectives {
    constructor(component, directives) {
        this.component = component;
        this.directives = directives;
    }
}
function assertComponent(meta) {
    if (!meta.isComponent) {
        throw new BaseException(`Could not compile '${meta.type.name}' because it is not a component.`);
    }
}
function templateVariableName(type) {
    return `${type.name}Template`;
}
function templateGetterName(type) {
    return `${templateVariableName(type)}Getter`;
}
function templateModuleUrl(moduleUrl) {
    var urlWithoutSuffix = moduleUrl.substring(0, moduleUrl.length - MODULE_SUFFIX.length);
    return `${urlWithoutSuffix}.template${MODULE_SUFFIX}`;
}
function addAll(source, target) {
    for (var i = 0; i < source.length; i++) {
        target.push(source[i]);
    }
}
function codeGenComponentTemplateFactory(nestedCompType) {
    return `${moduleRef(templateModuleUrl(nestedCompType.type.moduleUrl))}${templateGetterName(nestedCompType.type)}`;
}
function removeDuplicates(items) {
    let res = [];
    items.forEach(item => {
        let hasMatch = res.filter(r => r.type.name == item.type.name && r.type.moduleUrl == item.type.moduleUrl &&
            r.type.runtime == item.type.runtime)
            .length > 0;
        if (!hasMatch) {
            res.push(item);
        }
    });
    return res;
}
//# sourceMappingURL=data:application/json;base64,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