import { Provider } from 'angular2/src/core/di';
export declare function createWithoutPackagePrefix(): UrlResolver;
export declare var DEFAULT_PACKAGE_URL_PROVIDER: Provider;
/**
 * Used by the {@link Compiler} when resolving HTML and CSS template URLs.
 *
 * This interface can be overridden by the application developer to create custom behavior.
 *
 * See {@link Compiler}
 */
export declare class UrlResolver {
    private _packagePrefix;
    constructor(packagePrefix?: string);
    /**
     * Resolves the `url` given the `baseUrl`:
     * - when the `url` is null, the `baseUrl` is returned,
     * - if `url` is relative ('path/to/here', './path/to/here'), the resolved url is a combination of
     * `baseUrl` and `url`,
     * - if `url` is absolute (it has a scheme: 'http://', 'https://' or start with '/'), the `url` is
     * returned as is (ignoring the `baseUrl`)
     *
     * @param {string} baseUrl
     * @param {string} url
     * @returns {string} the resolved URL
     */
    resolve(baseUrl: string, url: string): string;
}
export declare function getUrlScheme(url: string): string;
