'use strict';var xhr_1 = require('angular2/src/compiler/xhr');
var xhr_impl_1 = require('angular2/src/web_workers/worker/xhr_impl');
var collection_1 = require('angular2/src/facade/collection');
var renderer_1 = require('angular2/src/web_workers/worker/renderer');
var lang_1 = require('angular2/src/facade/lang');
var message_bus_1 = require('angular2/src/web_workers/shared/message_bus');
var api_1 = require('angular2/src/core/render/api');
var core_1 = require('angular2/core');
var common_1 = require("angular2/common");
var client_message_broker_1 = require('angular2/src/web_workers/shared/client_message_broker');
var service_message_broker_1 = require('angular2/src/web_workers/shared/service_message_broker');
var compiler_1 = require('angular2/src/compiler/compiler');
var serializer_1 = require("angular2/src/web_workers/shared/serializer");
var api_2 = require("angular2/src/web_workers/shared/api");
var di_1 = require('angular2/src/core/di');
var render_proto_view_ref_store_1 = require('angular2/src/web_workers/shared/render_proto_view_ref_store');
var render_view_with_fragments_store_1 = require('angular2/src/web_workers/shared/render_view_with_fragments_store');
var event_dispatcher_1 = require('angular2/src/web_workers/worker/event_dispatcher');
var async_1 = require('angular2/src/facade/async');
var PrintLogger = (function () {
    function PrintLogger() {
        this.log = lang_1.print;
        this.logError = lang_1.print;
        this.logGroup = lang_1.print;
    }
    PrintLogger.prototype.logGroupEnd = function () { };
    return PrintLogger;
})();
exports.WORKER_APP_PLATFORM = lang_1.CONST_EXPR([core_1.PLATFORM_COMMON_PROVIDERS]);
exports.WORKER_APP_COMMON_PROVIDERS = lang_1.CONST_EXPR([
    core_1.APPLICATION_COMMON_PROVIDERS,
    compiler_1.COMPILER_PROVIDERS,
    common_1.FORM_PROVIDERS,
    serializer_1.Serializer,
    new di_1.Provider(core_1.PLATFORM_PIPES, { useValue: common_1.COMMON_PIPES, multi: true }),
    new di_1.Provider(core_1.PLATFORM_DIRECTIVES, { useValue: common_1.COMMON_DIRECTIVES, multi: true }),
    new di_1.Provider(client_message_broker_1.ClientMessageBrokerFactory, { useClass: client_message_broker_1.ClientMessageBrokerFactory_ }),
    new di_1.Provider(service_message_broker_1.ServiceMessageBrokerFactory, { useClass: service_message_broker_1.ServiceMessageBrokerFactory_ }),
    renderer_1.WebWorkerRenderer,
    new di_1.Provider(api_1.Renderer, { useExisting: renderer_1.WebWorkerRenderer }),
    new di_1.Provider(api_2.ON_WEB_WORKER, { useValue: true }),
    render_view_with_fragments_store_1.RenderViewWithFragmentsStore,
    render_proto_view_ref_store_1.RenderProtoViewRefStore,
    new di_1.Provider(core_1.ExceptionHandler, { useFactory: _exceptionHandler, deps: [] }),
    xhr_impl_1.WebWorkerXHRImpl,
    new di_1.Provider(xhr_1.XHR, { useExisting: xhr_impl_1.WebWorkerXHRImpl }),
    event_dispatcher_1.WebWorkerEventDispatcher
]);
function _exceptionHandler() {
    return new core_1.ExceptionHandler(new PrintLogger());
}
/**
 * Asynchronously returns a list of providers that can be used to initialize the
 * Application injector.
 * Also takes care of attaching the {@link MessageBus} to the given {@link NgZone}.
 */
function genericWorkerAppProviders(bus, zone) {
    bus.attachToZone(zone);
    var bindings = collection_1.ListWrapper.concat(exports.WORKER_APP_COMMON_PROVIDERS, [
        new di_1.Provider(message_bus_1.MessageBus, { useValue: bus }),
    ]);
    return async_1.PromiseWrapper.resolve(bindings);
}
exports.genericWorkerAppProviders = genericWorkerAppProviders;
//# sourceMappingURL=data:application/json;base64,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