'use strict';var lang_1 = require('angular2/src/facade/lang');
var exceptions_1 = require('angular2/src/facade/exceptions');
var collection_1 = require('angular2/src/facade/collection');
var Locals = (function () {
    function Locals(parent, current) {
        this.parent = parent;
        this.current = current;
    }
    Locals.prototype.contains = function (name) {
        if (this.current.has(name)) {
            return true;
        }
        if (lang_1.isPresent(this.parent)) {
            return this.parent.contains(name);
        }
        return false;
    };
    Locals.prototype.get = function (name) {
        if (this.current.has(name)) {
            return this.current.get(name);
        }
        if (lang_1.isPresent(this.parent)) {
            return this.parent.get(name);
        }
        throw new exceptions_1.BaseException("Cannot find '" + name + "'");
    };
    Locals.prototype.set = function (name, value) {
        // TODO(rado): consider removing this check if we can guarantee this is not
        // exposed to the public API.
        // TODO: vsavkin maybe it should check only the local map
        if (this.current.has(name)) {
            this.current.set(name, value);
        }
        else {
            throw new exceptions_1.BaseException("Setting of new keys post-construction is not supported. Key: " + name + ".");
        }
    };
    Locals.prototype.clearValues = function () { collection_1.MapWrapper.clearValues(this.current); };
    return Locals;
})();
exports.Locals = Locals;
//# sourceMappingURL=data:application/json;base64,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