var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { RenderProtoViewRef, RenderViewRef, RenderFragmentRef, RenderComponentTemplate } from 'angular2/src/core/render/api';
import { ClientMessageBrokerFactory, FnArg, UiArguments } from "angular2/src/web_workers/shared/client_message_broker";
import { isPresent } from "angular2/src/facade/lang";
import { Injectable } from "angular2/src/core/di";
import { RenderProtoViewRefStore } from 'angular2/src/web_workers/shared/render_proto_view_ref_store';
import { RenderViewWithFragmentsStore } from 'angular2/src/web_workers/shared/render_view_with_fragments_store';
import { WebWorkerElementRef, WebWorkerTemplateCmd } from 'angular2/src/web_workers/shared/api';
import { RENDERER_CHANNEL } from 'angular2/src/web_workers/shared/messaging_api';
import { WebWorkerEventDispatcher } from 'angular2/src/web_workers/worker/event_dispatcher';
export let WebWorkerRenderer = class {
    constructor(messageBrokerFactory, _renderProtoViewRefStore, _renderViewStore, _eventDispatcher) {
        this._renderProtoViewRefStore = _renderProtoViewRefStore;
        this._renderViewStore = _renderViewStore;
        this._eventDispatcher = _eventDispatcher;
        this._messageBroker = messageBrokerFactory.createMessageBroker(RENDERER_CHANNEL);
    }
    registerComponentTemplate(template) {
        var fnArgs = [new FnArg(template, RenderComponentTemplate)];
        var args = new UiArguments("registerComponentTemplate", fnArgs);
        this._messageBroker.runOnService(args, null);
    }
    createProtoView(componentTemplateId, cmds) {
        var renderProtoViewRef = this._renderProtoViewRefStore.allocate();
        var fnArgs = [
            new FnArg(componentTemplateId, null),
            new FnArg(cmds, WebWorkerTemplateCmd),
            new FnArg(renderProtoViewRef, RenderProtoViewRef)
        ];
        var args = new UiArguments("createProtoView", fnArgs);
        this._messageBroker.runOnService(args, null);
        return renderProtoViewRef;
    }
    /**
     * Creates a root host view that includes the given element.
     * Note that the fragmentCount needs to be passed in so that we can create a result
     * synchronously even when dealing with webworkers!
     *
     * @param {RenderProtoViewRef} hostProtoViewRef a RenderProtoViewRef of type
     * ProtoViewDto.HOST_VIEW_TYPE
     * @param {any} hostElementSelector css selector for the host element (will be queried against the
     * main document)
     * @return {RenderViewRef} the created view
     */
    createRootHostView(hostProtoViewRef, fragmentCount, hostElementSelector) {
        return this._createViewHelper(hostProtoViewRef, fragmentCount, hostElementSelector);
    }
    /**
     * Creates a regular view out of the given ProtoView
     * Note that the fragmentCount needs to be passed in so that we can create a result
     * synchronously even when dealing with webworkers!
     */
    createView(protoViewRef, fragmentCount) {
        return this._createViewHelper(protoViewRef, fragmentCount);
    }
    _createViewHelper(protoViewRef, fragmentCount, hostElementSelector) {
        var renderViewWithFragments = this._renderViewStore.allocate(fragmentCount);
        var startIndex = (renderViewWithFragments.viewRef).refNumber;
        var fnArgs = [
            new FnArg(protoViewRef, RenderProtoViewRef),
            new FnArg(fragmentCount, null),
        ];
        var method = "createView";
        if (isPresent(hostElementSelector) && hostElementSelector != null) {
            fnArgs.push(new FnArg(hostElementSelector, null));
            method = "createRootHostView";
        }
        fnArgs.push(new FnArg(startIndex, null));
        var args = new UiArguments(method, fnArgs);
        this._messageBroker.runOnService(args, null);
        return renderViewWithFragments;
    }
    /**
     * Destroys the given view after it has been dehydrated and detached
     */
    destroyView(viewRef) {
        var fnArgs = [new FnArg(viewRef, RenderViewRef)];
        var args = new UiArguments("destroyView", fnArgs);
        this._messageBroker.runOnService(args, null);
        this._renderViewStore.remove(viewRef);
    }
    /**
     * Attaches a fragment after another fragment.
     */
    attachFragmentAfterFragment(previousFragmentRef, fragmentRef) {
        var fnArgs = [
            new FnArg(previousFragmentRef, RenderFragmentRef),
            new FnArg(fragmentRef, RenderFragmentRef)
        ];
        var args = new UiArguments("attachFragmentAfterFragment", fnArgs);
        this._messageBroker.runOnService(args, null);
    }
    /**
     * Attaches a fragment after an element.
     */
    attachFragmentAfterElement(elementRef, fragmentRef) {
        var fnArgs = [new FnArg(elementRef, WebWorkerElementRef), new FnArg(fragmentRef, RenderFragmentRef)];
        var args = new UiArguments("attachFragmentAfterElement", fnArgs);
        this._messageBroker.runOnService(args, null);
    }
    /**
     * Detaches a fragment.
     */
    detachFragment(fragmentRef) {
        var fnArgs = [new FnArg(fragmentRef, RenderFragmentRef)];
        var args = new UiArguments("detachFragment", fnArgs);
        this._messageBroker.runOnService(args, null);
    }
    /**
     * Hydrates a view after it has been attached. Hydration/dehydration is used for reusing views
     * inside of the view pool.
     */
    hydrateView(viewRef) {
        var fnArgs = [new FnArg(viewRef, RenderViewRef)];
        var args = new UiArguments("hydrateView", fnArgs);
        this._messageBroker.runOnService(args, null);
    }
    /**
     * Dehydrates a view after it has been attached. Hydration/dehydration is used for reusing views
     * inside of the view pool.
     */
    dehydrateView(viewRef) {
        var fnArgs = [new FnArg(viewRef, RenderViewRef)];
        var args = new UiArguments("dehydrateView", fnArgs);
        this._messageBroker.runOnService(args, null);
    }
    /**
     * Returns the native element at the given location.
     * Attention: In a WebWorker scenario, this should always return null!
     */
    getNativeElementSync(location) { return null; }
    /**
     * Sets a property on an element.
     */
    setElementProperty(location, propertyName, propertyValue) {
        var fnArgs = [
            new FnArg(location, WebWorkerElementRef),
            new FnArg(propertyName, null),
            new FnArg(propertyValue, null)
        ];
        var args = new UiArguments("setElementProperty", fnArgs);
        this._messageBroker.runOnService(args, null);
    }
    /**
     * Sets an attribute on an element.
     */
    setElementAttribute(location, attributeName, attributeValue) {
        var fnArgs = [
            new FnArg(location, WebWorkerElementRef),
            new FnArg(attributeName, null),
            new FnArg(attributeValue, null)
        ];
        var args = new UiArguments("setElementAttribute", fnArgs);
        this._messageBroker.runOnService(args, null);
    }
    setBindingDebugInfo(location, propertyName, propertyValue) {
        var fnArgs = [
            new FnArg(location, WebWorkerElementRef),
            new FnArg(propertyName, null),
            new FnArg(propertyValue, null)
        ];
        var args = new UiArguments("setBindingDebugInfo", fnArgs);
        this._messageBroker.runOnService(args, null);
    }
    /**
     * Sets a class on an element.
     */
    setElementClass(location, className, isAdd) {
        var fnArgs = [
            new FnArg(location, WebWorkerElementRef),
            new FnArg(className, null),
            new FnArg(isAdd, null)
        ];
        var args = new UiArguments("setElementClass", fnArgs);
        this._messageBroker.runOnService(args, null);
    }
    /**
     * Sets a style on an element.
     */
    setElementStyle(location, styleName, styleValue) {
        var fnArgs = [
            new FnArg(location, WebWorkerElementRef),
            new FnArg(styleName, null),
            new FnArg(styleValue, null)
        ];
        var args = new UiArguments("setElementStyle", fnArgs);
        this._messageBroker.runOnService(args, null);
    }
    /**
     * Calls a method on an element.
     * Note: For now we're assuming that everything in the args list are primitive
     */
    invokeElementMethod(location, methodName, args) {
        var fnArgs = [
            new FnArg(location, WebWorkerElementRef),
            new FnArg(methodName, null),
            new FnArg(args, null)
        ];
        var uiArgs = new UiArguments("invokeElementMethod", fnArgs);
        this._messageBroker.runOnService(uiArgs, null);
    }
    /**
     * Sets the value of a text node.
     */
    setText(viewRef, textNodeIndex, text) {
        var fnArgs = [new FnArg(viewRef, RenderViewRef), new FnArg(textNodeIndex, null), new FnArg(text, null)];
        var args = new UiArguments("setText", fnArgs);
        this._messageBroker.runOnService(args, null);
    }
    /**
     * Sets the dispatcher for all events of the given view
     */
    setEventDispatcher(viewRef, dispatcher) {
        var fnArgs = [new FnArg(viewRef, RenderViewRef)];
        var args = new UiArguments("setEventDispatcher", fnArgs);
        this._eventDispatcher.registerEventDispatcher(viewRef, dispatcher);
        this._messageBroker.runOnService(args, null);
    }
};
WebWorkerRenderer = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [ClientMessageBrokerFactory, RenderProtoViewRefStore, RenderViewWithFragmentsStore, WebWorkerEventDispatcher])
], WebWorkerRenderer);
//# sourceMappingURL=data:application/json;base64,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