import { CONST_EXPR, isPresent, isBlank, looseIdentical } from 'angular2/src/facade/lang';
import { BaseException } from 'angular2/src/facade/exceptions';
import { StringMapWrapper } from 'angular2/src/facade/collection';
import { ChangeDetectionStrategy, isDefaultChangeDetectionStrategy } from './constants';
import { implementsOnDestroy } from './pipe_lifecycle_reflector';
import { BindingTarget } from './binding_record';
import { DirectiveIndex } from './directive_record';
/**
 * Indicates that the result of a {@link PipeMetadata} transformation has changed even though the
 * reference
 * has not changed.
 *
 * The wrapped value will be unwrapped by change detection, and the unwrapped value will be stored.
 *
 * Example:
 *
 * ```
 * if (this._latestValue === this._latestReturnedValue) {
 *    return this._latestReturnedValue;
 *  } else {
 *    this._latestReturnedValue = this._latestValue;
 *    return WrappedValue.wrap(this._latestValue); // this will force update
 *  }
 * ```
 */
export class WrappedValue {
    constructor(wrapped) {
        this.wrapped = wrapped;
    }
    static wrap(value) {
        var w = _wrappedValues[_wrappedIndex++ % 5];
        w.wrapped = value;
        return w;
    }
}
var _wrappedValues = [
    new WrappedValue(null),
    new WrappedValue(null),
    new WrappedValue(null),
    new WrappedValue(null),
    new WrappedValue(null)
];
var _wrappedIndex = 0;
/**
 * Represents a basic change from a previous to a new value.
 */
export class SimpleChange {
    constructor(previousValue, currentValue) {
        this.previousValue = previousValue;
        this.currentValue = currentValue;
    }
    /**
     * Check whether the new value is the first value assigned.
     */
    isFirstChange() { return this.previousValue === ChangeDetectionUtil.uninitialized; }
}
var _simpleChangesIndex = 0;
var _simpleChanges = [
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null),
    new SimpleChange(null, null)
];
function _simpleChange(previousValue, currentValue) {
    var index = _simpleChangesIndex++ % 20;
    var s = _simpleChanges[index];
    s.previousValue = previousValue;
    s.currentValue = currentValue;
    return s;
}
/* tslint:disable:requireParameterType */
export class ChangeDetectionUtil {
    static arrayFn0() { return []; }
    static arrayFn1(a1) { return [a1]; }
    static arrayFn2(a1, a2) { return [a1, a2]; }
    static arrayFn3(a1, a2, a3) { return [a1, a2, a3]; }
    static arrayFn4(a1, a2, a3, a4) { return [a1, a2, a3, a4]; }
    static arrayFn5(a1, a2, a3, a4, a5) { return [a1, a2, a3, a4, a5]; }
    static arrayFn6(a1, a2, a3, a4, a5, a6) { return [a1, a2, a3, a4, a5, a6]; }
    static arrayFn7(a1, a2, a3, a4, a5, a6, a7) { return [a1, a2, a3, a4, a5, a6, a7]; }
    static arrayFn8(a1, a2, a3, a4, a5, a6, a7, a8) {
        return [a1, a2, a3, a4, a5, a6, a7, a8];
    }
    static arrayFn9(a1, a2, a3, a4, a5, a6, a7, a8, a9) {
        return [a1, a2, a3, a4, a5, a6, a7, a8, a9];
    }
    static operation_negate(value) { return !value; }
    static operation_add(left, right) { return left + right; }
    static operation_subtract(left, right) { return left - right; }
    static operation_multiply(left, right) { return left * right; }
    static operation_divide(left, right) { return left / right; }
    static operation_remainder(left, right) { return left % right; }
    static operation_equals(left, right) { return left == right; }
    static operation_not_equals(left, right) { return left != right; }
    static operation_identical(left, right) { return left === right; }
    static operation_not_identical(left, right) { return left !== right; }
    static operation_less_then(left, right) { return left < right; }
    static operation_greater_then(left, right) { return left > right; }
    static operation_less_or_equals_then(left, right) { return left <= right; }
    static operation_greater_or_equals_then(left, right) { return left >= right; }
    static cond(cond, trueVal, falseVal) { return cond ? trueVal : falseVal; }
    static mapFn(keys) {
        function buildMap(values) {
            var res = StringMapWrapper.create();
            for (var i = 0; i < keys.length; ++i) {
                StringMapWrapper.set(res, keys[i], values[i]);
            }
            return res;
        }
        switch (keys.length) {
            case 0:
                return () => [];
            case 1:
                return (a1) => buildMap([a1]);
            case 2:
                return (a1, a2) => buildMap([a1, a2]);
            case 3:
                return (a1, a2, a3) => buildMap([a1, a2, a3]);
            case 4:
                return (a1, a2, a3, a4) => buildMap([a1, a2, a3, a4]);
            case 5:
                return (a1, a2, a3, a4, a5) => buildMap([a1, a2, a3, a4, a5]);
            case 6:
                return (a1, a2, a3, a4, a5, a6) => buildMap([a1, a2, a3, a4, a5, a6]);
            case 7:
                return (a1, a2, a3, a4, a5, a6, a7) => buildMap([a1, a2, a3, a4, a5, a6, a7]);
            case 8:
                return (a1, a2, a3, a4, a5, a6, a7, a8) => buildMap([a1, a2, a3, a4, a5, a6, a7, a8]);
            case 9:
                return (a1, a2, a3, a4, a5, a6, a7, a8, a9) => buildMap([a1, a2, a3, a4, a5, a6, a7, a8, a9]);
            default:
                throw new BaseException(`Does not support literal maps with more than 9 elements`);
        }
    }
    static keyedAccess(obj, args) { return obj[args[0]]; }
    static unwrapValue(value) {
        if (value instanceof WrappedValue) {
            return value.wrapped;
        }
        else {
            return value;
        }
    }
    static changeDetectionMode(strategy) {
        return isDefaultChangeDetectionStrategy(strategy) ? ChangeDetectionStrategy.CheckAlways :
            ChangeDetectionStrategy.CheckOnce;
    }
    static simpleChange(previousValue, currentValue) {
        return _simpleChange(previousValue, currentValue);
    }
    static isValueBlank(value) { return isBlank(value); }
    static s(value) { return isPresent(value) ? `${value}` : ''; }
    static protoByIndex(protos, selfIndex) {
        return selfIndex < 1 ?
            null :
            protos[selfIndex - 1]; // self index is shifted by one because of context
    }
    static callPipeOnDestroy(selectedPipe) {
        if (implementsOnDestroy(selectedPipe.pipe)) {
            selectedPipe.pipe.ngOnDestroy();
        }
    }
    static bindingTarget(mode, elementIndex, name, unit, debug) {
        return new BindingTarget(mode, elementIndex, name, unit, debug);
    }
    static directiveIndex(elementIndex, directiveIndex) {
        return new DirectiveIndex(elementIndex, directiveIndex);
    }
    static looseNotIdentical(a, b) { return !looseIdentical(a, b); }
}
ChangeDetectionUtil.uninitialized = CONST_EXPR(new Object());
//# sourceMappingURL=data:application/json;base64,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