var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Inject, Injectable } from 'angular2/src/core/di';
import { AnimationBuilder } from 'angular2/src/animate/animation_builder';
import { isPresent, isBlank, Json, RegExpWrapper, CONST_EXPR, stringify, StringWrapper, isArray } from 'angular2/src/facade/lang';
import { BaseException } from 'angular2/src/facade/exceptions';
import { DomSharedStylesHost } from './shared_styles_host';
import { EventManager } from './events/event_manager';
import { DOCUMENT } from './dom_tokens';
import { ViewEncapsulation } from 'angular2/src/core/metadata';
import { DOM } from 'angular2/src/platform/dom/dom_adapter';
import { camelCaseToDashCase } from './util';
const NAMESPACE_URIS = CONST_EXPR({ 'xlink': 'http://www.w3.org/1999/xlink', 'svg': 'http://www.w3.org/2000/svg' });
const TEMPLATE_COMMENT_TEXT = 'template bindings={}';
var TEMPLATE_BINDINGS_EXP = /^template bindings=(.*)$/g;
export class DomRootRenderer {
    constructor(document, eventManager, sharedStylesHost, animate) {
        this.document = document;
        this.eventManager = eventManager;
        this.sharedStylesHost = sharedStylesHost;
        this.animate = animate;
        this._registeredComponents = new Map();
    }
    renderComponent(componentProto) {
        var renderer = this._registeredComponents.get(componentProto.id);
        if (isBlank(renderer)) {
            renderer = new DomRenderer(this, componentProto);
            this._registeredComponents.set(componentProto.id, renderer);
        }
        return renderer;
    }
}
export let DomRootRenderer_ = class extends DomRootRenderer {
    constructor(_document, _eventManager, sharedStylesHost, animate) {
        super(_document, _eventManager, sharedStylesHost, animate);
    }
};
DomRootRenderer_ = __decorate([
    Injectable(),
    __param(0, Inject(DOCUMENT)), 
    __metadata('design:paramtypes', [Object, EventManager, DomSharedStylesHost, AnimationBuilder])
], DomRootRenderer_);
export class DomRenderer {
    constructor(_rootRenderer, componentProto) {
        this._rootRenderer = _rootRenderer;
        this.componentProto = componentProto;
        this._styles = _flattenStyles(componentProto.id, componentProto.styles, []);
        if (componentProto.encapsulation !== ViewEncapsulation.Native) {
            this._rootRenderer.sharedStylesHost.addStyles(this._styles);
        }
        if (this.componentProto.encapsulation === ViewEncapsulation.Emulated) {
            this._contentAttr = _shimContentAttribute(componentProto.id);
            this._hostAttr = _shimHostAttribute(componentProto.id);
        }
        else {
            this._contentAttr = null;
            this._hostAttr = null;
        }
    }
    renderComponent(componentProto) {
        return this._rootRenderer.renderComponent(componentProto);
    }
    selectRootElement(selector) {
        var el = DOM.querySelector(this._rootRenderer.document, selector);
        if (isBlank(el)) {
            throw new BaseException(`The selector "${selector}" did not match any elements`);
        }
        DOM.clearNodes(el);
        return el;
    }
    createElement(parent, name) {
        var nsAndName = splitNamespace(name);
        var el = isPresent(nsAndName[0]) ?
            DOM.createElementNS(NAMESPACE_URIS[nsAndName[0]], nsAndName[1]) :
            DOM.createElement(nsAndName[1]);
        if (isPresent(this._contentAttr)) {
            DOM.setAttribute(el, this._contentAttr, '');
        }
        if (isPresent(parent)) {
            DOM.appendChild(parent, el);
        }
        return el;
    }
    createViewRoot(hostElement) {
        var nodesParent;
        if (this.componentProto.encapsulation === ViewEncapsulation.Native) {
            nodesParent = DOM.createShadowRoot(hostElement);
            this._rootRenderer.sharedStylesHost.addHost(nodesParent);
            for (var i = 0; i < this._styles.length; i++) {
                DOM.appendChild(nodesParent, DOM.createStyleElement(this._styles[i]));
            }
        }
        else {
            if (isPresent(this._hostAttr)) {
                DOM.setAttribute(hostElement, this._hostAttr, '');
            }
            nodesParent = hostElement;
        }
        return nodesParent;
    }
    createTemplateAnchor(parentElement) {
        var comment = DOM.createComment(TEMPLATE_COMMENT_TEXT);
        if (isPresent(parentElement)) {
            DOM.appendChild(parentElement, comment);
        }
        return comment;
    }
    createText(parentElement, value) {
        var node = DOM.createTextNode(value);
        if (isPresent(parentElement)) {
            DOM.appendChild(parentElement, node);
        }
        return node;
    }
    projectNodes(parentElement, nodes) {
        if (isBlank(parentElement))
            return;
        appendNodes(parentElement, nodes);
    }
    attachViewAfter(node, viewRootNodes) {
        moveNodesAfterSibling(node, viewRootNodes);
        for (let i = 0; i < viewRootNodes.length; i++)
            this.animateNodeEnter(viewRootNodes[i]);
    }
    detachView(viewRootNodes) {
        for (var i = 0; i < viewRootNodes.length; i++) {
            var node = viewRootNodes[i];
            DOM.remove(node);
            this.animateNodeLeave(node);
        }
    }
    destroyView(hostElement, viewAllNodes) {
        if (this.componentProto.encapsulation === ViewEncapsulation.Native && isPresent(hostElement)) {
            this._rootRenderer.sharedStylesHost.removeHost(DOM.getShadowRoot(hostElement));
        }
    }
    listen(renderElement, name, callback) {
        this._rootRenderer.eventManager.addEventListener(renderElement, name, decoratePreventDefault(callback));
    }
    listenGlobal(target, name, callback) {
        return this._rootRenderer.eventManager.addGlobalEventListener(target, name, decoratePreventDefault(callback));
    }
    setElementProperty(renderElement, propertyName, propertyValue) {
        DOM.setProperty(renderElement, propertyName, propertyValue);
    }
    setElementAttribute(renderElement, attributeName, attributeValue) {
        var attrNs;
        var nsAndName = splitNamespace(attributeName);
        if (isPresent(nsAndName[0])) {
            attributeName = nsAndName[0] + ':' + nsAndName[1];
            attrNs = NAMESPACE_URIS[nsAndName[0]];
        }
        if (isPresent(attributeValue)) {
            if (isPresent(attrNs)) {
                DOM.setAttributeNS(renderElement, attrNs, attributeName, attributeValue);
            }
            else {
                DOM.setAttribute(renderElement, nsAndName[1], attributeValue);
            }
        }
        else {
            DOM.removeAttribute(renderElement, attributeName);
        }
    }
    setBindingDebugInfo(renderElement, propertyName, propertyValue) {
        var dashCasedPropertyName = camelCaseToDashCase(propertyName);
        if (DOM.isCommentNode(renderElement)) {
            var existingBindings = RegExpWrapper.firstMatch(TEMPLATE_BINDINGS_EXP, StringWrapper.replaceAll(DOM.getText(renderElement), /\n/g, ''));
            var parsedBindings = Json.parse(existingBindings[1]);
            parsedBindings[dashCasedPropertyName] = propertyValue;
            DOM.setText(renderElement, StringWrapper.replace(TEMPLATE_COMMENT_TEXT, '{}', Json.stringify(parsedBindings)));
        }
        else {
            this.setElementAttribute(renderElement, propertyName, propertyValue);
        }
    }
    setElementClass(renderElement, className, isAdd) {
        if (isAdd) {
            DOM.addClass(renderElement, className);
        }
        else {
            DOM.removeClass(renderElement, className);
        }
    }
    setElementStyle(renderElement, styleName, styleValue) {
        if (isPresent(styleValue)) {
            DOM.setStyle(renderElement, styleName, stringify(styleValue));
        }
        else {
            DOM.removeStyle(renderElement, styleName);
        }
    }
    invokeElementMethod(renderElement, methodName, args) {
        DOM.invoke(renderElement, methodName, args);
    }
    setText(renderNode, text) { DOM.setText(renderNode, text); }
    /**
     * Performs animations if necessary
     * @param node
     */
    animateNodeEnter(node) {
        if (DOM.isElementNode(node) && DOM.hasClass(node, 'ng-animate')) {
            DOM.addClass(node, 'ng-enter');
            this._rootRenderer.animate.css()
                .addAnimationClass('ng-enter-active')
                .start(node)
                .onComplete(() => { DOM.removeClass(node, 'ng-enter'); });
        }
    }
    /**
     * If animations are necessary, performs animations then removes the element; otherwise, it just
     * removes the element.
     * @param node
     */
    animateNodeLeave(node) {
        if (DOM.isElementNode(node) && DOM.hasClass(node, 'ng-animate')) {
            DOM.addClass(node, 'ng-leave');
            this._rootRenderer.animate.css()
                .addAnimationClass('ng-leave-active')
                .start(node)
                .onComplete(() => {
                DOM.removeClass(node, 'ng-leave');
                DOM.remove(node);
            });
        }
        else {
            DOM.remove(node);
        }
    }
}
function moveNodesAfterSibling(sibling, nodes) {
    var parent = DOM.parentElement(sibling);
    if (nodes.length > 0 && isPresent(parent)) {
        var nextSibling = DOM.nextSibling(sibling);
        if (isPresent(nextSibling)) {
            for (var i = 0; i < nodes.length; i++) {
                DOM.insertBefore(nextSibling, nodes[i]);
            }
        }
        else {
            for (var i = 0; i < nodes.length; i++) {
                DOM.appendChild(parent, nodes[i]);
            }
        }
    }
}
function appendNodes(parent, nodes) {
    for (var i = 0; i < nodes.length; i++) {
        DOM.appendChild(parent, nodes[i]);
    }
}
function decoratePreventDefault(eventHandler) {
    return (event) => {
        var allowDefaultBehavior = eventHandler(event);
        if (allowDefaultBehavior === false) {
            // TODO(tbosch): move preventDefault into event plugins...
            DOM.preventDefault(event);
        }
    };
}
var COMPONENT_REGEX = /%COMP%/g;
export const COMPONENT_VARIABLE = '%COMP%';
export const HOST_ATTR = `_nghost-${COMPONENT_VARIABLE}`;
export const CONTENT_ATTR = `_ngcontent-${COMPONENT_VARIABLE}`;
function _shimContentAttribute(componentShortId) {
    return StringWrapper.replaceAll(CONTENT_ATTR, COMPONENT_REGEX, componentShortId);
}
function _shimHostAttribute(componentShortId) {
    return StringWrapper.replaceAll(HOST_ATTR, COMPONENT_REGEX, componentShortId);
}
function _flattenStyles(compId, styles, target) {
    for (var i = 0; i < styles.length; i++) {
        var style = styles[i];
        if (isArray(style)) {
            _flattenStyles(compId, style, target);
        }
        else {
            style = StringWrapper.replaceAll(style, COMPONENT_REGEX, compId);
            target.push(style);
        }
    }
    return target;
}
var NS_PREFIX_RE = /^@([^:]+):(.+)/g;
function splitNamespace(name) {
    if (name[0] != '@') {
        return [null, name];
    }
    let match = RegExpWrapper.firstMatch(NS_PREFIX_RE, name);
    return [match[1], match[2]];
}
//# sourceMappingURL=data:application/json;base64,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