'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var lang_1 = require('angular2/src/facade/lang');
var exceptions_1 = require('angular2/src/facade/exceptions');
var collection_1 = require('angular2/src/facade/collection');
var async_1 = require('angular2/src/facade/async');
var directive_metadata_1 = require('./directive_metadata');
var template_ast_1 = require('./template_ast');
var di_1 = require('angular2/src/core/di');
var source_module_1 = require('./source_module');
var change_detector_compiler_1 = require('./change_detector_compiler');
var style_compiler_1 = require('./style_compiler');
var view_compiler_1 = require('./view_compiler');
var proto_view_compiler_1 = require('./proto_view_compiler');
var template_parser_1 = require('./template_parser');
var template_normalizer_1 = require('./template_normalizer');
var runtime_metadata_1 = require('./runtime_metadata');
var view_1 = require('angular2/src/core/linker/view');
var change_detection_1 = require('angular2/src/core/change_detection/change_detection');
var resolved_metadata_cache_1 = require('angular2/src/core/linker/resolved_metadata_cache');
var util_1 = require('./util');
exports.METADATA_CACHE_MODULE_REF = source_module_1.moduleRef('package:angular2/src/core/linker/resolved_metadata_cache' + util_1.MODULE_SUFFIX);
/**
 * An internal module of the Angular compiler that begins with component types,
 * extracts templates, and eventually produces a compiled version of the component
 * ready for linking into an application.
 */
var TemplateCompiler = (function () {
    function TemplateCompiler(_runtimeMetadataResolver, _templateNormalizer, _templateParser, _styleCompiler, _cdCompiler, _protoViewCompiler, _viewCompiler, _resolvedMetadataCache, _genConfig) {
        this._runtimeMetadataResolver = _runtimeMetadataResolver;
        this._templateNormalizer = _templateNormalizer;
        this._templateParser = _templateParser;
        this._styleCompiler = _styleCompiler;
        this._cdCompiler = _cdCompiler;
        this._protoViewCompiler = _protoViewCompiler;
        this._viewCompiler = _viewCompiler;
        this._resolvedMetadataCache = _resolvedMetadataCache;
        this._genConfig = _genConfig;
        this._hostCacheKeys = new Map();
        this._compiledTemplateCache = new Map();
        this._compiledTemplateDone = new Map();
    }
    TemplateCompiler.prototype.normalizeDirectiveMetadata = function (directive) {
        if (!directive.isComponent) {
            // For non components there is nothing to be normalized yet.
            return async_1.PromiseWrapper.resolve(directive);
        }
        return this._templateNormalizer.normalizeTemplate(directive.type, directive.template)
            .then(function (normalizedTemplate) { return new directive_metadata_1.CompileDirectiveMetadata({
            type: directive.type,
            isComponent: directive.isComponent,
            dynamicLoadable: directive.dynamicLoadable,
            selector: directive.selector,
            exportAs: directive.exportAs,
            changeDetection: directive.changeDetection,
            inputs: directive.inputs,
            outputs: directive.outputs,
            hostListeners: directive.hostListeners,
            hostProperties: directive.hostProperties,
            hostAttributes: directive.hostAttributes,
            lifecycleHooks: directive.lifecycleHooks,
            template: normalizedTemplate
        }); });
    };
    TemplateCompiler.prototype.compileHostComponentRuntime = function (type) {
        var compMeta = this._runtimeMetadataResolver.getDirectiveMetadata(type);
        var hostCacheKey = this._hostCacheKeys.get(type);
        if (lang_1.isBlank(hostCacheKey)) {
            hostCacheKey = new Object();
            this._hostCacheKeys.set(type, hostCacheKey);
            assertComponent(compMeta);
            var hostMeta = directive_metadata_1.createHostComponentMeta(compMeta.type, compMeta.selector);
            this._compileComponentRuntime(hostCacheKey, hostMeta, [compMeta], [], new Set());
        }
        return this._compiledTemplateDone.get(hostCacheKey)
            .then(function (compiledTemplate) {
            return new view_1.HostViewFactory(compMeta.selector, compiledTemplate.viewFactory);
        });
    };
    TemplateCompiler.prototype.clearCache = function () {
        this._styleCompiler.clearCache();
        this._compiledTemplateCache.clear();
        this._compiledTemplateDone.clear();
        this._hostCacheKeys.clear();
    };
    TemplateCompiler.prototype.compileTemplatesCodeGen = function (components) {
        var _this = this;
        if (components.length === 0) {
            throw new exceptions_1.BaseException('No components given');
        }
        var declarations = [];
        components.forEach(function (componentWithDirs) {
            var compMeta = componentWithDirs.component;
            assertComponent(compMeta);
            _this._compileComponentCodeGen(compMeta, componentWithDirs.directives, componentWithDirs.pipes, declarations);
            if (compMeta.dynamicLoadable) {
                var hostMeta = directive_metadata_1.createHostComponentMeta(compMeta.type, compMeta.selector);
                var viewFactoryExpression = _this._compileComponentCodeGen(hostMeta, [compMeta], [], declarations);
                var constructionKeyword = lang_1.IS_DART ? 'const' : 'new';
                var compiledTemplateExpr = constructionKeyword + " " + proto_view_compiler_1.APP_VIEW_MODULE_REF + "HostViewFactory('" + compMeta.selector + "'," + viewFactoryExpression + ")";
                var varName = codeGenHostViewFactoryName(compMeta.type);
                declarations.push("" + util_1.codeGenExportVariable(varName) + compiledTemplateExpr + ";");
            }
        });
        var moduleUrl = components[0].component.type.moduleUrl;
        return new source_module_1.SourceModule("" + templateModuleUrl(moduleUrl), declarations.join('\n'));
    };
    TemplateCompiler.prototype.compileStylesheetCodeGen = function (stylesheetUrl, cssText) {
        return this._styleCompiler.compileStylesheetCodeGen(stylesheetUrl, cssText);
    };
    TemplateCompiler.prototype._compileComponentRuntime = function (cacheKey, compMeta, viewDirectives, pipes, compilingComponentCacheKeys) {
        var _this = this;
        var uniqViewDirectives = removeDuplicates(viewDirectives);
        var uniqViewPipes = removeDuplicates(pipes);
        var compiledTemplate = this._compiledTemplateCache.get(cacheKey);
        var done = this._compiledTemplateDone.get(cacheKey);
        if (lang_1.isBlank(compiledTemplate)) {
            compiledTemplate = new CompiledTemplate();
            this._compiledTemplateCache.set(cacheKey, compiledTemplate);
            compilingComponentCacheKeys.add(cacheKey);
            done = async_1.PromiseWrapper
                .all([this._styleCompiler.compileComponentRuntime(compMeta.template)].concat(uniqViewDirectives.map(function (dirMeta) { return _this.normalizeDirectiveMetadata(dirMeta); })))
                .then(function (stylesAndNormalizedViewDirMetas) {
                var normalizedViewDirMetas = stylesAndNormalizedViewDirMetas.slice(1);
                var styles = stylesAndNormalizedViewDirMetas[0];
                var parsedTemplate = _this._templateParser.parse(compMeta.template.template, normalizedViewDirMetas, uniqViewPipes, compMeta.type.name);
                var childPromises = [];
                var usedDirectives = DirectiveCollector.findUsedDirectives(parsedTemplate);
                usedDirectives.components.forEach(function (component) { return _this._compileNestedComponentRuntime(component, compilingComponentCacheKeys, childPromises); });
                return async_1.PromiseWrapper.all(childPromises)
                    .then(function (_) {
                    var filteredPipes = filterPipes(parsedTemplate, uniqViewPipes);
                    compiledTemplate.init(_this._createViewFactoryRuntime(compMeta, parsedTemplate, usedDirectives.directives, styles, filteredPipes));
                    collection_1.SetWrapper.delete(compilingComponentCacheKeys, cacheKey);
                    return compiledTemplate;
                });
            });
            this._compiledTemplateDone.set(cacheKey, done);
        }
        return compiledTemplate;
    };
    TemplateCompiler.prototype._compileNestedComponentRuntime = function (childComponentDir, compilingComponentCacheKeys, childPromises) {
        var childCacheKey = childComponentDir.type.runtime;
        var childViewDirectives = this._runtimeMetadataResolver.getViewDirectivesMetadata(childComponentDir.type.runtime);
        var childViewPipes = this._runtimeMetadataResolver.getViewPipesMetadata(childComponentDir.type.runtime);
        var childIsRecursive = collection_1.SetWrapper.has(compilingComponentCacheKeys, childCacheKey);
        this._compileComponentRuntime(childCacheKey, childComponentDir, childViewDirectives, childViewPipes, compilingComponentCacheKeys);
        if (!childIsRecursive) {
            // Only wait for a child if it is not a cycle
            childPromises.push(this._compiledTemplateDone.get(childCacheKey));
        }
    };
    TemplateCompiler.prototype._createViewFactoryRuntime = function (compMeta, parsedTemplate, directives, styles, pipes) {
        var _this = this;
        if (lang_1.IS_DART || !this._genConfig.useJit) {
            var changeDetectorFactories = this._cdCompiler.compileComponentRuntime(compMeta.type, compMeta.changeDetection, parsedTemplate);
            var protoViews = this._protoViewCompiler.compileProtoViewRuntime(this._resolvedMetadataCache, compMeta, parsedTemplate, pipes);
            return this._viewCompiler.compileComponentRuntime(compMeta, parsedTemplate, styles, protoViews.protoViews, changeDetectorFactories, function (compMeta) { return _this._getNestedComponentViewFactory(compMeta); });
        }
        else {
            var declarations = [];
            var viewFactoryExpr = this._createViewFactoryCodeGen('resolvedMetadataCache', compMeta, new source_module_1.SourceExpression([], 'styles'), parsedTemplate, pipes, declarations);
            var vars = { 'exports': {}, 'styles': styles, 'resolvedMetadataCache': this._resolvedMetadataCache };
            directives.forEach(function (dirMeta) {
                vars[dirMeta.type.name] = dirMeta.type.runtime;
                if (dirMeta.isComponent && dirMeta.type.runtime !== compMeta.type.runtime) {
                    vars[("viewFactory_" + dirMeta.type.name + "0")] = _this._getNestedComponentViewFactory(dirMeta);
                }
            });
            pipes.forEach(function (pipeMeta) { return vars[pipeMeta.type.name] = pipeMeta.type.runtime; });
            var declarationsWithoutImports = source_module_1.SourceModule.getSourceWithoutImports(declarations.join('\n'));
            return lang_1.evalExpression("viewFactory_" + compMeta.type.name, viewFactoryExpr, declarationsWithoutImports, mergeStringMaps([vars, change_detector_compiler_1.CHANGE_DETECTION_JIT_IMPORTS, proto_view_compiler_1.PROTO_VIEW_JIT_IMPORTS, view_compiler_1.VIEW_JIT_IMPORTS]));
        }
    };
    TemplateCompiler.prototype._getNestedComponentViewFactory = function (compMeta) {
        return this._compiledTemplateCache.get(compMeta.type.runtime).viewFactory;
    };
    TemplateCompiler.prototype._compileComponentCodeGen = function (compMeta, directives, pipes, targetDeclarations) {
        var uniqueDirectives = removeDuplicates(directives);
        var uniqPipes = removeDuplicates(pipes);
        var styleExpr = this._styleCompiler.compileComponentCodeGen(compMeta.template);
        var parsedTemplate = this._templateParser.parse(compMeta.template.template, uniqueDirectives, uniqPipes, compMeta.type.name);
        var filteredPipes = filterPipes(parsedTemplate, uniqPipes);
        return this._createViewFactoryCodeGen(exports.METADATA_CACHE_MODULE_REF + "CODEGEN_RESOLVED_METADATA_CACHE", compMeta, styleExpr, parsedTemplate, filteredPipes, targetDeclarations);
    };
    TemplateCompiler.prototype._createViewFactoryCodeGen = function (resolvedMetadataCacheExpr, compMeta, styleExpr, parsedTemplate, pipes, targetDeclarations) {
        var changeDetectorsExprs = this._cdCompiler.compileComponentCodeGen(compMeta.type, compMeta.changeDetection, parsedTemplate);
        var protoViewExprs = this._protoViewCompiler.compileProtoViewCodeGen(new util_1.Expression(resolvedMetadataCacheExpr), compMeta, parsedTemplate, pipes);
        var viewFactoryExpr = this._viewCompiler.compileComponentCodeGen(compMeta, parsedTemplate, styleExpr, protoViewExprs.protoViews, changeDetectorsExprs, codeGenComponentViewFactoryName);
        util_1.addAll(changeDetectorsExprs.declarations, targetDeclarations);
        util_1.addAll(protoViewExprs.declarations, targetDeclarations);
        util_1.addAll(viewFactoryExpr.declarations, targetDeclarations);
        return viewFactoryExpr.expression;
    };
    TemplateCompiler = __decorate([
        di_1.Injectable(), 
        __metadata('design:paramtypes', [runtime_metadata_1.RuntimeMetadataResolver, template_normalizer_1.TemplateNormalizer, template_parser_1.TemplateParser, style_compiler_1.StyleCompiler, change_detector_compiler_1.ChangeDetectionCompiler, proto_view_compiler_1.ProtoViewCompiler, view_compiler_1.ViewCompiler, resolved_metadata_cache_1.ResolvedMetadataCache, change_detection_1.ChangeDetectorGenConfig])
    ], TemplateCompiler);
    return TemplateCompiler;
})();
exports.TemplateCompiler = TemplateCompiler;
var NormalizedComponentWithViewDirectives = (function () {
    function NormalizedComponentWithViewDirectives(component, directives, pipes) {
        this.component = component;
        this.directives = directives;
        this.pipes = pipes;
    }
    return NormalizedComponentWithViewDirectives;
})();
exports.NormalizedComponentWithViewDirectives = NormalizedComponentWithViewDirectives;
var CompiledTemplate = (function () {
    function CompiledTemplate() {
        this.viewFactory = null;
    }
    CompiledTemplate.prototype.init = function (viewFactory) { this.viewFactory = viewFactory; };
    return CompiledTemplate;
})();
function assertComponent(meta) {
    if (!meta.isComponent) {
        throw new exceptions_1.BaseException("Could not compile '" + meta.type.name + "' because it is not a component.");
    }
}
function templateModuleUrl(moduleUrl) {
    var urlWithoutSuffix = moduleUrl.substring(0, moduleUrl.length - util_1.MODULE_SUFFIX.length);
    return urlWithoutSuffix + ".template" + util_1.MODULE_SUFFIX;
}
function codeGenHostViewFactoryName(type) {
    return "hostViewFactory_" + type.name;
}
function codeGenComponentViewFactoryName(nestedCompType) {
    return source_module_1.moduleRef(templateModuleUrl(nestedCompType.type.moduleUrl)) + "viewFactory_" + nestedCompType.type.name + "0";
}
function mergeStringMaps(maps) {
    var result = {};
    maps.forEach(function (map) { collection_1.StringMapWrapper.forEach(map, function (value, key) { result[key] = value; }); });
    return result;
}
function removeDuplicates(items) {
    var res = [];
    items.forEach(function (item) {
        var hasMatch = res.filter(function (r) { return r.type.name == item.type.name && r.type.moduleUrl == item.type.moduleUrl &&
            r.type.runtime == item.type.runtime; })
            .length > 0;
        if (!hasMatch) {
            res.push(item);
        }
    });
    return res;
}
var DirectiveCollector = (function () {
    function DirectiveCollector() {
        this.directives = [];
        this.components = [];
    }
    DirectiveCollector.findUsedDirectives = function (parsedTemplate) {
        var collector = new DirectiveCollector();
        template_ast_1.templateVisitAll(collector, parsedTemplate);
        return collector;
    };
    DirectiveCollector.prototype.visitBoundText = function (ast, context) { return null; };
    DirectiveCollector.prototype.visitText = function (ast, context) { return null; };
    DirectiveCollector.prototype.visitNgContent = function (ast, context) { return null; };
    DirectiveCollector.prototype.visitElement = function (ast, context) {
        template_ast_1.templateVisitAll(this, ast.directives);
        template_ast_1.templateVisitAll(this, ast.children);
        return null;
    };
    DirectiveCollector.prototype.visitEmbeddedTemplate = function (ast, context) {
        template_ast_1.templateVisitAll(this, ast.directives);
        template_ast_1.templateVisitAll(this, ast.children);
        return null;
    };
    DirectiveCollector.prototype.visitVariable = function (ast, ctx) { return null; };
    DirectiveCollector.prototype.visitAttr = function (ast, attrNameAndValues) { return null; };
    DirectiveCollector.prototype.visitDirective = function (ast, ctx) {
        if (ast.directive.isComponent) {
            this.components.push(ast.directive);
        }
        this.directives.push(ast.directive);
        return null;
    };
    DirectiveCollector.prototype.visitEvent = function (ast, eventTargetAndNames) {
        return null;
    };
    DirectiveCollector.prototype.visitDirectiveProperty = function (ast, context) { return null; };
    DirectiveCollector.prototype.visitElementProperty = function (ast, context) { return null; };
    return DirectiveCollector;
})();
function filterPipes(template, allPipes) {
    var visitor = new PipeVisitor();
    template_ast_1.templateVisitAll(visitor, template);
    return allPipes.filter(function (pipeMeta) { return collection_1.SetWrapper.has(visitor.collector.pipes, pipeMeta.name); });
}
var PipeVisitor = (function () {
    function PipeVisitor() {
        this.collector = new template_parser_1.PipeCollector();
    }
    PipeVisitor.prototype.visitBoundText = function (ast, context) {
        ast.value.visit(this.collector);
        return null;
    };
    PipeVisitor.prototype.visitText = function (ast, context) { return null; };
    PipeVisitor.prototype.visitNgContent = function (ast, context) { return null; };
    PipeVisitor.prototype.visitElement = function (ast, context) {
        template_ast_1.templateVisitAll(this, ast.inputs);
        template_ast_1.templateVisitAll(this, ast.outputs);
        template_ast_1.templateVisitAll(this, ast.directives);
        template_ast_1.templateVisitAll(this, ast.children);
        return null;
    };
    PipeVisitor.prototype.visitEmbeddedTemplate = function (ast, context) {
        template_ast_1.templateVisitAll(this, ast.outputs);
        template_ast_1.templateVisitAll(this, ast.directives);
        template_ast_1.templateVisitAll(this, ast.children);
        return null;
    };
    PipeVisitor.prototype.visitVariable = function (ast, ctx) { return null; };
    PipeVisitor.prototype.visitAttr = function (ast, attrNameAndValues) { return null; };
    PipeVisitor.prototype.visitDirective = function (ast, ctx) {
        template_ast_1.templateVisitAll(this, ast.inputs);
        template_ast_1.templateVisitAll(this, ast.hostEvents);
        template_ast_1.templateVisitAll(this, ast.hostProperties);
        return null;
    };
    PipeVisitor.prototype.visitEvent = function (ast, eventTargetAndNames) {
        ast.handler.visit(this.collector);
        return null;
    };
    PipeVisitor.prototype.visitDirectiveProperty = function (ast, context) {
        ast.value.visit(this.collector);
        return null;
    };
    PipeVisitor.prototype.visitElementProperty = function (ast, context) {
        ast.value.visit(this.collector);
        return null;
    };
    return PipeVisitor;
})();
//# sourceMappingURL=data:application/json;base64,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