'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var lang_1 = require('angular2/src/facade/lang');
var collection_1 = require('angular2/src/facade/collection');
var template_ast_1 = require('./template_ast');
var source_module_1 = require('./source_module');
var view_1 = require('angular2/src/core/linker/view');
var view_type_1 = require('angular2/src/core/linker/view_type');
var element_1 = require('angular2/src/core/linker/element');
var view_2 = require('angular2/src/core/metadata/view');
var util_1 = require('./util');
var di_1 = require('angular2/src/core/di');
var proto_view_compiler_1 = require('./proto_view_compiler');
exports.VIEW_JIT_IMPORTS = lang_1.CONST_EXPR({
    'AppView': view_1.AppView,
    'AppElement': element_1.AppElement,
    'flattenNestedViewRenderNodes': view_1.flattenNestedViewRenderNodes,
    'checkSlotCount': view_1.checkSlotCount
});
var ViewCompiler = (function () {
    function ViewCompiler() {
    }
    ViewCompiler.prototype.compileComponentRuntime = function (component, template, styles, protoViews, changeDetectorFactories, componentViewFactory) {
        var viewFactory = new RuntimeViewFactory(component, styles, protoViews, changeDetectorFactories, componentViewFactory);
        return viewFactory.createViewFactory(template, 0, []);
    };
    ViewCompiler.prototype.compileComponentCodeGen = function (component, template, styles, protoViews, changeDetectorFactoryExpressions, componentViewFactory) {
        var viewFactory = new CodeGenViewFactory(component, styles, protoViews, changeDetectorFactoryExpressions, componentViewFactory);
        var targetStatements = [];
        var viewFactoryExpression = viewFactory.createViewFactory(template, 0, targetStatements);
        return new source_module_1.SourceExpression(targetStatements.map(function (stmt) { return stmt.statement; }), viewFactoryExpression.expression);
    };
    ViewCompiler = __decorate([
        di_1.Injectable(), 
        __metadata('design:paramtypes', [])
    ], ViewCompiler);
    return ViewCompiler;
})();
exports.ViewCompiler = ViewCompiler;
var CodeGenViewFactory = (function () {
    function CodeGenViewFactory(component, styles, protoViews, changeDetectorExpressions, componentViewFactory) {
        this.component = component;
        this.styles = styles;
        this.protoViews = protoViews;
        this.changeDetectorExpressions = changeDetectorExpressions;
        this.componentViewFactory = componentViewFactory;
        this._nextVarId = 0;
    }
    CodeGenViewFactory.prototype._nextVar = function (prefix) {
        return "" + prefix + this._nextVarId++ + "_" + this.component.type.name;
    };
    CodeGenViewFactory.prototype._nextRenderVar = function () { return this._nextVar('render'); };
    CodeGenViewFactory.prototype._nextAppVar = function () { return this._nextVar('app'); };
    CodeGenViewFactory.prototype._nextDisposableVar = function () {
        return "disposable" + this._nextVarId++ + "_" + this.component.type.name;
    };
    CodeGenViewFactory.prototype.createText = function (renderer, parent, text, targetStatements) {
        var varName = this._nextRenderVar();
        var statement = "var " + varName + " = " + renderer.expression + ".createText(" + (lang_1.isPresent(parent) ? parent.expression : null) + ", " + util_1.escapeSingleQuoteString(text) + ");";
        targetStatements.push(new util_1.Statement(statement));
        return new util_1.Expression(varName);
    };
    CodeGenViewFactory.prototype.createElement = function (renderer, parentRenderNode, name, rootSelector, targetStatements) {
        var varName = this._nextRenderVar();
        var valueExpr;
        if (lang_1.isPresent(rootSelector)) {
            valueExpr = rootSelector.expression + " == null ?\n        " + renderer.expression + ".createElement(" + (lang_1.isPresent(parentRenderNode) ? parentRenderNode.expression : null) + ", " + util_1.escapeSingleQuoteString(name) + ") :\n        " + renderer.expression + ".selectRootElement(" + rootSelector.expression + ");";
        }
        else {
            valueExpr =
                renderer.expression + ".createElement(" + (lang_1.isPresent(parentRenderNode) ? parentRenderNode.expression : null) + ", " + util_1.escapeSingleQuoteString(name) + ")";
        }
        var statement = "var " + varName + " = " + valueExpr + ";";
        targetStatements.push(new util_1.Statement(statement));
        return new util_1.Expression(varName);
    };
    CodeGenViewFactory.prototype.createTemplateAnchor = function (renderer, parentRenderNode, targetStatements) {
        var varName = this._nextRenderVar();
        var valueExpr = renderer.expression + ".createTemplateAnchor(" + (lang_1.isPresent(parentRenderNode) ? parentRenderNode.expression : null) + ");";
        targetStatements.push(new util_1.Statement("var " + varName + " = " + valueExpr));
        return new util_1.Expression(varName);
    };
    CodeGenViewFactory.prototype.createGlobalEventListener = function (renderer, appView, boundElementIndex, eventAst, targetStatements) {
        var disposableVar = this._nextDisposableVar();
        var eventHandlerExpr = codeGenEventHandler(appView, boundElementIndex, eventAst.fullName);
        targetStatements.push(new util_1.Statement("var " + disposableVar + " = " + renderer.expression + ".listenGlobal(" + util_1.escapeValue(eventAst.target) + ", " + util_1.escapeValue(eventAst.name) + ", " + eventHandlerExpr + ");"));
        return new util_1.Expression(disposableVar);
    };
    CodeGenViewFactory.prototype.createElementEventListener = function (renderer, appView, boundElementIndex, renderNode, eventAst, targetStatements) {
        var eventHandlerExpr = codeGenEventHandler(appView, boundElementIndex, eventAst.fullName);
        targetStatements.push(new util_1.Statement(renderer.expression + ".listen(" + renderNode.expression + ", " + util_1.escapeValue(eventAst.name) + ", " + eventHandlerExpr + ");"));
    };
    CodeGenViewFactory.prototype.setElementAttribute = function (renderer, renderNode, attrName, attrValue, targetStatements) {
        targetStatements.push(new util_1.Statement(renderer.expression + ".setElementAttribute(" + renderNode.expression + ", " + util_1.escapeSingleQuoteString(attrName) + ", " + util_1.escapeSingleQuoteString(attrValue) + ");"));
    };
    CodeGenViewFactory.prototype.createAppElement = function (appProtoEl, appView, renderNode, parentAppEl, embeddedViewFactory, targetStatements) {
        var appVar = this._nextAppVar();
        var varValue = "new " + proto_view_compiler_1.APP_EL_MODULE_REF + "AppElement(" + appProtoEl.expression + ", " + appView.expression + ",\n      " + (lang_1.isPresent(parentAppEl) ? parentAppEl.expression : null) + ", " + renderNode.expression + ", " + (lang_1.isPresent(embeddedViewFactory) ? embeddedViewFactory.expression : null) + ")";
        targetStatements.push(new util_1.Statement("var " + appVar + " = " + varValue + ";"));
        return new util_1.Expression(appVar);
    };
    CodeGenViewFactory.prototype.createAndSetComponentView = function (renderer, viewManager, view, appEl, component, contentNodesByNgContentIndex, targetStatements) {
        var codeGenContentNodes;
        if (this.component.type.isHost) {
            codeGenContentNodes = view.expression + ".projectableNodes";
        }
        else {
            codeGenContentNodes =
                "[" + contentNodesByNgContentIndex.map(function (nodes) { return util_1.codeGenFlatArray(nodes); }).join(',') + "]";
        }
        targetStatements.push(new util_1.Statement(this.componentViewFactory(component) + "(" + renderer.expression + ", " + viewManager.expression + ", " + appEl.expression + ", " + codeGenContentNodes + ", null, null, null);"));
    };
    CodeGenViewFactory.prototype.getProjectedNodes = function (projectableNodes, ngContentIndex) {
        return new util_1.Expression(projectableNodes.expression + "[" + ngContentIndex + "]", true);
    };
    CodeGenViewFactory.prototype.appendProjectedNodes = function (renderer, parent, nodes, targetStatements) {
        targetStatements.push(new util_1.Statement(renderer.expression + ".projectNodes(" + parent.expression + ", " + proto_view_compiler_1.APP_VIEW_MODULE_REF + "flattenNestedViewRenderNodes(" + nodes.expression + "));"));
    };
    CodeGenViewFactory.prototype.createViewFactory = function (asts, embeddedTemplateIndex, targetStatements) {
        var compileProtoView = this.protoViews[embeddedTemplateIndex];
        var isHostView = this.component.type.isHost;
        var isComponentView = embeddedTemplateIndex === 0 && !isHostView;
        var visitor = new ViewBuilderVisitor(new util_1.Expression('renderer'), new util_1.Expression('viewManager'), new util_1.Expression('projectableNodes'), isHostView ? new util_1.Expression('rootSelector') : null, new util_1.Expression('view'), compileProtoView, targetStatements, this);
        template_ast_1.templateVisitAll(visitor, asts, new ParentElement(isComponentView ? new util_1.Expression('parentRenderNode') : null, null, null));
        var appProtoView = compileProtoView.protoView.expression;
        var viewFactoryName = codeGenViewFactoryName(this.component, embeddedTemplateIndex);
        var changeDetectorFactory = this.changeDetectorExpressions.expressions[embeddedTemplateIndex];
        var factoryArgs = [
            'parentRenderer',
            'viewManager',
            'containerEl',
            'projectableNodes',
            'rootSelector',
            'dynamicallyCreatedProviders',
            'rootInjector'
        ];
        var initRendererStmts = [];
        var rendererExpr = "parentRenderer";
        if (embeddedTemplateIndex === 0) {
            var renderCompTypeVar = this._nextVar('renderType');
            targetStatements.push(new util_1.Statement("var " + renderCompTypeVar + " = null;"));
            var stylesVar = this._nextVar('styles');
            targetStatements.push(new util_1.Statement(util_1.CONST_VAR + " " + stylesVar + " = " + this.styles.expression + ";"));
            var encapsulation = this.component.template.encapsulation;
            initRendererStmts.push("if (" + renderCompTypeVar + " == null) {\n        " + renderCompTypeVar + " = viewManager.createRenderComponentType(" + codeGenViewEncapsulation(encapsulation) + ", " + stylesVar + ");\n      }");
            rendererExpr = "parentRenderer.renderComponent(" + renderCompTypeVar + ")";
        }
        var statement = "\n" + util_1.codeGenFnHeader(factoryArgs, viewFactoryName) + "{\n  " + initRendererStmts.join('\n') + "\n  var renderer = " + rendererExpr + ";\n  var view = new " + proto_view_compiler_1.APP_VIEW_MODULE_REF + "AppView(\n    " + appProtoView + ", renderer, viewManager,\n    projectableNodes,\n    containerEl,\n    dynamicallyCreatedProviders, rootInjector,\n    " + changeDetectorFactory + "()\n  );\n  " + proto_view_compiler_1.APP_VIEW_MODULE_REF + "checkSlotCount(" + util_1.escapeValue(this.component.type.name) + ", " + this.component.template.ngContentSelectors.length + ", projectableNodes);\n  " + (isComponentView ? 'var parentRenderNode = renderer.createViewRoot(view.containerAppElement.nativeElement);' : '') + "\n  " + visitor.renderStmts.map(function (stmt) { return stmt.statement; }).join('\n') + "\n  " + visitor.appStmts.map(function (stmt) { return stmt.statement; }).join('\n') + "\n\n  view.init(" + util_1.codeGenFlatArray(visitor.rootNodesOrAppElements) + ", " + util_1.codeGenArray(visitor.renderNodes) + ", " + util_1.codeGenArray(visitor.appDisposables) + ",\n            " + util_1.codeGenArray(visitor.appElements) + ");\n  return view;\n}";
        targetStatements.push(new util_1.Statement(statement));
        return new util_1.Expression(viewFactoryName);
    };
    return CodeGenViewFactory;
})();
var RuntimeViewFactory = (function () {
    function RuntimeViewFactory(component, styles, protoViews, changeDetectorFactories, componentViewFactory) {
        this.component = component;
        this.styles = styles;
        this.protoViews = protoViews;
        this.changeDetectorFactories = changeDetectorFactories;
        this.componentViewFactory = componentViewFactory;
    }
    RuntimeViewFactory.prototype.createText = function (renderer, parent, text, targetStatements) {
        return renderer.createText(parent, text);
    };
    RuntimeViewFactory.prototype.createElement = function (renderer, parent, name, rootSelector, targetStatements) {
        var el;
        if (lang_1.isPresent(rootSelector)) {
            el = renderer.selectRootElement(rootSelector);
        }
        else {
            el = renderer.createElement(parent, name);
        }
        return el;
    };
    RuntimeViewFactory.prototype.createTemplateAnchor = function (renderer, parent, targetStatements) {
        return renderer.createTemplateAnchor(parent);
    };
    RuntimeViewFactory.prototype.createGlobalEventListener = function (renderer, appView, boundElementIndex, eventAst, targetStatements) {
        return renderer.listenGlobal(eventAst.target, eventAst.name, function (event) { return appView.triggerEventHandlers(eventAst.fullName, event, boundElementIndex); });
    };
    RuntimeViewFactory.prototype.createElementEventListener = function (renderer, appView, boundElementIndex, renderNode, eventAst, targetStatements) {
        renderer.listen(renderNode, eventAst.name, function (event) { return appView.triggerEventHandlers(eventAst.fullName, event, boundElementIndex); });
    };
    RuntimeViewFactory.prototype.setElementAttribute = function (renderer, renderNode, attrName, attrValue, targetStatements) {
        renderer.setElementAttribute(renderNode, attrName, attrValue);
    };
    RuntimeViewFactory.prototype.createAppElement = function (appProtoEl, appView, renderNode, parentAppEl, embeddedViewFactory, targetStatements) {
        return new element_1.AppElement(appProtoEl, appView, parentAppEl, renderNode, embeddedViewFactory);
    };
    RuntimeViewFactory.prototype.createAndSetComponentView = function (renderer, viewManager, appView, appEl, component, contentNodesByNgContentIndex, targetStatements) {
        var flattenedContentNodes;
        if (this.component.type.isHost) {
            flattenedContentNodes = appView.projectableNodes;
        }
        else {
            flattenedContentNodes = collection_1.ListWrapper.createFixedSize(contentNodesByNgContentIndex.length);
            for (var i = 0; i < contentNodesByNgContentIndex.length; i++) {
                flattenedContentNodes[i] = util_1.flattenArray(contentNodesByNgContentIndex[i], []);
            }
        }
        this.componentViewFactory(component)(renderer, viewManager, appEl, flattenedContentNodes);
    };
    RuntimeViewFactory.prototype.getProjectedNodes = function (projectableNodes, ngContentIndex) {
        return projectableNodes[ngContentIndex];
    };
    RuntimeViewFactory.prototype.appendProjectedNodes = function (renderer, parent, nodes, targetStatements) {
        renderer.projectNodes(parent, view_1.flattenNestedViewRenderNodes(nodes));
    };
    RuntimeViewFactory.prototype.createViewFactory = function (asts, embeddedTemplateIndex, targetStatements) {
        var _this = this;
        var compileProtoView = this.protoViews[embeddedTemplateIndex];
        var isComponentView = compileProtoView.protoView.type === view_type_1.ViewType.COMPONENT;
        var renderComponentType = null;
        return function (parentRenderer, viewManager, containerEl, projectableNodes, rootSelector, dynamicallyCreatedProviders, rootInjector) {
            if (rootSelector === void 0) { rootSelector = null; }
            if (dynamicallyCreatedProviders === void 0) { dynamicallyCreatedProviders = null; }
            if (rootInjector === void 0) { rootInjector = null; }
            view_1.checkSlotCount(_this.component.type.name, _this.component.template.ngContentSelectors.length, projectableNodes);
            var renderer;
            if (embeddedTemplateIndex === 0) {
                if (lang_1.isBlank(renderComponentType)) {
                    renderComponentType = viewManager.createRenderComponentType(_this.component.template.encapsulation, _this.styles);
                }
                renderer = parentRenderer.renderComponent(renderComponentType);
            }
            else {
                renderer = parentRenderer;
            }
            var changeDetector = _this.changeDetectorFactories[embeddedTemplateIndex]();
            var view = new view_1.AppView(compileProtoView.protoView, renderer, viewManager, projectableNodes, containerEl, dynamicallyCreatedProviders, rootInjector, changeDetector);
            var visitor = new ViewBuilderVisitor(renderer, viewManager, projectableNodes, rootSelector, view, compileProtoView, [], _this);
            var parentRenderNode = isComponentView ? renderer.createViewRoot(containerEl.nativeElement) : null;
            template_ast_1.templateVisitAll(visitor, asts, new ParentElement(parentRenderNode, null, null));
            view.init(util_1.flattenArray(visitor.rootNodesOrAppElements, []), visitor.renderNodes, visitor.appDisposables, visitor.appElements);
            return view;
        };
    };
    return RuntimeViewFactory;
})();
var ParentElement = (function () {
    function ParentElement(renderNode, appEl, component) {
        this.renderNode = renderNode;
        this.appEl = appEl;
        this.component = component;
        if (lang_1.isPresent(component)) {
            this.contentNodesByNgContentIndex =
                collection_1.ListWrapper.createFixedSize(component.template.ngContentSelectors.length);
            for (var i = 0; i < this.contentNodesByNgContentIndex.length; i++) {
                this.contentNodesByNgContentIndex[i] = [];
            }
        }
        else {
            this.contentNodesByNgContentIndex = null;
        }
    }
    ParentElement.prototype.addContentNode = function (ngContentIndex, nodeExpr) {
        this.contentNodesByNgContentIndex[ngContentIndex].push(nodeExpr);
    };
    return ParentElement;
})();
var ViewBuilderVisitor = (function () {
    function ViewBuilderVisitor(renderer, viewManager, projectableNodes, rootSelector, view, protoView, targetStatements, factory) {
        this.renderer = renderer;
        this.viewManager = viewManager;
        this.projectableNodes = projectableNodes;
        this.rootSelector = rootSelector;
        this.view = view;
        this.protoView = protoView;
        this.targetStatements = targetStatements;
        this.factory = factory;
        this.renderStmts = [];
        this.renderNodes = [];
        this.appStmts = [];
        this.appElements = [];
        this.appDisposables = [];
        this.rootNodesOrAppElements = [];
        this.elementCount = 0;
    }
    ViewBuilderVisitor.prototype._addRenderNode = function (renderNode, appEl, ngContentIndex, parent) {
        this.renderNodes.push(renderNode);
        if (lang_1.isPresent(parent.component)) {
            if (lang_1.isPresent(ngContentIndex)) {
                parent.addContentNode(ngContentIndex, lang_1.isPresent(appEl) ? appEl : renderNode);
            }
        }
        else if (lang_1.isBlank(parent.renderNode)) {
            this.rootNodesOrAppElements.push(lang_1.isPresent(appEl) ? appEl : renderNode);
        }
    };
    ViewBuilderVisitor.prototype._getParentRenderNode = function (ngContentIndex, parent) {
        return lang_1.isPresent(parent.component) &&
            parent.component.template.encapsulation !== view_2.ViewEncapsulation.Native ?
            null :
            parent.renderNode;
    };
    ViewBuilderVisitor.prototype.visitBoundText = function (ast, parent) {
        return this._visitText('', ast.ngContentIndex, parent);
    };
    ViewBuilderVisitor.prototype.visitText = function (ast, parent) {
        return this._visitText(ast.value, ast.ngContentIndex, parent);
    };
    ViewBuilderVisitor.prototype._visitText = function (value, ngContentIndex, parent) {
        var renderNode = this.factory.createText(this.renderer, this._getParentRenderNode(ngContentIndex, parent), value, this.renderStmts);
        this._addRenderNode(renderNode, null, ngContentIndex, parent);
        return null;
    };
    ViewBuilderVisitor.prototype.visitNgContent = function (ast, parent) {
        var nodesExpression = this.factory.getProjectedNodes(this.projectableNodes, ast.index);
        if (lang_1.isPresent(parent.component)) {
            if (lang_1.isPresent(ast.ngContentIndex)) {
                parent.addContentNode(ast.ngContentIndex, nodesExpression);
            }
        }
        else {
            if (lang_1.isPresent(parent.renderNode)) {
                this.factory.appendProjectedNodes(this.renderer, parent.renderNode, nodesExpression, this.renderStmts);
            }
            else {
                this.rootNodesOrAppElements.push(nodesExpression);
            }
        }
        return null;
    };
    ViewBuilderVisitor.prototype.visitElement = function (ast, parent) {
        var _this = this;
        var renderNode = this.factory.createElement(this.renderer, this._getParentRenderNode(ast.ngContentIndex, parent), ast.name, this.rootSelector, this.renderStmts);
        var component = ast.getComponent();
        var elementIndex = this.elementCount++;
        var protoEl = this.protoView.protoElements[elementIndex];
        protoEl.renderEvents.forEach(function (eventAst) {
            if (lang_1.isPresent(eventAst.target)) {
                var disposable = _this.factory.createGlobalEventListener(_this.renderer, _this.view, protoEl.boundElementIndex, eventAst, _this.renderStmts);
                _this.appDisposables.push(disposable);
            }
            else {
                _this.factory.createElementEventListener(_this.renderer, _this.view, protoEl.boundElementIndex, renderNode, eventAst, _this.renderStmts);
            }
        });
        for (var i = 0; i < protoEl.attrNameAndValues.length; i++) {
            var attrName = protoEl.attrNameAndValues[i][0];
            var attrValue = protoEl.attrNameAndValues[i][1];
            this.factory.setElementAttribute(this.renderer, renderNode, attrName, attrValue, this.renderStmts);
        }
        var appEl = null;
        if (lang_1.isPresent(protoEl.appProtoEl)) {
            appEl = this.factory.createAppElement(protoEl.appProtoEl, this.view, renderNode, parent.appEl, null, this.appStmts);
            this.appElements.push(appEl);
        }
        this._addRenderNode(renderNode, appEl, ast.ngContentIndex, parent);
        var newParent = new ParentElement(renderNode, lang_1.isPresent(appEl) ? appEl : parent.appEl, component);
        template_ast_1.templateVisitAll(this, ast.children, newParent);
        if (lang_1.isPresent(appEl) && lang_1.isPresent(component)) {
            this.factory.createAndSetComponentView(this.renderer, this.viewManager, this.view, appEl, component, newParent.contentNodesByNgContentIndex, this.appStmts);
        }
        return null;
    };
    ViewBuilderVisitor.prototype.visitEmbeddedTemplate = function (ast, parent) {
        var renderNode = this.factory.createTemplateAnchor(this.renderer, this._getParentRenderNode(ast.ngContentIndex, parent), this.renderStmts);
        var elementIndex = this.elementCount++;
        var protoEl = this.protoView.protoElements[elementIndex];
        var embeddedViewFactory = this.factory.createViewFactory(ast.children, protoEl.embeddedTemplateIndex, this.targetStatements);
        var appEl = this.factory.createAppElement(protoEl.appProtoEl, this.view, renderNode, parent.appEl, embeddedViewFactory, this.appStmts);
        this._addRenderNode(renderNode, appEl, ast.ngContentIndex, parent);
        this.appElements.push(appEl);
        return null;
    };
    ViewBuilderVisitor.prototype.visitVariable = function (ast, ctx) { return null; };
    ViewBuilderVisitor.prototype.visitAttr = function (ast, ctx) { return null; };
    ViewBuilderVisitor.prototype.visitDirective = function (ast, ctx) { return null; };
    ViewBuilderVisitor.prototype.visitEvent = function (ast, ctx) { return null; };
    ViewBuilderVisitor.prototype.visitDirectiveProperty = function (ast, context) { return null; };
    ViewBuilderVisitor.prototype.visitElementProperty = function (ast, context) { return null; };
    return ViewBuilderVisitor;
})();
function codeGenEventHandler(view, boundElementIndex, eventName) {
    return util_1.codeGenValueFn(['event'], view.expression + ".triggerEventHandlers(" + util_1.escapeValue(eventName) + ", event, " + boundElementIndex + ")");
}
function codeGenViewFactoryName(component, embeddedTemplateIndex) {
    return "viewFactory_" + component.type.name + embeddedTemplateIndex;
}
function codeGenViewEncapsulation(value) {
    if (lang_1.IS_DART) {
        return "" + proto_view_compiler_1.METADATA_MODULE_REF + value;
    }
    else {
        return "" + value;
    }
}
//# sourceMappingURL=data:application/json;base64,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