'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var lang_1 = require('angular2/src/facade/lang');
var collection_1 = require('angular2/src/facade/collection');
var template_ast_1 = require('./template_ast');
var source_module_1 = require('./source_module');
var view_1 = require('angular2/src/core/linker/view');
var view_type_1 = require('angular2/src/core/linker/view_type');
var element_1 = require('angular2/src/core/linker/element');
var view_2 = require('angular2/src/core/metadata/view');
var util_1 = require('./util');
var di_1 = require('angular2/src/core/di');
var proto_view_compiler_1 = require('./proto_view_compiler');
exports.VIEW_JIT_IMPORTS = lang_1.CONST_EXPR({
    'AppView': view_1.AppView,
    'AppElement': element_1.AppElement,
    'flattenNestedViewRenderNodes': view_1.flattenNestedViewRenderNodes,
    'checkSlotCount': view_1.checkSlotCount
});
var ViewCompiler = (function () {
    function ViewCompiler() {
    }
    ViewCompiler.prototype.compileComponentRuntime = function (component, template, styles, protoViews, changeDetectorFactories, componentViewFactory) {
        var viewFactory = new RuntimeViewFactory(component, styles, protoViews, changeDetectorFactories, componentViewFactory);
        return viewFactory.createViewFactory(template, 0, []);
    };
    ViewCompiler.prototype.compileComponentCodeGen = function (component, template, styles, protoViews, changeDetectorFactoryExpressions, componentViewFactory) {
        var viewFactory = new CodeGenViewFactory(component, styles, protoViews, changeDetectorFactoryExpressions, componentViewFactory);
        var targetStatements = [];
        var viewFactoryExpression = viewFactory.createViewFactory(template, 0, targetStatements);
        return new source_module_1.SourceExpression(targetStatements.map(function (stmt) { return stmt.statement; }), viewFactoryExpression.expression);
    };
    ViewCompiler = __decorate([
        di_1.Injectable(), 
        __metadata('design:paramtypes', [])
    ], ViewCompiler);
    return ViewCompiler;
})();
exports.ViewCompiler = ViewCompiler;
var CodeGenViewFactory = (function () {
    function CodeGenViewFactory(component, styles, protoViews, changeDetectorExpressions, componentViewFactory) {
        this.component = component;
        this.styles = styles;
        this.protoViews = protoViews;
        this.changeDetectorExpressions = changeDetectorExpressions;
        this.componentViewFactory = componentViewFactory;
        this._nextVarId = 0;
    }
    CodeGenViewFactory.prototype._nextVar = function (prefix) {
        return "" + prefix + this._nextVarId++ + "_" + this.component.type.name;
    };
    CodeGenViewFactory.prototype._nextRenderVar = function () { return this._nextVar('render'); };
    CodeGenViewFactory.prototype._nextAppVar = function () { return this._nextVar('app'); };
    CodeGenViewFactory.prototype._nextDisposableVar = function () {
        return "disposable" + this._nextVarId++ + "_" + this.component.type.name;
    };
    CodeGenViewFactory.prototype.createText = function (renderer, parent, text, targetStatements) {
        var varName = this._nextRenderVar();
        var statement = "var " + varName + " = " + renderer.expression + ".createText(" + (lang_1.isPresent(parent) ? parent.expression : null) + ", " + util_1.escapeSingleQuoteString(text) + ");";
        targetStatements.push(new util_1.Statement(statement));
        return new util_1.Expression(varName);
    };
    CodeGenViewFactory.prototype.createElement = function (renderer, parentRenderNode, name, rootSelector, targetStatements) {
        var varName = this._nextRenderVar();
        var valueExpr;
        if (lang_1.isPresent(rootSelector)) {
            valueExpr = rootSelector.expression + " == null ?\n        " + renderer.expression + ".createElement(" + (lang_1.isPresent(parentRenderNode) ? parentRenderNode.expression : null) + ", " + util_1.escapeSingleQuoteString(name) + ") :\n        " + renderer.expression + ".selectRootElement(" + rootSelector.expression + ");";
        }
        else {
            valueExpr =
                renderer.expression + ".createElement(" + (lang_1.isPresent(parentRenderNode) ? parentRenderNode.expression : null) + ", " + util_1.escapeSingleQuoteString(name) + ")";
        }
        var statement = "var " + varName + " = " + valueExpr + ";";
        targetStatements.push(new util_1.Statement(statement));
        return new util_1.Expression(varName);
    };
    CodeGenViewFactory.prototype.createTemplateAnchor = function (renderer, parentRenderNode, targetStatements) {
        var varName = this._nextRenderVar();
        var valueExpr = renderer.expression + ".createTemplateAnchor(" + (lang_1.isPresent(parentRenderNode) ? parentRenderNode.expression : null) + ");";
        targetStatements.push(new util_1.Statement("var " + varName + " = " + valueExpr));
        return new util_1.Expression(varName);
    };
    CodeGenViewFactory.prototype.createGlobalEventListener = function (renderer, appView, boundElementIndex, eventAst, targetStatements) {
        var disposableVar = this._nextDisposableVar();
        var eventHandlerExpr = codeGenEventHandler(appView, boundElementIndex, eventAst.fullName);
        targetStatements.push(new util_1.Statement("var " + disposableVar + " = " + renderer.expression + ".listenGlobal(" + util_1.escapeValue(eventAst.target) + ", " + util_1.escapeValue(eventAst.name) + ", " + eventHandlerExpr + ");"));
        return new util_1.Expression(disposableVar);
    };
    CodeGenViewFactory.prototype.createElementEventListener = function (renderer, appView, boundElementIndex, renderNode, eventAst, targetStatements) {
        var disposableVar = this._nextDisposableVar();
        var eventHandlerExpr = codeGenEventHandler(appView, boundElementIndex, eventAst.fullName);
        targetStatements.push(new util_1.Statement("var " + disposableVar + " = " + renderer.expression + ".listen(" + renderNode.expression + ", " + util_1.escapeValue(eventAst.name) + ", " + eventHandlerExpr + ");"));
        return new util_1.Expression(disposableVar);
    };
    CodeGenViewFactory.prototype.setElementAttribute = function (renderer, renderNode, attrName, attrValue, targetStatements) {
        targetStatements.push(new util_1.Statement(renderer.expression + ".setElementAttribute(" + renderNode.expression + ", " + util_1.escapeSingleQuoteString(attrName) + ", " + util_1.escapeSingleQuoteString(attrValue) + ");"));
    };
    CodeGenViewFactory.prototype.createAppElement = function (appProtoEl, appView, renderNode, parentAppEl, embeddedViewFactory, targetStatements) {
        var appVar = this._nextAppVar();
        var varValue = "new " + proto_view_compiler_1.APP_EL_MODULE_REF + "AppElement(" + appProtoEl.expression + ", " + appView.expression + ",\n      " + (lang_1.isPresent(parentAppEl) ? parentAppEl.expression : null) + ", " + renderNode.expression + ", " + (lang_1.isPresent(embeddedViewFactory) ? embeddedViewFactory.expression : null) + ")";
        targetStatements.push(new util_1.Statement("var " + appVar + " = " + varValue + ";"));
        return new util_1.Expression(appVar);
    };
    CodeGenViewFactory.prototype.createAndSetComponentView = function (renderer, viewManager, view, appEl, component, contentNodesByNgContentIndex, targetStatements) {
        var codeGenContentNodes;
        if (this.component.type.isHost) {
            codeGenContentNodes = view.expression + ".projectableNodes";
        }
        else {
            codeGenContentNodes =
                "[" + contentNodesByNgContentIndex.map(function (nodes) { return util_1.codeGenFlatArray(nodes); }).join(',') + "]";
        }
        targetStatements.push(new util_1.Statement(this.componentViewFactory(component) + "(" + renderer.expression + ", " + viewManager.expression + ", " + appEl.expression + ", " + codeGenContentNodes + ", null, null, null);"));
    };
    CodeGenViewFactory.prototype.getProjectedNodes = function (projectableNodes, ngContentIndex) {
        return new util_1.Expression(projectableNodes.expression + "[" + ngContentIndex + "]", true);
    };
    CodeGenViewFactory.prototype.appendProjectedNodes = function (renderer, parent, nodes, targetStatements) {
        targetStatements.push(new util_1.Statement(renderer.expression + ".projectNodes(" + parent.expression + ", " + proto_view_compiler_1.APP_VIEW_MODULE_REF + "flattenNestedViewRenderNodes(" + nodes.expression + "));"));
    };
    CodeGenViewFactory.prototype.createViewFactory = function (asts, embeddedTemplateIndex, targetStatements) {
        var compileProtoView = this.protoViews[embeddedTemplateIndex];
        var isHostView = this.component.type.isHost;
        var isComponentView = embeddedTemplateIndex === 0 && !isHostView;
        var visitor = new ViewBuilderVisitor(new util_1.Expression('renderer'), new util_1.Expression('viewManager'), new util_1.Expression('projectableNodes'), isHostView ? new util_1.Expression('rootSelector') : null, new util_1.Expression('view'), compileProtoView, targetStatements, this);
        template_ast_1.templateVisitAll(visitor, asts, new ParentElement(isComponentView ? new util_1.Expression('parentRenderNode') : null, null, null));
        var appProtoView = compileProtoView.protoView.expression;
        var viewFactoryName = codeGenViewFactoryName(this.component, embeddedTemplateIndex);
        var changeDetectorFactory = this.changeDetectorExpressions.expressions[embeddedTemplateIndex];
        var factoryArgs = [
            'parentRenderer',
            'viewManager',
            'containerEl',
            'projectableNodes',
            'rootSelector',
            'dynamicallyCreatedProviders',
            'rootInjector'
        ];
        var initRendererStmts = [];
        var rendererExpr = "parentRenderer";
        if (embeddedTemplateIndex === 0) {
            var renderCompTypeVar = this._nextVar('renderType');
            targetStatements.push(new util_1.Statement("var " + renderCompTypeVar + " = null;"));
            var stylesVar = this._nextVar('styles');
            targetStatements.push(new util_1.Statement(util_1.CONST_VAR + " " + stylesVar + " = " + this.styles.expression + ";"));
            var encapsulation = this.component.template.encapsulation;
            initRendererStmts.push("if (" + renderCompTypeVar + " == null) {\n        " + renderCompTypeVar + " = viewManager.createRenderComponentType(" + codeGenViewEncapsulation(encapsulation) + ", " + stylesVar + ");\n      }");
            rendererExpr = "parentRenderer.renderComponent(" + renderCompTypeVar + ")";
        }
        var statement = "\n" + util_1.codeGenFnHeader(factoryArgs, viewFactoryName) + "{\n  " + initRendererStmts.join('\n') + "\n  var renderer = " + rendererExpr + ";\n  var view = new " + proto_view_compiler_1.APP_VIEW_MODULE_REF + "AppView(\n    " + appProtoView + ", renderer, viewManager,\n    projectableNodes,\n    containerEl,\n    dynamicallyCreatedProviders, rootInjector,\n    " + changeDetectorFactory + "()\n  );\n  " + proto_view_compiler_1.APP_VIEW_MODULE_REF + "checkSlotCount(" + util_1.escapeValue(this.component.type.name) + ", " + this.component.template.ngContentSelectors.length + ", projectableNodes);\n  " + (isComponentView ? 'var parentRenderNode = renderer.createViewRoot(view.containerAppElement.nativeElement);' : '') + "\n  " + visitor.renderStmts.map(function (stmt) { return stmt.statement; }).join('\n') + "\n  " + visitor.appStmts.map(function (stmt) { return stmt.statement; }).join('\n') + "\n\n  view.init(" + util_1.codeGenFlatArray(visitor.rootNodesOrAppElements) + ", " + util_1.codeGenArray(visitor.renderNodes) + ", " + util_1.codeGenArray(visitor.appDisposables) + ",\n            " + util_1.codeGenArray(visitor.appElements) + ");\n  return view;\n}";
        targetStatements.push(new util_1.Statement(statement));
        return new util_1.Expression(viewFactoryName);
    };
    return CodeGenViewFactory;
})();
var RuntimeViewFactory = (function () {
    function RuntimeViewFactory(component, styles, protoViews, changeDetectorFactories, componentViewFactory) {
        this.component = component;
        this.styles = styles;
        this.protoViews = protoViews;
        this.changeDetectorFactories = changeDetectorFactories;
        this.componentViewFactory = componentViewFactory;
    }
    RuntimeViewFactory.prototype.createText = function (renderer, parent, text, targetStatements) {
        return renderer.createText(parent, text);
    };
    RuntimeViewFactory.prototype.createElement = function (renderer, parent, name, rootSelector, targetStatements) {
        var el;
        if (lang_1.isPresent(rootSelector)) {
            el = renderer.selectRootElement(rootSelector);
        }
        else {
            el = renderer.createElement(parent, name);
        }
        return el;
    };
    RuntimeViewFactory.prototype.createTemplateAnchor = function (renderer, parent, targetStatements) {
        return renderer.createTemplateAnchor(parent);
    };
    RuntimeViewFactory.prototype.createGlobalEventListener = function (renderer, appView, boundElementIndex, eventAst, targetStatements) {
        return renderer.listenGlobal(eventAst.target, eventAst.name, function (event) { return appView.triggerEventHandlers(eventAst.fullName, event, boundElementIndex); });
    };
    RuntimeViewFactory.prototype.createElementEventListener = function (renderer, appView, boundElementIndex, renderNode, eventAst, targetStatements) {
        return renderer.listen(renderNode, eventAst.name, function (event) { return appView.triggerEventHandlers(eventAst.fullName, event, boundElementIndex); });
    };
    RuntimeViewFactory.prototype.setElementAttribute = function (renderer, renderNode, attrName, attrValue, targetStatements) {
        renderer.setElementAttribute(renderNode, attrName, attrValue);
    };
    RuntimeViewFactory.prototype.createAppElement = function (appProtoEl, appView, renderNode, parentAppEl, embeddedViewFactory, targetStatements) {
        return new element_1.AppElement(appProtoEl, appView, parentAppEl, renderNode, embeddedViewFactory);
    };
    RuntimeViewFactory.prototype.createAndSetComponentView = function (renderer, viewManager, appView, appEl, component, contentNodesByNgContentIndex, targetStatements) {
        var flattenedContentNodes;
        if (this.component.type.isHost) {
            flattenedContentNodes = appView.projectableNodes;
        }
        else {
            flattenedContentNodes = collection_1.ListWrapper.createFixedSize(contentNodesByNgContentIndex.length);
            for (var i = 0; i < contentNodesByNgContentIndex.length; i++) {
                flattenedContentNodes[i] = util_1.flattenArray(contentNodesByNgContentIndex[i], []);
            }
        }
        this.componentViewFactory(component)(renderer, viewManager, appEl, flattenedContentNodes);
    };
    RuntimeViewFactory.prototype.getProjectedNodes = function (projectableNodes, ngContentIndex) {
        return projectableNodes[ngContentIndex];
    };
    RuntimeViewFactory.prototype.appendProjectedNodes = function (renderer, parent, nodes, targetStatements) {
        renderer.projectNodes(parent, view_1.flattenNestedViewRenderNodes(nodes));
    };
    RuntimeViewFactory.prototype.createViewFactory = function (asts, embeddedTemplateIndex, targetStatements) {
        var _this = this;
        var compileProtoView = this.protoViews[embeddedTemplateIndex];
        var isComponentView = compileProtoView.protoView.type === view_type_1.ViewType.COMPONENT;
        var renderComponentType = null;
        return function (parentRenderer, viewManager, containerEl, projectableNodes, rootSelector, dynamicallyCreatedProviders, rootInjector) {
            if (rootSelector === void 0) { rootSelector = null; }
            if (dynamicallyCreatedProviders === void 0) { dynamicallyCreatedProviders = null; }
            if (rootInjector === void 0) { rootInjector = null; }
            view_1.checkSlotCount(_this.component.type.name, _this.component.template.ngContentSelectors.length, projectableNodes);
            var renderer;
            if (embeddedTemplateIndex === 0) {
                if (lang_1.isBlank(renderComponentType)) {
                    renderComponentType = viewManager.createRenderComponentType(_this.component.template.encapsulation, _this.styles);
                }
                renderer = parentRenderer.renderComponent(renderComponentType);
            }
            else {
                renderer = parentRenderer;
            }
            var changeDetector = _this.changeDetectorFactories[embeddedTemplateIndex]();
            var view = new view_1.AppView(compileProtoView.protoView, renderer, viewManager, projectableNodes, containerEl, dynamicallyCreatedProviders, rootInjector, changeDetector);
            var visitor = new ViewBuilderVisitor(renderer, viewManager, projectableNodes, rootSelector, view, compileProtoView, [], _this);
            var parentRenderNode = isComponentView ? renderer.createViewRoot(containerEl.nativeElement) : null;
            template_ast_1.templateVisitAll(visitor, asts, new ParentElement(parentRenderNode, null, null));
            view.init(util_1.flattenArray(visitor.rootNodesOrAppElements, []), visitor.renderNodes, visitor.appDisposables, visitor.appElements);
            return view;
        };
    };
    return RuntimeViewFactory;
})();
var ParentElement = (function () {
    function ParentElement(renderNode, appEl, component) {
        this.renderNode = renderNode;
        this.appEl = appEl;
        this.component = component;
        if (lang_1.isPresent(component)) {
            this.contentNodesByNgContentIndex =
                collection_1.ListWrapper.createFixedSize(component.template.ngContentSelectors.length);
            for (var i = 0; i < this.contentNodesByNgContentIndex.length; i++) {
                this.contentNodesByNgContentIndex[i] = [];
            }
        }
        else {
            this.contentNodesByNgContentIndex = null;
        }
    }
    ParentElement.prototype.addContentNode = function (ngContentIndex, nodeExpr) {
        this.contentNodesByNgContentIndex[ngContentIndex].push(nodeExpr);
    };
    return ParentElement;
})();
var ViewBuilderVisitor = (function () {
    function ViewBuilderVisitor(renderer, viewManager, projectableNodes, rootSelector, view, protoView, targetStatements, factory) {
        this.renderer = renderer;
        this.viewManager = viewManager;
        this.projectableNodes = projectableNodes;
        this.rootSelector = rootSelector;
        this.view = view;
        this.protoView = protoView;
        this.targetStatements = targetStatements;
        this.factory = factory;
        this.renderStmts = [];
        this.renderNodes = [];
        this.appStmts = [];
        this.appElements = [];
        this.appDisposables = [];
        this.rootNodesOrAppElements = [];
        this.elementCount = 0;
    }
    ViewBuilderVisitor.prototype._addRenderNode = function (renderNode, appEl, ngContentIndex, parent) {
        this.renderNodes.push(renderNode);
        if (lang_1.isPresent(parent.component)) {
            if (lang_1.isPresent(ngContentIndex)) {
                parent.addContentNode(ngContentIndex, lang_1.isPresent(appEl) ? appEl : renderNode);
            }
        }
        else if (lang_1.isBlank(parent.renderNode)) {
            this.rootNodesOrAppElements.push(lang_1.isPresent(appEl) ? appEl : renderNode);
        }
    };
    ViewBuilderVisitor.prototype._getParentRenderNode = function (ngContentIndex, parent) {
        return lang_1.isPresent(parent.component) &&
            parent.component.template.encapsulation !== view_2.ViewEncapsulation.Native ?
            null :
            parent.renderNode;
    };
    ViewBuilderVisitor.prototype.visitBoundText = function (ast, parent) {
        return this._visitText('', ast.ngContentIndex, parent);
    };
    ViewBuilderVisitor.prototype.visitText = function (ast, parent) {
        return this._visitText(ast.value, ast.ngContentIndex, parent);
    };
    ViewBuilderVisitor.prototype._visitText = function (value, ngContentIndex, parent) {
        var renderNode = this.factory.createText(this.renderer, this._getParentRenderNode(ngContentIndex, parent), value, this.renderStmts);
        this._addRenderNode(renderNode, null, ngContentIndex, parent);
        return null;
    };
    ViewBuilderVisitor.prototype.visitNgContent = function (ast, parent) {
        var nodesExpression = this.factory.getProjectedNodes(this.projectableNodes, ast.index);
        if (lang_1.isPresent(parent.component)) {
            if (lang_1.isPresent(ast.ngContentIndex)) {
                parent.addContentNode(ast.ngContentIndex, nodesExpression);
            }
        }
        else {
            if (lang_1.isPresent(parent.renderNode)) {
                this.factory.appendProjectedNodes(this.renderer, parent.renderNode, nodesExpression, this.renderStmts);
            }
            else {
                this.rootNodesOrAppElements.push(nodesExpression);
            }
        }
        return null;
    };
    ViewBuilderVisitor.prototype.visitElement = function (ast, parent) {
        var _this = this;
        var renderNode = this.factory.createElement(this.renderer, this._getParentRenderNode(ast.ngContentIndex, parent), ast.name, this.rootSelector, this.renderStmts);
        var component = ast.getComponent();
        var elementIndex = this.elementCount++;
        var protoEl = this.protoView.protoElements[elementIndex];
        protoEl.renderEvents.forEach(function (eventAst) {
            var disposable;
            if (lang_1.isPresent(eventAst.target)) {
                disposable = _this.factory.createGlobalEventListener(_this.renderer, _this.view, protoEl.boundElementIndex, eventAst, _this.renderStmts);
            }
            else {
                disposable = _this.factory.createElementEventListener(_this.renderer, _this.view, protoEl.boundElementIndex, renderNode, eventAst, _this.renderStmts);
            }
            _this.appDisposables.push(disposable);
        });
        for (var i = 0; i < protoEl.attrNameAndValues.length; i++) {
            var attrName = protoEl.attrNameAndValues[i][0];
            var attrValue = protoEl.attrNameAndValues[i][1];
            this.factory.setElementAttribute(this.renderer, renderNode, attrName, attrValue, this.renderStmts);
        }
        var appEl = null;
        if (lang_1.isPresent(protoEl.appProtoEl)) {
            appEl = this.factory.createAppElement(protoEl.appProtoEl, this.view, renderNode, parent.appEl, null, this.appStmts);
            this.appElements.push(appEl);
        }
        this._addRenderNode(renderNode, appEl, ast.ngContentIndex, parent);
        var newParent = new ParentElement(renderNode, lang_1.isPresent(appEl) ? appEl : parent.appEl, component);
        template_ast_1.templateVisitAll(this, ast.children, newParent);
        if (lang_1.isPresent(appEl) && lang_1.isPresent(component)) {
            this.factory.createAndSetComponentView(this.renderer, this.viewManager, this.view, appEl, component, newParent.contentNodesByNgContentIndex, this.appStmts);
        }
        return null;
    };
    ViewBuilderVisitor.prototype.visitEmbeddedTemplate = function (ast, parent) {
        var renderNode = this.factory.createTemplateAnchor(this.renderer, this._getParentRenderNode(ast.ngContentIndex, parent), this.renderStmts);
        var elementIndex = this.elementCount++;
        var protoEl = this.protoView.protoElements[elementIndex];
        var embeddedViewFactory = this.factory.createViewFactory(ast.children, protoEl.embeddedTemplateIndex, this.targetStatements);
        var appEl = this.factory.createAppElement(protoEl.appProtoEl, this.view, renderNode, parent.appEl, embeddedViewFactory, this.appStmts);
        this._addRenderNode(renderNode, appEl, ast.ngContentIndex, parent);
        this.appElements.push(appEl);
        return null;
    };
    ViewBuilderVisitor.prototype.visitVariable = function (ast, ctx) { return null; };
    ViewBuilderVisitor.prototype.visitAttr = function (ast, ctx) { return null; };
    ViewBuilderVisitor.prototype.visitDirective = function (ast, ctx) { return null; };
    ViewBuilderVisitor.prototype.visitEvent = function (ast, ctx) { return null; };
    ViewBuilderVisitor.prototype.visitDirectiveProperty = function (ast, context) { return null; };
    ViewBuilderVisitor.prototype.visitElementProperty = function (ast, context) { return null; };
    return ViewBuilderVisitor;
})();
function codeGenEventHandler(view, boundElementIndex, eventName) {
    return util_1.codeGenValueFn(['event'], view.expression + ".triggerEventHandlers(" + util_1.escapeValue(eventName) + ", event, " + boundElementIndex + ")");
}
function codeGenViewFactoryName(component, embeddedTemplateIndex) {
    return "viewFactory_" + component.type.name + embeddedTemplateIndex;
}
function codeGenViewEncapsulation(value) {
    if (lang_1.IS_DART) {
        return "" + proto_view_compiler_1.METADATA_MODULE_REF + value;
    }
    else {
        return "" + value;
    }
}
//# sourceMappingURL=data:application/json;base64,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