'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var collection_1 = require('angular2/src/facade/collection');
var lang_1 = require('angular2/src/facade/lang');
var exceptions_1 = require('angular2/src/facade/exceptions');
var DefaultKeyValueDifferFactory = (function () {
    function DefaultKeyValueDifferFactory() {
    }
    DefaultKeyValueDifferFactory.prototype.supports = function (obj) { return obj instanceof Map || lang_1.isJsObject(obj); };
    DefaultKeyValueDifferFactory.prototype.create = function (cdRef) { return new DefaultKeyValueDiffer(); };
    DefaultKeyValueDifferFactory = __decorate([
        lang_1.CONST(), 
        __metadata('design:paramtypes', [])
    ], DefaultKeyValueDifferFactory);
    return DefaultKeyValueDifferFactory;
})();
exports.DefaultKeyValueDifferFactory = DefaultKeyValueDifferFactory;
var DefaultKeyValueDiffer = (function () {
    function DefaultKeyValueDiffer() {
        this._records = new Map();
        this._mapHead = null;
        this._previousMapHead = null;
        this._changesHead = null;
        this._changesTail = null;
        this._additionsHead = null;
        this._additionsTail = null;
        this._removalsHead = null;
        this._removalsTail = null;
    }
    Object.defineProperty(DefaultKeyValueDiffer.prototype, "isDirty", {
        get: function () {
            return this._additionsHead !== null || this._changesHead !== null ||
                this._removalsHead !== null;
        },
        enumerable: true,
        configurable: true
    });
    DefaultKeyValueDiffer.prototype.forEachItem = function (fn) {
        var record;
        for (record = this._mapHead; record !== null; record = record._next) {
            fn(record);
        }
    };
    DefaultKeyValueDiffer.prototype.forEachPreviousItem = function (fn) {
        var record;
        for (record = this._previousMapHead; record !== null; record = record._nextPrevious) {
            fn(record);
        }
    };
    DefaultKeyValueDiffer.prototype.forEachChangedItem = function (fn) {
        var record;
        for (record = this._changesHead; record !== null; record = record._nextChanged) {
            fn(record);
        }
    };
    DefaultKeyValueDiffer.prototype.forEachAddedItem = function (fn) {
        var record;
        for (record = this._additionsHead; record !== null; record = record._nextAdded) {
            fn(record);
        }
    };
    DefaultKeyValueDiffer.prototype.forEachRemovedItem = function (fn) {
        var record;
        for (record = this._removalsHead; record !== null; record = record._nextRemoved) {
            fn(record);
        }
    };
    DefaultKeyValueDiffer.prototype.diff = function (map) {
        if (lang_1.isBlank(map))
            map = collection_1.MapWrapper.createFromPairs([]);
        if (!(map instanceof Map || lang_1.isJsObject(map))) {
            throw new exceptions_1.BaseException("Error trying to diff '" + map + "'");
        }
        if (this.check(map)) {
            return this;
        }
        else {
            return null;
        }
    };
    DefaultKeyValueDiffer.prototype.onDestroy = function () { };
    DefaultKeyValueDiffer.prototype.check = function (map) {
        var _this = this;
        this._reset();
        var records = this._records;
        var oldSeqRecord = this._mapHead;
        var lastOldSeqRecord = null;
        var lastNewSeqRecord = null;
        var seqChanged = false;
        this._forEach(map, function (value, key) {
            var newSeqRecord;
            if (oldSeqRecord !== null && key === oldSeqRecord.key) {
                newSeqRecord = oldSeqRecord;
                if (!lang_1.looseIdentical(value, oldSeqRecord.currentValue)) {
                    oldSeqRecord.previousValue = oldSeqRecord.currentValue;
                    oldSeqRecord.currentValue = value;
                    _this._addToChanges(oldSeqRecord);
                }
            }
            else {
                seqChanged = true;
                if (oldSeqRecord !== null) {
                    oldSeqRecord._next = null;
                    _this._removeFromSeq(lastOldSeqRecord, oldSeqRecord);
                    _this._addToRemovals(oldSeqRecord);
                }
                if (records.has(key)) {
                    newSeqRecord = records.get(key);
                }
                else {
                    newSeqRecord = new KeyValueChangeRecord(key);
                    records.set(key, newSeqRecord);
                    newSeqRecord.currentValue = value;
                    _this._addToAdditions(newSeqRecord);
                }
            }
            if (seqChanged) {
                if (_this._isInRemovals(newSeqRecord)) {
                    _this._removeFromRemovals(newSeqRecord);
                }
                if (lastNewSeqRecord == null) {
                    _this._mapHead = newSeqRecord;
                }
                else {
                    lastNewSeqRecord._next = newSeqRecord;
                }
            }
            lastOldSeqRecord = oldSeqRecord;
            lastNewSeqRecord = newSeqRecord;
            oldSeqRecord = oldSeqRecord === null ? null : oldSeqRecord._next;
        });
        this._truncate(lastOldSeqRecord, oldSeqRecord);
        return this.isDirty;
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._reset = function () {
        if (this.isDirty) {
            var record;
            // Record the state of the mapping
            for (record = this._previousMapHead = this._mapHead; record !== null; record = record._next) {
                record._nextPrevious = record._next;
            }
            for (record = this._changesHead; record !== null; record = record._nextChanged) {
                record.previousValue = record.currentValue;
            }
            for (record = this._additionsHead; record != null; record = record._nextAdded) {
                record.previousValue = record.currentValue;
            }
            // todo(vicb) once assert is supported
            // assert(() {
            //  var r = _changesHead;
            //  while (r != null) {
            //    var nextRecord = r._nextChanged;
            //    r._nextChanged = null;
            //    r = nextRecord;
            //  }
            //
            //  r = _additionsHead;
            //  while (r != null) {
            //    var nextRecord = r._nextAdded;
            //    r._nextAdded = null;
            //    r = nextRecord;
            //  }
            //
            //  r = _removalsHead;
            //  while (r != null) {
            //    var nextRecord = r._nextRemoved;
            //    r._nextRemoved = null;
            //    r = nextRecord;
            //  }
            //
            //  return true;
            //});
            this._changesHead = this._changesTail = null;
            this._additionsHead = this._additionsTail = null;
            this._removalsHead = this._removalsTail = null;
        }
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._truncate = function (lastRecord, record) {
        while (record !== null) {
            if (lastRecord === null) {
                this._mapHead = null;
            }
            else {
                lastRecord._next = null;
            }
            var nextRecord = record._next;
            // todo(vicb) assert
            // assert((() {
            //  record._next = null;
            //  return true;
            //}));
            this._addToRemovals(record);
            lastRecord = record;
            record = nextRecord;
        }
        for (var rec = this._removalsHead; rec !== null; rec = rec._nextRemoved) {
            rec.previousValue = rec.currentValue;
            rec.currentValue = null;
            this._records.delete(rec.key);
        }
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._isInRemovals = function (record) {
        return record === this._removalsHead || record._nextRemoved !== null ||
            record._prevRemoved !== null;
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._addToRemovals = function (record) {
        // todo(vicb) assert
        // assert(record._next == null);
        // assert(record._nextAdded == null);
        // assert(record._nextChanged == null);
        // assert(record._nextRemoved == null);
        // assert(record._prevRemoved == null);
        if (this._removalsHead === null) {
            this._removalsHead = this._removalsTail = record;
        }
        else {
            this._removalsTail._nextRemoved = record;
            record._prevRemoved = this._removalsTail;
            this._removalsTail = record;
        }
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._removeFromSeq = function (prev, record) {
        var next = record._next;
        if (prev === null) {
            this._mapHead = next;
        }
        else {
            prev._next = next;
        }
        // todo(vicb) assert
        // assert((() {
        //  record._next = null;
        //  return true;
        //})());
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._removeFromRemovals = function (record) {
        // todo(vicb) assert
        // assert(record._next == null);
        // assert(record._nextAdded == null);
        // assert(record._nextChanged == null);
        var prev = record._prevRemoved;
        var next = record._nextRemoved;
        if (prev === null) {
            this._removalsHead = next;
        }
        else {
            prev._nextRemoved = next;
        }
        if (next === null) {
            this._removalsTail = prev;
        }
        else {
            next._prevRemoved = prev;
        }
        record._prevRemoved = record._nextRemoved = null;
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._addToAdditions = function (record) {
        // todo(vicb): assert
        // assert(record._next == null);
        // assert(record._nextAdded == null);
        // assert(record._nextChanged == null);
        // assert(record._nextRemoved == null);
        // assert(record._prevRemoved == null);
        if (this._additionsHead === null) {
            this._additionsHead = this._additionsTail = record;
        }
        else {
            this._additionsTail._nextAdded = record;
            this._additionsTail = record;
        }
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._addToChanges = function (record) {
        // todo(vicb) assert
        // assert(record._nextAdded == null);
        // assert(record._nextChanged == null);
        // assert(record._nextRemoved == null);
        // assert(record._prevRemoved == null);
        if (this._changesHead === null) {
            this._changesHead = this._changesTail = record;
        }
        else {
            this._changesTail._nextChanged = record;
            this._changesTail = record;
        }
    };
    DefaultKeyValueDiffer.prototype.toString = function () {
        var items = [];
        var previous = [];
        var changes = [];
        var additions = [];
        var removals = [];
        var record;
        for (record = this._mapHead; record !== null; record = record._next) {
            items.push(lang_1.stringify(record));
        }
        for (record = this._previousMapHead; record !== null; record = record._nextPrevious) {
            previous.push(lang_1.stringify(record));
        }
        for (record = this._changesHead; record !== null; record = record._nextChanged) {
            changes.push(lang_1.stringify(record));
        }
        for (record = this._additionsHead; record !== null; record = record._nextAdded) {
            additions.push(lang_1.stringify(record));
        }
        for (record = this._removalsHead; record !== null; record = record._nextRemoved) {
            removals.push(lang_1.stringify(record));
        }
        return "map: " + items.join(', ') + "\n" + "previous: " + previous.join(', ') + "\n" +
            "additions: " + additions.join(', ') + "\n" + "changes: " + changes.join(', ') + "\n" +
            "removals: " + removals.join(', ') + "\n";
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._forEach = function (obj, fn) {
        if (obj instanceof Map) {
            obj.forEach(fn);
        }
        else {
            collection_1.StringMapWrapper.forEach(obj, fn);
        }
    };
    return DefaultKeyValueDiffer;
})();
exports.DefaultKeyValueDiffer = DefaultKeyValueDiffer;
var KeyValueChangeRecord = (function () {
    function KeyValueChangeRecord(key) {
        this.key = key;
        this.previousValue = null;
        this.currentValue = null;
        /** @internal */
        this._nextPrevious = null;
        /** @internal */
        this._next = null;
        /** @internal */
        this._nextAdded = null;
        /** @internal */
        this._nextRemoved = null;
        /** @internal */
        this._prevRemoved = null;
        /** @internal */
        this._nextChanged = null;
    }
    KeyValueChangeRecord.prototype.toString = function () {
        return lang_1.looseIdentical(this.previousValue, this.currentValue) ?
            lang_1.stringify(this.key) :
            (lang_1.stringify(this.key) + '[' + lang_1.stringify(this.previousValue) + '->' +
                lang_1.stringify(this.currentValue) + ']');
    };
    return KeyValueChangeRecord;
})();
exports.KeyValueChangeRecord = KeyValueChangeRecord;
//# sourceMappingURL=data:application/json;base64,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