var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { SourceExpressions, moduleRef } from './source_module';
import { ChangeDetectorJITGenerator } from 'angular2/src/core/change_detection/change_detection_jit_generator';
import { AbstractChangeDetector } from 'angular2/src/core/change_detection/abstract_change_detector';
import { ChangeDetectionUtil } from 'angular2/src/core/change_detection/change_detection_util';
import { ChangeDetectorState } from 'angular2/src/core/change_detection/constants';
import { createChangeDetectorDefinitions } from './change_definition_factory';
import { IS_DART, CONST_EXPR } from 'angular2/src/facade/lang';
import { ChangeDetectorGenConfig, DynamicProtoChangeDetector } from 'angular2/src/core/change_detection/change_detection';
import { Codegen } from 'angular2/src/transform/template_compiler/change_detector_codegen';
import { MODULE_SUFFIX } from './util';
import { Injectable } from 'angular2/src/core/di';
const ABSTRACT_CHANGE_DETECTOR = "AbstractChangeDetector";
const UTIL = "ChangeDetectionUtil";
const CHANGE_DETECTOR_STATE = "ChangeDetectorState";
export const CHANGE_DETECTION_JIT_IMPORTS = CONST_EXPR({
    'AbstractChangeDetector': AbstractChangeDetector,
    'ChangeDetectionUtil': ChangeDetectionUtil,
    'ChangeDetectorState': ChangeDetectorState
});
var ABSTRACT_CHANGE_DETECTOR_MODULE = moduleRef(`package:angular2/src/core/change_detection/abstract_change_detector${MODULE_SUFFIX}`);
var UTIL_MODULE = moduleRef(`package:angular2/src/core/change_detection/change_detection_util${MODULE_SUFFIX}`);
var PREGEN_PROTO_CHANGE_DETECTOR_MODULE = moduleRef(`package:angular2/src/core/change_detection/pregen_proto_change_detector${MODULE_SUFFIX}`);
var CONSTANTS_MODULE = moduleRef(`package:angular2/src/core/change_detection/constants${MODULE_SUFFIX}`);
export let ChangeDetectionCompiler = class ChangeDetectionCompiler {
    constructor(_genConfig) {
        this._genConfig = _genConfig;
    }
    compileComponentRuntime(componentType, strategy, parsedTemplate) {
        var changeDetectorDefinitions = createChangeDetectorDefinitions(componentType, strategy, this._genConfig, parsedTemplate);
        return changeDetectorDefinitions.map(definition => this._createChangeDetectorFactory(definition));
    }
    _createChangeDetectorFactory(definition) {
        var proto = new DynamicProtoChangeDetector(definition);
        return () => proto.instantiate();
    }
    compileComponentCodeGen(componentType, strategy, parsedTemplate) {
        var changeDetectorDefinitions = createChangeDetectorDefinitions(componentType, strategy, this._genConfig, parsedTemplate);
        var factories = [];
        var index = 0;
        var sourceParts = changeDetectorDefinitions.map(definition => {
            var codegen;
            var sourcePart;
            // TODO(tbosch): move the 2 code generators to the same place, one with .dart and one with .ts
            // suffix
            // and have the same API for calling them!
            if (IS_DART) {
                codegen = new Codegen(PREGEN_PROTO_CHANGE_DETECTOR_MODULE);
                var className = `_${definition.id}`;
                var typeRef = (index === 0 && componentType.isHost) ?
                    'dynamic' :
                    `${moduleRef(componentType.moduleUrl)}${componentType.name}`;
                codegen.generate(typeRef, className, definition);
                factories.push(`${className}.newChangeDetector`);
                sourcePart = codegen.toString();
            }
            else {
                codegen = new ChangeDetectorJITGenerator(definition, `${UTIL_MODULE}${UTIL}`, `${ABSTRACT_CHANGE_DETECTOR_MODULE}${ABSTRACT_CHANGE_DETECTOR}`, `${CONSTANTS_MODULE}${CHANGE_DETECTOR_STATE}`);
                factories.push(`function() { return new ${codegen.typeName}(); }`);
                sourcePart = codegen.generateSource();
            }
            index++;
            return sourcePart;
        });
        return new SourceExpressions(sourceParts, factories);
    }
};
ChangeDetectionCompiler = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [ChangeDetectorGenConfig])
], ChangeDetectionCompiler);
//# sourceMappingURL=data:application/json;base64,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