var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { isPresent, isBlank, IS_DART, CONST_EXPR } from 'angular2/src/facade/lang';
import { ListWrapper } from 'angular2/src/facade/collection';
import { templateVisitAll } from './template_ast';
import { SourceExpression } from './source_module';
import { AppView, flattenNestedViewRenderNodes, checkSlotCount } from 'angular2/src/core/linker/view';
import { ViewType } from 'angular2/src/core/linker/view_type';
import { AppElement } from 'angular2/src/core/linker/element';
import { ViewEncapsulation } from 'angular2/src/core/metadata/view';
import { escapeSingleQuoteString, codeGenValueFn, codeGenFnHeader, Statement, escapeValue, codeGenArray, codeGenFlatArray, Expression, flattenArray, CONST_VAR } from './util';
import { Injectable } from 'angular2/src/core/di';
import { APP_VIEW_MODULE_REF, APP_EL_MODULE_REF, METADATA_MODULE_REF } from './proto_view_compiler';
export const VIEW_JIT_IMPORTS = CONST_EXPR({
    'AppView': AppView,
    'AppElement': AppElement,
    'flattenNestedViewRenderNodes': flattenNestedViewRenderNodes,
    'checkSlotCount': checkSlotCount
});
export let ViewCompiler = class ViewCompiler {
    constructor() {
    }
    compileComponentRuntime(component, template, styles, protoViews, changeDetectorFactories, componentViewFactory) {
        var viewFactory = new RuntimeViewFactory(component, styles, protoViews, changeDetectorFactories, componentViewFactory);
        return viewFactory.createViewFactory(template, 0, []);
    }
    compileComponentCodeGen(component, template, styles, protoViews, changeDetectorFactoryExpressions, componentViewFactory) {
        var viewFactory = new CodeGenViewFactory(component, styles, protoViews, changeDetectorFactoryExpressions, componentViewFactory);
        var targetStatements = [];
        var viewFactoryExpression = viewFactory.createViewFactory(template, 0, targetStatements);
        return new SourceExpression(targetStatements.map(stmt => stmt.statement), viewFactoryExpression.expression);
    }
};
ViewCompiler = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [])
], ViewCompiler);
class CodeGenViewFactory {
    constructor(component, styles, protoViews, changeDetectorExpressions, componentViewFactory) {
        this.component = component;
        this.styles = styles;
        this.protoViews = protoViews;
        this.changeDetectorExpressions = changeDetectorExpressions;
        this.componentViewFactory = componentViewFactory;
        this._nextVarId = 0;
    }
    _nextVar(prefix) {
        return `${prefix}${this._nextVarId++}_${this.component.type.name}`;
    }
    _nextRenderVar() { return this._nextVar('render'); }
    _nextAppVar() { return this._nextVar('app'); }
    _nextDisposableVar() {
        return `disposable${this._nextVarId++}_${this.component.type.name}`;
    }
    createText(renderer, parent, text, targetStatements) {
        var varName = this._nextRenderVar();
        var statement = `var ${varName} = ${renderer.expression}.createText(${isPresent(parent) ? parent.expression : null}, ${escapeSingleQuoteString(text)});`;
        targetStatements.push(new Statement(statement));
        return new Expression(varName);
    }
    createElement(renderer, parentRenderNode, name, rootSelector, targetStatements) {
        var varName = this._nextRenderVar();
        var valueExpr;
        if (isPresent(rootSelector)) {
            valueExpr = `${rootSelector.expression} == null ?
        ${renderer.expression}.createElement(${isPresent(parentRenderNode) ? parentRenderNode.expression : null}, ${escapeSingleQuoteString(name)}) :
        ${renderer.expression}.selectRootElement(${rootSelector.expression});`;
        }
        else {
            valueExpr =
                `${renderer.expression}.createElement(${isPresent(parentRenderNode) ? parentRenderNode.expression : null}, ${escapeSingleQuoteString(name)})`;
        }
        var statement = `var ${varName} = ${valueExpr};`;
        targetStatements.push(new Statement(statement));
        return new Expression(varName);
    }
    createTemplateAnchor(renderer, parentRenderNode, targetStatements) {
        var varName = this._nextRenderVar();
        var valueExpr = `${renderer.expression}.createTemplateAnchor(${isPresent(parentRenderNode) ? parentRenderNode.expression : null});`;
        targetStatements.push(new Statement(`var ${varName} = ${valueExpr}`));
        return new Expression(varName);
    }
    createGlobalEventListener(renderer, appView, boundElementIndex, eventAst, targetStatements) {
        var disposableVar = this._nextDisposableVar();
        var eventHandlerExpr = codeGenEventHandler(appView, boundElementIndex, eventAst.fullName);
        targetStatements.push(new Statement(`var ${disposableVar} = ${renderer.expression}.listenGlobal(${escapeValue(eventAst.target)}, ${escapeValue(eventAst.name)}, ${eventHandlerExpr});`));
        return new Expression(disposableVar);
    }
    createElementEventListener(renderer, appView, boundElementIndex, renderNode, eventAst, targetStatements) {
        var disposableVar = this._nextDisposableVar();
        var eventHandlerExpr = codeGenEventHandler(appView, boundElementIndex, eventAst.fullName);
        targetStatements.push(new Statement(`var ${disposableVar} = ${renderer.expression}.listen(${renderNode.expression}, ${escapeValue(eventAst.name)}, ${eventHandlerExpr});`));
        return new Expression(disposableVar);
    }
    setElementAttribute(renderer, renderNode, attrName, attrValue, targetStatements) {
        targetStatements.push(new Statement(`${renderer.expression}.setElementAttribute(${renderNode.expression}, ${escapeSingleQuoteString(attrName)}, ${escapeSingleQuoteString(attrValue)});`));
    }
    createAppElement(appProtoEl, appView, renderNode, parentAppEl, embeddedViewFactory, targetStatements) {
        var appVar = this._nextAppVar();
        var varValue = `new ${APP_EL_MODULE_REF}AppElement(${appProtoEl.expression}, ${appView.expression},
      ${isPresent(parentAppEl) ? parentAppEl.expression : null}, ${renderNode.expression}, ${isPresent(embeddedViewFactory) ? embeddedViewFactory.expression : null})`;
        targetStatements.push(new Statement(`var ${appVar} = ${varValue};`));
        return new Expression(appVar);
    }
    createAndSetComponentView(renderer, viewManager, view, appEl, component, contentNodesByNgContentIndex, targetStatements) {
        var codeGenContentNodes;
        if (this.component.type.isHost) {
            codeGenContentNodes = `${view.expression}.projectableNodes`;
        }
        else {
            codeGenContentNodes =
                `[${contentNodesByNgContentIndex.map(nodes => codeGenFlatArray(nodes)).join(',')}]`;
        }
        targetStatements.push(new Statement(`${this.componentViewFactory(component)}(${renderer.expression}, ${viewManager.expression}, ${appEl.expression}, ${codeGenContentNodes}, null, null, null);`));
    }
    getProjectedNodes(projectableNodes, ngContentIndex) {
        return new Expression(`${projectableNodes.expression}[${ngContentIndex}]`, true);
    }
    appendProjectedNodes(renderer, parent, nodes, targetStatements) {
        targetStatements.push(new Statement(`${renderer.expression}.projectNodes(${parent.expression}, ${APP_VIEW_MODULE_REF}flattenNestedViewRenderNodes(${nodes.expression}));`));
    }
    createViewFactory(asts, embeddedTemplateIndex, targetStatements) {
        var compileProtoView = this.protoViews[embeddedTemplateIndex];
        var isHostView = this.component.type.isHost;
        var isComponentView = embeddedTemplateIndex === 0 && !isHostView;
        var visitor = new ViewBuilderVisitor(new Expression('renderer'), new Expression('viewManager'), new Expression('projectableNodes'), isHostView ? new Expression('rootSelector') : null, new Expression('view'), compileProtoView, targetStatements, this);
        templateVisitAll(visitor, asts, new ParentElement(isComponentView ? new Expression('parentRenderNode') : null, null, null));
        var appProtoView = compileProtoView.protoView.expression;
        var viewFactoryName = codeGenViewFactoryName(this.component, embeddedTemplateIndex);
        var changeDetectorFactory = this.changeDetectorExpressions.expressions[embeddedTemplateIndex];
        var factoryArgs = [
            'parentRenderer',
            'viewManager',
            'containerEl',
            'projectableNodes',
            'rootSelector',
            'dynamicallyCreatedProviders',
            'rootInjector'
        ];
        var initRendererStmts = [];
        var rendererExpr = `parentRenderer`;
        if (embeddedTemplateIndex === 0) {
            var renderCompTypeVar = this._nextVar('renderType');
            targetStatements.push(new Statement(`var ${renderCompTypeVar} = null;`));
            var stylesVar = this._nextVar('styles');
            targetStatements.push(new Statement(`${CONST_VAR} ${stylesVar} = ${this.styles.expression};`));
            var encapsulation = this.component.template.encapsulation;
            initRendererStmts.push(`if (${renderCompTypeVar} == null) {
        ${renderCompTypeVar} = viewManager.createRenderComponentType(${codeGenViewEncapsulation(encapsulation)}, ${stylesVar});
      }`);
            rendererExpr = `parentRenderer.renderComponent(${renderCompTypeVar})`;
        }
        var statement = `
${codeGenFnHeader(factoryArgs, viewFactoryName)}{
  ${initRendererStmts.join('\n')}
  var renderer = ${rendererExpr};
  var view = new ${APP_VIEW_MODULE_REF}AppView(
    ${appProtoView}, renderer, viewManager,
    projectableNodes,
    containerEl,
    dynamicallyCreatedProviders, rootInjector,
    ${changeDetectorFactory}()
  );
  ${APP_VIEW_MODULE_REF}checkSlotCount(${escapeValue(this.component.type.name)}, ${this.component.template.ngContentSelectors.length}, projectableNodes);
  ${isComponentView ? 'var parentRenderNode = renderer.createViewRoot(view.containerAppElement.nativeElement);' : ''}
  ${visitor.renderStmts.map(stmt => stmt.statement).join('\n')}
  ${visitor.appStmts.map(stmt => stmt.statement).join('\n')}

  view.init(${codeGenFlatArray(visitor.rootNodesOrAppElements)}, ${codeGenArray(visitor.renderNodes)}, ${codeGenArray(visitor.appDisposables)},
            ${codeGenArray(visitor.appElements)});
  return view;
}`;
        targetStatements.push(new Statement(statement));
        return new Expression(viewFactoryName);
    }
}
class RuntimeViewFactory {
    constructor(component, styles, protoViews, changeDetectorFactories, componentViewFactory) {
        this.component = component;
        this.styles = styles;
        this.protoViews = protoViews;
        this.changeDetectorFactories = changeDetectorFactories;
        this.componentViewFactory = componentViewFactory;
    }
    createText(renderer, parent, text, targetStatements) {
        return renderer.createText(parent, text);
    }
    createElement(renderer, parent, name, rootSelector, targetStatements) {
        var el;
        if (isPresent(rootSelector)) {
            el = renderer.selectRootElement(rootSelector);
        }
        else {
            el = renderer.createElement(parent, name);
        }
        return el;
    }
    createTemplateAnchor(renderer, parent, targetStatements) {
        return renderer.createTemplateAnchor(parent);
    }
    createGlobalEventListener(renderer, appView, boundElementIndex, eventAst, targetStatements) {
        return renderer.listenGlobal(eventAst.target, eventAst.name, (event) => appView.triggerEventHandlers(eventAst.fullName, event, boundElementIndex));
    }
    createElementEventListener(renderer, appView, boundElementIndex, renderNode, eventAst, targetStatements) {
        return renderer.listen(renderNode, eventAst.name, (event) => appView.triggerEventHandlers(eventAst.fullName, event, boundElementIndex));
    }
    setElementAttribute(renderer, renderNode, attrName, attrValue, targetStatements) {
        renderer.setElementAttribute(renderNode, attrName, attrValue);
    }
    createAppElement(appProtoEl, appView, renderNode, parentAppEl, embeddedViewFactory, targetStatements) {
        return new AppElement(appProtoEl, appView, parentAppEl, renderNode, embeddedViewFactory);
    }
    createAndSetComponentView(renderer, viewManager, appView, appEl, component, contentNodesByNgContentIndex, targetStatements) {
        var flattenedContentNodes;
        if (this.component.type.isHost) {
            flattenedContentNodes = appView.projectableNodes;
        }
        else {
            flattenedContentNodes = ListWrapper.createFixedSize(contentNodesByNgContentIndex.length);
            for (var i = 0; i < contentNodesByNgContentIndex.length; i++) {
                flattenedContentNodes[i] = flattenArray(contentNodesByNgContentIndex[i], []);
            }
        }
        this.componentViewFactory(component)(renderer, viewManager, appEl, flattenedContentNodes);
    }
    getProjectedNodes(projectableNodes, ngContentIndex) {
        return projectableNodes[ngContentIndex];
    }
    appendProjectedNodes(renderer, parent, nodes, targetStatements) {
        renderer.projectNodes(parent, flattenNestedViewRenderNodes(nodes));
    }
    createViewFactory(asts, embeddedTemplateIndex, targetStatements) {
        var compileProtoView = this.protoViews[embeddedTemplateIndex];
        var isComponentView = compileProtoView.protoView.type === ViewType.COMPONENT;
        var renderComponentType = null;
        return (parentRenderer, viewManager, containerEl, projectableNodes, rootSelector = null, dynamicallyCreatedProviders = null, rootInjector = null) => {
            checkSlotCount(this.component.type.name, this.component.template.ngContentSelectors.length, projectableNodes);
            var renderer;
            if (embeddedTemplateIndex === 0) {
                if (isBlank(renderComponentType)) {
                    renderComponentType = viewManager.createRenderComponentType(this.component.template.encapsulation, this.styles);
                }
                renderer = parentRenderer.renderComponent(renderComponentType);
            }
            else {
                renderer = parentRenderer;
            }
            var changeDetector = this.changeDetectorFactories[embeddedTemplateIndex]();
            var view = new AppView(compileProtoView.protoView, renderer, viewManager, projectableNodes, containerEl, dynamicallyCreatedProviders, rootInjector, changeDetector);
            var visitor = new ViewBuilderVisitor(renderer, viewManager, projectableNodes, rootSelector, view, compileProtoView, [], this);
            var parentRenderNode = isComponentView ? renderer.createViewRoot(containerEl.nativeElement) : null;
            templateVisitAll(visitor, asts, new ParentElement(parentRenderNode, null, null));
            view.init(flattenArray(visitor.rootNodesOrAppElements, []), visitor.renderNodes, visitor.appDisposables, visitor.appElements);
            return view;
        };
    }
}
class ParentElement {
    constructor(renderNode, appEl, component) {
        this.renderNode = renderNode;
        this.appEl = appEl;
        this.component = component;
        if (isPresent(component)) {
            this.contentNodesByNgContentIndex =
                ListWrapper.createFixedSize(component.template.ngContentSelectors.length);
            for (var i = 0; i < this.contentNodesByNgContentIndex.length; i++) {
                this.contentNodesByNgContentIndex[i] = [];
            }
        }
        else {
            this.contentNodesByNgContentIndex = null;
        }
    }
    addContentNode(ngContentIndex, nodeExpr) {
        this.contentNodesByNgContentIndex[ngContentIndex].push(nodeExpr);
    }
}
class ViewBuilderVisitor {
    constructor(renderer, viewManager, projectableNodes, rootSelector, view, protoView, targetStatements, factory) {
        this.renderer = renderer;
        this.viewManager = viewManager;
        this.projectableNodes = projectableNodes;
        this.rootSelector = rootSelector;
        this.view = view;
        this.protoView = protoView;
        this.targetStatements = targetStatements;
        this.factory = factory;
        this.renderStmts = [];
        this.renderNodes = [];
        this.appStmts = [];
        this.appElements = [];
        this.appDisposables = [];
        this.rootNodesOrAppElements = [];
        this.elementCount = 0;
    }
    _addRenderNode(renderNode, appEl, ngContentIndex, parent) {
        this.renderNodes.push(renderNode);
        if (isPresent(parent.component)) {
            if (isPresent(ngContentIndex)) {
                parent.addContentNode(ngContentIndex, isPresent(appEl) ? appEl : renderNode);
            }
        }
        else if (isBlank(parent.renderNode)) {
            this.rootNodesOrAppElements.push(isPresent(appEl) ? appEl : renderNode);
        }
    }
    _getParentRenderNode(ngContentIndex, parent) {
        return isPresent(parent.component) &&
            parent.component.template.encapsulation !== ViewEncapsulation.Native ?
            null :
            parent.renderNode;
    }
    visitBoundText(ast, parent) {
        return this._visitText('', ast.ngContentIndex, parent);
    }
    visitText(ast, parent) {
        return this._visitText(ast.value, ast.ngContentIndex, parent);
    }
    _visitText(value, ngContentIndex, parent) {
        var renderNode = this.factory.createText(this.renderer, this._getParentRenderNode(ngContentIndex, parent), value, this.renderStmts);
        this._addRenderNode(renderNode, null, ngContentIndex, parent);
        return null;
    }
    visitNgContent(ast, parent) {
        var nodesExpression = this.factory.getProjectedNodes(this.projectableNodes, ast.index);
        if (isPresent(parent.component)) {
            if (isPresent(ast.ngContentIndex)) {
                parent.addContentNode(ast.ngContentIndex, nodesExpression);
            }
        }
        else {
            if (isPresent(parent.renderNode)) {
                this.factory.appendProjectedNodes(this.renderer, parent.renderNode, nodesExpression, this.renderStmts);
            }
            else {
                this.rootNodesOrAppElements.push(nodesExpression);
            }
        }
        return null;
    }
    visitElement(ast, parent) {
        var renderNode = this.factory.createElement(this.renderer, this._getParentRenderNode(ast.ngContentIndex, parent), ast.name, this.rootSelector, this.renderStmts);
        var component = ast.getComponent();
        var elementIndex = this.elementCount++;
        var protoEl = this.protoView.protoElements[elementIndex];
        protoEl.renderEvents.forEach((eventAst) => {
            var disposable;
            if (isPresent(eventAst.target)) {
                disposable = this.factory.createGlobalEventListener(this.renderer, this.view, protoEl.boundElementIndex, eventAst, this.renderStmts);
            }
            else {
                disposable = this.factory.createElementEventListener(this.renderer, this.view, protoEl.boundElementIndex, renderNode, eventAst, this.renderStmts);
            }
            this.appDisposables.push(disposable);
        });
        for (var i = 0; i < protoEl.attrNameAndValues.length; i++) {
            var attrName = protoEl.attrNameAndValues[i][0];
            var attrValue = protoEl.attrNameAndValues[i][1];
            this.factory.setElementAttribute(this.renderer, renderNode, attrName, attrValue, this.renderStmts);
        }
        var appEl = null;
        if (isPresent(protoEl.appProtoEl)) {
            appEl = this.factory.createAppElement(protoEl.appProtoEl, this.view, renderNode, parent.appEl, null, this.appStmts);
            this.appElements.push(appEl);
        }
        this._addRenderNode(renderNode, appEl, ast.ngContentIndex, parent);
        var newParent = new ParentElement(renderNode, isPresent(appEl) ? appEl : parent.appEl, component);
        templateVisitAll(this, ast.children, newParent);
        if (isPresent(appEl) && isPresent(component)) {
            this.factory.createAndSetComponentView(this.renderer, this.viewManager, this.view, appEl, component, newParent.contentNodesByNgContentIndex, this.appStmts);
        }
        return null;
    }
    visitEmbeddedTemplate(ast, parent) {
        var renderNode = this.factory.createTemplateAnchor(this.renderer, this._getParentRenderNode(ast.ngContentIndex, parent), this.renderStmts);
        var elementIndex = this.elementCount++;
        var protoEl = this.protoView.protoElements[elementIndex];
        var embeddedViewFactory = this.factory.createViewFactory(ast.children, protoEl.embeddedTemplateIndex, this.targetStatements);
        var appEl = this.factory.createAppElement(protoEl.appProtoEl, this.view, renderNode, parent.appEl, embeddedViewFactory, this.appStmts);
        this._addRenderNode(renderNode, appEl, ast.ngContentIndex, parent);
        this.appElements.push(appEl);
        return null;
    }
    visitVariable(ast, ctx) { return null; }
    visitAttr(ast, ctx) { return null; }
    visitDirective(ast, ctx) { return null; }
    visitEvent(ast, ctx) { return null; }
    visitDirectiveProperty(ast, context) { return null; }
    visitElementProperty(ast, context) { return null; }
}
function codeGenEventHandler(view, boundElementIndex, eventName) {
    return codeGenValueFn(['event'], `${view.expression}.triggerEventHandlers(${escapeValue(eventName)}, event, ${boundElementIndex})`);
}
function codeGenViewFactoryName(component, embeddedTemplateIndex) {
    return `viewFactory_${component.type.name}${embeddedTemplateIndex}`;
}
function codeGenViewEncapsulation(value) {
    if (IS_DART) {
        return `${METADATA_MODULE_REF}${value}`;
    }
    else {
        return `${value}`;
    }
}
//# sourceMappingURL=data:application/json;base64,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