'use strict';"use strict";
var lang_1 = require('angular2/src/facade/lang');
var interfaces_1 = require('./interfaces');
function hasLifecycleHook(lcInterface, token) {
    if (!(token instanceof lang_1.Type))
        return false;
    var proto = token.prototype;
    switch (lcInterface) {
        case interfaces_1.LifecycleHooks.AfterContentInit:
            return !!proto.ngAfterContentInit;
        case interfaces_1.LifecycleHooks.AfterContentChecked:
            return !!proto.ngAfterContentChecked;
        case interfaces_1.LifecycleHooks.AfterViewInit:
            return !!proto.ngAfterViewInit;
        case interfaces_1.LifecycleHooks.AfterViewChecked:
            return !!proto.ngAfterViewChecked;
        case interfaces_1.LifecycleHooks.OnChanges:
            return !!proto.ngOnChanges;
        case interfaces_1.LifecycleHooks.DoCheck:
            return !!proto.ngDoCheck;
        case interfaces_1.LifecycleHooks.OnDestroy:
            return !!proto.ngOnDestroy;
        case interfaces_1.LifecycleHooks.OnInit:
            return !!proto.ngOnInit;
        default:
            return false;
    }
}
exports.hasLifecycleHook = hasLifecycleHook;
//# sourceMappingURL=data:application/json;base64,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