'use strict';"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var di_1 = require('angular2/src/core/di');
var lang_1 = require('angular2/src/facade/lang');
var collection_1 = require('angular2/src/facade/collection');
var exceptions_1 = require('angular2/src/facade/exceptions');
var view_1 = require('./view');
var api_1 = require('angular2/src/core/render/api');
var profile_1 = require('../profile/profile');
var application_tokens_1 = require('angular2/src/core/application_tokens');
var view_type_1 = require('./view_type');
/**
 * Service exposing low level API for creating, moving and destroying Views.
 *
 * Most applications should use higher-level abstractions like {@link DynamicComponentLoader} and
 * {@link ViewContainerRef} instead.
 */
var AppViewManager = (function () {
    function AppViewManager() {
    }
    return AppViewManager;
}());
exports.AppViewManager = AppViewManager;
var AppViewManager_ = (function (_super) {
    __extends(AppViewManager_, _super);
    function AppViewManager_(_renderer, _appId) {
        _super.call(this);
        this._renderer = _renderer;
        this._appId = _appId;
        this._nextCompTypeId = 0;
        /** @internal */
        this._createRootHostViewScope = profile_1.wtfCreateScope('AppViewManager#createRootHostView()');
        /** @internal */
        this._destroyRootHostViewScope = profile_1.wtfCreateScope('AppViewManager#destroyRootHostView()');
        /** @internal */
        this._createEmbeddedViewInContainerScope = profile_1.wtfCreateScope('AppViewManager#createEmbeddedViewInContainer()');
        /** @internal */
        this._createHostViewInContainerScope = profile_1.wtfCreateScope('AppViewManager#createHostViewInContainer()');
        /** @internal */
        this._destroyViewInContainerScope = profile_1.wtfCreateScope('AppViewMananger#destroyViewInContainer()');
        /** @internal */
        this._attachViewInContainerScope = profile_1.wtfCreateScope('AppViewMananger#attachViewInContainer()');
        /** @internal */
        this._detachViewInContainerScope = profile_1.wtfCreateScope('AppViewMananger#detachViewInContainer()');
    }
    AppViewManager_.prototype.getViewContainer = function (location) {
        return location.internalElement.getViewContainerRef();
    };
    AppViewManager_.prototype.getHostElement = function (hostViewRef) {
        var hostView = hostViewRef.internalView;
        if (hostView.proto.type !== view_type_1.ViewType.HOST) {
            throw new exceptions_1.BaseException('This operation is only allowed on host views');
        }
        return hostView.appElements[0].ref;
    };
    AppViewManager_.prototype.getNamedElementInComponentView = function (hostLocation, variableName) {
        var appEl = hostLocation.internalElement;
        var componentView = appEl.componentView;
        if (lang_1.isBlank(componentView)) {
            throw new exceptions_1.BaseException("There is no component directive at element " + hostLocation);
        }
        for (var i = 0; i < componentView.appElements.length; i++) {
            var compAppEl = componentView.appElements[i];
            if (collection_1.StringMapWrapper.contains(compAppEl.proto.directiveVariableBindings, variableName)) {
                return compAppEl.ref;
            }
        }
        throw new exceptions_1.BaseException("Could not find variable " + variableName);
    };
    AppViewManager_.prototype.getComponent = function (hostLocation) {
        return hostLocation.internalElement.getComponent();
    };
    AppViewManager_.prototype.createRootHostView = function (hostViewFactoryRef, overrideSelector, injector, projectableNodes) {
        if (projectableNodes === void 0) { projectableNodes = null; }
        var s = this._createRootHostViewScope();
        var hostViewFactory = hostViewFactoryRef.internalHostViewFactory;
        var selector = lang_1.isPresent(overrideSelector) ? overrideSelector : hostViewFactory.selector;
        var view = hostViewFactory.viewFactory(this._renderer, this, null, projectableNodes, selector, null, injector);
        return profile_1.wtfLeave(s, view.ref);
    };
    AppViewManager_.prototype.destroyRootHostView = function (hostViewRef) {
        var s = this._destroyRootHostViewScope();
        var hostView = hostViewRef.internalView;
        hostView.renderer.detachView(view_1.flattenNestedViewRenderNodes(hostView.rootNodesOrAppElements));
        hostView.destroy();
        profile_1.wtfLeave(s);
    };
    AppViewManager_.prototype.createEmbeddedViewInContainer = function (viewContainerLocation, index, templateRef) {
        var s = this._createEmbeddedViewInContainerScope();
        var contextEl = templateRef.elementRef.internalElement;
        var view = contextEl.embeddedViewFactory(contextEl.parentView.renderer, this, contextEl, contextEl.parentView.projectableNodes, null, null, null);
        this._attachViewToContainer(view, viewContainerLocation.internalElement, index);
        return profile_1.wtfLeave(s, view.ref);
    };
    AppViewManager_.prototype.createHostViewInContainer = function (viewContainerLocation, index, hostViewFactoryRef, dynamicallyCreatedProviders, projectableNodes) {
        var s = this._createHostViewInContainerScope();
        // TODO(tbosch): This should be specifiable via an additional argument!
        var viewContainerLocation_ = viewContainerLocation;
        var contextEl = viewContainerLocation_.internalElement;
        var hostViewFactory = hostViewFactoryRef.internalHostViewFactory;
        var view = hostViewFactory.viewFactory(contextEl.parentView.renderer, contextEl.parentView.viewManager, contextEl, projectableNodes, null, dynamicallyCreatedProviders, null);
        this._attachViewToContainer(view, viewContainerLocation_.internalElement, index);
        return profile_1.wtfLeave(s, view.ref);
    };
    AppViewManager_.prototype.destroyViewInContainer = function (viewContainerLocation, index) {
        var s = this._destroyViewInContainerScope();
        var view = this._detachViewInContainer(viewContainerLocation.internalElement, index);
        view.destroy();
        profile_1.wtfLeave(s);
    };
    // TODO(i): refactor detachViewInContainer+attachViewInContainer to moveViewInContainer
    AppViewManager_.prototype.attachViewInContainer = function (viewContainerLocation, index, viewRef) {
        var viewRef_ = viewRef;
        var s = this._attachViewInContainerScope();
        this._attachViewToContainer(viewRef_.internalView, viewContainerLocation.internalElement, index);
        return profile_1.wtfLeave(s, viewRef_);
    };
    // TODO(i): refactor detachViewInContainer+attachViewInContainer to moveViewInContainer
    AppViewManager_.prototype.detachViewInContainer = function (viewContainerLocation, index) {
        var s = this._detachViewInContainerScope();
        var view = this._detachViewInContainer(viewContainerLocation.internalElement, index);
        return profile_1.wtfLeave(s, view.ref);
    };
    /** @internal */
    AppViewManager_.prototype.onViewCreated = function (view) { };
    /** @internal */
    AppViewManager_.prototype.onViewDestroyed = function (view) { };
    /** @internal */
    AppViewManager_.prototype.createRenderComponentType = function (encapsulation, styles) {
        return new api_1.RenderComponentType(this._appId + "-" + this._nextCompTypeId++, encapsulation, styles);
    };
    AppViewManager_.prototype._attachViewToContainer = function (view, vcAppElement, viewIndex) {
        if (view.proto.type === view_type_1.ViewType.COMPONENT) {
            throw new exceptions_1.BaseException("Component views can't be moved!");
        }
        var nestedViews = vcAppElement.nestedViews;
        if (nestedViews == null) {
            nestedViews = [];
            vcAppElement.nestedViews = nestedViews;
        }
        collection_1.ListWrapper.insert(nestedViews, viewIndex, view);
        var refNode;
        if (viewIndex > 0) {
            var prevView = nestedViews[viewIndex - 1];
            refNode = prevView.rootNodesOrAppElements.length > 0 ?
                prevView.rootNodesOrAppElements[prevView.rootNodesOrAppElements.length - 1] :
                null;
        }
        else {
            refNode = vcAppElement.nativeElement;
        }
        if (lang_1.isPresent(refNode)) {
            var refRenderNode = view_1.findLastRenderNode(refNode);
            view.renderer.attachViewAfter(refRenderNode, view_1.flattenNestedViewRenderNodes(view.rootNodesOrAppElements));
        }
        // TODO: This is only needed when a view is destroyed,
        // not when it is detached for reordering with ng-for...
        vcAppElement.parentView.changeDetector.addContentChild(view.changeDetector);
        vcAppElement.traverseAndSetQueriesAsDirty();
    };
    AppViewManager_.prototype._detachViewInContainer = function (vcAppElement, viewIndex) {
        var view = collection_1.ListWrapper.removeAt(vcAppElement.nestedViews, viewIndex);
        if (view.proto.type === view_type_1.ViewType.COMPONENT) {
            throw new exceptions_1.BaseException("Component views can't be moved!");
        }
        vcAppElement.traverseAndSetQueriesAsDirty();
        view.renderer.detachView(view_1.flattenNestedViewRenderNodes(view.rootNodesOrAppElements));
        // TODO: This is only needed when a view is destroyed,
        // not when it is detached for reordering with ng-for...
        view.changeDetector.remove();
        return view;
    };
    AppViewManager_ = __decorate([
        di_1.Injectable(),
        __param(1, di_1.Inject(application_tokens_1.APP_ID)), 
        __metadata('design:paramtypes', [api_1.RootRenderer, String])
    ], AppViewManager_);
    return AppViewManager_;
}(AppViewManager));
exports.AppViewManager_ = AppViewManager_;
//# sourceMappingURL=data:application/json;base64,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