var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { isBlank, isPresent, CONST_EXPR, looseIdentical } from 'angular2/src/facade/lang';
import { ListWrapper, StringMapWrapper } from 'angular2/src/facade/collection';
import { BaseException } from 'angular2/src/facade/exceptions';
import { AppElement } from './element';
import { ExpressionChangedAfterItHasBeenCheckedException } from './exceptions';
import { devModeEqual, uninitialized } from 'angular2/src/core/change_detection/change_detection';
import { Inject, Injectable } from 'angular2/src/core/di';
import { RootRenderer, RenderComponentType } from 'angular2/src/core/render/api';
import { APP_ID } from 'angular2/src/core/application_tokens';
export let ViewUtils = class ViewUtils {
    constructor(_renderer, _appId) {
        this._renderer = _renderer;
        this._appId = _appId;
        this._nextCompTypeId = 0;
    }
    /**
     * Used by the generated code
     */
    createRenderComponentType(templateUrl, slotCount, encapsulation, styles) {
        return new RenderComponentType(`${this._appId}-${this._nextCompTypeId++}`, templateUrl, slotCount, encapsulation, styles);
    }
    /** @internal */
    renderComponent(renderComponentType) {
        return this._renderer.renderComponent(renderComponentType);
    }
};
ViewUtils = __decorate([
    Injectable(),
    __param(1, Inject(APP_ID)), 
    __metadata('design:paramtypes', [RootRenderer, String])
], ViewUtils);
export function flattenNestedViewRenderNodes(nodes) {
    return _flattenNestedViewRenderNodes(nodes, []);
}
function _flattenNestedViewRenderNodes(nodes, renderNodes) {
    for (var i = 0; i < nodes.length; i++) {
        var node = nodes[i];
        if (node instanceof AppElement) {
            var appEl = node;
            renderNodes.push(appEl.nativeElement);
            if (isPresent(appEl.nestedViews)) {
                for (var k = 0; k < appEl.nestedViews.length; k++) {
                    _flattenNestedViewRenderNodes(appEl.nestedViews[k].rootNodesOrAppElements, renderNodes);
                }
            }
        }
        else {
            renderNodes.push(node);
        }
    }
    return renderNodes;
}
const EMPTY_ARR = CONST_EXPR([]);
export function ensureSlotCount(projectableNodes, expectedSlotCount) {
    var res;
    if (isBlank(projectableNodes)) {
        res = EMPTY_ARR;
    }
    else if (projectableNodes.length < expectedSlotCount) {
        var givenSlotCount = projectableNodes.length;
        res = ListWrapper.createFixedSize(expectedSlotCount);
        for (var i = 0; i < expectedSlotCount; i++) {
            res[i] = (i < givenSlotCount) ? projectableNodes[i] : EMPTY_ARR;
        }
    }
    else {
        res = projectableNodes;
    }
    return res;
}
export const MAX_INTERPOLATION_VALUES = 9;
export function interpolate(valueCount, c0, a1, c1, a2, c2, a3, c3, a4, c4, a5, c5, a6, c6, a7, c7, a8, c8, a9, c9) {
    switch (valueCount) {
        case 1:
            return c0 + _toStringWithNull(a1) + c1;
        case 2:
            return c0 + _toStringWithNull(a1) + c1 + _toStringWithNull(a2) + c2;
        case 3:
            return c0 + _toStringWithNull(a1) + c1 + _toStringWithNull(a2) + c2 + _toStringWithNull(a3) +
                c3;
        case 4:
            return c0 + _toStringWithNull(a1) + c1 + _toStringWithNull(a2) + c2 + _toStringWithNull(a3) +
                c3 + _toStringWithNull(a4) + c4;
        case 5:
            return c0 + _toStringWithNull(a1) + c1 + _toStringWithNull(a2) + c2 + _toStringWithNull(a3) +
                c3 + _toStringWithNull(a4) + c4 + _toStringWithNull(a5) + c5;
        case 6:
            return c0 + _toStringWithNull(a1) + c1 + _toStringWithNull(a2) + c2 + _toStringWithNull(a3) +
                c3 + _toStringWithNull(a4) + c4 + _toStringWithNull(a5) + c5 + _toStringWithNull(a6) +
                c6;
        case 7:
            return c0 + _toStringWithNull(a1) + c1 + _toStringWithNull(a2) + c2 + _toStringWithNull(a3) +
                c3 + _toStringWithNull(a4) + c4 + _toStringWithNull(a5) + c5 + _toStringWithNull(a6) +
                c6 + _toStringWithNull(a7) + c7;
        case 8:
            return c0 + _toStringWithNull(a1) + c1 + _toStringWithNull(a2) + c2 + _toStringWithNull(a3) +
                c3 + _toStringWithNull(a4) + c4 + _toStringWithNull(a5) + c5 + _toStringWithNull(a6) +
                c6 + _toStringWithNull(a7) + c7 + _toStringWithNull(a8) + c8;
        case 9:
            return c0 + _toStringWithNull(a1) + c1 + _toStringWithNull(a2) + c2 + _toStringWithNull(a3) +
                c3 + _toStringWithNull(a4) + c4 + _toStringWithNull(a5) + c5 + _toStringWithNull(a6) +
                c6 + _toStringWithNull(a7) + c7 + _toStringWithNull(a8) + c8 + _toStringWithNull(a9) +
                c9;
        default:
            throw new BaseException(`Does not support more than 9 expressions`);
    }
}
function _toStringWithNull(v) {
    return v != null ? v.toString() : '';
}
export function checkBinding(throwOnChange, oldValue, newValue) {
    if (throwOnChange) {
        if (!devModeEqual(oldValue, newValue)) {
            throw new ExpressionChangedAfterItHasBeenCheckedException(oldValue, newValue, null);
        }
        return false;
    }
    else {
        return !looseIdentical(oldValue, newValue);
    }
}
export function arrayLooseIdentical(a, b) {
    if (a.length != b.length)
        return false;
    for (var i = 0; i < a.length; ++i) {
        if (!looseIdentical(a[i], b[i]))
            return false;
    }
    return true;
}
export function mapLooseIdentical(m1, m2) {
    var k1 = StringMapWrapper.keys(m1);
    var k2 = StringMapWrapper.keys(m2);
    if (k1.length != k2.length) {
        return false;
    }
    var key;
    for (var i = 0; i < k1.length; i++) {
        key = k1[i];
        if (!looseIdentical(m1[key], m2[key])) {
            return false;
        }
    }
    return true;
}
export function castByValue(input, value) {
    return input;
}
export function pureProxy1(fn) {
    var result;
    var v0;
    v0 = uninitialized;
    return (p0) => {
        if (!looseIdentical(v0, p0)) {
            v0 = p0;
            result = fn(p0);
        }
        return result;
    };
}
export function pureProxy2(fn) {
    var result;
    var v0, v1;
    v0 = v1 = uninitialized;
    return (p0, p1) => {
        if (!looseIdentical(v0, p0) || !looseIdentical(v1, p1)) {
            v0 = p0;
            v1 = p1;
            result = fn(p0, p1);
        }
        return result;
    };
}
export function pureProxy3(fn) {
    var result;
    var v0, v1, v2;
    v0 = v1 = v2 = uninitialized;
    return (p0, p1, p2) => {
        if (!looseIdentical(v0, p0) || !looseIdentical(v1, p1) || !looseIdentical(v2, p2)) {
            v0 = p0;
            v1 = p1;
            v2 = p2;
            result = fn(p0, p1, p2);
        }
        return result;
    };
}
export function pureProxy4(fn) {
    var result;
    var v0, v1, v2, v3;
    v0 = v1 = v2 = v3 = uninitialized;
    return (p0, p1, p2, p3) => {
        if (!looseIdentical(v0, p0) || !looseIdentical(v1, p1) || !looseIdentical(v2, p2) ||
            !looseIdentical(v3, p3)) {
            v0 = p0;
            v1 = p1;
            v2 = p2;
            v3 = p3;
            result = fn(p0, p1, p2, p3);
        }
        return result;
    };
}
export function pureProxy5(fn) {
    var result;
    var v0, v1, v2, v3, v4;
    v0 = v1 = v2 = v3 = v4 = uninitialized;
    return (p0, p1, p2, p3, p4) => {
        if (!looseIdentical(v0, p0) || !looseIdentical(v1, p1) || !looseIdentical(v2, p2) ||
            !looseIdentical(v3, p3) || !looseIdentical(v4, p4)) {
            v0 = p0;
            v1 = p1;
            v2 = p2;
            v3 = p3;
            v4 = p4;
            result = fn(p0, p1, p2, p3, p4);
        }
        return result;
    };
}
export function pureProxy6(fn) {
    var result;
    var v0, v1, v2, v3, v4, v5;
    v0 = v1 = v2 = v3 = v4 = v5 = uninitialized;
    return (p0, p1, p2, p3, p4, p5) => {
        if (!looseIdentical(v0, p0) || !looseIdentical(v1, p1) || !looseIdentical(v2, p2) ||
            !looseIdentical(v3, p3) || !looseIdentical(v4, p4) || !looseIdentical(v5, p5)) {
            v0 = p0;
            v1 = p1;
            v2 = p2;
            v3 = p3;
            v4 = p4;
            v5 = p5;
            result = fn(p0, p1, p2, p3, p4, p5);
        }
        return result;
    };
}
export function pureProxy7(fn) {
    var result;
    var v0, v1, v2, v3, v4, v5, v6;
    v0 = v1 = v2 = v3 = v4 = v5 = v6 = uninitialized;
    return (p0, p1, p2, p3, p4, p5, p6) => {
        if (!looseIdentical(v0, p0) || !looseIdentical(v1, p1) || !looseIdentical(v2, p2) ||
            !looseIdentical(v3, p3) || !looseIdentical(v4, p4) || !looseIdentical(v5, p5) ||
            !looseIdentical(v6, p6)) {
            v0 = p0;
            v1 = p1;
            v2 = p2;
            v3 = p3;
            v4 = p4;
            v5 = p5;
            v6 = p6;
            result = fn(p0, p1, p2, p3, p4, p5, p6);
        }
        return result;
    };
}
export function pureProxy8(fn) {
    var result;
    var v0, v1, v2, v3, v4, v5, v6, v7;
    v0 = v1 = v2 = v3 = v4 = v5 = v6 = v7 = uninitialized;
    return (p0, p1, p2, p3, p4, p5, p6, p7) => {
        if (!looseIdentical(v0, p0) || !looseIdentical(v1, p1) || !looseIdentical(v2, p2) ||
            !looseIdentical(v3, p3) || !looseIdentical(v4, p4) || !looseIdentical(v5, p5) ||
            !looseIdentical(v6, p6) || !looseIdentical(v7, p7)) {
            v0 = p0;
            v1 = p1;
            v2 = p2;
            v3 = p3;
            v4 = p4;
            v5 = p5;
            v6 = p6;
            v7 = p7;
            result = fn(p0, p1, p2, p3, p4, p5, p6, p7);
        }
        return result;
    };
}
export function pureProxy9(fn) {
    var result;
    var v0, v1, v2, v3, v4, v5, v6, v7, v8;
    v0 = v1 = v2 = v3 = v4 = v5 = v6 = v7 = v8 = uninitialized;
    return (p0, p1, p2, p3, p4, p5, p6, p7, p8) => {
        if (!looseIdentical(v0, p0) || !looseIdentical(v1, p1) || !looseIdentical(v2, p2) ||
            !looseIdentical(v3, p3) || !looseIdentical(v4, p4) || !looseIdentical(v5, p5) ||
            !looseIdentical(v6, p6) || !looseIdentical(v7, p7) || !looseIdentical(v8, p8)) {
            v0 = p0;
            v1 = p1;
            v2 = p2;
            v3 = p3;
            v4 = p4;
            v5 = p5;
            v6 = p6;
            v7 = p7;
            v8 = p8;
            result = fn(p0, p1, p2, p3, p4, p5, p6, p7, p8);
        }
        return result;
    };
}
export function pureProxy10(fn) {
    var result;
    var v0, v1, v2, v3, v4, v5, v6, v7, v8, v9;
    v0 = v1 = v2 = v3 = v4 = v5 = v6 = v7 = v8 = v9 = uninitialized;
    return (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9) => {
        if (!looseIdentical(v0, p0) || !looseIdentical(v1, p1) || !looseIdentical(v2, p2) ||
            !looseIdentical(v3, p3) || !looseIdentical(v4, p4) || !looseIdentical(v5, p5) ||
            !looseIdentical(v6, p6) || !looseIdentical(v7, p7) || !looseIdentical(v8, p8) ||
            !looseIdentical(v9, p9)) {
            v0 = p0;
            v1 = p1;
            v2 = p2;
            v3 = p3;
            v4 = p4;
            v5 = p5;
            v6 = p6;
            v7 = p7;
            v8 = p8;
            v9 = p9;
            result = fn(p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
        }
        return result;
    };
}
//# sourceMappingURL=data:application/json;base64,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