'use strict';"use strict";
var lang_1 = require('angular2/src/facade/lang');
// see http://www.w3.org/TR/html51/syntax.html#named-character-references
// see https://html.spec.whatwg.org/multipage/entities.json
// This list is not exhaustive to keep the compiler footprint low.
// The `&#123;` / `&#x1ab;` syntax should be used when the named character reference does not exist.
exports.NAMED_ENTITIES = lang_1.CONST_EXPR({
    'Aacute': '\u00C1',
    'aacute': '\u00E1',
    'Acirc': '\u00C2',
    'acirc': '\u00E2',
    'acute': '\u00B4',
    'AElig': '\u00C6',
    'aelig': '\u00E6',
    'Agrave': '\u00C0',
    'agrave': '\u00E0',
    'alefsym': '\u2135',
    'Alpha': '\u0391',
    'alpha': '\u03B1',
    'amp': '&',
    'and': '\u2227',
    'ang': '\u2220',
    'apos': '\u0027',
    'Aring': '\u00C5',
    'aring': '\u00E5',
    'asymp': '\u2248',
    'Atilde': '\u00C3',
    'atilde': '\u00E3',
    'Auml': '\u00C4',
    'auml': '\u00E4',
    'bdquo': '\u201E',
    'Beta': '\u0392',
    'beta': '\u03B2',
    'brvbar': '\u00A6',
    'bull': '\u2022',
    'cap': '\u2229',
    'Ccedil': '\u00C7',
    'ccedil': '\u00E7',
    'cedil': '\u00B8',
    'cent': '\u00A2',
    'Chi': '\u03A7',
    'chi': '\u03C7',
    'circ': '\u02C6',
    'clubs': '\u2663',
    'cong': '\u2245',
    'copy': '\u00A9',
    'crarr': '\u21B5',
    'cup': '\u222A',
    'curren': '\u00A4',
    'dagger': '\u2020',
    'Dagger': '\u2021',
    'darr': '\u2193',
    'dArr': '\u21D3',
    'deg': '\u00B0',
    'Delta': '\u0394',
    'delta': '\u03B4',
    'diams': '\u2666',
    'divide': '\u00F7',
    'Eacute': '\u00C9',
    'eacute': '\u00E9',
    'Ecirc': '\u00CA',
    'ecirc': '\u00EA',
    'Egrave': '\u00C8',
    'egrave': '\u00E8',
    'empty': '\u2205',
    'emsp': '\u2003',
    'ensp': '\u2002',
    'Epsilon': '\u0395',
    'epsilon': '\u03B5',
    'equiv': '\u2261',
    'Eta': '\u0397',
    'eta': '\u03B7',
    'ETH': '\u00D0',
    'eth': '\u00F0',
    'Euml': '\u00CB',
    'euml': '\u00EB',
    'euro': '\u20AC',
    'exist': '\u2203',
    'fnof': '\u0192',
    'forall': '\u2200',
    'frac12': '\u00BD',
    'frac14': '\u00BC',
    'frac34': '\u00BE',
    'frasl': '\u2044',
    'Gamma': '\u0393',
    'gamma': '\u03B3',
    'ge': '\u2265',
    'gt': '>',
    'harr': '\u2194',
    'hArr': '\u21D4',
    'hearts': '\u2665',
    'hellip': '\u2026',
    'Iacute': '\u00CD',
    'iacute': '\u00ED',
    'Icirc': '\u00CE',
    'icirc': '\u00EE',
    'iexcl': '\u00A1',
    'Igrave': '\u00CC',
    'igrave': '\u00EC',
    'image': '\u2111',
    'infin': '\u221E',
    'int': '\u222B',
    'Iota': '\u0399',
    'iota': '\u03B9',
    'iquest': '\u00BF',
    'isin': '\u2208',
    'Iuml': '\u00CF',
    'iuml': '\u00EF',
    'Kappa': '\u039A',
    'kappa': '\u03BA',
    'Lambda': '\u039B',
    'lambda': '\u03BB',
    'lang': '\u27E8',
    'laquo': '\u00AB',
    'larr': '\u2190',
    'lArr': '\u21D0',
    'lceil': '\u2308',
    'ldquo': '\u201C',
    'le': '\u2264',
    'lfloor': '\u230A',
    'lowast': '\u2217',
    'loz': '\u25CA',
    'lrm': '\u200E',
    'lsaquo': '\u2039',
    'lsquo': '\u2018',
    'lt': '<',
    'macr': '\u00AF',
    'mdash': '\u2014',
    'micro': '\u00B5',
    'middot': '\u00B7',
    'minus': '\u2212',
    'Mu': '\u039C',
    'mu': '\u03BC',
    'nabla': '\u2207',
    'nbsp': '\u00A0',
    'ndash': '\u2013',
    'ne': '\u2260',
    'ni': '\u220B',
    'not': '\u00AC',
    'notin': '\u2209',
    'nsub': '\u2284',
    'Ntilde': '\u00D1',
    'ntilde': '\u00F1',
    'Nu': '\u039D',
    'nu': '\u03BD',
    'Oacute': '\u00D3',
    'oacute': '\u00F3',
    'Ocirc': '\u00D4',
    'ocirc': '\u00F4',
    'OElig': '\u0152',
    'oelig': '\u0153',
    'Ograve': '\u00D2',
    'ograve': '\u00F2',
    'oline': '\u203E',
    'Omega': '\u03A9',
    'omega': '\u03C9',
    'Omicron': '\u039F',
    'omicron': '\u03BF',
    'oplus': '\u2295',
    'or': '\u2228',
    'ordf': '\u00AA',
    'ordm': '\u00BA',
    'Oslash': '\u00D8',
    'oslash': '\u00F8',
    'Otilde': '\u00D5',
    'otilde': '\u00F5',
    'otimes': '\u2297',
    'Ouml': '\u00D6',
    'ouml': '\u00F6',
    'para': '\u00B6',
    'permil': '\u2030',
    'perp': '\u22A5',
    'Phi': '\u03A6',
    'phi': '\u03C6',
    'Pi': '\u03A0',
    'pi': '\u03C0',
    'piv': '\u03D6',
    'plusmn': '\u00B1',
    'pound': '\u00A3',
    'prime': '\u2032',
    'Prime': '\u2033',
    'prod': '\u220F',
    'prop': '\u221D',
    'Psi': '\u03A8',
    'psi': '\u03C8',
    'quot': '\u0022',
    'radic': '\u221A',
    'rang': '\u27E9',
    'raquo': '\u00BB',
    'rarr': '\u2192',
    'rArr': '\u21D2',
    'rceil': '\u2309',
    'rdquo': '\u201D',
    'real': '\u211C',
    'reg': '\u00AE',
    'rfloor': '\u230B',
    'Rho': '\u03A1',
    'rho': '\u03C1',
    'rlm': '\u200F',
    'rsaquo': '\u203A',
    'rsquo': '\u2019',
    'sbquo': '\u201A',
    'Scaron': '\u0160',
    'scaron': '\u0161',
    'sdot': '\u22C5',
    'sect': '\u00A7',
    'shy': '\u00AD',
    'Sigma': '\u03A3',
    'sigma': '\u03C3',
    'sigmaf': '\u03C2',
    'sim': '\u223C',
    'spades': '\u2660',
    'sub': '\u2282',
    'sube': '\u2286',
    'sum': '\u2211',
    'sup': '\u2283',
    'sup1': '\u00B9',
    'sup2': '\u00B2',
    'sup3': '\u00B3',
    'supe': '\u2287',
    'szlig': '\u00DF',
    'Tau': '\u03A4',
    'tau': '\u03C4',
    'there4': '\u2234',
    'Theta': '\u0398',
    'theta': '\u03B8',
    'thetasym': '\u03D1',
    'thinsp': '\u2009',
    'THORN': '\u00DE',
    'thorn': '\u00FE',
    'tilde': '\u02DC',
    'times': '\u00D7',
    'trade': '\u2122',
    'Uacute': '\u00DA',
    'uacute': '\u00FA',
    'uarr': '\u2191',
    'uArr': '\u21D1',
    'Ucirc': '\u00DB',
    'ucirc': '\u00FB',
    'Ugrave': '\u00D9',
    'ugrave': '\u00F9',
    'uml': '\u00A8',
    'upsih': '\u03D2',
    'Upsilon': '\u03A5',
    'upsilon': '\u03C5',
    'Uuml': '\u00DC',
    'uuml': '\u00FC',
    'weierp': '\u2118',
    'Xi': '\u039E',
    'xi': '\u03BE',
    'Yacute': '\u00DD',
    'yacute': '\u00FD',
    'yen': '\u00A5',
    'yuml': '\u00FF',
    'Yuml': '\u0178',
    'Zeta': '\u0396',
    'zeta': '\u03B6',
    'zwj': '\u200D',
    'zwnj': '\u200C',
});
(function (HtmlTagContentType) {
    HtmlTagContentType[HtmlTagContentType["RAW_TEXT"] = 0] = "RAW_TEXT";
    HtmlTagContentType[HtmlTagContentType["ESCAPABLE_RAW_TEXT"] = 1] = "ESCAPABLE_RAW_TEXT";
    HtmlTagContentType[HtmlTagContentType["PARSABLE_DATA"] = 2] = "PARSABLE_DATA";
})(exports.HtmlTagContentType || (exports.HtmlTagContentType = {}));
var HtmlTagContentType = exports.HtmlTagContentType;
var HtmlTagDefinition = (function () {
    function HtmlTagDefinition(_a) {
        var _this = this;
        var _b = _a === void 0 ? {} : _a, closedByChildren = _b.closedByChildren, requiredParents = _b.requiredParents, implicitNamespacePrefix = _b.implicitNamespacePrefix, contentType = _b.contentType, closedByParent = _b.closedByParent, isVoid = _b.isVoid, ignoreFirstLf = _b.ignoreFirstLf;
        this.closedByChildren = {};
        this.closedByParent = false;
        if (lang_1.isPresent(closedByChildren) && closedByChildren.length > 0) {
            closedByChildren.forEach(function (tagName) { return _this.closedByChildren[tagName] = true; });
        }
        this.isVoid = lang_1.normalizeBool(isVoid);
        this.closedByParent = lang_1.normalizeBool(closedByParent) || this.isVoid;
        if (lang_1.isPresent(requiredParents) && requiredParents.length > 0) {
            this.requiredParents = {};
            this.parentToAdd = requiredParents[0];
            requiredParents.forEach(function (tagName) { return _this.requiredParents[tagName] = true; });
        }
        this.implicitNamespacePrefix = implicitNamespacePrefix;
        this.contentType = lang_1.isPresent(contentType) ? contentType : HtmlTagContentType.PARSABLE_DATA;
        this.ignoreFirstLf = lang_1.normalizeBool(ignoreFirstLf);
    }
    HtmlTagDefinition.prototype.requireExtraParent = function (currentParent) {
        if (lang_1.isBlank(this.requiredParents)) {
            return false;
        }
        if (lang_1.isBlank(currentParent)) {
            return true;
        }
        var lcParent = currentParent.toLowerCase();
        return this.requiredParents[lcParent] != true && lcParent != 'template';
    };
    HtmlTagDefinition.prototype.isClosedByChild = function (name) {
        return this.isVoid || lang_1.normalizeBool(this.closedByChildren[name.toLowerCase()]);
    };
    return HtmlTagDefinition;
}());
exports.HtmlTagDefinition = HtmlTagDefinition;
// see http://www.w3.org/TR/html51/syntax.html#optional-tags
// This implementation does not fully conform to the HTML5 spec.
var TAG_DEFINITIONS = {
    'base': new HtmlTagDefinition({ isVoid: true }),
    'meta': new HtmlTagDefinition({ isVoid: true }),
    'area': new HtmlTagDefinition({ isVoid: true }),
    'embed': new HtmlTagDefinition({ isVoid: true }),
    'link': new HtmlTagDefinition({ isVoid: true }),
    'img': new HtmlTagDefinition({ isVoid: true }),
    'input': new HtmlTagDefinition({ isVoid: true }),
    'param': new HtmlTagDefinition({ isVoid: true }),
    'hr': new HtmlTagDefinition({ isVoid: true }),
    'br': new HtmlTagDefinition({ isVoid: true }),
    'source': new HtmlTagDefinition({ isVoid: true }),
    'track': new HtmlTagDefinition({ isVoid: true }),
    'wbr': new HtmlTagDefinition({ isVoid: true }),
    'p': new HtmlTagDefinition({
        closedByChildren: [
            'address',
            'article',
            'aside',
            'blockquote',
            'div',
            'dl',
            'fieldset',
            'footer',
            'form',
            'h1',
            'h2',
            'h3',
            'h4',
            'h5',
            'h6',
            'header',
            'hgroup',
            'hr',
            'main',
            'nav',
            'ol',
            'p',
            'pre',
            'section',
            'table',
            'ul'
        ],
        closedByParent: true
    }),
    'thead': new HtmlTagDefinition({ closedByChildren: ['tbody', 'tfoot'] }),
    'tbody': new HtmlTagDefinition({ closedByChildren: ['tbody', 'tfoot'], closedByParent: true }),
    'tfoot': new HtmlTagDefinition({ closedByChildren: ['tbody'], closedByParent: true }),
    'tr': new HtmlTagDefinition({
        closedByChildren: ['tr'],
        requiredParents: ['tbody', 'tfoot', 'thead'],
        closedByParent: true
    }),
    'td': new HtmlTagDefinition({ closedByChildren: ['td', 'th'], closedByParent: true }),
    'th': new HtmlTagDefinition({ closedByChildren: ['td', 'th'], closedByParent: true }),
    'col': new HtmlTagDefinition({ requiredParents: ['colgroup'], isVoid: true }),
    'svg': new HtmlTagDefinition({ implicitNamespacePrefix: 'svg' }),
    'math': new HtmlTagDefinition({ implicitNamespacePrefix: 'math' }),
    'li': new HtmlTagDefinition({ closedByChildren: ['li'], closedByParent: true }),
    'dt': new HtmlTagDefinition({ closedByChildren: ['dt', 'dd'] }),
    'dd': new HtmlTagDefinition({ closedByChildren: ['dt', 'dd'], closedByParent: true }),
    'rb': new HtmlTagDefinition({ closedByChildren: ['rb', 'rt', 'rtc', 'rp'], closedByParent: true }),
    'rt': new HtmlTagDefinition({ closedByChildren: ['rb', 'rt', 'rtc', 'rp'], closedByParent: true }),
    'rtc': new HtmlTagDefinition({ closedByChildren: ['rb', 'rtc', 'rp'], closedByParent: true }),
    'rp': new HtmlTagDefinition({ closedByChildren: ['rb', 'rt', 'rtc', 'rp'], closedByParent: true }),
    'optgroup': new HtmlTagDefinition({ closedByChildren: ['optgroup'], closedByParent: true }),
    'option': new HtmlTagDefinition({ closedByChildren: ['option', 'optgroup'], closedByParent: true }),
    'pre': new HtmlTagDefinition({ ignoreFirstLf: true }),
    'listing': new HtmlTagDefinition({ ignoreFirstLf: true }),
    'style': new HtmlTagDefinition({ contentType: HtmlTagContentType.RAW_TEXT }),
    'script': new HtmlTagDefinition({ contentType: HtmlTagContentType.RAW_TEXT }),
    'title': new HtmlTagDefinition({ contentType: HtmlTagContentType.ESCAPABLE_RAW_TEXT }),
    'textarea': new HtmlTagDefinition({ contentType: HtmlTagContentType.ESCAPABLE_RAW_TEXT, ignoreFirstLf: true }),
};
var DEFAULT_TAG_DEFINITION = new HtmlTagDefinition();
function getHtmlTagDefinition(tagName) {
    var result = TAG_DEFINITIONS[tagName.toLowerCase()];
    return lang_1.isPresent(result) ? result : DEFAULT_TAG_DEFINITION;
}
exports.getHtmlTagDefinition = getHtmlTagDefinition;
var NS_PREFIX_RE = /^@([^:]+):(.+)/g;
function splitNsName(elementName) {
    if (elementName[0] != '@') {
        return [null, elementName];
    }
    var match = lang_1.RegExpWrapper.firstMatch(NS_PREFIX_RE, elementName);
    return [match[1], match[2]];
}
exports.splitNsName = splitNsName;
function getNsPrefix(elementName) {
    return splitNsName(elementName)[0];
}
exports.getNsPrefix = getNsPrefix;
function mergeNsAndName(prefix, localName) {
    return lang_1.isPresent(prefix) ? "@" + prefix + ":" + localName : localName;
}
exports.mergeNsAndName = mergeNsAndName;
//# sourceMappingURL=data:application/json;base64,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