import { HtmlAst } from 'angular2/src/compiler/html_ast';
/**
 * Expands special forms into elements.
 *
 * For example,
 *
 * ```
 * { messages.length, plural,
 *   =0 {zero}
 *   =1 {one}
 *   =other {more than one}
 * }
 * ```
 *
 * will be expanded into
 *
 * ```
 * <ul [ngPlural]="messages.length">
 *   <template [ngPluralCase]="0"><li i18n="plural_0">zero</li></template>
 *   <template [ngPluralCase]="1"><li i18n="plural_1">one</li></template>
 *   <template [ngPluralCase]="other"><li i18n="plural_other">more than one</li></template>
 * </ul>
 * ```
 */
export declare function expandNodes(nodes: HtmlAst[]): ExpansionResult;
export declare class ExpansionResult {
    nodes: HtmlAst[];
    expanded: boolean;
    constructor(nodes: HtmlAst[], expanded: boolean);
}
