import { assertionsEnabled, isPresent, isBlank } from 'angular2/src/facade/lang';
import { ListWrapper } from 'angular2/src/facade/collection';
import { ChangeDetectionUtil } from './change_detection_util';
import { ChangeDetectorRef_ } from './change_detector_ref';
import { ChangeDetectionError, ExpressionChangedAfterItHasBeenCheckedException, DehydratedException, EventEvaluationErrorContext, EventEvaluationError } from './exceptions';
import { Locals } from './parser/locals';
import { ChangeDetectionStrategy, ChangeDetectorState } from './constants';
import { wtfCreateScope, wtfLeave } from '../profile/profile';
import { isObservable } from './observable_facade';
import { ObservableWrapper } from 'angular2/src/facade/async';
var _scope_check = wtfCreateScope(`ChangeDetector#check(ascii id, bool throwOnChange)`);
class _Context {
    constructor(element, componentElement, context, locals, injector, expression) {
        this.element = element;
        this.componentElement = componentElement;
        this.context = context;
        this.locals = locals;
        this.injector = injector;
        this.expression = expression;
    }
}
export class AbstractChangeDetector {
    constructor(id, numberOfPropertyProtoRecords, bindingTargets, directiveIndices, strategy) {
        this.id = id;
        this.numberOfPropertyProtoRecords = numberOfPropertyProtoRecords;
        this.bindingTargets = bindingTargets;
        this.directiveIndices = directiveIndices;
        this.strategy = strategy;
        this.contentChildren = [];
        this.viewChildren = [];
        // The names of the below fields must be kept in sync with codegen_name_util.ts or
        // change detection will fail.
        this.state = ChangeDetectorState.NeverChecked;
        this.locals = null;
        this.mode = null;
        this.pipes = null;
        this.ref = new ChangeDetectorRef_(this);
    }
    addContentChild(cd) {
        this.contentChildren.push(cd);
        cd.parent = this;
    }
    removeContentChild(cd) { ListWrapper.remove(this.contentChildren, cd); }
    addViewChild(cd) {
        this.viewChildren.push(cd);
        cd.parent = this;
    }
    removeViewChild(cd) { ListWrapper.remove(this.viewChildren, cd); }
    remove() { this.parent.removeContentChild(this); }
    handleEvent(eventName, elIndex, event) {
        if (!this.hydrated()) {
            this.throwDehydratedError();
        }
        try {
            var locals = new Map();
            locals.set('$event', event);
            var res = !this.handleEventInternal(eventName, elIndex, new Locals(this.locals, locals));
            this.markPathToRootAsCheckOnce();
            return res;
        }
        catch (e) {
            var c = this.dispatcher.getDebugContext(null, elIndex, null);
            var context = isPresent(c) ?
                new EventEvaluationErrorContext(c.element, c.componentElement, c.context, c.locals, c.injector) :
                null;
            throw new EventEvaluationError(eventName, e, e.stack, context);
        }
    }
    handleEventInternal(eventName, elIndex, locals) { return false; }
    detectChanges() { this.runDetectChanges(false); }
    checkNoChanges() {
        if (assertionsEnabled()) {
            this.runDetectChanges(true);
        }
    }
    runDetectChanges(throwOnChange) {
        if (this.mode === ChangeDetectionStrategy.Detached ||
            this.mode === ChangeDetectionStrategy.Checked || this.state === ChangeDetectorState.Errored)
            return;
        var s = _scope_check(this.id, throwOnChange);
        this.detectChangesInRecords(throwOnChange);
        this._detectChangesContentChildren(throwOnChange);
        if (!throwOnChange)
            this.afterContentLifecycleCallbacks();
        this._detectChangesInViewChildren(throwOnChange);
        if (!throwOnChange)
            this.afterViewLifecycleCallbacks();
        if (this.mode === ChangeDetectionStrategy.CheckOnce)
            this.mode = ChangeDetectionStrategy.Checked;
        this.state = ChangeDetectorState.CheckedBefore;
        wtfLeave(s);
    }
    // This method is not intended to be overridden. Subclasses should instead provide an
    // implementation of `detectChangesInRecordsInternal` which does the work of detecting changes
    // and which this method will call.
    // This method expects that `detectChangesInRecordsInternal` will set the property
    // `this.propertyBindingIndex` to the propertyBindingIndex of the first proto record. This is to
    // facilitate error reporting.
    detectChangesInRecords(throwOnChange) {
        if (!this.hydrated()) {
            this.throwDehydratedError();
        }
        try {
            this.detectChangesInRecordsInternal(throwOnChange);
        }
        catch (e) {
            // throwOnChange errors aren't counted as fatal errors.
            if (!(e instanceof ExpressionChangedAfterItHasBeenCheckedException)) {
                this.state = ChangeDetectorState.Errored;
            }
            this._throwError(e, e.stack);
        }
    }
    // Subclasses should override this method to perform any work necessary to detect and report
    // changes. For example, changes should be reported via `ChangeDetectionUtil.addChange`, lifecycle
    // methods should be called, etc.
    // This implementation should also set `this.propertyBindingIndex` to the propertyBindingIndex of
    // the
    // first proto record to facilitate error reporting. See {@link #detectChangesInRecords}.
    detectChangesInRecordsInternal(throwOnChange) { }
    // This method is not intended to be overridden. Subclasses should instead provide an
    // implementation of `hydrateDirectives`.
    hydrate(context, locals, dispatcher, pipes) {
        this.dispatcher = dispatcher;
        this.mode = ChangeDetectionUtil.changeDetectionMode(this.strategy);
        this.context = context;
        if (this.strategy === ChangeDetectionStrategy.OnPushObserve) {
            this.observeComponent(context);
        }
        this.locals = locals;
        this.pipes = pipes;
        this.hydrateDirectives(dispatcher);
        this.state = ChangeDetectorState.NeverChecked;
    }
    // Subclasses should override this method to hydrate any directives.
    hydrateDirectives(dispatcher) { }
    // This method is not intended to be overridden. Subclasses should instead provide an
    // implementation of `dehydrateDirectives`.
    dehydrate() {
        this.dehydrateDirectives(true);
        // This is an experimental feature. Works only in Dart.
        if (this.strategy === ChangeDetectionStrategy.OnPushObserve) {
            this._unsubsribeFromObservables();
        }
        this._unsubscribeFromOutputs();
        this.dispatcher = null;
        this.context = null;
        this.locals = null;
        this.pipes = null;
    }
    // Subclasses should override this method to dehydrate any directives. This method should reverse
    // any work done in `hydrateDirectives`.
    dehydrateDirectives(destroyPipes) { }
    hydrated() { return isPresent(this.context); }
    destroyRecursive() {
        this.dispatcher.notifyOnDestroy();
        this.dehydrate();
        var children = this.contentChildren;
        for (var i = 0; i < children.length; i++) {
            children[i].destroyRecursive();
        }
        children = this.viewChildren;
        for (var i = 0; i < children.length; i++) {
            children[i].destroyRecursive();
        }
    }
    afterContentLifecycleCallbacks() {
        this.dispatcher.notifyAfterContentChecked();
        this.afterContentLifecycleCallbacksInternal();
    }
    afterContentLifecycleCallbacksInternal() { }
    afterViewLifecycleCallbacks() {
        this.dispatcher.notifyAfterViewChecked();
        this.afterViewLifecycleCallbacksInternal();
    }
    afterViewLifecycleCallbacksInternal() { }
    /** @internal */
    _detectChangesContentChildren(throwOnChange) {
        var c = this.contentChildren;
        for (var i = 0; i < c.length; ++i) {
            c[i].runDetectChanges(throwOnChange);
        }
    }
    /** @internal */
    _detectChangesInViewChildren(throwOnChange) {
        var c = this.viewChildren;
        for (var i = 0; i < c.length; ++i) {
            c[i].runDetectChanges(throwOnChange);
        }
    }
    markAsCheckOnce() { this.mode = ChangeDetectionStrategy.CheckOnce; }
    markPathToRootAsCheckOnce() {
        var c = this;
        while (isPresent(c) && c.mode !== ChangeDetectionStrategy.Detached) {
            if (c.mode === ChangeDetectionStrategy.Checked)
                c.mode = ChangeDetectionStrategy.CheckOnce;
            c = c.parent;
        }
    }
    // This is an experimental feature. Works only in Dart.
    _unsubsribeFromObservables() {
        if (isPresent(this.subscriptions)) {
            for (var i = 0; i < this.subscriptions.length; ++i) {
                var s = this.subscriptions[i];
                if (isPresent(this.subscriptions[i])) {
                    s.cancel();
                    this.subscriptions[i] = null;
                }
            }
        }
    }
    _unsubscribeFromOutputs() {
        if (isPresent(this.outputSubscriptions)) {
            for (var i = 0; i < this.outputSubscriptions.length; ++i) {
                ObservableWrapper.dispose(this.outputSubscriptions[i]);
                this.outputSubscriptions[i] = null;
            }
        }
    }
    // This is an experimental feature. Works only in Dart.
    observeValue(value, index) {
        if (isObservable(value)) {
            this._createArrayToStoreObservables();
            if (isBlank(this.subscriptions[index])) {
                this.streams[index] = value.changes;
                this.subscriptions[index] = value.changes.listen((_) => this.ref.markForCheck());
            }
            else if (this.streams[index] !== value.changes) {
                this.subscriptions[index].cancel();
                this.streams[index] = value.changes;
                this.subscriptions[index] = value.changes.listen((_) => this.ref.markForCheck());
            }
        }
        return value;
    }
    // This is an experimental feature. Works only in Dart.
    observeDirective(value, index) {
        if (isObservable(value)) {
            this._createArrayToStoreObservables();
            var arrayIndex = this.numberOfPropertyProtoRecords + index + 2; // +1 is component
            this.streams[arrayIndex] = value.changes;
            this.subscriptions[arrayIndex] = value.changes.listen((_) => this.ref.markForCheck());
        }
        return value;
    }
    // This is an experimental feature. Works only in Dart.
    observeComponent(value) {
        if (isObservable(value)) {
            this._createArrayToStoreObservables();
            var index = this.numberOfPropertyProtoRecords + 1;
            this.streams[index] = value.changes;
            this.subscriptions[index] = value.changes.listen((_) => this.ref.markForCheck());
        }
        return value;
    }
    _createArrayToStoreObservables() {
        if (isBlank(this.subscriptions)) {
            this.subscriptions = ListWrapper.createFixedSize(this.numberOfPropertyProtoRecords +
                this.directiveIndices.length + 2);
            this.streams = ListWrapper.createFixedSize(this.numberOfPropertyProtoRecords +
                this.directiveIndices.length + 2);
        }
    }
    getDirectiveFor(directives, index) {
        return directives.getDirectiveFor(this.directiveIndices[index]);
    }
    getDetectorFor(directives, index) {
        return directives.getDetectorFor(this.directiveIndices[index]);
    }
    notifyDispatcher(value) {
        this.dispatcher.notifyOnBinding(this._currentBinding(), value);
    }
    logBindingUpdate(value) {
        this.dispatcher.logBindingUpdate(this._currentBinding(), value);
    }
    addChange(changes, oldValue, newValue) {
        if (isBlank(changes)) {
            changes = {};
        }
        changes[this._currentBinding().name] = ChangeDetectionUtil.simpleChange(oldValue, newValue);
        return changes;
    }
    _throwError(exception, stack) {
        var error;
        try {
            var c = this.dispatcher.getDebugContext(null, this._currentBinding().elementIndex, null);
            var context = isPresent(c) ? new _Context(c.element, c.componentElement, c.context, c.locals, c.injector, this._currentBinding().debug) :
                null;
            error = new ChangeDetectionError(this._currentBinding().debug, exception, stack, context);
        }
        catch (e) {
            // if an error happens during getting the debug context, we throw a ChangeDetectionError
            // without the extra information.
            error = new ChangeDetectionError(null, exception, stack, null);
        }
        throw error;
    }
    throwOnChangeError(oldValue, newValue) {
        throw new ExpressionChangedAfterItHasBeenCheckedException(this._currentBinding().debug, oldValue, newValue, null);
    }
    throwDehydratedError() { throw new DehydratedException(); }
    _currentBinding() {
        return this.bindingTargets[this.propertyBindingIndex];
    }
}
//# sourceMappingURL=data:application/json;base64,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