var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { CONST_EXPR, isPresent, NumberWrapper } from 'angular2/src/facade/lang';
import { Map } from 'angular2/src/facade/collection';
import { Injectable, Provider } from 'angular2/src/core/di';
import { AppViewListener } from 'angular2/src/core/linker/view_listener';
import { DOM } from 'angular2/src/platform/dom/dom_adapter';
import { DebugElement_ } from 'angular2/src/core/debug/debug_element';
const NG_ID_PROPERTY = 'ngid';
const INSPECT_GLOBAL_NAME = 'ng.probe';
const NG_ID_SEPARATOR = '#';
// Need to keep the views in a global Map so that multiple angular apps are supported
var _allIdsByView = new Map();
var _allViewsById = new Map();
var _nextId = 0;
function _setElementId(element, indices) {
    if (isPresent(element) && DOM.isElementNode(element)) {
        DOM.setData(element, NG_ID_PROPERTY, indices.join(NG_ID_SEPARATOR));
    }
}
function _getElementId(element) {
    var elId = DOM.getData(element, NG_ID_PROPERTY);
    if (isPresent(elId)) {
        return elId.split(NG_ID_SEPARATOR).map(partStr => NumberWrapper.parseInt(partStr, 10));
    }
    else {
        return null;
    }
}
/**
 * Returns a {@link DebugElement} for the given native DOM element, or
 * null if the given native element does not have an Angular view associated
 * with it.
 */
export function inspectNativeElement(element) {
    var elId = _getElementId(element);
    if (isPresent(elId)) {
        var view = _allViewsById.get(elId[0]);
        if (isPresent(view)) {
            return new DebugElement_(view.appElements[elId[1]]);
        }
    }
    return null;
}
export let DebugElementViewListener = class {
    constructor() {
        DOM.setGlobalVar(INSPECT_GLOBAL_NAME, inspectNativeElement);
    }
    onViewCreated(view) {
        var viewId = _nextId++;
        _allViewsById.set(viewId, view);
        _allIdsByView.set(view, viewId);
        for (var i = 0; i < view.appElements.length; i++) {
            var el = view.appElements[i];
            _setElementId(el.nativeElement, [viewId, i]);
        }
    }
    onViewDestroyed(view) {
        var viewId = _allIdsByView.get(view);
        _allIdsByView.delete(view);
        _allViewsById.delete(viewId);
    }
};
DebugElementViewListener = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [])
], DebugElementViewListener);
/**
 * Providers which support debugging Angular applications (e.g. via `ng.probe`).
 *
 * ## Example
 *
 * {@example platform/dom/debug/ts/debug_element_view_listener/providers.ts region='providers'}
 */
export const ELEMENT_PROBE_PROVIDERS = CONST_EXPR([
    DebugElementViewListener,
    CONST_EXPR(new Provider(AppViewListener, { useExisting: DebugElementViewListener })),
]);
/**
 * Use {@link ELEMENT_PROBE_PROVIDERS}.
 *
 * @deprecated
 */
export const ELEMENT_PROBE_BINDINGS = ELEMENT_PROBE_PROVIDERS;
//# sourceMappingURL=data:application/json;base64,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