'use strict';var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var di_1 = require('angular2/src/core/di');
var animation_builder_1 = require('angular2/src/animate/animation_builder');
var lang_1 = require('angular2/src/facade/lang');
var exceptions_1 = require('angular2/src/facade/exceptions');
var shared_styles_host_1 = require('./shared_styles_host');
var event_manager_1 = require('./events/event_manager');
var dom_tokens_1 = require('./dom_tokens');
var metadata_1 = require('angular2/src/core/metadata');
var dom_adapter_1 = require('angular2/src/platform/dom/dom_adapter');
var util_1 = require('./util');
var NAMESPACE_URIS = lang_1.CONST_EXPR({ 'xlink': 'http://www.w3.org/1999/xlink', 'svg': 'http://www.w3.org/2000/svg' });
var TEMPLATE_COMMENT_TEXT = 'template bindings={}';
var TEMPLATE_BINDINGS_EXP = /^template bindings=(.*)$/g;
var DomRootRenderer = (function () {
    function DomRootRenderer(document, eventManager, sharedStylesHost, animate) {
        this.document = document;
        this.eventManager = eventManager;
        this.sharedStylesHost = sharedStylesHost;
        this.animate = animate;
        this._registeredComponents = new Map();
    }
    DomRootRenderer.prototype.renderComponent = function (componentProto) {
        var renderer = this._registeredComponents.get(componentProto.id);
        if (lang_1.isBlank(renderer)) {
            renderer = new DomRenderer(this, componentProto);
            this._registeredComponents.set(componentProto.id, renderer);
        }
        return renderer;
    };
    return DomRootRenderer;
})();
exports.DomRootRenderer = DomRootRenderer;
var DomRootRenderer_ = (function (_super) {
    __extends(DomRootRenderer_, _super);
    function DomRootRenderer_(_document, _eventManager, sharedStylesHost, animate) {
        _super.call(this, _document, _eventManager, sharedStylesHost, animate);
    }
    DomRootRenderer_ = __decorate([
        di_1.Injectable(),
        __param(0, di_1.Inject(dom_tokens_1.DOCUMENT)), 
        __metadata('design:paramtypes', [Object, event_manager_1.EventManager, shared_styles_host_1.DomSharedStylesHost, animation_builder_1.AnimationBuilder])
    ], DomRootRenderer_);
    return DomRootRenderer_;
})(DomRootRenderer);
exports.DomRootRenderer_ = DomRootRenderer_;
var DomRenderer = (function () {
    function DomRenderer(_rootRenderer, componentProto) {
        this._rootRenderer = _rootRenderer;
        this.componentProto = componentProto;
        this._styles = _flattenStyles(componentProto.id, componentProto.styles, []);
        if (componentProto.encapsulation !== metadata_1.ViewEncapsulation.Native) {
            this._rootRenderer.sharedStylesHost.addStyles(this._styles);
        }
        if (this.componentProto.encapsulation === metadata_1.ViewEncapsulation.Emulated) {
            this._contentAttr = _shimContentAttribute(componentProto.id);
            this._hostAttr = _shimHostAttribute(componentProto.id);
        }
        else {
            this._contentAttr = null;
            this._hostAttr = null;
        }
    }
    DomRenderer.prototype.renderComponent = function (componentProto) {
        return this._rootRenderer.renderComponent(componentProto);
    };
    DomRenderer.prototype.selectRootElement = function (selector) {
        var el = dom_adapter_1.DOM.querySelector(this._rootRenderer.document, selector);
        if (lang_1.isBlank(el)) {
            throw new exceptions_1.BaseException("The selector \"" + selector + "\" did not match any elements");
        }
        dom_adapter_1.DOM.clearNodes(el);
        return el;
    };
    DomRenderer.prototype.createElement = function (parent, name) {
        var nsAndName = splitNamespace(name);
        var el = lang_1.isPresent(nsAndName[0]) ?
            dom_adapter_1.DOM.createElementNS(NAMESPACE_URIS[nsAndName[0]], nsAndName[1]) :
            dom_adapter_1.DOM.createElement(nsAndName[1]);
        if (lang_1.isPresent(this._contentAttr)) {
            dom_adapter_1.DOM.setAttribute(el, this._contentAttr, '');
        }
        if (lang_1.isPresent(parent)) {
            dom_adapter_1.DOM.appendChild(parent, el);
        }
        return el;
    };
    DomRenderer.prototype.createViewRoot = function (hostElement) {
        var nodesParent;
        if (this.componentProto.encapsulation === metadata_1.ViewEncapsulation.Native) {
            nodesParent = dom_adapter_1.DOM.createShadowRoot(hostElement);
            this._rootRenderer.sharedStylesHost.addHost(nodesParent);
            for (var i = 0; i < this._styles.length; i++) {
                dom_adapter_1.DOM.appendChild(nodesParent, dom_adapter_1.DOM.createStyleElement(this._styles[i]));
            }
        }
        else {
            if (lang_1.isPresent(this._hostAttr)) {
                dom_adapter_1.DOM.setAttribute(hostElement, this._hostAttr, '');
            }
            nodesParent = hostElement;
        }
        return nodesParent;
    };
    DomRenderer.prototype.createTemplateAnchor = function (parentElement) {
        var comment = dom_adapter_1.DOM.createComment(TEMPLATE_COMMENT_TEXT);
        if (lang_1.isPresent(parentElement)) {
            dom_adapter_1.DOM.appendChild(parentElement, comment);
        }
        return comment;
    };
    DomRenderer.prototype.createText = function (parentElement, value) {
        var node = dom_adapter_1.DOM.createTextNode(value);
        if (lang_1.isPresent(parentElement)) {
            dom_adapter_1.DOM.appendChild(parentElement, node);
        }
        return node;
    };
    DomRenderer.prototype.projectNodes = function (parentElement, nodes) {
        if (lang_1.isBlank(parentElement))
            return;
        appendNodes(parentElement, nodes);
    };
    DomRenderer.prototype.attachViewAfter = function (node, viewRootNodes) {
        moveNodesAfterSibling(node, viewRootNodes);
        for (var i = 0; i < viewRootNodes.length; i++)
            this.animateNodeEnter(viewRootNodes[i]);
    };
    DomRenderer.prototype.detachView = function (viewRootNodes) {
        for (var i = 0; i < viewRootNodes.length; i++) {
            var node = viewRootNodes[i];
            dom_adapter_1.DOM.remove(node);
            this.animateNodeLeave(node);
        }
    };
    DomRenderer.prototype.destroyView = function (hostElement, viewAllNodes) {
        if (this.componentProto.encapsulation === metadata_1.ViewEncapsulation.Native && lang_1.isPresent(hostElement)) {
            this._rootRenderer.sharedStylesHost.removeHost(dom_adapter_1.DOM.getShadowRoot(hostElement));
        }
    };
    DomRenderer.prototype.listen = function (renderElement, name, callback) {
        return this._rootRenderer.eventManager.addEventListener(renderElement, name, decoratePreventDefault(callback));
    };
    DomRenderer.prototype.listenGlobal = function (target, name, callback) {
        return this._rootRenderer.eventManager.addGlobalEventListener(target, name, decoratePreventDefault(callback));
    };
    DomRenderer.prototype.setElementProperty = function (renderElement, propertyName, propertyValue) {
        dom_adapter_1.DOM.setProperty(renderElement, propertyName, propertyValue);
    };
    DomRenderer.prototype.setElementAttribute = function (renderElement, attributeName, attributeValue) {
        var attrNs;
        var nsAndName = splitNamespace(attributeName);
        if (lang_1.isPresent(nsAndName[0])) {
            attributeName = nsAndName[0] + ':' + nsAndName[1];
            attrNs = NAMESPACE_URIS[nsAndName[0]];
        }
        if (lang_1.isPresent(attributeValue)) {
            if (lang_1.isPresent(attrNs)) {
                dom_adapter_1.DOM.setAttributeNS(renderElement, attrNs, attributeName, attributeValue);
            }
            else {
                dom_adapter_1.DOM.setAttribute(renderElement, nsAndName[1], attributeValue);
            }
        }
        else {
            dom_adapter_1.DOM.removeAttribute(renderElement, attributeName);
        }
    };
    DomRenderer.prototype.setBindingDebugInfo = function (renderElement, propertyName, propertyValue) {
        var dashCasedPropertyName = util_1.camelCaseToDashCase(propertyName);
        if (dom_adapter_1.DOM.isCommentNode(renderElement)) {
            var existingBindings = lang_1.RegExpWrapper.firstMatch(TEMPLATE_BINDINGS_EXP, lang_1.StringWrapper.replaceAll(dom_adapter_1.DOM.getText(renderElement), /\n/g, ''));
            var parsedBindings = lang_1.Json.parse(existingBindings[1]);
            parsedBindings[dashCasedPropertyName] = propertyValue;
            dom_adapter_1.DOM.setText(renderElement, lang_1.StringWrapper.replace(TEMPLATE_COMMENT_TEXT, '{}', lang_1.Json.stringify(parsedBindings)));
        }
        else {
            this.setElementAttribute(renderElement, propertyName, propertyValue);
        }
    };
    DomRenderer.prototype.setElementClass = function (renderElement, className, isAdd) {
        if (isAdd) {
            dom_adapter_1.DOM.addClass(renderElement, className);
        }
        else {
            dom_adapter_1.DOM.removeClass(renderElement, className);
        }
    };
    DomRenderer.prototype.setElementStyle = function (renderElement, styleName, styleValue) {
        if (lang_1.isPresent(styleValue)) {
            dom_adapter_1.DOM.setStyle(renderElement, styleName, lang_1.stringify(styleValue));
        }
        else {
            dom_adapter_1.DOM.removeStyle(renderElement, styleName);
        }
    };
    DomRenderer.prototype.invokeElementMethod = function (renderElement, methodName, args) {
        dom_adapter_1.DOM.invoke(renderElement, methodName, args);
    };
    DomRenderer.prototype.setText = function (renderNode, text) { dom_adapter_1.DOM.setText(renderNode, text); };
    /**
     * Performs animations if necessary
     * @param node
     */
    DomRenderer.prototype.animateNodeEnter = function (node) {
        if (dom_adapter_1.DOM.isElementNode(node) && dom_adapter_1.DOM.hasClass(node, 'ng-animate')) {
            dom_adapter_1.DOM.addClass(node, 'ng-enter');
            this._rootRenderer.animate.css()
                .addAnimationClass('ng-enter-active')
                .start(node)
                .onComplete(function () { dom_adapter_1.DOM.removeClass(node, 'ng-enter'); });
        }
    };
    /**
     * If animations are necessary, performs animations then removes the element; otherwise, it just
     * removes the element.
     * @param node
     */
    DomRenderer.prototype.animateNodeLeave = function (node) {
        if (dom_adapter_1.DOM.isElementNode(node) && dom_adapter_1.DOM.hasClass(node, 'ng-animate')) {
            dom_adapter_1.DOM.addClass(node, 'ng-leave');
            this._rootRenderer.animate.css()
                .addAnimationClass('ng-leave-active')
                .start(node)
                .onComplete(function () {
                dom_adapter_1.DOM.removeClass(node, 'ng-leave');
                dom_adapter_1.DOM.remove(node);
            });
        }
        else {
            dom_adapter_1.DOM.remove(node);
        }
    };
    return DomRenderer;
})();
exports.DomRenderer = DomRenderer;
function moveNodesAfterSibling(sibling, nodes) {
    var parent = dom_adapter_1.DOM.parentElement(sibling);
    if (nodes.length > 0 && lang_1.isPresent(parent)) {
        var nextSibling = dom_adapter_1.DOM.nextSibling(sibling);
        if (lang_1.isPresent(nextSibling)) {
            for (var i = 0; i < nodes.length; i++) {
                dom_adapter_1.DOM.insertBefore(nextSibling, nodes[i]);
            }
        }
        else {
            for (var i = 0; i < nodes.length; i++) {
                dom_adapter_1.DOM.appendChild(parent, nodes[i]);
            }
        }
    }
}
function appendNodes(parent, nodes) {
    for (var i = 0; i < nodes.length; i++) {
        dom_adapter_1.DOM.appendChild(parent, nodes[i]);
    }
}
function decoratePreventDefault(eventHandler) {
    return function (event) {
        var allowDefaultBehavior = eventHandler(event);
        if (allowDefaultBehavior === false) {
            // TODO(tbosch): move preventDefault into event plugins...
            dom_adapter_1.DOM.preventDefault(event);
        }
    };
}
var COMPONENT_REGEX = /%COMP%/g;
exports.COMPONENT_VARIABLE = '%COMP%';
exports.HOST_ATTR = "_nghost-" + exports.COMPONENT_VARIABLE;
exports.CONTENT_ATTR = "_ngcontent-" + exports.COMPONENT_VARIABLE;
function _shimContentAttribute(componentShortId) {
    return lang_1.StringWrapper.replaceAll(exports.CONTENT_ATTR, COMPONENT_REGEX, componentShortId);
}
function _shimHostAttribute(componentShortId) {
    return lang_1.StringWrapper.replaceAll(exports.HOST_ATTR, COMPONENT_REGEX, componentShortId);
}
function _flattenStyles(compId, styles, target) {
    for (var i = 0; i < styles.length; i++) {
        var style = styles[i];
        if (lang_1.isArray(style)) {
            _flattenStyles(compId, style, target);
        }
        else {
            style = lang_1.StringWrapper.replaceAll(style, COMPONENT_REGEX, compId);
            target.push(style);
        }
    }
    return target;
}
var NS_PREFIX_RE = /^@([^:]+):(.+)/g;
function splitNamespace(name) {
    if (name[0] != '@') {
        return [null, name];
    }
    var match = lang_1.RegExpWrapper.firstMatch(NS_PREFIX_RE, name);
    return [match[1], match[2]];
}
//# sourceMappingURL=data:application/json;base64,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