var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { ListWrapper, MapWrapper, Map, StringMapWrapper } from 'angular2/src/facade/collection';
import { Locals } from 'angular2/src/core/change_detection/change_detection';
import { DebugContext } from 'angular2/src/core/change_detection/interfaces';
import { AppElement } from './element';
import { isPresent, isBlank, CONST, CONST_EXPR } from 'angular2/src/facade/lang';
import { BaseException } from 'angular2/src/facade/exceptions';
import { RenderDebugInfo } from 'angular2/src/core/render/api';
import { ViewRef_ } from './view_ref';
import { ProtoPipes } from 'angular2/src/core/pipes/pipes';
import { camelCaseToDashCase } from 'angular2/src/core/render/util';
export { DebugContext } from 'angular2/src/core/change_detection/interfaces';
import { Pipes } from 'angular2/src/core/pipes/pipes';
import { ViewType } from './view_type';
const REFLECT_PREFIX = 'ng-reflect-';
const EMPTY_CONTEXT = CONST_EXPR(new Object());
/**
 * Cost of making objects: http://jsperf.com/instantiate-size-of-object
 *
 */
export class AppView {
    constructor(proto, renderer, viewManager, projectableNodes, containerAppElement, imperativelyCreatedProviders, rootInjector, changeDetector) {
        this.proto = proto;
        this.renderer = renderer;
        this.viewManager = viewManager;
        this.projectableNodes = projectableNodes;
        this.containerAppElement = containerAppElement;
        this.changeDetector = changeDetector;
        /**
         * The context against which data-binding expressions in this view are evaluated against.
         * This is always a component instance.
         */
        this.context = null;
        this.destroyed = false;
        this.ref = new ViewRef_(this);
        var injectorWithHostBoundary = AppElement.getViewParentInjector(this.proto.type, containerAppElement, imperativelyCreatedProviders, rootInjector);
        this.parentInjector = injectorWithHostBoundary.injector;
        this.hostInjectorBoundary = injectorWithHostBoundary.hostInjectorBoundary;
        var pipes;
        var context;
        switch (proto.type) {
            case ViewType.COMPONENT:
                pipes = new Pipes(proto.protoPipes, containerAppElement.getInjector());
                context = containerAppElement.getComponent();
                break;
            case ViewType.EMBEDDED:
                pipes = containerAppElement.parentView.pipes;
                context = containerAppElement.parentView.context;
                break;
            case ViewType.HOST:
                pipes = null;
                context = EMPTY_CONTEXT;
                break;
        }
        this.pipes = pipes;
        this.context = context;
    }
    init(rootNodesOrAppElements, allNodes, disposables, appElements) {
        this.rootNodesOrAppElements = rootNodesOrAppElements;
        this.allNodes = allNodes;
        this.disposables = disposables;
        this.appElements = appElements;
        var localsMap = new Map();
        StringMapWrapper.forEach(this.proto.templateVariableBindings, (templateName, _) => { localsMap.set(templateName, null); });
        for (var i = 0; i < appElements.length; i++) {
            var appEl = appElements[i];
            var providerTokens = [];
            if (isPresent(appEl.proto.protoInjector)) {
                for (var j = 0; j < appEl.proto.protoInjector.numberOfProviders; j++) {
                    providerTokens.push(appEl.proto.protoInjector.getProviderAtIndex(j).key.token);
                }
            }
            StringMapWrapper.forEach(appEl.proto.directiveVariableBindings, (directiveIndex, name) => {
                if (isBlank(directiveIndex)) {
                    localsMap.set(name, appEl.nativeElement);
                }
                else {
                    localsMap.set(name, appEl.getDirectiveAtIndex(directiveIndex));
                }
            });
            this.renderer.setElementDebugInfo(appEl.nativeElement, new RenderDebugInfo(appEl.getInjector(), appEl.getComponent(), providerTokens, localsMap));
        }
        var parentLocals = null;
        if (this.proto.type !== ViewType.COMPONENT) {
            parentLocals =
                isPresent(this.containerAppElement) ? this.containerAppElement.parentView.locals : null;
        }
        if (this.proto.type === ViewType.COMPONENT) {
            // Note: the render nodes have been attached to their host element
            // in the ViewFactory already.
            this.containerAppElement.attachComponentView(this);
            this.containerAppElement.parentView.changeDetector.addViewChild(this.changeDetector);
        }
        this.locals = new Locals(parentLocals, localsMap);
        this.changeDetector.hydrate(this.context, this.locals, this, this.pipes);
        this.viewManager.onViewCreated(this);
    }
    destroy() {
        if (this.destroyed) {
            throw new BaseException('This view has already been destroyed!');
        }
        this.changeDetector.destroyRecursive();
    }
    notifyOnDestroy() {
        this.destroyed = true;
        var hostElement = this.proto.type === ViewType.COMPONENT ? this.containerAppElement.nativeElement : null;
        this.renderer.destroyView(hostElement, this.allNodes);
        for (var i = 0; i < this.disposables.length; i++) {
            this.disposables[i]();
        }
        this.viewManager.onViewDestroyed(this);
    }
    get changeDetectorRef() { return this.changeDetector.ref; }
    get flatRootNodes() { return flattenNestedViewRenderNodes(this.rootNodesOrAppElements); }
    hasLocal(contextName) {
        return StringMapWrapper.contains(this.proto.templateVariableBindings, contextName);
    }
    setLocal(contextName, value) {
        if (!this.hasLocal(contextName)) {
            return;
        }
        var templateName = this.proto.templateVariableBindings[contextName];
        this.locals.set(templateName, value);
    }
    // dispatch to element injector or text nodes based on context
    notifyOnBinding(b, currentValue) {
        if (b.isTextNode()) {
            this.renderer.setText(this.allNodes[b.elementIndex], currentValue);
        }
        else {
            var nativeElement = this.appElements[b.elementIndex].nativeElement;
            if (b.isElementProperty()) {
                this.renderer.setElementProperty(nativeElement, b.name, currentValue);
            }
            else if (b.isElementAttribute()) {
                this.renderer.setElementAttribute(nativeElement, b.name, isPresent(currentValue) ? `${currentValue}` : null);
            }
            else if (b.isElementClass()) {
                this.renderer.setElementClass(nativeElement, b.name, currentValue);
            }
            else if (b.isElementStyle()) {
                var unit = isPresent(b.unit) ? b.unit : '';
                this.renderer.setElementStyle(nativeElement, b.name, isPresent(currentValue) ? `${currentValue}${unit}` : null);
            }
            else {
                throw new BaseException('Unsupported directive record');
            }
        }
    }
    logBindingUpdate(b, value) {
        if (b.isDirective() || b.isElementProperty()) {
            var nativeElement = this.appElements[b.elementIndex].nativeElement;
            this.renderer.setBindingDebugInfo(nativeElement, `${REFLECT_PREFIX}${camelCaseToDashCase(b.name)}`, `${value}`);
        }
    }
    notifyAfterContentChecked() {
        var count = this.appElements.length;
        for (var i = count - 1; i >= 0; i--) {
            this.appElements[i].ngAfterContentChecked();
        }
    }
    notifyAfterViewChecked() {
        var count = this.appElements.length;
        for (var i = count - 1; i >= 0; i--) {
            this.appElements[i].ngAfterViewChecked();
        }
    }
    getDebugContext(appElement, elementIndex, directiveIndex) {
        try {
            if (isBlank(appElement) && elementIndex < this.appElements.length) {
                appElement = this.appElements[elementIndex];
            }
            var container = this.containerAppElement;
            var element = isPresent(appElement) ? appElement.nativeElement : null;
            var componentElement = isPresent(container) ? container.nativeElement : null;
            var directive = isPresent(directiveIndex) ? appElement.getDirectiveAtIndex(directiveIndex) : null;
            var injector = isPresent(appElement) ? appElement.getInjector() : null;
            return new DebugContext(element, componentElement, directive, this.context, _localsToStringMap(this.locals), injector);
        }
        catch (e) {
            // TODO: vsavkin log the exception once we have a good way to log errors and warnings
            // if an error happens during getting the debug context, we return null.
            return null;
        }
    }
    getDirectiveFor(directive) {
        return this.appElements[directive.elementIndex].getDirectiveAtIndex(directive.directiveIndex);
    }
    getDetectorFor(directive) {
        var componentView = this.appElements[directive.elementIndex].componentView;
        return isPresent(componentView) ? componentView.changeDetector : null;
    }
    /**
     * Triggers the event handlers for the element and the directives.
     *
     * This method is intended to be called from directive EventEmitters.
     *
     * @param {string} eventName
     * @param {*} eventObj
     * @param {number} boundElementIndex
     * @return false if preventDefault must be applied to the DOM event
     */
    triggerEventHandlers(eventName, eventObj, boundElementIndex) {
        return this.changeDetector.handleEvent(eventName, boundElementIndex, eventObj);
    }
}
function _localsToStringMap(locals) {
    var res = {};
    var c = locals;
    while (isPresent(c)) {
        res = StringMapWrapper.merge(res, MapWrapper.toStringMap(c.current));
        c = c.parent;
    }
    return res;
}
/**
 *
 */
export class AppProtoView {
    constructor(type, protoPipes, templateVariableBindings) {
        this.type = type;
        this.protoPipes = protoPipes;
        this.templateVariableBindings = templateVariableBindings;
    }
    static create(metadataCache, type, pipes, templateVariableBindings) {
        var protoPipes = null;
        if (isPresent(pipes) && pipes.length > 0) {
            var boundPipes = ListWrapper.createFixedSize(pipes.length);
            for (var i = 0; i < pipes.length; i++) {
                boundPipes[i] = metadataCache.getResolvedPipeMetadata(pipes[i]);
            }
            protoPipes = ProtoPipes.fromProviders(boundPipes);
        }
        return new AppProtoView(type, protoPipes, templateVariableBindings);
    }
}
export let HostViewFactory = class {
    constructor(selector, viewFactory) {
        this.selector = selector;
        this.viewFactory = viewFactory;
    }
};
HostViewFactory = __decorate([
    CONST(), 
    __metadata('design:paramtypes', [String, Function])
], HostViewFactory);
export function flattenNestedViewRenderNodes(nodes) {
    return _flattenNestedViewRenderNodes(nodes, []);
}
function _flattenNestedViewRenderNodes(nodes, renderNodes) {
    for (var i = 0; i < nodes.length; i++) {
        var node = nodes[i];
        if (node instanceof AppElement) {
            var appEl = node;
            renderNodes.push(appEl.nativeElement);
            if (isPresent(appEl.nestedViews)) {
                for (var k = 0; k < appEl.nestedViews.length; k++) {
                    _flattenNestedViewRenderNodes(appEl.nestedViews[k].rootNodesOrAppElements, renderNodes);
                }
            }
        }
        else {
            renderNodes.push(node);
        }
    }
    return renderNodes;
}
export function checkSlotCount(componentName, expectedSlotCount, projectableNodes) {
    var givenSlotCount = isPresent(projectableNodes) ? projectableNodes.length : 0;
    if (givenSlotCount < expectedSlotCount) {
        throw new BaseException(`The component ${componentName} has ${expectedSlotCount} <ng-content> elements,` +
            ` but only ${givenSlotCount} slots were provided.`);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmlldy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFuZ3VsYXIyL3NyYy9jb3JlL2xpbmtlci92aWV3LnRzIl0sIm5hbWVzIjpbIkFwcFZpZXciLCJBcHBWaWV3LmNvbnN0cnVjdG9yIiwiQXBwVmlldy5pbml0IiwiQXBwVmlldy5kZXN0cm95IiwiQXBwVmlldy5ub3RpZnlPbkRlc3Ryb3kiLCJBcHBWaWV3LmNoYW5nZURldGVjdG9yUmVmIiwiQXBwVmlldy5mbGF0Um9vdE5vZGVzIiwiQXBwVmlldy5oYXNMb2NhbCIsIkFwcFZpZXcuc2V0TG9jYWwiLCJBcHBWaWV3Lm5vdGlmeU9uQmluZGluZyIsIkFwcFZpZXcubG9nQmluZGluZ1VwZGF0ZSIsIkFwcFZpZXcubm90aWZ5QWZ0ZXJDb250ZW50Q2hlY2tlZCIsIkFwcFZpZXcubm90aWZ5QWZ0ZXJWaWV3Q2hlY2tlZCIsIkFwcFZpZXcuZ2V0RGVidWdDb250ZXh0IiwiQXBwVmlldy5nZXREaXJlY3RpdmVGb3IiLCJBcHBWaWV3LmdldERldGVjdG9yRm9yIiwiQXBwVmlldy50cmlnZ2VyRXZlbnRIYW5kbGVycyIsIl9sb2NhbHNUb1N0cmluZ01hcCIsIkFwcFByb3RvVmlldyIsIkFwcFByb3RvVmlldy5jb25zdHJ1Y3RvciIsIkFwcFByb3RvVmlldy5jcmVhdGUiLCJIb3N0Vmlld0ZhY3RvcnkiLCJIb3N0Vmlld0ZhY3RvcnkuY29uc3RydWN0b3IiLCJmbGF0dGVuTmVzdGVkVmlld1JlbmRlck5vZGVzIiwiX2ZsYXR0ZW5OZXN0ZWRWaWV3UmVuZGVyTm9kZXMiLCJjaGVja1Nsb3RDb3VudCJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7O09BQU8sRUFDTCxXQUFXLEVBQ1gsVUFBVSxFQUNWLEdBQUcsRUFDSCxnQkFBZ0IsRUFDakIsTUFBTSxnQ0FBZ0M7T0FDaEMsRUFLTCxNQUFNLEVBR1AsTUFBTSxxREFBcUQ7T0FFckQsRUFBQyxZQUFZLEVBQUMsTUFBTSwrQ0FBK0M7T0FFbkUsRUFBa0IsVUFBVSxFQUFvQixNQUFNLFdBQVc7T0FDakUsRUFDTCxTQUFTLEVBQ1QsT0FBTyxFQUlQLEtBQUssRUFDTCxVQUFVLEVBQ1gsTUFBTSwwQkFBMEI7T0FDMUIsRUFBQyxhQUFhLEVBQW1CLE1BQU0sZ0NBQWdDO09BQ3ZFLEVBQXlCLGVBQWUsRUFBQyxNQUFNLDhCQUE4QjtPQUM3RSxFQUFDLFFBQVEsRUFBcUIsTUFBTSxZQUFZO09BQ2hELEVBQUMsVUFBVSxFQUFDLE1BQU0sK0JBQStCO09BQ2pELEVBQUMsbUJBQW1CLEVBQUMsTUFBTSwrQkFBK0I7QUFFakUsU0FBUSxZQUFZLFFBQU8sK0NBQStDLENBQUM7T0FDcEUsRUFBQyxLQUFLLEVBQUMsTUFBTSwrQkFBK0I7T0FHNUMsRUFBQyxRQUFRLEVBQUMsTUFBTSxhQUFhO0FBRXBDLE1BQU0sY0FBYyxHQUFXLGFBQWEsQ0FBQztBQUU3QyxNQUFNLGFBQWEsR0FBRyxVQUFVLENBQUMsSUFBSSxNQUFNLEVBQUUsQ0FBQyxDQUFDO0FBRS9DOzs7R0FHRztBQUNIO0lBZ0NFQSxZQUFtQkEsS0FBbUJBLEVBQVNBLFFBQWtCQSxFQUM5Q0EsV0FBNEJBLEVBQVNBLGdCQUFvQ0EsRUFDekVBLG1CQUErQkEsRUFDdENBLDRCQUFnREEsRUFBRUEsWUFBc0JBLEVBQ2pFQSxjQUE4QkE7UUFKOUJDLFVBQUtBLEdBQUxBLEtBQUtBLENBQWNBO1FBQVNBLGFBQVFBLEdBQVJBLFFBQVFBLENBQVVBO1FBQzlDQSxnQkFBV0EsR0FBWEEsV0FBV0EsQ0FBaUJBO1FBQVNBLHFCQUFnQkEsR0FBaEJBLGdCQUFnQkEsQ0FBb0JBO1FBQ3pFQSx3QkFBbUJBLEdBQW5CQSxtQkFBbUJBLENBQVlBO1FBRS9CQSxtQkFBY0EsR0FBZEEsY0FBY0EsQ0FBZ0JBO1FBN0JqREE7OztXQUdHQTtRQUNIQSxZQUFPQSxHQUFRQSxJQUFJQSxDQUFDQTtRQW1CcEJBLGNBQVNBLEdBQVlBLEtBQUtBLENBQUNBO1FBT3pCQSxJQUFJQSxDQUFDQSxHQUFHQSxHQUFHQSxJQUFJQSxRQUFRQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtRQUM5QkEsSUFBSUEsd0JBQXdCQSxHQUFHQSxVQUFVQSxDQUFDQSxxQkFBcUJBLENBQzNEQSxJQUFJQSxDQUFDQSxLQUFLQSxDQUFDQSxJQUFJQSxFQUFFQSxtQkFBbUJBLEVBQUVBLDRCQUE0QkEsRUFBRUEsWUFBWUEsQ0FBQ0EsQ0FBQ0E7UUFDdEZBLElBQUlBLENBQUNBLGNBQWNBLEdBQUdBLHdCQUF3QkEsQ0FBQ0EsUUFBUUEsQ0FBQ0E7UUFDeERBLElBQUlBLENBQUNBLG9CQUFvQkEsR0FBR0Esd0JBQXdCQSxDQUFDQSxvQkFBb0JBLENBQUNBO1FBQzFFQSxJQUFJQSxLQUFLQSxDQUFDQTtRQUNWQSxJQUFJQSxPQUFPQSxDQUFDQTtRQUNaQSxNQUFNQSxDQUFDQSxDQUFDQSxLQUFLQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNuQkEsS0FBS0EsUUFBUUEsQ0FBQ0EsU0FBU0E7Z0JBQ3JCQSxLQUFLQSxHQUFHQSxJQUFJQSxLQUFLQSxDQUFDQSxLQUFLQSxDQUFDQSxVQUFVQSxFQUFFQSxtQkFBbUJBLENBQUNBLFdBQVdBLEVBQUVBLENBQUNBLENBQUNBO2dCQUN2RUEsT0FBT0EsR0FBR0EsbUJBQW1CQSxDQUFDQSxZQUFZQSxFQUFFQSxDQUFDQTtnQkFDN0NBLEtBQUtBLENBQUNBO1lBQ1JBLEtBQUtBLFFBQVFBLENBQUNBLFFBQVFBO2dCQUNwQkEsS0FBS0EsR0FBR0EsbUJBQW1CQSxDQUFDQSxVQUFVQSxDQUFDQSxLQUFLQSxDQUFDQTtnQkFDN0NBLE9BQU9BLEdBQUdBLG1CQUFtQkEsQ0FBQ0EsVUFBVUEsQ0FBQ0EsT0FBT0EsQ0FBQ0E7Z0JBQ2pEQSxLQUFLQSxDQUFDQTtZQUNSQSxLQUFLQSxRQUFRQSxDQUFDQSxJQUFJQTtnQkFDaEJBLEtBQUtBLEdBQUdBLElBQUlBLENBQUNBO2dCQUNiQSxPQUFPQSxHQUFHQSxhQUFhQSxDQUFDQTtnQkFDeEJBLEtBQUtBLENBQUNBO1FBQ1ZBLENBQUNBO1FBQ0RBLElBQUlBLENBQUNBLEtBQUtBLEdBQUdBLEtBQUtBLENBQUNBO1FBQ25CQSxJQUFJQSxDQUFDQSxPQUFPQSxHQUFHQSxPQUFPQSxDQUFDQTtJQUN6QkEsQ0FBQ0E7SUFFREQsSUFBSUEsQ0FBQ0Esc0JBQTZCQSxFQUFFQSxRQUFlQSxFQUFFQSxXQUF1QkEsRUFDdkVBLFdBQXlCQTtRQUM1QkUsSUFBSUEsQ0FBQ0Esc0JBQXNCQSxHQUFHQSxzQkFBc0JBLENBQUNBO1FBQ3JEQSxJQUFJQSxDQUFDQSxRQUFRQSxHQUFHQSxRQUFRQSxDQUFDQTtRQUN6QkEsSUFBSUEsQ0FBQ0EsV0FBV0EsR0FBR0EsV0FBV0EsQ0FBQ0E7UUFDL0JBLElBQUlBLENBQUNBLFdBQVdBLEdBQUdBLFdBQVdBLENBQUNBO1FBQy9CQSxJQUFJQSxTQUFTQSxHQUFHQSxJQUFJQSxHQUFHQSxFQUFlQSxDQUFDQTtRQUN2Q0EsZ0JBQWdCQSxDQUFDQSxPQUFPQSxDQUFDQSxJQUFJQSxDQUFDQSxLQUFLQSxDQUFDQSx3QkFBd0JBLEVBQ25DQSxDQUFDQSxZQUFZQSxFQUFFQSxDQUFDQSxPQUFPQSxTQUFTQSxDQUFDQSxHQUFHQSxDQUFDQSxZQUFZQSxFQUFFQSxJQUFJQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUN0RkEsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsRUFBRUEsQ0FBQ0EsR0FBR0EsV0FBV0EsQ0FBQ0EsTUFBTUEsRUFBRUEsQ0FBQ0EsRUFBRUEsRUFBRUEsQ0FBQ0E7WUFDNUNBLElBQUlBLEtBQUtBLEdBQUdBLFdBQVdBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQzNCQSxJQUFJQSxjQUFjQSxHQUFHQSxFQUFFQSxDQUFDQTtZQUN4QkEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsU0FBU0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EsYUFBYUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7Z0JBQ3pDQSxHQUFHQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxFQUFFQSxDQUFDQSxHQUFHQSxLQUFLQSxDQUFDQSxLQUFLQSxDQUFDQSxhQUFhQSxDQUFDQSxpQkFBaUJBLEVBQUVBLENBQUNBLEVBQUVBLEVBQUVBLENBQUNBO29CQUNyRUEsY0FBY0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsS0FBS0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EsYUFBYUEsQ0FBQ0Esa0JBQWtCQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxLQUFLQSxDQUFDQSxDQUFDQTtnQkFDakZBLENBQUNBO1lBQ0hBLENBQUNBO1lBQ0RBLGdCQUFnQkEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EseUJBQXlCQSxFQUFFQSxDQUFDQSxjQUFjQSxFQUFFQSxJQUFJQTtnQkFDbkZBLEVBQUVBLENBQUNBLENBQUNBLE9BQU9BLENBQUNBLGNBQWNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO29CQUM1QkEsU0FBU0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsSUFBSUEsRUFBRUEsS0FBS0EsQ0FBQ0EsYUFBYUEsQ0FBQ0EsQ0FBQ0E7Z0JBQzNDQSxDQUFDQTtnQkFBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7b0JBQ05BLFNBQVNBLENBQUNBLEdBQUdBLENBQUNBLElBQUlBLEVBQUVBLEtBQUtBLENBQUNBLG1CQUFtQkEsQ0FBQ0EsY0FBY0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7Z0JBQ2pFQSxDQUFDQTtZQUNIQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNIQSxJQUFJQSxDQUFDQSxRQUFRQSxDQUFDQSxtQkFBbUJBLENBQzdCQSxLQUFLQSxDQUFDQSxhQUFhQSxFQUFFQSxJQUFJQSxlQUFlQSxDQUFDQSxLQUFLQSxDQUFDQSxXQUFXQSxFQUFFQSxFQUFFQSxLQUFLQSxDQUFDQSxZQUFZQSxFQUFFQSxFQUN6Q0EsY0FBY0EsRUFBRUEsU0FBU0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDM0VBLENBQUNBO1FBQ0RBLElBQUlBLFlBQVlBLEdBQUdBLElBQUlBLENBQUNBO1FBQ3hCQSxFQUFFQSxDQUFDQSxDQUFDQSxJQUFJQSxDQUFDQSxLQUFLQSxDQUFDQSxJQUFJQSxLQUFLQSxRQUFRQSxDQUFDQSxTQUFTQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUMzQ0EsWUFBWUE7Z0JBQ1JBLFNBQVNBLENBQUNBLElBQUlBLENBQUNBLG1CQUFtQkEsQ0FBQ0EsR0FBR0EsSUFBSUEsQ0FBQ0EsbUJBQW1CQSxDQUFDQSxVQUFVQSxDQUFDQSxNQUFNQSxHQUFHQSxJQUFJQSxDQUFDQTtRQUM5RkEsQ0FBQ0E7UUFDREEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsS0FBS0EsQ0FBQ0EsSUFBSUEsS0FBS0EsUUFBUUEsQ0FBQ0EsU0FBU0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDM0NBLGtFQUFrRUE7WUFDbEVBLDhCQUE4QkE7WUFDOUJBLElBQUlBLENBQUNBLG1CQUFtQkEsQ0FBQ0EsbUJBQW1CQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtZQUNuREEsSUFBSUEsQ0FBQ0EsbUJBQW1CQSxDQUFDQSxVQUFVQSxDQUFDQSxjQUFjQSxDQUFDQSxZQUFZQSxDQUFDQSxJQUFJQSxDQUFDQSxjQUFjQSxDQUFDQSxDQUFDQTtRQUN2RkEsQ0FBQ0E7UUFDREEsSUFBSUEsQ0FBQ0EsTUFBTUEsR0FBR0EsSUFBSUEsTUFBTUEsQ0FBQ0EsWUFBWUEsRUFBRUEsU0FBU0EsQ0FBQ0EsQ0FBQ0E7UUFDbERBLElBQUlBLENBQUNBLGNBQWNBLENBQUNBLE9BQU9BLENBQUNBLElBQUlBLENBQUNBLE9BQU9BLEVBQUVBLElBQUlBLENBQUNBLE1BQU1BLEVBQUVBLElBQUlBLEVBQUVBLElBQUlBLENBQUNBLEtBQUtBLENBQUNBLENBQUNBO1FBQ3pFQSxJQUFJQSxDQUFDQSxXQUFXQSxDQUFDQSxhQUFhQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtJQUN2Q0EsQ0FBQ0E7SUFFREYsT0FBT0E7UUFDTEcsRUFBRUEsQ0FBQ0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsU0FBU0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDbkJBLE1BQU1BLElBQUlBLGFBQWFBLENBQUNBLHVDQUF1Q0EsQ0FBQ0EsQ0FBQ0E7UUFDbkVBLENBQUNBO1FBQ0RBLElBQUlBLENBQUNBLGNBQWNBLENBQUNBLGdCQUFnQkEsRUFBRUEsQ0FBQ0E7SUFDekNBLENBQUNBO0lBRURILGVBQWVBO1FBQ2JJLElBQUlBLENBQUNBLFNBQVNBLEdBQUdBLElBQUlBLENBQUNBO1FBQ3RCQSxJQUFJQSxXQUFXQSxHQUNYQSxJQUFJQSxDQUFDQSxLQUFLQSxDQUFDQSxJQUFJQSxLQUFLQSxRQUFRQSxDQUFDQSxTQUFTQSxHQUFHQSxJQUFJQSxDQUFDQSxtQkFBbUJBLENBQUNBLGFBQWFBLEdBQUdBLElBQUlBLENBQUNBO1FBQzNGQSxJQUFJQSxDQUFDQSxRQUFRQSxDQUFDQSxXQUFXQSxDQUFDQSxXQUFXQSxFQUFFQSxJQUFJQSxDQUFDQSxRQUFRQSxDQUFDQSxDQUFDQTtRQUN0REEsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsRUFBRUEsQ0FBQ0EsR0FBR0EsSUFBSUEsQ0FBQ0EsV0FBV0EsQ0FBQ0EsTUFBTUEsRUFBRUEsQ0FBQ0EsRUFBRUEsRUFBRUEsQ0FBQ0E7WUFDakRBLElBQUlBLENBQUNBLFdBQVdBLENBQUNBLENBQUNBLENBQUNBLEVBQUVBLENBQUNBO1FBQ3hCQSxDQUFDQTtRQUNEQSxJQUFJQSxDQUFDQSxXQUFXQSxDQUFDQSxlQUFlQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtJQUN6Q0EsQ0FBQ0E7SUFFREosSUFBSUEsaUJBQWlCQSxLQUF3QkssTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsY0FBY0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7SUFFOUVMLElBQUlBLGFBQWFBLEtBQVlNLE1BQU1BLENBQUNBLDRCQUE0QkEsQ0FBQ0EsSUFBSUEsQ0FBQ0Esc0JBQXNCQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtJQUVoR04sUUFBUUEsQ0FBQ0EsV0FBbUJBO1FBQzFCTyxNQUFNQSxDQUFDQSxnQkFBZ0JBLENBQUNBLFFBQVFBLENBQUNBLElBQUlBLENBQUNBLEtBQUtBLENBQUNBLHdCQUF3QkEsRUFBRUEsV0FBV0EsQ0FBQ0EsQ0FBQ0E7SUFDckZBLENBQUNBO0lBRURQLFFBQVFBLENBQUNBLFdBQW1CQSxFQUFFQSxLQUFVQTtRQUN0Q1EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsV0FBV0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDaENBLE1BQU1BLENBQUNBO1FBQ1RBLENBQUNBO1FBQ0RBLElBQUlBLFlBQVlBLEdBQUdBLElBQUlBLENBQUNBLEtBQUtBLENBQUNBLHdCQUF3QkEsQ0FBQ0EsV0FBV0EsQ0FBQ0EsQ0FBQ0E7UUFDcEVBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBLEdBQUdBLENBQUNBLFlBQVlBLEVBQUVBLEtBQUtBLENBQUNBLENBQUNBO0lBQ3ZDQSxDQUFDQTtJQUVEUiw4REFBOERBO0lBQzlEQSxlQUFlQSxDQUFDQSxDQUFnQkEsRUFBRUEsWUFBaUJBO1FBQ2pEUyxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxVQUFVQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNuQkEsSUFBSUEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsWUFBWUEsQ0FBQ0EsRUFBRUEsWUFBWUEsQ0FBQ0EsQ0FBQ0E7UUFDckVBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLENBQUNBO1lBQ05BLElBQUlBLGFBQWFBLEdBQUdBLElBQUlBLENBQUNBLFdBQVdBLENBQUNBLENBQUNBLENBQUNBLFlBQVlBLENBQUNBLENBQUNBLGFBQWFBLENBQUNBO1lBQ25FQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxpQkFBaUJBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBO2dCQUMxQkEsSUFBSUEsQ0FBQ0EsUUFBUUEsQ0FBQ0Esa0JBQWtCQSxDQUFDQSxhQUFhQSxFQUFFQSxDQUFDQSxDQUFDQSxJQUFJQSxFQUFFQSxZQUFZQSxDQUFDQSxDQUFDQTtZQUN4RUEsQ0FBQ0E7WUFBQ0EsSUFBSUEsQ0FBQ0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0Esa0JBQWtCQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQTtnQkFDbENBLElBQUlBLENBQUNBLFFBQVFBLENBQUNBLG1CQUFtQkEsQ0FBQ0EsYUFBYUEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsSUFBSUEsRUFDckJBLFNBQVNBLENBQUNBLFlBQVlBLENBQUNBLEdBQUdBLEdBQUdBLFlBQVlBLEVBQUVBLEdBQUdBLElBQUlBLENBQUNBLENBQUNBO1lBQ3hGQSxDQUFDQTtZQUFDQSxJQUFJQSxDQUFDQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxjQUFjQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQTtnQkFDOUJBLElBQUlBLENBQUNBLFFBQVFBLENBQUNBLGVBQWVBLENBQUNBLGFBQWFBLEVBQUVBLENBQUNBLENBQUNBLElBQUlBLEVBQUVBLFlBQVlBLENBQUNBLENBQUNBO1lBQ3JFQSxDQUFDQTtZQUFDQSxJQUFJQSxDQUFDQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxjQUFjQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQTtnQkFDOUJBLElBQUlBLElBQUlBLEdBQUdBLFNBQVNBLENBQUNBLENBQUNBLENBQUNBLElBQUlBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBLElBQUlBLEdBQUdBLEVBQUVBLENBQUNBO2dCQUMzQ0EsSUFBSUEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsZUFBZUEsQ0FBQ0EsYUFBYUEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsSUFBSUEsRUFDckJBLFNBQVNBLENBQUNBLFlBQVlBLENBQUNBLEdBQUdBLEdBQUdBLFlBQVlBLEdBQUdBLElBQUlBLEVBQUVBLEdBQUdBLElBQUlBLENBQUNBLENBQUNBO1lBQzNGQSxDQUFDQTtZQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtnQkFDTkEsTUFBTUEsSUFBSUEsYUFBYUEsQ0FBQ0EsOEJBQThCQSxDQUFDQSxDQUFDQTtZQUMxREEsQ0FBQ0E7UUFDSEEsQ0FBQ0E7SUFDSEEsQ0FBQ0E7SUFFRFQsZ0JBQWdCQSxDQUFDQSxDQUFnQkEsRUFBRUEsS0FBVUE7UUFDM0NVLEVBQUVBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLFdBQVdBLEVBQUVBLElBQUlBLENBQUNBLENBQUNBLGlCQUFpQkEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDN0NBLElBQUlBLGFBQWFBLEdBQUdBLElBQUlBLENBQUNBLFdBQVdBLENBQUNBLENBQUNBLENBQUNBLFlBQVlBLENBQUNBLENBQUNBLGFBQWFBLENBQUNBO1lBQ25FQSxJQUFJQSxDQUFDQSxRQUFRQSxDQUFDQSxtQkFBbUJBLENBQzdCQSxhQUFhQSxFQUFFQSxHQUFHQSxjQUFjQSxHQUFHQSxtQkFBbUJBLENBQUNBLENBQUNBLENBQUNBLElBQUlBLENBQUNBLEVBQUVBLEVBQUVBLEdBQUdBLEtBQUtBLEVBQUVBLENBQUNBLENBQUNBO1FBQ3BGQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUVEVix5QkFBeUJBO1FBQ3ZCVyxJQUFJQSxLQUFLQSxHQUFHQSxJQUFJQSxDQUFDQSxXQUFXQSxDQUFDQSxNQUFNQSxDQUFDQTtRQUNwQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsS0FBS0EsR0FBR0EsQ0FBQ0EsRUFBRUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsRUFBRUEsQ0FBQ0EsRUFBRUEsRUFBRUEsQ0FBQ0E7WUFDcENBLElBQUlBLENBQUNBLFdBQVdBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLHFCQUFxQkEsRUFBRUEsQ0FBQ0E7UUFDOUNBLENBQUNBO0lBQ0hBLENBQUNBO0lBRURYLHNCQUFzQkE7UUFDcEJZLElBQUlBLEtBQUtBLEdBQUdBLElBQUlBLENBQUNBLFdBQVdBLENBQUNBLE1BQU1BLENBQUNBO1FBQ3BDQSxHQUFHQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQSxHQUFHQSxLQUFLQSxHQUFHQSxDQUFDQSxFQUFFQSxDQUFDQSxJQUFJQSxDQUFDQSxFQUFFQSxDQUFDQSxFQUFFQSxFQUFFQSxDQUFDQTtZQUNwQ0EsSUFBSUEsQ0FBQ0EsV0FBV0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0Esa0JBQWtCQSxFQUFFQSxDQUFDQTtRQUMzQ0EsQ0FBQ0E7SUFDSEEsQ0FBQ0E7SUFFRFosZUFBZUEsQ0FBQ0EsVUFBc0JBLEVBQUVBLFlBQW9CQSxFQUM1Q0EsY0FBc0JBO1FBQ3BDYSxJQUFJQSxDQUFDQTtZQUNIQSxFQUFFQSxDQUFDQSxDQUFDQSxPQUFPQSxDQUFDQSxVQUFVQSxDQUFDQSxJQUFJQSxZQUFZQSxHQUFHQSxJQUFJQSxDQUFDQSxXQUFXQSxDQUFDQSxNQUFNQSxDQUFDQSxDQUFDQSxDQUFDQTtnQkFDbEVBLFVBQVVBLEdBQUdBLElBQUlBLENBQUNBLFdBQVdBLENBQUNBLFlBQVlBLENBQUNBLENBQUNBO1lBQzlDQSxDQUFDQTtZQUNEQSxJQUFJQSxTQUFTQSxHQUFHQSxJQUFJQSxDQUFDQSxtQkFBbUJBLENBQUNBO1lBRXpDQSxJQUFJQSxPQUFPQSxHQUFHQSxTQUFTQSxDQUFDQSxVQUFVQSxDQUFDQSxHQUFHQSxVQUFVQSxDQUFDQSxhQUFhQSxHQUFHQSxJQUFJQSxDQUFDQTtZQUN0RUEsSUFBSUEsZ0JBQWdCQSxHQUFHQSxTQUFTQSxDQUFDQSxTQUFTQSxDQUFDQSxHQUFHQSxTQUFTQSxDQUFDQSxhQUFhQSxHQUFHQSxJQUFJQSxDQUFDQTtZQUM3RUEsSUFBSUEsU0FBU0EsR0FDVEEsU0FBU0EsQ0FBQ0EsY0FBY0EsQ0FBQ0EsR0FBR0EsVUFBVUEsQ0FBQ0EsbUJBQW1CQSxDQUFDQSxjQUFjQSxDQUFDQSxHQUFHQSxJQUFJQSxDQUFDQTtZQUN0RkEsSUFBSUEsUUFBUUEsR0FBR0EsU0FBU0EsQ0FBQ0EsVUFBVUEsQ0FBQ0EsR0FBR0EsVUFBVUEsQ0FBQ0EsV0FBV0EsRUFBRUEsR0FBR0EsSUFBSUEsQ0FBQ0E7WUFFdkVBLE1BQU1BLENBQUNBLElBQUlBLFlBQVlBLENBQUNBLE9BQU9BLEVBQUVBLGdCQUFnQkEsRUFBRUEsU0FBU0EsRUFBRUEsSUFBSUEsQ0FBQ0EsT0FBT0EsRUFDbERBLGtCQUFrQkEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsRUFBRUEsUUFBUUEsQ0FBQ0EsQ0FBQ0E7UUFFckVBLENBQUVBO1FBQUFBLEtBQUtBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQ1hBLHFGQUFxRkE7WUFDckZBLHdFQUF3RUE7WUFDeEVBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBO1FBQ2RBLENBQUNBO0lBQ0hBLENBQUNBO0lBRURiLGVBQWVBLENBQUNBLFNBQXlCQTtRQUN2Q2MsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsV0FBV0EsQ0FBQ0EsU0FBU0EsQ0FBQ0EsWUFBWUEsQ0FBQ0EsQ0FBQ0EsbUJBQW1CQSxDQUFDQSxTQUFTQSxDQUFDQSxjQUFjQSxDQUFDQSxDQUFDQTtJQUNoR0EsQ0FBQ0E7SUFFRGQsY0FBY0EsQ0FBQ0EsU0FBeUJBO1FBQ3RDZSxJQUFJQSxhQUFhQSxHQUFHQSxJQUFJQSxDQUFDQSxXQUFXQSxDQUFDQSxTQUFTQSxDQUFDQSxZQUFZQSxDQUFDQSxDQUFDQSxhQUFhQSxDQUFDQTtRQUMzRUEsTUFBTUEsQ0FBQ0EsU0FBU0EsQ0FBQ0EsYUFBYUEsQ0FBQ0EsR0FBR0EsYUFBYUEsQ0FBQ0EsY0FBY0EsR0FBR0EsSUFBSUEsQ0FBQ0E7SUFDeEVBLENBQUNBO0lBRURmOzs7Ozs7Ozs7T0FTR0E7SUFDSEEsb0JBQW9CQSxDQUFDQSxTQUFpQkEsRUFBRUEsUUFBZUEsRUFBRUEsaUJBQXlCQTtRQUNoRmdCLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLGNBQWNBLENBQUNBLFdBQVdBLENBQUNBLFNBQVNBLEVBQUVBLGlCQUFpQkEsRUFBRUEsUUFBUUEsQ0FBQ0EsQ0FBQ0E7SUFDakZBLENBQUNBO0FBQ0hoQixDQUFDQTtBQUVELDRCQUE0QixNQUFjO0lBQ3hDaUIsSUFBSUEsR0FBR0EsR0FBR0EsRUFBRUEsQ0FBQ0E7SUFDYkEsSUFBSUEsQ0FBQ0EsR0FBR0EsTUFBTUEsQ0FBQ0E7SUFDZkEsT0FBT0EsU0FBU0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsRUFBRUEsQ0FBQ0E7UUFDcEJBLEdBQUdBLEdBQUdBLGdCQUFnQkEsQ0FBQ0EsS0FBS0EsQ0FBQ0EsR0FBR0EsRUFBRUEsVUFBVUEsQ0FBQ0EsV0FBV0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsT0FBT0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDckVBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBLE1BQU1BLENBQUNBO0lBQ2ZBLENBQUNBO0lBQ0RBLE1BQU1BLENBQUNBLEdBQUdBLENBQUNBO0FBQ2JBLENBQUNBO0FBRUQ7O0dBRUc7QUFDSDtJQWNFQyxZQUFtQkEsSUFBY0EsRUFBU0EsVUFBc0JBLEVBQzdDQSx3QkFBaURBO1FBRGpEQyxTQUFJQSxHQUFKQSxJQUFJQSxDQUFVQTtRQUFTQSxlQUFVQSxHQUFWQSxVQUFVQSxDQUFZQTtRQUM3Q0EsNkJBQXdCQSxHQUF4QkEsd0JBQXdCQSxDQUF5QkE7SUFBR0EsQ0FBQ0E7SUFkeEVELE9BQU9BLE1BQU1BLENBQUNBLGFBQW9DQSxFQUFFQSxJQUFjQSxFQUFFQSxLQUFhQSxFQUNuRUEsd0JBQWlEQTtRQUM3REUsSUFBSUEsVUFBVUEsR0FBR0EsSUFBSUEsQ0FBQ0E7UUFDdEJBLEVBQUVBLENBQUNBLENBQUNBLFNBQVNBLENBQUNBLEtBQUtBLENBQUNBLElBQUlBLEtBQUtBLENBQUNBLE1BQU1BLEdBQUdBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQ3pDQSxJQUFJQSxVQUFVQSxHQUFHQSxXQUFXQSxDQUFDQSxlQUFlQSxDQUFDQSxLQUFLQSxDQUFDQSxNQUFNQSxDQUFDQSxDQUFDQTtZQUMzREEsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsRUFBRUEsQ0FBQ0EsR0FBR0EsS0FBS0EsQ0FBQ0EsTUFBTUEsRUFBRUEsQ0FBQ0EsRUFBRUEsRUFBRUEsQ0FBQ0E7Z0JBQ3RDQSxVQUFVQSxDQUFDQSxDQUFDQSxDQUFDQSxHQUFHQSxhQUFhQSxDQUFDQSx1QkFBdUJBLENBQUNBLEtBQUtBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQ2xFQSxDQUFDQTtZQUNEQSxVQUFVQSxHQUFHQSxVQUFVQSxDQUFDQSxhQUFhQSxDQUFDQSxVQUFVQSxDQUFDQSxDQUFDQTtRQUNwREEsQ0FBQ0E7UUFDREEsTUFBTUEsQ0FBQ0EsSUFBSUEsWUFBWUEsQ0FBQ0EsSUFBSUEsRUFBRUEsVUFBVUEsRUFBRUEsd0JBQXdCQSxDQUFDQSxDQUFDQTtJQUN0RUEsQ0FBQ0E7QUFJSEYsQ0FBQ0E7QUFHRDtJQUVFRyxZQUFtQkEsUUFBZ0JBLEVBQVNBLFdBQXFCQTtRQUE5Q0MsYUFBUUEsR0FBUkEsUUFBUUEsQ0FBUUE7UUFBU0EsZ0JBQVdBLEdBQVhBLFdBQVdBLENBQVVBO0lBQUdBLENBQUNBO0FBQ3ZFRCxDQUFDQTtBQUhEO0lBQUMsS0FBSyxFQUFFOztvQkFHUDtBQUVELDZDQUE2QyxLQUFZO0lBQ3ZERSxNQUFNQSxDQUFDQSw2QkFBNkJBLENBQUNBLEtBQUtBLEVBQUVBLEVBQUVBLENBQUNBLENBQUNBO0FBQ2xEQSxDQUFDQTtBQUVELHVDQUF1QyxLQUFZLEVBQUUsV0FBa0I7SUFDckVDLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLEVBQUVBLENBQUNBLEdBQUdBLEtBQUtBLENBQUNBLE1BQU1BLEVBQUVBLENBQUNBLEVBQUVBLEVBQUVBLENBQUNBO1FBQ3RDQSxJQUFJQSxJQUFJQSxHQUFHQSxLQUFLQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUNwQkEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsSUFBSUEsWUFBWUEsVUFBVUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDL0JBLElBQUlBLEtBQUtBLEdBQWVBLElBQUlBLENBQUNBO1lBQzdCQSxXQUFXQSxDQUFDQSxJQUFJQSxDQUFDQSxLQUFLQSxDQUFDQSxhQUFhQSxDQUFDQSxDQUFDQTtZQUN0Q0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsU0FBU0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EsV0FBV0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7Z0JBQ2pDQSxHQUFHQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxFQUFFQSxDQUFDQSxHQUFHQSxLQUFLQSxDQUFDQSxXQUFXQSxDQUFDQSxNQUFNQSxFQUFFQSxDQUFDQSxFQUFFQSxFQUFFQSxDQUFDQTtvQkFDbERBLDZCQUE2QkEsQ0FBQ0EsS0FBS0EsQ0FBQ0EsV0FBV0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0Esc0JBQXNCQSxFQUFFQSxXQUFXQSxDQUFDQSxDQUFDQTtnQkFDMUZBLENBQUNBO1lBQ0hBLENBQUNBO1FBQ0hBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLENBQUNBO1lBQ05BLFdBQVdBLENBQUNBLElBQUlBLENBQUNBLElBQUlBLENBQUNBLENBQUNBO1FBQ3pCQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUNEQSxNQUFNQSxDQUFDQSxXQUFXQSxDQUFDQTtBQUNyQkEsQ0FBQ0E7QUFFRCwrQkFBK0IsYUFBcUIsRUFBRSxpQkFBeUIsRUFDaEQsZ0JBQXlCO0lBQ3REQyxJQUFJQSxjQUFjQSxHQUFHQSxTQUFTQSxDQUFDQSxnQkFBZ0JBLENBQUNBLEdBQUdBLGdCQUFnQkEsQ0FBQ0EsTUFBTUEsR0FBR0EsQ0FBQ0EsQ0FBQ0E7SUFDL0VBLEVBQUVBLENBQUNBLENBQUNBLGNBQWNBLEdBQUdBLGlCQUFpQkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDdkNBLE1BQU1BLElBQUlBLGFBQWFBLENBQ25CQSxpQkFBaUJBLGFBQWFBLFFBQVFBLGlCQUFpQkEseUJBQXlCQTtZQUNoRkEsYUFBYUEsY0FBY0EsdUJBQXVCQSxDQUFDQSxDQUFDQTtJQUMxREEsQ0FBQ0E7QUFDSEEsQ0FBQ0EiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xuICBMaXN0V3JhcHBlcixcbiAgTWFwV3JhcHBlcixcbiAgTWFwLFxuICBTdHJpbmdNYXBXcmFwcGVyLFxufSBmcm9tICdhbmd1bGFyMi9zcmMvZmFjYWRlL2NvbGxlY3Rpb24nO1xuaW1wb3J0IHtcbiAgQ2hhbmdlRGV0ZWN0b3IsXG4gIENoYW5nZURpc3BhdGNoZXIsXG4gIERpcmVjdGl2ZUluZGV4LFxuICBCaW5kaW5nVGFyZ2V0LFxuICBMb2NhbHMsXG4gIFByb3RvQ2hhbmdlRGV0ZWN0b3IsXG4gIENoYW5nZURldGVjdG9yUmVmXG59IGZyb20gJ2FuZ3VsYXIyL3NyYy9jb3JlL2NoYW5nZV9kZXRlY3Rpb24vY2hhbmdlX2RldGVjdGlvbic7XG5pbXBvcnQge1Jlc29sdmVkUHJvdmlkZXIsIEluamVjdGFibGUsIEluamVjdG9yfSBmcm9tICdhbmd1bGFyMi9zcmMvY29yZS9kaSc7XG5pbXBvcnQge0RlYnVnQ29udGV4dH0gZnJvbSAnYW5ndWxhcjIvc3JjL2NvcmUvY2hhbmdlX2RldGVjdGlvbi9pbnRlcmZhY2VzJztcblxuaW1wb3J0IHtBcHBQcm90b0VsZW1lbnQsIEFwcEVsZW1lbnQsIERpcmVjdGl2ZVByb3ZpZGVyfSBmcm9tICcuL2VsZW1lbnQnO1xuaW1wb3J0IHtcbiAgaXNQcmVzZW50LFxuICBpc0JsYW5rLFxuICBUeXBlLFxuICBpc0FycmF5LFxuICBpc051bWJlcixcbiAgQ09OU1QsXG4gIENPTlNUX0VYUFJcbn0gZnJvbSAnYW5ndWxhcjIvc3JjL2ZhY2FkZS9sYW5nJztcbmltcG9ydCB7QmFzZUV4Y2VwdGlvbiwgV3JhcHBlZEV4Y2VwdGlvbn0gZnJvbSAnYW5ndWxhcjIvc3JjL2ZhY2FkZS9leGNlcHRpb25zJztcbmltcG9ydCB7UmVuZGVyZXIsIFJvb3RSZW5kZXJlciwgUmVuZGVyRGVidWdJbmZvfSBmcm9tICdhbmd1bGFyMi9zcmMvY29yZS9yZW5kZXIvYXBpJztcbmltcG9ydCB7Vmlld1JlZl8sIEhvc3RWaWV3RmFjdG9yeVJlZn0gZnJvbSAnLi92aWV3X3JlZic7XG5pbXBvcnQge1Byb3RvUGlwZXN9IGZyb20gJ2FuZ3VsYXIyL3NyYy9jb3JlL3BpcGVzL3BpcGVzJztcbmltcG9ydCB7Y2FtZWxDYXNlVG9EYXNoQ2FzZX0gZnJvbSAnYW5ndWxhcjIvc3JjL2NvcmUvcmVuZGVyL3V0aWwnO1xuXG5leHBvcnQge0RlYnVnQ29udGV4dH0gZnJvbSAnYW5ndWxhcjIvc3JjL2NvcmUvY2hhbmdlX2RldGVjdGlvbi9pbnRlcmZhY2VzJztcbmltcG9ydCB7UGlwZXN9IGZyb20gJ2FuZ3VsYXIyL3NyYy9jb3JlL3BpcGVzL3BpcGVzJztcbmltcG9ydCB7QXBwVmlld01hbmFnZXJfLCBBcHBWaWV3TWFuYWdlcn0gZnJvbSAnLi92aWV3X21hbmFnZXInO1xuaW1wb3J0IHtSZXNvbHZlZE1ldGFkYXRhQ2FjaGV9IGZyb20gJy4vcmVzb2x2ZWRfbWV0YWRhdGFfY2FjaGUnO1xuaW1wb3J0IHtWaWV3VHlwZX0gZnJvbSAnLi92aWV3X3R5cGUnO1xuXG5jb25zdCBSRUZMRUNUX1BSRUZJWDogc3RyaW5nID0gJ25nLXJlZmxlY3QtJztcblxuY29uc3QgRU1QVFlfQ09OVEVYVCA9IENPTlNUX0VYUFIobmV3IE9iamVjdCgpKTtcblxuLyoqXG4gKiBDb3N0IG9mIG1ha2luZyBvYmplY3RzOiBodHRwOi8vanNwZXJmLmNvbS9pbnN0YW50aWF0ZS1zaXplLW9mLW9iamVjdFxuICpcbiAqL1xuZXhwb3J0IGNsYXNzIEFwcFZpZXcgaW1wbGVtZW50cyBDaGFuZ2VEaXNwYXRjaGVyIHtcbiAgcmVmOiBWaWV3UmVmXztcbiAgcm9vdE5vZGVzT3JBcHBFbGVtZW50czogYW55W107XG4gIGFsbE5vZGVzOiBhbnlbXTtcbiAgZGlzcG9zYWJsZXM6IEZ1bmN0aW9uW107XG4gIGFwcEVsZW1lbnRzOiBBcHBFbGVtZW50W107XG5cbiAgLyoqXG4gICAqIFRoZSBjb250ZXh0IGFnYWluc3Qgd2hpY2ggZGF0YS1iaW5kaW5nIGV4cHJlc3Npb25zIGluIHRoaXMgdmlldyBhcmUgZXZhbHVhdGVkIGFnYWluc3QuXG4gICAqIFRoaXMgaXMgYWx3YXlzIGEgY29tcG9uZW50IGluc3RhbmNlLlxuICAgKi9cbiAgY29udGV4dDogYW55ID0gbnVsbDtcblxuICAvKipcbiAgICogVmFyaWFibGVzLCBsb2NhbCB0byB0aGlzIHZpZXcsIHRoYXQgY2FuIGJlIHVzZWQgaW4gYmluZGluZyBleHByZXNzaW9ucyAoaW4gYWRkaXRpb24gdG8gdGhlXG4gICAqIGNvbnRleHQpLiBUaGlzIGlzIHVzZWQgZm9yIHRoaW5nIGxpa2UgYDx2aWRlbyAjcGxheWVyPmAgb3JcbiAgICogYDxsaSB0ZW1wbGF0ZT1cImZvciAjaXRlbSBvZiBpdGVtc1wiPmAsIHdoZXJlIFwicGxheWVyXCIgYW5kIFwiaXRlbVwiIGFyZSBsb2NhbHMsIHJlc3BlY3RpdmVseS5cbiAgICovXG4gIGxvY2FsczogTG9jYWxzO1xuXG4gIHBpcGVzOiBQaXBlcztcblxuICBwYXJlbnRJbmplY3RvcjogSW5qZWN0b3I7XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgcm9vdCBpbmplY3RvcnMgb2YgdGhpcyB2aWV3XG4gICAqIGhhdmUgYSBob3N0Qm91bmRhcnkuXG4gICAqL1xuICBob3N0SW5qZWN0b3JCb3VuZGFyeTogYm9vbGVhbjtcblxuICBkZXN0cm95ZWQ6IGJvb2xlYW4gPSBmYWxzZTtcblxuICBjb25zdHJ1Y3RvcihwdWJsaWMgcHJvdG86IEFwcFByb3RvVmlldywgcHVibGljIHJlbmRlcmVyOiBSZW5kZXJlcixcbiAgICAgICAgICAgICAgcHVibGljIHZpZXdNYW5hZ2VyOiBBcHBWaWV3TWFuYWdlcl8sIHB1YmxpYyBwcm9qZWN0YWJsZU5vZGVzOiBBcnJheTxhbnkgfCBhbnlbXT4sXG4gICAgICAgICAgICAgIHB1YmxpYyBjb250YWluZXJBcHBFbGVtZW50OiBBcHBFbGVtZW50LFxuICAgICAgICAgICAgICBpbXBlcmF0aXZlbHlDcmVhdGVkUHJvdmlkZXJzOiBSZXNvbHZlZFByb3ZpZGVyW10sIHJvb3RJbmplY3RvcjogSW5qZWN0b3IsXG4gICAgICAgICAgICAgIHB1YmxpYyBjaGFuZ2VEZXRlY3RvcjogQ2hhbmdlRGV0ZWN0b3IpIHtcbiAgICB0aGlzLnJlZiA9IG5ldyBWaWV3UmVmXyh0aGlzKTtcbiAgICB2YXIgaW5qZWN0b3JXaXRoSG9zdEJvdW5kYXJ5ID0gQXBwRWxlbWVudC5nZXRWaWV3UGFyZW50SW5qZWN0b3IoXG4gICAgICAgIHRoaXMucHJvdG8udHlwZSwgY29udGFpbmVyQXBwRWxlbWVudCwgaW1wZXJhdGl2ZWx5Q3JlYXRlZFByb3ZpZGVycywgcm9vdEluamVjdG9yKTtcbiAgICB0aGlzLnBhcmVudEluamVjdG9yID0gaW5qZWN0b3JXaXRoSG9zdEJvdW5kYXJ5LmluamVjdG9yO1xuICAgIHRoaXMuaG9zdEluamVjdG9yQm91bmRhcnkgPSBpbmplY3RvcldpdGhIb3N0Qm91bmRhcnkuaG9zdEluamVjdG9yQm91bmRhcnk7XG4gICAgdmFyIHBpcGVzO1xuICAgIHZhciBjb250ZXh0O1xuICAgIHN3aXRjaCAocHJvdG8udHlwZSkge1xuICAgICAgY2FzZSBWaWV3VHlwZS5DT01QT05FTlQ6XG4gICAgICAgIHBpcGVzID0gbmV3IFBpcGVzKHByb3RvLnByb3RvUGlwZXMsIGNvbnRhaW5lckFwcEVsZW1lbnQuZ2V0SW5qZWN0b3IoKSk7XG4gICAgICAgIGNvbnRleHQgPSBjb250YWluZXJBcHBFbGVtZW50LmdldENvbXBvbmVudCgpO1xuICAgICAgICBicmVhaztcbiAgICAgIGNhc2UgVmlld1R5cGUuRU1CRURERUQ6XG4gICAgICAgIHBpcGVzID0gY29udGFpbmVyQXBwRWxlbWVudC5wYXJlbnRWaWV3LnBpcGVzO1xuICAgICAgICBjb250ZXh0ID0gY29udGFpbmVyQXBwRWxlbWVudC5wYXJlbnRWaWV3LmNvbnRleHQ7XG4gICAgICAgIGJyZWFrO1xuICAgICAgY2FzZSBWaWV3VHlwZS5IT1NUOlxuICAgICAgICBwaXBlcyA9IG51bGw7XG4gICAgICAgIGNvbnRleHQgPSBFTVBUWV9DT05URVhUO1xuICAgICAgICBicmVhaztcbiAgICB9XG4gICAgdGhpcy5waXBlcyA9IHBpcGVzO1xuICAgIHRoaXMuY29udGV4dCA9IGNvbnRleHQ7XG4gIH1cblxuICBpbml0KHJvb3ROb2Rlc09yQXBwRWxlbWVudHM6IGFueVtdLCBhbGxOb2RlczogYW55W10sIGRpc3Bvc2FibGVzOiBGdW5jdGlvbltdLFxuICAgICAgIGFwcEVsZW1lbnRzOiBBcHBFbGVtZW50W10pIHtcbiAgICB0aGlzLnJvb3ROb2Rlc09yQXBwRWxlbWVudHMgPSByb290Tm9kZXNPckFwcEVsZW1lbnRzO1xuICAgIHRoaXMuYWxsTm9kZXMgPSBhbGxOb2RlcztcbiAgICB0aGlzLmRpc3Bvc2FibGVzID0gZGlzcG9zYWJsZXM7XG4gICAgdGhpcy5hcHBFbGVtZW50cyA9IGFwcEVsZW1lbnRzO1xuICAgIHZhciBsb2NhbHNNYXAgPSBuZXcgTWFwPHN0cmluZywgYW55PigpO1xuICAgIFN0cmluZ01hcFdyYXBwZXIuZm9yRWFjaCh0aGlzLnByb3RvLnRlbXBsYXRlVmFyaWFibGVCaW5kaW5ncyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgKHRlbXBsYXRlTmFtZSwgXykgPT4geyBsb2NhbHNNYXAuc2V0KHRlbXBsYXRlTmFtZSwgbnVsbCk7IH0pO1xuICAgIGZvciAodmFyIGkgPSAwOyBpIDwgYXBwRWxlbWVudHMubGVuZ3RoOyBpKyspIHtcbiAgICAgIHZhciBhcHBFbCA9IGFwcEVsZW1lbnRzW2ldO1xuICAgICAgdmFyIHByb3ZpZGVyVG9rZW5zID0gW107XG4gICAgICBpZiAoaXNQcmVzZW50KGFwcEVsLnByb3RvLnByb3RvSW5qZWN0b3IpKSB7XG4gICAgICAgIGZvciAodmFyIGogPSAwOyBqIDwgYXBwRWwucHJvdG8ucHJvdG9JbmplY3Rvci5udW1iZXJPZlByb3ZpZGVyczsgaisrKSB7XG4gICAgICAgICAgcHJvdmlkZXJUb2tlbnMucHVzaChhcHBFbC5wcm90by5wcm90b0luamVjdG9yLmdldFByb3ZpZGVyQXRJbmRleChqKS5rZXkudG9rZW4pO1xuICAgICAgICB9XG4gICAgICB9XG4gICAgICBTdHJpbmdNYXBXcmFwcGVyLmZvckVhY2goYXBwRWwucHJvdG8uZGlyZWN0aXZlVmFyaWFibGVCaW5kaW5ncywgKGRpcmVjdGl2ZUluZGV4LCBuYW1lKSA9PiB7XG4gICAgICAgIGlmIChpc0JsYW5rKGRpcmVjdGl2ZUluZGV4KSkge1xuICAgICAgICAgIGxvY2Fsc01hcC5zZXQobmFtZSwgYXBwRWwubmF0aXZlRWxlbWVudCk7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgbG9jYWxzTWFwLnNldChuYW1lLCBhcHBFbC5nZXREaXJlY3RpdmVBdEluZGV4KGRpcmVjdGl2ZUluZGV4KSk7XG4gICAgICAgIH1cbiAgICAgIH0pO1xuICAgICAgdGhpcy5yZW5kZXJlci5zZXRFbGVtZW50RGVidWdJbmZvKFxuICAgICAgICAgIGFwcEVsLm5hdGl2ZUVsZW1lbnQsIG5ldyBSZW5kZXJEZWJ1Z0luZm8oYXBwRWwuZ2V0SW5qZWN0b3IoKSwgYXBwRWwuZ2V0Q29tcG9uZW50KCksXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBwcm92aWRlclRva2VucywgbG9jYWxzTWFwKSk7XG4gICAgfVxuICAgIHZhciBwYXJlbnRMb2NhbHMgPSBudWxsO1xuICAgIGlmICh0aGlzLnByb3RvLnR5cGUgIT09IFZpZXdUeXBlLkNPTVBPTkVOVCkge1xuICAgICAgcGFyZW50TG9jYWxzID1cbiAgICAgICAgICBpc1ByZXNlbnQodGhpcy5jb250YWluZXJBcHBFbGVtZW50KSA/IHRoaXMuY29udGFpbmVyQXBwRWxlbWVudC5wYXJlbnRWaWV3LmxvY2FscyA6IG51bGw7XG4gICAgfVxuICAgIGlmICh0aGlzLnByb3RvLnR5cGUgPT09IFZpZXdUeXBlLkNPTVBPTkVOVCkge1xuICAgICAgLy8gTm90ZTogdGhlIHJlbmRlciBub2RlcyBoYXZlIGJlZW4gYXR0YWNoZWQgdG8gdGhlaXIgaG9zdCBlbGVtZW50XG4gICAgICAvLyBpbiB0aGUgVmlld0ZhY3RvcnkgYWxyZWFkeS5cbiAgICAgIHRoaXMuY29udGFpbmVyQXBwRWxlbWVudC5hdHRhY2hDb21wb25lbnRWaWV3KHRoaXMpO1xuICAgICAgdGhpcy5jb250YWluZXJBcHBFbGVtZW50LnBhcmVudFZpZXcuY2hhbmdlRGV0ZWN0b3IuYWRkVmlld0NoaWxkKHRoaXMuY2hhbmdlRGV0ZWN0b3IpO1xuICAgIH1cbiAgICB0aGlzLmxvY2FscyA9IG5ldyBMb2NhbHMocGFyZW50TG9jYWxzLCBsb2NhbHNNYXApO1xuICAgIHRoaXMuY2hhbmdlRGV0ZWN0b3IuaHlkcmF0ZSh0aGlzLmNvbnRleHQsIHRoaXMubG9jYWxzLCB0aGlzLCB0aGlzLnBpcGVzKTtcbiAgICB0aGlzLnZpZXdNYW5hZ2VyLm9uVmlld0NyZWF0ZWQodGhpcyk7XG4gIH1cblxuICBkZXN0cm95KCkge1xuICAgIGlmICh0aGlzLmRlc3Ryb3llZCkge1xuICAgICAgdGhyb3cgbmV3IEJhc2VFeGNlcHRpb24oJ1RoaXMgdmlldyBoYXMgYWxyZWFkeSBiZWVuIGRlc3Ryb3llZCEnKTtcbiAgICB9XG4gICAgdGhpcy5jaGFuZ2VEZXRlY3Rvci5kZXN0cm95UmVjdXJzaXZlKCk7XG4gIH1cblxuICBub3RpZnlPbkRlc3Ryb3koKSB7XG4gICAgdGhpcy5kZXN0cm95ZWQgPSB0cnVlO1xuICAgIHZhciBob3N0RWxlbWVudCA9XG4gICAgICAgIHRoaXMucHJvdG8udHlwZSA9PT0gVmlld1R5cGUuQ09NUE9ORU5UID8gdGhpcy5jb250YWluZXJBcHBFbGVtZW50Lm5hdGl2ZUVsZW1lbnQgOiBudWxsO1xuICAgIHRoaXMucmVuZGVyZXIuZGVzdHJveVZpZXcoaG9zdEVsZW1lbnQsIHRoaXMuYWxsTm9kZXMpO1xuICAgIGZvciAodmFyIGkgPSAwOyBpIDwgdGhpcy5kaXNwb3NhYmxlcy5sZW5ndGg7IGkrKykge1xuICAgICAgdGhpcy5kaXNwb3NhYmxlc1tpXSgpO1xuICAgIH1cbiAgICB0aGlzLnZpZXdNYW5hZ2VyLm9uVmlld0Rlc3Ryb3llZCh0aGlzKTtcbiAgfVxuXG4gIGdldCBjaGFuZ2VEZXRlY3RvclJlZigpOiBDaGFuZ2VEZXRlY3RvclJlZiB7IHJldHVybiB0aGlzLmNoYW5nZURldGVjdG9yLnJlZjsgfVxuXG4gIGdldCBmbGF0Um9vdE5vZGVzKCk6IGFueVtdIHsgcmV0dXJuIGZsYXR0ZW5OZXN0ZWRWaWV3UmVuZGVyTm9kZXModGhpcy5yb290Tm9kZXNPckFwcEVsZW1lbnRzKTsgfVxuXG4gIGhhc0xvY2FsKGNvbnRleHROYW1lOiBzdHJpbmcpOiBib29sZWFuIHtcbiAgICByZXR1cm4gU3RyaW5nTWFwV3JhcHBlci5jb250YWlucyh0aGlzLnByb3RvLnRlbXBsYXRlVmFyaWFibGVCaW5kaW5ncywgY29udGV4dE5hbWUpO1xuICB9XG5cbiAgc2V0TG9jYWwoY29udGV4dE5hbWU6IHN0cmluZywgdmFsdWU6IGFueSk6IHZvaWQge1xuICAgIGlmICghdGhpcy5oYXNMb2NhbChjb250ZXh0TmFtZSkpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG4gICAgdmFyIHRlbXBsYXRlTmFtZSA9IHRoaXMucHJvdG8udGVtcGxhdGVWYXJpYWJsZUJpbmRpbmdzW2NvbnRleHROYW1lXTtcbiAgICB0aGlzLmxvY2Fscy5zZXQodGVtcGxhdGVOYW1lLCB2YWx1ZSk7XG4gIH1cblxuICAvLyBkaXNwYXRjaCB0byBlbGVtZW50IGluamVjdG9yIG9yIHRleHQgbm9kZXMgYmFzZWQgb24gY29udGV4dFxuICBub3RpZnlPbkJpbmRpbmcoYjogQmluZGluZ1RhcmdldCwgY3VycmVudFZhbHVlOiBhbnkpOiB2b2lkIHtcbiAgICBpZiAoYi5pc1RleHROb2RlKCkpIHtcbiAgICAgIHRoaXMucmVuZGVyZXIuc2V0VGV4dCh0aGlzLmFsbE5vZGVzW2IuZWxlbWVudEluZGV4XSwgY3VycmVudFZhbHVlKTtcbiAgICB9IGVsc2Uge1xuICAgICAgdmFyIG5hdGl2ZUVsZW1lbnQgPSB0aGlzLmFwcEVsZW1lbnRzW2IuZWxlbWVudEluZGV4XS5uYXRpdmVFbGVtZW50O1xuICAgICAgaWYgKGIuaXNFbGVtZW50UHJvcGVydHkoKSkge1xuICAgICAgICB0aGlzLnJlbmRlcmVyLnNldEVsZW1lbnRQcm9wZXJ0eShuYXRpdmVFbGVtZW50LCBiLm5hbWUsIGN1cnJlbnRWYWx1ZSk7XG4gICAgICB9IGVsc2UgaWYgKGIuaXNFbGVtZW50QXR0cmlidXRlKCkpIHtcbiAgICAgICAgdGhpcy5yZW5kZXJlci5zZXRFbGVtZW50QXR0cmlidXRlKG5hdGl2ZUVsZW1lbnQsIGIubmFtZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGlzUHJlc2VudChjdXJyZW50VmFsdWUpID8gYCR7Y3VycmVudFZhbHVlfWAgOiBudWxsKTtcbiAgICAgIH0gZWxzZSBpZiAoYi5pc0VsZW1lbnRDbGFzcygpKSB7XG4gICAgICAgIHRoaXMucmVuZGVyZXIuc2V0RWxlbWVudENsYXNzKG5hdGl2ZUVsZW1lbnQsIGIubmFtZSwgY3VycmVudFZhbHVlKTtcbiAgICAgIH0gZWxzZSBpZiAoYi5pc0VsZW1lbnRTdHlsZSgpKSB7XG4gICAgICAgIHZhciB1bml0ID0gaXNQcmVzZW50KGIudW5pdCkgPyBiLnVuaXQgOiAnJztcbiAgICAgICAgdGhpcy5yZW5kZXJlci5zZXRFbGVtZW50U3R5bGUobmF0aXZlRWxlbWVudCwgYi5uYW1lLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBpc1ByZXNlbnQoY3VycmVudFZhbHVlKSA/IGAke2N1cnJlbnRWYWx1ZX0ke3VuaXR9YCA6IG51bGwpO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgdGhyb3cgbmV3IEJhc2VFeGNlcHRpb24oJ1Vuc3VwcG9ydGVkIGRpcmVjdGl2ZSByZWNvcmQnKTtcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICBsb2dCaW5kaW5nVXBkYXRlKGI6IEJpbmRpbmdUYXJnZXQsIHZhbHVlOiBhbnkpOiB2b2lkIHtcbiAgICBpZiAoYi5pc0RpcmVjdGl2ZSgpIHx8IGIuaXNFbGVtZW50UHJvcGVydHkoKSkge1xuICAgICAgdmFyIG5hdGl2ZUVsZW1lbnQgPSB0aGlzLmFwcEVsZW1lbnRzW2IuZWxlbWVudEluZGV4XS5uYXRpdmVFbGVtZW50O1xuICAgICAgdGhpcy5yZW5kZXJlci5zZXRCaW5kaW5nRGVidWdJbmZvKFxuICAgICAgICAgIG5hdGl2ZUVsZW1lbnQsIGAke1JFRkxFQ1RfUFJFRklYfSR7Y2FtZWxDYXNlVG9EYXNoQ2FzZShiLm5hbWUpfWAsIGAke3ZhbHVlfWApO1xuICAgIH1cbiAgfVxuXG4gIG5vdGlmeUFmdGVyQ29udGVudENoZWNrZWQoKTogdm9pZCB7XG4gICAgdmFyIGNvdW50ID0gdGhpcy5hcHBFbGVtZW50cy5sZW5ndGg7XG4gICAgZm9yICh2YXIgaSA9IGNvdW50IC0gMTsgaSA+PSAwOyBpLS0pIHtcbiAgICAgIHRoaXMuYXBwRWxlbWVudHNbaV0ubmdBZnRlckNvbnRlbnRDaGVja2VkKCk7XG4gICAgfVxuICB9XG5cbiAgbm90aWZ5QWZ0ZXJWaWV3Q2hlY2tlZCgpOiB2b2lkIHtcbiAgICB2YXIgY291bnQgPSB0aGlzLmFwcEVsZW1lbnRzLmxlbmd0aDtcbiAgICBmb3IgKHZhciBpID0gY291bnQgLSAxOyBpID49IDA7IGktLSkge1xuICAgICAgdGhpcy5hcHBFbGVtZW50c1tpXS5uZ0FmdGVyVmlld0NoZWNrZWQoKTtcbiAgICB9XG4gIH1cblxuICBnZXREZWJ1Z0NvbnRleHQoYXBwRWxlbWVudDogQXBwRWxlbWVudCwgZWxlbWVudEluZGV4OiBudW1iZXIsXG4gICAgICAgICAgICAgICAgICBkaXJlY3RpdmVJbmRleDogbnVtYmVyKTogRGVidWdDb250ZXh0IHtcbiAgICB0cnkge1xuICAgICAgaWYgKGlzQmxhbmsoYXBwRWxlbWVudCkgJiYgZWxlbWVudEluZGV4IDwgdGhpcy5hcHBFbGVtZW50cy5sZW5ndGgpIHtcbiAgICAgICAgYXBwRWxlbWVudCA9IHRoaXMuYXBwRWxlbWVudHNbZWxlbWVudEluZGV4XTtcbiAgICAgIH1cbiAgICAgIHZhciBjb250YWluZXIgPSB0aGlzLmNvbnRhaW5lckFwcEVsZW1lbnQ7XG5cbiAgICAgIHZhciBlbGVtZW50ID0gaXNQcmVzZW50KGFwcEVsZW1lbnQpID8gYXBwRWxlbWVudC5uYXRpdmVFbGVtZW50IDogbnVsbDtcbiAgICAgIHZhciBjb21wb25lbnRFbGVtZW50ID0gaXNQcmVzZW50KGNvbnRhaW5lcikgPyBjb250YWluZXIubmF0aXZlRWxlbWVudCA6IG51bGw7XG4gICAgICB2YXIgZGlyZWN0aXZlID1cbiAgICAgICAgICBpc1ByZXNlbnQoZGlyZWN0aXZlSW5kZXgpID8gYXBwRWxlbWVudC5nZXREaXJlY3RpdmVBdEluZGV4KGRpcmVjdGl2ZUluZGV4KSA6IG51bGw7XG4gICAgICB2YXIgaW5qZWN0b3IgPSBpc1ByZXNlbnQoYXBwRWxlbWVudCkgPyBhcHBFbGVtZW50LmdldEluamVjdG9yKCkgOiBudWxsO1xuXG4gICAgICByZXR1cm4gbmV3IERlYnVnQ29udGV4dChlbGVtZW50LCBjb21wb25lbnRFbGVtZW50LCBkaXJlY3RpdmUsIHRoaXMuY29udGV4dCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIF9sb2NhbHNUb1N0cmluZ01hcCh0aGlzLmxvY2FscyksIGluamVjdG9yKTtcblxuICAgIH0gY2F0Y2ggKGUpIHtcbiAgICAgIC8vIFRPRE86IHZzYXZraW4gbG9nIHRoZSBleGNlcHRpb24gb25jZSB3ZSBoYXZlIGEgZ29vZCB3YXkgdG8gbG9nIGVycm9ycyBhbmQgd2FybmluZ3NcbiAgICAgIC8vIGlmIGFuIGVycm9yIGhhcHBlbnMgZHVyaW5nIGdldHRpbmcgdGhlIGRlYnVnIGNvbnRleHQsIHdlIHJldHVybiBudWxsLlxuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxuICB9XG5cbiAgZ2V0RGlyZWN0aXZlRm9yKGRpcmVjdGl2ZTogRGlyZWN0aXZlSW5kZXgpOiBhbnkge1xuICAgIHJldHVybiB0aGlzLmFwcEVsZW1lbnRzW2RpcmVjdGl2ZS5lbGVtZW50SW5kZXhdLmdldERpcmVjdGl2ZUF0SW5kZXgoZGlyZWN0aXZlLmRpcmVjdGl2ZUluZGV4KTtcbiAgfVxuXG4gIGdldERldGVjdG9yRm9yKGRpcmVjdGl2ZTogRGlyZWN0aXZlSW5kZXgpOiBDaGFuZ2VEZXRlY3RvciB7XG4gICAgdmFyIGNvbXBvbmVudFZpZXcgPSB0aGlzLmFwcEVsZW1lbnRzW2RpcmVjdGl2ZS5lbGVtZW50SW5kZXhdLmNvbXBvbmVudFZpZXc7XG4gICAgcmV0dXJuIGlzUHJlc2VudChjb21wb25lbnRWaWV3KSA/IGNvbXBvbmVudFZpZXcuY2hhbmdlRGV0ZWN0b3IgOiBudWxsO1xuICB9XG5cbiAgLyoqXG4gICAqIFRyaWdnZXJzIHRoZSBldmVudCBoYW5kbGVycyBmb3IgdGhlIGVsZW1lbnQgYW5kIHRoZSBkaXJlY3RpdmVzLlxuICAgKlxuICAgKiBUaGlzIG1ldGhvZCBpcyBpbnRlbmRlZCB0byBiZSBjYWxsZWQgZnJvbSBkaXJlY3RpdmUgRXZlbnRFbWl0dGVycy5cbiAgICpcbiAgICogQHBhcmFtIHtzdHJpbmd9IGV2ZW50TmFtZVxuICAgKiBAcGFyYW0geyp9IGV2ZW50T2JqXG4gICAqIEBwYXJhbSB7bnVtYmVyfSBib3VuZEVsZW1lbnRJbmRleFxuICAgKiBAcmV0dXJuIGZhbHNlIGlmIHByZXZlbnREZWZhdWx0IG11c3QgYmUgYXBwbGllZCB0byB0aGUgRE9NIGV2ZW50XG4gICAqL1xuICB0cmlnZ2VyRXZlbnRIYW5kbGVycyhldmVudE5hbWU6IHN0cmluZywgZXZlbnRPYmo6IEV2ZW50LCBib3VuZEVsZW1lbnRJbmRleDogbnVtYmVyKTogYm9vbGVhbiB7XG4gICAgcmV0dXJuIHRoaXMuY2hhbmdlRGV0ZWN0b3IuaGFuZGxlRXZlbnQoZXZlbnROYW1lLCBib3VuZEVsZW1lbnRJbmRleCwgZXZlbnRPYmopO1xuICB9XG59XG5cbmZ1bmN0aW9uIF9sb2NhbHNUb1N0cmluZ01hcChsb2NhbHM6IExvY2Fscyk6IHtba2V5OiBzdHJpbmddOiBhbnl9IHtcbiAgdmFyIHJlcyA9IHt9O1xuICB2YXIgYyA9IGxvY2FscztcbiAgd2hpbGUgKGlzUHJlc2VudChjKSkge1xuICAgIHJlcyA9IFN0cmluZ01hcFdyYXBwZXIubWVyZ2UocmVzLCBNYXBXcmFwcGVyLnRvU3RyaW5nTWFwKGMuY3VycmVudCkpO1xuICAgIGMgPSBjLnBhcmVudDtcbiAgfVxuICByZXR1cm4gcmVzO1xufVxuXG4vKipcbiAqXG4gKi9cbmV4cG9ydCBjbGFzcyBBcHBQcm90b1ZpZXcge1xuICBzdGF0aWMgY3JlYXRlKG1ldGFkYXRhQ2FjaGU6IFJlc29sdmVkTWV0YWRhdGFDYWNoZSwgdHlwZTogVmlld1R5cGUsIHBpcGVzOiBUeXBlW10sXG4gICAgICAgICAgICAgICAgdGVtcGxhdGVWYXJpYWJsZUJpbmRpbmdzOiB7W2tleTogc3RyaW5nXTogc3RyaW5nfSk6IEFwcFByb3RvVmlldyB7XG4gICAgdmFyIHByb3RvUGlwZXMgPSBudWxsO1xuICAgIGlmIChpc1ByZXNlbnQocGlwZXMpICYmIHBpcGVzLmxlbmd0aCA+IDApIHtcbiAgICAgIHZhciBib3VuZFBpcGVzID0gTGlzdFdyYXBwZXIuY3JlYXRlRml4ZWRTaXplKHBpcGVzLmxlbmd0aCk7XG4gICAgICBmb3IgKHZhciBpID0gMDsgaSA8IHBpcGVzLmxlbmd0aDsgaSsrKSB7XG4gICAgICAgIGJvdW5kUGlwZXNbaV0gPSBtZXRhZGF0YUNhY2hlLmdldFJlc29sdmVkUGlwZU1ldGFkYXRhKHBpcGVzW2ldKTtcbiAgICAgIH1cbiAgICAgIHByb3RvUGlwZXMgPSBQcm90b1BpcGVzLmZyb21Qcm92aWRlcnMoYm91bmRQaXBlcyk7XG4gICAgfVxuICAgIHJldHVybiBuZXcgQXBwUHJvdG9WaWV3KHR5cGUsIHByb3RvUGlwZXMsIHRlbXBsYXRlVmFyaWFibGVCaW5kaW5ncyk7XG4gIH1cblxuICBjb25zdHJ1Y3RvcihwdWJsaWMgdHlwZTogVmlld1R5cGUsIHB1YmxpYyBwcm90b1BpcGVzOiBQcm90b1BpcGVzLFxuICAgICAgICAgICAgICBwdWJsaWMgdGVtcGxhdGVWYXJpYWJsZUJpbmRpbmdzOiB7W2tleTogc3RyaW5nXTogc3RyaW5nfSkge31cbn1cblxuXG5AQ09OU1QoKVxuZXhwb3J0IGNsYXNzIEhvc3RWaWV3RmFjdG9yeSB7XG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBzZWxlY3Rvcjogc3RyaW5nLCBwdWJsaWMgdmlld0ZhY3Rvcnk6IEZ1bmN0aW9uKSB7fVxufVxuXG5leHBvcnQgZnVuY3Rpb24gZmxhdHRlbk5lc3RlZFZpZXdSZW5kZXJOb2Rlcyhub2RlczogYW55W10pOiBhbnlbXSB7XG4gIHJldHVybiBfZmxhdHRlbk5lc3RlZFZpZXdSZW5kZXJOb2Rlcyhub2RlcywgW10pO1xufVxuXG5mdW5jdGlvbiBfZmxhdHRlbk5lc3RlZFZpZXdSZW5kZXJOb2Rlcyhub2RlczogYW55W10sIHJlbmRlck5vZGVzOiBhbnlbXSk6IGFueVtdIHtcbiAgZm9yICh2YXIgaSA9IDA7IGkgPCBub2Rlcy5sZW5ndGg7IGkrKykge1xuICAgIHZhciBub2RlID0gbm9kZXNbaV07XG4gICAgaWYgKG5vZGUgaW5zdGFuY2VvZiBBcHBFbGVtZW50KSB7XG4gICAgICB2YXIgYXBwRWwgPSA8QXBwRWxlbWVudD5ub2RlO1xuICAgICAgcmVuZGVyTm9kZXMucHVzaChhcHBFbC5uYXRpdmVFbGVtZW50KTtcbiAgICAgIGlmIChpc1ByZXNlbnQoYXBwRWwubmVzdGVkVmlld3MpKSB7XG4gICAgICAgIGZvciAodmFyIGsgPSAwOyBrIDwgYXBwRWwubmVzdGVkVmlld3MubGVuZ3RoOyBrKyspIHtcbiAgICAgICAgICBfZmxhdHRlbk5lc3RlZFZpZXdSZW5kZXJOb2RlcyhhcHBFbC5uZXN0ZWRWaWV3c1trXS5yb290Tm9kZXNPckFwcEVsZW1lbnRzLCByZW5kZXJOb2Rlcyk7XG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9IGVsc2Uge1xuICAgICAgcmVuZGVyTm9kZXMucHVzaChub2RlKTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHJlbmRlck5vZGVzO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gY2hlY2tTbG90Q291bnQoY29tcG9uZW50TmFtZTogc3RyaW5nLCBleHBlY3RlZFNsb3RDb3VudDogbnVtYmVyLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHByb2plY3RhYmxlTm9kZXM6IGFueVtdW10pOiB2b2lkIHtcbiAgdmFyIGdpdmVuU2xvdENvdW50ID0gaXNQcmVzZW50KHByb2plY3RhYmxlTm9kZXMpID8gcHJvamVjdGFibGVOb2Rlcy5sZW5ndGggOiAwO1xuICBpZiAoZ2l2ZW5TbG90Q291bnQgPCBleHBlY3RlZFNsb3RDb3VudCkge1xuICAgIHRocm93IG5ldyBCYXNlRXhjZXB0aW9uKFxuICAgICAgICBgVGhlIGNvbXBvbmVudCAke2NvbXBvbmVudE5hbWV9IGhhcyAke2V4cGVjdGVkU2xvdENvdW50fSA8bmctY29udGVudD4gZWxlbWVudHMsYCArXG4gICAgICAgIGAgYnV0IG9ubHkgJHtnaXZlblNsb3RDb3VudH0gc2xvdHMgd2VyZSBwcm92aWRlZC5gKTtcbiAgfVxufVxuIl19