"format register";
System.register("angular2/src/facade/lang", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var globalScope;
  if (typeof window === 'undefined') {
    if (typeof WorkerGlobalScope !== 'undefined' && self instanceof WorkerGlobalScope) {
      globalScope = self;
    } else {
      globalScope = global;
    }
  } else {
    globalScope = window;
  }
  exports.IS_DART = false;
  var _global = globalScope;
  exports.global = _global;
  exports.Type = Function;
  function getTypeNameForDebugging(type) {
    return type['name'];
  }
  exports.getTypeNameForDebugging = getTypeNameForDebugging;
  exports.Math = _global.Math;
  exports.Date = _global.Date;
  var _devMode = true;
  var _modeLocked = false;
  function lockMode() {
    _modeLocked = true;
  }
  exports.lockMode = lockMode;
  function enableProdMode() {
    if (_modeLocked) {
      throw 'Cannot enable prod mode after platform setup.';
    }
    _devMode = false;
  }
  exports.enableProdMode = enableProdMode;
  function assertionsEnabled() {
    return _devMode;
  }
  exports.assertionsEnabled = assertionsEnabled;
  _global.assert = function assert(condition) {};
  function CONST_EXPR(expr) {
    return expr;
  }
  exports.CONST_EXPR = CONST_EXPR;
  function CONST() {
    return function(target) {
      return target;
    };
  }
  exports.CONST = CONST;
  function isPresent(obj) {
    return obj !== undefined && obj !== null;
  }
  exports.isPresent = isPresent;
  function isBlank(obj) {
    return obj === undefined || obj === null;
  }
  exports.isBlank = isBlank;
  function isString(obj) {
    return typeof obj === "string";
  }
  exports.isString = isString;
  function isFunction(obj) {
    return typeof obj === "function";
  }
  exports.isFunction = isFunction;
  function isType(obj) {
    return isFunction(obj);
  }
  exports.isType = isType;
  function isStringMap(obj) {
    return typeof obj === 'object' && obj !== null;
  }
  exports.isStringMap = isStringMap;
  function isPromise(obj) {
    return obj instanceof _global.Promise;
  }
  exports.isPromise = isPromise;
  function isArray(obj) {
    return Array.isArray(obj);
  }
  exports.isArray = isArray;
  function isNumber(obj) {
    return typeof obj === 'number';
  }
  exports.isNumber = isNumber;
  function isDate(obj) {
    return obj instanceof exports.Date && !isNaN(obj.valueOf());
  }
  exports.isDate = isDate;
  function noop() {}
  exports.noop = noop;
  function stringify(token) {
    if (typeof token === 'string') {
      return token;
    }
    if (token === undefined || token === null) {
      return '' + token;
    }
    if (token.name) {
      return token.name;
    }
    if (token.overriddenName) {
      return token.overriddenName;
    }
    var res = token.toString();
    var newLineIndex = res.indexOf("\n");
    return (newLineIndex === -1) ? res : res.substring(0, newLineIndex);
  }
  exports.stringify = stringify;
  function serializeEnum(val) {
    return val;
  }
  exports.serializeEnum = serializeEnum;
  function deserializeEnum(val, values) {
    return val;
  }
  exports.deserializeEnum = deserializeEnum;
  var StringWrapper = (function() {
    function StringWrapper() {}
    StringWrapper.fromCharCode = function(code) {
      return String.fromCharCode(code);
    };
    StringWrapper.charCodeAt = function(s, index) {
      return s.charCodeAt(index);
    };
    StringWrapper.split = function(s, regExp) {
      return s.split(regExp);
    };
    StringWrapper.equals = function(s, s2) {
      return s === s2;
    };
    StringWrapper.stripLeft = function(s, charVal) {
      if (s && s.length) {
        var pos = 0;
        for (var i = 0; i < s.length; i++) {
          if (s[i] != charVal)
            break;
          pos++;
        }
        s = s.substring(pos);
      }
      return s;
    };
    StringWrapper.stripRight = function(s, charVal) {
      if (s && s.length) {
        var pos = s.length;
        for (var i = s.length - 1; i >= 0; i--) {
          if (s[i] != charVal)
            break;
          pos--;
        }
        s = s.substring(0, pos);
      }
      return s;
    };
    StringWrapper.replace = function(s, from, replace) {
      return s.replace(from, replace);
    };
    StringWrapper.replaceAll = function(s, from, replace) {
      return s.replace(from, replace);
    };
    StringWrapper.slice = function(s, from, to) {
      if (from === void 0) {
        from = 0;
      }
      if (to === void 0) {
        to = null;
      }
      return s.slice(from, to === null ? undefined : to);
    };
    StringWrapper.replaceAllMapped = function(s, from, cb) {
      return s.replace(from, function() {
        var matches = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          matches[_i - 0] = arguments[_i];
        }
        matches.splice(-2, 2);
        return cb(matches);
      });
    };
    StringWrapper.contains = function(s, substr) {
      return s.indexOf(substr) != -1;
    };
    StringWrapper.compare = function(a, b) {
      if (a < b) {
        return -1;
      } else if (a > b) {
        return 1;
      } else {
        return 0;
      }
    };
    return StringWrapper;
  })();
  exports.StringWrapper = StringWrapper;
  var StringJoiner = (function() {
    function StringJoiner(parts) {
      if (parts === void 0) {
        parts = [];
      }
      this.parts = parts;
    }
    StringJoiner.prototype.add = function(part) {
      this.parts.push(part);
    };
    StringJoiner.prototype.toString = function() {
      return this.parts.join("");
    };
    return StringJoiner;
  })();
  exports.StringJoiner = StringJoiner;
  var NumberParseError = (function(_super) {
    __extends(NumberParseError, _super);
    function NumberParseError(message) {
      _super.call(this);
      this.message = message;
    }
    NumberParseError.prototype.toString = function() {
      return this.message;
    };
    return NumberParseError;
  })(Error);
  exports.NumberParseError = NumberParseError;
  var NumberWrapper = (function() {
    function NumberWrapper() {}
    NumberWrapper.toFixed = function(n, fractionDigits) {
      return n.toFixed(fractionDigits);
    };
    NumberWrapper.equal = function(a, b) {
      return a === b;
    };
    NumberWrapper.parseIntAutoRadix = function(text) {
      var result = parseInt(text);
      if (isNaN(result)) {
        throw new NumberParseError("Invalid integer literal when parsing " + text);
      }
      return result;
    };
    NumberWrapper.parseInt = function(text, radix) {
      if (radix == 10) {
        if (/^(\-|\+)?[0-9]+$/.test(text)) {
          return parseInt(text, radix);
        }
      } else if (radix == 16) {
        if (/^(\-|\+)?[0-9ABCDEFabcdef]+$/.test(text)) {
          return parseInt(text, radix);
        }
      } else {
        var result = parseInt(text, radix);
        if (!isNaN(result)) {
          return result;
        }
      }
      throw new NumberParseError("Invalid integer literal when parsing " + text + " in base " + radix);
    };
    NumberWrapper.parseFloat = function(text) {
      return parseFloat(text);
    };
    Object.defineProperty(NumberWrapper, "NaN", {
      get: function() {
        return NaN;
      },
      enumerable: true,
      configurable: true
    });
    NumberWrapper.isNaN = function(value) {
      return isNaN(value);
    };
    NumberWrapper.isInteger = function(value) {
      return Number.isInteger(value);
    };
    return NumberWrapper;
  })();
  exports.NumberWrapper = NumberWrapper;
  exports.RegExp = _global.RegExp;
  var RegExpWrapper = (function() {
    function RegExpWrapper() {}
    RegExpWrapper.create = function(regExpStr, flags) {
      if (flags === void 0) {
        flags = '';
      }
      flags = flags.replace(/g/g, '');
      return new _global.RegExp(regExpStr, flags + 'g');
    };
    RegExpWrapper.firstMatch = function(regExp, input) {
      regExp.lastIndex = 0;
      return regExp.exec(input);
    };
    RegExpWrapper.test = function(regExp, input) {
      regExp.lastIndex = 0;
      return regExp.test(input);
    };
    RegExpWrapper.matcher = function(regExp, input) {
      regExp.lastIndex = 0;
      return {
        re: regExp,
        input: input
      };
    };
    return RegExpWrapper;
  })();
  exports.RegExpWrapper = RegExpWrapper;
  var RegExpMatcherWrapper = (function() {
    function RegExpMatcherWrapper() {}
    RegExpMatcherWrapper.next = function(matcher) {
      return matcher.re.exec(matcher.input);
    };
    return RegExpMatcherWrapper;
  })();
  exports.RegExpMatcherWrapper = RegExpMatcherWrapper;
  var FunctionWrapper = (function() {
    function FunctionWrapper() {}
    FunctionWrapper.apply = function(fn, posArgs) {
      return fn.apply(null, posArgs);
    };
    return FunctionWrapper;
  })();
  exports.FunctionWrapper = FunctionWrapper;
  function looseIdentical(a, b) {
    return a === b || typeof a === "number" && typeof b === "number" && isNaN(a) && isNaN(b);
  }
  exports.looseIdentical = looseIdentical;
  function getMapKey(value) {
    return value;
  }
  exports.getMapKey = getMapKey;
  function normalizeBlank(obj) {
    return isBlank(obj) ? null : obj;
  }
  exports.normalizeBlank = normalizeBlank;
  function normalizeBool(obj) {
    return isBlank(obj) ? false : obj;
  }
  exports.normalizeBool = normalizeBool;
  function isJsObject(o) {
    return o !== null && (typeof o === "function" || typeof o === "object");
  }
  exports.isJsObject = isJsObject;
  function print(obj) {
    console.log(obj);
  }
  exports.print = print;
  var Json = (function() {
    function Json() {}
    Json.parse = function(s) {
      return _global.JSON.parse(s);
    };
    Json.stringify = function(data) {
      return _global.JSON.stringify(data, null, 2);
    };
    return Json;
  })();
  exports.Json = Json;
  var DateWrapper = (function() {
    function DateWrapper() {}
    DateWrapper.create = function(year, month, day, hour, minutes, seconds, milliseconds) {
      if (month === void 0) {
        month = 1;
      }
      if (day === void 0) {
        day = 1;
      }
      if (hour === void 0) {
        hour = 0;
      }
      if (minutes === void 0) {
        minutes = 0;
      }
      if (seconds === void 0) {
        seconds = 0;
      }
      if (milliseconds === void 0) {
        milliseconds = 0;
      }
      return new exports.Date(year, month - 1, day, hour, minutes, seconds, milliseconds);
    };
    DateWrapper.fromISOString = function(str) {
      return new exports.Date(str);
    };
    DateWrapper.fromMillis = function(ms) {
      return new exports.Date(ms);
    };
    DateWrapper.toMillis = function(date) {
      return date.getTime();
    };
    DateWrapper.now = function() {
      return new exports.Date();
    };
    DateWrapper.toJson = function(date) {
      return date.toJSON();
    };
    return DateWrapper;
  })();
  exports.DateWrapper = DateWrapper;
  function setValueOnPath(global, path, value) {
    var parts = path.split('.');
    var obj = global;
    while (parts.length > 1) {
      var name = parts.shift();
      if (obj.hasOwnProperty(name) && isPresent(obj[name])) {
        obj = obj[name];
      } else {
        obj = obj[name] = {};
      }
    }
    if (obj === undefined || obj === null) {
      obj = {};
    }
    obj[parts.shift()] = value;
  }
  exports.setValueOnPath = setValueOnPath;
  var _symbolIterator = null;
  function getSymbolIterator() {
    if (isBlank(_symbolIterator)) {
      if (isPresent(Symbol) && isPresent(Symbol.iterator)) {
        _symbolIterator = Symbol.iterator;
      } else {
        var keys = Object.getOwnPropertyNames(Map.prototype);
        for (var i = 0; i < keys.length; ++i) {
          var key = keys[i];
          if (key !== 'entries' && key !== 'size' && Map.prototype[key] === Map.prototype['entries']) {
            _symbolIterator = key;
          }
        }
      }
    }
    return _symbolIterator;
  }
  exports.getSymbolIterator = getSymbolIterator;
  function evalExpression(sourceUrl, expr, declarations, vars) {
    var fnBody = declarations + "\nreturn " + expr + "\n//# sourceURL=" + sourceUrl;
    var fnArgNames = [];
    var fnArgValues = [];
    for (var argName in vars) {
      fnArgNames.push(argName);
      fnArgValues.push(vars[argName]);
    }
    return new (Function.bind.apply(Function, [void 0].concat(fnArgNames.concat(fnBody))))().apply(void 0, fnArgValues);
  }
  exports.evalExpression = evalExpression;
  function isPrimitive(obj) {
    return !isJsObject(obj);
  }
  exports.isPrimitive = isPrimitive;
  function hasConstructor(value, type) {
    return value.constructor === type;
  }
  exports.hasConstructor = hasConstructor;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/di/metadata", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var InjectMetadata = (function() {
    function InjectMetadata(token) {
      this.token = token;
    }
    InjectMetadata.prototype.toString = function() {
      return "@Inject(" + lang_1.stringify(this.token) + ")";
    };
    InjectMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [Object])], InjectMetadata);
    return InjectMetadata;
  })();
  exports.InjectMetadata = InjectMetadata;
  var OptionalMetadata = (function() {
    function OptionalMetadata() {}
    OptionalMetadata.prototype.toString = function() {
      return "@Optional()";
    };
    OptionalMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [])], OptionalMetadata);
    return OptionalMetadata;
  })();
  exports.OptionalMetadata = OptionalMetadata;
  var DependencyMetadata = (function() {
    function DependencyMetadata() {}
    Object.defineProperty(DependencyMetadata.prototype, "token", {
      get: function() {
        return null;
      },
      enumerable: true,
      configurable: true
    });
    DependencyMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [])], DependencyMetadata);
    return DependencyMetadata;
  })();
  exports.DependencyMetadata = DependencyMetadata;
  var InjectableMetadata = (function() {
    function InjectableMetadata() {}
    InjectableMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [])], InjectableMetadata);
    return InjectableMetadata;
  })();
  exports.InjectableMetadata = InjectableMetadata;
  var SelfMetadata = (function() {
    function SelfMetadata() {}
    SelfMetadata.prototype.toString = function() {
      return "@Self()";
    };
    SelfMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [])], SelfMetadata);
    return SelfMetadata;
  })();
  exports.SelfMetadata = SelfMetadata;
  var SkipSelfMetadata = (function() {
    function SkipSelfMetadata() {}
    SkipSelfMetadata.prototype.toString = function() {
      return "@SkipSelf()";
    };
    SkipSelfMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [])], SkipSelfMetadata);
    return SkipSelfMetadata;
  })();
  exports.SkipSelfMetadata = SkipSelfMetadata;
  var HostMetadata = (function() {
    function HostMetadata() {}
    HostMetadata.prototype.toString = function() {
      return "@Host()";
    };
    HostMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [])], HostMetadata);
    return HostMetadata;
  })();
  exports.HostMetadata = HostMetadata;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/util/decorators", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var _nextClassId = 0;
  function extractAnnotation(annotation) {
    if (lang_1.isFunction(annotation) && annotation.hasOwnProperty('annotation')) {
      annotation = annotation.annotation;
    }
    return annotation;
  }
  function applyParams(fnOrArray, key) {
    if (fnOrArray === Object || fnOrArray === String || fnOrArray === Function || fnOrArray === Number || fnOrArray === Array) {
      throw new Error("Can not use native " + lang_1.stringify(fnOrArray) + " as constructor");
    }
    if (lang_1.isFunction(fnOrArray)) {
      return fnOrArray;
    } else if (fnOrArray instanceof Array) {
      var annotations = fnOrArray;
      var fn = fnOrArray[fnOrArray.length - 1];
      if (!lang_1.isFunction(fn)) {
        throw new Error("Last position of Class method array must be Function in key " + key + " was '" + lang_1.stringify(fn) + "'");
      }
      var annoLength = annotations.length - 1;
      if (annoLength != fn.length) {
        throw new Error("Number of annotations (" + annoLength + ") does not match number of arguments (" + fn.length + ") in the function: " + lang_1.stringify(fn));
      }
      var paramsAnnotations = [];
      for (var i = 0,
          ii = annotations.length - 1; i < ii; i++) {
        var paramAnnotations = [];
        paramsAnnotations.push(paramAnnotations);
        var annotation = annotations[i];
        if (annotation instanceof Array) {
          for (var j = 0; j < annotation.length; j++) {
            paramAnnotations.push(extractAnnotation(annotation[j]));
          }
        } else if (lang_1.isFunction(annotation)) {
          paramAnnotations.push(extractAnnotation(annotation));
        } else {
          paramAnnotations.push(annotation);
        }
      }
      Reflect.defineMetadata('parameters', paramsAnnotations, fn);
      return fn;
    } else {
      throw new Error("Only Function or Array is supported in Class definition for key '" + key + "' is '" + lang_1.stringify(fnOrArray) + "'");
    }
  }
  function Class(clsDef) {
    var constructor = applyParams(clsDef.hasOwnProperty('constructor') ? clsDef.constructor : undefined, 'constructor');
    var proto = constructor.prototype;
    if (clsDef.hasOwnProperty('extends')) {
      if (lang_1.isFunction(clsDef.extends)) {
        constructor.prototype = proto = Object.create(clsDef.extends.prototype);
      } else {
        throw new Error("Class definition 'extends' property must be a constructor function was: " + lang_1.stringify(clsDef.extends));
      }
    }
    for (var key in clsDef) {
      if (key != 'extends' && key != 'prototype' && clsDef.hasOwnProperty(key)) {
        proto[key] = applyParams(clsDef[key], key);
      }
    }
    if (this && this.annotations instanceof Array) {
      Reflect.defineMetadata('annotations', this.annotations, constructor);
    }
    if (!constructor['name']) {
      constructor['overriddenName'] = "class" + _nextClassId++;
    }
    return constructor;
  }
  exports.Class = Class;
  var Reflect = lang_1.global.Reflect;
  if (!(Reflect && Reflect.getMetadata)) {
    throw 'reflect-metadata shim is required when using class decorators';
  }
  function makeDecorator(annotationCls, chainFn) {
    if (chainFn === void 0) {
      chainFn = null;
    }
    function DecoratorFactory(objOrType) {
      var annotationInstance = new annotationCls(objOrType);
      if (this instanceof annotationCls) {
        return annotationInstance;
      } else {
        var chainAnnotation = lang_1.isFunction(this) && this.annotations instanceof Array ? this.annotations : [];
        chainAnnotation.push(annotationInstance);
        var TypeDecorator = function TypeDecorator(cls) {
          var annotations = Reflect.getOwnMetadata('annotations', cls);
          annotations = annotations || [];
          annotations.push(annotationInstance);
          Reflect.defineMetadata('annotations', annotations, cls);
          return cls;
        };
        TypeDecorator.annotations = chainAnnotation;
        TypeDecorator.Class = Class;
        if (chainFn)
          chainFn(TypeDecorator);
        return TypeDecorator;
      }
    }
    DecoratorFactory.prototype = Object.create(annotationCls.prototype);
    return DecoratorFactory;
  }
  exports.makeDecorator = makeDecorator;
  function makeParamDecorator(annotationCls) {
    function ParamDecoratorFactory() {
      var args = [];
      for (var _i = 0; _i < arguments.length; _i++) {
        args[_i - 0] = arguments[_i];
      }
      var annotationInstance = Object.create(annotationCls.prototype);
      annotationCls.apply(annotationInstance, args);
      if (this instanceof annotationCls) {
        return annotationInstance;
      } else {
        ParamDecorator.annotation = annotationInstance;
        return ParamDecorator;
      }
      function ParamDecorator(cls, unusedKey, index) {
        var parameters = Reflect.getMetadata('parameters', cls);
        parameters = parameters || [];
        while (parameters.length <= index) {
          parameters.push(null);
        }
        parameters[index] = parameters[index] || [];
        var annotationsForParam = parameters[index];
        annotationsForParam.push(annotationInstance);
        Reflect.defineMetadata('parameters', parameters, cls);
        return cls;
      }
    }
    ParamDecoratorFactory.prototype = Object.create(annotationCls.prototype);
    return ParamDecoratorFactory;
  }
  exports.makeParamDecorator = makeParamDecorator;
  function makePropDecorator(decoratorCls) {
    function PropDecoratorFactory() {
      var args = [];
      for (var _i = 0; _i < arguments.length; _i++) {
        args[_i - 0] = arguments[_i];
      }
      var decoratorInstance = Object.create(decoratorCls.prototype);
      decoratorCls.apply(decoratorInstance, args);
      if (this instanceof decoratorCls) {
        return decoratorInstance;
      } else {
        return function PropDecorator(target, name) {
          var meta = Reflect.getOwnMetadata('propMetadata', target.constructor);
          meta = meta || {};
          meta[name] = meta[name] || [];
          meta[name].unshift(decoratorInstance);
          Reflect.defineMetadata('propMetadata', meta, target.constructor);
        };
      }
    }
    PropDecoratorFactory.prototype = Object.create(decoratorCls.prototype);
    return PropDecoratorFactory;
  }
  exports.makePropDecorator = makePropDecorator;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/di/forward_ref", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  function forwardRef(forwardRefFn) {
    forwardRefFn.__forward_ref__ = forwardRef;
    forwardRefFn.toString = function() {
      return lang_1.stringify(this());
    };
    return forwardRefFn;
  }
  exports.forwardRef = forwardRef;
  function resolveForwardRef(type) {
    if (lang_1.isFunction(type) && type.hasOwnProperty('__forward_ref__') && type.__forward_ref__ === forwardRef) {
      return type();
    } else {
      return type;
    }
  }
  exports.resolveForwardRef = resolveForwardRef;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/facade/collection", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  exports.Map = lang_1.global.Map;
  exports.Set = lang_1.global.Set;
  var createMapFromPairs = (function() {
    try {
      if (new exports.Map([[1, 2]]).size === 1) {
        return function createMapFromPairs(pairs) {
          return new exports.Map(pairs);
        };
      }
    } catch (e) {}
    return function createMapAndPopulateFromPairs(pairs) {
      var map = new exports.Map();
      for (var i = 0; i < pairs.length; i++) {
        var pair = pairs[i];
        map.set(pair[0], pair[1]);
      }
      return map;
    };
  })();
  var createMapFromMap = (function() {
    try {
      if (new exports.Map(new exports.Map())) {
        return function createMapFromMap(m) {
          return new exports.Map(m);
        };
      }
    } catch (e) {}
    return function createMapAndPopulateFromMap(m) {
      var map = new exports.Map();
      m.forEach(function(v, k) {
        map.set(k, v);
      });
      return map;
    };
  })();
  var _clearValues = (function() {
    if ((new exports.Map()).keys().next) {
      return function _clearValues(m) {
        var keyIterator = m.keys();
        var k;
        while (!((k = keyIterator.next()).done)) {
          m.set(k.value, null);
        }
      };
    } else {
      return function _clearValuesWithForeEach(m) {
        m.forEach(function(v, k) {
          m.set(k, null);
        });
      };
    }
  })();
  var _arrayFromMap = (function() {
    try {
      if ((new exports.Map()).values().next) {
        return function createArrayFromMap(m, getValues) {
          return getValues ? Array.from(m.values()) : Array.from(m.keys());
        };
      }
    } catch (e) {}
    return function createArrayFromMapWithForeach(m, getValues) {
      var res = ListWrapper.createFixedSize(m.size),
          i = 0;
      m.forEach(function(v, k) {
        res[i] = getValues ? v : k;
        i++;
      });
      return res;
    };
  })();
  var MapWrapper = (function() {
    function MapWrapper() {}
    MapWrapper.clone = function(m) {
      return createMapFromMap(m);
    };
    MapWrapper.createFromStringMap = function(stringMap) {
      var result = new exports.Map();
      for (var prop in stringMap) {
        result.set(prop, stringMap[prop]);
      }
      return result;
    };
    MapWrapper.toStringMap = function(m) {
      var r = {};
      m.forEach(function(v, k) {
        return r[k] = v;
      });
      return r;
    };
    MapWrapper.createFromPairs = function(pairs) {
      return createMapFromPairs(pairs);
    };
    MapWrapper.clearValues = function(m) {
      _clearValues(m);
    };
    MapWrapper.iterable = function(m) {
      return m;
    };
    MapWrapper.keys = function(m) {
      return _arrayFromMap(m, false);
    };
    MapWrapper.values = function(m) {
      return _arrayFromMap(m, true);
    };
    return MapWrapper;
  })();
  exports.MapWrapper = MapWrapper;
  var StringMapWrapper = (function() {
    function StringMapWrapper() {}
    StringMapWrapper.create = function() {
      return {};
    };
    StringMapWrapper.contains = function(map, key) {
      return map.hasOwnProperty(key);
    };
    StringMapWrapper.get = function(map, key) {
      return map.hasOwnProperty(key) ? map[key] : undefined;
    };
    StringMapWrapper.set = function(map, key, value) {
      map[key] = value;
    };
    StringMapWrapper.keys = function(map) {
      return Object.keys(map);
    };
    StringMapWrapper.isEmpty = function(map) {
      for (var prop in map) {
        return false;
      }
      return true;
    };
    StringMapWrapper.delete = function(map, key) {
      delete map[key];
    };
    StringMapWrapper.forEach = function(map, callback) {
      for (var prop in map) {
        if (map.hasOwnProperty(prop)) {
          callback(map[prop], prop);
        }
      }
    };
    StringMapWrapper.merge = function(m1, m2) {
      var m = {};
      for (var attr in m1) {
        if (m1.hasOwnProperty(attr)) {
          m[attr] = m1[attr];
        }
      }
      for (var attr in m2) {
        if (m2.hasOwnProperty(attr)) {
          m[attr] = m2[attr];
        }
      }
      return m;
    };
    StringMapWrapper.equals = function(m1, m2) {
      var k1 = Object.keys(m1);
      var k2 = Object.keys(m2);
      if (k1.length != k2.length) {
        return false;
      }
      var key;
      for (var i = 0; i < k1.length; i++) {
        key = k1[i];
        if (m1[key] !== m2[key]) {
          return false;
        }
      }
      return true;
    };
    return StringMapWrapper;
  })();
  exports.StringMapWrapper = StringMapWrapper;
  var ListWrapper = (function() {
    function ListWrapper() {}
    ListWrapper.createFixedSize = function(size) {
      return new Array(size);
    };
    ListWrapper.createGrowableSize = function(size) {
      return new Array(size);
    };
    ListWrapper.clone = function(array) {
      return array.slice(0);
    };
    ListWrapper.forEachWithIndex = function(array, fn) {
      for (var i = 0; i < array.length; i++) {
        fn(array[i], i);
      }
    };
    ListWrapper.first = function(array) {
      if (!array)
        return null;
      return array[0];
    };
    ListWrapper.last = function(array) {
      if (!array || array.length == 0)
        return null;
      return array[array.length - 1];
    };
    ListWrapper.indexOf = function(array, value, startIndex) {
      if (startIndex === void 0) {
        startIndex = 0;
      }
      return array.indexOf(value, startIndex);
    };
    ListWrapper.contains = function(list, el) {
      return list.indexOf(el) !== -1;
    };
    ListWrapper.reversed = function(array) {
      var a = ListWrapper.clone(array);
      return a.reverse();
    };
    ListWrapper.concat = function(a, b) {
      return a.concat(b);
    };
    ListWrapper.insert = function(list, index, value) {
      list.splice(index, 0, value);
    };
    ListWrapper.removeAt = function(list, index) {
      var res = list[index];
      list.splice(index, 1);
      return res;
    };
    ListWrapper.removeAll = function(list, items) {
      for (var i = 0; i < items.length; ++i) {
        var index = list.indexOf(items[i]);
        list.splice(index, 1);
      }
    };
    ListWrapper.remove = function(list, el) {
      var index = list.indexOf(el);
      if (index > -1) {
        list.splice(index, 1);
        return true;
      }
      return false;
    };
    ListWrapper.clear = function(list) {
      list.length = 0;
    };
    ListWrapper.isEmpty = function(list) {
      return list.length == 0;
    };
    ListWrapper.fill = function(list, value, start, end) {
      if (start === void 0) {
        start = 0;
      }
      if (end === void 0) {
        end = null;
      }
      list.fill(value, start, end === null ? list.length : end);
    };
    ListWrapper.equals = function(a, b) {
      if (a.length != b.length)
        return false;
      for (var i = 0; i < a.length; ++i) {
        if (a[i] !== b[i])
          return false;
      }
      return true;
    };
    ListWrapper.slice = function(l, from, to) {
      if (from === void 0) {
        from = 0;
      }
      if (to === void 0) {
        to = null;
      }
      return l.slice(from, to === null ? undefined : to);
    };
    ListWrapper.splice = function(l, from, length) {
      return l.splice(from, length);
    };
    ListWrapper.sort = function(l, compareFn) {
      if (lang_1.isPresent(compareFn)) {
        l.sort(compareFn);
      } else {
        l.sort();
      }
    };
    ListWrapper.toString = function(l) {
      return l.toString();
    };
    ListWrapper.toJSON = function(l) {
      return JSON.stringify(l);
    };
    ListWrapper.maximum = function(list, predicate) {
      if (list.length == 0) {
        return null;
      }
      var solution = null;
      var maxValue = -Infinity;
      for (var index = 0; index < list.length; index++) {
        var candidate = list[index];
        if (lang_1.isBlank(candidate)) {
          continue;
        }
        var candidateValue = predicate(candidate);
        if (candidateValue > maxValue) {
          solution = candidate;
          maxValue = candidateValue;
        }
      }
      return solution;
    };
    return ListWrapper;
  })();
  exports.ListWrapper = ListWrapper;
  function isListLikeIterable(obj) {
    if (!lang_1.isJsObject(obj))
      return false;
    return lang_1.isArray(obj) || (!(obj instanceof exports.Map) && lang_1.getSymbolIterator() in obj);
  }
  exports.isListLikeIterable = isListLikeIterable;
  function areIterablesEqual(a, b, comparator) {
    var iterator1 = a[lang_1.getSymbolIterator()]();
    var iterator2 = b[lang_1.getSymbolIterator()]();
    while (true) {
      var item1 = iterator1.next();
      var item2 = iterator2.next();
      if (item1.done && item2.done)
        return true;
      if (item1.done || item2.done)
        return false;
      if (!comparator(item1.value, item2.value))
        return false;
    }
  }
  exports.areIterablesEqual = areIterablesEqual;
  function iterateListLike(obj, fn) {
    if (lang_1.isArray(obj)) {
      for (var i = 0; i < obj.length; i++) {
        fn(obj[i]);
      }
    } else {
      var iterator = obj[lang_1.getSymbolIterator()]();
      var item;
      while (!((item = iterator.next()).done)) {
        fn(item.value);
      }
    }
  }
  exports.iterateListLike = iterateListLike;
  var createSetFromList = (function() {
    var test = new exports.Set([1, 2, 3]);
    if (test.size === 3) {
      return function createSetFromList(lst) {
        return new exports.Set(lst);
      };
    } else {
      return function createSetAndPopulateFromList(lst) {
        var res = new exports.Set(lst);
        if (res.size !== lst.length) {
          for (var i = 0; i < lst.length; i++) {
            res.add(lst[i]);
          }
        }
        return res;
      };
    }
  })();
  var SetWrapper = (function() {
    function SetWrapper() {}
    SetWrapper.createFromList = function(lst) {
      return createSetFromList(lst);
    };
    SetWrapper.has = function(s, key) {
      return s.has(key);
    };
    SetWrapper.delete = function(m, k) {
      m.delete(k);
    };
    return SetWrapper;
  })();
  exports.SetWrapper = SetWrapper;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/facade/exception_handler", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var _ArrayLogger = (function() {
    function _ArrayLogger() {
      this.res = [];
    }
    _ArrayLogger.prototype.log = function(s) {
      this.res.push(s);
    };
    _ArrayLogger.prototype.logError = function(s) {
      this.res.push(s);
    };
    _ArrayLogger.prototype.logGroup = function(s) {
      this.res.push(s);
    };
    _ArrayLogger.prototype.logGroupEnd = function() {};
    ;
    return _ArrayLogger;
  })();
  var ExceptionHandler = (function() {
    function ExceptionHandler(_logger, _rethrowException) {
      if (_rethrowException === void 0) {
        _rethrowException = true;
      }
      this._logger = _logger;
      this._rethrowException = _rethrowException;
    }
    ExceptionHandler.exceptionToString = function(exception, stackTrace, reason) {
      if (stackTrace === void 0) {
        stackTrace = null;
      }
      if (reason === void 0) {
        reason = null;
      }
      var l = new _ArrayLogger();
      var e = new ExceptionHandler(l, false);
      e.call(exception, stackTrace, reason);
      return l.res.join("\n");
    };
    ExceptionHandler.prototype.call = function(exception, stackTrace, reason) {
      if (stackTrace === void 0) {
        stackTrace = null;
      }
      if (reason === void 0) {
        reason = null;
      }
      var originalException = this._findOriginalException(exception);
      var originalStack = this._findOriginalStack(exception);
      var context = this._findContext(exception);
      this._logger.logGroup("EXCEPTION: " + this._extractMessage(exception));
      if (lang_1.isPresent(stackTrace) && lang_1.isBlank(originalStack)) {
        this._logger.logError("STACKTRACE:");
        this._logger.logError(this._longStackTrace(stackTrace));
      }
      if (lang_1.isPresent(reason)) {
        this._logger.logError("REASON: " + reason);
      }
      if (lang_1.isPresent(originalException)) {
        this._logger.logError("ORIGINAL EXCEPTION: " + this._extractMessage(originalException));
      }
      if (lang_1.isPresent(originalStack)) {
        this._logger.logError("ORIGINAL STACKTRACE:");
        this._logger.logError(this._longStackTrace(originalStack));
      }
      if (lang_1.isPresent(context)) {
        this._logger.logError("ERROR CONTEXT:");
        this._logger.logError(context);
      }
      this._logger.logGroupEnd();
      if (this._rethrowException)
        throw exception;
    };
    ExceptionHandler.prototype._extractMessage = function(exception) {
      return exception instanceof exceptions_1.WrappedException ? exception.wrapperMessage : exception.toString();
    };
    ExceptionHandler.prototype._longStackTrace = function(stackTrace) {
      return collection_1.isListLikeIterable(stackTrace) ? stackTrace.join("\n\n-----async gap-----\n") : stackTrace.toString();
    };
    ExceptionHandler.prototype._findContext = function(exception) {
      try {
        if (!(exception instanceof exceptions_1.WrappedException))
          return null;
        return lang_1.isPresent(exception.context) ? exception.context : this._findContext(exception.originalException);
      } catch (e) {
        return null;
      }
    };
    ExceptionHandler.prototype._findOriginalException = function(exception) {
      if (!(exception instanceof exceptions_1.WrappedException))
        return null;
      var e = exception.originalException;
      while (e instanceof exceptions_1.WrappedException && lang_1.isPresent(e.originalException)) {
        e = e.originalException;
      }
      return e;
    };
    ExceptionHandler.prototype._findOriginalStack = function(exception) {
      if (!(exception instanceof exceptions_1.WrappedException))
        return null;
      var e = exception;
      var stack = exception.originalStack;
      while (e instanceof exceptions_1.WrappedException && lang_1.isPresent(e.originalException)) {
        e = e.originalException;
        if (e instanceof exceptions_1.WrappedException && lang_1.isPresent(e.originalException)) {
          stack = e.originalStack;
        }
      }
      return stack;
    };
    return ExceptionHandler;
  })();
  exports.ExceptionHandler = ExceptionHandler;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/reflection/reflector", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var ReflectionInfo = (function() {
    function ReflectionInfo(annotations, parameters, factory, interfaces, propMetadata) {
      this.annotations = annotations;
      this.parameters = parameters;
      this.factory = factory;
      this.interfaces = interfaces;
      this.propMetadata = propMetadata;
    }
    return ReflectionInfo;
  })();
  exports.ReflectionInfo = ReflectionInfo;
  var Reflector = (function() {
    function Reflector(reflectionCapabilities) {
      this._injectableInfo = new collection_1.Map();
      this._getters = new collection_1.Map();
      this._setters = new collection_1.Map();
      this._methods = new collection_1.Map();
      this._usedKeys = null;
      this.reflectionCapabilities = reflectionCapabilities;
    }
    Reflector.prototype.isReflectionEnabled = function() {
      return this.reflectionCapabilities.isReflectionEnabled();
    };
    Reflector.prototype.trackUsage = function() {
      this._usedKeys = new collection_1.Set();
    };
    Reflector.prototype.listUnusedKeys = function() {
      var _this = this;
      if (this._usedKeys == null) {
        throw new exceptions_1.BaseException('Usage tracking is disabled');
      }
      var allTypes = collection_1.MapWrapper.keys(this._injectableInfo);
      return allTypes.filter(function(key) {
        return !collection_1.SetWrapper.has(_this._usedKeys, key);
      });
    };
    Reflector.prototype.registerFunction = function(func, funcInfo) {
      this._injectableInfo.set(func, funcInfo);
    };
    Reflector.prototype.registerType = function(type, typeInfo) {
      this._injectableInfo.set(type, typeInfo);
    };
    Reflector.prototype.registerGetters = function(getters) {
      _mergeMaps(this._getters, getters);
    };
    Reflector.prototype.registerSetters = function(setters) {
      _mergeMaps(this._setters, setters);
    };
    Reflector.prototype.registerMethods = function(methods) {
      _mergeMaps(this._methods, methods);
    };
    Reflector.prototype.factory = function(type) {
      if (this._containsReflectionInfo(type)) {
        var res = this._getReflectionInfo(type).factory;
        return lang_1.isPresent(res) ? res : null;
      } else {
        return this.reflectionCapabilities.factory(type);
      }
    };
    Reflector.prototype.parameters = function(typeOrFunc) {
      if (this._injectableInfo.has(typeOrFunc)) {
        var res = this._getReflectionInfo(typeOrFunc).parameters;
        return lang_1.isPresent(res) ? res : [];
      } else {
        return this.reflectionCapabilities.parameters(typeOrFunc);
      }
    };
    Reflector.prototype.annotations = function(typeOrFunc) {
      if (this._injectableInfo.has(typeOrFunc)) {
        var res = this._getReflectionInfo(typeOrFunc).annotations;
        return lang_1.isPresent(res) ? res : [];
      } else {
        return this.reflectionCapabilities.annotations(typeOrFunc);
      }
    };
    Reflector.prototype.propMetadata = function(typeOrFunc) {
      if (this._injectableInfo.has(typeOrFunc)) {
        var res = this._getReflectionInfo(typeOrFunc).propMetadata;
        return lang_1.isPresent(res) ? res : {};
      } else {
        return this.reflectionCapabilities.propMetadata(typeOrFunc);
      }
    };
    Reflector.prototype.interfaces = function(type) {
      if (this._injectableInfo.has(type)) {
        var res = this._getReflectionInfo(type).interfaces;
        return lang_1.isPresent(res) ? res : [];
      } else {
        return this.reflectionCapabilities.interfaces(type);
      }
    };
    Reflector.prototype.getter = function(name) {
      if (this._getters.has(name)) {
        return this._getters.get(name);
      } else {
        return this.reflectionCapabilities.getter(name);
      }
    };
    Reflector.prototype.setter = function(name) {
      if (this._setters.has(name)) {
        return this._setters.get(name);
      } else {
        return this.reflectionCapabilities.setter(name);
      }
    };
    Reflector.prototype.method = function(name) {
      if (this._methods.has(name)) {
        return this._methods.get(name);
      } else {
        return this.reflectionCapabilities.method(name);
      }
    };
    Reflector.prototype._getReflectionInfo = function(typeOrFunc) {
      if (lang_1.isPresent(this._usedKeys)) {
        this._usedKeys.add(typeOrFunc);
      }
      return this._injectableInfo.get(typeOrFunc);
    };
    Reflector.prototype._containsReflectionInfo = function(typeOrFunc) {
      return this._injectableInfo.has(typeOrFunc);
    };
    Reflector.prototype.importUri = function(type) {
      return this.reflectionCapabilities.importUri(type);
    };
    return Reflector;
  })();
  exports.Reflector = Reflector;
  function _mergeMaps(target, config) {
    collection_1.StringMapWrapper.forEach(config, function(v, k) {
      return target.set(k, v);
    });
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/reflection/reflection_capabilities", ["angular2/src/facade/lang", "angular2/src/facade/exceptions"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var ReflectionCapabilities = (function() {
    function ReflectionCapabilities(reflect) {
      this._reflect = lang_1.isPresent(reflect) ? reflect : lang_1.global.Reflect;
    }
    ReflectionCapabilities.prototype.isReflectionEnabled = function() {
      return true;
    };
    ReflectionCapabilities.prototype.factory = function(t) {
      switch (t.length) {
        case 0:
          return function() {
            return new t();
          };
        case 1:
          return function(a1) {
            return new t(a1);
          };
        case 2:
          return function(a1, a2) {
            return new t(a1, a2);
          };
        case 3:
          return function(a1, a2, a3) {
            return new t(a1, a2, a3);
          };
        case 4:
          return function(a1, a2, a3, a4) {
            return new t(a1, a2, a3, a4);
          };
        case 5:
          return function(a1, a2, a3, a4, a5) {
            return new t(a1, a2, a3, a4, a5);
          };
        case 6:
          return function(a1, a2, a3, a4, a5, a6) {
            return new t(a1, a2, a3, a4, a5, a6);
          };
        case 7:
          return function(a1, a2, a3, a4, a5, a6, a7) {
            return new t(a1, a2, a3, a4, a5, a6, a7);
          };
        case 8:
          return function(a1, a2, a3, a4, a5, a6, a7, a8) {
            return new t(a1, a2, a3, a4, a5, a6, a7, a8);
          };
        case 9:
          return function(a1, a2, a3, a4, a5, a6, a7, a8, a9) {
            return new t(a1, a2, a3, a4, a5, a6, a7, a8, a9);
          };
        case 10:
          return function(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10) {
            return new t(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
          };
        case 11:
          return function(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11) {
            return new t(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11);
          };
        case 12:
          return function(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12) {
            return new t(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12);
          };
        case 13:
          return function(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13) {
            return new t(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13);
          };
        case 14:
          return function(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14) {
            return new t(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14);
          };
        case 15:
          return function(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15) {
            return new t(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15);
          };
        case 16:
          return function(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16) {
            return new t(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16);
          };
        case 17:
          return function(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17) {
            return new t(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17);
          };
        case 18:
          return function(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18) {
            return new t(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18);
          };
        case 19:
          return function(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19) {
            return new t(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19);
          };
        case 20:
          return function(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20) {
            return new t(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20);
          };
      }
      ;
      throw new Error("Cannot create a factory for '" + lang_1.stringify(t) + "' because its constructor has more than 20 arguments");
    };
    ReflectionCapabilities.prototype._zipTypesAndAnnotations = function(paramTypes, paramAnnotations) {
      var result;
      if (typeof paramTypes === 'undefined') {
        result = new Array(paramAnnotations.length);
      } else {
        result = new Array(paramTypes.length);
      }
      for (var i = 0; i < result.length; i++) {
        if (typeof paramTypes === 'undefined') {
          result[i] = [];
        } else if (paramTypes[i] != Object) {
          result[i] = [paramTypes[i]];
        } else {
          result[i] = [];
        }
        if (lang_1.isPresent(paramAnnotations) && lang_1.isPresent(paramAnnotations[i])) {
          result[i] = result[i].concat(paramAnnotations[i]);
        }
      }
      return result;
    };
    ReflectionCapabilities.prototype.parameters = function(typeOrFunc) {
      if (lang_1.isPresent(typeOrFunc.parameters)) {
        return typeOrFunc.parameters;
      }
      if (lang_1.isPresent(this._reflect) && lang_1.isPresent(this._reflect.getMetadata)) {
        var paramAnnotations = this._reflect.getMetadata('parameters', typeOrFunc);
        var paramTypes = this._reflect.getMetadata('design:paramtypes', typeOrFunc);
        if (lang_1.isPresent(paramTypes) || lang_1.isPresent(paramAnnotations)) {
          return this._zipTypesAndAnnotations(paramTypes, paramAnnotations);
        }
      }
      var parameters = new Array(typeOrFunc.length);
      parameters.fill(undefined);
      return parameters;
    };
    ReflectionCapabilities.prototype.annotations = function(typeOrFunc) {
      if (lang_1.isPresent(typeOrFunc.annotations)) {
        var annotations = typeOrFunc.annotations;
        if (lang_1.isFunction(annotations) && annotations.annotations) {
          annotations = annotations.annotations;
        }
        return annotations;
      }
      if (lang_1.isPresent(this._reflect) && lang_1.isPresent(this._reflect.getMetadata)) {
        var annotations = this._reflect.getMetadata('annotations', typeOrFunc);
        if (lang_1.isPresent(annotations))
          return annotations;
      }
      return [];
    };
    ReflectionCapabilities.prototype.propMetadata = function(typeOrFunc) {
      if (lang_1.isPresent(typeOrFunc.propMetadata)) {
        var propMetadata = typeOrFunc.propMetadata;
        if (lang_1.isFunction(propMetadata) && propMetadata.propMetadata) {
          propMetadata = propMetadata.propMetadata;
        }
        return propMetadata;
      }
      if (lang_1.isPresent(this._reflect) && lang_1.isPresent(this._reflect.getMetadata)) {
        var propMetadata = this._reflect.getMetadata('propMetadata', typeOrFunc);
        if (lang_1.isPresent(propMetadata))
          return propMetadata;
      }
      return {};
    };
    ReflectionCapabilities.prototype.interfaces = function(type) {
      throw new exceptions_1.BaseException("JavaScript does not support interfaces");
    };
    ReflectionCapabilities.prototype.getter = function(name) {
      return new Function('o', 'return o.' + name + ';');
    };
    ReflectionCapabilities.prototype.setter = function(name) {
      return new Function('o', 'v', 'return o.' + name + ' = v;');
    };
    ReflectionCapabilities.prototype.method = function(name) {
      var functionBody = "if (!o." + name + ") throw new Error('\"" + name + "\" is undefined');\n        return o." + name + ".apply(o, args);";
      return new Function('o', 'args', functionBody);
    };
    ReflectionCapabilities.prototype.importUri = function(type) {
      return './';
    };
    return ReflectionCapabilities;
  })();
  exports.ReflectionCapabilities = ReflectionCapabilities;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/di/type_literal", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var TypeLiteral = (function() {
    function TypeLiteral() {}
    Object.defineProperty(TypeLiteral.prototype, "type", {
      get: function() {
        throw new Error("Type literals are only supported in Dart");
      },
      enumerable: true,
      configurable: true
    });
    return TypeLiteral;
  })();
  exports.TypeLiteral = TypeLiteral;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/di/exceptions", ["angular2/src/facade/collection", "angular2/src/facade/lang", "angular2/src/facade/exceptions"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var collection_1 = require("angular2/src/facade/collection");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  function findFirstClosedCycle(keys) {
    var res = [];
    for (var i = 0; i < keys.length; ++i) {
      if (collection_1.ListWrapper.contains(res, keys[i])) {
        res.push(keys[i]);
        return res;
      } else {
        res.push(keys[i]);
      }
    }
    return res;
  }
  function constructResolvingPath(keys) {
    if (keys.length > 1) {
      var reversed = findFirstClosedCycle(collection_1.ListWrapper.reversed(keys));
      var tokenStrs = reversed.map(function(k) {
        return lang_1.stringify(k.token);
      });
      return " (" + tokenStrs.join(' -> ') + ")";
    } else {
      return "";
    }
  }
  var AbstractProviderError = (function(_super) {
    __extends(AbstractProviderError, _super);
    function AbstractProviderError(injector, key, constructResolvingMessage) {
      _super.call(this, "DI Exception");
      this.keys = [key];
      this.injectors = [injector];
      this.constructResolvingMessage = constructResolvingMessage;
      this.message = this.constructResolvingMessage(this.keys);
    }
    AbstractProviderError.prototype.addKey = function(injector, key) {
      this.injectors.push(injector);
      this.keys.push(key);
      this.message = this.constructResolvingMessage(this.keys);
    };
    Object.defineProperty(AbstractProviderError.prototype, "context", {
      get: function() {
        return this.injectors[this.injectors.length - 1].debugContext();
      },
      enumerable: true,
      configurable: true
    });
    return AbstractProviderError;
  })(exceptions_1.BaseException);
  exports.AbstractProviderError = AbstractProviderError;
  var NoProviderError = (function(_super) {
    __extends(NoProviderError, _super);
    function NoProviderError(injector, key) {
      _super.call(this, injector, key, function(keys) {
        var first = lang_1.stringify(collection_1.ListWrapper.first(keys).token);
        return "No provider for " + first + "!" + constructResolvingPath(keys);
      });
    }
    return NoProviderError;
  })(AbstractProviderError);
  exports.NoProviderError = NoProviderError;
  var CyclicDependencyError = (function(_super) {
    __extends(CyclicDependencyError, _super);
    function CyclicDependencyError(injector, key) {
      _super.call(this, injector, key, function(keys) {
        return "Cannot instantiate cyclic dependency!" + constructResolvingPath(keys);
      });
    }
    return CyclicDependencyError;
  })(AbstractProviderError);
  exports.CyclicDependencyError = CyclicDependencyError;
  var InstantiationError = (function(_super) {
    __extends(InstantiationError, _super);
    function InstantiationError(injector, originalException, originalStack, key) {
      _super.call(this, "DI Exception", originalException, originalStack, null);
      this.keys = [key];
      this.injectors = [injector];
    }
    InstantiationError.prototype.addKey = function(injector, key) {
      this.injectors.push(injector);
      this.keys.push(key);
    };
    Object.defineProperty(InstantiationError.prototype, "wrapperMessage", {
      get: function() {
        var first = lang_1.stringify(collection_1.ListWrapper.first(this.keys).token);
        return "Error during instantiation of " + first + "!" + constructResolvingPath(this.keys) + ".";
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(InstantiationError.prototype, "causeKey", {
      get: function() {
        return this.keys[0];
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(InstantiationError.prototype, "context", {
      get: function() {
        return this.injectors[this.injectors.length - 1].debugContext();
      },
      enumerable: true,
      configurable: true
    });
    return InstantiationError;
  })(exceptions_1.WrappedException);
  exports.InstantiationError = InstantiationError;
  var InvalidProviderError = (function(_super) {
    __extends(InvalidProviderError, _super);
    function InvalidProviderError(provider) {
      _super.call(this, "Invalid provider - only instances of Provider and Type are allowed, got: " + provider.toString());
    }
    return InvalidProviderError;
  })(exceptions_1.BaseException);
  exports.InvalidProviderError = InvalidProviderError;
  var NoAnnotationError = (function(_super) {
    __extends(NoAnnotationError, _super);
    function NoAnnotationError(typeOrFunc, params) {
      _super.call(this, NoAnnotationError._genMessage(typeOrFunc, params));
    }
    NoAnnotationError._genMessage = function(typeOrFunc, params) {
      var signature = [];
      for (var i = 0,
          ii = params.length; i < ii; i++) {
        var parameter = params[i];
        if (lang_1.isBlank(parameter) || parameter.length == 0) {
          signature.push('?');
        } else {
          signature.push(parameter.map(lang_1.stringify).join(' '));
        }
      }
      return "Cannot resolve all parameters for '" + lang_1.stringify(typeOrFunc) + "'(" + signature.join(', ') + "). " + "Make sure that all the parameters are decorated with Inject or have valid type annotations and that '" + lang_1.stringify(typeOrFunc) + "' is decorated with Injectable.";
    };
    return NoAnnotationError;
  })(exceptions_1.BaseException);
  exports.NoAnnotationError = NoAnnotationError;
  var OutOfBoundsError = (function(_super) {
    __extends(OutOfBoundsError, _super);
    function OutOfBoundsError(index) {
      _super.call(this, "Index " + index + " is out-of-bounds.");
    }
    return OutOfBoundsError;
  })(exceptions_1.BaseException);
  exports.OutOfBoundsError = OutOfBoundsError;
  var MixingMultiProvidersWithRegularProvidersError = (function(_super) {
    __extends(MixingMultiProvidersWithRegularProvidersError, _super);
    function MixingMultiProvidersWithRegularProvidersError(provider1, provider2) {
      _super.call(this, "Cannot mix multi providers and regular providers, got: " + provider1.toString() + " " + provider2.toString());
    }
    return MixingMultiProvidersWithRegularProvidersError;
  })(exceptions_1.BaseException);
  exports.MixingMultiProvidersWithRegularProvidersError = MixingMultiProvidersWithRegularProvidersError;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/di/opaque_token", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var OpaqueToken = (function() {
    function OpaqueToken(_desc) {
      this._desc = _desc;
    }
    OpaqueToken.prototype.toString = function() {
      return "Token " + this._desc;
    };
    OpaqueToken = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [String])], OpaqueToken);
    return OpaqueToken;
  })();
  exports.OpaqueToken = OpaqueToken;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/animate/css_animation_options", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var CssAnimationOptions = (function() {
    function CssAnimationOptions() {
      this.classesToAdd = [];
      this.classesToRemove = [];
      this.animationClasses = [];
    }
    return CssAnimationOptions;
  })();
  exports.CssAnimationOptions = CssAnimationOptions;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/facade/math", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  exports.Math = lang_1.global.Math;
  exports.NaN = typeof exports.NaN;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/dom/util", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var CAMEL_CASE_REGEXP = /([A-Z])/g;
  var DASH_CASE_REGEXP = /-([a-z])/g;
  function camelCaseToDashCase(input) {
    return lang_1.StringWrapper.replaceAllMapped(input, CAMEL_CASE_REGEXP, function(m) {
      return '-' + m[1].toLowerCase();
    });
  }
  exports.camelCaseToDashCase = camelCaseToDashCase;
  function dashCaseToCamelCase(input) {
    return lang_1.StringWrapper.replaceAllMapped(input, DASH_CASE_REGEXP, function(m) {
      return m[1].toUpperCase();
    });
  }
  exports.dashCaseToCamelCase = dashCaseToCamelCase;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/animate/browser_details", ["angular2/src/core/di", "angular2/src/facade/math", "angular2/src/platform/dom/dom_adapter"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var di_1 = require("angular2/src/core/di");
  var math_1 = require("angular2/src/facade/math");
  var dom_adapter_1 = require("angular2/src/platform/dom/dom_adapter");
  var BrowserDetails = (function() {
    function BrowserDetails() {
      this.elapsedTimeIncludesDelay = false;
      this.doesElapsedTimeIncludesDelay();
    }
    BrowserDetails.prototype.doesElapsedTimeIncludesDelay = function() {
      var _this = this;
      var div = dom_adapter_1.DOM.createElement('div');
      dom_adapter_1.DOM.setAttribute(div, 'style', "position: absolute; top: -9999px; left: -9999px; width: 1px;\n      height: 1px; transition: all 1ms linear 1ms;");
      this.raf(function(timestamp) {
        dom_adapter_1.DOM.on(div, 'transitionend', function(event) {
          var elapsed = math_1.Math.round(event.elapsedTime * 1000);
          _this.elapsedTimeIncludesDelay = elapsed == 2;
          dom_adapter_1.DOM.remove(div);
        });
        dom_adapter_1.DOM.setStyle(div, 'width', '2px');
      }, 2);
    };
    BrowserDetails.prototype.raf = function(callback, frames) {
      if (frames === void 0) {
        frames = 1;
      }
      var queue = new RafQueue(callback, frames);
      return function() {
        return queue.cancel();
      };
    };
    BrowserDetails = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [])], BrowserDetails);
    return BrowserDetails;
  })();
  exports.BrowserDetails = BrowserDetails;
  var RafQueue = (function() {
    function RafQueue(callback, frames) {
      this.callback = callback;
      this.frames = frames;
      this._raf();
    }
    RafQueue.prototype._raf = function() {
      var _this = this;
      this.currentFrameId = dom_adapter_1.DOM.requestAnimationFrame(function(timestamp) {
        return _this._nextFrame(timestamp);
      });
    };
    RafQueue.prototype._nextFrame = function(timestamp) {
      this.frames--;
      if (this.frames > 0) {
        this._raf();
      } else {
        this.callback(timestamp);
      }
    };
    RafQueue.prototype.cancel = function() {
      dom_adapter_1.DOM.cancelAnimationFrame(this.currentFrameId);
      this.currentFrameId = null;
    };
    return RafQueue;
  })();
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/dom/dom_tokens", ["angular2/src/core/di", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var di_1 = require("angular2/src/core/di");
  var lang_1 = require("angular2/src/facade/lang");
  exports.DOCUMENT = lang_1.CONST_EXPR(new di_1.OpaqueToken('DocumentToken'));
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/facade/promise", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var PromiseWrapper = (function() {
    function PromiseWrapper() {}
    PromiseWrapper.resolve = function(obj) {
      return Promise.resolve(obj);
    };
    PromiseWrapper.reject = function(obj, _) {
      return Promise.reject(obj);
    };
    PromiseWrapper.catchError = function(promise, onError) {
      return promise.catch(onError);
    };
    PromiseWrapper.all = function(promises) {
      if (promises.length == 0)
        return Promise.resolve([]);
      return Promise.all(promises);
    };
    PromiseWrapper.then = function(promise, success, rejection) {
      return promise.then(success, rejection);
    };
    PromiseWrapper.wrap = function(computation) {
      return new Promise(function(res, rej) {
        try {
          res(computation());
        } catch (e) {
          rej(e);
        }
      });
    };
    PromiseWrapper.scheduleMicrotask = function(computation) {
      PromiseWrapper.then(PromiseWrapper.resolve(null), computation, function(_) {});
    };
    PromiseWrapper.isPromise = function(obj) {
      return obj instanceof Promise;
    };
    PromiseWrapper.completer = function() {
      var resolve;
      var reject;
      var p = new Promise(function(res, rej) {
        resolve = res;
        reject = rej;
      });
      return {
        promise: p,
        resolve: resolve,
        reject: reject
      };
    };
    return PromiseWrapper;
  })();
  exports.PromiseWrapper = PromiseWrapper;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/profile/wtf_impl", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var trace;
  var events;
  function detectWTF() {
    var wtf = lang_1.global['wtf'];
    if (wtf) {
      trace = wtf['trace'];
      if (trace) {
        events = trace['events'];
        return true;
      }
    }
    return false;
  }
  exports.detectWTF = detectWTF;
  function createScope(signature, flags) {
    if (flags === void 0) {
      flags = null;
    }
    return events.createScope(signature, flags);
  }
  exports.createScope = createScope;
  function leave(scope, returnValue) {
    trace.leaveScope(scope, returnValue);
    return returnValue;
  }
  exports.leave = leave;
  function startTimeRange(rangeType, action) {
    return trace.beginTimeRange(rangeType, action);
  }
  exports.startTimeRange = startTimeRange;
  function endTimeRange(range) {
    trace.endTimeRange(range);
  }
  exports.endTimeRange = endTimeRange;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/metadata/di", ["angular2/src/facade/lang", "angular2/src/core/di", "angular2/src/core/di/metadata"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var di_1 = require("angular2/src/core/di");
  var metadata_1 = require("angular2/src/core/di/metadata");
  var AttributeMetadata = (function(_super) {
    __extends(AttributeMetadata, _super);
    function AttributeMetadata(attributeName) {
      _super.call(this);
      this.attributeName = attributeName;
    }
    Object.defineProperty(AttributeMetadata.prototype, "token", {
      get: function() {
        return this;
      },
      enumerable: true,
      configurable: true
    });
    AttributeMetadata.prototype.toString = function() {
      return "@Attribute(" + lang_1.stringify(this.attributeName) + ")";
    };
    AttributeMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [String])], AttributeMetadata);
    return AttributeMetadata;
  })(metadata_1.DependencyMetadata);
  exports.AttributeMetadata = AttributeMetadata;
  var QueryMetadata = (function(_super) {
    __extends(QueryMetadata, _super);
    function QueryMetadata(_selector, _a) {
      var _b = _a === void 0 ? {} : _a,
          _c = _b.descendants,
          descendants = _c === void 0 ? false : _c,
          _d = _b.first,
          first = _d === void 0 ? false : _d;
      _super.call(this);
      this._selector = _selector;
      this.descendants = descendants;
      this.first = first;
    }
    Object.defineProperty(QueryMetadata.prototype, "isViewQuery", {
      get: function() {
        return false;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(QueryMetadata.prototype, "selector", {
      get: function() {
        return di_1.resolveForwardRef(this._selector);
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(QueryMetadata.prototype, "isVarBindingQuery", {
      get: function() {
        return lang_1.isString(this.selector);
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(QueryMetadata.prototype, "varBindings", {
      get: function() {
        return this.selector.split(',');
      },
      enumerable: true,
      configurable: true
    });
    QueryMetadata.prototype.toString = function() {
      return "@Query(" + lang_1.stringify(this.selector) + ")";
    };
    QueryMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [Object, Object])], QueryMetadata);
    return QueryMetadata;
  })(metadata_1.DependencyMetadata);
  exports.QueryMetadata = QueryMetadata;
  var ContentChildrenMetadata = (function(_super) {
    __extends(ContentChildrenMetadata, _super);
    function ContentChildrenMetadata(_selector, _a) {
      var _b = (_a === void 0 ? {} : _a).descendants,
          descendants = _b === void 0 ? false : _b;
      _super.call(this, _selector, {descendants: descendants});
    }
    ContentChildrenMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [Object, Object])], ContentChildrenMetadata);
    return ContentChildrenMetadata;
  })(QueryMetadata);
  exports.ContentChildrenMetadata = ContentChildrenMetadata;
  var ContentChildMetadata = (function(_super) {
    __extends(ContentChildMetadata, _super);
    function ContentChildMetadata(_selector) {
      _super.call(this, _selector, {
        descendants: true,
        first: true
      });
    }
    ContentChildMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [Object])], ContentChildMetadata);
    return ContentChildMetadata;
  })(QueryMetadata);
  exports.ContentChildMetadata = ContentChildMetadata;
  var ViewQueryMetadata = (function(_super) {
    __extends(ViewQueryMetadata, _super);
    function ViewQueryMetadata(_selector, _a) {
      var _b = _a === void 0 ? {} : _a,
          _c = _b.descendants,
          descendants = _c === void 0 ? false : _c,
          _d = _b.first,
          first = _d === void 0 ? false : _d;
      _super.call(this, _selector, {
        descendants: descendants,
        first: first
      });
    }
    Object.defineProperty(ViewQueryMetadata.prototype, "isViewQuery", {
      get: function() {
        return true;
      },
      enumerable: true,
      configurable: true
    });
    ViewQueryMetadata.prototype.toString = function() {
      return "@ViewQuery(" + lang_1.stringify(this.selector) + ")";
    };
    ViewQueryMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [Object, Object])], ViewQueryMetadata);
    return ViewQueryMetadata;
  })(QueryMetadata);
  exports.ViewQueryMetadata = ViewQueryMetadata;
  var ViewChildrenMetadata = (function(_super) {
    __extends(ViewChildrenMetadata, _super);
    function ViewChildrenMetadata(_selector) {
      _super.call(this, _selector, {descendants: true});
    }
    ViewChildrenMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [Object])], ViewChildrenMetadata);
    return ViewChildrenMetadata;
  })(ViewQueryMetadata);
  exports.ViewChildrenMetadata = ViewChildrenMetadata;
  var ViewChildMetadata = (function(_super) {
    __extends(ViewChildMetadata, _super);
    function ViewChildMetadata(_selector) {
      _super.call(this, _selector, {
        descendants: true,
        first: true
      });
    }
    ViewChildMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [Object])], ViewChildMetadata);
    return ViewChildMetadata;
  })(ViewQueryMetadata);
  exports.ViewChildMetadata = ViewChildMetadata;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/differs/iterable_differs", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection", "angular2/src/core/di"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var di_1 = require("angular2/src/core/di");
  var IterableDiffers = (function() {
    function IterableDiffers(factories) {
      this.factories = factories;
    }
    IterableDiffers.create = function(factories, parent) {
      if (lang_1.isPresent(parent)) {
        var copied = collection_1.ListWrapper.clone(parent.factories);
        factories = factories.concat(copied);
        return new IterableDiffers(factories);
      } else {
        return new IterableDiffers(factories);
      }
    };
    IterableDiffers.extend = function(factories) {
      return new di_1.Provider(IterableDiffers, {
        useFactory: function(parent) {
          if (lang_1.isBlank(parent)) {
            throw new exceptions_1.BaseException('Cannot extend IterableDiffers without a parent injector');
          }
          return IterableDiffers.create(factories, parent);
        },
        deps: [[IterableDiffers, new di_1.SkipSelfMetadata(), new di_1.OptionalMetadata()]]
      });
    };
    IterableDiffers.prototype.find = function(iterable) {
      var factory = this.factories.find(function(f) {
        return f.supports(iterable);
      });
      if (lang_1.isPresent(factory)) {
        return factory;
      } else {
        throw new exceptions_1.BaseException("Cannot find a differ supporting object '" + iterable + "'");
      }
    };
    IterableDiffers = __decorate([di_1.Injectable(), lang_1.CONST(), __metadata('design:paramtypes', [Array])], IterableDiffers);
    return IterableDiffers;
  })();
  exports.IterableDiffers = IterableDiffers;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/differs/default_iterable_differ", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var lang_2 = require("angular2/src/facade/lang");
  var DefaultIterableDifferFactory = (function() {
    function DefaultIterableDifferFactory() {}
    DefaultIterableDifferFactory.prototype.supports = function(obj) {
      return collection_1.isListLikeIterable(obj);
    };
    DefaultIterableDifferFactory.prototype.create = function(cdRef, trackByFn) {
      return new DefaultIterableDiffer(trackByFn);
    };
    DefaultIterableDifferFactory = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [])], DefaultIterableDifferFactory);
    return DefaultIterableDifferFactory;
  })();
  exports.DefaultIterableDifferFactory = DefaultIterableDifferFactory;
  var trackByIdentity = function(index, item) {
    return item;
  };
  var DefaultIterableDiffer = (function() {
    function DefaultIterableDiffer(_trackByFn) {
      this._trackByFn = _trackByFn;
      this._length = null;
      this._collection = null;
      this._linkedRecords = null;
      this._unlinkedRecords = null;
      this._previousItHead = null;
      this._itHead = null;
      this._itTail = null;
      this._additionsHead = null;
      this._additionsTail = null;
      this._movesHead = null;
      this._movesTail = null;
      this._removalsHead = null;
      this._removalsTail = null;
      this._identityChangesHead = null;
      this._identityChangesTail = null;
      this._trackByFn = lang_2.isPresent(this._trackByFn) ? this._trackByFn : trackByIdentity;
    }
    Object.defineProperty(DefaultIterableDiffer.prototype, "collection", {
      get: function() {
        return this._collection;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(DefaultIterableDiffer.prototype, "length", {
      get: function() {
        return this._length;
      },
      enumerable: true,
      configurable: true
    });
    DefaultIterableDiffer.prototype.forEachItem = function(fn) {
      var record;
      for (record = this._itHead; record !== null; record = record._next) {
        fn(record);
      }
    };
    DefaultIterableDiffer.prototype.forEachPreviousItem = function(fn) {
      var record;
      for (record = this._previousItHead; record !== null; record = record._nextPrevious) {
        fn(record);
      }
    };
    DefaultIterableDiffer.prototype.forEachAddedItem = function(fn) {
      var record;
      for (record = this._additionsHead; record !== null; record = record._nextAdded) {
        fn(record);
      }
    };
    DefaultIterableDiffer.prototype.forEachMovedItem = function(fn) {
      var record;
      for (record = this._movesHead; record !== null; record = record._nextMoved) {
        fn(record);
      }
    };
    DefaultIterableDiffer.prototype.forEachRemovedItem = function(fn) {
      var record;
      for (record = this._removalsHead; record !== null; record = record._nextRemoved) {
        fn(record);
      }
    };
    DefaultIterableDiffer.prototype.forEachIdentityChange = function(fn) {
      var record;
      for (record = this._identityChangesHead; record !== null; record = record._nextIdentityChange) {
        fn(record);
      }
    };
    DefaultIterableDiffer.prototype.diff = function(collection) {
      if (lang_2.isBlank(collection))
        collection = [];
      if (!collection_1.isListLikeIterable(collection)) {
        throw new exceptions_1.BaseException("Error trying to diff '" + collection + "'");
      }
      if (this.check(collection)) {
        return this;
      } else {
        return null;
      }
    };
    DefaultIterableDiffer.prototype.onDestroy = function() {};
    DefaultIterableDiffer.prototype.check = function(collection) {
      var _this = this;
      this._reset();
      var record = this._itHead;
      var mayBeDirty = false;
      var index;
      var item;
      var itemTrackBy;
      if (lang_2.isArray(collection)) {
        var list = collection;
        this._length = collection.length;
        for (index = 0; index < this._length; index++) {
          item = list[index];
          itemTrackBy = this._trackByFn(index, item);
          if (record === null || !lang_2.looseIdentical(record.trackById, itemTrackBy)) {
            record = this._mismatch(record, item, itemTrackBy, index);
            mayBeDirty = true;
          } else {
            if (mayBeDirty) {
              record = this._verifyReinsertion(record, item, itemTrackBy, index);
            }
            if (!lang_2.looseIdentical(record.item, item))
              this._addIdentityChange(record, item);
          }
          record = record._next;
        }
      } else {
        index = 0;
        collection_1.iterateListLike(collection, function(item) {
          itemTrackBy = _this._trackByFn(index, item);
          if (record === null || !lang_2.looseIdentical(record.trackById, itemTrackBy)) {
            record = _this._mismatch(record, item, itemTrackBy, index);
            mayBeDirty = true;
          } else {
            if (mayBeDirty) {
              record = _this._verifyReinsertion(record, item, itemTrackBy, index);
            }
            if (!lang_2.looseIdentical(record.item, item))
              _this._addIdentityChange(record, item);
          }
          record = record._next;
          index++;
        });
        this._length = index;
      }
      this._truncate(record);
      this._collection = collection;
      return this.isDirty;
    };
    Object.defineProperty(DefaultIterableDiffer.prototype, "isDirty", {
      get: function() {
        return this._additionsHead !== null || this._movesHead !== null || this._removalsHead !== null || this._identityChangesHead !== null;
      },
      enumerable: true,
      configurable: true
    });
    DefaultIterableDiffer.prototype._reset = function() {
      if (this.isDirty) {
        var record;
        var nextRecord;
        for (record = this._previousItHead = this._itHead; record !== null; record = record._next) {
          record._nextPrevious = record._next;
        }
        for (record = this._additionsHead; record !== null; record = record._nextAdded) {
          record.previousIndex = record.currentIndex;
        }
        this._additionsHead = this._additionsTail = null;
        for (record = this._movesHead; record !== null; record = nextRecord) {
          record.previousIndex = record.currentIndex;
          nextRecord = record._nextMoved;
        }
        this._movesHead = this._movesTail = null;
        this._removalsHead = this._removalsTail = null;
        this._identityChangesHead = this._identityChangesTail = null;
      }
    };
    DefaultIterableDiffer.prototype._mismatch = function(record, item, itemTrackBy, index) {
      var previousRecord;
      if (record === null) {
        previousRecord = this._itTail;
      } else {
        previousRecord = record._prev;
        this._remove(record);
      }
      record = this._linkedRecords === null ? null : this._linkedRecords.get(itemTrackBy, index);
      if (record !== null) {
        if (!lang_2.looseIdentical(record.item, item))
          this._addIdentityChange(record, item);
        this._moveAfter(record, previousRecord, index);
      } else {
        record = this._unlinkedRecords === null ? null : this._unlinkedRecords.get(itemTrackBy);
        if (record !== null) {
          if (!lang_2.looseIdentical(record.item, item))
            this._addIdentityChange(record, item);
          this._reinsertAfter(record, previousRecord, index);
        } else {
          record = this._addAfter(new CollectionChangeRecord(item, itemTrackBy), previousRecord, index);
        }
      }
      return record;
    };
    DefaultIterableDiffer.prototype._verifyReinsertion = function(record, item, itemTrackBy, index) {
      var reinsertRecord = this._unlinkedRecords === null ? null : this._unlinkedRecords.get(itemTrackBy);
      if (reinsertRecord !== null) {
        record = this._reinsertAfter(reinsertRecord, record._prev, index);
      } else if (record.currentIndex != index) {
        record.currentIndex = index;
        this._addToMoves(record, index);
      }
      return record;
    };
    DefaultIterableDiffer.prototype._truncate = function(record) {
      while (record !== null) {
        var nextRecord = record._next;
        this._addToRemovals(this._unlink(record));
        record = nextRecord;
      }
      if (this._unlinkedRecords !== null) {
        this._unlinkedRecords.clear();
      }
      if (this._additionsTail !== null) {
        this._additionsTail._nextAdded = null;
      }
      if (this._movesTail !== null) {
        this._movesTail._nextMoved = null;
      }
      if (this._itTail !== null) {
        this._itTail._next = null;
      }
      if (this._removalsTail !== null) {
        this._removalsTail._nextRemoved = null;
      }
    };
    DefaultIterableDiffer.prototype._reinsertAfter = function(record, prevRecord, index) {
      if (this._unlinkedRecords !== null) {
        this._unlinkedRecords.remove(record);
      }
      var prev = record._prevRemoved;
      var next = record._nextRemoved;
      if (prev === null) {
        this._removalsHead = next;
      } else {
        prev._nextRemoved = next;
      }
      if (next === null) {
        this._removalsTail = prev;
      } else {
        next._prevRemoved = prev;
      }
      this._insertAfter(record, prevRecord, index);
      this._addToMoves(record, index);
      return record;
    };
    DefaultIterableDiffer.prototype._moveAfter = function(record, prevRecord, index) {
      this._unlink(record);
      this._insertAfter(record, prevRecord, index);
      this._addToMoves(record, index);
      return record;
    };
    DefaultIterableDiffer.prototype._addAfter = function(record, prevRecord, index) {
      this._insertAfter(record, prevRecord, index);
      if (this._additionsTail === null) {
        this._additionsTail = this._additionsHead = record;
      } else {
        this._additionsTail = this._additionsTail._nextAdded = record;
      }
      return record;
    };
    DefaultIterableDiffer.prototype._insertAfter = function(record, prevRecord, index) {
      var next = prevRecord === null ? this._itHead : prevRecord._next;
      record._next = next;
      record._prev = prevRecord;
      if (next === null) {
        this._itTail = record;
      } else {
        next._prev = record;
      }
      if (prevRecord === null) {
        this._itHead = record;
      } else {
        prevRecord._next = record;
      }
      if (this._linkedRecords === null) {
        this._linkedRecords = new _DuplicateMap();
      }
      this._linkedRecords.put(record);
      record.currentIndex = index;
      return record;
    };
    DefaultIterableDiffer.prototype._remove = function(record) {
      return this._addToRemovals(this._unlink(record));
    };
    DefaultIterableDiffer.prototype._unlink = function(record) {
      if (this._linkedRecords !== null) {
        this._linkedRecords.remove(record);
      }
      var prev = record._prev;
      var next = record._next;
      if (prev === null) {
        this._itHead = next;
      } else {
        prev._next = next;
      }
      if (next === null) {
        this._itTail = prev;
      } else {
        next._prev = prev;
      }
      return record;
    };
    DefaultIterableDiffer.prototype._addToMoves = function(record, toIndex) {
      if (record.previousIndex === toIndex) {
        return record;
      }
      if (this._movesTail === null) {
        this._movesTail = this._movesHead = record;
      } else {
        this._movesTail = this._movesTail._nextMoved = record;
      }
      return record;
    };
    DefaultIterableDiffer.prototype._addToRemovals = function(record) {
      if (this._unlinkedRecords === null) {
        this._unlinkedRecords = new _DuplicateMap();
      }
      this._unlinkedRecords.put(record);
      record.currentIndex = null;
      record._nextRemoved = null;
      if (this._removalsTail === null) {
        this._removalsTail = this._removalsHead = record;
        record._prevRemoved = null;
      } else {
        record._prevRemoved = this._removalsTail;
        this._removalsTail = this._removalsTail._nextRemoved = record;
      }
      return record;
    };
    DefaultIterableDiffer.prototype._addIdentityChange = function(record, item) {
      record.item = item;
      if (this._identityChangesTail === null) {
        this._identityChangesTail = this._identityChangesHead = record;
      } else {
        this._identityChangesTail = this._identityChangesTail._nextIdentityChange = record;
      }
      return record;
    };
    DefaultIterableDiffer.prototype.toString = function() {
      var list = [];
      this.forEachItem(function(record) {
        return list.push(record);
      });
      var previous = [];
      this.forEachPreviousItem(function(record) {
        return previous.push(record);
      });
      var additions = [];
      this.forEachAddedItem(function(record) {
        return additions.push(record);
      });
      var moves = [];
      this.forEachMovedItem(function(record) {
        return moves.push(record);
      });
      var removals = [];
      this.forEachRemovedItem(function(record) {
        return removals.push(record);
      });
      var identityChanges = [];
      this.forEachIdentityChange(function(record) {
        return identityChanges.push(record);
      });
      return "collection: " + list.join(', ') + "\n" + "previous: " + previous.join(', ') + "\n" + "additions: " + additions.join(', ') + "\n" + "moves: " + moves.join(', ') + "\n" + "removals: " + removals.join(', ') + "\n" + "identityChanges: " + identityChanges.join(', ') + "\n";
    };
    return DefaultIterableDiffer;
  })();
  exports.DefaultIterableDiffer = DefaultIterableDiffer;
  var CollectionChangeRecord = (function() {
    function CollectionChangeRecord(item, trackById) {
      this.item = item;
      this.trackById = trackById;
      this.currentIndex = null;
      this.previousIndex = null;
      this._nextPrevious = null;
      this._prev = null;
      this._next = null;
      this._prevDup = null;
      this._nextDup = null;
      this._prevRemoved = null;
      this._nextRemoved = null;
      this._nextAdded = null;
      this._nextMoved = null;
      this._nextIdentityChange = null;
    }
    CollectionChangeRecord.prototype.toString = function() {
      return this.previousIndex === this.currentIndex ? lang_2.stringify(this.item) : lang_2.stringify(this.item) + '[' + lang_2.stringify(this.previousIndex) + '->' + lang_2.stringify(this.currentIndex) + ']';
    };
    return CollectionChangeRecord;
  })();
  exports.CollectionChangeRecord = CollectionChangeRecord;
  var _DuplicateItemRecordList = (function() {
    function _DuplicateItemRecordList() {
      this._head = null;
      this._tail = null;
    }
    _DuplicateItemRecordList.prototype.add = function(record) {
      if (this._head === null) {
        this._head = this._tail = record;
        record._nextDup = null;
        record._prevDup = null;
      } else {
        this._tail._nextDup = record;
        record._prevDup = this._tail;
        record._nextDup = null;
        this._tail = record;
      }
    };
    _DuplicateItemRecordList.prototype.get = function(trackById, afterIndex) {
      var record;
      for (record = this._head; record !== null; record = record._nextDup) {
        if ((afterIndex === null || afterIndex < record.currentIndex) && lang_2.looseIdentical(record.trackById, trackById)) {
          return record;
        }
      }
      return null;
    };
    _DuplicateItemRecordList.prototype.remove = function(record) {
      var prev = record._prevDup;
      var next = record._nextDup;
      if (prev === null) {
        this._head = next;
      } else {
        prev._nextDup = next;
      }
      if (next === null) {
        this._tail = prev;
      } else {
        next._prevDup = prev;
      }
      return this._head === null;
    };
    return _DuplicateItemRecordList;
  })();
  var _DuplicateMap = (function() {
    function _DuplicateMap() {
      this.map = new Map();
    }
    _DuplicateMap.prototype.put = function(record) {
      var key = lang_2.getMapKey(record.trackById);
      var duplicates = this.map.get(key);
      if (!lang_2.isPresent(duplicates)) {
        duplicates = new _DuplicateItemRecordList();
        this.map.set(key, duplicates);
      }
      duplicates.add(record);
    };
    _DuplicateMap.prototype.get = function(trackById, afterIndex) {
      if (afterIndex === void 0) {
        afterIndex = null;
      }
      var key = lang_2.getMapKey(trackById);
      var recordList = this.map.get(key);
      return lang_2.isBlank(recordList) ? null : recordList.get(trackById, afterIndex);
    };
    _DuplicateMap.prototype.remove = function(record) {
      var key = lang_2.getMapKey(record.trackById);
      var recordList = this.map.get(key);
      if (recordList.remove(record)) {
        this.map.delete(key);
      }
      return record;
    };
    Object.defineProperty(_DuplicateMap.prototype, "isEmpty", {
      get: function() {
        return this.map.size === 0;
      },
      enumerable: true,
      configurable: true
    });
    _DuplicateMap.prototype.clear = function() {
      this.map.clear();
    };
    _DuplicateMap.prototype.toString = function() {
      return '_DuplicateMap(' + lang_2.stringify(this.map) + ')';
    };
    return _DuplicateMap;
  })();
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/differs/keyvalue_differs", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection", "angular2/src/core/di"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var di_1 = require("angular2/src/core/di");
  var KeyValueDiffers = (function() {
    function KeyValueDiffers(factories) {
      this.factories = factories;
    }
    KeyValueDiffers.create = function(factories, parent) {
      if (lang_1.isPresent(parent)) {
        var copied = collection_1.ListWrapper.clone(parent.factories);
        factories = factories.concat(copied);
        return new KeyValueDiffers(factories);
      } else {
        return new KeyValueDiffers(factories);
      }
    };
    KeyValueDiffers.extend = function(factories) {
      return new di_1.Provider(KeyValueDiffers, {
        useFactory: function(parent) {
          if (lang_1.isBlank(parent)) {
            throw new exceptions_1.BaseException('Cannot extend KeyValueDiffers without a parent injector');
          }
          return KeyValueDiffers.create(factories, parent);
        },
        deps: [[KeyValueDiffers, new di_1.SkipSelfMetadata(), new di_1.OptionalMetadata()]]
      });
    };
    KeyValueDiffers.prototype.find = function(kv) {
      var factory = this.factories.find(function(f) {
        return f.supports(kv);
      });
      if (lang_1.isPresent(factory)) {
        return factory;
      } else {
        throw new exceptions_1.BaseException("Cannot find a differ supporting object '" + kv + "'");
      }
    };
    KeyValueDiffers = __decorate([di_1.Injectable(), lang_1.CONST(), __metadata('design:paramtypes', [Array])], KeyValueDiffers);
    return KeyValueDiffers;
  })();
  exports.KeyValueDiffers = KeyValueDiffers;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/differs/default_keyvalue_differ", ["angular2/src/facade/collection", "angular2/src/facade/lang", "angular2/src/facade/exceptions"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var collection_1 = require("angular2/src/facade/collection");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var DefaultKeyValueDifferFactory = (function() {
    function DefaultKeyValueDifferFactory() {}
    DefaultKeyValueDifferFactory.prototype.supports = function(obj) {
      return obj instanceof Map || lang_1.isJsObject(obj);
    };
    DefaultKeyValueDifferFactory.prototype.create = function(cdRef) {
      return new DefaultKeyValueDiffer();
    };
    DefaultKeyValueDifferFactory = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [])], DefaultKeyValueDifferFactory);
    return DefaultKeyValueDifferFactory;
  })();
  exports.DefaultKeyValueDifferFactory = DefaultKeyValueDifferFactory;
  var DefaultKeyValueDiffer = (function() {
    function DefaultKeyValueDiffer() {
      this._records = new Map();
      this._mapHead = null;
      this._previousMapHead = null;
      this._changesHead = null;
      this._changesTail = null;
      this._additionsHead = null;
      this._additionsTail = null;
      this._removalsHead = null;
      this._removalsTail = null;
    }
    Object.defineProperty(DefaultKeyValueDiffer.prototype, "isDirty", {
      get: function() {
        return this._additionsHead !== null || this._changesHead !== null || this._removalsHead !== null;
      },
      enumerable: true,
      configurable: true
    });
    DefaultKeyValueDiffer.prototype.forEachItem = function(fn) {
      var record;
      for (record = this._mapHead; record !== null; record = record._next) {
        fn(record);
      }
    };
    DefaultKeyValueDiffer.prototype.forEachPreviousItem = function(fn) {
      var record;
      for (record = this._previousMapHead; record !== null; record = record._nextPrevious) {
        fn(record);
      }
    };
    DefaultKeyValueDiffer.prototype.forEachChangedItem = function(fn) {
      var record;
      for (record = this._changesHead; record !== null; record = record._nextChanged) {
        fn(record);
      }
    };
    DefaultKeyValueDiffer.prototype.forEachAddedItem = function(fn) {
      var record;
      for (record = this._additionsHead; record !== null; record = record._nextAdded) {
        fn(record);
      }
    };
    DefaultKeyValueDiffer.prototype.forEachRemovedItem = function(fn) {
      var record;
      for (record = this._removalsHead; record !== null; record = record._nextRemoved) {
        fn(record);
      }
    };
    DefaultKeyValueDiffer.prototype.diff = function(map) {
      if (lang_1.isBlank(map))
        map = collection_1.MapWrapper.createFromPairs([]);
      if (!(map instanceof Map || lang_1.isJsObject(map))) {
        throw new exceptions_1.BaseException("Error trying to diff '" + map + "'");
      }
      if (this.check(map)) {
        return this;
      } else {
        return null;
      }
    };
    DefaultKeyValueDiffer.prototype.onDestroy = function() {};
    DefaultKeyValueDiffer.prototype.check = function(map) {
      var _this = this;
      this._reset();
      var records = this._records;
      var oldSeqRecord = this._mapHead;
      var lastOldSeqRecord = null;
      var lastNewSeqRecord = null;
      var seqChanged = false;
      this._forEach(map, function(value, key) {
        var newSeqRecord;
        if (oldSeqRecord !== null && key === oldSeqRecord.key) {
          newSeqRecord = oldSeqRecord;
          if (!lang_1.looseIdentical(value, oldSeqRecord.currentValue)) {
            oldSeqRecord.previousValue = oldSeqRecord.currentValue;
            oldSeqRecord.currentValue = value;
            _this._addToChanges(oldSeqRecord);
          }
        } else {
          seqChanged = true;
          if (oldSeqRecord !== null) {
            oldSeqRecord._next = null;
            _this._removeFromSeq(lastOldSeqRecord, oldSeqRecord);
            _this._addToRemovals(oldSeqRecord);
          }
          if (records.has(key)) {
            newSeqRecord = records.get(key);
          } else {
            newSeqRecord = new KVChangeRecord(key);
            records.set(key, newSeqRecord);
            newSeqRecord.currentValue = value;
            _this._addToAdditions(newSeqRecord);
          }
        }
        if (seqChanged) {
          if (_this._isInRemovals(newSeqRecord)) {
            _this._removeFromRemovals(newSeqRecord);
          }
          if (lastNewSeqRecord == null) {
            _this._mapHead = newSeqRecord;
          } else {
            lastNewSeqRecord._next = newSeqRecord;
          }
        }
        lastOldSeqRecord = oldSeqRecord;
        lastNewSeqRecord = newSeqRecord;
        oldSeqRecord = oldSeqRecord === null ? null : oldSeqRecord._next;
      });
      this._truncate(lastOldSeqRecord, oldSeqRecord);
      return this.isDirty;
    };
    DefaultKeyValueDiffer.prototype._reset = function() {
      if (this.isDirty) {
        var record;
        for (record = this._previousMapHead = this._mapHead; record !== null; record = record._next) {
          record._nextPrevious = record._next;
        }
        for (record = this._changesHead; record !== null; record = record._nextChanged) {
          record.previousValue = record.currentValue;
        }
        for (record = this._additionsHead; record != null; record = record._nextAdded) {
          record.previousValue = record.currentValue;
        }
        this._changesHead = this._changesTail = null;
        this._additionsHead = this._additionsTail = null;
        this._removalsHead = this._removalsTail = null;
      }
    };
    DefaultKeyValueDiffer.prototype._truncate = function(lastRecord, record) {
      while (record !== null) {
        if (lastRecord === null) {
          this._mapHead = null;
        } else {
          lastRecord._next = null;
        }
        var nextRecord = record._next;
        this._addToRemovals(record);
        lastRecord = record;
        record = nextRecord;
      }
      for (var rec = this._removalsHead; rec !== null; rec = rec._nextRemoved) {
        rec.previousValue = rec.currentValue;
        rec.currentValue = null;
        this._records.delete(rec.key);
      }
    };
    DefaultKeyValueDiffer.prototype._isInRemovals = function(record) {
      return record === this._removalsHead || record._nextRemoved !== null || record._prevRemoved !== null;
    };
    DefaultKeyValueDiffer.prototype._addToRemovals = function(record) {
      if (this._removalsHead === null) {
        this._removalsHead = this._removalsTail = record;
      } else {
        this._removalsTail._nextRemoved = record;
        record._prevRemoved = this._removalsTail;
        this._removalsTail = record;
      }
    };
    DefaultKeyValueDiffer.prototype._removeFromSeq = function(prev, record) {
      var next = record._next;
      if (prev === null) {
        this._mapHead = next;
      } else {
        prev._next = next;
      }
    };
    DefaultKeyValueDiffer.prototype._removeFromRemovals = function(record) {
      var prev = record._prevRemoved;
      var next = record._nextRemoved;
      if (prev === null) {
        this._removalsHead = next;
      } else {
        prev._nextRemoved = next;
      }
      if (next === null) {
        this._removalsTail = prev;
      } else {
        next._prevRemoved = prev;
      }
      record._prevRemoved = record._nextRemoved = null;
    };
    DefaultKeyValueDiffer.prototype._addToAdditions = function(record) {
      if (this._additionsHead === null) {
        this._additionsHead = this._additionsTail = record;
      } else {
        this._additionsTail._nextAdded = record;
        this._additionsTail = record;
      }
    };
    DefaultKeyValueDiffer.prototype._addToChanges = function(record) {
      if (this._changesHead === null) {
        this._changesHead = this._changesTail = record;
      } else {
        this._changesTail._nextChanged = record;
        this._changesTail = record;
      }
    };
    DefaultKeyValueDiffer.prototype.toString = function() {
      var items = [];
      var previous = [];
      var changes = [];
      var additions = [];
      var removals = [];
      var record;
      for (record = this._mapHead; record !== null; record = record._next) {
        items.push(lang_1.stringify(record));
      }
      for (record = this._previousMapHead; record !== null; record = record._nextPrevious) {
        previous.push(lang_1.stringify(record));
      }
      for (record = this._changesHead; record !== null; record = record._nextChanged) {
        changes.push(lang_1.stringify(record));
      }
      for (record = this._additionsHead; record !== null; record = record._nextAdded) {
        additions.push(lang_1.stringify(record));
      }
      for (record = this._removalsHead; record !== null; record = record._nextRemoved) {
        removals.push(lang_1.stringify(record));
      }
      return "map: " + items.join(', ') + "\n" + "previous: " + previous.join(', ') + "\n" + "additions: " + additions.join(', ') + "\n" + "changes: " + changes.join(', ') + "\n" + "removals: " + removals.join(', ') + "\n";
    };
    DefaultKeyValueDiffer.prototype._forEach = function(obj, fn) {
      if (obj instanceof Map) {
        obj.forEach(fn);
      } else {
        collection_1.StringMapWrapper.forEach(obj, fn);
      }
    };
    return DefaultKeyValueDiffer;
  })();
  exports.DefaultKeyValueDiffer = DefaultKeyValueDiffer;
  var KVChangeRecord = (function() {
    function KVChangeRecord(key) {
      this.key = key;
      this.previousValue = null;
      this.currentValue = null;
      this._nextPrevious = null;
      this._next = null;
      this._nextAdded = null;
      this._nextRemoved = null;
      this._prevRemoved = null;
      this._nextChanged = null;
    }
    KVChangeRecord.prototype.toString = function() {
      return lang_1.looseIdentical(this.previousValue, this.currentValue) ? lang_1.stringify(this.key) : (lang_1.stringify(this.key) + '[' + lang_1.stringify(this.previousValue) + '->' + lang_1.stringify(this.currentValue) + ']');
    };
    return KVChangeRecord;
  })();
  exports.KVChangeRecord = KVChangeRecord;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/parser/ast", ["angular2/src/facade/collection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var collection_1 = require("angular2/src/facade/collection");
  var AST = (function() {
    function AST() {}
    AST.prototype.visit = function(visitor) {
      return null;
    };
    AST.prototype.toString = function() {
      return "AST";
    };
    return AST;
  })();
  exports.AST = AST;
  var Quote = (function(_super) {
    __extends(Quote, _super);
    function Quote(prefix, uninterpretedExpression, location) {
      _super.call(this);
      this.prefix = prefix;
      this.uninterpretedExpression = uninterpretedExpression;
      this.location = location;
    }
    Quote.prototype.visit = function(visitor) {
      return visitor.visitQuote(this);
    };
    Quote.prototype.toString = function() {
      return "Quote";
    };
    return Quote;
  })(AST);
  exports.Quote = Quote;
  var EmptyExpr = (function(_super) {
    __extends(EmptyExpr, _super);
    function EmptyExpr() {
      _super.apply(this, arguments);
    }
    EmptyExpr.prototype.visit = function(visitor) {};
    return EmptyExpr;
  })(AST);
  exports.EmptyExpr = EmptyExpr;
  var ImplicitReceiver = (function(_super) {
    __extends(ImplicitReceiver, _super);
    function ImplicitReceiver() {
      _super.apply(this, arguments);
    }
    ImplicitReceiver.prototype.visit = function(visitor) {
      return visitor.visitImplicitReceiver(this);
    };
    return ImplicitReceiver;
  })(AST);
  exports.ImplicitReceiver = ImplicitReceiver;
  var Chain = (function(_super) {
    __extends(Chain, _super);
    function Chain(expressions) {
      _super.call(this);
      this.expressions = expressions;
    }
    Chain.prototype.visit = function(visitor) {
      return visitor.visitChain(this);
    };
    return Chain;
  })(AST);
  exports.Chain = Chain;
  var Conditional = (function(_super) {
    __extends(Conditional, _super);
    function Conditional(condition, trueExp, falseExp) {
      _super.call(this);
      this.condition = condition;
      this.trueExp = trueExp;
      this.falseExp = falseExp;
    }
    Conditional.prototype.visit = function(visitor) {
      return visitor.visitConditional(this);
    };
    return Conditional;
  })(AST);
  exports.Conditional = Conditional;
  var PropertyRead = (function(_super) {
    __extends(PropertyRead, _super);
    function PropertyRead(receiver, name, getter) {
      _super.call(this);
      this.receiver = receiver;
      this.name = name;
      this.getter = getter;
    }
    PropertyRead.prototype.visit = function(visitor) {
      return visitor.visitPropertyRead(this);
    };
    return PropertyRead;
  })(AST);
  exports.PropertyRead = PropertyRead;
  var PropertyWrite = (function(_super) {
    __extends(PropertyWrite, _super);
    function PropertyWrite(receiver, name, setter, value) {
      _super.call(this);
      this.receiver = receiver;
      this.name = name;
      this.setter = setter;
      this.value = value;
    }
    PropertyWrite.prototype.visit = function(visitor) {
      return visitor.visitPropertyWrite(this);
    };
    return PropertyWrite;
  })(AST);
  exports.PropertyWrite = PropertyWrite;
  var SafePropertyRead = (function(_super) {
    __extends(SafePropertyRead, _super);
    function SafePropertyRead(receiver, name, getter) {
      _super.call(this);
      this.receiver = receiver;
      this.name = name;
      this.getter = getter;
    }
    SafePropertyRead.prototype.visit = function(visitor) {
      return visitor.visitSafePropertyRead(this);
    };
    return SafePropertyRead;
  })(AST);
  exports.SafePropertyRead = SafePropertyRead;
  var KeyedRead = (function(_super) {
    __extends(KeyedRead, _super);
    function KeyedRead(obj, key) {
      _super.call(this);
      this.obj = obj;
      this.key = key;
    }
    KeyedRead.prototype.visit = function(visitor) {
      return visitor.visitKeyedRead(this);
    };
    return KeyedRead;
  })(AST);
  exports.KeyedRead = KeyedRead;
  var KeyedWrite = (function(_super) {
    __extends(KeyedWrite, _super);
    function KeyedWrite(obj, key, value) {
      _super.call(this);
      this.obj = obj;
      this.key = key;
      this.value = value;
    }
    KeyedWrite.prototype.visit = function(visitor) {
      return visitor.visitKeyedWrite(this);
    };
    return KeyedWrite;
  })(AST);
  exports.KeyedWrite = KeyedWrite;
  var BindingPipe = (function(_super) {
    __extends(BindingPipe, _super);
    function BindingPipe(exp, name, args) {
      _super.call(this);
      this.exp = exp;
      this.name = name;
      this.args = args;
    }
    BindingPipe.prototype.visit = function(visitor) {
      return visitor.visitPipe(this);
    };
    return BindingPipe;
  })(AST);
  exports.BindingPipe = BindingPipe;
  var LiteralPrimitive = (function(_super) {
    __extends(LiteralPrimitive, _super);
    function LiteralPrimitive(value) {
      _super.call(this);
      this.value = value;
    }
    LiteralPrimitive.prototype.visit = function(visitor) {
      return visitor.visitLiteralPrimitive(this);
    };
    return LiteralPrimitive;
  })(AST);
  exports.LiteralPrimitive = LiteralPrimitive;
  var LiteralArray = (function(_super) {
    __extends(LiteralArray, _super);
    function LiteralArray(expressions) {
      _super.call(this);
      this.expressions = expressions;
    }
    LiteralArray.prototype.visit = function(visitor) {
      return visitor.visitLiteralArray(this);
    };
    return LiteralArray;
  })(AST);
  exports.LiteralArray = LiteralArray;
  var LiteralMap = (function(_super) {
    __extends(LiteralMap, _super);
    function LiteralMap(keys, values) {
      _super.call(this);
      this.keys = keys;
      this.values = values;
    }
    LiteralMap.prototype.visit = function(visitor) {
      return visitor.visitLiteralMap(this);
    };
    return LiteralMap;
  })(AST);
  exports.LiteralMap = LiteralMap;
  var Interpolation = (function(_super) {
    __extends(Interpolation, _super);
    function Interpolation(strings, expressions) {
      _super.call(this);
      this.strings = strings;
      this.expressions = expressions;
    }
    Interpolation.prototype.visit = function(visitor) {
      return visitor.visitInterpolation(this);
    };
    return Interpolation;
  })(AST);
  exports.Interpolation = Interpolation;
  var Binary = (function(_super) {
    __extends(Binary, _super);
    function Binary(operation, left, right) {
      _super.call(this);
      this.operation = operation;
      this.left = left;
      this.right = right;
    }
    Binary.prototype.visit = function(visitor) {
      return visitor.visitBinary(this);
    };
    return Binary;
  })(AST);
  exports.Binary = Binary;
  var PrefixNot = (function(_super) {
    __extends(PrefixNot, _super);
    function PrefixNot(expression) {
      _super.call(this);
      this.expression = expression;
    }
    PrefixNot.prototype.visit = function(visitor) {
      return visitor.visitPrefixNot(this);
    };
    return PrefixNot;
  })(AST);
  exports.PrefixNot = PrefixNot;
  var MethodCall = (function(_super) {
    __extends(MethodCall, _super);
    function MethodCall(receiver, name, fn, args) {
      _super.call(this);
      this.receiver = receiver;
      this.name = name;
      this.fn = fn;
      this.args = args;
    }
    MethodCall.prototype.visit = function(visitor) {
      return visitor.visitMethodCall(this);
    };
    return MethodCall;
  })(AST);
  exports.MethodCall = MethodCall;
  var SafeMethodCall = (function(_super) {
    __extends(SafeMethodCall, _super);
    function SafeMethodCall(receiver, name, fn, args) {
      _super.call(this);
      this.receiver = receiver;
      this.name = name;
      this.fn = fn;
      this.args = args;
    }
    SafeMethodCall.prototype.visit = function(visitor) {
      return visitor.visitSafeMethodCall(this);
    };
    return SafeMethodCall;
  })(AST);
  exports.SafeMethodCall = SafeMethodCall;
  var FunctionCall = (function(_super) {
    __extends(FunctionCall, _super);
    function FunctionCall(target, args) {
      _super.call(this);
      this.target = target;
      this.args = args;
    }
    FunctionCall.prototype.visit = function(visitor) {
      return visitor.visitFunctionCall(this);
    };
    return FunctionCall;
  })(AST);
  exports.FunctionCall = FunctionCall;
  var ASTWithSource = (function(_super) {
    __extends(ASTWithSource, _super);
    function ASTWithSource(ast, source, location) {
      _super.call(this);
      this.ast = ast;
      this.source = source;
      this.location = location;
    }
    ASTWithSource.prototype.visit = function(visitor) {
      return this.ast.visit(visitor);
    };
    ASTWithSource.prototype.toString = function() {
      return this.source + " in " + this.location;
    };
    return ASTWithSource;
  })(AST);
  exports.ASTWithSource = ASTWithSource;
  var TemplateBinding = (function() {
    function TemplateBinding(key, keyIsVar, name, expression) {
      this.key = key;
      this.keyIsVar = keyIsVar;
      this.name = name;
      this.expression = expression;
    }
    return TemplateBinding;
  })();
  exports.TemplateBinding = TemplateBinding;
  var RecursiveAstVisitor = (function() {
    function RecursiveAstVisitor() {}
    RecursiveAstVisitor.prototype.visitBinary = function(ast) {
      ast.left.visit(this);
      ast.right.visit(this);
      return null;
    };
    RecursiveAstVisitor.prototype.visitChain = function(ast) {
      return this.visitAll(ast.expressions);
    };
    RecursiveAstVisitor.prototype.visitConditional = function(ast) {
      ast.condition.visit(this);
      ast.trueExp.visit(this);
      ast.falseExp.visit(this);
      return null;
    };
    RecursiveAstVisitor.prototype.visitPipe = function(ast) {
      ast.exp.visit(this);
      this.visitAll(ast.args);
      return null;
    };
    RecursiveAstVisitor.prototype.visitFunctionCall = function(ast) {
      ast.target.visit(this);
      this.visitAll(ast.args);
      return null;
    };
    RecursiveAstVisitor.prototype.visitImplicitReceiver = function(ast) {
      return null;
    };
    RecursiveAstVisitor.prototype.visitInterpolation = function(ast) {
      return this.visitAll(ast.expressions);
    };
    RecursiveAstVisitor.prototype.visitKeyedRead = function(ast) {
      ast.obj.visit(this);
      ast.key.visit(this);
      return null;
    };
    RecursiveAstVisitor.prototype.visitKeyedWrite = function(ast) {
      ast.obj.visit(this);
      ast.key.visit(this);
      ast.value.visit(this);
      return null;
    };
    RecursiveAstVisitor.prototype.visitLiteralArray = function(ast) {
      return this.visitAll(ast.expressions);
    };
    RecursiveAstVisitor.prototype.visitLiteralMap = function(ast) {
      return this.visitAll(ast.values);
    };
    RecursiveAstVisitor.prototype.visitLiteralPrimitive = function(ast) {
      return null;
    };
    RecursiveAstVisitor.prototype.visitMethodCall = function(ast) {
      ast.receiver.visit(this);
      return this.visitAll(ast.args);
    };
    RecursiveAstVisitor.prototype.visitPrefixNot = function(ast) {
      ast.expression.visit(this);
      return null;
    };
    RecursiveAstVisitor.prototype.visitPropertyRead = function(ast) {
      ast.receiver.visit(this);
      return null;
    };
    RecursiveAstVisitor.prototype.visitPropertyWrite = function(ast) {
      ast.receiver.visit(this);
      ast.value.visit(this);
      return null;
    };
    RecursiveAstVisitor.prototype.visitSafePropertyRead = function(ast) {
      ast.receiver.visit(this);
      return null;
    };
    RecursiveAstVisitor.prototype.visitSafeMethodCall = function(ast) {
      ast.receiver.visit(this);
      return this.visitAll(ast.args);
    };
    RecursiveAstVisitor.prototype.visitAll = function(asts) {
      var _this = this;
      asts.forEach(function(ast) {
        return ast.visit(_this);
      });
      return null;
    };
    RecursiveAstVisitor.prototype.visitQuote = function(ast) {
      return null;
    };
    return RecursiveAstVisitor;
  })();
  exports.RecursiveAstVisitor = RecursiveAstVisitor;
  var AstTransformer = (function() {
    function AstTransformer() {}
    AstTransformer.prototype.visitImplicitReceiver = function(ast) {
      return ast;
    };
    AstTransformer.prototype.visitInterpolation = function(ast) {
      return new Interpolation(ast.strings, this.visitAll(ast.expressions));
    };
    AstTransformer.prototype.visitLiteralPrimitive = function(ast) {
      return new LiteralPrimitive(ast.value);
    };
    AstTransformer.prototype.visitPropertyRead = function(ast) {
      return new PropertyRead(ast.receiver.visit(this), ast.name, ast.getter);
    };
    AstTransformer.prototype.visitPropertyWrite = function(ast) {
      return new PropertyWrite(ast.receiver.visit(this), ast.name, ast.setter, ast.value);
    };
    AstTransformer.prototype.visitSafePropertyRead = function(ast) {
      return new SafePropertyRead(ast.receiver.visit(this), ast.name, ast.getter);
    };
    AstTransformer.prototype.visitMethodCall = function(ast) {
      return new MethodCall(ast.receiver.visit(this), ast.name, ast.fn, this.visitAll(ast.args));
    };
    AstTransformer.prototype.visitSafeMethodCall = function(ast) {
      return new SafeMethodCall(ast.receiver.visit(this), ast.name, ast.fn, this.visitAll(ast.args));
    };
    AstTransformer.prototype.visitFunctionCall = function(ast) {
      return new FunctionCall(ast.target.visit(this), this.visitAll(ast.args));
    };
    AstTransformer.prototype.visitLiteralArray = function(ast) {
      return new LiteralArray(this.visitAll(ast.expressions));
    };
    AstTransformer.prototype.visitLiteralMap = function(ast) {
      return new LiteralMap(ast.keys, this.visitAll(ast.values));
    };
    AstTransformer.prototype.visitBinary = function(ast) {
      return new Binary(ast.operation, ast.left.visit(this), ast.right.visit(this));
    };
    AstTransformer.prototype.visitPrefixNot = function(ast) {
      return new PrefixNot(ast.expression.visit(this));
    };
    AstTransformer.prototype.visitConditional = function(ast) {
      return new Conditional(ast.condition.visit(this), ast.trueExp.visit(this), ast.falseExp.visit(this));
    };
    AstTransformer.prototype.visitPipe = function(ast) {
      return new BindingPipe(ast.exp.visit(this), ast.name, this.visitAll(ast.args));
    };
    AstTransformer.prototype.visitKeyedRead = function(ast) {
      return new KeyedRead(ast.obj.visit(this), ast.key.visit(this));
    };
    AstTransformer.prototype.visitKeyedWrite = function(ast) {
      return new KeyedWrite(ast.obj.visit(this), ast.key.visit(this), ast.value.visit(this));
    };
    AstTransformer.prototype.visitAll = function(asts) {
      var res = collection_1.ListWrapper.createFixedSize(asts.length);
      for (var i = 0; i < asts.length; ++i) {
        res[i] = asts[i].visit(this);
      }
      return res;
    };
    AstTransformer.prototype.visitChain = function(ast) {
      return new Chain(this.visitAll(ast.expressions));
    };
    AstTransformer.prototype.visitQuote = function(ast) {
      return new Quote(ast.prefix, ast.uninterpretedExpression, ast.location);
    };
    return AstTransformer;
  })();
  exports.AstTransformer = AstTransformer;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/parser/lexer", ["angular2/src/core/di/decorators", "angular2/src/facade/collection", "angular2/src/facade/lang", "angular2/src/facade/exceptions"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var decorators_1 = require("angular2/src/core/di/decorators");
  var collection_1 = require("angular2/src/facade/collection");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  (function(TokenType) {
    TokenType[TokenType["Character"] = 0] = "Character";
    TokenType[TokenType["Identifier"] = 1] = "Identifier";
    TokenType[TokenType["Keyword"] = 2] = "Keyword";
    TokenType[TokenType["String"] = 3] = "String";
    TokenType[TokenType["Operator"] = 4] = "Operator";
    TokenType[TokenType["Number"] = 5] = "Number";
  })(exports.TokenType || (exports.TokenType = {}));
  var TokenType = exports.TokenType;
  var Lexer = (function() {
    function Lexer() {}
    Lexer.prototype.tokenize = function(text) {
      var scanner = new _Scanner(text);
      var tokens = [];
      var token = scanner.scanToken();
      while (token != null) {
        tokens.push(token);
        token = scanner.scanToken();
      }
      return tokens;
    };
    Lexer = __decorate([decorators_1.Injectable(), __metadata('design:paramtypes', [])], Lexer);
    return Lexer;
  })();
  exports.Lexer = Lexer;
  var Token = (function() {
    function Token(index, type, numValue, strValue) {
      this.index = index;
      this.type = type;
      this.numValue = numValue;
      this.strValue = strValue;
    }
    Token.prototype.isCharacter = function(code) {
      return (this.type == TokenType.Character && this.numValue == code);
    };
    Token.prototype.isNumber = function() {
      return (this.type == TokenType.Number);
    };
    Token.prototype.isString = function() {
      return (this.type == TokenType.String);
    };
    Token.prototype.isOperator = function(operater) {
      return (this.type == TokenType.Operator && this.strValue == operater);
    };
    Token.prototype.isIdentifier = function() {
      return (this.type == TokenType.Identifier);
    };
    Token.prototype.isKeyword = function() {
      return (this.type == TokenType.Keyword);
    };
    Token.prototype.isKeywordVar = function() {
      return (this.type == TokenType.Keyword && this.strValue == "var");
    };
    Token.prototype.isKeywordNull = function() {
      return (this.type == TokenType.Keyword && this.strValue == "null");
    };
    Token.prototype.isKeywordUndefined = function() {
      return (this.type == TokenType.Keyword && this.strValue == "undefined");
    };
    Token.prototype.isKeywordTrue = function() {
      return (this.type == TokenType.Keyword && this.strValue == "true");
    };
    Token.prototype.isKeywordFalse = function() {
      return (this.type == TokenType.Keyword && this.strValue == "false");
    };
    Token.prototype.toNumber = function() {
      return (this.type == TokenType.Number) ? this.numValue : -1;
    };
    Token.prototype.toString = function() {
      switch (this.type) {
        case TokenType.Character:
        case TokenType.Identifier:
        case TokenType.Keyword:
        case TokenType.Operator:
        case TokenType.String:
          return this.strValue;
        case TokenType.Number:
          return this.numValue.toString();
        default:
          return null;
      }
    };
    return Token;
  })();
  exports.Token = Token;
  function newCharacterToken(index, code) {
    return new Token(index, TokenType.Character, code, lang_1.StringWrapper.fromCharCode(code));
  }
  function newIdentifierToken(index, text) {
    return new Token(index, TokenType.Identifier, 0, text);
  }
  function newKeywordToken(index, text) {
    return new Token(index, TokenType.Keyword, 0, text);
  }
  function newOperatorToken(index, text) {
    return new Token(index, TokenType.Operator, 0, text);
  }
  function newStringToken(index, text) {
    return new Token(index, TokenType.String, 0, text);
  }
  function newNumberToken(index, n) {
    return new Token(index, TokenType.Number, n, "");
  }
  exports.EOF = new Token(-1, TokenType.Character, 0, "");
  exports.$EOF = 0;
  exports.$TAB = 9;
  exports.$LF = 10;
  exports.$VTAB = 11;
  exports.$FF = 12;
  exports.$CR = 13;
  exports.$SPACE = 32;
  exports.$BANG = 33;
  exports.$DQ = 34;
  exports.$HASH = 35;
  exports.$$ = 36;
  exports.$PERCENT = 37;
  exports.$AMPERSAND = 38;
  exports.$SQ = 39;
  exports.$LPAREN = 40;
  exports.$RPAREN = 41;
  exports.$STAR = 42;
  exports.$PLUS = 43;
  exports.$COMMA = 44;
  exports.$MINUS = 45;
  exports.$PERIOD = 46;
  exports.$SLASH = 47;
  exports.$COLON = 58;
  exports.$SEMICOLON = 59;
  exports.$LT = 60;
  exports.$EQ = 61;
  exports.$GT = 62;
  exports.$QUESTION = 63;
  var $0 = 48;
  var $9 = 57;
  var $A = 65,
      $E = 69,
      $Z = 90;
  exports.$LBRACKET = 91;
  exports.$BACKSLASH = 92;
  exports.$RBRACKET = 93;
  var $CARET = 94;
  var $_ = 95;
  var $a = 97,
      $e = 101,
      $f = 102,
      $n = 110,
      $r = 114,
      $t = 116,
      $u = 117,
      $v = 118,
      $z = 122;
  exports.$LBRACE = 123;
  exports.$BAR = 124;
  exports.$RBRACE = 125;
  var $NBSP = 160;
  var ScannerError = (function(_super) {
    __extends(ScannerError, _super);
    function ScannerError(message) {
      _super.call(this);
      this.message = message;
    }
    ScannerError.prototype.toString = function() {
      return this.message;
    };
    return ScannerError;
  })(exceptions_1.BaseException);
  exports.ScannerError = ScannerError;
  var _Scanner = (function() {
    function _Scanner(input) {
      this.input = input;
      this.peek = 0;
      this.index = -1;
      this.length = input.length;
      this.advance();
    }
    _Scanner.prototype.advance = function() {
      this.peek = ++this.index >= this.length ? exports.$EOF : lang_1.StringWrapper.charCodeAt(this.input, this.index);
    };
    _Scanner.prototype.scanToken = function() {
      var input = this.input,
          length = this.length,
          peek = this.peek,
          index = this.index;
      while (peek <= exports.$SPACE) {
        if (++index >= length) {
          peek = exports.$EOF;
          break;
        } else {
          peek = lang_1.StringWrapper.charCodeAt(input, index);
        }
      }
      this.peek = peek;
      this.index = index;
      if (index >= length) {
        return null;
      }
      if (isIdentifierStart(peek))
        return this.scanIdentifier();
      if (isDigit(peek))
        return this.scanNumber(index);
      var start = index;
      switch (peek) {
        case exports.$PERIOD:
          this.advance();
          return isDigit(this.peek) ? this.scanNumber(start) : newCharacterToken(start, exports.$PERIOD);
        case exports.$LPAREN:
        case exports.$RPAREN:
        case exports.$LBRACE:
        case exports.$RBRACE:
        case exports.$LBRACKET:
        case exports.$RBRACKET:
        case exports.$COMMA:
        case exports.$COLON:
        case exports.$SEMICOLON:
          return this.scanCharacter(start, peek);
        case exports.$SQ:
        case exports.$DQ:
          return this.scanString();
        case exports.$HASH:
        case exports.$PLUS:
        case exports.$MINUS:
        case exports.$STAR:
        case exports.$SLASH:
        case exports.$PERCENT:
        case $CARET:
          return this.scanOperator(start, lang_1.StringWrapper.fromCharCode(peek));
        case exports.$QUESTION:
          return this.scanComplexOperator(start, '?', exports.$PERIOD, '.');
        case exports.$LT:
        case exports.$GT:
          return this.scanComplexOperator(start, lang_1.StringWrapper.fromCharCode(peek), exports.$EQ, '=');
        case exports.$BANG:
        case exports.$EQ:
          return this.scanComplexOperator(start, lang_1.StringWrapper.fromCharCode(peek), exports.$EQ, '=', exports.$EQ, '=');
        case exports.$AMPERSAND:
          return this.scanComplexOperator(start, '&', exports.$AMPERSAND, '&');
        case exports.$BAR:
          return this.scanComplexOperator(start, '|', exports.$BAR, '|');
        case $NBSP:
          while (isWhitespace(this.peek))
            this.advance();
          return this.scanToken();
      }
      this.error("Unexpected character [" + lang_1.StringWrapper.fromCharCode(peek) + "]", 0);
      return null;
    };
    _Scanner.prototype.scanCharacter = function(start, code) {
      this.advance();
      return newCharacterToken(start, code);
    };
    _Scanner.prototype.scanOperator = function(start, str) {
      this.advance();
      return newOperatorToken(start, str);
    };
    _Scanner.prototype.scanComplexOperator = function(start, one, twoCode, two, threeCode, three) {
      this.advance();
      var str = one;
      if (this.peek == twoCode) {
        this.advance();
        str += two;
      }
      if (lang_1.isPresent(threeCode) && this.peek == threeCode) {
        this.advance();
        str += three;
      }
      return newOperatorToken(start, str);
    };
    _Scanner.prototype.scanIdentifier = function() {
      var start = this.index;
      this.advance();
      while (isIdentifierPart(this.peek))
        this.advance();
      var str = this.input.substring(start, this.index);
      if (collection_1.SetWrapper.has(KEYWORDS, str)) {
        return newKeywordToken(start, str);
      } else {
        return newIdentifierToken(start, str);
      }
    };
    _Scanner.prototype.scanNumber = function(start) {
      var simple = (this.index === start);
      this.advance();
      while (true) {
        if (isDigit(this.peek)) {} else if (this.peek == exports.$PERIOD) {
          simple = false;
        } else if (isExponentStart(this.peek)) {
          this.advance();
          if (isExponentSign(this.peek))
            this.advance();
          if (!isDigit(this.peek))
            this.error('Invalid exponent', -1);
          simple = false;
        } else {
          break;
        }
        this.advance();
      }
      var str = this.input.substring(start, this.index);
      var value = simple ? lang_1.NumberWrapper.parseIntAutoRadix(str) : lang_1.NumberWrapper.parseFloat(str);
      return newNumberToken(start, value);
    };
    _Scanner.prototype.scanString = function() {
      var start = this.index;
      var quote = this.peek;
      this.advance();
      var buffer;
      var marker = this.index;
      var input = this.input;
      while (this.peek != quote) {
        if (this.peek == exports.$BACKSLASH) {
          if (buffer == null)
            buffer = new lang_1.StringJoiner();
          buffer.add(input.substring(marker, this.index));
          this.advance();
          var unescapedCode;
          if (this.peek == $u) {
            var hex = input.substring(this.index + 1, this.index + 5);
            try {
              unescapedCode = lang_1.NumberWrapper.parseInt(hex, 16);
            } catch (e) {
              this.error("Invalid unicode escape [\\u" + hex + "]", 0);
            }
            for (var i = 0; i < 5; i++) {
              this.advance();
            }
          } else {
            unescapedCode = unescape(this.peek);
            this.advance();
          }
          buffer.add(lang_1.StringWrapper.fromCharCode(unescapedCode));
          marker = this.index;
        } else if (this.peek == exports.$EOF) {
          this.error('Unterminated quote', 0);
        } else {
          this.advance();
        }
      }
      var last = input.substring(marker, this.index);
      this.advance();
      var unescaped = last;
      if (buffer != null) {
        buffer.add(last);
        unescaped = buffer.toString();
      }
      return newStringToken(start, unescaped);
    };
    _Scanner.prototype.error = function(message, offset) {
      var position = this.index + offset;
      throw new ScannerError("Lexer Error: " + message + " at column " + position + " in expression [" + this.input + "]");
    };
    return _Scanner;
  })();
  function isWhitespace(code) {
    return (code >= exports.$TAB && code <= exports.$SPACE) || (code == $NBSP);
  }
  function isIdentifierStart(code) {
    return ($a <= code && code <= $z) || ($A <= code && code <= $Z) || (code == $_) || (code == exports.$$);
  }
  function isIdentifier(input) {
    if (input.length == 0)
      return false;
    var scanner = new _Scanner(input);
    if (!isIdentifierStart(scanner.peek))
      return false;
    scanner.advance();
    while (scanner.peek !== exports.$EOF) {
      if (!isIdentifierPart(scanner.peek))
        return false;
      scanner.advance();
    }
    return true;
  }
  exports.isIdentifier = isIdentifier;
  function isIdentifierPart(code) {
    return ($a <= code && code <= $z) || ($A <= code && code <= $Z) || ($0 <= code && code <= $9) || (code == $_) || (code == exports.$$);
  }
  function isDigit(code) {
    return $0 <= code && code <= $9;
  }
  function isExponentStart(code) {
    return code == $e || code == $E;
  }
  function isExponentSign(code) {
    return code == exports.$MINUS || code == exports.$PLUS;
  }
  function unescape(code) {
    switch (code) {
      case $n:
        return exports.$LF;
      case $f:
        return exports.$FF;
      case $r:
        return exports.$CR;
      case $t:
        return exports.$TAB;
      case $v:
        return exports.$VTAB;
      default:
        return code;
    }
  }
  var OPERATORS = collection_1.SetWrapper.createFromList(['+', '-', '*', '/', '%', '^', '=', '==', '!=', '===', '!==', '<', '>', '<=', '>=', '&&', '||', '&', '|', '!', '?', '#', '?.']);
  var KEYWORDS = collection_1.SetWrapper.createFromList(['var', 'null', 'undefined', 'true', 'false', 'if', 'else']);
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/parser/parser", ["angular2/src/core/di/decorators", "angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection", "angular2/src/core/change_detection/parser/lexer", "angular2/src/core/reflection/reflection", "angular2/src/core/change_detection/parser/ast"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var decorators_1 = require("angular2/src/core/di/decorators");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var lexer_1 = require("angular2/src/core/change_detection/parser/lexer");
  var reflection_1 = require("angular2/src/core/reflection/reflection");
  var ast_1 = require("angular2/src/core/change_detection/parser/ast");
  var _implicitReceiver = new ast_1.ImplicitReceiver();
  var INTERPOLATION_REGEXP = /\{\{([\s\S]*?)\}\}/g;
  var ParseException = (function(_super) {
    __extends(ParseException, _super);
    function ParseException(message, input, errLocation, ctxLocation) {
      _super.call(this, "Parser Error: " + message + " " + errLocation + " [" + input + "] in " + ctxLocation);
    }
    return ParseException;
  })(exceptions_1.BaseException);
  var Parser = (function() {
    function Parser(_lexer, providedReflector) {
      if (providedReflector === void 0) {
        providedReflector = null;
      }
      this._lexer = _lexer;
      this._reflector = lang_1.isPresent(providedReflector) ? providedReflector : reflection_1.reflector;
    }
    Parser.prototype.parseAction = function(input, location) {
      this._checkNoInterpolation(input, location);
      var tokens = this._lexer.tokenize(input);
      var ast = new _ParseAST(input, location, tokens, this._reflector, true).parseChain();
      return new ast_1.ASTWithSource(ast, input, location);
    };
    Parser.prototype.parseBinding = function(input, location) {
      var ast = this._parseBindingAst(input, location);
      return new ast_1.ASTWithSource(ast, input, location);
    };
    Parser.prototype.parseSimpleBinding = function(input, location) {
      var ast = this._parseBindingAst(input, location);
      if (!SimpleExpressionChecker.check(ast)) {
        throw new ParseException('Host binding expression can only contain field access and constants', input, location);
      }
      return new ast_1.ASTWithSource(ast, input, location);
    };
    Parser.prototype._parseBindingAst = function(input, location) {
      var quote = this._parseQuote(input, location);
      if (lang_1.isPresent(quote)) {
        return quote;
      }
      this._checkNoInterpolation(input, location);
      var tokens = this._lexer.tokenize(input);
      return new _ParseAST(input, location, tokens, this._reflector, false).parseChain();
    };
    Parser.prototype._parseQuote = function(input, location) {
      if (lang_1.isBlank(input))
        return null;
      var prefixSeparatorIndex = input.indexOf(':');
      if (prefixSeparatorIndex == -1)
        return null;
      var prefix = input.substring(0, prefixSeparatorIndex).trim();
      if (!lexer_1.isIdentifier(prefix))
        return null;
      var uninterpretedExpression = input.substring(prefixSeparatorIndex + 1);
      return new ast_1.Quote(prefix, uninterpretedExpression, location);
    };
    Parser.prototype.parseTemplateBindings = function(input, location) {
      var tokens = this._lexer.tokenize(input);
      return new _ParseAST(input, location, tokens, this._reflector, false).parseTemplateBindings();
    };
    Parser.prototype.parseInterpolation = function(input, location) {
      var parts = lang_1.StringWrapper.split(input, INTERPOLATION_REGEXP);
      if (parts.length <= 1) {
        return null;
      }
      var strings = [];
      var expressions = [];
      for (var i = 0; i < parts.length; i++) {
        var part = parts[i];
        if (i % 2 === 0) {
          strings.push(part);
        } else if (part.trim().length > 0) {
          var tokens = this._lexer.tokenize(part);
          var ast = new _ParseAST(input, location, tokens, this._reflector, false).parseChain();
          expressions.push(ast);
        } else {
          throw new ParseException('Blank expressions are not allowed in interpolated strings', input, "at column " + this._findInterpolationErrorColumn(parts, i) + " in", location);
        }
      }
      return new ast_1.ASTWithSource(new ast_1.Interpolation(strings, expressions), input, location);
    };
    Parser.prototype.wrapLiteralPrimitive = function(input, location) {
      return new ast_1.ASTWithSource(new ast_1.LiteralPrimitive(input), input, location);
    };
    Parser.prototype._checkNoInterpolation = function(input, location) {
      var parts = lang_1.StringWrapper.split(input, INTERPOLATION_REGEXP);
      if (parts.length > 1) {
        throw new ParseException('Got interpolation ({{}}) where expression was expected', input, "at column " + this._findInterpolationErrorColumn(parts, 1) + " in", location);
      }
    };
    Parser.prototype._findInterpolationErrorColumn = function(parts, partInErrIdx) {
      var errLocation = '';
      for (var j = 0; j < partInErrIdx; j++) {
        errLocation += j % 2 === 0 ? parts[j] : "{{" + parts[j] + "}}";
      }
      return errLocation.length;
    };
    Parser = __decorate([decorators_1.Injectable(), __metadata('design:paramtypes', [lexer_1.Lexer, reflection_1.Reflector])], Parser);
    return Parser;
  })();
  exports.Parser = Parser;
  var _ParseAST = (function() {
    function _ParseAST(input, location, tokens, reflector, parseAction) {
      this.input = input;
      this.location = location;
      this.tokens = tokens;
      this.reflector = reflector;
      this.parseAction = parseAction;
      this.index = 0;
    }
    _ParseAST.prototype.peek = function(offset) {
      var i = this.index + offset;
      return i < this.tokens.length ? this.tokens[i] : lexer_1.EOF;
    };
    Object.defineProperty(_ParseAST.prototype, "next", {
      get: function() {
        return this.peek(0);
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(_ParseAST.prototype, "inputIndex", {
      get: function() {
        return (this.index < this.tokens.length) ? this.next.index : this.input.length;
      },
      enumerable: true,
      configurable: true
    });
    _ParseAST.prototype.advance = function() {
      this.index++;
    };
    _ParseAST.prototype.optionalCharacter = function(code) {
      if (this.next.isCharacter(code)) {
        this.advance();
        return true;
      } else {
        return false;
      }
    };
    _ParseAST.prototype.optionalKeywordVar = function() {
      if (this.peekKeywordVar()) {
        this.advance();
        return true;
      } else {
        return false;
      }
    };
    _ParseAST.prototype.peekKeywordVar = function() {
      return this.next.isKeywordVar() || this.next.isOperator('#');
    };
    _ParseAST.prototype.expectCharacter = function(code) {
      if (this.optionalCharacter(code))
        return ;
      this.error("Missing expected " + lang_1.StringWrapper.fromCharCode(code));
    };
    _ParseAST.prototype.optionalOperator = function(op) {
      if (this.next.isOperator(op)) {
        this.advance();
        return true;
      } else {
        return false;
      }
    };
    _ParseAST.prototype.expectOperator = function(operator) {
      if (this.optionalOperator(operator))
        return ;
      this.error("Missing expected operator " + operator);
    };
    _ParseAST.prototype.expectIdentifierOrKeyword = function() {
      var n = this.next;
      if (!n.isIdentifier() && !n.isKeyword()) {
        this.error("Unexpected token " + n + ", expected identifier or keyword");
      }
      this.advance();
      return n.toString();
    };
    _ParseAST.prototype.expectIdentifierOrKeywordOrString = function() {
      var n = this.next;
      if (!n.isIdentifier() && !n.isKeyword() && !n.isString()) {
        this.error("Unexpected token " + n + ", expected identifier, keyword, or string");
      }
      this.advance();
      return n.toString();
    };
    _ParseAST.prototype.parseChain = function() {
      var exprs = [];
      while (this.index < this.tokens.length) {
        var expr = this.parsePipe();
        exprs.push(expr);
        if (this.optionalCharacter(lexer_1.$SEMICOLON)) {
          if (!this.parseAction) {
            this.error("Binding expression cannot contain chained expression");
          }
          while (this.optionalCharacter(lexer_1.$SEMICOLON)) {}
        } else if (this.index < this.tokens.length) {
          this.error("Unexpected token '" + this.next + "'");
        }
      }
      if (exprs.length == 0)
        return new ast_1.EmptyExpr();
      if (exprs.length == 1)
        return exprs[0];
      return new ast_1.Chain(exprs);
    };
    _ParseAST.prototype.parsePipe = function() {
      var result = this.parseExpression();
      if (this.optionalOperator("|")) {
        if (this.parseAction) {
          this.error("Cannot have a pipe in an action expression");
        }
        do {
          var name = this.expectIdentifierOrKeyword();
          var args = [];
          while (this.optionalCharacter(lexer_1.$COLON)) {
            args.push(this.parseExpression());
          }
          result = new ast_1.BindingPipe(result, name, args);
        } while (this.optionalOperator("|"));
      }
      return result;
    };
    _ParseAST.prototype.parseExpression = function() {
      return this.parseConditional();
    };
    _ParseAST.prototype.parseConditional = function() {
      var start = this.inputIndex;
      var result = this.parseLogicalOr();
      if (this.optionalOperator('?')) {
        var yes = this.parsePipe();
        if (!this.optionalCharacter(lexer_1.$COLON)) {
          var end = this.inputIndex;
          var expression = this.input.substring(start, end);
          this.error("Conditional expression " + expression + " requires all 3 expressions");
        }
        var no = this.parsePipe();
        return new ast_1.Conditional(result, yes, no);
      } else {
        return result;
      }
    };
    _ParseAST.prototype.parseLogicalOr = function() {
      var result = this.parseLogicalAnd();
      while (this.optionalOperator('||')) {
        result = new ast_1.Binary('||', result, this.parseLogicalAnd());
      }
      return result;
    };
    _ParseAST.prototype.parseLogicalAnd = function() {
      var result = this.parseEquality();
      while (this.optionalOperator('&&')) {
        result = new ast_1.Binary('&&', result, this.parseEquality());
      }
      return result;
    };
    _ParseAST.prototype.parseEquality = function() {
      var result = this.parseRelational();
      while (true) {
        if (this.optionalOperator('==')) {
          result = new ast_1.Binary('==', result, this.parseRelational());
        } else if (this.optionalOperator('===')) {
          result = new ast_1.Binary('===', result, this.parseRelational());
        } else if (this.optionalOperator('!=')) {
          result = new ast_1.Binary('!=', result, this.parseRelational());
        } else if (this.optionalOperator('!==')) {
          result = new ast_1.Binary('!==', result, this.parseRelational());
        } else {
          return result;
        }
      }
    };
    _ParseAST.prototype.parseRelational = function() {
      var result = this.parseAdditive();
      while (true) {
        if (this.optionalOperator('<')) {
          result = new ast_1.Binary('<', result, this.parseAdditive());
        } else if (this.optionalOperator('>')) {
          result = new ast_1.Binary('>', result, this.parseAdditive());
        } else if (this.optionalOperator('<=')) {
          result = new ast_1.Binary('<=', result, this.parseAdditive());
        } else if (this.optionalOperator('>=')) {
          result = new ast_1.Binary('>=', result, this.parseAdditive());
        } else {
          return result;
        }
      }
    };
    _ParseAST.prototype.parseAdditive = function() {
      var result = this.parseMultiplicative();
      while (true) {
        if (this.optionalOperator('+')) {
          result = new ast_1.Binary('+', result, this.parseMultiplicative());
        } else if (this.optionalOperator('-')) {
          result = new ast_1.Binary('-', result, this.parseMultiplicative());
        } else {
          return result;
        }
      }
    };
    _ParseAST.prototype.parseMultiplicative = function() {
      var result = this.parsePrefix();
      while (true) {
        if (this.optionalOperator('*')) {
          result = new ast_1.Binary('*', result, this.parsePrefix());
        } else if (this.optionalOperator('%')) {
          result = new ast_1.Binary('%', result, this.parsePrefix());
        } else if (this.optionalOperator('/')) {
          result = new ast_1.Binary('/', result, this.parsePrefix());
        } else {
          return result;
        }
      }
    };
    _ParseAST.prototype.parsePrefix = function() {
      if (this.optionalOperator('+')) {
        return this.parsePrefix();
      } else if (this.optionalOperator('-')) {
        return new ast_1.Binary('-', new ast_1.LiteralPrimitive(0), this.parsePrefix());
      } else if (this.optionalOperator('!')) {
        return new ast_1.PrefixNot(this.parsePrefix());
      } else {
        return this.parseCallChain();
      }
    };
    _ParseAST.prototype.parseCallChain = function() {
      var result = this.parsePrimary();
      while (true) {
        if (this.optionalCharacter(lexer_1.$PERIOD)) {
          result = this.parseAccessMemberOrMethodCall(result, false);
        } else if (this.optionalOperator('?.')) {
          result = this.parseAccessMemberOrMethodCall(result, true);
        } else if (this.optionalCharacter(lexer_1.$LBRACKET)) {
          var key = this.parsePipe();
          this.expectCharacter(lexer_1.$RBRACKET);
          if (this.optionalOperator("=")) {
            var value = this.parseConditional();
            result = new ast_1.KeyedWrite(result, key, value);
          } else {
            result = new ast_1.KeyedRead(result, key);
          }
        } else if (this.optionalCharacter(lexer_1.$LPAREN)) {
          var args = this.parseCallArguments();
          this.expectCharacter(lexer_1.$RPAREN);
          result = new ast_1.FunctionCall(result, args);
        } else {
          return result;
        }
      }
    };
    _ParseAST.prototype.parsePrimary = function() {
      if (this.optionalCharacter(lexer_1.$LPAREN)) {
        var result = this.parsePipe();
        this.expectCharacter(lexer_1.$RPAREN);
        return result;
      } else if (this.next.isKeywordNull() || this.next.isKeywordUndefined()) {
        this.advance();
        return new ast_1.LiteralPrimitive(null);
      } else if (this.next.isKeywordTrue()) {
        this.advance();
        return new ast_1.LiteralPrimitive(true);
      } else if (this.next.isKeywordFalse()) {
        this.advance();
        return new ast_1.LiteralPrimitive(false);
      } else if (this.optionalCharacter(lexer_1.$LBRACKET)) {
        var elements = this.parseExpressionList(lexer_1.$RBRACKET);
        this.expectCharacter(lexer_1.$RBRACKET);
        return new ast_1.LiteralArray(elements);
      } else if (this.next.isCharacter(lexer_1.$LBRACE)) {
        return this.parseLiteralMap();
      } else if (this.next.isIdentifier()) {
        return this.parseAccessMemberOrMethodCall(_implicitReceiver, false);
      } else if (this.next.isNumber()) {
        var value = this.next.toNumber();
        this.advance();
        return new ast_1.LiteralPrimitive(value);
      } else if (this.next.isString()) {
        var literalValue = this.next.toString();
        this.advance();
        return new ast_1.LiteralPrimitive(literalValue);
      } else if (this.index >= this.tokens.length) {
        this.error("Unexpected end of expression: " + this.input);
      } else {
        this.error("Unexpected token " + this.next);
      }
      throw new exceptions_1.BaseException("Fell through all cases in parsePrimary");
    };
    _ParseAST.prototype.parseExpressionList = function(terminator) {
      var result = [];
      if (!this.next.isCharacter(terminator)) {
        do {
          result.push(this.parsePipe());
        } while (this.optionalCharacter(lexer_1.$COMMA));
      }
      return result;
    };
    _ParseAST.prototype.parseLiteralMap = function() {
      var keys = [];
      var values = [];
      this.expectCharacter(lexer_1.$LBRACE);
      if (!this.optionalCharacter(lexer_1.$RBRACE)) {
        do {
          var key = this.expectIdentifierOrKeywordOrString();
          keys.push(key);
          this.expectCharacter(lexer_1.$COLON);
          values.push(this.parsePipe());
        } while (this.optionalCharacter(lexer_1.$COMMA));
        this.expectCharacter(lexer_1.$RBRACE);
      }
      return new ast_1.LiteralMap(keys, values);
    };
    _ParseAST.prototype.parseAccessMemberOrMethodCall = function(receiver, isSafe) {
      if (isSafe === void 0) {
        isSafe = false;
      }
      var id = this.expectIdentifierOrKeyword();
      if (this.optionalCharacter(lexer_1.$LPAREN)) {
        var args = this.parseCallArguments();
        this.expectCharacter(lexer_1.$RPAREN);
        var fn = this.reflector.method(id);
        return isSafe ? new ast_1.SafeMethodCall(receiver, id, fn, args) : new ast_1.MethodCall(receiver, id, fn, args);
      } else {
        if (isSafe) {
          if (this.optionalOperator("=")) {
            this.error("The '?.' operator cannot be used in the assignment");
          } else {
            return new ast_1.SafePropertyRead(receiver, id, this.reflector.getter(id));
          }
        } else {
          if (this.optionalOperator("=")) {
            if (!this.parseAction) {
              this.error("Bindings cannot contain assignments");
            }
            var value = this.parseConditional();
            return new ast_1.PropertyWrite(receiver, id, this.reflector.setter(id), value);
          } else {
            return new ast_1.PropertyRead(receiver, id, this.reflector.getter(id));
          }
        }
      }
      return null;
    };
    _ParseAST.prototype.parseCallArguments = function() {
      if (this.next.isCharacter(lexer_1.$RPAREN))
        return [];
      var positionals = [];
      do {
        positionals.push(this.parsePipe());
      } while (this.optionalCharacter(lexer_1.$COMMA));
      return positionals;
    };
    _ParseAST.prototype.parseBlockContent = function() {
      if (!this.parseAction) {
        this.error("Binding expression cannot contain chained expression");
      }
      var exprs = [];
      while (this.index < this.tokens.length && !this.next.isCharacter(lexer_1.$RBRACE)) {
        var expr = this.parseExpression();
        exprs.push(expr);
        if (this.optionalCharacter(lexer_1.$SEMICOLON)) {
          while (this.optionalCharacter(lexer_1.$SEMICOLON)) {}
        }
      }
      if (exprs.length == 0)
        return new ast_1.EmptyExpr();
      if (exprs.length == 1)
        return exprs[0];
      return new ast_1.Chain(exprs);
    };
    _ParseAST.prototype.expectTemplateBindingKey = function() {
      var result = '';
      var operatorFound = false;
      do {
        result += this.expectIdentifierOrKeywordOrString();
        operatorFound = this.optionalOperator('-');
        if (operatorFound) {
          result += '-';
        }
      } while (operatorFound);
      return result.toString();
    };
    _ParseAST.prototype.parseTemplateBindings = function() {
      var bindings = [];
      var prefix = null;
      while (this.index < this.tokens.length) {
        var keyIsVar = this.optionalKeywordVar();
        var key = this.expectTemplateBindingKey();
        if (!keyIsVar) {
          if (prefix == null) {
            prefix = key;
          } else {
            key = prefix + key[0].toUpperCase() + key.substring(1);
          }
        }
        this.optionalCharacter(lexer_1.$COLON);
        var name = null;
        var expression = null;
        if (keyIsVar) {
          if (this.optionalOperator("=")) {
            name = this.expectTemplateBindingKey();
          } else {
            name = '\$implicit';
          }
        } else if (this.next !== lexer_1.EOF && !this.peekKeywordVar()) {
          var start = this.inputIndex;
          var ast = this.parsePipe();
          var source = this.input.substring(start, this.inputIndex);
          expression = new ast_1.ASTWithSource(ast, source, this.location);
        }
        bindings.push(new ast_1.TemplateBinding(key, keyIsVar, name, expression));
        if (!this.optionalCharacter(lexer_1.$SEMICOLON)) {
          this.optionalCharacter(lexer_1.$COMMA);
        }
      }
      return bindings;
    };
    _ParseAST.prototype.error = function(message, index) {
      if (index === void 0) {
        index = null;
      }
      if (lang_1.isBlank(index))
        index = this.index;
      var location = (index < this.tokens.length) ? "at column " + (this.tokens[index].index + 1) + " in" : "at the end of the expression";
      throw new ParseException(message, this.input, location, this.location);
    };
    return _ParseAST;
  })();
  exports._ParseAST = _ParseAST;
  var SimpleExpressionChecker = (function() {
    function SimpleExpressionChecker() {
      this.simple = true;
    }
    SimpleExpressionChecker.check = function(ast) {
      var s = new SimpleExpressionChecker();
      ast.visit(s);
      return s.simple;
    };
    SimpleExpressionChecker.prototype.visitImplicitReceiver = function(ast) {};
    SimpleExpressionChecker.prototype.visitInterpolation = function(ast) {
      this.simple = false;
    };
    SimpleExpressionChecker.prototype.visitLiteralPrimitive = function(ast) {};
    SimpleExpressionChecker.prototype.visitPropertyRead = function(ast) {};
    SimpleExpressionChecker.prototype.visitPropertyWrite = function(ast) {
      this.simple = false;
    };
    SimpleExpressionChecker.prototype.visitSafePropertyRead = function(ast) {
      this.simple = false;
    };
    SimpleExpressionChecker.prototype.visitMethodCall = function(ast) {
      this.simple = false;
    };
    SimpleExpressionChecker.prototype.visitSafeMethodCall = function(ast) {
      this.simple = false;
    };
    SimpleExpressionChecker.prototype.visitFunctionCall = function(ast) {
      this.simple = false;
    };
    SimpleExpressionChecker.prototype.visitLiteralArray = function(ast) {
      this.visitAll(ast.expressions);
    };
    SimpleExpressionChecker.prototype.visitLiteralMap = function(ast) {
      this.visitAll(ast.values);
    };
    SimpleExpressionChecker.prototype.visitBinary = function(ast) {
      this.simple = false;
    };
    SimpleExpressionChecker.prototype.visitPrefixNot = function(ast) {
      this.simple = false;
    };
    SimpleExpressionChecker.prototype.visitConditional = function(ast) {
      this.simple = false;
    };
    SimpleExpressionChecker.prototype.visitPipe = function(ast) {
      this.simple = false;
    };
    SimpleExpressionChecker.prototype.visitKeyedRead = function(ast) {
      this.simple = false;
    };
    SimpleExpressionChecker.prototype.visitKeyedWrite = function(ast) {
      this.simple = false;
    };
    SimpleExpressionChecker.prototype.visitAll = function(asts) {
      var res = collection_1.ListWrapper.createFixedSize(asts.length);
      for (var i = 0; i < asts.length; ++i) {
        res[i] = asts[i].visit(this);
      }
      return res;
    };
    SimpleExpressionChecker.prototype.visitChain = function(ast) {
      this.simple = false;
    };
    SimpleExpressionChecker.prototype.visitQuote = function(ast) {
      this.simple = false;
    };
    return SimpleExpressionChecker;
  })();
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/parser/locals", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var Locals = (function() {
    function Locals(parent, current) {
      this.parent = parent;
      this.current = current;
    }
    Locals.prototype.contains = function(name) {
      if (this.current.has(name)) {
        return true;
      }
      if (lang_1.isPresent(this.parent)) {
        return this.parent.contains(name);
      }
      return false;
    };
    Locals.prototype.get = function(name) {
      if (this.current.has(name)) {
        return this.current.get(name);
      }
      if (lang_1.isPresent(this.parent)) {
        return this.parent.get(name);
      }
      throw new exceptions_1.BaseException("Cannot find '" + name + "'");
    };
    Locals.prototype.set = function(name, value) {
      if (this.current.has(name)) {
        this.current.set(name, value);
      } else {
        throw new exceptions_1.BaseException("Setting of new keys post-construction is not supported. Key: " + name + ".");
      }
    };
    Locals.prototype.clearLocalValues = function() {
      collection_1.MapWrapper.clearValues(this.current);
    };
    return Locals;
  })();
  exports.Locals = Locals;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/exceptions", ["angular2/src/facade/exceptions"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var ExpressionChangedAfterItHasBeenCheckedException = (function(_super) {
    __extends(ExpressionChangedAfterItHasBeenCheckedException, _super);
    function ExpressionChangedAfterItHasBeenCheckedException(exp, oldValue, currValue, context) {
      _super.call(this, ("Expression '" + exp + "' has changed after it was checked. ") + ("Previous value: '" + oldValue + "'. Current value: '" + currValue + "'"));
    }
    return ExpressionChangedAfterItHasBeenCheckedException;
  })(exceptions_1.BaseException);
  exports.ExpressionChangedAfterItHasBeenCheckedException = ExpressionChangedAfterItHasBeenCheckedException;
  var ChangeDetectionError = (function(_super) {
    __extends(ChangeDetectionError, _super);
    function ChangeDetectionError(exp, originalException, originalStack, context) {
      _super.call(this, originalException + " in [" + exp + "]", originalException, originalStack, context);
      this.location = exp;
    }
    return ChangeDetectionError;
  })(exceptions_1.WrappedException);
  exports.ChangeDetectionError = ChangeDetectionError;
  var DehydratedException = (function(_super) {
    __extends(DehydratedException, _super);
    function DehydratedException(details) {
      _super.call(this, "Attempt to use a dehydrated detector: " + details);
    }
    return DehydratedException;
  })(exceptions_1.BaseException);
  exports.DehydratedException = DehydratedException;
  var EventEvaluationError = (function(_super) {
    __extends(EventEvaluationError, _super);
    function EventEvaluationError(eventName, originalException, originalStack, context) {
      _super.call(this, "Error during evaluation of \"" + eventName + "\"", originalException, originalStack, context);
    }
    return EventEvaluationError;
  })(exceptions_1.WrappedException);
  exports.EventEvaluationError = EventEvaluationError;
  var EventEvaluationErrorContext = (function() {
    function EventEvaluationErrorContext(element, componentElement, context, locals, injector) {
      this.element = element;
      this.componentElement = componentElement;
      this.context = context;
      this.locals = locals;
      this.injector = injector;
    }
    return EventEvaluationErrorContext;
  })();
  exports.EventEvaluationErrorContext = EventEvaluationErrorContext;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/interfaces", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var DebugContext = (function() {
    function DebugContext(element, componentElement, directive, context, locals, injector) {
      this.element = element;
      this.componentElement = componentElement;
      this.directive = directive;
      this.context = context;
      this.locals = locals;
      this.injector = injector;
    }
    return DebugContext;
  })();
  exports.DebugContext = DebugContext;
  var ChangeDetectorGenConfig = (function() {
    function ChangeDetectorGenConfig(genDebugInfo, logBindingUpdate, useJit) {
      this.genDebugInfo = genDebugInfo;
      this.logBindingUpdate = logBindingUpdate;
      this.useJit = useJit;
    }
    return ChangeDetectorGenConfig;
  })();
  exports.ChangeDetectorGenConfig = ChangeDetectorGenConfig;
  var ChangeDetectorDefinition = (function() {
    function ChangeDetectorDefinition(id, strategy, variableNames, bindingRecords, eventRecords, directiveRecords, genConfig) {
      this.id = id;
      this.strategy = strategy;
      this.variableNames = variableNames;
      this.bindingRecords = bindingRecords;
      this.eventRecords = eventRecords;
      this.directiveRecords = directiveRecords;
      this.genConfig = genConfig;
    }
    return ChangeDetectorDefinition;
  })();
  exports.ChangeDetectorDefinition = ChangeDetectorDefinition;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/constants", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  (function(ChangeDetectorState) {
    ChangeDetectorState[ChangeDetectorState["NeverChecked"] = 0] = "NeverChecked";
    ChangeDetectorState[ChangeDetectorState["CheckedBefore"] = 1] = "CheckedBefore";
    ChangeDetectorState[ChangeDetectorState["Errored"] = 2] = "Errored";
  })(exports.ChangeDetectorState || (exports.ChangeDetectorState = {}));
  var ChangeDetectorState = exports.ChangeDetectorState;
  (function(ChangeDetectionStrategy) {
    ChangeDetectionStrategy[ChangeDetectionStrategy["CheckOnce"] = 0] = "CheckOnce";
    ChangeDetectionStrategy[ChangeDetectionStrategy["Checked"] = 1] = "Checked";
    ChangeDetectionStrategy[ChangeDetectionStrategy["CheckAlways"] = 2] = "CheckAlways";
    ChangeDetectionStrategy[ChangeDetectionStrategy["Detached"] = 3] = "Detached";
    ChangeDetectionStrategy[ChangeDetectionStrategy["OnPush"] = 4] = "OnPush";
    ChangeDetectionStrategy[ChangeDetectionStrategy["Default"] = 5] = "Default";
    ChangeDetectionStrategy[ChangeDetectionStrategy["OnPushObserve"] = 6] = "OnPushObserve";
  })(exports.ChangeDetectionStrategy || (exports.ChangeDetectionStrategy = {}));
  var ChangeDetectionStrategy = exports.ChangeDetectionStrategy;
  exports.CHANGE_DETECTION_STRATEGY_VALUES = [ChangeDetectionStrategy.CheckOnce, ChangeDetectionStrategy.Checked, ChangeDetectionStrategy.CheckAlways, ChangeDetectionStrategy.Detached, ChangeDetectionStrategy.OnPush, ChangeDetectionStrategy.Default, ChangeDetectionStrategy.OnPushObserve];
  exports.CHANGE_DETECTOR_STATE_VALUES = [ChangeDetectorState.NeverChecked, ChangeDetectorState.CheckedBefore, ChangeDetectorState.Errored];
  function isDefaultChangeDetectionStrategy(changeDetectionStrategy) {
    return lang_1.isBlank(changeDetectionStrategy) || changeDetectionStrategy === ChangeDetectionStrategy.Default;
  }
  exports.isDefaultChangeDetectionStrategy = isDefaultChangeDetectionStrategy;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/pipe_lifecycle_reflector", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  function implementsOnDestroy(pipe) {
    return pipe.constructor.prototype.ngOnDestroy;
  }
  exports.implementsOnDestroy = implementsOnDestroy;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/binding_record", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var DIRECTIVE_LIFECYCLE = "directiveLifecycle";
  var BINDING = "native";
  var DIRECTIVE = "directive";
  var ELEMENT_PROPERTY = "elementProperty";
  var ELEMENT_ATTRIBUTE = "elementAttribute";
  var ELEMENT_CLASS = "elementClass";
  var ELEMENT_STYLE = "elementStyle";
  var TEXT_NODE = "textNode";
  var EVENT = "event";
  var HOST_EVENT = "hostEvent";
  var BindingTarget = (function() {
    function BindingTarget(mode, elementIndex, name, unit, debug) {
      this.mode = mode;
      this.elementIndex = elementIndex;
      this.name = name;
      this.unit = unit;
      this.debug = debug;
    }
    BindingTarget.prototype.isDirective = function() {
      return this.mode === DIRECTIVE;
    };
    BindingTarget.prototype.isElementProperty = function() {
      return this.mode === ELEMENT_PROPERTY;
    };
    BindingTarget.prototype.isElementAttribute = function() {
      return this.mode === ELEMENT_ATTRIBUTE;
    };
    BindingTarget.prototype.isElementClass = function() {
      return this.mode === ELEMENT_CLASS;
    };
    BindingTarget.prototype.isElementStyle = function() {
      return this.mode === ELEMENT_STYLE;
    };
    BindingTarget.prototype.isTextNode = function() {
      return this.mode === TEXT_NODE;
    };
    return BindingTarget;
  })();
  exports.BindingTarget = BindingTarget;
  var BindingRecord = (function() {
    function BindingRecord(mode, target, implicitReceiver, ast, setter, lifecycleEvent, directiveRecord) {
      this.mode = mode;
      this.target = target;
      this.implicitReceiver = implicitReceiver;
      this.ast = ast;
      this.setter = setter;
      this.lifecycleEvent = lifecycleEvent;
      this.directiveRecord = directiveRecord;
    }
    BindingRecord.prototype.isDirectiveLifecycle = function() {
      return this.mode === DIRECTIVE_LIFECYCLE;
    };
    BindingRecord.prototype.callOnChanges = function() {
      return lang_1.isPresent(this.directiveRecord) && this.directiveRecord.callOnChanges;
    };
    BindingRecord.prototype.isDefaultChangeDetection = function() {
      return lang_1.isBlank(this.directiveRecord) || this.directiveRecord.isDefaultChangeDetection();
    };
    BindingRecord.createDirectiveDoCheck = function(directiveRecord) {
      return new BindingRecord(DIRECTIVE_LIFECYCLE, null, 0, null, null, "DoCheck", directiveRecord);
    };
    BindingRecord.createDirectiveOnInit = function(directiveRecord) {
      return new BindingRecord(DIRECTIVE_LIFECYCLE, null, 0, null, null, "OnInit", directiveRecord);
    };
    BindingRecord.createDirectiveOnChanges = function(directiveRecord) {
      return new BindingRecord(DIRECTIVE_LIFECYCLE, null, 0, null, null, "OnChanges", directiveRecord);
    };
    BindingRecord.createForDirective = function(ast, propertyName, setter, directiveRecord) {
      var elementIndex = directiveRecord.directiveIndex.elementIndex;
      var t = new BindingTarget(DIRECTIVE, elementIndex, propertyName, null, ast.toString());
      return new BindingRecord(DIRECTIVE, t, 0, ast, setter, null, directiveRecord);
    };
    BindingRecord.createForElementProperty = function(ast, elementIndex, propertyName) {
      var t = new BindingTarget(ELEMENT_PROPERTY, elementIndex, propertyName, null, ast.toString());
      return new BindingRecord(BINDING, t, 0, ast, null, null, null);
    };
    BindingRecord.createForElementAttribute = function(ast, elementIndex, attributeName) {
      var t = new BindingTarget(ELEMENT_ATTRIBUTE, elementIndex, attributeName, null, ast.toString());
      return new BindingRecord(BINDING, t, 0, ast, null, null, null);
    };
    BindingRecord.createForElementClass = function(ast, elementIndex, className) {
      var t = new BindingTarget(ELEMENT_CLASS, elementIndex, className, null, ast.toString());
      return new BindingRecord(BINDING, t, 0, ast, null, null, null);
    };
    BindingRecord.createForElementStyle = function(ast, elementIndex, styleName, unit) {
      var t = new BindingTarget(ELEMENT_STYLE, elementIndex, styleName, unit, ast.toString());
      return new BindingRecord(BINDING, t, 0, ast, null, null, null);
    };
    BindingRecord.createForHostProperty = function(directiveIndex, ast, propertyName) {
      var t = new BindingTarget(ELEMENT_PROPERTY, directiveIndex.elementIndex, propertyName, null, ast.toString());
      return new BindingRecord(BINDING, t, directiveIndex, ast, null, null, null);
    };
    BindingRecord.createForHostAttribute = function(directiveIndex, ast, attributeName) {
      var t = new BindingTarget(ELEMENT_ATTRIBUTE, directiveIndex.elementIndex, attributeName, null, ast.toString());
      return new BindingRecord(BINDING, t, directiveIndex, ast, null, null, null);
    };
    BindingRecord.createForHostClass = function(directiveIndex, ast, className) {
      var t = new BindingTarget(ELEMENT_CLASS, directiveIndex.elementIndex, className, null, ast.toString());
      return new BindingRecord(BINDING, t, directiveIndex, ast, null, null, null);
    };
    BindingRecord.createForHostStyle = function(directiveIndex, ast, styleName, unit) {
      var t = new BindingTarget(ELEMENT_STYLE, directiveIndex.elementIndex, styleName, unit, ast.toString());
      return new BindingRecord(BINDING, t, directiveIndex, ast, null, null, null);
    };
    BindingRecord.createForTextNode = function(ast, elementIndex) {
      var t = new BindingTarget(TEXT_NODE, elementIndex, null, null, ast.toString());
      return new BindingRecord(BINDING, t, 0, ast, null, null, null);
    };
    BindingRecord.createForEvent = function(ast, eventName, elementIndex) {
      var t = new BindingTarget(EVENT, elementIndex, eventName, null, ast.toString());
      return new BindingRecord(EVENT, t, 0, ast, null, null, null);
    };
    BindingRecord.createForHostEvent = function(ast, eventName, directiveRecord) {
      var directiveIndex = directiveRecord.directiveIndex;
      var t = new BindingTarget(HOST_EVENT, directiveIndex.elementIndex, eventName, null, ast.toString());
      return new BindingRecord(HOST_EVENT, t, directiveIndex, ast, null, null, directiveRecord);
    };
    return BindingRecord;
  })();
  exports.BindingRecord = BindingRecord;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/directive_record", ["angular2/src/facade/lang", "angular2/src/core/change_detection/constants"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var constants_1 = require("angular2/src/core/change_detection/constants");
  var DirectiveIndex = (function() {
    function DirectiveIndex(elementIndex, directiveIndex) {
      this.elementIndex = elementIndex;
      this.directiveIndex = directiveIndex;
    }
    Object.defineProperty(DirectiveIndex.prototype, "name", {
      get: function() {
        return this.elementIndex + "_" + this.directiveIndex;
      },
      enumerable: true,
      configurable: true
    });
    return DirectiveIndex;
  })();
  exports.DirectiveIndex = DirectiveIndex;
  var DirectiveRecord = (function() {
    function DirectiveRecord(_a) {
      var _b = _a === void 0 ? {} : _a,
          directiveIndex = _b.directiveIndex,
          callAfterContentInit = _b.callAfterContentInit,
          callAfterContentChecked = _b.callAfterContentChecked,
          callAfterViewInit = _b.callAfterViewInit,
          callAfterViewChecked = _b.callAfterViewChecked,
          callOnChanges = _b.callOnChanges,
          callDoCheck = _b.callDoCheck,
          callOnInit = _b.callOnInit,
          callOnDestroy = _b.callOnDestroy,
          changeDetection = _b.changeDetection,
          outputs = _b.outputs;
      this.directiveIndex = directiveIndex;
      this.callAfterContentInit = lang_1.normalizeBool(callAfterContentInit);
      this.callAfterContentChecked = lang_1.normalizeBool(callAfterContentChecked);
      this.callOnChanges = lang_1.normalizeBool(callOnChanges);
      this.callAfterViewInit = lang_1.normalizeBool(callAfterViewInit);
      this.callAfterViewChecked = lang_1.normalizeBool(callAfterViewChecked);
      this.callDoCheck = lang_1.normalizeBool(callDoCheck);
      this.callOnInit = lang_1.normalizeBool(callOnInit);
      this.callOnDestroy = lang_1.normalizeBool(callOnDestroy);
      this.changeDetection = changeDetection;
      this.outputs = outputs;
    }
    DirectiveRecord.prototype.isDefaultChangeDetection = function() {
      return constants_1.isDefaultChangeDetectionStrategy(this.changeDetection);
    };
    return DirectiveRecord;
  })();
  exports.DirectiveRecord = DirectiveRecord;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/change_detector_ref", ["angular2/src/core/change_detection/constants"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var constants_1 = require("angular2/src/core/change_detection/constants");
  var ChangeDetectorRef = (function() {
    function ChangeDetectorRef() {}
    return ChangeDetectorRef;
  })();
  exports.ChangeDetectorRef = ChangeDetectorRef;
  var ChangeDetectorRef_ = (function(_super) {
    __extends(ChangeDetectorRef_, _super);
    function ChangeDetectorRef_(_cd) {
      _super.call(this);
      this._cd = _cd;
    }
    ChangeDetectorRef_.prototype.markForCheck = function() {
      this._cd.markPathToRootAsCheckOnce();
    };
    ChangeDetectorRef_.prototype.detach = function() {
      this._cd.mode = constants_1.ChangeDetectionStrategy.Detached;
    };
    ChangeDetectorRef_.prototype.detectChanges = function() {
      this._cd.detectChanges();
    };
    ChangeDetectorRef_.prototype.checkNoChanges = function() {
      this._cd.checkNoChanges();
    };
    ChangeDetectorRef_.prototype.reattach = function() {
      this._cd.mode = constants_1.ChangeDetectionStrategy.CheckAlways;
      this.markForCheck();
    };
    return ChangeDetectorRef_;
  })(ChangeDetectorRef);
  exports.ChangeDetectorRef_ = ChangeDetectorRef_;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/observable_facade", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  function isObservable(value) {
    return false;
  }
  exports.isObservable = isObservable;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/proto_record", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  (function(RecordType) {
    RecordType[RecordType["Self"] = 0] = "Self";
    RecordType[RecordType["Const"] = 1] = "Const";
    RecordType[RecordType["PrimitiveOp"] = 2] = "PrimitiveOp";
    RecordType[RecordType["PropertyRead"] = 3] = "PropertyRead";
    RecordType[RecordType["PropertyWrite"] = 4] = "PropertyWrite";
    RecordType[RecordType["Local"] = 5] = "Local";
    RecordType[RecordType["InvokeMethod"] = 6] = "InvokeMethod";
    RecordType[RecordType["InvokeClosure"] = 7] = "InvokeClosure";
    RecordType[RecordType["KeyedRead"] = 8] = "KeyedRead";
    RecordType[RecordType["KeyedWrite"] = 9] = "KeyedWrite";
    RecordType[RecordType["Pipe"] = 10] = "Pipe";
    RecordType[RecordType["Interpolate"] = 11] = "Interpolate";
    RecordType[RecordType["SafeProperty"] = 12] = "SafeProperty";
    RecordType[RecordType["CollectionLiteral"] = 13] = "CollectionLiteral";
    RecordType[RecordType["SafeMethodInvoke"] = 14] = "SafeMethodInvoke";
    RecordType[RecordType["DirectiveLifecycle"] = 15] = "DirectiveLifecycle";
    RecordType[RecordType["Chain"] = 16] = "Chain";
    RecordType[RecordType["SkipRecordsIf"] = 17] = "SkipRecordsIf";
    RecordType[RecordType["SkipRecordsIfNot"] = 18] = "SkipRecordsIfNot";
    RecordType[RecordType["SkipRecords"] = 19] = "SkipRecords";
  })(exports.RecordType || (exports.RecordType = {}));
  var RecordType = exports.RecordType;
  var ProtoRecord = (function() {
    function ProtoRecord(mode, name, funcOrValue, args, fixedArgs, contextIndex, directiveIndex, selfIndex, bindingRecord, lastInBinding, lastInDirective, argumentToPureFunction, referencedBySelf, propertyBindingIndex) {
      this.mode = mode;
      this.name = name;
      this.funcOrValue = funcOrValue;
      this.args = args;
      this.fixedArgs = fixedArgs;
      this.contextIndex = contextIndex;
      this.directiveIndex = directiveIndex;
      this.selfIndex = selfIndex;
      this.bindingRecord = bindingRecord;
      this.lastInBinding = lastInBinding;
      this.lastInDirective = lastInDirective;
      this.argumentToPureFunction = argumentToPureFunction;
      this.referencedBySelf = referencedBySelf;
      this.propertyBindingIndex = propertyBindingIndex;
    }
    ProtoRecord.prototype.isPureFunction = function() {
      return this.mode === RecordType.Interpolate || this.mode === RecordType.CollectionLiteral;
    };
    ProtoRecord.prototype.isUsedByOtherRecord = function() {
      return !this.lastInBinding || this.referencedBySelf;
    };
    ProtoRecord.prototype.shouldBeChecked = function() {
      return this.argumentToPureFunction || this.lastInBinding || this.isPureFunction() || this.isPipeRecord();
    };
    ProtoRecord.prototype.isPipeRecord = function() {
      return this.mode === RecordType.Pipe;
    };
    ProtoRecord.prototype.isConditionalSkipRecord = function() {
      return this.mode === RecordType.SkipRecordsIfNot || this.mode === RecordType.SkipRecordsIf;
    };
    ProtoRecord.prototype.isUnconditionalSkipRecord = function() {
      return this.mode === RecordType.SkipRecords;
    };
    ProtoRecord.prototype.isSkipRecord = function() {
      return this.isConditionalSkipRecord() || this.isUnconditionalSkipRecord();
    };
    ProtoRecord.prototype.isLifeCycleRecord = function() {
      return this.mode === RecordType.DirectiveLifecycle;
    };
    return ProtoRecord;
  })();
  exports.ProtoRecord = ProtoRecord;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/event_binding", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var EventBinding = (function() {
    function EventBinding(eventName, elIndex, dirIndex, records) {
      this.eventName = eventName;
      this.elIndex = elIndex;
      this.dirIndex = dirIndex;
      this.records = records;
    }
    return EventBinding;
  })();
  exports.EventBinding = EventBinding;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/coalesce", ["angular2/src/facade/lang", "angular2/src/facade/collection", "angular2/src/core/change_detection/proto_record"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var collection_1 = require("angular2/src/facade/collection");
  var proto_record_1 = require("angular2/src/core/change_detection/proto_record");
  function coalesce(srcRecords) {
    var dstRecords = [];
    var excludedIdxs = [];
    var indexMap = new collection_1.Map();
    var skipDepth = 0;
    var skipSources = collection_1.ListWrapper.createFixedSize(srcRecords.length);
    for (var protoIndex = 0; protoIndex < srcRecords.length; protoIndex++) {
      var skipRecord = skipSources[protoIndex];
      if (lang_1.isPresent(skipRecord)) {
        skipDepth--;
        skipRecord.fixedArgs[0] = dstRecords.length;
      }
      var src = srcRecords[protoIndex];
      var dst = _cloneAndUpdateIndexes(src, dstRecords, indexMap);
      if (dst.isSkipRecord()) {
        dstRecords.push(dst);
        skipDepth++;
        skipSources[dst.fixedArgs[0]] = dst;
      } else {
        var record = _mayBeAddRecord(dst, dstRecords, excludedIdxs, skipDepth > 0);
        indexMap.set(src.selfIndex, record.selfIndex);
      }
    }
    return _optimizeSkips(dstRecords);
  }
  exports.coalesce = coalesce;
  function _optimizeSkips(srcRecords) {
    var dstRecords = [];
    var skipSources = collection_1.ListWrapper.createFixedSize(srcRecords.length);
    var indexMap = new collection_1.Map();
    for (var protoIndex = 0; protoIndex < srcRecords.length; protoIndex++) {
      var skipRecord = skipSources[protoIndex];
      if (lang_1.isPresent(skipRecord)) {
        skipRecord.fixedArgs[0] = dstRecords.length;
      }
      var src = srcRecords[protoIndex];
      if (src.isSkipRecord()) {
        if (src.isConditionalSkipRecord() && src.fixedArgs[0] === protoIndex + 2 && protoIndex < srcRecords.length - 1 && srcRecords[protoIndex + 1].mode === proto_record_1.RecordType.SkipRecords) {
          src.mode = src.mode === proto_record_1.RecordType.SkipRecordsIf ? proto_record_1.RecordType.SkipRecordsIfNot : proto_record_1.RecordType.SkipRecordsIf;
          src.fixedArgs[0] = srcRecords[protoIndex + 1].fixedArgs[0];
          protoIndex++;
        }
        if (src.fixedArgs[0] > protoIndex + 1) {
          var dst = _cloneAndUpdateIndexes(src, dstRecords, indexMap);
          dstRecords.push(dst);
          skipSources[dst.fixedArgs[0]] = dst;
        }
      } else {
        var dst = _cloneAndUpdateIndexes(src, dstRecords, indexMap);
        dstRecords.push(dst);
        indexMap.set(src.selfIndex, dst.selfIndex);
      }
    }
    return dstRecords;
  }
  function _mayBeAddRecord(record, dstRecords, excludedIdxs, excluded) {
    var match = _findFirstMatch(record, dstRecords, excludedIdxs);
    if (lang_1.isPresent(match)) {
      if (record.lastInBinding) {
        dstRecords.push(_createSelfRecord(record, match.selfIndex, dstRecords.length + 1));
        match.referencedBySelf = true;
      } else {
        if (record.argumentToPureFunction) {
          match.argumentToPureFunction = true;
        }
      }
      return match;
    }
    if (excluded) {
      excludedIdxs.push(record.selfIndex);
    }
    dstRecords.push(record);
    return record;
  }
  function _findFirstMatch(record, dstRecords, excludedIdxs) {
    return dstRecords.find(function(rr) {
      return excludedIdxs.indexOf(rr.selfIndex) == -1 && rr.mode !== proto_record_1.RecordType.DirectiveLifecycle && _haveSameDirIndex(rr, record) && rr.mode === record.mode && lang_1.looseIdentical(rr.funcOrValue, record.funcOrValue) && rr.contextIndex === record.contextIndex && lang_1.looseIdentical(rr.name, record.name) && collection_1.ListWrapper.equals(rr.args, record.args);
    });
  }
  function _cloneAndUpdateIndexes(record, dstRecords, indexMap) {
    var args = record.args.map(function(src) {
      return _srcToDstSelfIndex(indexMap, src);
    });
    var contextIndex = _srcToDstSelfIndex(indexMap, record.contextIndex);
    var selfIndex = dstRecords.length + 1;
    return new proto_record_1.ProtoRecord(record.mode, record.name, record.funcOrValue, args, record.fixedArgs, contextIndex, record.directiveIndex, selfIndex, record.bindingRecord, record.lastInBinding, record.lastInDirective, record.argumentToPureFunction, record.referencedBySelf, record.propertyBindingIndex);
  }
  function _srcToDstSelfIndex(indexMap, srcIdx) {
    var dstIdx = indexMap.get(srcIdx);
    return lang_1.isPresent(dstIdx) ? dstIdx : srcIdx;
  }
  function _createSelfRecord(r, contextIndex, selfIndex) {
    return new proto_record_1.ProtoRecord(proto_record_1.RecordType.Self, "self", null, [], r.fixedArgs, contextIndex, r.directiveIndex, selfIndex, r.bindingRecord, r.lastInBinding, r.lastInDirective, false, false, r.propertyBindingIndex);
  }
  function _haveSameDirIndex(a, b) {
    var di1 = lang_1.isBlank(a.directiveIndex) ? null : a.directiveIndex.directiveIndex;
    var ei1 = lang_1.isBlank(a.directiveIndex) ? null : a.directiveIndex.elementIndex;
    var di2 = lang_1.isBlank(b.directiveIndex) ? null : b.directiveIndex.directiveIndex;
    var ei2 = lang_1.isBlank(b.directiveIndex) ? null : b.directiveIndex.elementIndex;
    return di1 === di2 && ei1 === ei2;
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/codegen_name_util", ["angular2/src/facade/lang", "angular2/src/facade/collection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var collection_1 = require("angular2/src/facade/collection");
  var _STATE_ACCESSOR = "state";
  var _CONTEXT_ACCESSOR = "context";
  var _PROP_BINDING_INDEX = "propertyBindingIndex";
  var _DIRECTIVES_ACCESSOR = "directiveIndices";
  var _DISPATCHER_ACCESSOR = "dispatcher";
  var _LOCALS_ACCESSOR = "locals";
  var _MODE_ACCESSOR = "mode";
  var _PIPES_ACCESSOR = "pipes";
  var _PROTOS_ACCESSOR = "protos";
  exports.CONTEXT_ACCESSOR = "context";
  exports.CONTEXT_INDEX = 0;
  var _FIELD_PREFIX = 'this.';
  var _whiteSpaceRegExp = /\W/g;
  function sanitizeName(s) {
    return lang_1.StringWrapper.replaceAll(s, _whiteSpaceRegExp, '');
  }
  exports.sanitizeName = sanitizeName;
  var CodegenNameUtil = (function() {
    function CodegenNameUtil(_records, _eventBindings, _directiveRecords, _utilName) {
      this._records = _records;
      this._eventBindings = _eventBindings;
      this._directiveRecords = _directiveRecords;
      this._utilName = _utilName;
      this._sanitizedEventNames = new collection_1.Map();
      this._sanitizedNames = collection_1.ListWrapper.createFixedSize(this._records.length + 1);
      this._sanitizedNames[exports.CONTEXT_INDEX] = exports.CONTEXT_ACCESSOR;
      for (var i = 0,
          iLen = this._records.length; i < iLen; ++i) {
        this._sanitizedNames[i + 1] = sanitizeName("" + this._records[i].name + i);
      }
      for (var ebIndex = 0; ebIndex < _eventBindings.length; ++ebIndex) {
        var eb = _eventBindings[ebIndex];
        var names = [exports.CONTEXT_ACCESSOR];
        for (var i = 0,
            iLen = eb.records.length; i < iLen; ++i) {
          names.push(sanitizeName("" + eb.records[i].name + i + "_" + ebIndex));
        }
        this._sanitizedEventNames.set(eb, names);
      }
    }
    CodegenNameUtil.prototype._addFieldPrefix = function(name) {
      return "" + _FIELD_PREFIX + name;
    };
    CodegenNameUtil.prototype.getDispatcherName = function() {
      return this._addFieldPrefix(_DISPATCHER_ACCESSOR);
    };
    CodegenNameUtil.prototype.getPipesAccessorName = function() {
      return this._addFieldPrefix(_PIPES_ACCESSOR);
    };
    CodegenNameUtil.prototype.getProtosName = function() {
      return this._addFieldPrefix(_PROTOS_ACCESSOR);
    };
    CodegenNameUtil.prototype.getDirectivesAccessorName = function() {
      return this._addFieldPrefix(_DIRECTIVES_ACCESSOR);
    };
    CodegenNameUtil.prototype.getLocalsAccessorName = function() {
      return this._addFieldPrefix(_LOCALS_ACCESSOR);
    };
    CodegenNameUtil.prototype.getStateName = function() {
      return this._addFieldPrefix(_STATE_ACCESSOR);
    };
    CodegenNameUtil.prototype.getModeName = function() {
      return this._addFieldPrefix(_MODE_ACCESSOR);
    };
    CodegenNameUtil.prototype.getPropertyBindingIndex = function() {
      return this._addFieldPrefix(_PROP_BINDING_INDEX);
    };
    CodegenNameUtil.prototype.getLocalName = function(idx) {
      return "l_" + this._sanitizedNames[idx];
    };
    CodegenNameUtil.prototype.getEventLocalName = function(eb, idx) {
      return "l_" + this._sanitizedEventNames.get(eb)[idx];
    };
    CodegenNameUtil.prototype.getChangeName = function(idx) {
      return "c_" + this._sanitizedNames[idx];
    };
    CodegenNameUtil.prototype.genInitLocals = function() {
      var declarations = [];
      var assignments = [];
      for (var i = 0,
          iLen = this.getFieldCount(); i < iLen; ++i) {
        if (i == exports.CONTEXT_INDEX) {
          declarations.push(this.getLocalName(i) + " = " + this.getFieldName(i));
        } else {
          var rec = this._records[i - 1];
          if (rec.argumentToPureFunction) {
            var changeName = this.getChangeName(i);
            declarations.push(this.getLocalName(i) + "," + changeName);
            assignments.push(changeName);
          } else {
            declarations.push("" + this.getLocalName(i));
          }
        }
      }
      var assignmentsCode = collection_1.ListWrapper.isEmpty(assignments) ? '' : assignments.join('=') + " = false;";
      return "var " + declarations.join(',') + ";" + assignmentsCode;
    };
    CodegenNameUtil.prototype.genInitEventLocals = function() {
      var _this = this;
      var res = [(this.getLocalName(exports.CONTEXT_INDEX) + " = " + this.getFieldName(exports.CONTEXT_INDEX))];
      this._sanitizedEventNames.forEach(function(names, eb) {
        for (var i = 0; i < names.length; ++i) {
          if (i !== exports.CONTEXT_INDEX) {
            res.push("" + _this.getEventLocalName(eb, i));
          }
        }
      });
      return res.length > 1 ? "var " + res.join(',') + ";" : '';
    };
    CodegenNameUtil.prototype.getPreventDefaultAccesor = function() {
      return "preventDefault";
    };
    CodegenNameUtil.prototype.getFieldCount = function() {
      return this._sanitizedNames.length;
    };
    CodegenNameUtil.prototype.getFieldName = function(idx) {
      return this._addFieldPrefix(this._sanitizedNames[idx]);
    };
    CodegenNameUtil.prototype.getAllFieldNames = function() {
      var fieldList = [];
      for (var k = 0,
          kLen = this.getFieldCount(); k < kLen; ++k) {
        if (k === 0 || this._records[k - 1].shouldBeChecked()) {
          fieldList.push(this.getFieldName(k));
        }
      }
      for (var i = 0,
          iLen = this._records.length; i < iLen; ++i) {
        var rec = this._records[i];
        if (rec.isPipeRecord()) {
          fieldList.push(this.getPipeName(rec.selfIndex));
        }
      }
      for (var j = 0,
          jLen = this._directiveRecords.length; j < jLen; ++j) {
        var dRec = this._directiveRecords[j];
        fieldList.push(this.getDirectiveName(dRec.directiveIndex));
        if (!dRec.isDefaultChangeDetection()) {
          fieldList.push(this.getDetectorName(dRec.directiveIndex));
        }
      }
      return fieldList;
    };
    CodegenNameUtil.prototype.genDehydrateFields = function() {
      var fields = this.getAllFieldNames();
      collection_1.ListWrapper.removeAt(fields, exports.CONTEXT_INDEX);
      if (collection_1.ListWrapper.isEmpty(fields))
        return '';
      fields.push(this._utilName + ".uninitialized;");
      return fields.join(' = ');
    };
    CodegenNameUtil.prototype.genPipeOnDestroy = function() {
      var _this = this;
      return this._records.filter(function(r) {
        return r.isPipeRecord();
      }).map(function(r) {
        return (_this._utilName + ".callPipeOnDestroy(" + _this.getPipeName(r.selfIndex) + ");");
      }).join('\n');
    };
    CodegenNameUtil.prototype.getPipeName = function(idx) {
      return this._addFieldPrefix(this._sanitizedNames[idx] + "_pipe");
    };
    CodegenNameUtil.prototype.getDirectiveName = function(d) {
      return this._addFieldPrefix("directive_" + d.name);
    };
    CodegenNameUtil.prototype.getDetectorName = function(d) {
      return this._addFieldPrefix("detector_" + d.name);
    };
    return CodegenNameUtil;
  })();
  exports.CodegenNameUtil = CodegenNameUtil;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/codegen_facade", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  function codify(obj) {
    return JSON.stringify(obj);
  }
  exports.codify = codify;
  function rawString(str) {
    return "'" + str + "'";
  }
  exports.rawString = rawString;
  function combineGeneratedStrings(vals) {
    return vals.join(' + ');
  }
  exports.combineGeneratedStrings = combineGeneratedStrings;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/metadata/view", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  (function(ViewEncapsulation) {
    ViewEncapsulation[ViewEncapsulation["Emulated"] = 0] = "Emulated";
    ViewEncapsulation[ViewEncapsulation["Native"] = 1] = "Native";
    ViewEncapsulation[ViewEncapsulation["None"] = 2] = "None";
  })(exports.ViewEncapsulation || (exports.ViewEncapsulation = {}));
  var ViewEncapsulation = exports.ViewEncapsulation;
  exports.VIEW_ENCAPSULATION_VALUES = [ViewEncapsulation.Emulated, ViewEncapsulation.Native, ViewEncapsulation.None];
  var ViewMetadata = (function() {
    function ViewMetadata(_a) {
      var _b = _a === void 0 ? {} : _a,
          templateUrl = _b.templateUrl,
          template = _b.template,
          directives = _b.directives,
          pipes = _b.pipes,
          encapsulation = _b.encapsulation,
          styles = _b.styles,
          styleUrls = _b.styleUrls;
      this.templateUrl = templateUrl;
      this.template = template;
      this.styleUrls = styleUrls;
      this.styles = styles;
      this.directives = directives;
      this.pipes = pipes;
      this.encapsulation = encapsulation;
    }
    ViewMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [Object])], ViewMetadata);
    return ViewMetadata;
  })();
  exports.ViewMetadata = ViewMetadata;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/util", ["angular2/src/core/util/decorators"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var decorators_1 = require("angular2/src/core/util/decorators");
  exports.Class = decorators_1.Class;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/prod_mode", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  exports.enableProdMode = lang_1.enableProdMode;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/facade/facade", ["angular2/src/facade/lang", "angular2/src/facade/async", "angular2/src/facade/exceptions", "angular2/src/facade/exception_handler"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  exports.Type = lang_1.Type;
  var async_1 = require("angular2/src/facade/async");
  exports.EventEmitter = async_1.EventEmitter;
  var exceptions_1 = require("angular2/src/facade/exceptions");
  exports.WrappedException = exceptions_1.WrappedException;
  var exception_handler_1 = require("angular2/src/facade/exception_handler");
  exports.ExceptionHandler = exception_handler_1.ExceptionHandler;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/application_tokens", ["angular2/src/core/di", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var di_1 = require("angular2/src/core/di");
  var lang_1 = require("angular2/src/facade/lang");
  exports.APP_COMPONENT_REF_PROMISE = lang_1.CONST_EXPR(new di_1.OpaqueToken('Promise<ComponentRef>'));
  exports.APP_COMPONENT = lang_1.CONST_EXPR(new di_1.OpaqueToken('AppComponent'));
  exports.APP_ID = lang_1.CONST_EXPR(new di_1.OpaqueToken('AppId'));
  function _appIdRandomProviderFactory() {
    return "" + _randomChar() + _randomChar() + _randomChar();
  }
  exports.APP_ID_RANDOM_PROVIDER = lang_1.CONST_EXPR(new di_1.Provider(exports.APP_ID, {
    useFactory: _appIdRandomProviderFactory,
    deps: []
  }));
  function _randomChar() {
    return lang_1.StringWrapper.fromCharCode(97 + lang_1.Math.floor(lang_1.Math.random() * 25));
  }
  exports.PLATFORM_INITIALIZER = lang_1.CONST_EXPR(new di_1.OpaqueToken("Platform Initializer"));
  exports.APP_INITIALIZER = lang_1.CONST_EXPR(new di_1.OpaqueToken("Application Initializer"));
  exports.PACKAGE_ROOT_URL = lang_1.CONST_EXPR(new di_1.OpaqueToken("Application Packages Root URL"));
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/testability/testability", ["angular2/src/core/di", "angular2/src/facade/collection", "angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/core/zone/ng_zone", "angular2/src/facade/async"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var di_1 = require("angular2/src/core/di");
  var collection_1 = require("angular2/src/facade/collection");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var ng_zone_1 = require("angular2/src/core/zone/ng_zone");
  var async_1 = require("angular2/src/facade/async");
  var Testability = (function() {
    function Testability(_ngZone) {
      this._pendingCount = 0;
      this._didWork = false;
      this._callbacks = [];
      this._isAngularEventPending = false;
      this._watchAngularEvents(_ngZone);
    }
    Testability.prototype._watchAngularEvents = function(_ngZone) {
      var _this = this;
      async_1.ObservableWrapper.subscribe(_ngZone.onTurnStart, function(_) {
        _this._didWork = true;
        _this._isAngularEventPending = true;
      });
      _ngZone.runOutsideAngular(function() {
        async_1.ObservableWrapper.subscribe(_ngZone.onEventDone, function(_) {
          if (!_ngZone.hasPendingTimers) {
            _this._isAngularEventPending = false;
            _this._runCallbacksIfReady();
          }
        });
      });
    };
    Testability.prototype.increasePendingRequestCount = function() {
      this._pendingCount += 1;
      this._didWork = true;
      return this._pendingCount;
    };
    Testability.prototype.decreasePendingRequestCount = function() {
      this._pendingCount -= 1;
      if (this._pendingCount < 0) {
        throw new exceptions_1.BaseException('pending async requests below zero');
      }
      this._runCallbacksIfReady();
      return this._pendingCount;
    };
    Testability.prototype.isStable = function() {
      return this._pendingCount == 0 && !this._isAngularEventPending;
    };
    Testability.prototype._runCallbacksIfReady = function() {
      var _this = this;
      if (!this.isStable()) {
        this._didWork = true;
        return ;
      }
      async_1.PromiseWrapper.resolve(null).then(function(_) {
        while (_this._callbacks.length !== 0) {
          (_this._callbacks.pop())(_this._didWork);
        }
        _this._didWork = false;
      });
    };
    Testability.prototype.whenStable = function(callback) {
      this._callbacks.push(callback);
      this._runCallbacksIfReady();
    };
    Testability.prototype.getPendingRequestCount = function() {
      return this._pendingCount;
    };
    Testability.prototype.isAngularEventPending = function() {
      return this._isAngularEventPending;
    };
    Testability.prototype.findBindings = function(using, provider, exactMatch) {
      return [];
    };
    Testability.prototype.findProviders = function(using, provider, exactMatch) {
      return [];
    };
    Testability = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [ng_zone_1.NgZone])], Testability);
    return Testability;
  })();
  exports.Testability = Testability;
  var TestabilityRegistry = (function() {
    function TestabilityRegistry() {
      this._applications = new collection_1.Map();
      _testabilityGetter.addToWindow(this);
    }
    TestabilityRegistry.prototype.registerApplication = function(token, testability) {
      this._applications.set(token, testability);
    };
    TestabilityRegistry.prototype.getTestability = function(elem) {
      return this._applications.get(elem);
    };
    TestabilityRegistry.prototype.getAllTestabilities = function() {
      return collection_1.MapWrapper.values(this._applications);
    };
    TestabilityRegistry.prototype.findTestabilityInTree = function(elem, findInAncestors) {
      if (findInAncestors === void 0) {
        findInAncestors = true;
      }
      return _testabilityGetter.findTestabilityInTree(this, elem, findInAncestors);
    };
    TestabilityRegistry = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [])], TestabilityRegistry);
    return TestabilityRegistry;
  })();
  exports.TestabilityRegistry = TestabilityRegistry;
  var _NoopGetTestability = (function() {
    function _NoopGetTestability() {}
    _NoopGetTestability.prototype.addToWindow = function(registry) {};
    _NoopGetTestability.prototype.findTestabilityInTree = function(registry, elem, findInAncestors) {
      return null;
    };
    _NoopGetTestability = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [])], _NoopGetTestability);
    return _NoopGetTestability;
  })();
  function setTestabilityGetter(getter) {
    _testabilityGetter = getter;
  }
  exports.setTestabilityGetter = setTestabilityGetter;
  var _testabilityGetter = lang_1.CONST_EXPR(new _NoopGetTestability());
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/view_type", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  (function(ViewType) {
    ViewType[ViewType["HOST"] = 0] = "HOST";
    ViewType[ViewType["COMPONENT"] = 1] = "COMPONENT";
    ViewType[ViewType["EMBEDDED"] = 2] = "EMBEDDED";
  })(exports.ViewType || (exports.ViewType = {}));
  var ViewType = exports.ViewType;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/element_ref", ["angular2/src/facade/exceptions"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var ElementRef = (function() {
    function ElementRef() {}
    Object.defineProperty(ElementRef.prototype, "nativeElement", {
      get: function() {
        return exceptions_1.unimplemented();
      },
      enumerable: true,
      configurable: true
    });
    return ElementRef;
  })();
  exports.ElementRef = ElementRef;
  var ElementRef_ = (function() {
    function ElementRef_(_appElement) {
      this._appElement = _appElement;
    }
    Object.defineProperty(ElementRef_.prototype, "internalElement", {
      get: function() {
        return this._appElement;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(ElementRef_.prototype, "nativeElement", {
      get: function() {
        return this._appElement.nativeElement;
      },
      enumerable: true,
      configurable: true
    });
    return ElementRef_;
  })();
  exports.ElementRef_ = ElementRef_;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/view_container_ref", ["angular2/src/facade/collection", "angular2/src/facade/exceptions", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var collection_1 = require("angular2/src/facade/collection");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var lang_1 = require("angular2/src/facade/lang");
  var ViewContainerRef = (function() {
    function ViewContainerRef() {}
    Object.defineProperty(ViewContainerRef.prototype, "element", {
      get: function() {
        return exceptions_1.unimplemented();
      },
      enumerable: true,
      configurable: true
    });
    ViewContainerRef.prototype.clear = function() {
      for (var i = this.length - 1; i >= 0; i--) {
        this.remove(i);
      }
    };
    Object.defineProperty(ViewContainerRef.prototype, "length", {
      get: function() {
        return exceptions_1.unimplemented();
      },
      enumerable: true,
      configurable: true
    });
    ;
    return ViewContainerRef;
  })();
  exports.ViewContainerRef = ViewContainerRef;
  var ViewContainerRef_ = (function(_super) {
    __extends(ViewContainerRef_, _super);
    function ViewContainerRef_(_element) {
      _super.call(this);
      this._element = _element;
    }
    ViewContainerRef_.prototype.get = function(index) {
      return this._element.nestedViews[index].ref;
    };
    Object.defineProperty(ViewContainerRef_.prototype, "length", {
      get: function() {
        var views = this._element.nestedViews;
        return lang_1.isPresent(views) ? views.length : 0;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(ViewContainerRef_.prototype, "element", {
      get: function() {
        return this._element.ref;
      },
      enumerable: true,
      configurable: true
    });
    ViewContainerRef_.prototype.createEmbeddedView = function(templateRef, index) {
      if (index === void 0) {
        index = -1;
      }
      if (index == -1)
        index = this.length;
      var vm = this._element.parentView.viewManager;
      return vm.createEmbeddedViewInContainer(this._element.ref, index, templateRef);
    };
    ViewContainerRef_.prototype.createHostView = function(hostViewFactoryRef, index, dynamicallyCreatedProviders, projectableNodes) {
      if (index === void 0) {
        index = -1;
      }
      if (dynamicallyCreatedProviders === void 0) {
        dynamicallyCreatedProviders = null;
      }
      if (projectableNodes === void 0) {
        projectableNodes = null;
      }
      if (index == -1)
        index = this.length;
      var vm = this._element.parentView.viewManager;
      return vm.createHostViewInContainer(this._element.ref, index, hostViewFactoryRef, dynamicallyCreatedProviders, projectableNodes);
    };
    ViewContainerRef_.prototype.insert = function(viewRef, index) {
      if (index === void 0) {
        index = -1;
      }
      if (index == -1)
        index = this.length;
      var vm = this._element.parentView.viewManager;
      return vm.attachViewInContainer(this._element.ref, index, viewRef);
    };
    ViewContainerRef_.prototype.indexOf = function(viewRef) {
      return collection_1.ListWrapper.indexOf(this._element.nestedViews, viewRef.internalView);
    };
    ViewContainerRef_.prototype.remove = function(index) {
      if (index === void 0) {
        index = -1;
      }
      if (index == -1)
        index = this.length - 1;
      var vm = this._element.parentView.viewManager;
      return vm.destroyViewInContainer(this._element.ref, index);
    };
    ViewContainerRef_.prototype.detach = function(index) {
      if (index === void 0) {
        index = -1;
      }
      if (index == -1)
        index = this.length - 1;
      var vm = this._element.parentView.viewManager;
      return vm.detachViewInContainer(this._element.ref, index);
    };
    return ViewContainerRef_;
  })(ViewContainerRef);
  exports.ViewContainerRef_ = ViewContainerRef_;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/render/api", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var RenderComponentType = (function() {
    function RenderComponentType(id, encapsulation, styles) {
      this.id = id;
      this.encapsulation = encapsulation;
      this.styles = styles;
    }
    return RenderComponentType;
  })();
  exports.RenderComponentType = RenderComponentType;
  var RenderDebugInfo = (function() {
    function RenderDebugInfo(injector, component, providerTokens, locals) {
      this.injector = injector;
      this.component = component;
      this.providerTokens = providerTokens;
      this.locals = locals;
    }
    return RenderDebugInfo;
  })();
  exports.RenderDebugInfo = RenderDebugInfo;
  var Renderer = (function() {
    function Renderer() {}
    return Renderer;
  })();
  exports.Renderer = Renderer;
  var RootRenderer = (function() {
    function RootRenderer() {}
    return RootRenderer;
  })();
  exports.RootRenderer = RootRenderer;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/template_ref", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var TemplateRef = (function() {
    function TemplateRef() {}
    Object.defineProperty(TemplateRef.prototype, "elementRef", {
      get: function() {
        return null;
      },
      enumerable: true,
      configurable: true
    });
    return TemplateRef;
  })();
  exports.TemplateRef = TemplateRef;
  var TemplateRef_ = (function(_super) {
    __extends(TemplateRef_, _super);
    function TemplateRef_(_elementRef) {
      _super.call(this);
      this._elementRef = _elementRef;
    }
    Object.defineProperty(TemplateRef_.prototype, "elementRef", {
      get: function() {
        return this._elementRef;
      },
      enumerable: true,
      configurable: true
    });
    return TemplateRef_;
  })(TemplateRef);
  exports.TemplateRef_ = TemplateRef_;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/query_list", ["angular2/src/facade/collection", "angular2/src/facade/lang", "angular2/src/facade/async"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var collection_1 = require("angular2/src/facade/collection");
  var lang_1 = require("angular2/src/facade/lang");
  var async_1 = require("angular2/src/facade/async");
  var QueryList = (function() {
    function QueryList() {
      this._results = [];
      this._emitter = new async_1.EventEmitter();
    }
    Object.defineProperty(QueryList.prototype, "changes", {
      get: function() {
        return this._emitter;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(QueryList.prototype, "length", {
      get: function() {
        return this._results.length;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(QueryList.prototype, "first", {
      get: function() {
        return collection_1.ListWrapper.first(this._results);
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(QueryList.prototype, "last", {
      get: function() {
        return collection_1.ListWrapper.last(this._results);
      },
      enumerable: true,
      configurable: true
    });
    QueryList.prototype.map = function(fn) {
      return this._results.map(fn);
    };
    QueryList.prototype.filter = function(fn) {
      return this._results.filter(fn);
    };
    QueryList.prototype.reduce = function(fn, init) {
      return this._results.reduce(fn, init);
    };
    QueryList.prototype.toArray = function() {
      return collection_1.ListWrapper.clone(this._results);
    };
    QueryList.prototype[lang_1.getSymbolIterator()] = function() {
      return this._results[lang_1.getSymbolIterator()]();
    };
    QueryList.prototype.toString = function() {
      return this._results.toString();
    };
    QueryList.prototype.reset = function(res) {
      this._results = res;
    };
    QueryList.prototype.notifyOnChanges = function() {
      this._emitter.emit(this);
    };
    return QueryList;
  })();
  exports.QueryList = QueryList;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/pipes/pipe_provider", ["angular2/src/core/di/provider", "angular2/src/core/di"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var provider_1 = require("angular2/src/core/di/provider");
  var di_1 = require("angular2/src/core/di");
  var PipeProvider = (function(_super) {
    __extends(PipeProvider, _super);
    function PipeProvider(name, pure, key, resolvedFactories, multiBinding) {
      _super.call(this, key, resolvedFactories, multiBinding);
      this.name = name;
      this.pure = pure;
    }
    PipeProvider.createFromType = function(type, metadata) {
      var provider = new di_1.Provider(type, {useClass: type});
      var rb = provider_1.resolveProvider(provider);
      return new PipeProvider(metadata.name, metadata.pure, rb.key, rb.resolvedFactories, rb.multiProvider);
    };
    return PipeProvider;
  })(provider_1.ResolvedProvider_);
  exports.PipeProvider = PipeProvider;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/view_ref", ["angular2/src/facade/exceptions"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var ViewRef = (function() {
    function ViewRef() {}
    Object.defineProperty(ViewRef.prototype, "changeDetectorRef", {
      get: function() {
        return exceptions_1.unimplemented();
      },
      enumerable: true,
      configurable: true
    });
    ;
    Object.defineProperty(ViewRef.prototype, "destroyed", {
      get: function() {
        return exceptions_1.unimplemented();
      },
      enumerable: true,
      configurable: true
    });
    return ViewRef;
  })();
  exports.ViewRef = ViewRef;
  var HostViewRef = (function(_super) {
    __extends(HostViewRef, _super);
    function HostViewRef() {
      _super.apply(this, arguments);
    }
    Object.defineProperty(HostViewRef.prototype, "rootNodes", {
      get: function() {
        return exceptions_1.unimplemented();
      },
      enumerable: true,
      configurable: true
    });
    ;
    return HostViewRef;
  })(ViewRef);
  exports.HostViewRef = HostViewRef;
  var EmbeddedViewRef = (function(_super) {
    __extends(EmbeddedViewRef, _super);
    function EmbeddedViewRef() {
      _super.apply(this, arguments);
    }
    Object.defineProperty(EmbeddedViewRef.prototype, "rootNodes", {
      get: function() {
        return exceptions_1.unimplemented();
      },
      enumerable: true,
      configurable: true
    });
    ;
    return EmbeddedViewRef;
  })(ViewRef);
  exports.EmbeddedViewRef = EmbeddedViewRef;
  var ViewRef_ = (function() {
    function ViewRef_(_view) {
      this._view = _view;
      this._view = _view;
    }
    Object.defineProperty(ViewRef_.prototype, "internalView", {
      get: function() {
        return this._view;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(ViewRef_.prototype, "changeDetectorRef", {
      get: function() {
        return this._view.changeDetector.ref;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(ViewRef_.prototype, "rootNodes", {
      get: function() {
        return this._view.flatRootNodes;
      },
      enumerable: true,
      configurable: true
    });
    ViewRef_.prototype.setLocal = function(variableName, value) {
      this._view.setLocal(variableName, value);
    };
    ViewRef_.prototype.hasLocal = function(variableName) {
      return this._view.hasLocal(variableName);
    };
    Object.defineProperty(ViewRef_.prototype, "destroyed", {
      get: function() {
        return this._view.destroyed;
      },
      enumerable: true,
      configurable: true
    });
    return ViewRef_;
  })();
  exports.ViewRef_ = ViewRef_;
  var HostViewFactoryRef = (function() {
    function HostViewFactoryRef() {}
    return HostViewFactoryRef;
  })();
  exports.HostViewFactoryRef = HostViewFactoryRef;
  var HostViewFactoryRef_ = (function() {
    function HostViewFactoryRef_(_hostViewFactory) {
      this._hostViewFactory = _hostViewFactory;
    }
    Object.defineProperty(HostViewFactoryRef_.prototype, "internalHostViewFactory", {
      get: function() {
        return this._hostViewFactory;
      },
      enumerable: true,
      configurable: true
    });
    return HostViewFactoryRef_;
  })();
  exports.HostViewFactoryRef_ = HostViewFactoryRef_;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/pipes", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var SelectedPipe = (function() {
    function SelectedPipe(pipe, pure) {
      this.pipe = pipe;
      this.pure = pure;
    }
    return SelectedPipe;
  })();
  exports.SelectedPipe = SelectedPipe;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/render/util", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var CAMEL_CASE_REGEXP = /([A-Z])/g;
  var DASH_CASE_REGEXP = /-([a-z])/g;
  function camelCaseToDashCase(input) {
    return lang_1.StringWrapper.replaceAllMapped(input, CAMEL_CASE_REGEXP, function(m) {
      return '-' + m[1].toLowerCase();
    });
  }
  exports.camelCaseToDashCase = camelCaseToDashCase;
  function dashCaseToCamelCase(input) {
    return lang_1.StringWrapper.replaceAllMapped(input, DASH_CASE_REGEXP, function(m) {
      return m[1].toUpperCase();
    });
  }
  exports.dashCaseToCamelCase = dashCaseToCamelCase;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/view_manager", ["angular2/src/core/di", "angular2/src/facade/lang", "angular2/src/facade/collection", "angular2/src/facade/exceptions", "angular2/src/core/linker/view", "angular2/src/core/linker/element", "angular2/src/core/render/api", "angular2/src/core/profile/profile", "angular2/src/core/application_tokens", "angular2/src/core/linker/view_type"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var di_1 = require("angular2/src/core/di");
  var lang_1 = require("angular2/src/facade/lang");
  var collection_1 = require("angular2/src/facade/collection");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var view_1 = require("angular2/src/core/linker/view");
  var element_1 = require("angular2/src/core/linker/element");
  var api_1 = require("angular2/src/core/render/api");
  var profile_1 = require("angular2/src/core/profile/profile");
  var application_tokens_1 = require("angular2/src/core/application_tokens");
  var view_type_1 = require("angular2/src/core/linker/view_type");
  var AppViewManager = (function() {
    function AppViewManager() {}
    return AppViewManager;
  })();
  exports.AppViewManager = AppViewManager;
  var AppViewManager_ = (function(_super) {
    __extends(AppViewManager_, _super);
    function AppViewManager_(_renderer, _appId) {
      _super.call(this);
      this._renderer = _renderer;
      this._appId = _appId;
      this._nextCompTypeId = 0;
      this._createRootHostViewScope = profile_1.wtfCreateScope('AppViewManager#createRootHostView()');
      this._destroyRootHostViewScope = profile_1.wtfCreateScope('AppViewManager#destroyRootHostView()');
      this._createEmbeddedViewInContainerScope = profile_1.wtfCreateScope('AppViewManager#createEmbeddedViewInContainer()');
      this._createHostViewInContainerScope = profile_1.wtfCreateScope('AppViewManager#createHostViewInContainer()');
      this._destroyViewInContainerScope = profile_1.wtfCreateScope('AppViewMananger#destroyViewInContainer()');
      this._attachViewInContainerScope = profile_1.wtfCreateScope('AppViewMananger#attachViewInContainer()');
      this._detachViewInContainerScope = profile_1.wtfCreateScope('AppViewMananger#detachViewInContainer()');
    }
    AppViewManager_.prototype.getViewContainer = function(location) {
      return location.internalElement.getViewContainerRef();
    };
    AppViewManager_.prototype.getHostElement = function(hostViewRef) {
      var hostView = hostViewRef.internalView;
      if (hostView.proto.type !== view_type_1.ViewType.HOST) {
        throw new exceptions_1.BaseException('This operation is only allowed on host views');
      }
      return hostView.appElements[0].ref;
    };
    AppViewManager_.prototype.getNamedElementInComponentView = function(hostLocation, variableName) {
      var appEl = hostLocation.internalElement;
      var componentView = appEl.componentView;
      if (lang_1.isBlank(componentView)) {
        throw new exceptions_1.BaseException("There is no component directive at element " + hostLocation);
      }
      for (var i = 0; i < componentView.appElements.length; i++) {
        var compAppEl = componentView.appElements[i];
        if (collection_1.StringMapWrapper.contains(compAppEl.proto.directiveVariableBindings, variableName)) {
          return compAppEl.ref;
        }
      }
      throw new exceptions_1.BaseException("Could not find variable " + variableName);
    };
    AppViewManager_.prototype.getComponent = function(hostLocation) {
      return hostLocation.internalElement.getComponent();
    };
    AppViewManager_.prototype.createRootHostView = function(hostViewFactoryRef, overrideSelector, injector, projectableNodes) {
      if (projectableNodes === void 0) {
        projectableNodes = null;
      }
      var s = this._createRootHostViewScope();
      var hostViewFactory = hostViewFactoryRef.internalHostViewFactory;
      var selector = lang_1.isPresent(overrideSelector) ? overrideSelector : hostViewFactory.selector;
      var view = hostViewFactory.viewFactory(this._renderer, this, null, projectableNodes, selector, null, injector);
      return profile_1.wtfLeave(s, view.ref);
    };
    AppViewManager_.prototype.destroyRootHostView = function(hostViewRef) {
      var s = this._destroyRootHostViewScope();
      var hostView = hostViewRef.internalView;
      hostView.renderer.detachView(view_1.flattenNestedViewRenderNodes(hostView.rootNodesOrAppElements));
      hostView.destroy();
      profile_1.wtfLeave(s);
    };
    AppViewManager_.prototype.createEmbeddedViewInContainer = function(viewContainerLocation, index, templateRef) {
      var s = this._createEmbeddedViewInContainerScope();
      var contextEl = templateRef.elementRef.internalElement;
      var view = contextEl.embeddedViewFactory(contextEl.parentView.renderer, this, contextEl, contextEl.parentView.projectableNodes, null, null, null);
      this._attachViewToContainer(view, viewContainerLocation.internalElement, index);
      return profile_1.wtfLeave(s, view.ref);
    };
    AppViewManager_.prototype.createHostViewInContainer = function(viewContainerLocation, index, hostViewFactoryRef, dynamicallyCreatedProviders, projectableNodes) {
      var s = this._createHostViewInContainerScope();
      var viewContainerLocation_ = viewContainerLocation;
      var contextEl = viewContainerLocation_.internalElement;
      var hostViewFactory = hostViewFactoryRef.internalHostViewFactory;
      var view = hostViewFactory.viewFactory(contextEl.parentView.renderer, contextEl.parentView.viewManager, contextEl, projectableNodes, null, dynamicallyCreatedProviders, null);
      this._attachViewToContainer(view, viewContainerLocation_.internalElement, index);
      return profile_1.wtfLeave(s, view.ref);
    };
    AppViewManager_.prototype.destroyViewInContainer = function(viewContainerLocation, index) {
      var s = this._destroyViewInContainerScope();
      var view = this._detachViewInContainer(viewContainerLocation.internalElement, index);
      view.destroy();
      profile_1.wtfLeave(s);
    };
    AppViewManager_.prototype.attachViewInContainer = function(viewContainerLocation, index, viewRef) {
      var viewRef_ = viewRef;
      var s = this._attachViewInContainerScope();
      this._attachViewToContainer(viewRef_.internalView, viewContainerLocation.internalElement, index);
      return profile_1.wtfLeave(s, viewRef_);
    };
    AppViewManager_.prototype.detachViewInContainer = function(viewContainerLocation, index) {
      var s = this._detachViewInContainerScope();
      var view = this._detachViewInContainer(viewContainerLocation.internalElement, index);
      return profile_1.wtfLeave(s, view.ref);
    };
    AppViewManager_.prototype.onViewCreated = function(view) {};
    AppViewManager_.prototype.onViewDestroyed = function(view) {};
    AppViewManager_.prototype.createRenderComponentType = function(encapsulation, styles) {
      return new api_1.RenderComponentType(this._appId + "-" + this._nextCompTypeId++, encapsulation, styles);
    };
    AppViewManager_.prototype._attachViewToContainer = function(view, vcAppElement, viewIndex) {
      if (view.proto.type === view_type_1.ViewType.COMPONENT) {
        throw new exceptions_1.BaseException("Component views can't be moved!");
      }
      var nestedViews = vcAppElement.nestedViews;
      if (nestedViews == null) {
        nestedViews = [];
        vcAppElement.nestedViews = nestedViews;
      }
      collection_1.ListWrapper.insert(nestedViews, viewIndex, view);
      var refNode;
      if (viewIndex > 0) {
        var prevView = nestedViews[viewIndex - 1];
        refNode = prevView.rootNodesOrAppElements.length > 0 ? prevView.rootNodesOrAppElements[prevView.rootNodesOrAppElements.length - 1] : null;
      } else {
        refNode = vcAppElement.nativeElement;
      }
      if (lang_1.isPresent(refNode)) {
        var refRenderNode;
        if (refNode instanceof element_1.AppElement) {
          refRenderNode = refNode.nativeElement;
        } else {
          refRenderNode = refNode;
        }
        view.renderer.attachViewAfter(refRenderNode, view_1.flattenNestedViewRenderNodes(view.rootNodesOrAppElements));
      }
      vcAppElement.parentView.changeDetector.addContentChild(view.changeDetector);
      vcAppElement.traverseAndSetQueriesAsDirty();
    };
    AppViewManager_.prototype._detachViewInContainer = function(vcAppElement, viewIndex) {
      var view = collection_1.ListWrapper.removeAt(vcAppElement.nestedViews, viewIndex);
      if (view.proto.type === view_type_1.ViewType.COMPONENT) {
        throw new exceptions_1.BaseException("Component views can't be moved!");
      }
      vcAppElement.traverseAndSetQueriesAsDirty();
      view.renderer.detachView(view_1.flattenNestedViewRenderNodes(view.rootNodesOrAppElements));
      view.changeDetector.remove();
      return view;
    };
    AppViewManager_ = __decorate([di_1.Injectable(), __param(1, di_1.Inject(application_tokens_1.APP_ID)), __metadata('design:paramtypes', [api_1.RootRenderer, String])], AppViewManager_);
    return AppViewManager_;
  })(AppViewManager);
  exports.AppViewManager_ = AppViewManager_;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/console", ["angular2/src/core/di", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var di_1 = require("angular2/src/core/di");
  var lang_1 = require("angular2/src/facade/lang");
  var Console = (function() {
    function Console() {}
    Console.prototype.log = function(message) {
      lang_1.print(message);
    };
    Console = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [])], Console);
    return Console;
  })();
  exports.Console = Console;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/zone", ["angular2/src/core/zone/ng_zone"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var ng_zone_1 = require("angular2/src/core/zone/ng_zone");
  exports.NgZone = ng_zone_1.NgZone;
  exports.NgZoneError = ng_zone_1.NgZoneError;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/render", ["angular2/src/core/render/api"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var api_1 = require("angular2/src/core/render/api");
  exports.RootRenderer = api_1.RootRenderer;
  exports.Renderer = api_1.Renderer;
  exports.RenderComponentType = api_1.RenderComponentType;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/directive_resolver", ["angular2/src/core/di", "angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection", "angular2/src/core/metadata", "angular2/src/core/reflection/reflection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var di_1 = require("angular2/src/core/di");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var metadata_1 = require("angular2/src/core/metadata");
  var reflection_1 = require("angular2/src/core/reflection/reflection");
  function _isDirectiveMetadata(type) {
    return type instanceof metadata_1.DirectiveMetadata;
  }
  var DirectiveResolver = (function() {
    function DirectiveResolver() {}
    DirectiveResolver.prototype.resolve = function(type) {
      var typeMetadata = reflection_1.reflector.annotations(di_1.resolveForwardRef(type));
      if (lang_1.isPresent(typeMetadata)) {
        var metadata = typeMetadata.find(_isDirectiveMetadata);
        if (lang_1.isPresent(metadata)) {
          var propertyMetadata = reflection_1.reflector.propMetadata(type);
          return this._mergeWithPropertyMetadata(metadata, propertyMetadata, type);
        }
      }
      throw new exceptions_1.BaseException("No Directive annotation found on " + lang_1.stringify(type));
    };
    DirectiveResolver.prototype._mergeWithPropertyMetadata = function(dm, propertyMetadata, directiveType) {
      var inputs = [];
      var outputs = [];
      var host = {};
      var queries = {};
      collection_1.StringMapWrapper.forEach(propertyMetadata, function(metadata, propName) {
        metadata.forEach(function(a) {
          if (a instanceof metadata_1.InputMetadata) {
            if (lang_1.isPresent(a.bindingPropertyName)) {
              inputs.push(propName + ": " + a.bindingPropertyName);
            } else {
              inputs.push(propName);
            }
          }
          if (a instanceof metadata_1.OutputMetadata) {
            if (lang_1.isPresent(a.bindingPropertyName)) {
              outputs.push(propName + ": " + a.bindingPropertyName);
            } else {
              outputs.push(propName);
            }
          }
          if (a instanceof metadata_1.HostBindingMetadata) {
            if (lang_1.isPresent(a.hostPropertyName)) {
              host[("[" + a.hostPropertyName + "]")] = propName;
            } else {
              host[("[" + propName + "]")] = propName;
            }
          }
          if (a instanceof metadata_1.HostListenerMetadata) {
            var args = lang_1.isPresent(a.args) ? a.args.join(', ') : '';
            host[("(" + a.eventName + ")")] = propName + "(" + args + ")";
          }
          if (a instanceof metadata_1.ContentChildrenMetadata) {
            queries[propName] = a;
          }
          if (a instanceof metadata_1.ViewChildrenMetadata) {
            queries[propName] = a;
          }
          if (a instanceof metadata_1.ContentChildMetadata) {
            queries[propName] = a;
          }
          if (a instanceof metadata_1.ViewChildMetadata) {
            queries[propName] = a;
          }
        });
      });
      return this._merge(dm, inputs, outputs, host, queries, directiveType);
    };
    DirectiveResolver.prototype._merge = function(dm, inputs, outputs, host, queries, directiveType) {
      var mergedInputs = lang_1.isPresent(dm.inputs) ? collection_1.ListWrapper.concat(dm.inputs, inputs) : inputs;
      var mergedOutputs;
      if (lang_1.isPresent(dm.outputs)) {
        dm.outputs.forEach(function(propName) {
          if (collection_1.ListWrapper.contains(outputs, propName)) {
            throw new exceptions_1.BaseException("Output event '" + propName + "' defined multiple times in '" + lang_1.stringify(directiveType) + "'");
          }
        });
        mergedOutputs = collection_1.ListWrapper.concat(dm.outputs, outputs);
      } else {
        mergedOutputs = outputs;
      }
      var mergedHost = lang_1.isPresent(dm.host) ? collection_1.StringMapWrapper.merge(dm.host, host) : host;
      var mergedQueries = lang_1.isPresent(dm.queries) ? collection_1.StringMapWrapper.merge(dm.queries, queries) : queries;
      if (dm instanceof metadata_1.ComponentMetadata) {
        return new metadata_1.ComponentMetadata({
          selector: dm.selector,
          inputs: mergedInputs,
          outputs: mergedOutputs,
          host: mergedHost,
          exportAs: dm.exportAs,
          moduleId: dm.moduleId,
          queries: mergedQueries,
          changeDetection: dm.changeDetection,
          providers: dm.providers,
          viewProviders: dm.viewProviders
        });
      } else {
        return new metadata_1.DirectiveMetadata({
          selector: dm.selector,
          inputs: mergedInputs,
          outputs: mergedOutputs,
          host: mergedHost,
          exportAs: dm.exportAs,
          queries: mergedQueries,
          providers: dm.providers
        });
      }
    };
    DirectiveResolver = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [])], DirectiveResolver);
    return DirectiveResolver;
  })();
  exports.DirectiveResolver = DirectiveResolver;
  exports.CODEGEN_DIRECTIVE_RESOLVER = new DirectiveResolver();
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/view_resolver", ["angular2/src/core/di", "angular2/src/core/metadata/view", "angular2/src/core/metadata/directives", "angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection", "angular2/src/core/reflection/reflection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var di_1 = require("angular2/src/core/di");
  var view_1 = require("angular2/src/core/metadata/view");
  var directives_1 = require("angular2/src/core/metadata/directives");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var reflection_1 = require("angular2/src/core/reflection/reflection");
  var ViewResolver = (function() {
    function ViewResolver() {
      this._cache = new collection_1.Map();
    }
    ViewResolver.prototype.resolve = function(component) {
      var view = this._cache.get(component);
      if (lang_1.isBlank(view)) {
        view = this._resolve(component);
        this._cache.set(component, view);
      }
      return view;
    };
    ViewResolver.prototype._resolve = function(component) {
      var compMeta;
      var viewMeta;
      reflection_1.reflector.annotations(component).forEach(function(m) {
        if (m instanceof view_1.ViewMetadata) {
          viewMeta = m;
        }
        if (m instanceof directives_1.ComponentMetadata) {
          compMeta = m;
        }
      });
      if (lang_1.isPresent(compMeta)) {
        if (lang_1.isBlank(compMeta.template) && lang_1.isBlank(compMeta.templateUrl) && lang_1.isBlank(viewMeta)) {
          throw new exceptions_1.BaseException("Component '" + lang_1.stringify(component) + "' must have either 'template', 'templateUrl', or '@View' set.");
        } else if (lang_1.isPresent(compMeta.template) && lang_1.isPresent(viewMeta)) {
          this._throwMixingViewAndComponent("template", component);
        } else if (lang_1.isPresent(compMeta.templateUrl) && lang_1.isPresent(viewMeta)) {
          this._throwMixingViewAndComponent("templateUrl", component);
        } else if (lang_1.isPresent(compMeta.directives) && lang_1.isPresent(viewMeta)) {
          this._throwMixingViewAndComponent("directives", component);
        } else if (lang_1.isPresent(compMeta.pipes) && lang_1.isPresent(viewMeta)) {
          this._throwMixingViewAndComponent("pipes", component);
        } else if (lang_1.isPresent(compMeta.encapsulation) && lang_1.isPresent(viewMeta)) {
          this._throwMixingViewAndComponent("encapsulation", component);
        } else if (lang_1.isPresent(compMeta.styles) && lang_1.isPresent(viewMeta)) {
          this._throwMixingViewAndComponent("styles", component);
        } else if (lang_1.isPresent(compMeta.styleUrls) && lang_1.isPresent(viewMeta)) {
          this._throwMixingViewAndComponent("styleUrls", component);
        } else if (lang_1.isPresent(viewMeta)) {
          return viewMeta;
        } else {
          return new view_1.ViewMetadata({
            templateUrl: compMeta.templateUrl,
            template: compMeta.template,
            directives: compMeta.directives,
            pipes: compMeta.pipes,
            encapsulation: compMeta.encapsulation,
            styles: compMeta.styles,
            styleUrls: compMeta.styleUrls
          });
        }
      } else {
        if (lang_1.isBlank(viewMeta)) {
          throw new exceptions_1.BaseException("No View decorator found on component '" + lang_1.stringify(component) + "'");
        } else {
          return viewMeta;
        }
      }
      return null;
    };
    ViewResolver.prototype._throwMixingViewAndComponent = function(propertyName, component) {
      throw new exceptions_1.BaseException("Component '" + lang_1.stringify(component) + "' cannot have both '" + propertyName + "' and '@View' set at the same time\"");
    };
    ViewResolver = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [])], ViewResolver);
    return ViewResolver;
  })();
  exports.ViewResolver = ViewResolver;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/debug/debug_node", ["angular2/src/facade/lang", "angular2/src/facade/collection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var lang_1 = require("angular2/src/facade/lang");
  var collection_1 = require("angular2/src/facade/collection");
  var EventListener = (function() {
    function EventListener(name, callback) {
      this.name = name;
      this.callback = callback;
    }
    ;
    return EventListener;
  })();
  exports.EventListener = EventListener;
  var DebugNode = (function() {
    function DebugNode(nativeNode, parent) {
      this.nativeNode = nativeNode;
      if (lang_1.isPresent(parent) && parent instanceof DebugElement) {
        parent.addChild(this);
      } else {
        this.parent = null;
      }
      this.listeners = [];
      this.providerTokens = [];
    }
    DebugNode.prototype.setDebugInfo = function(info) {
      this.injector = info.injector;
      this.providerTokens = info.providerTokens;
      this.locals = info.locals;
      this.componentInstance = info.component;
    };
    DebugNode.prototype.inject = function(token) {
      return this.injector.get(token);
    };
    DebugNode.prototype.getLocal = function(name) {
      return this.locals.get(name);
    };
    return DebugNode;
  })();
  exports.DebugNode = DebugNode;
  var DebugElement = (function(_super) {
    __extends(DebugElement, _super);
    function DebugElement(nativeNode, parent) {
      _super.call(this, nativeNode, parent);
      this.properties = new Map();
      this.attributes = new Map();
      this.childNodes = [];
      this.nativeElement = nativeNode;
    }
    DebugElement.prototype.addChild = function(child) {
      if (lang_1.isPresent(child)) {
        this.childNodes.push(child);
        child.parent = this;
      }
    };
    DebugElement.prototype.removeChild = function(child) {
      var childIndex = this.childNodes.indexOf(child);
      if (childIndex !== -1) {
        child.parent = null;
        this.childNodes.splice(childIndex, 1);
      }
    };
    DebugElement.prototype.insertChildrenAfter = function(child, newChildren) {
      var siblingIndex = this.childNodes.indexOf(child);
      if (siblingIndex !== -1) {
        var previousChildren = this.childNodes.slice(0, siblingIndex + 1);
        var nextChildren = this.childNodes.slice(siblingIndex + 1);
        this.childNodes = collection_1.ListWrapper.concat(collection_1.ListWrapper.concat(previousChildren, newChildren), nextChildren);
        for (var i = 0; i < newChildren.length; ++i) {
          var newChild = newChildren[i];
          if (lang_1.isPresent(newChild.parent)) {
            newChild.parent.removeChild(newChild);
          }
          newChild.parent = this;
        }
      }
    };
    DebugElement.prototype.query = function(predicate) {
      var results = this.queryAll(predicate);
      return results.length > 0 ? results[0] : null;
    };
    DebugElement.prototype.queryAll = function(predicate) {
      var matches = [];
      _queryElementChildren(this, predicate, matches);
      return matches;
    };
    DebugElement.prototype.queryAllNodes = function(predicate) {
      var matches = [];
      _queryNodeChildren(this, predicate, matches);
      return matches;
    };
    Object.defineProperty(DebugElement.prototype, "children", {
      get: function() {
        var children = [];
        this.childNodes.forEach(function(node) {
          if (node instanceof DebugElement) {
            children.push(node);
          }
        });
        return children;
      },
      enumerable: true,
      configurable: true
    });
    DebugElement.prototype.triggerEventHandler = function(eventName, eventObj) {
      this.listeners.forEach(function(listener) {
        if (listener.name == eventName) {
          listener.callback(eventObj);
        }
      });
    };
    return DebugElement;
  })(DebugNode);
  exports.DebugElement = DebugElement;
  function asNativeElements(debugEls) {
    return debugEls.map(function(el) {
      return el.nativeElement;
    });
  }
  exports.asNativeElements = asNativeElements;
  function _queryElementChildren(element, predicate, matches) {
    element.childNodes.forEach(function(node) {
      if (node instanceof DebugElement) {
        if (predicate(node)) {
          matches.push(node);
        }
        _queryElementChildren(node, predicate, matches);
      }
    });
  }
  function _queryNodeChildren(parentNode, predicate, matches) {
    if (parentNode instanceof DebugElement) {
      parentNode.childNodes.forEach(function(node) {
        if (predicate(node)) {
          matches.push(node);
        }
        if (node instanceof DebugElement) {
          _queryNodeChildren(node, predicate, matches);
        }
      });
    }
  }
  var _nativeNodeToDebugNode = new Map();
  function getDebugNode(nativeNode) {
    return _nativeNodeToDebugNode.get(nativeNode);
  }
  exports.getDebugNode = getDebugNode;
  function getAllDebugNodes() {
    return collection_1.MapWrapper.values(_nativeNodeToDebugNode);
  }
  exports.getAllDebugNodes = getAllDebugNodes;
  function indexDebugNode(node) {
    _nativeNodeToDebugNode.set(node.nativeNode, node);
  }
  exports.indexDebugNode = indexDebugNode;
  function removeDebugNodeFromIndex(node) {
    _nativeNodeToDebugNode.delete(node.nativeNode);
  }
  exports.removeDebugNodeFromIndex = removeDebugNodeFromIndex;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/platform_directives_and_pipes", ["angular2/src/core/di", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var di_1 = require("angular2/src/core/di");
  var lang_1 = require("angular2/src/facade/lang");
  exports.PLATFORM_DIRECTIVES = lang_1.CONST_EXPR(new di_1.OpaqueToken("Platform Directives"));
  exports.PLATFORM_PIPES = lang_1.CONST_EXPR(new di_1.OpaqueToken("Platform Pipes"));
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/platform_common_providers", ["angular2/src/facade/lang", "angular2/src/core/di", "angular2/src/core/console", "angular2/src/core/reflection/reflection", "angular2/src/core/testability/testability"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var di_1 = require("angular2/src/core/di");
  var console_1 = require("angular2/src/core/console");
  var reflection_1 = require("angular2/src/core/reflection/reflection");
  var testability_1 = require("angular2/src/core/testability/testability");
  function _reflector() {
    return reflection_1.reflector;
  }
  exports.PLATFORM_COMMON_PROVIDERS = lang_1.CONST_EXPR([new di_1.Provider(reflection_1.Reflector, {
    useFactory: _reflector,
    deps: []
  }), testability_1.TestabilityRegistry, console_1.Console]);
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/pipe_resolver", ["angular2/src/core/di", "angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/core/metadata", "angular2/src/core/reflection/reflection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var di_1 = require("angular2/src/core/di");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var metadata_1 = require("angular2/src/core/metadata");
  var reflection_1 = require("angular2/src/core/reflection/reflection");
  function _isPipeMetadata(type) {
    return type instanceof metadata_1.PipeMetadata;
  }
  var PipeResolver = (function() {
    function PipeResolver() {}
    PipeResolver.prototype.resolve = function(type) {
      var metas = reflection_1.reflector.annotations(di_1.resolveForwardRef(type));
      if (lang_1.isPresent(metas)) {
        var annotation = metas.find(_isPipeMetadata);
        if (lang_1.isPresent(annotation)) {
          return annotation;
        }
      }
      throw new exceptions_1.BaseException("No Pipe decorator found on " + lang_1.stringify(type));
    };
    PipeResolver = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [])], PipeResolver);
    return PipeResolver;
  })();
  exports.PipeResolver = PipeResolver;
  exports.CODEGEN_PIPE_RESOLVER = new PipeResolver();
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/dom/debug/by", ["angular2/src/facade/lang", "angular2/src/platform/dom/dom_adapter"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var dom_adapter_1 = require("angular2/src/platform/dom/dom_adapter");
  var By = (function() {
    function By() {}
    By.all = function() {
      return function(debugElement) {
        return true;
      };
    };
    By.css = function(selector) {
      return function(debugElement) {
        return lang_1.isPresent(debugElement.nativeElement) ? dom_adapter_1.DOM.elementMatches(debugElement.nativeElement, selector) : false;
      };
    };
    By.directive = function(type) {
      return function(debugElement) {
        return debugElement.providerTokens.indexOf(type) !== -1;
      };
    };
    return By;
  })();
  exports.By = By;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/debug/debug_renderer", ["angular2/src/facade/lang", "angular2/src/core/debug/debug_node"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var debug_node_1 = require("angular2/src/core/debug/debug_node");
  var DebugDomRootRenderer = (function() {
    function DebugDomRootRenderer(_delegate) {
      this._delegate = _delegate;
    }
    DebugDomRootRenderer.prototype.renderComponent = function(componentProto) {
      return new DebugDomRenderer(this, this._delegate.renderComponent(componentProto));
    };
    return DebugDomRootRenderer;
  })();
  exports.DebugDomRootRenderer = DebugDomRootRenderer;
  var DebugDomRenderer = (function() {
    function DebugDomRenderer(_rootRenderer, _delegate) {
      this._rootRenderer = _rootRenderer;
      this._delegate = _delegate;
    }
    DebugDomRenderer.prototype.renderComponent = function(componentType) {
      return this._rootRenderer.renderComponent(componentType);
    };
    DebugDomRenderer.prototype.selectRootElement = function(selector) {
      var nativeEl = this._delegate.selectRootElement(selector);
      var debugEl = new debug_node_1.DebugElement(nativeEl, null);
      debug_node_1.indexDebugNode(debugEl);
      return nativeEl;
    };
    DebugDomRenderer.prototype.createElement = function(parentElement, name) {
      var nativeEl = this._delegate.createElement(parentElement, name);
      var debugEl = new debug_node_1.DebugElement(nativeEl, debug_node_1.getDebugNode(parentElement));
      debugEl.name = name;
      debug_node_1.indexDebugNode(debugEl);
      return nativeEl;
    };
    DebugDomRenderer.prototype.createViewRoot = function(hostElement) {
      return this._delegate.createViewRoot(hostElement);
    };
    DebugDomRenderer.prototype.createTemplateAnchor = function(parentElement) {
      var comment = this._delegate.createTemplateAnchor(parentElement);
      var debugEl = new debug_node_1.DebugNode(comment, debug_node_1.getDebugNode(parentElement));
      debug_node_1.indexDebugNode(debugEl);
      return comment;
    };
    DebugDomRenderer.prototype.createText = function(parentElement, value) {
      var text = this._delegate.createText(parentElement, value);
      var debugEl = new debug_node_1.DebugNode(text, debug_node_1.getDebugNode(parentElement));
      debug_node_1.indexDebugNode(debugEl);
      return text;
    };
    DebugDomRenderer.prototype.projectNodes = function(parentElement, nodes) {
      var debugParent = debug_node_1.getDebugNode(parentElement);
      if (lang_1.isPresent(debugParent) && debugParent instanceof debug_node_1.DebugElement) {
        nodes.forEach(function(node) {
          debugParent.addChild(debug_node_1.getDebugNode(node));
        });
      }
      return this._delegate.projectNodes(parentElement, nodes);
    };
    DebugDomRenderer.prototype.attachViewAfter = function(node, viewRootNodes) {
      var debugNode = debug_node_1.getDebugNode(node);
      if (lang_1.isPresent(debugNode)) {
        var debugParent = debugNode.parent;
        if (viewRootNodes.length > 0 && lang_1.isPresent(debugParent)) {
          var debugViewRootNodes = [];
          viewRootNodes.forEach(function(rootNode) {
            return debugViewRootNodes.push(debug_node_1.getDebugNode(rootNode));
          });
          debugParent.insertChildrenAfter(debugNode, debugViewRootNodes);
        }
      }
      return this._delegate.attachViewAfter(node, viewRootNodes);
    };
    DebugDomRenderer.prototype.detachView = function(viewRootNodes) {
      viewRootNodes.forEach(function(node) {
        var debugNode = debug_node_1.getDebugNode(node);
        if (lang_1.isPresent(debugNode) && lang_1.isPresent(debugNode.parent)) {
          debugNode.parent.removeChild(debugNode);
        }
      });
      return this._delegate.detachView(viewRootNodes);
    };
    DebugDomRenderer.prototype.destroyView = function(hostElement, viewAllNodes) {
      viewAllNodes.forEach(function(node) {
        debug_node_1.removeDebugNodeFromIndex(debug_node_1.getDebugNode(node));
      });
      return this._delegate.destroyView(hostElement, viewAllNodes);
    };
    DebugDomRenderer.prototype.listen = function(renderElement, name, callback) {
      var debugEl = debug_node_1.getDebugNode(renderElement);
      if (lang_1.isPresent(debugEl)) {
        debugEl.listeners.push(new debug_node_1.EventListener(name, callback));
      }
      return this._delegate.listen(renderElement, name, callback);
    };
    DebugDomRenderer.prototype.listenGlobal = function(target, name, callback) {
      return this._delegate.listenGlobal(target, name, callback);
    };
    DebugDomRenderer.prototype.setElementProperty = function(renderElement, propertyName, propertyValue) {
      var debugEl = debug_node_1.getDebugNode(renderElement);
      if (lang_1.isPresent(debugEl) && debugEl instanceof debug_node_1.DebugElement) {
        debugEl.properties.set(propertyName, propertyValue);
      }
      return this._delegate.setElementProperty(renderElement, propertyName, propertyValue);
    };
    DebugDomRenderer.prototype.setElementAttribute = function(renderElement, attributeName, attributeValue) {
      var debugEl = debug_node_1.getDebugNode(renderElement);
      if (lang_1.isPresent(debugEl) && debugEl instanceof debug_node_1.DebugElement) {
        debugEl.attributes.set(attributeName, attributeValue);
      }
      return this._delegate.setElementAttribute(renderElement, attributeName, attributeValue);
    };
    DebugDomRenderer.prototype.setBindingDebugInfo = function(renderElement, propertyName, propertyValue) {
      return this._delegate.setBindingDebugInfo(renderElement, propertyName, propertyValue);
    };
    DebugDomRenderer.prototype.setElementDebugInfo = function(renderElement, info) {
      var debugEl = debug_node_1.getDebugNode(renderElement);
      debugEl.setDebugInfo(info);
      return this._delegate.setElementDebugInfo(renderElement, info);
    };
    DebugDomRenderer.prototype.setElementClass = function(renderElement, className, isAdd) {
      return this._delegate.setElementClass(renderElement, className, isAdd);
    };
    DebugDomRenderer.prototype.setElementStyle = function(renderElement, styleName, styleValue) {
      return this._delegate.setElementStyle(renderElement, styleName, styleValue);
    };
    DebugDomRenderer.prototype.invokeElementMethod = function(renderElement, methodName, args) {
      return this._delegate.invokeElementMethod(renderElement, methodName, args);
    };
    DebugDomRenderer.prototype.setText = function(renderNode, text) {
      return this._delegate.setText(renderNode, text);
    };
    return DebugDomRenderer;
  })();
  exports.DebugDomRenderer = DebugDomRenderer;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/dom/dom_adapter", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  exports.DOM = null;
  function setRootDomAdapter(adapter) {
    if (lang_1.isBlank(exports.DOM)) {
      exports.DOM = adapter;
    }
  }
  exports.setRootDomAdapter = setRootDomAdapter;
  var DomAdapter = (function() {
    function DomAdapter() {}
    Object.defineProperty(DomAdapter.prototype, "attrToPropMap", {
      get: function() {
        return this._attrToPropMap;
      },
      set: function(value) {
        this._attrToPropMap = value;
      },
      enumerable: true,
      configurable: true
    });
    ;
    ;
    return DomAdapter;
  })();
  exports.DomAdapter = DomAdapter;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/di/decorators", ["angular2/src/core/di/metadata", "angular2/src/core/util/decorators"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var metadata_1 = require("angular2/src/core/di/metadata");
  var decorators_1 = require("angular2/src/core/util/decorators");
  exports.Inject = decorators_1.makeParamDecorator(metadata_1.InjectMetadata);
  exports.Optional = decorators_1.makeParamDecorator(metadata_1.OptionalMetadata);
  exports.Injectable = decorators_1.makeDecorator(metadata_1.InjectableMetadata);
  exports.Self = decorators_1.makeParamDecorator(metadata_1.SelfMetadata);
  exports.Host = decorators_1.makeParamDecorator(metadata_1.HostMetadata);
  exports.SkipSelf = decorators_1.makeParamDecorator(metadata_1.SkipSelfMetadata);
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/facade/exceptions", ["angular2/src/facade/exception_handler", "angular2/src/facade/exception_handler"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var exception_handler_1 = require("angular2/src/facade/exception_handler");
  var exception_handler_2 = require("angular2/src/facade/exception_handler");
  exports.ExceptionHandler = exception_handler_2.ExceptionHandler;
  var BaseException = (function(_super) {
    __extends(BaseException, _super);
    function BaseException(message) {
      if (message === void 0) {
        message = "--";
      }
      _super.call(this, message);
      this.message = message;
      this.stack = (new Error(message)).stack;
    }
    BaseException.prototype.toString = function() {
      return this.message;
    };
    return BaseException;
  })(Error);
  exports.BaseException = BaseException;
  var WrappedException = (function(_super) {
    __extends(WrappedException, _super);
    function WrappedException(_wrapperMessage, _originalException, _originalStack, _context) {
      _super.call(this, _wrapperMessage);
      this._wrapperMessage = _wrapperMessage;
      this._originalException = _originalException;
      this._originalStack = _originalStack;
      this._context = _context;
      this._wrapperStack = (new Error(_wrapperMessage)).stack;
    }
    Object.defineProperty(WrappedException.prototype, "wrapperMessage", {
      get: function() {
        return this._wrapperMessage;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(WrappedException.prototype, "wrapperStack", {
      get: function() {
        return this._wrapperStack;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(WrappedException.prototype, "originalException", {
      get: function() {
        return this._originalException;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(WrappedException.prototype, "originalStack", {
      get: function() {
        return this._originalStack;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(WrappedException.prototype, "context", {
      get: function() {
        return this._context;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(WrappedException.prototype, "message", {
      get: function() {
        return exception_handler_1.ExceptionHandler.exceptionToString(this);
      },
      enumerable: true,
      configurable: true
    });
    WrappedException.prototype.toString = function() {
      return this.message;
    };
    return WrappedException;
  })(Error);
  exports.WrappedException = WrappedException;
  function makeTypeError(message) {
    return new TypeError(message);
  }
  exports.makeTypeError = makeTypeError;
  function unimplemented() {
    throw new BaseException('unimplemented');
  }
  exports.unimplemented = unimplemented;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/reflection/reflection", ["angular2/src/core/reflection/reflector", "angular2/src/core/reflection/reflector", "angular2/src/core/reflection/reflection_capabilities"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var reflector_1 = require("angular2/src/core/reflection/reflector");
  var reflector_2 = require("angular2/src/core/reflection/reflector");
  exports.Reflector = reflector_2.Reflector;
  exports.ReflectionInfo = reflector_2.ReflectionInfo;
  var reflection_capabilities_1 = require("angular2/src/core/reflection/reflection_capabilities");
  exports.reflector = new reflector_1.Reflector(new reflection_capabilities_1.ReflectionCapabilities());
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/di/key", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/core/di/type_literal", "angular2/src/core/di/forward_ref", "angular2/src/core/di/type_literal"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var type_literal_1 = require("angular2/src/core/di/type_literal");
  var forward_ref_1 = require("angular2/src/core/di/forward_ref");
  var type_literal_2 = require("angular2/src/core/di/type_literal");
  exports.TypeLiteral = type_literal_2.TypeLiteral;
  var Key = (function() {
    function Key(token, id) {
      this.token = token;
      this.id = id;
      if (lang_1.isBlank(token)) {
        throw new exceptions_1.BaseException('Token must be defined!');
      }
    }
    Object.defineProperty(Key.prototype, "displayName", {
      get: function() {
        return lang_1.stringify(this.token);
      },
      enumerable: true,
      configurable: true
    });
    Key.get = function(token) {
      return _globalKeyRegistry.get(forward_ref_1.resolveForwardRef(token));
    };
    Object.defineProperty(Key, "numberOfKeys", {
      get: function() {
        return _globalKeyRegistry.numberOfKeys;
      },
      enumerable: true,
      configurable: true
    });
    return Key;
  })();
  exports.Key = Key;
  var KeyRegistry = (function() {
    function KeyRegistry() {
      this._allKeys = new Map();
    }
    KeyRegistry.prototype.get = function(token) {
      if (token instanceof Key)
        return token;
      var theToken = token;
      if (token instanceof type_literal_1.TypeLiteral) {
        theToken = token.type;
      }
      token = theToken;
      if (this._allKeys.has(token)) {
        return this._allKeys.get(token);
      }
      var newKey = new Key(token, Key.numberOfKeys);
      this._allKeys.set(token, newKey);
      return newKey;
    };
    Object.defineProperty(KeyRegistry.prototype, "numberOfKeys", {
      get: function() {
        return this._allKeys.size;
      },
      enumerable: true,
      configurable: true
    });
    return KeyRegistry;
  })();
  exports.KeyRegistry = KeyRegistry;
  var _globalKeyRegistry = new KeyRegistry();
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/animate/animation", ["angular2/src/facade/lang", "angular2/src/facade/math", "angular2/src/platform/dom/util", "angular2/src/facade/collection", "angular2/src/platform/dom/dom_adapter"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var math_1 = require("angular2/src/facade/math");
  var util_1 = require("angular2/src/platform/dom/util");
  var collection_1 = require("angular2/src/facade/collection");
  var dom_adapter_1 = require("angular2/src/platform/dom/dom_adapter");
  var Animation = (function() {
    function Animation(element, data, browserDetails) {
      var _this = this;
      this.element = element;
      this.data = data;
      this.browserDetails = browserDetails;
      this.callbacks = [];
      this.eventClearFunctions = [];
      this.completed = false;
      this._stringPrefix = '';
      this.startTime = lang_1.DateWrapper.toMillis(lang_1.DateWrapper.now());
      this._stringPrefix = dom_adapter_1.DOM.getAnimationPrefix();
      this.setup();
      this.wait(function(timestamp) {
        return _this.start();
      });
    }
    Object.defineProperty(Animation.prototype, "totalTime", {
      get: function() {
        var delay = this.computedDelay != null ? this.computedDelay : 0;
        var duration = this.computedDuration != null ? this.computedDuration : 0;
        return delay + duration;
      },
      enumerable: true,
      configurable: true
    });
    Animation.prototype.wait = function(callback) {
      this.browserDetails.raf(callback, 2);
    };
    Animation.prototype.setup = function() {
      if (this.data.fromStyles != null)
        this.applyStyles(this.data.fromStyles);
      if (this.data.duration != null)
        this.applyStyles({'transitionDuration': this.data.duration.toString() + 'ms'});
      if (this.data.delay != null)
        this.applyStyles({'transitionDelay': this.data.delay.toString() + 'ms'});
    };
    Animation.prototype.start = function() {
      this.addClasses(this.data.classesToAdd);
      this.addClasses(this.data.animationClasses);
      this.removeClasses(this.data.classesToRemove);
      if (this.data.toStyles != null)
        this.applyStyles(this.data.toStyles);
      var computedStyles = dom_adapter_1.DOM.getComputedStyle(this.element);
      this.computedDelay = math_1.Math.max(this.parseDurationString(computedStyles.getPropertyValue(this._stringPrefix + 'transition-delay')), this.parseDurationString(this.element.style.getPropertyValue(this._stringPrefix + 'transition-delay')));
      this.computedDuration = math_1.Math.max(this.parseDurationString(computedStyles.getPropertyValue(this._stringPrefix + 'transition-duration')), this.parseDurationString(this.element.style.getPropertyValue(this._stringPrefix + 'transition-duration')));
      this.addEvents();
    };
    Animation.prototype.applyStyles = function(styles) {
      var _this = this;
      collection_1.StringMapWrapper.forEach(styles, function(value, key) {
        var dashCaseKey = util_1.camelCaseToDashCase(key);
        if (lang_1.isPresent(dom_adapter_1.DOM.getStyle(_this.element, dashCaseKey))) {
          dom_adapter_1.DOM.setStyle(_this.element, dashCaseKey, value.toString());
        } else {
          dom_adapter_1.DOM.setStyle(_this.element, _this._stringPrefix + dashCaseKey, value.toString());
        }
      });
    };
    Animation.prototype.addClasses = function(classes) {
      for (var i = 0,
          len = classes.length; i < len; i++)
        dom_adapter_1.DOM.addClass(this.element, classes[i]);
    };
    Animation.prototype.removeClasses = function(classes) {
      for (var i = 0,
          len = classes.length; i < len; i++)
        dom_adapter_1.DOM.removeClass(this.element, classes[i]);
    };
    Animation.prototype.addEvents = function() {
      var _this = this;
      if (this.totalTime > 0) {
        this.eventClearFunctions.push(dom_adapter_1.DOM.onAndCancel(this.element, dom_adapter_1.DOM.getTransitionEnd(), function(event) {
          return _this.handleAnimationEvent(event);
        }));
      } else {
        this.handleAnimationCompleted();
      }
    };
    Animation.prototype.handleAnimationEvent = function(event) {
      var elapsedTime = math_1.Math.round(event.elapsedTime * 1000);
      if (!this.browserDetails.elapsedTimeIncludesDelay)
        elapsedTime += this.computedDelay;
      event.stopPropagation();
      if (elapsedTime >= this.totalTime)
        this.handleAnimationCompleted();
    };
    Animation.prototype.handleAnimationCompleted = function() {
      this.removeClasses(this.data.animationClasses);
      this.callbacks.forEach(function(callback) {
        return callback();
      });
      this.callbacks = [];
      this.eventClearFunctions.forEach(function(fn) {
        return fn();
      });
      this.eventClearFunctions = [];
      this.completed = true;
    };
    Animation.prototype.onComplete = function(callback) {
      if (this.completed) {
        callback();
      } else {
        this.callbacks.push(callback);
      }
      return this;
    };
    Animation.prototype.parseDurationString = function(duration) {
      var maxValue = 0;
      if (duration == null || duration.length < 2) {
        return maxValue;
      } else if (duration.substring(duration.length - 2) == 'ms') {
        var value = lang_1.NumberWrapper.parseInt(this.stripLetters(duration), 10);
        if (value > maxValue)
          maxValue = value;
      } else if (duration.substring(duration.length - 1) == 's') {
        var ms = lang_1.NumberWrapper.parseFloat(this.stripLetters(duration)) * 1000;
        var value = math_1.Math.floor(ms);
        if (value > maxValue)
          maxValue = value;
      }
      return maxValue;
    };
    Animation.prototype.stripLetters = function(str) {
      return lang_1.StringWrapper.replaceAll(str, lang_1.RegExpWrapper.create('[^0-9]+$', ''), '');
    };
    return Animation;
  })();
  exports.Animation = Animation;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/dom/shared_styles_host", ["angular2/src/platform/dom/dom_adapter", "angular2/src/core/di", "angular2/src/facade/collection", "angular2/src/platform/dom/dom_tokens"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var dom_adapter_1 = require("angular2/src/platform/dom/dom_adapter");
  var di_1 = require("angular2/src/core/di");
  var collection_1 = require("angular2/src/facade/collection");
  var dom_tokens_1 = require("angular2/src/platform/dom/dom_tokens");
  var SharedStylesHost = (function() {
    function SharedStylesHost() {
      this._styles = [];
      this._stylesSet = new Set();
    }
    SharedStylesHost.prototype.addStyles = function(styles) {
      var _this = this;
      var additions = [];
      styles.forEach(function(style) {
        if (!collection_1.SetWrapper.has(_this._stylesSet, style)) {
          _this._stylesSet.add(style);
          _this._styles.push(style);
          additions.push(style);
        }
      });
      this.onStylesAdded(additions);
    };
    SharedStylesHost.prototype.onStylesAdded = function(additions) {};
    SharedStylesHost.prototype.getAllStyles = function() {
      return this._styles;
    };
    SharedStylesHost = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [])], SharedStylesHost);
    return SharedStylesHost;
  })();
  exports.SharedStylesHost = SharedStylesHost;
  var DomSharedStylesHost = (function(_super) {
    __extends(DomSharedStylesHost, _super);
    function DomSharedStylesHost(doc) {
      _super.call(this);
      this._hostNodes = new Set();
      this._hostNodes.add(doc.head);
    }
    DomSharedStylesHost.prototype._addStylesToHost = function(styles, host) {
      for (var i = 0; i < styles.length; i++) {
        var style = styles[i];
        dom_adapter_1.DOM.appendChild(host, dom_adapter_1.DOM.createStyleElement(style));
      }
    };
    DomSharedStylesHost.prototype.addHost = function(hostNode) {
      this._addStylesToHost(this._styles, hostNode);
      this._hostNodes.add(hostNode);
    };
    DomSharedStylesHost.prototype.removeHost = function(hostNode) {
      collection_1.SetWrapper.delete(this._hostNodes, hostNode);
    };
    DomSharedStylesHost.prototype.onStylesAdded = function(additions) {
      var _this = this;
      this._hostNodes.forEach(function(hostNode) {
        _this._addStylesToHost(additions, hostNode);
      });
    };
    DomSharedStylesHost = __decorate([di_1.Injectable(), __param(0, di_1.Inject(dom_tokens_1.DOCUMENT)), __metadata('design:paramtypes', [Object])], DomSharedStylesHost);
    return DomSharedStylesHost;
  })(SharedStylesHost);
  exports.DomSharedStylesHost = DomSharedStylesHost;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/profile/profile", ["angular2/src/core/profile/wtf_impl"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var impl = require("angular2/src/core/profile/wtf_impl");
  exports.wtfEnabled = impl.detectWTF();
  function noopScope(arg0, arg1) {
    return null;
  }
  exports.wtfCreateScope = exports.wtfEnabled ? impl.createScope : function(signature, flags) {
    return noopScope;
  };
  exports.wtfLeave = exports.wtfEnabled ? impl.leave : function(s, r) {
    return r;
  };
  exports.wtfStartTimeRange = exports.wtfEnabled ? impl.startTimeRange : function(rangeType, action) {
    return null;
  };
  exports.wtfEndTimeRange = exports.wtfEnabled ? impl.endTimeRange : function(r) {
    return null;
  };
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/change_detection_util", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection", "angular2/src/core/change_detection/constants", "angular2/src/core/change_detection/pipe_lifecycle_reflector", "angular2/src/core/change_detection/binding_record", "angular2/src/core/change_detection/directive_record"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var constants_1 = require("angular2/src/core/change_detection/constants");
  var pipe_lifecycle_reflector_1 = require("angular2/src/core/change_detection/pipe_lifecycle_reflector");
  var binding_record_1 = require("angular2/src/core/change_detection/binding_record");
  var directive_record_1 = require("angular2/src/core/change_detection/directive_record");
  var WrappedValue = (function() {
    function WrappedValue(wrapped) {
      this.wrapped = wrapped;
    }
    WrappedValue.wrap = function(value) {
      var w = _wrappedValues[_wrappedIndex++ % 5];
      w.wrapped = value;
      return w;
    };
    return WrappedValue;
  })();
  exports.WrappedValue = WrappedValue;
  var _wrappedValues = [new WrappedValue(null), new WrappedValue(null), new WrappedValue(null), new WrappedValue(null), new WrappedValue(null)];
  var _wrappedIndex = 0;
  var SimpleChange = (function() {
    function SimpleChange(previousValue, currentValue) {
      this.previousValue = previousValue;
      this.currentValue = currentValue;
    }
    SimpleChange.prototype.isFirstChange = function() {
      return this.previousValue === ChangeDetectionUtil.uninitialized;
    };
    return SimpleChange;
  })();
  exports.SimpleChange = SimpleChange;
  var _simpleChangesIndex = 0;
  var _simpleChanges = [new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null), new SimpleChange(null, null)];
  function _simpleChange(previousValue, currentValue) {
    var index = _simpleChangesIndex++ % 20;
    var s = _simpleChanges[index];
    s.previousValue = previousValue;
    s.currentValue = currentValue;
    return s;
  }
  var ChangeDetectionUtil = (function() {
    function ChangeDetectionUtil() {}
    ChangeDetectionUtil.arrayFn0 = function() {
      return [];
    };
    ChangeDetectionUtil.arrayFn1 = function(a1) {
      return [a1];
    };
    ChangeDetectionUtil.arrayFn2 = function(a1, a2) {
      return [a1, a2];
    };
    ChangeDetectionUtil.arrayFn3 = function(a1, a2, a3) {
      return [a1, a2, a3];
    };
    ChangeDetectionUtil.arrayFn4 = function(a1, a2, a3, a4) {
      return [a1, a2, a3, a4];
    };
    ChangeDetectionUtil.arrayFn5 = function(a1, a2, a3, a4, a5) {
      return [a1, a2, a3, a4, a5];
    };
    ChangeDetectionUtil.arrayFn6 = function(a1, a2, a3, a4, a5, a6) {
      return [a1, a2, a3, a4, a5, a6];
    };
    ChangeDetectionUtil.arrayFn7 = function(a1, a2, a3, a4, a5, a6, a7) {
      return [a1, a2, a3, a4, a5, a6, a7];
    };
    ChangeDetectionUtil.arrayFn8 = function(a1, a2, a3, a4, a5, a6, a7, a8) {
      return [a1, a2, a3, a4, a5, a6, a7, a8];
    };
    ChangeDetectionUtil.arrayFn9 = function(a1, a2, a3, a4, a5, a6, a7, a8, a9) {
      return [a1, a2, a3, a4, a5, a6, a7, a8, a9];
    };
    ChangeDetectionUtil.operation_negate = function(value) {
      return !value;
    };
    ChangeDetectionUtil.operation_add = function(left, right) {
      return left + right;
    };
    ChangeDetectionUtil.operation_subtract = function(left, right) {
      return left - right;
    };
    ChangeDetectionUtil.operation_multiply = function(left, right) {
      return left * right;
    };
    ChangeDetectionUtil.operation_divide = function(left, right) {
      return left / right;
    };
    ChangeDetectionUtil.operation_remainder = function(left, right) {
      return left % right;
    };
    ChangeDetectionUtil.operation_equals = function(left, right) {
      return left == right;
    };
    ChangeDetectionUtil.operation_not_equals = function(left, right) {
      return left != right;
    };
    ChangeDetectionUtil.operation_identical = function(left, right) {
      return left === right;
    };
    ChangeDetectionUtil.operation_not_identical = function(left, right) {
      return left !== right;
    };
    ChangeDetectionUtil.operation_less_then = function(left, right) {
      return left < right;
    };
    ChangeDetectionUtil.operation_greater_then = function(left, right) {
      return left > right;
    };
    ChangeDetectionUtil.operation_less_or_equals_then = function(left, right) {
      return left <= right;
    };
    ChangeDetectionUtil.operation_greater_or_equals_then = function(left, right) {
      return left >= right;
    };
    ChangeDetectionUtil.cond = function(cond, trueVal, falseVal) {
      return cond ? trueVal : falseVal;
    };
    ChangeDetectionUtil.mapFn = function(keys) {
      function buildMap(values) {
        var res = collection_1.StringMapWrapper.create();
        for (var i = 0; i < keys.length; ++i) {
          collection_1.StringMapWrapper.set(res, keys[i], values[i]);
        }
        return res;
      }
      switch (keys.length) {
        case 0:
          return function() {
            return [];
          };
        case 1:
          return function(a1) {
            return buildMap([a1]);
          };
        case 2:
          return function(a1, a2) {
            return buildMap([a1, a2]);
          };
        case 3:
          return function(a1, a2, a3) {
            return buildMap([a1, a2, a3]);
          };
        case 4:
          return function(a1, a2, a3, a4) {
            return buildMap([a1, a2, a3, a4]);
          };
        case 5:
          return function(a1, a2, a3, a4, a5) {
            return buildMap([a1, a2, a3, a4, a5]);
          };
        case 6:
          return function(a1, a2, a3, a4, a5, a6) {
            return buildMap([a1, a2, a3, a4, a5, a6]);
          };
        case 7:
          return function(a1, a2, a3, a4, a5, a6, a7) {
            return buildMap([a1, a2, a3, a4, a5, a6, a7]);
          };
        case 8:
          return function(a1, a2, a3, a4, a5, a6, a7, a8) {
            return buildMap([a1, a2, a3, a4, a5, a6, a7, a8]);
          };
        case 9:
          return function(a1, a2, a3, a4, a5, a6, a7, a8, a9) {
            return buildMap([a1, a2, a3, a4, a5, a6, a7, a8, a9]);
          };
        default:
          throw new exceptions_1.BaseException("Does not support literal maps with more than 9 elements");
      }
    };
    ChangeDetectionUtil.keyedAccess = function(obj, args) {
      return obj[args[0]];
    };
    ChangeDetectionUtil.unwrapValue = function(value) {
      if (value instanceof WrappedValue) {
        return value.wrapped;
      } else {
        return value;
      }
    };
    ChangeDetectionUtil.changeDetectionMode = function(strategy) {
      return constants_1.isDefaultChangeDetectionStrategy(strategy) ? constants_1.ChangeDetectionStrategy.CheckAlways : constants_1.ChangeDetectionStrategy.CheckOnce;
    };
    ChangeDetectionUtil.simpleChange = function(previousValue, currentValue) {
      return _simpleChange(previousValue, currentValue);
    };
    ChangeDetectionUtil.isValueBlank = function(value) {
      return lang_1.isBlank(value);
    };
    ChangeDetectionUtil.s = function(value) {
      return lang_1.isPresent(value) ? "" + value : '';
    };
    ChangeDetectionUtil.protoByIndex = function(protos, selfIndex) {
      return selfIndex < 1 ? null : protos[selfIndex - 1];
    };
    ChangeDetectionUtil.callPipeOnDestroy = function(selectedPipe) {
      if (pipe_lifecycle_reflector_1.implementsOnDestroy(selectedPipe.pipe)) {
        selectedPipe.pipe.ngOnDestroy();
      }
    };
    ChangeDetectionUtil.bindingTarget = function(mode, elementIndex, name, unit, debug) {
      return new binding_record_1.BindingTarget(mode, elementIndex, name, unit, debug);
    };
    ChangeDetectionUtil.directiveIndex = function(elementIndex, directiveIndex) {
      return new directive_record_1.DirectiveIndex(elementIndex, directiveIndex);
    };
    ChangeDetectionUtil.looseNotIdentical = function(a, b) {
      return !lang_1.looseIdentical(a, b);
    };
    ChangeDetectionUtil.devModeEqual = function(a, b) {
      if (collection_1.isListLikeIterable(a) && collection_1.isListLikeIterable(b)) {
        return collection_1.areIterablesEqual(a, b, ChangeDetectionUtil.devModeEqual);
      } else if (!collection_1.isListLikeIterable(a) && !lang_1.isPrimitive(a) && !collection_1.isListLikeIterable(b) && !lang_1.isPrimitive(b)) {
        return true;
      } else {
        return lang_1.looseIdentical(a, b);
      }
    };
    ChangeDetectionUtil.uninitialized = lang_1.CONST_EXPR(new Object());
    return ChangeDetectionUtil;
  })();
  exports.ChangeDetectionUtil = ChangeDetectionUtil;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/abstract_change_detector", ["angular2/src/facade/lang", "angular2/src/facade/collection", "angular2/src/core/change_detection/change_detection_util", "angular2/src/core/change_detection/change_detector_ref", "angular2/src/core/change_detection/exceptions", "angular2/src/core/change_detection/parser/locals", "angular2/src/core/change_detection/constants", "angular2/src/core/profile/profile", "angular2/src/core/change_detection/observable_facade", "angular2/src/facade/async"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var collection_1 = require("angular2/src/facade/collection");
  var change_detection_util_1 = require("angular2/src/core/change_detection/change_detection_util");
  var change_detector_ref_1 = require("angular2/src/core/change_detection/change_detector_ref");
  var exceptions_1 = require("angular2/src/core/change_detection/exceptions");
  var locals_1 = require("angular2/src/core/change_detection/parser/locals");
  var constants_1 = require("angular2/src/core/change_detection/constants");
  var profile_1 = require("angular2/src/core/profile/profile");
  var observable_facade_1 = require("angular2/src/core/change_detection/observable_facade");
  var async_1 = require("angular2/src/facade/async");
  var _scope_check = profile_1.wtfCreateScope("ChangeDetector#check(ascii id, bool throwOnChange)");
  var _Context = (function() {
    function _Context(element, componentElement, context, locals, injector, expression) {
      this.element = element;
      this.componentElement = componentElement;
      this.context = context;
      this.locals = locals;
      this.injector = injector;
      this.expression = expression;
    }
    return _Context;
  })();
  var AbstractChangeDetector = (function() {
    function AbstractChangeDetector(id, numberOfPropertyProtoRecords, bindingTargets, directiveIndices, strategy) {
      this.id = id;
      this.numberOfPropertyProtoRecords = numberOfPropertyProtoRecords;
      this.bindingTargets = bindingTargets;
      this.directiveIndices = directiveIndices;
      this.strategy = strategy;
      this.contentChildren = [];
      this.viewChildren = [];
      this.state = constants_1.ChangeDetectorState.NeverChecked;
      this.locals = null;
      this.mode = null;
      this.pipes = null;
      this.ref = new change_detector_ref_1.ChangeDetectorRef_(this);
    }
    AbstractChangeDetector.prototype.addContentChild = function(cd) {
      this.contentChildren.push(cd);
      cd.parent = this;
    };
    AbstractChangeDetector.prototype.removeContentChild = function(cd) {
      collection_1.ListWrapper.remove(this.contentChildren, cd);
    };
    AbstractChangeDetector.prototype.addViewChild = function(cd) {
      this.viewChildren.push(cd);
      cd.parent = this;
    };
    AbstractChangeDetector.prototype.removeViewChild = function(cd) {
      collection_1.ListWrapper.remove(this.viewChildren, cd);
    };
    AbstractChangeDetector.prototype.remove = function() {
      this.parent.removeContentChild(this);
    };
    AbstractChangeDetector.prototype.handleEvent = function(eventName, elIndex, event) {
      if (!this.hydrated()) {
        this.throwDehydratedError(this.id + " -> " + eventName);
      }
      try {
        var locals = new Map();
        locals.set('$event', event);
        var res = !this.handleEventInternal(eventName, elIndex, new locals_1.Locals(this.locals, locals));
        this.markPathToRootAsCheckOnce();
        return res;
      } catch (e) {
        var c = this.dispatcher.getDebugContext(null, elIndex, null);
        var context = lang_1.isPresent(c) ? new exceptions_1.EventEvaluationErrorContext(c.element, c.componentElement, c.context, c.locals, c.injector) : null;
        throw new exceptions_1.EventEvaluationError(eventName, e, e.stack, context);
      }
    };
    AbstractChangeDetector.prototype.handleEventInternal = function(eventName, elIndex, locals) {
      return false;
    };
    AbstractChangeDetector.prototype.detectChanges = function() {
      this.runDetectChanges(false);
    };
    AbstractChangeDetector.prototype.checkNoChanges = function() {
      if (lang_1.assertionsEnabled()) {
        this.runDetectChanges(true);
      }
    };
    AbstractChangeDetector.prototype.runDetectChanges = function(throwOnChange) {
      if (this.mode === constants_1.ChangeDetectionStrategy.Detached || this.mode === constants_1.ChangeDetectionStrategy.Checked || this.state === constants_1.ChangeDetectorState.Errored)
        return ;
      var s = _scope_check(this.id, throwOnChange);
      this.detectChangesInRecords(throwOnChange);
      this._detectChangesContentChildren(throwOnChange);
      if (!throwOnChange)
        this.afterContentLifecycleCallbacks();
      this._detectChangesInViewChildren(throwOnChange);
      if (!throwOnChange)
        this.afterViewLifecycleCallbacks();
      if (this.mode === constants_1.ChangeDetectionStrategy.CheckOnce)
        this.mode = constants_1.ChangeDetectionStrategy.Checked;
      this.state = constants_1.ChangeDetectorState.CheckedBefore;
      profile_1.wtfLeave(s);
    };
    AbstractChangeDetector.prototype.detectChangesInRecords = function(throwOnChange) {
      if (!this.hydrated()) {
        this.throwDehydratedError(this.id);
      }
      try {
        this.detectChangesInRecordsInternal(throwOnChange);
      } catch (e) {
        if (!(e instanceof exceptions_1.ExpressionChangedAfterItHasBeenCheckedException)) {
          this.state = constants_1.ChangeDetectorState.Errored;
        }
        this._throwError(e, e.stack);
      }
    };
    AbstractChangeDetector.prototype.detectChangesInRecordsInternal = function(throwOnChange) {};
    AbstractChangeDetector.prototype.hydrate = function(context, locals, dispatcher, pipes) {
      this.dispatcher = dispatcher;
      this.mode = change_detection_util_1.ChangeDetectionUtil.changeDetectionMode(this.strategy);
      this.context = context;
      if (this.strategy === constants_1.ChangeDetectionStrategy.OnPushObserve) {
        this.observeComponent(context);
      }
      this.locals = locals;
      this.pipes = pipes;
      this.hydrateDirectives(dispatcher);
      this.state = constants_1.ChangeDetectorState.NeverChecked;
    };
    AbstractChangeDetector.prototype.hydrateDirectives = function(dispatcher) {};
    AbstractChangeDetector.prototype.dehydrate = function() {
      this.dehydrateDirectives(true);
      if (this.strategy === constants_1.ChangeDetectionStrategy.OnPushObserve) {
        this._unsubsribeFromObservables();
      }
      this._unsubscribeFromOutputs();
      this.dispatcher = null;
      this.context = null;
      this.locals = null;
      this.pipes = null;
    };
    AbstractChangeDetector.prototype.dehydrateDirectives = function(destroyPipes) {};
    AbstractChangeDetector.prototype.hydrated = function() {
      return lang_1.isPresent(this.context);
    };
    AbstractChangeDetector.prototype.destroyRecursive = function() {
      this.dispatcher.notifyOnDestroy();
      this.dehydrate();
      var children = this.contentChildren;
      for (var i = 0; i < children.length; i++) {
        children[i].destroyRecursive();
      }
      children = this.viewChildren;
      for (var i = 0; i < children.length; i++) {
        children[i].destroyRecursive();
      }
    };
    AbstractChangeDetector.prototype.afterContentLifecycleCallbacks = function() {
      this.dispatcher.notifyAfterContentChecked();
      this.afterContentLifecycleCallbacksInternal();
    };
    AbstractChangeDetector.prototype.afterContentLifecycleCallbacksInternal = function() {};
    AbstractChangeDetector.prototype.afterViewLifecycleCallbacks = function() {
      this.dispatcher.notifyAfterViewChecked();
      this.afterViewLifecycleCallbacksInternal();
    };
    AbstractChangeDetector.prototype.afterViewLifecycleCallbacksInternal = function() {};
    AbstractChangeDetector.prototype._detectChangesContentChildren = function(throwOnChange) {
      var c = this.contentChildren;
      for (var i = 0; i < c.length; ++i) {
        c[i].runDetectChanges(throwOnChange);
      }
    };
    AbstractChangeDetector.prototype._detectChangesInViewChildren = function(throwOnChange) {
      var c = this.viewChildren;
      for (var i = 0; i < c.length; ++i) {
        c[i].runDetectChanges(throwOnChange);
      }
    };
    AbstractChangeDetector.prototype.markAsCheckOnce = function() {
      this.mode = constants_1.ChangeDetectionStrategy.CheckOnce;
    };
    AbstractChangeDetector.prototype.markPathToRootAsCheckOnce = function() {
      var c = this;
      while (lang_1.isPresent(c) && c.mode !== constants_1.ChangeDetectionStrategy.Detached) {
        if (c.mode === constants_1.ChangeDetectionStrategy.Checked)
          c.mode = constants_1.ChangeDetectionStrategy.CheckOnce;
        c = c.parent;
      }
    };
    AbstractChangeDetector.prototype._unsubsribeFromObservables = function() {
      if (lang_1.isPresent(this.subscriptions)) {
        for (var i = 0; i < this.subscriptions.length; ++i) {
          var s = this.subscriptions[i];
          if (lang_1.isPresent(this.subscriptions[i])) {
            s.cancel();
            this.subscriptions[i] = null;
          }
        }
      }
    };
    AbstractChangeDetector.prototype._unsubscribeFromOutputs = function() {
      if (lang_1.isPresent(this.outputSubscriptions)) {
        for (var i = 0; i < this.outputSubscriptions.length; ++i) {
          async_1.ObservableWrapper.dispose(this.outputSubscriptions[i]);
          this.outputSubscriptions[i] = null;
        }
      }
    };
    AbstractChangeDetector.prototype.observeValue = function(value, index) {
      var _this = this;
      if (observable_facade_1.isObservable(value)) {
        this._createArrayToStoreObservables();
        if (lang_1.isBlank(this.subscriptions[index])) {
          this.streams[index] = value.changes;
          this.subscriptions[index] = value.changes.listen(function(_) {
            return _this.ref.markForCheck();
          });
        } else if (this.streams[index] !== value.changes) {
          this.subscriptions[index].cancel();
          this.streams[index] = value.changes;
          this.subscriptions[index] = value.changes.listen(function(_) {
            return _this.ref.markForCheck();
          });
        }
      }
      return value;
    };
    AbstractChangeDetector.prototype.observeDirective = function(value, index) {
      var _this = this;
      if (observable_facade_1.isObservable(value)) {
        this._createArrayToStoreObservables();
        var arrayIndex = this.numberOfPropertyProtoRecords + index + 2;
        this.streams[arrayIndex] = value.changes;
        this.subscriptions[arrayIndex] = value.changes.listen(function(_) {
          return _this.ref.markForCheck();
        });
      }
      return value;
    };
    AbstractChangeDetector.prototype.observeComponent = function(value) {
      var _this = this;
      if (observable_facade_1.isObservable(value)) {
        this._createArrayToStoreObservables();
        var index = this.numberOfPropertyProtoRecords + 1;
        this.streams[index] = value.changes;
        this.subscriptions[index] = value.changes.listen(function(_) {
          return _this.ref.markForCheck();
        });
      }
      return value;
    };
    AbstractChangeDetector.prototype._createArrayToStoreObservables = function() {
      if (lang_1.isBlank(this.subscriptions)) {
        this.subscriptions = collection_1.ListWrapper.createFixedSize(this.numberOfPropertyProtoRecords + this.directiveIndices.length + 2);
        this.streams = collection_1.ListWrapper.createFixedSize(this.numberOfPropertyProtoRecords + this.directiveIndices.length + 2);
      }
    };
    AbstractChangeDetector.prototype.getDirectiveFor = function(directives, index) {
      return directives.getDirectiveFor(this.directiveIndices[index]);
    };
    AbstractChangeDetector.prototype.getDetectorFor = function(directives, index) {
      return directives.getDetectorFor(this.directiveIndices[index]);
    };
    AbstractChangeDetector.prototype.notifyDispatcher = function(value) {
      this.dispatcher.notifyOnBinding(this._currentBinding(), value);
    };
    AbstractChangeDetector.prototype.logBindingUpdate = function(value) {
      this.dispatcher.logBindingUpdate(this._currentBinding(), value);
    };
    AbstractChangeDetector.prototype.addChange = function(changes, oldValue, newValue) {
      if (lang_1.isBlank(changes)) {
        changes = {};
      }
      changes[this._currentBinding().name] = change_detection_util_1.ChangeDetectionUtil.simpleChange(oldValue, newValue);
      return changes;
    };
    AbstractChangeDetector.prototype._throwError = function(exception, stack) {
      var error;
      try {
        var c = this.dispatcher.getDebugContext(null, this._currentBinding().elementIndex, null);
        var context = lang_1.isPresent(c) ? new _Context(c.element, c.componentElement, c.context, c.locals, c.injector, this._currentBinding().debug) : null;
        error = new exceptions_1.ChangeDetectionError(this._currentBinding().debug, exception, stack, context);
      } catch (e) {
        error = new exceptions_1.ChangeDetectionError(null, exception, stack, null);
      }
      throw error;
    };
    AbstractChangeDetector.prototype.throwOnChangeError = function(oldValue, newValue) {
      throw new exceptions_1.ExpressionChangedAfterItHasBeenCheckedException(this._currentBinding().debug, oldValue, newValue, null);
    };
    AbstractChangeDetector.prototype.throwDehydratedError = function(detail) {
      throw new exceptions_1.DehydratedException(detail);
    };
    AbstractChangeDetector.prototype._currentBinding = function() {
      return this.bindingTargets[this.propertyBindingIndex];
    };
    return AbstractChangeDetector;
  })();
  exports.AbstractChangeDetector = AbstractChangeDetector;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/codegen_logic_util", ["angular2/src/facade/lang", "angular2/src/core/change_detection/codegen_facade", "angular2/src/core/change_detection/proto_record", "angular2/src/core/change_detection/constants", "angular2/src/facade/exceptions"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var codegen_facade_1 = require("angular2/src/core/change_detection/codegen_facade");
  var proto_record_1 = require("angular2/src/core/change_detection/proto_record");
  var constants_1 = require("angular2/src/core/change_detection/constants");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var CodegenLogicUtil = (function() {
    function CodegenLogicUtil(_names, _utilName, _changeDetectorStateName, _changeDetection) {
      this._names = _names;
      this._utilName = _utilName;
      this._changeDetectorStateName = _changeDetectorStateName;
      this._changeDetection = _changeDetection;
    }
    CodegenLogicUtil.prototype.genPropertyBindingEvalValue = function(protoRec) {
      var _this = this;
      return this._genEvalValue(protoRec, function(idx) {
        return _this._names.getLocalName(idx);
      }, this._names.getLocalsAccessorName());
    };
    CodegenLogicUtil.prototype.genEventBindingEvalValue = function(eventRecord, protoRec) {
      var _this = this;
      return this._genEvalValue(protoRec, function(idx) {
        return _this._names.getEventLocalName(eventRecord, idx);
      }, "locals");
    };
    CodegenLogicUtil.prototype._genEvalValue = function(protoRec, getLocalName, localsAccessor) {
      var context = (protoRec.contextIndex == -1) ? this._names.getDirectiveName(protoRec.directiveIndex) : getLocalName(protoRec.contextIndex);
      var argString = protoRec.args.map(function(arg) {
        return getLocalName(arg);
      }).join(", ");
      var rhs;
      switch (protoRec.mode) {
        case proto_record_1.RecordType.Self:
          rhs = context;
          break;
        case proto_record_1.RecordType.Const:
          rhs = codegen_facade_1.codify(protoRec.funcOrValue);
          break;
        case proto_record_1.RecordType.PropertyRead:
          rhs = this._observe(context + "." + protoRec.name, protoRec);
          break;
        case proto_record_1.RecordType.SafeProperty:
          var read = this._observe(context + "." + protoRec.name, protoRec);
          rhs = this._utilName + ".isValueBlank(" + context + ") ? null : " + this._observe(read, protoRec);
          break;
        case proto_record_1.RecordType.PropertyWrite:
          rhs = context + "." + protoRec.name + " = " + getLocalName(protoRec.args[0]);
          break;
        case proto_record_1.RecordType.Local:
          rhs = this._observe(localsAccessor + ".get(" + codegen_facade_1.rawString(protoRec.name) + ")", protoRec);
          break;
        case proto_record_1.RecordType.InvokeMethod:
          rhs = this._observe(context + "." + protoRec.name + "(" + argString + ")", protoRec);
          break;
        case proto_record_1.RecordType.SafeMethodInvoke:
          var invoke = context + "." + protoRec.name + "(" + argString + ")";
          rhs = this._utilName + ".isValueBlank(" + context + ") ? null : " + this._observe(invoke, protoRec);
          break;
        case proto_record_1.RecordType.InvokeClosure:
          rhs = context + "(" + argString + ")";
          break;
        case proto_record_1.RecordType.PrimitiveOp:
          rhs = this._utilName + "." + protoRec.name + "(" + argString + ")";
          break;
        case proto_record_1.RecordType.CollectionLiteral:
          rhs = this._utilName + "." + protoRec.name + "(" + argString + ")";
          break;
        case proto_record_1.RecordType.Interpolate:
          rhs = this._genInterpolation(protoRec);
          break;
        case proto_record_1.RecordType.KeyedRead:
          rhs = this._observe(context + "[" + getLocalName(protoRec.args[0]) + "]", protoRec);
          break;
        case proto_record_1.RecordType.KeyedWrite:
          rhs = context + "[" + getLocalName(protoRec.args[0]) + "] = " + getLocalName(protoRec.args[1]);
          break;
        case proto_record_1.RecordType.Chain:
          rhs = "" + getLocalName(protoRec.args[protoRec.args.length - 1]);
          break;
        default:
          throw new exceptions_1.BaseException("Unknown operation " + protoRec.mode);
      }
      return getLocalName(protoRec.selfIndex) + " = " + rhs + ";";
    };
    CodegenLogicUtil.prototype._observe = function(exp, rec) {
      if (this._changeDetection === constants_1.ChangeDetectionStrategy.OnPushObserve) {
        return "this.observeValue(" + exp + ", " + rec.selfIndex + ")";
      } else {
        return exp;
      }
    };
    CodegenLogicUtil.prototype.genPropertyBindingTargets = function(propertyBindingTargets, genDebugInfo) {
      var _this = this;
      var bs = propertyBindingTargets.map(function(b) {
        if (lang_1.isBlank(b))
          return "null";
        var debug = genDebugInfo ? codegen_facade_1.codify(b.debug) : "null";
        return _this._utilName + ".bindingTarget(" + codegen_facade_1.codify(b.mode) + ", " + b.elementIndex + ", " + codegen_facade_1.codify(b.name) + ", " + codegen_facade_1.codify(b.unit) + ", " + debug + ")";
      });
      return "[" + bs.join(", ") + "]";
    };
    CodegenLogicUtil.prototype.genDirectiveIndices = function(directiveRecords) {
      var _this = this;
      var bs = directiveRecords.map(function(b) {
        return (_this._utilName + ".directiveIndex(" + b.directiveIndex.elementIndex + ", " + b.directiveIndex.directiveIndex + ")");
      });
      return "[" + bs.join(", ") + "]";
    };
    CodegenLogicUtil.prototype._genInterpolation = function(protoRec) {
      var iVals = [];
      for (var i = 0; i < protoRec.args.length; ++i) {
        iVals.push(codegen_facade_1.codify(protoRec.fixedArgs[i]));
        iVals.push(this._utilName + ".s(" + this._names.getLocalName(protoRec.args[i]) + ")");
      }
      iVals.push(codegen_facade_1.codify(protoRec.fixedArgs[protoRec.args.length]));
      return codegen_facade_1.combineGeneratedStrings(iVals);
    };
    CodegenLogicUtil.prototype.genHydrateDirectives = function(directiveRecords) {
      var _this = this;
      var res = [];
      var outputCount = 0;
      for (var i = 0; i < directiveRecords.length; ++i) {
        var r = directiveRecords[i];
        var dirVarName = this._names.getDirectiveName(r.directiveIndex);
        res.push(dirVarName + " = " + this._genReadDirective(i) + ";");
        if (lang_1.isPresent(r.outputs)) {
          r.outputs.forEach(function(output) {
            var eventHandlerExpr = _this._genEventHandler(r.directiveIndex.elementIndex, output[1]);
            var statementStart = "this.outputSubscriptions[" + outputCount++ + "] = " + dirVarName + "." + output[0];
            if (lang_1.IS_DART) {
              res.push(statementStart + ".listen(" + eventHandlerExpr + ");");
            } else {
              res.push(statementStart + ".subscribe({next: " + eventHandlerExpr + "});");
            }
          });
        }
      }
      if (outputCount > 0) {
        var statementStart = 'this.outputSubscriptions';
        if (lang_1.IS_DART) {
          res.unshift(statementStart + " = new List(" + outputCount + ");");
        } else {
          res.unshift(statementStart + " = new Array(" + outputCount + ");");
        }
      }
      return res.join("\n");
    };
    CodegenLogicUtil.prototype.genDirectivesOnDestroy = function(directiveRecords) {
      var res = [];
      for (var i = 0; i < directiveRecords.length; ++i) {
        var r = directiveRecords[i];
        if (r.callOnDestroy) {
          var dirVarName = this._names.getDirectiveName(r.directiveIndex);
          res.push(dirVarName + ".ngOnDestroy();");
        }
      }
      return res.join("\n");
    };
    CodegenLogicUtil.prototype._genEventHandler = function(boundElementIndex, eventName) {
      if (lang_1.IS_DART) {
        return "(event) => this.handleEvent('" + eventName + "', " + boundElementIndex + ", event)";
      } else {
        return "(function(event) { return this.handleEvent('" + eventName + "', " + boundElementIndex + ", event); }).bind(this)";
      }
    };
    CodegenLogicUtil.prototype._genReadDirective = function(index) {
      var directiveExpr = "this.getDirectiveFor(directives, " + index + ")";
      if (this._changeDetection === constants_1.ChangeDetectionStrategy.OnPushObserve) {
        return "this.observeDirective(" + directiveExpr + ", " + index + ")";
      } else {
        return directiveExpr;
      }
    };
    CodegenLogicUtil.prototype.genHydrateDetectors = function(directiveRecords) {
      var res = [];
      for (var i = 0; i < directiveRecords.length; ++i) {
        var r = directiveRecords[i];
        if (!r.isDefaultChangeDetection()) {
          res.push(this._names.getDetectorName(r.directiveIndex) + " = this.getDetectorFor(directives, " + i + ");");
        }
      }
      return res.join("\n");
    };
    CodegenLogicUtil.prototype.genContentLifecycleCallbacks = function(directiveRecords) {
      var res = [];
      var eq = lang_1.IS_DART ? '==' : '===';
      for (var i = directiveRecords.length - 1; i >= 0; --i) {
        var dir = directiveRecords[i];
        if (dir.callAfterContentInit) {
          res.push("if(" + this._names.getStateName() + " " + eq + " " + this._changeDetectorStateName + ".NeverChecked) " + this._names.getDirectiveName(dir.directiveIndex) + ".ngAfterContentInit();");
        }
        if (dir.callAfterContentChecked) {
          res.push(this._names.getDirectiveName(dir.directiveIndex) + ".ngAfterContentChecked();");
        }
      }
      return res;
    };
    CodegenLogicUtil.prototype.genViewLifecycleCallbacks = function(directiveRecords) {
      var res = [];
      var eq = lang_1.IS_DART ? '==' : '===';
      for (var i = directiveRecords.length - 1; i >= 0; --i) {
        var dir = directiveRecords[i];
        if (dir.callAfterViewInit) {
          res.push("if(" + this._names.getStateName() + " " + eq + " " + this._changeDetectorStateName + ".NeverChecked) " + this._names.getDirectiveName(dir.directiveIndex) + ".ngAfterViewInit();");
        }
        if (dir.callAfterViewChecked) {
          res.push(this._names.getDirectiveName(dir.directiveIndex) + ".ngAfterViewChecked();");
        }
      }
      return res;
    };
    return CodegenLogicUtil;
  })();
  exports.CodegenLogicUtil = CodegenLogicUtil;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/element", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection", "angular2/src/core/di", "angular2/src/core/di/provider", "angular2/src/core/di/injector", "angular2/src/core/di/provider", "angular2/src/core/metadata/di", "angular2/src/core/linker/view_type", "angular2/src/core/linker/element_ref", "angular2/src/core/linker/view_container_ref", "angular2/src/core/linker/element_ref", "angular2/src/core/render/api", "angular2/src/core/linker/template_ref", "angular2/src/core/metadata/directives", "angular2/src/core/change_detection/change_detection", "angular2/src/core/linker/query_list", "angular2/src/core/reflection/reflection", "angular2/src/core/pipes/pipe_provider", "angular2/src/core/linker/view_container_ref"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var di_1 = require("angular2/src/core/di");
  var provider_1 = require("angular2/src/core/di/provider");
  var injector_1 = require("angular2/src/core/di/injector");
  var provider_2 = require("angular2/src/core/di/provider");
  var di_2 = require("angular2/src/core/metadata/di");
  var view_type_1 = require("angular2/src/core/linker/view_type");
  var element_ref_1 = require("angular2/src/core/linker/element_ref");
  var view_container_ref_1 = require("angular2/src/core/linker/view_container_ref");
  var element_ref_2 = require("angular2/src/core/linker/element_ref");
  var api_1 = require("angular2/src/core/render/api");
  var template_ref_1 = require("angular2/src/core/linker/template_ref");
  var directives_1 = require("angular2/src/core/metadata/directives");
  var change_detection_1 = require("angular2/src/core/change_detection/change_detection");
  var query_list_1 = require("angular2/src/core/linker/query_list");
  var reflection_1 = require("angular2/src/core/reflection/reflection");
  var pipe_provider_1 = require("angular2/src/core/pipes/pipe_provider");
  var view_container_ref_2 = require("angular2/src/core/linker/view_container_ref");
  var _staticKeys;
  var StaticKeys = (function() {
    function StaticKeys() {
      this.templateRefId = di_1.Key.get(template_ref_1.TemplateRef).id;
      this.viewContainerId = di_1.Key.get(view_container_ref_1.ViewContainerRef).id;
      this.changeDetectorRefId = di_1.Key.get(change_detection_1.ChangeDetectorRef).id;
      this.elementRefId = di_1.Key.get(element_ref_2.ElementRef).id;
      this.rendererId = di_1.Key.get(api_1.Renderer).id;
    }
    StaticKeys.instance = function() {
      if (lang_1.isBlank(_staticKeys))
        _staticKeys = new StaticKeys();
      return _staticKeys;
    };
    return StaticKeys;
  })();
  exports.StaticKeys = StaticKeys;
  var DirectiveDependency = (function(_super) {
    __extends(DirectiveDependency, _super);
    function DirectiveDependency(key, optional, lowerBoundVisibility, upperBoundVisibility, properties, attributeName, queryDecorator) {
      _super.call(this, key, optional, lowerBoundVisibility, upperBoundVisibility, properties);
      this.attributeName = attributeName;
      this.queryDecorator = queryDecorator;
      this._verify();
    }
    DirectiveDependency.prototype._verify = function() {
      var count = 0;
      if (lang_1.isPresent(this.queryDecorator))
        count++;
      if (lang_1.isPresent(this.attributeName))
        count++;
      if (count > 1)
        throw new exceptions_1.BaseException('A directive injectable can contain only one of the following @Attribute or @Query.');
    };
    DirectiveDependency.createFrom = function(d) {
      return new DirectiveDependency(d.key, d.optional, d.lowerBoundVisibility, d.upperBoundVisibility, d.properties, DirectiveDependency._attributeName(d.properties), DirectiveDependency._query(d.properties));
    };
    DirectiveDependency._attributeName = function(properties) {
      var p = properties.find(function(p) {
        return p instanceof di_2.AttributeMetadata;
      });
      return lang_1.isPresent(p) ? p.attributeName : null;
    };
    DirectiveDependency._query = function(properties) {
      return properties.find(function(p) {
        return p instanceof di_2.QueryMetadata;
      });
    };
    return DirectiveDependency;
  })(di_1.Dependency);
  exports.DirectiveDependency = DirectiveDependency;
  var DirectiveProvider = (function(_super) {
    __extends(DirectiveProvider, _super);
    function DirectiveProvider(key, factory, deps, isComponent, providers, viewProviders, queries) {
      _super.call(this, key, [new provider_2.ResolvedFactory(factory, deps)], false);
      this.isComponent = isComponent;
      this.providers = providers;
      this.viewProviders = viewProviders;
      this.queries = queries;
    }
    Object.defineProperty(DirectiveProvider.prototype, "displayName", {
      get: function() {
        return this.key.displayName;
      },
      enumerable: true,
      configurable: true
    });
    DirectiveProvider.createFromType = function(type, meta) {
      var provider = new di_1.Provider(type, {useClass: type});
      if (lang_1.isBlank(meta)) {
        meta = new directives_1.DirectiveMetadata();
      }
      var rb = provider_2.resolveProvider(provider);
      var rf = rb.resolvedFactories[0];
      var deps = rf.dependencies.map(DirectiveDependency.createFrom);
      var isComponent = meta instanceof directives_1.ComponentMetadata;
      var resolvedProviders = lang_1.isPresent(meta.providers) ? di_1.Injector.resolve(meta.providers) : null;
      var resolvedViewProviders = meta instanceof directives_1.ComponentMetadata && lang_1.isPresent(meta.viewProviders) ? di_1.Injector.resolve(meta.viewProviders) : null;
      var queries = [];
      if (lang_1.isPresent(meta.queries)) {
        collection_1.StringMapWrapper.forEach(meta.queries, function(meta, fieldName) {
          var setter = reflection_1.reflector.setter(fieldName);
          queries.push(new QueryMetadataWithSetter(setter, meta));
        });
      }
      deps.forEach(function(d) {
        if (lang_1.isPresent(d.queryDecorator)) {
          queries.push(new QueryMetadataWithSetter(null, d.queryDecorator));
        }
      });
      return new DirectiveProvider(rb.key, rf.factory, deps, isComponent, resolvedProviders, resolvedViewProviders, queries);
    };
    return DirectiveProvider;
  })(provider_2.ResolvedProvider_);
  exports.DirectiveProvider = DirectiveProvider;
  var QueryMetadataWithSetter = (function() {
    function QueryMetadataWithSetter(setter, metadata) {
      this.setter = setter;
      this.metadata = metadata;
    }
    return QueryMetadataWithSetter;
  })();
  exports.QueryMetadataWithSetter = QueryMetadataWithSetter;
  function setProvidersVisibility(providers, visibility, result) {
    for (var i = 0; i < providers.length; i++) {
      result.set(providers[i].key.id, visibility);
    }
  }
  var AppProtoElement = (function() {
    function AppProtoElement(firstProviderIsComponent, index, attributes, pwvs, protoQueryRefs, directiveVariableBindings) {
      this.firstProviderIsComponent = firstProviderIsComponent;
      this.index = index;
      this.attributes = attributes;
      this.protoQueryRefs = protoQueryRefs;
      this.directiveVariableBindings = directiveVariableBindings;
      var length = pwvs.length;
      if (length > 0) {
        this.protoInjector = new injector_1.ProtoInjector(pwvs);
      } else {
        this.protoInjector = null;
        this.protoQueryRefs = [];
      }
    }
    AppProtoElement.create = function(metadataCache, index, attributes, directiveTypes, directiveVariableBindings) {
      var componentDirProvider = null;
      var mergedProvidersMap = new Map();
      var providerVisibilityMap = new Map();
      var providers = collection_1.ListWrapper.createGrowableSize(directiveTypes.length);
      var protoQueryRefs = [];
      for (var i = 0; i < directiveTypes.length; i++) {
        var dirProvider = metadataCache.getResolvedDirectiveMetadata(directiveTypes[i]);
        providers[i] = new injector_1.ProviderWithVisibility(dirProvider, dirProvider.isComponent ? injector_1.Visibility.PublicAndPrivate : injector_1.Visibility.Public);
        if (dirProvider.isComponent) {
          componentDirProvider = dirProvider;
        } else {
          if (lang_1.isPresent(dirProvider.providers)) {
            provider_1.mergeResolvedProviders(dirProvider.providers, mergedProvidersMap);
            setProvidersVisibility(dirProvider.providers, injector_1.Visibility.Public, providerVisibilityMap);
          }
        }
        if (lang_1.isPresent(dirProvider.viewProviders)) {
          provider_1.mergeResolvedProviders(dirProvider.viewProviders, mergedProvidersMap);
          setProvidersVisibility(dirProvider.viewProviders, injector_1.Visibility.Private, providerVisibilityMap);
        }
        for (var queryIdx = 0; queryIdx < dirProvider.queries.length; queryIdx++) {
          var q = dirProvider.queries[queryIdx];
          protoQueryRefs.push(new ProtoQueryRef(i, q.setter, q.metadata));
        }
      }
      if (lang_1.isPresent(componentDirProvider) && lang_1.isPresent(componentDirProvider.providers)) {
        provider_1.mergeResolvedProviders(componentDirProvider.providers, mergedProvidersMap);
        setProvidersVisibility(componentDirProvider.providers, injector_1.Visibility.Public, providerVisibilityMap);
      }
      mergedProvidersMap.forEach(function(provider, _) {
        providers.push(new injector_1.ProviderWithVisibility(provider, providerVisibilityMap.get(provider.key.id)));
      });
      return new AppProtoElement(lang_1.isPresent(componentDirProvider), index, attributes, providers, protoQueryRefs, directiveVariableBindings);
    };
    AppProtoElement.prototype.getProviderAtIndex = function(index) {
      return this.protoInjector.getProviderAtIndex(index);
    };
    return AppProtoElement;
  })();
  exports.AppProtoElement = AppProtoElement;
  var _Context = (function() {
    function _Context(element, componentElement, injector) {
      this.element = element;
      this.componentElement = componentElement;
      this.injector = injector;
    }
    return _Context;
  })();
  var InjectorWithHostBoundary = (function() {
    function InjectorWithHostBoundary(injector, hostInjectorBoundary) {
      this.injector = injector;
      this.hostInjectorBoundary = hostInjectorBoundary;
    }
    return InjectorWithHostBoundary;
  })();
  exports.InjectorWithHostBoundary = InjectorWithHostBoundary;
  var AppElement = (function() {
    function AppElement(proto, parentView, parent, nativeElement, embeddedViewFactory) {
      var _this = this;
      this.proto = proto;
      this.parentView = parentView;
      this.parent = parent;
      this.nativeElement = nativeElement;
      this.embeddedViewFactory = embeddedViewFactory;
      this.nestedViews = null;
      this.componentView = null;
      this.ref = new element_ref_1.ElementRef_(this);
      var parentInjector = lang_1.isPresent(parent) ? parent._injector : parentView.parentInjector;
      if (lang_1.isPresent(this.proto.protoInjector)) {
        var isBoundary;
        if (lang_1.isPresent(parent) && lang_1.isPresent(parent.proto.protoInjector)) {
          isBoundary = false;
        } else {
          isBoundary = parentView.hostInjectorBoundary;
        }
        this._queryStrategy = this._buildQueryStrategy();
        this._injector = new di_1.Injector(this.proto.protoInjector, parentInjector, isBoundary, this, function() {
          return _this._debugContext();
        });
        var injectorStrategy = this._injector.internalStrategy;
        this._strategy = injectorStrategy instanceof injector_1.InjectorInlineStrategy ? new ElementDirectiveInlineStrategy(injectorStrategy, this) : new ElementDirectiveDynamicStrategy(injectorStrategy, this);
        this._strategy.init();
      } else {
        this._queryStrategy = null;
        this._injector = parentInjector;
        this._strategy = null;
      }
    }
    AppElement.getViewParentInjector = function(parentViewType, containerAppElement, imperativelyCreatedProviders, rootInjector) {
      var parentInjector;
      var hostInjectorBoundary;
      switch (parentViewType) {
        case view_type_1.ViewType.COMPONENT:
          parentInjector = containerAppElement._injector;
          hostInjectorBoundary = true;
          break;
        case view_type_1.ViewType.EMBEDDED:
          parentInjector = lang_1.isPresent(containerAppElement.proto.protoInjector) ? containerAppElement._injector.parent : containerAppElement._injector;
          hostInjectorBoundary = containerAppElement._injector.hostBoundary;
          break;
        case view_type_1.ViewType.HOST:
          if (lang_1.isPresent(containerAppElement)) {
            parentInjector = lang_1.isPresent(containerAppElement.proto.protoInjector) ? containerAppElement._injector.parent : containerAppElement._injector;
            if (lang_1.isPresent(imperativelyCreatedProviders)) {
              var imperativeProvidersWithVisibility = imperativelyCreatedProviders.map(function(p) {
                return new injector_1.ProviderWithVisibility(p, injector_1.Visibility.Public);
              });
              parentInjector = new di_1.Injector(new injector_1.ProtoInjector(imperativeProvidersWithVisibility), parentInjector, true, null, null);
              hostInjectorBoundary = false;
            } else {
              hostInjectorBoundary = containerAppElement._injector.hostBoundary;
            }
          } else {
            parentInjector = rootInjector;
            hostInjectorBoundary = true;
          }
          break;
      }
      return new InjectorWithHostBoundary(parentInjector, hostInjectorBoundary);
    };
    AppElement.prototype.attachComponentView = function(componentView) {
      this.componentView = componentView;
    };
    AppElement.prototype._debugContext = function() {
      var c = this.parentView.getDebugContext(this, null, null);
      return lang_1.isPresent(c) ? new _Context(c.element, c.componentElement, c.injector) : null;
    };
    AppElement.prototype.hasVariableBinding = function(name) {
      var vb = this.proto.directiveVariableBindings;
      return lang_1.isPresent(vb) && collection_1.StringMapWrapper.contains(vb, name);
    };
    AppElement.prototype.getVariableBinding = function(name) {
      var index = this.proto.directiveVariableBindings[name];
      return lang_1.isPresent(index) ? this.getDirectiveAtIndex(index) : this.getElementRef();
    };
    AppElement.prototype.get = function(token) {
      return this._injector.get(token);
    };
    AppElement.prototype.hasDirective = function(type) {
      return lang_1.isPresent(this._injector.getOptional(type));
    };
    AppElement.prototype.getComponent = function() {
      return lang_1.isPresent(this._strategy) ? this._strategy.getComponent() : null;
    };
    AppElement.prototype.getInjector = function() {
      return this._injector;
    };
    AppElement.prototype.getElementRef = function() {
      return this.ref;
    };
    AppElement.prototype.getViewContainerRef = function() {
      return new view_container_ref_2.ViewContainerRef_(this);
    };
    AppElement.prototype.getTemplateRef = function() {
      if (lang_1.isPresent(this.embeddedViewFactory)) {
        return new template_ref_1.TemplateRef_(this.ref);
      }
      return null;
    };
    AppElement.prototype.getDependency = function(injector, provider, dep) {
      if (provider instanceof DirectiveProvider) {
        var dirDep = dep;
        if (lang_1.isPresent(dirDep.attributeName))
          return this._buildAttribute(dirDep);
        if (lang_1.isPresent(dirDep.queryDecorator))
          return this._queryStrategy.findQuery(dirDep.queryDecorator).list;
        if (dirDep.key.id === StaticKeys.instance().changeDetectorRefId) {
          if (this.proto.firstProviderIsComponent) {
            return new _ComponentViewChangeDetectorRef(this);
          } else {
            return this.parentView.changeDetector.ref;
          }
        }
        if (dirDep.key.id === StaticKeys.instance().elementRefId) {
          return this.getElementRef();
        }
        if (dirDep.key.id === StaticKeys.instance().viewContainerId) {
          return this.getViewContainerRef();
        }
        if (dirDep.key.id === StaticKeys.instance().templateRefId) {
          var tr = this.getTemplateRef();
          if (lang_1.isBlank(tr) && !dirDep.optional) {
            throw new di_1.NoProviderError(null, dirDep.key);
          }
          return tr;
        }
        if (dirDep.key.id === StaticKeys.instance().rendererId) {
          return this.parentView.renderer;
        }
      } else if (provider instanceof pipe_provider_1.PipeProvider) {
        if (dep.key.id === StaticKeys.instance().changeDetectorRefId) {
          if (this.proto.firstProviderIsComponent) {
            return new _ComponentViewChangeDetectorRef(this);
          } else {
            return this.parentView.changeDetector;
          }
        }
      }
      return injector_1.UNDEFINED;
    };
    AppElement.prototype._buildAttribute = function(dep) {
      var attributes = this.proto.attributes;
      if (lang_1.isPresent(attributes) && collection_1.StringMapWrapper.contains(attributes, dep.attributeName)) {
        return attributes[dep.attributeName];
      } else {
        return null;
      }
    };
    AppElement.prototype.addDirectivesMatchingQuery = function(query, list) {
      var templateRef = this.getTemplateRef();
      if (query.selector === template_ref_1.TemplateRef && lang_1.isPresent(templateRef)) {
        list.push(templateRef);
      }
      if (this._strategy != null) {
        this._strategy.addDirectivesMatchingQuery(query, list);
      }
    };
    AppElement.prototype._buildQueryStrategy = function() {
      if (this.proto.protoQueryRefs.length === 0) {
        return _emptyQueryStrategy;
      } else if (this.proto.protoQueryRefs.length <= InlineQueryStrategy.NUMBER_OF_SUPPORTED_QUERIES) {
        return new InlineQueryStrategy(this);
      } else {
        return new DynamicQueryStrategy(this);
      }
    };
    AppElement.prototype.getDirectiveAtIndex = function(index) {
      return this._injector.getAt(index);
    };
    AppElement.prototype.ngAfterViewChecked = function() {
      if (lang_1.isPresent(this._queryStrategy))
        this._queryStrategy.updateViewQueries();
    };
    AppElement.prototype.ngAfterContentChecked = function() {
      if (lang_1.isPresent(this._queryStrategy))
        this._queryStrategy.updateContentQueries();
    };
    AppElement.prototype.traverseAndSetQueriesAsDirty = function() {
      var inj = this;
      while (lang_1.isPresent(inj)) {
        inj._setQueriesAsDirty();
        if (lang_1.isBlank(inj.parent) && inj.parentView.proto.type === view_type_1.ViewType.EMBEDDED) {
          inj = inj.parentView.containerAppElement;
        } else {
          inj = inj.parent;
        }
      }
    };
    AppElement.prototype._setQueriesAsDirty = function() {
      if (lang_1.isPresent(this._queryStrategy)) {
        this._queryStrategy.setContentQueriesAsDirty();
      }
      if (this.parentView.proto.type === view_type_1.ViewType.COMPONENT) {
        this.parentView.containerAppElement._queryStrategy.setViewQueriesAsDirty();
      }
    };
    return AppElement;
  })();
  exports.AppElement = AppElement;
  var _EmptyQueryStrategy = (function() {
    function _EmptyQueryStrategy() {}
    _EmptyQueryStrategy.prototype.setContentQueriesAsDirty = function() {};
    _EmptyQueryStrategy.prototype.setViewQueriesAsDirty = function() {};
    _EmptyQueryStrategy.prototype.updateContentQueries = function() {};
    _EmptyQueryStrategy.prototype.updateViewQueries = function() {};
    _EmptyQueryStrategy.prototype.findQuery = function(query) {
      throw new exceptions_1.BaseException("Cannot find query for directive " + query + ".");
    };
    return _EmptyQueryStrategy;
  })();
  var _emptyQueryStrategy = new _EmptyQueryStrategy();
  var InlineQueryStrategy = (function() {
    function InlineQueryStrategy(ei) {
      var protoRefs = ei.proto.protoQueryRefs;
      if (protoRefs.length > 0)
        this.query0 = new QueryRef(protoRefs[0], ei);
      if (protoRefs.length > 1)
        this.query1 = new QueryRef(protoRefs[1], ei);
      if (protoRefs.length > 2)
        this.query2 = new QueryRef(protoRefs[2], ei);
    }
    InlineQueryStrategy.prototype.setContentQueriesAsDirty = function() {
      if (lang_1.isPresent(this.query0) && !this.query0.isViewQuery)
        this.query0.dirty = true;
      if (lang_1.isPresent(this.query1) && !this.query1.isViewQuery)
        this.query1.dirty = true;
      if (lang_1.isPresent(this.query2) && !this.query2.isViewQuery)
        this.query2.dirty = true;
    };
    InlineQueryStrategy.prototype.setViewQueriesAsDirty = function() {
      if (lang_1.isPresent(this.query0) && this.query0.isViewQuery)
        this.query0.dirty = true;
      if (lang_1.isPresent(this.query1) && this.query1.isViewQuery)
        this.query1.dirty = true;
      if (lang_1.isPresent(this.query2) && this.query2.isViewQuery)
        this.query2.dirty = true;
    };
    InlineQueryStrategy.prototype.updateContentQueries = function() {
      if (lang_1.isPresent(this.query0) && !this.query0.isViewQuery) {
        this.query0.update();
      }
      if (lang_1.isPresent(this.query1) && !this.query1.isViewQuery) {
        this.query1.update();
      }
      if (lang_1.isPresent(this.query2) && !this.query2.isViewQuery) {
        this.query2.update();
      }
    };
    InlineQueryStrategy.prototype.updateViewQueries = function() {
      if (lang_1.isPresent(this.query0) && this.query0.isViewQuery) {
        this.query0.update();
      }
      if (lang_1.isPresent(this.query1) && this.query1.isViewQuery) {
        this.query1.update();
      }
      if (lang_1.isPresent(this.query2) && this.query2.isViewQuery) {
        this.query2.update();
      }
    };
    InlineQueryStrategy.prototype.findQuery = function(query) {
      if (lang_1.isPresent(this.query0) && this.query0.protoQueryRef.query === query) {
        return this.query0;
      }
      if (lang_1.isPresent(this.query1) && this.query1.protoQueryRef.query === query) {
        return this.query1;
      }
      if (lang_1.isPresent(this.query2) && this.query2.protoQueryRef.query === query) {
        return this.query2;
      }
      throw new exceptions_1.BaseException("Cannot find query for directive " + query + ".");
    };
    InlineQueryStrategy.NUMBER_OF_SUPPORTED_QUERIES = 3;
    return InlineQueryStrategy;
  })();
  var DynamicQueryStrategy = (function() {
    function DynamicQueryStrategy(ei) {
      this.queries = ei.proto.protoQueryRefs.map(function(p) {
        return new QueryRef(p, ei);
      });
    }
    DynamicQueryStrategy.prototype.setContentQueriesAsDirty = function() {
      for (var i = 0; i < this.queries.length; ++i) {
        var q = this.queries[i];
        if (!q.isViewQuery)
          q.dirty = true;
      }
    };
    DynamicQueryStrategy.prototype.setViewQueriesAsDirty = function() {
      for (var i = 0; i < this.queries.length; ++i) {
        var q = this.queries[i];
        if (q.isViewQuery)
          q.dirty = true;
      }
    };
    DynamicQueryStrategy.prototype.updateContentQueries = function() {
      for (var i = 0; i < this.queries.length; ++i) {
        var q = this.queries[i];
        if (!q.isViewQuery) {
          q.update();
        }
      }
    };
    DynamicQueryStrategy.prototype.updateViewQueries = function() {
      for (var i = 0; i < this.queries.length; ++i) {
        var q = this.queries[i];
        if (q.isViewQuery) {
          q.update();
        }
      }
    };
    DynamicQueryStrategy.prototype.findQuery = function(query) {
      for (var i = 0; i < this.queries.length; ++i) {
        var q = this.queries[i];
        if (q.protoQueryRef.query === query) {
          return q;
        }
      }
      throw new exceptions_1.BaseException("Cannot find query for directive " + query + ".");
    };
    return DynamicQueryStrategy;
  })();
  var ElementDirectiveInlineStrategy = (function() {
    function ElementDirectiveInlineStrategy(injectorStrategy, _ei) {
      this.injectorStrategy = injectorStrategy;
      this._ei = _ei;
    }
    ElementDirectiveInlineStrategy.prototype.init = function() {
      var i = this.injectorStrategy;
      var p = i.protoStrategy;
      i.resetConstructionCounter();
      if (p.provider0 instanceof DirectiveProvider && lang_1.isPresent(p.keyId0) && i.obj0 === injector_1.UNDEFINED)
        i.obj0 = i.instantiateProvider(p.provider0, p.visibility0);
      if (p.provider1 instanceof DirectiveProvider && lang_1.isPresent(p.keyId1) && i.obj1 === injector_1.UNDEFINED)
        i.obj1 = i.instantiateProvider(p.provider1, p.visibility1);
      if (p.provider2 instanceof DirectiveProvider && lang_1.isPresent(p.keyId2) && i.obj2 === injector_1.UNDEFINED)
        i.obj2 = i.instantiateProvider(p.provider2, p.visibility2);
      if (p.provider3 instanceof DirectiveProvider && lang_1.isPresent(p.keyId3) && i.obj3 === injector_1.UNDEFINED)
        i.obj3 = i.instantiateProvider(p.provider3, p.visibility3);
      if (p.provider4 instanceof DirectiveProvider && lang_1.isPresent(p.keyId4) && i.obj4 === injector_1.UNDEFINED)
        i.obj4 = i.instantiateProvider(p.provider4, p.visibility4);
      if (p.provider5 instanceof DirectiveProvider && lang_1.isPresent(p.keyId5) && i.obj5 === injector_1.UNDEFINED)
        i.obj5 = i.instantiateProvider(p.provider5, p.visibility5);
      if (p.provider6 instanceof DirectiveProvider && lang_1.isPresent(p.keyId6) && i.obj6 === injector_1.UNDEFINED)
        i.obj6 = i.instantiateProvider(p.provider6, p.visibility6);
      if (p.provider7 instanceof DirectiveProvider && lang_1.isPresent(p.keyId7) && i.obj7 === injector_1.UNDEFINED)
        i.obj7 = i.instantiateProvider(p.provider7, p.visibility7);
      if (p.provider8 instanceof DirectiveProvider && lang_1.isPresent(p.keyId8) && i.obj8 === injector_1.UNDEFINED)
        i.obj8 = i.instantiateProvider(p.provider8, p.visibility8);
      if (p.provider9 instanceof DirectiveProvider && lang_1.isPresent(p.keyId9) && i.obj9 === injector_1.UNDEFINED)
        i.obj9 = i.instantiateProvider(p.provider9, p.visibility9);
    };
    ElementDirectiveInlineStrategy.prototype.getComponent = function() {
      return this.injectorStrategy.obj0;
    };
    ElementDirectiveInlineStrategy.prototype.isComponentKey = function(key) {
      return this._ei.proto.firstProviderIsComponent && lang_1.isPresent(key) && key.id === this.injectorStrategy.protoStrategy.keyId0;
    };
    ElementDirectiveInlineStrategy.prototype.addDirectivesMatchingQuery = function(query, list) {
      var i = this.injectorStrategy;
      var p = i.protoStrategy;
      if (lang_1.isPresent(p.provider0) && p.provider0.key.token === query.selector) {
        if (i.obj0 === injector_1.UNDEFINED)
          i.obj0 = i.instantiateProvider(p.provider0, p.visibility0);
        list.push(i.obj0);
      }
      if (lang_1.isPresent(p.provider1) && p.provider1.key.token === query.selector) {
        if (i.obj1 === injector_1.UNDEFINED)
          i.obj1 = i.instantiateProvider(p.provider1, p.visibility1);
        list.push(i.obj1);
      }
      if (lang_1.isPresent(p.provider2) && p.provider2.key.token === query.selector) {
        if (i.obj2 === injector_1.UNDEFINED)
          i.obj2 = i.instantiateProvider(p.provider2, p.visibility2);
        list.push(i.obj2);
      }
      if (lang_1.isPresent(p.provider3) && p.provider3.key.token === query.selector) {
        if (i.obj3 === injector_1.UNDEFINED)
          i.obj3 = i.instantiateProvider(p.provider3, p.visibility3);
        list.push(i.obj3);
      }
      if (lang_1.isPresent(p.provider4) && p.provider4.key.token === query.selector) {
        if (i.obj4 === injector_1.UNDEFINED)
          i.obj4 = i.instantiateProvider(p.provider4, p.visibility4);
        list.push(i.obj4);
      }
      if (lang_1.isPresent(p.provider5) && p.provider5.key.token === query.selector) {
        if (i.obj5 === injector_1.UNDEFINED)
          i.obj5 = i.instantiateProvider(p.provider5, p.visibility5);
        list.push(i.obj5);
      }
      if (lang_1.isPresent(p.provider6) && p.provider6.key.token === query.selector) {
        if (i.obj6 === injector_1.UNDEFINED)
          i.obj6 = i.instantiateProvider(p.provider6, p.visibility6);
        list.push(i.obj6);
      }
      if (lang_1.isPresent(p.provider7) && p.provider7.key.token === query.selector) {
        if (i.obj7 === injector_1.UNDEFINED)
          i.obj7 = i.instantiateProvider(p.provider7, p.visibility7);
        list.push(i.obj7);
      }
      if (lang_1.isPresent(p.provider8) && p.provider8.key.token === query.selector) {
        if (i.obj8 === injector_1.UNDEFINED)
          i.obj8 = i.instantiateProvider(p.provider8, p.visibility8);
        list.push(i.obj8);
      }
      if (lang_1.isPresent(p.provider9) && p.provider9.key.token === query.selector) {
        if (i.obj9 === injector_1.UNDEFINED)
          i.obj9 = i.instantiateProvider(p.provider9, p.visibility9);
        list.push(i.obj9);
      }
    };
    return ElementDirectiveInlineStrategy;
  })();
  var ElementDirectiveDynamicStrategy = (function() {
    function ElementDirectiveDynamicStrategy(injectorStrategy, _ei) {
      this.injectorStrategy = injectorStrategy;
      this._ei = _ei;
    }
    ElementDirectiveDynamicStrategy.prototype.init = function() {
      var inj = this.injectorStrategy;
      var p = inj.protoStrategy;
      inj.resetConstructionCounter();
      for (var i = 0; i < p.keyIds.length; i++) {
        if (p.providers[i] instanceof DirectiveProvider && lang_1.isPresent(p.keyIds[i]) && inj.objs[i] === injector_1.UNDEFINED) {
          inj.objs[i] = inj.instantiateProvider(p.providers[i], p.visibilities[i]);
        }
      }
    };
    ElementDirectiveDynamicStrategy.prototype.getComponent = function() {
      return this.injectorStrategy.objs[0];
    };
    ElementDirectiveDynamicStrategy.prototype.isComponentKey = function(key) {
      var p = this.injectorStrategy.protoStrategy;
      return this._ei.proto.firstProviderIsComponent && lang_1.isPresent(key) && key.id === p.keyIds[0];
    };
    ElementDirectiveDynamicStrategy.prototype.addDirectivesMatchingQuery = function(query, list) {
      var ist = this.injectorStrategy;
      var p = ist.protoStrategy;
      for (var i = 0; i < p.providers.length; i++) {
        if (p.providers[i].key.token === query.selector) {
          if (ist.objs[i] === injector_1.UNDEFINED) {
            ist.objs[i] = ist.instantiateProvider(p.providers[i], p.visibilities[i]);
          }
          list.push(ist.objs[i]);
        }
      }
    };
    return ElementDirectiveDynamicStrategy;
  })();
  var ProtoQueryRef = (function() {
    function ProtoQueryRef(dirIndex, setter, query) {
      this.dirIndex = dirIndex;
      this.setter = setter;
      this.query = query;
    }
    Object.defineProperty(ProtoQueryRef.prototype, "usesPropertySyntax", {
      get: function() {
        return lang_1.isPresent(this.setter);
      },
      enumerable: true,
      configurable: true
    });
    return ProtoQueryRef;
  })();
  exports.ProtoQueryRef = ProtoQueryRef;
  var QueryRef = (function() {
    function QueryRef(protoQueryRef, originator) {
      this.protoQueryRef = protoQueryRef;
      this.originator = originator;
      this.list = new query_list_1.QueryList();
      this.dirty = true;
    }
    Object.defineProperty(QueryRef.prototype, "isViewQuery", {
      get: function() {
        return this.protoQueryRef.query.isViewQuery;
      },
      enumerable: true,
      configurable: true
    });
    QueryRef.prototype.update = function() {
      if (!this.dirty)
        return ;
      this._update();
      this.dirty = false;
      if (this.protoQueryRef.usesPropertySyntax) {
        var dir = this.originator.getDirectiveAtIndex(this.protoQueryRef.dirIndex);
        if (this.protoQueryRef.query.first) {
          this.protoQueryRef.setter(dir, this.list.length > 0 ? this.list.first : null);
        } else {
          this.protoQueryRef.setter(dir, this.list);
        }
      }
      this.list.notifyOnChanges();
    };
    QueryRef.prototype._update = function() {
      var aggregator = [];
      if (this.protoQueryRef.query.isViewQuery) {
        var nestedView = this.originator.componentView;
        if (lang_1.isPresent(nestedView))
          this._visitView(nestedView, aggregator);
      } else {
        this._visit(this.originator, aggregator);
      }
      this.list.reset(aggregator);
    };
    ;
    QueryRef.prototype._visit = function(inj, aggregator) {
      var view = inj.parentView;
      var startIdx = inj.proto.index;
      for (var i = startIdx; i < view.appElements.length; i++) {
        var curInj = view.appElements[i];
        if (i > startIdx && (lang_1.isBlank(curInj.parent) || curInj.parent.proto.index < startIdx)) {
          break;
        }
        if (!this.protoQueryRef.query.descendants && !(curInj.parent == this.originator || curInj == this.originator))
          continue;
        this._visitInjector(curInj, aggregator);
        this._visitViewContainerViews(curInj.nestedViews, aggregator);
      }
    };
    QueryRef.prototype._visitInjector = function(inj, aggregator) {
      if (this.protoQueryRef.query.isVarBindingQuery) {
        this._aggregateVariableBinding(inj, aggregator);
      } else {
        this._aggregateDirective(inj, aggregator);
      }
    };
    QueryRef.prototype._visitViewContainerViews = function(views, aggregator) {
      if (lang_1.isPresent(views)) {
        for (var j = 0; j < views.length; j++) {
          this._visitView(views[j], aggregator);
        }
      }
    };
    QueryRef.prototype._visitView = function(view, aggregator) {
      for (var i = 0; i < view.appElements.length; i++) {
        var inj = view.appElements[i];
        this._visitInjector(inj, aggregator);
        this._visitViewContainerViews(inj.nestedViews, aggregator);
      }
    };
    QueryRef.prototype._aggregateVariableBinding = function(inj, aggregator) {
      var vb = this.protoQueryRef.query.varBindings;
      for (var i = 0; i < vb.length; ++i) {
        if (inj.hasVariableBinding(vb[i])) {
          aggregator.push(inj.getVariableBinding(vb[i]));
        }
      }
    };
    QueryRef.prototype._aggregateDirective = function(inj, aggregator) {
      inj.addDirectivesMatchingQuery(this.protoQueryRef.query, aggregator);
    };
    return QueryRef;
  })();
  exports.QueryRef = QueryRef;
  var _ComponentViewChangeDetectorRef = (function(_super) {
    __extends(_ComponentViewChangeDetectorRef, _super);
    function _ComponentViewChangeDetectorRef(_appElement) {
      _super.call(this);
      this._appElement = _appElement;
    }
    _ComponentViewChangeDetectorRef.prototype.markForCheck = function() {
      this._appElement.componentView.changeDetector.ref.markForCheck();
    };
    _ComponentViewChangeDetectorRef.prototype.detach = function() {
      this._appElement.componentView.changeDetector.ref.detach();
    };
    _ComponentViewChangeDetectorRef.prototype.detectChanges = function() {
      this._appElement.componentView.changeDetector.ref.detectChanges();
    };
    _ComponentViewChangeDetectorRef.prototype.checkNoChanges = function() {
      this._appElement.componentView.changeDetector.ref.checkNoChanges();
    };
    _ComponentViewChangeDetectorRef.prototype.reattach = function() {
      this._appElement.componentView.changeDetector.ref.reattach();
    };
    return _ComponentViewChangeDetectorRef;
  })(change_detection_1.ChangeDetectorRef);
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/pipes/pipes", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection", "angular2/src/core/change_detection/pipes"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var cd = require("angular2/src/core/change_detection/pipes");
  var ProtoPipes = (function() {
    function ProtoPipes(config) {
      this.config = config;
      this.config = config;
    }
    ProtoPipes.fromProviders = function(providers) {
      var config = {};
      providers.forEach(function(b) {
        return config[b.name] = b;
      });
      return new ProtoPipes(config);
    };
    ProtoPipes.prototype.get = function(name) {
      var provider = this.config[name];
      if (lang_1.isBlank(provider))
        throw new exceptions_1.BaseException("Cannot find pipe '" + name + "'.");
      return provider;
    };
    return ProtoPipes;
  })();
  exports.ProtoPipes = ProtoPipes;
  var Pipes = (function() {
    function Pipes(proto, injector) {
      this.proto = proto;
      this.injector = injector;
      this._config = {};
    }
    Pipes.prototype.get = function(name) {
      var cached = collection_1.StringMapWrapper.get(this._config, name);
      if (lang_1.isPresent(cached))
        return cached;
      var p = this.proto.get(name);
      var transform = this.injector.instantiateResolved(p);
      var res = new cd.SelectedPipe(transform, p.pure);
      if (p.pure) {
        collection_1.StringMapWrapper.set(this._config, name, res);
      }
      return res;
    };
    return Pipes;
  })();
  exports.Pipes = Pipes;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker", ["angular2/src/core/linker/directive_resolver", "angular2/src/core/linker/view_resolver", "angular2/src/core/linker/compiler", "angular2/src/core/linker/view_manager", "angular2/src/core/linker/query_list", "angular2/src/core/linker/dynamic_component_loader", "angular2/src/core/linker/element_ref", "angular2/src/core/linker/template_ref", "angular2/src/core/linker/view_ref", "angular2/src/core/linker/view_container_ref", "angular2/src/core/linker/dynamic_component_loader"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var directive_resolver_1 = require("angular2/src/core/linker/directive_resolver");
  exports.DirectiveResolver = directive_resolver_1.DirectiveResolver;
  var view_resolver_1 = require("angular2/src/core/linker/view_resolver");
  exports.ViewResolver = view_resolver_1.ViewResolver;
  var compiler_1 = require("angular2/src/core/linker/compiler");
  exports.Compiler = compiler_1.Compiler;
  var view_manager_1 = require("angular2/src/core/linker/view_manager");
  exports.AppViewManager = view_manager_1.AppViewManager;
  var query_list_1 = require("angular2/src/core/linker/query_list");
  exports.QueryList = query_list_1.QueryList;
  var dynamic_component_loader_1 = require("angular2/src/core/linker/dynamic_component_loader");
  exports.DynamicComponentLoader = dynamic_component_loader_1.DynamicComponentLoader;
  var element_ref_1 = require("angular2/src/core/linker/element_ref");
  exports.ElementRef = element_ref_1.ElementRef;
  var template_ref_1 = require("angular2/src/core/linker/template_ref");
  exports.TemplateRef = template_ref_1.TemplateRef;
  var view_ref_1 = require("angular2/src/core/linker/view_ref");
  exports.EmbeddedViewRef = view_ref_1.EmbeddedViewRef;
  exports.HostViewRef = view_ref_1.HostViewRef;
  exports.ViewRef = view_ref_1.ViewRef;
  exports.HostViewFactoryRef = view_ref_1.HostViewFactoryRef;
  var view_container_ref_1 = require("angular2/src/core/linker/view_container_ref");
  exports.ViewContainerRef = view_container_ref_1.ViewContainerRef;
  var dynamic_component_loader_2 = require("angular2/src/core/linker/dynamic_component_loader");
  exports.ComponentRef = dynamic_component_loader_2.ComponentRef;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/resolved_metadata_cache", ["angular2/src/core/di", "angular2/src/facade/lang", "angular2/src/core/linker/element", "angular2/src/core/linker/directive_resolver", "angular2/src/core/pipes/pipe_provider", "angular2/src/core/linker/pipe_resolver"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var di_1 = require("angular2/src/core/di");
  var lang_1 = require("angular2/src/facade/lang");
  var element_1 = require("angular2/src/core/linker/element");
  var directive_resolver_1 = require("angular2/src/core/linker/directive_resolver");
  var pipe_provider_1 = require("angular2/src/core/pipes/pipe_provider");
  var pipe_resolver_1 = require("angular2/src/core/linker/pipe_resolver");
  var ResolvedMetadataCache = (function() {
    function ResolvedMetadataCache(_directiveResolver, _pipeResolver) {
      this._directiveResolver = _directiveResolver;
      this._pipeResolver = _pipeResolver;
      this._directiveCache = new Map();
      this._pipeCache = new Map();
    }
    ResolvedMetadataCache.prototype.getResolvedDirectiveMetadata = function(type) {
      var result = this._directiveCache.get(type);
      if (lang_1.isBlank(result)) {
        result = element_1.DirectiveProvider.createFromType(type, this._directiveResolver.resolve(type));
        this._directiveCache.set(type, result);
      }
      return result;
    };
    ResolvedMetadataCache.prototype.getResolvedPipeMetadata = function(type) {
      var result = this._pipeCache.get(type);
      if (lang_1.isBlank(result)) {
        result = pipe_provider_1.PipeProvider.createFromType(type, this._pipeResolver.resolve(type));
        this._pipeCache.set(type, result);
      }
      return result;
    };
    ResolvedMetadataCache = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [directive_resolver_1.DirectiveResolver, pipe_resolver_1.PipeResolver])], ResolvedMetadataCache);
    return ResolvedMetadataCache;
  })();
  exports.ResolvedMetadataCache = ResolvedMetadataCache;
  exports.CODEGEN_RESOLVED_METADATA_CACHE = new ResolvedMetadataCache(directive_resolver_1.CODEGEN_DIRECTIVE_RESOLVER, pipe_resolver_1.CODEGEN_PIPE_RESOLVER);
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/dom/debug/ng_probe", ["angular2/src/facade/lang", "angular2/src/core/di", "angular2/src/platform/dom/dom_adapter", "angular2/src/core/debug/debug_node", "angular2/src/platform/dom/dom_renderer", "angular2/core", "angular2/src/core/debug/debug_renderer"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var di_1 = require("angular2/src/core/di");
  var dom_adapter_1 = require("angular2/src/platform/dom/dom_adapter");
  var debug_node_1 = require("angular2/src/core/debug/debug_node");
  var dom_renderer_1 = require("angular2/src/platform/dom/dom_renderer");
  var core_1 = require("angular2/core");
  var debug_renderer_1 = require("angular2/src/core/debug/debug_renderer");
  var INSPECT_GLOBAL_NAME = 'ng.probe';
  function inspectNativeElement(element) {
    return debug_node_1.getDebugNode(element);
  }
  exports.inspectNativeElement = inspectNativeElement;
  function _createConditionalRootRenderer(rootRenderer) {
    if (lang_1.assertionsEnabled()) {
      return _createRootRenderer(rootRenderer);
    }
    return rootRenderer;
  }
  function _createRootRenderer(rootRenderer) {
    dom_adapter_1.DOM.setGlobalVar(INSPECT_GLOBAL_NAME, inspectNativeElement);
    return new debug_renderer_1.DebugDomRootRenderer(rootRenderer);
  }
  exports.ELEMENT_PROBE_PROVIDERS = lang_1.CONST_EXPR([new di_1.Provider(core_1.RootRenderer, {
    useFactory: _createConditionalRootRenderer,
    deps: [dom_renderer_1.DomRootRenderer]
  })]);
  exports.ELEMENT_PROBE_PROVIDERS_PROD_MODE = lang_1.CONST_EXPR([new di_1.Provider(core_1.RootRenderer, {
    useFactory: _createRootRenderer,
    deps: [dom_renderer_1.DomRootRenderer]
  })]);
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/di/provider", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection", "angular2/src/core/reflection/reflection", "angular2/src/core/di/key", "angular2/src/core/di/metadata", "angular2/src/core/di/exceptions", "angular2/src/core/di/forward_ref"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var reflection_1 = require("angular2/src/core/reflection/reflection");
  var key_1 = require("angular2/src/core/di/key");
  var metadata_1 = require("angular2/src/core/di/metadata");
  var exceptions_2 = require("angular2/src/core/di/exceptions");
  var forward_ref_1 = require("angular2/src/core/di/forward_ref");
  var Dependency = (function() {
    function Dependency(key, optional, lowerBoundVisibility, upperBoundVisibility, properties) {
      this.key = key;
      this.optional = optional;
      this.lowerBoundVisibility = lowerBoundVisibility;
      this.upperBoundVisibility = upperBoundVisibility;
      this.properties = properties;
    }
    Dependency.fromKey = function(key) {
      return new Dependency(key, false, null, null, []);
    };
    return Dependency;
  })();
  exports.Dependency = Dependency;
  var _EMPTY_LIST = lang_1.CONST_EXPR([]);
  var Provider = (function() {
    function Provider(token, _a) {
      var useClass = _a.useClass,
          useValue = _a.useValue,
          useExisting = _a.useExisting,
          useFactory = _a.useFactory,
          deps = _a.deps,
          multi = _a.multi;
      this.token = token;
      this.useClass = useClass;
      this.useValue = useValue;
      this.useExisting = useExisting;
      this.useFactory = useFactory;
      this.dependencies = deps;
      this._multi = multi;
    }
    Object.defineProperty(Provider.prototype, "multi", {
      get: function() {
        return lang_1.normalizeBool(this._multi);
      },
      enumerable: true,
      configurable: true
    });
    Provider = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [Object, Object])], Provider);
    return Provider;
  })();
  exports.Provider = Provider;
  var Binding = (function(_super) {
    __extends(Binding, _super);
    function Binding(token, _a) {
      var toClass = _a.toClass,
          toValue = _a.toValue,
          toAlias = _a.toAlias,
          toFactory = _a.toFactory,
          deps = _a.deps,
          multi = _a.multi;
      _super.call(this, token, {
        useClass: toClass,
        useValue: toValue,
        useExisting: toAlias,
        useFactory: toFactory,
        deps: deps,
        multi: multi
      });
    }
    Object.defineProperty(Binding.prototype, "toClass", {
      get: function() {
        return this.useClass;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(Binding.prototype, "toAlias", {
      get: function() {
        return this.useExisting;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(Binding.prototype, "toFactory", {
      get: function() {
        return this.useFactory;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(Binding.prototype, "toValue", {
      get: function() {
        return this.useValue;
      },
      enumerable: true,
      configurable: true
    });
    Binding = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [Object, Object])], Binding);
    return Binding;
  })(Provider);
  exports.Binding = Binding;
  var ResolvedProvider_ = (function() {
    function ResolvedProvider_(key, resolvedFactories, multiProvider) {
      this.key = key;
      this.resolvedFactories = resolvedFactories;
      this.multiProvider = multiProvider;
    }
    Object.defineProperty(ResolvedProvider_.prototype, "resolvedFactory", {
      get: function() {
        return this.resolvedFactories[0];
      },
      enumerable: true,
      configurable: true
    });
    return ResolvedProvider_;
  })();
  exports.ResolvedProvider_ = ResolvedProvider_;
  var ResolvedFactory = (function() {
    function ResolvedFactory(factory, dependencies) {
      this.factory = factory;
      this.dependencies = dependencies;
    }
    return ResolvedFactory;
  })();
  exports.ResolvedFactory = ResolvedFactory;
  function bind(token) {
    return new ProviderBuilder(token);
  }
  exports.bind = bind;
  function provide(token, _a) {
    var useClass = _a.useClass,
        useValue = _a.useValue,
        useExisting = _a.useExisting,
        useFactory = _a.useFactory,
        deps = _a.deps,
        multi = _a.multi;
    return new Provider(token, {
      useClass: useClass,
      useValue: useValue,
      useExisting: useExisting,
      useFactory: useFactory,
      deps: deps,
      multi: multi
    });
  }
  exports.provide = provide;
  var ProviderBuilder = (function() {
    function ProviderBuilder(token) {
      this.token = token;
    }
    ProviderBuilder.prototype.toClass = function(type) {
      if (!lang_1.isType(type)) {
        throw new exceptions_1.BaseException("Trying to create a class provider but \"" + lang_1.stringify(type) + "\" is not a class!");
      }
      return new Provider(this.token, {useClass: type});
    };
    ProviderBuilder.prototype.toValue = function(value) {
      return new Provider(this.token, {useValue: value});
    };
    ProviderBuilder.prototype.toAlias = function(aliasToken) {
      if (lang_1.isBlank(aliasToken)) {
        throw new exceptions_1.BaseException("Can not alias " + lang_1.stringify(this.token) + " to a blank value!");
      }
      return new Provider(this.token, {useExisting: aliasToken});
    };
    ProviderBuilder.prototype.toFactory = function(factory, dependencies) {
      if (!lang_1.isFunction(factory)) {
        throw new exceptions_1.BaseException("Trying to create a factory provider but \"" + lang_1.stringify(factory) + "\" is not a function!");
      }
      return new Provider(this.token, {
        useFactory: factory,
        deps: dependencies
      });
    };
    return ProviderBuilder;
  })();
  exports.ProviderBuilder = ProviderBuilder;
  function resolveFactory(provider) {
    var factoryFn;
    var resolvedDeps;
    if (lang_1.isPresent(provider.useClass)) {
      var useClass = forward_ref_1.resolveForwardRef(provider.useClass);
      factoryFn = reflection_1.reflector.factory(useClass);
      resolvedDeps = _dependenciesFor(useClass);
    } else if (lang_1.isPresent(provider.useExisting)) {
      factoryFn = function(aliasInstance) {
        return aliasInstance;
      };
      resolvedDeps = [Dependency.fromKey(key_1.Key.get(provider.useExisting))];
    } else if (lang_1.isPresent(provider.useFactory)) {
      factoryFn = provider.useFactory;
      resolvedDeps = _constructDependencies(provider.useFactory, provider.dependencies);
    } else {
      factoryFn = function() {
        return provider.useValue;
      };
      resolvedDeps = _EMPTY_LIST;
    }
    return new ResolvedFactory(factoryFn, resolvedDeps);
  }
  exports.resolveFactory = resolveFactory;
  function resolveProvider(provider) {
    return new ResolvedProvider_(key_1.Key.get(provider.token), [resolveFactory(provider)], provider.multi);
  }
  exports.resolveProvider = resolveProvider;
  function resolveProviders(providers) {
    var normalized = _normalizeProviders(providers, []);
    var resolved = normalized.map(resolveProvider);
    return collection_1.MapWrapper.values(mergeResolvedProviders(resolved, new Map()));
  }
  exports.resolveProviders = resolveProviders;
  function mergeResolvedProviders(providers, normalizedProvidersMap) {
    for (var i = 0; i < providers.length; i++) {
      var provider = providers[i];
      var existing = normalizedProvidersMap.get(provider.key.id);
      if (lang_1.isPresent(existing)) {
        if (provider.multiProvider !== existing.multiProvider) {
          throw new exceptions_2.MixingMultiProvidersWithRegularProvidersError(existing, provider);
        }
        if (provider.multiProvider) {
          for (var j = 0; j < provider.resolvedFactories.length; j++) {
            existing.resolvedFactories.push(provider.resolvedFactories[j]);
          }
        } else {
          normalizedProvidersMap.set(provider.key.id, provider);
        }
      } else {
        var resolvedProvider;
        if (provider.multiProvider) {
          resolvedProvider = new ResolvedProvider_(provider.key, collection_1.ListWrapper.clone(provider.resolvedFactories), provider.multiProvider);
        } else {
          resolvedProvider = provider;
        }
        normalizedProvidersMap.set(provider.key.id, resolvedProvider);
      }
    }
    return normalizedProvidersMap;
  }
  exports.mergeResolvedProviders = mergeResolvedProviders;
  function _normalizeProviders(providers, res) {
    providers.forEach(function(b) {
      if (b instanceof lang_1.Type) {
        res.push(provide(b, {useClass: b}));
      } else if (b instanceof Provider) {
        res.push(b);
      } else if (b instanceof Array) {
        _normalizeProviders(b, res);
      } else if (b instanceof ProviderBuilder) {
        throw new exceptions_2.InvalidProviderError(b.token);
      } else {
        throw new exceptions_2.InvalidProviderError(b);
      }
    });
    return res;
  }
  function _constructDependencies(factoryFunction, dependencies) {
    if (lang_1.isBlank(dependencies)) {
      return _dependenciesFor(factoryFunction);
    } else {
      var params = dependencies.map(function(t) {
        return [t];
      });
      return dependencies.map(function(t) {
        return _extractToken(factoryFunction, t, params);
      });
    }
  }
  function _dependenciesFor(typeOrFunc) {
    var params = reflection_1.reflector.parameters(typeOrFunc);
    if (lang_1.isBlank(params))
      return [];
    if (params.some(lang_1.isBlank)) {
      throw new exceptions_2.NoAnnotationError(typeOrFunc, params);
    }
    return params.map(function(p) {
      return _extractToken(typeOrFunc, p, params);
    });
  }
  function _extractToken(typeOrFunc, metadata, params) {
    var depProps = [];
    var token = null;
    var optional = false;
    if (!lang_1.isArray(metadata)) {
      if (metadata instanceof metadata_1.InjectMetadata) {
        return _createDependency(metadata.token, optional, null, null, depProps);
      } else {
        return _createDependency(metadata, optional, null, null, depProps);
      }
    }
    var lowerBoundVisibility = null;
    var upperBoundVisibility = null;
    for (var i = 0; i < metadata.length; ++i) {
      var paramMetadata = metadata[i];
      if (paramMetadata instanceof lang_1.Type) {
        token = paramMetadata;
      } else if (paramMetadata instanceof metadata_1.InjectMetadata) {
        token = paramMetadata.token;
      } else if (paramMetadata instanceof metadata_1.OptionalMetadata) {
        optional = true;
      } else if (paramMetadata instanceof metadata_1.SelfMetadata) {
        upperBoundVisibility = paramMetadata;
      } else if (paramMetadata instanceof metadata_1.HostMetadata) {
        upperBoundVisibility = paramMetadata;
      } else if (paramMetadata instanceof metadata_1.SkipSelfMetadata) {
        lowerBoundVisibility = paramMetadata;
      } else if (paramMetadata instanceof metadata_1.DependencyMetadata) {
        if (lang_1.isPresent(paramMetadata.token)) {
          token = paramMetadata.token;
        }
        depProps.push(paramMetadata);
      }
    }
    token = forward_ref_1.resolveForwardRef(token);
    if (lang_1.isPresent(token)) {
      return _createDependency(token, optional, lowerBoundVisibility, upperBoundVisibility, depProps);
    } else {
      throw new exceptions_2.NoAnnotationError(typeOrFunc, params);
    }
  }
  function _createDependency(token, optional, lowerBoundVisibility, upperBoundVisibility, depProps) {
    return new Dependency(key_1.Key.get(token), optional, lowerBoundVisibility, upperBoundVisibility, depProps);
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/animate/css_animation_builder", ["angular2/src/animate/css_animation_options", "angular2/src/animate/animation"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var css_animation_options_1 = require("angular2/src/animate/css_animation_options");
  var animation_1 = require("angular2/src/animate/animation");
  var CssAnimationBuilder = (function() {
    function CssAnimationBuilder(browserDetails) {
      this.browserDetails = browserDetails;
      this.data = new css_animation_options_1.CssAnimationOptions();
    }
    CssAnimationBuilder.prototype.addAnimationClass = function(className) {
      this.data.animationClasses.push(className);
      return this;
    };
    CssAnimationBuilder.prototype.addClass = function(className) {
      this.data.classesToAdd.push(className);
      return this;
    };
    CssAnimationBuilder.prototype.removeClass = function(className) {
      this.data.classesToRemove.push(className);
      return this;
    };
    CssAnimationBuilder.prototype.setDuration = function(duration) {
      this.data.duration = duration;
      return this;
    };
    CssAnimationBuilder.prototype.setDelay = function(delay) {
      this.data.delay = delay;
      return this;
    };
    CssAnimationBuilder.prototype.setStyles = function(from, to) {
      return this.setFromStyles(from).setToStyles(to);
    };
    CssAnimationBuilder.prototype.setFromStyles = function(from) {
      this.data.fromStyles = from;
      return this;
    };
    CssAnimationBuilder.prototype.setToStyles = function(to) {
      this.data.toStyles = to;
      return this;
    };
    CssAnimationBuilder.prototype.start = function(element) {
      return new animation_1.Animation(element, this.data, this.browserDetails);
    };
    return CssAnimationBuilder;
  })();
  exports.CssAnimationBuilder = CssAnimationBuilder;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/dynamic_change_detector", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection", "angular2/src/core/change_detection/abstract_change_detector", "angular2/src/core/change_detection/change_detection_util", "angular2/src/core/change_detection/constants", "angular2/src/core/change_detection/proto_record", "angular2/src/core/reflection/reflection", "angular2/src/facade/async"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var abstract_change_detector_1 = require("angular2/src/core/change_detection/abstract_change_detector");
  var change_detection_util_1 = require("angular2/src/core/change_detection/change_detection_util");
  var constants_1 = require("angular2/src/core/change_detection/constants");
  var proto_record_1 = require("angular2/src/core/change_detection/proto_record");
  var reflection_1 = require("angular2/src/core/reflection/reflection");
  var async_1 = require("angular2/src/facade/async");
  var DynamicChangeDetector = (function(_super) {
    __extends(DynamicChangeDetector, _super);
    function DynamicChangeDetector(id, numberOfPropertyProtoRecords, propertyBindingTargets, directiveIndices, strategy, _records, _eventBindings, _directiveRecords, _genConfig) {
      _super.call(this, id, numberOfPropertyProtoRecords, propertyBindingTargets, directiveIndices, strategy);
      this._records = _records;
      this._eventBindings = _eventBindings;
      this._directiveRecords = _directiveRecords;
      this._genConfig = _genConfig;
      var len = _records.length + 1;
      this.values = collection_1.ListWrapper.createFixedSize(len);
      this.localPipes = collection_1.ListWrapper.createFixedSize(len);
      this.prevContexts = collection_1.ListWrapper.createFixedSize(len);
      this.changes = collection_1.ListWrapper.createFixedSize(len);
      this.dehydrateDirectives(false);
    }
    DynamicChangeDetector.prototype.handleEventInternal = function(eventName, elIndex, locals) {
      var _this = this;
      var preventDefault = false;
      this._matchingEventBindings(eventName, elIndex).forEach(function(rec) {
        var res = _this._processEventBinding(rec, locals);
        if (res === false) {
          preventDefault = true;
        }
      });
      return preventDefault;
    };
    DynamicChangeDetector.prototype._processEventBinding = function(eb, locals) {
      var values = collection_1.ListWrapper.createFixedSize(eb.records.length);
      values[0] = this.values[0];
      for (var protoIdx = 0; protoIdx < eb.records.length; ++protoIdx) {
        var proto = eb.records[protoIdx];
        if (proto.isSkipRecord()) {
          protoIdx += this._computeSkipLength(protoIdx, proto, values);
        } else {
          var res = this._calculateCurrValue(proto, values, locals);
          if (proto.lastInBinding) {
            this._markPathAsCheckOnce(proto);
            return res;
          } else {
            this._writeSelf(proto, res, values);
          }
        }
      }
      throw new exceptions_1.BaseException("Cannot be reached");
    };
    DynamicChangeDetector.prototype._computeSkipLength = function(protoIndex, proto, values) {
      if (proto.mode === proto_record_1.RecordType.SkipRecords) {
        return proto.fixedArgs[0] - protoIndex - 1;
      }
      if (proto.mode === proto_record_1.RecordType.SkipRecordsIf) {
        var condition = this._readContext(proto, values);
        return condition ? proto.fixedArgs[0] - protoIndex - 1 : 0;
      }
      if (proto.mode === proto_record_1.RecordType.SkipRecordsIfNot) {
        var condition = this._readContext(proto, values);
        return condition ? 0 : proto.fixedArgs[0] - protoIndex - 1;
      }
      throw new exceptions_1.BaseException("Cannot be reached");
    };
    DynamicChangeDetector.prototype._markPathAsCheckOnce = function(proto) {
      if (!proto.bindingRecord.isDefaultChangeDetection()) {
        var dir = proto.bindingRecord.directiveRecord;
        this._getDetectorFor(dir.directiveIndex).markPathToRootAsCheckOnce();
      }
    };
    DynamicChangeDetector.prototype._matchingEventBindings = function(eventName, elIndex) {
      return this._eventBindings.filter(function(eb) {
        return eb.eventName == eventName && eb.elIndex === elIndex;
      });
    };
    DynamicChangeDetector.prototype.hydrateDirectives = function(dispatcher) {
      var _this = this;
      this.values[0] = this.context;
      this.dispatcher = dispatcher;
      if (this.strategy === constants_1.ChangeDetectionStrategy.OnPushObserve) {
        for (var i = 0; i < this.directiveIndices.length; ++i) {
          var index = this.directiveIndices[i];
          _super.prototype.observeDirective.call(this, this._getDirectiveFor(index), i);
        }
      }
      this.outputSubscriptions = [];
      for (var i = 0; i < this._directiveRecords.length; ++i) {
        var r = this._directiveRecords[i];
        if (lang_1.isPresent(r.outputs)) {
          r.outputs.forEach(function(output) {
            var eventHandler = _this._createEventHandler(r.directiveIndex.elementIndex, output[1]);
            var directive = _this._getDirectiveFor(r.directiveIndex);
            var getter = reflection_1.reflector.getter(output[0]);
            _this.outputSubscriptions.push(async_1.ObservableWrapper.subscribe(getter(directive), eventHandler));
          });
        }
      }
    };
    DynamicChangeDetector.prototype._createEventHandler = function(boundElementIndex, eventName) {
      var _this = this;
      return function(event) {
        return _this.handleEvent(eventName, boundElementIndex, event);
      };
    };
    DynamicChangeDetector.prototype.dehydrateDirectives = function(destroyPipes) {
      if (destroyPipes) {
        this._destroyPipes();
        this._destroyDirectives();
      }
      this.values[0] = null;
      collection_1.ListWrapper.fill(this.values, change_detection_util_1.ChangeDetectionUtil.uninitialized, 1);
      collection_1.ListWrapper.fill(this.changes, false);
      collection_1.ListWrapper.fill(this.localPipes, null);
      collection_1.ListWrapper.fill(this.prevContexts, change_detection_util_1.ChangeDetectionUtil.uninitialized);
    };
    DynamicChangeDetector.prototype._destroyPipes = function() {
      for (var i = 0; i < this.localPipes.length; ++i) {
        if (lang_1.isPresent(this.localPipes[i])) {
          change_detection_util_1.ChangeDetectionUtil.callPipeOnDestroy(this.localPipes[i]);
        }
      }
    };
    DynamicChangeDetector.prototype._destroyDirectives = function() {
      for (var i = 0; i < this._directiveRecords.length; ++i) {
        var record = this._directiveRecords[i];
        if (record.callOnDestroy) {
          this._getDirectiveFor(record.directiveIndex).ngOnDestroy();
        }
      }
    };
    DynamicChangeDetector.prototype.checkNoChanges = function() {
      this.runDetectChanges(true);
    };
    DynamicChangeDetector.prototype.detectChangesInRecordsInternal = function(throwOnChange) {
      var protos = this._records;
      var changes = null;
      var isChanged = false;
      for (var protoIdx = 0; protoIdx < protos.length; ++protoIdx) {
        var proto = protos[protoIdx];
        var bindingRecord = proto.bindingRecord;
        var directiveRecord = bindingRecord.directiveRecord;
        if (this._firstInBinding(proto)) {
          this.propertyBindingIndex = proto.propertyBindingIndex;
        }
        if (proto.isLifeCycleRecord()) {
          if (proto.name === "DoCheck" && !throwOnChange) {
            this._getDirectiveFor(directiveRecord.directiveIndex).ngDoCheck();
          } else if (proto.name === "OnInit" && !throwOnChange && this.state == constants_1.ChangeDetectorState.NeverChecked) {
            this._getDirectiveFor(directiveRecord.directiveIndex).ngOnInit();
          } else if (proto.name === "OnChanges" && lang_1.isPresent(changes) && !throwOnChange) {
            this._getDirectiveFor(directiveRecord.directiveIndex).ngOnChanges(changes);
          }
        } else if (proto.isSkipRecord()) {
          protoIdx += this._computeSkipLength(protoIdx, proto, this.values);
        } else {
          var change = this._check(proto, throwOnChange, this.values, this.locals);
          if (lang_1.isPresent(change)) {
            this._updateDirectiveOrElement(change, bindingRecord);
            isChanged = true;
            changes = this._addChange(bindingRecord, change, changes);
          }
        }
        if (proto.lastInDirective) {
          changes = null;
          if (isChanged && !bindingRecord.isDefaultChangeDetection()) {
            this._getDetectorFor(directiveRecord.directiveIndex).markAsCheckOnce();
          }
          isChanged = false;
        }
      }
    };
    DynamicChangeDetector.prototype._firstInBinding = function(r) {
      var prev = change_detection_util_1.ChangeDetectionUtil.protoByIndex(this._records, r.selfIndex - 1);
      return lang_1.isBlank(prev) || prev.bindingRecord !== r.bindingRecord;
    };
    DynamicChangeDetector.prototype.afterContentLifecycleCallbacksInternal = function() {
      var dirs = this._directiveRecords;
      for (var i = dirs.length - 1; i >= 0; --i) {
        var dir = dirs[i];
        if (dir.callAfterContentInit && this.state == constants_1.ChangeDetectorState.NeverChecked) {
          this._getDirectiveFor(dir.directiveIndex).ngAfterContentInit();
        }
        if (dir.callAfterContentChecked) {
          this._getDirectiveFor(dir.directiveIndex).ngAfterContentChecked();
        }
      }
    };
    DynamicChangeDetector.prototype.afterViewLifecycleCallbacksInternal = function() {
      var dirs = this._directiveRecords;
      for (var i = dirs.length - 1; i >= 0; --i) {
        var dir = dirs[i];
        if (dir.callAfterViewInit && this.state == constants_1.ChangeDetectorState.NeverChecked) {
          this._getDirectiveFor(dir.directiveIndex).ngAfterViewInit();
        }
        if (dir.callAfterViewChecked) {
          this._getDirectiveFor(dir.directiveIndex).ngAfterViewChecked();
        }
      }
    };
    DynamicChangeDetector.prototype._updateDirectiveOrElement = function(change, bindingRecord) {
      if (lang_1.isBlank(bindingRecord.directiveRecord)) {
        _super.prototype.notifyDispatcher.call(this, change.currentValue);
      } else {
        var directiveIndex = bindingRecord.directiveRecord.directiveIndex;
        bindingRecord.setter(this._getDirectiveFor(directiveIndex), change.currentValue);
      }
      if (this._genConfig.logBindingUpdate) {
        _super.prototype.logBindingUpdate.call(this, change.currentValue);
      }
    };
    DynamicChangeDetector.prototype._addChange = function(bindingRecord, change, changes) {
      if (bindingRecord.callOnChanges()) {
        return _super.prototype.addChange.call(this, changes, change.previousValue, change.currentValue);
      } else {
        return changes;
      }
    };
    DynamicChangeDetector.prototype._getDirectiveFor = function(directiveIndex) {
      return this.dispatcher.getDirectiveFor(directiveIndex);
    };
    DynamicChangeDetector.prototype._getDetectorFor = function(directiveIndex) {
      return this.dispatcher.getDetectorFor(directiveIndex);
    };
    DynamicChangeDetector.prototype._check = function(proto, throwOnChange, values, locals) {
      if (proto.isPipeRecord()) {
        return this._pipeCheck(proto, throwOnChange, values);
      } else {
        return this._referenceCheck(proto, throwOnChange, values, locals);
      }
    };
    DynamicChangeDetector.prototype._referenceCheck = function(proto, throwOnChange, values, locals) {
      if (this._pureFuncAndArgsDidNotChange(proto)) {
        this._setChanged(proto, false);
        return null;
      }
      var currValue = this._calculateCurrValue(proto, values, locals);
      if (this.strategy === constants_1.ChangeDetectionStrategy.OnPushObserve) {
        _super.prototype.observeValue.call(this, currValue, proto.selfIndex);
      }
      if (proto.shouldBeChecked()) {
        var prevValue = this._readSelf(proto, values);
        var detectedChange = throwOnChange ? !change_detection_util_1.ChangeDetectionUtil.devModeEqual(prevValue, currValue) : change_detection_util_1.ChangeDetectionUtil.looseNotIdentical(prevValue, currValue);
        if (detectedChange) {
          if (proto.lastInBinding) {
            var change = change_detection_util_1.ChangeDetectionUtil.simpleChange(prevValue, currValue);
            if (throwOnChange)
              this.throwOnChangeError(prevValue, currValue);
            this._writeSelf(proto, currValue, values);
            this._setChanged(proto, true);
            return change;
          } else {
            this._writeSelf(proto, currValue, values);
            this._setChanged(proto, true);
            return null;
          }
        } else {
          this._setChanged(proto, false);
          return null;
        }
      } else {
        this._writeSelf(proto, currValue, values);
        this._setChanged(proto, true);
        return null;
      }
    };
    DynamicChangeDetector.prototype._calculateCurrValue = function(proto, values, locals) {
      switch (proto.mode) {
        case proto_record_1.RecordType.Self:
          return this._readContext(proto, values);
        case proto_record_1.RecordType.Const:
          return proto.funcOrValue;
        case proto_record_1.RecordType.PropertyRead:
          var context = this._readContext(proto, values);
          return proto.funcOrValue(context);
        case proto_record_1.RecordType.SafeProperty:
          var context = this._readContext(proto, values);
          return lang_1.isBlank(context) ? null : proto.funcOrValue(context);
        case proto_record_1.RecordType.PropertyWrite:
          var context = this._readContext(proto, values);
          var value = this._readArgs(proto, values)[0];
          proto.funcOrValue(context, value);
          return value;
        case proto_record_1.RecordType.KeyedWrite:
          var context = this._readContext(proto, values);
          var key = this._readArgs(proto, values)[0];
          var value = this._readArgs(proto, values)[1];
          context[key] = value;
          return value;
        case proto_record_1.RecordType.Local:
          return locals.get(proto.name);
        case proto_record_1.RecordType.InvokeMethod:
          var context = this._readContext(proto, values);
          var args = this._readArgs(proto, values);
          return proto.funcOrValue(context, args);
        case proto_record_1.RecordType.SafeMethodInvoke:
          var context = this._readContext(proto, values);
          if (lang_1.isBlank(context)) {
            return null;
          }
          var args = this._readArgs(proto, values);
          return proto.funcOrValue(context, args);
        case proto_record_1.RecordType.KeyedRead:
          var arg = this._readArgs(proto, values)[0];
          return this._readContext(proto, values)[arg];
        case proto_record_1.RecordType.Chain:
          var args = this._readArgs(proto, values);
          return args[args.length - 1];
        case proto_record_1.RecordType.InvokeClosure:
          return lang_1.FunctionWrapper.apply(this._readContext(proto, values), this._readArgs(proto, values));
        case proto_record_1.RecordType.Interpolate:
        case proto_record_1.RecordType.PrimitiveOp:
        case proto_record_1.RecordType.CollectionLiteral:
          return lang_1.FunctionWrapper.apply(proto.funcOrValue, this._readArgs(proto, values));
        default:
          throw new exceptions_1.BaseException("Unknown operation " + proto.mode);
      }
    };
    DynamicChangeDetector.prototype._pipeCheck = function(proto, throwOnChange, values) {
      var context = this._readContext(proto, values);
      var selectedPipe = this._pipeFor(proto, context);
      if (!selectedPipe.pure || this._argsOrContextChanged(proto)) {
        var args = this._readArgs(proto, values);
        var currValue = selectedPipe.pipe.transform(context, args);
        if (proto.shouldBeChecked()) {
          var prevValue = this._readSelf(proto, values);
          var detectedChange = throwOnChange ? !change_detection_util_1.ChangeDetectionUtil.devModeEqual(prevValue, currValue) : change_detection_util_1.ChangeDetectionUtil.looseNotIdentical(prevValue, currValue);
          if (detectedChange) {
            currValue = change_detection_util_1.ChangeDetectionUtil.unwrapValue(currValue);
            if (proto.lastInBinding) {
              var change = change_detection_util_1.ChangeDetectionUtil.simpleChange(prevValue, currValue);
              if (throwOnChange)
                this.throwOnChangeError(prevValue, currValue);
              this._writeSelf(proto, currValue, values);
              this._setChanged(proto, true);
              return change;
            } else {
              this._writeSelf(proto, currValue, values);
              this._setChanged(proto, true);
              return null;
            }
          } else {
            this._setChanged(proto, false);
            return null;
          }
        } else {
          this._writeSelf(proto, currValue, values);
          this._setChanged(proto, true);
          return null;
        }
      }
    };
    DynamicChangeDetector.prototype._pipeFor = function(proto, context) {
      var storedPipe = this._readPipe(proto);
      if (lang_1.isPresent(storedPipe))
        return storedPipe;
      var pipe = this.pipes.get(proto.name);
      this._writePipe(proto, pipe);
      return pipe;
    };
    DynamicChangeDetector.prototype._readContext = function(proto, values) {
      if (proto.contextIndex == -1) {
        return this._getDirectiveFor(proto.directiveIndex);
      }
      return values[proto.contextIndex];
    };
    DynamicChangeDetector.prototype._readSelf = function(proto, values) {
      return values[proto.selfIndex];
    };
    DynamicChangeDetector.prototype._writeSelf = function(proto, value, values) {
      values[proto.selfIndex] = value;
    };
    DynamicChangeDetector.prototype._readPipe = function(proto) {
      return this.localPipes[proto.selfIndex];
    };
    DynamicChangeDetector.prototype._writePipe = function(proto, value) {
      this.localPipes[proto.selfIndex] = value;
    };
    DynamicChangeDetector.prototype._setChanged = function(proto, value) {
      if (proto.argumentToPureFunction)
        this.changes[proto.selfIndex] = value;
    };
    DynamicChangeDetector.prototype._pureFuncAndArgsDidNotChange = function(proto) {
      return proto.isPureFunction() && !this._argsChanged(proto);
    };
    DynamicChangeDetector.prototype._argsChanged = function(proto) {
      var args = proto.args;
      for (var i = 0; i < args.length; ++i) {
        if (this.changes[args[i]]) {
          return true;
        }
      }
      return false;
    };
    DynamicChangeDetector.prototype._argsOrContextChanged = function(proto) {
      return this._argsChanged(proto) || this.changes[proto.contextIndex];
    };
    DynamicChangeDetector.prototype._readArgs = function(proto, values) {
      var res = collection_1.ListWrapper.createFixedSize(proto.args.length);
      var args = proto.args;
      for (var i = 0; i < args.length; ++i) {
        res[i] = values[args[i]];
      }
      return res;
    };
    return DynamicChangeDetector;
  })(abstract_change_detector_1.AbstractChangeDetector);
  exports.DynamicChangeDetector = DynamicChangeDetector;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/change_detection_jit_generator", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection", "angular2/src/core/change_detection/abstract_change_detector", "angular2/src/core/change_detection/change_detection_util", "angular2/src/core/change_detection/proto_record", "angular2/src/core/change_detection/codegen_name_util", "angular2/src/core/change_detection/codegen_logic_util", "angular2/src/core/change_detection/codegen_facade", "angular2/src/core/change_detection/constants", "angular2/src/core/change_detection/proto_change_detector"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var abstract_change_detector_1 = require("angular2/src/core/change_detection/abstract_change_detector");
  var change_detection_util_1 = require("angular2/src/core/change_detection/change_detection_util");
  var proto_record_1 = require("angular2/src/core/change_detection/proto_record");
  var codegen_name_util_1 = require("angular2/src/core/change_detection/codegen_name_util");
  var codegen_logic_util_1 = require("angular2/src/core/change_detection/codegen_logic_util");
  var codegen_facade_1 = require("angular2/src/core/change_detection/codegen_facade");
  var constants_1 = require("angular2/src/core/change_detection/constants");
  var proto_change_detector_1 = require("angular2/src/core/change_detection/proto_change_detector");
  var IS_CHANGED_LOCAL = "isChanged";
  var CHANGES_LOCAL = "changes";
  var ChangeDetectorJITGenerator = (function() {
    function ChangeDetectorJITGenerator(definition, changeDetectionUtilVarName, abstractChangeDetectorVarName, changeDetectorStateVarName) {
      this.changeDetectionUtilVarName = changeDetectionUtilVarName;
      this.abstractChangeDetectorVarName = abstractChangeDetectorVarName;
      this.changeDetectorStateVarName = changeDetectorStateVarName;
      var propertyBindingRecords = proto_change_detector_1.createPropertyRecords(definition);
      var eventBindingRecords = proto_change_detector_1.createEventRecords(definition);
      var propertyBindingTargets = definition.bindingRecords.map(function(b) {
        return b.target;
      });
      this.id = definition.id;
      this.changeDetectionStrategy = definition.strategy;
      this.genConfig = definition.genConfig;
      this.records = propertyBindingRecords;
      this.propertyBindingTargets = propertyBindingTargets;
      this.eventBindings = eventBindingRecords;
      this.directiveRecords = definition.directiveRecords;
      this._names = new codegen_name_util_1.CodegenNameUtil(this.records, this.eventBindings, this.directiveRecords, this.changeDetectionUtilVarName);
      this._logic = new codegen_logic_util_1.CodegenLogicUtil(this._names, this.changeDetectionUtilVarName, this.changeDetectorStateVarName, this.changeDetectionStrategy);
      this.typeName = codegen_name_util_1.sanitizeName("ChangeDetector_" + this.id);
    }
    ChangeDetectorJITGenerator.prototype.generate = function() {
      var factorySource = "\n      " + this.generateSource() + "\n      return function() {\n        return new " + this.typeName + "();\n      }\n    ";
      return new Function(this.abstractChangeDetectorVarName, this.changeDetectionUtilVarName, this.changeDetectorStateVarName, factorySource)(abstract_change_detector_1.AbstractChangeDetector, change_detection_util_1.ChangeDetectionUtil, constants_1.ChangeDetectorState);
    };
    ChangeDetectorJITGenerator.prototype.generateSource = function() {
      return "\n      var " + this.typeName + " = function " + this.typeName + "() {\n        " + this.abstractChangeDetectorVarName + ".call(\n            this, " + JSON.stringify(this.id) + ", " + this.records.length + ",\n            " + this.typeName + ".gen_propertyBindingTargets, " + this.typeName + ".gen_directiveIndices,\n            " + codegen_facade_1.codify(this.changeDetectionStrategy) + ");\n        this.dehydrateDirectives(false);\n      }\n\n      " + this.typeName + ".prototype = Object.create(" + this.abstractChangeDetectorVarName + ".prototype);\n\n      " + this.typeName + ".prototype.detectChangesInRecordsInternal = function(throwOnChange) {\n        " + this._names.genInitLocals() + "\n        var " + IS_CHANGED_LOCAL + " = false;\n        var " + CHANGES_LOCAL + " = null;\n\n        " + this._genAllRecords(this.records) + "\n      }\n\n      " + this._maybeGenHandleEventInternal() + "\n\n      " + this._maybeGenAfterContentLifecycleCallbacks() + "\n\n      " + this._maybeGenAfterViewLifecycleCallbacks() + "\n\n      " + this._maybeGenHydrateDirectives() + "\n\n      " + this._maybeGenDehydrateDirectives() + "\n\n      " + this._genPropertyBindingTargets() + "\n\n      " + this._genDirectiveIndices() + "\n    ";
    };
    ChangeDetectorJITGenerator.prototype._genPropertyBindingTargets = function() {
      var targets = this._logic.genPropertyBindingTargets(this.propertyBindingTargets, this.genConfig.genDebugInfo);
      return this.typeName + ".gen_propertyBindingTargets = " + targets + ";";
    };
    ChangeDetectorJITGenerator.prototype._genDirectiveIndices = function() {
      var indices = this._logic.genDirectiveIndices(this.directiveRecords);
      return this.typeName + ".gen_directiveIndices = " + indices + ";";
    };
    ChangeDetectorJITGenerator.prototype._maybeGenHandleEventInternal = function() {
      var _this = this;
      if (this.eventBindings.length > 0) {
        var handlers = this.eventBindings.map(function(eb) {
          return _this._genEventBinding(eb);
        }).join("\n");
        return "\n        " + this.typeName + ".prototype.handleEventInternal = function(eventName, elIndex, locals) {\n          var " + this._names.getPreventDefaultAccesor() + " = false;\n          " + this._names.genInitEventLocals() + "\n          " + handlers + "\n          return " + this._names.getPreventDefaultAccesor() + ";\n        }\n      ";
      } else {
        return '';
      }
    };
    ChangeDetectorJITGenerator.prototype._genEventBinding = function(eb) {
      var _this = this;
      var codes = [];
      this._endOfBlockIdxs = [];
      collection_1.ListWrapper.forEachWithIndex(eb.records, function(r, i) {
        var code;
        if (r.isConditionalSkipRecord()) {
          code = _this._genConditionalSkip(r, _this._names.getEventLocalName(eb, i));
        } else if (r.isUnconditionalSkipRecord()) {
          code = _this._genUnconditionalSkip(r);
        } else {
          code = _this._genEventBindingEval(eb, r);
        }
        code += _this._genEndOfSkipBlock(i);
        codes.push(code);
      });
      return "\n    if (eventName === \"" + eb.eventName + "\" && elIndex === " + eb.elIndex + ") {\n      " + codes.join("\n") + "\n    }";
    };
    ChangeDetectorJITGenerator.prototype._genEventBindingEval = function(eb, r) {
      if (r.lastInBinding) {
        var evalRecord = this._logic.genEventBindingEvalValue(eb, r);
        var markPath = this._genMarkPathToRootAsCheckOnce(r);
        var prevDefault = this._genUpdatePreventDefault(eb, r);
        return evalRecord + "\n" + markPath + "\n" + prevDefault;
      } else {
        return this._logic.genEventBindingEvalValue(eb, r);
      }
    };
    ChangeDetectorJITGenerator.prototype._genMarkPathToRootAsCheckOnce = function(r) {
      var br = r.bindingRecord;
      if (br.isDefaultChangeDetection()) {
        return "";
      } else {
        return this._names.getDetectorName(br.directiveRecord.directiveIndex) + ".markPathToRootAsCheckOnce();";
      }
    };
    ChangeDetectorJITGenerator.prototype._genUpdatePreventDefault = function(eb, r) {
      var local = this._names.getEventLocalName(eb, r.selfIndex);
      return "if (" + local + " === false) { " + this._names.getPreventDefaultAccesor() + " = true};";
    };
    ChangeDetectorJITGenerator.prototype._maybeGenDehydrateDirectives = function() {
      var destroyPipesCode = this._names.genPipeOnDestroy();
      var destroyDirectivesCode = this._logic.genDirectivesOnDestroy(this.directiveRecords);
      var dehydrateFieldsCode = this._names.genDehydrateFields();
      if (!destroyPipesCode && !destroyDirectivesCode && !dehydrateFieldsCode)
        return '';
      return this.typeName + ".prototype.dehydrateDirectives = function(destroyPipes) {\n        if (destroyPipes) {\n          " + destroyPipesCode + "\n          " + destroyDirectivesCode + "\n        }\n        " + dehydrateFieldsCode + "\n    }";
    };
    ChangeDetectorJITGenerator.prototype._maybeGenHydrateDirectives = function() {
      var hydrateDirectivesCode = this._logic.genHydrateDirectives(this.directiveRecords);
      var hydrateDetectorsCode = this._logic.genHydrateDetectors(this.directiveRecords);
      if (!hydrateDirectivesCode && !hydrateDetectorsCode)
        return '';
      return this.typeName + ".prototype.hydrateDirectives = function(directives) {\n      " + hydrateDirectivesCode + "\n      " + hydrateDetectorsCode + "\n    }";
    };
    ChangeDetectorJITGenerator.prototype._maybeGenAfterContentLifecycleCallbacks = function() {
      var notifications = this._logic.genContentLifecycleCallbacks(this.directiveRecords);
      if (notifications.length > 0) {
        var directiveNotifications = notifications.join("\n");
        return "\n        " + this.typeName + ".prototype.afterContentLifecycleCallbacksInternal = function() {\n          " + directiveNotifications + "\n        }\n      ";
      } else {
        return '';
      }
    };
    ChangeDetectorJITGenerator.prototype._maybeGenAfterViewLifecycleCallbacks = function() {
      var notifications = this._logic.genViewLifecycleCallbacks(this.directiveRecords);
      if (notifications.length > 0) {
        var directiveNotifications = notifications.join("\n");
        return "\n        " + this.typeName + ".prototype.afterViewLifecycleCallbacksInternal = function() {\n          " + directiveNotifications + "\n        }\n      ";
      } else {
        return '';
      }
    };
    ChangeDetectorJITGenerator.prototype._genAllRecords = function(rs) {
      var codes = [];
      this._endOfBlockIdxs = [];
      for (var i = 0; i < rs.length; i++) {
        var code = void 0;
        var r = rs[i];
        if (r.isLifeCycleRecord()) {
          code = this._genDirectiveLifecycle(r);
        } else if (r.isPipeRecord()) {
          code = this._genPipeCheck(r);
        } else if (r.isConditionalSkipRecord()) {
          code = this._genConditionalSkip(r, this._names.getLocalName(r.contextIndex));
        } else if (r.isUnconditionalSkipRecord()) {
          code = this._genUnconditionalSkip(r);
        } else {
          code = this._genReferenceCheck(r);
        }
        code = "\n        " + this._maybeFirstInBinding(r) + "\n        " + code + "\n        " + this._maybeGenLastInDirective(r) + "\n        " + this._genEndOfSkipBlock(i) + "\n      ";
        codes.push(code);
      }
      return codes.join("\n");
    };
    ChangeDetectorJITGenerator.prototype._genConditionalSkip = function(r, condition) {
      var maybeNegate = r.mode === proto_record_1.RecordType.SkipRecordsIf ? '!' : '';
      this._endOfBlockIdxs.push(r.fixedArgs[0] - 1);
      return "if (" + maybeNegate + condition + ") {";
    };
    ChangeDetectorJITGenerator.prototype._genUnconditionalSkip = function(r) {
      this._endOfBlockIdxs.pop();
      this._endOfBlockIdxs.push(r.fixedArgs[0] - 1);
      return "} else {";
    };
    ChangeDetectorJITGenerator.prototype._genEndOfSkipBlock = function(protoIndex) {
      if (!collection_1.ListWrapper.isEmpty(this._endOfBlockIdxs)) {
        var endOfBlock = collection_1.ListWrapper.last(this._endOfBlockIdxs);
        if (protoIndex === endOfBlock) {
          this._endOfBlockIdxs.pop();
          return '}';
        }
      }
      return '';
    };
    ChangeDetectorJITGenerator.prototype._genDirectiveLifecycle = function(r) {
      if (r.name === "DoCheck") {
        return this._genOnCheck(r);
      } else if (r.name === "OnInit") {
        return this._genOnInit(r);
      } else if (r.name === "OnChanges") {
        return this._genOnChange(r);
      } else {
        throw new exceptions_1.BaseException("Unknown lifecycle event '" + r.name + "'");
      }
    };
    ChangeDetectorJITGenerator.prototype._genPipeCheck = function(r) {
      var _this = this;
      var context = this._names.getLocalName(r.contextIndex);
      var argString = r.args.map(function(arg) {
        return _this._names.getLocalName(arg);
      }).join(", ");
      var oldValue = this._names.getFieldName(r.selfIndex);
      var newValue = this._names.getLocalName(r.selfIndex);
      var pipe = this._names.getPipeName(r.selfIndex);
      var pipeName = r.name;
      var init = "\n      if (" + pipe + " === " + this.changeDetectionUtilVarName + ".uninitialized) {\n        " + pipe + " = " + this._names.getPipesAccessorName() + ".get('" + pipeName + "');\n      }\n    ";
      var read = newValue + " = " + pipe + ".pipe.transform(" + context + ", [" + argString + "]);";
      var contexOrArgCheck = r.args.map(function(a) {
        return _this._names.getChangeName(a);
      });
      contexOrArgCheck.push(this._names.getChangeName(r.contextIndex));
      var condition = "!" + pipe + ".pure || (" + contexOrArgCheck.join(" || ") + ")";
      var check = "\n      " + this._genThrowOnChangeCheck(oldValue, newValue) + "\n      if (" + this.changeDetectionUtilVarName + ".looseNotIdentical(" + oldValue + ", " + newValue + ")) {\n        " + newValue + " = " + this.changeDetectionUtilVarName + ".unwrapValue(" + newValue + ")\n        " + this._genChangeMarker(r) + "\n        " + this._genUpdateDirectiveOrElement(r) + "\n        " + this._genAddToChanges(r) + "\n        " + oldValue + " = " + newValue + ";\n      }\n    ";
      var genCode = r.shouldBeChecked() ? "" + read + check : read;
      if (r.isUsedByOtherRecord()) {
        return init + " if (" + condition + ") { " + genCode + " } else { " + newValue + " = " + oldValue + "; }";
      } else {
        return init + " if (" + condition + ") { " + genCode + " }";
      }
    };
    ChangeDetectorJITGenerator.prototype._genReferenceCheck = function(r) {
      var _this = this;
      var oldValue = this._names.getFieldName(r.selfIndex);
      var newValue = this._names.getLocalName(r.selfIndex);
      var read = "\n      " + this._logic.genPropertyBindingEvalValue(r) + "\n    ";
      var check = "\n      " + this._genThrowOnChangeCheck(oldValue, newValue) + "\n      if (" + this.changeDetectionUtilVarName + ".looseNotIdentical(" + oldValue + ", " + newValue + ")) {\n        " + this._genChangeMarker(r) + "\n        " + this._genUpdateDirectiveOrElement(r) + "\n        " + this._genAddToChanges(r) + "\n        " + oldValue + " = " + newValue + ";\n      }\n    ";
      var genCode = r.shouldBeChecked() ? "" + read + check : read;
      if (r.isPureFunction()) {
        var condition = r.args.map(function(a) {
          return _this._names.getChangeName(a);
        }).join(" || ");
        if (r.isUsedByOtherRecord()) {
          return "if (" + condition + ") { " + genCode + " } else { " + newValue + " = " + oldValue + "; }";
        } else {
          return "if (" + condition + ") { " + genCode + " }";
        }
      } else {
        return genCode;
      }
    };
    ChangeDetectorJITGenerator.prototype._genChangeMarker = function(r) {
      return r.argumentToPureFunction ? this._names.getChangeName(r.selfIndex) + " = true" : "";
    };
    ChangeDetectorJITGenerator.prototype._genUpdateDirectiveOrElement = function(r) {
      if (!r.lastInBinding)
        return "";
      var newValue = this._names.getLocalName(r.selfIndex);
      var notifyDebug = this.genConfig.logBindingUpdate ? "this.logBindingUpdate(" + newValue + ");" : "";
      var br = r.bindingRecord;
      if (br.target.isDirective()) {
        var directiveProperty = this._names.getDirectiveName(br.directiveRecord.directiveIndex) + "." + br.target.name;
        return "\n        " + directiveProperty + " = " + newValue + ";\n        " + notifyDebug + "\n        " + IS_CHANGED_LOCAL + " = true;\n      ";
      } else {
        return "\n        this.notifyDispatcher(" + newValue + ");\n        " + notifyDebug + "\n      ";
      }
    };
    ChangeDetectorJITGenerator.prototype._genThrowOnChangeCheck = function(oldValue, newValue) {
      if (lang_1.assertionsEnabled()) {
        return "\n        if (throwOnChange && !" + this.changeDetectionUtilVarName + ".devModeEqual(" + oldValue + ", " + newValue + ")) {\n          this.throwOnChangeError(" + oldValue + ", " + newValue + ");\n        }\n        ";
      } else {
        return '';
      }
    };
    ChangeDetectorJITGenerator.prototype._genAddToChanges = function(r) {
      var newValue = this._names.getLocalName(r.selfIndex);
      var oldValue = this._names.getFieldName(r.selfIndex);
      if (!r.bindingRecord.callOnChanges())
        return "";
      return CHANGES_LOCAL + " = this.addChange(" + CHANGES_LOCAL + ", " + oldValue + ", " + newValue + ");";
    };
    ChangeDetectorJITGenerator.prototype._maybeFirstInBinding = function(r) {
      var prev = change_detection_util_1.ChangeDetectionUtil.protoByIndex(this.records, r.selfIndex - 1);
      var firstInBinding = lang_1.isBlank(prev) || prev.bindingRecord !== r.bindingRecord;
      return firstInBinding && !r.bindingRecord.isDirectiveLifecycle() ? this._names.getPropertyBindingIndex() + " = " + r.propertyBindingIndex + ";" : '';
    };
    ChangeDetectorJITGenerator.prototype._maybeGenLastInDirective = function(r) {
      if (!r.lastInDirective)
        return "";
      return "\n      " + CHANGES_LOCAL + " = null;\n      " + this._genNotifyOnPushDetectors(r) + "\n      " + IS_CHANGED_LOCAL + " = false;\n    ";
    };
    ChangeDetectorJITGenerator.prototype._genOnCheck = function(r) {
      var br = r.bindingRecord;
      return "if (!throwOnChange) " + this._names.getDirectiveName(br.directiveRecord.directiveIndex) + ".ngDoCheck();";
    };
    ChangeDetectorJITGenerator.prototype._genOnInit = function(r) {
      var br = r.bindingRecord;
      return "if (!throwOnChange && " + this._names.getStateName() + " === " + this.changeDetectorStateVarName + ".NeverChecked) " + this._names.getDirectiveName(br.directiveRecord.directiveIndex) + ".ngOnInit();";
    };
    ChangeDetectorJITGenerator.prototype._genOnChange = function(r) {
      var br = r.bindingRecord;
      return "if (!throwOnChange && " + CHANGES_LOCAL + ") " + this._names.getDirectiveName(br.directiveRecord.directiveIndex) + ".ngOnChanges(" + CHANGES_LOCAL + ");";
    };
    ChangeDetectorJITGenerator.prototype._genNotifyOnPushDetectors = function(r) {
      var br = r.bindingRecord;
      if (!r.lastInDirective || br.isDefaultChangeDetection())
        return "";
      var retVal = "\n      if(" + IS_CHANGED_LOCAL + ") {\n        " + this._names.getDetectorName(br.directiveRecord.directiveIndex) + ".markAsCheckOnce();\n      }\n    ";
      return retVal;
    };
    return ChangeDetectorJITGenerator;
  })();
  exports.ChangeDetectorJITGenerator = ChangeDetectorJITGenerator;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/view", ["angular2/src/facade/collection", "angular2/src/core/change_detection/change_detection", "angular2/src/core/change_detection/interfaces", "angular2/src/core/linker/element", "angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/core/render/api", "angular2/src/core/linker/view_ref", "angular2/src/core/pipes/pipes", "angular2/src/core/render/util", "angular2/src/core/change_detection/interfaces", "angular2/src/core/pipes/pipes", "angular2/src/core/linker/view_type"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var collection_1 = require("angular2/src/facade/collection");
  var change_detection_1 = require("angular2/src/core/change_detection/change_detection");
  var interfaces_1 = require("angular2/src/core/change_detection/interfaces");
  var element_1 = require("angular2/src/core/linker/element");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var api_1 = require("angular2/src/core/render/api");
  var view_ref_1 = require("angular2/src/core/linker/view_ref");
  var pipes_1 = require("angular2/src/core/pipes/pipes");
  var util_1 = require("angular2/src/core/render/util");
  var interfaces_2 = require("angular2/src/core/change_detection/interfaces");
  exports.DebugContext = interfaces_2.DebugContext;
  var pipes_2 = require("angular2/src/core/pipes/pipes");
  var view_type_1 = require("angular2/src/core/linker/view_type");
  var REFLECT_PREFIX = 'ng-reflect-';
  var EMPTY_CONTEXT = lang_1.CONST_EXPR(new Object());
  var AppView = (function() {
    function AppView(proto, renderer, viewManager, projectableNodes, containerAppElement, imperativelyCreatedProviders, rootInjector, changeDetector) {
      this.proto = proto;
      this.renderer = renderer;
      this.viewManager = viewManager;
      this.projectableNodes = projectableNodes;
      this.containerAppElement = containerAppElement;
      this.changeDetector = changeDetector;
      this.context = null;
      this.destroyed = false;
      this.ref = new view_ref_1.ViewRef_(this);
      var injectorWithHostBoundary = element_1.AppElement.getViewParentInjector(this.proto.type, containerAppElement, imperativelyCreatedProviders, rootInjector);
      this.parentInjector = injectorWithHostBoundary.injector;
      this.hostInjectorBoundary = injectorWithHostBoundary.hostInjectorBoundary;
      var pipes;
      var context;
      switch (proto.type) {
        case view_type_1.ViewType.COMPONENT:
          pipes = new pipes_2.Pipes(proto.protoPipes, containerAppElement.getInjector());
          context = containerAppElement.getComponent();
          break;
        case view_type_1.ViewType.EMBEDDED:
          pipes = containerAppElement.parentView.pipes;
          context = containerAppElement.parentView.context;
          break;
        case view_type_1.ViewType.HOST:
          pipes = null;
          context = EMPTY_CONTEXT;
          break;
      }
      this.pipes = pipes;
      this.context = context;
    }
    AppView.prototype.init = function(rootNodesOrAppElements, allNodes, disposables, appElements) {
      this.rootNodesOrAppElements = rootNodesOrAppElements;
      this.allNodes = allNodes;
      this.disposables = disposables;
      this.appElements = appElements;
      var localsMap = new collection_1.Map();
      collection_1.StringMapWrapper.forEach(this.proto.templateVariableBindings, function(templateName, _) {
        localsMap.set(templateName, null);
      });
      for (var i = 0; i < appElements.length; i++) {
        var appEl = appElements[i];
        var providerTokens = [];
        if (lang_1.isPresent(appEl.proto.protoInjector)) {
          for (var j = 0; j < appEl.proto.protoInjector.numberOfProviders; j++) {
            providerTokens.push(appEl.proto.protoInjector.getProviderAtIndex(j).key.token);
          }
        }
        collection_1.StringMapWrapper.forEach(appEl.proto.directiveVariableBindings, function(directiveIndex, name) {
          if (lang_1.isBlank(directiveIndex)) {
            localsMap.set(name, appEl.nativeElement);
          } else {
            localsMap.set(name, appEl.getDirectiveAtIndex(directiveIndex));
          }
        });
        this.renderer.setElementDebugInfo(appEl.nativeElement, new api_1.RenderDebugInfo(appEl.getInjector(), appEl.getComponent(), providerTokens, localsMap));
      }
      var parentLocals = null;
      if (this.proto.type !== view_type_1.ViewType.COMPONENT) {
        parentLocals = lang_1.isPresent(this.containerAppElement) ? this.containerAppElement.parentView.locals : null;
      }
      if (this.proto.type === view_type_1.ViewType.COMPONENT) {
        this.containerAppElement.attachComponentView(this);
        this.containerAppElement.parentView.changeDetector.addViewChild(this.changeDetector);
      }
      this.locals = new change_detection_1.Locals(parentLocals, localsMap);
      this.changeDetector.hydrate(this.context, this.locals, this, this.pipes);
      this.viewManager.onViewCreated(this);
    };
    AppView.prototype.destroy = function() {
      if (this.destroyed) {
        throw new exceptions_1.BaseException('This view has already been destroyed!');
      }
      this.changeDetector.destroyRecursive();
    };
    AppView.prototype.notifyOnDestroy = function() {
      this.destroyed = true;
      var hostElement = this.proto.type === view_type_1.ViewType.COMPONENT ? this.containerAppElement.nativeElement : null;
      this.renderer.destroyView(hostElement, this.allNodes);
      for (var i = 0; i < this.disposables.length; i++) {
        this.disposables[i]();
      }
      this.viewManager.onViewDestroyed(this);
    };
    Object.defineProperty(AppView.prototype, "changeDetectorRef", {
      get: function() {
        return this.changeDetector.ref;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AppView.prototype, "flatRootNodes", {
      get: function() {
        return flattenNestedViewRenderNodes(this.rootNodesOrAppElements);
      },
      enumerable: true,
      configurable: true
    });
    AppView.prototype.hasLocal = function(contextName) {
      return collection_1.StringMapWrapper.contains(this.proto.templateVariableBindings, contextName);
    };
    AppView.prototype.setLocal = function(contextName, value) {
      if (!this.hasLocal(contextName)) {
        return ;
      }
      var templateName = this.proto.templateVariableBindings[contextName];
      this.locals.set(templateName, value);
    };
    AppView.prototype.notifyOnBinding = function(b, currentValue) {
      if (b.isTextNode()) {
        this.renderer.setText(this.allNodes[b.elementIndex], currentValue);
      } else {
        var nativeElement = this.appElements[b.elementIndex].nativeElement;
        if (b.isElementProperty()) {
          this.renderer.setElementProperty(nativeElement, b.name, currentValue);
        } else if (b.isElementAttribute()) {
          this.renderer.setElementAttribute(nativeElement, b.name, lang_1.isPresent(currentValue) ? "" + currentValue : null);
        } else if (b.isElementClass()) {
          this.renderer.setElementClass(nativeElement, b.name, currentValue);
        } else if (b.isElementStyle()) {
          var unit = lang_1.isPresent(b.unit) ? b.unit : '';
          this.renderer.setElementStyle(nativeElement, b.name, lang_1.isPresent(currentValue) ? "" + currentValue + unit : null);
        } else {
          throw new exceptions_1.BaseException('Unsupported directive record');
        }
      }
    };
    AppView.prototype.logBindingUpdate = function(b, value) {
      if (b.isDirective() || b.isElementProperty()) {
        var nativeElement = this.appElements[b.elementIndex].nativeElement;
        this.renderer.setBindingDebugInfo(nativeElement, "" + REFLECT_PREFIX + util_1.camelCaseToDashCase(b.name), "" + value);
      }
    };
    AppView.prototype.notifyAfterContentChecked = function() {
      var count = this.appElements.length;
      for (var i = count - 1; i >= 0; i--) {
        this.appElements[i].ngAfterContentChecked();
      }
    };
    AppView.prototype.notifyAfterViewChecked = function() {
      var count = this.appElements.length;
      for (var i = count - 1; i >= 0; i--) {
        this.appElements[i].ngAfterViewChecked();
      }
    };
    AppView.prototype.getDebugContext = function(appElement, elementIndex, directiveIndex) {
      try {
        if (lang_1.isBlank(appElement) && elementIndex < this.appElements.length) {
          appElement = this.appElements[elementIndex];
        }
        var container = this.containerAppElement;
        var element = lang_1.isPresent(appElement) ? appElement.nativeElement : null;
        var componentElement = lang_1.isPresent(container) ? container.nativeElement : null;
        var directive = lang_1.isPresent(directiveIndex) ? appElement.getDirectiveAtIndex(directiveIndex) : null;
        var injector = lang_1.isPresent(appElement) ? appElement.getInjector() : null;
        return new interfaces_1.DebugContext(element, componentElement, directive, this.context, _localsToStringMap(this.locals), injector);
      } catch (e) {
        return null;
      }
    };
    AppView.prototype.getDirectiveFor = function(directive) {
      return this.appElements[directive.elementIndex].getDirectiveAtIndex(directive.directiveIndex);
    };
    AppView.prototype.getDetectorFor = function(directive) {
      var componentView = this.appElements[directive.elementIndex].componentView;
      return lang_1.isPresent(componentView) ? componentView.changeDetector : null;
    };
    AppView.prototype.triggerEventHandlers = function(eventName, eventObj, boundElementIndex) {
      return this.changeDetector.handleEvent(eventName, boundElementIndex, eventObj);
    };
    return AppView;
  })();
  exports.AppView = AppView;
  function _localsToStringMap(locals) {
    var res = {};
    var c = locals;
    while (lang_1.isPresent(c)) {
      res = collection_1.StringMapWrapper.merge(res, collection_1.MapWrapper.toStringMap(c.current));
      c = c.parent;
    }
    return res;
  }
  var AppProtoView = (function() {
    function AppProtoView(type, protoPipes, templateVariableBindings) {
      this.type = type;
      this.protoPipes = protoPipes;
      this.templateVariableBindings = templateVariableBindings;
    }
    AppProtoView.create = function(metadataCache, type, pipes, templateVariableBindings) {
      var protoPipes = null;
      if (lang_1.isPresent(pipes) && pipes.length > 0) {
        var boundPipes = collection_1.ListWrapper.createFixedSize(pipes.length);
        for (var i = 0; i < pipes.length; i++) {
          boundPipes[i] = metadataCache.getResolvedPipeMetadata(pipes[i]);
        }
        protoPipes = pipes_1.ProtoPipes.fromProviders(boundPipes);
      }
      return new AppProtoView(type, protoPipes, templateVariableBindings);
    };
    return AppProtoView;
  })();
  exports.AppProtoView = AppProtoView;
  var HostViewFactory = (function() {
    function HostViewFactory(selector, viewFactory) {
      this.selector = selector;
      this.viewFactory = viewFactory;
    }
    HostViewFactory = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [String, Function])], HostViewFactory);
    return HostViewFactory;
  })();
  exports.HostViewFactory = HostViewFactory;
  function flattenNestedViewRenderNodes(nodes) {
    return _flattenNestedViewRenderNodes(nodes, []);
  }
  exports.flattenNestedViewRenderNodes = flattenNestedViewRenderNodes;
  function _flattenNestedViewRenderNodes(nodes, renderNodes) {
    for (var i = 0; i < nodes.length; i++) {
      var node = nodes[i];
      if (node instanceof element_1.AppElement) {
        var appEl = node;
        renderNodes.push(appEl.nativeElement);
        if (lang_1.isPresent(appEl.nestedViews)) {
          for (var k = 0; k < appEl.nestedViews.length; k++) {
            _flattenNestedViewRenderNodes(appEl.nestedViews[k].rootNodesOrAppElements, renderNodes);
          }
        }
      } else {
        renderNodes.push(node);
      }
    }
    return renderNodes;
  }
  function checkSlotCount(componentName, expectedSlotCount, projectableNodes) {
    var givenSlotCount = lang_1.isPresent(projectableNodes) ? projectableNodes.length : 0;
    if (givenSlotCount < expectedSlotCount) {
      throw new exceptions_1.BaseException(("The component " + componentName + " has " + expectedSlotCount + " <ng-content> elements,") + (" but only " + givenSlotCount + " slots were provided."));
    }
  }
  exports.checkSlotCount = checkSlotCount;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/application_common_providers", ["angular2/src/facade/lang", "angular2/src/core/di", "angular2/src/core/application_tokens", "angular2/src/core/change_detection/change_detection", "angular2/src/core/linker/resolved_metadata_cache", "angular2/src/core/linker/view_manager", "angular2/src/core/linker/view_manager", "angular2/src/core/linker/view_resolver", "angular2/src/core/linker/directive_resolver", "angular2/src/core/linker/pipe_resolver", "angular2/src/core/linker/compiler", "angular2/src/core/linker/compiler", "angular2/src/core/linker/dynamic_component_loader", "angular2/src/core/linker/dynamic_component_loader"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var di_1 = require("angular2/src/core/di");
  var application_tokens_1 = require("angular2/src/core/application_tokens");
  var change_detection_1 = require("angular2/src/core/change_detection/change_detection");
  var resolved_metadata_cache_1 = require("angular2/src/core/linker/resolved_metadata_cache");
  var view_manager_1 = require("angular2/src/core/linker/view_manager");
  var view_manager_2 = require("angular2/src/core/linker/view_manager");
  var view_resolver_1 = require("angular2/src/core/linker/view_resolver");
  var directive_resolver_1 = require("angular2/src/core/linker/directive_resolver");
  var pipe_resolver_1 = require("angular2/src/core/linker/pipe_resolver");
  var compiler_1 = require("angular2/src/core/linker/compiler");
  var compiler_2 = require("angular2/src/core/linker/compiler");
  var dynamic_component_loader_1 = require("angular2/src/core/linker/dynamic_component_loader");
  var dynamic_component_loader_2 = require("angular2/src/core/linker/dynamic_component_loader");
  exports.APPLICATION_COMMON_PROVIDERS = lang_1.CONST_EXPR([new di_1.Provider(compiler_1.Compiler, {useClass: compiler_2.Compiler_}), application_tokens_1.APP_ID_RANDOM_PROVIDER, resolved_metadata_cache_1.ResolvedMetadataCache, new di_1.Provider(view_manager_1.AppViewManager, {useClass: view_manager_2.AppViewManager_}), view_resolver_1.ViewResolver, new di_1.Provider(change_detection_1.IterableDiffers, {useValue: change_detection_1.defaultIterableDiffers}), new di_1.Provider(change_detection_1.KeyValueDiffers, {useValue: change_detection_1.defaultKeyValueDiffers}), directive_resolver_1.DirectiveResolver, pipe_resolver_1.PipeResolver, new di_1.Provider(dynamic_component_loader_1.DynamicComponentLoader, {useClass: dynamic_component_loader_2.DynamicComponentLoader_})]);
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/di/injector", ["angular2/src/facade/collection", "angular2/src/core/di/provider", "angular2/src/core/di/exceptions", "angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/core/di/key", "angular2/src/core/di/metadata"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var collection_1 = require("angular2/src/facade/collection");
  var provider_1 = require("angular2/src/core/di/provider");
  var exceptions_1 = require("angular2/src/core/di/exceptions");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_2 = require("angular2/src/facade/exceptions");
  var key_1 = require("angular2/src/core/di/key");
  var metadata_1 = require("angular2/src/core/di/metadata");
  var _MAX_CONSTRUCTION_COUNTER = 10;
  exports.UNDEFINED = lang_1.CONST_EXPR(new Object());
  (function(Visibility) {
    Visibility[Visibility["Public"] = 0] = "Public";
    Visibility[Visibility["Private"] = 1] = "Private";
    Visibility[Visibility["PublicAndPrivate"] = 2] = "PublicAndPrivate";
  })(exports.Visibility || (exports.Visibility = {}));
  var Visibility = exports.Visibility;
  function canSee(src, dst) {
    return (src === dst) || (dst === Visibility.PublicAndPrivate || src === Visibility.PublicAndPrivate);
  }
  var ProtoInjectorInlineStrategy = (function() {
    function ProtoInjectorInlineStrategy(protoEI, bwv) {
      this.provider0 = null;
      this.provider1 = null;
      this.provider2 = null;
      this.provider3 = null;
      this.provider4 = null;
      this.provider5 = null;
      this.provider6 = null;
      this.provider7 = null;
      this.provider8 = null;
      this.provider9 = null;
      this.keyId0 = null;
      this.keyId1 = null;
      this.keyId2 = null;
      this.keyId3 = null;
      this.keyId4 = null;
      this.keyId5 = null;
      this.keyId6 = null;
      this.keyId7 = null;
      this.keyId8 = null;
      this.keyId9 = null;
      this.visibility0 = null;
      this.visibility1 = null;
      this.visibility2 = null;
      this.visibility3 = null;
      this.visibility4 = null;
      this.visibility5 = null;
      this.visibility6 = null;
      this.visibility7 = null;
      this.visibility8 = null;
      this.visibility9 = null;
      var length = bwv.length;
      if (length > 0) {
        this.provider0 = bwv[0].provider;
        this.keyId0 = bwv[0].getKeyId();
        this.visibility0 = bwv[0].visibility;
      }
      if (length > 1) {
        this.provider1 = bwv[1].provider;
        this.keyId1 = bwv[1].getKeyId();
        this.visibility1 = bwv[1].visibility;
      }
      if (length > 2) {
        this.provider2 = bwv[2].provider;
        this.keyId2 = bwv[2].getKeyId();
        this.visibility2 = bwv[2].visibility;
      }
      if (length > 3) {
        this.provider3 = bwv[3].provider;
        this.keyId3 = bwv[3].getKeyId();
        this.visibility3 = bwv[3].visibility;
      }
      if (length > 4) {
        this.provider4 = bwv[4].provider;
        this.keyId4 = bwv[4].getKeyId();
        this.visibility4 = bwv[4].visibility;
      }
      if (length > 5) {
        this.provider5 = bwv[5].provider;
        this.keyId5 = bwv[5].getKeyId();
        this.visibility5 = bwv[5].visibility;
      }
      if (length > 6) {
        this.provider6 = bwv[6].provider;
        this.keyId6 = bwv[6].getKeyId();
        this.visibility6 = bwv[6].visibility;
      }
      if (length > 7) {
        this.provider7 = bwv[7].provider;
        this.keyId7 = bwv[7].getKeyId();
        this.visibility7 = bwv[7].visibility;
      }
      if (length > 8) {
        this.provider8 = bwv[8].provider;
        this.keyId8 = bwv[8].getKeyId();
        this.visibility8 = bwv[8].visibility;
      }
      if (length > 9) {
        this.provider9 = bwv[9].provider;
        this.keyId9 = bwv[9].getKeyId();
        this.visibility9 = bwv[9].visibility;
      }
    }
    ProtoInjectorInlineStrategy.prototype.getProviderAtIndex = function(index) {
      if (index == 0)
        return this.provider0;
      if (index == 1)
        return this.provider1;
      if (index == 2)
        return this.provider2;
      if (index == 3)
        return this.provider3;
      if (index == 4)
        return this.provider4;
      if (index == 5)
        return this.provider5;
      if (index == 6)
        return this.provider6;
      if (index == 7)
        return this.provider7;
      if (index == 8)
        return this.provider8;
      if (index == 9)
        return this.provider9;
      throw new exceptions_1.OutOfBoundsError(index);
    };
    ProtoInjectorInlineStrategy.prototype.createInjectorStrategy = function(injector) {
      return new InjectorInlineStrategy(injector, this);
    };
    return ProtoInjectorInlineStrategy;
  })();
  exports.ProtoInjectorInlineStrategy = ProtoInjectorInlineStrategy;
  var ProtoInjectorDynamicStrategy = (function() {
    function ProtoInjectorDynamicStrategy(protoInj, bwv) {
      var len = bwv.length;
      this.providers = collection_1.ListWrapper.createFixedSize(len);
      this.keyIds = collection_1.ListWrapper.createFixedSize(len);
      this.visibilities = collection_1.ListWrapper.createFixedSize(len);
      for (var i = 0; i < len; i++) {
        this.providers[i] = bwv[i].provider;
        this.keyIds[i] = bwv[i].getKeyId();
        this.visibilities[i] = bwv[i].visibility;
      }
    }
    ProtoInjectorDynamicStrategy.prototype.getProviderAtIndex = function(index) {
      if (index < 0 || index >= this.providers.length) {
        throw new exceptions_1.OutOfBoundsError(index);
      }
      return this.providers[index];
    };
    ProtoInjectorDynamicStrategy.prototype.createInjectorStrategy = function(ei) {
      return new InjectorDynamicStrategy(this, ei);
    };
    return ProtoInjectorDynamicStrategy;
  })();
  exports.ProtoInjectorDynamicStrategy = ProtoInjectorDynamicStrategy;
  var ProtoInjector = (function() {
    function ProtoInjector(bwv) {
      this.numberOfProviders = bwv.length;
      this._strategy = bwv.length > _MAX_CONSTRUCTION_COUNTER ? new ProtoInjectorDynamicStrategy(this, bwv) : new ProtoInjectorInlineStrategy(this, bwv);
    }
    ProtoInjector.fromResolvedProviders = function(providers) {
      var bd = providers.map(function(b) {
        return new ProviderWithVisibility(b, Visibility.Public);
      });
      return new ProtoInjector(bd);
    };
    ProtoInjector.prototype.getProviderAtIndex = function(index) {
      return this._strategy.getProviderAtIndex(index);
    };
    return ProtoInjector;
  })();
  exports.ProtoInjector = ProtoInjector;
  var InjectorInlineStrategy = (function() {
    function InjectorInlineStrategy(injector, protoStrategy) {
      this.injector = injector;
      this.protoStrategy = protoStrategy;
      this.obj0 = exports.UNDEFINED;
      this.obj1 = exports.UNDEFINED;
      this.obj2 = exports.UNDEFINED;
      this.obj3 = exports.UNDEFINED;
      this.obj4 = exports.UNDEFINED;
      this.obj5 = exports.UNDEFINED;
      this.obj6 = exports.UNDEFINED;
      this.obj7 = exports.UNDEFINED;
      this.obj8 = exports.UNDEFINED;
      this.obj9 = exports.UNDEFINED;
    }
    InjectorInlineStrategy.prototype.resetConstructionCounter = function() {
      this.injector._constructionCounter = 0;
    };
    InjectorInlineStrategy.prototype.instantiateProvider = function(provider, visibility) {
      return this.injector._new(provider, visibility);
    };
    InjectorInlineStrategy.prototype.getObjByKeyId = function(keyId, visibility) {
      var p = this.protoStrategy;
      var inj = this.injector;
      if (p.keyId0 === keyId && canSee(p.visibility0, visibility)) {
        if (this.obj0 === exports.UNDEFINED) {
          this.obj0 = inj._new(p.provider0, p.visibility0);
        }
        return this.obj0;
      }
      if (p.keyId1 === keyId && canSee(p.visibility1, visibility)) {
        if (this.obj1 === exports.UNDEFINED) {
          this.obj1 = inj._new(p.provider1, p.visibility1);
        }
        return this.obj1;
      }
      if (p.keyId2 === keyId && canSee(p.visibility2, visibility)) {
        if (this.obj2 === exports.UNDEFINED) {
          this.obj2 = inj._new(p.provider2, p.visibility2);
        }
        return this.obj2;
      }
      if (p.keyId3 === keyId && canSee(p.visibility3, visibility)) {
        if (this.obj3 === exports.UNDEFINED) {
          this.obj3 = inj._new(p.provider3, p.visibility3);
        }
        return this.obj3;
      }
      if (p.keyId4 === keyId && canSee(p.visibility4, visibility)) {
        if (this.obj4 === exports.UNDEFINED) {
          this.obj4 = inj._new(p.provider4, p.visibility4);
        }
        return this.obj4;
      }
      if (p.keyId5 === keyId && canSee(p.visibility5, visibility)) {
        if (this.obj5 === exports.UNDEFINED) {
          this.obj5 = inj._new(p.provider5, p.visibility5);
        }
        return this.obj5;
      }
      if (p.keyId6 === keyId && canSee(p.visibility6, visibility)) {
        if (this.obj6 === exports.UNDEFINED) {
          this.obj6 = inj._new(p.provider6, p.visibility6);
        }
        return this.obj6;
      }
      if (p.keyId7 === keyId && canSee(p.visibility7, visibility)) {
        if (this.obj7 === exports.UNDEFINED) {
          this.obj7 = inj._new(p.provider7, p.visibility7);
        }
        return this.obj7;
      }
      if (p.keyId8 === keyId && canSee(p.visibility8, visibility)) {
        if (this.obj8 === exports.UNDEFINED) {
          this.obj8 = inj._new(p.provider8, p.visibility8);
        }
        return this.obj8;
      }
      if (p.keyId9 === keyId && canSee(p.visibility9, visibility)) {
        if (this.obj9 === exports.UNDEFINED) {
          this.obj9 = inj._new(p.provider9, p.visibility9);
        }
        return this.obj9;
      }
      return exports.UNDEFINED;
    };
    InjectorInlineStrategy.prototype.getObjAtIndex = function(index) {
      if (index == 0)
        return this.obj0;
      if (index == 1)
        return this.obj1;
      if (index == 2)
        return this.obj2;
      if (index == 3)
        return this.obj3;
      if (index == 4)
        return this.obj4;
      if (index == 5)
        return this.obj5;
      if (index == 6)
        return this.obj6;
      if (index == 7)
        return this.obj7;
      if (index == 8)
        return this.obj8;
      if (index == 9)
        return this.obj9;
      throw new exceptions_1.OutOfBoundsError(index);
    };
    InjectorInlineStrategy.prototype.getMaxNumberOfObjects = function() {
      return _MAX_CONSTRUCTION_COUNTER;
    };
    return InjectorInlineStrategy;
  })();
  exports.InjectorInlineStrategy = InjectorInlineStrategy;
  var InjectorDynamicStrategy = (function() {
    function InjectorDynamicStrategy(protoStrategy, injector) {
      this.protoStrategy = protoStrategy;
      this.injector = injector;
      this.objs = collection_1.ListWrapper.createFixedSize(protoStrategy.providers.length);
      collection_1.ListWrapper.fill(this.objs, exports.UNDEFINED);
    }
    InjectorDynamicStrategy.prototype.resetConstructionCounter = function() {
      this.injector._constructionCounter = 0;
    };
    InjectorDynamicStrategy.prototype.instantiateProvider = function(provider, visibility) {
      return this.injector._new(provider, visibility);
    };
    InjectorDynamicStrategy.prototype.getObjByKeyId = function(keyId, visibility) {
      var p = this.protoStrategy;
      for (var i = 0; i < p.keyIds.length; i++) {
        if (p.keyIds[i] === keyId && canSee(p.visibilities[i], visibility)) {
          if (this.objs[i] === exports.UNDEFINED) {
            this.objs[i] = this.injector._new(p.providers[i], p.visibilities[i]);
          }
          return this.objs[i];
        }
      }
      return exports.UNDEFINED;
    };
    InjectorDynamicStrategy.prototype.getObjAtIndex = function(index) {
      if (index < 0 || index >= this.objs.length) {
        throw new exceptions_1.OutOfBoundsError(index);
      }
      return this.objs[index];
    };
    InjectorDynamicStrategy.prototype.getMaxNumberOfObjects = function() {
      return this.objs.length;
    };
    return InjectorDynamicStrategy;
  })();
  exports.InjectorDynamicStrategy = InjectorDynamicStrategy;
  var ProviderWithVisibility = (function() {
    function ProviderWithVisibility(provider, visibility) {
      this.provider = provider;
      this.visibility = visibility;
    }
    ;
    ProviderWithVisibility.prototype.getKeyId = function() {
      return this.provider.key.id;
    };
    return ProviderWithVisibility;
  })();
  exports.ProviderWithVisibility = ProviderWithVisibility;
  var Injector = (function() {
    function Injector(_proto, _parent, _isHostBoundary, _depProvider, _debugContext) {
      if (_parent === void 0) {
        _parent = null;
      }
      if (_isHostBoundary === void 0) {
        _isHostBoundary = false;
      }
      if (_depProvider === void 0) {
        _depProvider = null;
      }
      if (_debugContext === void 0) {
        _debugContext = null;
      }
      this._isHostBoundary = _isHostBoundary;
      this._depProvider = _depProvider;
      this._debugContext = _debugContext;
      this._constructionCounter = 0;
      this._proto = _proto;
      this._parent = _parent;
      this._strategy = _proto._strategy.createInjectorStrategy(this);
    }
    Injector.resolve = function(providers) {
      return provider_1.resolveProviders(providers);
    };
    Injector.resolveAndCreate = function(providers) {
      var resolvedProviders = Injector.resolve(providers);
      return Injector.fromResolvedProviders(resolvedProviders);
    };
    Injector.fromResolvedProviders = function(providers) {
      return new Injector(ProtoInjector.fromResolvedProviders(providers));
    };
    Injector.fromResolvedBindings = function(providers) {
      return Injector.fromResolvedProviders(providers);
    };
    Object.defineProperty(Injector.prototype, "hostBoundary", {
      get: function() {
        return this._isHostBoundary;
      },
      enumerable: true,
      configurable: true
    });
    Injector.prototype.debugContext = function() {
      return this._debugContext();
    };
    Injector.prototype.get = function(token) {
      return this._getByKey(key_1.Key.get(token), null, null, false, Visibility.PublicAndPrivate);
    };
    Injector.prototype.getOptional = function(token) {
      return this._getByKey(key_1.Key.get(token), null, null, true, Visibility.PublicAndPrivate);
    };
    Injector.prototype.getAt = function(index) {
      return this._strategy.getObjAtIndex(index);
    };
    Object.defineProperty(Injector.prototype, "parent", {
      get: function() {
        return this._parent;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(Injector.prototype, "internalStrategy", {
      get: function() {
        return this._strategy;
      },
      enumerable: true,
      configurable: true
    });
    Injector.prototype.resolveAndCreateChild = function(providers) {
      var resolvedProviders = Injector.resolve(providers);
      return this.createChildFromResolved(resolvedProviders);
    };
    Injector.prototype.createChildFromResolved = function(providers) {
      var bd = providers.map(function(b) {
        return new ProviderWithVisibility(b, Visibility.Public);
      });
      var proto = new ProtoInjector(bd);
      var inj = new Injector(proto);
      inj._parent = this;
      return inj;
    };
    Injector.prototype.resolveAndInstantiate = function(provider) {
      return this.instantiateResolved(Injector.resolve([provider])[0]);
    };
    Injector.prototype.instantiateResolved = function(provider) {
      return this._instantiateProvider(provider, Visibility.PublicAndPrivate);
    };
    Injector.prototype._new = function(provider, visibility) {
      if (this._constructionCounter++ > this._strategy.getMaxNumberOfObjects()) {
        throw new exceptions_1.CyclicDependencyError(this, provider.key);
      }
      return this._instantiateProvider(provider, visibility);
    };
    Injector.prototype._instantiateProvider = function(provider, visibility) {
      if (provider.multiProvider) {
        var res = collection_1.ListWrapper.createFixedSize(provider.resolvedFactories.length);
        for (var i = 0; i < provider.resolvedFactories.length; ++i) {
          res[i] = this._instantiate(provider, provider.resolvedFactories[i], visibility);
        }
        return res;
      } else {
        return this._instantiate(provider, provider.resolvedFactories[0], visibility);
      }
    };
    Injector.prototype._instantiate = function(provider, resolvedFactory, visibility) {
      var factory = resolvedFactory.factory;
      var deps = resolvedFactory.dependencies;
      var length = deps.length;
      var d0,
          d1,
          d2,
          d3,
          d4,
          d5,
          d6,
          d7,
          d8,
          d9,
          d10,
          d11,
          d12,
          d13,
          d14,
          d15,
          d16,
          d17,
          d18,
          d19;
      try {
        d0 = length > 0 ? this._getByDependency(provider, deps[0], visibility) : null;
        d1 = length > 1 ? this._getByDependency(provider, deps[1], visibility) : null;
        d2 = length > 2 ? this._getByDependency(provider, deps[2], visibility) : null;
        d3 = length > 3 ? this._getByDependency(provider, deps[3], visibility) : null;
        d4 = length > 4 ? this._getByDependency(provider, deps[4], visibility) : null;
        d5 = length > 5 ? this._getByDependency(provider, deps[5], visibility) : null;
        d6 = length > 6 ? this._getByDependency(provider, deps[6], visibility) : null;
        d7 = length > 7 ? this._getByDependency(provider, deps[7], visibility) : null;
        d8 = length > 8 ? this._getByDependency(provider, deps[8], visibility) : null;
        d9 = length > 9 ? this._getByDependency(provider, deps[9], visibility) : null;
        d10 = length > 10 ? this._getByDependency(provider, deps[10], visibility) : null;
        d11 = length > 11 ? this._getByDependency(provider, deps[11], visibility) : null;
        d12 = length > 12 ? this._getByDependency(provider, deps[12], visibility) : null;
        d13 = length > 13 ? this._getByDependency(provider, deps[13], visibility) : null;
        d14 = length > 14 ? this._getByDependency(provider, deps[14], visibility) : null;
        d15 = length > 15 ? this._getByDependency(provider, deps[15], visibility) : null;
        d16 = length > 16 ? this._getByDependency(provider, deps[16], visibility) : null;
        d17 = length > 17 ? this._getByDependency(provider, deps[17], visibility) : null;
        d18 = length > 18 ? this._getByDependency(provider, deps[18], visibility) : null;
        d19 = length > 19 ? this._getByDependency(provider, deps[19], visibility) : null;
      } catch (e) {
        if (e instanceof exceptions_1.AbstractProviderError || e instanceof exceptions_1.InstantiationError) {
          e.addKey(this, provider.key);
        }
        throw e;
      }
      var obj;
      try {
        switch (length) {
          case 0:
            obj = factory();
            break;
          case 1:
            obj = factory(d0);
            break;
          case 2:
            obj = factory(d0, d1);
            break;
          case 3:
            obj = factory(d0, d1, d2);
            break;
          case 4:
            obj = factory(d0, d1, d2, d3);
            break;
          case 5:
            obj = factory(d0, d1, d2, d3, d4);
            break;
          case 6:
            obj = factory(d0, d1, d2, d3, d4, d5);
            break;
          case 7:
            obj = factory(d0, d1, d2, d3, d4, d5, d6);
            break;
          case 8:
            obj = factory(d0, d1, d2, d3, d4, d5, d6, d7);
            break;
          case 9:
            obj = factory(d0, d1, d2, d3, d4, d5, d6, d7, d8);
            break;
          case 10:
            obj = factory(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9);
            break;
          case 11:
            obj = factory(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10);
            break;
          case 12:
            obj = factory(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11);
            break;
          case 13:
            obj = factory(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
            break;
          case 14:
            obj = factory(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13);
            break;
          case 15:
            obj = factory(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14);
            break;
          case 16:
            obj = factory(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15);
            break;
          case 17:
            obj = factory(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16);
            break;
          case 18:
            obj = factory(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16, d17);
            break;
          case 19:
            obj = factory(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16, d17, d18);
            break;
          case 20:
            obj = factory(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16, d17, d18, d19);
            break;
          default:
            throw new exceptions_2.BaseException("Cannot instantiate '" + provider.key.displayName + "' because it has more than 20 dependencies");
        }
      } catch (e) {
        throw new exceptions_1.InstantiationError(this, e, e.stack, provider.key);
      }
      return obj;
    };
    Injector.prototype._getByDependency = function(provider, dep, providerVisibility) {
      var special = lang_1.isPresent(this._depProvider) ? this._depProvider.getDependency(this, provider, dep) : exports.UNDEFINED;
      if (special !== exports.UNDEFINED) {
        return special;
      } else {
        return this._getByKey(dep.key, dep.lowerBoundVisibility, dep.upperBoundVisibility, dep.optional, providerVisibility);
      }
    };
    Injector.prototype._getByKey = function(key, lowerBoundVisibility, upperBoundVisibility, optional, providerVisibility) {
      if (key === INJECTOR_KEY) {
        return this;
      }
      if (upperBoundVisibility instanceof metadata_1.SelfMetadata) {
        return this._getByKeySelf(key, optional, providerVisibility);
      } else if (upperBoundVisibility instanceof metadata_1.HostMetadata) {
        return this._getByKeyHost(key, optional, providerVisibility, lowerBoundVisibility);
      } else {
        return this._getByKeyDefault(key, optional, providerVisibility, lowerBoundVisibility);
      }
    };
    Injector.prototype._throwOrNull = function(key, optional) {
      if (optional) {
        return null;
      } else {
        throw new exceptions_1.NoProviderError(this, key);
      }
    };
    Injector.prototype._getByKeySelf = function(key, optional, providerVisibility) {
      var obj = this._strategy.getObjByKeyId(key.id, providerVisibility);
      return (obj !== exports.UNDEFINED) ? obj : this._throwOrNull(key, optional);
    };
    Injector.prototype._getByKeyHost = function(key, optional, providerVisibility, lowerBoundVisibility) {
      var inj = this;
      if (lowerBoundVisibility instanceof metadata_1.SkipSelfMetadata) {
        if (inj._isHostBoundary) {
          return this._getPrivateDependency(key, optional, inj);
        } else {
          inj = inj._parent;
        }
      }
      while (inj != null) {
        var obj = inj._strategy.getObjByKeyId(key.id, providerVisibility);
        if (obj !== exports.UNDEFINED)
          return obj;
        if (lang_1.isPresent(inj._parent) && inj._isHostBoundary) {
          return this._getPrivateDependency(key, optional, inj);
        } else {
          inj = inj._parent;
        }
      }
      return this._throwOrNull(key, optional);
    };
    Injector.prototype._getPrivateDependency = function(key, optional, inj) {
      var obj = inj._parent._strategy.getObjByKeyId(key.id, Visibility.Private);
      return (obj !== exports.UNDEFINED) ? obj : this._throwOrNull(key, optional);
    };
    Injector.prototype._getByKeyDefault = function(key, optional, providerVisibility, lowerBoundVisibility) {
      var inj = this;
      if (lowerBoundVisibility instanceof metadata_1.SkipSelfMetadata) {
        providerVisibility = inj._isHostBoundary ? Visibility.PublicAndPrivate : Visibility.Public;
        inj = inj._parent;
      }
      while (inj != null) {
        var obj = inj._strategy.getObjByKeyId(key.id, providerVisibility);
        if (obj !== exports.UNDEFINED)
          return obj;
        providerVisibility = inj._isHostBoundary ? Visibility.PublicAndPrivate : Visibility.Public;
        inj = inj._parent;
      }
      return this._throwOrNull(key, optional);
    };
    Object.defineProperty(Injector.prototype, "displayName", {
      get: function() {
        return "Injector(providers: [" + _mapProviders(this, function(b) {
          return (" \"" + b.key.displayName + "\" ");
        }).join(", ") + "])";
      },
      enumerable: true,
      configurable: true
    });
    Injector.prototype.toString = function() {
      return this.displayName;
    };
    return Injector;
  })();
  exports.Injector = Injector;
  var INJECTOR_KEY = key_1.Key.get(Injector);
  function _mapProviders(injector, fn) {
    var res = [];
    for (var i = 0; i < injector._proto.numberOfProviders; ++i) {
      res.push(fn(injector._proto.getProviderAtIndex(i)));
    }
    return res;
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/animate/animation_builder", ["angular2/src/core/di", "angular2/src/animate/css_animation_builder", "angular2/src/animate/browser_details"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var di_1 = require("angular2/src/core/di");
  var css_animation_builder_1 = require("angular2/src/animate/css_animation_builder");
  var browser_details_1 = require("angular2/src/animate/browser_details");
  var AnimationBuilder = (function() {
    function AnimationBuilder(browserDetails) {
      this.browserDetails = browserDetails;
    }
    AnimationBuilder.prototype.css = function() {
      return new css_animation_builder_1.CssAnimationBuilder(this.browserDetails);
    };
    AnimationBuilder = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [browser_details_1.BrowserDetails])], AnimationBuilder);
    return AnimationBuilder;
  })();
  exports.AnimationBuilder = AnimationBuilder;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/proto_change_detector", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection", "angular2/src/core/change_detection/parser/ast", "angular2/src/core/change_detection/change_detection_util", "angular2/src/core/change_detection/dynamic_change_detector", "angular2/src/core/change_detection/directive_record", "angular2/src/core/change_detection/event_binding", "angular2/src/core/change_detection/coalesce", "angular2/src/core/change_detection/proto_record"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var ast_1 = require("angular2/src/core/change_detection/parser/ast");
  var change_detection_util_1 = require("angular2/src/core/change_detection/change_detection_util");
  var dynamic_change_detector_1 = require("angular2/src/core/change_detection/dynamic_change_detector");
  var directive_record_1 = require("angular2/src/core/change_detection/directive_record");
  var event_binding_1 = require("angular2/src/core/change_detection/event_binding");
  var coalesce_1 = require("angular2/src/core/change_detection/coalesce");
  var proto_record_1 = require("angular2/src/core/change_detection/proto_record");
  var DynamicProtoChangeDetector = (function() {
    function DynamicProtoChangeDetector(_definition) {
      this._definition = _definition;
      this._propertyBindingRecords = createPropertyRecords(_definition);
      this._eventBindingRecords = createEventRecords(_definition);
      this._propertyBindingTargets = this._definition.bindingRecords.map(function(b) {
        return b.target;
      });
      this._directiveIndices = this._definition.directiveRecords.map(function(d) {
        return d.directiveIndex;
      });
    }
    DynamicProtoChangeDetector.prototype.instantiate = function() {
      return new dynamic_change_detector_1.DynamicChangeDetector(this._definition.id, this._propertyBindingRecords.length, this._propertyBindingTargets, this._directiveIndices, this._definition.strategy, this._propertyBindingRecords, this._eventBindingRecords, this._definition.directiveRecords, this._definition.genConfig);
    };
    return DynamicProtoChangeDetector;
  })();
  exports.DynamicProtoChangeDetector = DynamicProtoChangeDetector;
  function createPropertyRecords(definition) {
    var recordBuilder = new ProtoRecordBuilder();
    collection_1.ListWrapper.forEachWithIndex(definition.bindingRecords, function(b, index) {
      return recordBuilder.add(b, definition.variableNames, index);
    });
    return coalesce_1.coalesce(recordBuilder.records);
  }
  exports.createPropertyRecords = createPropertyRecords;
  function createEventRecords(definition) {
    var varNames = collection_1.ListWrapper.concat(['$event'], definition.variableNames);
    return definition.eventRecords.map(function(er) {
      var records = _ConvertAstIntoProtoRecords.create(er, varNames);
      var dirIndex = er.implicitReceiver instanceof directive_record_1.DirectiveIndex ? er.implicitReceiver : null;
      return new event_binding_1.EventBinding(er.target.name, er.target.elementIndex, dirIndex, records);
    });
  }
  exports.createEventRecords = createEventRecords;
  var ProtoRecordBuilder = (function() {
    function ProtoRecordBuilder() {
      this.records = [];
    }
    ProtoRecordBuilder.prototype.add = function(b, variableNames, bindingIndex) {
      var oldLast = collection_1.ListWrapper.last(this.records);
      if (lang_1.isPresent(oldLast) && oldLast.bindingRecord.directiveRecord == b.directiveRecord) {
        oldLast.lastInDirective = false;
      }
      var numberOfRecordsBefore = this.records.length;
      this._appendRecords(b, variableNames, bindingIndex);
      var newLast = collection_1.ListWrapper.last(this.records);
      if (lang_1.isPresent(newLast) && newLast !== oldLast) {
        newLast.lastInBinding = true;
        newLast.lastInDirective = true;
        this._setArgumentToPureFunction(numberOfRecordsBefore);
      }
    };
    ProtoRecordBuilder.prototype._setArgumentToPureFunction = function(startIndex) {
      var _this = this;
      for (var i = startIndex; i < this.records.length; ++i) {
        var rec = this.records[i];
        if (rec.isPureFunction()) {
          rec.args.forEach(function(recordIndex) {
            return _this.records[recordIndex - 1].argumentToPureFunction = true;
          });
        }
        if (rec.mode === proto_record_1.RecordType.Pipe) {
          rec.args.forEach(function(recordIndex) {
            return _this.records[recordIndex - 1].argumentToPureFunction = true;
          });
          this.records[rec.contextIndex - 1].argumentToPureFunction = true;
        }
      }
    };
    ProtoRecordBuilder.prototype._appendRecords = function(b, variableNames, bindingIndex) {
      if (b.isDirectiveLifecycle()) {
        this.records.push(new proto_record_1.ProtoRecord(proto_record_1.RecordType.DirectiveLifecycle, b.lifecycleEvent, null, [], [], -1, null, this.records.length + 1, b, false, false, false, false, null));
      } else {
        _ConvertAstIntoProtoRecords.append(this.records, b, variableNames, bindingIndex);
      }
    };
    return ProtoRecordBuilder;
  })();
  exports.ProtoRecordBuilder = ProtoRecordBuilder;
  var _ConvertAstIntoProtoRecords = (function() {
    function _ConvertAstIntoProtoRecords(_records, _bindingRecord, _variableNames, _bindingIndex) {
      this._records = _records;
      this._bindingRecord = _bindingRecord;
      this._variableNames = _variableNames;
      this._bindingIndex = _bindingIndex;
    }
    _ConvertAstIntoProtoRecords.append = function(records, b, variableNames, bindingIndex) {
      var c = new _ConvertAstIntoProtoRecords(records, b, variableNames, bindingIndex);
      b.ast.visit(c);
    };
    _ConvertAstIntoProtoRecords.create = function(b, variableNames) {
      var rec = [];
      _ConvertAstIntoProtoRecords.append(rec, b, variableNames, null);
      rec[rec.length - 1].lastInBinding = true;
      return rec;
    };
    _ConvertAstIntoProtoRecords.prototype.visitImplicitReceiver = function(ast) {
      return this._bindingRecord.implicitReceiver;
    };
    _ConvertAstIntoProtoRecords.prototype.visitInterpolation = function(ast) {
      var args = this._visitAll(ast.expressions);
      return this._addRecord(proto_record_1.RecordType.Interpolate, "interpolate", _interpolationFn(ast.strings), args, ast.strings, 0);
    };
    _ConvertAstIntoProtoRecords.prototype.visitLiteralPrimitive = function(ast) {
      return this._addRecord(proto_record_1.RecordType.Const, "literal", ast.value, [], null, 0);
    };
    _ConvertAstIntoProtoRecords.prototype.visitPropertyRead = function(ast) {
      var receiver = ast.receiver.visit(this);
      if (lang_1.isPresent(this._variableNames) && collection_1.ListWrapper.contains(this._variableNames, ast.name) && ast.receiver instanceof ast_1.ImplicitReceiver) {
        return this._addRecord(proto_record_1.RecordType.Local, ast.name, ast.name, [], null, receiver);
      } else {
        return this._addRecord(proto_record_1.RecordType.PropertyRead, ast.name, ast.getter, [], null, receiver);
      }
    };
    _ConvertAstIntoProtoRecords.prototype.visitPropertyWrite = function(ast) {
      if (lang_1.isPresent(this._variableNames) && collection_1.ListWrapper.contains(this._variableNames, ast.name) && ast.receiver instanceof ast_1.ImplicitReceiver) {
        throw new exceptions_1.BaseException("Cannot reassign a variable binding " + ast.name);
      } else {
        var receiver = ast.receiver.visit(this);
        var value = ast.value.visit(this);
        return this._addRecord(proto_record_1.RecordType.PropertyWrite, ast.name, ast.setter, [value], null, receiver);
      }
    };
    _ConvertAstIntoProtoRecords.prototype.visitKeyedWrite = function(ast) {
      var obj = ast.obj.visit(this);
      var key = ast.key.visit(this);
      var value = ast.value.visit(this);
      return this._addRecord(proto_record_1.RecordType.KeyedWrite, null, null, [key, value], null, obj);
    };
    _ConvertAstIntoProtoRecords.prototype.visitSafePropertyRead = function(ast) {
      var receiver = ast.receiver.visit(this);
      return this._addRecord(proto_record_1.RecordType.SafeProperty, ast.name, ast.getter, [], null, receiver);
    };
    _ConvertAstIntoProtoRecords.prototype.visitMethodCall = function(ast) {
      var receiver = ast.receiver.visit(this);
      var args = this._visitAll(ast.args);
      if (lang_1.isPresent(this._variableNames) && collection_1.ListWrapper.contains(this._variableNames, ast.name)) {
        var target = this._addRecord(proto_record_1.RecordType.Local, ast.name, ast.name, [], null, receiver);
        return this._addRecord(proto_record_1.RecordType.InvokeClosure, "closure", null, args, null, target);
      } else {
        return this._addRecord(proto_record_1.RecordType.InvokeMethod, ast.name, ast.fn, args, null, receiver);
      }
    };
    _ConvertAstIntoProtoRecords.prototype.visitSafeMethodCall = function(ast) {
      var receiver = ast.receiver.visit(this);
      var args = this._visitAll(ast.args);
      return this._addRecord(proto_record_1.RecordType.SafeMethodInvoke, ast.name, ast.fn, args, null, receiver);
    };
    _ConvertAstIntoProtoRecords.prototype.visitFunctionCall = function(ast) {
      var target = ast.target.visit(this);
      var args = this._visitAll(ast.args);
      return this._addRecord(proto_record_1.RecordType.InvokeClosure, "closure", null, args, null, target);
    };
    _ConvertAstIntoProtoRecords.prototype.visitLiteralArray = function(ast) {
      var primitiveName = "arrayFn" + ast.expressions.length;
      return this._addRecord(proto_record_1.RecordType.CollectionLiteral, primitiveName, _arrayFn(ast.expressions.length), this._visitAll(ast.expressions), null, 0);
    };
    _ConvertAstIntoProtoRecords.prototype.visitLiteralMap = function(ast) {
      return this._addRecord(proto_record_1.RecordType.CollectionLiteral, _mapPrimitiveName(ast.keys), change_detection_util_1.ChangeDetectionUtil.mapFn(ast.keys), this._visitAll(ast.values), null, 0);
    };
    _ConvertAstIntoProtoRecords.prototype.visitBinary = function(ast) {
      var left = ast.left.visit(this);
      switch (ast.operation) {
        case '&&':
          var branchEnd = [null];
          this._addRecord(proto_record_1.RecordType.SkipRecordsIfNot, "SkipRecordsIfNot", null, [], branchEnd, left);
          var right = ast.right.visit(this);
          branchEnd[0] = right;
          return this._addRecord(proto_record_1.RecordType.PrimitiveOp, "cond", change_detection_util_1.ChangeDetectionUtil.cond, [left, right, left], null, 0);
        case '||':
          var branchEnd = [null];
          this._addRecord(proto_record_1.RecordType.SkipRecordsIf, "SkipRecordsIf", null, [], branchEnd, left);
          var right = ast.right.visit(this);
          branchEnd[0] = right;
          return this._addRecord(proto_record_1.RecordType.PrimitiveOp, "cond", change_detection_util_1.ChangeDetectionUtil.cond, [left, left, right], null, 0);
        default:
          var right = ast.right.visit(this);
          return this._addRecord(proto_record_1.RecordType.PrimitiveOp, _operationToPrimitiveName(ast.operation), _operationToFunction(ast.operation), [left, right], null, 0);
      }
    };
    _ConvertAstIntoProtoRecords.prototype.visitPrefixNot = function(ast) {
      var exp = ast.expression.visit(this);
      return this._addRecord(proto_record_1.RecordType.PrimitiveOp, "operation_negate", change_detection_util_1.ChangeDetectionUtil.operation_negate, [exp], null, 0);
    };
    _ConvertAstIntoProtoRecords.prototype.visitConditional = function(ast) {
      var condition = ast.condition.visit(this);
      var startOfFalseBranch = [null];
      var endOfFalseBranch = [null];
      this._addRecord(proto_record_1.RecordType.SkipRecordsIfNot, "SkipRecordsIfNot", null, [], startOfFalseBranch, condition);
      var whenTrue = ast.trueExp.visit(this);
      var skip = this._addRecord(proto_record_1.RecordType.SkipRecords, "SkipRecords", null, [], endOfFalseBranch, 0);
      var whenFalse = ast.falseExp.visit(this);
      startOfFalseBranch[0] = skip;
      endOfFalseBranch[0] = whenFalse;
      return this._addRecord(proto_record_1.RecordType.PrimitiveOp, "cond", change_detection_util_1.ChangeDetectionUtil.cond, [condition, whenTrue, whenFalse], null, 0);
    };
    _ConvertAstIntoProtoRecords.prototype.visitPipe = function(ast) {
      var value = ast.exp.visit(this);
      var args = this._visitAll(ast.args);
      return this._addRecord(proto_record_1.RecordType.Pipe, ast.name, ast.name, args, null, value);
    };
    _ConvertAstIntoProtoRecords.prototype.visitKeyedRead = function(ast) {
      var obj = ast.obj.visit(this);
      var key = ast.key.visit(this);
      return this._addRecord(proto_record_1.RecordType.KeyedRead, "keyedAccess", change_detection_util_1.ChangeDetectionUtil.keyedAccess, [key], null, obj);
    };
    _ConvertAstIntoProtoRecords.prototype.visitChain = function(ast) {
      var _this = this;
      var args = ast.expressions.map(function(e) {
        return e.visit(_this);
      });
      return this._addRecord(proto_record_1.RecordType.Chain, "chain", null, args, null, 0);
    };
    _ConvertAstIntoProtoRecords.prototype.visitQuote = function(ast) {
      throw new exceptions_1.BaseException(("Caught uninterpreted expression at " + ast.location + ": " + ast.uninterpretedExpression + ". ") + ("Expression prefix " + ast.prefix + " did not match a template transformer to interpret the expression."));
    };
    _ConvertAstIntoProtoRecords.prototype._visitAll = function(asts) {
      var res = collection_1.ListWrapper.createFixedSize(asts.length);
      for (var i = 0; i < asts.length; ++i) {
        res[i] = asts[i].visit(this);
      }
      return res;
    };
    _ConvertAstIntoProtoRecords.prototype._addRecord = function(type, name, funcOrValue, args, fixedArgs, context) {
      var selfIndex = this._records.length + 1;
      if (context instanceof directive_record_1.DirectiveIndex) {
        this._records.push(new proto_record_1.ProtoRecord(type, name, funcOrValue, args, fixedArgs, -1, context, selfIndex, this._bindingRecord, false, false, false, false, this._bindingIndex));
      } else {
        this._records.push(new proto_record_1.ProtoRecord(type, name, funcOrValue, args, fixedArgs, context, null, selfIndex, this._bindingRecord, false, false, false, false, this._bindingIndex));
      }
      return selfIndex;
    };
    return _ConvertAstIntoProtoRecords;
  })();
  function _arrayFn(length) {
    switch (length) {
      case 0:
        return change_detection_util_1.ChangeDetectionUtil.arrayFn0;
      case 1:
        return change_detection_util_1.ChangeDetectionUtil.arrayFn1;
      case 2:
        return change_detection_util_1.ChangeDetectionUtil.arrayFn2;
      case 3:
        return change_detection_util_1.ChangeDetectionUtil.arrayFn3;
      case 4:
        return change_detection_util_1.ChangeDetectionUtil.arrayFn4;
      case 5:
        return change_detection_util_1.ChangeDetectionUtil.arrayFn5;
      case 6:
        return change_detection_util_1.ChangeDetectionUtil.arrayFn6;
      case 7:
        return change_detection_util_1.ChangeDetectionUtil.arrayFn7;
      case 8:
        return change_detection_util_1.ChangeDetectionUtil.arrayFn8;
      case 9:
        return change_detection_util_1.ChangeDetectionUtil.arrayFn9;
      default:
        throw new exceptions_1.BaseException("Does not support literal maps with more than 9 elements");
    }
  }
  function _mapPrimitiveName(keys) {
    var stringifiedKeys = keys.map(function(k) {
      return lang_1.isString(k) ? "\"" + k + "\"" : "" + k;
    }).join(', ');
    return "mapFn([" + stringifiedKeys + "])";
  }
  function _operationToPrimitiveName(operation) {
    switch (operation) {
      case '+':
        return "operation_add";
      case '-':
        return "operation_subtract";
      case '*':
        return "operation_multiply";
      case '/':
        return "operation_divide";
      case '%':
        return "operation_remainder";
      case '==':
        return "operation_equals";
      case '!=':
        return "operation_not_equals";
      case '===':
        return "operation_identical";
      case '!==':
        return "operation_not_identical";
      case '<':
        return "operation_less_then";
      case '>':
        return "operation_greater_then";
      case '<=':
        return "operation_less_or_equals_then";
      case '>=':
        return "operation_greater_or_equals_then";
      default:
        throw new exceptions_1.BaseException("Unsupported operation " + operation);
    }
  }
  function _operationToFunction(operation) {
    switch (operation) {
      case '+':
        return change_detection_util_1.ChangeDetectionUtil.operation_add;
      case '-':
        return change_detection_util_1.ChangeDetectionUtil.operation_subtract;
      case '*':
        return change_detection_util_1.ChangeDetectionUtil.operation_multiply;
      case '/':
        return change_detection_util_1.ChangeDetectionUtil.operation_divide;
      case '%':
        return change_detection_util_1.ChangeDetectionUtil.operation_remainder;
      case '==':
        return change_detection_util_1.ChangeDetectionUtil.operation_equals;
      case '!=':
        return change_detection_util_1.ChangeDetectionUtil.operation_not_equals;
      case '===':
        return change_detection_util_1.ChangeDetectionUtil.operation_identical;
      case '!==':
        return change_detection_util_1.ChangeDetectionUtil.operation_not_identical;
      case '<':
        return change_detection_util_1.ChangeDetectionUtil.operation_less_then;
      case '>':
        return change_detection_util_1.ChangeDetectionUtil.operation_greater_then;
      case '<=':
        return change_detection_util_1.ChangeDetectionUtil.operation_less_or_equals_then;
      case '>=':
        return change_detection_util_1.ChangeDetectionUtil.operation_greater_or_equals_then;
      default:
        throw new exceptions_1.BaseException("Unsupported operation " + operation);
    }
  }
  function s(v) {
    return lang_1.isPresent(v) ? "" + v : '';
  }
  function _interpolationFn(strings) {
    var length = strings.length;
    var c0 = length > 0 ? strings[0] : null;
    var c1 = length > 1 ? strings[1] : null;
    var c2 = length > 2 ? strings[2] : null;
    var c3 = length > 3 ? strings[3] : null;
    var c4 = length > 4 ? strings[4] : null;
    var c5 = length > 5 ? strings[5] : null;
    var c6 = length > 6 ? strings[6] : null;
    var c7 = length > 7 ? strings[7] : null;
    var c8 = length > 8 ? strings[8] : null;
    var c9 = length > 9 ? strings[9] : null;
    switch (length - 1) {
      case 1:
        return function(a1) {
          return c0 + s(a1) + c1;
        };
      case 2:
        return function(a1, a2) {
          return c0 + s(a1) + c1 + s(a2) + c2;
        };
      case 3:
        return function(a1, a2, a3) {
          return c0 + s(a1) + c1 + s(a2) + c2 + s(a3) + c3;
        };
      case 4:
        return function(a1, a2, a3, a4) {
          return c0 + s(a1) + c1 + s(a2) + c2 + s(a3) + c3 + s(a4) + c4;
        };
      case 5:
        return function(a1, a2, a3, a4, a5) {
          return c0 + s(a1) + c1 + s(a2) + c2 + s(a3) + c3 + s(a4) + c4 + s(a5) + c5;
        };
      case 6:
        return function(a1, a2, a3, a4, a5, a6) {
          return c0 + s(a1) + c1 + s(a2) + c2 + s(a3) + c3 + s(a4) + c4 + s(a5) + c5 + s(a6) + c6;
        };
      case 7:
        return function(a1, a2, a3, a4, a5, a6, a7) {
          return c0 + s(a1) + c1 + s(a2) + c2 + s(a3) + c3 + s(a4) + c4 + s(a5) + c5 + s(a6) + c6 + s(a7) + c7;
        };
      case 8:
        return function(a1, a2, a3, a4, a5, a6, a7, a8) {
          return c0 + s(a1) + c1 + s(a2) + c2 + s(a3) + c3 + s(a4) + c4 + s(a5) + c5 + s(a6) + c6 + s(a7) + c7 + s(a8) + c8;
        };
      case 9:
        return function(a1, a2, a3, a4, a5, a6, a7, a8, a9) {
          return c0 + s(a1) + c1 + s(a2) + c2 + s(a3) + c3 + s(a4) + c4 + s(a5) + c5 + s(a6) + c6 + s(a7) + c7 + s(a8) + c8 + s(a9) + c9;
        };
      default:
        throw new exceptions_1.BaseException("Does not support more than 9 expressions");
    }
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/jit_proto_change_detector", ["angular2/src/core/change_detection/change_detection_jit_generator"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var change_detection_jit_generator_1 = require("angular2/src/core/change_detection/change_detection_jit_generator");
  var JitProtoChangeDetector = (function() {
    function JitProtoChangeDetector(definition) {
      this.definition = definition;
      this._factory = this._createFactory(definition);
    }
    JitProtoChangeDetector.isSupported = function() {
      return true;
    };
    JitProtoChangeDetector.prototype.instantiate = function() {
      return this._factory();
    };
    JitProtoChangeDetector.prototype._createFactory = function(definition) {
      return new change_detection_jit_generator_1.ChangeDetectorJITGenerator(definition, 'util', 'AbstractChangeDetector', 'ChangeDetectorStatus').generate();
    };
    return JitProtoChangeDetector;
  })();
  exports.JitProtoChangeDetector = JitProtoChangeDetector;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/compiler", ["angular2/src/core/di", "angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/async", "angular2/src/core/reflection/reflection", "angular2/src/core/linker/view", "angular2/src/core/linker/view_ref"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var di_1 = require("angular2/src/core/di");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var async_1 = require("angular2/src/facade/async");
  var reflection_1 = require("angular2/src/core/reflection/reflection");
  var view_1 = require("angular2/src/core/linker/view");
  var view_ref_1 = require("angular2/src/core/linker/view_ref");
  var Compiler = (function() {
    function Compiler() {}
    return Compiler;
  })();
  exports.Compiler = Compiler;
  function isHostViewFactory(type) {
    return type instanceof view_1.HostViewFactory;
  }
  var Compiler_ = (function(_super) {
    __extends(Compiler_, _super);
    function Compiler_() {
      _super.apply(this, arguments);
    }
    Compiler_.prototype.compileInHost = function(componentType) {
      var metadatas = reflection_1.reflector.annotations(componentType);
      var hostViewFactory = metadatas.find(isHostViewFactory);
      if (lang_1.isBlank(hostViewFactory)) {
        throw new exceptions_1.BaseException("No precompiled component " + lang_1.stringify(componentType) + " found");
      }
      return async_1.PromiseWrapper.resolve(new view_ref_1.HostViewFactoryRef_(hostViewFactory));
    };
    Compiler_.prototype.clearCache = function() {};
    Compiler_ = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [])], Compiler_);
    return Compiler_;
  })(Compiler);
  exports.Compiler_ = Compiler_;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/di", ["angular2/src/core/di/metadata", "angular2/src/core/di/decorators", "angular2/src/core/di/forward_ref", "angular2/src/core/di/injector", "angular2/src/core/di/provider", "angular2/src/core/di/key", "angular2/src/core/di/exceptions", "angular2/src/core/di/opaque_token"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  function __export(m) {
    for (var p in m)
      if (!exports.hasOwnProperty(p))
        exports[p] = m[p];
  }
  var metadata_1 = require("angular2/src/core/di/metadata");
  exports.InjectMetadata = metadata_1.InjectMetadata;
  exports.OptionalMetadata = metadata_1.OptionalMetadata;
  exports.InjectableMetadata = metadata_1.InjectableMetadata;
  exports.SelfMetadata = metadata_1.SelfMetadata;
  exports.HostMetadata = metadata_1.HostMetadata;
  exports.SkipSelfMetadata = metadata_1.SkipSelfMetadata;
  exports.DependencyMetadata = metadata_1.DependencyMetadata;
  __export(require("angular2/src/core/di/decorators"));
  var forward_ref_1 = require("angular2/src/core/di/forward_ref");
  exports.forwardRef = forward_ref_1.forwardRef;
  exports.resolveForwardRef = forward_ref_1.resolveForwardRef;
  var injector_1 = require("angular2/src/core/di/injector");
  exports.Injector = injector_1.Injector;
  var provider_1 = require("angular2/src/core/di/provider");
  exports.Binding = provider_1.Binding;
  exports.ProviderBuilder = provider_1.ProviderBuilder;
  exports.ResolvedFactory = provider_1.ResolvedFactory;
  exports.Dependency = provider_1.Dependency;
  exports.bind = provider_1.bind;
  exports.Provider = provider_1.Provider;
  exports.provide = provider_1.provide;
  var key_1 = require("angular2/src/core/di/key");
  exports.Key = key_1.Key;
  exports.TypeLiteral = key_1.TypeLiteral;
  var exceptions_1 = require("angular2/src/core/di/exceptions");
  exports.NoProviderError = exceptions_1.NoProviderError;
  exports.AbstractProviderError = exceptions_1.AbstractProviderError;
  exports.CyclicDependencyError = exceptions_1.CyclicDependencyError;
  exports.InstantiationError = exceptions_1.InstantiationError;
  exports.InvalidProviderError = exceptions_1.InvalidProviderError;
  exports.NoAnnotationError = exceptions_1.NoAnnotationError;
  exports.OutOfBoundsError = exceptions_1.OutOfBoundsError;
  var opaque_token_1 = require("angular2/src/core/di/opaque_token");
  exports.OpaqueToken = opaque_token_1.OpaqueToken;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection/change_detection", ["angular2/src/core/change_detection/differs/iterable_differs", "angular2/src/core/change_detection/differs/default_iterable_differ", "angular2/src/core/change_detection/differs/keyvalue_differs", "angular2/src/core/change_detection/differs/default_keyvalue_differ", "angular2/src/facade/lang", "angular2/src/core/change_detection/parser/ast", "angular2/src/core/change_detection/parser/lexer", "angular2/src/core/change_detection/parser/parser", "angular2/src/core/change_detection/parser/locals", "angular2/src/core/change_detection/exceptions", "angular2/src/core/change_detection/interfaces", "angular2/src/core/change_detection/constants", "angular2/src/core/change_detection/proto_change_detector", "angular2/src/core/change_detection/jit_proto_change_detector", "angular2/src/core/change_detection/binding_record", "angular2/src/core/change_detection/directive_record", "angular2/src/core/change_detection/dynamic_change_detector", "angular2/src/core/change_detection/change_detector_ref", "angular2/src/core/change_detection/differs/iterable_differs", "angular2/src/core/change_detection/differs/keyvalue_differs", "angular2/src/core/change_detection/change_detection_util"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var iterable_differs_1 = require("angular2/src/core/change_detection/differs/iterable_differs");
  var default_iterable_differ_1 = require("angular2/src/core/change_detection/differs/default_iterable_differ");
  var keyvalue_differs_1 = require("angular2/src/core/change_detection/differs/keyvalue_differs");
  var default_keyvalue_differ_1 = require("angular2/src/core/change_detection/differs/default_keyvalue_differ");
  var lang_1 = require("angular2/src/facade/lang");
  var ast_1 = require("angular2/src/core/change_detection/parser/ast");
  exports.ASTWithSource = ast_1.ASTWithSource;
  exports.AST = ast_1.AST;
  exports.AstTransformer = ast_1.AstTransformer;
  exports.PropertyRead = ast_1.PropertyRead;
  exports.LiteralArray = ast_1.LiteralArray;
  exports.ImplicitReceiver = ast_1.ImplicitReceiver;
  var lexer_1 = require("angular2/src/core/change_detection/parser/lexer");
  exports.Lexer = lexer_1.Lexer;
  var parser_1 = require("angular2/src/core/change_detection/parser/parser");
  exports.Parser = parser_1.Parser;
  var locals_1 = require("angular2/src/core/change_detection/parser/locals");
  exports.Locals = locals_1.Locals;
  var exceptions_1 = require("angular2/src/core/change_detection/exceptions");
  exports.DehydratedException = exceptions_1.DehydratedException;
  exports.ExpressionChangedAfterItHasBeenCheckedException = exceptions_1.ExpressionChangedAfterItHasBeenCheckedException;
  exports.ChangeDetectionError = exceptions_1.ChangeDetectionError;
  var interfaces_1 = require("angular2/src/core/change_detection/interfaces");
  exports.ChangeDetectorDefinition = interfaces_1.ChangeDetectorDefinition;
  exports.DebugContext = interfaces_1.DebugContext;
  exports.ChangeDetectorGenConfig = interfaces_1.ChangeDetectorGenConfig;
  var constants_1 = require("angular2/src/core/change_detection/constants");
  exports.ChangeDetectionStrategy = constants_1.ChangeDetectionStrategy;
  exports.CHANGE_DETECTION_STRATEGY_VALUES = constants_1.CHANGE_DETECTION_STRATEGY_VALUES;
  var proto_change_detector_1 = require("angular2/src/core/change_detection/proto_change_detector");
  exports.DynamicProtoChangeDetector = proto_change_detector_1.DynamicProtoChangeDetector;
  var jit_proto_change_detector_1 = require("angular2/src/core/change_detection/jit_proto_change_detector");
  exports.JitProtoChangeDetector = jit_proto_change_detector_1.JitProtoChangeDetector;
  var binding_record_1 = require("angular2/src/core/change_detection/binding_record");
  exports.BindingRecord = binding_record_1.BindingRecord;
  exports.BindingTarget = binding_record_1.BindingTarget;
  var directive_record_1 = require("angular2/src/core/change_detection/directive_record");
  exports.DirectiveIndex = directive_record_1.DirectiveIndex;
  exports.DirectiveRecord = directive_record_1.DirectiveRecord;
  var dynamic_change_detector_1 = require("angular2/src/core/change_detection/dynamic_change_detector");
  exports.DynamicChangeDetector = dynamic_change_detector_1.DynamicChangeDetector;
  var change_detector_ref_1 = require("angular2/src/core/change_detection/change_detector_ref");
  exports.ChangeDetectorRef = change_detector_ref_1.ChangeDetectorRef;
  var iterable_differs_2 = require("angular2/src/core/change_detection/differs/iterable_differs");
  exports.IterableDiffers = iterable_differs_2.IterableDiffers;
  var keyvalue_differs_2 = require("angular2/src/core/change_detection/differs/keyvalue_differs");
  exports.KeyValueDiffers = keyvalue_differs_2.KeyValueDiffers;
  var change_detection_util_1 = require("angular2/src/core/change_detection/change_detection_util");
  exports.WrappedValue = change_detection_util_1.WrappedValue;
  exports.SimpleChange = change_detection_util_1.SimpleChange;
  exports.keyValDiff = lang_1.CONST_EXPR([lang_1.CONST_EXPR(new default_keyvalue_differ_1.DefaultKeyValueDifferFactory())]);
  exports.iterableDiff = lang_1.CONST_EXPR([lang_1.CONST_EXPR(new default_iterable_differ_1.DefaultIterableDifferFactory())]);
  exports.defaultIterableDiffers = lang_1.CONST_EXPR(new iterable_differs_1.IterableDiffers(exports.iterableDiff));
  exports.defaultKeyValueDiffers = lang_1.CONST_EXPR(new keyvalue_differs_1.KeyValueDiffers(exports.keyValDiff));
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/dynamic_component_loader", ["angular2/src/core/di", "angular2/src/core/linker/compiler", "angular2/src/facade/lang", "angular2/src/core/linker/view_manager"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var di_1 = require("angular2/src/core/di");
  var compiler_1 = require("angular2/src/core/linker/compiler");
  var lang_1 = require("angular2/src/facade/lang");
  var view_manager_1 = require("angular2/src/core/linker/view_manager");
  var ComponentRef = (function() {
    function ComponentRef() {}
    Object.defineProperty(ComponentRef.prototype, "hostView", {
      get: function() {
        return this.location.internalElement.parentView.ref;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(ComponentRef.prototype, "hostComponent", {
      get: function() {
        return this.instance;
      },
      enumerable: true,
      configurable: true
    });
    return ComponentRef;
  })();
  exports.ComponentRef = ComponentRef;
  var ComponentRef_ = (function(_super) {
    __extends(ComponentRef_, _super);
    function ComponentRef_(location, instance, componentType, injector, _dispose) {
      _super.call(this);
      this._dispose = _dispose;
      this.location = location;
      this.instance = instance;
      this.componentType = componentType;
      this.injector = injector;
    }
    Object.defineProperty(ComponentRef_.prototype, "hostComponentType", {
      get: function() {
        return this.componentType;
      },
      enumerable: true,
      configurable: true
    });
    ComponentRef_.prototype.dispose = function() {
      this._dispose();
    };
    return ComponentRef_;
  })(ComponentRef);
  exports.ComponentRef_ = ComponentRef_;
  var DynamicComponentLoader = (function() {
    function DynamicComponentLoader() {}
    return DynamicComponentLoader;
  })();
  exports.DynamicComponentLoader = DynamicComponentLoader;
  var DynamicComponentLoader_ = (function(_super) {
    __extends(DynamicComponentLoader_, _super);
    function DynamicComponentLoader_(_compiler, _viewManager) {
      _super.call(this);
      this._compiler = _compiler;
      this._viewManager = _viewManager;
    }
    DynamicComponentLoader_.prototype.loadAsRoot = function(type, overrideSelector, injector, onDispose, projectableNodes) {
      var _this = this;
      return this._compiler.compileInHost(type).then(function(hostProtoViewRef) {
        var hostViewRef = _this._viewManager.createRootHostView(hostProtoViewRef, overrideSelector, injector, projectableNodes);
        var newLocation = _this._viewManager.getHostElement(hostViewRef);
        var component = _this._viewManager.getComponent(newLocation);
        var dispose = function() {
          if (lang_1.isPresent(onDispose)) {
            onDispose();
          }
          _this._viewManager.destroyRootHostView(hostViewRef);
        };
        return new ComponentRef_(newLocation, component, type, injector, dispose);
      });
    };
    DynamicComponentLoader_.prototype.loadIntoLocation = function(type, hostLocation, anchorName, providers, projectableNodes) {
      if (providers === void 0) {
        providers = null;
      }
      if (projectableNodes === void 0) {
        projectableNodes = null;
      }
      return this.loadNextToLocation(type, this._viewManager.getNamedElementInComponentView(hostLocation, anchorName), providers, projectableNodes);
    };
    DynamicComponentLoader_.prototype.loadNextToLocation = function(type, location, providers, projectableNodes) {
      var _this = this;
      if (providers === void 0) {
        providers = null;
      }
      if (projectableNodes === void 0) {
        projectableNodes = null;
      }
      return this._compiler.compileInHost(type).then(function(hostProtoViewRef) {
        var viewContainer = _this._viewManager.getViewContainer(location);
        var hostViewRef = viewContainer.createHostView(hostProtoViewRef, viewContainer.length, providers, projectableNodes);
        var newLocation = _this._viewManager.getHostElement(hostViewRef);
        var component = _this._viewManager.getComponent(newLocation);
        var dispose = function() {
          var index = viewContainer.indexOf(hostViewRef);
          if (!hostViewRef.destroyed && index !== -1) {
            viewContainer.remove(index);
          }
        };
        return new ComponentRef_(newLocation, component, type, null, dispose);
      });
    };
    DynamicComponentLoader_ = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [compiler_1.Compiler, view_manager_1.AppViewManager])], DynamicComponentLoader_);
    return DynamicComponentLoader_;
  })(DynamicComponentLoader);
  exports.DynamicComponentLoader_ = DynamicComponentLoader_;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/change_detection", ["angular2/src/core/change_detection/change_detection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var change_detection_1 = require("angular2/src/core/change_detection/change_detection");
  exports.ChangeDetectionStrategy = change_detection_1.ChangeDetectionStrategy;
  exports.ExpressionChangedAfterItHasBeenCheckedException = change_detection_1.ExpressionChangedAfterItHasBeenCheckedException;
  exports.ChangeDetectionError = change_detection_1.ChangeDetectionError;
  exports.ChangeDetectorRef = change_detection_1.ChangeDetectorRef;
  exports.WrappedValue = change_detection_1.WrappedValue;
  exports.SimpleChange = change_detection_1.SimpleChange;
  exports.IterableDiffers = change_detection_1.IterableDiffers;
  exports.KeyValueDiffers = change_detection_1.KeyValueDiffers;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/application_ref", ["angular2/src/core/zone/ng_zone", "angular2/src/facade/lang", "angular2/src/core/di", "angular2/src/core/application_tokens", "angular2/src/facade/async", "angular2/src/facade/collection", "angular2/src/core/testability/testability", "angular2/src/core/linker/dynamic_component_loader", "angular2/src/facade/exceptions", "angular2/src/core/console", "angular2/src/core/profile/profile", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var ng_zone_1 = require("angular2/src/core/zone/ng_zone");
  var lang_1 = require("angular2/src/facade/lang");
  var di_1 = require("angular2/src/core/di");
  var application_tokens_1 = require("angular2/src/core/application_tokens");
  var async_1 = require("angular2/src/facade/async");
  var collection_1 = require("angular2/src/facade/collection");
  var testability_1 = require("angular2/src/core/testability/testability");
  var dynamic_component_loader_1 = require("angular2/src/core/linker/dynamic_component_loader");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var console_1 = require("angular2/src/core/console");
  var profile_1 = require("angular2/src/core/profile/profile");
  var lang_2 = require("angular2/src/facade/lang");
  function _componentProviders(appComponentType) {
    return [di_1.provide(application_tokens_1.APP_COMPONENT, {useValue: appComponentType}), di_1.provide(application_tokens_1.APP_COMPONENT_REF_PROMISE, {
      useFactory: function(dynamicComponentLoader, appRef, injector) {
        var ref;
        return dynamicComponentLoader.loadAsRoot(appComponentType, null, injector, function() {
          appRef._unloadComponent(ref);
        }).then(function(componentRef) {
          ref = componentRef;
          var testability = injector.getOptional(testability_1.Testability);
          if (lang_1.isPresent(testability)) {
            injector.get(testability_1.TestabilityRegistry).registerApplication(componentRef.location.nativeElement, testability);
          }
          return componentRef;
        });
      },
      deps: [dynamic_component_loader_1.DynamicComponentLoader, ApplicationRef, di_1.Injector]
    }), di_1.provide(appComponentType, {
      useFactory: function(p) {
        return p.then(function(ref) {
          return ref.instance;
        });
      },
      deps: [application_tokens_1.APP_COMPONENT_REF_PROMISE]
    })];
  }
  function createNgZone() {
    return new ng_zone_1.NgZone({enableLongStackTrace: lang_1.assertionsEnabled()});
  }
  exports.createNgZone = createNgZone;
  var _platform;
  var _platformProviders;
  function platform(providers) {
    lang_2.lockMode();
    if (lang_1.isPresent(_platform)) {
      if (collection_1.ListWrapper.equals(_platformProviders, providers)) {
        return _platform;
      } else {
        throw new exceptions_1.BaseException("platform cannot be initialized with different sets of providers.");
      }
    } else {
      return _createPlatform(providers);
    }
  }
  exports.platform = platform;
  function disposePlatform() {
    if (lang_1.isPresent(_platform)) {
      _platform.dispose();
      _platform = null;
    }
  }
  exports.disposePlatform = disposePlatform;
  function _createPlatform(providers) {
    _platformProviders = providers;
    var injector = di_1.Injector.resolveAndCreate(providers);
    _platform = new PlatformRef_(injector, function() {
      _platform = null;
      _platformProviders = null;
    });
    _runPlatformInitializers(injector);
    return _platform;
  }
  function _runPlatformInitializers(injector) {
    var inits = injector.getOptional(application_tokens_1.PLATFORM_INITIALIZER);
    if (lang_1.isPresent(inits))
      inits.forEach(function(init) {
        return init();
      });
  }
  var PlatformRef = (function() {
    function PlatformRef() {}
    Object.defineProperty(PlatformRef.prototype, "injector", {
      get: function() {
        return exceptions_1.unimplemented();
      },
      enumerable: true,
      configurable: true
    });
    ;
    return PlatformRef;
  })();
  exports.PlatformRef = PlatformRef;
  var PlatformRef_ = (function(_super) {
    __extends(PlatformRef_, _super);
    function PlatformRef_(_injector, _dispose) {
      _super.call(this);
      this._injector = _injector;
      this._dispose = _dispose;
      this._applications = [];
      this._disposeListeners = [];
    }
    PlatformRef_.prototype.registerDisposeListener = function(dispose) {
      this._disposeListeners.push(dispose);
    };
    Object.defineProperty(PlatformRef_.prototype, "injector", {
      get: function() {
        return this._injector;
      },
      enumerable: true,
      configurable: true
    });
    PlatformRef_.prototype.application = function(providers) {
      var app = this._initApp(createNgZone(), providers);
      if (async_1.PromiseWrapper.isPromise(app)) {
        throw new exceptions_1.BaseException("Cannot use asyncronous app initializers with application. Use asyncApplication instead.");
      }
      return app;
    };
    PlatformRef_.prototype.asyncApplication = function(bindingFn, additionalProviders) {
      var _this = this;
      var zone = createNgZone();
      var completer = async_1.PromiseWrapper.completer();
      if (bindingFn === null) {
        completer.resolve(this._initApp(zone, additionalProviders));
      } else {
        zone.run(function() {
          async_1.PromiseWrapper.then(bindingFn(zone), function(providers) {
            if (lang_1.isPresent(additionalProviders)) {
              providers = collection_1.ListWrapper.concat(providers, additionalProviders);
            }
            var promise = _this._initApp(zone, providers);
            completer.resolve(promise);
          });
        });
      }
      return completer.promise;
    };
    PlatformRef_.prototype._initApp = function(zone, providers) {
      var _this = this;
      var injector;
      var app;
      zone.run(function() {
        providers = collection_1.ListWrapper.concat(providers, [di_1.provide(ng_zone_1.NgZone, {useValue: zone}), di_1.provide(ApplicationRef, {
          useFactory: function() {
            return app;
          },
          deps: []
        })]);
        var exceptionHandler;
        try {
          injector = _this.injector.resolveAndCreateChild(providers);
          exceptionHandler = injector.get(exceptions_1.ExceptionHandler);
          zone.overrideOnErrorHandler(function(e, s) {
            return exceptionHandler.call(e, s);
          });
        } catch (e) {
          if (lang_1.isPresent(exceptionHandler)) {
            exceptionHandler.call(e, e.stack);
          } else {
            lang_1.print(e.toString());
          }
        }
      });
      app = new ApplicationRef_(this, zone, injector);
      this._applications.push(app);
      var promise = _runAppInitializers(injector);
      if (promise !== null) {
        return async_1.PromiseWrapper.then(promise, function(_) {
          return app;
        });
      } else {
        return app;
      }
    };
    PlatformRef_.prototype.dispose = function() {
      collection_1.ListWrapper.clone(this._applications).forEach(function(app) {
        return app.dispose();
      });
      this._disposeListeners.forEach(function(dispose) {
        return dispose();
      });
      this._dispose();
    };
    PlatformRef_.prototype._applicationDisposed = function(app) {
      collection_1.ListWrapper.remove(this._applications, app);
    };
    return PlatformRef_;
  })(PlatformRef);
  exports.PlatformRef_ = PlatformRef_;
  function _runAppInitializers(injector) {
    var inits = injector.getOptional(application_tokens_1.APP_INITIALIZER);
    var promises = [];
    if (lang_1.isPresent(inits)) {
      inits.forEach(function(init) {
        var retVal = init();
        if (async_1.PromiseWrapper.isPromise(retVal)) {
          promises.push(retVal);
        }
      });
    }
    if (promises.length > 0) {
      return async_1.PromiseWrapper.all(promises);
    } else {
      return null;
    }
  }
  var ApplicationRef = (function() {
    function ApplicationRef() {}
    Object.defineProperty(ApplicationRef.prototype, "injector", {
      get: function() {
        return exceptions_1.unimplemented();
      },
      enumerable: true,
      configurable: true
    });
    ;
    Object.defineProperty(ApplicationRef.prototype, "zone", {
      get: function() {
        return exceptions_1.unimplemented();
      },
      enumerable: true,
      configurable: true
    });
    ;
    Object.defineProperty(ApplicationRef.prototype, "componentTypes", {
      get: function() {
        return exceptions_1.unimplemented();
      },
      enumerable: true,
      configurable: true
    });
    ;
    return ApplicationRef;
  })();
  exports.ApplicationRef = ApplicationRef;
  var ApplicationRef_ = (function(_super) {
    __extends(ApplicationRef_, _super);
    function ApplicationRef_(_platform, _zone, _injector) {
      var _this = this;
      _super.call(this);
      this._platform = _platform;
      this._zone = _zone;
      this._injector = _injector;
      this._bootstrapListeners = [];
      this._disposeListeners = [];
      this._rootComponents = [];
      this._rootComponentTypes = [];
      this._changeDetectorRefs = [];
      this._runningTick = false;
      this._enforceNoNewChanges = false;
      if (lang_1.isPresent(this._zone)) {
        async_1.ObservableWrapper.subscribe(this._zone.onTurnDone, function(_) {
          _this._zone.run(function() {
            _this.tick();
          });
        });
      }
      this._enforceNoNewChanges = lang_1.assertionsEnabled();
    }
    ApplicationRef_.prototype.registerBootstrapListener = function(listener) {
      this._bootstrapListeners.push(listener);
    };
    ApplicationRef_.prototype.registerDisposeListener = function(dispose) {
      this._disposeListeners.push(dispose);
    };
    ApplicationRef_.prototype.registerChangeDetector = function(changeDetector) {
      this._changeDetectorRefs.push(changeDetector);
    };
    ApplicationRef_.prototype.unregisterChangeDetector = function(changeDetector) {
      collection_1.ListWrapper.remove(this._changeDetectorRefs, changeDetector);
    };
    ApplicationRef_.prototype.bootstrap = function(componentType, providers) {
      var _this = this;
      var completer = async_1.PromiseWrapper.completer();
      this._zone.run(function() {
        var componentProviders = _componentProviders(componentType);
        if (lang_1.isPresent(providers)) {
          componentProviders.push(providers);
        }
        var exceptionHandler = _this._injector.get(exceptions_1.ExceptionHandler);
        _this._rootComponentTypes.push(componentType);
        try {
          var injector = _this._injector.resolveAndCreateChild(componentProviders);
          var compRefToken = injector.get(application_tokens_1.APP_COMPONENT_REF_PROMISE);
          var tick = function(componentRef) {
            _this._loadComponent(componentRef);
            completer.resolve(componentRef);
          };
          var tickResult = async_1.PromiseWrapper.then(compRefToken, tick);
          if (lang_1.IS_DART) {
            async_1.PromiseWrapper.then(tickResult, function(_) {});
          }
          async_1.PromiseWrapper.then(tickResult, null, function(err, stackTrace) {
            return completer.reject(err, stackTrace);
          });
        } catch (e) {
          exceptionHandler.call(e, e.stack);
          completer.reject(e, e.stack);
        }
      });
      return completer.promise.then(function(_) {
        var c = _this._injector.get(console_1.Console);
        if (lang_1.assertionsEnabled()) {
          c.log("Angular 2 is running in the development mode. Call enableProdMode() to enable the production mode.");
        }
        return _;
      });
    };
    ApplicationRef_.prototype._loadComponent = function(ref) {
      var appChangeDetector = ref.location.internalElement.parentView.changeDetector;
      this._changeDetectorRefs.push(appChangeDetector.ref);
      this.tick();
      this._rootComponents.push(ref);
      this._bootstrapListeners.forEach(function(listener) {
        return listener(ref);
      });
    };
    ApplicationRef_.prototype._unloadComponent = function(ref) {
      if (!collection_1.ListWrapper.contains(this._rootComponents, ref)) {
        return ;
      }
      this.unregisterChangeDetector(ref.location.internalElement.parentView.changeDetector.ref);
      collection_1.ListWrapper.remove(this._rootComponents, ref);
    };
    Object.defineProperty(ApplicationRef_.prototype, "injector", {
      get: function() {
        return this._injector;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(ApplicationRef_.prototype, "zone", {
      get: function() {
        return this._zone;
      },
      enumerable: true,
      configurable: true
    });
    ApplicationRef_.prototype.tick = function() {
      if (this._runningTick) {
        throw new exceptions_1.BaseException("ApplicationRef.tick is called recursively");
      }
      var s = ApplicationRef_._tickScope();
      try {
        this._runningTick = true;
        this._changeDetectorRefs.forEach(function(detector) {
          return detector.detectChanges();
        });
        if (this._enforceNoNewChanges) {
          this._changeDetectorRefs.forEach(function(detector) {
            return detector.checkNoChanges();
          });
        }
      } finally {
        this._runningTick = false;
        profile_1.wtfLeave(s);
      }
    };
    ApplicationRef_.prototype.dispose = function() {
      collection_1.ListWrapper.clone(this._rootComponents).forEach(function(ref) {
        return ref.dispose();
      });
      this._disposeListeners.forEach(function(dispose) {
        return dispose();
      });
      this._platform._applicationDisposed(this);
    };
    Object.defineProperty(ApplicationRef_.prototype, "componentTypes", {
      get: function() {
        return this._rootComponentTypes;
      },
      enumerable: true,
      configurable: true
    });
    ApplicationRef_._tickScope = profile_1.wtfCreateScope('ApplicationRef#tick()');
    return ApplicationRef_;
  })(ApplicationRef);
  exports.ApplicationRef_ = ApplicationRef_;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/metadata/directives", ["angular2/src/facade/lang", "angular2/src/core/di/metadata", "angular2/src/core/change_detection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var metadata_1 = require("angular2/src/core/di/metadata");
  var change_detection_1 = require("angular2/src/core/change_detection");
  var DirectiveMetadata = (function(_super) {
    __extends(DirectiveMetadata, _super);
    function DirectiveMetadata(_a) {
      var _b = _a === void 0 ? {} : _a,
          selector = _b.selector,
          inputs = _b.inputs,
          outputs = _b.outputs,
          properties = _b.properties,
          events = _b.events,
          host = _b.host,
          bindings = _b.bindings,
          providers = _b.providers,
          exportAs = _b.exportAs,
          queries = _b.queries;
      _super.call(this);
      this.selector = selector;
      this._inputs = inputs;
      this._properties = properties;
      this._outputs = outputs;
      this._events = events;
      this.host = host;
      this.exportAs = exportAs;
      this.queries = queries;
      this._providers = providers;
      this._bindings = bindings;
    }
    Object.defineProperty(DirectiveMetadata.prototype, "inputs", {
      get: function() {
        return lang_1.isPresent(this._properties) && this._properties.length > 0 ? this._properties : this._inputs;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(DirectiveMetadata.prototype, "properties", {
      get: function() {
        return this.inputs;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(DirectiveMetadata.prototype, "outputs", {
      get: function() {
        return lang_1.isPresent(this._events) && this._events.length > 0 ? this._events : this._outputs;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(DirectiveMetadata.prototype, "events", {
      get: function() {
        return this.outputs;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(DirectiveMetadata.prototype, "providers", {
      get: function() {
        return lang_1.isPresent(this._bindings) && this._bindings.length > 0 ? this._bindings : this._providers;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(DirectiveMetadata.prototype, "bindings", {
      get: function() {
        return this.providers;
      },
      enumerable: true,
      configurable: true
    });
    DirectiveMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [Object])], DirectiveMetadata);
    return DirectiveMetadata;
  })(metadata_1.InjectableMetadata);
  exports.DirectiveMetadata = DirectiveMetadata;
  var ComponentMetadata = (function(_super) {
    __extends(ComponentMetadata, _super);
    function ComponentMetadata(_a) {
      var _b = _a === void 0 ? {} : _a,
          selector = _b.selector,
          inputs = _b.inputs,
          outputs = _b.outputs,
          properties = _b.properties,
          events = _b.events,
          host = _b.host,
          exportAs = _b.exportAs,
          moduleId = _b.moduleId,
          bindings = _b.bindings,
          providers = _b.providers,
          viewBindings = _b.viewBindings,
          viewProviders = _b.viewProviders,
          _c = _b.changeDetection,
          changeDetection = _c === void 0 ? change_detection_1.ChangeDetectionStrategy.Default : _c,
          queries = _b.queries,
          templateUrl = _b.templateUrl,
          template = _b.template,
          styleUrls = _b.styleUrls,
          styles = _b.styles,
          directives = _b.directives,
          pipes = _b.pipes,
          encapsulation = _b.encapsulation;
      _super.call(this, {
        selector: selector,
        inputs: inputs,
        outputs: outputs,
        properties: properties,
        events: events,
        host: host,
        exportAs: exportAs,
        bindings: bindings,
        providers: providers,
        queries: queries
      });
      this.changeDetection = changeDetection;
      this._viewProviders = viewProviders;
      this._viewBindings = viewBindings;
      this.templateUrl = templateUrl;
      this.template = template;
      this.styleUrls = styleUrls;
      this.styles = styles;
      this.directives = directives;
      this.pipes = pipes;
      this.encapsulation = encapsulation;
      this.moduleId = moduleId;
    }
    Object.defineProperty(ComponentMetadata.prototype, "viewProviders", {
      get: function() {
        return lang_1.isPresent(this._viewBindings) && this._viewBindings.length > 0 ? this._viewBindings : this._viewProviders;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(ComponentMetadata.prototype, "viewBindings", {
      get: function() {
        return this.viewProviders;
      },
      enumerable: true,
      configurable: true
    });
    ComponentMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [Object])], ComponentMetadata);
    return ComponentMetadata;
  })(DirectiveMetadata);
  exports.ComponentMetadata = ComponentMetadata;
  var PipeMetadata = (function(_super) {
    __extends(PipeMetadata, _super);
    function PipeMetadata(_a) {
      var name = _a.name,
          pure = _a.pure;
      _super.call(this);
      this.name = name;
      this._pure = pure;
    }
    Object.defineProperty(PipeMetadata.prototype, "pure", {
      get: function() {
        return lang_1.isPresent(this._pure) ? this._pure : true;
      },
      enumerable: true,
      configurable: true
    });
    PipeMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [Object])], PipeMetadata);
    return PipeMetadata;
  })(metadata_1.InjectableMetadata);
  exports.PipeMetadata = PipeMetadata;
  var InputMetadata = (function() {
    function InputMetadata(bindingPropertyName) {
      this.bindingPropertyName = bindingPropertyName;
    }
    InputMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [String])], InputMetadata);
    return InputMetadata;
  })();
  exports.InputMetadata = InputMetadata;
  var OutputMetadata = (function() {
    function OutputMetadata(bindingPropertyName) {
      this.bindingPropertyName = bindingPropertyName;
    }
    OutputMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [String])], OutputMetadata);
    return OutputMetadata;
  })();
  exports.OutputMetadata = OutputMetadata;
  var HostBindingMetadata = (function() {
    function HostBindingMetadata(hostPropertyName) {
      this.hostPropertyName = hostPropertyName;
    }
    HostBindingMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [String])], HostBindingMetadata);
    return HostBindingMetadata;
  })();
  exports.HostBindingMetadata = HostBindingMetadata;
  var HostListenerMetadata = (function() {
    function HostListenerMetadata(eventName, args) {
      this.eventName = eventName;
      this.args = args;
    }
    HostListenerMetadata = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [String, Array])], HostListenerMetadata);
    return HostListenerMetadata;
  })();
  exports.HostListenerMetadata = HostListenerMetadata;
  global.define = __define;
  return module.exports;
});

System.register("angular2/core", ["angular2/src/core/metadata", "angular2/src/core/util", "angular2/src/core/prod_mode", "angular2/src/core/di", "angular2/src/facade/facade", "angular2/src/facade/lang", "angular2/src/core/application_ref", "angular2/src/core/application_tokens", "angular2/src/core/zone", "angular2/src/core/render", "angular2/src/core/linker", "angular2/src/core/debug/debug_node", "angular2/src/core/testability/testability", "angular2/src/core/change_detection", "angular2/src/core/platform_directives_and_pipes", "angular2/src/core/platform_common_providers", "angular2/src/core/application_common_providers", "angular2/src/core/reflection/reflection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  function __export(m) {
    for (var p in m)
      if (!exports.hasOwnProperty(p))
        exports[p] = m[p];
  }
  __export(require("angular2/src/core/metadata"));
  __export(require("angular2/src/core/util"));
  __export(require("angular2/src/core/prod_mode"));
  __export(require("angular2/src/core/di"));
  __export(require("angular2/src/facade/facade"));
  var lang_1 = require("angular2/src/facade/lang");
  exports.enableProdMode = lang_1.enableProdMode;
  var application_ref_1 = require("angular2/src/core/application_ref");
  exports.platform = application_ref_1.platform;
  exports.createNgZone = application_ref_1.createNgZone;
  exports.PlatformRef = application_ref_1.PlatformRef;
  exports.ApplicationRef = application_ref_1.ApplicationRef;
  var application_tokens_1 = require("angular2/src/core/application_tokens");
  exports.APP_ID = application_tokens_1.APP_ID;
  exports.APP_COMPONENT = application_tokens_1.APP_COMPONENT;
  exports.APP_INITIALIZER = application_tokens_1.APP_INITIALIZER;
  exports.PACKAGE_ROOT_URL = application_tokens_1.PACKAGE_ROOT_URL;
  exports.PLATFORM_INITIALIZER = application_tokens_1.PLATFORM_INITIALIZER;
  __export(require("angular2/src/core/zone"));
  __export(require("angular2/src/core/render"));
  __export(require("angular2/src/core/linker"));
  var debug_node_1 = require("angular2/src/core/debug/debug_node");
  exports.DebugElement = debug_node_1.DebugElement;
  exports.DebugNode = debug_node_1.DebugNode;
  exports.asNativeElements = debug_node_1.asNativeElements;
  __export(require("angular2/src/core/testability/testability"));
  __export(require("angular2/src/core/change_detection"));
  __export(require("angular2/src/core/platform_directives_and_pipes"));
  __export(require("angular2/src/core/platform_common_providers"));
  __export(require("angular2/src/core/application_common_providers"));
  __export(require("angular2/src/core/reflection/reflection"));
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/facade/async", ["angular2/src/facade/lang", "angular2/src/facade/promise", "rxjs/Subject", "rxjs/observable/PromiseObservable", "rxjs/operator/toPromise", "rxjs/Observable", "rxjs/Subject"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var lang_1 = require("angular2/src/facade/lang");
  var promise_1 = require("angular2/src/facade/promise");
  exports.PromiseWrapper = promise_1.PromiseWrapper;
  var Subject_1 = require("rxjs/Subject");
  var PromiseObservable_1 = require("rxjs/observable/PromiseObservable");
  var toPromise_1 = require("rxjs/operator/toPromise");
  var Observable_1 = require("rxjs/Observable");
  exports.Observable = Observable_1.Observable;
  var Subject_2 = require("rxjs/Subject");
  exports.Subject = Subject_2.Subject;
  var TimerWrapper = (function() {
    function TimerWrapper() {}
    TimerWrapper.setTimeout = function(fn, millis) {
      return lang_1.global.setTimeout(fn, millis);
    };
    TimerWrapper.clearTimeout = function(id) {
      lang_1.global.clearTimeout(id);
    };
    TimerWrapper.setInterval = function(fn, millis) {
      return lang_1.global.setInterval(fn, millis);
    };
    TimerWrapper.clearInterval = function(id) {
      lang_1.global.clearInterval(id);
    };
    return TimerWrapper;
  })();
  exports.TimerWrapper = TimerWrapper;
  var ObservableWrapper = (function() {
    function ObservableWrapper() {}
    ObservableWrapper.subscribe = function(emitter, onNext, onError, onComplete) {
      if (onComplete === void 0) {
        onComplete = function() {};
      }
      onError = (typeof onError === "function") && onError || lang_1.noop;
      onComplete = (typeof onComplete === "function") && onComplete || lang_1.noop;
      return emitter.subscribe({
        next: onNext,
        error: onError,
        complete: onComplete
      });
    };
    ObservableWrapper.isObservable = function(obs) {
      return !!obs.subscribe;
    };
    ObservableWrapper.hasSubscribers = function(obs) {
      return obs.observers.length > 0;
    };
    ObservableWrapper.dispose = function(subscription) {
      subscription.unsubscribe();
    };
    ObservableWrapper.callNext = function(emitter, value) {
      emitter.next(value);
    };
    ObservableWrapper.callEmit = function(emitter, value) {
      emitter.emit(value);
    };
    ObservableWrapper.callError = function(emitter, error) {
      emitter.error(error);
    };
    ObservableWrapper.callComplete = function(emitter) {
      emitter.complete();
    };
    ObservableWrapper.fromPromise = function(promise) {
      return PromiseObservable_1.PromiseObservable.create(promise);
    };
    ObservableWrapper.toPromise = function(obj) {
      return toPromise_1.toPromise.call(obj);
    };
    return ObservableWrapper;
  })();
  exports.ObservableWrapper = ObservableWrapper;
  var EventEmitter = (function(_super) {
    __extends(EventEmitter, _super);
    function EventEmitter(isAsync) {
      if (isAsync === void 0) {
        isAsync = true;
      }
      _super.call(this);
      this._isAsync = isAsync;
    }
    EventEmitter.prototype.emit = function(value) {
      _super.prototype.next.call(this, value);
    };
    EventEmitter.prototype.next = function(value) {
      _super.prototype.next.call(this, value);
    };
    EventEmitter.prototype.subscribe = function(generatorOrNext, error, complete) {
      var schedulerFn;
      var errorFn = function(err) {
        return null;
      };
      var completeFn = function() {
        return null;
      };
      if (generatorOrNext && typeof generatorOrNext === 'object') {
        schedulerFn = this._isAsync ? function(value) {
          setTimeout(function() {
            return generatorOrNext.next(value);
          });
        } : function(value) {
          generatorOrNext.next(value);
        };
        if (generatorOrNext.error) {
          errorFn = this._isAsync ? function(err) {
            setTimeout(function() {
              return generatorOrNext.error(err);
            });
          } : function(err) {
            generatorOrNext.error(err);
          };
        }
        if (generatorOrNext.complete) {
          completeFn = this._isAsync ? function() {
            setTimeout(function() {
              return generatorOrNext.complete();
            });
          } : function() {
            generatorOrNext.complete();
          };
        }
      } else {
        schedulerFn = this._isAsync ? function(value) {
          setTimeout(function() {
            return generatorOrNext(value);
          });
        } : function(value) {
          generatorOrNext(value);
        };
        if (error) {
          errorFn = this._isAsync ? function(err) {
            setTimeout(function() {
              return error(err);
            });
          } : function(err) {
            error(err);
          };
        }
        if (complete) {
          completeFn = this._isAsync ? function() {
            setTimeout(function() {
              return complete();
            });
          } : function() {
            complete();
          };
        }
      }
      return _super.prototype.subscribe.call(this, schedulerFn, errorFn, completeFn);
    };
    return EventEmitter;
  })(Subject_1.Subject);
  exports.EventEmitter = EventEmitter;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/metadata", ["angular2/src/core/metadata/di", "angular2/src/core/metadata/directives", "angular2/src/core/metadata/view", "angular2/src/core/metadata/di", "angular2/src/core/metadata/directives", "angular2/src/core/metadata/view", "angular2/src/core/util/decorators"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var di_1 = require("angular2/src/core/metadata/di");
  exports.QueryMetadata = di_1.QueryMetadata;
  exports.ContentChildrenMetadata = di_1.ContentChildrenMetadata;
  exports.ContentChildMetadata = di_1.ContentChildMetadata;
  exports.ViewChildrenMetadata = di_1.ViewChildrenMetadata;
  exports.ViewQueryMetadata = di_1.ViewQueryMetadata;
  exports.ViewChildMetadata = di_1.ViewChildMetadata;
  exports.AttributeMetadata = di_1.AttributeMetadata;
  var directives_1 = require("angular2/src/core/metadata/directives");
  exports.ComponentMetadata = directives_1.ComponentMetadata;
  exports.DirectiveMetadata = directives_1.DirectiveMetadata;
  exports.PipeMetadata = directives_1.PipeMetadata;
  exports.InputMetadata = directives_1.InputMetadata;
  exports.OutputMetadata = directives_1.OutputMetadata;
  exports.HostBindingMetadata = directives_1.HostBindingMetadata;
  exports.HostListenerMetadata = directives_1.HostListenerMetadata;
  var view_1 = require("angular2/src/core/metadata/view");
  exports.ViewMetadata = view_1.ViewMetadata;
  exports.ViewEncapsulation = view_1.ViewEncapsulation;
  var di_2 = require("angular2/src/core/metadata/di");
  var directives_2 = require("angular2/src/core/metadata/directives");
  var view_2 = require("angular2/src/core/metadata/view");
  var decorators_1 = require("angular2/src/core/util/decorators");
  exports.Component = decorators_1.makeDecorator(directives_2.ComponentMetadata, function(fn) {
    return fn.View = exports.View;
  });
  exports.Directive = decorators_1.makeDecorator(directives_2.DirectiveMetadata);
  exports.View = decorators_1.makeDecorator(view_2.ViewMetadata, function(fn) {
    return fn.View = exports.View;
  });
  exports.Attribute = decorators_1.makeParamDecorator(di_2.AttributeMetadata);
  exports.Query = decorators_1.makeParamDecorator(di_2.QueryMetadata);
  exports.ContentChildren = decorators_1.makePropDecorator(di_2.ContentChildrenMetadata);
  exports.ContentChild = decorators_1.makePropDecorator(di_2.ContentChildMetadata);
  exports.ViewChildren = decorators_1.makePropDecorator(di_2.ViewChildrenMetadata);
  exports.ViewChild = decorators_1.makePropDecorator(di_2.ViewChildMetadata);
  exports.ViewQuery = decorators_1.makeParamDecorator(di_2.ViewQueryMetadata);
  exports.Pipe = decorators_1.makeDecorator(directives_2.PipeMetadata);
  exports.Input = decorators_1.makePropDecorator(directives_2.InputMetadata);
  exports.Output = decorators_1.makePropDecorator(directives_2.OutputMetadata);
  exports.HostBinding = decorators_1.makePropDecorator(directives_2.HostBindingMetadata);
  exports.HostListener = decorators_1.makePropDecorator(directives_2.HostListenerMetadata);
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/dom/events/dom_events", ["angular2/src/platform/dom/dom_adapter", "angular2/core", "angular2/src/platform/dom/events/event_manager"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var dom_adapter_1 = require("angular2/src/platform/dom/dom_adapter");
  var core_1 = require("angular2/core");
  var event_manager_1 = require("angular2/src/platform/dom/events/event_manager");
  var DomEventsPlugin = (function(_super) {
    __extends(DomEventsPlugin, _super);
    function DomEventsPlugin() {
      _super.apply(this, arguments);
    }
    DomEventsPlugin.prototype.supports = function(eventName) {
      return true;
    };
    DomEventsPlugin.prototype.addEventListener = function(element, eventName, handler) {
      var zone = this.manager.getZone();
      var outsideHandler = function(event) {
        return zone.run(function() {
          return handler(event);
        });
      };
      return this.manager.getZone().runOutsideAngular(function() {
        return dom_adapter_1.DOM.onAndCancel(element, eventName, outsideHandler);
      });
    };
    DomEventsPlugin.prototype.addGlobalEventListener = function(target, eventName, handler) {
      var element = dom_adapter_1.DOM.getGlobalEventTarget(target);
      var zone = this.manager.getZone();
      var outsideHandler = function(event) {
        return zone.run(function() {
          return handler(event);
        });
      };
      return this.manager.getZone().runOutsideAngular(function() {
        return dom_adapter_1.DOM.onAndCancel(element, eventName, outsideHandler);
      });
    };
    DomEventsPlugin = __decorate([core_1.Injectable(), __metadata('design:paramtypes', [])], DomEventsPlugin);
    return DomEventsPlugin;
  })(event_manager_1.EventManagerPlugin);
  exports.DomEventsPlugin = DomEventsPlugin;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/zone/ng_zone", ["angular2/src/facade/collection", "angular2/src/facade/lang", "angular2/src/facade/async", "angular2/src/core/profile/profile"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var collection_1 = require("angular2/src/facade/collection");
  var lang_1 = require("angular2/src/facade/lang");
  var async_1 = require("angular2/src/facade/async");
  var profile_1 = require("angular2/src/core/profile/profile");
  var NgZoneError = (function() {
    function NgZoneError(error, stackTrace) {
      this.error = error;
      this.stackTrace = stackTrace;
    }
    return NgZoneError;
  })();
  exports.NgZoneError = NgZoneError;
  var NgZone = (function() {
    function NgZone(_a) {
      var enableLongStackTrace = _a.enableLongStackTrace;
      this._runScope = profile_1.wtfCreateScope("NgZone#run()");
      this._microtaskScope = profile_1.wtfCreateScope("NgZone#microtask()");
      this._pendingMicrotasks = 0;
      this._hasExecutedCodeInInnerZone = false;
      this._nestedRun = 0;
      this._inVmTurnDone = false;
      this._pendingTimeouts = [];
      if (lang_1.global.zone) {
        this._disabled = false;
        this._mountZone = lang_1.global.zone;
        this._innerZone = this._createInnerZone(this._mountZone, enableLongStackTrace);
      } else {
        this._disabled = true;
        this._mountZone = null;
      }
      this._onTurnStartEvents = new async_1.EventEmitter(false);
      this._onTurnDoneEvents = new async_1.EventEmitter(false);
      this._onEventDoneEvents = new async_1.EventEmitter(false);
      this._onErrorEvents = new async_1.EventEmitter(false);
    }
    NgZone.prototype.overrideOnTurnStart = function(onTurnStartHook) {
      this._onTurnStart = lang_1.normalizeBlank(onTurnStartHook);
    };
    Object.defineProperty(NgZone.prototype, "onTurnStart", {
      get: function() {
        return this._onTurnStartEvents;
      },
      enumerable: true,
      configurable: true
    });
    NgZone.prototype._notifyOnTurnStart = function(parentRun) {
      var _this = this;
      parentRun.call(this._innerZone, function() {
        _this._onTurnStartEvents.emit(null);
      });
    };
    NgZone.prototype.overrideOnTurnDone = function(onTurnDoneHook) {
      this._onTurnDone = lang_1.normalizeBlank(onTurnDoneHook);
    };
    Object.defineProperty(NgZone.prototype, "onTurnDone", {
      get: function() {
        return this._onTurnDoneEvents;
      },
      enumerable: true,
      configurable: true
    });
    NgZone.prototype._notifyOnTurnDone = function(parentRun) {
      var _this = this;
      parentRun.call(this._innerZone, function() {
        _this._onTurnDoneEvents.emit(null);
      });
    };
    NgZone.prototype.overrideOnEventDone = function(onEventDoneFn, opt_waitForAsync) {
      var _this = this;
      if (opt_waitForAsync === void 0) {
        opt_waitForAsync = false;
      }
      var normalizedOnEventDone = lang_1.normalizeBlank(onEventDoneFn);
      if (opt_waitForAsync) {
        this._onEventDone = function() {
          if (!_this._pendingTimeouts.length) {
            normalizedOnEventDone();
          }
        };
      } else {
        this._onEventDone = normalizedOnEventDone;
      }
    };
    Object.defineProperty(NgZone.prototype, "onEventDone", {
      get: function() {
        return this._onEventDoneEvents;
      },
      enumerable: true,
      configurable: true
    });
    NgZone.prototype._notifyOnEventDone = function() {
      var _this = this;
      this.runOutsideAngular(function() {
        _this._onEventDoneEvents.emit(null);
      });
    };
    Object.defineProperty(NgZone.prototype, "hasPendingMicrotasks", {
      get: function() {
        return this._pendingMicrotasks > 0;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgZone.prototype, "hasPendingTimers", {
      get: function() {
        return this._pendingTimeouts.length > 0;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgZone.prototype, "hasPendingAsyncTasks", {
      get: function() {
        return this.hasPendingMicrotasks || this.hasPendingTimers;
      },
      enumerable: true,
      configurable: true
    });
    NgZone.prototype.overrideOnErrorHandler = function(errorHandler) {
      this._onErrorHandler = lang_1.normalizeBlank(errorHandler);
    };
    Object.defineProperty(NgZone.prototype, "onError", {
      get: function() {
        return this._onErrorEvents;
      },
      enumerable: true,
      configurable: true
    });
    NgZone.prototype.run = function(fn) {
      if (this._disabled) {
        return fn();
      } else {
        var s = this._runScope();
        try {
          return this._innerZone.run(fn);
        } finally {
          profile_1.wtfLeave(s);
        }
      }
    };
    NgZone.prototype.runOutsideAngular = function(fn) {
      if (this._disabled) {
        return fn();
      } else {
        return this._mountZone.run(fn);
      }
    };
    NgZone.prototype._createInnerZone = function(zone, enableLongStackTrace) {
      var microtaskScope = this._microtaskScope;
      var ngZone = this;
      var errorHandling;
      if (enableLongStackTrace) {
        errorHandling = collection_1.StringMapWrapper.merge(lang_1.global.Zone.longStackTraceZone, {onError: function(e) {
            ngZone._notifyOnError(this, e);
          }});
      } else {
        errorHandling = {onError: function(e) {
            ngZone._notifyOnError(this, e);
          }};
      }
      return zone.fork(errorHandling).fork({
        '$run': function(parentRun) {
          return function() {
            try {
              ngZone._nestedRun++;
              if (!ngZone._hasExecutedCodeInInnerZone) {
                ngZone._hasExecutedCodeInInnerZone = true;
                ngZone._notifyOnTurnStart(parentRun);
                if (ngZone._onTurnStart) {
                  parentRun.call(ngZone._innerZone, ngZone._onTurnStart);
                }
              }
              return parentRun.apply(this, arguments);
            } finally {
              ngZone._nestedRun--;
              if (ngZone._pendingMicrotasks == 0 && ngZone._nestedRun == 0 && !this._inVmTurnDone) {
                if (ngZone._hasExecutedCodeInInnerZone) {
                  try {
                    this._inVmTurnDone = true;
                    ngZone._notifyOnTurnDone(parentRun);
                    if (ngZone._onTurnDone) {
                      parentRun.call(ngZone._innerZone, ngZone._onTurnDone);
                    }
                  } finally {
                    this._inVmTurnDone = false;
                    ngZone._hasExecutedCodeInInnerZone = false;
                  }
                }
                if (ngZone._pendingMicrotasks === 0) {
                  ngZone._notifyOnEventDone();
                  if (lang_1.isPresent(ngZone._onEventDone)) {
                    ngZone.runOutsideAngular(ngZone._onEventDone);
                  }
                }
              }
            }
          };
        },
        '$scheduleMicrotask': function(parentScheduleMicrotask) {
          return function(fn) {
            ngZone._pendingMicrotasks++;
            var microtask = function() {
              var s = microtaskScope();
              try {
                fn();
              } finally {
                ngZone._pendingMicrotasks--;
                profile_1.wtfLeave(s);
              }
            };
            parentScheduleMicrotask.call(this, microtask);
          };
        },
        '$setTimeout': function(parentSetTimeout) {
          return function(fn, delay) {
            var args = [];
            for (var _i = 2; _i < arguments.length; _i++) {
              args[_i - 2] = arguments[_i];
            }
            var id;
            var cb = function() {
              fn();
              collection_1.ListWrapper.remove(ngZone._pendingTimeouts, id);
            };
            id = parentSetTimeout.call(this, cb, delay, args);
            ngZone._pendingTimeouts.push(id);
            return id;
          };
        },
        '$clearTimeout': function(parentClearTimeout) {
          return function(id) {
            parentClearTimeout.call(this, id);
            collection_1.ListWrapper.remove(ngZone._pendingTimeouts, id);
          };
        },
        _innerZone: true
      });
    };
    NgZone.prototype._notifyOnError = function(zone, e) {
      if (lang_1.isPresent(this._onErrorHandler) || async_1.ObservableWrapper.hasSubscribers(this._onErrorEvents)) {
        var trace = [lang_1.normalizeBlank(e.stack)];
        while (zone && zone.constructedAtException) {
          trace.push(zone.constructedAtException.get());
          zone = zone.parent;
        }
        if (async_1.ObservableWrapper.hasSubscribers(this._onErrorEvents)) {
          async_1.ObservableWrapper.callEmit(this._onErrorEvents, new NgZoneError(e, trace));
        }
        if (lang_1.isPresent(this._onErrorHandler)) {
          this._onErrorHandler(e, trace);
        }
      } else {
        console.log('## _notifyOnError ##');
        console.log(e.stack);
        throw e;
      }
    };
    return NgZone;
  })();
  exports.NgZone = NgZone;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/dom/events/event_manager", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/core/di", "angular2/src/core/zone/ng_zone", "angular2/src/facade/collection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var di_1 = require("angular2/src/core/di");
  var ng_zone_1 = require("angular2/src/core/zone/ng_zone");
  var collection_1 = require("angular2/src/facade/collection");
  exports.EVENT_MANAGER_PLUGINS = lang_1.CONST_EXPR(new di_1.OpaqueToken("EventManagerPlugins"));
  var EventManager = (function() {
    function EventManager(plugins, _zone) {
      var _this = this;
      this._zone = _zone;
      plugins.forEach(function(p) {
        return p.manager = _this;
      });
      this._plugins = collection_1.ListWrapper.reversed(plugins);
    }
    EventManager.prototype.addEventListener = function(element, eventName, handler) {
      var plugin = this._findPluginFor(eventName);
      return plugin.addEventListener(element, eventName, handler);
    };
    EventManager.prototype.addGlobalEventListener = function(target, eventName, handler) {
      var plugin = this._findPluginFor(eventName);
      return plugin.addGlobalEventListener(target, eventName, handler);
    };
    EventManager.prototype.getZone = function() {
      return this._zone;
    };
    EventManager.prototype._findPluginFor = function(eventName) {
      var plugins = this._plugins;
      for (var i = 0; i < plugins.length; i++) {
        var plugin = plugins[i];
        if (plugin.supports(eventName)) {
          return plugin;
        }
      }
      throw new exceptions_1.BaseException("No event manager plugin found for event " + eventName);
    };
    EventManager = __decorate([di_1.Injectable(), __param(0, di_1.Inject(exports.EVENT_MANAGER_PLUGINS)), __metadata('design:paramtypes', [Array, ng_zone_1.NgZone])], EventManager);
    return EventManager;
  })();
  exports.EventManager = EventManager;
  var EventManagerPlugin = (function() {
    function EventManagerPlugin() {}
    EventManagerPlugin.prototype.supports = function(eventName) {
      return false;
    };
    EventManagerPlugin.prototype.addEventListener = function(element, eventName, handler) {
      throw "not implemented";
    };
    EventManagerPlugin.prototype.addGlobalEventListener = function(element, eventName, handler) {
      throw "not implemented";
    };
    return EventManagerPlugin;
  })();
  exports.EventManagerPlugin = EventManagerPlugin;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/dom/dom_renderer", ["angular2/src/core/di", "angular2/src/animate/animation_builder", "angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/platform/dom/shared_styles_host", "angular2/src/platform/dom/events/event_manager", "angular2/src/platform/dom/dom_tokens", "angular2/src/core/metadata", "angular2/src/platform/dom/dom_adapter", "angular2/src/platform/dom/util"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var di_1 = require("angular2/src/core/di");
  var animation_builder_1 = require("angular2/src/animate/animation_builder");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var shared_styles_host_1 = require("angular2/src/platform/dom/shared_styles_host");
  var event_manager_1 = require("angular2/src/platform/dom/events/event_manager");
  var dom_tokens_1 = require("angular2/src/platform/dom/dom_tokens");
  var metadata_1 = require("angular2/src/core/metadata");
  var dom_adapter_1 = require("angular2/src/platform/dom/dom_adapter");
  var util_1 = require("angular2/src/platform/dom/util");
  var NAMESPACE_URIS = lang_1.CONST_EXPR({
    'xlink': 'http://www.w3.org/1999/xlink',
    'svg': 'http://www.w3.org/2000/svg'
  });
  var TEMPLATE_COMMENT_TEXT = 'template bindings={}';
  var TEMPLATE_BINDINGS_EXP = /^template bindings=(.*)$/g;
  var DomRootRenderer = (function() {
    function DomRootRenderer(document, eventManager, sharedStylesHost, animate) {
      this.document = document;
      this.eventManager = eventManager;
      this.sharedStylesHost = sharedStylesHost;
      this.animate = animate;
      this._registeredComponents = new Map();
    }
    DomRootRenderer.prototype.renderComponent = function(componentProto) {
      var renderer = this._registeredComponents.get(componentProto.id);
      if (lang_1.isBlank(renderer)) {
        renderer = new DomRenderer(this, componentProto);
        this._registeredComponents.set(componentProto.id, renderer);
      }
      return renderer;
    };
    return DomRootRenderer;
  })();
  exports.DomRootRenderer = DomRootRenderer;
  var DomRootRenderer_ = (function(_super) {
    __extends(DomRootRenderer_, _super);
    function DomRootRenderer_(_document, _eventManager, sharedStylesHost, animate) {
      _super.call(this, _document, _eventManager, sharedStylesHost, animate);
    }
    DomRootRenderer_ = __decorate([di_1.Injectable(), __param(0, di_1.Inject(dom_tokens_1.DOCUMENT)), __metadata('design:paramtypes', [Object, event_manager_1.EventManager, shared_styles_host_1.DomSharedStylesHost, animation_builder_1.AnimationBuilder])], DomRootRenderer_);
    return DomRootRenderer_;
  })(DomRootRenderer);
  exports.DomRootRenderer_ = DomRootRenderer_;
  var DomRenderer = (function() {
    function DomRenderer(_rootRenderer, componentProto) {
      this._rootRenderer = _rootRenderer;
      this.componentProto = componentProto;
      this._styles = _flattenStyles(componentProto.id, componentProto.styles, []);
      if (componentProto.encapsulation !== metadata_1.ViewEncapsulation.Native) {
        this._rootRenderer.sharedStylesHost.addStyles(this._styles);
      }
      if (this.componentProto.encapsulation === metadata_1.ViewEncapsulation.Emulated) {
        this._contentAttr = _shimContentAttribute(componentProto.id);
        this._hostAttr = _shimHostAttribute(componentProto.id);
      } else {
        this._contentAttr = null;
        this._hostAttr = null;
      }
    }
    DomRenderer.prototype.renderComponent = function(componentProto) {
      return this._rootRenderer.renderComponent(componentProto);
    };
    DomRenderer.prototype.selectRootElement = function(selector) {
      var el = dom_adapter_1.DOM.querySelector(this._rootRenderer.document, selector);
      if (lang_1.isBlank(el)) {
        throw new exceptions_1.BaseException("The selector \"" + selector + "\" did not match any elements");
      }
      dom_adapter_1.DOM.clearNodes(el);
      return el;
    };
    DomRenderer.prototype.createElement = function(parent, name) {
      var nsAndName = splitNamespace(name);
      var el = lang_1.isPresent(nsAndName[0]) ? dom_adapter_1.DOM.createElementNS(NAMESPACE_URIS[nsAndName[0]], nsAndName[1]) : dom_adapter_1.DOM.createElement(nsAndName[1]);
      if (lang_1.isPresent(this._contentAttr)) {
        dom_adapter_1.DOM.setAttribute(el, this._contentAttr, '');
      }
      if (lang_1.isPresent(parent)) {
        dom_adapter_1.DOM.appendChild(parent, el);
      }
      return el;
    };
    DomRenderer.prototype.createViewRoot = function(hostElement) {
      var nodesParent;
      if (this.componentProto.encapsulation === metadata_1.ViewEncapsulation.Native) {
        nodesParent = dom_adapter_1.DOM.createShadowRoot(hostElement);
        this._rootRenderer.sharedStylesHost.addHost(nodesParent);
        for (var i = 0; i < this._styles.length; i++) {
          dom_adapter_1.DOM.appendChild(nodesParent, dom_adapter_1.DOM.createStyleElement(this._styles[i]));
        }
      } else {
        if (lang_1.isPresent(this._hostAttr)) {
          dom_adapter_1.DOM.setAttribute(hostElement, this._hostAttr, '');
        }
        nodesParent = hostElement;
      }
      return nodesParent;
    };
    DomRenderer.prototype.createTemplateAnchor = function(parentElement) {
      var comment = dom_adapter_1.DOM.createComment(TEMPLATE_COMMENT_TEXT);
      if (lang_1.isPresent(parentElement)) {
        dom_adapter_1.DOM.appendChild(parentElement, comment);
      }
      return comment;
    };
    DomRenderer.prototype.createText = function(parentElement, value) {
      var node = dom_adapter_1.DOM.createTextNode(value);
      if (lang_1.isPresent(parentElement)) {
        dom_adapter_1.DOM.appendChild(parentElement, node);
      }
      return node;
    };
    DomRenderer.prototype.projectNodes = function(parentElement, nodes) {
      if (lang_1.isBlank(parentElement))
        return ;
      appendNodes(parentElement, nodes);
    };
    DomRenderer.prototype.attachViewAfter = function(node, viewRootNodes) {
      moveNodesAfterSibling(node, viewRootNodes);
      for (var i = 0; i < viewRootNodes.length; i++)
        this.animateNodeEnter(viewRootNodes[i]);
    };
    DomRenderer.prototype.detachView = function(viewRootNodes) {
      for (var i = 0; i < viewRootNodes.length; i++) {
        var node = viewRootNodes[i];
        dom_adapter_1.DOM.remove(node);
        this.animateNodeLeave(node);
      }
    };
    DomRenderer.prototype.destroyView = function(hostElement, viewAllNodes) {
      if (this.componentProto.encapsulation === metadata_1.ViewEncapsulation.Native && lang_1.isPresent(hostElement)) {
        this._rootRenderer.sharedStylesHost.removeHost(dom_adapter_1.DOM.getShadowRoot(hostElement));
      }
    };
    DomRenderer.prototype.listen = function(renderElement, name, callback) {
      return this._rootRenderer.eventManager.addEventListener(renderElement, name, decoratePreventDefault(callback));
    };
    DomRenderer.prototype.listenGlobal = function(target, name, callback) {
      return this._rootRenderer.eventManager.addGlobalEventListener(target, name, decoratePreventDefault(callback));
    };
    DomRenderer.prototype.setElementProperty = function(renderElement, propertyName, propertyValue) {
      dom_adapter_1.DOM.setProperty(renderElement, propertyName, propertyValue);
    };
    DomRenderer.prototype.setElementAttribute = function(renderElement, attributeName, attributeValue) {
      var attrNs;
      var nsAndName = splitNamespace(attributeName);
      if (lang_1.isPresent(nsAndName[0])) {
        attributeName = nsAndName[0] + ':' + nsAndName[1];
        attrNs = NAMESPACE_URIS[nsAndName[0]];
      }
      if (lang_1.isPresent(attributeValue)) {
        if (lang_1.isPresent(attrNs)) {
          dom_adapter_1.DOM.setAttributeNS(renderElement, attrNs, attributeName, attributeValue);
        } else {
          dom_adapter_1.DOM.setAttribute(renderElement, nsAndName[1], attributeValue);
        }
      } else {
        dom_adapter_1.DOM.removeAttribute(renderElement, attributeName);
      }
    };
    DomRenderer.prototype.setBindingDebugInfo = function(renderElement, propertyName, propertyValue) {
      var dashCasedPropertyName = util_1.camelCaseToDashCase(propertyName);
      if (dom_adapter_1.DOM.isCommentNode(renderElement)) {
        var existingBindings = lang_1.RegExpWrapper.firstMatch(TEMPLATE_BINDINGS_EXP, lang_1.StringWrapper.replaceAll(dom_adapter_1.DOM.getText(renderElement), /\n/g, ''));
        var parsedBindings = lang_1.Json.parse(existingBindings[1]);
        parsedBindings[dashCasedPropertyName] = propertyValue;
        dom_adapter_1.DOM.setText(renderElement, lang_1.StringWrapper.replace(TEMPLATE_COMMENT_TEXT, '{}', lang_1.Json.stringify(parsedBindings)));
      } else {
        this.setElementAttribute(renderElement, propertyName, propertyValue);
      }
    };
    DomRenderer.prototype.setElementDebugInfo = function(renderElement, info) {};
    DomRenderer.prototype.setElementClass = function(renderElement, className, isAdd) {
      if (isAdd) {
        dom_adapter_1.DOM.addClass(renderElement, className);
      } else {
        dom_adapter_1.DOM.removeClass(renderElement, className);
      }
    };
    DomRenderer.prototype.setElementStyle = function(renderElement, styleName, styleValue) {
      if (lang_1.isPresent(styleValue)) {
        dom_adapter_1.DOM.setStyle(renderElement, styleName, lang_1.stringify(styleValue));
      } else {
        dom_adapter_1.DOM.removeStyle(renderElement, styleName);
      }
    };
    DomRenderer.prototype.invokeElementMethod = function(renderElement, methodName, args) {
      dom_adapter_1.DOM.invoke(renderElement, methodName, args);
    };
    DomRenderer.prototype.setText = function(renderNode, text) {
      dom_adapter_1.DOM.setText(renderNode, text);
    };
    DomRenderer.prototype.animateNodeEnter = function(node) {
      if (dom_adapter_1.DOM.isElementNode(node) && dom_adapter_1.DOM.hasClass(node, 'ng-animate')) {
        dom_adapter_1.DOM.addClass(node, 'ng-enter');
        this._rootRenderer.animate.css().addAnimationClass('ng-enter-active').start(node).onComplete(function() {
          dom_adapter_1.DOM.removeClass(node, 'ng-enter');
        });
      }
    };
    DomRenderer.prototype.animateNodeLeave = function(node) {
      if (dom_adapter_1.DOM.isElementNode(node) && dom_adapter_1.DOM.hasClass(node, 'ng-animate')) {
        dom_adapter_1.DOM.addClass(node, 'ng-leave');
        this._rootRenderer.animate.css().addAnimationClass('ng-leave-active').start(node).onComplete(function() {
          dom_adapter_1.DOM.removeClass(node, 'ng-leave');
          dom_adapter_1.DOM.remove(node);
        });
      } else {
        dom_adapter_1.DOM.remove(node);
      }
    };
    return DomRenderer;
  })();
  exports.DomRenderer = DomRenderer;
  function moveNodesAfterSibling(sibling, nodes) {
    var parent = dom_adapter_1.DOM.parentElement(sibling);
    if (nodes.length > 0 && lang_1.isPresent(parent)) {
      var nextSibling = dom_adapter_1.DOM.nextSibling(sibling);
      if (lang_1.isPresent(nextSibling)) {
        for (var i = 0; i < nodes.length; i++) {
          dom_adapter_1.DOM.insertBefore(nextSibling, nodes[i]);
        }
      } else {
        for (var i = 0; i < nodes.length; i++) {
          dom_adapter_1.DOM.appendChild(parent, nodes[i]);
        }
      }
    }
  }
  function appendNodes(parent, nodes) {
    for (var i = 0; i < nodes.length; i++) {
      dom_adapter_1.DOM.appendChild(parent, nodes[i]);
    }
  }
  function decoratePreventDefault(eventHandler) {
    return function(event) {
      var allowDefaultBehavior = eventHandler(event);
      if (allowDefaultBehavior === false) {
        dom_adapter_1.DOM.preventDefault(event);
      }
    };
  }
  var COMPONENT_REGEX = /%COMP%/g;
  exports.COMPONENT_VARIABLE = '%COMP%';
  exports.HOST_ATTR = "_nghost-" + exports.COMPONENT_VARIABLE;
  exports.CONTENT_ATTR = "_ngcontent-" + exports.COMPONENT_VARIABLE;
  function _shimContentAttribute(componentShortId) {
    return lang_1.StringWrapper.replaceAll(exports.CONTENT_ATTR, COMPONENT_REGEX, componentShortId);
  }
  function _shimHostAttribute(componentShortId) {
    return lang_1.StringWrapper.replaceAll(exports.HOST_ATTR, COMPONENT_REGEX, componentShortId);
  }
  function _flattenStyles(compId, styles, target) {
    for (var i = 0; i < styles.length; i++) {
      var style = styles[i];
      if (lang_1.isArray(style)) {
        _flattenStyles(compId, style, target);
      } else {
        style = lang_1.StringWrapper.replaceAll(style, COMPONENT_REGEX, compId);
        target.push(style);
      }
    }
    return target;
  }
  var NS_PREFIX_RE = /^@([^:]+):(.+)/g;
  function splitNamespace(name) {
    if (name[0] != '@') {
      return [null, name];
    }
    var match = lang_1.RegExpWrapper.firstMatch(NS_PREFIX_RE, name);
    return [match[1], match[2]];
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/platform/common_dom", ["angular2/src/platform/dom/dom_adapter", "angular2/src/platform/dom/dom_renderer", "angular2/src/platform/dom/dom_tokens", "angular2/src/platform/dom/shared_styles_host", "angular2/src/platform/dom/events/dom_events", "angular2/src/platform/dom/events/event_manager", "angular2/src/platform/dom/debug/by", "angular2/src/platform/dom/debug/ng_probe"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  function __export(m) {
    for (var p in m)
      if (!exports.hasOwnProperty(p))
        exports[p] = m[p];
  }
  var dom_adapter_1 = require("angular2/src/platform/dom/dom_adapter");
  exports.DOM = dom_adapter_1.DOM;
  exports.setRootDomAdapter = dom_adapter_1.setRootDomAdapter;
  exports.DomAdapter = dom_adapter_1.DomAdapter;
  var dom_renderer_1 = require("angular2/src/platform/dom/dom_renderer");
  exports.DomRenderer = dom_renderer_1.DomRenderer;
  var dom_tokens_1 = require("angular2/src/platform/dom/dom_tokens");
  exports.DOCUMENT = dom_tokens_1.DOCUMENT;
  var shared_styles_host_1 = require("angular2/src/platform/dom/shared_styles_host");
  exports.SharedStylesHost = shared_styles_host_1.SharedStylesHost;
  exports.DomSharedStylesHost = shared_styles_host_1.DomSharedStylesHost;
  var dom_events_1 = require("angular2/src/platform/dom/events/dom_events");
  exports.DomEventsPlugin = dom_events_1.DomEventsPlugin;
  var event_manager_1 = require("angular2/src/platform/dom/events/event_manager");
  exports.EVENT_MANAGER_PLUGINS = event_manager_1.EVENT_MANAGER_PLUGINS;
  exports.EventManager = event_manager_1.EventManager;
  exports.EventManagerPlugin = event_manager_1.EventManagerPlugin;
  __export(require("angular2/src/platform/dom/debug/by"));
  __export(require("angular2/src/platform/dom/debug/ng_probe"));
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/pipes/invalid_pipe_argument_exception", ["angular2/src/facade/lang", "angular2/src/facade/exceptions"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var InvalidPipeArgumentException = (function(_super) {
    __extends(InvalidPipeArgumentException, _super);
    function InvalidPipeArgumentException(type, value) {
      _super.call(this, "Invalid argument '" + value + "' for pipe '" + lang_1.stringify(type) + "'");
    }
    return InvalidPipeArgumentException;
  })(exceptions_1.BaseException);
  exports.InvalidPipeArgumentException = InvalidPipeArgumentException;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/pipes/uppercase_pipe", ["angular2/src/facade/lang", "angular2/core", "angular2/src/common/pipes/invalid_pipe_argument_exception"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var core_1 = require("angular2/core");
  var invalid_pipe_argument_exception_1 = require("angular2/src/common/pipes/invalid_pipe_argument_exception");
  var UpperCasePipe = (function() {
    function UpperCasePipe() {}
    UpperCasePipe.prototype.transform = function(value, args) {
      if (args === void 0) {
        args = null;
      }
      if (lang_1.isBlank(value))
        return value;
      if (!lang_1.isString(value)) {
        throw new invalid_pipe_argument_exception_1.InvalidPipeArgumentException(UpperCasePipe, value);
      }
      return value.toUpperCase();
    };
    UpperCasePipe = __decorate([lang_1.CONST(), core_1.Pipe({name: 'uppercase'}), core_1.Injectable(), __metadata('design:paramtypes', [])], UpperCasePipe);
    return UpperCasePipe;
  })();
  exports.UpperCasePipe = UpperCasePipe;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/pipes/lowercase_pipe", ["angular2/src/facade/lang", "angular2/core", "angular2/src/common/pipes/invalid_pipe_argument_exception"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var core_1 = require("angular2/core");
  var invalid_pipe_argument_exception_1 = require("angular2/src/common/pipes/invalid_pipe_argument_exception");
  var LowerCasePipe = (function() {
    function LowerCasePipe() {}
    LowerCasePipe.prototype.transform = function(value, args) {
      if (args === void 0) {
        args = null;
      }
      if (lang_1.isBlank(value))
        return value;
      if (!lang_1.isString(value)) {
        throw new invalid_pipe_argument_exception_1.InvalidPipeArgumentException(LowerCasePipe, value);
      }
      return value.toLowerCase();
    };
    LowerCasePipe = __decorate([lang_1.CONST(), core_1.Pipe({name: 'lowercase'}), core_1.Injectable(), __metadata('design:paramtypes', [])], LowerCasePipe);
    return LowerCasePipe;
  })();
  exports.LowerCasePipe = LowerCasePipe;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/pipes/json_pipe", ["angular2/src/facade/lang", "angular2/core"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var core_1 = require("angular2/core");
  var JsonPipe = (function() {
    function JsonPipe() {}
    JsonPipe.prototype.transform = function(value, args) {
      if (args === void 0) {
        args = null;
      }
      return lang_1.Json.stringify(value);
    };
    JsonPipe = __decorate([lang_1.CONST(), core_1.Pipe({
      name: 'json',
      pure: false
    }), core_1.Injectable(), __metadata('design:paramtypes', [])], JsonPipe);
    return JsonPipe;
  })();
  exports.JsonPipe = JsonPipe;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/pipes/slice_pipe", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection", "angular2/core", "angular2/src/common/pipes/invalid_pipe_argument_exception"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var core_1 = require("angular2/core");
  var invalid_pipe_argument_exception_1 = require("angular2/src/common/pipes/invalid_pipe_argument_exception");
  var SlicePipe = (function() {
    function SlicePipe() {}
    SlicePipe.prototype.transform = function(value, args) {
      if (args === void 0) {
        args = null;
      }
      if (lang_1.isBlank(args) || args.length == 0) {
        throw new exceptions_1.BaseException('Slice pipe requires one argument');
      }
      if (!this.supports(value)) {
        throw new invalid_pipe_argument_exception_1.InvalidPipeArgumentException(SlicePipe, value);
      }
      if (lang_1.isBlank(value))
        return value;
      var start = args[0];
      var end = args.length > 1 ? args[1] : null;
      if (lang_1.isString(value)) {
        return lang_1.StringWrapper.slice(value, start, end);
      }
      return collection_1.ListWrapper.slice(value, start, end);
    };
    SlicePipe.prototype.supports = function(obj) {
      return lang_1.isString(obj) || lang_1.isArray(obj);
    };
    SlicePipe = __decorate([core_1.Pipe({
      name: 'slice',
      pure: false
    }), core_1.Injectable(), __metadata('design:paramtypes', [])], SlicePipe);
    return SlicePipe;
  })();
  exports.SlicePipe = SlicePipe;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/facade/intl", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  (function(NumberFormatStyle) {
    NumberFormatStyle[NumberFormatStyle["Decimal"] = 0] = "Decimal";
    NumberFormatStyle[NumberFormatStyle["Percent"] = 1] = "Percent";
    NumberFormatStyle[NumberFormatStyle["Currency"] = 2] = "Currency";
  })(exports.NumberFormatStyle || (exports.NumberFormatStyle = {}));
  var NumberFormatStyle = exports.NumberFormatStyle;
  var NumberFormatter = (function() {
    function NumberFormatter() {}
    NumberFormatter.format = function(num, locale, style, _a) {
      var _b = _a === void 0 ? {} : _a,
          _c = _b.minimumIntegerDigits,
          minimumIntegerDigits = _c === void 0 ? 1 : _c,
          _d = _b.minimumFractionDigits,
          minimumFractionDigits = _d === void 0 ? 0 : _d,
          _e = _b.maximumFractionDigits,
          maximumFractionDigits = _e === void 0 ? 3 : _e,
          currency = _b.currency,
          _f = _b.currencyAsSymbol,
          currencyAsSymbol = _f === void 0 ? false : _f;
      var intlOptions = {
        minimumIntegerDigits: minimumIntegerDigits,
        minimumFractionDigits: minimumFractionDigits,
        maximumFractionDigits: maximumFractionDigits
      };
      intlOptions.style = NumberFormatStyle[style].toLowerCase();
      if (style == NumberFormatStyle.Currency) {
        intlOptions.currency = currency;
        intlOptions.currencyDisplay = currencyAsSymbol ? 'symbol' : 'code';
      }
      return new Intl.NumberFormat(locale, intlOptions).format(num);
    };
    return NumberFormatter;
  })();
  exports.NumberFormatter = NumberFormatter;
  function digitCondition(len) {
    return len == 2 ? '2-digit' : 'numeric';
  }
  function nameCondition(len) {
    return len < 4 ? 'short' : 'long';
  }
  function extractComponents(pattern) {
    var ret = {};
    var i = 0,
        j;
    while (i < pattern.length) {
      j = i;
      while (j < pattern.length && pattern[j] == pattern[i])
        j++;
      var len = j - i;
      switch (pattern[i]) {
        case 'G':
          ret.era = nameCondition(len);
          break;
        case 'y':
          ret.year = digitCondition(len);
          break;
        case 'M':
          if (len >= 3)
            ret.month = nameCondition(len);
          else
            ret.month = digitCondition(len);
          break;
        case 'd':
          ret.day = digitCondition(len);
          break;
        case 'E':
          ret.weekday = nameCondition(len);
          break;
        case 'j':
          ret.hour = digitCondition(len);
          break;
        case 'h':
          ret.hour = digitCondition(len);
          ret.hour12 = true;
          break;
        case 'H':
          ret.hour = digitCondition(len);
          ret.hour12 = false;
          break;
        case 'm':
          ret.minute = digitCondition(len);
          break;
        case 's':
          ret.second = digitCondition(len);
          break;
        case 'z':
          ret.timeZoneName = 'long';
          break;
        case 'Z':
          ret.timeZoneName = 'short';
          break;
      }
      i = j;
    }
    return ret;
  }
  var dateFormatterCache = new Map();
  var DateFormatter = (function() {
    function DateFormatter() {}
    DateFormatter.format = function(date, locale, pattern) {
      var key = locale + pattern;
      if (dateFormatterCache.has(key)) {
        return dateFormatterCache.get(key).format(date);
      }
      var formatter = new Intl.DateTimeFormat(locale, extractComponents(pattern));
      dateFormatterCache.set(key, formatter);
      return formatter.format(date);
    };
    return DateFormatter;
  })();
  exports.DateFormatter = DateFormatter;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/pipes/number_pipe", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/intl", "angular2/core", "angular2/src/facade/collection", "angular2/src/common/pipes/invalid_pipe_argument_exception"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var intl_1 = require("angular2/src/facade/intl");
  var core_1 = require("angular2/core");
  var collection_1 = require("angular2/src/facade/collection");
  var invalid_pipe_argument_exception_1 = require("angular2/src/common/pipes/invalid_pipe_argument_exception");
  var defaultLocale = 'en-US';
  var _re = lang_1.RegExpWrapper.create('^(\\d+)?\\.((\\d+)(\\-(\\d+))?)?$');
  var NumberPipe = (function() {
    function NumberPipe() {}
    NumberPipe._format = function(value, style, digits, currency, currencyAsSymbol) {
      if (currency === void 0) {
        currency = null;
      }
      if (currencyAsSymbol === void 0) {
        currencyAsSymbol = false;
      }
      if (lang_1.isBlank(value))
        return null;
      if (!lang_1.isNumber(value)) {
        throw new invalid_pipe_argument_exception_1.InvalidPipeArgumentException(NumberPipe, value);
      }
      var minInt = 1,
          minFraction = 0,
          maxFraction = 3;
      if (lang_1.isPresent(digits)) {
        var parts = lang_1.RegExpWrapper.firstMatch(_re, digits);
        if (lang_1.isBlank(parts)) {
          throw new exceptions_1.BaseException(digits + " is not a valid digit info for number pipes");
        }
        if (lang_1.isPresent(parts[1])) {
          minInt = lang_1.NumberWrapper.parseIntAutoRadix(parts[1]);
        }
        if (lang_1.isPresent(parts[3])) {
          minFraction = lang_1.NumberWrapper.parseIntAutoRadix(parts[3]);
        }
        if (lang_1.isPresent(parts[5])) {
          maxFraction = lang_1.NumberWrapper.parseIntAutoRadix(parts[5]);
        }
      }
      return intl_1.NumberFormatter.format(value, defaultLocale, style, {
        minimumIntegerDigits: minInt,
        minimumFractionDigits: minFraction,
        maximumFractionDigits: maxFraction,
        currency: currency,
        currencyAsSymbol: currencyAsSymbol
      });
    };
    NumberPipe = __decorate([lang_1.CONST(), core_1.Injectable(), __metadata('design:paramtypes', [])], NumberPipe);
    return NumberPipe;
  })();
  exports.NumberPipe = NumberPipe;
  var DecimalPipe = (function(_super) {
    __extends(DecimalPipe, _super);
    function DecimalPipe() {
      _super.apply(this, arguments);
    }
    DecimalPipe.prototype.transform = function(value, args) {
      var digits = collection_1.ListWrapper.first(args);
      return NumberPipe._format(value, intl_1.NumberFormatStyle.Decimal, digits);
    };
    DecimalPipe = __decorate([lang_1.CONST(), core_1.Pipe({name: 'number'}), core_1.Injectable(), __metadata('design:paramtypes', [])], DecimalPipe);
    return DecimalPipe;
  })(NumberPipe);
  exports.DecimalPipe = DecimalPipe;
  var PercentPipe = (function(_super) {
    __extends(PercentPipe, _super);
    function PercentPipe() {
      _super.apply(this, arguments);
    }
    PercentPipe.prototype.transform = function(value, args) {
      var digits = collection_1.ListWrapper.first(args);
      return NumberPipe._format(value, intl_1.NumberFormatStyle.Percent, digits);
    };
    PercentPipe = __decorate([lang_1.CONST(), core_1.Pipe({name: 'percent'}), core_1.Injectable(), __metadata('design:paramtypes', [])], PercentPipe);
    return PercentPipe;
  })(NumberPipe);
  exports.PercentPipe = PercentPipe;
  var CurrencyPipe = (function(_super) {
    __extends(CurrencyPipe, _super);
    function CurrencyPipe() {
      _super.apply(this, arguments);
    }
    CurrencyPipe.prototype.transform = function(value, args) {
      var currencyCode = lang_1.isPresent(args) && args.length > 0 ? args[0] : 'USD';
      var symbolDisplay = lang_1.isPresent(args) && args.length > 1 ? args[1] : false;
      var digits = lang_1.isPresent(args) && args.length > 2 ? args[2] : null;
      return NumberPipe._format(value, intl_1.NumberFormatStyle.Currency, digits, currencyCode, symbolDisplay);
    };
    CurrencyPipe = __decorate([lang_1.CONST(), core_1.Pipe({name: 'currency'}), core_1.Injectable(), __metadata('design:paramtypes', [])], CurrencyPipe);
    return CurrencyPipe;
  })(NumberPipe);
  exports.CurrencyPipe = CurrencyPipe;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/directives/ng_class", ["angular2/src/facade/lang", "angular2/core", "angular2/src/facade/collection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var core_1 = require("angular2/core");
  var collection_1 = require("angular2/src/facade/collection");
  var NgClass = (function() {
    function NgClass(_iterableDiffers, _keyValueDiffers, _ngEl, _renderer) {
      this._iterableDiffers = _iterableDiffers;
      this._keyValueDiffers = _keyValueDiffers;
      this._ngEl = _ngEl;
      this._renderer = _renderer;
      this._initialClasses = [];
    }
    Object.defineProperty(NgClass.prototype, "initialClasses", {
      set: function(v) {
        this._applyInitialClasses(true);
        this._initialClasses = lang_1.isPresent(v) && lang_1.isString(v) ? v.split(' ') : [];
        this._applyInitialClasses(false);
        this._applyClasses(this._rawClass, false);
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgClass.prototype, "rawClass", {
      set: function(v) {
        this._cleanupClasses(this._rawClass);
        if (lang_1.isString(v)) {
          v = v.split(' ');
        }
        this._rawClass = v;
        if (lang_1.isPresent(v)) {
          if (collection_1.isListLikeIterable(v)) {
            this._differ = this._iterableDiffers.find(v).create(null);
            this._mode = 'iterable';
          } else {
            this._differ = this._keyValueDiffers.find(v).create(null);
            this._mode = 'keyValue';
          }
        } else {
          this._differ = null;
        }
      },
      enumerable: true,
      configurable: true
    });
    NgClass.prototype.ngDoCheck = function() {
      if (lang_1.isPresent(this._differ)) {
        var changes = this._differ.diff(this._rawClass);
        if (lang_1.isPresent(changes)) {
          if (this._mode == 'iterable') {
            this._applyIterableChanges(changes);
          } else {
            this._applyKeyValueChanges(changes);
          }
        }
      }
    };
    NgClass.prototype.ngOnDestroy = function() {
      this._cleanupClasses(this._rawClass);
    };
    NgClass.prototype._cleanupClasses = function(rawClassVal) {
      this._applyClasses(rawClassVal, true);
      this._applyInitialClasses(false);
    };
    NgClass.prototype._applyKeyValueChanges = function(changes) {
      var _this = this;
      changes.forEachAddedItem(function(record) {
        _this._toggleClass(record.key, record.currentValue);
      });
      changes.forEachChangedItem(function(record) {
        _this._toggleClass(record.key, record.currentValue);
      });
      changes.forEachRemovedItem(function(record) {
        if (record.previousValue) {
          _this._toggleClass(record.key, false);
        }
      });
    };
    NgClass.prototype._applyIterableChanges = function(changes) {
      var _this = this;
      changes.forEachAddedItem(function(record) {
        _this._toggleClass(record.item, true);
      });
      changes.forEachRemovedItem(function(record) {
        _this._toggleClass(record.item, false);
      });
    };
    NgClass.prototype._applyInitialClasses = function(isCleanup) {
      var _this = this;
      this._initialClasses.forEach(function(className) {
        return _this._toggleClass(className, !isCleanup);
      });
    };
    NgClass.prototype._applyClasses = function(rawClassVal, isCleanup) {
      var _this = this;
      if (lang_1.isPresent(rawClassVal)) {
        if (lang_1.isArray(rawClassVal)) {
          rawClassVal.forEach(function(className) {
            return _this._toggleClass(className, !isCleanup);
          });
        } else if (rawClassVal instanceof Set) {
          rawClassVal.forEach(function(className) {
            return _this._toggleClass(className, !isCleanup);
          });
        } else {
          collection_1.StringMapWrapper.forEach(rawClassVal, function(expVal, className) {
            if (expVal)
              _this._toggleClass(className, !isCleanup);
          });
        }
      }
    };
    NgClass.prototype._toggleClass = function(className, enabled) {
      className = className.trim();
      if (className.length > 0) {
        if (className.indexOf(' ') > -1) {
          var classes = className.split(/\s+/g);
          for (var i = 0,
              len = classes.length; i < len; i++) {
            this._renderer.setElementClass(this._ngEl.nativeElement, classes[i], enabled);
          }
        } else {
          this._renderer.setElementClass(this._ngEl.nativeElement, className, enabled);
        }
      }
    };
    NgClass = __decorate([core_1.Directive({
      selector: '[ngClass]',
      inputs: ['rawClass: ngClass', 'initialClasses: class']
    }), __metadata('design:paramtypes', [core_1.IterableDiffers, core_1.KeyValueDiffers, core_1.ElementRef, core_1.Renderer])], NgClass);
    return NgClass;
  })();
  exports.NgClass = NgClass;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/directives/ng_for", ["angular2/core", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var core_1 = require("angular2/core");
  var lang_1 = require("angular2/src/facade/lang");
  var NgFor = (function() {
    function NgFor(_viewContainer, _templateRef, _iterableDiffers, _cdr) {
      this._viewContainer = _viewContainer;
      this._templateRef = _templateRef;
      this._iterableDiffers = _iterableDiffers;
      this._cdr = _cdr;
    }
    Object.defineProperty(NgFor.prototype, "ngForOf", {
      set: function(value) {
        this._ngForOf = value;
        if (lang_1.isBlank(this._differ) && lang_1.isPresent(value)) {
          this._differ = this._iterableDiffers.find(value).create(this._cdr, this._ngForTrackBy);
        }
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgFor.prototype, "ngForTemplate", {
      set: function(value) {
        if (lang_1.isPresent(value)) {
          this._templateRef = value;
        }
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgFor.prototype, "ngForTrackBy", {
      set: function(value) {
        this._ngForTrackBy = value;
      },
      enumerable: true,
      configurable: true
    });
    NgFor.prototype.ngDoCheck = function() {
      if (lang_1.isPresent(this._differ)) {
        var changes = this._differ.diff(this._ngForOf);
        if (lang_1.isPresent(changes))
          this._applyChanges(changes);
      }
    };
    NgFor.prototype._applyChanges = function(changes) {
      var _this = this;
      var recordViewTuples = [];
      changes.forEachRemovedItem(function(removedRecord) {
        return recordViewTuples.push(new RecordViewTuple(removedRecord, null));
      });
      changes.forEachMovedItem(function(movedRecord) {
        return recordViewTuples.push(new RecordViewTuple(movedRecord, null));
      });
      var insertTuples = this._bulkRemove(recordViewTuples);
      changes.forEachAddedItem(function(addedRecord) {
        return insertTuples.push(new RecordViewTuple(addedRecord, null));
      });
      this._bulkInsert(insertTuples);
      for (var i = 0; i < insertTuples.length; i++) {
        this._perViewChange(insertTuples[i].view, insertTuples[i].record);
      }
      for (var i = 0,
          ilen = this._viewContainer.length; i < ilen; i++) {
        var viewRef = this._viewContainer.get(i);
        viewRef.setLocal('last', i === ilen - 1);
      }
      changes.forEachIdentityChange(function(record) {
        var viewRef = _this._viewContainer.get(record.currentIndex);
        viewRef.setLocal('\$implicit', record.item);
      });
    };
    NgFor.prototype._perViewChange = function(view, record) {
      view.setLocal('\$implicit', record.item);
      view.setLocal('index', record.currentIndex);
      view.setLocal('even', (record.currentIndex % 2 == 0));
      view.setLocal('odd', (record.currentIndex % 2 == 1));
    };
    NgFor.prototype._bulkRemove = function(tuples) {
      tuples.sort(function(a, b) {
        return a.record.previousIndex - b.record.previousIndex;
      });
      var movedTuples = [];
      for (var i = tuples.length - 1; i >= 0; i--) {
        var tuple = tuples[i];
        if (lang_1.isPresent(tuple.record.currentIndex)) {
          tuple.view = this._viewContainer.detach(tuple.record.previousIndex);
          movedTuples.push(tuple);
        } else {
          this._viewContainer.remove(tuple.record.previousIndex);
        }
      }
      return movedTuples;
    };
    NgFor.prototype._bulkInsert = function(tuples) {
      tuples.sort(function(a, b) {
        return a.record.currentIndex - b.record.currentIndex;
      });
      for (var i = 0; i < tuples.length; i++) {
        var tuple = tuples[i];
        if (lang_1.isPresent(tuple.view)) {
          this._viewContainer.insert(tuple.view, tuple.record.currentIndex);
        } else {
          tuple.view = this._viewContainer.createEmbeddedView(this._templateRef, tuple.record.currentIndex);
        }
      }
      return tuples;
    };
    NgFor = __decorate([core_1.Directive({
      selector: '[ngFor][ngForOf]',
      inputs: ['ngForTrackBy', 'ngForOf', 'ngForTemplate']
    }), __metadata('design:paramtypes', [core_1.ViewContainerRef, core_1.TemplateRef, core_1.IterableDiffers, core_1.ChangeDetectorRef])], NgFor);
    return NgFor;
  })();
  exports.NgFor = NgFor;
  var RecordViewTuple = (function() {
    function RecordViewTuple(record, view) {
      this.record = record;
      this.view = view;
    }
    return RecordViewTuple;
  })();
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/directives/ng_if", ["angular2/core", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var core_1 = require("angular2/core");
  var lang_1 = require("angular2/src/facade/lang");
  var NgIf = (function() {
    function NgIf(_viewContainer, _templateRef) {
      this._viewContainer = _viewContainer;
      this._templateRef = _templateRef;
      this._prevCondition = null;
    }
    Object.defineProperty(NgIf.prototype, "ngIf", {
      set: function(newCondition) {
        if (newCondition && (lang_1.isBlank(this._prevCondition) || !this._prevCondition)) {
          this._prevCondition = true;
          this._viewContainer.createEmbeddedView(this._templateRef);
        } else if (!newCondition && (lang_1.isBlank(this._prevCondition) || this._prevCondition)) {
          this._prevCondition = false;
          this._viewContainer.clear();
        }
      },
      enumerable: true,
      configurable: true
    });
    NgIf = __decorate([core_1.Directive({
      selector: '[ngIf]',
      inputs: ['ngIf']
    }), __metadata('design:paramtypes', [core_1.ViewContainerRef, core_1.TemplateRef])], NgIf);
    return NgIf;
  })();
  exports.NgIf = NgIf;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/directives/ng_style", ["angular2/core", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var core_1 = require("angular2/core");
  var lang_1 = require("angular2/src/facade/lang");
  var NgStyle = (function() {
    function NgStyle(_differs, _ngEl, _renderer) {
      this._differs = _differs;
      this._ngEl = _ngEl;
      this._renderer = _renderer;
    }
    Object.defineProperty(NgStyle.prototype, "rawStyle", {
      set: function(v) {
        this._rawStyle = v;
        if (lang_1.isBlank(this._differ) && lang_1.isPresent(v)) {
          this._differ = this._differs.find(this._rawStyle).create(null);
        }
      },
      enumerable: true,
      configurable: true
    });
    NgStyle.prototype.ngDoCheck = function() {
      if (lang_1.isPresent(this._differ)) {
        var changes = this._differ.diff(this._rawStyle);
        if (lang_1.isPresent(changes)) {
          this._applyChanges(changes);
        }
      }
    };
    NgStyle.prototype._applyChanges = function(changes) {
      var _this = this;
      changes.forEachAddedItem(function(record) {
        _this._setStyle(record.key, record.currentValue);
      });
      changes.forEachChangedItem(function(record) {
        _this._setStyle(record.key, record.currentValue);
      });
      changes.forEachRemovedItem(function(record) {
        _this._setStyle(record.key, null);
      });
    };
    NgStyle.prototype._setStyle = function(name, val) {
      this._renderer.setElementStyle(this._ngEl.nativeElement, name, val);
    };
    NgStyle = __decorate([core_1.Directive({
      selector: '[ngStyle]',
      inputs: ['rawStyle: ngStyle']
    }), __metadata('design:paramtypes', [core_1.KeyValueDiffers, core_1.ElementRef, core_1.Renderer])], NgStyle);
    return NgStyle;
  })();
  exports.NgStyle = NgStyle;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/directives/ng_switch", ["angular2/core", "angular2/src/facade/lang", "angular2/src/facade/collection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var core_1 = require("angular2/core");
  var lang_1 = require("angular2/src/facade/lang");
  var collection_1 = require("angular2/src/facade/collection");
  var _WHEN_DEFAULT = lang_1.CONST_EXPR(new Object());
  var SwitchView = (function() {
    function SwitchView(_viewContainerRef, _templateRef) {
      this._viewContainerRef = _viewContainerRef;
      this._templateRef = _templateRef;
    }
    SwitchView.prototype.create = function() {
      this._viewContainerRef.createEmbeddedView(this._templateRef);
    };
    SwitchView.prototype.destroy = function() {
      this._viewContainerRef.clear();
    };
    return SwitchView;
  })();
  exports.SwitchView = SwitchView;
  var NgSwitch = (function() {
    function NgSwitch() {
      this._useDefault = false;
      this._valueViews = new collection_1.Map();
      this._activeViews = [];
    }
    Object.defineProperty(NgSwitch.prototype, "ngSwitch", {
      set: function(value) {
        this._emptyAllActiveViews();
        this._useDefault = false;
        var views = this._valueViews.get(value);
        if (lang_1.isBlank(views)) {
          this._useDefault = true;
          views = lang_1.normalizeBlank(this._valueViews.get(_WHEN_DEFAULT));
        }
        this._activateViews(views);
        this._switchValue = value;
      },
      enumerable: true,
      configurable: true
    });
    NgSwitch.prototype._onWhenValueChanged = function(oldWhen, newWhen, view) {
      this._deregisterView(oldWhen, view);
      this._registerView(newWhen, view);
      if (oldWhen === this._switchValue) {
        view.destroy();
        collection_1.ListWrapper.remove(this._activeViews, view);
      } else if (newWhen === this._switchValue) {
        if (this._useDefault) {
          this._useDefault = false;
          this._emptyAllActiveViews();
        }
        view.create();
        this._activeViews.push(view);
      }
      if (this._activeViews.length === 0 && !this._useDefault) {
        this._useDefault = true;
        this._activateViews(this._valueViews.get(_WHEN_DEFAULT));
      }
    };
    NgSwitch.prototype._emptyAllActiveViews = function() {
      var activeContainers = this._activeViews;
      for (var i = 0; i < activeContainers.length; i++) {
        activeContainers[i].destroy();
      }
      this._activeViews = [];
    };
    NgSwitch.prototype._activateViews = function(views) {
      if (lang_1.isPresent(views)) {
        for (var i = 0; i < views.length; i++) {
          views[i].create();
        }
        this._activeViews = views;
      }
    };
    NgSwitch.prototype._registerView = function(value, view) {
      var views = this._valueViews.get(value);
      if (lang_1.isBlank(views)) {
        views = [];
        this._valueViews.set(value, views);
      }
      views.push(view);
    };
    NgSwitch.prototype._deregisterView = function(value, view) {
      if (value === _WHEN_DEFAULT)
        return ;
      var views = this._valueViews.get(value);
      if (views.length == 1) {
        this._valueViews.delete(value);
      } else {
        collection_1.ListWrapper.remove(views, view);
      }
    };
    NgSwitch = __decorate([core_1.Directive({
      selector: '[ngSwitch]',
      inputs: ['ngSwitch']
    }), __metadata('design:paramtypes', [])], NgSwitch);
    return NgSwitch;
  })();
  exports.NgSwitch = NgSwitch;
  var NgSwitchWhen = (function() {
    function NgSwitchWhen(viewContainer, templateRef, ngSwitch) {
      this._value = _WHEN_DEFAULT;
      this._switch = ngSwitch;
      this._view = new SwitchView(viewContainer, templateRef);
    }
    Object.defineProperty(NgSwitchWhen.prototype, "ngSwitchWhen", {
      set: function(value) {
        this._switch._onWhenValueChanged(this._value, value, this._view);
        this._value = value;
      },
      enumerable: true,
      configurable: true
    });
    NgSwitchWhen = __decorate([core_1.Directive({
      selector: '[ngSwitchWhen]',
      inputs: ['ngSwitchWhen']
    }), __param(2, core_1.Host()), __metadata('design:paramtypes', [core_1.ViewContainerRef, core_1.TemplateRef, NgSwitch])], NgSwitchWhen);
    return NgSwitchWhen;
  })();
  exports.NgSwitchWhen = NgSwitchWhen;
  var NgSwitchDefault = (function() {
    function NgSwitchDefault(viewContainer, templateRef, sswitch) {
      sswitch._registerView(_WHEN_DEFAULT, new SwitchView(viewContainer, templateRef));
    }
    NgSwitchDefault = __decorate([core_1.Directive({selector: '[ngSwitchDefault]'}), __param(2, core_1.Host()), __metadata('design:paramtypes', [core_1.ViewContainerRef, core_1.TemplateRef, NgSwitch])], NgSwitchDefault);
    return NgSwitchDefault;
  })();
  exports.NgSwitchDefault = NgSwitchDefault;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/directives/observable_list_diff", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/directives/core_directives", ["angular2/src/facade/lang", "angular2/src/common/directives/ng_class", "angular2/src/common/directives/ng_for", "angular2/src/common/directives/ng_if", "angular2/src/common/directives/ng_style", "angular2/src/common/directives/ng_switch"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var ng_class_1 = require("angular2/src/common/directives/ng_class");
  var ng_for_1 = require("angular2/src/common/directives/ng_for");
  var ng_if_1 = require("angular2/src/common/directives/ng_if");
  var ng_style_1 = require("angular2/src/common/directives/ng_style");
  var ng_switch_1 = require("angular2/src/common/directives/ng_switch");
  exports.CORE_DIRECTIVES = lang_1.CONST_EXPR([ng_class_1.NgClass, ng_for_1.NgFor, ng_if_1.NgIf, ng_style_1.NgStyle, ng_switch_1.NgSwitch, ng_switch_1.NgSwitchWhen, ng_switch_1.NgSwitchDefault]);
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/model", ["angular2/src/facade/lang", "angular2/src/facade/async", "angular2/src/facade/promise", "angular2/src/facade/collection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var lang_1 = require("angular2/src/facade/lang");
  var async_1 = require("angular2/src/facade/async");
  var promise_1 = require("angular2/src/facade/promise");
  var collection_1 = require("angular2/src/facade/collection");
  exports.VALID = "VALID";
  exports.INVALID = "INVALID";
  exports.PENDING = "PENDING";
  function isControl(control) {
    return control instanceof AbstractControl;
  }
  exports.isControl = isControl;
  function _find(control, path) {
    if (lang_1.isBlank(path))
      return null;
    if (!(path instanceof Array)) {
      path = path.split("/");
    }
    if (path instanceof Array && collection_1.ListWrapper.isEmpty(path))
      return null;
    return path.reduce(function(v, name) {
      if (v instanceof ControlGroup) {
        return lang_1.isPresent(v.controls[name]) ? v.controls[name] : null;
      } else if (v instanceof ControlArray) {
        var index = name;
        return lang_1.isPresent(v.at(index)) ? v.at(index) : null;
      } else {
        return null;
      }
    }, control);
  }
  function toObservable(r) {
    return promise_1.PromiseWrapper.isPromise(r) ? async_1.ObservableWrapper.fromPromise(r) : r;
  }
  var AbstractControl = (function() {
    function AbstractControl(validator, asyncValidator) {
      this.validator = validator;
      this.asyncValidator = asyncValidator;
      this._pristine = true;
      this._touched = false;
    }
    Object.defineProperty(AbstractControl.prototype, "value", {
      get: function() {
        return this._value;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControl.prototype, "status", {
      get: function() {
        return this._status;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControl.prototype, "valid", {
      get: function() {
        return this._status === exports.VALID;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControl.prototype, "errors", {
      get: function() {
        return this._errors;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControl.prototype, "pristine", {
      get: function() {
        return this._pristine;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControl.prototype, "dirty", {
      get: function() {
        return !this.pristine;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControl.prototype, "touched", {
      get: function() {
        return this._touched;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControl.prototype, "untouched", {
      get: function() {
        return !this._touched;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControl.prototype, "valueChanges", {
      get: function() {
        return this._valueChanges;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControl.prototype, "statusChanges", {
      get: function() {
        return this._statusChanges;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControl.prototype, "pending", {
      get: function() {
        return this._status == exports.PENDING;
      },
      enumerable: true,
      configurable: true
    });
    AbstractControl.prototype.markAsTouched = function() {
      this._touched = true;
    };
    AbstractControl.prototype.markAsDirty = function(_a) {
      var onlySelf = (_a === void 0 ? {} : _a).onlySelf;
      onlySelf = lang_1.normalizeBool(onlySelf);
      this._pristine = false;
      if (lang_1.isPresent(this._parent) && !onlySelf) {
        this._parent.markAsDirty({onlySelf: onlySelf});
      }
    };
    AbstractControl.prototype.markAsPending = function(_a) {
      var onlySelf = (_a === void 0 ? {} : _a).onlySelf;
      onlySelf = lang_1.normalizeBool(onlySelf);
      this._status = exports.PENDING;
      if (lang_1.isPresent(this._parent) && !onlySelf) {
        this._parent.markAsPending({onlySelf: onlySelf});
      }
    };
    AbstractControl.prototype.setParent = function(parent) {
      this._parent = parent;
    };
    AbstractControl.prototype.updateValueAndValidity = function(_a) {
      var _b = _a === void 0 ? {} : _a,
          onlySelf = _b.onlySelf,
          emitEvent = _b.emitEvent;
      onlySelf = lang_1.normalizeBool(onlySelf);
      emitEvent = lang_1.isPresent(emitEvent) ? emitEvent : true;
      this._updateValue();
      this._errors = this._runValidator();
      this._status = this._calculateStatus();
      if (this._status == exports.VALID || this._status == exports.PENDING) {
        this._runAsyncValidator(emitEvent);
      }
      if (emitEvent) {
        async_1.ObservableWrapper.callEmit(this._valueChanges, this._value);
        async_1.ObservableWrapper.callEmit(this._statusChanges, this._status);
      }
      if (lang_1.isPresent(this._parent) && !onlySelf) {
        this._parent.updateValueAndValidity({
          onlySelf: onlySelf,
          emitEvent: emitEvent
        });
      }
    };
    AbstractControl.prototype._runValidator = function() {
      return lang_1.isPresent(this.validator) ? this.validator(this) : null;
    };
    AbstractControl.prototype._runAsyncValidator = function(emitEvent) {
      var _this = this;
      if (lang_1.isPresent(this.asyncValidator)) {
        this._status = exports.PENDING;
        this._cancelExistingSubscription();
        var obs = toObservable(this.asyncValidator(this));
        this._asyncValidationSubscription = async_1.ObservableWrapper.subscribe(obs, function(res) {
          return _this.setErrors(res, {emitEvent: emitEvent});
        });
      }
    };
    AbstractControl.prototype._cancelExistingSubscription = function() {
      if (lang_1.isPresent(this._asyncValidationSubscription)) {
        async_1.ObservableWrapper.dispose(this._asyncValidationSubscription);
      }
    };
    AbstractControl.prototype.setErrors = function(errors, _a) {
      var emitEvent = (_a === void 0 ? {} : _a).emitEvent;
      emitEvent = lang_1.isPresent(emitEvent) ? emitEvent : true;
      this._errors = errors;
      this._status = this._calculateStatus();
      if (emitEvent) {
        async_1.ObservableWrapper.callEmit(this._statusChanges, this._status);
      }
      if (lang_1.isPresent(this._parent)) {
        this._parent._updateControlsErrors();
      }
    };
    AbstractControl.prototype.find = function(path) {
      return _find(this, path);
    };
    AbstractControl.prototype.getError = function(errorCode, path) {
      if (path === void 0) {
        path = null;
      }
      var control = lang_1.isPresent(path) && !collection_1.ListWrapper.isEmpty(path) ? this.find(path) : this;
      if (lang_1.isPresent(control) && lang_1.isPresent(control._errors)) {
        return collection_1.StringMapWrapper.get(control._errors, errorCode);
      } else {
        return null;
      }
    };
    AbstractControl.prototype.hasError = function(errorCode, path) {
      if (path === void 0) {
        path = null;
      }
      return lang_1.isPresent(this.getError(errorCode, path));
    };
    Object.defineProperty(AbstractControl.prototype, "root", {
      get: function() {
        var x = this;
        while (lang_1.isPresent(x._parent)) {
          x = x._parent;
        }
        return x;
      },
      enumerable: true,
      configurable: true
    });
    AbstractControl.prototype._updateControlsErrors = function() {
      this._status = this._calculateStatus();
      if (lang_1.isPresent(this._parent)) {
        this._parent._updateControlsErrors();
      }
    };
    AbstractControl.prototype._initObservables = function() {
      this._valueChanges = new async_1.EventEmitter();
      this._statusChanges = new async_1.EventEmitter();
    };
    AbstractControl.prototype._calculateStatus = function() {
      if (lang_1.isPresent(this._errors))
        return exports.INVALID;
      if (this._anyControlsHaveStatus(exports.PENDING))
        return exports.PENDING;
      if (this._anyControlsHaveStatus(exports.INVALID))
        return exports.INVALID;
      return exports.VALID;
    };
    return AbstractControl;
  })();
  exports.AbstractControl = AbstractControl;
  var Control = (function(_super) {
    __extends(Control, _super);
    function Control(value, validator, asyncValidator) {
      if (value === void 0) {
        value = null;
      }
      if (validator === void 0) {
        validator = null;
      }
      if (asyncValidator === void 0) {
        asyncValidator = null;
      }
      _super.call(this, validator, asyncValidator);
      this._value = value;
      this.updateValueAndValidity({
        onlySelf: true,
        emitEvent: false
      });
      this._initObservables();
    }
    Control.prototype.updateValue = function(value, _a) {
      var _b = _a === void 0 ? {} : _a,
          onlySelf = _b.onlySelf,
          emitEvent = _b.emitEvent,
          emitModelToViewChange = _b.emitModelToViewChange;
      emitModelToViewChange = lang_1.isPresent(emitModelToViewChange) ? emitModelToViewChange : true;
      this._value = value;
      if (lang_1.isPresent(this._onChange) && emitModelToViewChange)
        this._onChange(this._value);
      this.updateValueAndValidity({
        onlySelf: onlySelf,
        emitEvent: emitEvent
      });
    };
    Control.prototype._updateValue = function() {};
    Control.prototype._anyControlsHaveStatus = function(status) {
      return false;
    };
    Control.prototype.registerOnChange = function(fn) {
      this._onChange = fn;
    };
    return Control;
  })(AbstractControl);
  exports.Control = Control;
  var ControlGroup = (function(_super) {
    __extends(ControlGroup, _super);
    function ControlGroup(controls, optionals, validator, asyncValidator) {
      if (optionals === void 0) {
        optionals = null;
      }
      if (validator === void 0) {
        validator = null;
      }
      if (asyncValidator === void 0) {
        asyncValidator = null;
      }
      _super.call(this, validator, asyncValidator);
      this.controls = controls;
      this._optionals = lang_1.isPresent(optionals) ? optionals : {};
      this._initObservables();
      this._setParentForControls();
      this.updateValueAndValidity({
        onlySelf: true,
        emitEvent: false
      });
    }
    ControlGroup.prototype.addControl = function(name, control) {
      this.controls[name] = control;
      control.setParent(this);
    };
    ControlGroup.prototype.removeControl = function(name) {
      collection_1.StringMapWrapper.delete(this.controls, name);
    };
    ControlGroup.prototype.include = function(controlName) {
      collection_1.StringMapWrapper.set(this._optionals, controlName, true);
      this.updateValueAndValidity();
    };
    ControlGroup.prototype.exclude = function(controlName) {
      collection_1.StringMapWrapper.set(this._optionals, controlName, false);
      this.updateValueAndValidity();
    };
    ControlGroup.prototype.contains = function(controlName) {
      var c = collection_1.StringMapWrapper.contains(this.controls, controlName);
      return c && this._included(controlName);
    };
    ControlGroup.prototype._setParentForControls = function() {
      var _this = this;
      collection_1.StringMapWrapper.forEach(this.controls, function(control, name) {
        control.setParent(_this);
      });
    };
    ControlGroup.prototype._updateValue = function() {
      this._value = this._reduceValue();
    };
    ControlGroup.prototype._anyControlsHaveStatus = function(status) {
      var _this = this;
      var res = false;
      collection_1.StringMapWrapper.forEach(this.controls, function(control, name) {
        res = res || (_this.contains(name) && control.status == status);
      });
      return res;
    };
    ControlGroup.prototype._reduceValue = function() {
      return this._reduceChildren({}, function(acc, control, name) {
        acc[name] = control.value;
        return acc;
      });
    };
    ControlGroup.prototype._reduceChildren = function(initValue, fn) {
      var _this = this;
      var res = initValue;
      collection_1.StringMapWrapper.forEach(this.controls, function(control, name) {
        if (_this._included(name)) {
          res = fn(res, control, name);
        }
      });
      return res;
    };
    ControlGroup.prototype._included = function(controlName) {
      var isOptional = collection_1.StringMapWrapper.contains(this._optionals, controlName);
      return !isOptional || collection_1.StringMapWrapper.get(this._optionals, controlName);
    };
    return ControlGroup;
  })(AbstractControl);
  exports.ControlGroup = ControlGroup;
  var ControlArray = (function(_super) {
    __extends(ControlArray, _super);
    function ControlArray(controls, validator, asyncValidator) {
      if (validator === void 0) {
        validator = null;
      }
      if (asyncValidator === void 0) {
        asyncValidator = null;
      }
      _super.call(this, validator, asyncValidator);
      this.controls = controls;
      this._initObservables();
      this._setParentForControls();
      this.updateValueAndValidity({
        onlySelf: true,
        emitEvent: false
      });
    }
    ControlArray.prototype.at = function(index) {
      return this.controls[index];
    };
    ControlArray.prototype.push = function(control) {
      this.controls.push(control);
      control.setParent(this);
      this.updateValueAndValidity();
    };
    ControlArray.prototype.insert = function(index, control) {
      collection_1.ListWrapper.insert(this.controls, index, control);
      control.setParent(this);
      this.updateValueAndValidity();
    };
    ControlArray.prototype.removeAt = function(index) {
      collection_1.ListWrapper.removeAt(this.controls, index);
      this.updateValueAndValidity();
    };
    Object.defineProperty(ControlArray.prototype, "length", {
      get: function() {
        return this.controls.length;
      },
      enumerable: true,
      configurable: true
    });
    ControlArray.prototype._updateValue = function() {
      this._value = this.controls.map(function(control) {
        return control.value;
      });
    };
    ControlArray.prototype._anyControlsHaveStatus = function(status) {
      return this.controls.some(function(c) {
        return c.status == status;
      });
    };
    ControlArray.prototype._setParentForControls = function() {
      var _this = this;
      this.controls.forEach(function(control) {
        control.setParent(_this);
      });
    };
    return ControlArray;
  })(AbstractControl);
  exports.ControlArray = ControlArray;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/abstract_control_directive", ["angular2/src/facade/lang", "angular2/src/facade/exceptions"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var AbstractControlDirective = (function() {
    function AbstractControlDirective() {}
    Object.defineProperty(AbstractControlDirective.prototype, "control", {
      get: function() {
        return exceptions_1.unimplemented();
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControlDirective.prototype, "value", {
      get: function() {
        return lang_1.isPresent(this.control) ? this.control.value : null;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControlDirective.prototype, "valid", {
      get: function() {
        return lang_1.isPresent(this.control) ? this.control.valid : null;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControlDirective.prototype, "errors", {
      get: function() {
        return lang_1.isPresent(this.control) ? this.control.errors : null;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControlDirective.prototype, "pristine", {
      get: function() {
        return lang_1.isPresent(this.control) ? this.control.pristine : null;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControlDirective.prototype, "dirty", {
      get: function() {
        return lang_1.isPresent(this.control) ? this.control.dirty : null;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControlDirective.prototype, "touched", {
      get: function() {
        return lang_1.isPresent(this.control) ? this.control.touched : null;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControlDirective.prototype, "untouched", {
      get: function() {
        return lang_1.isPresent(this.control) ? this.control.untouched : null;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(AbstractControlDirective.prototype, "path", {
      get: function() {
        return null;
      },
      enumerable: true,
      configurable: true
    });
    return AbstractControlDirective;
  })();
  exports.AbstractControlDirective = AbstractControlDirective;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/control_container", ["angular2/src/common/forms/directives/abstract_control_directive"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var abstract_control_directive_1 = require("angular2/src/common/forms/directives/abstract_control_directive");
  var ControlContainer = (function(_super) {
    __extends(ControlContainer, _super);
    function ControlContainer() {
      _super.apply(this, arguments);
    }
    Object.defineProperty(ControlContainer.prototype, "formDirective", {
      get: function() {
        return null;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(ControlContainer.prototype, "path", {
      get: function() {
        return null;
      },
      enumerable: true,
      configurable: true
    });
    return ControlContainer;
  })(abstract_control_directive_1.AbstractControlDirective);
  exports.ControlContainer = ControlContainer;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/ng_control", ["angular2/src/common/forms/directives/abstract_control_directive", "angular2/src/facade/exceptions"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var abstract_control_directive_1 = require("angular2/src/common/forms/directives/abstract_control_directive");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var NgControl = (function(_super) {
    __extends(NgControl, _super);
    function NgControl() {
      _super.apply(this, arguments);
      this.name = null;
      this.valueAccessor = null;
    }
    Object.defineProperty(NgControl.prototype, "validator", {
      get: function() {
        return exceptions_1.unimplemented();
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgControl.prototype, "asyncValidator", {
      get: function() {
        return exceptions_1.unimplemented();
      },
      enumerable: true,
      configurable: true
    });
    return NgControl;
  })(abstract_control_directive_1.AbstractControlDirective);
  exports.NgControl = NgControl;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/control_value_accessor", ["angular2/core", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var core_1 = require("angular2/core");
  var lang_1 = require("angular2/src/facade/lang");
  exports.NG_VALUE_ACCESSOR = lang_1.CONST_EXPR(new core_1.OpaqueToken("NgValueAccessor"));
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/validators", ["angular2/src/facade/lang", "angular2/src/facade/promise", "angular2/src/facade/async", "angular2/src/facade/collection", "angular2/core"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var promise_1 = require("angular2/src/facade/promise");
  var async_1 = require("angular2/src/facade/async");
  var collection_1 = require("angular2/src/facade/collection");
  var core_1 = require("angular2/core");
  exports.NG_VALIDATORS = lang_1.CONST_EXPR(new core_1.OpaqueToken("NgValidators"));
  exports.NG_ASYNC_VALIDATORS = lang_1.CONST_EXPR(new core_1.OpaqueToken("NgAsyncValidators"));
  var Validators = (function() {
    function Validators() {}
    Validators.required = function(control) {
      return lang_1.isBlank(control.value) || (lang_1.isString(control.value) && control.value == "") ? {"required": true} : null;
    };
    Validators.minLength = function(minLength) {
      return function(control) {
        if (lang_1.isPresent(Validators.required(control)))
          return null;
        var v = control.value;
        return v.length < minLength ? {"minlength": {
            "requiredLength": minLength,
            "actualLength": v.length
          }} : null;
      };
    };
    Validators.maxLength = function(maxLength) {
      return function(control) {
        if (lang_1.isPresent(Validators.required(control)))
          return null;
        var v = control.value;
        return v.length > maxLength ? {"maxlength": {
            "requiredLength": maxLength,
            "actualLength": v.length
          }} : null;
      };
    };
    Validators.nullValidator = function(c) {
      return null;
    };
    Validators.compose = function(validators) {
      if (lang_1.isBlank(validators))
        return null;
      var presentValidators = validators.filter(lang_1.isPresent);
      if (presentValidators.length == 0)
        return null;
      return function(control) {
        return _mergeErrors(_executeValidators(control, presentValidators));
      };
    };
    Validators.composeAsync = function(validators) {
      if (lang_1.isBlank(validators))
        return null;
      var presentValidators = validators.filter(lang_1.isPresent);
      if (presentValidators.length == 0)
        return null;
      return function(control) {
        var promises = _executeValidators(control, presentValidators).map(_convertToPromise);
        return promise_1.PromiseWrapper.all(promises).then(_mergeErrors);
      };
    };
    return Validators;
  })();
  exports.Validators = Validators;
  function _convertToPromise(obj) {
    return promise_1.PromiseWrapper.isPromise(obj) ? obj : async_1.ObservableWrapper.toPromise(obj);
  }
  function _executeValidators(control, validators) {
    return validators.map(function(v) {
      return v(control);
    });
  }
  function _mergeErrors(arrayOfErrors) {
    var res = arrayOfErrors.reduce(function(res, errors) {
      return lang_1.isPresent(errors) ? collection_1.StringMapWrapper.merge(res, errors) : res;
    }, {});
    return collection_1.StringMapWrapper.isEmpty(res) ? null : res;
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/default_value_accessor", ["angular2/core", "angular2/src/common/forms/directives/control_value_accessor", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var core_1 = require("angular2/core");
  var control_value_accessor_1 = require("angular2/src/common/forms/directives/control_value_accessor");
  var lang_1 = require("angular2/src/facade/lang");
  var DEFAULT_VALUE_ACCESSOR = lang_1.CONST_EXPR(new core_1.Provider(control_value_accessor_1.NG_VALUE_ACCESSOR, {
    useExisting: core_1.forwardRef(function() {
      return DefaultValueAccessor;
    }),
    multi: true
  }));
  var DefaultValueAccessor = (function() {
    function DefaultValueAccessor(_renderer, _elementRef) {
      this._renderer = _renderer;
      this._elementRef = _elementRef;
      this.onChange = function(_) {};
      this.onTouched = function() {};
    }
    DefaultValueAccessor.prototype.writeValue = function(value) {
      var normalizedValue = lang_1.isBlank(value) ? '' : value;
      this._renderer.setElementProperty(this._elementRef.nativeElement, 'value', normalizedValue);
    };
    DefaultValueAccessor.prototype.registerOnChange = function(fn) {
      this.onChange = fn;
    };
    DefaultValueAccessor.prototype.registerOnTouched = function(fn) {
      this.onTouched = fn;
    };
    DefaultValueAccessor = __decorate([core_1.Directive({
      selector: 'input:not([type=checkbox])[ngControl],textarea[ngControl],input:not([type=checkbox])[ngFormControl],textarea[ngFormControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]',
      host: {
        '(input)': 'onChange($event.target.value)',
        '(blur)': 'onTouched()'
      },
      bindings: [DEFAULT_VALUE_ACCESSOR]
    }), __metadata('design:paramtypes', [core_1.Renderer, core_1.ElementRef])], DefaultValueAccessor);
    return DefaultValueAccessor;
  })();
  exports.DefaultValueAccessor = DefaultValueAccessor;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/number_value_accessor", ["angular2/core", "angular2/src/common/forms/directives/control_value_accessor", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var core_1 = require("angular2/core");
  var control_value_accessor_1 = require("angular2/src/common/forms/directives/control_value_accessor");
  var lang_1 = require("angular2/src/facade/lang");
  var NUMBER_VALUE_ACCESSOR = lang_1.CONST_EXPR(new core_1.Provider(control_value_accessor_1.NG_VALUE_ACCESSOR, {
    useExisting: core_1.forwardRef(function() {
      return NumberValueAccessor;
    }),
    multi: true
  }));
  var NumberValueAccessor = (function() {
    function NumberValueAccessor(_renderer, _elementRef) {
      this._renderer = _renderer;
      this._elementRef = _elementRef;
      this.onChange = function(_) {};
      this.onTouched = function() {};
    }
    NumberValueAccessor.prototype.writeValue = function(value) {
      this._renderer.setElementProperty(this._elementRef.nativeElement, 'value', value);
    };
    NumberValueAccessor.prototype.registerOnChange = function(fn) {
      this.onChange = function(value) {
        fn(lang_1.NumberWrapper.parseFloat(value));
      };
    };
    NumberValueAccessor.prototype.registerOnTouched = function(fn) {
      this.onTouched = fn;
    };
    NumberValueAccessor = __decorate([core_1.Directive({
      selector: 'input[type=number][ngControl],input[type=number][ngFormControl],input[type=number][ngModel]',
      host: {
        '(change)': 'onChange($event.target.value)',
        '(input)': 'onChange($event.target.value)',
        '(blur)': 'onTouched()'
      },
      bindings: [NUMBER_VALUE_ACCESSOR]
    }), __metadata('design:paramtypes', [core_1.Renderer, core_1.ElementRef])], NumberValueAccessor);
    return NumberValueAccessor;
  })();
  exports.NumberValueAccessor = NumberValueAccessor;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/checkbox_value_accessor", ["angular2/core", "angular2/src/common/forms/directives/control_value_accessor", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var core_1 = require("angular2/core");
  var control_value_accessor_1 = require("angular2/src/common/forms/directives/control_value_accessor");
  var lang_1 = require("angular2/src/facade/lang");
  var CHECKBOX_VALUE_ACCESSOR = lang_1.CONST_EXPR(new core_1.Provider(control_value_accessor_1.NG_VALUE_ACCESSOR, {
    useExisting: core_1.forwardRef(function() {
      return CheckboxControlValueAccessor;
    }),
    multi: true
  }));
  var CheckboxControlValueAccessor = (function() {
    function CheckboxControlValueAccessor(_renderer, _elementRef) {
      this._renderer = _renderer;
      this._elementRef = _elementRef;
      this.onChange = function(_) {};
      this.onTouched = function() {};
    }
    CheckboxControlValueAccessor.prototype.writeValue = function(value) {
      this._renderer.setElementProperty(this._elementRef.nativeElement, 'checked', value);
    };
    CheckboxControlValueAccessor.prototype.registerOnChange = function(fn) {
      this.onChange = fn;
    };
    CheckboxControlValueAccessor.prototype.registerOnTouched = function(fn) {
      this.onTouched = fn;
    };
    CheckboxControlValueAccessor = __decorate([core_1.Directive({
      selector: 'input[type=checkbox][ngControl],input[type=checkbox][ngFormControl],input[type=checkbox][ngModel]',
      host: {
        '(change)': 'onChange($event.target.checked)',
        '(blur)': 'onTouched()'
      },
      providers: [CHECKBOX_VALUE_ACCESSOR]
    }), __metadata('design:paramtypes', [core_1.Renderer, core_1.ElementRef])], CheckboxControlValueAccessor);
    return CheckboxControlValueAccessor;
  })();
  exports.CheckboxControlValueAccessor = CheckboxControlValueAccessor;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/select_control_value_accessor", ["angular2/core", "angular2/src/facade/async", "angular2/src/common/forms/directives/control_value_accessor", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var core_1 = require("angular2/core");
  var async_1 = require("angular2/src/facade/async");
  var control_value_accessor_1 = require("angular2/src/common/forms/directives/control_value_accessor");
  var lang_1 = require("angular2/src/facade/lang");
  var SELECT_VALUE_ACCESSOR = lang_1.CONST_EXPR(new core_1.Provider(control_value_accessor_1.NG_VALUE_ACCESSOR, {
    useExisting: core_1.forwardRef(function() {
      return SelectControlValueAccessor;
    }),
    multi: true
  }));
  var NgSelectOption = (function() {
    function NgSelectOption() {}
    NgSelectOption = __decorate([core_1.Directive({selector: 'option'}), __metadata('design:paramtypes', [])], NgSelectOption);
    return NgSelectOption;
  })();
  exports.NgSelectOption = NgSelectOption;
  var SelectControlValueAccessor = (function() {
    function SelectControlValueAccessor(_renderer, _elementRef, query) {
      this._renderer = _renderer;
      this._elementRef = _elementRef;
      this.onChange = function(_) {};
      this.onTouched = function() {};
      this._updateValueWhenListOfOptionsChanges(query);
    }
    SelectControlValueAccessor.prototype.writeValue = function(value) {
      this.value = value;
      this._renderer.setElementProperty(this._elementRef.nativeElement, 'value', value);
    };
    SelectControlValueAccessor.prototype.registerOnChange = function(fn) {
      this.onChange = fn;
    };
    SelectControlValueAccessor.prototype.registerOnTouched = function(fn) {
      this.onTouched = fn;
    };
    SelectControlValueAccessor.prototype._updateValueWhenListOfOptionsChanges = function(query) {
      var _this = this;
      async_1.ObservableWrapper.subscribe(query.changes, function(_) {
        return _this.writeValue(_this.value);
      });
    };
    SelectControlValueAccessor = __decorate([core_1.Directive({
      selector: 'select[ngControl],select[ngFormControl],select[ngModel]',
      host: {
        '(input)': 'onChange($event.target.value)',
        '(blur)': 'onTouched()'
      },
      bindings: [SELECT_VALUE_ACCESSOR]
    }), __param(2, core_1.Query(NgSelectOption, {descendants: true})), __metadata('design:paramtypes', [core_1.Renderer, core_1.ElementRef, core_1.QueryList])], SelectControlValueAccessor);
    return SelectControlValueAccessor;
  })();
  exports.SelectControlValueAccessor = SelectControlValueAccessor;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/radio_control_value_accessor", ["angular2/core", "angular2/src/common/forms/directives/control_value_accessor", "angular2/src/common/forms/directives/ng_control", "angular2/src/facade/lang", "angular2/src/facade/collection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var core_1 = require("angular2/core");
  var control_value_accessor_1 = require("angular2/src/common/forms/directives/control_value_accessor");
  var ng_control_1 = require("angular2/src/common/forms/directives/ng_control");
  var lang_1 = require("angular2/src/facade/lang");
  var collection_1 = require("angular2/src/facade/collection");
  var RADIO_VALUE_ACCESSOR = lang_1.CONST_EXPR(new core_1.Provider(control_value_accessor_1.NG_VALUE_ACCESSOR, {
    useExisting: core_1.forwardRef(function() {
      return RadioControlValueAccessor;
    }),
    multi: true
  }));
  var RadioControlRegistry = (function() {
    function RadioControlRegistry() {
      this._accessors = [];
    }
    RadioControlRegistry.prototype.add = function(control, accessor) {
      this._accessors.push([control, accessor]);
    };
    RadioControlRegistry.prototype.remove = function(accessor) {
      var indexToRemove = -1;
      for (var i = 0; i < this._accessors.length; ++i) {
        if (this._accessors[i][1] === accessor) {
          indexToRemove = i;
        }
      }
      collection_1.ListWrapper.removeAt(this._accessors, indexToRemove);
    };
    RadioControlRegistry.prototype.select = function(accessor) {
      this._accessors.forEach(function(c) {
        if (c[0].control.root === accessor._control.control.root && c[1] !== accessor) {
          c[1].fireUncheck();
        }
      });
    };
    RadioControlRegistry = __decorate([core_1.Injectable(), __metadata('design:paramtypes', [])], RadioControlRegistry);
    return RadioControlRegistry;
  })();
  exports.RadioControlRegistry = RadioControlRegistry;
  var RadioButtonState = (function() {
    function RadioButtonState(checked, value) {
      this.checked = checked;
      this.value = value;
    }
    return RadioButtonState;
  })();
  exports.RadioButtonState = RadioButtonState;
  var RadioControlValueAccessor = (function() {
    function RadioControlValueAccessor(_renderer, _elementRef, _registry, _injector) {
      this._renderer = _renderer;
      this._elementRef = _elementRef;
      this._registry = _registry;
      this._injector = _injector;
      this.onChange = function() {};
      this.onTouched = function() {};
    }
    RadioControlValueAccessor.prototype.ngOnInit = function() {
      this._control = this._injector.get(ng_control_1.NgControl);
      this._registry.add(this._control, this);
    };
    RadioControlValueAccessor.prototype.ngOnDestroy = function() {
      this._registry.remove(this);
    };
    RadioControlValueAccessor.prototype.writeValue = function(value) {
      this._state = value;
      if (lang_1.isPresent(value) && value.checked) {
        this._renderer.setElementProperty(this._elementRef.nativeElement, 'checked', true);
      }
    };
    RadioControlValueAccessor.prototype.registerOnChange = function(fn) {
      var _this = this;
      this._fn = fn;
      this.onChange = function() {
        fn(new RadioButtonState(true, _this._state.value));
        _this._registry.select(_this);
      };
    };
    RadioControlValueAccessor.prototype.fireUncheck = function() {
      this._fn(new RadioButtonState(false, this._state.value));
    };
    RadioControlValueAccessor.prototype.registerOnTouched = function(fn) {
      this.onTouched = fn;
    };
    __decorate([core_1.Input(), __metadata('design:type', String)], RadioControlValueAccessor.prototype, "name", void 0);
    RadioControlValueAccessor = __decorate([core_1.Directive({
      selector: 'input[type=radio][ngControl],input[type=radio][ngFormControl],input[type=radio][ngModel]',
      host: {
        '(change)': 'onChange()',
        '(blur)': 'onTouched()'
      },
      providers: [RADIO_VALUE_ACCESSOR]
    }), __metadata('design:paramtypes', [core_1.Renderer, core_1.ElementRef, RadioControlRegistry, core_1.Injector])], RadioControlValueAccessor);
    return RadioControlValueAccessor;
  })();
  exports.RadioControlValueAccessor = RadioControlValueAccessor;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/normalize_validator", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  function normalizeValidator(validator) {
    if (validator.validate !== undefined) {
      return function(c) {
        return validator.validate(c);
      };
    } else {
      return validator;
    }
  }
  exports.normalizeValidator = normalizeValidator;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/ng_form_control", ["angular2/src/facade/lang", "angular2/src/facade/collection", "angular2/src/facade/async", "angular2/core", "angular2/src/common/forms/directives/ng_control", "angular2/src/common/forms/validators", "angular2/src/common/forms/directives/control_value_accessor", "angular2/src/common/forms/directives/shared"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var lang_1 = require("angular2/src/facade/lang");
  var collection_1 = require("angular2/src/facade/collection");
  var async_1 = require("angular2/src/facade/async");
  var core_1 = require("angular2/core");
  var ng_control_1 = require("angular2/src/common/forms/directives/ng_control");
  var validators_1 = require("angular2/src/common/forms/validators");
  var control_value_accessor_1 = require("angular2/src/common/forms/directives/control_value_accessor");
  var shared_1 = require("angular2/src/common/forms/directives/shared");
  var formControlBinding = lang_1.CONST_EXPR(new core_1.Provider(ng_control_1.NgControl, {useExisting: core_1.forwardRef(function() {
      return NgFormControl;
    })}));
  var NgFormControl = (function(_super) {
    __extends(NgFormControl, _super);
    function NgFormControl(_validators, _asyncValidators, valueAccessors) {
      _super.call(this);
      this._validators = _validators;
      this._asyncValidators = _asyncValidators;
      this.update = new async_1.EventEmitter();
      this.valueAccessor = shared_1.selectValueAccessor(this, valueAccessors);
    }
    NgFormControl.prototype.ngOnChanges = function(changes) {
      if (this._isControlChanged(changes)) {
        shared_1.setUpControl(this.form, this);
        this.form.updateValueAndValidity({emitEvent: false});
      }
      if (shared_1.isPropertyUpdated(changes, this.viewModel)) {
        this.form.updateValue(this.model);
        this.viewModel = this.model;
      }
    };
    Object.defineProperty(NgFormControl.prototype, "path", {
      get: function() {
        return [];
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgFormControl.prototype, "validator", {
      get: function() {
        return shared_1.composeValidators(this._validators);
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgFormControl.prototype, "asyncValidator", {
      get: function() {
        return shared_1.composeAsyncValidators(this._asyncValidators);
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgFormControl.prototype, "control", {
      get: function() {
        return this.form;
      },
      enumerable: true,
      configurable: true
    });
    NgFormControl.prototype.viewToModelUpdate = function(newValue) {
      this.viewModel = newValue;
      async_1.ObservableWrapper.callEmit(this.update, newValue);
    };
    NgFormControl.prototype._isControlChanged = function(changes) {
      return collection_1.StringMapWrapper.contains(changes, "form");
    };
    NgFormControl = __decorate([core_1.Directive({
      selector: '[ngFormControl]',
      bindings: [formControlBinding],
      inputs: ['form: ngFormControl', 'model: ngModel'],
      outputs: ['update: ngModelChange'],
      exportAs: 'ngForm'
    }), __param(0, core_1.Optional()), __param(0, core_1.Self()), __param(0, core_1.Inject(validators_1.NG_VALIDATORS)), __param(1, core_1.Optional()), __param(1, core_1.Self()), __param(1, core_1.Inject(validators_1.NG_ASYNC_VALIDATORS)), __param(2, core_1.Optional()), __param(2, core_1.Self()), __param(2, core_1.Inject(control_value_accessor_1.NG_VALUE_ACCESSOR)), __metadata('design:paramtypes', [Array, Array, Array])], NgFormControl);
    return NgFormControl;
  })(ng_control_1.NgControl);
  exports.NgFormControl = NgFormControl;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/ng_model", ["angular2/src/facade/lang", "angular2/src/facade/async", "angular2/core", "angular2/src/common/forms/directives/control_value_accessor", "angular2/src/common/forms/directives/ng_control", "angular2/src/common/forms/model", "angular2/src/common/forms/validators", "angular2/src/common/forms/directives/shared"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var lang_1 = require("angular2/src/facade/lang");
  var async_1 = require("angular2/src/facade/async");
  var core_1 = require("angular2/core");
  var control_value_accessor_1 = require("angular2/src/common/forms/directives/control_value_accessor");
  var ng_control_1 = require("angular2/src/common/forms/directives/ng_control");
  var model_1 = require("angular2/src/common/forms/model");
  var validators_1 = require("angular2/src/common/forms/validators");
  var shared_1 = require("angular2/src/common/forms/directives/shared");
  var formControlBinding = lang_1.CONST_EXPR(new core_1.Provider(ng_control_1.NgControl, {useExisting: core_1.forwardRef(function() {
      return NgModel;
    })}));
  var NgModel = (function(_super) {
    __extends(NgModel, _super);
    function NgModel(_validators, _asyncValidators, valueAccessors) {
      _super.call(this);
      this._validators = _validators;
      this._asyncValidators = _asyncValidators;
      this._control = new model_1.Control();
      this._added = false;
      this.update = new async_1.EventEmitter();
      this.valueAccessor = shared_1.selectValueAccessor(this, valueAccessors);
    }
    NgModel.prototype.ngOnChanges = function(changes) {
      if (!this._added) {
        shared_1.setUpControl(this._control, this);
        this._control.updateValueAndValidity({emitEvent: false});
        this._added = true;
      }
      if (shared_1.isPropertyUpdated(changes, this.viewModel)) {
        this._control.updateValue(this.model);
        this.viewModel = this.model;
      }
    };
    Object.defineProperty(NgModel.prototype, "control", {
      get: function() {
        return this._control;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgModel.prototype, "path", {
      get: function() {
        return [];
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgModel.prototype, "validator", {
      get: function() {
        return shared_1.composeValidators(this._validators);
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgModel.prototype, "asyncValidator", {
      get: function() {
        return shared_1.composeAsyncValidators(this._asyncValidators);
      },
      enumerable: true,
      configurable: true
    });
    NgModel.prototype.viewToModelUpdate = function(newValue) {
      this.viewModel = newValue;
      async_1.ObservableWrapper.callEmit(this.update, newValue);
    };
    NgModel = __decorate([core_1.Directive({
      selector: '[ngModel]:not([ngControl]):not([ngFormControl])',
      bindings: [formControlBinding],
      inputs: ['model: ngModel'],
      outputs: ['update: ngModelChange'],
      exportAs: 'ngForm'
    }), __param(0, core_1.Optional()), __param(0, core_1.Self()), __param(0, core_1.Inject(validators_1.NG_VALIDATORS)), __param(1, core_1.Optional()), __param(1, core_1.Self()), __param(1, core_1.Inject(validators_1.NG_ASYNC_VALIDATORS)), __param(2, core_1.Optional()), __param(2, core_1.Self()), __param(2, core_1.Inject(control_value_accessor_1.NG_VALUE_ACCESSOR)), __metadata('design:paramtypes', [Array, Array, Array])], NgModel);
    return NgModel;
  })(ng_control_1.NgControl);
  exports.NgModel = NgModel;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/ng_control_group", ["angular2/core", "angular2/src/facade/lang", "angular2/src/common/forms/directives/control_container", "angular2/src/common/forms/directives/shared", "angular2/src/common/forms/validators"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var core_1 = require("angular2/core");
  var lang_1 = require("angular2/src/facade/lang");
  var control_container_1 = require("angular2/src/common/forms/directives/control_container");
  var shared_1 = require("angular2/src/common/forms/directives/shared");
  var validators_1 = require("angular2/src/common/forms/validators");
  var controlGroupProvider = lang_1.CONST_EXPR(new core_1.Provider(control_container_1.ControlContainer, {useExisting: core_1.forwardRef(function() {
      return NgControlGroup;
    })}));
  var NgControlGroup = (function(_super) {
    __extends(NgControlGroup, _super);
    function NgControlGroup(parent, _validators, _asyncValidators) {
      _super.call(this);
      this._validators = _validators;
      this._asyncValidators = _asyncValidators;
      this._parent = parent;
    }
    NgControlGroup.prototype.ngOnInit = function() {
      this.formDirective.addControlGroup(this);
    };
    NgControlGroup.prototype.ngOnDestroy = function() {
      this.formDirective.removeControlGroup(this);
    };
    Object.defineProperty(NgControlGroup.prototype, "control", {
      get: function() {
        return this.formDirective.getControlGroup(this);
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgControlGroup.prototype, "path", {
      get: function() {
        return shared_1.controlPath(this.name, this._parent);
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgControlGroup.prototype, "formDirective", {
      get: function() {
        return this._parent.formDirective;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgControlGroup.prototype, "validator", {
      get: function() {
        return shared_1.composeValidators(this._validators);
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgControlGroup.prototype, "asyncValidator", {
      get: function() {
        return shared_1.composeAsyncValidators(this._asyncValidators);
      },
      enumerable: true,
      configurable: true
    });
    NgControlGroup = __decorate([core_1.Directive({
      selector: '[ngControlGroup]',
      providers: [controlGroupProvider],
      inputs: ['name: ngControlGroup'],
      exportAs: 'ngForm'
    }), __param(0, core_1.Host()), __param(0, core_1.SkipSelf()), __param(1, core_1.Optional()), __param(1, core_1.Self()), __param(1, core_1.Inject(validators_1.NG_VALIDATORS)), __param(2, core_1.Optional()), __param(2, core_1.Self()), __param(2, core_1.Inject(validators_1.NG_ASYNC_VALIDATORS)), __metadata('design:paramtypes', [control_container_1.ControlContainer, Array, Array])], NgControlGroup);
    return NgControlGroup;
  })(control_container_1.ControlContainer);
  exports.NgControlGroup = NgControlGroup;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/ng_form_model", ["angular2/src/facade/lang", "angular2/src/facade/collection", "angular2/src/facade/async", "angular2/core", "angular2/src/common/forms/directives/control_container", "angular2/src/common/forms/directives/shared", "angular2/src/common/forms/validators"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var lang_1 = require("angular2/src/facade/lang");
  var collection_1 = require("angular2/src/facade/collection");
  var async_1 = require("angular2/src/facade/async");
  var core_1 = require("angular2/core");
  var control_container_1 = require("angular2/src/common/forms/directives/control_container");
  var shared_1 = require("angular2/src/common/forms/directives/shared");
  var validators_1 = require("angular2/src/common/forms/validators");
  var formDirectiveProvider = lang_1.CONST_EXPR(new core_1.Provider(control_container_1.ControlContainer, {useExisting: core_1.forwardRef(function() {
      return NgFormModel;
    })}));
  var NgFormModel = (function(_super) {
    __extends(NgFormModel, _super);
    function NgFormModel(_validators, _asyncValidators) {
      _super.call(this);
      this._validators = _validators;
      this._asyncValidators = _asyncValidators;
      this.form = null;
      this.directives = [];
      this.ngSubmit = new async_1.EventEmitter();
    }
    NgFormModel.prototype.ngOnChanges = function(changes) {
      if (collection_1.StringMapWrapper.contains(changes, "form")) {
        var sync = shared_1.composeValidators(this._validators);
        this.form.validator = validators_1.Validators.compose([this.form.validator, sync]);
        var async = shared_1.composeAsyncValidators(this._asyncValidators);
        this.form.asyncValidator = validators_1.Validators.composeAsync([this.form.asyncValidator, async]);
        this.form.updateValueAndValidity({
          onlySelf: true,
          emitEvent: false
        });
      }
      this._updateDomValue();
    };
    Object.defineProperty(NgFormModel.prototype, "formDirective", {
      get: function() {
        return this;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgFormModel.prototype, "control", {
      get: function() {
        return this.form;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgFormModel.prototype, "path", {
      get: function() {
        return [];
      },
      enumerable: true,
      configurable: true
    });
    NgFormModel.prototype.addControl = function(dir) {
      var ctrl = this.form.find(dir.path);
      shared_1.setUpControl(ctrl, dir);
      ctrl.updateValueAndValidity({emitEvent: false});
      this.directives.push(dir);
    };
    NgFormModel.prototype.getControl = function(dir) {
      return this.form.find(dir.path);
    };
    NgFormModel.prototype.removeControl = function(dir) {
      collection_1.ListWrapper.remove(this.directives, dir);
    };
    NgFormModel.prototype.addControlGroup = function(dir) {
      var ctrl = this.form.find(dir.path);
      shared_1.setUpControlGroup(ctrl, dir);
      ctrl.updateValueAndValidity({emitEvent: false});
    };
    NgFormModel.prototype.removeControlGroup = function(dir) {};
    NgFormModel.prototype.getControlGroup = function(dir) {
      return this.form.find(dir.path);
    };
    NgFormModel.prototype.updateModel = function(dir, value) {
      var ctrl = this.form.find(dir.path);
      ctrl.updateValue(value);
    };
    NgFormModel.prototype.onSubmit = function() {
      async_1.ObservableWrapper.callEmit(this.ngSubmit, null);
      return false;
    };
    NgFormModel.prototype._updateDomValue = function() {
      var _this = this;
      this.directives.forEach(function(dir) {
        var ctrl = _this.form.find(dir.path);
        dir.valueAccessor.writeValue(ctrl.value);
      });
    };
    NgFormModel = __decorate([core_1.Directive({
      selector: '[ngFormModel]',
      bindings: [formDirectiveProvider],
      inputs: ['form: ngFormModel'],
      host: {'(submit)': 'onSubmit()'},
      outputs: ['ngSubmit'],
      exportAs: 'ngForm'
    }), __param(0, core_1.Optional()), __param(0, core_1.Self()), __param(0, core_1.Inject(validators_1.NG_VALIDATORS)), __param(1, core_1.Optional()), __param(1, core_1.Self()), __param(1, core_1.Inject(validators_1.NG_ASYNC_VALIDATORS)), __metadata('design:paramtypes', [Array, Array])], NgFormModel);
    return NgFormModel;
  })(control_container_1.ControlContainer);
  exports.NgFormModel = NgFormModel;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/ng_form", ["angular2/src/facade/async", "angular2/src/facade/collection", "angular2/src/facade/lang", "angular2/core", "angular2/src/common/forms/directives/control_container", "angular2/src/common/forms/model", "angular2/src/common/forms/directives/shared", "angular2/src/common/forms/validators"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var async_1 = require("angular2/src/facade/async");
  var collection_1 = require("angular2/src/facade/collection");
  var lang_1 = require("angular2/src/facade/lang");
  var core_1 = require("angular2/core");
  var control_container_1 = require("angular2/src/common/forms/directives/control_container");
  var model_1 = require("angular2/src/common/forms/model");
  var shared_1 = require("angular2/src/common/forms/directives/shared");
  var validators_1 = require("angular2/src/common/forms/validators");
  var formDirectiveProvider = lang_1.CONST_EXPR(new core_1.Provider(control_container_1.ControlContainer, {useExisting: core_1.forwardRef(function() {
      return NgForm;
    })}));
  var NgForm = (function(_super) {
    __extends(NgForm, _super);
    function NgForm(validators, asyncValidators) {
      _super.call(this);
      this.ngSubmit = new async_1.EventEmitter();
      this.form = new model_1.ControlGroup({}, null, shared_1.composeValidators(validators), shared_1.composeAsyncValidators(asyncValidators));
    }
    Object.defineProperty(NgForm.prototype, "formDirective", {
      get: function() {
        return this;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgForm.prototype, "control", {
      get: function() {
        return this.form;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgForm.prototype, "path", {
      get: function() {
        return [];
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgForm.prototype, "controls", {
      get: function() {
        return this.form.controls;
      },
      enumerable: true,
      configurable: true
    });
    NgForm.prototype.addControl = function(dir) {
      var _this = this;
      async_1.PromiseWrapper.scheduleMicrotask(function() {
        var container = _this._findContainer(dir.path);
        var ctrl = new model_1.Control();
        shared_1.setUpControl(ctrl, dir);
        container.addControl(dir.name, ctrl);
        ctrl.updateValueAndValidity({emitEvent: false});
      });
    };
    NgForm.prototype.getControl = function(dir) {
      return this.form.find(dir.path);
    };
    NgForm.prototype.removeControl = function(dir) {
      var _this = this;
      async_1.PromiseWrapper.scheduleMicrotask(function() {
        var container = _this._findContainer(dir.path);
        if (lang_1.isPresent(container)) {
          container.removeControl(dir.name);
          container.updateValueAndValidity({emitEvent: false});
        }
      });
    };
    NgForm.prototype.addControlGroup = function(dir) {
      var _this = this;
      async_1.PromiseWrapper.scheduleMicrotask(function() {
        var container = _this._findContainer(dir.path);
        var group = new model_1.ControlGroup({});
        shared_1.setUpControlGroup(group, dir);
        container.addControl(dir.name, group);
        group.updateValueAndValidity({emitEvent: false});
      });
    };
    NgForm.prototype.removeControlGroup = function(dir) {
      var _this = this;
      async_1.PromiseWrapper.scheduleMicrotask(function() {
        var container = _this._findContainer(dir.path);
        if (lang_1.isPresent(container)) {
          container.removeControl(dir.name);
          container.updateValueAndValidity({emitEvent: false});
        }
      });
    };
    NgForm.prototype.getControlGroup = function(dir) {
      return this.form.find(dir.path);
    };
    NgForm.prototype.updateModel = function(dir, value) {
      var _this = this;
      async_1.PromiseWrapper.scheduleMicrotask(function() {
        var ctrl = _this.form.find(dir.path);
        ctrl.updateValue(value);
      });
    };
    NgForm.prototype.onSubmit = function() {
      async_1.ObservableWrapper.callEmit(this.ngSubmit, null);
      return false;
    };
    NgForm.prototype._findContainer = function(path) {
      path.pop();
      return collection_1.ListWrapper.isEmpty(path) ? this.form : this.form.find(path);
    };
    NgForm = __decorate([core_1.Directive({
      selector: 'form:not([ngNoForm]):not([ngFormModel]),ngForm,[ngForm]',
      bindings: [formDirectiveProvider],
      host: {'(submit)': 'onSubmit()'},
      outputs: ['ngSubmit'],
      exportAs: 'ngForm'
    }), __param(0, core_1.Optional()), __param(0, core_1.Self()), __param(0, core_1.Inject(validators_1.NG_VALIDATORS)), __param(1, core_1.Optional()), __param(1, core_1.Self()), __param(1, core_1.Inject(validators_1.NG_ASYNC_VALIDATORS)), __metadata('design:paramtypes', [Array, Array])], NgForm);
    return NgForm;
  })(control_container_1.ControlContainer);
  exports.NgForm = NgForm;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/ng_control_status", ["angular2/core", "angular2/src/common/forms/directives/ng_control", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var core_1 = require("angular2/core");
  var ng_control_1 = require("angular2/src/common/forms/directives/ng_control");
  var lang_1 = require("angular2/src/facade/lang");
  var NgControlStatus = (function() {
    function NgControlStatus(cd) {
      this._cd = cd;
    }
    Object.defineProperty(NgControlStatus.prototype, "ngClassUntouched", {
      get: function() {
        return lang_1.isPresent(this._cd.control) ? this._cd.control.untouched : false;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgControlStatus.prototype, "ngClassTouched", {
      get: function() {
        return lang_1.isPresent(this._cd.control) ? this._cd.control.touched : false;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgControlStatus.prototype, "ngClassPristine", {
      get: function() {
        return lang_1.isPresent(this._cd.control) ? this._cd.control.pristine : false;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgControlStatus.prototype, "ngClassDirty", {
      get: function() {
        return lang_1.isPresent(this._cd.control) ? this._cd.control.dirty : false;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgControlStatus.prototype, "ngClassValid", {
      get: function() {
        return lang_1.isPresent(this._cd.control) ? this._cd.control.valid : false;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgControlStatus.prototype, "ngClassInvalid", {
      get: function() {
        return lang_1.isPresent(this._cd.control) ? !this._cd.control.valid : false;
      },
      enumerable: true,
      configurable: true
    });
    NgControlStatus = __decorate([core_1.Directive({
      selector: '[ngControl],[ngModel],[ngFormControl]',
      host: {
        '[class.ng-untouched]': 'ngClassUntouched',
        '[class.ng-touched]': 'ngClassTouched',
        '[class.ng-pristine]': 'ngClassPristine',
        '[class.ng-dirty]': 'ngClassDirty',
        '[class.ng-valid]': 'ngClassValid',
        '[class.ng-invalid]': 'ngClassInvalid'
      }
    }), __param(0, core_1.Self()), __metadata('design:paramtypes', [ng_control_1.NgControl])], NgControlStatus);
    return NgControlStatus;
  })();
  exports.NgControlStatus = NgControlStatus;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/validators", ["angular2/core", "angular2/src/facade/lang", "angular2/src/common/forms/validators", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var core_1 = require("angular2/core");
  var lang_1 = require("angular2/src/facade/lang");
  var validators_1 = require("angular2/src/common/forms/validators");
  var lang_2 = require("angular2/src/facade/lang");
  var REQUIRED_VALIDATOR = lang_1.CONST_EXPR(new core_1.Provider(validators_1.NG_VALIDATORS, {
    useValue: validators_1.Validators.required,
    multi: true
  }));
  var RequiredValidator = (function() {
    function RequiredValidator() {}
    RequiredValidator = __decorate([core_1.Directive({
      selector: '[required][ngControl],[required][ngFormControl],[required][ngModel]',
      providers: [REQUIRED_VALIDATOR]
    }), __metadata('design:paramtypes', [])], RequiredValidator);
    return RequiredValidator;
  })();
  exports.RequiredValidator = RequiredValidator;
  var MIN_LENGTH_VALIDATOR = lang_1.CONST_EXPR(new core_1.Provider(validators_1.NG_VALIDATORS, {
    useExisting: core_1.forwardRef(function() {
      return MinLengthValidator;
    }),
    multi: true
  }));
  var MinLengthValidator = (function() {
    function MinLengthValidator(minLength) {
      this._validator = validators_1.Validators.minLength(lang_2.NumberWrapper.parseInt(minLength, 10));
    }
    MinLengthValidator.prototype.validate = function(c) {
      return this._validator(c);
    };
    MinLengthValidator = __decorate([core_1.Directive({
      selector: '[minlength][ngControl],[minlength][ngFormControl],[minlength][ngModel]',
      providers: [MIN_LENGTH_VALIDATOR]
    }), __param(0, core_1.Attribute("minlength")), __metadata('design:paramtypes', [String])], MinLengthValidator);
    return MinLengthValidator;
  })();
  exports.MinLengthValidator = MinLengthValidator;
  var MAX_LENGTH_VALIDATOR = lang_1.CONST_EXPR(new core_1.Provider(validators_1.NG_VALIDATORS, {
    useExisting: core_1.forwardRef(function() {
      return MaxLengthValidator;
    }),
    multi: true
  }));
  var MaxLengthValidator = (function() {
    function MaxLengthValidator(maxLength) {
      this._validator = validators_1.Validators.maxLength(lang_2.NumberWrapper.parseInt(maxLength, 10));
    }
    MaxLengthValidator.prototype.validate = function(c) {
      return this._validator(c);
    };
    MaxLengthValidator = __decorate([core_1.Directive({
      selector: '[maxlength][ngControl],[maxlength][ngFormControl],[maxlength][ngModel]',
      providers: [MAX_LENGTH_VALIDATOR]
    }), __param(0, core_1.Attribute("maxlength")), __metadata('design:paramtypes', [String])], MaxLengthValidator);
    return MaxLengthValidator;
  })();
  exports.MaxLengthValidator = MaxLengthValidator;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/form_builder", ["angular2/core", "angular2/src/facade/collection", "angular2/src/facade/lang", "angular2/src/common/forms/model"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var core_1 = require("angular2/core");
  var collection_1 = require("angular2/src/facade/collection");
  var lang_1 = require("angular2/src/facade/lang");
  var modelModule = require("angular2/src/common/forms/model");
  var FormBuilder = (function() {
    function FormBuilder() {}
    FormBuilder.prototype.group = function(controlsConfig, extra) {
      if (extra === void 0) {
        extra = null;
      }
      var controls = this._reduceControls(controlsConfig);
      var optionals = lang_1.isPresent(extra) ? collection_1.StringMapWrapper.get(extra, "optionals") : null;
      var validator = lang_1.isPresent(extra) ? collection_1.StringMapWrapper.get(extra, "validator") : null;
      var asyncValidator = lang_1.isPresent(extra) ? collection_1.StringMapWrapper.get(extra, "asyncValidator") : null;
      return new modelModule.ControlGroup(controls, optionals, validator, asyncValidator);
    };
    FormBuilder.prototype.control = function(value, validator, asyncValidator) {
      if (validator === void 0) {
        validator = null;
      }
      if (asyncValidator === void 0) {
        asyncValidator = null;
      }
      return new modelModule.Control(value, validator, asyncValidator);
    };
    FormBuilder.prototype.array = function(controlsConfig, validator, asyncValidator) {
      var _this = this;
      if (validator === void 0) {
        validator = null;
      }
      if (asyncValidator === void 0) {
        asyncValidator = null;
      }
      var controls = controlsConfig.map(function(c) {
        return _this._createControl(c);
      });
      return new modelModule.ControlArray(controls, validator, asyncValidator);
    };
    FormBuilder.prototype._reduceControls = function(controlsConfig) {
      var _this = this;
      var controls = {};
      collection_1.StringMapWrapper.forEach(controlsConfig, function(controlConfig, controlName) {
        controls[controlName] = _this._createControl(controlConfig);
      });
      return controls;
    };
    FormBuilder.prototype._createControl = function(controlConfig) {
      if (controlConfig instanceof modelModule.Control || controlConfig instanceof modelModule.ControlGroup || controlConfig instanceof modelModule.ControlArray) {
        return controlConfig;
      } else if (lang_1.isArray(controlConfig)) {
        var value = controlConfig[0];
        var validator = controlConfig.length > 1 ? controlConfig[1] : null;
        var asyncValidator = controlConfig.length > 2 ? controlConfig[2] : null;
        return this.control(value, validator, asyncValidator);
      } else {
        return this.control(controlConfig);
      }
    };
    FormBuilder = __decorate([core_1.Injectable(), __metadata('design:paramtypes', [])], FormBuilder);
    return FormBuilder;
  })();
  exports.FormBuilder = FormBuilder;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/common_directives", ["angular2/src/facade/lang", "angular2/src/common/forms", "angular2/src/common/directives"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var forms_1 = require("angular2/src/common/forms");
  var directives_1 = require("angular2/src/common/directives");
  exports.COMMON_DIRECTIVES = lang_1.CONST_EXPR([directives_1.CORE_DIRECTIVES, forms_1.FORM_DIRECTIVES]);
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/dom/events/key_events", ["angular2/src/platform/dom/dom_adapter", "angular2/src/facade/lang", "angular2/src/facade/collection", "angular2/src/platform/dom/events/event_manager", "angular2/src/core/di"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var dom_adapter_1 = require("angular2/src/platform/dom/dom_adapter");
  var lang_1 = require("angular2/src/facade/lang");
  var collection_1 = require("angular2/src/facade/collection");
  var event_manager_1 = require("angular2/src/platform/dom/events/event_manager");
  var di_1 = require("angular2/src/core/di");
  var modifierKeys = ['alt', 'control', 'meta', 'shift'];
  var modifierKeyGetters = {
    'alt': function(event) {
      return event.altKey;
    },
    'control': function(event) {
      return event.ctrlKey;
    },
    'meta': function(event) {
      return event.metaKey;
    },
    'shift': function(event) {
      return event.shiftKey;
    }
  };
  var KeyEventsPlugin = (function(_super) {
    __extends(KeyEventsPlugin, _super);
    function KeyEventsPlugin() {
      _super.call(this);
    }
    KeyEventsPlugin.prototype.supports = function(eventName) {
      return lang_1.isPresent(KeyEventsPlugin.parseEventName(eventName));
    };
    KeyEventsPlugin.prototype.addEventListener = function(element, eventName, handler) {
      var parsedEvent = KeyEventsPlugin.parseEventName(eventName);
      var outsideHandler = KeyEventsPlugin.eventCallback(element, collection_1.StringMapWrapper.get(parsedEvent, 'fullKey'), handler, this.manager.getZone());
      return this.manager.getZone().runOutsideAngular(function() {
        return dom_adapter_1.DOM.onAndCancel(element, collection_1.StringMapWrapper.get(parsedEvent, 'domEventName'), outsideHandler);
      });
    };
    KeyEventsPlugin.parseEventName = function(eventName) {
      var parts = eventName.toLowerCase().split('.');
      var domEventName = parts.shift();
      if ((parts.length === 0) || !(lang_1.StringWrapper.equals(domEventName, 'keydown') || lang_1.StringWrapper.equals(domEventName, 'keyup'))) {
        return null;
      }
      var key = KeyEventsPlugin._normalizeKey(parts.pop());
      var fullKey = '';
      modifierKeys.forEach(function(modifierName) {
        if (collection_1.ListWrapper.contains(parts, modifierName)) {
          collection_1.ListWrapper.remove(parts, modifierName);
          fullKey += modifierName + '.';
        }
      });
      fullKey += key;
      if (parts.length != 0 || key.length === 0) {
        return null;
      }
      var result = collection_1.StringMapWrapper.create();
      collection_1.StringMapWrapper.set(result, 'domEventName', domEventName);
      collection_1.StringMapWrapper.set(result, 'fullKey', fullKey);
      return result;
    };
    KeyEventsPlugin.getEventFullKey = function(event) {
      var fullKey = '';
      var key = dom_adapter_1.DOM.getEventKey(event);
      key = key.toLowerCase();
      if (lang_1.StringWrapper.equals(key, ' ')) {
        key = 'space';
      } else if (lang_1.StringWrapper.equals(key, '.')) {
        key = 'dot';
      }
      modifierKeys.forEach(function(modifierName) {
        if (modifierName != key) {
          var modifierGetter = collection_1.StringMapWrapper.get(modifierKeyGetters, modifierName);
          if (modifierGetter(event)) {
            fullKey += modifierName + '.';
          }
        }
      });
      fullKey += key;
      return fullKey;
    };
    KeyEventsPlugin.eventCallback = function(element, fullKey, handler, zone) {
      return function(event) {
        if (lang_1.StringWrapper.equals(KeyEventsPlugin.getEventFullKey(event), fullKey)) {
          zone.run(function() {
            return handler(event);
          });
        }
      };
    };
    KeyEventsPlugin._normalizeKey = function(keyName) {
      switch (keyName) {
        case 'esc':
          return 'escape';
        default:
          return keyName;
      }
    };
    KeyEventsPlugin = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [])], KeyEventsPlugin);
    return KeyEventsPlugin;
  })(event_manager_1.EventManagerPlugin);
  exports.KeyEventsPlugin = KeyEventsPlugin;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/dom/events/hammer_common", ["angular2/src/platform/dom/events/event_manager", "angular2/src/facade/collection"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var event_manager_1 = require("angular2/src/platform/dom/events/event_manager");
  var collection_1 = require("angular2/src/facade/collection");
  var _eventNames = {
    'pan': true,
    'panstart': true,
    'panmove': true,
    'panend': true,
    'pancancel': true,
    'panleft': true,
    'panright': true,
    'panup': true,
    'pandown': true,
    'pinch': true,
    'pinchstart': true,
    'pinchmove': true,
    'pinchend': true,
    'pinchcancel': true,
    'pinchin': true,
    'pinchout': true,
    'press': true,
    'pressup': true,
    'rotate': true,
    'rotatestart': true,
    'rotatemove': true,
    'rotateend': true,
    'rotatecancel': true,
    'swipe': true,
    'swipeleft': true,
    'swiperight': true,
    'swipeup': true,
    'swipedown': true,
    'tap': true
  };
  var HammerGesturesPluginCommon = (function(_super) {
    __extends(HammerGesturesPluginCommon, _super);
    function HammerGesturesPluginCommon() {
      _super.call(this);
    }
    HammerGesturesPluginCommon.prototype.supports = function(eventName) {
      eventName = eventName.toLowerCase();
      return collection_1.StringMapWrapper.contains(_eventNames, eventName);
    };
    return HammerGesturesPluginCommon;
  })(event_manager_1.EventManagerPlugin);
  exports.HammerGesturesPluginCommon = HammerGesturesPluginCommon;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/xhr", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var XHR = (function() {
    function XHR() {}
    XHR.prototype.get = function(url) {
      return null;
    };
    return XHR;
  })();
  exports.XHR = XHR;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/browser/testability", ["angular2/src/facade/collection", "angular2/src/facade/lang", "angular2/src/platform/dom/dom_adapter", "angular2/core"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var collection_1 = require("angular2/src/facade/collection");
  var lang_1 = require("angular2/src/facade/lang");
  var dom_adapter_1 = require("angular2/src/platform/dom/dom_adapter");
  var core_1 = require("angular2/core");
  var PublicTestability = (function() {
    function PublicTestability(testability) {
      this._testability = testability;
    }
    PublicTestability.prototype.isStable = function() {
      return this._testability.isStable();
    };
    PublicTestability.prototype.whenStable = function(callback) {
      this._testability.whenStable(callback);
    };
    PublicTestability.prototype.findBindings = function(using, provider, exactMatch) {
      return this.findProviders(using, provider, exactMatch);
    };
    PublicTestability.prototype.findProviders = function(using, provider, exactMatch) {
      return this._testability.findBindings(using, provider, exactMatch);
    };
    return PublicTestability;
  })();
  var BrowserGetTestability = (function() {
    function BrowserGetTestability() {}
    BrowserGetTestability.init = function() {
      core_1.setTestabilityGetter(new BrowserGetTestability());
    };
    BrowserGetTestability.prototype.addToWindow = function(registry) {
      lang_1.global.getAngularTestability = function(elem, findInAncestors) {
        if (findInAncestors === void 0) {
          findInAncestors = true;
        }
        var testability = registry.findTestabilityInTree(elem, findInAncestors);
        if (testability == null) {
          throw new Error('Could not find testability for element.');
        }
        return new PublicTestability(testability);
      };
      lang_1.global.getAllAngularTestabilities = function() {
        var testabilities = registry.getAllTestabilities();
        return testabilities.map(function(testability) {
          return new PublicTestability(testability);
        });
      };
      var whenAllStable = function(callback) {
        var testabilities = lang_1.global.getAllAngularTestabilities();
        var count = testabilities.length;
        var didWork = false;
        var decrement = function(didWork_) {
          didWork = didWork || didWork_;
          count--;
          if (count == 0) {
            callback(didWork);
          }
        };
        testabilities.forEach(function(testability) {
          testability.whenStable(decrement);
        });
      };
      if (!lang_1.global.frameworkStabilizers) {
        lang_1.global.frameworkStabilizers = collection_1.ListWrapper.createGrowableSize(0);
      }
      lang_1.global.frameworkStabilizers.push(whenAllStable);
    };
    BrowserGetTestability.prototype.findTestabilityInTree = function(registry, elem, findInAncestors) {
      if (elem == null) {
        return null;
      }
      var t = registry.getTestability(elem);
      if (lang_1.isPresent(t)) {
        return t;
      } else if (!findInAncestors) {
        return null;
      }
      if (dom_adapter_1.DOM.isShadowRoot(elem)) {
        return this.findTestabilityInTree(registry, dom_adapter_1.DOM.getHost(elem), true);
      }
      return this.findTestabilityInTree(registry, dom_adapter_1.DOM.parentElement(elem), true);
    };
    return BrowserGetTestability;
  })();
  exports.BrowserGetTestability = BrowserGetTestability;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/profile/wtf_init", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  function wtfInit() {}
  exports.wtfInit = wtfInit;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/browser/title", ["angular2/src/platform/dom/dom_adapter"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var dom_adapter_1 = require("angular2/src/platform/dom/dom_adapter");
  var Title = (function() {
    function Title() {}
    Title.prototype.getTitle = function() {
      return dom_adapter_1.DOM.getTitle();
    };
    Title.prototype.setTitle = function(newTitle) {
      dom_adapter_1.DOM.setTitle(newTitle);
    };
    return Title;
  })();
  exports.Title = Title;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/facade/browser", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var win = window;
  exports.window = win;
  exports.document = window.document;
  exports.location = window.location;
  exports.gc = window['gc'] ? function() {
    return window['gc']();
  } : function() {
    return null;
  };
  exports.performance = window['performance'] ? window['performance'] : null;
  exports.Event = window['Event'];
  exports.MouseEvent = window['MouseEvent'];
  exports.KeyboardEvent = window['KeyboardEvent'];
  exports.EventTarget = window['EventTarget'];
  exports.History = window['History'];
  exports.Location = window['Location'];
  exports.EventListener = window['EventListener'];
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/url_resolver", ["angular2/src/core/di", "angular2/src/facade/lang", "angular2/src/core/application_tokens", "angular2/src/core/di"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var di_1 = require("angular2/src/core/di");
  var lang_1 = require("angular2/src/facade/lang");
  var application_tokens_1 = require("angular2/src/core/application_tokens");
  var di_2 = require("angular2/src/core/di");
  function createWithoutPackagePrefix() {
    return new UrlResolver();
  }
  exports.createWithoutPackagePrefix = createWithoutPackagePrefix;
  exports.DEFAULT_PACKAGE_URL_PROVIDER = new di_2.Provider(application_tokens_1.PACKAGE_ROOT_URL, {useValue: "/"});
  var UrlResolver = (function() {
    function UrlResolver(packagePrefix) {
      if (packagePrefix === void 0) {
        packagePrefix = null;
      }
      if (lang_1.isPresent(packagePrefix)) {
        this._packagePrefix = lang_1.StringWrapper.stripRight(packagePrefix, "/") + "/";
      }
    }
    UrlResolver.prototype.resolve = function(baseUrl, url) {
      var resolvedUrl = url;
      if (lang_1.isPresent(baseUrl) && baseUrl.length > 0) {
        resolvedUrl = _resolveUrl(baseUrl, resolvedUrl);
      }
      if (lang_1.isPresent(this._packagePrefix) && getUrlScheme(resolvedUrl) == "package") {
        resolvedUrl = resolvedUrl.replace("package:", this._packagePrefix);
      }
      return resolvedUrl;
    };
    UrlResolver = __decorate([di_1.Injectable(), __param(0, di_1.Inject(application_tokens_1.PACKAGE_ROOT_URL)), __metadata('design:paramtypes', [String])], UrlResolver);
    return UrlResolver;
  })();
  exports.UrlResolver = UrlResolver;
  function getUrlScheme(url) {
    var match = _split(url);
    return (match && match[_ComponentIndex.Scheme]) || "";
  }
  exports.getUrlScheme = getUrlScheme;
  function _buildFromEncodedParts(opt_scheme, opt_userInfo, opt_domain, opt_port, opt_path, opt_queryData, opt_fragment) {
    var out = [];
    if (lang_1.isPresent(opt_scheme)) {
      out.push(opt_scheme + ':');
    }
    if (lang_1.isPresent(opt_domain)) {
      out.push('//');
      if (lang_1.isPresent(opt_userInfo)) {
        out.push(opt_userInfo + '@');
      }
      out.push(opt_domain);
      if (lang_1.isPresent(opt_port)) {
        out.push(':' + opt_port);
      }
    }
    if (lang_1.isPresent(opt_path)) {
      out.push(opt_path);
    }
    if (lang_1.isPresent(opt_queryData)) {
      out.push('?' + opt_queryData);
    }
    if (lang_1.isPresent(opt_fragment)) {
      out.push('#' + opt_fragment);
    }
    return out.join('');
  }
  var _splitRe = lang_1.RegExpWrapper.create('^' + '(?:' + '([^:/?#.]+)' + ':)?' + '(?://' + '(?:([^/?#]*)@)?' + '([\\w\\d\\-\\u0100-\\uffff.%]*)' + '(?::([0-9]+))?' + ')?' + '([^?#]+)?' + '(?:\\?([^#]*))?' + '(?:#(.*))?' + '$');
  var _ComponentIndex;
  (function(_ComponentIndex) {
    _ComponentIndex[_ComponentIndex["Scheme"] = 1] = "Scheme";
    _ComponentIndex[_ComponentIndex["UserInfo"] = 2] = "UserInfo";
    _ComponentIndex[_ComponentIndex["Domain"] = 3] = "Domain";
    _ComponentIndex[_ComponentIndex["Port"] = 4] = "Port";
    _ComponentIndex[_ComponentIndex["Path"] = 5] = "Path";
    _ComponentIndex[_ComponentIndex["QueryData"] = 6] = "QueryData";
    _ComponentIndex[_ComponentIndex["Fragment"] = 7] = "Fragment";
  })(_ComponentIndex || (_ComponentIndex = {}));
  function _split(uri) {
    return lang_1.RegExpWrapper.firstMatch(_splitRe, uri);
  }
  function _removeDotSegments(path) {
    if (path == '/')
      return '/';
    var leadingSlash = path[0] == '/' ? '/' : '';
    var trailingSlash = path[path.length - 1] === '/' ? '/' : '';
    var segments = path.split('/');
    var out = [];
    var up = 0;
    for (var pos = 0; pos < segments.length; pos++) {
      var segment = segments[pos];
      switch (segment) {
        case '':
        case '.':
          break;
        case '..':
          if (out.length > 0) {
            out.pop();
          } else {
            up++;
          }
          break;
        default:
          out.push(segment);
      }
    }
    if (leadingSlash == '') {
      while (up-- > 0) {
        out.unshift('..');
      }
      if (out.length === 0)
        out.push('.');
    }
    return leadingSlash + out.join('/') + trailingSlash;
  }
  function _joinAndCanonicalizePath(parts) {
    var path = parts[_ComponentIndex.Path];
    path = lang_1.isBlank(path) ? '' : _removeDotSegments(path);
    parts[_ComponentIndex.Path] = path;
    return _buildFromEncodedParts(parts[_ComponentIndex.Scheme], parts[_ComponentIndex.UserInfo], parts[_ComponentIndex.Domain], parts[_ComponentIndex.Port], path, parts[_ComponentIndex.QueryData], parts[_ComponentIndex.Fragment]);
  }
  function _resolveUrl(base, url) {
    var parts = _split(encodeURI(url));
    var baseParts = _split(base);
    if (lang_1.isPresent(parts[_ComponentIndex.Scheme])) {
      return _joinAndCanonicalizePath(parts);
    } else {
      parts[_ComponentIndex.Scheme] = baseParts[_ComponentIndex.Scheme];
    }
    for (var i = _ComponentIndex.Scheme; i <= _ComponentIndex.Port; i++) {
      if (lang_1.isBlank(parts[i])) {
        parts[i] = baseParts[i];
      }
    }
    if (parts[_ComponentIndex.Path][0] == '/') {
      return _joinAndCanonicalizePath(parts);
    }
    var path = baseParts[_ComponentIndex.Path];
    if (lang_1.isBlank(path))
      path = '/';
    var index = path.lastIndexOf('/');
    path = path.substring(0, index + 1) + parts[_ComponentIndex.Path];
    parts[_ComponentIndex.Path] = path;
    return _joinAndCanonicalizePath(parts);
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/selector", ["angular2/src/facade/collection", "angular2/src/facade/lang", "angular2/src/facade/exceptions"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var collection_1 = require("angular2/src/facade/collection");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var _EMPTY_ATTR_VALUE = '';
  var _SELECTOR_REGEXP = lang_1.RegExpWrapper.create('(\\:not\\()|' + '([-\\w]+)|' + '(?:\\.([-\\w]+))|' + '(?:\\[([-\\w*]+)(?:=([^\\]]*))?\\])|' + '(\\))|' + '(\\s*,\\s*)');
  var CssSelector = (function() {
    function CssSelector() {
      this.element = null;
      this.classNames = [];
      this.attrs = [];
      this.notSelectors = [];
    }
    CssSelector.parse = function(selector) {
      var results = [];
      var _addResult = function(res, cssSel) {
        if (cssSel.notSelectors.length > 0 && lang_1.isBlank(cssSel.element) && collection_1.ListWrapper.isEmpty(cssSel.classNames) && collection_1.ListWrapper.isEmpty(cssSel.attrs)) {
          cssSel.element = "*";
        }
        res.push(cssSel);
      };
      var cssSelector = new CssSelector();
      var matcher = lang_1.RegExpWrapper.matcher(_SELECTOR_REGEXP, selector);
      var match;
      var current = cssSelector;
      var inNot = false;
      while (lang_1.isPresent(match = lang_1.RegExpMatcherWrapper.next(matcher))) {
        if (lang_1.isPresent(match[1])) {
          if (inNot) {
            throw new exceptions_1.BaseException('Nesting :not is not allowed in a selector');
          }
          inNot = true;
          current = new CssSelector();
          cssSelector.notSelectors.push(current);
        }
        if (lang_1.isPresent(match[2])) {
          current.setElement(match[2]);
        }
        if (lang_1.isPresent(match[3])) {
          current.addClassName(match[3]);
        }
        if (lang_1.isPresent(match[4])) {
          current.addAttribute(match[4], match[5]);
        }
        if (lang_1.isPresent(match[6])) {
          inNot = false;
          current = cssSelector;
        }
        if (lang_1.isPresent(match[7])) {
          if (inNot) {
            throw new exceptions_1.BaseException('Multiple selectors in :not are not supported');
          }
          _addResult(results, cssSelector);
          cssSelector = current = new CssSelector();
        }
      }
      _addResult(results, cssSelector);
      return results;
    };
    CssSelector.prototype.isElementSelector = function() {
      return lang_1.isPresent(this.element) && collection_1.ListWrapper.isEmpty(this.classNames) && collection_1.ListWrapper.isEmpty(this.attrs) && this.notSelectors.length === 0;
    };
    CssSelector.prototype.setElement = function(element) {
      if (element === void 0) {
        element = null;
      }
      this.element = element;
    };
    CssSelector.prototype.getMatchingElementTemplate = function() {
      var tagName = lang_1.isPresent(this.element) ? this.element : 'div';
      var classAttr = this.classNames.length > 0 ? " class=\"" + this.classNames.join(' ') + "\"" : '';
      var attrs = '';
      for (var i = 0; i < this.attrs.length; i += 2) {
        var attrName = this.attrs[i];
        var attrValue = this.attrs[i + 1] !== '' ? "=\"" + this.attrs[i + 1] + "\"" : '';
        attrs += " " + attrName + attrValue;
      }
      return "<" + tagName + classAttr + attrs + "></" + tagName + ">";
    };
    CssSelector.prototype.addAttribute = function(name, value) {
      if (value === void 0) {
        value = _EMPTY_ATTR_VALUE;
      }
      this.attrs.push(name);
      if (lang_1.isPresent(value)) {
        value = value.toLowerCase();
      } else {
        value = _EMPTY_ATTR_VALUE;
      }
      this.attrs.push(value);
    };
    CssSelector.prototype.addClassName = function(name) {
      this.classNames.push(name.toLowerCase());
    };
    CssSelector.prototype.toString = function() {
      var res = '';
      if (lang_1.isPresent(this.element)) {
        res += this.element;
      }
      if (lang_1.isPresent(this.classNames)) {
        for (var i = 0; i < this.classNames.length; i++) {
          res += '.' + this.classNames[i];
        }
      }
      if (lang_1.isPresent(this.attrs)) {
        for (var i = 0; i < this.attrs.length; ) {
          var attrName = this.attrs[i++];
          var attrValue = this.attrs[i++];
          res += '[' + attrName;
          if (attrValue.length > 0) {
            res += '=' + attrValue;
          }
          res += ']';
        }
      }
      this.notSelectors.forEach(function(notSelector) {
        return res += ":not(" + notSelector + ")";
      });
      return res;
    };
    return CssSelector;
  })();
  exports.CssSelector = CssSelector;
  var SelectorMatcher = (function() {
    function SelectorMatcher() {
      this._elementMap = new collection_1.Map();
      this._elementPartialMap = new collection_1.Map();
      this._classMap = new collection_1.Map();
      this._classPartialMap = new collection_1.Map();
      this._attrValueMap = new collection_1.Map();
      this._attrValuePartialMap = new collection_1.Map();
      this._listContexts = [];
    }
    SelectorMatcher.createNotMatcher = function(notSelectors) {
      var notMatcher = new SelectorMatcher();
      notMatcher.addSelectables(notSelectors, null);
      return notMatcher;
    };
    SelectorMatcher.prototype.addSelectables = function(cssSelectors, callbackCtxt) {
      var listContext = null;
      if (cssSelectors.length > 1) {
        listContext = new SelectorListContext(cssSelectors);
        this._listContexts.push(listContext);
      }
      for (var i = 0; i < cssSelectors.length; i++) {
        this._addSelectable(cssSelectors[i], callbackCtxt, listContext);
      }
    };
    SelectorMatcher.prototype._addSelectable = function(cssSelector, callbackCtxt, listContext) {
      var matcher = this;
      var element = cssSelector.element;
      var classNames = cssSelector.classNames;
      var attrs = cssSelector.attrs;
      var selectable = new SelectorContext(cssSelector, callbackCtxt, listContext);
      if (lang_1.isPresent(element)) {
        var isTerminal = attrs.length === 0 && classNames.length === 0;
        if (isTerminal) {
          this._addTerminal(matcher._elementMap, element, selectable);
        } else {
          matcher = this._addPartial(matcher._elementPartialMap, element);
        }
      }
      if (lang_1.isPresent(classNames)) {
        for (var index = 0; index < classNames.length; index++) {
          var isTerminal = attrs.length === 0 && index === classNames.length - 1;
          var className = classNames[index];
          if (isTerminal) {
            this._addTerminal(matcher._classMap, className, selectable);
          } else {
            matcher = this._addPartial(matcher._classPartialMap, className);
          }
        }
      }
      if (lang_1.isPresent(attrs)) {
        for (var index = 0; index < attrs.length; ) {
          var isTerminal = index === attrs.length - 2;
          var attrName = attrs[index++];
          var attrValue = attrs[index++];
          if (isTerminal) {
            var terminalMap = matcher._attrValueMap;
            var terminalValuesMap = terminalMap.get(attrName);
            if (lang_1.isBlank(terminalValuesMap)) {
              terminalValuesMap = new collection_1.Map();
              terminalMap.set(attrName, terminalValuesMap);
            }
            this._addTerminal(terminalValuesMap, attrValue, selectable);
          } else {
            var parttialMap = matcher._attrValuePartialMap;
            var partialValuesMap = parttialMap.get(attrName);
            if (lang_1.isBlank(partialValuesMap)) {
              partialValuesMap = new collection_1.Map();
              parttialMap.set(attrName, partialValuesMap);
            }
            matcher = this._addPartial(partialValuesMap, attrValue);
          }
        }
      }
    };
    SelectorMatcher.prototype._addTerminal = function(map, name, selectable) {
      var terminalList = map.get(name);
      if (lang_1.isBlank(terminalList)) {
        terminalList = [];
        map.set(name, terminalList);
      }
      terminalList.push(selectable);
    };
    SelectorMatcher.prototype._addPartial = function(map, name) {
      var matcher = map.get(name);
      if (lang_1.isBlank(matcher)) {
        matcher = new SelectorMatcher();
        map.set(name, matcher);
      }
      return matcher;
    };
    SelectorMatcher.prototype.match = function(cssSelector, matchedCallback) {
      var result = false;
      var element = cssSelector.element;
      var classNames = cssSelector.classNames;
      var attrs = cssSelector.attrs;
      for (var i = 0; i < this._listContexts.length; i++) {
        this._listContexts[i].alreadyMatched = false;
      }
      result = this._matchTerminal(this._elementMap, element, cssSelector, matchedCallback) || result;
      result = this._matchPartial(this._elementPartialMap, element, cssSelector, matchedCallback) || result;
      if (lang_1.isPresent(classNames)) {
        for (var index = 0; index < classNames.length; index++) {
          var className = classNames[index];
          result = this._matchTerminal(this._classMap, className, cssSelector, matchedCallback) || result;
          result = this._matchPartial(this._classPartialMap, className, cssSelector, matchedCallback) || result;
        }
      }
      if (lang_1.isPresent(attrs)) {
        for (var index = 0; index < attrs.length; ) {
          var attrName = attrs[index++];
          var attrValue = attrs[index++];
          var terminalValuesMap = this._attrValueMap.get(attrName);
          if (!lang_1.StringWrapper.equals(attrValue, _EMPTY_ATTR_VALUE)) {
            result = this._matchTerminal(terminalValuesMap, _EMPTY_ATTR_VALUE, cssSelector, matchedCallback) || result;
          }
          result = this._matchTerminal(terminalValuesMap, attrValue, cssSelector, matchedCallback) || result;
          var partialValuesMap = this._attrValuePartialMap.get(attrName);
          if (!lang_1.StringWrapper.equals(attrValue, _EMPTY_ATTR_VALUE)) {
            result = this._matchPartial(partialValuesMap, _EMPTY_ATTR_VALUE, cssSelector, matchedCallback) || result;
          }
          result = this._matchPartial(partialValuesMap, attrValue, cssSelector, matchedCallback) || result;
        }
      }
      return result;
    };
    SelectorMatcher.prototype._matchTerminal = function(map, name, cssSelector, matchedCallback) {
      if (lang_1.isBlank(map) || lang_1.isBlank(name)) {
        return false;
      }
      var selectables = map.get(name);
      var starSelectables = map.get("*");
      if (lang_1.isPresent(starSelectables)) {
        selectables = selectables.concat(starSelectables);
      }
      if (lang_1.isBlank(selectables)) {
        return false;
      }
      var selectable;
      var result = false;
      for (var index = 0; index < selectables.length; index++) {
        selectable = selectables[index];
        result = selectable.finalize(cssSelector, matchedCallback) || result;
      }
      return result;
    };
    SelectorMatcher.prototype._matchPartial = function(map, name, cssSelector, matchedCallback) {
      if (lang_1.isBlank(map) || lang_1.isBlank(name)) {
        return false;
      }
      var nestedSelector = map.get(name);
      if (lang_1.isBlank(nestedSelector)) {
        return false;
      }
      return nestedSelector.match(cssSelector, matchedCallback);
    };
    return SelectorMatcher;
  })();
  exports.SelectorMatcher = SelectorMatcher;
  var SelectorListContext = (function() {
    function SelectorListContext(selectors) {
      this.selectors = selectors;
      this.alreadyMatched = false;
    }
    return SelectorListContext;
  })();
  exports.SelectorListContext = SelectorListContext;
  var SelectorContext = (function() {
    function SelectorContext(selector, cbContext, listContext) {
      this.selector = selector;
      this.cbContext = cbContext;
      this.listContext = listContext;
      this.notSelectors = selector.notSelectors;
    }
    SelectorContext.prototype.finalize = function(cssSelector, callback) {
      var result = true;
      if (this.notSelectors.length > 0 && (lang_1.isBlank(this.listContext) || !this.listContext.alreadyMatched)) {
        var notMatcher = SelectorMatcher.createNotMatcher(this.notSelectors);
        result = !notMatcher.match(cssSelector, null);
      }
      if (result && lang_1.isPresent(callback) && (lang_1.isBlank(this.listContext) || !this.listContext.alreadyMatched)) {
        if (lang_1.isPresent(this.listContext)) {
          this.listContext.alreadyMatched = true;
        }
        callback(this.selector, this.cbContext);
      }
      return result;
    };
    return SelectorContext;
  })();
  exports.SelectorContext = SelectorContext;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/util", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var CAMEL_CASE_REGEXP = /([A-Z])/g;
  var DASH_CASE_REGEXP = /-([a-z])/g;
  var SINGLE_QUOTE_ESCAPE_STRING_RE = /'|\\|\n|\r|\$/g;
  var DOUBLE_QUOTE_ESCAPE_STRING_RE = /"|\\|\n|\r|\$/g;
  exports.MODULE_SUFFIX = lang_1.IS_DART ? '.dart' : '.js';
  exports.CONST_VAR = lang_1.IS_DART ? 'const' : 'var';
  function camelCaseToDashCase(input) {
    return lang_1.StringWrapper.replaceAllMapped(input, CAMEL_CASE_REGEXP, function(m) {
      return '-' + m[1].toLowerCase();
    });
  }
  exports.camelCaseToDashCase = camelCaseToDashCase;
  function dashCaseToCamelCase(input) {
    return lang_1.StringWrapper.replaceAllMapped(input, DASH_CASE_REGEXP, function(m) {
      return m[1].toUpperCase();
    });
  }
  exports.dashCaseToCamelCase = dashCaseToCamelCase;
  function escapeSingleQuoteString(input) {
    if (lang_1.isBlank(input)) {
      return null;
    }
    return "'" + escapeString(input, SINGLE_QUOTE_ESCAPE_STRING_RE) + "'";
  }
  exports.escapeSingleQuoteString = escapeSingleQuoteString;
  function escapeDoubleQuoteString(input) {
    if (lang_1.isBlank(input)) {
      return null;
    }
    return "\"" + escapeString(input, DOUBLE_QUOTE_ESCAPE_STRING_RE) + "\"";
  }
  exports.escapeDoubleQuoteString = escapeDoubleQuoteString;
  function escapeString(input, re) {
    return lang_1.StringWrapper.replaceAllMapped(input, re, function(match) {
      if (match[0] == '$') {
        return lang_1.IS_DART ? '\\$' : '$';
      } else if (match[0] == '\n') {
        return '\\n';
      } else if (match[0] == '\r') {
        return '\\r';
      } else {
        return "\\" + match[0];
      }
    });
  }
  function codeGenExportVariable(name) {
    if (lang_1.IS_DART) {
      return "const " + name + " = ";
    } else {
      return "var " + name + " = exports['" + name + "'] = ";
    }
  }
  exports.codeGenExportVariable = codeGenExportVariable;
  function codeGenConstConstructorCall(name) {
    if (lang_1.IS_DART) {
      return "const " + name;
    } else {
      return "new " + name;
    }
  }
  exports.codeGenConstConstructorCall = codeGenConstConstructorCall;
  function codeGenValueFn(params, value, fnName) {
    if (fnName === void 0) {
      fnName = '';
    }
    if (lang_1.IS_DART) {
      return codeGenFnHeader(params, fnName) + " => " + value;
    } else {
      return codeGenFnHeader(params, fnName) + " { return " + value + "; }";
    }
  }
  exports.codeGenValueFn = codeGenValueFn;
  function codeGenFnHeader(params, fnName) {
    if (fnName === void 0) {
      fnName = '';
    }
    if (lang_1.IS_DART) {
      return fnName + "(" + params.join(',') + ")";
    } else {
      return "function " + fnName + "(" + params.join(',') + ")";
    }
  }
  exports.codeGenFnHeader = codeGenFnHeader;
  function codeGenToString(expr) {
    if (lang_1.IS_DART) {
      return "'${" + expr + "}'";
    } else {
      return expr;
    }
  }
  exports.codeGenToString = codeGenToString;
  function splitAtColon(input, defaultValues) {
    var parts = lang_1.StringWrapper.split(input.trim(), /\s*:\s*/g);
    if (parts.length > 1) {
      return parts;
    } else {
      return defaultValues;
    }
  }
  exports.splitAtColon = splitAtColon;
  var Statement = (function() {
    function Statement(statement) {
      this.statement = statement;
    }
    return Statement;
  })();
  exports.Statement = Statement;
  var Expression = (function() {
    function Expression(expression, isArray) {
      if (isArray === void 0) {
        isArray = false;
      }
      this.expression = expression;
      this.isArray = isArray;
    }
    return Expression;
  })();
  exports.Expression = Expression;
  function escapeValue(value) {
    if (value instanceof Expression) {
      return value.expression;
    } else if (lang_1.isString(value)) {
      return escapeSingleQuoteString(value);
    } else if (lang_1.isBlank(value)) {
      return 'null';
    } else {
      return "" + value;
    }
  }
  exports.escapeValue = escapeValue;
  function codeGenArray(data) {
    return "[" + data.map(escapeValue).join(',') + "]";
  }
  exports.codeGenArray = codeGenArray;
  function codeGenFlatArray(values) {
    var result = '([';
    var isFirstArrayEntry = true;
    var concatFn = lang_1.IS_DART ? '.addAll' : 'concat';
    for (var i = 0; i < values.length; i++) {
      var value = values[i];
      if (value instanceof Expression && value.isArray) {
        result += "])." + concatFn + "(" + value.expression + ")." + concatFn + "([";
        isFirstArrayEntry = true;
      } else {
        if (!isFirstArrayEntry) {
          result += ',';
        }
        isFirstArrayEntry = false;
        result += escapeValue(value);
      }
    }
    result += '])';
    return result;
  }
  exports.codeGenFlatArray = codeGenFlatArray;
  function codeGenStringMap(keyValueArray) {
    return "{" + keyValueArray.map(codeGenKeyValue).join(',') + "}";
  }
  exports.codeGenStringMap = codeGenStringMap;
  function codeGenKeyValue(keyValue) {
    return escapeValue(keyValue[0]) + ":" + escapeValue(keyValue[1]);
  }
  function addAll(source, target) {
    for (var i = 0; i < source.length; i++) {
      target.push(source[i]);
    }
  }
  exports.addAll = addAll;
  function flattenArray(source, target) {
    if (lang_1.isPresent(source)) {
      for (var i = 0; i < source.length; i++) {
        var item = source[i];
        if (lang_1.isArray(item)) {
          flattenArray(item, target);
        } else {
          target.push(item);
        }
      }
    }
    return target;
  }
  exports.flattenArray = flattenArray;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/interfaces", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  (function(LifecycleHooks) {
    LifecycleHooks[LifecycleHooks["OnInit"] = 0] = "OnInit";
    LifecycleHooks[LifecycleHooks["OnDestroy"] = 1] = "OnDestroy";
    LifecycleHooks[LifecycleHooks["DoCheck"] = 2] = "DoCheck";
    LifecycleHooks[LifecycleHooks["OnChanges"] = 3] = "OnChanges";
    LifecycleHooks[LifecycleHooks["AfterContentInit"] = 4] = "AfterContentInit";
    LifecycleHooks[LifecycleHooks["AfterContentChecked"] = 5] = "AfterContentChecked";
    LifecycleHooks[LifecycleHooks["AfterViewInit"] = 6] = "AfterViewInit";
    LifecycleHooks[LifecycleHooks["AfterViewChecked"] = 7] = "AfterViewChecked";
  })(exports.LifecycleHooks || (exports.LifecycleHooks = {}));
  var LifecycleHooks = exports.LifecycleHooks;
  exports.LIFECYCLE_HOOKS_VALUES = [LifecycleHooks.OnInit, LifecycleHooks.OnDestroy, LifecycleHooks.DoCheck, LifecycleHooks.OnChanges, LifecycleHooks.AfterContentInit, LifecycleHooks.AfterContentChecked, LifecycleHooks.AfterViewInit, LifecycleHooks.AfterViewChecked];
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/template_ast", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var TextAst = (function() {
    function TextAst(value, ngContentIndex, sourceSpan) {
      this.value = value;
      this.ngContentIndex = ngContentIndex;
      this.sourceSpan = sourceSpan;
    }
    TextAst.prototype.visit = function(visitor, context) {
      return visitor.visitText(this, context);
    };
    return TextAst;
  })();
  exports.TextAst = TextAst;
  var BoundTextAst = (function() {
    function BoundTextAst(value, ngContentIndex, sourceSpan) {
      this.value = value;
      this.ngContentIndex = ngContentIndex;
      this.sourceSpan = sourceSpan;
    }
    BoundTextAst.prototype.visit = function(visitor, context) {
      return visitor.visitBoundText(this, context);
    };
    return BoundTextAst;
  })();
  exports.BoundTextAst = BoundTextAst;
  var AttrAst = (function() {
    function AttrAst(name, value, sourceSpan) {
      this.name = name;
      this.value = value;
      this.sourceSpan = sourceSpan;
    }
    AttrAst.prototype.visit = function(visitor, context) {
      return visitor.visitAttr(this, context);
    };
    return AttrAst;
  })();
  exports.AttrAst = AttrAst;
  var BoundElementPropertyAst = (function() {
    function BoundElementPropertyAst(name, type, value, unit, sourceSpan) {
      this.name = name;
      this.type = type;
      this.value = value;
      this.unit = unit;
      this.sourceSpan = sourceSpan;
    }
    BoundElementPropertyAst.prototype.visit = function(visitor, context) {
      return visitor.visitElementProperty(this, context);
    };
    return BoundElementPropertyAst;
  })();
  exports.BoundElementPropertyAst = BoundElementPropertyAst;
  var BoundEventAst = (function() {
    function BoundEventAst(name, target, handler, sourceSpan) {
      this.name = name;
      this.target = target;
      this.handler = handler;
      this.sourceSpan = sourceSpan;
    }
    BoundEventAst.prototype.visit = function(visitor, context) {
      return visitor.visitEvent(this, context);
    };
    Object.defineProperty(BoundEventAst.prototype, "fullName", {
      get: function() {
        if (lang_1.isPresent(this.target)) {
          return this.target + ":" + this.name;
        } else {
          return this.name;
        }
      },
      enumerable: true,
      configurable: true
    });
    return BoundEventAst;
  })();
  exports.BoundEventAst = BoundEventAst;
  var VariableAst = (function() {
    function VariableAst(name, value, sourceSpan) {
      this.name = name;
      this.value = value;
      this.sourceSpan = sourceSpan;
    }
    VariableAst.prototype.visit = function(visitor, context) {
      return visitor.visitVariable(this, context);
    };
    return VariableAst;
  })();
  exports.VariableAst = VariableAst;
  var ElementAst = (function() {
    function ElementAst(name, attrs, inputs, outputs, exportAsVars, directives, children, ngContentIndex, sourceSpan) {
      this.name = name;
      this.attrs = attrs;
      this.inputs = inputs;
      this.outputs = outputs;
      this.exportAsVars = exportAsVars;
      this.directives = directives;
      this.children = children;
      this.ngContentIndex = ngContentIndex;
      this.sourceSpan = sourceSpan;
    }
    ElementAst.prototype.visit = function(visitor, context) {
      return visitor.visitElement(this, context);
    };
    ElementAst.prototype.isBound = function() {
      return (this.inputs.length > 0 || this.outputs.length > 0 || this.exportAsVars.length > 0 || this.directives.length > 0);
    };
    ElementAst.prototype.getComponent = function() {
      return this.directives.length > 0 && this.directives[0].directive.isComponent ? this.directives[0].directive : null;
    };
    return ElementAst;
  })();
  exports.ElementAst = ElementAst;
  var EmbeddedTemplateAst = (function() {
    function EmbeddedTemplateAst(attrs, outputs, vars, directives, children, ngContentIndex, sourceSpan) {
      this.attrs = attrs;
      this.outputs = outputs;
      this.vars = vars;
      this.directives = directives;
      this.children = children;
      this.ngContentIndex = ngContentIndex;
      this.sourceSpan = sourceSpan;
    }
    EmbeddedTemplateAst.prototype.visit = function(visitor, context) {
      return visitor.visitEmbeddedTemplate(this, context);
    };
    return EmbeddedTemplateAst;
  })();
  exports.EmbeddedTemplateAst = EmbeddedTemplateAst;
  var BoundDirectivePropertyAst = (function() {
    function BoundDirectivePropertyAst(directiveName, templateName, value, sourceSpan) {
      this.directiveName = directiveName;
      this.templateName = templateName;
      this.value = value;
      this.sourceSpan = sourceSpan;
    }
    BoundDirectivePropertyAst.prototype.visit = function(visitor, context) {
      return visitor.visitDirectiveProperty(this, context);
    };
    return BoundDirectivePropertyAst;
  })();
  exports.BoundDirectivePropertyAst = BoundDirectivePropertyAst;
  var DirectiveAst = (function() {
    function DirectiveAst(directive, inputs, hostProperties, hostEvents, exportAsVars, sourceSpan) {
      this.directive = directive;
      this.inputs = inputs;
      this.hostProperties = hostProperties;
      this.hostEvents = hostEvents;
      this.exportAsVars = exportAsVars;
      this.sourceSpan = sourceSpan;
    }
    DirectiveAst.prototype.visit = function(visitor, context) {
      return visitor.visitDirective(this, context);
    };
    return DirectiveAst;
  })();
  exports.DirectiveAst = DirectiveAst;
  var NgContentAst = (function() {
    function NgContentAst(index, ngContentIndex, sourceSpan) {
      this.index = index;
      this.ngContentIndex = ngContentIndex;
      this.sourceSpan = sourceSpan;
    }
    NgContentAst.prototype.visit = function(visitor, context) {
      return visitor.visitNgContent(this, context);
    };
    return NgContentAst;
  })();
  exports.NgContentAst = NgContentAst;
  (function(PropertyBindingType) {
    PropertyBindingType[PropertyBindingType["Property"] = 0] = "Property";
    PropertyBindingType[PropertyBindingType["Attribute"] = 1] = "Attribute";
    PropertyBindingType[PropertyBindingType["Class"] = 2] = "Class";
    PropertyBindingType[PropertyBindingType["Style"] = 3] = "Style";
  })(exports.PropertyBindingType || (exports.PropertyBindingType = {}));
  var PropertyBindingType = exports.PropertyBindingType;
  function templateVisitAll(visitor, asts, context) {
    if (context === void 0) {
      context = null;
    }
    var result = [];
    asts.forEach(function(ast) {
      var astResult = ast.visit(visitor, context);
      if (lang_1.isPresent(astResult)) {
        result.push(astResult);
      }
    });
    return result;
  }
  exports.templateVisitAll = templateVisitAll;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/source_module", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var MODULE_REGEXP = /#MODULE\[([^\]]*)\]/g;
  function moduleRef(moduleUrl) {
    return "#MODULE[" + moduleUrl + "]";
  }
  exports.moduleRef = moduleRef;
  var SourceModule = (function() {
    function SourceModule(moduleUrl, sourceWithModuleRefs) {
      this.moduleUrl = moduleUrl;
      this.sourceWithModuleRefs = sourceWithModuleRefs;
    }
    SourceModule.getSourceWithoutImports = function(sourceWithModuleRefs) {
      return lang_1.StringWrapper.replaceAllMapped(sourceWithModuleRefs, MODULE_REGEXP, function(match) {
        return '';
      });
    };
    SourceModule.prototype.getSourceWithImports = function() {
      var _this = this;
      var moduleAliases = {};
      var imports = [];
      var newSource = lang_1.StringWrapper.replaceAllMapped(this.sourceWithModuleRefs, MODULE_REGEXP, function(match) {
        var moduleUrl = match[1];
        var alias = moduleAliases[moduleUrl];
        if (lang_1.isBlank(alias)) {
          if (moduleUrl == _this.moduleUrl) {
            alias = '';
          } else {
            alias = "import" + imports.length;
            imports.push([moduleUrl, alias]);
          }
          moduleAliases[moduleUrl] = alias;
        }
        return alias.length > 0 ? alias + "." : '';
      });
      return new SourceWithImports(newSource, imports);
    };
    return SourceModule;
  })();
  exports.SourceModule = SourceModule;
  var SourceExpression = (function() {
    function SourceExpression(declarations, expression) {
      this.declarations = declarations;
      this.expression = expression;
    }
    return SourceExpression;
  })();
  exports.SourceExpression = SourceExpression;
  var SourceExpressions = (function() {
    function SourceExpressions(declarations, expressions) {
      this.declarations = declarations;
      this.expressions = expressions;
    }
    return SourceExpressions;
  })();
  exports.SourceExpressions = SourceExpressions;
  var SourceWithImports = (function() {
    function SourceWithImports(source, imports) {
      this.source = source;
      this.imports = imports;
    }
    return SourceWithImports;
  })();
  exports.SourceWithImports = SourceWithImports;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/change_definition_factory", ["angular2/src/facade/collection", "angular2/src/facade/lang", "angular2/src/core/reflection/reflection", "angular2/src/core/change_detection/change_detection", "angular2/src/compiler/template_ast", "angular2/src/core/linker/interfaces"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var collection_1 = require("angular2/src/facade/collection");
  var lang_1 = require("angular2/src/facade/lang");
  var reflection_1 = require("angular2/src/core/reflection/reflection");
  var change_detection_1 = require("angular2/src/core/change_detection/change_detection");
  var template_ast_1 = require("angular2/src/compiler/template_ast");
  var interfaces_1 = require("angular2/src/core/linker/interfaces");
  function createChangeDetectorDefinitions(componentType, componentStrategy, genConfig, parsedTemplate) {
    var pvVisitors = [];
    var visitor = new ProtoViewVisitor(null, pvVisitors, componentStrategy);
    template_ast_1.templateVisitAll(visitor, parsedTemplate);
    return createChangeDefinitions(pvVisitors, componentType, genConfig);
  }
  exports.createChangeDetectorDefinitions = createChangeDetectorDefinitions;
  var ProtoViewVisitor = (function() {
    function ProtoViewVisitor(parent, allVisitors, strategy) {
      this.parent = parent;
      this.allVisitors = allVisitors;
      this.strategy = strategy;
      this.nodeCount = 0;
      this.boundElementCount = 0;
      this.variableNames = [];
      this.bindingRecords = [];
      this.eventRecords = [];
      this.directiveRecords = [];
      this.viewIndex = allVisitors.length;
      allVisitors.push(this);
    }
    ProtoViewVisitor.prototype.visitEmbeddedTemplate = function(ast, context) {
      this.nodeCount++;
      this.boundElementCount++;
      template_ast_1.templateVisitAll(this, ast.outputs);
      for (var i = 0; i < ast.directives.length; i++) {
        ast.directives[i].visit(this, i);
      }
      var childVisitor = new ProtoViewVisitor(this, this.allVisitors, change_detection_1.ChangeDetectionStrategy.Default);
      template_ast_1.templateVisitAll(childVisitor, ast.vars);
      template_ast_1.templateVisitAll(childVisitor, ast.children);
      return null;
    };
    ProtoViewVisitor.prototype.visitElement = function(ast, context) {
      this.nodeCount++;
      if (ast.isBound()) {
        this.boundElementCount++;
      }
      template_ast_1.templateVisitAll(this, ast.inputs, null);
      template_ast_1.templateVisitAll(this, ast.outputs);
      template_ast_1.templateVisitAll(this, ast.exportAsVars);
      for (var i = 0; i < ast.directives.length; i++) {
        ast.directives[i].visit(this, i);
      }
      template_ast_1.templateVisitAll(this, ast.children);
      return null;
    };
    ProtoViewVisitor.prototype.visitNgContent = function(ast, context) {
      return null;
    };
    ProtoViewVisitor.prototype.visitVariable = function(ast, context) {
      this.variableNames.push(ast.name);
      return null;
    };
    ProtoViewVisitor.prototype.visitEvent = function(ast, directiveRecord) {
      var bindingRecord = lang_1.isPresent(directiveRecord) ? change_detection_1.BindingRecord.createForHostEvent(ast.handler, ast.fullName, directiveRecord) : change_detection_1.BindingRecord.createForEvent(ast.handler, ast.fullName, this.boundElementCount - 1);
      this.eventRecords.push(bindingRecord);
      return null;
    };
    ProtoViewVisitor.prototype.visitElementProperty = function(ast, directiveRecord) {
      var boundElementIndex = this.boundElementCount - 1;
      var dirIndex = lang_1.isPresent(directiveRecord) ? directiveRecord.directiveIndex : null;
      var bindingRecord;
      if (ast.type === template_ast_1.PropertyBindingType.Property) {
        bindingRecord = lang_1.isPresent(dirIndex) ? change_detection_1.BindingRecord.createForHostProperty(dirIndex, ast.value, ast.name) : change_detection_1.BindingRecord.createForElementProperty(ast.value, boundElementIndex, ast.name);
      } else if (ast.type === template_ast_1.PropertyBindingType.Attribute) {
        bindingRecord = lang_1.isPresent(dirIndex) ? change_detection_1.BindingRecord.createForHostAttribute(dirIndex, ast.value, ast.name) : change_detection_1.BindingRecord.createForElementAttribute(ast.value, boundElementIndex, ast.name);
      } else if (ast.type === template_ast_1.PropertyBindingType.Class) {
        bindingRecord = lang_1.isPresent(dirIndex) ? change_detection_1.BindingRecord.createForHostClass(dirIndex, ast.value, ast.name) : change_detection_1.BindingRecord.createForElementClass(ast.value, boundElementIndex, ast.name);
      } else if (ast.type === template_ast_1.PropertyBindingType.Style) {
        bindingRecord = lang_1.isPresent(dirIndex) ? change_detection_1.BindingRecord.createForHostStyle(dirIndex, ast.value, ast.name, ast.unit) : change_detection_1.BindingRecord.createForElementStyle(ast.value, boundElementIndex, ast.name, ast.unit);
      }
      this.bindingRecords.push(bindingRecord);
      return null;
    };
    ProtoViewVisitor.prototype.visitAttr = function(ast, context) {
      return null;
    };
    ProtoViewVisitor.prototype.visitBoundText = function(ast, context) {
      var nodeIndex = this.nodeCount++;
      this.bindingRecords.push(change_detection_1.BindingRecord.createForTextNode(ast.value, nodeIndex));
      return null;
    };
    ProtoViewVisitor.prototype.visitText = function(ast, context) {
      this.nodeCount++;
      return null;
    };
    ProtoViewVisitor.prototype.visitDirective = function(ast, directiveIndexAsNumber) {
      var directiveIndex = new change_detection_1.DirectiveIndex(this.boundElementCount - 1, directiveIndexAsNumber);
      var directiveMetadata = ast.directive;
      var outputsArray = [];
      collection_1.StringMapWrapper.forEach(ast.directive.outputs, function(eventName, dirProperty) {
        return outputsArray.push([dirProperty, eventName]);
      });
      var directiveRecord = new change_detection_1.DirectiveRecord({
        directiveIndex: directiveIndex,
        callAfterContentInit: directiveMetadata.lifecycleHooks.indexOf(interfaces_1.LifecycleHooks.AfterContentInit) !== -1,
        callAfterContentChecked: directiveMetadata.lifecycleHooks.indexOf(interfaces_1.LifecycleHooks.AfterContentChecked) !== -1,
        callAfterViewInit: directiveMetadata.lifecycleHooks.indexOf(interfaces_1.LifecycleHooks.AfterViewInit) !== -1,
        callAfterViewChecked: directiveMetadata.lifecycleHooks.indexOf(interfaces_1.LifecycleHooks.AfterViewChecked) !== -1,
        callOnChanges: directiveMetadata.lifecycleHooks.indexOf(interfaces_1.LifecycleHooks.OnChanges) !== -1,
        callDoCheck: directiveMetadata.lifecycleHooks.indexOf(interfaces_1.LifecycleHooks.DoCheck) !== -1,
        callOnInit: directiveMetadata.lifecycleHooks.indexOf(interfaces_1.LifecycleHooks.OnInit) !== -1,
        callOnDestroy: directiveMetadata.lifecycleHooks.indexOf(interfaces_1.LifecycleHooks.OnDestroy) !== -1,
        changeDetection: directiveMetadata.changeDetection,
        outputs: outputsArray
      });
      this.directiveRecords.push(directiveRecord);
      template_ast_1.templateVisitAll(this, ast.inputs, directiveRecord);
      var bindingRecords = this.bindingRecords;
      if (directiveRecord.callOnChanges) {
        bindingRecords.push(change_detection_1.BindingRecord.createDirectiveOnChanges(directiveRecord));
      }
      if (directiveRecord.callOnInit) {
        bindingRecords.push(change_detection_1.BindingRecord.createDirectiveOnInit(directiveRecord));
      }
      if (directiveRecord.callDoCheck) {
        bindingRecords.push(change_detection_1.BindingRecord.createDirectiveDoCheck(directiveRecord));
      }
      template_ast_1.templateVisitAll(this, ast.hostProperties, directiveRecord);
      template_ast_1.templateVisitAll(this, ast.hostEvents, directiveRecord);
      template_ast_1.templateVisitAll(this, ast.exportAsVars);
      return null;
    };
    ProtoViewVisitor.prototype.visitDirectiveProperty = function(ast, directiveRecord) {
      var setter = reflection_1.reflector.setter(ast.directiveName);
      this.bindingRecords.push(change_detection_1.BindingRecord.createForDirective(ast.value, ast.directiveName, setter, directiveRecord));
      return null;
    };
    return ProtoViewVisitor;
  })();
  function createChangeDefinitions(pvVisitors, componentType, genConfig) {
    var pvVariableNames = _collectNestedProtoViewsVariableNames(pvVisitors);
    return pvVisitors.map(function(pvVisitor) {
      var id = componentType.name + "_" + pvVisitor.viewIndex;
      return new change_detection_1.ChangeDetectorDefinition(id, pvVisitor.strategy, pvVariableNames[pvVisitor.viewIndex], pvVisitor.bindingRecords, pvVisitor.eventRecords, pvVisitor.directiveRecords, genConfig);
    });
  }
  function _collectNestedProtoViewsVariableNames(pvVisitors) {
    var nestedPvVariableNames = collection_1.ListWrapper.createFixedSize(pvVisitors.length);
    pvVisitors.forEach(function(pv) {
      var parentVariableNames = lang_1.isPresent(pv.parent) ? nestedPvVariableNames[pv.parent.viewIndex] : [];
      nestedPvVariableNames[pv.viewIndex] = parentVariableNames.concat(pv.variableNames);
    });
    return nestedPvVariableNames;
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/transform/template_compiler/change_detector_codegen", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var Codegen = (function() {
    function Codegen(moduleAlias) {}
    Codegen.prototype.generate = function(typeName, changeDetectorTypeName, def) {
      throw "Not implemented in JS";
    };
    Codegen.prototype.toString = function() {
      throw "Not implemented in JS";
    };
    return Codegen;
  })();
  exports.Codegen = Codegen;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/shadow_css", ["angular2/src/facade/collection", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var collection_1 = require("angular2/src/facade/collection");
  var lang_1 = require("angular2/src/facade/lang");
  var ShadowCss = (function() {
    function ShadowCss() {
      this.strictStyling = true;
    }
    ShadowCss.prototype.shimCssText = function(cssText, selector, hostSelector) {
      if (hostSelector === void 0) {
        hostSelector = '';
      }
      cssText = stripComments(cssText);
      cssText = this._insertDirectives(cssText);
      return this._scopeCssText(cssText, selector, hostSelector);
    };
    ShadowCss.prototype._insertDirectives = function(cssText) {
      cssText = this._insertPolyfillDirectivesInCssText(cssText);
      return this._insertPolyfillRulesInCssText(cssText);
    };
    ShadowCss.prototype._insertPolyfillDirectivesInCssText = function(cssText) {
      return lang_1.StringWrapper.replaceAllMapped(cssText, _cssContentNextSelectorRe, function(m) {
        return m[1] + '{';
      });
    };
    ShadowCss.prototype._insertPolyfillRulesInCssText = function(cssText) {
      return lang_1.StringWrapper.replaceAllMapped(cssText, _cssContentRuleRe, function(m) {
        var rule = m[0];
        rule = lang_1.StringWrapper.replace(rule, m[1], '');
        rule = lang_1.StringWrapper.replace(rule, m[2], '');
        return m[3] + rule;
      });
    };
    ShadowCss.prototype._scopeCssText = function(cssText, scopeSelector, hostSelector) {
      var unscoped = this._extractUnscopedRulesFromCssText(cssText);
      cssText = this._insertPolyfillHostInCssText(cssText);
      cssText = this._convertColonHost(cssText);
      cssText = this._convertColonHostContext(cssText);
      cssText = this._convertShadowDOMSelectors(cssText);
      if (lang_1.isPresent(scopeSelector)) {
        cssText = this._scopeSelectors(cssText, scopeSelector, hostSelector);
      }
      cssText = cssText + '\n' + unscoped;
      return cssText.trim();
    };
    ShadowCss.prototype._extractUnscopedRulesFromCssText = function(cssText) {
      var r = '',
          m;
      var matcher = lang_1.RegExpWrapper.matcher(_cssContentUnscopedRuleRe, cssText);
      while (lang_1.isPresent(m = lang_1.RegExpMatcherWrapper.next(matcher))) {
        var rule = m[0];
        rule = lang_1.StringWrapper.replace(rule, m[2], '');
        rule = lang_1.StringWrapper.replace(rule, m[1], m[3]);
        r += rule + '\n\n';
      }
      return r;
    };
    ShadowCss.prototype._convertColonHost = function(cssText) {
      return this._convertColonRule(cssText, _cssColonHostRe, this._colonHostPartReplacer);
    };
    ShadowCss.prototype._convertColonHostContext = function(cssText) {
      return this._convertColonRule(cssText, _cssColonHostContextRe, this._colonHostContextPartReplacer);
    };
    ShadowCss.prototype._convertColonRule = function(cssText, regExp, partReplacer) {
      return lang_1.StringWrapper.replaceAllMapped(cssText, regExp, function(m) {
        if (lang_1.isPresent(m[2])) {
          var parts = m[2].split(','),
              r = [];
          for (var i = 0; i < parts.length; i++) {
            var p = parts[i];
            if (lang_1.isBlank(p))
              break;
            p = p.trim();
            r.push(partReplacer(_polyfillHostNoCombinator, p, m[3]));
          }
          return r.join(',');
        } else {
          return _polyfillHostNoCombinator + m[3];
        }
      });
    };
    ShadowCss.prototype._colonHostContextPartReplacer = function(host, part, suffix) {
      if (lang_1.StringWrapper.contains(part, _polyfillHost)) {
        return this._colonHostPartReplacer(host, part, suffix);
      } else {
        return host + part + suffix + ', ' + part + ' ' + host + suffix;
      }
    };
    ShadowCss.prototype._colonHostPartReplacer = function(host, part, suffix) {
      return host + lang_1.StringWrapper.replace(part, _polyfillHost, '') + suffix;
    };
    ShadowCss.prototype._convertShadowDOMSelectors = function(cssText) {
      for (var i = 0; i < _shadowDOMSelectorsRe.length; i++) {
        cssText = lang_1.StringWrapper.replaceAll(cssText, _shadowDOMSelectorsRe[i], ' ');
      }
      return cssText;
    };
    ShadowCss.prototype._scopeSelectors = function(cssText, scopeSelector, hostSelector) {
      var _this = this;
      return processRules(cssText, function(rule) {
        var selector = rule.selector;
        var content = rule.content;
        if (rule.selector[0] != '@' || rule.selector.startsWith('@page')) {
          selector = _this._scopeSelector(rule.selector, scopeSelector, hostSelector, _this.strictStyling);
        } else if (rule.selector.startsWith('@media')) {
          content = _this._scopeSelectors(rule.content, scopeSelector, hostSelector);
        }
        return new CssRule(selector, content);
      });
    };
    ShadowCss.prototype._scopeSelector = function(selector, scopeSelector, hostSelector, strict) {
      var r = [],
          parts = selector.split(',');
      for (var i = 0; i < parts.length; i++) {
        var p = parts[i];
        p = p.trim();
        if (this._selectorNeedsScoping(p, scopeSelector)) {
          p = strict && !lang_1.StringWrapper.contains(p, _polyfillHostNoCombinator) ? this._applyStrictSelectorScope(p, scopeSelector) : this._applySelectorScope(p, scopeSelector, hostSelector);
        }
        r.push(p);
      }
      return r.join(', ');
    };
    ShadowCss.prototype._selectorNeedsScoping = function(selector, scopeSelector) {
      var re = this._makeScopeMatcher(scopeSelector);
      return !lang_1.isPresent(lang_1.RegExpWrapper.firstMatch(re, selector));
    };
    ShadowCss.prototype._makeScopeMatcher = function(scopeSelector) {
      var lre = /\[/g;
      var rre = /\]/g;
      scopeSelector = lang_1.StringWrapper.replaceAll(scopeSelector, lre, '\\[');
      scopeSelector = lang_1.StringWrapper.replaceAll(scopeSelector, rre, '\\]');
      return lang_1.RegExpWrapper.create('^(' + scopeSelector + ')' + _selectorReSuffix, 'm');
    };
    ShadowCss.prototype._applySelectorScope = function(selector, scopeSelector, hostSelector) {
      return this._applySimpleSelectorScope(selector, scopeSelector, hostSelector);
    };
    ShadowCss.prototype._applySimpleSelectorScope = function(selector, scopeSelector, hostSelector) {
      if (lang_1.isPresent(lang_1.RegExpWrapper.firstMatch(_polyfillHostRe, selector))) {
        var replaceBy = this.strictStyling ? "[" + hostSelector + "]" : scopeSelector;
        selector = lang_1.StringWrapper.replace(selector, _polyfillHostNoCombinator, replaceBy);
        return lang_1.StringWrapper.replaceAll(selector, _polyfillHostRe, replaceBy + ' ');
      } else {
        return scopeSelector + ' ' + selector;
      }
    };
    ShadowCss.prototype._applyStrictSelectorScope = function(selector, scopeSelector) {
      var isRe = /\[is=([^\]]*)\]/g;
      scopeSelector = lang_1.StringWrapper.replaceAllMapped(scopeSelector, isRe, function(m) {
        return m[1];
      });
      var splits = [' ', '>', '+', '~'],
          scoped = selector,
          attrName = '[' + scopeSelector + ']';
      for (var i = 0; i < splits.length; i++) {
        var sep = splits[i];
        var parts = scoped.split(sep);
        scoped = parts.map(function(p) {
          var t = lang_1.StringWrapper.replaceAll(p.trim(), _polyfillHostRe, '');
          if (t.length > 0 && !collection_1.ListWrapper.contains(splits, t) && !lang_1.StringWrapper.contains(t, attrName)) {
            var re = /([^:]*)(:*)(.*)/g;
            var m = lang_1.RegExpWrapper.firstMatch(re, t);
            if (lang_1.isPresent(m)) {
              p = m[1] + attrName + m[2] + m[3];
            }
          }
          return p;
        }).join(sep);
      }
      return scoped;
    };
    ShadowCss.prototype._insertPolyfillHostInCssText = function(selector) {
      selector = lang_1.StringWrapper.replaceAll(selector, _colonHostContextRe, _polyfillHostContext);
      selector = lang_1.StringWrapper.replaceAll(selector, _colonHostRe, _polyfillHost);
      return selector;
    };
    return ShadowCss;
  })();
  exports.ShadowCss = ShadowCss;
  var _cssContentNextSelectorRe = /polyfill-next-selector[^}]*content:[\s]*?['"](.*?)['"][;\s]*}([^{]*?){/gim;
  var _cssContentRuleRe = /(polyfill-rule)[^}]*(content:[\s]*['"](.*?)['"])[;\s]*[^}]*}/gim;
  var _cssContentUnscopedRuleRe = /(polyfill-unscoped-rule)[^}]*(content:[\s]*['"](.*?)['"])[;\s]*[^}]*}/gim;
  var _polyfillHost = '-shadowcsshost';
  var _polyfillHostContext = '-shadowcsscontext';
  var _parenSuffix = ')(?:\\((' + '(?:\\([^)(]*\\)|[^)(]*)+?' + ')\\))?([^,{]*)';
  var _cssColonHostRe = lang_1.RegExpWrapper.create('(' + _polyfillHost + _parenSuffix, 'im');
  var _cssColonHostContextRe = lang_1.RegExpWrapper.create('(' + _polyfillHostContext + _parenSuffix, 'im');
  var _polyfillHostNoCombinator = _polyfillHost + '-no-combinator';
  var _shadowDOMSelectorsRe = [/>>>/g, /::shadow/g, /::content/g, /\/deep\//g, /\/shadow-deep\//g, /\/shadow\//g];
  var _selectorReSuffix = '([>\\s~+\[.,{:][\\s\\S]*)?$';
  var _polyfillHostRe = lang_1.RegExpWrapper.create(_polyfillHost, 'im');
  var _colonHostRe = /:host/gim;
  var _colonHostContextRe = /:host-context/gim;
  var _commentRe = /\/\*[\s\S]*?\*\//g;
  function stripComments(input) {
    return lang_1.StringWrapper.replaceAllMapped(input, _commentRe, function(_) {
      return '';
    });
  }
  var _ruleRe = /(\s*)([^;\{\}]+?)(\s*)((?:{%BLOCK%}?\s*;?)|(?:\s*;))/g;
  var _curlyRe = /([{}])/g;
  var OPEN_CURLY = '{';
  var CLOSE_CURLY = '}';
  var BLOCK_PLACEHOLDER = '%BLOCK%';
  var CssRule = (function() {
    function CssRule(selector, content) {
      this.selector = selector;
      this.content = content;
    }
    return CssRule;
  })();
  exports.CssRule = CssRule;
  function processRules(input, ruleCallback) {
    var inputWithEscapedBlocks = escapeBlocks(input);
    var nextBlockIndex = 0;
    return lang_1.StringWrapper.replaceAllMapped(inputWithEscapedBlocks.escapedString, _ruleRe, function(m) {
      var selector = m[2];
      var content = '';
      var suffix = m[4];
      var contentPrefix = '';
      if (lang_1.isPresent(m[4]) && m[4].startsWith('{' + BLOCK_PLACEHOLDER)) {
        content = inputWithEscapedBlocks.blocks[nextBlockIndex++];
        suffix = m[4].substring(BLOCK_PLACEHOLDER.length + 1);
        contentPrefix = '{';
      }
      var rule = ruleCallback(new CssRule(selector, content));
      return "" + m[1] + rule.selector + m[3] + contentPrefix + rule.content + suffix;
    });
  }
  exports.processRules = processRules;
  var StringWithEscapedBlocks = (function() {
    function StringWithEscapedBlocks(escapedString, blocks) {
      this.escapedString = escapedString;
      this.blocks = blocks;
    }
    return StringWithEscapedBlocks;
  })();
  function escapeBlocks(input) {
    var inputParts = lang_1.StringWrapper.split(input, _curlyRe);
    var resultParts = [];
    var escapedBlocks = [];
    var bracketCount = 0;
    var currentBlockParts = [];
    for (var partIndex = 0; partIndex < inputParts.length; partIndex++) {
      var part = inputParts[partIndex];
      if (part == CLOSE_CURLY) {
        bracketCount--;
      }
      if (bracketCount > 0) {
        currentBlockParts.push(part);
      } else {
        if (currentBlockParts.length > 0) {
          escapedBlocks.push(currentBlockParts.join(''));
          resultParts.push(BLOCK_PLACEHOLDER);
          currentBlockParts = [];
        }
        resultParts.push(part);
      }
      if (part == OPEN_CURLY) {
        bracketCount++;
      }
    }
    if (currentBlockParts.length > 0) {
      escapedBlocks.push(currentBlockParts.join(''));
      resultParts.push(BLOCK_PLACEHOLDER);
    }
    return new StringWithEscapedBlocks(resultParts.join(''), escapedBlocks);
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/style_url_resolver", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var StyleWithImports = (function() {
    function StyleWithImports(style, styleUrls) {
      this.style = style;
      this.styleUrls = styleUrls;
    }
    return StyleWithImports;
  })();
  exports.StyleWithImports = StyleWithImports;
  function isStyleUrlResolvable(url) {
    if (lang_1.isBlank(url) || url.length === 0 || url[0] == '/')
      return false;
    var schemeMatch = lang_1.RegExpWrapper.firstMatch(_urlWithSchemaRe, url);
    return lang_1.isBlank(schemeMatch) || schemeMatch[1] == 'package' || schemeMatch[1] == 'asset';
  }
  exports.isStyleUrlResolvable = isStyleUrlResolvable;
  function extractStyleUrls(resolver, baseUrl, cssText) {
    var foundUrls = [];
    var modifiedCssText = lang_1.StringWrapper.replaceAllMapped(cssText, _cssImportRe, function(m) {
      var url = lang_1.isPresent(m[1]) ? m[1] : m[2];
      if (!isStyleUrlResolvable(url)) {
        return m[0];
      }
      foundUrls.push(resolver.resolve(baseUrl, url));
      return '';
    });
    return new StyleWithImports(modifiedCssText, foundUrls);
  }
  exports.extractStyleUrls = extractStyleUrls;
  var _cssImportRe = /@import\s+(?:url\()?\s*(?:(?:['"]([^'"]*))|([^;\)\s]*))[^;]*;?/g;
  var _urlWithSchemaRe = /^([a-zA-Z\-\+\.]+):/g;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/proto_view_compiler", ["angular2/src/facade/lang", "angular2/src/facade/collection", "angular2/src/compiler/template_ast", "angular2/src/compiler/source_module", "angular2/src/core/linker/view", "angular2/src/core/linker/view_type", "angular2/src/core/linker/element", "angular2/src/compiler/util", "angular2/src/core/di"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var collection_1 = require("angular2/src/facade/collection");
  var template_ast_1 = require("angular2/src/compiler/template_ast");
  var source_module_1 = require("angular2/src/compiler/source_module");
  var view_1 = require("angular2/src/core/linker/view");
  var view_type_1 = require("angular2/src/core/linker/view_type");
  var element_1 = require("angular2/src/core/linker/element");
  var util_1 = require("angular2/src/compiler/util");
  var di_1 = require("angular2/src/core/di");
  exports.PROTO_VIEW_JIT_IMPORTS = lang_1.CONST_EXPR({
    'AppProtoView': view_1.AppProtoView,
    'AppProtoElement': element_1.AppProtoElement,
    'ViewType': view_type_1.ViewType
  });
  exports.APP_VIEW_MODULE_REF = source_module_1.moduleRef('package:angular2/src/core/linker/view' + util_1.MODULE_SUFFIX);
  exports.VIEW_TYPE_MODULE_REF = source_module_1.moduleRef('package:angular2/src/core/linker/view_type' + util_1.MODULE_SUFFIX);
  exports.APP_EL_MODULE_REF = source_module_1.moduleRef('package:angular2/src/core/linker/element' + util_1.MODULE_SUFFIX);
  exports.METADATA_MODULE_REF = source_module_1.moduleRef('package:angular2/src/core/metadata/view' + util_1.MODULE_SUFFIX);
  var IMPLICIT_TEMPLATE_VAR = '\$implicit';
  var CLASS_ATTR = 'class';
  var STYLE_ATTR = 'style';
  var ProtoViewCompiler = (function() {
    function ProtoViewCompiler() {}
    ProtoViewCompiler.prototype.compileProtoViewRuntime = function(metadataCache, component, template, pipes) {
      var protoViewFactory = new RuntimeProtoViewFactory(metadataCache, component, pipes);
      var allProtoViews = [];
      protoViewFactory.createCompileProtoView(template, [], [], allProtoViews);
      return new CompileProtoViews([], allProtoViews);
    };
    ProtoViewCompiler.prototype.compileProtoViewCodeGen = function(resolvedMetadataCacheExpr, component, template, pipes) {
      var protoViewFactory = new CodeGenProtoViewFactory(resolvedMetadataCacheExpr, component, pipes);
      var allProtoViews = [];
      var allStatements = [];
      protoViewFactory.createCompileProtoView(template, [], allStatements, allProtoViews);
      return new CompileProtoViews(allStatements.map(function(stmt) {
        return stmt.statement;
      }), allProtoViews);
    };
    ProtoViewCompiler = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [])], ProtoViewCompiler);
    return ProtoViewCompiler;
  })();
  exports.ProtoViewCompiler = ProtoViewCompiler;
  var CompileProtoViews = (function() {
    function CompileProtoViews(declarations, protoViews) {
      this.declarations = declarations;
      this.protoViews = protoViews;
    }
    return CompileProtoViews;
  })();
  exports.CompileProtoViews = CompileProtoViews;
  var CompileProtoView = (function() {
    function CompileProtoView(embeddedTemplateIndex, protoElements, protoView) {
      this.embeddedTemplateIndex = embeddedTemplateIndex;
      this.protoElements = protoElements;
      this.protoView = protoView;
    }
    return CompileProtoView;
  })();
  exports.CompileProtoView = CompileProtoView;
  var CompileProtoElement = (function() {
    function CompileProtoElement(boundElementIndex, attrNameAndValues, variableNameAndValues, renderEvents, directives, embeddedTemplateIndex, appProtoEl) {
      this.boundElementIndex = boundElementIndex;
      this.attrNameAndValues = attrNameAndValues;
      this.variableNameAndValues = variableNameAndValues;
      this.renderEvents = renderEvents;
      this.directives = directives;
      this.embeddedTemplateIndex = embeddedTemplateIndex;
      this.appProtoEl = appProtoEl;
    }
    return CompileProtoElement;
  })();
  exports.CompileProtoElement = CompileProtoElement;
  function visitAndReturnContext(visitor, asts, context) {
    template_ast_1.templateVisitAll(visitor, asts, context);
    return context;
  }
  var ProtoViewFactory = (function() {
    function ProtoViewFactory(component) {
      this.component = component;
    }
    ProtoViewFactory.prototype.createCompileProtoView = function(template, templateVariableBindings, targetStatements, targetProtoViews) {
      var embeddedTemplateIndex = targetProtoViews.length;
      targetProtoViews.push(null);
      var builder = new ProtoViewBuilderVisitor(this, targetStatements, targetProtoViews);
      template_ast_1.templateVisitAll(builder, template);
      var viewType = getViewType(this.component, embeddedTemplateIndex);
      var appProtoView = this.createAppProtoView(embeddedTemplateIndex, viewType, templateVariableBindings, targetStatements);
      var cpv = new CompileProtoView(embeddedTemplateIndex, builder.protoElements, appProtoView);
      targetProtoViews[embeddedTemplateIndex] = cpv;
      return cpv;
    };
    return ProtoViewFactory;
  })();
  var CodeGenProtoViewFactory = (function(_super) {
    __extends(CodeGenProtoViewFactory, _super);
    function CodeGenProtoViewFactory(resolvedMetadataCacheExpr, component, pipes) {
      _super.call(this, component);
      this.resolvedMetadataCacheExpr = resolvedMetadataCacheExpr;
      this.pipes = pipes;
      this._nextVarId = 0;
    }
    CodeGenProtoViewFactory.prototype._nextProtoViewVar = function(embeddedTemplateIndex) {
      return "appProtoView" + this._nextVarId++ + "_" + this.component.type.name + embeddedTemplateIndex;
    };
    CodeGenProtoViewFactory.prototype.createAppProtoView = function(embeddedTemplateIndex, viewType, templateVariableBindings, targetStatements) {
      var protoViewVarName = this._nextProtoViewVar(embeddedTemplateIndex);
      var viewTypeExpr = codeGenViewType(viewType);
      var pipesExpr = embeddedTemplateIndex === 0 ? codeGenTypesArray(this.pipes.map(function(pipeMeta) {
        return pipeMeta.type;
      })) : null;
      var statement = "var " + protoViewVarName + " = " + exports.APP_VIEW_MODULE_REF + "AppProtoView.create(" + this.resolvedMetadataCacheExpr.expression + ", " + viewTypeExpr + ", " + pipesExpr + ", " + util_1.codeGenStringMap(templateVariableBindings) + ");";
      targetStatements.push(new util_1.Statement(statement));
      return new util_1.Expression(protoViewVarName);
    };
    CodeGenProtoViewFactory.prototype.createAppProtoElement = function(boundElementIndex, attrNameAndValues, variableNameAndValues, directives, targetStatements) {
      var varName = "appProtoEl" + this._nextVarId++ + "_" + this.component.type.name;
      var value = exports.APP_EL_MODULE_REF + "AppProtoElement.create(\n        " + this.resolvedMetadataCacheExpr.expression + ",\n        " + boundElementIndex + ",\n        " + util_1.codeGenStringMap(attrNameAndValues) + ",\n        " + codeGenDirectivesArray(directives) + ",\n        " + util_1.codeGenStringMap(variableNameAndValues) + "\n      )";
      var statement = "var " + varName + " = " + value + ";";
      targetStatements.push(new util_1.Statement(statement));
      return new util_1.Expression(varName);
    };
    return CodeGenProtoViewFactory;
  })(ProtoViewFactory);
  var RuntimeProtoViewFactory = (function(_super) {
    __extends(RuntimeProtoViewFactory, _super);
    function RuntimeProtoViewFactory(metadataCache, component, pipes) {
      _super.call(this, component);
      this.metadataCache = metadataCache;
      this.pipes = pipes;
    }
    RuntimeProtoViewFactory.prototype.createAppProtoView = function(embeddedTemplateIndex, viewType, templateVariableBindings, targetStatements) {
      var pipes = embeddedTemplateIndex === 0 ? this.pipes.map(function(pipeMeta) {
        return pipeMeta.type.runtime;
      }) : [];
      var templateVars = keyValueArrayToStringMap(templateVariableBindings);
      return view_1.AppProtoView.create(this.metadataCache, viewType, pipes, templateVars);
    };
    RuntimeProtoViewFactory.prototype.createAppProtoElement = function(boundElementIndex, attrNameAndValues, variableNameAndValues, directives, targetStatements) {
      var attrs = keyValueArrayToStringMap(attrNameAndValues);
      return element_1.AppProtoElement.create(this.metadataCache, boundElementIndex, attrs, directives.map(function(dirMeta) {
        return dirMeta.type.runtime;
      }), keyValueArrayToStringMap(variableNameAndValues));
    };
    return RuntimeProtoViewFactory;
  })(ProtoViewFactory);
  var ProtoViewBuilderVisitor = (function() {
    function ProtoViewBuilderVisitor(factory, allStatements, allProtoViews) {
      this.factory = factory;
      this.allStatements = allStatements;
      this.allProtoViews = allProtoViews;
      this.protoElements = [];
      this.boundElementCount = 0;
    }
    ProtoViewBuilderVisitor.prototype._readAttrNameAndValues = function(directives, attrAsts) {
      var attrs = visitAndReturnContext(this, attrAsts, {});
      directives.forEach(function(directiveMeta) {
        collection_1.StringMapWrapper.forEach(directiveMeta.hostAttributes, function(value, name) {
          var prevValue = attrs[name];
          attrs[name] = lang_1.isPresent(prevValue) ? mergeAttributeValue(name, prevValue, value) : value;
        });
      });
      return mapToKeyValueArray(attrs);
    };
    ProtoViewBuilderVisitor.prototype.visitBoundText = function(ast, context) {
      return null;
    };
    ProtoViewBuilderVisitor.prototype.visitText = function(ast, context) {
      return null;
    };
    ProtoViewBuilderVisitor.prototype.visitNgContent = function(ast, context) {
      return null;
    };
    ProtoViewBuilderVisitor.prototype.visitElement = function(ast, context) {
      var _this = this;
      var boundElementIndex = null;
      if (ast.isBound()) {
        boundElementIndex = this.boundElementCount++;
      }
      var component = ast.getComponent();
      var variableNameAndValues = [];
      if (lang_1.isBlank(component)) {
        ast.exportAsVars.forEach(function(varAst) {
          variableNameAndValues.push([varAst.name, null]);
        });
      }
      var directives = [];
      var renderEvents = visitAndReturnContext(this, ast.outputs, new Map());
      collection_1.ListWrapper.forEachWithIndex(ast.directives, function(directiveAst, index) {
        directiveAst.visit(_this, new DirectiveContext(index, boundElementIndex, renderEvents, variableNameAndValues, directives));
      });
      var renderEventArray = [];
      renderEvents.forEach(function(eventAst, _) {
        return renderEventArray.push(eventAst);
      });
      var attrNameAndValues = this._readAttrNameAndValues(directives, ast.attrs);
      this._addProtoElement(ast.isBound(), boundElementIndex, attrNameAndValues, variableNameAndValues, renderEventArray, directives, null);
      template_ast_1.templateVisitAll(this, ast.children);
      return null;
    };
    ProtoViewBuilderVisitor.prototype.visitEmbeddedTemplate = function(ast, context) {
      var _this = this;
      var boundElementIndex = this.boundElementCount++;
      var directives = [];
      collection_1.ListWrapper.forEachWithIndex(ast.directives, function(directiveAst, index) {
        directiveAst.visit(_this, new DirectiveContext(index, boundElementIndex, new Map(), [], directives));
      });
      var attrNameAndValues = this._readAttrNameAndValues(directives, ast.attrs);
      var templateVariableBindings = ast.vars.map(function(varAst) {
        return [varAst.value.length > 0 ? varAst.value : IMPLICIT_TEMPLATE_VAR, varAst.name];
      });
      var nestedProtoView = this.factory.createCompileProtoView(ast.children, templateVariableBindings, this.allStatements, this.allProtoViews);
      this._addProtoElement(true, boundElementIndex, attrNameAndValues, [], [], directives, nestedProtoView.embeddedTemplateIndex);
      return null;
    };
    ProtoViewBuilderVisitor.prototype._addProtoElement = function(isBound, boundElementIndex, attrNameAndValues, variableNameAndValues, renderEvents, directives, embeddedTemplateIndex) {
      var appProtoEl = null;
      if (isBound) {
        appProtoEl = this.factory.createAppProtoElement(boundElementIndex, attrNameAndValues, variableNameAndValues, directives, this.allStatements);
      }
      var compileProtoEl = new CompileProtoElement(boundElementIndex, attrNameAndValues, variableNameAndValues, renderEvents, directives, embeddedTemplateIndex, appProtoEl);
      this.protoElements.push(compileProtoEl);
    };
    ProtoViewBuilderVisitor.prototype.visitVariable = function(ast, ctx) {
      return null;
    };
    ProtoViewBuilderVisitor.prototype.visitAttr = function(ast, attrNameAndValues) {
      attrNameAndValues[ast.name] = ast.value;
      return null;
    };
    ProtoViewBuilderVisitor.prototype.visitDirective = function(ast, ctx) {
      ctx.targetDirectives.push(ast.directive);
      template_ast_1.templateVisitAll(this, ast.hostEvents, ctx.hostEventTargetAndNames);
      ast.exportAsVars.forEach(function(varAst) {
        ctx.targetVariableNameAndValues.push([varAst.name, ctx.index]);
      });
      return null;
    };
    ProtoViewBuilderVisitor.prototype.visitEvent = function(ast, eventTargetAndNames) {
      eventTargetAndNames.set(ast.fullName, ast);
      return null;
    };
    ProtoViewBuilderVisitor.prototype.visitDirectiveProperty = function(ast, context) {
      return null;
    };
    ProtoViewBuilderVisitor.prototype.visitElementProperty = function(ast, context) {
      return null;
    };
    return ProtoViewBuilderVisitor;
  })();
  function mapToKeyValueArray(data) {
    var entryArray = [];
    collection_1.StringMapWrapper.forEach(data, function(value, name) {
      entryArray.push([name, value]);
    });
    collection_1.ListWrapper.sort(entryArray, function(entry1, entry2) {
      return lang_1.StringWrapper.compare(entry1[0], entry2[0]);
    });
    var keyValueArray = [];
    entryArray.forEach(function(entry) {
      keyValueArray.push([entry[0], entry[1]]);
    });
    return keyValueArray;
  }
  function mergeAttributeValue(attrName, attrValue1, attrValue2) {
    if (attrName == CLASS_ATTR || attrName == STYLE_ATTR) {
      return attrValue1 + " " + attrValue2;
    } else {
      return attrValue2;
    }
  }
  var DirectiveContext = (function() {
    function DirectiveContext(index, boundElementIndex, hostEventTargetAndNames, targetVariableNameAndValues, targetDirectives) {
      this.index = index;
      this.boundElementIndex = boundElementIndex;
      this.hostEventTargetAndNames = hostEventTargetAndNames;
      this.targetVariableNameAndValues = targetVariableNameAndValues;
      this.targetDirectives = targetDirectives;
    }
    return DirectiveContext;
  })();
  function keyValueArrayToStringMap(keyValueArray) {
    var stringMap = {};
    for (var i = 0; i < keyValueArray.length; i++) {
      var entry = keyValueArray[i];
      stringMap[entry[0]] = entry[1];
    }
    return stringMap;
  }
  function codeGenDirectivesArray(directives) {
    var expressions = directives.map(function(directiveType) {
      return typeRef(directiveType.type);
    });
    return "[" + expressions.join(',') + "]";
  }
  function codeGenTypesArray(types) {
    var expressions = types.map(typeRef);
    return "[" + expressions.join(',') + "]";
  }
  function codeGenViewType(value) {
    if (lang_1.IS_DART) {
      return "" + exports.VIEW_TYPE_MODULE_REF + value;
    } else {
      return "" + value;
    }
  }
  function typeRef(type) {
    return "" + source_module_1.moduleRef(type.moduleUrl) + type.name;
  }
  function getViewType(component, embeddedTemplateIndex) {
    if (embeddedTemplateIndex > 0) {
      return view_type_1.ViewType.EMBEDDED;
    } else if (component.type.isHost) {
      return view_type_1.ViewType.HOST;
    } else {
      return view_type_1.ViewType.COMPONENT;
    }
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/html_ast", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var HtmlTextAst = (function() {
    function HtmlTextAst(value, sourceSpan) {
      this.value = value;
      this.sourceSpan = sourceSpan;
    }
    HtmlTextAst.prototype.visit = function(visitor, context) {
      return visitor.visitText(this, context);
    };
    return HtmlTextAst;
  })();
  exports.HtmlTextAst = HtmlTextAst;
  var HtmlAttrAst = (function() {
    function HtmlAttrAst(name, value, sourceSpan) {
      this.name = name;
      this.value = value;
      this.sourceSpan = sourceSpan;
    }
    HtmlAttrAst.prototype.visit = function(visitor, context) {
      return visitor.visitAttr(this, context);
    };
    return HtmlAttrAst;
  })();
  exports.HtmlAttrAst = HtmlAttrAst;
  var HtmlElementAst = (function() {
    function HtmlElementAst(name, attrs, children, sourceSpan) {
      this.name = name;
      this.attrs = attrs;
      this.children = children;
      this.sourceSpan = sourceSpan;
    }
    HtmlElementAst.prototype.visit = function(visitor, context) {
      return visitor.visitElement(this, context);
    };
    return HtmlElementAst;
  })();
  exports.HtmlElementAst = HtmlElementAst;
  function htmlVisitAll(visitor, asts, context) {
    if (context === void 0) {
      context = null;
    }
    var result = [];
    asts.forEach(function(ast) {
      var astResult = ast.visit(visitor, context);
      if (lang_1.isPresent(astResult)) {
        result.push(astResult);
      }
    });
    return result;
  }
  exports.htmlVisitAll = htmlVisitAll;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/parse_util", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var ParseLocation = (function() {
    function ParseLocation(file, offset, line, col) {
      this.file = file;
      this.offset = offset;
      this.line = line;
      this.col = col;
    }
    ParseLocation.prototype.toString = function() {
      return this.file.url + "@" + this.line + ":" + this.col;
    };
    return ParseLocation;
  })();
  exports.ParseLocation = ParseLocation;
  var ParseSourceFile = (function() {
    function ParseSourceFile(content, url) {
      this.content = content;
      this.url = url;
    }
    return ParseSourceFile;
  })();
  exports.ParseSourceFile = ParseSourceFile;
  var ParseError = (function() {
    function ParseError(location, msg) {
      this.location = location;
      this.msg = msg;
    }
    ParseError.prototype.toString = function() {
      var source = this.location.file.content;
      var ctxStart = this.location.offset;
      if (ctxStart > source.length - 1) {
        ctxStart = source.length - 1;
      }
      var ctxEnd = ctxStart;
      var ctxLen = 0;
      var ctxLines = 0;
      while (ctxLen < 100 && ctxStart > 0) {
        ctxStart--;
        ctxLen++;
        if (source[ctxStart] == "\n") {
          if (++ctxLines == 3) {
            break;
          }
        }
      }
      ctxLen = 0;
      ctxLines = 0;
      while (ctxLen < 100 && ctxEnd < source.length - 1) {
        ctxEnd++;
        ctxLen++;
        if (source[ctxEnd] == "\n") {
          if (++ctxLines == 3) {
            break;
          }
        }
      }
      var context = source.substring(ctxStart, this.location.offset) + '[ERROR ->]' + source.substring(this.location.offset, ctxEnd + 1);
      return this.msg + " (\"" + context + "\"): " + this.location;
    };
    return ParseError;
  })();
  exports.ParseError = ParseError;
  var ParseSourceSpan = (function() {
    function ParseSourceSpan(start, end) {
      this.start = start;
      this.end = end;
    }
    ParseSourceSpan.prototype.toString = function() {
      return this.start.file.content.substring(this.start.offset, this.end.offset);
    };
    return ParseSourceSpan;
  })();
  exports.ParseSourceSpan = ParseSourceSpan;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/html_tags", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  exports.NAMED_ENTITIES = lang_1.CONST_EXPR({
    'Aacute': '\u00C1',
    'aacute': '\u00E1',
    'Acirc': '\u00C2',
    'acirc': '\u00E2',
    'acute': '\u00B4',
    'AElig': '\u00C6',
    'aelig': '\u00E6',
    'Agrave': '\u00C0',
    'agrave': '\u00E0',
    'alefsym': '\u2135',
    'Alpha': '\u0391',
    'alpha': '\u03B1',
    'amp': '&',
    'and': '\u2227',
    'ang': '\u2220',
    'apos': '\u0027',
    'Aring': '\u00C5',
    'aring': '\u00E5',
    'asymp': '\u2248',
    'Atilde': '\u00C3',
    'atilde': '\u00E3',
    'Auml': '\u00C4',
    'auml': '\u00E4',
    'bdquo': '\u201E',
    'Beta': '\u0392',
    'beta': '\u03B2',
    'brvbar': '\u00A6',
    'bull': '\u2022',
    'cap': '\u2229',
    'Ccedil': '\u00C7',
    'ccedil': '\u00E7',
    'cedil': '\u00B8',
    'cent': '\u00A2',
    'Chi': '\u03A7',
    'chi': '\u03C7',
    'circ': '\u02C6',
    'clubs': '\u2663',
    'cong': '\u2245',
    'copy': '\u00A9',
    'crarr': '\u21B5',
    'cup': '\u222A',
    'curren': '\u00A4',
    'dagger': '\u2020',
    'Dagger': '\u2021',
    'darr': '\u2193',
    'dArr': '\u21D3',
    'deg': '\u00B0',
    'Delta': '\u0394',
    'delta': '\u03B4',
    'diams': '\u2666',
    'divide': '\u00F7',
    'Eacute': '\u00C9',
    'eacute': '\u00E9',
    'Ecirc': '\u00CA',
    'ecirc': '\u00EA',
    'Egrave': '\u00C8',
    'egrave': '\u00E8',
    'empty': '\u2205',
    'emsp': '\u2003',
    'ensp': '\u2002',
    'Epsilon': '\u0395',
    'epsilon': '\u03B5',
    'equiv': '\u2261',
    'Eta': '\u0397',
    'eta': '\u03B7',
    'ETH': '\u00D0',
    'eth': '\u00F0',
    'Euml': '\u00CB',
    'euml': '\u00EB',
    'euro': '\u20AC',
    'exist': '\u2203',
    'fnof': '\u0192',
    'forall': '\u2200',
    'frac12': '\u00BD',
    'frac14': '\u00BC',
    'frac34': '\u00BE',
    'frasl': '\u2044',
    'Gamma': '\u0393',
    'gamma': '\u03B3',
    'ge': '\u2265',
    'gt': '>',
    'harr': '\u2194',
    'hArr': '\u21D4',
    'hearts': '\u2665',
    'hellip': '\u2026',
    'Iacute': '\u00CD',
    'iacute': '\u00ED',
    'Icirc': '\u00CE',
    'icirc': '\u00EE',
    'iexcl': '\u00A1',
    'Igrave': '\u00CC',
    'igrave': '\u00EC',
    'image': '\u2111',
    'infin': '\u221E',
    'int': '\u222B',
    'Iota': '\u0399',
    'iota': '\u03B9',
    'iquest': '\u00BF',
    'isin': '\u2208',
    'Iuml': '\u00CF',
    'iuml': '\u00EF',
    'Kappa': '\u039A',
    'kappa': '\u03BA',
    'Lambda': '\u039B',
    'lambda': '\u03BB',
    'lang': '\u27E8',
    'laquo': '\u00AB',
    'larr': '\u2190',
    'lArr': '\u21D0',
    'lceil': '\u2308',
    'ldquo': '\u201C',
    'le': '\u2264',
    'lfloor': '\u230A',
    'lowast': '\u2217',
    'loz': '\u25CA',
    'lrm': '\u200E',
    'lsaquo': '\u2039',
    'lsquo': '\u2018',
    'lt': '<',
    'macr': '\u00AF',
    'mdash': '\u2014',
    'micro': '\u00B5',
    'middot': '\u00B7',
    'minus': '\u2212',
    'Mu': '\u039C',
    'mu': '\u03BC',
    'nabla': '\u2207',
    'nbsp': '\u00A0',
    'ndash': '\u2013',
    'ne': '\u2260',
    'ni': '\u220B',
    'not': '\u00AC',
    'notin': '\u2209',
    'nsub': '\u2284',
    'Ntilde': '\u00D1',
    'ntilde': '\u00F1',
    'Nu': '\u039D',
    'nu': '\u03BD',
    'Oacute': '\u00D3',
    'oacute': '\u00F3',
    'Ocirc': '\u00D4',
    'ocirc': '\u00F4',
    'OElig': '\u0152',
    'oelig': '\u0153',
    'Ograve': '\u00D2',
    'ograve': '\u00F2',
    'oline': '\u203E',
    'Omega': '\u03A9',
    'omega': '\u03C9',
    'Omicron': '\u039F',
    'omicron': '\u03BF',
    'oplus': '\u2295',
    'or': '\u2228',
    'ordf': '\u00AA',
    'ordm': '\u00BA',
    'Oslash': '\u00D8',
    'oslash': '\u00F8',
    'Otilde': '\u00D5',
    'otilde': '\u00F5',
    'otimes': '\u2297',
    'Ouml': '\u00D6',
    'ouml': '\u00F6',
    'para': '\u00B6',
    'permil': '\u2030',
    'perp': '\u22A5',
    'Phi': '\u03A6',
    'phi': '\u03C6',
    'Pi': '\u03A0',
    'pi': '\u03C0',
    'piv': '\u03D6',
    'plusmn': '\u00B1',
    'pound': '\u00A3',
    'prime': '\u2032',
    'Prime': '\u2033',
    'prod': '\u220F',
    'prop': '\u221D',
    'Psi': '\u03A8',
    'psi': '\u03C8',
    'quot': '\u0022',
    'radic': '\u221A',
    'rang': '\u27E9',
    'raquo': '\u00BB',
    'rarr': '\u2192',
    'rArr': '\u21D2',
    'rceil': '\u2309',
    'rdquo': '\u201D',
    'real': '\u211C',
    'reg': '\u00AE',
    'rfloor': '\u230B',
    'Rho': '\u03A1',
    'rho': '\u03C1',
    'rlm': '\u200F',
    'rsaquo': '\u203A',
    'rsquo': '\u2019',
    'sbquo': '\u201A',
    'Scaron': '\u0160',
    'scaron': '\u0161',
    'sdot': '\u22C5',
    'sect': '\u00A7',
    'shy': '\u00AD',
    'Sigma': '\u03A3',
    'sigma': '\u03C3',
    'sigmaf': '\u03C2',
    'sim': '\u223C',
    'spades': '\u2660',
    'sub': '\u2282',
    'sube': '\u2286',
    'sum': '\u2211',
    'sup': '\u2283',
    'sup1': '\u00B9',
    'sup2': '\u00B2',
    'sup3': '\u00B3',
    'supe': '\u2287',
    'szlig': '\u00DF',
    'Tau': '\u03A4',
    'tau': '\u03C4',
    'there4': '\u2234',
    'Theta': '\u0398',
    'theta': '\u03B8',
    'thetasym': '\u03D1',
    'thinsp': '\u2009',
    'THORN': '\u00DE',
    'thorn': '\u00FE',
    'tilde': '\u02DC',
    'times': '\u00D7',
    'trade': '\u2122',
    'Uacute': '\u00DA',
    'uacute': '\u00FA',
    'uarr': '\u2191',
    'uArr': '\u21D1',
    'Ucirc': '\u00DB',
    'ucirc': '\u00FB',
    'Ugrave': '\u00D9',
    'ugrave': '\u00F9',
    'uml': '\u00A8',
    'upsih': '\u03D2',
    'Upsilon': '\u03A5',
    'upsilon': '\u03C5',
    'Uuml': '\u00DC',
    'uuml': '\u00FC',
    'weierp': '\u2118',
    'Xi': '\u039E',
    'xi': '\u03BE',
    'Yacute': '\u00DD',
    'yacute': '\u00FD',
    'yen': '\u00A5',
    'yuml': '\u00FF',
    'Yuml': '\u0178',
    'Zeta': '\u0396',
    'zeta': '\u03B6',
    'zwj': '\u200D',
    'zwnj': '\u200C'
  });
  (function(HtmlTagContentType) {
    HtmlTagContentType[HtmlTagContentType["RAW_TEXT"] = 0] = "RAW_TEXT";
    HtmlTagContentType[HtmlTagContentType["ESCAPABLE_RAW_TEXT"] = 1] = "ESCAPABLE_RAW_TEXT";
    HtmlTagContentType[HtmlTagContentType["PARSABLE_DATA"] = 2] = "PARSABLE_DATA";
  })(exports.HtmlTagContentType || (exports.HtmlTagContentType = {}));
  var HtmlTagContentType = exports.HtmlTagContentType;
  var HtmlTagDefinition = (function() {
    function HtmlTagDefinition(_a) {
      var _this = this;
      var _b = _a === void 0 ? {} : _a,
          closedByChildren = _b.closedByChildren,
          requiredParents = _b.requiredParents,
          implicitNamespacePrefix = _b.implicitNamespacePrefix,
          contentType = _b.contentType,
          closedByParent = _b.closedByParent,
          isVoid = _b.isVoid,
          ignoreFirstLf = _b.ignoreFirstLf;
      this.closedByChildren = {};
      this.closedByParent = false;
      if (lang_1.isPresent(closedByChildren) && closedByChildren.length > 0) {
        closedByChildren.forEach(function(tagName) {
          return _this.closedByChildren[tagName] = true;
        });
      }
      this.isVoid = lang_1.normalizeBool(isVoid);
      this.closedByParent = lang_1.normalizeBool(closedByParent) || this.isVoid;
      if (lang_1.isPresent(requiredParents) && requiredParents.length > 0) {
        this.requiredParents = {};
        this.parentToAdd = requiredParents[0];
        requiredParents.forEach(function(tagName) {
          return _this.requiredParents[tagName] = true;
        });
      }
      this.implicitNamespacePrefix = implicitNamespacePrefix;
      this.contentType = lang_1.isPresent(contentType) ? contentType : HtmlTagContentType.PARSABLE_DATA;
      this.ignoreFirstLf = lang_1.normalizeBool(ignoreFirstLf);
    }
    HtmlTagDefinition.prototype.requireExtraParent = function(currentParent) {
      if (lang_1.isBlank(this.requiredParents)) {
        return false;
      }
      if (lang_1.isBlank(currentParent)) {
        return true;
      }
      var lcParent = currentParent.toLowerCase();
      return this.requiredParents[lcParent] != true && lcParent != 'template';
    };
    HtmlTagDefinition.prototype.isClosedByChild = function(name) {
      return this.isVoid || lang_1.normalizeBool(this.closedByChildren[name.toLowerCase()]);
    };
    return HtmlTagDefinition;
  })();
  exports.HtmlTagDefinition = HtmlTagDefinition;
  var TAG_DEFINITIONS = {
    'area': new HtmlTagDefinition({isVoid: true}),
    'embed': new HtmlTagDefinition({isVoid: true}),
    'link': new HtmlTagDefinition({isVoid: true}),
    'img': new HtmlTagDefinition({isVoid: true}),
    'input': new HtmlTagDefinition({isVoid: true}),
    'param': new HtmlTagDefinition({isVoid: true}),
    'hr': new HtmlTagDefinition({isVoid: true}),
    'br': new HtmlTagDefinition({isVoid: true}),
    'source': new HtmlTagDefinition({isVoid: true}),
    'track': new HtmlTagDefinition({isVoid: true}),
    'wbr': new HtmlTagDefinition({isVoid: true}),
    'p': new HtmlTagDefinition({
      closedByChildren: ['address', 'article', 'aside', 'blockquote', 'div', 'dl', 'fieldset', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'hgroup', 'hr', 'main', 'nav', 'ol', 'p', 'pre', 'section', 'table', 'ul'],
      closedByParent: true
    }),
    'thead': new HtmlTagDefinition({closedByChildren: ['tbody', 'tfoot']}),
    'tbody': new HtmlTagDefinition({
      closedByChildren: ['tbody', 'tfoot'],
      closedByParent: true
    }),
    'tfoot': new HtmlTagDefinition({
      closedByChildren: ['tbody'],
      closedByParent: true
    }),
    'tr': new HtmlTagDefinition({
      closedByChildren: ['tr'],
      requiredParents: ['tbody', 'tfoot', 'thead'],
      closedByParent: true
    }),
    'td': new HtmlTagDefinition({
      closedByChildren: ['td', 'th'],
      closedByParent: true
    }),
    'th': new HtmlTagDefinition({
      closedByChildren: ['td', 'th'],
      closedByParent: true
    }),
    'col': new HtmlTagDefinition({
      requiredParents: ['colgroup'],
      isVoid: true
    }),
    'svg': new HtmlTagDefinition({implicitNamespacePrefix: 'svg'}),
    'math': new HtmlTagDefinition({implicitNamespacePrefix: 'math'}),
    'li': new HtmlTagDefinition({
      closedByChildren: ['li'],
      closedByParent: true
    }),
    'dt': new HtmlTagDefinition({closedByChildren: ['dt', 'dd']}),
    'dd': new HtmlTagDefinition({
      closedByChildren: ['dt', 'dd'],
      closedByParent: true
    }),
    'rb': new HtmlTagDefinition({
      closedByChildren: ['rb', 'rt', 'rtc', 'rp'],
      closedByParent: true
    }),
    'rt': new HtmlTagDefinition({
      closedByChildren: ['rb', 'rt', 'rtc', 'rp'],
      closedByParent: true
    }),
    'rtc': new HtmlTagDefinition({
      closedByChildren: ['rb', 'rtc', 'rp'],
      closedByParent: true
    }),
    'rp': new HtmlTagDefinition({
      closedByChildren: ['rb', 'rt', 'rtc', 'rp'],
      closedByParent: true
    }),
    'optgroup': new HtmlTagDefinition({
      closedByChildren: ['optgroup'],
      closedByParent: true
    }),
    'option': new HtmlTagDefinition({
      closedByChildren: ['option', 'optgroup'],
      closedByParent: true
    }),
    'pre': new HtmlTagDefinition({ignoreFirstLf: true}),
    'listing': new HtmlTagDefinition({ignoreFirstLf: true}),
    'style': new HtmlTagDefinition({contentType: HtmlTagContentType.RAW_TEXT}),
    'script': new HtmlTagDefinition({contentType: HtmlTagContentType.RAW_TEXT}),
    'title': new HtmlTagDefinition({contentType: HtmlTagContentType.ESCAPABLE_RAW_TEXT}),
    'textarea': new HtmlTagDefinition({
      contentType: HtmlTagContentType.ESCAPABLE_RAW_TEXT,
      ignoreFirstLf: true
    })
  };
  var DEFAULT_TAG_DEFINITION = new HtmlTagDefinition();
  function getHtmlTagDefinition(tagName) {
    var result = TAG_DEFINITIONS[tagName.toLowerCase()];
    return lang_1.isPresent(result) ? result : DEFAULT_TAG_DEFINITION;
  }
  exports.getHtmlTagDefinition = getHtmlTagDefinition;
  var NS_PREFIX_RE = /^@([^:]+):(.+)/g;
  function splitNsName(elementName) {
    if (elementName[0] != '@') {
      return [null, elementName];
    }
    var match = lang_1.RegExpWrapper.firstMatch(NS_PREFIX_RE, elementName);
    return [match[1], match[2]];
  }
  exports.splitNsName = splitNsName;
  function getNsPrefix(elementName) {
    return splitNsName(elementName)[0];
  }
  exports.getNsPrefix = getNsPrefix;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/schema/element_schema_registry", [], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var ElementSchemaRegistry = (function() {
    function ElementSchemaRegistry() {}
    ElementSchemaRegistry.prototype.hasProperty = function(tagName, propName) {
      return true;
    };
    ElementSchemaRegistry.prototype.getMappedPropName = function(propName) {
      return propName;
    };
    return ElementSchemaRegistry;
  })();
  exports.ElementSchemaRegistry = ElementSchemaRegistry;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/template_preparser", ["angular2/src/facade/lang", "angular2/src/compiler/html_tags"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var html_tags_1 = require("angular2/src/compiler/html_tags");
  var NG_CONTENT_SELECT_ATTR = 'select';
  var NG_CONTENT_ELEMENT = 'ng-content';
  var LINK_ELEMENT = 'link';
  var LINK_STYLE_REL_ATTR = 'rel';
  var LINK_STYLE_HREF_ATTR = 'href';
  var LINK_STYLE_REL_VALUE = 'stylesheet';
  var STYLE_ELEMENT = 'style';
  var SCRIPT_ELEMENT = 'script';
  var NG_NON_BINDABLE_ATTR = 'ngNonBindable';
  function preparseElement(ast) {
    var selectAttr = null;
    var hrefAttr = null;
    var relAttr = null;
    var nonBindable = false;
    ast.attrs.forEach(function(attr) {
      var lcAttrName = attr.name.toLowerCase();
      if (lcAttrName == NG_CONTENT_SELECT_ATTR) {
        selectAttr = attr.value;
      } else if (lcAttrName == LINK_STYLE_HREF_ATTR) {
        hrefAttr = attr.value;
      } else if (lcAttrName == LINK_STYLE_REL_ATTR) {
        relAttr = attr.value;
      } else if (attr.name == NG_NON_BINDABLE_ATTR) {
        nonBindable = true;
      }
    });
    selectAttr = normalizeNgContentSelect(selectAttr);
    var nodeName = ast.name.toLowerCase();
    var type = PreparsedElementType.OTHER;
    if (html_tags_1.splitNsName(nodeName)[1] == NG_CONTENT_ELEMENT) {
      type = PreparsedElementType.NG_CONTENT;
    } else if (nodeName == STYLE_ELEMENT) {
      type = PreparsedElementType.STYLE;
    } else if (nodeName == SCRIPT_ELEMENT) {
      type = PreparsedElementType.SCRIPT;
    } else if (nodeName == LINK_ELEMENT && relAttr == LINK_STYLE_REL_VALUE) {
      type = PreparsedElementType.STYLESHEET;
    }
    return new PreparsedElement(type, selectAttr, hrefAttr, nonBindable);
  }
  exports.preparseElement = preparseElement;
  (function(PreparsedElementType) {
    PreparsedElementType[PreparsedElementType["NG_CONTENT"] = 0] = "NG_CONTENT";
    PreparsedElementType[PreparsedElementType["STYLE"] = 1] = "STYLE";
    PreparsedElementType[PreparsedElementType["STYLESHEET"] = 2] = "STYLESHEET";
    PreparsedElementType[PreparsedElementType["SCRIPT"] = 3] = "SCRIPT";
    PreparsedElementType[PreparsedElementType["OTHER"] = 4] = "OTHER";
  })(exports.PreparsedElementType || (exports.PreparsedElementType = {}));
  var PreparsedElementType = exports.PreparsedElementType;
  var PreparsedElement = (function() {
    function PreparsedElement(type, selectAttr, hrefAttr, nonBindable) {
      this.type = type;
      this.selectAttr = selectAttr;
      this.hrefAttr = hrefAttr;
      this.nonBindable = nonBindable;
    }
    return PreparsedElement;
  })();
  exports.PreparsedElement = PreparsedElement;
  function normalizeNgContentSelect(selectAttr) {
    if (lang_1.isBlank(selectAttr) || selectAttr.length === 0) {
      return '*';
    }
    return selectAttr;
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/template_normalizer", ["angular2/src/compiler/directive_metadata", "angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/async", "angular2/src/compiler/xhr", "angular2/src/compiler/url_resolver", "angular2/src/compiler/style_url_resolver", "angular2/src/core/di", "angular2/src/core/metadata/view", "angular2/src/compiler/html_ast", "angular2/src/compiler/html_parser", "angular2/src/compiler/template_preparser"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var directive_metadata_1 = require("angular2/src/compiler/directive_metadata");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var async_1 = require("angular2/src/facade/async");
  var xhr_1 = require("angular2/src/compiler/xhr");
  var url_resolver_1 = require("angular2/src/compiler/url_resolver");
  var style_url_resolver_1 = require("angular2/src/compiler/style_url_resolver");
  var di_1 = require("angular2/src/core/di");
  var view_1 = require("angular2/src/core/metadata/view");
  var html_ast_1 = require("angular2/src/compiler/html_ast");
  var html_parser_1 = require("angular2/src/compiler/html_parser");
  var template_preparser_1 = require("angular2/src/compiler/template_preparser");
  var TemplateNormalizer = (function() {
    function TemplateNormalizer(_xhr, _urlResolver, _htmlParser) {
      this._xhr = _xhr;
      this._urlResolver = _urlResolver;
      this._htmlParser = _htmlParser;
    }
    TemplateNormalizer.prototype.normalizeTemplate = function(directiveType, template) {
      var _this = this;
      if (lang_1.isPresent(template.template)) {
        return async_1.PromiseWrapper.resolve(this.normalizeLoadedTemplate(directiveType, template, template.template, directiveType.moduleUrl));
      } else if (lang_1.isPresent(template.templateUrl)) {
        var sourceAbsUrl = this._urlResolver.resolve(directiveType.moduleUrl, template.templateUrl);
        return this._xhr.get(sourceAbsUrl).then(function(templateContent) {
          return _this.normalizeLoadedTemplate(directiveType, template, templateContent, sourceAbsUrl);
        });
      } else {
        throw new exceptions_1.BaseException("No template specified for component " + directiveType.name);
      }
    };
    TemplateNormalizer.prototype.normalizeLoadedTemplate = function(directiveType, templateMeta, template, templateAbsUrl) {
      var _this = this;
      var rootNodesAndErrors = this._htmlParser.parse(template, directiveType.name);
      if (rootNodesAndErrors.errors.length > 0) {
        var errorString = rootNodesAndErrors.errors.join('\n');
        throw new exceptions_1.BaseException("Template parse errors:\n" + errorString);
      }
      var visitor = new TemplatePreparseVisitor();
      html_ast_1.htmlVisitAll(visitor, rootNodesAndErrors.rootNodes);
      var allStyles = templateMeta.styles.concat(visitor.styles);
      var allStyleAbsUrls = visitor.styleUrls.filter(style_url_resolver_1.isStyleUrlResolvable).map(function(url) {
        return _this._urlResolver.resolve(templateAbsUrl, url);
      }).concat(templateMeta.styleUrls.filter(style_url_resolver_1.isStyleUrlResolvable).map(function(url) {
        return _this._urlResolver.resolve(directiveType.moduleUrl, url);
      }));
      var allResolvedStyles = allStyles.map(function(style) {
        var styleWithImports = style_url_resolver_1.extractStyleUrls(_this._urlResolver, templateAbsUrl, style);
        styleWithImports.styleUrls.forEach(function(styleUrl) {
          return allStyleAbsUrls.push(styleUrl);
        });
        return styleWithImports.style;
      });
      var encapsulation = templateMeta.encapsulation;
      if (encapsulation === view_1.ViewEncapsulation.Emulated && allResolvedStyles.length === 0 && allStyleAbsUrls.length === 0) {
        encapsulation = view_1.ViewEncapsulation.None;
      }
      return new directive_metadata_1.CompileTemplateMetadata({
        encapsulation: encapsulation,
        template: template,
        templateUrl: templateAbsUrl,
        styles: allResolvedStyles,
        styleUrls: allStyleAbsUrls,
        ngContentSelectors: visitor.ngContentSelectors
      });
    };
    TemplateNormalizer = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [xhr_1.XHR, url_resolver_1.UrlResolver, html_parser_1.HtmlParser])], TemplateNormalizer);
    return TemplateNormalizer;
  })();
  exports.TemplateNormalizer = TemplateNormalizer;
  var TemplatePreparseVisitor = (function() {
    function TemplatePreparseVisitor() {
      this.ngContentSelectors = [];
      this.styles = [];
      this.styleUrls = [];
      this.ngNonBindableStackCount = 0;
    }
    TemplatePreparseVisitor.prototype.visitElement = function(ast, context) {
      var preparsedElement = template_preparser_1.preparseElement(ast);
      switch (preparsedElement.type) {
        case template_preparser_1.PreparsedElementType.NG_CONTENT:
          if (this.ngNonBindableStackCount === 0) {
            this.ngContentSelectors.push(preparsedElement.selectAttr);
          }
          break;
        case template_preparser_1.PreparsedElementType.STYLE:
          var textContent = '';
          ast.children.forEach(function(child) {
            if (child instanceof html_ast_1.HtmlTextAst) {
              textContent += child.value;
            }
          });
          this.styles.push(textContent);
          break;
        case template_preparser_1.PreparsedElementType.STYLESHEET:
          this.styleUrls.push(preparsedElement.hrefAttr);
          break;
        default:
          break;
      }
      if (preparsedElement.nonBindable) {
        this.ngNonBindableStackCount++;
      }
      html_ast_1.htmlVisitAll(this, ast.children);
      if (preparsedElement.nonBindable) {
        this.ngNonBindableStackCount--;
      }
      return null;
    };
    TemplatePreparseVisitor.prototype.visitAttr = function(ast, context) {
      return null;
    };
    TemplatePreparseVisitor.prototype.visitText = function(ast, context) {
      return null;
    };
    return TemplatePreparseVisitor;
  })();
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/linker/directive_lifecycle_reflector", ["angular2/src/facade/lang", "angular2/src/core/linker/interfaces"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var interfaces_1 = require("angular2/src/core/linker/interfaces");
  function hasLifecycleHook(lcInterface, token) {
    if (!(token instanceof lang_1.Type))
      return false;
    var proto = token.prototype;
    switch (lcInterface) {
      case interfaces_1.LifecycleHooks.AfterContentInit:
        return !!proto.ngAfterContentInit;
      case interfaces_1.LifecycleHooks.AfterContentChecked:
        return !!proto.ngAfterContentChecked;
      case interfaces_1.LifecycleHooks.AfterViewInit:
        return !!proto.ngAfterViewInit;
      case interfaces_1.LifecycleHooks.AfterViewChecked:
        return !!proto.ngAfterViewChecked;
      case interfaces_1.LifecycleHooks.OnChanges:
        return !!proto.ngOnChanges;
      case interfaces_1.LifecycleHooks.DoCheck:
        return !!proto.ngDoCheck;
      case interfaces_1.LifecycleHooks.OnDestroy:
        return !!proto.ngOnDestroy;
      case interfaces_1.LifecycleHooks.OnInit:
        return !!proto.ngOnInit;
      default:
        return false;
    }
  }
  exports.hasLifecycleHook = hasLifecycleHook;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/schema/dom_element_schema_registry", ["angular2/src/core/di", "angular2/src/facade/lang", "angular2/src/facade/collection", "angular2/src/platform/dom/dom_adapter", "angular2/src/compiler/html_tags", "angular2/src/compiler/schema/element_schema_registry"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var di_1 = require("angular2/src/core/di");
  var lang_1 = require("angular2/src/facade/lang");
  var collection_1 = require("angular2/src/facade/collection");
  var dom_adapter_1 = require("angular2/src/platform/dom/dom_adapter");
  var html_tags_1 = require("angular2/src/compiler/html_tags");
  var element_schema_registry_1 = require("angular2/src/compiler/schema/element_schema_registry");
  var NAMESPACE_URIS = lang_1.CONST_EXPR({
    'xlink': 'http://www.w3.org/1999/xlink',
    'svg': 'http://www.w3.org/2000/svg'
  });
  var DomElementSchemaRegistry = (function(_super) {
    __extends(DomElementSchemaRegistry, _super);
    function DomElementSchemaRegistry() {
      _super.apply(this, arguments);
      this._protoElements = new Map();
    }
    DomElementSchemaRegistry.prototype._getProtoElement = function(tagName) {
      var element = this._protoElements.get(tagName);
      if (lang_1.isBlank(element)) {
        var nsAndName = html_tags_1.splitNsName(tagName);
        element = lang_1.isPresent(nsAndName[0]) ? dom_adapter_1.DOM.createElementNS(NAMESPACE_URIS[nsAndName[0]], nsAndName[1]) : dom_adapter_1.DOM.createElement(nsAndName[1]);
        this._protoElements.set(tagName, element);
      }
      return element;
    };
    DomElementSchemaRegistry.prototype.hasProperty = function(tagName, propName) {
      if (tagName.indexOf('-') !== -1) {
        return true;
      } else {
        var elm = this._getProtoElement(tagName);
        return dom_adapter_1.DOM.hasProperty(elm, propName);
      }
    };
    DomElementSchemaRegistry.prototype.getMappedPropName = function(propName) {
      var mappedPropName = collection_1.StringMapWrapper.get(dom_adapter_1.DOM.attrToPropMap, propName);
      return lang_1.isPresent(mappedPropName) ? mappedPropName : propName;
    };
    DomElementSchemaRegistry = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [])], DomElementSchemaRegistry);
    return DomElementSchemaRegistry;
  })(element_schema_registry_1.ElementSchemaRegistry);
  exports.DomElementSchemaRegistry = DomElementSchemaRegistry;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/core/angular_entrypoint", ["angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var AngularEntrypoint = (function() {
    function AngularEntrypoint(name) {
      this.name = name;
    }
    AngularEntrypoint = __decorate([lang_1.CONST(), __metadata('design:paramtypes', [String])], AngularEntrypoint);
    return AngularEntrypoint;
  })();
  exports.AngularEntrypoint = AngularEntrypoint;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/pipes/async_pipe", ["angular2/src/facade/lang", "angular2/src/facade/async", "angular2/core", "angular2/src/common/pipes/invalid_pipe_argument_exception"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var async_1 = require("angular2/src/facade/async");
  var core_1 = require("angular2/core");
  var invalid_pipe_argument_exception_1 = require("angular2/src/common/pipes/invalid_pipe_argument_exception");
  var ObservableStrategy = (function() {
    function ObservableStrategy() {}
    ObservableStrategy.prototype.createSubscription = function(async, updateLatestValue) {
      return async_1.ObservableWrapper.subscribe(async, updateLatestValue, function(e) {
        throw e;
      });
    };
    ObservableStrategy.prototype.dispose = function(subscription) {
      async_1.ObservableWrapper.dispose(subscription);
    };
    ObservableStrategy.prototype.onDestroy = function(subscription) {
      async_1.ObservableWrapper.dispose(subscription);
    };
    return ObservableStrategy;
  })();
  var PromiseStrategy = (function() {
    function PromiseStrategy() {}
    PromiseStrategy.prototype.createSubscription = function(async, updateLatestValue) {
      return async.then(updateLatestValue);
    };
    PromiseStrategy.prototype.dispose = function(subscription) {};
    PromiseStrategy.prototype.onDestroy = function(subscription) {};
    return PromiseStrategy;
  })();
  var _promiseStrategy = new PromiseStrategy();
  var _observableStrategy = new ObservableStrategy();
  var __unused;
  var AsyncPipe = (function() {
    function AsyncPipe(_ref) {
      this._latestValue = null;
      this._latestReturnedValue = null;
      this._subscription = null;
      this._obj = null;
      this._strategy = null;
      this._ref = _ref;
    }
    AsyncPipe.prototype.ngOnDestroy = function() {
      if (lang_1.isPresent(this._subscription)) {
        this._dispose();
      }
    };
    AsyncPipe.prototype.transform = function(obj, args) {
      if (lang_1.isBlank(this._obj)) {
        if (lang_1.isPresent(obj)) {
          this._subscribe(obj);
        }
        this._latestReturnedValue = this._latestValue;
        return this._latestValue;
      }
      if (obj !== this._obj) {
        this._dispose();
        return this.transform(obj);
      }
      if (this._latestValue === this._latestReturnedValue) {
        return this._latestReturnedValue;
      } else {
        this._latestReturnedValue = this._latestValue;
        return core_1.WrappedValue.wrap(this._latestValue);
      }
    };
    AsyncPipe.prototype._subscribe = function(obj) {
      var _this = this;
      this._obj = obj;
      this._strategy = this._selectStrategy(obj);
      this._subscription = this._strategy.createSubscription(obj, function(value) {
        return _this._updateLatestValue(obj, value);
      });
    };
    AsyncPipe.prototype._selectStrategy = function(obj) {
      if (lang_1.isPromise(obj)) {
        return _promiseStrategy;
      } else if (async_1.ObservableWrapper.isObservable(obj)) {
        return _observableStrategy;
      } else {
        throw new invalid_pipe_argument_exception_1.InvalidPipeArgumentException(AsyncPipe, obj);
      }
    };
    AsyncPipe.prototype._dispose = function() {
      this._strategy.dispose(this._subscription);
      this._latestValue = null;
      this._latestReturnedValue = null;
      this._subscription = null;
      this._obj = null;
    };
    AsyncPipe.prototype._updateLatestValue = function(async, value) {
      if (async === this._obj) {
        this._latestValue = value;
        this._ref.markForCheck();
      }
    };
    AsyncPipe = __decorate([core_1.Pipe({
      name: 'async',
      pure: false
    }), core_1.Injectable(), __metadata('design:paramtypes', [core_1.ChangeDetectorRef])], AsyncPipe);
    return AsyncPipe;
  })();
  exports.AsyncPipe = AsyncPipe;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/pipes/date_pipe", ["angular2/src/facade/lang", "angular2/src/facade/intl", "angular2/core", "angular2/src/facade/collection", "angular2/src/common/pipes/invalid_pipe_argument_exception"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var intl_1 = require("angular2/src/facade/intl");
  var core_1 = require("angular2/core");
  var collection_1 = require("angular2/src/facade/collection");
  var invalid_pipe_argument_exception_1 = require("angular2/src/common/pipes/invalid_pipe_argument_exception");
  var defaultLocale = 'en-US';
  var DatePipe = (function() {
    function DatePipe() {}
    DatePipe.prototype.transform = function(value, args) {
      if (lang_1.isBlank(value))
        return null;
      if (!this.supports(value)) {
        throw new invalid_pipe_argument_exception_1.InvalidPipeArgumentException(DatePipe, value);
      }
      var pattern = lang_1.isPresent(args) && args.length > 0 ? args[0] : 'mediumDate';
      if (lang_1.isNumber(value)) {
        value = lang_1.DateWrapper.fromMillis(value);
      }
      if (collection_1.StringMapWrapper.contains(DatePipe._ALIASES, pattern)) {
        pattern = collection_1.StringMapWrapper.get(DatePipe._ALIASES, pattern);
      }
      return intl_1.DateFormatter.format(value, defaultLocale, pattern);
    };
    DatePipe.prototype.supports = function(obj) {
      return lang_1.isDate(obj) || lang_1.isNumber(obj);
    };
    DatePipe._ALIASES = {
      'medium': 'yMMMdjms',
      'short': 'yMdjm',
      'fullDate': 'yMMMMEEEEd',
      'longDate': 'yMMMMd',
      'mediumDate': 'yMMMd',
      'shortDate': 'yMd',
      'mediumTime': 'jms',
      'shortTime': 'jm'
    };
    DatePipe = __decorate([lang_1.CONST(), core_1.Pipe({
      name: 'date',
      pure: true
    }), core_1.Injectable(), __metadata('design:paramtypes', [])], DatePipe);
    return DatePipe;
  })();
  exports.DatePipe = DatePipe;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/directives", ["angular2/src/common/directives/ng_class", "angular2/src/common/directives/ng_for", "angular2/src/common/directives/ng_if", "angular2/src/common/directives/ng_style", "angular2/src/common/directives/ng_switch", "angular2/src/common/directives/observable_list_diff", "angular2/src/common/directives/core_directives"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  function __export(m) {
    for (var p in m)
      if (!exports.hasOwnProperty(p))
        exports[p] = m[p];
  }
  var ng_class_1 = require("angular2/src/common/directives/ng_class");
  exports.NgClass = ng_class_1.NgClass;
  var ng_for_1 = require("angular2/src/common/directives/ng_for");
  exports.NgFor = ng_for_1.NgFor;
  var ng_if_1 = require("angular2/src/common/directives/ng_if");
  exports.NgIf = ng_if_1.NgIf;
  var ng_style_1 = require("angular2/src/common/directives/ng_style");
  exports.NgStyle = ng_style_1.NgStyle;
  var ng_switch_1 = require("angular2/src/common/directives/ng_switch");
  exports.NgSwitch = ng_switch_1.NgSwitch;
  exports.NgSwitchWhen = ng_switch_1.NgSwitchWhen;
  exports.NgSwitchDefault = ng_switch_1.NgSwitchDefault;
  __export(require("angular2/src/common/directives/observable_list_diff"));
  var core_directives_1 = require("angular2/src/common/directives/core_directives");
  exports.CORE_DIRECTIVES = core_directives_1.CORE_DIRECTIVES;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/shared", ["angular2/src/facade/collection", "angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/common/forms/validators", "angular2/src/common/forms/directives/default_value_accessor", "angular2/src/common/forms/directives/number_value_accessor", "angular2/src/common/forms/directives/checkbox_value_accessor", "angular2/src/common/forms/directives/select_control_value_accessor", "angular2/src/common/forms/directives/radio_control_value_accessor", "angular2/src/common/forms/directives/normalize_validator"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var collection_1 = require("angular2/src/facade/collection");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var validators_1 = require("angular2/src/common/forms/validators");
  var default_value_accessor_1 = require("angular2/src/common/forms/directives/default_value_accessor");
  var number_value_accessor_1 = require("angular2/src/common/forms/directives/number_value_accessor");
  var checkbox_value_accessor_1 = require("angular2/src/common/forms/directives/checkbox_value_accessor");
  var select_control_value_accessor_1 = require("angular2/src/common/forms/directives/select_control_value_accessor");
  var radio_control_value_accessor_1 = require("angular2/src/common/forms/directives/radio_control_value_accessor");
  var normalize_validator_1 = require("angular2/src/common/forms/directives/normalize_validator");
  function controlPath(name, parent) {
    var p = collection_1.ListWrapper.clone(parent.path);
    p.push(name);
    return p;
  }
  exports.controlPath = controlPath;
  function setUpControl(control, dir) {
    if (lang_1.isBlank(control))
      _throwError(dir, "Cannot find control");
    if (lang_1.isBlank(dir.valueAccessor))
      _throwError(dir, "No value accessor for");
    control.validator = validators_1.Validators.compose([control.validator, dir.validator]);
    control.asyncValidator = validators_1.Validators.composeAsync([control.asyncValidator, dir.asyncValidator]);
    dir.valueAccessor.writeValue(control.value);
    dir.valueAccessor.registerOnChange(function(newValue) {
      dir.viewToModelUpdate(newValue);
      control.updateValue(newValue, {emitModelToViewChange: false});
      control.markAsDirty();
    });
    control.registerOnChange(function(newValue) {
      return dir.valueAccessor.writeValue(newValue);
    });
    dir.valueAccessor.registerOnTouched(function() {
      return control.markAsTouched();
    });
  }
  exports.setUpControl = setUpControl;
  function setUpControlGroup(control, dir) {
    if (lang_1.isBlank(control))
      _throwError(dir, "Cannot find control");
    control.validator = validators_1.Validators.compose([control.validator, dir.validator]);
    control.asyncValidator = validators_1.Validators.composeAsync([control.asyncValidator, dir.asyncValidator]);
  }
  exports.setUpControlGroup = setUpControlGroup;
  function _throwError(dir, message) {
    var path = dir.path.join(" -> ");
    throw new exceptions_1.BaseException(message + " '" + path + "'");
  }
  function composeValidators(validators) {
    return lang_1.isPresent(validators) ? validators_1.Validators.compose(validators.map(normalize_validator_1.normalizeValidator)) : null;
  }
  exports.composeValidators = composeValidators;
  function composeAsyncValidators(validators) {
    return lang_1.isPresent(validators) ? validators_1.Validators.composeAsync(validators.map(normalize_validator_1.normalizeValidator)) : null;
  }
  exports.composeAsyncValidators = composeAsyncValidators;
  function isPropertyUpdated(changes, viewModel) {
    if (!collection_1.StringMapWrapper.contains(changes, "model"))
      return false;
    var change = changes["model"];
    if (change.isFirstChange())
      return true;
    return !lang_1.looseIdentical(viewModel, change.currentValue);
  }
  exports.isPropertyUpdated = isPropertyUpdated;
  function selectValueAccessor(dir, valueAccessors) {
    if (lang_1.isBlank(valueAccessors))
      return null;
    var defaultAccessor;
    var builtinAccessor;
    var customAccessor;
    valueAccessors.forEach(function(v) {
      if (lang_1.hasConstructor(v, default_value_accessor_1.DefaultValueAccessor)) {
        defaultAccessor = v;
      } else if (lang_1.hasConstructor(v, checkbox_value_accessor_1.CheckboxControlValueAccessor) || lang_1.hasConstructor(v, number_value_accessor_1.NumberValueAccessor) || lang_1.hasConstructor(v, select_control_value_accessor_1.SelectControlValueAccessor) || lang_1.hasConstructor(v, radio_control_value_accessor_1.RadioControlValueAccessor)) {
        if (lang_1.isPresent(builtinAccessor))
          _throwError(dir, "More than one built-in value accessor matches");
        builtinAccessor = v;
      } else {
        if (lang_1.isPresent(customAccessor))
          _throwError(dir, "More than one custom value accessor matches");
        customAccessor = v;
      }
    });
    if (lang_1.isPresent(customAccessor))
      return customAccessor;
    if (lang_1.isPresent(builtinAccessor))
      return builtinAccessor;
    if (lang_1.isPresent(defaultAccessor))
      return defaultAccessor;
    _throwError(dir, "No valid value accessor for");
    return null;
  }
  exports.selectValueAccessor = selectValueAccessor;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives", ["angular2/src/facade/lang", "angular2/src/common/forms/directives/ng_control_name", "angular2/src/common/forms/directives/ng_form_control", "angular2/src/common/forms/directives/ng_model", "angular2/src/common/forms/directives/ng_control_group", "angular2/src/common/forms/directives/ng_form_model", "angular2/src/common/forms/directives/ng_form", "angular2/src/common/forms/directives/default_value_accessor", "angular2/src/common/forms/directives/checkbox_value_accessor", "angular2/src/common/forms/directives/number_value_accessor", "angular2/src/common/forms/directives/radio_control_value_accessor", "angular2/src/common/forms/directives/ng_control_status", "angular2/src/common/forms/directives/select_control_value_accessor", "angular2/src/common/forms/directives/validators", "angular2/src/common/forms/directives/ng_control_name", "angular2/src/common/forms/directives/ng_form_control", "angular2/src/common/forms/directives/ng_model", "angular2/src/common/forms/directives/ng_control_group", "angular2/src/common/forms/directives/ng_form_model", "angular2/src/common/forms/directives/ng_form", "angular2/src/common/forms/directives/default_value_accessor", "angular2/src/common/forms/directives/checkbox_value_accessor", "angular2/src/common/forms/directives/radio_control_value_accessor", "angular2/src/common/forms/directives/number_value_accessor", "angular2/src/common/forms/directives/ng_control_status", "angular2/src/common/forms/directives/select_control_value_accessor", "angular2/src/common/forms/directives/validators", "angular2/src/common/forms/directives/ng_control"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var ng_control_name_1 = require("angular2/src/common/forms/directives/ng_control_name");
  var ng_form_control_1 = require("angular2/src/common/forms/directives/ng_form_control");
  var ng_model_1 = require("angular2/src/common/forms/directives/ng_model");
  var ng_control_group_1 = require("angular2/src/common/forms/directives/ng_control_group");
  var ng_form_model_1 = require("angular2/src/common/forms/directives/ng_form_model");
  var ng_form_1 = require("angular2/src/common/forms/directives/ng_form");
  var default_value_accessor_1 = require("angular2/src/common/forms/directives/default_value_accessor");
  var checkbox_value_accessor_1 = require("angular2/src/common/forms/directives/checkbox_value_accessor");
  var number_value_accessor_1 = require("angular2/src/common/forms/directives/number_value_accessor");
  var radio_control_value_accessor_1 = require("angular2/src/common/forms/directives/radio_control_value_accessor");
  var ng_control_status_1 = require("angular2/src/common/forms/directives/ng_control_status");
  var select_control_value_accessor_1 = require("angular2/src/common/forms/directives/select_control_value_accessor");
  var validators_1 = require("angular2/src/common/forms/directives/validators");
  var ng_control_name_2 = require("angular2/src/common/forms/directives/ng_control_name");
  exports.NgControlName = ng_control_name_2.NgControlName;
  var ng_form_control_2 = require("angular2/src/common/forms/directives/ng_form_control");
  exports.NgFormControl = ng_form_control_2.NgFormControl;
  var ng_model_2 = require("angular2/src/common/forms/directives/ng_model");
  exports.NgModel = ng_model_2.NgModel;
  var ng_control_group_2 = require("angular2/src/common/forms/directives/ng_control_group");
  exports.NgControlGroup = ng_control_group_2.NgControlGroup;
  var ng_form_model_2 = require("angular2/src/common/forms/directives/ng_form_model");
  exports.NgFormModel = ng_form_model_2.NgFormModel;
  var ng_form_2 = require("angular2/src/common/forms/directives/ng_form");
  exports.NgForm = ng_form_2.NgForm;
  var default_value_accessor_2 = require("angular2/src/common/forms/directives/default_value_accessor");
  exports.DefaultValueAccessor = default_value_accessor_2.DefaultValueAccessor;
  var checkbox_value_accessor_2 = require("angular2/src/common/forms/directives/checkbox_value_accessor");
  exports.CheckboxControlValueAccessor = checkbox_value_accessor_2.CheckboxControlValueAccessor;
  var radio_control_value_accessor_2 = require("angular2/src/common/forms/directives/radio_control_value_accessor");
  exports.RadioControlValueAccessor = radio_control_value_accessor_2.RadioControlValueAccessor;
  exports.RadioButtonState = radio_control_value_accessor_2.RadioButtonState;
  var number_value_accessor_2 = require("angular2/src/common/forms/directives/number_value_accessor");
  exports.NumberValueAccessor = number_value_accessor_2.NumberValueAccessor;
  var ng_control_status_2 = require("angular2/src/common/forms/directives/ng_control_status");
  exports.NgControlStatus = ng_control_status_2.NgControlStatus;
  var select_control_value_accessor_2 = require("angular2/src/common/forms/directives/select_control_value_accessor");
  exports.SelectControlValueAccessor = select_control_value_accessor_2.SelectControlValueAccessor;
  exports.NgSelectOption = select_control_value_accessor_2.NgSelectOption;
  var validators_2 = require("angular2/src/common/forms/directives/validators");
  exports.RequiredValidator = validators_2.RequiredValidator;
  exports.MinLengthValidator = validators_2.MinLengthValidator;
  exports.MaxLengthValidator = validators_2.MaxLengthValidator;
  var ng_control_1 = require("angular2/src/common/forms/directives/ng_control");
  exports.NgControl = ng_control_1.NgControl;
  exports.FORM_DIRECTIVES = lang_1.CONST_EXPR([ng_control_name_1.NgControlName, ng_control_group_1.NgControlGroup, ng_form_control_1.NgFormControl, ng_model_1.NgModel, ng_form_model_1.NgFormModel, ng_form_1.NgForm, select_control_value_accessor_1.NgSelectOption, default_value_accessor_1.DefaultValueAccessor, number_value_accessor_1.NumberValueAccessor, checkbox_value_accessor_1.CheckboxControlValueAccessor, select_control_value_accessor_1.SelectControlValueAccessor, radio_control_value_accessor_1.RadioControlValueAccessor, ng_control_status_1.NgControlStatus, validators_1.RequiredValidator, validators_1.MinLengthValidator, validators_1.MaxLengthValidator]);
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/dom/events/hammer_gestures", ["angular2/src/platform/dom/events/hammer_common", "angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/core/di"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var hammer_common_1 = require("angular2/src/platform/dom/events/hammer_common");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var di_1 = require("angular2/src/core/di");
  var HammerGesturesPlugin = (function(_super) {
    __extends(HammerGesturesPlugin, _super);
    function HammerGesturesPlugin() {
      _super.apply(this, arguments);
    }
    HammerGesturesPlugin.prototype.supports = function(eventName) {
      if (!_super.prototype.supports.call(this, eventName))
        return false;
      if (!lang_1.isPresent(window['Hammer'])) {
        throw new exceptions_1.BaseException("Hammer.js is not loaded, can not bind " + eventName + " event");
      }
      return true;
    };
    HammerGesturesPlugin.prototype.addEventListener = function(element, eventName, handler) {
      var zone = this.manager.getZone();
      eventName = eventName.toLowerCase();
      return zone.runOutsideAngular(function() {
        var mc = new Hammer(element);
        mc.get('pinch').set({enable: true});
        mc.get('rotate').set({enable: true});
        var handler = function(eventObj) {
          zone.run(function() {
            handler(eventObj);
          });
        };
        mc.on(eventName, handler);
        return function() {
          mc.off(eventName, handler);
        };
      });
    };
    HammerGesturesPlugin = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [])], HammerGesturesPlugin);
    return HammerGesturesPlugin;
  })(hammer_common_1.HammerGesturesPluginCommon);
  exports.HammerGesturesPlugin = HammerGesturesPlugin;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/browser/xhr_impl", ["angular2/src/facade/promise", "angular2/src/facade/lang", "angular2/src/compiler/xhr"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var promise_1 = require("angular2/src/facade/promise");
  var lang_1 = require("angular2/src/facade/lang");
  var xhr_1 = require("angular2/src/compiler/xhr");
  var XHRImpl = (function(_super) {
    __extends(XHRImpl, _super);
    function XHRImpl() {
      _super.apply(this, arguments);
    }
    XHRImpl.prototype.get = function(url) {
      var completer = promise_1.PromiseWrapper.completer();
      var xhr = new XMLHttpRequest();
      xhr.open('GET', url, true);
      xhr.responseType = 'text';
      xhr.onload = function() {
        var response = lang_1.isPresent(xhr.response) ? xhr.response : xhr.responseText;
        var status = xhr.status === 1223 ? 204 : xhr.status;
        if (status === 0) {
          status = response ? 200 : 0;
        }
        if (200 <= status && status <= 300) {
          completer.resolve(response);
        } else {
          completer.reject("Failed to load " + url, null);
        }
      };
      xhr.onerror = function() {
        completer.reject("Failed to load " + url, null);
      };
      xhr.send();
      return completer.promise;
    };
    return XHRImpl;
  })(xhr_1.XHR);
  exports.XHRImpl = XHRImpl;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/browser/tools/common_tools", ["angular2/src/core/application_ref", "angular2/src/facade/lang", "angular2/src/facade/browser", "angular2/src/platform/dom/dom_adapter"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var application_ref_1 = require("angular2/src/core/application_ref");
  var lang_1 = require("angular2/src/facade/lang");
  var browser_1 = require("angular2/src/facade/browser");
  var dom_adapter_1 = require("angular2/src/platform/dom/dom_adapter");
  var AngularTools = (function() {
    function AngularTools(ref) {
      this.profiler = new AngularProfiler(ref);
    }
    return AngularTools;
  })();
  exports.AngularTools = AngularTools;
  var AngularProfiler = (function() {
    function AngularProfiler(ref) {
      this.appRef = ref.injector.get(application_ref_1.ApplicationRef);
    }
    AngularProfiler.prototype.timeChangeDetection = function(config) {
      var record = lang_1.isPresent(config) && config['record'];
      var profileName = 'Change Detection';
      var isProfilerAvailable = lang_1.isPresent(browser_1.window.console.profile);
      if (record && isProfilerAvailable) {
        browser_1.window.console.profile(profileName);
      }
      var start = dom_adapter_1.DOM.performanceNow();
      var numTicks = 0;
      while (numTicks < 5 || (dom_adapter_1.DOM.performanceNow() - start) < 500) {
        this.appRef.tick();
        numTicks++;
      }
      var end = dom_adapter_1.DOM.performanceNow();
      if (record && isProfilerAvailable) {
        browser_1.window.console.profileEnd(profileName);
      }
      var msPerTick = (end - start) / numTicks;
      browser_1.window.console.log("ran " + numTicks + " change detection cycles");
      browser_1.window.console.log(lang_1.NumberWrapper.toFixed(msPerTick, 2) + " ms per check");
    };
    return AngularProfiler;
  })();
  exports.AngularProfiler = AngularProfiler;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/directive_metadata", ["angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/facade/collection", "angular2/src/core/change_detection/change_detection", "angular2/src/core/metadata/view", "angular2/src/compiler/selector", "angular2/src/compiler/util", "angular2/src/core/linker/interfaces"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var collection_1 = require("angular2/src/facade/collection");
  var change_detection_1 = require("angular2/src/core/change_detection/change_detection");
  var view_1 = require("angular2/src/core/metadata/view");
  var selector_1 = require("angular2/src/compiler/selector");
  var util_1 = require("angular2/src/compiler/util");
  var interfaces_1 = require("angular2/src/core/linker/interfaces");
  var HOST_REG_EXP = /^(?:(?:\[([^\]]+)\])|(?:\(([^\)]+)\)))$/g;
  var CompileMetadataWithType = (function() {
    function CompileMetadataWithType() {}
    CompileMetadataWithType.fromJson = function(data) {
      return _COMPILE_METADATA_FROM_JSON[data['class']](data);
    };
    Object.defineProperty(CompileMetadataWithType.prototype, "type", {
      get: function() {
        return exceptions_1.unimplemented();
      },
      enumerable: true,
      configurable: true
    });
    return CompileMetadataWithType;
  })();
  exports.CompileMetadataWithType = CompileMetadataWithType;
  var CompileTypeMetadata = (function() {
    function CompileTypeMetadata(_a) {
      var _b = _a === void 0 ? {} : _a,
          runtime = _b.runtime,
          name = _b.name,
          moduleUrl = _b.moduleUrl,
          isHost = _b.isHost;
      this.runtime = runtime;
      this.name = name;
      this.moduleUrl = moduleUrl;
      this.isHost = lang_1.normalizeBool(isHost);
    }
    CompileTypeMetadata.fromJson = function(data) {
      return new CompileTypeMetadata({
        name: data['name'],
        moduleUrl: data['moduleUrl'],
        isHost: data['isHost']
      });
    };
    CompileTypeMetadata.prototype.toJson = function() {
      return {
        'name': this.name,
        'moduleUrl': this.moduleUrl,
        'isHost': this.isHost
      };
    };
    return CompileTypeMetadata;
  })();
  exports.CompileTypeMetadata = CompileTypeMetadata;
  var CompileTemplateMetadata = (function() {
    function CompileTemplateMetadata(_a) {
      var _b = _a === void 0 ? {} : _a,
          encapsulation = _b.encapsulation,
          template = _b.template,
          templateUrl = _b.templateUrl,
          styles = _b.styles,
          styleUrls = _b.styleUrls,
          ngContentSelectors = _b.ngContentSelectors;
      this.encapsulation = lang_1.isPresent(encapsulation) ? encapsulation : view_1.ViewEncapsulation.Emulated;
      this.template = template;
      this.templateUrl = templateUrl;
      this.styles = lang_1.isPresent(styles) ? styles : [];
      this.styleUrls = lang_1.isPresent(styleUrls) ? styleUrls : [];
      this.ngContentSelectors = lang_1.isPresent(ngContentSelectors) ? ngContentSelectors : [];
    }
    CompileTemplateMetadata.fromJson = function(data) {
      return new CompileTemplateMetadata({
        encapsulation: lang_1.isPresent(data['encapsulation']) ? view_1.VIEW_ENCAPSULATION_VALUES[data['encapsulation']] : data['encapsulation'],
        template: data['template'],
        templateUrl: data['templateUrl'],
        styles: data['styles'],
        styleUrls: data['styleUrls'],
        ngContentSelectors: data['ngContentSelectors']
      });
    };
    CompileTemplateMetadata.prototype.toJson = function() {
      return {
        'encapsulation': lang_1.isPresent(this.encapsulation) ? lang_1.serializeEnum(this.encapsulation) : this.encapsulation,
        'template': this.template,
        'templateUrl': this.templateUrl,
        'styles': this.styles,
        'styleUrls': this.styleUrls,
        'ngContentSelectors': this.ngContentSelectors
      };
    };
    return CompileTemplateMetadata;
  })();
  exports.CompileTemplateMetadata = CompileTemplateMetadata;
  var CompileDirectiveMetadata = (function() {
    function CompileDirectiveMetadata(_a) {
      var _b = _a === void 0 ? {} : _a,
          type = _b.type,
          isComponent = _b.isComponent,
          dynamicLoadable = _b.dynamicLoadable,
          selector = _b.selector,
          exportAs = _b.exportAs,
          changeDetection = _b.changeDetection,
          inputs = _b.inputs,
          outputs = _b.outputs,
          hostListeners = _b.hostListeners,
          hostProperties = _b.hostProperties,
          hostAttributes = _b.hostAttributes,
          lifecycleHooks = _b.lifecycleHooks,
          template = _b.template;
      this.type = type;
      this.isComponent = isComponent;
      this.dynamicLoadable = dynamicLoadable;
      this.selector = selector;
      this.exportAs = exportAs;
      this.changeDetection = changeDetection;
      this.inputs = inputs;
      this.outputs = outputs;
      this.hostListeners = hostListeners;
      this.hostProperties = hostProperties;
      this.hostAttributes = hostAttributes;
      this.lifecycleHooks = lifecycleHooks;
      this.template = template;
    }
    CompileDirectiveMetadata.create = function(_a) {
      var _b = _a === void 0 ? {} : _a,
          type = _b.type,
          isComponent = _b.isComponent,
          dynamicLoadable = _b.dynamicLoadable,
          selector = _b.selector,
          exportAs = _b.exportAs,
          changeDetection = _b.changeDetection,
          inputs = _b.inputs,
          outputs = _b.outputs,
          host = _b.host,
          lifecycleHooks = _b.lifecycleHooks,
          template = _b.template;
      var hostListeners = {};
      var hostProperties = {};
      var hostAttributes = {};
      if (lang_1.isPresent(host)) {
        collection_1.StringMapWrapper.forEach(host, function(value, key) {
          var matches = lang_1.RegExpWrapper.firstMatch(HOST_REG_EXP, key);
          if (lang_1.isBlank(matches)) {
            hostAttributes[key] = value;
          } else if (lang_1.isPresent(matches[1])) {
            hostProperties[matches[1]] = value;
          } else if (lang_1.isPresent(matches[2])) {
            hostListeners[matches[2]] = value;
          }
        });
      }
      var inputsMap = {};
      if (lang_1.isPresent(inputs)) {
        inputs.forEach(function(bindConfig) {
          var parts = util_1.splitAtColon(bindConfig, [bindConfig, bindConfig]);
          inputsMap[parts[0]] = parts[1];
        });
      }
      var outputsMap = {};
      if (lang_1.isPresent(outputs)) {
        outputs.forEach(function(bindConfig) {
          var parts = util_1.splitAtColon(bindConfig, [bindConfig, bindConfig]);
          outputsMap[parts[0]] = parts[1];
        });
      }
      return new CompileDirectiveMetadata({
        type: type,
        isComponent: lang_1.normalizeBool(isComponent),
        dynamicLoadable: lang_1.normalizeBool(dynamicLoadable),
        selector: selector,
        exportAs: exportAs,
        changeDetection: changeDetection,
        inputs: inputsMap,
        outputs: outputsMap,
        hostListeners: hostListeners,
        hostProperties: hostProperties,
        hostAttributes: hostAttributes,
        lifecycleHooks: lang_1.isPresent(lifecycleHooks) ? lifecycleHooks : [],
        template: template
      });
    };
    CompileDirectiveMetadata.fromJson = function(data) {
      return new CompileDirectiveMetadata({
        isComponent: data['isComponent'],
        dynamicLoadable: data['dynamicLoadable'],
        selector: data['selector'],
        exportAs: data['exportAs'],
        type: lang_1.isPresent(data['type']) ? CompileTypeMetadata.fromJson(data['type']) : data['type'],
        changeDetection: lang_1.isPresent(data['changeDetection']) ? change_detection_1.CHANGE_DETECTION_STRATEGY_VALUES[data['changeDetection']] : data['changeDetection'],
        inputs: data['inputs'],
        outputs: data['outputs'],
        hostListeners: data['hostListeners'],
        hostProperties: data['hostProperties'],
        hostAttributes: data['hostAttributes'],
        lifecycleHooks: data['lifecycleHooks'].map(function(hookValue) {
          return interfaces_1.LIFECYCLE_HOOKS_VALUES[hookValue];
        }),
        template: lang_1.isPresent(data['template']) ? CompileTemplateMetadata.fromJson(data['template']) : data['template']
      });
    };
    CompileDirectiveMetadata.prototype.toJson = function() {
      return {
        'class': 'Directive',
        'isComponent': this.isComponent,
        'dynamicLoadable': this.dynamicLoadable,
        'selector': this.selector,
        'exportAs': this.exportAs,
        'type': lang_1.isPresent(this.type) ? this.type.toJson() : this.type,
        'changeDetection': lang_1.isPresent(this.changeDetection) ? lang_1.serializeEnum(this.changeDetection) : this.changeDetection,
        'inputs': this.inputs,
        'outputs': this.outputs,
        'hostListeners': this.hostListeners,
        'hostProperties': this.hostProperties,
        'hostAttributes': this.hostAttributes,
        'lifecycleHooks': this.lifecycleHooks.map(function(hook) {
          return lang_1.serializeEnum(hook);
        }),
        'template': lang_1.isPresent(this.template) ? this.template.toJson() : this.template
      };
    };
    return CompileDirectiveMetadata;
  })();
  exports.CompileDirectiveMetadata = CompileDirectiveMetadata;
  function createHostComponentMeta(componentType, componentSelector) {
    var template = selector_1.CssSelector.parse(componentSelector)[0].getMatchingElementTemplate();
    return CompileDirectiveMetadata.create({
      type: new CompileTypeMetadata({
        runtime: Object,
        name: "Host" + componentType.name,
        moduleUrl: componentType.moduleUrl,
        isHost: true
      }),
      template: new CompileTemplateMetadata({
        template: template,
        templateUrl: '',
        styles: [],
        styleUrls: [],
        ngContentSelectors: []
      }),
      changeDetection: change_detection_1.ChangeDetectionStrategy.Default,
      inputs: [],
      outputs: [],
      host: {},
      lifecycleHooks: [],
      isComponent: true,
      dynamicLoadable: false,
      selector: '*'
    });
  }
  exports.createHostComponentMeta = createHostComponentMeta;
  var CompilePipeMetadata = (function() {
    function CompilePipeMetadata(_a) {
      var _b = _a === void 0 ? {} : _a,
          type = _b.type,
          name = _b.name,
          pure = _b.pure;
      this.type = type;
      this.name = name;
      this.pure = lang_1.normalizeBool(pure);
    }
    CompilePipeMetadata.fromJson = function(data) {
      return new CompilePipeMetadata({
        type: lang_1.isPresent(data['type']) ? CompileTypeMetadata.fromJson(data['type']) : data['type'],
        name: data['name'],
        pure: data['pure']
      });
    };
    CompilePipeMetadata.prototype.toJson = function() {
      return {
        'class': 'Pipe',
        'type': lang_1.isPresent(this.type) ? this.type.toJson() : null,
        'name': this.name,
        'pure': this.pure
      };
    };
    return CompilePipeMetadata;
  })();
  exports.CompilePipeMetadata = CompilePipeMetadata;
  var _COMPILE_METADATA_FROM_JSON = {
    'Directive': CompileDirectiveMetadata.fromJson,
    'Pipe': CompilePipeMetadata.fromJson
  };
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/change_detector_compiler", ["angular2/src/compiler/source_module", "angular2/src/core/change_detection/change_detection_jit_generator", "angular2/src/core/change_detection/abstract_change_detector", "angular2/src/core/change_detection/change_detection_util", "angular2/src/core/change_detection/constants", "angular2/src/compiler/change_definition_factory", "angular2/src/facade/lang", "angular2/src/core/change_detection/change_detection", "angular2/src/transform/template_compiler/change_detector_codegen", "angular2/src/compiler/util", "angular2/src/core/di"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var source_module_1 = require("angular2/src/compiler/source_module");
  var change_detection_jit_generator_1 = require("angular2/src/core/change_detection/change_detection_jit_generator");
  var abstract_change_detector_1 = require("angular2/src/core/change_detection/abstract_change_detector");
  var change_detection_util_1 = require("angular2/src/core/change_detection/change_detection_util");
  var constants_1 = require("angular2/src/core/change_detection/constants");
  var change_definition_factory_1 = require("angular2/src/compiler/change_definition_factory");
  var lang_1 = require("angular2/src/facade/lang");
  var change_detection_1 = require("angular2/src/core/change_detection/change_detection");
  var change_detector_codegen_1 = require("angular2/src/transform/template_compiler/change_detector_codegen");
  var util_1 = require("angular2/src/compiler/util");
  var di_1 = require("angular2/src/core/di");
  var ABSTRACT_CHANGE_DETECTOR = "AbstractChangeDetector";
  var UTIL = "ChangeDetectionUtil";
  var CHANGE_DETECTOR_STATE = "ChangeDetectorState";
  exports.CHANGE_DETECTION_JIT_IMPORTS = lang_1.CONST_EXPR({
    'AbstractChangeDetector': abstract_change_detector_1.AbstractChangeDetector,
    'ChangeDetectionUtil': change_detection_util_1.ChangeDetectionUtil,
    'ChangeDetectorState': constants_1.ChangeDetectorState
  });
  var ABSTRACT_CHANGE_DETECTOR_MODULE = source_module_1.moduleRef("package:angular2/src/core/change_detection/abstract_change_detector" + util_1.MODULE_SUFFIX);
  var UTIL_MODULE = source_module_1.moduleRef("package:angular2/src/core/change_detection/change_detection_util" + util_1.MODULE_SUFFIX);
  var PREGEN_PROTO_CHANGE_DETECTOR_MODULE = source_module_1.moduleRef("package:angular2/src/core/change_detection/pregen_proto_change_detector" + util_1.MODULE_SUFFIX);
  var CONSTANTS_MODULE = source_module_1.moduleRef("package:angular2/src/core/change_detection/constants" + util_1.MODULE_SUFFIX);
  var ChangeDetectionCompiler = (function() {
    function ChangeDetectionCompiler(_genConfig) {
      this._genConfig = _genConfig;
    }
    ChangeDetectionCompiler.prototype.compileComponentRuntime = function(componentType, strategy, parsedTemplate) {
      var _this = this;
      var changeDetectorDefinitions = change_definition_factory_1.createChangeDetectorDefinitions(componentType, strategy, this._genConfig, parsedTemplate);
      return changeDetectorDefinitions.map(function(definition) {
        return _this._createChangeDetectorFactory(definition);
      });
    };
    ChangeDetectionCompiler.prototype._createChangeDetectorFactory = function(definition) {
      var proto = new change_detection_1.DynamicProtoChangeDetector(definition);
      return function() {
        return proto.instantiate();
      };
    };
    ChangeDetectionCompiler.prototype.compileComponentCodeGen = function(componentType, strategy, parsedTemplate) {
      var changeDetectorDefinitions = change_definition_factory_1.createChangeDetectorDefinitions(componentType, strategy, this._genConfig, parsedTemplate);
      var factories = [];
      var index = 0;
      var sourceParts = changeDetectorDefinitions.map(function(definition) {
        var codegen;
        var sourcePart;
        if (lang_1.IS_DART) {
          codegen = new change_detector_codegen_1.Codegen(PREGEN_PROTO_CHANGE_DETECTOR_MODULE);
          var className = "_" + definition.id;
          var typeRef = (index === 0 && componentType.isHost) ? 'dynamic' : "" + source_module_1.moduleRef(componentType.moduleUrl) + componentType.name;
          codegen.generate(typeRef, className, definition);
          factories.push(className + ".newChangeDetector");
          sourcePart = codegen.toString();
        } else {
          codegen = new change_detection_jit_generator_1.ChangeDetectorJITGenerator(definition, "" + UTIL_MODULE + UTIL, "" + ABSTRACT_CHANGE_DETECTOR_MODULE + ABSTRACT_CHANGE_DETECTOR, "" + CONSTANTS_MODULE + CHANGE_DETECTOR_STATE);
          factories.push("function() { return new " + codegen.typeName + "(); }");
          sourcePart = codegen.generateSource();
        }
        index++;
        return sourcePart;
      });
      return new source_module_1.SourceExpressions(sourceParts, factories);
    };
    ChangeDetectionCompiler = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [change_detection_1.ChangeDetectorGenConfig])], ChangeDetectionCompiler);
    return ChangeDetectionCompiler;
  })();
  exports.ChangeDetectionCompiler = ChangeDetectionCompiler;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/style_compiler", ["angular2/src/compiler/source_module", "angular2/src/core/metadata/view", "angular2/src/compiler/xhr", "angular2/src/facade/lang", "angular2/src/facade/async", "angular2/src/compiler/shadow_css", "angular2/src/compiler/url_resolver", "angular2/src/compiler/style_url_resolver", "angular2/src/compiler/util", "angular2/src/core/di"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var source_module_1 = require("angular2/src/compiler/source_module");
  var view_1 = require("angular2/src/core/metadata/view");
  var xhr_1 = require("angular2/src/compiler/xhr");
  var lang_1 = require("angular2/src/facade/lang");
  var async_1 = require("angular2/src/facade/async");
  var shadow_css_1 = require("angular2/src/compiler/shadow_css");
  var url_resolver_1 = require("angular2/src/compiler/url_resolver");
  var style_url_resolver_1 = require("angular2/src/compiler/style_url_resolver");
  var util_1 = require("angular2/src/compiler/util");
  var di_1 = require("angular2/src/core/di");
  var COMPONENT_VARIABLE = '%COMP%';
  var HOST_ATTR = "_nghost-" + COMPONENT_VARIABLE;
  var CONTENT_ATTR = "_ngcontent-" + COMPONENT_VARIABLE;
  var StyleCompiler = (function() {
    function StyleCompiler(_xhr, _urlResolver) {
      this._xhr = _xhr;
      this._urlResolver = _urlResolver;
      this._styleCache = new Map();
      this._shadowCss = new shadow_css_1.ShadowCss();
    }
    StyleCompiler.prototype.compileComponentRuntime = function(template) {
      var styles = template.styles;
      var styleAbsUrls = template.styleUrls;
      return this._loadStyles(styles, styleAbsUrls, template.encapsulation === view_1.ViewEncapsulation.Emulated);
    };
    StyleCompiler.prototype.compileComponentCodeGen = function(template) {
      var shim = template.encapsulation === view_1.ViewEncapsulation.Emulated;
      return this._styleCodeGen(template.styles, template.styleUrls, shim);
    };
    StyleCompiler.prototype.compileStylesheetCodeGen = function(stylesheetUrl, cssText) {
      var styleWithImports = style_url_resolver_1.extractStyleUrls(this._urlResolver, stylesheetUrl, cssText);
      return [this._styleModule(stylesheetUrl, false, this._styleCodeGen([styleWithImports.style], styleWithImports.styleUrls, false)), this._styleModule(stylesheetUrl, true, this._styleCodeGen([styleWithImports.style], styleWithImports.styleUrls, true))];
    };
    StyleCompiler.prototype.clearCache = function() {
      this._styleCache.clear();
    };
    StyleCompiler.prototype._loadStyles = function(plainStyles, absUrls, encapsulate) {
      var _this = this;
      var promises = absUrls.map(function(absUrl) {
        var cacheKey = "" + absUrl + (encapsulate ? '.shim' : '');
        var result = _this._styleCache.get(cacheKey);
        if (lang_1.isBlank(result)) {
          result = _this._xhr.get(absUrl).then(function(style) {
            var styleWithImports = style_url_resolver_1.extractStyleUrls(_this._urlResolver, absUrl, style);
            return _this._loadStyles([styleWithImports.style], styleWithImports.styleUrls, encapsulate);
          });
          _this._styleCache.set(cacheKey, result);
        }
        return result;
      });
      return async_1.PromiseWrapper.all(promises).then(function(nestedStyles) {
        var result = plainStyles.map(function(plainStyle) {
          return _this._shimIfNeeded(plainStyle, encapsulate);
        });
        nestedStyles.forEach(function(styles) {
          return result.push(styles);
        });
        return result;
      });
    };
    StyleCompiler.prototype._styleCodeGen = function(plainStyles, absUrls, shim) {
      var _this = this;
      var arrayPrefix = lang_1.IS_DART ? "const" : '';
      var styleExpressions = plainStyles.map(function(plainStyle) {
        return util_1.escapeSingleQuoteString(_this._shimIfNeeded(plainStyle, shim));
      });
      for (var i = 0; i < absUrls.length; i++) {
        var moduleUrl = this._createModuleUrl(absUrls[i], shim);
        styleExpressions.push(source_module_1.moduleRef(moduleUrl) + "STYLES");
      }
      var expressionSource = arrayPrefix + " [" + styleExpressions.join(',') + "]";
      return new source_module_1.SourceExpression([], expressionSource);
    };
    StyleCompiler.prototype._styleModule = function(stylesheetUrl, shim, expression) {
      var moduleSource = "\n      " + expression.declarations.join('\n') + "\n      " + util_1.codeGenExportVariable('STYLES') + expression.expression + ";\n    ";
      return new source_module_1.SourceModule(this._createModuleUrl(stylesheetUrl, shim), moduleSource);
    };
    StyleCompiler.prototype._shimIfNeeded = function(style, shim) {
      return shim ? this._shadowCss.shimCssText(style, CONTENT_ATTR, HOST_ATTR) : style;
    };
    StyleCompiler.prototype._createModuleUrl = function(stylesheetUrl, shim) {
      return shim ? stylesheetUrl + ".shim" + util_1.MODULE_SUFFIX : "" + stylesheetUrl + util_1.MODULE_SUFFIX;
    };
    StyleCompiler = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [xhr_1.XHR, url_resolver_1.UrlResolver])], StyleCompiler);
    return StyleCompiler;
  })();
  exports.StyleCompiler = StyleCompiler;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/view_compiler", ["angular2/src/facade/lang", "angular2/src/facade/collection", "angular2/src/compiler/template_ast", "angular2/src/compiler/source_module", "angular2/src/core/linker/view", "angular2/src/core/linker/view_type", "angular2/src/core/linker/element", "angular2/src/core/metadata/view", "angular2/src/compiler/util", "angular2/src/core/di", "angular2/src/compiler/proto_view_compiler"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var collection_1 = require("angular2/src/facade/collection");
  var template_ast_1 = require("angular2/src/compiler/template_ast");
  var source_module_1 = require("angular2/src/compiler/source_module");
  var view_1 = require("angular2/src/core/linker/view");
  var view_type_1 = require("angular2/src/core/linker/view_type");
  var element_1 = require("angular2/src/core/linker/element");
  var view_2 = require("angular2/src/core/metadata/view");
  var util_1 = require("angular2/src/compiler/util");
  var di_1 = require("angular2/src/core/di");
  var proto_view_compiler_1 = require("angular2/src/compiler/proto_view_compiler");
  exports.VIEW_JIT_IMPORTS = lang_1.CONST_EXPR({
    'AppView': view_1.AppView,
    'AppElement': element_1.AppElement,
    'flattenNestedViewRenderNodes': view_1.flattenNestedViewRenderNodes,
    'checkSlotCount': view_1.checkSlotCount
  });
  var ViewCompiler = (function() {
    function ViewCompiler() {}
    ViewCompiler.prototype.compileComponentRuntime = function(component, template, styles, protoViews, changeDetectorFactories, componentViewFactory) {
      var viewFactory = new RuntimeViewFactory(component, styles, protoViews, changeDetectorFactories, componentViewFactory);
      return viewFactory.createViewFactory(template, 0, []);
    };
    ViewCompiler.prototype.compileComponentCodeGen = function(component, template, styles, protoViews, changeDetectorFactoryExpressions, componentViewFactory) {
      var viewFactory = new CodeGenViewFactory(component, styles, protoViews, changeDetectorFactoryExpressions, componentViewFactory);
      var targetStatements = [];
      var viewFactoryExpression = viewFactory.createViewFactory(template, 0, targetStatements);
      return new source_module_1.SourceExpression(targetStatements.map(function(stmt) {
        return stmt.statement;
      }), viewFactoryExpression.expression);
    };
    ViewCompiler = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [])], ViewCompiler);
    return ViewCompiler;
  })();
  exports.ViewCompiler = ViewCompiler;
  var CodeGenViewFactory = (function() {
    function CodeGenViewFactory(component, styles, protoViews, changeDetectorExpressions, componentViewFactory) {
      this.component = component;
      this.styles = styles;
      this.protoViews = protoViews;
      this.changeDetectorExpressions = changeDetectorExpressions;
      this.componentViewFactory = componentViewFactory;
      this._nextVarId = 0;
    }
    CodeGenViewFactory.prototype._nextVar = function(prefix) {
      return "" + prefix + this._nextVarId++ + "_" + this.component.type.name;
    };
    CodeGenViewFactory.prototype._nextRenderVar = function() {
      return this._nextVar('render');
    };
    CodeGenViewFactory.prototype._nextAppVar = function() {
      return this._nextVar('app');
    };
    CodeGenViewFactory.prototype._nextDisposableVar = function() {
      return "disposable" + this._nextVarId++ + "_" + this.component.type.name;
    };
    CodeGenViewFactory.prototype.createText = function(renderer, parent, text, targetStatements) {
      var varName = this._nextRenderVar();
      var statement = "var " + varName + " = " + renderer.expression + ".createText(" + (lang_1.isPresent(parent) ? parent.expression : null) + ", " + util_1.escapeSingleQuoteString(text) + ");";
      targetStatements.push(new util_1.Statement(statement));
      return new util_1.Expression(varName);
    };
    CodeGenViewFactory.prototype.createElement = function(renderer, parentRenderNode, name, rootSelector, targetStatements) {
      var varName = this._nextRenderVar();
      var valueExpr;
      if (lang_1.isPresent(rootSelector)) {
        valueExpr = rootSelector.expression + " == null ?\n        " + renderer.expression + ".createElement(" + (lang_1.isPresent(parentRenderNode) ? parentRenderNode.expression : null) + ", " + util_1.escapeSingleQuoteString(name) + ") :\n        " + renderer.expression + ".selectRootElement(" + rootSelector.expression + ");";
      } else {
        valueExpr = renderer.expression + ".createElement(" + (lang_1.isPresent(parentRenderNode) ? parentRenderNode.expression : null) + ", " + util_1.escapeSingleQuoteString(name) + ")";
      }
      var statement = "var " + varName + " = " + valueExpr + ";";
      targetStatements.push(new util_1.Statement(statement));
      return new util_1.Expression(varName);
    };
    CodeGenViewFactory.prototype.createTemplateAnchor = function(renderer, parentRenderNode, targetStatements) {
      var varName = this._nextRenderVar();
      var valueExpr = renderer.expression + ".createTemplateAnchor(" + (lang_1.isPresent(parentRenderNode) ? parentRenderNode.expression : null) + ");";
      targetStatements.push(new util_1.Statement("var " + varName + " = " + valueExpr));
      return new util_1.Expression(varName);
    };
    CodeGenViewFactory.prototype.createGlobalEventListener = function(renderer, appView, boundElementIndex, eventAst, targetStatements) {
      var disposableVar = this._nextDisposableVar();
      var eventHandlerExpr = codeGenEventHandler(appView, boundElementIndex, eventAst.fullName);
      targetStatements.push(new util_1.Statement("var " + disposableVar + " = " + renderer.expression + ".listenGlobal(" + util_1.escapeValue(eventAst.target) + ", " + util_1.escapeValue(eventAst.name) + ", " + eventHandlerExpr + ");"));
      return new util_1.Expression(disposableVar);
    };
    CodeGenViewFactory.prototype.createElementEventListener = function(renderer, appView, boundElementIndex, renderNode, eventAst, targetStatements) {
      var disposableVar = this._nextDisposableVar();
      var eventHandlerExpr = codeGenEventHandler(appView, boundElementIndex, eventAst.fullName);
      targetStatements.push(new util_1.Statement("var " + disposableVar + " = " + renderer.expression + ".listen(" + renderNode.expression + ", " + util_1.escapeValue(eventAst.name) + ", " + eventHandlerExpr + ");"));
      return new util_1.Expression(disposableVar);
    };
    CodeGenViewFactory.prototype.setElementAttribute = function(renderer, renderNode, attrName, attrValue, targetStatements) {
      targetStatements.push(new util_1.Statement(renderer.expression + ".setElementAttribute(" + renderNode.expression + ", " + util_1.escapeSingleQuoteString(attrName) + ", " + util_1.escapeSingleQuoteString(attrValue) + ");"));
    };
    CodeGenViewFactory.prototype.createAppElement = function(appProtoEl, appView, renderNode, parentAppEl, embeddedViewFactory, targetStatements) {
      var appVar = this._nextAppVar();
      var varValue = "new " + proto_view_compiler_1.APP_EL_MODULE_REF + "AppElement(" + appProtoEl.expression + ", " + appView.expression + ",\n      " + (lang_1.isPresent(parentAppEl) ? parentAppEl.expression : null) + ", " + renderNode.expression + ", " + (lang_1.isPresent(embeddedViewFactory) ? embeddedViewFactory.expression : null) + ")";
      targetStatements.push(new util_1.Statement("var " + appVar + " = " + varValue + ";"));
      return new util_1.Expression(appVar);
    };
    CodeGenViewFactory.prototype.createAndSetComponentView = function(renderer, viewManager, view, appEl, component, contentNodesByNgContentIndex, targetStatements) {
      var codeGenContentNodes;
      if (this.component.type.isHost) {
        codeGenContentNodes = view.expression + ".projectableNodes";
      } else {
        codeGenContentNodes = "[" + contentNodesByNgContentIndex.map(function(nodes) {
          return util_1.codeGenFlatArray(nodes);
        }).join(',') + "]";
      }
      targetStatements.push(new util_1.Statement(this.componentViewFactory(component) + "(" + renderer.expression + ", " + viewManager.expression + ", " + appEl.expression + ", " + codeGenContentNodes + ", null, null, null);"));
    };
    CodeGenViewFactory.prototype.getProjectedNodes = function(projectableNodes, ngContentIndex) {
      return new util_1.Expression(projectableNodes.expression + "[" + ngContentIndex + "]", true);
    };
    CodeGenViewFactory.prototype.appendProjectedNodes = function(renderer, parent, nodes, targetStatements) {
      targetStatements.push(new util_1.Statement(renderer.expression + ".projectNodes(" + parent.expression + ", " + proto_view_compiler_1.APP_VIEW_MODULE_REF + "flattenNestedViewRenderNodes(" + nodes.expression + "));"));
    };
    CodeGenViewFactory.prototype.createViewFactory = function(asts, embeddedTemplateIndex, targetStatements) {
      var compileProtoView = this.protoViews[embeddedTemplateIndex];
      var isHostView = this.component.type.isHost;
      var isComponentView = embeddedTemplateIndex === 0 && !isHostView;
      var visitor = new ViewBuilderVisitor(new util_1.Expression('renderer'), new util_1.Expression('viewManager'), new util_1.Expression('projectableNodes'), isHostView ? new util_1.Expression('rootSelector') : null, new util_1.Expression('view'), compileProtoView, targetStatements, this);
      template_ast_1.templateVisitAll(visitor, asts, new ParentElement(isComponentView ? new util_1.Expression('parentRenderNode') : null, null, null));
      var appProtoView = compileProtoView.protoView.expression;
      var viewFactoryName = codeGenViewFactoryName(this.component, embeddedTemplateIndex);
      var changeDetectorFactory = this.changeDetectorExpressions.expressions[embeddedTemplateIndex];
      var factoryArgs = ['parentRenderer', 'viewManager', 'containerEl', 'projectableNodes', 'rootSelector', 'dynamicallyCreatedProviders', 'rootInjector'];
      var initRendererStmts = [];
      var rendererExpr = "parentRenderer";
      if (embeddedTemplateIndex === 0) {
        var renderCompTypeVar = this._nextVar('renderType');
        targetStatements.push(new util_1.Statement("var " + renderCompTypeVar + " = null;"));
        var stylesVar = this._nextVar('styles');
        targetStatements.push(new util_1.Statement(util_1.CONST_VAR + " " + stylesVar + " = " + this.styles.expression + ";"));
        var encapsulation = this.component.template.encapsulation;
        initRendererStmts.push("if (" + renderCompTypeVar + " == null) {\n        " + renderCompTypeVar + " = viewManager.createRenderComponentType(" + codeGenViewEncapsulation(encapsulation) + ", " + stylesVar + ");\n      }");
        rendererExpr = "parentRenderer.renderComponent(" + renderCompTypeVar + ")";
      }
      var statement = "\n" + util_1.codeGenFnHeader(factoryArgs, viewFactoryName) + "{\n  " + initRendererStmts.join('\n') + "\n  var renderer = " + rendererExpr + ";\n  var view = new " + proto_view_compiler_1.APP_VIEW_MODULE_REF + "AppView(\n    " + appProtoView + ", renderer, viewManager,\n    projectableNodes,\n    containerEl,\n    dynamicallyCreatedProviders, rootInjector,\n    " + changeDetectorFactory + "()\n  );\n  " + proto_view_compiler_1.APP_VIEW_MODULE_REF + "checkSlotCount(" + util_1.escapeValue(this.component.type.name) + ", " + this.component.template.ngContentSelectors.length + ", projectableNodes);\n  " + (isComponentView ? 'var parentRenderNode = renderer.createViewRoot(view.containerAppElement.nativeElement);' : '') + "\n  " + visitor.renderStmts.map(function(stmt) {
        return stmt.statement;
      }).join('\n') + "\n  " + visitor.appStmts.map(function(stmt) {
        return stmt.statement;
      }).join('\n') + "\n\n  view.init(" + util_1.codeGenFlatArray(visitor.rootNodesOrAppElements) + ", " + util_1.codeGenArray(visitor.renderNodes) + ", " + util_1.codeGenArray(visitor.appDisposables) + ",\n            " + util_1.codeGenArray(visitor.appElements) + ");\n  return view;\n}";
      targetStatements.push(new util_1.Statement(statement));
      return new util_1.Expression(viewFactoryName);
    };
    return CodeGenViewFactory;
  })();
  var RuntimeViewFactory = (function() {
    function RuntimeViewFactory(component, styles, protoViews, changeDetectorFactories, componentViewFactory) {
      this.component = component;
      this.styles = styles;
      this.protoViews = protoViews;
      this.changeDetectorFactories = changeDetectorFactories;
      this.componentViewFactory = componentViewFactory;
    }
    RuntimeViewFactory.prototype.createText = function(renderer, parent, text, targetStatements) {
      return renderer.createText(parent, text);
    };
    RuntimeViewFactory.prototype.createElement = function(renderer, parent, name, rootSelector, targetStatements) {
      var el;
      if (lang_1.isPresent(rootSelector)) {
        el = renderer.selectRootElement(rootSelector);
      } else {
        el = renderer.createElement(parent, name);
      }
      return el;
    };
    RuntimeViewFactory.prototype.createTemplateAnchor = function(renderer, parent, targetStatements) {
      return renderer.createTemplateAnchor(parent);
    };
    RuntimeViewFactory.prototype.createGlobalEventListener = function(renderer, appView, boundElementIndex, eventAst, targetStatements) {
      return renderer.listenGlobal(eventAst.target, eventAst.name, function(event) {
        return appView.triggerEventHandlers(eventAst.fullName, event, boundElementIndex);
      });
    };
    RuntimeViewFactory.prototype.createElementEventListener = function(renderer, appView, boundElementIndex, renderNode, eventAst, targetStatements) {
      return renderer.listen(renderNode, eventAst.name, function(event) {
        return appView.triggerEventHandlers(eventAst.fullName, event, boundElementIndex);
      });
    };
    RuntimeViewFactory.prototype.setElementAttribute = function(renderer, renderNode, attrName, attrValue, targetStatements) {
      renderer.setElementAttribute(renderNode, attrName, attrValue);
    };
    RuntimeViewFactory.prototype.createAppElement = function(appProtoEl, appView, renderNode, parentAppEl, embeddedViewFactory, targetStatements) {
      return new element_1.AppElement(appProtoEl, appView, parentAppEl, renderNode, embeddedViewFactory);
    };
    RuntimeViewFactory.prototype.createAndSetComponentView = function(renderer, viewManager, appView, appEl, component, contentNodesByNgContentIndex, targetStatements) {
      var flattenedContentNodes;
      if (this.component.type.isHost) {
        flattenedContentNodes = appView.projectableNodes;
      } else {
        flattenedContentNodes = collection_1.ListWrapper.createFixedSize(contentNodesByNgContentIndex.length);
        for (var i = 0; i < contentNodesByNgContentIndex.length; i++) {
          flattenedContentNodes[i] = util_1.flattenArray(contentNodesByNgContentIndex[i], []);
        }
      }
      this.componentViewFactory(component)(renderer, viewManager, appEl, flattenedContentNodes);
    };
    RuntimeViewFactory.prototype.getProjectedNodes = function(projectableNodes, ngContentIndex) {
      return projectableNodes[ngContentIndex];
    };
    RuntimeViewFactory.prototype.appendProjectedNodes = function(renderer, parent, nodes, targetStatements) {
      renderer.projectNodes(parent, view_1.flattenNestedViewRenderNodes(nodes));
    };
    RuntimeViewFactory.prototype.createViewFactory = function(asts, embeddedTemplateIndex, targetStatements) {
      var _this = this;
      var compileProtoView = this.protoViews[embeddedTemplateIndex];
      var isComponentView = compileProtoView.protoView.type === view_type_1.ViewType.COMPONENT;
      var renderComponentType = null;
      return function(parentRenderer, viewManager, containerEl, projectableNodes, rootSelector, dynamicallyCreatedProviders, rootInjector) {
        if (rootSelector === void 0) {
          rootSelector = null;
        }
        if (dynamicallyCreatedProviders === void 0) {
          dynamicallyCreatedProviders = null;
        }
        if (rootInjector === void 0) {
          rootInjector = null;
        }
        view_1.checkSlotCount(_this.component.type.name, _this.component.template.ngContentSelectors.length, projectableNodes);
        var renderer;
        if (embeddedTemplateIndex === 0) {
          if (lang_1.isBlank(renderComponentType)) {
            renderComponentType = viewManager.createRenderComponentType(_this.component.template.encapsulation, _this.styles);
          }
          renderer = parentRenderer.renderComponent(renderComponentType);
        } else {
          renderer = parentRenderer;
        }
        var changeDetector = _this.changeDetectorFactories[embeddedTemplateIndex]();
        var view = new view_1.AppView(compileProtoView.protoView, renderer, viewManager, projectableNodes, containerEl, dynamicallyCreatedProviders, rootInjector, changeDetector);
        var visitor = new ViewBuilderVisitor(renderer, viewManager, projectableNodes, rootSelector, view, compileProtoView, [], _this);
        var parentRenderNode = isComponentView ? renderer.createViewRoot(containerEl.nativeElement) : null;
        template_ast_1.templateVisitAll(visitor, asts, new ParentElement(parentRenderNode, null, null));
        view.init(util_1.flattenArray(visitor.rootNodesOrAppElements, []), visitor.renderNodes, visitor.appDisposables, visitor.appElements);
        return view;
      };
    };
    return RuntimeViewFactory;
  })();
  var ParentElement = (function() {
    function ParentElement(renderNode, appEl, component) {
      this.renderNode = renderNode;
      this.appEl = appEl;
      this.component = component;
      if (lang_1.isPresent(component)) {
        this.contentNodesByNgContentIndex = collection_1.ListWrapper.createFixedSize(component.template.ngContentSelectors.length);
        for (var i = 0; i < this.contentNodesByNgContentIndex.length; i++) {
          this.contentNodesByNgContentIndex[i] = [];
        }
      } else {
        this.contentNodesByNgContentIndex = null;
      }
    }
    ParentElement.prototype.addContentNode = function(ngContentIndex, nodeExpr) {
      this.contentNodesByNgContentIndex[ngContentIndex].push(nodeExpr);
    };
    return ParentElement;
  })();
  var ViewBuilderVisitor = (function() {
    function ViewBuilderVisitor(renderer, viewManager, projectableNodes, rootSelector, view, protoView, targetStatements, factory) {
      this.renderer = renderer;
      this.viewManager = viewManager;
      this.projectableNodes = projectableNodes;
      this.rootSelector = rootSelector;
      this.view = view;
      this.protoView = protoView;
      this.targetStatements = targetStatements;
      this.factory = factory;
      this.renderStmts = [];
      this.renderNodes = [];
      this.appStmts = [];
      this.appElements = [];
      this.appDisposables = [];
      this.rootNodesOrAppElements = [];
      this.elementCount = 0;
    }
    ViewBuilderVisitor.prototype._addRenderNode = function(renderNode, appEl, ngContentIndex, parent) {
      this.renderNodes.push(renderNode);
      if (lang_1.isPresent(parent.component)) {
        if (lang_1.isPresent(ngContentIndex)) {
          parent.addContentNode(ngContentIndex, lang_1.isPresent(appEl) ? appEl : renderNode);
        }
      } else if (lang_1.isBlank(parent.renderNode)) {
        this.rootNodesOrAppElements.push(lang_1.isPresent(appEl) ? appEl : renderNode);
      }
    };
    ViewBuilderVisitor.prototype._getParentRenderNode = function(ngContentIndex, parent) {
      return lang_1.isPresent(parent.component) && parent.component.template.encapsulation !== view_2.ViewEncapsulation.Native ? null : parent.renderNode;
    };
    ViewBuilderVisitor.prototype.visitBoundText = function(ast, parent) {
      return this._visitText('', ast.ngContentIndex, parent);
    };
    ViewBuilderVisitor.prototype.visitText = function(ast, parent) {
      return this._visitText(ast.value, ast.ngContentIndex, parent);
    };
    ViewBuilderVisitor.prototype._visitText = function(value, ngContentIndex, parent) {
      var renderNode = this.factory.createText(this.renderer, this._getParentRenderNode(ngContentIndex, parent), value, this.renderStmts);
      this._addRenderNode(renderNode, null, ngContentIndex, parent);
      return null;
    };
    ViewBuilderVisitor.prototype.visitNgContent = function(ast, parent) {
      var nodesExpression = this.factory.getProjectedNodes(this.projectableNodes, ast.index);
      if (lang_1.isPresent(parent.component)) {
        if (lang_1.isPresent(ast.ngContentIndex)) {
          parent.addContentNode(ast.ngContentIndex, nodesExpression);
        }
      } else {
        if (lang_1.isPresent(parent.renderNode)) {
          this.factory.appendProjectedNodes(this.renderer, parent.renderNode, nodesExpression, this.renderStmts);
        } else {
          this.rootNodesOrAppElements.push(nodesExpression);
        }
      }
      return null;
    };
    ViewBuilderVisitor.prototype.visitElement = function(ast, parent) {
      var _this = this;
      var renderNode = this.factory.createElement(this.renderer, this._getParentRenderNode(ast.ngContentIndex, parent), ast.name, this.rootSelector, this.renderStmts);
      var component = ast.getComponent();
      var elementIndex = this.elementCount++;
      var protoEl = this.protoView.protoElements[elementIndex];
      protoEl.renderEvents.forEach(function(eventAst) {
        var disposable;
        if (lang_1.isPresent(eventAst.target)) {
          disposable = _this.factory.createGlobalEventListener(_this.renderer, _this.view, protoEl.boundElementIndex, eventAst, _this.renderStmts);
        } else {
          disposable = _this.factory.createElementEventListener(_this.renderer, _this.view, protoEl.boundElementIndex, renderNode, eventAst, _this.renderStmts);
        }
        _this.appDisposables.push(disposable);
      });
      for (var i = 0; i < protoEl.attrNameAndValues.length; i++) {
        var attrName = protoEl.attrNameAndValues[i][0];
        var attrValue = protoEl.attrNameAndValues[i][1];
        this.factory.setElementAttribute(this.renderer, renderNode, attrName, attrValue, this.renderStmts);
      }
      var appEl = null;
      if (lang_1.isPresent(protoEl.appProtoEl)) {
        appEl = this.factory.createAppElement(protoEl.appProtoEl, this.view, renderNode, parent.appEl, null, this.appStmts);
        this.appElements.push(appEl);
      }
      this._addRenderNode(renderNode, appEl, ast.ngContentIndex, parent);
      var newParent = new ParentElement(renderNode, lang_1.isPresent(appEl) ? appEl : parent.appEl, component);
      template_ast_1.templateVisitAll(this, ast.children, newParent);
      if (lang_1.isPresent(appEl) && lang_1.isPresent(component)) {
        this.factory.createAndSetComponentView(this.renderer, this.viewManager, this.view, appEl, component, newParent.contentNodesByNgContentIndex, this.appStmts);
      }
      return null;
    };
    ViewBuilderVisitor.prototype.visitEmbeddedTemplate = function(ast, parent) {
      var renderNode = this.factory.createTemplateAnchor(this.renderer, this._getParentRenderNode(ast.ngContentIndex, parent), this.renderStmts);
      var elementIndex = this.elementCount++;
      var protoEl = this.protoView.protoElements[elementIndex];
      var embeddedViewFactory = this.factory.createViewFactory(ast.children, protoEl.embeddedTemplateIndex, this.targetStatements);
      var appEl = this.factory.createAppElement(protoEl.appProtoEl, this.view, renderNode, parent.appEl, embeddedViewFactory, this.appStmts);
      this._addRenderNode(renderNode, appEl, ast.ngContentIndex, parent);
      this.appElements.push(appEl);
      return null;
    };
    ViewBuilderVisitor.prototype.visitVariable = function(ast, ctx) {
      return null;
    };
    ViewBuilderVisitor.prototype.visitAttr = function(ast, ctx) {
      return null;
    };
    ViewBuilderVisitor.prototype.visitDirective = function(ast, ctx) {
      return null;
    };
    ViewBuilderVisitor.prototype.visitEvent = function(ast, ctx) {
      return null;
    };
    ViewBuilderVisitor.prototype.visitDirectiveProperty = function(ast, context) {
      return null;
    };
    ViewBuilderVisitor.prototype.visitElementProperty = function(ast, context) {
      return null;
    };
    return ViewBuilderVisitor;
  })();
  function codeGenEventHandler(view, boundElementIndex, eventName) {
    return util_1.codeGenValueFn(['event'], view.expression + ".triggerEventHandlers(" + util_1.escapeValue(eventName) + ", event, " + boundElementIndex + ")");
  }
  function codeGenViewFactoryName(component, embeddedTemplateIndex) {
    return "viewFactory_" + component.type.name + embeddedTemplateIndex;
  }
  function codeGenViewEncapsulation(value) {
    if (lang_1.IS_DART) {
      return "" + proto_view_compiler_1.METADATA_MODULE_REF + value;
    } else {
      return "" + value;
    }
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/html_lexer", ["angular2/src/facade/lang", "angular2/src/facade/collection", "angular2/src/compiler/parse_util", "angular2/src/compiler/html_tags"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var lang_1 = require("angular2/src/facade/lang");
  var collection_1 = require("angular2/src/facade/collection");
  var parse_util_1 = require("angular2/src/compiler/parse_util");
  var html_tags_1 = require("angular2/src/compiler/html_tags");
  (function(HtmlTokenType) {
    HtmlTokenType[HtmlTokenType["TAG_OPEN_START"] = 0] = "TAG_OPEN_START";
    HtmlTokenType[HtmlTokenType["TAG_OPEN_END"] = 1] = "TAG_OPEN_END";
    HtmlTokenType[HtmlTokenType["TAG_OPEN_END_VOID"] = 2] = "TAG_OPEN_END_VOID";
    HtmlTokenType[HtmlTokenType["TAG_CLOSE"] = 3] = "TAG_CLOSE";
    HtmlTokenType[HtmlTokenType["TEXT"] = 4] = "TEXT";
    HtmlTokenType[HtmlTokenType["ESCAPABLE_RAW_TEXT"] = 5] = "ESCAPABLE_RAW_TEXT";
    HtmlTokenType[HtmlTokenType["RAW_TEXT"] = 6] = "RAW_TEXT";
    HtmlTokenType[HtmlTokenType["COMMENT_START"] = 7] = "COMMENT_START";
    HtmlTokenType[HtmlTokenType["COMMENT_END"] = 8] = "COMMENT_END";
    HtmlTokenType[HtmlTokenType["CDATA_START"] = 9] = "CDATA_START";
    HtmlTokenType[HtmlTokenType["CDATA_END"] = 10] = "CDATA_END";
    HtmlTokenType[HtmlTokenType["ATTR_NAME"] = 11] = "ATTR_NAME";
    HtmlTokenType[HtmlTokenType["ATTR_VALUE"] = 12] = "ATTR_VALUE";
    HtmlTokenType[HtmlTokenType["DOC_TYPE"] = 13] = "DOC_TYPE";
    HtmlTokenType[HtmlTokenType["EOF"] = 14] = "EOF";
  })(exports.HtmlTokenType || (exports.HtmlTokenType = {}));
  var HtmlTokenType = exports.HtmlTokenType;
  var HtmlToken = (function() {
    function HtmlToken(type, parts, sourceSpan) {
      this.type = type;
      this.parts = parts;
      this.sourceSpan = sourceSpan;
    }
    return HtmlToken;
  })();
  exports.HtmlToken = HtmlToken;
  var HtmlTokenError = (function(_super) {
    __extends(HtmlTokenError, _super);
    function HtmlTokenError(errorMsg, tokenType, location) {
      _super.call(this, location, errorMsg);
      this.tokenType = tokenType;
    }
    return HtmlTokenError;
  })(parse_util_1.ParseError);
  exports.HtmlTokenError = HtmlTokenError;
  var HtmlTokenizeResult = (function() {
    function HtmlTokenizeResult(tokens, errors) {
      this.tokens = tokens;
      this.errors = errors;
    }
    return HtmlTokenizeResult;
  })();
  exports.HtmlTokenizeResult = HtmlTokenizeResult;
  function tokenizeHtml(sourceContent, sourceUrl) {
    return new _HtmlTokenizer(new parse_util_1.ParseSourceFile(sourceContent, sourceUrl)).tokenize();
  }
  exports.tokenizeHtml = tokenizeHtml;
  var $EOF = 0;
  var $TAB = 9;
  var $LF = 10;
  var $FF = 12;
  var $CR = 13;
  var $SPACE = 32;
  var $BANG = 33;
  var $DQ = 34;
  var $HASH = 35;
  var $$ = 36;
  var $AMPERSAND = 38;
  var $SQ = 39;
  var $MINUS = 45;
  var $SLASH = 47;
  var $0 = 48;
  var $SEMICOLON = 59;
  var $9 = 57;
  var $COLON = 58;
  var $LT = 60;
  var $EQ = 61;
  var $GT = 62;
  var $QUESTION = 63;
  var $LBRACKET = 91;
  var $RBRACKET = 93;
  var $A = 65;
  var $F = 70;
  var $X = 88;
  var $Z = 90;
  var $a = 97;
  var $f = 102;
  var $z = 122;
  var $x = 120;
  var $NBSP = 160;
  var CR_OR_CRLF_REGEXP = /\r\n?/g;
  function unexpectedCharacterErrorMsg(charCode) {
    var char = charCode === $EOF ? 'EOF' : lang_1.StringWrapper.fromCharCode(charCode);
    return "Unexpected character \"" + char + "\"";
  }
  function unknownEntityErrorMsg(entitySrc) {
    return "Unknown entity \"" + entitySrc + "\" - use the \"&#<decimal>;\" or  \"&#x<hex>;\" syntax";
  }
  var ControlFlowError = (function() {
    function ControlFlowError(error) {
      this.error = error;
    }
    return ControlFlowError;
  })();
  var _HtmlTokenizer = (function() {
    function _HtmlTokenizer(file) {
      this.file = file;
      this.peek = -1;
      this.index = -1;
      this.line = 0;
      this.column = -1;
      this.tokens = [];
      this.errors = [];
      this.input = file.content;
      this.length = file.content.length;
      this._advance();
    }
    _HtmlTokenizer.prototype._processCarriageReturns = function(content) {
      return lang_1.StringWrapper.replaceAll(content, CR_OR_CRLF_REGEXP, '\n');
    };
    _HtmlTokenizer.prototype.tokenize = function() {
      while (this.peek !== $EOF) {
        var start = this._getLocation();
        try {
          if (this._attemptCharCode($LT)) {
            if (this._attemptCharCode($BANG)) {
              if (this._attemptCharCode($LBRACKET)) {
                this._consumeCdata(start);
              } else if (this._attemptCharCode($MINUS)) {
                this._consumeComment(start);
              } else {
                this._consumeDocType(start);
              }
            } else if (this._attemptCharCode($SLASH)) {
              this._consumeTagClose(start);
            } else {
              this._consumeTagOpen(start);
            }
          } else {
            this._consumeText();
          }
        } catch (e) {
          if (e instanceof ControlFlowError) {
            this.errors.push(e.error);
          } else {
            throw e;
          }
        }
      }
      this._beginToken(HtmlTokenType.EOF);
      this._endToken([]);
      return new HtmlTokenizeResult(mergeTextTokens(this.tokens), this.errors);
    };
    _HtmlTokenizer.prototype._getLocation = function() {
      return new parse_util_1.ParseLocation(this.file, this.index, this.line, this.column);
    };
    _HtmlTokenizer.prototype._beginToken = function(type, start) {
      if (start === void 0) {
        start = null;
      }
      if (lang_1.isBlank(start)) {
        start = this._getLocation();
      }
      this.currentTokenStart = start;
      this.currentTokenType = type;
    };
    _HtmlTokenizer.prototype._endToken = function(parts, end) {
      if (end === void 0) {
        end = null;
      }
      if (lang_1.isBlank(end)) {
        end = this._getLocation();
      }
      var token = new HtmlToken(this.currentTokenType, parts, new parse_util_1.ParseSourceSpan(this.currentTokenStart, end));
      this.tokens.push(token);
      this.currentTokenStart = null;
      this.currentTokenType = null;
      return token;
    };
    _HtmlTokenizer.prototype._createError = function(msg, position) {
      var error = new HtmlTokenError(msg, this.currentTokenType, position);
      this.currentTokenStart = null;
      this.currentTokenType = null;
      return new ControlFlowError(error);
    };
    _HtmlTokenizer.prototype._advance = function() {
      if (this.index >= this.length) {
        throw this._createError(unexpectedCharacterErrorMsg($EOF), this._getLocation());
      }
      if (this.peek === $LF) {
        this.line++;
        this.column = 0;
      } else if (this.peek !== $LF && this.peek !== $CR) {
        this.column++;
      }
      this.index++;
      this.peek = this.index >= this.length ? $EOF : lang_1.StringWrapper.charCodeAt(this.input, this.index);
    };
    _HtmlTokenizer.prototype._attemptCharCode = function(charCode) {
      if (this.peek === charCode) {
        this._advance();
        return true;
      }
      return false;
    };
    _HtmlTokenizer.prototype._attemptCharCodeCaseInsensitive = function(charCode) {
      if (compareCharCodeCaseInsensitive(this.peek, charCode)) {
        this._advance();
        return true;
      }
      return false;
    };
    _HtmlTokenizer.prototype._requireCharCode = function(charCode) {
      var location = this._getLocation();
      if (!this._attemptCharCode(charCode)) {
        throw this._createError(unexpectedCharacterErrorMsg(this.peek), location);
      }
    };
    _HtmlTokenizer.prototype._attemptStr = function(chars) {
      for (var i = 0; i < chars.length; i++) {
        if (!this._attemptCharCode(lang_1.StringWrapper.charCodeAt(chars, i))) {
          return false;
        }
      }
      return true;
    };
    _HtmlTokenizer.prototype._attemptStrCaseInsensitive = function(chars) {
      for (var i = 0; i < chars.length; i++) {
        if (!this._attemptCharCodeCaseInsensitive(lang_1.StringWrapper.charCodeAt(chars, i))) {
          return false;
        }
      }
      return true;
    };
    _HtmlTokenizer.prototype._requireStr = function(chars) {
      var location = this._getLocation();
      if (!this._attemptStr(chars)) {
        throw this._createError(unexpectedCharacterErrorMsg(this.peek), location);
      }
    };
    _HtmlTokenizer.prototype._attemptCharCodeUntilFn = function(predicate) {
      while (!predicate(this.peek)) {
        this._advance();
      }
    };
    _HtmlTokenizer.prototype._requireCharCodeUntilFn = function(predicate, len) {
      var start = this._getLocation();
      this._attemptCharCodeUntilFn(predicate);
      if (this.index - start.offset < len) {
        throw this._createError(unexpectedCharacterErrorMsg(this.peek), start);
      }
    };
    _HtmlTokenizer.prototype._attemptUntilChar = function(char) {
      while (this.peek !== char) {
        this._advance();
      }
    };
    _HtmlTokenizer.prototype._readChar = function(decodeEntities) {
      if (decodeEntities && this.peek === $AMPERSAND) {
        return this._decodeEntity();
      } else {
        var index = this.index;
        this._advance();
        return this.input[index];
      }
    };
    _HtmlTokenizer.prototype._decodeEntity = function() {
      var start = this._getLocation();
      this._advance();
      if (this._attemptCharCode($HASH)) {
        var isHex = this._attemptCharCode($x) || this._attemptCharCode($X);
        var numberStart = this._getLocation().offset;
        this._attemptCharCodeUntilFn(isDigitEntityEnd);
        if (this.peek != $SEMICOLON) {
          throw this._createError(unexpectedCharacterErrorMsg(this.peek), this._getLocation());
        }
        this._advance();
        var strNum = this.input.substring(numberStart, this.index - 1);
        try {
          var charCode = lang_1.NumberWrapper.parseInt(strNum, isHex ? 16 : 10);
          return lang_1.StringWrapper.fromCharCode(charCode);
        } catch (e) {
          var entity = this.input.substring(start.offset + 1, this.index - 1);
          throw this._createError(unknownEntityErrorMsg(entity), start);
        }
      } else {
        var startPosition = this._savePosition();
        this._attemptCharCodeUntilFn(isNamedEntityEnd);
        if (this.peek != $SEMICOLON) {
          this._restorePosition(startPosition);
          return '&';
        }
        this._advance();
        var name_1 = this.input.substring(start.offset + 1, this.index - 1);
        var char = html_tags_1.NAMED_ENTITIES[name_1];
        if (lang_1.isBlank(char)) {
          throw this._createError(unknownEntityErrorMsg(name_1), start);
        }
        return char;
      }
    };
    _HtmlTokenizer.prototype._consumeRawText = function(decodeEntities, firstCharOfEnd, attemptEndRest) {
      var tagCloseStart;
      var textStart = this._getLocation();
      this._beginToken(decodeEntities ? HtmlTokenType.ESCAPABLE_RAW_TEXT : HtmlTokenType.RAW_TEXT, textStart);
      var parts = [];
      while (true) {
        tagCloseStart = this._getLocation();
        if (this._attemptCharCode(firstCharOfEnd) && attemptEndRest()) {
          break;
        }
        if (this.index > tagCloseStart.offset) {
          parts.push(this.input.substring(tagCloseStart.offset, this.index));
        }
        while (this.peek !== firstCharOfEnd) {
          parts.push(this._readChar(decodeEntities));
        }
      }
      return this._endToken([this._processCarriageReturns(parts.join(''))], tagCloseStart);
    };
    _HtmlTokenizer.prototype._consumeComment = function(start) {
      var _this = this;
      this._beginToken(HtmlTokenType.COMMENT_START, start);
      this._requireCharCode($MINUS);
      this._endToken([]);
      var textToken = this._consumeRawText(false, $MINUS, function() {
        return _this._attemptStr('->');
      });
      this._beginToken(HtmlTokenType.COMMENT_END, textToken.sourceSpan.end);
      this._endToken([]);
    };
    _HtmlTokenizer.prototype._consumeCdata = function(start) {
      var _this = this;
      this._beginToken(HtmlTokenType.CDATA_START, start);
      this._requireStr('CDATA[');
      this._endToken([]);
      var textToken = this._consumeRawText(false, $RBRACKET, function() {
        return _this._attemptStr(']>');
      });
      this._beginToken(HtmlTokenType.CDATA_END, textToken.sourceSpan.end);
      this._endToken([]);
    };
    _HtmlTokenizer.prototype._consumeDocType = function(start) {
      this._beginToken(HtmlTokenType.DOC_TYPE, start);
      this._attemptUntilChar($GT);
      this._advance();
      this._endToken([this.input.substring(start.offset + 2, this.index - 1)]);
    };
    _HtmlTokenizer.prototype._consumePrefixAndName = function() {
      var nameOrPrefixStart = this.index;
      var prefix = null;
      while (this.peek !== $COLON && !isPrefixEnd(this.peek)) {
        this._advance();
      }
      var nameStart;
      if (this.peek === $COLON) {
        this._advance();
        prefix = this.input.substring(nameOrPrefixStart, this.index - 1);
        nameStart = this.index;
      } else {
        nameStart = nameOrPrefixStart;
      }
      this._requireCharCodeUntilFn(isNameEnd, this.index === nameStart ? 1 : 0);
      var name = this.input.substring(nameStart, this.index);
      return [prefix, name];
    };
    _HtmlTokenizer.prototype._consumeTagOpen = function(start) {
      var savedPos = this._savePosition();
      var lowercaseTagName;
      try {
        if (!isAsciiLetter(this.peek)) {
          throw this._createError(unexpectedCharacterErrorMsg(this.peek), this._getLocation());
        }
        var nameStart = this.index;
        this._consumeTagOpenStart(start);
        lowercaseTagName = this.input.substring(nameStart, this.index).toLowerCase();
        this._attemptCharCodeUntilFn(isNotWhitespace);
        while (this.peek !== $SLASH && this.peek !== $GT) {
          this._consumeAttributeName();
          this._attemptCharCodeUntilFn(isNotWhitespace);
          if (this._attemptCharCode($EQ)) {
            this._attemptCharCodeUntilFn(isNotWhitespace);
            this._consumeAttributeValue();
          }
          this._attemptCharCodeUntilFn(isNotWhitespace);
        }
        this._consumeTagOpenEnd();
      } catch (e) {
        if (e instanceof ControlFlowError) {
          this._restorePosition(savedPos);
          this._beginToken(HtmlTokenType.TEXT, start);
          this._endToken(['<']);
          return ;
        }
        throw e;
      }
      var contentTokenType = html_tags_1.getHtmlTagDefinition(lowercaseTagName).contentType;
      if (contentTokenType === html_tags_1.HtmlTagContentType.RAW_TEXT) {
        this._consumeRawTextWithTagClose(lowercaseTagName, false);
      } else if (contentTokenType === html_tags_1.HtmlTagContentType.ESCAPABLE_RAW_TEXT) {
        this._consumeRawTextWithTagClose(lowercaseTagName, true);
      }
    };
    _HtmlTokenizer.prototype._consumeRawTextWithTagClose = function(lowercaseTagName, decodeEntities) {
      var _this = this;
      var textToken = this._consumeRawText(decodeEntities, $LT, function() {
        if (!_this._attemptCharCode($SLASH))
          return false;
        _this._attemptCharCodeUntilFn(isNotWhitespace);
        if (!_this._attemptStrCaseInsensitive(lowercaseTagName))
          return false;
        _this._attemptCharCodeUntilFn(isNotWhitespace);
        if (!_this._attemptCharCode($GT))
          return false;
        return true;
      });
      this._beginToken(HtmlTokenType.TAG_CLOSE, textToken.sourceSpan.end);
      this._endToken([null, lowercaseTagName]);
    };
    _HtmlTokenizer.prototype._consumeTagOpenStart = function(start) {
      this._beginToken(HtmlTokenType.TAG_OPEN_START, start);
      var parts = this._consumePrefixAndName();
      this._endToken(parts);
    };
    _HtmlTokenizer.prototype._consumeAttributeName = function() {
      this._beginToken(HtmlTokenType.ATTR_NAME);
      var prefixAndName = this._consumePrefixAndName();
      this._endToken(prefixAndName);
    };
    _HtmlTokenizer.prototype._consumeAttributeValue = function() {
      this._beginToken(HtmlTokenType.ATTR_VALUE);
      var value;
      if (this.peek === $SQ || this.peek === $DQ) {
        var quoteChar = this.peek;
        this._advance();
        var parts = [];
        while (this.peek !== quoteChar) {
          parts.push(this._readChar(true));
        }
        value = parts.join('');
        this._advance();
      } else {
        var valueStart = this.index;
        this._requireCharCodeUntilFn(isNameEnd, 1);
        value = this.input.substring(valueStart, this.index);
      }
      this._endToken([this._processCarriageReturns(value)]);
    };
    _HtmlTokenizer.prototype._consumeTagOpenEnd = function() {
      var tokenType = this._attemptCharCode($SLASH) ? HtmlTokenType.TAG_OPEN_END_VOID : HtmlTokenType.TAG_OPEN_END;
      this._beginToken(tokenType);
      this._requireCharCode($GT);
      this._endToken([]);
    };
    _HtmlTokenizer.prototype._consumeTagClose = function(start) {
      this._beginToken(HtmlTokenType.TAG_CLOSE, start);
      this._attemptCharCodeUntilFn(isNotWhitespace);
      var prefixAndName;
      prefixAndName = this._consumePrefixAndName();
      this._attemptCharCodeUntilFn(isNotWhitespace);
      this._requireCharCode($GT);
      this._endToken(prefixAndName);
    };
    _HtmlTokenizer.prototype._consumeText = function() {
      var start = this._getLocation();
      this._beginToken(HtmlTokenType.TEXT, start);
      var parts = [this._readChar(true)];
      while (!isTextEnd(this.peek)) {
        parts.push(this._readChar(true));
      }
      this._endToken([this._processCarriageReturns(parts.join(''))]);
    };
    _HtmlTokenizer.prototype._savePosition = function() {
      return [this.peek, this.index, this.column, this.line, this.tokens.length];
    };
    _HtmlTokenizer.prototype._restorePosition = function(position) {
      this.peek = position[0];
      this.index = position[1];
      this.column = position[2];
      this.line = position[3];
      var nbTokens = position[4];
      if (nbTokens < this.tokens.length) {
        this.tokens = collection_1.ListWrapper.slice(this.tokens, 0, nbTokens);
      }
    };
    return _HtmlTokenizer;
  })();
  function isNotWhitespace(code) {
    return !isWhitespace(code) || code === $EOF;
  }
  function isWhitespace(code) {
    return (code >= $TAB && code <= $SPACE) || (code === $NBSP);
  }
  function isNameEnd(code) {
    return isWhitespace(code) || code === $GT || code === $SLASH || code === $SQ || code === $DQ || code === $EQ;
  }
  function isPrefixEnd(code) {
    return (code < $a || $z < code) && (code < $A || $Z < code) && (code < $0 || code > $9);
  }
  function isDigitEntityEnd(code) {
    return code == $SEMICOLON || code == $EOF || !isAsciiHexDigit(code);
  }
  function isNamedEntityEnd(code) {
    return code == $SEMICOLON || code == $EOF || !isAsciiLetter(code);
  }
  function isTextEnd(code) {
    return code === $LT || code === $EOF;
  }
  function isAsciiLetter(code) {
    return code >= $a && code <= $z || code >= $A && code <= $Z;
  }
  function isAsciiHexDigit(code) {
    return code >= $a && code <= $f || code >= $A && code <= $F || code >= $0 && code <= $9;
  }
  function compareCharCodeCaseInsensitive(code1, code2) {
    return toUpperCaseCharCode(code1) == toUpperCaseCharCode(code2);
  }
  function toUpperCaseCharCode(code) {
    return code >= $a && code <= $z ? code - $a + $A : code;
  }
  function mergeTextTokens(srcTokens) {
    var dstTokens = [];
    var lastDstToken;
    for (var i = 0; i < srcTokens.length; i++) {
      var token = srcTokens[i];
      if (lang_1.isPresent(lastDstToken) && lastDstToken.type == HtmlTokenType.TEXT && token.type == HtmlTokenType.TEXT) {
        lastDstToken.parts[0] += token.parts[0];
        lastDstToken.sourceSpan.end = token.sourceSpan.end;
      } else {
        lastDstToken = token;
        dstTokens.push(lastDstToken);
      }
    }
    return dstTokens;
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/runtime_metadata", ["angular2/src/core/di", "angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/compiler/directive_metadata", "angular2/src/core/metadata/directives", "angular2/src/core/linker/directive_resolver", "angular2/src/core/linker/pipe_resolver", "angular2/src/core/linker/view_resolver", "angular2/src/core/linker/directive_lifecycle_reflector", "angular2/src/core/linker/interfaces", "angular2/src/core/reflection/reflection", "angular2/src/core/di", "angular2/src/core/platform_directives_and_pipes", "angular2/src/compiler/util", "angular2/src/compiler/url_resolver"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var di_1 = require("angular2/src/core/di");
  var lang_1 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var cpl = require("angular2/src/compiler/directive_metadata");
  var md = require("angular2/src/core/metadata/directives");
  var directive_resolver_1 = require("angular2/src/core/linker/directive_resolver");
  var pipe_resolver_1 = require("angular2/src/core/linker/pipe_resolver");
  var view_resolver_1 = require("angular2/src/core/linker/view_resolver");
  var directive_lifecycle_reflector_1 = require("angular2/src/core/linker/directive_lifecycle_reflector");
  var interfaces_1 = require("angular2/src/core/linker/interfaces");
  var reflection_1 = require("angular2/src/core/reflection/reflection");
  var di_2 = require("angular2/src/core/di");
  var platform_directives_and_pipes_1 = require("angular2/src/core/platform_directives_and_pipes");
  var util_1 = require("angular2/src/compiler/util");
  var url_resolver_1 = require("angular2/src/compiler/url_resolver");
  var RuntimeMetadataResolver = (function() {
    function RuntimeMetadataResolver(_directiveResolver, _pipeResolver, _viewResolver, _platformDirectives, _platformPipes) {
      this._directiveResolver = _directiveResolver;
      this._pipeResolver = _pipeResolver;
      this._viewResolver = _viewResolver;
      this._platformDirectives = _platformDirectives;
      this._platformPipes = _platformPipes;
      this._directiveCache = new Map();
      this._pipeCache = new Map();
    }
    RuntimeMetadataResolver.prototype.getDirectiveMetadata = function(directiveType) {
      var meta = this._directiveCache.get(directiveType);
      if (lang_1.isBlank(meta)) {
        var dirMeta = this._directiveResolver.resolve(directiveType);
        var moduleUrl = null;
        var templateMeta = null;
        var changeDetectionStrategy = null;
        if (dirMeta instanceof md.ComponentMetadata) {
          var cmpMeta = dirMeta;
          moduleUrl = calcModuleUrl(directiveType, cmpMeta);
          var viewMeta = this._viewResolver.resolve(directiveType);
          templateMeta = new cpl.CompileTemplateMetadata({
            encapsulation: viewMeta.encapsulation,
            template: viewMeta.template,
            templateUrl: viewMeta.templateUrl,
            styles: viewMeta.styles,
            styleUrls: viewMeta.styleUrls
          });
          changeDetectionStrategy = cmpMeta.changeDetection;
        }
        meta = cpl.CompileDirectiveMetadata.create({
          selector: dirMeta.selector,
          exportAs: dirMeta.exportAs,
          isComponent: lang_1.isPresent(templateMeta),
          dynamicLoadable: true,
          type: new cpl.CompileTypeMetadata({
            name: lang_1.stringify(directiveType),
            moduleUrl: moduleUrl,
            runtime: directiveType
          }),
          template: templateMeta,
          changeDetection: changeDetectionStrategy,
          inputs: dirMeta.inputs,
          outputs: dirMeta.outputs,
          host: dirMeta.host,
          lifecycleHooks: interfaces_1.LIFECYCLE_HOOKS_VALUES.filter(function(hook) {
            return directive_lifecycle_reflector_1.hasLifecycleHook(hook, directiveType);
          })
        });
        this._directiveCache.set(directiveType, meta);
      }
      return meta;
    };
    RuntimeMetadataResolver.prototype.getPipeMetadata = function(pipeType) {
      var meta = this._pipeCache.get(pipeType);
      if (lang_1.isBlank(meta)) {
        var pipeMeta = this._pipeResolver.resolve(pipeType);
        var moduleUrl = reflection_1.reflector.importUri(pipeType);
        meta = new cpl.CompilePipeMetadata({
          type: new cpl.CompileTypeMetadata({
            name: lang_1.stringify(pipeType),
            moduleUrl: moduleUrl,
            runtime: pipeType
          }),
          name: pipeMeta.name,
          pure: pipeMeta.pure
        });
        this._pipeCache.set(pipeType, meta);
      }
      return meta;
    };
    RuntimeMetadataResolver.prototype.getViewDirectivesMetadata = function(component) {
      var _this = this;
      var view = this._viewResolver.resolve(component);
      var directives = flattenDirectives(view, this._platformDirectives);
      for (var i = 0; i < directives.length; i++) {
        if (!isValidType(directives[i])) {
          throw new exceptions_1.BaseException("Unexpected directive value '" + lang_1.stringify(directives[i]) + "' on the View of component '" + lang_1.stringify(component) + "'");
        }
      }
      return directives.map(function(type) {
        return _this.getDirectiveMetadata(type);
      });
    };
    RuntimeMetadataResolver.prototype.getViewPipesMetadata = function(component) {
      var _this = this;
      var view = this._viewResolver.resolve(component);
      var pipes = flattenPipes(view, this._platformPipes);
      for (var i = 0; i < pipes.length; i++) {
        if (!isValidType(pipes[i])) {
          throw new exceptions_1.BaseException("Unexpected piped value '" + lang_1.stringify(pipes[i]) + "' on the View of component '" + lang_1.stringify(component) + "'");
        }
      }
      return pipes.map(function(type) {
        return _this.getPipeMetadata(type);
      });
    };
    RuntimeMetadataResolver = __decorate([di_2.Injectable(), __param(3, di_2.Optional()), __param(3, di_2.Inject(platform_directives_and_pipes_1.PLATFORM_DIRECTIVES)), __param(4, di_2.Optional()), __param(4, di_2.Inject(platform_directives_and_pipes_1.PLATFORM_PIPES)), __metadata('design:paramtypes', [directive_resolver_1.DirectiveResolver, pipe_resolver_1.PipeResolver, view_resolver_1.ViewResolver, Array, Array])], RuntimeMetadataResolver);
    return RuntimeMetadataResolver;
  })();
  exports.RuntimeMetadataResolver = RuntimeMetadataResolver;
  function flattenDirectives(view, platformDirectives) {
    var directives = [];
    if (lang_1.isPresent(platformDirectives)) {
      flattenArray(platformDirectives, directives);
    }
    if (lang_1.isPresent(view.directives)) {
      flattenArray(view.directives, directives);
    }
    return directives;
  }
  function flattenPipes(view, platformPipes) {
    var pipes = [];
    if (lang_1.isPresent(platformPipes)) {
      flattenArray(platformPipes, pipes);
    }
    if (lang_1.isPresent(view.pipes)) {
      flattenArray(view.pipes, pipes);
    }
    return pipes;
  }
  function flattenArray(tree, out) {
    for (var i = 0; i < tree.length; i++) {
      var item = di_1.resolveForwardRef(tree[i]);
      if (lang_1.isArray(item)) {
        flattenArray(item, out);
      } else {
        out.push(item);
      }
    }
  }
  function isValidType(value) {
    return lang_1.isPresent(value) && (value instanceof lang_1.Type);
  }
  function calcModuleUrl(type, cmpMetadata) {
    var moduleId = cmpMetadata.moduleId;
    if (lang_1.isPresent(moduleId)) {
      var scheme = url_resolver_1.getUrlScheme(moduleId);
      return lang_1.isPresent(scheme) && scheme.length > 0 ? moduleId : "package:" + moduleId + util_1.MODULE_SUFFIX;
    } else {
      return reflection_1.reflector.importUri(type);
    }
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/pipes", ["angular2/src/common/pipes/async_pipe", "angular2/src/common/pipes/uppercase_pipe", "angular2/src/common/pipes/lowercase_pipe", "angular2/src/common/pipes/json_pipe", "angular2/src/common/pipes/slice_pipe", "angular2/src/common/pipes/date_pipe", "angular2/src/common/pipes/number_pipe", "angular2/src/facade/lang", "angular2/src/common/pipes/async_pipe", "angular2/src/common/pipes/date_pipe", "angular2/src/common/pipes/json_pipe", "angular2/src/common/pipes/slice_pipe", "angular2/src/common/pipes/lowercase_pipe", "angular2/src/common/pipes/number_pipe", "angular2/src/common/pipes/uppercase_pipe"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var async_pipe_1 = require("angular2/src/common/pipes/async_pipe");
  var uppercase_pipe_1 = require("angular2/src/common/pipes/uppercase_pipe");
  var lowercase_pipe_1 = require("angular2/src/common/pipes/lowercase_pipe");
  var json_pipe_1 = require("angular2/src/common/pipes/json_pipe");
  var slice_pipe_1 = require("angular2/src/common/pipes/slice_pipe");
  var date_pipe_1 = require("angular2/src/common/pipes/date_pipe");
  var number_pipe_1 = require("angular2/src/common/pipes/number_pipe");
  var lang_1 = require("angular2/src/facade/lang");
  var async_pipe_2 = require("angular2/src/common/pipes/async_pipe");
  exports.AsyncPipe = async_pipe_2.AsyncPipe;
  var date_pipe_2 = require("angular2/src/common/pipes/date_pipe");
  exports.DatePipe = date_pipe_2.DatePipe;
  var json_pipe_2 = require("angular2/src/common/pipes/json_pipe");
  exports.JsonPipe = json_pipe_2.JsonPipe;
  var slice_pipe_2 = require("angular2/src/common/pipes/slice_pipe");
  exports.SlicePipe = slice_pipe_2.SlicePipe;
  var lowercase_pipe_2 = require("angular2/src/common/pipes/lowercase_pipe");
  exports.LowerCasePipe = lowercase_pipe_2.LowerCasePipe;
  var number_pipe_2 = require("angular2/src/common/pipes/number_pipe");
  exports.NumberPipe = number_pipe_2.NumberPipe;
  exports.DecimalPipe = number_pipe_2.DecimalPipe;
  exports.PercentPipe = number_pipe_2.PercentPipe;
  exports.CurrencyPipe = number_pipe_2.CurrencyPipe;
  var uppercase_pipe_2 = require("angular2/src/common/pipes/uppercase_pipe");
  exports.UpperCasePipe = uppercase_pipe_2.UpperCasePipe;
  exports.COMMON_PIPES = lang_1.CONST_EXPR([async_pipe_1.AsyncPipe, uppercase_pipe_1.UpperCasePipe, lowercase_pipe_1.LowerCasePipe, json_pipe_1.JsonPipe, slice_pipe_1.SlicePipe, number_pipe_1.DecimalPipe, number_pipe_1.PercentPipe, number_pipe_1.CurrencyPipe, date_pipe_1.DatePipe]);
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms/directives/ng_control_name", ["angular2/src/facade/lang", "angular2/src/facade/async", "angular2/core", "angular2/src/common/forms/directives/control_container", "angular2/src/common/forms/directives/ng_control", "angular2/src/common/forms/directives/control_value_accessor", "angular2/src/common/forms/directives/shared", "angular2/src/common/forms/validators"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var lang_1 = require("angular2/src/facade/lang");
  var async_1 = require("angular2/src/facade/async");
  var core_1 = require("angular2/core");
  var control_container_1 = require("angular2/src/common/forms/directives/control_container");
  var ng_control_1 = require("angular2/src/common/forms/directives/ng_control");
  var control_value_accessor_1 = require("angular2/src/common/forms/directives/control_value_accessor");
  var shared_1 = require("angular2/src/common/forms/directives/shared");
  var validators_1 = require("angular2/src/common/forms/validators");
  var controlNameBinding = lang_1.CONST_EXPR(new core_1.Provider(ng_control_1.NgControl, {useExisting: core_1.forwardRef(function() {
      return NgControlName;
    })}));
  var NgControlName = (function(_super) {
    __extends(NgControlName, _super);
    function NgControlName(_parent, _validators, _asyncValidators, valueAccessors) {
      _super.call(this);
      this._parent = _parent;
      this._validators = _validators;
      this._asyncValidators = _asyncValidators;
      this.update = new async_1.EventEmitter();
      this._added = false;
      this.valueAccessor = shared_1.selectValueAccessor(this, valueAccessors);
    }
    NgControlName.prototype.ngOnChanges = function(changes) {
      if (!this._added) {
        this.formDirective.addControl(this);
        this._added = true;
      }
      if (shared_1.isPropertyUpdated(changes, this.viewModel)) {
        this.viewModel = this.model;
        this.formDirective.updateModel(this, this.model);
      }
    };
    NgControlName.prototype.ngOnDestroy = function() {
      this.formDirective.removeControl(this);
    };
    NgControlName.prototype.viewToModelUpdate = function(newValue) {
      this.viewModel = newValue;
      async_1.ObservableWrapper.callEmit(this.update, newValue);
    };
    Object.defineProperty(NgControlName.prototype, "path", {
      get: function() {
        return shared_1.controlPath(this.name, this._parent);
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgControlName.prototype, "formDirective", {
      get: function() {
        return this._parent.formDirective;
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgControlName.prototype, "validator", {
      get: function() {
        return shared_1.composeValidators(this._validators);
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgControlName.prototype, "asyncValidator", {
      get: function() {
        return shared_1.composeAsyncValidators(this._asyncValidators);
      },
      enumerable: true,
      configurable: true
    });
    Object.defineProperty(NgControlName.prototype, "control", {
      get: function() {
        return this.formDirective.getControl(this);
      },
      enumerable: true,
      configurable: true
    });
    NgControlName = __decorate([core_1.Directive({
      selector: '[ngControl]',
      bindings: [controlNameBinding],
      inputs: ['name: ngControl', 'model: ngModel'],
      outputs: ['update: ngModelChange'],
      exportAs: 'ngForm'
    }), __param(0, core_1.Host()), __param(0, core_1.SkipSelf()), __param(1, core_1.Optional()), __param(1, core_1.Self()), __param(1, core_1.Inject(validators_1.NG_VALIDATORS)), __param(2, core_1.Optional()), __param(2, core_1.Self()), __param(2, core_1.Inject(validators_1.NG_ASYNC_VALIDATORS)), __param(3, core_1.Optional()), __param(3, core_1.Self()), __param(3, core_1.Inject(control_value_accessor_1.NG_VALUE_ACCESSOR)), __metadata('design:paramtypes', [control_container_1.ControlContainer, Array, Array, Array])], NgControlName);
    return NgControlName;
  })(ng_control_1.NgControl);
  exports.NgControlName = NgControlName;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/browser/generic_browser_adapter", ["angular2/src/facade/collection", "angular2/src/facade/lang", "angular2/src/platform/dom/dom_adapter", "angular2/src/platform/browser/xhr_impl"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var collection_1 = require("angular2/src/facade/collection");
  var lang_1 = require("angular2/src/facade/lang");
  var dom_adapter_1 = require("angular2/src/platform/dom/dom_adapter");
  var xhr_impl_1 = require("angular2/src/platform/browser/xhr_impl");
  var GenericBrowserDomAdapter = (function(_super) {
    __extends(GenericBrowserDomAdapter, _super);
    function GenericBrowserDomAdapter() {
      var _this = this;
      _super.call(this);
      this._animationPrefix = null;
      this._transitionEnd = null;
      try {
        var element = this.createElement('div', this.defaultDoc());
        if (lang_1.isPresent(this.getStyle(element, 'animationName'))) {
          this._animationPrefix = '';
        } else {
          var domPrefixes = ['Webkit', 'Moz', 'O', 'ms'];
          for (var i = 0; i < domPrefixes.length; i++) {
            if (lang_1.isPresent(this.getStyle(element, domPrefixes[i] + 'AnimationName'))) {
              this._animationPrefix = '-' + domPrefixes[i].toLowerCase() + '-';
              break;
            }
          }
        }
        var transEndEventNames = {
          WebkitTransition: 'webkitTransitionEnd',
          MozTransition: 'transitionend',
          OTransition: 'oTransitionEnd otransitionend',
          transition: 'transitionend'
        };
        collection_1.StringMapWrapper.forEach(transEndEventNames, function(value, key) {
          if (lang_1.isPresent(_this.getStyle(element, key))) {
            _this._transitionEnd = value;
          }
        });
      } catch (e) {
        this._animationPrefix = null;
        this._transitionEnd = null;
      }
    }
    GenericBrowserDomAdapter.prototype.getXHR = function() {
      return xhr_impl_1.XHRImpl;
    };
    GenericBrowserDomAdapter.prototype.getDistributedNodes = function(el) {
      return el.getDistributedNodes();
    };
    GenericBrowserDomAdapter.prototype.resolveAndSetHref = function(el, baseUrl, href) {
      el.href = href == null ? baseUrl : baseUrl + '/../' + href;
    };
    GenericBrowserDomAdapter.prototype.supportsDOMEvents = function() {
      return true;
    };
    GenericBrowserDomAdapter.prototype.supportsNativeShadowDOM = function() {
      return lang_1.isFunction(this.defaultDoc().body.createShadowRoot);
    };
    GenericBrowserDomAdapter.prototype.getAnimationPrefix = function() {
      return lang_1.isPresent(this._animationPrefix) ? this._animationPrefix : "";
    };
    GenericBrowserDomAdapter.prototype.getTransitionEnd = function() {
      return lang_1.isPresent(this._transitionEnd) ? this._transitionEnd : "";
    };
    GenericBrowserDomAdapter.prototype.supportsAnimation = function() {
      return lang_1.isPresent(this._animationPrefix) && lang_1.isPresent(this._transitionEnd);
    };
    return GenericBrowserDomAdapter;
  })(dom_adapter_1.DomAdapter);
  exports.GenericBrowserDomAdapter = GenericBrowserDomAdapter;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/browser/tools/tools", ["angular2/src/facade/lang", "angular2/src/platform/browser/tools/common_tools"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var lang_1 = require("angular2/src/facade/lang");
  var common_tools_1 = require("angular2/src/platform/browser/tools/common_tools");
  var context = lang_1.global;
  function enableDebugTools(ref) {
    context.ng = new common_tools_1.AngularTools(ref);
  }
  exports.enableDebugTools = enableDebugTools;
  function disableDebugTools() {
    delete context.ng;
  }
  exports.disableDebugTools = disableDebugTools;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/html_parser", ["angular2/src/facade/lang", "angular2/src/facade/collection", "angular2/src/compiler/html_ast", "angular2/src/core/di", "angular2/src/compiler/html_lexer", "angular2/src/compiler/parse_util", "angular2/src/compiler/html_tags"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var lang_1 = require("angular2/src/facade/lang");
  var collection_1 = require("angular2/src/facade/collection");
  var html_ast_1 = require("angular2/src/compiler/html_ast");
  var di_1 = require("angular2/src/core/di");
  var html_lexer_1 = require("angular2/src/compiler/html_lexer");
  var parse_util_1 = require("angular2/src/compiler/parse_util");
  var html_tags_1 = require("angular2/src/compiler/html_tags");
  var HtmlTreeError = (function(_super) {
    __extends(HtmlTreeError, _super);
    function HtmlTreeError(elementName, location, msg) {
      _super.call(this, location, msg);
      this.elementName = elementName;
    }
    HtmlTreeError.create = function(elementName, location, msg) {
      return new HtmlTreeError(elementName, location, msg);
    };
    return HtmlTreeError;
  })(parse_util_1.ParseError);
  exports.HtmlTreeError = HtmlTreeError;
  var HtmlParseTreeResult = (function() {
    function HtmlParseTreeResult(rootNodes, errors) {
      this.rootNodes = rootNodes;
      this.errors = errors;
    }
    return HtmlParseTreeResult;
  })();
  exports.HtmlParseTreeResult = HtmlParseTreeResult;
  var HtmlParser = (function() {
    function HtmlParser() {}
    HtmlParser.prototype.parse = function(sourceContent, sourceUrl) {
      var tokensAndErrors = html_lexer_1.tokenizeHtml(sourceContent, sourceUrl);
      var treeAndErrors = new TreeBuilder(tokensAndErrors.tokens).build();
      return new HtmlParseTreeResult(treeAndErrors.rootNodes, tokensAndErrors.errors.concat(treeAndErrors.errors));
    };
    HtmlParser = __decorate([di_1.Injectable(), __metadata('design:paramtypes', [])], HtmlParser);
    return HtmlParser;
  })();
  exports.HtmlParser = HtmlParser;
  var TreeBuilder = (function() {
    function TreeBuilder(tokens) {
      this.tokens = tokens;
      this.index = -1;
      this.rootNodes = [];
      this.errors = [];
      this.elementStack = [];
      this._advance();
    }
    TreeBuilder.prototype.build = function() {
      while (this.peek.type !== html_lexer_1.HtmlTokenType.EOF) {
        if (this.peek.type === html_lexer_1.HtmlTokenType.TAG_OPEN_START) {
          this._consumeStartTag(this._advance());
        } else if (this.peek.type === html_lexer_1.HtmlTokenType.TAG_CLOSE) {
          this._consumeEndTag(this._advance());
        } else if (this.peek.type === html_lexer_1.HtmlTokenType.CDATA_START) {
          this._closeVoidElement();
          this._consumeCdata(this._advance());
        } else if (this.peek.type === html_lexer_1.HtmlTokenType.COMMENT_START) {
          this._closeVoidElement();
          this._consumeComment(this._advance());
        } else if (this.peek.type === html_lexer_1.HtmlTokenType.TEXT || this.peek.type === html_lexer_1.HtmlTokenType.RAW_TEXT || this.peek.type === html_lexer_1.HtmlTokenType.ESCAPABLE_RAW_TEXT) {
          this._closeVoidElement();
          this._consumeText(this._advance());
        } else {
          this._advance();
        }
      }
      return new HtmlParseTreeResult(this.rootNodes, this.errors);
    };
    TreeBuilder.prototype._advance = function() {
      var prev = this.peek;
      if (this.index < this.tokens.length - 1) {
        this.index++;
      }
      this.peek = this.tokens[this.index];
      return prev;
    };
    TreeBuilder.prototype._advanceIf = function(type) {
      if (this.peek.type === type) {
        return this._advance();
      }
      return null;
    };
    TreeBuilder.prototype._consumeCdata = function(startToken) {
      this._consumeText(this._advance());
      this._advanceIf(html_lexer_1.HtmlTokenType.CDATA_END);
    };
    TreeBuilder.prototype._consumeComment = function(startToken) {
      this._advanceIf(html_lexer_1.HtmlTokenType.RAW_TEXT);
      this._advanceIf(html_lexer_1.HtmlTokenType.COMMENT_END);
    };
    TreeBuilder.prototype._consumeText = function(token) {
      var text = token.parts[0];
      if (text.length > 0 && text[0] == '\n') {
        var parent_1 = this._getParentElement();
        if (lang_1.isPresent(parent_1) && parent_1.children.length == 0 && html_tags_1.getHtmlTagDefinition(parent_1.name).ignoreFirstLf) {
          text = text.substring(1);
        }
      }
      if (text.length > 0) {
        this._addToParent(new html_ast_1.HtmlTextAst(text, token.sourceSpan));
      }
    };
    TreeBuilder.prototype._closeVoidElement = function() {
      if (this.elementStack.length > 0) {
        var el = collection_1.ListWrapper.last(this.elementStack);
        if (html_tags_1.getHtmlTagDefinition(el.name).isVoid) {
          this.elementStack.pop();
        }
      }
    };
    TreeBuilder.prototype._consumeStartTag = function(startTagToken) {
      var prefix = startTagToken.parts[0];
      var name = startTagToken.parts[1];
      var attrs = [];
      while (this.peek.type === html_lexer_1.HtmlTokenType.ATTR_NAME) {
        attrs.push(this._consumeAttr(this._advance()));
      }
      var fullName = getElementFullName(prefix, name, this._getParentElement());
      var selfClosing = false;
      if (this.peek.type === html_lexer_1.HtmlTokenType.TAG_OPEN_END_VOID) {
        this._advance();
        selfClosing = true;
        if (html_tags_1.getNsPrefix(fullName) == null && !html_tags_1.getHtmlTagDefinition(fullName).isVoid) {
          this.errors.push(HtmlTreeError.create(fullName, startTagToken.sourceSpan.start, "Only void and foreign elements can be self closed \"" + startTagToken.parts[1] + "\""));
        }
      } else if (this.peek.type === html_lexer_1.HtmlTokenType.TAG_OPEN_END) {
        this._advance();
        selfClosing = false;
      }
      var end = this.peek.sourceSpan.start;
      var el = new html_ast_1.HtmlElementAst(fullName, attrs, [], new parse_util_1.ParseSourceSpan(startTagToken.sourceSpan.start, end));
      this._pushElement(el);
      if (selfClosing) {
        this._popElement(fullName);
      }
    };
    TreeBuilder.prototype._pushElement = function(el) {
      if (this.elementStack.length > 0) {
        var parentEl = collection_1.ListWrapper.last(this.elementStack);
        if (html_tags_1.getHtmlTagDefinition(parentEl.name).isClosedByChild(el.name)) {
          this.elementStack.pop();
        }
      }
      var tagDef = html_tags_1.getHtmlTagDefinition(el.name);
      var parentEl = this._getParentElement();
      if (tagDef.requireExtraParent(lang_1.isPresent(parentEl) ? parentEl.name : null)) {
        var newParent = new html_ast_1.HtmlElementAst(tagDef.parentToAdd, [], [el], el.sourceSpan);
        this._addToParent(newParent);
        this.elementStack.push(newParent);
        this.elementStack.push(el);
      } else {
        this._addToParent(el);
        this.elementStack.push(el);
      }
    };
    TreeBuilder.prototype._consumeEndTag = function(endTagToken) {
      var fullName = getElementFullName(endTagToken.parts[0], endTagToken.parts[1], this._getParentElement());
      if (html_tags_1.getHtmlTagDefinition(fullName).isVoid) {
        this.errors.push(HtmlTreeError.create(fullName, endTagToken.sourceSpan.start, "Void elements do not have end tags \"" + endTagToken.parts[1] + "\""));
      } else if (!this._popElement(fullName)) {
        this.errors.push(HtmlTreeError.create(fullName, endTagToken.sourceSpan.start, "Unexpected closing tag \"" + endTagToken.parts[1] + "\""));
      }
    };
    TreeBuilder.prototype._popElement = function(fullName) {
      for (var stackIndex = this.elementStack.length - 1; stackIndex >= 0; stackIndex--) {
        var el = this.elementStack[stackIndex];
        if (el.name == fullName) {
          collection_1.ListWrapper.splice(this.elementStack, stackIndex, this.elementStack.length - stackIndex);
          return true;
        }
        if (!html_tags_1.getHtmlTagDefinition(el.name).closedByParent) {
          return false;
        }
      }
      return false;
    };
    TreeBuilder.prototype._consumeAttr = function(attrName) {
      var fullName = mergeNsAndName(attrName.parts[0], attrName.parts[1]);
      var end = attrName.sourceSpan.end;
      var value = '';
      if (this.peek.type === html_lexer_1.HtmlTokenType.ATTR_VALUE) {
        var valueToken = this._advance();
        value = valueToken.parts[0];
        end = valueToken.sourceSpan.end;
      }
      return new html_ast_1.HtmlAttrAst(fullName, value, new parse_util_1.ParseSourceSpan(attrName.sourceSpan.start, end));
    };
    TreeBuilder.prototype._getParentElement = function() {
      return this.elementStack.length > 0 ? collection_1.ListWrapper.last(this.elementStack) : null;
    };
    TreeBuilder.prototype._addToParent = function(node) {
      var parent = this._getParentElement();
      if (lang_1.isPresent(parent)) {
        parent.children.push(node);
      } else {
        this.rootNodes.push(node);
      }
    };
    return TreeBuilder;
  })();
  function mergeNsAndName(prefix, localName) {
    return lang_1.isPresent(prefix) ? "@" + prefix + ":" + localName : localName;
  }
  function getElementFullName(prefix, localName, parentElement) {
    if (lang_1.isBlank(prefix)) {
      prefix = html_tags_1.getHtmlTagDefinition(localName).implicitNamespacePrefix;
      if (lang_1.isBlank(prefix) && lang_1.isPresent(parentElement)) {
        prefix = html_tags_1.getNsPrefix(parentElement.name);
      }
    }
    return mergeNsAndName(prefix, localName);
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/common/forms", ["angular2/src/common/forms/model", "angular2/src/common/forms/directives/abstract_control_directive", "angular2/src/common/forms/directives/control_container", "angular2/src/common/forms/directives/ng_control_name", "angular2/src/common/forms/directives/ng_form_control", "angular2/src/common/forms/directives/ng_model", "angular2/src/common/forms/directives/ng_control", "angular2/src/common/forms/directives/ng_control_group", "angular2/src/common/forms/directives/ng_form_model", "angular2/src/common/forms/directives/ng_form", "angular2/src/common/forms/directives/control_value_accessor", "angular2/src/common/forms/directives/default_value_accessor", "angular2/src/common/forms/directives/ng_control_status", "angular2/src/common/forms/directives/checkbox_value_accessor", "angular2/src/common/forms/directives/select_control_value_accessor", "angular2/src/common/forms/directives", "angular2/src/common/forms/validators", "angular2/src/common/forms/directives/validators", "angular2/src/common/forms/form_builder", "angular2/src/common/forms/form_builder", "angular2/src/common/forms/directives/radio_control_value_accessor", "angular2/src/facade/lang"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var model_1 = require("angular2/src/common/forms/model");
  exports.AbstractControl = model_1.AbstractControl;
  exports.Control = model_1.Control;
  exports.ControlGroup = model_1.ControlGroup;
  exports.ControlArray = model_1.ControlArray;
  var abstract_control_directive_1 = require("angular2/src/common/forms/directives/abstract_control_directive");
  exports.AbstractControlDirective = abstract_control_directive_1.AbstractControlDirective;
  var control_container_1 = require("angular2/src/common/forms/directives/control_container");
  exports.ControlContainer = control_container_1.ControlContainer;
  var ng_control_name_1 = require("angular2/src/common/forms/directives/ng_control_name");
  exports.NgControlName = ng_control_name_1.NgControlName;
  var ng_form_control_1 = require("angular2/src/common/forms/directives/ng_form_control");
  exports.NgFormControl = ng_form_control_1.NgFormControl;
  var ng_model_1 = require("angular2/src/common/forms/directives/ng_model");
  exports.NgModel = ng_model_1.NgModel;
  var ng_control_1 = require("angular2/src/common/forms/directives/ng_control");
  exports.NgControl = ng_control_1.NgControl;
  var ng_control_group_1 = require("angular2/src/common/forms/directives/ng_control_group");
  exports.NgControlGroup = ng_control_group_1.NgControlGroup;
  var ng_form_model_1 = require("angular2/src/common/forms/directives/ng_form_model");
  exports.NgFormModel = ng_form_model_1.NgFormModel;
  var ng_form_1 = require("angular2/src/common/forms/directives/ng_form");
  exports.NgForm = ng_form_1.NgForm;
  var control_value_accessor_1 = require("angular2/src/common/forms/directives/control_value_accessor");
  exports.NG_VALUE_ACCESSOR = control_value_accessor_1.NG_VALUE_ACCESSOR;
  var default_value_accessor_1 = require("angular2/src/common/forms/directives/default_value_accessor");
  exports.DefaultValueAccessor = default_value_accessor_1.DefaultValueAccessor;
  var ng_control_status_1 = require("angular2/src/common/forms/directives/ng_control_status");
  exports.NgControlStatus = ng_control_status_1.NgControlStatus;
  var checkbox_value_accessor_1 = require("angular2/src/common/forms/directives/checkbox_value_accessor");
  exports.CheckboxControlValueAccessor = checkbox_value_accessor_1.CheckboxControlValueAccessor;
  var select_control_value_accessor_1 = require("angular2/src/common/forms/directives/select_control_value_accessor");
  exports.NgSelectOption = select_control_value_accessor_1.NgSelectOption;
  exports.SelectControlValueAccessor = select_control_value_accessor_1.SelectControlValueAccessor;
  var directives_1 = require("angular2/src/common/forms/directives");
  exports.FORM_DIRECTIVES = directives_1.FORM_DIRECTIVES;
  exports.RadioButtonState = directives_1.RadioButtonState;
  var validators_1 = require("angular2/src/common/forms/validators");
  exports.NG_VALIDATORS = validators_1.NG_VALIDATORS;
  exports.NG_ASYNC_VALIDATORS = validators_1.NG_ASYNC_VALIDATORS;
  exports.Validators = validators_1.Validators;
  var validators_2 = require("angular2/src/common/forms/directives/validators");
  exports.RequiredValidator = validators_2.RequiredValidator;
  exports.MinLengthValidator = validators_2.MinLengthValidator;
  exports.MaxLengthValidator = validators_2.MaxLengthValidator;
  var form_builder_1 = require("angular2/src/common/forms/form_builder");
  exports.FormBuilder = form_builder_1.FormBuilder;
  var form_builder_2 = require("angular2/src/common/forms/form_builder");
  var radio_control_value_accessor_1 = require("angular2/src/common/forms/directives/radio_control_value_accessor");
  var lang_1 = require("angular2/src/facade/lang");
  exports.FORM_PROVIDERS = lang_1.CONST_EXPR([form_builder_2.FormBuilder, radio_control_value_accessor_1.RadioControlRegistry]);
  exports.FORM_BINDINGS = exports.FORM_PROVIDERS;
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/platform/browser/browser_adapter", ["angular2/src/facade/collection", "angular2/src/facade/lang", "angular2/src/platform/dom/dom_adapter", "angular2/src/platform/browser/generic_browser_adapter"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var collection_1 = require("angular2/src/facade/collection");
  var lang_1 = require("angular2/src/facade/lang");
  var dom_adapter_1 = require("angular2/src/platform/dom/dom_adapter");
  var generic_browser_adapter_1 = require("angular2/src/platform/browser/generic_browser_adapter");
  var _attrToPropMap = {
    'class': 'className',
    'innerHtml': 'innerHTML',
    'readonly': 'readOnly',
    'tabindex': 'tabIndex'
  };
  var DOM_KEY_LOCATION_NUMPAD = 3;
  var _keyMap = {
    '\b': 'Backspace',
    '\t': 'Tab',
    '\x7F': 'Delete',
    '\x1B': 'Escape',
    'Del': 'Delete',
    'Esc': 'Escape',
    'Left': 'ArrowLeft',
    'Right': 'ArrowRight',
    'Up': 'ArrowUp',
    'Down': 'ArrowDown',
    'Menu': 'ContextMenu',
    'Scroll': 'ScrollLock',
    'Win': 'OS'
  };
  var _chromeNumKeyPadMap = {
    'A': '1',
    'B': '2',
    'C': '3',
    'D': '4',
    'E': '5',
    'F': '6',
    'G': '7',
    'H': '8',
    'I': '9',
    'J': '*',
    'K': '+',
    'M': '-',
    'N': '.',
    'O': '/',
    '\x60': '0',
    '\x90': 'NumLock'
  };
  var BrowserDomAdapter = (function(_super) {
    __extends(BrowserDomAdapter, _super);
    function BrowserDomAdapter() {
      _super.apply(this, arguments);
    }
    BrowserDomAdapter.prototype.parse = function(templateHtml) {
      throw new Error("parse not implemented");
    };
    BrowserDomAdapter.makeCurrent = function() {
      dom_adapter_1.setRootDomAdapter(new BrowserDomAdapter());
    };
    BrowserDomAdapter.prototype.hasProperty = function(element, name) {
      return name in element;
    };
    BrowserDomAdapter.prototype.setProperty = function(el, name, value) {
      el[name] = value;
    };
    BrowserDomAdapter.prototype.getProperty = function(el, name) {
      return el[name];
    };
    BrowserDomAdapter.prototype.invoke = function(el, methodName, args) {
      el[methodName].apply(el, args);
    };
    BrowserDomAdapter.prototype.logError = function(error) {
      if (window.console.error) {
        window.console.error(error);
      } else {
        window.console.log(error);
      }
    };
    BrowserDomAdapter.prototype.log = function(error) {
      window.console.log(error);
    };
    BrowserDomAdapter.prototype.logGroup = function(error) {
      if (window.console.group) {
        window.console.group(error);
        this.logError(error);
      } else {
        window.console.log(error);
      }
    };
    BrowserDomAdapter.prototype.logGroupEnd = function() {
      if (window.console.groupEnd) {
        window.console.groupEnd();
      }
    };
    Object.defineProperty(BrowserDomAdapter.prototype, "attrToPropMap", {
      get: function() {
        return _attrToPropMap;
      },
      enumerable: true,
      configurable: true
    });
    BrowserDomAdapter.prototype.query = function(selector) {
      return document.querySelector(selector);
    };
    BrowserDomAdapter.prototype.querySelector = function(el, selector) {
      return el.querySelector(selector);
    };
    BrowserDomAdapter.prototype.querySelectorAll = function(el, selector) {
      return el.querySelectorAll(selector);
    };
    BrowserDomAdapter.prototype.on = function(el, evt, listener) {
      el.addEventListener(evt, listener, false);
    };
    BrowserDomAdapter.prototype.onAndCancel = function(el, evt, listener) {
      el.addEventListener(evt, listener, false);
      return function() {
        el.removeEventListener(evt, listener, false);
      };
    };
    BrowserDomAdapter.prototype.dispatchEvent = function(el, evt) {
      el.dispatchEvent(evt);
    };
    BrowserDomAdapter.prototype.createMouseEvent = function(eventType) {
      var evt = document.createEvent('MouseEvent');
      evt.initEvent(eventType, true, true);
      return evt;
    };
    BrowserDomAdapter.prototype.createEvent = function(eventType) {
      var evt = document.createEvent('Event');
      evt.initEvent(eventType, true, true);
      return evt;
    };
    BrowserDomAdapter.prototype.preventDefault = function(evt) {
      evt.preventDefault();
      evt.returnValue = false;
    };
    BrowserDomAdapter.prototype.isPrevented = function(evt) {
      return evt.defaultPrevented || lang_1.isPresent(evt.returnValue) && !evt.returnValue;
    };
    BrowserDomAdapter.prototype.getInnerHTML = function(el) {
      return el.innerHTML;
    };
    BrowserDomAdapter.prototype.getOuterHTML = function(el) {
      return el.outerHTML;
    };
    BrowserDomAdapter.prototype.nodeName = function(node) {
      return node.nodeName;
    };
    BrowserDomAdapter.prototype.nodeValue = function(node) {
      return node.nodeValue;
    };
    BrowserDomAdapter.prototype.type = function(node) {
      return node.type;
    };
    BrowserDomAdapter.prototype.content = function(node) {
      if (this.hasProperty(node, "content")) {
        return node.content;
      } else {
        return node;
      }
    };
    BrowserDomAdapter.prototype.firstChild = function(el) {
      return el.firstChild;
    };
    BrowserDomAdapter.prototype.nextSibling = function(el) {
      return el.nextSibling;
    };
    BrowserDomAdapter.prototype.parentElement = function(el) {
      return el.parentNode;
    };
    BrowserDomAdapter.prototype.childNodes = function(el) {
      return el.childNodes;
    };
    BrowserDomAdapter.prototype.childNodesAsList = function(el) {
      var childNodes = el.childNodes;
      var res = collection_1.ListWrapper.createFixedSize(childNodes.length);
      for (var i = 0; i < childNodes.length; i++) {
        res[i] = childNodes[i];
      }
      return res;
    };
    BrowserDomAdapter.prototype.clearNodes = function(el) {
      while (el.firstChild) {
        el.removeChild(el.firstChild);
      }
    };
    BrowserDomAdapter.prototype.appendChild = function(el, node) {
      el.appendChild(node);
    };
    BrowserDomAdapter.prototype.removeChild = function(el, node) {
      el.removeChild(node);
    };
    BrowserDomAdapter.prototype.replaceChild = function(el, newChild, oldChild) {
      el.replaceChild(newChild, oldChild);
    };
    BrowserDomAdapter.prototype.remove = function(node) {
      if (node.parentNode) {
        node.parentNode.removeChild(node);
      }
      return node;
    };
    BrowserDomAdapter.prototype.insertBefore = function(el, node) {
      el.parentNode.insertBefore(node, el);
    };
    BrowserDomAdapter.prototype.insertAllBefore = function(el, nodes) {
      nodes.forEach(function(n) {
        return el.parentNode.insertBefore(n, el);
      });
    };
    BrowserDomAdapter.prototype.insertAfter = function(el, node) {
      el.parentNode.insertBefore(node, el.nextSibling);
    };
    BrowserDomAdapter.prototype.setInnerHTML = function(el, value) {
      el.innerHTML = value;
    };
    BrowserDomAdapter.prototype.getText = function(el) {
      return el.textContent;
    };
    BrowserDomAdapter.prototype.setText = function(el, value) {
      el.textContent = value;
    };
    BrowserDomAdapter.prototype.getValue = function(el) {
      return el.value;
    };
    BrowserDomAdapter.prototype.setValue = function(el, value) {
      el.value = value;
    };
    BrowserDomAdapter.prototype.getChecked = function(el) {
      return el.checked;
    };
    BrowserDomAdapter.prototype.setChecked = function(el, value) {
      el.checked = value;
    };
    BrowserDomAdapter.prototype.createComment = function(text) {
      return document.createComment(text);
    };
    BrowserDomAdapter.prototype.createTemplate = function(html) {
      var t = document.createElement('template');
      t.innerHTML = html;
      return t;
    };
    BrowserDomAdapter.prototype.createElement = function(tagName, doc) {
      if (doc === void 0) {
        doc = document;
      }
      return doc.createElement(tagName);
    };
    BrowserDomAdapter.prototype.createElementNS = function(ns, tagName, doc) {
      if (doc === void 0) {
        doc = document;
      }
      return doc.createElementNS(ns, tagName);
    };
    BrowserDomAdapter.prototype.createTextNode = function(text, doc) {
      if (doc === void 0) {
        doc = document;
      }
      return doc.createTextNode(text);
    };
    BrowserDomAdapter.prototype.createScriptTag = function(attrName, attrValue, doc) {
      if (doc === void 0) {
        doc = document;
      }
      var el = doc.createElement('SCRIPT');
      el.setAttribute(attrName, attrValue);
      return el;
    };
    BrowserDomAdapter.prototype.createStyleElement = function(css, doc) {
      if (doc === void 0) {
        doc = document;
      }
      var style = doc.createElement('style');
      this.appendChild(style, this.createTextNode(css));
      return style;
    };
    BrowserDomAdapter.prototype.createShadowRoot = function(el) {
      return el.createShadowRoot();
    };
    BrowserDomAdapter.prototype.getShadowRoot = function(el) {
      return el.shadowRoot;
    };
    BrowserDomAdapter.prototype.getHost = function(el) {
      return el.host;
    };
    BrowserDomAdapter.prototype.clone = function(node) {
      return node.cloneNode(true);
    };
    BrowserDomAdapter.prototype.getElementsByClassName = function(element, name) {
      return element.getElementsByClassName(name);
    };
    BrowserDomAdapter.prototype.getElementsByTagName = function(element, name) {
      return element.getElementsByTagName(name);
    };
    BrowserDomAdapter.prototype.classList = function(element) {
      return Array.prototype.slice.call(element.classList, 0);
    };
    BrowserDomAdapter.prototype.addClass = function(element, className) {
      element.classList.add(className);
    };
    BrowserDomAdapter.prototype.removeClass = function(element, className) {
      element.classList.remove(className);
    };
    BrowserDomAdapter.prototype.hasClass = function(element, className) {
      return element.classList.contains(className);
    };
    BrowserDomAdapter.prototype.setStyle = function(element, styleName, styleValue) {
      element.style[styleName] = styleValue;
    };
    BrowserDomAdapter.prototype.removeStyle = function(element, stylename) {
      element.style[stylename] = null;
    };
    BrowserDomAdapter.prototype.getStyle = function(element, stylename) {
      return element.style[stylename];
    };
    BrowserDomAdapter.prototype.hasStyle = function(element, styleName, styleValue) {
      if (styleValue === void 0) {
        styleValue = null;
      }
      var value = this.getStyle(element, styleName) || '';
      return styleValue ? value == styleValue : value.length > 0;
    };
    BrowserDomAdapter.prototype.tagName = function(element) {
      return element.tagName;
    };
    BrowserDomAdapter.prototype.attributeMap = function(element) {
      var res = new Map();
      var elAttrs = element.attributes;
      for (var i = 0; i < elAttrs.length; i++) {
        var attrib = elAttrs[i];
        res.set(attrib.name, attrib.value);
      }
      return res;
    };
    BrowserDomAdapter.prototype.hasAttribute = function(element, attribute) {
      return element.hasAttribute(attribute);
    };
    BrowserDomAdapter.prototype.getAttribute = function(element, attribute) {
      return element.getAttribute(attribute);
    };
    BrowserDomAdapter.prototype.setAttribute = function(element, name, value) {
      element.setAttribute(name, value);
    };
    BrowserDomAdapter.prototype.setAttributeNS = function(element, ns, name, value) {
      element.setAttributeNS(ns, name, value);
    };
    BrowserDomAdapter.prototype.removeAttribute = function(element, attribute) {
      element.removeAttribute(attribute);
    };
    BrowserDomAdapter.prototype.templateAwareRoot = function(el) {
      return this.isTemplateElement(el) ? this.content(el) : el;
    };
    BrowserDomAdapter.prototype.createHtmlDocument = function() {
      return document.implementation.createHTMLDocument('fakeTitle');
    };
    BrowserDomAdapter.prototype.defaultDoc = function() {
      return document;
    };
    BrowserDomAdapter.prototype.getBoundingClientRect = function(el) {
      try {
        return el.getBoundingClientRect();
      } catch (e) {
        return {
          top: 0,
          bottom: 0,
          left: 0,
          right: 0,
          width: 0,
          height: 0
        };
      }
    };
    BrowserDomAdapter.prototype.getTitle = function() {
      return document.title;
    };
    BrowserDomAdapter.prototype.setTitle = function(newTitle) {
      document.title = newTitle || '';
    };
    BrowserDomAdapter.prototype.elementMatches = function(n, selector) {
      var matches = false;
      if (n instanceof HTMLElement) {
        if (n.matches) {
          matches = n.matches(selector);
        } else if (n.msMatchesSelector) {
          matches = n.msMatchesSelector(selector);
        } else if (n.webkitMatchesSelector) {
          matches = n.webkitMatchesSelector(selector);
        }
      }
      return matches;
    };
    BrowserDomAdapter.prototype.isTemplateElement = function(el) {
      return el instanceof HTMLElement && el.nodeName == "TEMPLATE";
    };
    BrowserDomAdapter.prototype.isTextNode = function(node) {
      return node.nodeType === Node.TEXT_NODE;
    };
    BrowserDomAdapter.prototype.isCommentNode = function(node) {
      return node.nodeType === Node.COMMENT_NODE;
    };
    BrowserDomAdapter.prototype.isElementNode = function(node) {
      return node.nodeType === Node.ELEMENT_NODE;
    };
    BrowserDomAdapter.prototype.hasShadowRoot = function(node) {
      return node instanceof HTMLElement && lang_1.isPresent(node.shadowRoot);
    };
    BrowserDomAdapter.prototype.isShadowRoot = function(node) {
      return node instanceof DocumentFragment;
    };
    BrowserDomAdapter.prototype.importIntoDoc = function(node) {
      var toImport = node;
      if (this.isTemplateElement(node)) {
        toImport = this.content(node);
      }
      return document.importNode(toImport, true);
    };
    BrowserDomAdapter.prototype.adoptNode = function(node) {
      return document.adoptNode(node);
    };
    BrowserDomAdapter.prototype.getHref = function(el) {
      return el.href;
    };
    BrowserDomAdapter.prototype.getEventKey = function(event) {
      var key = event.key;
      if (lang_1.isBlank(key)) {
        key = event.keyIdentifier;
        if (lang_1.isBlank(key)) {
          return 'Unidentified';
        }
        if (key.startsWith('U+')) {
          key = String.fromCharCode(parseInt(key.substring(2), 16));
          if (event.location === DOM_KEY_LOCATION_NUMPAD && _chromeNumKeyPadMap.hasOwnProperty(key)) {
            key = _chromeNumKeyPadMap[key];
          }
        }
      }
      if (_keyMap.hasOwnProperty(key)) {
        key = _keyMap[key];
      }
      return key;
    };
    BrowserDomAdapter.prototype.getGlobalEventTarget = function(target) {
      if (target == "window") {
        return window;
      } else if (target == "document") {
        return document;
      } else if (target == "body") {
        return document.body;
      }
    };
    BrowserDomAdapter.prototype.getHistory = function() {
      return window.history;
    };
    BrowserDomAdapter.prototype.getLocation = function() {
      return window.location;
    };
    BrowserDomAdapter.prototype.getBaseHref = function() {
      var href = getBaseElementHref();
      if (lang_1.isBlank(href)) {
        return null;
      }
      return relativePath(href);
    };
    BrowserDomAdapter.prototype.resetBaseElement = function() {
      baseElement = null;
    };
    BrowserDomAdapter.prototype.getUserAgent = function() {
      return window.navigator.userAgent;
    };
    BrowserDomAdapter.prototype.setData = function(element, name, value) {
      this.setAttribute(element, 'data-' + name, value);
    };
    BrowserDomAdapter.prototype.getData = function(element, name) {
      return this.getAttribute(element, 'data-' + name);
    };
    BrowserDomAdapter.prototype.getComputedStyle = function(element) {
      return getComputedStyle(element);
    };
    BrowserDomAdapter.prototype.setGlobalVar = function(path, value) {
      lang_1.setValueOnPath(lang_1.global, path, value);
    };
    BrowserDomAdapter.prototype.requestAnimationFrame = function(callback) {
      return window.requestAnimationFrame(callback);
    };
    BrowserDomAdapter.prototype.cancelAnimationFrame = function(id) {
      window.cancelAnimationFrame(id);
    };
    BrowserDomAdapter.prototype.performanceNow = function() {
      if (lang_1.isPresent(window.performance) && lang_1.isPresent(window.performance.now)) {
        return window.performance.now();
      } else {
        return lang_1.DateWrapper.toMillis(lang_1.DateWrapper.now());
      }
    };
    return BrowserDomAdapter;
  })(generic_browser_adapter_1.GenericBrowserDomAdapter);
  exports.BrowserDomAdapter = BrowserDomAdapter;
  var baseElement = null;
  function getBaseElementHref() {
    if (lang_1.isBlank(baseElement)) {
      baseElement = document.querySelector('base');
      if (lang_1.isBlank(baseElement)) {
        return null;
      }
    }
    return baseElement.getAttribute('href');
  }
  var urlParsingNode = null;
  function relativePath(url) {
    if (lang_1.isBlank(urlParsingNode)) {
      urlParsingNode = document.createElement("a");
    }
    urlParsingNode.setAttribute('href', url);
    return (urlParsingNode.pathname.charAt(0) === '/') ? urlParsingNode.pathname : '/' + urlParsingNode.pathname;
  }
  global.define = __define;
  return module.exports;
});

System.register("angular2/src/compiler/template_parser", ["angular2/src/facade/collection", "angular2/src/facade/lang", "angular2/core", "angular2/src/facade/lang", "angular2/src/facade/exceptions", "angular2/src/core/change_detection/change_detection", "angular2/src/compiler/html_parser", "angular2/src/compiler/html_tags", "angular2/src/compiler/parse_util", "angular2/src/core/change_detection/parser/ast", "angular2/src/compiler/template_ast", "angular2/src/compiler/selector", "angular2/src/compiler/schema/element_schema_registry", "angular2/src/compiler/template_preparser", "angular2/src/compiler/style_url_resolver", "angular2/src/compiler/html_ast", "angular2/src/compiler/util"], true, function(require, exports, module) {
  var global = System.global,
      __define = global.define;
  global.define = undefined;
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var collection_1 = require("angular2/src/facade/collection");
  var lang_1 = require("angular2/src/facade/lang");
  var core_1 = require("angular2/core");
  var lang_2 = require("angular2/src/facade/lang");
  var exceptions_1 = require("angular2/src/facade/exceptions");
  var change_detection_1 = require("angular2/src/core/change_detection/change_detection");
  var html_parser_1 = require("angular2/src/compiler/html_parser");
  var html_tags_1 = require("angular2/src/compiler/html_tags");
  var parse_util_1 = require("angular2/src/compiler/parse_util");
  var ast_1 = require("angular2/src/core/change_detection/parser/ast");
  var template_ast_1 = require("angular2/src/compiler/template_ast");
  var selector_1 = require("angular2/src/compiler/selector");
  var element_schema_registry_1 = require("angular2/src/compiler/schema/element_schema_registry");
  var template_preparser_1 = require("angular2/src/compiler/template_preparser");
  var style_url_resolver_1 = require("angular2/src/compiler/style_url_resolver");
  var html_ast_1 = require("angular2/src/compiler/html_ast");
  var util_1 = require("angular2/src/compiler/util");
  var BIND_NAME_REGEXP = /^(?:(?:(?:(bind-)|(var-|#)|(on-)|(bindon-))(.+))|\[\(([^\)]+)\)\]|\[([^\]]+)\]|\(([^\)]+)\))$/g;
  var TEMPLATE_ELEMENT = 'template';
  var TEMPLATE_ATTR = 'template';
  var TEMPLATE_ATTR_PREFIX = '*';
  var CLASS_ATTR = 'class';
  var PROPERTY_PARTS_SEPARATOR = '.';
  var ATTRIBUTE_PREFIX = 'attr';
  var CLASS_PREFIX = 'class';
  var STYLE_PREFIX = 'style';
  var TEXT_CSS_SELECTOR = selector_1.CssSelector.parse('*')[0];
  exports.TEMPLATE_TRANSFORMS = lang_2.CONST_EXPR(new core_1.OpaqueToken('TemplateTransforms'));
  var TemplateParseError = (function(_super) {
    __extends(TemplateParseError, _super);
    function TemplateParseError(message, location) {
      _super.call(this, location, message);
    }
    return TemplateParseError;
  })(parse_util_1.ParseError);
  exports.TemplateParseError = TemplateParseError;
  var TemplateParser = (function() {
    function TemplateParser(_exprParser, _schemaRegistry, _htmlParser, transforms) {
      this._exprParser = _exprParser;
      this._schemaRegistry = _schemaRegistry;
      this._htmlParser = _htmlParser;
      this.transforms = transforms;
    }
    TemplateParser.prototype.parse = function(template, directives, pipes, templateUrl) {
      var parseVisitor = new TemplateParseVisitor(directives, pipes, this._exprParser, this._schemaRegistry);
      var htmlAstWithErrors = this._htmlParser.parse(template, templateUrl);
      var result = html_ast_1.htmlVisitAll(parseVisitor, htmlAstWithErrors.rootNodes, EMPTY_COMPONENT);
      var errors = htmlAstWithErrors.errors.concat(parseVisitor.errors);
      if (errors.length > 0) {
        var errorString = errors.join('\n');
        throw new exceptions_1.BaseException("Template parse errors:\n" + errorString);
      }
      if (lang_1.isPresent(this.transforms)) {
        this.transforms.forEach(function(transform) {
          result = template_ast_1.templateVisitAll(transform, result);
        });
      }
      return result;
    };
    TemplateParser = __decorate([core_1.Injectable(), __param(3, core_1.Optional()), __param(3, core_1.Inject(exports.TEMPLATE_TRANSFORMS)), __metadata('design:paramtypes', [change_detection_1.Parser, element_schema_registry_1.ElementSchemaRegistry, html_parser_1.HtmlParser, Array])], TemplateParser);
    return TemplateParser;
  })();
  exports.TemplateParser = TemplateParser;
  var TemplateParseVisitor = (function() {
    function TemplateParseVisitor(directives, pipes, _exprParser, _schemaRegistry) {
      var _this = this;
      this._exprParser = _exprParser;
      this._schemaRegistry = _schemaRegistry;
      this.errors = [];
      this.directivesIndex = new Map();
      this.ngContentCount = 0;
      this.selectorMatcher = new selector_1.SelectorMatcher();
      collection_1.ListWrapper.forEachWithIndex(directives, function(directive, index) {
        var selector = selector_1.CssSelector.parse(directive.selector);
        _this.selectorMatcher.addSelectables(selector, directive);
        _this.directivesIndex.set(directive, index);
      });
      this.pipesByName = new Map();
      pipes.forEach(function(pipe) {
        return _this.pipesByName.set(pipe.name, pipe);
      });
    }
    TemplateParseVisitor.prototype._reportError = function(message, sourceSpan) {
      this.errors.push(new TemplateParseError(message, sourceSpan.start));
    };
    TemplateParseVisitor.prototype._parseInterpolation = function(value, sourceSpan) {
      var sourceInfo = sourceSpan.start.toString();
      try {
        var ast = this._exprParser.parseInterpolation(value, sourceInfo);
        this._checkPipes(ast, sourceSpan);
        return ast;
      } catch (e) {
        this._reportError("" + e, sourceSpan);
        return this._exprParser.wrapLiteralPrimitive('ERROR', sourceInfo);
      }
    };
    TemplateParseVisitor.prototype._parseAction = function(value, sourceSpan) {
      var sourceInfo = sourceSpan.start.toString();
      try {
        var ast = this._exprParser.parseAction(value, sourceInfo);
        this._checkPipes(ast, sourceSpan);
        return ast;
      } catch (e) {
        this._reportError("" + e, sourceSpan);
        return this._exprParser.wrapLiteralPrimitive('ERROR', sourceInfo);
      }
    };
    TemplateParseVisitor.prototype._parseBinding = function(value, sourceSpan) {
      var sourceInfo = sourceSpan.start.toString();
      try {
        var ast = this._exprParser.parseBinding(value, sourceInfo);
        this._checkPipes(ast, sourceSpan);
        return ast;
      } catch (e) {
        this._reportError("" + e, sourceSpan);
        return this._exprParser.wrapLiteralPrimitive('ERROR', sourceInfo);
      }
    };
    TemplateParseVisitor.prototype._parseTemplateBindings = function(value, sourceSpan) {
      var _this = this;
      var sourceInfo = sourceSpan.start.toString();
      try {
        var bindings = this._exprParser.parseTemplateBindings(value, sourceInfo);
        bindings.forEach(function(binding) {
          if (lang_1.isPresent(binding.expression)) {
            _this._checkPipes(binding.expression, sourceSpan);
          }
        });
        return bindings;
      } catch (e) {
        this._reportError("" + e, sourceSpan);
        return [];
      }
    };
    TemplateParseVisitor.prototype._checkPipes = function(ast, sourceSpan) {
      var _this = this;
      if (lang_1.isPresent(ast)) {
        var collector = new PipeCollector();
        ast.visit(collector);
        collector.pipes.forEach(function(pipeName) {
          if (!_this.pipesByName.has(pipeName)) {
            _this._reportError("The pipe '" + pipeName + "' could not be found", sourceSpan);
          }
        });
      }
    };
    TemplateParseVisitor.prototype.visitText = function(ast, component) {
      var ngContentIndex = component.findNgContentIndex(TEXT_CSS_SELECTOR);
      var expr = this._parseInterpolation(ast.value, ast.sourceSpan);
      if (lang_1.isPresent(expr)) {
        return new template_ast_1.BoundTextAst(expr, ngContentIndex, ast.sourceSpan);
      } else {
        return new template_ast_1.TextAst(ast.value, ngContentIndex, ast.sourceSpan);
      }
    };
    TemplateParseVisitor.prototype.visitAttr = function(ast, contex) {
      return new template_ast_1.AttrAst(ast.name, ast.value, ast.sourceSpan);
    };
    TemplateParseVisitor.prototype.visitElement = function(element, component) {
      var _this = this;
      var nodeName = element.name;
      var preparsedElement = template_preparser_1.preparseElement(element);
      if (preparsedElement.type === template_preparser_1.PreparsedElementType.SCRIPT || preparsedElement.type === template_preparser_1.PreparsedElementType.STYLE) {
        return null;
      }
      if (preparsedElement.type === template_preparser_1.PreparsedElementType.STYLESHEET && style_url_resolver_1.isStyleUrlResolvable(preparsedElement.hrefAttr)) {
        return null;
      }
      var matchableAttrs = [];
      var elementOrDirectiveProps = [];
      var vars = [];
      var events = [];
      var templateElementOrDirectiveProps = [];
      var templateVars = [];
      var templateMatchableAttrs = [];
      var hasInlineTemplates = false;
      var attrs = [];
      element.attrs.forEach(function(attr) {
        var hasBinding = _this._parseAttr(attr, matchableAttrs, elementOrDirectiveProps, events, vars);
        var hasTemplateBinding = _this._parseInlineTemplateBinding(attr, templateMatchableAttrs, templateElementOrDirectiveProps, templateVars);
        if (!hasBinding && !hasTemplateBinding) {
          attrs.push(_this.visitAttr(attr, null));
          matchableAttrs.push([attr.name, attr.value]);
        }
        if (hasTemplateBinding) {
          hasInlineTemplates = true;
        }
      });
      var lcElName = html_tags_1.splitNsName(nodeName.toLowerCase())[1];
      var isTemplateElement = lcElName == TEMPLATE_ELEMENT;
      var elementCssSelector = createElementCssSelector(nodeName, matchableAttrs);
      var directives = this._createDirectiveAsts(element.name, this._parseDirectives(this.selectorMatcher, elementCssSelector), elementOrDirectiveProps, isTemplateElement ? [] : vars, element.sourceSpan);
      var elementProps = this._createElementPropertyAsts(element.name, elementOrDirectiveProps, directives);
      var children = html_ast_1.htmlVisitAll(preparsedElement.nonBindable ? NON_BINDABLE_VISITOR : this, element.children, Component.create(directives));
      var elementNgContentIndex = hasInlineTemplates ? null : component.findNgContentIndex(elementCssSelector);
      var parsedElem