var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { isPresent, isBlank, StringWrapper, IS_DART, CONST_EXPR } from 'angular2/src/facade/lang';
import { StringMapWrapper, ListWrapper } from 'angular2/src/facade/collection';
import { templateVisitAll } from './template_ast';
import { moduleRef } from './source_module';
import { AppProtoView } from 'angular2/src/core/linker/view';
import { ViewType } from 'angular2/src/core/linker/view_type';
import { AppProtoElement } from 'angular2/src/core/linker/element';
import { MODULE_SUFFIX, codeGenStringMap, Expression, Statement } from './util';
import { Injectable } from 'angular2/src/core/di';
export const PROTO_VIEW_JIT_IMPORTS = CONST_EXPR({ 'AppProtoView': AppProtoView, 'AppProtoElement': AppProtoElement, 'ViewType': ViewType });
// TODO: have a single file that reexports everything needed for
// codegen explicitly
// - helps understanding what codegen works against
// - less imports in codegen code
export var APP_VIEW_MODULE_REF = moduleRef('package:angular2/src/core/linker/view' + MODULE_SUFFIX);
export var VIEW_TYPE_MODULE_REF = moduleRef('package:angular2/src/core/linker/view_type' + MODULE_SUFFIX);
export var APP_EL_MODULE_REF = moduleRef('package:angular2/src/core/linker/element' + MODULE_SUFFIX);
export var METADATA_MODULE_REF = moduleRef('package:angular2/src/core/metadata/view' + MODULE_SUFFIX);
const IMPLICIT_TEMPLATE_VAR = '\$implicit';
const CLASS_ATTR = 'class';
const STYLE_ATTR = 'style';
export let ProtoViewCompiler = class {
    constructor() {
    }
    compileProtoViewRuntime(metadataCache, component, template, pipes) {
        var protoViewFactory = new RuntimeProtoViewFactory(metadataCache, component, pipes);
        var allProtoViews = [];
        protoViewFactory.createCompileProtoView(template, [], [], allProtoViews);
        return new CompileProtoViews([], allProtoViews);
    }
    compileProtoViewCodeGen(resolvedMetadataCacheExpr, component, template, pipes) {
        var protoViewFactory = new CodeGenProtoViewFactory(resolvedMetadataCacheExpr, component, pipes);
        var allProtoViews = [];
        var allStatements = [];
        protoViewFactory.createCompileProtoView(template, [], allStatements, allProtoViews);
        return new CompileProtoViews(allStatements.map(stmt => stmt.statement), allProtoViews);
    }
};
ProtoViewCompiler = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [])
], ProtoViewCompiler);
export class CompileProtoViews {
    constructor(declarations, protoViews) {
        this.declarations = declarations;
        this.protoViews = protoViews;
    }
}
export class CompileProtoView {
    constructor(embeddedTemplateIndex, protoElements, protoView) {
        this.embeddedTemplateIndex = embeddedTemplateIndex;
        this.protoElements = protoElements;
        this.protoView = protoView;
    }
}
export class CompileProtoElement {
    constructor(boundElementIndex, attrNameAndValues, variableNameAndValues, renderEvents, directives, embeddedTemplateIndex, appProtoEl) {
        this.boundElementIndex = boundElementIndex;
        this.attrNameAndValues = attrNameAndValues;
        this.variableNameAndValues = variableNameAndValues;
        this.renderEvents = renderEvents;
        this.directives = directives;
        this.embeddedTemplateIndex = embeddedTemplateIndex;
        this.appProtoEl = appProtoEl;
    }
}
function visitAndReturnContext(visitor, asts, context) {
    templateVisitAll(visitor, asts, context);
    return context;
}
class ProtoViewFactory {
    constructor(component) {
        this.component = component;
    }
    createCompileProtoView(template, templateVariableBindings, targetStatements, targetProtoViews) {
        var embeddedTemplateIndex = targetProtoViews.length;
        // Note: targetProtoViews needs to be in depth first order.
        // So we "reserve" a space here that we fill after the recursion is done
        targetProtoViews.push(null);
        var builder = new ProtoViewBuilderVisitor(this, targetStatements, targetProtoViews);
        templateVisitAll(builder, template);
        var viewType = getViewType(this.component, embeddedTemplateIndex);
        var appProtoView = this.createAppProtoView(embeddedTemplateIndex, viewType, templateVariableBindings, targetStatements);
        var cpv = new CompileProtoView(embeddedTemplateIndex, builder.protoElements, appProtoView);
        targetProtoViews[embeddedTemplateIndex] = cpv;
        return cpv;
    }
}
class CodeGenProtoViewFactory extends ProtoViewFactory {
    constructor(resolvedMetadataCacheExpr, component, pipes) {
        super(component);
        this.resolvedMetadataCacheExpr = resolvedMetadataCacheExpr;
        this.pipes = pipes;
        this._nextVarId = 0;
    }
    _nextProtoViewVar(embeddedTemplateIndex) {
        return `appProtoView${this._nextVarId++}_${this.component.type.name}${embeddedTemplateIndex}`;
    }
    createAppProtoView(embeddedTemplateIndex, viewType, templateVariableBindings, targetStatements) {
        var protoViewVarName = this._nextProtoViewVar(embeddedTemplateIndex);
        var viewTypeExpr = codeGenViewType(viewType);
        var pipesExpr = embeddedTemplateIndex === 0 ?
            codeGenTypesArray(this.pipes.map(pipeMeta => pipeMeta.type)) :
            null;
        var statement = `var ${protoViewVarName} = ${APP_VIEW_MODULE_REF}AppProtoView.create(${this.resolvedMetadataCacheExpr.expression}, ${viewTypeExpr}, ${pipesExpr}, ${codeGenStringMap(templateVariableBindings)});`;
        targetStatements.push(new Statement(statement));
        return new Expression(protoViewVarName);
    }
    createAppProtoElement(boundElementIndex, attrNameAndValues, variableNameAndValues, directives, targetStatements) {
        var varName = `appProtoEl${this._nextVarId++}_${this.component.type.name}`;
        var value = `${APP_EL_MODULE_REF}AppProtoElement.create(
        ${this.resolvedMetadataCacheExpr.expression},
        ${boundElementIndex},
        ${codeGenStringMap(attrNameAndValues)},
        ${codeGenDirectivesArray(directives)},
        ${codeGenStringMap(variableNameAndValues)}
      )`;
        var statement = `var ${varName} = ${value};`;
        targetStatements.push(new Statement(statement));
        return new Expression(varName);
    }
}
class RuntimeProtoViewFactory extends ProtoViewFactory {
    constructor(metadataCache, component, pipes) {
        super(component);
        this.metadataCache = metadataCache;
        this.pipes = pipes;
    }
    createAppProtoView(embeddedTemplateIndex, viewType, templateVariableBindings, targetStatements) {
        var pipes = embeddedTemplateIndex === 0 ? this.pipes.map(pipeMeta => pipeMeta.type.runtime) : [];
        var templateVars = keyValueArrayToStringMap(templateVariableBindings);
        return AppProtoView.create(this.metadataCache, viewType, pipes, templateVars);
    }
    createAppProtoElement(boundElementIndex, attrNameAndValues, variableNameAndValues, directives, targetStatements) {
        var attrs = keyValueArrayToStringMap(attrNameAndValues);
        return AppProtoElement.create(this.metadataCache, boundElementIndex, attrs, directives.map(dirMeta => dirMeta.type.runtime), keyValueArrayToStringMap(variableNameAndValues));
    }
}
class ProtoViewBuilderVisitor {
    constructor(factory, allStatements, allProtoViews) {
        this.factory = factory;
        this.allStatements = allStatements;
        this.allProtoViews = allProtoViews;
        this.protoElements = [];
        this.boundElementCount = 0;
    }
    _readAttrNameAndValues(directives, attrAsts) {
        var attrs = visitAndReturnContext(this, attrAsts, {});
        directives.forEach(directiveMeta => {
            StringMapWrapper.forEach(directiveMeta.hostAttributes, (value, name) => {
                var prevValue = attrs[name];
                attrs[name] = isPresent(prevValue) ? mergeAttributeValue(name, prevValue, value) : value;
            });
        });
        return mapToKeyValueArray(attrs);
    }
    visitBoundText(ast, context) { return null; }
    visitText(ast, context) { return null; }
    visitNgContent(ast, context) { return null; }
    visitElement(ast, context) {
        var boundElementIndex = null;
        if (ast.isBound()) {
            boundElementIndex = this.boundElementCount++;
        }
        var component = ast.getComponent();
        var variableNameAndValues = [];
        if (isBlank(component)) {
            ast.exportAsVars.forEach((varAst) => { variableNameAndValues.push([varAst.name, null]); });
        }
        var directives = [];
        var renderEvents = visitAndReturnContext(this, ast.outputs, new Map());
        ListWrapper.forEachWithIndex(ast.directives, (directiveAst, index) => {
            directiveAst.visit(this, new DirectiveContext(index, boundElementIndex, renderEvents, variableNameAndValues, directives));
        });
        var renderEventArray = [];
        renderEvents.forEach((eventAst, _) => renderEventArray.push(eventAst));
        var attrNameAndValues = this._readAttrNameAndValues(directives, ast.attrs);
        this._addProtoElement(ast.isBound(), boundElementIndex, attrNameAndValues, variableNameAndValues, renderEventArray, directives, null);
        templateVisitAll(this, ast.children);
        return null;
    }
    visitEmbeddedTemplate(ast, context) {
        var boundElementIndex = this.boundElementCount++;
        var directives = [];
        ListWrapper.forEachWithIndex(ast.directives, (directiveAst, index) => {
            directiveAst.visit(this, new DirectiveContext(index, boundElementIndex, new Map(), [], directives));
        });
        var attrNameAndValues = this._readAttrNameAndValues(directives, ast.attrs);
        var templateVariableBindings = ast.vars.map(varAst => [varAst.value.length > 0 ? varAst.value : IMPLICIT_TEMPLATE_VAR, varAst.name]);
        var nestedProtoView = this.factory.createCompileProtoView(ast.children, templateVariableBindings, this.allStatements, this.allProtoViews);
        this._addProtoElement(true, boundElementIndex, attrNameAndValues, [], [], directives, nestedProtoView.embeddedTemplateIndex);
        return null;
    }
    _addProtoElement(isBound, boundElementIndex, attrNameAndValues, variableNameAndValues, renderEvents, directives, embeddedTemplateIndex) {
        var appProtoEl = null;
        if (isBound) {
            appProtoEl =
                this.factory.createAppProtoElement(boundElementIndex, attrNameAndValues, variableNameAndValues, directives, this.allStatements);
        }
        var compileProtoEl = new CompileProtoElement(boundElementIndex, attrNameAndValues, variableNameAndValues, renderEvents, directives, embeddedTemplateIndex, appProtoEl);
        this.protoElements.push(compileProtoEl);
    }
    visitVariable(ast, ctx) { return null; }
    visitAttr(ast, attrNameAndValues) {
        attrNameAndValues[ast.name] = ast.value;
        return null;
    }
    visitDirective(ast, ctx) {
        ctx.targetDirectives.push(ast.directive);
        templateVisitAll(this, ast.hostEvents, ctx.hostEventTargetAndNames);
        ast.exportAsVars.forEach(varAst => { ctx.targetVariableNameAndValues.push([varAst.name, ctx.index]); });
        return null;
    }
    visitEvent(ast, eventTargetAndNames) {
        eventTargetAndNames.set(ast.fullName, ast);
        return null;
    }
    visitDirectiveProperty(ast, context) { return null; }
    visitElementProperty(ast, context) { return null; }
}
function mapToKeyValueArray(data) {
    var entryArray = [];
    StringMapWrapper.forEach(data, (value, name) => { entryArray.push([name, value]); });
    // We need to sort to get a defined output order
    // for tests and for caching generated artifacts...
    ListWrapper.sort(entryArray, (entry1, entry2) => StringWrapper.compare(entry1[0], entry2[0]));
    var keyValueArray = [];
    entryArray.forEach((entry) => { keyValueArray.push([entry[0], entry[1]]); });
    return keyValueArray;
}
function mergeAttributeValue(attrName, attrValue1, attrValue2) {
    if (attrName == CLASS_ATTR || attrName == STYLE_ATTR) {
        return `${attrValue1} ${attrValue2}`;
    }
    else {
        return attrValue2;
    }
}
class DirectiveContext {
    constructor(index, boundElementIndex, hostEventTargetAndNames, targetVariableNameAndValues, targetDirectives) {
        this.index = index;
        this.boundElementIndex = boundElementIndex;
        this.hostEventTargetAndNames = hostEventTargetAndNames;
        this.targetVariableNameAndValues = targetVariableNameAndValues;
        this.targetDirectives = targetDirectives;
    }
}
function keyValueArrayToStringMap(keyValueArray) {
    var stringMap = {};
    for (var i = 0; i < keyValueArray.length; i++) {
        var entry = keyValueArray[i];
        stringMap[entry[0]] = entry[1];
    }
    return stringMap;
}
function codeGenDirectivesArray(directives) {
    var expressions = directives.map(directiveType => typeRef(directiveType.type));
    return `[${expressions.join(',')}]`;
}
function codeGenTypesArray(types) {
    var expressions = types.map(typeRef);
    return `[${expressions.join(',')}]`;
}
function codeGenViewType(value) {
    if (IS_DART) {
        return `${VIEW_TYPE_MODULE_REF}${value}`;
    }
    else {
        return `${value}`;
    }
}
function typeRef(type) {
    return `${moduleRef(type.moduleUrl)}${type.name}`;
}
function getViewType(component, embeddedTemplateIndex) {
    if (embeddedTemplateIndex > 0) {
        return ViewType.EMBEDDED;
    }
    else if (component.type.isHost) {
        return ViewType.HOST;
    }
    else {
        return ViewType.COMPONENT;
    }
}
//# sourceMappingURL=data:application/json;base64,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