'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var lang_1 = require('angular2/src/facade/lang');
var exceptions_1 = require('angular2/src/facade/exceptions');
var collection_1 = require('angular2/src/facade/collection');
var async_1 = require('angular2/src/facade/async');
var directive_metadata_1 = require('./directive_metadata');
var template_ast_1 = require('./template_ast');
var di_1 = require('angular2/src/core/di');
var source_module_1 = require('./source_module');
var change_detector_compiler_1 = require('./change_detector_compiler');
var style_compiler_1 = require('./style_compiler');
var view_compiler_1 = require('./view_compiler');
var proto_view_compiler_1 = require('./proto_view_compiler');
var template_parser_1 = require('./template_parser');
var template_normalizer_1 = require('./template_normalizer');
var runtime_metadata_1 = require('./runtime_metadata');
var view_1 = require('angular2/src/core/linker/view');
var change_detection_1 = require('angular2/src/core/change_detection/change_detection');
var resolved_metadata_cache_1 = require('angular2/src/core/linker/resolved_metadata_cache');
var util_1 = require('./util');
exports.METADATA_CACHE_MODULE_REF = source_module_1.moduleRef('package:angular2/src/core/linker/resolved_metadata_cache' + util_1.MODULE_SUFFIX);
/**
 * An internal module of the Angular compiler that begins with component types,
 * extracts templates, and eventually produces a compiled version of the component
 * ready for linking into an application.
 */
var TemplateCompiler = (function () {
    function TemplateCompiler(_runtimeMetadataResolver, _templateNormalizer, _templateParser, _styleCompiler, _cdCompiler, _protoViewCompiler, _viewCompiler, _resolvedMetadataCache, _genConfig) {
        this._runtimeMetadataResolver = _runtimeMetadataResolver;
        this._templateNormalizer = _templateNormalizer;
        this._templateParser = _templateParser;
        this._styleCompiler = _styleCompiler;
        this._cdCompiler = _cdCompiler;
        this._protoViewCompiler = _protoViewCompiler;
        this._viewCompiler = _viewCompiler;
        this._resolvedMetadataCache = _resolvedMetadataCache;
        this._genConfig = _genConfig;
        this._hostCacheKeys = new Map();
        this._compiledTemplateCache = new Map();
        this._compiledTemplateDone = new Map();
    }
    TemplateCompiler.prototype.normalizeDirectiveMetadata = function (directive) {
        if (!directive.isComponent) {
            // For non components there is nothing to be normalized yet.
            return async_1.PromiseWrapper.resolve(directive);
        }
        return this._templateNormalizer.normalizeTemplate(directive.type, directive.template)
            .then(function (normalizedTemplate) { return new directive_metadata_1.CompileDirectiveMetadata({
            type: directive.type,
            isComponent: directive.isComponent,
            dynamicLoadable: directive.dynamicLoadable,
            selector: directive.selector,
            exportAs: directive.exportAs,
            changeDetection: directive.changeDetection,
            inputs: directive.inputs,
            outputs: directive.outputs,
            hostListeners: directive.hostListeners,
            hostProperties: directive.hostProperties,
            hostAttributes: directive.hostAttributes,
            lifecycleHooks: directive.lifecycleHooks,
            template: normalizedTemplate
        }); });
    };
    TemplateCompiler.prototype.compileHostComponentRuntime = function (type) {
        var compMeta = this._runtimeMetadataResolver.getDirectiveMetadata(type);
        var hostCacheKey = this._hostCacheKeys.get(type);
        if (lang_1.isBlank(hostCacheKey)) {
            hostCacheKey = new Object();
            this._hostCacheKeys.set(type, hostCacheKey);
            assertComponent(compMeta);
            var hostMeta = directive_metadata_1.createHostComponentMeta(compMeta.type, compMeta.selector);
            this._compileComponentRuntime(hostCacheKey, hostMeta, [compMeta], [], []);
        }
        return this._compiledTemplateDone.get(hostCacheKey)
            .then(function (compiledTemplate) {
            return new view_1.HostViewFactory(compMeta.selector, compiledTemplate.viewFactory);
        });
    };
    TemplateCompiler.prototype.clearCache = function () {
        this._styleCompiler.clearCache();
        this._compiledTemplateCache.clear();
        this._compiledTemplateDone.clear();
        this._hostCacheKeys.clear();
    };
    TemplateCompiler.prototype.compileTemplatesCodeGen = function (components) {
        var _this = this;
        if (components.length === 0) {
            throw new exceptions_1.BaseException('No components given');
        }
        var declarations = [];
        components.forEach(function (componentWithDirs) {
            var compMeta = componentWithDirs.component;
            assertComponent(compMeta);
            _this._compileComponentCodeGen(compMeta, componentWithDirs.directives, componentWithDirs.pipes, declarations);
            if (compMeta.dynamicLoadable) {
                var hostMeta = directive_metadata_1.createHostComponentMeta(compMeta.type, compMeta.selector);
                var viewFactoryExpression = _this._compileComponentCodeGen(hostMeta, [compMeta], [], declarations);
                var constructionKeyword = lang_1.IS_DART ? 'const' : 'new';
                var compiledTemplateExpr = constructionKeyword + " " + proto_view_compiler_1.APP_VIEW_MODULE_REF + "HostViewFactory('" + compMeta.selector + "'," + viewFactoryExpression + ")";
                var varName = codeGenHostViewFactoryName(compMeta.type);
                declarations.push("" + util_1.codeGenExportVariable(varName) + compiledTemplateExpr + ";");
            }
        });
        var moduleUrl = components[0].component.type.moduleUrl;
        return new source_module_1.SourceModule("" + templateModuleUrl(moduleUrl), declarations.join('\n'));
    };
    TemplateCompiler.prototype.compileStylesheetCodeGen = function (stylesheetUrl, cssText) {
        return this._styleCompiler.compileStylesheetCodeGen(stylesheetUrl, cssText);
    };
    TemplateCompiler.prototype._compileComponentRuntime = function (cacheKey, compMeta, viewDirectives, pipes, compilingComponentsPath) {
        var _this = this;
        var uniqViewDirectives = removeDuplicates(viewDirectives);
        var uniqViewPipes = removeDuplicates(pipes);
        var compiledTemplate = this._compiledTemplateCache.get(cacheKey);
        var done = this._compiledTemplateDone.get(cacheKey);
        if (lang_1.isBlank(compiledTemplate)) {
            compiledTemplate = new CompiledTemplate();
            this._compiledTemplateCache.set(cacheKey, compiledTemplate);
            done = async_1.PromiseWrapper
                .all([this._styleCompiler.compileComponentRuntime(compMeta.template)].concat(uniqViewDirectives.map(function (dirMeta) { return _this.normalizeDirectiveMetadata(dirMeta); })))
                .then(function (stylesAndNormalizedViewDirMetas) {
                var normalizedViewDirMetas = stylesAndNormalizedViewDirMetas.slice(1);
                var styles = stylesAndNormalizedViewDirMetas[0];
                var parsedTemplate = _this._templateParser.parse(compMeta.template.template, normalizedViewDirMetas, uniqViewPipes, compMeta.type.name);
                var childPromises = [];
                var usedDirectives = DirectiveCollector.findUsedDirectives(parsedTemplate);
                usedDirectives.components.forEach(function (component) { return _this._compileNestedComponentRuntime(component, compilingComponentsPath, childPromises); });
                return async_1.PromiseWrapper.all(childPromises)
                    .then(function (_) {
                    var filteredPipes = filterPipes(parsedTemplate, uniqViewPipes);
                    compiledTemplate.init(_this._createViewFactoryRuntime(compMeta, parsedTemplate, usedDirectives.directives, styles, filteredPipes));
                    return compiledTemplate;
                });
            });
            this._compiledTemplateDone.set(cacheKey, done);
        }
        return compiledTemplate;
    };
    TemplateCompiler.prototype._compileNestedComponentRuntime = function (childComponentDir, parentCompilingComponentsPath, childPromises) {
        var compilingComponentsPath = collection_1.ListWrapper.clone(parentCompilingComponentsPath);
        var childCacheKey = childComponentDir.type.runtime;
        var childViewDirectives = this._runtimeMetadataResolver.getViewDirectivesMetadata(childComponentDir.type.runtime);
        var childViewPipes = this._runtimeMetadataResolver.getViewPipesMetadata(childComponentDir.type.runtime);
        var childIsRecursive = collection_1.ListWrapper.contains(compilingComponentsPath, childCacheKey);
        compilingComponentsPath.push(childCacheKey);
        this._compileComponentRuntime(childCacheKey, childComponentDir, childViewDirectives, childViewPipes, compilingComponentsPath);
        if (!childIsRecursive) {
            // Only wait for a child if it is not a cycle
            childPromises.push(this._compiledTemplateDone.get(childCacheKey));
        }
    };
    TemplateCompiler.prototype._createViewFactoryRuntime = function (compMeta, parsedTemplate, directives, styles, pipes) {
        var _this = this;
        if (lang_1.IS_DART || !this._genConfig.useJit) {
            var changeDetectorFactories = this._cdCompiler.compileComponentRuntime(compMeta.type, compMeta.changeDetection, parsedTemplate);
            var protoViews = this._protoViewCompiler.compileProtoViewRuntime(this._resolvedMetadataCache, compMeta, parsedTemplate, pipes);
            return this._viewCompiler.compileComponentRuntime(compMeta, parsedTemplate, styles, protoViews.protoViews, changeDetectorFactories, function (compMeta) { return _this._getNestedComponentViewFactory(compMeta); });
        }
        else {
            var declarations = [];
            var viewFactoryExpr = this._createViewFactoryCodeGen('resolvedMetadataCache', compMeta, new source_module_1.SourceExpression([], 'styles'), parsedTemplate, pipes, declarations);
            var vars = { 'exports': {}, 'styles': styles, 'resolvedMetadataCache': this._resolvedMetadataCache };
            directives.forEach(function (dirMeta) {
                vars[dirMeta.type.name] = dirMeta.type.runtime;
                if (dirMeta.isComponent && dirMeta.type.runtime !== compMeta.type.runtime) {
                    vars[("viewFactory_" + dirMeta.type.name + "0")] = _this._getNestedComponentViewFactory(dirMeta);
                }
            });
            pipes.forEach(function (pipeMeta) { return vars[pipeMeta.type.name] = pipeMeta.type.runtime; });
            var declarationsWithoutImports = source_module_1.SourceModule.getSourceWithoutImports(declarations.join('\n'));
            return lang_1.evalExpression("viewFactory_" + compMeta.type.name, viewFactoryExpr, declarationsWithoutImports, mergeStringMaps([vars, change_detector_compiler_1.CHANGE_DETECTION_JIT_IMPORTS, proto_view_compiler_1.PROTO_VIEW_JIT_IMPORTS, view_compiler_1.VIEW_JIT_IMPORTS]));
        }
    };
    TemplateCompiler.prototype._getNestedComponentViewFactory = function (compMeta) {
        return this._compiledTemplateCache.get(compMeta.type.runtime).viewFactory;
    };
    TemplateCompiler.prototype._compileComponentCodeGen = function (compMeta, directives, pipes, targetDeclarations) {
        var uniqueDirectives = removeDuplicates(directives);
        var uniqPipes = removeDuplicates(pipes);
        var styleExpr = this._styleCompiler.compileComponentCodeGen(compMeta.template);
        var parsedTemplate = this._templateParser.parse(compMeta.template.template, uniqueDirectives, uniqPipes, compMeta.type.name);
        var filteredPipes = filterPipes(parsedTemplate, uniqPipes);
        return this._createViewFactoryCodeGen(exports.METADATA_CACHE_MODULE_REF + "CODEGEN_RESOLVED_METADATA_CACHE", compMeta, styleExpr, parsedTemplate, filteredPipes, targetDeclarations);
    };
    TemplateCompiler.prototype._createViewFactoryCodeGen = function (resolvedMetadataCacheExpr, compMeta, styleExpr, parsedTemplate, pipes, targetDeclarations) {
        var changeDetectorsExprs = this._cdCompiler.compileComponentCodeGen(compMeta.type, compMeta.changeDetection, parsedTemplate);
        var protoViewExprs = this._protoViewCompiler.compileProtoViewCodeGen(new util_1.Expression(resolvedMetadataCacheExpr), compMeta, parsedTemplate, pipes);
        var viewFactoryExpr = this._viewCompiler.compileComponentCodeGen(compMeta, parsedTemplate, styleExpr, protoViewExprs.protoViews, changeDetectorsExprs, codeGenComponentViewFactoryName);
        util_1.addAll(changeDetectorsExprs.declarations, targetDeclarations);
        util_1.addAll(protoViewExprs.declarations, targetDeclarations);
        util_1.addAll(viewFactoryExpr.declarations, targetDeclarations);
        return viewFactoryExpr.expression;
    };
    TemplateCompiler = __decorate([
        di_1.Injectable(), 
        __metadata('design:paramtypes', [runtime_metadata_1.RuntimeMetadataResolver, template_normalizer_1.TemplateNormalizer, template_parser_1.TemplateParser, style_compiler_1.StyleCompiler, change_detector_compiler_1.ChangeDetectionCompiler, proto_view_compiler_1.ProtoViewCompiler, view_compiler_1.ViewCompiler, resolved_metadata_cache_1.ResolvedMetadataCache, change_detection_1.ChangeDetectorGenConfig])
    ], TemplateCompiler);
    return TemplateCompiler;
})();
exports.TemplateCompiler = TemplateCompiler;
var NormalizedComponentWithViewDirectives = (function () {
    function NormalizedComponentWithViewDirectives(component, directives, pipes) {
        this.component = component;
        this.directives = directives;
        this.pipes = pipes;
    }
    return NormalizedComponentWithViewDirectives;
})();
exports.NormalizedComponentWithViewDirectives = NormalizedComponentWithViewDirectives;
var CompiledTemplate = (function () {
    function CompiledTemplate() {
        this.viewFactory = null;
    }
    CompiledTemplate.prototype.init = function (viewFactory) { this.viewFactory = viewFactory; };
    return CompiledTemplate;
})();
function assertComponent(meta) {
    if (!meta.isComponent) {
        throw new exceptions_1.BaseException("Could not compile '" + meta.type.name + "' because it is not a component.");
    }
}
function templateModuleUrl(moduleUrl) {
    var urlWithoutSuffix = moduleUrl.substring(0, moduleUrl.length - util_1.MODULE_SUFFIX.length);
    return urlWithoutSuffix + ".template" + util_1.MODULE_SUFFIX;
}
function codeGenHostViewFactoryName(type) {
    return "hostViewFactory_" + type.name;
}
function codeGenComponentViewFactoryName(nestedCompType) {
    return source_module_1.moduleRef(templateModuleUrl(nestedCompType.type.moduleUrl)) + "viewFactory_" + nestedCompType.type.name + "0";
}
function mergeStringMaps(maps) {
    var result = {};
    maps.forEach(function (map) { collection_1.StringMapWrapper.forEach(map, function (value, key) { result[key] = value; }); });
    return result;
}
function removeDuplicates(items) {
    var res = [];
    items.forEach(function (item) {
        var hasMatch = res.filter(function (r) { return r.type.name == item.type.name && r.type.moduleUrl == item.type.moduleUrl &&
            r.type.runtime == item.type.runtime; })
            .length > 0;
        if (!hasMatch) {
            res.push(item);
        }
    });
    return res;
}
var DirectiveCollector = (function () {
    function DirectiveCollector() {
        this.directives = [];
        this.components = [];
    }
    DirectiveCollector.findUsedDirectives = function (parsedTemplate) {
        var collector = new DirectiveCollector();
        template_ast_1.templateVisitAll(collector, parsedTemplate);
        return collector;
    };
    DirectiveCollector.prototype.visitBoundText = function (ast, context) { return null; };
    DirectiveCollector.prototype.visitText = function (ast, context) { return null; };
    DirectiveCollector.prototype.visitNgContent = function (ast, context) { return null; };
    DirectiveCollector.prototype.visitElement = function (ast, context) {
        template_ast_1.templateVisitAll(this, ast.directives);
        template_ast_1.templateVisitAll(this, ast.children);
        return null;
    };
    DirectiveCollector.prototype.visitEmbeddedTemplate = function (ast, context) {
        template_ast_1.templateVisitAll(this, ast.directives);
        template_ast_1.templateVisitAll(this, ast.children);
        return null;
    };
    DirectiveCollector.prototype.visitVariable = function (ast, ctx) { return null; };
    DirectiveCollector.prototype.visitAttr = function (ast, attrNameAndValues) { return null; };
    DirectiveCollector.prototype.visitDirective = function (ast, ctx) {
        if (ast.directive.isComponent) {
            this.components.push(ast.directive);
        }
        this.directives.push(ast.directive);
        return null;
    };
    DirectiveCollector.prototype.visitEvent = function (ast, eventTargetAndNames) {
        return null;
    };
    DirectiveCollector.prototype.visitDirectiveProperty = function (ast, context) { return null; };
    DirectiveCollector.prototype.visitElementProperty = function (ast, context) { return null; };
    return DirectiveCollector;
})();
function filterPipes(template, allPipes) {
    var visitor = new PipeVisitor();
    template_ast_1.templateVisitAll(visitor, template);
    return allPipes.filter(function (pipeMeta) { return collection_1.SetWrapper.has(visitor.collector.pipes, pipeMeta.name); });
}
var PipeVisitor = (function () {
    function PipeVisitor() {
        this.collector = new template_parser_1.PipeCollector();
    }
    PipeVisitor.prototype.visitBoundText = function (ast, context) {
        ast.value.visit(this.collector);
        return null;
    };
    PipeVisitor.prototype.visitText = function (ast, context) { return null; };
    PipeVisitor.prototype.visitNgContent = function (ast, context) { return null; };
    PipeVisitor.prototype.visitElement = function (ast, context) {
        template_ast_1.templateVisitAll(this, ast.inputs);
        template_ast_1.templateVisitAll(this, ast.outputs);
        template_ast_1.templateVisitAll(this, ast.directives);
        template_ast_1.templateVisitAll(this, ast.children);
        return null;
    };
    PipeVisitor.prototype.visitEmbeddedTemplate = function (ast, context) {
        template_ast_1.templateVisitAll(this, ast.outputs);
        template_ast_1.templateVisitAll(this, ast.directives);
        template_ast_1.templateVisitAll(this, ast.children);
        return null;
    };
    PipeVisitor.prototype.visitVariable = function (ast, ctx) { return null; };
    PipeVisitor.prototype.visitAttr = function (ast, attrNameAndValues) { return null; };
    PipeVisitor.prototype.visitDirective = function (ast, ctx) {
        template_ast_1.templateVisitAll(this, ast.inputs);
        template_ast_1.templateVisitAll(this, ast.hostEvents);
        template_ast_1.templateVisitAll(this, ast.hostProperties);
        return null;
    };
    PipeVisitor.prototype.visitEvent = function (ast, eventTargetAndNames) {
        ast.handler.visit(this.collector);
        return null;
    };
    PipeVisitor.prototype.visitDirectiveProperty = function (ast, context) {
        ast.value.visit(this.collector);
        return null;
    };
    PipeVisitor.prototype.visitElementProperty = function (ast, context) {
        ast.value.visit(this.collector);
        return null;
    };
    return PipeVisitor;
})();
//# sourceMappingURL=data:application/json;base64,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