var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { IS_DART, isBlank, evalExpression } from 'angular2/src/facade/lang';
import { BaseException } from 'angular2/src/facade/exceptions';
import { ListWrapper, SetWrapper, StringMapWrapper } from 'angular2/src/facade/collection';
import { PromiseWrapper } from 'angular2/src/facade/async';
import { createHostComponentMeta, CompileDirectiveMetadata } from './directive_metadata';
import { templateVisitAll } from './template_ast';
import { Injectable } from 'angular2/src/core/di';
import { SourceModule, moduleRef, SourceExpression } from './source_module';
import { ChangeDetectionCompiler, CHANGE_DETECTION_JIT_IMPORTS } from './change_detector_compiler';
import { StyleCompiler } from './style_compiler';
import { ViewCompiler, VIEW_JIT_IMPORTS } from './view_compiler';
import { ProtoViewCompiler, APP_VIEW_MODULE_REF, PROTO_VIEW_JIT_IMPORTS } from './proto_view_compiler';
import { TemplateParser, PipeCollector } from './template_parser';
import { TemplateNormalizer } from './template_normalizer';
import { RuntimeMetadataResolver } from './runtime_metadata';
import { HostViewFactory } from 'angular2/src/core/linker/view';
import { ChangeDetectorGenConfig } from 'angular2/src/core/change_detection/change_detection';
import { ResolvedMetadataCache } from 'angular2/src/core/linker/resolved_metadata_cache';
import { codeGenExportVariable, MODULE_SUFFIX, addAll, Expression } from './util';
export var METADATA_CACHE_MODULE_REF = moduleRef('package:angular2/src/core/linker/resolved_metadata_cache' + MODULE_SUFFIX);
/**
 * An internal module of the Angular compiler that begins with component types,
 * extracts templates, and eventually produces a compiled version of the component
 * ready for linking into an application.
 */
export let TemplateCompiler = class {
    constructor(_runtimeMetadataResolver, _templateNormalizer, _templateParser, _styleCompiler, _cdCompiler, _protoViewCompiler, _viewCompiler, _resolvedMetadataCache, _genConfig) {
        this._runtimeMetadataResolver = _runtimeMetadataResolver;
        this._templateNormalizer = _templateNormalizer;
        this._templateParser = _templateParser;
        this._styleCompiler = _styleCompiler;
        this._cdCompiler = _cdCompiler;
        this._protoViewCompiler = _protoViewCompiler;
        this._viewCompiler = _viewCompiler;
        this._resolvedMetadataCache = _resolvedMetadataCache;
        this._genConfig = _genConfig;
        this._hostCacheKeys = new Map();
        this._compiledTemplateCache = new Map();
        this._compiledTemplateDone = new Map();
    }
    normalizeDirectiveMetadata(directive) {
        if (!directive.isComponent) {
            // For non components there is nothing to be normalized yet.
            return PromiseWrapper.resolve(directive);
        }
        return this._templateNormalizer.normalizeTemplate(directive.type, directive.template)
            .then((normalizedTemplate) => new CompileDirectiveMetadata({
            type: directive.type,
            isComponent: directive.isComponent,
            dynamicLoadable: directive.dynamicLoadable,
            selector: directive.selector,
            exportAs: directive.exportAs,
            changeDetection: directive.changeDetection,
            inputs: directive.inputs,
            outputs: directive.outputs,
            hostListeners: directive.hostListeners,
            hostProperties: directive.hostProperties,
            hostAttributes: directive.hostAttributes,
            lifecycleHooks: directive.lifecycleHooks,
            providers: directive.providers,
            template: normalizedTemplate
        }));
    }
    compileHostComponentRuntime(type) {
        var compMeta = this._runtimeMetadataResolver.getDirectiveMetadata(type);
        var hostCacheKey = this._hostCacheKeys.get(type);
        if (isBlank(hostCacheKey)) {
            hostCacheKey = new Object();
            this._hostCacheKeys.set(type, hostCacheKey);
            assertComponent(compMeta);
            var hostMeta = createHostComponentMeta(compMeta.type, compMeta.selector);
            this._compileComponentRuntime(hostCacheKey, hostMeta, [compMeta], [], []);
        }
        return this._compiledTemplateDone.get(hostCacheKey)
            .then((compiledTemplate) => new HostViewFactory(compMeta.selector, compiledTemplate.viewFactory));
    }
    clearCache() {
        this._styleCompiler.clearCache();
        this._compiledTemplateCache.clear();
        this._compiledTemplateDone.clear();
        this._hostCacheKeys.clear();
    }
    compileTemplatesCodeGen(components) {
        if (components.length === 0) {
            throw new BaseException('No components given');
        }
        var declarations = [];
        components.forEach(componentWithDirs => {
            var compMeta = componentWithDirs.component;
            assertComponent(compMeta);
            this._compileComponentCodeGen(compMeta, componentWithDirs.directives, componentWithDirs.pipes, declarations);
            if (compMeta.dynamicLoadable) {
                var hostMeta = createHostComponentMeta(compMeta.type, compMeta.selector);
                var viewFactoryExpression = this._compileComponentCodeGen(hostMeta, [compMeta], [], declarations);
                var constructionKeyword = IS_DART ? 'const' : 'new';
                var compiledTemplateExpr = `${constructionKeyword} ${APP_VIEW_MODULE_REF}HostViewFactory('${compMeta.selector}',${viewFactoryExpression})`;
                var varName = codeGenHostViewFactoryName(compMeta.type);
                declarations.push(`${codeGenExportVariable(varName)}${compiledTemplateExpr};`);
            }
        });
        var moduleUrl = components[0].component.type.moduleUrl;
        return new SourceModule(`${templateModuleUrl(moduleUrl)}`, declarations.join('\n'));
    }
    compileStylesheetCodeGen(stylesheetUrl, cssText) {
        return this._styleCompiler.compileStylesheetCodeGen(stylesheetUrl, cssText);
    }
    _compileComponentRuntime(cacheKey, compMeta, viewDirectives, pipes, compilingComponentsPath) {
        let uniqViewDirectives = removeDuplicates(viewDirectives);
        let uniqViewPipes = removeDuplicates(pipes);
        var compiledTemplate = this._compiledTemplateCache.get(cacheKey);
        var done = this._compiledTemplateDone.get(cacheKey);
        if (isBlank(compiledTemplate)) {
            compiledTemplate = new CompiledTemplate();
            this._compiledTemplateCache.set(cacheKey, compiledTemplate);
            done = PromiseWrapper
                .all([this._styleCompiler.compileComponentRuntime(compMeta.template)].concat(uniqViewDirectives.map(dirMeta => this.normalizeDirectiveMetadata(dirMeta))))
                .then((stylesAndNormalizedViewDirMetas) => {
                var normalizedViewDirMetas = stylesAndNormalizedViewDirMetas.slice(1);
                var styles = stylesAndNormalizedViewDirMetas[0];
                var parsedTemplate = this._templateParser.parse(compMeta.template.template, normalizedViewDirMetas, uniqViewPipes, compMeta.type.name);
                var childPromises = [];
                var usedDirectives = DirectiveCollector.findUsedDirectives(parsedTemplate);
                usedDirectives.components.forEach(component => this._compileNestedComponentRuntime(component, compilingComponentsPath, childPromises));
                return PromiseWrapper.all(childPromises)
                    .then((_) => {
                    var filteredPipes = filterPipes(parsedTemplate, uniqViewPipes);
                    compiledTemplate.init(this._createViewFactoryRuntime(compMeta, parsedTemplate, usedDirectives.directives, styles, filteredPipes));
                    return compiledTemplate;
                });
            });
            this._compiledTemplateDone.set(cacheKey, done);
        }
        return compiledTemplate;
    }
    _compileNestedComponentRuntime(childComponentDir, parentCompilingComponentsPath, childPromises) {
        var compilingComponentsPath = ListWrapper.clone(parentCompilingComponentsPath);
        var childCacheKey = childComponentDir.type.runtime;
        var childViewDirectives = this._runtimeMetadataResolver.getViewDirectivesMetadata(childComponentDir.type.runtime);
        var childViewPipes = this._runtimeMetadataResolver.getViewPipesMetadata(childComponentDir.type.runtime);
        var childIsRecursive = ListWrapper.contains(compilingComponentsPath, childCacheKey);
        compilingComponentsPath.push(childCacheKey);
        this._compileComponentRuntime(childCacheKey, childComponentDir, childViewDirectives, childViewPipes, compilingComponentsPath);
        if (!childIsRecursive) {
            // Only wait for a child if it is not a cycle
            childPromises.push(this._compiledTemplateDone.get(childCacheKey));
        }
    }
    _createViewFactoryRuntime(compMeta, parsedTemplate, directives, styles, pipes) {
        if (IS_DART || !this._genConfig.useJit) {
            var changeDetectorFactories = this._cdCompiler.compileComponentRuntime(compMeta.type, compMeta.changeDetection, parsedTemplate);
            var protoViews = this._protoViewCompiler.compileProtoViewRuntime(this._resolvedMetadataCache, compMeta, parsedTemplate, pipes);
            return this._viewCompiler.compileComponentRuntime(compMeta, parsedTemplate, styles, protoViews.protoViews, changeDetectorFactories, (compMeta) => this._getNestedComponentViewFactory(compMeta));
        }
        else {
            var declarations = [];
            var viewFactoryExpr = this._createViewFactoryCodeGen('resolvedMetadataCache', compMeta, new SourceExpression([], 'styles'), parsedTemplate, pipes, declarations);
            var vars = { 'exports': {}, 'styles': styles, 'resolvedMetadataCache': this._resolvedMetadataCache };
            directives.forEach(dirMeta => {
                vars[dirMeta.type.name] = dirMeta.type.runtime;
                if (dirMeta.isComponent && dirMeta.type.runtime !== compMeta.type.runtime) {
                    vars[`viewFactory_${dirMeta.type.name}0`] = this._getNestedComponentViewFactory(dirMeta);
                }
            });
            pipes.forEach(pipeMeta => vars[pipeMeta.type.name] = pipeMeta.type.runtime);
            var declarationsWithoutImports = SourceModule.getSourceWithoutImports(declarations.join('\n'));
            return evalExpression(`viewFactory_${compMeta.type.name}`, viewFactoryExpr, declarationsWithoutImports, mergeStringMaps([vars, CHANGE_DETECTION_JIT_IMPORTS, PROTO_VIEW_JIT_IMPORTS, VIEW_JIT_IMPORTS]));
        }
    }
    _getNestedComponentViewFactory(compMeta) {
        return this._compiledTemplateCache.get(compMeta.type.runtime).viewFactory;
    }
    _compileComponentCodeGen(compMeta, directives, pipes, targetDeclarations) {
        let uniqueDirectives = removeDuplicates(directives);
        let uniqPipes = removeDuplicates(pipes);
        var styleExpr = this._styleCompiler.compileComponentCodeGen(compMeta.template);
        var parsedTemplate = this._templateParser.parse(compMeta.template.template, uniqueDirectives, uniqPipes, compMeta.type.name);
        var filteredPipes = filterPipes(parsedTemplate, uniqPipes);
        return this._createViewFactoryCodeGen(`${METADATA_CACHE_MODULE_REF}CODEGEN_RESOLVED_METADATA_CACHE`, compMeta, styleExpr, parsedTemplate, filteredPipes, targetDeclarations);
    }
    _createViewFactoryCodeGen(resolvedMetadataCacheExpr, compMeta, styleExpr, parsedTemplate, pipes, targetDeclarations) {
        var changeDetectorsExprs = this._cdCompiler.compileComponentCodeGen(compMeta.type, compMeta.changeDetection, parsedTemplate);
        var protoViewExprs = this._protoViewCompiler.compileProtoViewCodeGen(new Expression(resolvedMetadataCacheExpr), compMeta, parsedTemplate, pipes);
        var viewFactoryExpr = this._viewCompiler.compileComponentCodeGen(compMeta, parsedTemplate, styleExpr, protoViewExprs.protoViews, changeDetectorsExprs, codeGenComponentViewFactoryName);
        addAll(changeDetectorsExprs.declarations, targetDeclarations);
        addAll(protoViewExprs.declarations, targetDeclarations);
        addAll(viewFactoryExpr.declarations, targetDeclarations);
        return viewFactoryExpr.expression;
    }
};
TemplateCompiler = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [RuntimeMetadataResolver, TemplateNormalizer, TemplateParser, StyleCompiler, ChangeDetectionCompiler, ProtoViewCompiler, ViewCompiler, ResolvedMetadataCache, ChangeDetectorGenConfig])
], TemplateCompiler);
export class NormalizedComponentWithViewDirectives {
    constructor(component, directives, pipes) {
        this.component = component;
        this.directives = directives;
        this.pipes = pipes;
    }
}
class CompiledTemplate {
    constructor() {
        this.viewFactory = null;
    }
    init(viewFactory) { this.viewFactory = viewFactory; }
}
function assertComponent(meta) {
    if (!meta.isComponent) {
        throw new BaseException(`Could not compile '${meta.type.name}' because it is not a component.`);
    }
}
function templateModuleUrl(moduleUrl) {
    var urlWithoutSuffix = moduleUrl.substring(0, moduleUrl.length - MODULE_SUFFIX.length);
    return `${urlWithoutSuffix}.template${MODULE_SUFFIX}`;
}
function codeGenHostViewFactoryName(type) {
    return `hostViewFactory_${type.name}`;
}
function codeGenComponentViewFactoryName(nestedCompType) {
    return `${moduleRef(templateModuleUrl(nestedCompType.type.moduleUrl))}viewFactory_${nestedCompType.type.name}0`;
}
function mergeStringMaps(maps) {
    var result = {};
    maps.forEach((map) => { StringMapWrapper.forEach(map, (value, key) => { result[key] = value; }); });
    return result;
}
function removeDuplicates(items) {
    let res = [];
    items.forEach(item => {
        let hasMatch = res.filter(r => r.type.name == item.type.name && r.type.moduleUrl == item.type.moduleUrl &&
            r.type.runtime == item.type.runtime)
            .length > 0;
        if (!hasMatch) {
            res.push(item);
        }
    });
    return res;
}
class DirectiveCollector {
    constructor() {
        this.directives = [];
        this.components = [];
    }
    static findUsedDirectives(parsedTemplate) {
        var collector = new DirectiveCollector();
        templateVisitAll(collector, parsedTemplate);
        return collector;
    }
    visitBoundText(ast, context) { return null; }
    visitText(ast, context) { return null; }
    visitNgContent(ast, context) { return null; }
    visitElement(ast, context) {
        templateVisitAll(this, ast.directives);
        templateVisitAll(this, ast.children);
        return null;
    }
    visitEmbeddedTemplate(ast, context) {
        templateVisitAll(this, ast.directives);
        templateVisitAll(this, ast.children);
        return null;
    }
    visitVariable(ast, ctx) { return null; }
    visitAttr(ast, attrNameAndValues) { return null; }
    visitDirective(ast, ctx) {
        if (ast.directive.isComponent) {
            this.components.push(ast.directive);
        }
        this.directives.push(ast.directive);
        return null;
    }
    visitEvent(ast, eventTargetAndNames) {
        return null;
    }
    visitDirectiveProperty(ast, context) { return null; }
    visitElementProperty(ast, context) { return null; }
}
function filterPipes(template, allPipes) {
    var visitor = new PipeVisitor();
    templateVisitAll(visitor, template);
    return allPipes.filter((pipeMeta) => SetWrapper.has(visitor.collector.pipes, pipeMeta.name));
}
class PipeVisitor {
    constructor() {
        this.collector = new PipeCollector();
    }
    visitBoundText(ast, context) {
        ast.value.visit(this.collector);
        return null;
    }
    visitText(ast, context) { return null; }
    visitNgContent(ast, context) { return null; }
    visitElement(ast, context) {
        templateVisitAll(this, ast.inputs);
        templateVisitAll(this, ast.outputs);
        templateVisitAll(this, ast.directives);
        templateVisitAll(this, ast.children);
        return null;
    }
    visitEmbeddedTemplate(ast, context) {
        templateVisitAll(this, ast.outputs);
        templateVisitAll(this, ast.directives);
        templateVisitAll(this, ast.children);
        return null;
    }
    visitVariable(ast, ctx) { return null; }
    visitAttr(ast, attrNameAndValues) { return null; }
    visitDirective(ast, ctx) {
        templateVisitAll(this, ast.inputs);
        templateVisitAll(this, ast.hostEvents);
        templateVisitAll(this, ast.hostProperties);
        return null;
    }
    visitEvent(ast, eventTargetAndNames) {
        ast.handler.visit(this.collector);
        return null;
    }
    visitDirectiveProperty(ast, context) {
        ast.value.visit(this.collector);
        return null;
    }
    visitElementProperty(ast, context) {
        ast.value.visit(this.collector);
        return null;
    }
}
//# sourceMappingURL=data:application/json;base64,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