'use strict';var lang_1 = require('angular2/src/facade/lang');
var collection_1 = require('angular2/src/facade/collection');
var change_detection_util_1 = require('./change_detection_util');
var change_detector_ref_1 = require('./change_detector_ref');
var exceptions_1 = require('./exceptions');
var locals_1 = require('./parser/locals');
var constants_1 = require('./constants');
var profile_1 = require('../profile/profile');
var async_1 = require('angular2/src/facade/async');
var _scope_check = profile_1.wtfCreateScope("ChangeDetector#check(ascii id, bool throwOnChange)");
var _Context = (function () {
    function _Context(element, componentElement, context, locals, injector, expression) {
        this.element = element;
        this.componentElement = componentElement;
        this.context = context;
        this.locals = locals;
        this.injector = injector;
        this.expression = expression;
    }
    return _Context;
})();
var AbstractChangeDetector = (function () {
    function AbstractChangeDetector(id, numberOfPropertyProtoRecords, bindingTargets, directiveIndices, strategy) {
        this.id = id;
        this.numberOfPropertyProtoRecords = numberOfPropertyProtoRecords;
        this.bindingTargets = bindingTargets;
        this.directiveIndices = directiveIndices;
        this.strategy = strategy;
        this.contentChildren = [];
        this.viewChildren = [];
        // The names of the below fields must be kept in sync with codegen_name_util.ts or
        // change detection will fail.
        this.state = constants_1.ChangeDetectorState.NeverChecked;
        this.locals = null;
        this.mode = null;
        this.pipes = null;
        this.ref = new change_detector_ref_1.ChangeDetectorRef_(this);
    }
    AbstractChangeDetector.prototype.addContentChild = function (cd) {
        this.contentChildren.push(cd);
        cd.parent = this;
    };
    AbstractChangeDetector.prototype.removeContentChild = function (cd) { collection_1.ListWrapper.remove(this.contentChildren, cd); };
    AbstractChangeDetector.prototype.addViewChild = function (cd) {
        this.viewChildren.push(cd);
        cd.parent = this;
    };
    AbstractChangeDetector.prototype.removeViewChild = function (cd) { collection_1.ListWrapper.remove(this.viewChildren, cd); };
    AbstractChangeDetector.prototype.remove = function () { this.parent.removeContentChild(this); };
    AbstractChangeDetector.prototype.handleEvent = function (eventName, elIndex, event) {
        if (!this.hydrated()) {
            this.throwDehydratedError(this.id + " -> " + eventName);
        }
        try {
            var locals = new Map();
            locals.set('$event', event);
            var res = !this.handleEventInternal(eventName, elIndex, new locals_1.Locals(this.locals, locals));
            this.markPathToRootAsCheckOnce();
            return res;
        }
        catch (e) {
            var c = this.dispatcher.getDebugContext(null, elIndex, null);
            var context = lang_1.isPresent(c) ?
                new exceptions_1.EventEvaluationErrorContext(c.element, c.componentElement, c.context, c.locals, c.injector) :
                null;
            throw new exceptions_1.EventEvaluationError(eventName, e, e.stack, context);
        }
    };
    AbstractChangeDetector.prototype.handleEventInternal = function (eventName, elIndex, locals) { return false; };
    AbstractChangeDetector.prototype.detectChanges = function () { this.runDetectChanges(false); };
    AbstractChangeDetector.prototype.checkNoChanges = function () {
        if (lang_1.assertionsEnabled()) {
            this.runDetectChanges(true);
        }
    };
    AbstractChangeDetector.prototype.runDetectChanges = function (throwOnChange) {
        if (this.mode === constants_1.ChangeDetectionStrategy.Detached ||
            this.mode === constants_1.ChangeDetectionStrategy.Checked || this.state === constants_1.ChangeDetectorState.Errored)
            return;
        var s = _scope_check(this.id, throwOnChange);
        this.detectChangesInRecords(throwOnChange);
        this._detectChangesContentChildren(throwOnChange);
        if (!throwOnChange)
            this.afterContentLifecycleCallbacks();
        this._detectChangesInViewChildren(throwOnChange);
        if (!throwOnChange)
            this.afterViewLifecycleCallbacks();
        if (this.mode === constants_1.ChangeDetectionStrategy.CheckOnce)
            this.mode = constants_1.ChangeDetectionStrategy.Checked;
        this.state = constants_1.ChangeDetectorState.CheckedBefore;
        profile_1.wtfLeave(s);
    };
    // This method is not intended to be overridden. Subclasses should instead provide an
    // implementation of `detectChangesInRecordsInternal` which does the work of detecting changes
    // and which this method will call.
    // This method expects that `detectChangesInRecordsInternal` will set the property
    // `this.propertyBindingIndex` to the propertyBindingIndex of the first proto record. This is to
    // facilitate error reporting.
    AbstractChangeDetector.prototype.detectChangesInRecords = function (throwOnChange) {
        if (!this.hydrated()) {
            this.throwDehydratedError(this.id);
        }
        try {
            this.detectChangesInRecordsInternal(throwOnChange);
        }
        catch (e) {
            // throwOnChange errors aren't counted as fatal errors.
            if (!(e instanceof exceptions_1.ExpressionChangedAfterItHasBeenCheckedException)) {
                this.state = constants_1.ChangeDetectorState.Errored;
            }
            this._throwError(e, e.stack);
        }
    };
    // Subclasses should override this method to perform any work necessary to detect and report
    // changes. For example, changes should be reported via `ChangeDetectionUtil.addChange`, lifecycle
    // methods should be called, etc.
    // This implementation should also set `this.propertyBindingIndex` to the propertyBindingIndex of
    // the
    // first proto record to facilitate error reporting. See {@link #detectChangesInRecords}.
    AbstractChangeDetector.prototype.detectChangesInRecordsInternal = function (throwOnChange) { };
    // This method is not intended to be overridden. Subclasses should instead provide an
    // implementation of `hydrateDirectives`.
    AbstractChangeDetector.prototype.hydrate = function (context, locals, dispatcher, pipes) {
        this.dispatcher = dispatcher;
        this.mode = change_detection_util_1.ChangeDetectionUtil.changeDetectionMode(this.strategy);
        this.context = context;
        this.locals = locals;
        this.pipes = pipes;
        this.hydrateDirectives(dispatcher);
        this.state = constants_1.ChangeDetectorState.NeverChecked;
    };
    // Subclasses should override this method to hydrate any directives.
    AbstractChangeDetector.prototype.hydrateDirectives = function (dispatcher) { };
    // This method is not intended to be overridden. Subclasses should instead provide an
    // implementation of `dehydrateDirectives`.
    AbstractChangeDetector.prototype.dehydrate = function () {
        this.dehydrateDirectives(true);
        this._unsubscribeFromOutputs();
        this.dispatcher = null;
        this.context = null;
        this.locals = null;
        this.pipes = null;
    };
    // Subclasses should override this method to dehydrate any directives. This method should reverse
    // any work done in `hydrateDirectives`.
    AbstractChangeDetector.prototype.dehydrateDirectives = function (destroyPipes) { };
    AbstractChangeDetector.prototype.hydrated = function () { return lang_1.isPresent(this.context); };
    AbstractChangeDetector.prototype.destroyRecursive = function () {
        this.dispatcher.notifyOnDestroy();
        this.dehydrate();
        var children = this.contentChildren;
        for (var i = 0; i < children.length; i++) {
            children[i].destroyRecursive();
        }
        children = this.viewChildren;
        for (var i = 0; i < children.length; i++) {
            children[i].destroyRecursive();
        }
    };
    AbstractChangeDetector.prototype.afterContentLifecycleCallbacks = function () {
        this.dispatcher.notifyAfterContentChecked();
        this.afterContentLifecycleCallbacksInternal();
    };
    AbstractChangeDetector.prototype.afterContentLifecycleCallbacksInternal = function () { };
    AbstractChangeDetector.prototype.afterViewLifecycleCallbacks = function () {
        this.dispatcher.notifyAfterViewChecked();
        this.afterViewLifecycleCallbacksInternal();
    };
    AbstractChangeDetector.prototype.afterViewLifecycleCallbacksInternal = function () { };
    /** @internal */
    AbstractChangeDetector.prototype._detectChangesContentChildren = function (throwOnChange) {
        var c = this.contentChildren;
        for (var i = 0; i < c.length; ++i) {
            c[i].runDetectChanges(throwOnChange);
        }
    };
    /** @internal */
    AbstractChangeDetector.prototype._detectChangesInViewChildren = function (throwOnChange) {
        var c = this.viewChildren;
        for (var i = 0; i < c.length; ++i) {
            c[i].runDetectChanges(throwOnChange);
        }
    };
    AbstractChangeDetector.prototype.markAsCheckOnce = function () { this.mode = constants_1.ChangeDetectionStrategy.CheckOnce; };
    AbstractChangeDetector.prototype.markPathToRootAsCheckOnce = function () {
        var c = this;
        while (lang_1.isPresent(c) && c.mode !== constants_1.ChangeDetectionStrategy.Detached) {
            if (c.mode === constants_1.ChangeDetectionStrategy.Checked)
                c.mode = constants_1.ChangeDetectionStrategy.CheckOnce;
            c = c.parent;
        }
    };
    AbstractChangeDetector.prototype._unsubscribeFromOutputs = function () {
        if (lang_1.isPresent(this.outputSubscriptions)) {
            for (var i = 0; i < this.outputSubscriptions.length; ++i) {
                async_1.ObservableWrapper.dispose(this.outputSubscriptions[i]);
                this.outputSubscriptions[i] = null;
            }
        }
    };
    AbstractChangeDetector.prototype.getDirectiveFor = function (directives, index) {
        return directives.getDirectiveFor(this.directiveIndices[index]);
    };
    AbstractChangeDetector.prototype.getDetectorFor = function (directives, index) {
        return directives.getDetectorFor(this.directiveIndices[index]);
    };
    AbstractChangeDetector.prototype.notifyDispatcher = function (value) {
        this.dispatcher.notifyOnBinding(this._currentBinding(), value);
    };
    AbstractChangeDetector.prototype.logBindingUpdate = function (value) {
        this.dispatcher.logBindingUpdate(this._currentBinding(), value);
    };
    AbstractChangeDetector.prototype.addChange = function (changes, oldValue, newValue) {
        if (lang_1.isBlank(changes)) {
            changes = {};
        }
        changes[this._currentBinding().name] = change_detection_util_1.ChangeDetectionUtil.simpleChange(oldValue, newValue);
        return changes;
    };
    AbstractChangeDetector.prototype._throwError = function (exception, stack) {
        var error;
        try {
            var c = this.dispatcher.getDebugContext(null, this._currentBinding().elementIndex, null);
            var context = lang_1.isPresent(c) ? new _Context(c.element, c.componentElement, c.context, c.locals, c.injector, this._currentBinding().debug) :
                null;
            error = new exceptions_1.ChangeDetectionError(this._currentBinding().debug, exception, stack, context);
        }
        catch (e) {
            // if an error happens during getting the debug context, we throw a ChangeDetectionError
            // without the extra information.
            error = new exceptions_1.ChangeDetectionError(null, exception, stack, null);
        }
        throw error;
    };
    AbstractChangeDetector.prototype.throwOnChangeError = function (oldValue, newValue) {
        throw new exceptions_1.ExpressionChangedAfterItHasBeenCheckedException(this._currentBinding().debug, oldValue, newValue, null);
    };
    AbstractChangeDetector.prototype.throwDehydratedError = function (detail) { throw new exceptions_1.DehydratedException(detail); };
    AbstractChangeDetector.prototype._currentBinding = function () {
        return this.bindingTargets[this.propertyBindingIndex];
    };
    return AbstractChangeDetector;
})();
exports.AbstractChangeDetector = AbstractChangeDetector;
//# sourceMappingURL=data:application/json;base64,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